/*!
 * ForkAwesome to FontAwesome 7 JavaScript Shim
 * Version: 1.0.0
 * 
 * This JavaScript shim provides runtime compatibility for ForkAwesome 1.1.5 
 * when migrating to FontAwesome 7
 */

(function() {
  'use strict';

  // Icon mapping database - loaded from external JSON or embedded
  const iconMappings = {
    // Direct mappings (icon name changes)
    'home': 'house',
    'warning': 'triangle-exclamation',
    'close': 'xmark',
    'remove': 'xmark',
    'trash-o': 'trash-can',
    'file-text-o': 'file-lines',
    'gear': 'gear',
    'gears': 'gears',
    'exclamation-triangle': 'triangle-exclamation',
    'exclamation-circle': 'circle-exclamation',
    'check-circle': 'circle-check',
    'times-circle': 'circle-xmark',
    'chevron-circle-left': 'circle-chevron-left',
    'chevron-circle-right': 'circle-chevron-right',
    'chevron-circle-up': 'circle-chevron-up',
    'chevron-circle-down': 'circle-chevron-down',
    'arrow-circle-left': 'circle-arrow-left',
    'arrow-circle-right': 'circle-arrow-right',
    'arrow-circle-up': 'circle-arrow-up',
    'arrow-circle-down': 'circle-arrow-down',
    'mail-forward': 'share',
    'mail-reply': 'reply',
    'mail-reply-all': 'reply-all',
    'chain': 'link',
    'chain-broken': 'link-slash',
    'external-link': 'up-right-from-square',
    'level-up': 'turn-up',
    'level-down': 'turn-down',
    'pencil-square-o': 'pen-to-square',
    'ticket': 'ticket-simple',
    'diamond': 'gem',
    'bank': 'building-columns',
    'institution': 'building-columns',
    'university': 'building-columns',
    'mortar-board': 'graduation-cap',
    'graduation-cap': 'graduation-cap',
    'euro': 'euro-sign',
    'eur': 'euro-sign',
    'dollar': 'dollar-sign',
    'usd': 'dollar-sign',
    'rupee': 'indian-rupee-sign',
    'inr': 'indian-rupee-sign',
    'cny': 'yen-sign',
    'rmb': 'yen-sign',
    'yen': 'yen-sign',
    'jpy': 'yen-sign',
    'ruble': 'ruble-sign',
    'rouble': 'ruble-sign',
    'rub': 'ruble-sign',
    'won': 'won-sign',
    'krw': 'won-sign',
    'bitcoin': 'bitcoin',
    'btc': 'bitcoin',
    'youtube-play': 'youtube',
    'television': 'tv',
    'tv': 'tv',
    'calendar': 'calendar',
    'calendar-o': 'calendar',
    'arrows': 'arrows-up-down-left-right',
    'arrows-alt': 'maximize',
    'arrows-h': 'arrows-left-right',
    'arrows-v': 'arrows-up-down',
    'bar-chart': 'chart-column',
    'bar-chart-o': 'chart-bar',
    'line-chart': 'chart-line',
    'pie-chart': 'chart-pie',
    'battery': 'battery-full',
    'battery-4': 'battery-full',
    'battery-3': 'battery-three-quarters',
    'battery-2': 'battery-half',
    'battery-1': 'battery-quarter',
    'battery-0': 'battery-empty',
    'sign-in': 'right-to-bracket',
    'sign-out': 'right-from-bracket',
    'sign-in-alt': 'right-to-bracket',
    'sign-out-alt': 'right-from-bracket',
    'map-marker': 'location-dot',
    'map-marker-alt': 'location-dot',
    'refresh': 'rotate',
    'shield': 'shield',
    'shield-alt': 'shield-halved',
    'shopping-cart': 'cart-shopping',
    'shopping-bag': 'bag-shopping',
    'trash': 'trash',
    'angle-double-down': 'angles-down',
    'angle-double-left': 'angles-left',
    'angle-double-right': 'angles-right',
    'angle-double-up': 'angles-up',
    'long-arrow-down': 'arrow-down-long',
    'long-arrow-up': 'arrow-up-long',
    'long-arrow-left': 'arrow-left-long',
    'long-arrow-right': 'arrow-right-long',
    'magic': 'wand-magic-sparkles',
    'envelope': 'envelope',
    'envelope-o': 'envelope',
    'cloud-download': 'cloud-arrow-down',
    'cloud-upload': 'cloud-arrow-up',
    'reply': 'reply',
    'reply-all': 'reply-all',
    'forward': 'forward',
    'paper-plane': 'paper-plane',
    'paper-plane-o': 'paper-plane',
    'send': 'paper-plane',
    'send-o': 'paper-plane',
    'history': 'clock-rotate-left',
    'circle-thin': 'circle',
    'header': 'heading',
    'sliders': 'sliders',
    'list-ul': 'list-ul',
    'list-ol': 'list-ol',
    'th-large': 'table-cells-large',
    'th-list': 'table-list',
    'th': 'table-cells',
    'check': 'check',
    'times': 'xmark',
    'search-plus': 'magnifying-glass-plus',
    'search-minus': 'magnifying-glass-minus',
    'search': 'magnifying-glass',
    'power-off': 'power-off',
    'signal': 'signal',
    'cog': 'gear',
    'cogs': 'gears',
    'home': 'house',
    'clock-o': 'clock',
    'road': 'road',
    'download': 'download',
    'inbox': 'inbox',
    'repeat': 'repeat',
    'rotate': 'rotate',
    'retweet': 'retweet',
    'lock': 'lock',
    'unlock': 'unlock',
    'flag': 'flag',
    'flag-o': 'flag',
    'headphones': 'headphones',
    'volume-off': 'volume-xmark',
    'volume-down': 'volume-low',
    'volume-up': 'volume-high',
    'qrcode': 'qrcode',
    'barcode': 'barcode',
    'tag': 'tag',
    'tags': 'tags',
    'book': 'book',
    'bookmark': 'bookmark',
    'bookmark-o': 'bookmark',
    'print': 'print',
    'camera': 'camera',
    'font': 'font',
    'bold': 'bold',
    'italic': 'italic',
    'text-height': 'text-height',
    'text-width': 'text-width',
    'align-left': 'align-left',
    'align-center': 'align-center',
    'align-right': 'align-right',
    'align-justify': 'align-justify',
    'list': 'list',
    'dedent': 'outdent',
    'outdent': 'outdent',
    'indent': 'indent',
    'video': 'video',
    'image': 'image',
    'photo': 'image',
    'picture': 'image',
    'picture-o': 'image',
    'pencil': 'pencil',
    'map-marker': 'location-dot',
    'adjust': 'circle-half-stroke',
    'tint': 'droplet',
    'edit': 'pen-to-square',
    'pencil-square': 'pen-to-square',
    'share-square-o': 'share-from-square',
    'check-square-o': 'square-check',
    'arrows': 'arrows-up-down-left-right',
    'step-backward': 'backward-step',
    'fast-backward': 'backward-fast',
    'backward': 'backward',
    'play': 'play',
    'pause': 'pause',
    'stop': 'stop',
    'forward': 'forward',
    'fast-forward': 'forward-fast',
    'step-forward': 'forward-step',
    'eject': 'eject',
    'chevron-left': 'chevron-left',
    'chevron-right': 'chevron-right',
    'plus-circle': 'circle-plus',
    'minus-circle': 'circle-minus',
    'times-circle-o': 'circle-xmark',
    'check-circle-o': 'circle-check',
    'question-circle': 'circle-question',
    'question-circle-o': 'circle-question',
    'info-circle': 'circle-info',
    'crosshairs': 'crosshairs',
    'ban': 'ban',
    'arrow-left': 'arrow-left',
    'arrow-right': 'arrow-right',
    'arrow-up': 'arrow-up',
    'arrow-down': 'arrow-down',
    'share': 'share',
    'expand': 'expand',
    'compress': 'compress',
    'plus': 'plus',
    'minus': 'minus',
    'asterisk': 'asterisk',
    'exclamation': 'exclamation',
    'gift': 'gift',
    'leaf': 'leaf',
    'fire': 'fire',
    'eye': 'eye',
    'eye-slash': 'eye-slash',
    'exclamation-triangle': 'triangle-exclamation',
    'plane': 'plane',
    'random': 'shuffle',
    'magnet': 'magnet',
    'chevron-up': 'chevron-up',
    'chevron-down': 'chevron-down',
    'retweet': 'retweet',
    'folder': 'folder',
    'folder-open': 'folder-open',
    'folder-o': 'folder',
    'folder-open-o': 'folder-open',
    'bar-chart': 'chart-column',
    'bar-chart-o': 'chart-bar',
    'caret-down': 'caret-down',
    'caret-up': 'caret-up',
    'caret-left': 'caret-left',
    'caret-right': 'caret-right',
    'sort': 'sort',
    'sort-down': 'sort-down',
    'sort-desc': 'sort-down',
    'sort-up': 'sort-up',
    'sort-asc': 'sort-up',
    'envelope': 'envelope',
    'linkedin-in': 'linkedin-in',
    'rotate-left': 'rotate-left',
    'undo': 'rotate-left',
    'gavel': 'gavel',
    'legal': 'gavel',
    'tachometer': 'gauge-high',
    'dashboard': 'gauge-high',
    'comment-o': 'comment',
    'comments-o': 'comments',
    'flash': 'bolt',
    'bolt': 'bolt',
    'sitemap': 'sitemap',
    'umbrella': 'umbrella',
    'lightbulb': 'lightbulb',
    'lightbulb-o': 'lightbulb',
    'exchange': 'arrow-right-arrow-left',
    'cloud-download-alt': 'cloud-arrow-down',
    'cloud-upload-alt': 'cloud-arrow-up',
    'user-md': 'user-doctor',
    'stethoscope': 'stethoscope',
    'suitcase': 'suitcase',
    'bell-o': 'bell',
    'coffee': 'mug-hot',
    'cutlery': 'utensils',
    'file-text-o': 'file-lines',
    'building-o': 'building',
    'hospital-o': 'hospital',
    'ambulance': 'truck-medical',
    'medkit': 'suitcase-medical',
    'fighter-jet': 'jet-fighter',
    'beer': 'beer-mug-empty',
    'h-square': 'square-h',
    'plus-square-o': 'square-plus',
    'angle-double-left': 'angles-left',
    'angle-double-right': 'angles-right',
    'angle-double-up': 'angles-up',
    'angle-double-down': 'angles-down',
    'angle-left': 'angle-left',
    'angle-right': 'angle-right',
    'angle-up': 'angle-up',
    'angle-down': 'angle-down',
    'desktop': 'desktop',
    'laptop': 'laptop',
    'tablet': 'tablet-screen-button',
    'mobile': 'mobile-screen-button',
    'mobile-phone': 'mobile-screen-button',
    'circle-o': 'circle',
    'quote-left': 'quote-left',
    'quote-right': 'quote-right',
    'spinner': 'spinner',
    'circle': 'circle',
    'mail-reply': 'reply',
    'github-alt': 'github-alt',
    'folder-o': 'folder',
    'folder-open-o': 'folder-open',
    'smile-o': 'face-smile',
    'frown-o': 'face-frown',
    'meh-o': 'face-meh',
    'gamepad': 'gamepad',
    'keyboard': 'keyboard',
    'keyboard-o': 'keyboard',
    'flag-checkered': 'flag-checkered',
    'terminal': 'terminal',
    'code': 'code',
    'mail-reply-all': 'reply-all',
    'star-half-o': 'star-half',
    'location-arrow': 'location-arrow',
    'crop': 'crop-simple',
    'code-fork': 'code-branch',
    'chain-broken': 'link-slash',
    'unlink': 'link-slash',
    'question': 'question',
    'info': 'info',
    'exclamation': 'exclamation',
    'superscript': 'superscript',
    'subscript': 'subscript',
    'eraser': 'eraser',
    'puzzle-piece': 'puzzle-piece',
    'microphone': 'microphone',
    'microphone-slash': 'microphone-slash',
    'shield': 'shield',
    'calendar-o': 'calendar',
    'fire-extinguisher': 'fire-extinguisher',
    'rocket': 'rocket',
    'maxcdn': 'maxcdn',
    'chevron-circle-left': 'circle-chevron-left',
    'chevron-circle-right': 'circle-chevron-right',
    'chevron-circle-up': 'circle-chevron-up',
    'chevron-circle-down': 'circle-chevron-down',
    'html5': 'html5',
    'css3': 'css3',
    'anchor': 'anchor',
    'unlock-alt': 'unlock-keyhole',
    'bullseye': 'bullseye',
    'ellipsis-h': 'ellipsis',
    'ellipsis-v': 'ellipsis-vertical',
    'rss-square': 'square-rss',
    'play-circle-o': 'circle-play',
    'minus-square-o': 'square-minus',
    'check-square': 'square-check',
    'pen-square': 'pen-to-square',
    'share-square': 'share-from-square',
    'compass': 'compass',
    'caret-square-o-down': 'square-caret-down',
    'toggle-down': 'square-caret-down',
    'caret-square-o-up': 'square-caret-up',
    'toggle-up': 'square-caret-up',
    'caret-square-o-right': 'square-caret-right',
    'toggle-right': 'square-caret-right',
    'eur': 'euro-sign',
    'euro': 'euro-sign',
    'gbp': 'sterling-sign',
    'usd': 'dollar-sign',
    'dollar': 'dollar-sign',
    'inr': 'indian-rupee-sign',
    'rupee': 'indian-rupee-sign',
    'jpy': 'yen-sign',
    'cny': 'yen-sign',
    'rmb': 'yen-sign',
    'yen': 'yen-sign',
    'rub': 'ruble-sign',
    'ruble': 'ruble-sign',
    'rouble': 'ruble-sign',
    'krw': 'won-sign',
    'won': 'won-sign',
    'bitcoin': 'bitcoin',
    'btc': 'bitcoin',
    'file': 'file',
    'file-o': 'file',
    'file-text': 'file-lines',
    'sort-alpha-asc': 'arrow-down-a-z',
    'sort-alpha-desc': 'arrow-down-z-a',
    'sort-amount-asc': 'arrow-down-short-wide',
    'sort-amount-desc': 'arrow-down-wide-short',
    'sort-numeric-asc': 'arrow-down-1-9',
    'sort-numeric-desc': 'arrow-down-9-1',
    'thumbs-up': 'thumbs-up',
    'thumbs-down': 'thumbs-down',
    'thumbs-o-up': 'thumbs-up',
    'thumbs-o-down': 'thumbs-down',
    'heart-o': 'heart',
    'lemon-o': 'lemon',
    'phone-square': 'square-phone',
    'twitter-square': 'square-x-twitter',
    'facebook-square': 'square-facebook',
    'github-square': 'square-github',
    'credit-card': 'credit-card',
    'credit-card-o': 'credit-card',
    'rss': 'rss',
    'hdd-o': 'hard-drive',
    'bullhorn': 'bullhorn',
    'bell': 'bell',
    'certificate': 'certificate',
    'hand-o-right': 'hand-point-right',
    'hand-o-left': 'hand-point-left',
    'hand-o-up': 'hand-point-up',
    'hand-o-down': 'hand-point-down',
    'arrow-circle-left': 'circle-arrow-left',
    'arrow-circle-right': 'circle-arrow-right',
    'arrow-circle-up': 'circle-arrow-up',
    'arrow-circle-down': 'circle-arrow-down',
    'globe': 'globe',
    'wrench': 'wrench',
    'tasks': 'list-check',
    'filter': 'filter',
    'briefcase': 'briefcase',
    'arrows-alt': 'maximize',
    'group': 'users',
    'users': 'users',
    'link': 'link',
    'cloud': 'cloud',
    'flask': 'flask',
    'cut': 'scissors',
    'scissors': 'scissors',
    'copy': 'copy',
    'files-o': 'copy',
    'paperclip': 'paperclip',
    'floppy-o': 'floppy-disk',
    'save': 'floppy-disk',
    'square': 'square',
    'square-o': 'square',
    'navicon': 'bars',
    'reorder': 'bars',
    'bars': 'bars',
    'list-ul': 'list-ul',
    'list-ol': 'list-ol',
    'strikethrough': 'strikethrough',
    'underline': 'underline',
    'table': 'table',
    'magic': 'wand-magic-sparkles',
    'truck': 'truck',
    'pinterest-square': 'square-pinterest',
    'google-plus-square': 'square-google-plus',
    'google-plus': 'google-plus',
    'money': 'money-bill',
    'caret-down': 'caret-down',
    'caret-up': 'caret-up',
    'caret-left': 'caret-left',
    'caret-right': 'caret-right',
    'columns': 'columns',
    'sort': 'sort',
    'sort-down': 'sort-down',
    'sort-desc': 'sort-down',
    'sort-up': 'sort-up',
    'sort-asc': 'sort-up',
    'envelope': 'envelope',
    'undo': 'rotate-left',
    'gavel': 'gavel',
    'legal': 'gavel',
    'tachometer': 'gauge-high',
    'dashboard': 'gauge-high',
    'comment-o': 'comment',
    'comments-o': 'comments',
    'flash': 'bolt',
    'bolt': 'bolt',
    'sitemap': 'sitemap',
    'umbrella': 'umbrella',
    'paste': 'clipboard',
    'clipboard': 'clipboard',
    'lightbulb-o': 'lightbulb',
    'exchange': 'arrow-right-arrow-left',
    'cloud-download': 'cloud-arrow-down',
    'cloud-upload': 'cloud-arrow-up',
    'user-md': 'user-doctor',
    'stethoscope': 'stethoscope',
    'suitcase': 'suitcase',
    'bell-o': 'bell',
    'coffee': 'mug-hot',
    'cutlery': 'utensils',
    'file-text-o': 'file-lines',
    'building-o': 'building',
    'hospital-o': 'hospital',
    'ambulance': 'truck-medical',
    'medkit': 'suitcase-medical',
    'fighter-jet': 'jet-fighter',
    'beer': 'beer-mug-empty',
    'h-square': 'square-h',
    'plus-square': 'square-plus',
    'angle-double-left': 'angles-left',
    'angle-double-right': 'angles-right',
    'angle-double-up': 'angles-up',
    'angle-double-down': 'angles-down',
    'angle-left': 'angle-left',
    'angle-right': 'angle-right',
    'angle-up': 'angle-up',
    'angle-down': 'angle-down',
    'desktop': 'desktop',
    'laptop': 'laptop',
    'tablet': 'tablet-screen-button',
    'mobile': 'mobile-screen-button',
    'mobile-phone': 'mobile-screen-button',
    'circle-o': 'circle',
    'quote-left': 'quote-left',
    'quote-right': 'quote-right',
    'spinner': 'spinner',
    'circle': 'circle',
    'smile-o': 'face-smile',
    'frown-o': 'face-frown',
    'meh-o': 'face-meh',
    'gamepad': 'gamepad',
    'keyboard-o': 'keyboard',
    'flag-checkered': 'flag-checkered',
    'terminal': 'terminal',
    'code': 'code',
    'star-half': 'star-half',
    'star-half-empty': 'star-half',
    'star-half-o': 'star-half',
    'star-half-full': 'star-half',
    'location-arrow': 'location-arrow',
    'crop': 'crop-simple',
    'code-fork': 'code-branch',
    'chain-broken': 'link-slash',
    'unlink': 'link-slash',
    'question': 'question',
    'info': 'info',
    'exclamation': 'exclamation',
    'superscript': 'superscript',
    'subscript': 'subscript',
    'eraser': 'eraser',
    'puzzle-piece': 'puzzle-piece',
    'microphone': 'microphone',
    'microphone-slash': 'microphone-slash',
    'shield': 'shield',
    'calendar-o': 'calendar',
    'fire-extinguisher': 'fire-extinguisher',
    'rocket': 'rocket',
    'maxcdn': 'maxcdn',
    'chevron-circle-left': 'circle-chevron-left',
    'chevron-circle-right': 'circle-chevron-right',
    'chevron-circle-up': 'circle-chevron-up',
    'chevron-circle-down': 'circle-chevron-down',
    'html5': 'html5',
    'css3': 'css3',
    'anchor': 'anchor',
    'unlock-alt': 'unlock-keyhole',
    'bullseye': 'bullseye',
    'ellipsis-h': 'ellipsis',
    'ellipsis-v': 'ellipsis-vertical',
    'rss-square': 'square-rss',
    'play-circle': 'circle-play',
    'minus-square': 'square-minus',
    'check-square': 'square-check',
    'pen-square': 'pen-to-square',
    'share-square': 'share-from-square',
    'cc': 'closed-captioning',
    'dedent': 'outdent',
    'outdent': 'outdent',
    'indent': 'indent',
    'video-camera': 'video',
    'picture-o': 'image',
    'pencil': 'pencil',
    'map-marker': 'location-dot',
    'adjust': 'circle-half-stroke',
    'tint': 'droplet',
    'pencil-square': 'pen-to-square',
    'share-square-o': 'share-from-square',
    'check-square-o': 'square-check',
    'arrows': 'arrows-up-down-left-right',
    'step-backward': 'backward-step',
    'fast-backward': 'backward-fast',
    'backward': 'backward',
    'play': 'play',
    'pause': 'pause',
    'stop': 'stop',
    'forward': 'forward',
    'fast-forward': 'forward-fast',
    'step-forward': 'forward-step',
    'eject': 'eject',
    'chevron-left': 'chevron-left',
    'chevron-right': 'chevron-right',
    'plus-circle': 'circle-plus',
    'minus-circle': 'circle-minus',
    'times-circle': 'circle-xmark',
    'check-circle': 'circle-check',
    'question-circle': 'circle-question',
    'info-circle': 'circle-info',
    'screenshot': 'crosshairs',
    'remove-circle': 'circle-xmark',
    'ok-circle': 'circle-check',
    'ban-circle': 'ban',
    'mail-forward': 'share',
    'resize-full': 'maximize',
    'resize-small': 'minimize',
    'plus': 'plus',
    'minus': 'minus',
    'asterisk': 'asterisk',
    'exclamation-sign': 'exclamation',
    'gift': 'gift',
    'leaf': 'leaf',
    'fire': 'fire',
    'eye-open': 'eye',
    'eye-close': 'eye-slash',
    'warning-sign': 'triangle-exclamation',
    'plane': 'plane',
    'random': 'shuffle',
    'comment': 'comment',
    'chevron-up': 'chevron-up',
    'chevron-down': 'chevron-down',
    'shopping-cart': 'cart-shopping',
    'bar-chart': 'chart-column',
    'bar-chart-o': 'chart-bar',
    'facebook-official': 'facebook',
    'pinterest-p': 'pinterest-p',
    'whatsapp': 'whatsapp',
    'server': 'server',
    'user-plus': 'user-plus',
    'user-times': 'user-xmark',
    'bed': 'bed',
    'train': 'train',
    'subway': 'train-subway',
    'battery-full': 'battery-full',
    'battery-three-quarters': 'battery-three-quarters',
    'battery-half': 'battery-half',
    'battery-quarter': 'battery-quarter',
    'battery-empty': 'battery-empty',
    'mouse-pointer': 'arrow-pointer',
    'i-cursor': 'i-cursor',
    'object-group': 'object-group',
    'object-ungroup': 'object-ungroup',
    'sticky-note': 'note-sticky',
    'sticky-note-o': 'note-sticky',
    'clone': 'clone',
    'hourglass-o': 'hourglass',
    'hourglass-start': 'hourglass-start',
    'hourglass-1': 'hourglass-start',
    'hourglass-half': 'hourglass-half',
    'hourglass-2': 'hourglass-half',
    'hourglass-end': 'hourglass-end',
    'hourglass-3': 'hourglass-end',
    'hand-rock-o': 'hand-back-fist',
    'hand-grab-o': 'hand',
    'hand-stop-o': 'hand',
    'hand-paper-o': 'hand',
    'hand-scissors-o': 'hand-scissors',
    'hand-lizard-o': 'hand-lizard',
    'hand-spock-o': 'hand-spock',
    'hand-pointer-o': 'hand-pointer',
    'hand-peace-o': 'hand-peace',
    'registered': 'registered',
    'creative-commons': 'creative-commons',
    'television': 'tv',
    'contao': 'contao',
    'paypal': 'paypal',
    'industry': 'industry',
    'map-pin': 'map-pin',
    'map-signs': 'signs-post',
    'map-o': 'map',
    'map': 'map',
    'commenting': 'comment-dots',
    'commenting-o': 'comment-dots',
    'houzz': 'houzz',
    'vimeo': 'vimeo-v',
    'black-tie': 'black-tie',
    'fonticons': 'fonticons',
    'reddit-alien': 'reddit-alien',
    'edge': 'edge',
    'codiepie': 'codiepie',
    'modx': 'modx',
    'fort-awesome': 'fort-awesome',
    'usb': 'usb',
    'product-hunt': 'product-hunt',
    'mixcloud': 'mixcloud',
    'scribd': 'scribd',
    'pause-circle': 'circle-pause',
    'pause-circle-o': 'circle-pause',
    'stop-circle': 'circle-stop',
    'stop-circle-o': 'circle-stop',
    'bluetooth': 'bluetooth',
    'bluetooth-b': 'bluetooth-b',
    'gitlab': 'gitlab',
    'wpbeginner': 'wpbeginner',
    'wpforms': 'wpforms',
    'envira': 'envira',
    'universal-access': 'universal-access',
    'wheelchair-alt': 'accessible-icon',
    'question-circle': 'circle-question',
    'blind': 'person-walking-with-cane',
    'audio-description': 'audio-description',
    'volume-control-phone': 'phone-volume',
    'phone-volume': 'phone-volume',
    'braille': 'braille',
    'assistive-listening-systems': 'assistive-listening-systems',
    'american-sign-language-interpreting': 'hands-asl-interpreting',
    'asl-interpreting': 'hands-asl-interpreting',
    'deaf': 'ear-deaf',
    'deafness': 'ear-deaf',
    'hard-of-hearing': 'ear-deaf',
    'glide': 'glide',
    'glide-g': 'glide-g',
    'sign-language': 'hands',
    'signing': 'hands',
    'viadeo': 'viadeo',
    'viadeo-square': 'square-viadeo',
    'snapchat': 'snapchat',
    'snapchat-ghost': 'snapchat',
    'snapchat-square': 'square-snapchat',
    'pied-piper': 'pied-piper',
    'first-order': 'first-order',
    'yoast': 'yoast',
    'themeisle': 'themeisle',
    'google-plus-official': 'google-plus',
    'google-plus-circle': 'google-plus',
    'font-awesome': 'font-awesome',
    'fa': 'font-awesome',
    'shower': 'shower',
    'bath': 'bath',
    'bathtub': 'bath',
    's15': 'bath',
    'bandcamp': 'bandcamp',
    'grav': 'grav',
    'etsy': 'etsy',
    'imdb': 'imdb',
    'ravelry': 'ravelry',
    'eercast': 'sellcast',
    'snowflake-o': 'snowflake',
    'superpowers': 'superpowers',
    'wpexplorer': 'wpexplorer',
    'meetup': 'meetup',
    'linode': 'linode',
    'angellist': 'angellist',
    'bitbucket': 'bitbucket',
    'drupal': 'drupal',
    'joomla': 'joomla',
    'behance': 'behance',
    'behance-square': 'square-behance',
    'steam': 'steam',
    'steam-square': 'square-steam',
    'spotify': 'spotify',
    'deviantart': 'deviantart',
    'soundcloud': 'soundcloud',
    'vine': 'vine',
    'codepen': 'codepen',
    'jsfiddle': 'jsfiddle',
    'rebel': 'rebel',
    'ra': 'rebel',
    'resistance': 'rebel',
    'empire': 'empire',
    'ge': 'empire',
    'git-square': 'square-git',
    'git': 'git',
    'hacker-news': 'hacker-news',
    'yc-square': 'hacker-news',
    'y-combinator-square': 'hacker-news',
    'tencent-weibo': 'tencent-weibo',
    'qq': 'qq',
    'weixin': 'weixin',
    'wechat': 'weixin',
    'slideshare': 'slideshare',
    'twitch': 'twitch',
    'yelp': 'yelp',
    'paypal': 'paypal',
    'google-wallet': 'google-wallet',
    'cc-visa': 'cc-visa',
    'cc-mastercard': 'cc-mastercard',
    'cc-discover': 'cc-discover',
    'cc-amex': 'cc-amex',
    'cc-paypal': 'cc-paypal',
    'cc-stripe': 'cc-stripe',
    'bell-slash': 'bell-slash',
    'bell-slash-o': 'bell-slash',
    'meanpath': 'font-awesome',
    'buysellads': 'buysellads',
    'connectdevelop': 'connectdevelop',
    'dashcube': 'dashcube',
    'forumbee': 'forumbee',
    'leanpub': 'leanpub',
    'sellsy': 'sellsy',
    'shirtsinbulk': 'shirtsinbulk',
    'simplybuilt': 'simplybuilt',
    'skyatlas': 'skyatlas',
    'pinterest-p': 'pinterest-p',
    'viacoin': 'viacoin',
    'medium': 'medium',
    'y-combinator': 'y-combinator',
    'yc': 'y-combinator',
    'optin-monster': 'optin-monster',
    'opencart': 'opencart',
    'expeditedssl': 'expeditedssl',
    'cc-jcb': 'cc-jcb',
    'cc-diners-club': 'cc-diners-club',
    'creative-commons': 'creative-commons',
    'gg': 'gg',
    'gg-circle': 'gg-circle',
    'odnoklassniki': 'odnoklassniki',
    'odnoklassniki-square': 'square-odnoklassniki',
    'get-pocket': 'get-pocket',
    'wikipedia-w': 'wikipedia-w',
    'safari': 'safari',
    'chrome': 'chrome',
    'firefox': 'firefox',
    'opera': 'opera',
    'internet-explorer': 'internet-explorer',
    'amazon': 'amazon',
    'reddit': 'reddit',
    'reddit-square': 'square-reddit',
    'stumbleupon-circle': 'stumbleupon-circle',
    'stumbleupon': 'stumbleupon',
    'delicious': 'delicious',
    'digg': 'digg',
    'drupal': 'drupal',
    'joomla': 'joomla',
    'behance': 'behance',
    'behance-square': 'square-behance',
    'steam': 'steam',
    'steam-square': 'square-steam',
    'spotify': 'spotify',
    'deviantart': 'deviantart',
    'soundcloud': 'soundcloud',
    'vine': 'vine',
    'codepen': 'codepen',
    'jsfiddle': 'jsfiddle',
    'rebel': 'rebel',
    'empire': 'empire',
    'git-square': 'square-git',
    'git': 'git',
    'hacker-news': 'hacker-news',
    'tencent-weibo': 'tencent-weibo',
    'qq': 'qq',
    'weixin': 'weixin',
    'slideshare': 'slideshare',
    'twitch': 'twitch',
    'yelp': 'yelp',
    'lastfm': 'lastfm',
    'lastfm-square': 'square-lastfm',
    'ioxhost': 'ioxhost',
    'angellist': 'angellist',
    'meanpath': 'font-awesome',
    'pagelines': 'pagelines',
    'stack-exchange': 'stack-exchange',
    'stack-overflow': 'stack-overflow',
    'pinterest': 'pinterest',
    'pinterest-square': 'square-pinterest',
    'maxcdn': 'maxcdn',
    'adn': 'adn',
    'behance': 'behance',
    'behance-square': 'square-behance',
    'bitbucket': 'bitbucket',
    'bitbucket-square': 'bitbucket',
    'tumblr': 'tumblr',
    'tumblr-square': 'square-tumblr',
    'apple': 'apple',
    'windows': 'windows',
    'android': 'android',
    'linux': 'linux',
    'dribbble': 'dribbble',
    'skype': 'skype',
    'foursquare': 'foursquare',
    'trello': 'trello',
    'gratipay': 'gratipay',
    'gittip': 'gratipay',
    'star': 'star',
    'star-o': 'star',
    'sun-o': 'sun',
    'moon-o': 'moon',
    'vk': 'vk',
    'weibo': 'weibo',
    'renren': 'renren',
    'pagelines': 'pagelines',
    'stack-exchange': 'stack-exchange',
    'arrow-circle-o-right': 'circle-right',
    'arrow-circle-o-left': 'circle-left',
    'arrow-circle-o-up': 'circle-up',
    'arrow-circle-o-down': 'circle-down',
    'caret-square-o-left': 'square-caret-left',
    'toggle-left': 'square-caret-left',
    'dot-circle-o': 'circle-dot',
    'vimeo-square': 'square-vimeo',
    'try': 'turkish-lira-sign',
    'turkish-lira': 'turkish-lira-sign',
    'slack': 'slack',
    'wordpress': 'wordpress',
    'openid': 'openid',
    'yahoo': 'yahoo',
    'google': 'google',
    'reddit': 'reddit',
    'reddit-square': 'square-reddit',
    'stumbleupon-circle': 'stumbleupon-circle',
    'stumbleupon': 'stumbleupon',
    'delicious': 'delicious',
    'digg': 'digg',
    'pied-piper-pp': 'pied-piper-pp',
    'pied-piper-alt': 'pied-piper-alt',
    'drupal': 'drupal',
    'joomla': 'joomla',
    'fax': 'fax',
    'child': 'child',
    'paw': 'paw',
    'cube': 'cube',
    'cubes': 'cubes',
    'recycle': 'recycle',
    'car': 'car',
    'automobile': 'car',
    'cab': 'taxi',
    'taxi': 'taxi',
    'tree': 'tree',
    'database': 'database',
    'file-pdf-o': 'file-pdf',
    'file-word-o': 'file-word',
    'file-excel-o': 'file-excel',
    'file-powerpoint-o': 'file-powerpoint',
    'file-image-o': 'file-image',
    'file-photo-o': 'file-image',
    'file-picture-o': 'file-image',
    'file-archive-o': 'file-zipper',
    'file-zip-o': 'file-zipper',
    'file-audio-o': 'file-audio',
    'file-sound-o': 'file-audio',
    'file-video-o': 'file-video',
    'file-movie-o': 'file-video',
    'file-code-o': 'file-code',
    'life-ring': 'life-ring',
    'life-bouy': 'life-ring',
    'life-buoy': 'life-ring',
    'life-saver': 'life-ring',
    'support': 'life-ring',
    'circle-o-notch': 'circle-notch',
    'rebel': 'rebel',
    'ra': 'rebel',
    'resistance': 'rebel',
    'empire': 'empire',
    'ge': 'empire',
    'git-square': 'square-git',
    'git': 'git',
    'hacker-news': 'hacker-news',
    'yc-square': 'hacker-news',
    'y-combinator-square': 'hacker-news',
    'tencent-weibo': 'tencent-weibo',
    'qq': 'qq',
    'weixin': 'weixin',
    'wechat': 'weixin',
    'paper-plane': 'paper-plane',
    'paper-plane-o': 'paper-plane',
    'send': 'paper-plane',
    'send-o': 'paper-plane',
    'circle-thin': 'circle',
    'futbol-o': 'futbol',
    'soccer-ball-o': 'futbol',
    'tty': 'tty',
    'binoculars': 'binoculars',
    'plug': 'plug',
    'newspaper-o': 'newspaper',
    'wifi': 'wifi',
    'calculator': 'calculator',
    'cc': 'closed-captioning',
    'ils': 'shekel-sign',
    'shekel': 'shekel-sign',
    'sheqel': 'shekel-sign',
    'transgender': 'mars-and-venus',
    'intersex': 'mars-and-venus',
    'transgender-alt': 'transgender',
    'venus-double': 'venus-double',
    'mars-double': 'mars-double',
    'venus-mars': 'venus-mars',
    'mars-stroke': 'mars-stroke',
    'mars-stroke-v': 'mars-stroke-up',
    'mars-stroke-h': 'mars-stroke-right',
    'neuter': 'neuter',
    'genderless': 'genderless',
    'user-plus': 'user-plus',
    'user-times': 'user-xmark',
    'user-circle': 'circle-user',
    'user-circle-o': 'circle-user',
    'bed': 'bed',
    'vcard': 'address-card',
    'vcard-o': 'address-card',
    'facebook-official': 'facebook',
    'pinterest-p': 'pinterest-p',
    'whatsapp': 'whatsapp',
    'server': 'server',
    'balance-scale': 'scale-balanced',
    'balance-scale-left': 'scale-unbalanced',
    'balance-scale-right': 'scale-unbalanced-flip',
    'hourglass': 'hourglass',
    'hourglass-o': 'hourglass',
    'hourglass-1': 'hourglass-start',
    'hourglass-start': 'hourglass-start',
    'hourglass-2': 'hourglass-half',
    'hourglass-half': 'hourglass-half',
    'hourglass-3': 'hourglass-end',
    'hourglass-end': 'hourglass-end',
    'hand-grab-o': 'hand',
    'hand-rock-o': 'hand-back-fist',
    'hand-paper-o': 'hand',
    'hand-stop-o': 'hand',
    'hand-scissors-o': 'hand-scissors',
    'hand-lizard-o': 'hand-lizard',
    'hand-spock-o': 'hand-spock',
    'hand-pointer-o': 'hand-pointer',
    'hand-peace-o': 'hand-peace',
    '500px': '500px',
    'adn': 'adn',
    'bitbucket': 'bitbucket',
    'bitbucket-square': 'bitbucket',
    'tumblr': 'tumblr',
    'tumblr-square': 'square-tumblr',
    'apple': 'apple',
    'windows': 'windows',
    'android': 'android',
    'linux': 'linux',
    'dribbble': 'dribbble',
    'skype': 'skype',
    'foursquare': 'foursquare',
    'trello': 'trello',
    'female': 'person-dress',
    'male': 'person',
    'gratipay': 'gratipay',
    'gittip': 'gratipay',
    'sun-o': 'sun',
    'moon-o': 'moon',
    'vk': 'vk',
    'weibo': 'weibo',
    'renren': 'renren',
    'pagelines': 'pagelines',
    'stack-exchange': 'stack-exchange',
    'arrow-circle-o-right': 'circle-right',
    'arrow-circle-o-left': 'circle-left',
    'caret-square-o-left': 'square-caret-left',
    'toggle-left': 'square-caret-left',
    'dot-circle-o': 'circle-dot',
    'vimeo-square': 'square-vimeo',
    'try': 'turkish-lira-sign',
    'turkish-lira': 'turkish-lira-sign',
    'plus-square-o': 'square-plus',
  };

  // Outline icons (-o suffix) mappings to regular style
  const outlineIcons = {
    'address-book-o': 'address-book',
    'address-card-o': 'address-card',
    'arrow-circle-o-down': 'circle-down',
    'arrow-circle-o-left': 'circle-left',
    'arrow-circle-o-right': 'circle-right',
    'arrow-circle-o-up': 'circle-up',
    'bar-chart-o': 'chart-bar',
    'bell-o': 'bell',
    'bell-slash-o': 'bell-slash',
    'bookmark-o': 'bookmark',
    'building-o': 'building',
    'calendar-check-o': 'calendar-check',
    'calendar-minus-o': 'calendar-minus',
    'calendar-o': 'calendar',
    'calendar-plus-o': 'calendar-plus',
    'calendar-times-o': 'calendar-xmark',
    'caret-square-o-down': 'square-caret-down',
    'caret-square-o-left': 'square-caret-left',
    'caret-square-o-right': 'square-caret-right',
    'caret-square-o-up': 'square-caret-up',
    'cc-o': 'closed-captioning',
    'check-circle-o': 'circle-check',
    'check-square-o': 'square-check',
    'circle-o': 'circle',
    'clock-o': 'clock',
    'clone-o': 'clone',
    'comment-o': 'comment',
    'commenting-o': 'comment-dots',
    'comments-o': 'comments',
    'copy-o': 'copy',
    'copyright-o': 'copyright',
    'credit-card-o': 'credit-card',
    'dot-circle-o': 'circle-dot',
    'envelope-o': 'envelope',
    'envelope-open-o': 'envelope-open',
    'eye-o': 'eye',
    'file-archive-o': 'file-zipper',
    'file-audio-o': 'file-audio',
    'file-code-o': 'file-code',
    'file-excel-o': 'file-excel',
    'file-image-o': 'file-image',
    'file-o': 'file',
    'file-pdf-o': 'file-pdf',
    'file-photo-o': 'file-image',
    'file-powerpoint-o': 'file-powerpoint',
    'file-text-o': 'file-lines',
    'file-video-o': 'file-video',
    'file-word-o': 'file-word',
    'files-o': 'copy',
    'flag-o': 'flag',
    'floppy-o': 'floppy-disk',
    'folder-o': 'folder',
    'folder-open-o': 'folder-open',
    'frown-o': 'face-frown',
    'futbol-o': 'futbol',
    'gem-o': 'gem',
    'hand-lizard-o': 'hand-lizard',
    'hand-o-down': 'hand-point-down',
    'hand-o-left': 'hand-point-left',
    'hand-o-right': 'hand-point-right',
    'hand-o-up': 'hand-point-up',
    'hand-paper-o': 'hand',
    'hand-peace-o': 'hand-peace',
    'hand-pointer-o': 'hand-pointer',
    'hand-rock-o': 'hand-back-fist',
    'hand-scissors-o': 'hand-scissors',
    'hand-spock-o': 'hand-spock',
    'handshake-o': 'handshake',
    'hdd-o': 'hard-drive',
    'heart-o': 'heart',
    'hospital-o': 'hospital',
    'hourglass-o': 'hourglass',
    'id-badge-o': 'id-badge',
    'id-card-o': 'id-card',
    'image-o': 'image',
    'keyboard-o': 'keyboard',
    'lemon-o': 'lemon',
    'life-ring-o': 'life-ring',
    'lightbulb-o': 'lightbulb',
    'map-o': 'map',
    'meh-o': 'face-meh',
    'minus-square-o': 'square-minus',
    'money-o': 'money-bill',
    'moon-o': 'moon',
    'newspaper-o': 'newspaper',
    'object-group-o': 'object-group',
    'object-ungroup-o': 'object-ungroup',
    'paper-plane-o': 'paper-plane',
    'pause-circle-o': 'circle-pause',
    'pencil-square-o': 'pen-to-square',
    'picture-o': 'image',
    'play-circle-o': 'circle-play',
    'plus-square-o': 'square-plus',
    'question-circle-o': 'circle-question',
    'registered-o': 'registered',
    'share-square-o': 'share-from-square',
    'smile-o': 'face-smile',
    'snowflake-o': 'snowflake',
    'square-o': 'square',
    'star-half-o': 'star-half',
    'star-o': 'star',
    'sticky-note-o': 'note-sticky',
    'stop-circle-o': 'circle-stop',
    'sun-o': 'sun',
    'thumbs-down-o': 'thumbs-down',
    'thumbs-o-down': 'thumbs-down',
    'thumbs-o-up': 'thumbs-up',
    'thumbs-up-o': 'thumbs-up',
    'times-circle-o': 'circle-xmark',
    'trash-o': 'trash-can',
    'user-circle-o': 'circle-user',
    'user-o': 'user',
    'window-close-o': 'rectangle-xmark',
    'window-maximize-o': 'window-maximize',
    'window-minimize-o': 'window-minimize',
    'window-restore-o': 'window-restore'
  };

  // Brand icons that need explicit font-family
  const brandIcons = [
    '500px', 'adn', 'amazon', 'android', 'angellist', 'apple', 'bandcamp', 'behance',
    'bitbucket', 'bitcoin', 'black-tie', 'bluetooth', 'bluetooth-b', 'buysellads',
    'cc-amex', 'cc-diners-club', 'cc-discover', 'cc-jcb', 'cc-mastercard', 'cc-paypal',
    'cc-stripe', 'cc-visa', 'chrome', 'codepen', 'codiepie', 'connectdevelop', 'contao',
    'css3', 'dashcube', 'delicious', 'deviantart', 'digg', 'dribbble', 'dropbox', 'drupal',
    'edge', 'empire', 'envira', 'etsy', 'expeditedssl', 'facebook', 'facebook-f',
    'firefox', 'flickr', 'fonticons', 'fort-awesome', 'forumbee', 'foursquare',
    'free-code-camp', 'get-pocket', 'gg', 'gg-circle', 'git', 'github', 'github-alt',
    'gitlab', 'glide', 'glide-g', 'google', 'google-plus', 'google-wallet', 'gratipay',
    'grav', 'hacker-news', 'houzz', 'html5', 'imdb', 'instagram', 'internet-explorer',
    'ioxhost', 'joomla', 'jsfiddle', 'lastfm', 'leanpub', 'linkedin', 'linode', 'linux',
    'maxcdn', 'meanpath', 'medium', 'meetup', 'mixcloud', 'modx', 'odnoklassniki',
    'opencart', 'openid', 'opera', 'optin-monster', 'pagelines', 'paypal', 'pied-piper',
    'pied-piper-alt', 'pied-piper-pp', 'pinterest', 'pinterest-p', 'product-hunt', 'qq',
    'quora', 'ravelry', 'rebel', 'reddit', 'reddit-alien', 'renren', 'safari', 'scribd',
    'sellsy', 'shirtsinbulk', 'simplybuilt', 'skyatlas', 'skype', 'slack', 'slideshare',
    'snapchat', 'soundcloud', 'spotify', 'stack-exchange', 'stack-overflow', 'steam',
    'stumbleupon', 'stumbleupon-circle', 'superpowers', 'telegram', 'tencent-weibo',
    'themeisle', 'trello', 'tumblr', 'twitch', 'twitter', 'usb', 'viacoin', 'viadeo',
    'vimeo', 'vine', 'vk', 'weibo', 'weixin', 'whatsapp', 'wikipedia-w', 'windows',
    'wordpress', 'wpbeginner', 'wpexplorer', 'wpforms', 'xing', 'y-combinator', 'yahoo',
    'yelp', 'yoast', 'youtube'
  ];

  // Fork Awesome specific icons fallback mappings
  const forkSpecificIcons = {
    'activitypub': 'share-nodes',
    'archive-org': 'building-columns',
    'artstation': 'artstation',
    'bell-slash-o': 'bell-slash',
    'biometric': 'fingerprint',
    'c': 'c',
    'cc-by': 'creative-commons-by',
    'cc-nc': 'creative-commons-nc',
    'cc-nc-eu': 'creative-commons-nc-eu',
    'cc-nc-jp': 'creative-commons-nc-jp',
    'cc-nd': 'creative-commons-nd',
    'cc-pd': 'creative-commons-pd',
    'cc-remix': 'creative-commons-remix',
    'cc-sa': 'creative-commons-sa',
    'cc-share': 'creative-commons-share',
    'cc-zero': 'creative-commons-zero',
    'commenting': 'comment-dots',
    'commenting-o': 'comment-dots',
    'dat': 'database',
    'diaspora': 'asterisk',
    'digitalocean': 'digital-ocean',
    'discord': 'discord',
    'emby': 'circle-play',
    'ethereum': 'ethereum',
    'f-droid': 'android',
    'facebook-messenger': 'facebook-messenger',
    'foster': 'hands-holding-child',
    'friendica': 'users',
    'galaxy': 'rocket',
    'gimp': 'palette',
    'gitea': 'mug-hot',
    'gnu-social': 'gnu',
    'google-auth': 'shield',
    'hackaday': 'wrench',
    'hackster': 'microchip',
    'inkscape': 'pen-nib',
    'jirafeau': 'share',
    'joplin': 'book',
    'jsdelivr': 'truck-fast',
    'keybase': 'key',
    'laravel': 'laravel',
    'liberapay': 'hand-holding-heart',
    'libreoffice': 'file-word',
    'line-graph': 'chart-line',
    'mastodon': 'mastodon',
    'matrix-org': 'comment-dots',
    'nextcloud': 'cloud',
    'nodejs': 'node-js',
    'orcid': 'orcid',
    'patreon': 'patreon',
    'peertube': 'video',
    'php': 'php',
    'pi-hole': 'shield-halved',
    'pixelfed': 'camera-retro',
    'plume': 'feather',
    'postgresql': 'database',
    'python': 'python',
    'react': 'react',
    'researchgate': 'researchgate',
    'riot': 'comments',
    'scuttlebutt': 'fish',
    'signal': 'signal-messenger',
    'sketchfab': 'cube',
    'snowdrift': 'snowflake',
    'social-home': 'house-user',
    'syncthing': 'arrows-rotate',
    'tex': 'code',
    'tor': 'user-secret',
    'unsplash': 'unsplash',
    'vagrant': 'v',
    'vscode': 'code',
    'xmpp': 'comment',
    'zotero': 'bookmark'
  };

  // Determine if an icon needs regular style
  function isRegularIcon(iconName) {
    return iconName in outlineIcons || iconName.endsWith('-o');
  }

  // Determine if an icon is a brand icon
  function isBrandIcon(iconName) {
    return brandIcons.includes(iconName) || iconName in forkSpecificIcons;
  }

  // Get the mapped icon name and style
  function getMappedIcon(iconName) {
    // Check direct mappings first
    if (iconName in iconMappings) {
      return { name: iconMappings[iconName], style: 'solid' };
    }

    // Check outline icons
    if (iconName in outlineIcons) {
      return { name: outlineIcons[iconName], style: 'regular' };
    }

    // Check Fork-specific icons
    if (iconName in forkSpecificIcons) {
      const mappedName = forkSpecificIcons[iconName];
      const style = isBrandIcon(mappedName) ? 'brands' : 'solid';
      return { name: mappedName, style: style };
    }

    // Default: return as-is
    return { name: iconName, style: 'solid' };
  }

  // Transform icon classes
  function transformIconClasses(element) {
    if (!element || !element.classList) return;

    const classList = element.classList;
    let iconClass = null;
    let hasFA = false;

    // Check if element has 'fa' class
    for (let i = 0; i < classList.length; i++) {
      if (classList[i] === 'fa') {
        hasFA = true;
      } else if (classList[i].startsWith('fa-') && !classList[i].match(/^fa-(fw|spin|pulse|rotate|flip|stack|inverse|border|pull|li|lg|2x|3x|4x|5x)/)) {
        iconClass = classList[i].substring(3); // Remove 'fa-' prefix
      }
    }

    if (!hasFA || !iconClass) return;

    // Get mapped icon
    const mapped = getMappedIcon(iconClass);

    // Remove old icon class
    classList.remove('fa-' + iconClass);

    // Add new icon class
    classList.add('fa-' + mapped.name);

    // Handle style-specific classes
    if (mapped.style === 'regular') {
      classList.add('far');
      classList.remove('fas', 'fab');
    } else if (mapped.style === 'brands') {
      classList.add('fab');
      classList.remove('fas', 'far');
    } else {
      classList.add('fas');
      classList.remove('far', 'fab');
    }
  }

  // Process all icons on the page
  function processAllIcons() {
    const icons = document.querySelectorAll('.fa');
    for (let i = 0; i < icons.length; i++) {
      transformIconClasses(icons[i]);
    }
  }

  // MutationObserver to handle dynamically added icons
  function observeDynamicIcons() {
    const observer = new MutationObserver(function(mutations) {
      mutations.forEach(function(mutation) {
        mutation.addedNodes.forEach(function(node) {
          if (node.nodeType === 1) { // Element node
            if (node.classList && node.classList.contains('fa')) {
              transformIconClasses(node);
            }
            // Check child nodes
            const childIcons = node.querySelectorAll('.fa');
            for (let i = 0; i < childIcons.length; i++) {
              transformIconClasses(childIcons[i]);
            }
          }
        });
      });
    });

    observer.observe(document.body, {
      childList: true,
      subtree: true
    });
  }

  // Initialize shim
  function init() {
    // Process existing icons
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', function() {
        processAllIcons();
        observeDynamicIcons();
      });
    } else {
      processAllIcons();
      observeDynamicIcons();
    }
  }

  // Expose API
  window.ForkAwesomeShim = {
    init: init,
    processAllIcons: processAllIcons,
    transformIconClasses: transformIconClasses,
    getMappedIcon: getMappedIcon
  };

  // Auto-initialize
  init();

})();