import type { User } from "@tryghost/admin-x-framework/api/users";

export const createMockUser = (overrides?: Partial<User>): User => ({
    id: "user-123",
    name: "Test User",
    slug: "test-user",
    email: "test@example.com",
    profile_image: null,
    cover_image: null,
    bio: null,
    website: null,
    location: null,
    facebook: null,
    twitter: null,
    threads: null,
    bluesky: null,
    mastodon: null,
    tiktok: null,
    youtube: null,
    instagram: null,
    linkedin: null,
    accessibility: null,
    status: "active",
    meta_title: null,
    meta_description: null,
    tour: null,
    last_seen: "2024-01-01T00:00:00.000Z",
    created_at: "2024-01-01T00:00:00.000Z",
    updated_at: "2024-01-01T00:00:00.000Z",
    comment_notifications: true,
    free_member_signup_notification: true,
    paid_subscription_canceled_notification: true,
    paid_subscription_started_notification: true,
    mention_notifications: true,
    recommendation_notifications: true,
    milestone_notifications: true,
    donation_notifications: true,
    roles: [
        {
            id: "1",
            name: "Administrator",
            description: "Administrators",
            created_at: "2024-01-01T00:00:00.000Z",
            updated_at: "2024-01-01T00:00:00.000Z",
        },
    ],
    url: "http://localhost:2368/author/test-user/",
    ...overrides,
});

export const mockUser = createMockUser();
