type DotsPatternProps = {
    className?: string;
    style?: React.CSSProperties;
}

const DotsPatternn: React.FC<DotsPatternProps> = ({className = '', style}) => {
    return (
        <svg className={className} fill="none" height="574" style={style} viewBox="0 0 572 574" width="572" xmlns="http://www.w3.org/2000/svg">
            <path d="M324.657 286.802C324.736 286.802 324.799 286.739 324.799 286.66C324.799 286.582 324.736 286.519 324.657 286.519C324.579 286.519 324.516 286.582 324.516 286.66C324.516 286.739 324.579 286.802 324.657 286.802Z" fill="currentColor"/>
            <path d="M319.435 306.238C319.483 306.238 319.522 306.199 319.522 306.151C319.522 306.103 319.483 306.063 319.435 306.063C319.387 306.063 319.348 306.103 319.348 306.151C319.348 306.199 319.387 306.238 319.435 306.238Z" fill="currentColor"/>
            <path d="M305.169 320.505C305.217 320.505 305.257 320.465 305.257 320.417C305.257 320.369 305.217 320.33 305.169 320.33C305.121 320.33 305.082 320.369 305.082 320.417C305.082 320.465 305.121 320.505 305.169 320.505Z" fill="currentColor"/>
            <path d="M285.681 325.727C285.729 325.727 285.768 325.688 285.768 325.64C285.768 325.592 285.729 325.553 285.681 325.553C285.633 325.553 285.594 325.592 285.594 325.64C285.594 325.688 285.633 325.727 285.681 325.727Z" fill="currentColor"/>
            <path d="M266.189 320.505C266.237 320.505 266.276 320.465 266.276 320.417C266.276 320.369 266.237 320.33 266.189 320.33C266.141 320.33 266.102 320.369 266.102 320.417C266.102 320.465 266.141 320.505 266.189 320.505Z" fill="currentColor"/>
            <path d="M251.923 306.238C251.971 306.238 252.01 306.199 252.01 306.151C252.01 306.103 251.971 306.063 251.923 306.063C251.875 306.063 251.836 306.103 251.836 306.151C251.836 306.199 251.875 306.238 251.923 306.238Z" fill="currentColor"/>
            <path d="M246.7 286.802C246.779 286.802 246.842 286.739 246.842 286.66C246.842 286.582 246.779 286.519 246.7 286.519C246.622 286.519 246.559 286.582 246.559 286.66C246.559 286.739 246.622 286.802 246.7 286.802Z" fill="currentColor"/>
            <path d="M251.923 267.258C251.971 267.258 252.01 267.219 252.01 267.171C252.01 267.123 251.971 267.084 251.923 267.084C251.875 267.084 251.836 267.123 251.836 267.171C251.836 267.219 251.875 267.258 251.923 267.258Z" fill="currentColor"/>
            <path d="M266.189 252.991C266.237 252.991 266.276 252.952 266.276 252.904C266.276 252.855 266.237 252.816 266.189 252.816C266.141 252.816 266.102 252.855 266.102 252.904C266.102 252.952 266.141 252.991 266.189 252.991Z" fill="currentColor"/>
            <path d="M285.681 247.797C285.745 247.797 285.796 247.746 285.796 247.682C285.796 247.619 285.745 247.567 285.681 247.567C285.618 247.567 285.566 247.619 285.566 247.682C285.566 247.746 285.618 247.797 285.681 247.797Z" fill="currentColor"/>
            <path d="M305.169 252.991C305.217 252.991 305.257 252.952 305.257 252.904C305.257 252.855 305.217 252.816 305.169 252.816C305.121 252.816 305.082 252.855 305.082 252.904C305.082 252.952 305.121 252.991 305.169 252.991Z" fill="currentColor"/>
            <path d="M319.435 267.258C319.483 267.258 319.522 267.219 319.522 267.171C319.522 267.123 319.483 267.084 319.435 267.084C319.387 267.084 319.348 267.123 319.348 267.171C319.348 267.219 319.387 267.258 319.435 267.258Z" fill="currentColor"/>
            <path d="M227.209 287.046C227.422 287.046 227.594 286.873 227.594 286.66C227.594 286.448 227.422 286.275 227.209 286.275C226.997 286.275 226.824 286.448 226.824 286.66C226.824 286.873 226.997 287.046 227.209 287.046Z" fill="currentColor"/>
            <path d="M230.736 266.993C230.918 266.993 231.066 266.846 231.066 266.664C231.066 266.482 230.918 266.334 230.736 266.334C230.554 266.334 230.406 266.482 230.406 266.664C230.406 266.846 230.554 266.993 230.736 266.993Z" fill="currentColor"/>
            <path d="M240.888 249.408C241.07 249.408 241.218 249.26 241.218 249.078C241.218 248.896 241.07 248.748 240.888 248.748C240.706 248.748 240.559 248.896 240.559 249.078C240.559 249.26 240.706 249.408 240.888 249.408Z" fill="currentColor"/>
            <path d="M256.443 236.355C256.625 236.355 256.773 236.207 256.773 236.025C256.773 235.843 256.625 235.695 256.443 235.695C256.261 235.695 256.113 235.843 256.113 236.025C256.113 236.207 256.261 236.355 256.443 236.355Z" fill="currentColor"/>
            <path d="M275.526 229.465C275.738 229.465 275.911 229.293 275.911 229.08C275.911 228.868 275.738 228.695 275.526 228.695C275.313 228.695 275.141 228.868 275.141 229.08C275.141 229.293 275.313 229.465 275.526 229.465Z" fill="currentColor"/>
            <path d="M295.834 229.41C296.016 229.41 296.163 229.263 296.163 229.081C296.163 228.899 296.016 228.751 295.834 228.751C295.652 228.751 295.504 228.899 295.504 229.081C295.504 229.263 295.652 229.41 295.834 229.41Z" fill="currentColor"/>
            <path d="M314.913 236.383C315.11 236.383 315.271 236.223 315.271 236.025C315.271 235.827 315.11 235.667 314.913 235.667C314.715 235.667 314.555 235.827 314.555 236.025C314.555 236.223 314.715 236.383 314.913 236.383Z" fill="currentColor"/>
            <path d="M330.471 249.463C330.684 249.463 330.856 249.29 330.856 249.077C330.856 248.865 330.684 248.692 330.471 248.692C330.258 248.692 330.086 248.865 330.086 249.077C330.086 249.29 330.258 249.463 330.471 249.463Z" fill="currentColor"/>
            <path d="M340.623 266.993C340.805 266.993 340.952 266.846 340.952 266.664C340.952 266.482 340.805 266.334 340.623 266.334C340.441 266.334 340.293 266.482 340.293 266.664C340.293 266.846 340.441 266.993 340.623 266.993Z" fill="currentColor"/>
            <path d="M344.147 287.046C344.359 287.046 344.532 286.873 344.532 286.66C344.532 286.448 344.359 286.275 344.147 286.275C343.934 286.275 343.762 286.448 343.762 286.66C343.762 286.873 343.934 287.046 344.147 287.046Z" fill="currentColor"/>
            <path d="M340.623 306.989C340.805 306.989 340.952 306.841 340.952 306.659C340.952 306.477 340.805 306.329 340.623 306.329C340.441 306.329 340.293 306.477 340.293 306.659C340.293 306.841 340.441 306.989 340.623 306.989Z" fill="currentColor"/>
            <path d="M330.47 324.574C330.652 324.574 330.8 324.427 330.8 324.245C330.8 324.063 330.652 323.915 330.47 323.915C330.288 323.915 330.141 324.063 330.141 324.245C330.141 324.427 330.288 324.574 330.47 324.574Z" fill="currentColor"/>
            <path d="M314.913 337.655C315.11 337.655 315.271 337.494 315.271 337.297C315.271 337.099 315.11 336.938 314.913 336.938C314.715 336.938 314.555 337.099 314.555 337.297C314.555 337.494 314.715 337.655 314.913 337.655Z" fill="currentColor"/>
            <path d="M295.834 344.572C296.016 344.572 296.163 344.424 296.163 344.242C296.163 344.06 296.016 343.912 295.834 343.912C295.652 343.912 295.504 344.06 295.504 344.242C295.504 344.424 295.652 344.572 295.834 344.572Z" fill="currentColor"/>
            <path d="M275.525 344.572C275.707 344.572 275.855 344.424 275.855 344.242C275.855 344.06 275.707 343.912 275.525 343.912C275.343 343.912 275.195 344.06 275.195 344.242C275.195 344.424 275.343 344.572 275.525 344.572Z" fill="currentColor"/>
            <path d="M256.443 337.626C256.625 337.626 256.773 337.479 256.773 337.297C256.773 337.114 256.625 336.967 256.443 336.967C256.261 336.967 256.113 337.114 256.113 337.297C256.113 337.479 256.261 337.626 256.443 337.626Z" fill="currentColor"/>
            <path d="M240.888 324.574C241.07 324.574 241.218 324.427 241.218 324.245C241.218 324.063 241.07 323.915 240.888 323.915C240.706 323.915 240.559 324.063 240.559 324.245C240.559 324.427 240.706 324.574 240.888 324.574Z" fill="currentColor"/>
            <path d="M230.736 306.989C230.918 306.989 231.066 306.841 231.066 306.659C231.066 306.477 230.918 306.329 230.736 306.329C230.554 306.329 230.406 306.477 230.406 306.659C230.406 306.841 230.554 306.989 230.736 306.989Z" fill="currentColor"/>
            <path d="M363.638 287.233C363.954 287.233 364.21 286.977 364.21 286.661C364.21 286.345 363.954 286.089 363.638 286.089C363.322 286.089 363.066 286.345 363.066 286.661C363.066 286.977 363.322 287.233 363.638 287.233Z" fill="currentColor"/>
            <path d="M360.982 307.437C361.312 307.437 361.581 307.169 361.581 306.838C361.581 306.507 361.312 306.239 360.982 306.239C360.651 306.239 360.383 306.507 360.383 306.838C360.383 307.169 360.651 307.437 360.982 307.437Z" fill="currentColor"/>
            <path d="M353.193 326.212C353.509 326.212 353.765 325.956 353.765 325.64C353.765 325.324 353.509 325.068 353.193 325.068C352.877 325.068 352.621 325.324 352.621 325.64C352.621 325.956 352.877 326.212 353.193 326.212Z" fill="currentColor"/>
            <path d="M340.806 342.385C341.137 342.385 341.405 342.117 341.405 341.786C341.405 341.456 341.137 341.188 340.806 341.188C340.475 341.188 340.207 341.456 340.207 341.786C340.207 342.117 340.475 342.385 340.806 342.385Z" fill="currentColor"/>
            <path d="M324.658 354.747C324.974 354.747 325.23 354.491 325.23 354.175C325.23 353.86 324.974 353.604 324.658 353.604C324.342 353.604 324.086 353.86 324.086 354.175C324.086 354.491 324.342 354.747 324.658 354.747Z" fill="currentColor"/>
            <path d="M305.857 362.536C306.173 362.536 306.429 362.279 306.429 361.964C306.429 361.648 306.173 361.392 305.857 361.392C305.541 361.392 305.285 361.648 305.285 361.964C305.285 362.279 305.541 362.536 305.857 362.536Z" fill="currentColor"/>
            <path d="M285.679 365.248C286.026 365.248 286.307 364.966 286.307 364.62C286.307 364.273 286.026 363.991 285.679 363.991C285.332 363.991 285.051 364.273 285.051 364.62C285.051 364.966 285.332 365.248 285.679 365.248Z" fill="currentColor"/>
            <path d="M265.502 362.536C265.818 362.536 266.074 362.279 266.074 361.964C266.074 361.648 265.818 361.392 265.502 361.392C265.186 361.392 264.93 361.648 264.93 361.964C264.93 362.279 265.186 362.536 265.502 362.536Z" fill="currentColor"/>
            <path d="M246.7 354.774C247.031 354.774 247.299 354.506 247.299 354.175C247.299 353.844 247.031 353.576 246.7 353.576C246.37 353.576 246.102 353.844 246.102 354.175C246.102 354.506 246.37 354.774 246.7 354.774Z" fill="currentColor"/>
            <path d="M230.556 342.385C230.887 342.385 231.155 342.117 231.155 341.786C231.155 341.456 230.887 341.188 230.556 341.188C230.225 341.188 229.957 341.456 229.957 341.786C229.957 342.117 230.225 342.385 230.556 342.385Z" fill="currentColor"/>
            <path d="M218.166 326.212C218.482 326.212 218.738 325.956 218.738 325.64C218.738 325.324 218.482 325.068 218.166 325.068C217.85 325.068 217.594 325.324 217.594 325.64C217.594 325.956 217.85 326.212 218.166 326.212Z" fill="currentColor"/>
            <path d="M210.377 307.41C210.693 307.41 210.949 307.153 210.949 306.838C210.949 306.522 210.693 306.266 210.377 306.266C210.061 306.266 209.805 306.522 209.805 306.838C209.805 307.153 210.061 307.41 210.377 307.41Z" fill="currentColor"/>
            <path d="M207.72 287.259C208.051 287.259 208.319 286.991 208.319 286.66C208.319 286.33 208.051 286.062 207.72 286.062C207.389 286.062 207.121 286.33 207.121 286.66C207.121 286.991 207.389 287.259 207.72 287.259Z" fill="currentColor"/>
            <path d="M210.377 267.056C210.693 267.056 210.949 266.8 210.949 266.484C210.949 266.168 210.693 265.912 210.377 265.912C210.061 265.912 209.805 266.168 209.805 266.484C209.805 266.8 210.061 267.056 210.377 267.056Z" fill="currentColor"/>
            <path d="M218.166 248.254C218.482 248.254 218.738 247.998 218.738 247.682C218.738 247.366 218.482 247.11 218.166 247.11C217.85 247.11 217.594 247.366 217.594 247.682C217.594 247.998 217.85 248.254 218.166 248.254Z" fill="currentColor"/>
            <path d="M230.552 232.108C230.868 232.108 231.124 231.852 231.124 231.536C231.124 231.22 230.868 230.964 230.552 230.964C230.237 230.964 229.98 231.22 229.98 231.536C229.98 231.852 230.237 232.108 230.552 232.108Z" fill="currentColor"/>
            <path d="M246.701 219.718C247.017 219.718 247.273 219.462 247.273 219.146C247.273 218.83 247.017 218.574 246.701 218.574C246.385 218.574 246.129 218.83 246.129 219.146C246.129 219.462 246.385 219.718 246.701 219.718Z" fill="currentColor"/>
            <path d="M265.502 211.931C265.818 211.931 266.074 211.675 266.074 211.359C266.074 211.043 265.818 210.787 265.502 210.787C265.186 210.787 264.93 211.043 264.93 211.359C264.93 211.675 265.186 211.931 265.502 211.931Z" fill="currentColor"/>
            <path d="M285.677 209.275C285.993 209.275 286.249 209.019 286.249 208.703C286.249 208.387 285.993 208.131 285.677 208.131C285.362 208.131 285.105 208.387 285.105 208.703C285.105 209.019 285.362 209.275 285.677 209.275Z" fill="currentColor"/>
            <path d="M305.857 211.931C306.173 211.931 306.429 211.675 306.429 211.359C306.429 211.043 306.173 210.787 305.857 210.787C305.541 210.787 305.285 211.043 305.285 211.359C305.285 211.675 305.541 211.931 305.857 211.931Z" fill="currentColor"/>
            <path d="M324.657 219.746C324.988 219.746 325.256 219.477 325.256 219.147C325.256 218.816 324.988 218.548 324.657 218.548C324.327 218.548 324.059 218.816 324.059 219.147C324.059 219.477 324.327 219.746 324.657 219.746Z" fill="currentColor"/>
            <path d="M340.802 232.108C341.118 232.108 341.374 231.852 341.374 231.536C341.374 231.22 341.118 230.964 340.802 230.964C340.487 230.964 340.23 231.22 340.23 231.536C340.23 231.852 340.487 232.108 340.802 232.108Z" fill="currentColor"/>
            <path d="M353.195 248.31C353.542 248.31 353.823 248.029 353.823 247.682C353.823 247.335 353.542 247.054 353.195 247.054C352.848 247.054 352.566 247.335 352.566 247.682C352.566 248.029 352.848 248.31 353.195 248.31Z" fill="currentColor"/>
            <path d="M360.982 267.056C361.298 267.056 361.554 266.8 361.554 266.484C361.554 266.168 361.298 265.912 360.982 265.912C360.666 265.912 360.41 266.168 360.41 266.484C360.41 266.8 360.666 267.056 360.982 267.056Z" fill="currentColor"/>
            <path d="M188.232 287.475C188.682 287.475 189.046 287.111 189.046 286.661C189.046 286.211 188.682 285.847 188.232 285.847C187.783 285.847 187.418 286.211 187.418 286.661C187.418 287.111 187.783 287.475 188.232 287.475Z" fill="currentColor"/>
            <path d="M190.361 267.214C190.811 267.214 191.175 266.85 191.175 266.4C191.175 265.95 190.811 265.586 190.361 265.586C189.911 265.586 189.547 265.95 189.547 266.4C189.547 266.85 189.911 267.214 190.361 267.214Z" fill="currentColor"/>
            <path d="M196.658 247.839C197.108 247.839 197.472 247.475 197.472 247.025C197.472 246.575 197.108 246.211 196.658 246.211C196.208 246.211 195.844 246.575 195.844 247.025C195.844 247.475 196.208 247.839 196.658 247.839Z" fill="currentColor"/>
            <path d="M206.842 230.197C207.291 230.197 207.656 229.832 207.656 229.383C207.656 228.933 207.291 228.568 206.842 228.568C206.392 228.568 206.027 228.933 206.027 229.383C206.027 229.832 206.392 230.197 206.842 230.197Z" fill="currentColor"/>
            <path d="M220.474 215.057C220.924 215.057 221.289 214.693 221.289 214.243C221.289 213.793 220.924 213.429 220.474 213.429C220.025 213.429 219.66 213.793 219.66 214.243C219.66 214.693 220.025 215.057 220.474 215.057Z" fill="currentColor"/>
            <path d="M236.955 203.083C237.404 203.083 237.769 202.718 237.769 202.268C237.769 201.819 237.404 201.454 236.955 201.454C236.505 201.454 236.141 201.819 236.141 202.268C236.141 202.718 236.505 203.083 236.955 203.083Z" fill="currentColor"/>
            <path d="M255.564 194.796C256.014 194.796 256.378 194.432 256.378 193.982C256.378 193.533 256.014 193.168 255.564 193.168C255.115 193.168 254.75 193.533 254.75 193.982C254.75 194.432 255.115 194.796 255.564 194.796Z" fill="currentColor"/>
            <path d="M275.494 190.561C275.944 190.561 276.308 190.197 276.308 189.747C276.308 189.297 275.944 188.933 275.494 188.933C275.044 188.933 274.68 189.297 274.68 189.747C274.68 190.197 275.044 190.561 275.494 190.561Z" fill="currentColor"/>
            <path d="M295.865 190.561C296.315 190.561 296.679 190.197 296.679 189.747C296.679 189.297 296.315 188.933 295.865 188.933C295.415 188.933 295.051 189.297 295.051 189.747C295.051 190.197 295.415 190.561 295.865 190.561Z" fill="currentColor"/>
            <path d="M315.791 194.796C316.24 194.796 316.605 194.432 316.605 193.982C316.605 193.533 316.24 193.168 315.791 193.168C315.341 193.168 314.977 193.533 314.977 193.982C314.977 194.432 315.341 194.796 315.791 194.796Z" fill="currentColor"/>
            <path d="M334.404 203.083C334.854 203.083 335.218 202.718 335.218 202.268C335.218 201.819 334.854 201.454 334.404 201.454C333.954 201.454 333.59 201.819 333.59 202.268C333.59 202.718 333.954 203.083 334.404 203.083Z" fill="currentColor"/>
            <path d="M350.885 215.057C351.334 215.057 351.699 214.693 351.699 214.243C351.699 213.793 351.334 213.429 350.885 213.429C350.435 213.429 350.07 213.793 350.07 214.243C350.07 214.693 350.435 215.057 350.885 215.057Z" fill="currentColor"/>
            <path d="M364.517 230.197C364.967 230.197 365.332 229.832 365.332 229.383C365.332 228.933 364.967 228.568 364.517 228.568C364.068 228.568 363.703 228.933 363.703 229.383C363.703 229.832 364.068 230.197 364.517 230.197Z" fill="currentColor"/>
            <path d="M374.705 247.839C375.155 247.839 375.519 247.475 375.519 247.025C375.519 246.575 375.155 246.211 374.705 246.211C374.255 246.211 373.891 246.575 373.891 247.025C373.891 247.475 374.255 247.839 374.705 247.839Z" fill="currentColor"/>
            <path d="M381 267.272C381.482 267.272 381.872 266.882 381.872 266.401C381.872 265.919 381.482 265.529 381 265.529C380.519 265.529 380.129 265.919 380.129 266.401C380.129 266.882 380.519 267.272 381 267.272Z" fill="currentColor"/>
            <path d="M383.129 287.533C383.611 287.533 384.001 287.143 384.001 286.661C384.001 286.18 383.611 285.79 383.129 285.79C382.648 285.79 382.258 286.18 382.258 286.661C382.258 287.143 382.648 287.533 383.129 287.533Z" fill="currentColor"/>
            <path d="M380.998 307.736C381.447 307.736 381.812 307.371 381.812 306.922C381.812 306.472 381.447 306.107 380.998 306.107C380.548 306.107 380.184 306.472 380.184 306.922C380.184 307.371 380.548 307.736 380.998 307.736Z" fill="currentColor"/>
            <path d="M374.705 327.111C375.155 327.111 375.519 326.746 375.519 326.297C375.519 325.847 375.155 325.482 374.705 325.482C374.255 325.482 373.891 325.847 373.891 326.297C373.891 326.746 374.255 327.111 374.705 327.111Z" fill="currentColor"/>
            <path d="M364.517 344.754C364.967 344.754 365.332 344.39 365.332 343.94C365.332 343.491 364.967 343.126 364.517 343.126C364.068 343.126 363.703 343.491 363.703 343.94C363.703 344.39 364.068 344.754 364.517 344.754Z" fill="currentColor"/>
            <path d="M350.885 359.893C351.334 359.893 351.699 359.529 351.699 359.079C351.699 358.629 351.334 358.265 350.885 358.265C350.435 358.265 350.07 358.629 350.07 359.079C350.07 359.529 350.435 359.893 350.885 359.893Z" fill="currentColor"/>
            <path d="M334.404 371.895C334.868 371.895 335.245 371.519 335.245 371.054C335.245 370.589 334.868 370.213 334.404 370.213C333.939 370.213 333.562 370.589 333.562 371.054C333.562 371.519 333.939 371.895 334.404 371.895Z" fill="currentColor"/>
            <path d="M315.794 380.181C316.259 380.181 316.635 379.805 316.635 379.34C316.635 378.876 316.259 378.499 315.794 378.499C315.33 378.499 314.953 378.876 314.953 379.34C314.953 379.805 315.33 380.181 315.794 380.181Z" fill="currentColor"/>
            <path d="M295.865 384.39C296.315 384.39 296.679 384.026 296.679 383.576C296.679 383.126 296.315 382.762 295.865 382.762C295.415 382.762 295.051 383.126 295.051 383.576C295.051 384.026 295.415 384.39 295.865 384.39Z" fill="currentColor"/>
            <path d="M275.494 384.39C275.944 384.39 276.308 384.026 276.308 383.576C276.308 383.126 275.944 382.762 275.494 382.762C275.044 382.762 274.68 383.126 274.68 383.576C274.68 384.026 275.044 384.39 275.494 384.39Z" fill="currentColor"/>
            <path d="M255.567 380.211C256.048 380.211 256.438 379.821 256.438 379.339C256.438 378.858 256.048 378.468 255.567 378.468C255.085 378.468 254.695 378.858 254.695 379.339C254.695 379.821 255.085 380.211 255.567 380.211Z" fill="currentColor"/>
            <path d="M236.955 371.868C237.404 371.868 237.769 371.503 237.769 371.053C237.769 370.604 237.404 370.239 236.955 370.239C236.505 370.239 236.141 370.604 236.141 371.053C236.141 371.503 236.505 371.868 236.955 371.868Z" fill="currentColor"/>
            <path d="M220.474 359.893C220.924 359.893 221.289 359.529 221.289 359.079C221.289 358.629 220.924 358.265 220.474 358.265C220.025 358.265 219.66 358.629 219.66 359.079C219.66 359.529 220.025 359.893 220.474 359.893Z" fill="currentColor"/>
            <path d="M206.842 344.754C207.291 344.754 207.656 344.39 207.656 343.94C207.656 343.491 207.291 343.126 206.842 343.126C206.392 343.126 206.027 343.491 206.027 343.94C206.027 344.39 206.392 344.754 206.842 344.754Z" fill="currentColor"/>
            <path d="M196.658 327.111C197.108 327.111 197.472 326.746 197.472 326.297C197.472 325.847 197.108 325.482 196.658 325.482C196.208 325.482 195.844 325.847 195.844 326.297C195.844 326.746 196.208 327.111 196.658 327.111Z" fill="currentColor"/>
            <path d="M190.361 307.736C190.811 307.736 191.175 307.371 191.175 306.922C191.175 306.472 190.811 306.107 190.361 306.107C189.911 306.107 189.547 306.472 189.547 306.922C189.547 307.371 189.911 307.736 190.361 307.736Z" fill="currentColor"/>
            <path d="M402.619 287.717C403.202 287.717 403.675 287.244 403.675 286.661C403.675 286.078 403.202 285.604 402.619 285.604C402.036 285.604 401.562 286.078 401.562 286.661C401.562 287.244 402.036 287.717 402.619 287.717Z" fill="currentColor"/>
            <path d="M400.841 308.082C401.457 308.082 401.956 307.583 401.956 306.967C401.956 306.352 401.457 305.853 400.841 305.853C400.226 305.853 399.727 306.352 399.727 306.967C399.727 307.583 400.226 308.082 400.841 308.082Z" fill="currentColor"/>
            <path d="M395.564 327.74C396.162 327.74 396.647 327.255 396.647 326.657C396.647 326.058 396.162 325.573 395.564 325.573C394.965 325.573 394.48 326.058 394.48 326.657C394.48 327.255 394.965 327.74 395.564 327.74Z" fill="currentColor"/>
            <path d="M386.951 346.214C387.549 346.214 388.034 345.729 388.034 345.13C388.034 344.532 387.549 344.047 386.951 344.047C386.352 344.047 385.867 344.532 385.867 345.13C385.867 345.729 386.352 346.214 386.951 346.214Z" fill="currentColor"/>
            <path d="M375.259 362.942C375.875 362.942 376.374 362.443 376.374 361.828C376.374 361.212 375.875 360.713 375.259 360.713C374.644 360.713 374.145 361.212 374.145 361.828C374.145 362.443 374.644 362.942 375.259 362.942Z" fill="currentColor"/>
            <path d="M360.846 377.298C361.429 377.298 361.902 376.825 361.902 376.241C361.902 375.658 361.429 375.185 360.846 375.185C360.262 375.185 359.789 375.658 359.789 376.241C359.789 376.825 360.262 377.298 360.846 377.298Z" fill="currentColor"/>
            <path d="M344.15 388.989C344.734 388.989 345.207 388.516 345.207 387.932C345.207 387.349 344.734 386.876 344.15 386.876C343.567 386.876 343.094 387.349 343.094 387.932C343.094 388.516 343.567 388.989 344.15 388.989Z" fill="currentColor"/>
            <path d="M325.673 397.63C326.272 397.63 326.757 397.145 326.757 396.546C326.757 395.948 326.272 395.463 325.673 395.463C325.075 395.463 324.59 395.948 324.59 396.546C324.59 397.145 325.075 397.63 325.673 397.63Z" fill="currentColor"/>
            <path d="M305.986 402.906C306.584 402.906 307.069 402.421 307.069 401.823C307.069 401.224 306.584 400.739 305.986 400.739C305.387 400.739 304.902 401.224 304.902 401.823C304.902 402.421 305.387 402.906 305.986 402.906Z" fill="currentColor"/>
            <path d="M285.681 404.682C286.279 404.682 286.764 404.197 286.764 403.599C286.764 403.001 286.279 402.516 285.681 402.516C285.083 402.516 284.598 403.001 284.598 403.599C284.598 404.197 285.083 404.682 285.681 404.682Z" fill="currentColor"/>
            <path d="M265.372 402.906C265.971 402.906 266.456 402.421 266.456 401.823C266.456 401.224 265.971 400.739 265.372 400.739C264.774 400.739 264.289 401.224 264.289 401.823C264.289 402.421 264.774 402.906 265.372 402.906Z" fill="currentColor"/>
            <path d="M245.685 397.603C246.269 397.603 246.742 397.13 246.742 396.547C246.742 395.963 246.269 395.49 245.685 395.49C245.102 395.49 244.629 395.963 244.629 396.547C244.629 397.13 245.102 397.603 245.685 397.603Z" fill="currentColor"/>
            <path d="M227.212 389.015C227.811 389.015 228.296 388.53 228.296 387.932C228.296 387.334 227.811 386.849 227.212 386.849C226.614 386.849 226.129 387.334 226.129 387.932C226.129 388.53 226.614 389.015 227.212 389.015Z" fill="currentColor"/>
            <path d="M210.514 377.298C211.097 377.298 211.57 376.825 211.57 376.241C211.57 375.658 211.097 375.185 210.514 375.185C209.93 375.185 209.457 375.658 209.457 376.241C209.457 376.825 209.93 377.298 210.514 377.298Z" fill="currentColor"/>
            <path d="M196.099 362.942C196.715 362.942 197.214 362.443 197.214 361.828C197.214 361.212 196.715 360.713 196.099 360.713C195.483 360.713 194.984 361.212 194.984 361.828C194.984 362.443 195.483 362.942 196.099 362.942Z" fill="currentColor"/>
            <path d="M184.408 346.214C185.006 346.214 185.491 345.729 185.491 345.13C185.491 344.532 185.006 344.047 184.408 344.047C183.809 344.047 183.324 344.532 183.324 345.13C183.324 345.729 183.809 346.214 184.408 346.214Z" fill="currentColor"/>
            <path d="M175.795 327.712C176.378 327.712 176.851 327.24 176.851 326.656C176.851 326.073 176.378 325.6 175.795 325.6C175.211 325.6 174.738 326.073 174.738 326.656C174.738 327.24 175.211 327.712 175.795 327.712Z" fill="currentColor"/>
            <path d="M170.517 308.024C171.101 308.024 171.574 307.551 171.574 306.968C171.574 306.384 171.101 305.911 170.517 305.911C169.934 305.911 169.461 306.384 169.461 306.968C169.461 307.551 169.934 308.024 170.517 308.024Z" fill="currentColor"/>
            <path d="M168.74 287.775C169.355 287.775 169.854 287.276 169.854 286.661C169.854 286.045 169.355 285.546 168.74 285.546C168.124 285.546 167.625 286.045 167.625 286.661C167.625 287.276 168.124 287.775 168.74 287.775Z" fill="currentColor"/>
            <path d="M170.517 267.412C171.101 267.412 171.574 266.939 171.574 266.355C171.574 265.772 171.101 265.299 170.517 265.299C169.934 265.299 169.461 265.772 169.461 266.355C169.461 266.939 169.934 267.412 170.517 267.412Z" fill="currentColor"/>
            <path d="M175.795 247.722C176.378 247.722 176.851 247.249 176.851 246.666C176.851 246.082 176.378 245.609 175.795 245.609C175.211 245.609 174.738 246.082 174.738 246.666C174.738 247.249 175.211 247.722 175.795 247.722Z" fill="currentColor"/>
            <path d="M184.408 229.28C185.009 229.28 185.496 228.793 185.496 228.192C185.496 227.591 185.009 227.104 184.408 227.104C183.807 227.104 183.32 227.591 183.32 228.192C183.32 228.793 183.807 229.28 184.408 229.28Z" fill="currentColor"/>
            <path d="M196.099 212.551C196.683 212.551 197.156 212.078 197.156 211.495C197.156 210.911 196.683 210.438 196.099 210.438C195.516 210.438 195.043 210.911 195.043 211.495C195.043 212.078 195.516 212.551 196.099 212.551Z" fill="currentColor"/>
            <path d="M210.514 198.138C211.097 198.138 211.57 197.665 211.57 197.082C211.57 196.498 211.097 196.025 210.514 196.025C209.93 196.025 209.457 196.498 209.457 197.082C209.457 197.665 209.93 198.138 210.514 198.138Z" fill="currentColor"/>
            <path d="M227.209 186.446C227.792 186.446 228.265 185.973 228.265 185.389C228.265 184.806 227.792 184.333 227.209 184.333C226.625 184.333 226.152 184.806 226.152 185.389C226.152 185.973 226.625 186.446 227.209 186.446Z" fill="currentColor"/>
            <path d="M245.685 177.832C246.269 177.832 246.742 177.359 246.742 176.775C246.742 176.192 246.269 175.719 245.685 175.719C245.102 175.719 244.629 176.192 244.629 176.775C244.629 177.359 245.102 177.832 245.685 177.832Z" fill="currentColor"/>
            <path d="M265.373 172.556C265.956 172.556 266.429 172.083 266.429 171.5C266.429 170.916 265.956 170.443 265.373 170.443C264.789 170.443 264.316 170.916 264.316 171.5C264.316 172.083 264.789 172.556 265.373 172.556Z" fill="currentColor"/>
            <path d="M285.681 170.806C286.279 170.806 286.764 170.321 286.764 169.723C286.764 169.125 286.279 168.64 285.681 168.64C285.083 168.64 284.598 169.125 284.598 169.723C284.598 170.321 285.083 170.806 285.681 170.806Z" fill="currentColor"/>
            <path d="M305.986 172.556C306.57 172.556 307.043 172.083 307.043 171.5C307.043 170.916 306.57 170.443 305.986 170.443C305.403 170.443 304.93 170.916 304.93 171.5C304.93 172.083 305.403 172.556 305.986 172.556Z" fill="currentColor"/>
            <path d="M325.674 177.832C326.257 177.832 326.73 177.359 326.73 176.775C326.73 176.192 326.257 175.719 325.674 175.719C325.09 175.719 324.617 176.192 324.617 176.775C324.617 177.359 325.09 177.832 325.674 177.832Z" fill="currentColor"/>
            <path d="M344.15 186.505C344.765 186.505 345.265 186.006 345.265 185.39C345.265 184.774 344.765 184.275 344.15 184.275C343.534 184.275 343.035 184.774 343.035 185.39C343.035 186.006 343.534 186.505 344.15 186.505Z" fill="currentColor"/>
            <path d="M360.846 198.138C361.429 198.138 361.902 197.665 361.902 197.082C361.902 196.498 361.429 196.025 360.846 196.025C360.262 196.025 359.789 196.498 359.789 197.082C359.789 197.665 360.262 198.138 360.846 198.138Z" fill="currentColor"/>
            <path d="M375.26 212.551C375.843 212.551 376.316 212.078 376.316 211.495C376.316 210.911 375.843 210.438 375.26 210.438C374.676 210.438 374.203 210.911 374.203 211.495C374.203 212.078 374.676 212.551 375.26 212.551Z" fill="currentColor"/>
            <path d="M386.951 229.249C387.534 229.249 388.007 228.776 388.007 228.192C388.007 227.609 387.534 227.136 386.951 227.136C386.367 227.136 385.895 227.609 385.895 228.192C385.895 228.776 386.367 229.249 386.951 229.249Z" fill="currentColor"/>
            <path d="M395.564 247.78C396.179 247.78 396.679 247.281 396.679 246.665C396.679 246.05 396.179 245.551 395.564 245.551C394.948 245.551 394.449 246.05 394.449 246.665C394.449 247.281 394.948 247.78 395.564 247.78Z" fill="currentColor"/>
            <path d="M400.841 267.438C401.44 267.438 401.925 266.953 401.925 266.355C401.925 265.757 401.44 265.271 400.841 265.271C400.243 265.271 399.758 265.757 399.758 266.355C399.758 266.953 400.243 267.438 400.841 267.438Z" fill="currentColor"/>
            <path d="M149.252 287.96C149.969 287.96 150.551 287.378 150.551 286.661C150.551 285.944 149.969 285.362 149.252 285.362C148.535 285.362 147.953 285.944 147.953 286.661C147.953 287.378 148.535 287.96 149.252 287.96Z" fill="currentColor"/>
            <path d="M150.775 267.627C151.493 267.627 152.074 267.045 152.074 266.328C152.074 265.611 151.493 265.029 150.775 265.029C150.058 265.029 149.477 265.611 149.477 266.328C149.477 267.045 150.058 267.627 150.775 267.627Z" fill="currentColor"/>
            <path d="M155.314 247.773C156.046 247.773 156.64 247.18 156.64 246.448C156.64 245.716 156.046 245.122 155.314 245.122C154.582 245.122 153.988 245.716 153.988 246.448C153.988 247.18 154.582 247.773 155.314 247.773Z" fill="currentColor"/>
            <path d="M162.764 228.765C163.481 228.765 164.062 228.184 164.062 227.467C164.062 226.749 163.481 226.168 162.764 226.168C162.046 226.168 161.465 226.749 161.465 227.467C161.465 228.184 162.046 228.765 162.764 228.765Z" fill="currentColor"/>
            <path d="M172.959 211.107C173.676 211.107 174.258 210.526 174.258 209.808C174.258 209.091 173.676 208.51 172.959 208.51C172.242 208.51 171.66 209.091 171.66 209.808C171.66 210.526 172.242 211.107 172.959 211.107Z" fill="currentColor"/>
            <path d="M185.669 195.192C186.401 195.192 186.995 194.599 186.995 193.867C186.995 193.135 186.401 192.541 185.669 192.541C184.937 192.541 184.344 193.135 184.344 193.867C184.344 194.599 184.937 195.192 185.669 195.192Z" fill="currentColor"/>
            <path d="M200.619 181.323C201.351 181.323 201.944 180.73 201.944 179.998C201.944 179.265 201.351 178.672 200.619 178.672C199.886 178.672 199.293 179.265 199.293 179.998C199.293 180.73 199.886 181.323 200.619 181.323Z" fill="currentColor"/>
            <path d="M217.467 169.81C218.184 169.81 218.765 169.229 218.765 168.512C218.765 167.794 218.184 167.213 217.467 167.213C216.749 167.213 216.168 167.794 216.168 168.512C216.168 169.229 216.749 169.81 217.467 169.81Z" fill="currentColor"/>
            <path d="M235.837 160.99C236.569 160.99 237.163 160.397 237.163 159.664C237.163 158.932 236.569 158.339 235.837 158.339C235.105 158.339 234.512 158.932 234.512 159.664C234.512 160.397 235.105 160.99 235.837 160.99Z" fill="currentColor"/>
            <path d="M255.322 154.953C256.039 154.953 256.621 154.371 256.621 153.654C256.621 152.937 256.039 152.355 255.322 152.355C254.605 152.355 254.023 152.937 254.023 153.654C254.023 154.371 254.605 154.953 255.322 154.953Z" fill="currentColor"/>
            <path d="M275.486 151.914C276.203 151.914 276.785 151.332 276.785 150.615C276.785 149.898 276.203 149.316 275.486 149.316C274.769 149.316 274.188 149.898 274.188 150.615C274.188 151.332 274.769 151.914 275.486 151.914Z" fill="currentColor"/>
            <path d="M295.873 151.914C296.59 151.914 297.172 151.332 297.172 150.615C297.172 149.898 296.59 149.316 295.873 149.316C295.156 149.316 294.574 149.898 294.574 150.615C294.574 151.332 295.156 151.914 295.873 151.914Z" fill="currentColor"/>
            <path d="M316.037 154.953C316.754 154.953 317.336 154.371 317.336 153.654C317.336 152.937 316.754 152.355 316.037 152.355C315.32 152.355 314.738 152.937 314.738 153.654C314.738 154.371 315.32 154.953 316.037 154.953Z" fill="currentColor"/>
            <path d="M335.521 160.963C336.239 160.963 336.82 160.381 336.82 159.664C336.82 158.947 336.239 158.365 335.521 158.365C334.804 158.365 334.223 158.947 334.223 159.664C334.223 160.381 334.804 160.963 335.521 160.963Z" fill="currentColor"/>
            <path d="M353.892 169.837C354.624 169.837 355.218 169.243 355.218 168.511C355.218 167.779 354.624 167.186 353.892 167.186C353.16 167.186 352.566 167.779 352.566 168.511C352.566 169.243 353.16 169.837 353.892 169.837Z" fill="currentColor"/>
            <path d="M370.74 181.323C371.472 181.323 372.065 180.73 372.065 179.998C372.065 179.265 371.472 178.672 370.74 178.672C370.008 178.672 369.414 179.265 369.414 179.998C369.414 180.73 370.008 181.323 370.74 181.323Z" fill="currentColor"/>
            <path d="M385.689 195.192C386.421 195.192 387.014 194.599 387.014 193.867C387.014 193.135 386.421 192.541 385.689 192.541C384.957 192.541 384.363 193.135 384.363 193.867C384.363 194.599 384.957 195.192 385.689 195.192Z" fill="currentColor"/>
            <path d="M398.4 211.107C399.118 211.107 399.699 210.526 399.699 209.808C399.699 209.091 399.118 208.51 398.4 208.51C397.683 208.51 397.102 209.091 397.102 209.808C397.102 210.526 397.683 211.107 398.4 211.107Z" fill="currentColor"/>
            <path d="M408.596 228.765C409.313 228.765 409.894 228.184 409.894 227.467C409.894 226.749 409.313 226.168 408.596 226.168C407.878 226.168 407.297 226.749 407.297 227.467C407.297 228.184 407.878 228.765 408.596 228.765Z" fill="currentColor"/>
            <path d="M416.045 247.747C416.762 247.747 417.344 247.165 417.344 246.448C417.344 245.731 416.762 245.149 416.045 245.149C415.328 245.149 414.746 245.731 414.746 246.448C414.746 247.165 415.328 247.747 416.045 247.747Z" fill="currentColor"/>
            <path d="M420.583 267.653C421.316 267.653 421.909 267.06 421.909 266.328C421.909 265.595 421.316 265.002 420.583 265.002C419.851 265.002 419.258 265.595 419.258 266.328C419.258 267.06 419.851 267.653 420.583 267.653Z" fill="currentColor"/>
            <path d="M422.107 287.986C422.839 287.986 423.432 287.393 423.432 286.661C423.432 285.928 422.839 285.335 422.107 285.335C421.375 285.335 420.781 285.928 420.781 286.661C420.781 287.393 421.375 287.986 422.107 287.986Z" fill="currentColor"/>
            <path d="M420.583 308.32C421.316 308.32 421.909 307.727 421.909 306.995C421.909 306.262 421.316 305.669 420.583 305.669C419.851 305.669 419.258 306.262 419.258 306.995C419.258 307.727 419.851 308.32 420.583 308.32Z" fill="currentColor"/>
            <path d="M416.045 328.173C416.762 328.173 417.344 327.591 417.344 326.874C417.344 326.157 416.762 325.575 416.045 325.575C415.328 325.575 414.746 326.157 414.746 326.874C414.746 327.591 415.328 328.173 416.045 328.173Z" fill="currentColor"/>
            <path d="M408.596 347.153C409.313 347.153 409.894 346.572 409.894 345.854C409.894 345.137 409.313 344.556 408.596 344.556C407.878 344.556 407.297 345.137 407.297 345.854C407.297 346.572 407.878 347.153 408.596 347.153Z" fill="currentColor"/>
            <path d="M398.4 364.812C399.118 364.812 399.699 364.231 399.699 363.513C399.699 362.796 399.118 362.215 398.4 362.215C397.683 362.215 397.102 362.796 397.102 363.513C397.102 364.231 397.683 364.812 398.4 364.812Z" fill="currentColor"/>
            <path d="M385.689 380.755C386.407 380.755 386.988 380.173 386.988 379.456C386.988 378.739 386.407 378.157 385.689 378.157C384.972 378.157 384.391 378.739 384.391 379.456C384.391 380.173 384.972 380.755 385.689 380.755Z" fill="currentColor"/>
            <path d="M370.74 394.649C371.472 394.649 372.065 394.056 372.065 393.324C372.065 392.592 371.472 391.998 370.74 391.998C370.008 391.998 369.414 392.592 369.414 393.324C369.414 394.056 370.008 394.649 370.74 394.649Z" fill="currentColor"/>
            <path d="M353.892 406.137C354.624 406.137 355.218 405.543 355.218 404.811C355.218 404.079 354.624 403.485 353.892 403.485C353.16 403.485 352.566 404.079 352.566 404.811C352.566 405.543 353.16 406.137 353.892 406.137Z" fill="currentColor"/>
            <path d="M335.521 414.983C336.253 414.983 336.847 414.39 336.847 413.658C336.847 412.926 336.253 412.332 335.521 412.332C334.789 412.332 334.195 412.926 334.195 413.658C334.195 414.39 334.789 414.983 335.521 414.983Z" fill="currentColor"/>
            <path d="M316.037 420.967C316.754 420.967 317.336 420.385 317.336 419.668C317.336 418.951 316.754 418.369 316.037 418.369C315.32 418.369 314.738 418.951 314.738 419.668C314.738 420.385 315.32 420.967 316.037 420.967Z" fill="currentColor"/>
            <path d="M295.873 424.006C296.59 424.006 297.172 423.424 297.172 422.707C297.172 421.99 296.59 421.408 295.873 421.408C295.156 421.408 294.574 421.99 294.574 422.707C294.574 423.424 295.156 424.006 295.873 424.006Z" fill="currentColor"/>
            <path d="M275.486 424.033C276.218 424.033 276.811 423.44 276.811 422.707C276.811 421.975 276.218 421.382 275.486 421.382C274.754 421.382 274.16 421.975 274.16 422.707C274.16 423.44 274.754 424.033 275.486 424.033Z" fill="currentColor"/>
            <path d="M255.322 420.967C256.039 420.967 256.621 420.385 256.621 419.668C256.621 418.951 256.039 418.369 255.322 418.369C254.605 418.369 254.023 418.951 254.023 419.668C254.023 420.385 254.605 420.967 255.322 420.967Z" fill="currentColor"/>
            <path d="M235.838 414.957C236.555 414.957 237.136 414.375 237.136 413.658C237.136 412.941 236.555 412.359 235.838 412.359C235.12 412.359 234.539 412.941 234.539 413.658C234.539 414.375 235.12 414.957 235.838 414.957Z" fill="currentColor"/>
            <path d="M217.466 406.137C218.198 406.137 218.792 405.543 218.792 404.811C218.792 404.079 218.198 403.485 217.466 403.485C216.734 403.485 216.141 404.079 216.141 404.811C216.141 405.543 216.734 406.137 217.466 406.137Z" fill="currentColor"/>
            <path d="M200.619 394.623C201.336 394.623 201.918 394.041 201.918 393.324C201.918 392.607 201.336 392.025 200.619 392.025C199.902 392.025 199.32 392.607 199.32 393.324C199.32 394.041 199.902 394.623 200.619 394.623Z" fill="currentColor"/>
            <path d="M185.669 380.781C186.401 380.781 186.995 380.188 186.995 379.455C186.995 378.723 186.401 378.13 185.669 378.13C184.937 378.13 184.344 378.723 184.344 379.455C184.344 380.188 184.937 380.781 185.669 380.781Z" fill="currentColor"/>
            <path d="M172.959 364.812C173.676 364.812 174.258 364.231 174.258 363.513C174.258 362.796 173.676 362.215 172.959 362.215C172.242 362.215 171.66 362.796 171.66 363.513C171.66 364.231 172.242 364.812 172.959 364.812Z" fill="currentColor"/>
            <path d="M162.764 347.153C163.481 347.153 164.062 346.572 164.062 345.854C164.062 345.137 163.481 344.556 162.764 344.556C162.046 344.556 161.465 345.137 161.465 345.854C161.465 346.572 162.046 347.153 162.764 347.153Z" fill="currentColor"/>
            <path d="M155.314 328.173C156.032 328.173 156.613 327.591 156.613 326.874C156.613 326.157 156.032 325.575 155.314 325.575C154.597 325.575 154.016 326.157 154.016 326.874C154.016 327.591 154.597 328.173 155.314 328.173Z" fill="currentColor"/>
            <path d="M150.775 308.294C151.493 308.294 152.074 307.712 152.074 306.995C152.074 306.278 151.493 305.696 150.775 305.696C150.058 305.696 149.477 306.278 149.477 306.995C149.477 307.712 150.058 308.294 150.775 308.294Z" fill="currentColor"/>
            <path d="M441.596 288.202C442.447 288.202 443.137 287.512 443.137 286.661C443.137 285.81 442.447 285.12 441.596 285.12C440.745 285.12 440.055 285.81 440.055 286.661C440.055 287.512 440.745 288.202 441.596 288.202Z" fill="currentColor"/>
            <path d="M440.263 308.58C441.129 308.58 441.831 307.878 441.831 307.012C441.831 306.146 441.129 305.444 440.263 305.444C439.397 305.444 438.695 306.146 438.695 307.012C438.695 307.878 439.397 308.58 440.263 308.58Z" fill="currentColor"/>
            <path d="M436.285 328.616C437.169 328.616 437.886 327.899 437.886 327.015C437.886 326.131 437.169 325.414 436.285 325.414C435.4 325.414 434.684 326.131 434.684 327.015C434.684 327.899 435.4 328.616 436.285 328.616Z" fill="currentColor"/>
            <path d="M429.728 347.895C430.594 347.895 431.296 347.194 431.296 346.328C431.296 345.462 430.594 344.76 429.728 344.76C428.862 344.76 428.16 345.462 428.16 346.328C428.16 347.194 428.862 347.895 429.728 347.895Z" fill="currentColor"/>
            <path d="M420.709 366.161C421.56 366.161 422.25 365.471 422.25 364.62C422.25 363.769 421.56 363.079 420.709 363.079C419.858 363.079 419.168 363.769 419.168 364.62C419.168 365.471 419.858 366.161 420.709 366.161Z" fill="currentColor"/>
            <path d="M409.376 383.145C410.242 383.145 410.944 382.443 410.944 381.578C410.944 380.712 410.242 380.01 409.376 380.01C408.511 380.01 407.809 380.712 407.809 381.578C407.809 382.443 408.511 383.145 409.376 383.145Z" fill="currentColor"/>
            <path d="M395.929 398.513C396.813 398.513 397.53 397.796 397.53 396.912C397.53 396.027 396.813 395.311 395.929 395.311C395.045 395.311 394.328 396.027 394.328 396.912C394.328 397.796 395.045 398.513 395.929 398.513Z" fill="currentColor"/>
            <path d="M380.596 411.899C381.447 411.899 382.137 411.209 382.137 410.358C382.137 409.507 381.447 408.817 380.596 408.817C379.745 408.817 379.055 409.507 379.055 410.358C379.055 411.209 379.745 411.899 380.596 411.899Z" fill="currentColor"/>
            <path d="M363.638 423.257C364.504 423.257 365.206 422.555 365.206 421.689C365.206 420.823 364.504 420.121 363.638 420.121C362.772 420.121 362.07 420.823 362.07 421.689C362.07 422.555 362.772 423.257 363.638 423.257Z" fill="currentColor"/>
            <path d="M345.346 432.251C346.197 432.251 346.887 431.561 346.887 430.71C346.887 429.859 346.197 429.169 345.346 429.169C344.495 429.169 343.805 429.859 343.805 430.71C343.805 431.561 344.495 432.251 345.346 432.251Z" fill="currentColor"/>
            <path d="M326.033 438.833C326.899 438.833 327.601 438.131 327.601 437.265C327.601 436.399 326.899 435.697 326.033 435.697C325.167 435.697 324.465 436.399 324.465 437.265C324.465 438.131 325.167 438.833 326.033 438.833Z" fill="currentColor"/>
            <path d="M306.031 442.846C306.915 442.846 307.632 442.129 307.632 441.245C307.632 440.36 306.915 439.644 306.031 439.644C305.147 439.644 304.43 440.36 304.43 441.245C304.43 442.129 305.147 442.846 306.031 442.846Z" fill="currentColor"/>
            <path d="M285.678 444.119C286.529 444.119 287.219 443.429 287.219 442.578C287.219 441.727 286.529 441.037 285.678 441.037C284.827 441.037 284.137 441.727 284.137 442.578C284.137 443.429 284.827 444.119 285.678 444.119Z" fill="currentColor"/>
            <path d="M265.33 442.812C266.195 442.812 266.897 442.111 266.897 441.245C266.897 440.379 266.195 439.677 265.33 439.677C264.464 439.677 263.762 440.379 263.762 441.245C263.762 442.111 264.464 442.812 265.33 442.812Z" fill="currentColor"/>
            <path d="M245.326 438.833C246.192 438.833 246.894 438.131 246.894 437.265C246.894 436.399 246.192 435.697 245.326 435.697C244.46 435.697 243.758 436.399 243.758 437.265C243.758 438.131 244.46 438.833 245.326 438.833Z" fill="currentColor"/>
            <path d="M226.014 432.251C226.865 432.251 227.555 431.561 227.555 430.71C227.555 429.859 226.865 429.169 226.014 429.169C225.163 429.169 224.473 429.859 224.473 430.71C224.473 431.561 225.163 432.251 226.014 432.251Z" fill="currentColor"/>
            <path d="M207.721 423.23C208.572 423.23 209.262 422.54 209.262 421.689C209.262 420.838 208.572 420.148 207.721 420.148C206.87 420.148 206.18 420.838 206.18 421.689C206.18 422.54 206.87 423.23 207.721 423.23Z" fill="currentColor"/>
            <path d="M190.763 411.927C191.629 411.927 192.331 411.225 192.331 410.359C192.331 409.493 191.629 408.791 190.763 408.791C189.897 408.791 189.195 409.493 189.195 410.359C189.195 411.225 189.897 411.927 190.763 411.927Z" fill="currentColor"/>
            <path d="M175.429 398.513C176.313 398.513 177.03 397.796 177.03 396.912C177.03 396.027 176.313 395.311 175.429 395.311C174.545 395.311 173.828 396.027 173.828 396.912C173.828 397.796 174.545 398.513 175.429 398.513Z" fill="currentColor"/>
            <path d="M161.982 383.145C162.848 383.145 163.55 382.443 163.55 381.578C163.55 380.712 162.848 380.01 161.982 380.01C161.116 380.01 160.414 380.712 160.414 381.578C160.414 382.443 161.116 383.145 161.982 383.145Z" fill="currentColor"/>
            <path d="M150.65 366.187C151.516 366.187 152.218 365.486 152.218 364.62C152.218 363.754 151.516 363.052 150.65 363.052C149.784 363.052 149.082 363.754 149.082 364.62C149.082 365.486 149.784 366.187 150.65 366.187Z" fill="currentColor"/>
            <path d="M141.63 347.895C142.496 347.895 143.198 347.194 143.198 346.328C143.198 345.462 142.496 344.76 141.63 344.76C140.764 344.76 140.062 345.462 140.062 346.328C140.062 347.194 140.764 347.895 141.63 347.895Z" fill="currentColor"/>
            <path d="M135.076 328.557C135.927 328.557 136.617 327.867 136.617 327.016C136.617 326.165 135.927 325.475 135.076 325.475C134.225 325.475 133.535 326.165 133.535 327.016C133.535 327.867 134.225 328.557 135.076 328.557Z" fill="currentColor"/>
            <path d="M131.096 308.554C131.947 308.554 132.637 307.864 132.637 307.013C132.637 306.162 131.947 305.472 131.096 305.472C130.245 305.472 129.555 306.162 129.555 307.013C129.555 307.864 130.245 308.554 131.096 308.554Z" fill="currentColor"/>
            <path d="M129.764 288.202C130.615 288.202 131.305 287.512 131.305 286.661C131.305 285.81 130.615 285.12 129.764 285.12C128.913 285.12 128.223 285.81 128.223 286.661C128.223 287.512 128.913 288.202 129.764 288.202Z" fill="currentColor"/>
            <path d="M131.096 267.85C131.947 267.85 132.637 267.161 132.637 266.309C132.637 265.458 131.947 264.769 131.096 264.769C130.245 264.769 129.555 265.458 129.555 266.309C129.555 267.161 130.245 267.85 131.096 267.85Z" fill="currentColor"/>
            <path d="M135.076 247.874C135.942 247.874 136.644 247.172 136.644 246.306C136.644 245.44 135.942 244.738 135.076 244.738C134.21 244.738 133.508 245.44 133.508 246.306C133.508 247.172 134.21 247.874 135.076 247.874Z" fill="currentColor"/>
            <path d="M141.63 228.562C142.496 228.562 143.198 227.86 143.198 226.994C143.198 226.128 142.496 225.426 141.63 225.426C140.764 225.426 140.062 226.128 140.062 226.994C140.062 227.86 140.764 228.562 141.63 228.562Z" fill="currentColor"/>
            <path d="M150.652 210.304C151.536 210.304 152.253 209.587 152.253 208.703C152.253 207.818 151.536 207.102 150.652 207.102C149.768 207.102 149.051 207.818 149.051 208.703C149.051 209.587 149.768 210.304 150.652 210.304Z" fill="currentColor"/>
            <path d="M161.982 193.313C162.848 193.313 163.55 192.611 163.55 191.745C163.55 190.879 162.848 190.177 161.982 190.177C161.116 190.177 160.414 190.879 160.414 191.745C160.414 192.611 161.116 193.313 161.982 193.313Z" fill="currentColor"/>
            <path d="M175.429 178.012C176.313 178.012 177.03 177.295 177.03 176.411C177.03 175.526 176.313 174.81 175.429 174.81C174.545 174.81 173.828 175.526 173.828 176.411C173.828 177.295 174.545 178.012 175.429 178.012Z" fill="currentColor"/>
            <path d="M190.765 164.564C191.649 164.564 192.366 163.848 192.366 162.963C192.366 162.079 191.649 161.362 190.765 161.362C189.881 161.362 189.164 162.079 189.164 162.963C189.164 163.848 189.881 164.564 190.765 164.564Z" fill="currentColor"/>
            <path d="M207.72 153.201C208.586 153.201 209.288 152.499 209.288 151.633C209.288 150.767 208.586 150.065 207.72 150.065C206.854 150.065 206.152 150.767 206.152 151.633C206.152 152.499 206.854 153.201 207.72 153.201Z" fill="currentColor"/>
            <path d="M226.014 144.153C226.865 144.153 227.555 143.463 227.555 142.612C227.555 141.761 226.865 141.071 226.014 141.071C225.163 141.071 224.473 141.761 224.473 142.612C224.473 143.463 225.163 144.153 226.014 144.153Z" fill="currentColor"/>
            <path d="M245.326 137.598C246.177 137.598 246.867 136.908 246.867 136.057C246.867 135.206 246.177 134.516 245.326 134.516C244.475 134.516 243.785 135.206 243.785 136.057C243.785 136.908 244.475 137.598 245.326 137.598Z" fill="currentColor"/>
            <path d="M265.33 133.618C266.181 133.618 266.871 132.928 266.871 132.077C266.871 131.226 266.181 130.536 265.33 130.536C264.479 130.536 263.789 131.226 263.789 132.077C263.789 132.928 264.479 133.618 265.33 133.618Z" fill="currentColor"/>
            <path d="M285.678 132.284C286.529 132.284 287.219 131.594 287.219 130.743C287.219 129.892 286.529 129.202 285.678 129.202C284.827 129.202 284.137 129.892 284.137 130.743C284.137 131.594 284.827 132.284 285.678 132.284Z" fill="currentColor"/>
            <path d="M306.033 133.646C306.899 133.646 307.601 132.944 307.601 132.078C307.601 131.212 306.899 130.51 306.033 130.51C305.167 130.51 304.465 131.212 304.465 132.078C304.465 132.944 305.167 133.646 306.033 133.646Z" fill="currentColor"/>
            <path d="M326.033 137.624C326.899 137.624 327.601 136.922 327.601 136.056C327.601 135.19 326.899 134.488 326.033 134.488C325.167 134.488 324.465 135.19 324.465 136.056C324.465 136.922 325.167 137.624 326.033 137.624Z" fill="currentColor"/>
            <path d="M345.345 144.18C346.211 144.18 346.913 143.478 346.913 142.612C346.913 141.746 346.211 141.044 345.345 141.044C344.479 141.044 343.777 141.746 343.777 142.612C343.777 143.478 344.479 144.18 345.345 144.18Z" fill="currentColor"/>
            <path d="M363.639 153.174C364.49 153.174 365.18 152.484 365.18 151.633C365.18 150.782 364.49 150.092 363.639 150.092C362.788 150.092 362.098 150.782 362.098 151.633C362.098 152.484 362.788 153.174 363.639 153.174Z" fill="currentColor"/>
            <path d="M380.597 164.564C381.481 164.564 382.198 163.848 382.198 162.963C382.198 162.079 381.481 161.362 380.597 161.362C379.713 161.362 378.996 162.079 378.996 162.963C378.996 163.848 379.713 164.564 380.597 164.564Z" fill="currentColor"/>
            <path d="M395.928 177.952C396.779 177.952 397.469 177.262 397.469 176.411C397.469 175.56 396.779 174.87 395.928 174.87C395.077 174.87 394.387 175.56 394.387 176.411C394.387 177.262 395.077 177.952 395.928 177.952Z" fill="currentColor"/>
            <path d="M409.376 193.313C410.242 193.313 410.944 192.611 410.944 191.745C410.944 190.879 410.242 190.177 409.376 190.177C408.511 190.177 407.809 190.879 407.809 191.745C407.809 192.611 408.511 193.313 409.376 193.313Z" fill="currentColor"/>
            <path d="M420.709 210.243C421.56 210.243 422.25 209.553 422.25 208.702C422.25 207.851 421.56 207.161 420.709 207.161C419.858 207.161 419.168 207.851 419.168 208.702C419.168 209.553 419.858 210.243 420.709 210.243Z" fill="currentColor"/>
            <path d="M429.728 228.535C430.58 228.535 431.269 227.845 431.269 226.994C431.269 226.143 430.58 225.453 429.728 225.453C428.877 225.453 428.188 226.143 428.188 226.994C428.188 227.845 428.877 228.535 429.728 228.535Z" fill="currentColor"/>
            <path d="M436.283 247.848C437.134 247.848 437.824 247.158 437.824 246.307C437.824 245.456 437.134 244.766 436.283 244.766C435.432 244.766 434.742 245.456 434.742 246.307C434.742 247.158 435.432 247.848 436.283 247.848Z" fill="currentColor"/>
            <path d="M440.261 267.911C441.145 267.911 441.862 267.194 441.862 266.31C441.862 265.426 441.145 264.709 440.261 264.709C439.377 264.709 438.66 265.426 438.66 266.31C438.66 267.194 439.377 267.911 440.261 267.911Z" fill="currentColor"/>
            <path d="M110.274 288.505C111.292 288.505 112.118 287.679 112.118 286.661C112.118 285.642 111.292 284.816 110.274 284.816C109.255 284.816 108.43 285.642 108.43 286.661C108.43 287.679 109.255 288.505 110.274 288.505Z" fill="currentColor"/>
            <path d="M111.459 268.081C112.444 268.081 113.242 267.283 113.242 266.298C113.242 265.313 112.444 264.515 111.459 264.515C110.474 264.515 109.676 265.313 109.676 266.298C109.676 267.283 110.474 268.081 111.459 268.081Z" fill="currentColor"/>
            <path d="M115.002 247.993C115.987 247.993 116.785 247.195 116.785 246.21C116.785 245.225 115.987 244.427 115.002 244.427C114.017 244.427 113.219 245.225 113.219 246.21C113.219 247.195 114.017 247.993 115.002 247.993Z" fill="currentColor"/>
            <path d="M120.85 228.451C121.834 228.451 122.633 227.653 122.633 226.668C122.633 225.683 121.834 224.885 120.85 224.885C119.865 224.885 119.066 225.683 119.066 226.668C119.066 227.653 119.865 228.451 120.85 228.451Z" fill="currentColor"/>
            <path d="M128.932 209.722C129.916 209.722 130.715 208.923 130.715 207.938C130.715 206.954 129.916 206.155 128.932 206.155C127.947 206.155 127.148 206.954 127.148 207.938C127.148 208.923 127.947 209.722 128.932 209.722Z" fill="currentColor"/>
            <path d="M139.127 192.057C140.112 192.057 140.91 191.258 140.91 190.273C140.91 189.289 140.112 188.49 139.127 188.49C138.142 188.49 137.344 189.289 137.344 190.273C137.344 191.258 138.142 192.057 139.127 192.057Z" fill="currentColor"/>
            <path d="M151.311 175.695C152.295 175.695 153.094 174.897 153.094 173.912C153.094 172.927 152.295 172.129 151.311 172.129C150.326 172.129 149.527 172.927 149.527 173.912C149.527 174.897 150.326 175.695 151.311 175.695Z" fill="currentColor"/>
            <path d="M165.306 160.885C166.306 160.885 167.116 160.074 167.116 159.075C167.116 158.075 166.306 157.265 165.306 157.265C164.307 157.265 163.496 158.075 163.496 159.075C163.496 160.074 164.307 160.885 165.306 160.885Z" fill="currentColor"/>
            <path d="M180.935 147.774C181.935 147.774 182.745 146.963 182.745 145.963C182.745 144.964 181.935 144.153 180.935 144.153C179.935 144.153 179.125 144.964 179.125 145.963C179.125 146.963 179.935 147.774 180.935 147.774Z" fill="currentColor"/>
            <path d="M197.975 136.537C198.959 136.537 199.758 135.739 199.758 134.754C199.758 133.769 198.959 132.971 197.975 132.971C196.99 132.971 196.191 133.769 196.191 134.754C196.191 135.739 196.99 136.537 197.975 136.537Z" fill="currentColor"/>
            <path d="M216.205 127.41C217.204 127.41 218.015 126.6 218.015 125.6C218.015 124.6 217.204 123.79 216.205 123.79C215.205 123.79 214.395 124.6 214.395 125.6C214.395 126.6 215.205 127.41 216.205 127.41Z" fill="currentColor"/>
            <path d="M235.373 120.433C236.372 120.433 237.183 119.622 237.183 118.623C237.183 117.623 236.372 116.812 235.373 116.812C234.373 116.812 233.562 117.623 233.562 118.623C233.562 119.622 234.373 120.433 235.373 120.433Z" fill="currentColor"/>
            <path d="M255.221 115.702C256.206 115.702 257.004 114.904 257.004 113.919C257.004 112.934 256.206 112.136 255.221 112.136C254.236 112.136 253.438 112.934 253.438 113.919C253.438 114.904 254.236 115.702 255.221 115.702Z" fill="currentColor"/>
            <path d="M275.482 113.334C276.467 113.334 277.266 112.536 277.266 111.551C277.266 110.566 276.467 109.768 275.482 109.768C274.498 109.768 273.699 110.566 273.699 111.551C273.699 112.536 274.498 113.334 275.482 113.334Z" fill="currentColor"/>
            <path d="M295.877 113.334C296.862 113.334 297.66 112.536 297.66 111.551C297.66 110.566 296.862 109.768 295.877 109.768C294.892 109.768 294.094 110.566 294.094 111.551C294.094 112.536 294.892 113.334 295.877 113.334Z" fill="currentColor"/>
            <path d="M316.138 115.73C317.138 115.73 317.948 114.919 317.948 113.919C317.948 112.92 317.138 112.109 316.138 112.109C315.139 112.109 314.328 112.92 314.328 113.919C314.328 114.919 315.139 115.73 316.138 115.73Z" fill="currentColor"/>
            <path d="M335.989 120.468C337.007 120.468 337.833 119.642 337.833 118.624C337.833 117.605 337.007 116.779 335.989 116.779C334.97 116.779 334.145 117.605 334.145 118.624C334.145 119.642 334.97 120.468 335.989 120.468Z" fill="currentColor"/>
            <path d="M355.154 127.41C356.154 127.41 356.964 126.6 356.964 125.6C356.964 124.6 356.154 123.79 355.154 123.79C354.154 123.79 353.344 124.6 353.344 125.6C353.344 126.6 354.154 127.41 355.154 127.41Z" fill="currentColor"/>
            <path d="M373.384 136.565C374.384 136.565 375.194 135.754 375.194 134.754C375.194 133.755 374.384 132.944 373.384 132.944C372.385 132.944 371.574 133.755 371.574 134.754C371.574 135.754 372.385 136.565 373.384 136.565Z" fill="currentColor"/>
            <path d="M390.424 147.746C391.409 147.746 392.207 146.948 392.207 145.963C392.207 144.978 391.409 144.18 390.424 144.18C389.439 144.18 388.641 144.978 388.641 145.963C388.641 146.948 389.439 147.746 390.424 147.746Z" fill="currentColor"/>
            <path d="M406.052 160.885C407.052 160.885 407.862 160.074 407.862 159.075C407.862 158.075 407.052 157.265 406.052 157.265C405.053 157.265 404.242 158.075 404.242 159.075C404.242 160.074 405.053 160.885 406.052 160.885Z" fill="currentColor"/>
            <path d="M420.049 175.695C421.034 175.695 421.832 174.897 421.832 173.912C421.832 172.927 421.034 172.129 420.049 172.129C419.064 172.129 418.266 172.927 418.266 173.912C418.266 174.897 419.064 175.695 420.049 175.695Z" fill="currentColor"/>
            <path d="M432.228 192.083C433.228 192.083 434.038 191.273 434.038 190.273C434.038 189.273 433.228 188.463 432.228 188.463C431.228 188.463 430.418 189.273 430.418 190.273C430.418 191.273 431.228 192.083 432.228 192.083Z" fill="currentColor"/>
            <path d="M442.427 209.749C443.427 209.749 444.237 208.939 444.237 207.939C444.237 206.939 443.427 206.129 442.427 206.129C441.428 206.129 440.617 206.939 440.617 207.939C440.617 208.939 441.428 209.749 442.427 209.749Z" fill="currentColor"/>
            <path d="M450.509 228.479C451.509 228.479 452.319 227.668 452.319 226.669C452.319 225.669 451.509 224.858 450.509 224.858C449.51 224.858 448.699 225.669 448.699 226.669C448.699 227.668 449.51 228.479 450.509 228.479Z" fill="currentColor"/>
            <path d="M456.36 248.054C457.378 248.054 458.204 247.228 458.204 246.209C458.204 245.191 457.378 244.365 456.36 244.365C455.341 244.365 454.516 245.191 454.516 246.209C454.516 247.228 455.341 248.054 456.36 248.054Z" fill="currentColor"/>
            <path d="M459.9 268.081C460.885 268.081 461.684 267.283 461.684 266.298C461.684 265.313 460.885 264.515 459.9 264.515C458.916 264.515 458.117 265.313 458.117 266.298C458.117 267.283 458.916 268.081 459.9 268.081Z" fill="currentColor"/>
            <path d="M461.087 288.471C462.087 288.471 462.898 287.66 462.898 286.661C462.898 285.661 462.087 284.851 461.087 284.851C460.088 284.851 459.277 285.661 459.277 286.661C459.277 287.66 460.088 288.471 461.087 288.471Z" fill="currentColor"/>
            <path d="M459.899 308.869C460.917 308.869 461.743 308.043 461.743 307.025C461.743 306.006 460.917 305.181 459.899 305.181C458.88 305.181 458.055 306.006 458.055 307.025C458.055 308.043 458.88 308.869 459.899 308.869Z" fill="currentColor"/>
            <path d="M456.357 328.923C457.357 328.923 458.167 328.113 458.167 327.113C458.167 326.113 457.357 325.303 456.357 325.303C455.357 325.303 454.547 326.113 454.547 327.113C454.547 328.113 455.357 328.923 456.357 328.923Z" fill="currentColor"/>
            <path d="M450.509 348.464C451.509 348.464 452.319 347.654 452.319 346.654C452.319 345.654 451.509 344.844 450.509 344.844C449.51 344.844 448.699 345.654 448.699 346.654C448.699 347.654 449.51 348.464 450.509 348.464Z" fill="currentColor"/>
            <path d="M442.427 367.193C443.427 367.193 444.237 366.383 444.237 365.383C444.237 364.384 443.427 363.573 442.427 363.573C441.428 363.573 440.617 364.384 440.617 365.383C440.617 366.383 441.428 367.193 442.427 367.193Z" fill="currentColor"/>
            <path d="M432.229 384.832C433.213 384.832 434.012 384.034 434.012 383.049C434.012 382.064 433.213 381.266 432.229 381.266C431.244 381.266 430.445 382.064 430.445 383.049C430.445 384.034 431.244 384.832 432.229 384.832Z" fill="currentColor"/>
            <path d="M420.047 401.255C421.066 401.255 421.892 400.429 421.892 399.411C421.892 398.392 421.066 397.566 420.047 397.566C419.029 397.566 418.203 398.392 418.203 399.411C418.203 400.429 419.029 401.255 420.047 401.255Z" fill="currentColor"/>
            <path d="M406.052 416.058C407.052 416.058 407.862 415.247 407.862 414.248C407.862 413.248 407.052 412.438 406.052 412.438C405.053 412.438 404.242 413.248 404.242 414.248C404.242 415.247 405.053 416.058 406.052 416.058Z" fill="currentColor"/>
            <path d="M390.424 429.143C391.409 429.143 392.207 428.344 392.207 427.359C392.207 426.374 391.409 425.576 390.424 425.576C389.439 425.576 388.641 426.374 388.641 427.359C388.641 428.344 389.439 429.143 390.424 429.143Z" fill="currentColor"/>
            <path d="M373.385 440.351C374.37 440.351 375.168 439.552 375.168 438.567C375.168 437.583 374.37 436.784 373.385 436.784C372.4 436.784 371.602 437.583 371.602 438.567C371.602 439.552 372.4 440.351 373.385 440.351Z" fill="currentColor"/>
            <path d="M355.154 449.532C356.154 449.532 356.964 448.722 356.964 447.722C356.964 446.722 356.154 445.912 355.154 445.912C354.154 445.912 353.344 446.722 353.344 447.722C353.344 448.722 354.154 449.532 355.154 449.532Z" fill="currentColor"/>
            <path d="M335.986 456.509C336.986 456.509 337.796 455.699 337.796 454.699C337.796 453.699 336.986 452.889 335.986 452.889C334.986 452.889 334.176 453.699 334.176 454.699C334.176 455.699 334.986 456.509 335.986 456.509Z" fill="currentColor"/>
            <path d="M316.138 461.213C317.138 461.213 317.948 460.403 317.948 459.403C317.948 458.403 317.138 457.593 316.138 457.593C315.139 457.593 314.328 458.403 314.328 459.403C314.328 460.403 315.139 461.213 316.138 461.213Z" fill="currentColor"/>
            <path d="M295.877 463.555C296.862 463.555 297.66 462.756 297.66 461.771C297.66 460.787 296.862 459.988 295.877 459.988C294.892 459.988 294.094 460.787 294.094 461.771C294.094 462.756 294.892 463.555 295.877 463.555Z" fill="currentColor"/>
            <path d="M275.482 463.581C276.482 463.581 277.292 462.771 277.292 461.771C277.292 460.771 276.482 459.961 275.482 459.961C274.482 459.961 273.672 460.771 273.672 461.771C273.672 462.771 274.482 463.581 275.482 463.581Z" fill="currentColor"/>
            <path d="M255.219 461.247C256.238 461.247 257.064 460.421 257.064 459.403C257.064 458.384 256.238 457.559 255.219 457.559C254.201 457.559 253.375 458.384 253.375 459.403C253.375 460.421 254.201 461.247 255.219 461.247Z" fill="currentColor"/>
            <path d="M235.373 456.509C236.372 456.509 237.183 455.699 237.183 454.699C237.183 453.699 236.372 452.889 235.373 452.889C234.373 452.889 233.562 453.699 233.562 454.699C233.562 455.699 234.373 456.509 235.373 456.509Z" fill="currentColor"/>
            <path d="M216.205 449.532C217.204 449.532 218.015 448.722 218.015 447.722C218.015 446.722 217.204 445.912 216.205 445.912C215.205 445.912 214.395 446.722 214.395 447.722C214.395 448.722 215.205 449.532 216.205 449.532Z" fill="currentColor"/>
            <path d="M197.975 440.351C198.959 440.351 199.758 439.552 199.758 438.567C199.758 437.583 198.959 436.784 197.975 436.784C196.99 436.784 196.191 437.583 196.191 438.567C196.191 439.552 196.99 440.351 197.975 440.351Z" fill="currentColor"/>
            <path d="M180.935 429.169C181.935 429.169 182.745 428.359 182.745 427.359C182.745 426.359 181.935 425.549 180.935 425.549C179.935 425.549 179.125 426.359 179.125 427.359C179.125 428.359 179.935 429.169 180.935 429.169Z" fill="currentColor"/>
            <path d="M165.309 416.092C166.328 416.092 167.153 415.266 167.153 414.248C167.153 413.229 166.328 412.403 165.309 412.403C164.291 412.403 163.465 413.229 163.465 414.248C163.465 415.266 164.291 416.092 165.309 416.092Z" fill="currentColor"/>
            <path d="M151.311 401.193C152.295 401.193 153.094 400.395 153.094 399.41C153.094 398.425 152.295 397.627 151.311 397.627C150.326 397.627 149.527 398.425 149.527 399.41C149.527 400.395 150.326 401.193 151.311 401.193Z" fill="currentColor"/>
            <path d="M139.127 384.832C140.112 384.832 140.91 384.034 140.91 383.049C140.91 382.064 140.112 381.266 139.127 381.266C138.142 381.266 137.344 382.064 137.344 383.049C137.344 384.034 138.142 384.832 139.127 384.832Z" fill="currentColor"/>
            <path d="M128.931 367.193C129.931 367.193 130.741 366.383 130.741 365.383C130.741 364.384 129.931 363.573 128.931 363.573C127.932 363.573 127.121 364.384 127.121 365.383C127.121 366.383 127.932 367.193 128.931 367.193Z" fill="currentColor"/>
            <path d="M120.85 348.436C121.834 348.436 122.633 347.638 122.633 346.653C122.633 345.669 121.834 344.87 120.85 344.87C119.865 344.87 119.066 345.669 119.066 346.653C119.066 347.638 119.865 348.436 120.85 348.436Z" fill="currentColor"/>
            <path d="M115.002 328.923C116.001 328.923 116.812 328.113 116.812 327.113C116.812 326.113 116.001 325.303 115.002 325.303C114.002 325.303 113.191 326.113 113.191 327.113C113.191 328.113 114.002 328.923 115.002 328.923Z" fill="currentColor"/>
            <path d="M111.459 308.834C112.458 308.834 113.269 308.024 113.269 307.024C113.269 306.024 112.458 305.214 111.459 305.214C110.459 305.214 109.648 306.024 109.648 307.024C109.648 308.024 110.459 308.834 111.459 308.834Z" fill="currentColor"/>
            <path d="M480.576 288.748C481.729 288.748 482.663 287.814 482.663 286.661C482.663 285.508 481.729 284.573 480.576 284.573C479.423 284.573 478.488 285.508 478.488 286.661C478.488 287.814 479.423 288.748 480.576 288.748Z" fill="currentColor"/>
            <path d="M479.51 309.059C480.628 309.059 481.535 308.152 481.535 307.033C481.535 305.915 480.628 305.008 479.51 305.008C478.391 305.008 477.484 305.915 477.484 307.033C477.484 308.152 478.391 309.059 479.51 309.059Z" fill="currentColor"/>
            <path d="M476.318 329.27C477.471 329.27 478.405 328.335 478.405 327.182C478.405 326.029 477.471 325.095 476.318 325.095C475.165 325.095 474.23 326.029 474.23 327.182C474.23 328.335 475.165 329.27 476.318 329.27Z" fill="currentColor"/>
            <path d="M471.037 348.94C472.17 348.94 473.089 348.021 473.089 346.887C473.089 345.754 472.17 344.835 471.037 344.835C469.903 344.835 468.984 345.754 468.984 346.887C468.984 348.021 469.903 348.94 471.037 348.94Z" fill="currentColor"/>
            <path d="M463.728 368.02C464.881 368.02 465.816 367.085 465.816 365.932C465.816 364.779 464.881 363.845 463.728 363.845C462.575 363.845 461.641 364.779 461.641 365.932C461.641 367.085 462.575 368.02 463.728 368.02Z" fill="currentColor"/>
            <path d="M454.466 386.162C455.6 386.162 456.519 385.243 456.519 384.11C456.519 382.977 455.6 382.058 454.466 382.058C453.333 382.058 452.414 382.977 452.414 384.11C452.414 385.243 453.333 386.162 454.466 386.162Z" fill="currentColor"/>
            <path d="M443.353 403.271C444.487 403.271 445.405 402.352 445.405 401.218C445.405 400.085 444.487 399.166 443.353 399.166C442.22 399.166 441.301 400.085 441.301 401.218C441.301 402.352 442.22 403.271 443.353 403.271Z" fill="currentColor"/>
            <path d="M430.517 419.124C431.651 419.124 432.57 418.205 432.57 417.072C432.57 415.938 431.651 415.02 430.517 415.02C429.384 415.02 428.465 415.938 428.465 417.072C428.465 418.205 429.384 419.124 430.517 419.124Z" fill="currentColor"/>
            <path d="M416.091 433.55C417.225 433.55 418.144 432.631 418.144 431.498C418.144 430.364 417.225 429.445 416.091 429.445C414.958 429.445 414.039 430.364 414.039 431.498C414.039 432.631 414.958 433.55 416.091 433.55Z" fill="currentColor"/>
            <path d="M400.236 446.388C401.369 446.388 402.288 445.469 402.288 444.336C402.288 443.202 401.369 442.283 400.236 442.283C399.102 442.283 398.184 443.202 398.184 444.336C398.184 445.469 399.102 446.388 400.236 446.388Z" fill="currentColor"/>
            <path d="M383.127 457.499C384.26 457.499 385.179 456.58 385.179 455.447C385.179 454.313 384.26 453.395 383.127 453.395C381.993 453.395 381.074 454.313 381.074 455.447C381.074 456.58 381.993 457.499 383.127 457.499Z" fill="currentColor"/>
            <path d="M364.951 466.733C366.07 466.733 366.977 465.827 366.977 464.708C366.977 463.589 366.07 462.683 364.951 462.683C363.833 462.683 362.926 463.589 362.926 464.708C362.926 465.827 363.833 466.733 364.951 466.733Z" fill="currentColor"/>
            <path d="M345.904 474.106C347.057 474.106 347.991 473.171 347.991 472.018C347.991 470.865 347.057 469.931 345.904 469.931C344.751 469.931 343.816 470.865 343.816 472.018C343.816 473.171 344.751 474.106 345.904 474.106Z" fill="currentColor"/>
            <path d="M326.201 479.324C327.32 479.324 328.227 478.417 328.227 477.299C328.227 476.18 327.32 475.273 326.201 475.273C325.083 475.273 324.176 476.18 324.176 477.299C324.176 478.417 325.083 479.324 326.201 479.324Z" fill="currentColor"/>
            <path d="M306.052 482.542C307.186 482.542 308.105 481.623 308.105 480.49C308.105 479.356 307.186 478.438 306.052 478.438C304.919 478.438 304 479.356 304 480.49C304 481.623 304.919 482.542 306.052 482.542Z" fill="currentColor"/>
            <path d="M285.677 483.61C286.811 483.61 287.73 482.691 287.73 481.557C287.73 480.424 286.811 479.505 285.677 479.505C284.544 479.505 283.625 480.424 283.625 481.557C283.625 482.691 284.544 483.61 285.677 483.61Z" fill="currentColor"/>
            <path d="M265.306 482.542C266.44 482.542 267.359 481.623 267.359 480.49C267.359 479.356 266.44 478.438 265.306 478.438C264.173 478.438 263.254 479.356 263.254 480.49C263.254 481.623 264.173 482.542 265.306 482.542Z" fill="currentColor"/>
            <path d="M245.158 479.324C246.277 479.324 247.184 478.417 247.184 477.299C247.184 476.18 246.277 475.273 245.158 475.273C244.04 475.273 243.133 476.18 243.133 477.299C243.133 478.417 244.04 479.324 245.158 479.324Z" fill="currentColor"/>
            <path d="M225.451 474.044C226.57 474.044 227.477 473.137 227.477 472.019C227.477 470.9 226.57 469.993 225.451 469.993C224.333 469.993 223.426 470.9 223.426 472.019C223.426 473.137 224.333 474.044 225.451 474.044Z" fill="currentColor"/>
            <path d="M206.408 466.76C207.541 466.76 208.46 465.841 208.46 464.708C208.46 463.574 207.541 462.655 206.408 462.655C205.274 462.655 204.355 463.574 204.355 464.708C204.355 465.841 205.274 466.76 206.408 466.76Z" fill="currentColor"/>
            <path d="M188.232 457.499C189.366 457.499 190.284 456.58 190.284 455.447C190.284 454.313 189.366 453.395 188.232 453.395C187.099 453.395 186.18 454.313 186.18 455.447C186.18 456.58 187.099 457.499 188.232 457.499Z" fill="currentColor"/>
            <path d="M171.123 446.388C172.256 446.388 173.175 445.469 173.175 444.336C173.175 443.202 172.256 442.283 171.123 442.283C169.989 442.283 169.07 443.202 169.07 444.336C169.07 445.469 169.989 446.388 171.123 446.388Z" fill="currentColor"/>
            <path d="M155.267 433.55C156.401 433.55 157.32 432.631 157.32 431.498C157.32 430.364 156.401 429.445 155.267 429.445C154.134 429.445 153.215 430.364 153.215 431.498C153.215 432.631 154.134 433.55 155.267 433.55Z" fill="currentColor"/>
            <path d="M140.841 419.124C141.975 419.124 142.894 418.205 142.894 417.072C142.894 415.938 141.975 415.02 140.841 415.02C139.708 415.02 138.789 415.938 138.789 417.072C138.789 418.205 139.708 419.124 140.841 419.124Z" fill="currentColor"/>
            <path d="M128.005 403.271C129.139 403.271 130.058 402.352 130.058 401.218C130.058 400.085 129.139 399.166 128.005 399.166C126.872 399.166 125.953 400.085 125.953 401.218C125.953 402.352 126.872 403.271 128.005 403.271Z" fill="currentColor"/>
            <path d="M116.896 386.162C118.03 386.162 118.948 385.243 118.948 384.11C118.948 382.977 118.03 382.058 116.896 382.058C115.763 382.058 114.844 382.977 114.844 384.11C114.844 385.243 115.763 386.162 116.896 386.162Z" fill="currentColor"/>
            <path d="M107.631 367.958C108.75 367.958 109.656 367.051 109.656 365.933C109.656 364.814 108.75 363.907 107.631 363.907C106.512 363.907 105.605 364.814 105.605 365.933C105.605 367.051 106.512 367.958 107.631 367.958Z" fill="currentColor"/>
            <path d="M100.322 348.94C101.455 348.94 102.374 348.021 102.374 346.887C102.374 345.754 101.455 344.835 100.322 344.835C99.1884 344.835 98.2695 345.754 98.2695 346.887C98.2695 348.021 99.1884 348.94 100.322 348.94Z" fill="currentColor"/>
            <path d="M95.0411 329.207C96.1597 329.207 97.0665 328.3 97.0665 327.182C97.0665 326.063 96.1597 325.156 95.0411 325.156C93.9224 325.156 93.0156 326.063 93.0156 327.182C93.0156 328.3 93.9224 329.207 95.0411 329.207Z" fill="currentColor"/>
            <path d="M91.8492 309.086C92.9827 309.086 93.9016 308.167 93.9016 307.034C93.9016 305.9 92.9827 304.981 91.8492 304.981C90.7157 304.981 89.7969 305.9 89.7969 307.034C89.7969 308.167 90.7157 309.086 91.8492 309.086Z" fill="currentColor"/>
            <path d="M90.7828 288.713C91.9163 288.713 92.8352 287.794 92.8352 286.661C92.8352 285.527 91.9163 284.608 90.7828 284.608C89.6493 284.608 88.7305 285.527 88.7305 286.661C88.7305 287.794 89.6493 288.713 90.7828 288.713Z" fill="currentColor"/>
            <path d="M91.8492 268.341C92.9827 268.341 93.9016 267.422 93.9016 266.289C93.9016 265.155 92.9827 264.236 91.8492 264.236C90.7157 264.236 89.7969 265.155 89.7969 266.289C89.7969 267.422 90.7157 268.341 91.8492 268.341Z" fill="currentColor"/>
            <path d="M95.0411 248.165C96.1597 248.165 97.0665 247.258 97.0665 246.14C97.0665 245.021 96.1597 244.114 95.0411 244.114C93.9224 244.114 93.0156 245.021 93.0156 246.14C93.0156 247.258 93.9224 248.165 95.0411 248.165Z" fill="currentColor"/>
            <path d="M100.322 228.487C101.455 228.487 102.374 227.568 102.374 226.434C102.374 225.301 101.455 224.382 100.322 224.382C99.1884 224.382 98.2695 225.301 98.2695 226.434C98.2695 227.568 99.1884 228.487 100.322 228.487Z" fill="currentColor"/>
            <path d="M107.631 209.415C108.75 209.415 109.656 208.508 109.656 207.39C109.656 206.271 108.75 205.364 107.631 205.364C106.512 205.364 105.605 206.271 105.605 207.39C105.605 208.508 106.512 209.415 107.631 209.415Z" fill="currentColor"/>
            <path d="M116.896 191.3C118.049 191.3 118.983 190.365 118.983 189.212C118.983 188.06 118.049 187.125 116.896 187.125C115.743 187.125 114.809 188.06 114.809 189.212C114.809 190.365 115.743 191.3 116.896 191.3Z" fill="currentColor"/>
            <path d="M128.005 174.155C129.139 174.155 130.058 173.237 130.058 172.103C130.058 170.97 129.139 170.051 128.005 170.051C126.872 170.051 125.953 170.97 125.953 172.103C125.953 173.237 126.872 174.155 128.005 174.155Z" fill="currentColor"/>
            <path d="M140.841 158.302C141.975 158.302 142.894 157.383 142.894 156.25C142.894 155.116 141.975 154.197 140.841 154.197C139.708 154.197 138.789 155.116 138.789 156.25C138.789 157.383 139.708 158.302 140.841 158.302Z" fill="currentColor"/>
            <path d="M155.267 143.877C156.401 143.877 157.32 142.958 157.32 141.825C157.32 140.691 156.401 139.772 155.267 139.772C154.134 139.772 153.215 140.691 153.215 141.825C153.215 142.958 154.134 143.877 155.267 143.877Z" fill="currentColor"/>
            <path d="M171.123 131.012C172.242 131.012 173.149 130.105 173.149 128.986C173.149 127.868 172.242 126.961 171.123 126.961C170.004 126.961 169.098 127.868 169.098 128.986C169.098 130.105 170.004 131.012 171.123 131.012Z" fill="currentColor"/>
            <path d="M188.232 119.928C189.366 119.928 190.284 119.009 190.284 117.876C190.284 116.742 189.366 115.823 188.232 115.823C187.099 115.823 186.18 116.742 186.18 117.876C186.18 119.009 187.099 119.928 188.232 119.928Z" fill="currentColor"/>
            <path d="M206.408 110.639C207.527 110.639 208.434 109.732 208.434 108.613C208.434 107.495 207.527 106.588 206.408 106.588C205.29 106.588 204.383 107.495 204.383 108.613C204.383 109.732 205.29 110.639 206.408 110.639Z" fill="currentColor"/>
            <path d="M225.455 103.356C226.588 103.356 227.507 102.437 227.507 101.303C227.507 100.17 226.588 99.251 225.455 99.251C224.321 99.251 223.402 100.17 223.402 101.303C223.402 102.437 224.321 103.356 225.455 103.356Z" fill="currentColor"/>
            <path d="M245.158 98.0489C246.277 98.0489 247.184 97.1421 247.184 96.0235C247.184 94.9049 246.277 93.998 245.158 93.998C244.04 93.998 243.133 94.9049 243.133 96.0235C243.133 97.1421 244.04 98.0489 245.158 98.0489Z" fill="currentColor"/>
            <path d="M265.307 94.8575C266.425 94.8575 267.332 93.9507 267.332 92.8321C267.332 91.7135 266.425 90.8066 265.307 90.8066C264.188 90.8066 263.281 91.7135 263.281 92.8321C263.281 93.9507 264.188 94.8575 265.307 94.8575Z" fill="currentColor"/>
            <path d="M285.677 93.8166C286.811 93.8166 287.73 92.8978 287.73 91.7643C287.73 90.6308 286.811 89.7119 285.677 89.7119C284.544 89.7119 283.625 90.6308 283.625 91.7643C283.625 92.8978 284.544 93.8166 285.677 93.8166Z" fill="currentColor"/>
            <path d="M306.052 94.884C307.186 94.884 308.105 93.9651 308.105 92.8317C308.105 91.6982 307.186 90.7793 306.052 90.7793C304.919 90.7793 304 91.6982 304 92.8317C304 93.9651 304.919 94.884 306.052 94.884Z" fill="currentColor"/>
            <path d="M326.201 98.0754C327.334 98.0754 328.253 97.1565 328.253 96.0231C328.253 94.8896 327.334 93.9707 326.201 93.9707C325.067 93.9707 324.148 94.8896 324.148 96.0231C324.148 97.1565 325.067 98.0754 326.201 98.0754Z" fill="currentColor"/>
            <path d="M345.904 103.328C347.023 103.328 347.93 102.421 347.93 101.303C347.93 100.184 347.023 99.2773 345.904 99.2773C344.786 99.2773 343.879 100.184 343.879 101.303C343.879 102.421 344.786 103.328 345.904 103.328Z" fill="currentColor"/>
            <path d="M364.951 110.639C366.07 110.639 366.977 109.732 366.977 108.613C366.977 107.495 366.07 106.588 364.951 106.588C363.833 106.588 362.926 107.495 362.926 108.613C362.926 109.732 363.833 110.639 364.951 110.639Z" fill="currentColor"/>
            <path d="M383.127 119.928C384.26 119.928 385.179 119.009 385.179 117.876C385.179 116.742 384.26 115.823 383.127 115.823C381.993 115.823 381.074 116.742 381.074 117.876C381.074 119.009 381.993 119.928 383.127 119.928Z" fill="currentColor"/>
            <path d="M400.236 131.012C401.355 131.012 402.262 130.105 402.262 128.986C402.262 127.868 401.355 126.961 400.236 126.961C399.118 126.961 398.211 127.868 398.211 128.986C398.211 130.105 399.118 131.012 400.236 131.012Z" fill="currentColor"/>
            <path d="M416.091 143.877C417.225 143.877 418.144 142.958 418.144 141.825C418.144 140.691 417.225 139.772 416.091 139.772C414.958 139.772 414.039 140.691 414.039 141.825C414.039 142.958 414.958 143.877 416.091 143.877Z" fill="currentColor"/>
            <path d="M430.517 158.302C431.651 158.302 432.57 157.383 432.57 156.25C432.57 155.116 431.651 154.197 430.517 154.197C429.384 154.197 428.465 155.116 428.465 156.25C428.465 157.383 429.384 158.302 430.517 158.302Z" fill="currentColor"/>
            <path d="M443.353 174.155C444.487 174.155 445.405 173.237 445.405 172.103C445.405 170.97 444.487 170.051 443.353 170.051C442.22 170.051 441.301 170.97 441.301 172.103C441.301 173.237 442.22 174.155 443.353 174.155Z" fill="currentColor"/>
            <path d="M454.466 191.265C455.6 191.265 456.519 190.346 456.519 189.213C456.519 188.079 455.6 187.16 454.466 187.16C453.333 187.16 452.414 188.079 452.414 189.213C452.414 190.346 453.333 191.265 454.466 191.265Z" fill="currentColor"/>
            <path d="M463.728 209.477C464.881 209.477 465.816 208.542 465.816 207.389C465.816 206.236 464.881 205.302 463.728 205.302C462.575 205.302 461.641 206.236 461.641 207.389C461.641 208.542 462.575 209.477 463.728 209.477Z" fill="currentColor"/>
            <path d="M471.037 228.487C472.17 228.487 473.089 227.568 473.089 226.434C473.089 225.301 472.17 224.382 471.037 224.382C469.903 224.382 468.984 225.301 468.984 226.434C468.984 227.568 469.903 228.487 471.037 228.487Z" fill="currentColor"/>
            <path d="M476.318 248.165C477.437 248.165 478.344 247.258 478.344 246.14C478.344 245.021 477.437 244.114 476.318 244.114C475.2 244.114 474.293 245.021 474.293 246.14C474.293 247.258 475.2 248.165 476.318 248.165Z" fill="currentColor"/>
            <path d="M479.509 268.376C480.662 268.376 481.597 267.441 481.597 266.289C481.597 265.136 480.662 264.201 479.509 264.201C478.356 264.201 477.422 265.136 477.422 266.289C477.422 267.441 478.356 268.376 479.509 268.376Z" fill="currentColor"/>
            <path d="M71.2946 288.955C72.5619 288.955 73.5892 287.928 73.5892 286.661C73.5892 285.394 72.5619 284.366 71.2946 284.366C70.0273 284.366 69 285.394 69 286.661C69 287.928 70.0273 288.955 71.2946 288.955Z" fill="currentColor"/>
            <path d="M72.2638 268.55C73.5162 268.55 74.5315 267.535 74.5315 266.282C74.5315 265.03 73.5162 264.015 72.2638 264.015C71.0114 264.015 69.9961 265.03 69.9961 266.282C69.9961 267.535 71.0114 268.55 72.2638 268.55Z" fill="currentColor"/>
            <path d="M75.1657 248.382C76.433 248.382 77.4603 247.355 77.4603 246.088C77.4603 244.82 76.433 243.793 75.1657 243.793C73.8984 243.793 72.8711 244.82 72.8711 246.088C72.8711 247.355 73.8984 248.382 75.1657 248.382Z" fill="currentColor"/>
            <path d="M79.9782 228.556C81.2455 228.556 82.2728 227.529 82.2728 226.261C82.2728 224.994 81.2455 223.967 79.9782 223.967C78.7109 223.967 77.6836 224.994 77.6836 226.261C77.6836 227.529 78.7109 228.556 79.9782 228.556Z" fill="currentColor"/>
            <path d="M86.6506 209.339C87.9527 209.339 89.0083 208.284 89.0083 206.982C89.0083 205.68 87.9527 204.624 86.6506 204.624C85.3485 204.624 84.293 205.68 84.293 206.982C84.293 208.284 85.3485 209.339 86.6506 209.339Z" fill="currentColor"/>
            <path d="M95.1271 190.692C96.3795 190.692 97.3947 189.676 97.3947 188.424C97.3947 187.172 96.3795 186.156 95.1271 186.156C93.8747 186.156 92.8594 187.172 92.8594 188.424C92.8594 189.676 93.8747 190.692 95.1271 190.692Z" fill="currentColor"/>
            <path d="M105.326 173.049C106.593 173.049 107.62 172.022 107.62 170.755C107.62 169.487 106.593 168.46 105.326 168.46C104.059 168.46 103.031 169.487 103.031 170.755C103.031 172.022 104.059 173.049 105.326 173.049Z" fill="currentColor"/>
            <path d="M117.162 156.404C118.415 156.404 119.43 155.388 119.43 154.136C119.43 152.883 118.415 151.868 117.162 151.868C115.91 151.868 114.895 152.883 114.895 154.136C114.895 155.388 115.91 156.404 117.162 156.404Z" fill="currentColor"/>
            <path d="M130.521 141.012C131.788 141.012 132.816 139.985 132.816 138.717C132.816 137.45 131.788 136.423 130.521 136.423C129.254 136.423 128.227 137.45 128.227 138.717C128.227 139.985 129.254 141.012 130.521 141.012Z" fill="currentColor"/>
            <path d="M145.287 126.906C146.54 126.906 147.555 125.891 147.555 124.639C147.555 123.386 146.54 122.371 145.287 122.371C144.035 122.371 143.02 123.386 143.02 124.639C143.02 125.891 144.035 126.906 145.287 126.906Z" fill="currentColor"/>
            <path d="M161.322 114.294C162.575 114.294 163.59 113.279 163.59 112.026C163.59 110.774 162.575 109.759 161.322 109.759C160.07 109.759 159.055 110.774 159.055 112.026C159.055 113.279 160.07 114.294 161.322 114.294Z" fill="currentColor"/>
            <path d="M178.486 103.265C179.739 103.265 180.754 102.25 180.754 100.997C180.754 99.7448 179.739 98.7295 178.486 98.7295C177.234 98.7295 176.219 99.7448 176.219 100.997C176.219 102.25 177.234 103.265 178.486 103.265Z" fill="currentColor"/>
            <path d="M196.619 93.9162C197.872 93.9162 198.887 92.901 198.887 91.6485C198.887 90.3961 197.872 89.3809 196.619 89.3809C195.367 89.3809 194.352 90.3961 194.352 91.6485C194.352 92.901 195.367 93.9162 196.619 93.9162Z" fill="currentColor"/>
            <path d="M215.56 86.3607C216.828 86.3607 217.855 85.3334 217.855 84.0661C217.855 82.7988 216.828 81.7715 215.56 81.7715C214.293 81.7715 213.266 82.7988 213.266 84.0661C213.266 85.3334 214.293 86.3607 215.56 86.3607Z" fill="currentColor"/>
            <path d="M235.135 80.5862C236.387 80.5862 237.403 79.5709 237.403 78.3185C237.403 77.0661 236.387 76.0508 235.135 76.0508C233.882 76.0508 232.867 77.0661 232.867 78.3185C232.867 79.5709 233.882 80.5862 235.135 80.5862Z" fill="currentColor"/>
            <path d="M255.17 76.7513C256.437 76.7513 257.464 75.724 257.464 74.4567C257.464 73.1894 256.437 72.1621 255.17 72.1621C253.902 72.1621 252.875 73.1894 252.875 74.4567C252.875 75.724 253.902 76.7513 255.17 76.7513Z" fill="currentColor"/>
            <path d="M275.479 74.7854C276.731 74.7854 277.746 73.7701 277.746 72.5177C277.746 71.2653 276.731 70.25 275.479 70.25C274.226 70.25 273.211 71.2653 273.211 72.5177C273.211 73.7701 274.226 74.7854 275.479 74.7854Z" fill="currentColor"/>
            <path d="M295.881 74.8119C297.148 74.8119 298.175 73.7845 298.175 72.5173C298.175 71.25 297.148 70.2227 295.881 70.2227C294.613 70.2227 293.586 71.25 293.586 72.5173C293.586 73.7845 294.613 74.8119 295.881 74.8119Z" fill="currentColor"/>
            <path d="M316.189 76.7513C317.456 76.7513 318.484 75.724 318.484 74.4567C318.484 73.1894 317.456 72.1621 316.189 72.1621C314.922 72.1621 313.895 73.1894 313.895 74.4567C313.895 75.724 314.922 76.7513 316.189 76.7513Z" fill="currentColor"/>
            <path d="M336.225 80.5862C337.477 80.5862 338.492 79.5709 338.492 78.3185C338.492 77.0661 337.477 76.0508 336.225 76.0508C334.972 76.0508 333.957 77.0661 333.957 78.3185C333.957 79.5709 334.972 80.5862 336.225 80.5862Z" fill="currentColor"/>
            <path d="M355.798 86.3607C357.066 86.3607 358.093 85.3334 358.093 84.0661C358.093 82.7988 357.066 81.7715 355.798 81.7715C354.531 81.7715 353.504 82.7988 353.504 84.0661C353.504 85.3334 354.531 86.3607 355.798 86.3607Z" fill="currentColor"/>
            <path d="M374.737 93.9787C376.024 93.9787 377.068 92.9352 377.068 91.6481C377.068 90.3609 376.024 89.3174 374.737 89.3174C373.45 89.3174 372.406 90.3609 372.406 91.6481C372.406 92.9352 373.45 93.9787 374.737 93.9787Z" fill="currentColor"/>
            <path d="M392.873 103.265C394.126 103.265 395.141 102.25 395.141 100.997C395.141 99.7448 394.126 98.7295 392.873 98.7295C391.621 98.7295 390.605 99.7448 390.605 100.997C390.605 102.25 391.621 103.265 392.873 103.265Z" fill="currentColor"/>
            <path d="M410.037 114.322C411.304 114.322 412.331 113.294 412.331 112.027C412.331 110.76 411.304 109.732 410.037 109.732C408.77 109.732 407.742 110.76 407.742 112.027C407.742 113.294 408.77 114.322 410.037 114.322Z" fill="currentColor"/>
            <path d="M426.072 126.906C427.325 126.906 428.34 125.891 428.34 124.639C428.34 123.386 427.325 122.371 426.072 122.371C424.82 122.371 423.805 123.386 423.805 124.639C423.805 125.891 424.82 126.906 426.072 126.906Z" fill="currentColor"/>
            <path d="M440.838 141.012C442.105 141.012 443.132 139.985 443.132 138.717C443.132 137.45 442.105 136.423 440.838 136.423C439.57 136.423 438.543 137.45 438.543 138.717C438.543 139.985 439.57 141.012 440.838 141.012Z" fill="currentColor"/>
            <path d="M454.197 156.431C455.464 156.431 456.492 155.404 456.492 154.136C456.492 152.869 455.464 151.842 454.197 151.842C452.93 151.842 451.902 152.869 451.902 154.136C451.902 155.404 452.93 156.431 454.197 156.431Z" fill="currentColor"/>
            <path d="M466.033 173.049C467.3 173.049 468.327 172.022 468.327 170.755C468.327 169.487 467.3 168.46 466.033 168.46C464.766 168.46 463.738 169.487 463.738 170.755C463.738 172.022 464.766 173.049 466.033 173.049Z" fill="currentColor"/>
            <path d="M476.232 190.718C477.499 190.718 478.527 189.691 478.527 188.424C478.527 187.156 477.499 186.129 476.232 186.129C474.965 186.129 473.938 187.156 473.938 188.424C473.938 189.691 474.965 190.718 476.232 190.718Z" fill="currentColor"/>
            <path d="M484.709 209.277C485.976 209.277 487.003 208.249 487.003 206.982C487.003 205.715 485.976 204.688 484.709 204.688C483.441 204.688 482.414 205.715 482.414 206.982C482.414 208.249 483.441 209.277 484.709 209.277Z" fill="currentColor"/>
            <path d="M491.381 228.556C492.648 228.556 493.675 227.529 493.675 226.261C493.675 224.994 492.648 223.967 491.381 223.967C490.113 223.967 489.086 224.994 489.086 226.261C489.086 227.529 490.113 228.556 491.381 228.556Z" fill="currentColor"/>
            <path d="M496.19 248.356C497.442 248.356 498.457 247.34 498.457 246.088C498.457 244.836 497.442 243.82 496.19 243.82C494.937 243.82 493.922 244.836 493.922 246.088C493.922 247.34 494.937 248.356 496.19 248.356Z" fill="currentColor"/>
            <path d="M499.095 268.577C500.363 268.577 501.39 267.549 501.39 266.282C501.39 265.015 500.363 263.987 499.095 263.987C497.828 263.987 496.801 265.015 496.801 266.282C496.801 267.549 497.828 268.577 499.095 268.577Z" fill="currentColor"/>
            <path d="M500.065 288.991C501.352 288.991 502.396 287.948 502.396 286.661C502.396 285.374 501.352 284.33 500.065 284.33C498.778 284.33 497.734 285.374 497.734 286.661C497.734 287.948 498.778 288.991 500.065 288.991Z" fill="currentColor"/>
            <path d="M499.095 309.334C500.363 309.334 501.39 308.307 501.39 307.04C501.39 305.772 500.363 304.745 499.095 304.745C497.828 304.745 496.801 305.772 496.801 307.04C496.801 308.307 497.828 309.334 499.095 309.334Z" fill="currentColor"/>
            <path d="M496.19 329.501C497.442 329.501 498.457 328.486 498.457 327.233C498.457 325.981 497.442 324.966 496.19 324.966C494.937 324.966 493.922 325.981 493.922 327.233C493.922 328.486 494.937 329.501 496.19 329.501Z" fill="currentColor"/>
            <path d="M491.381 349.355C492.648 349.355 493.675 348.327 493.675 347.06C493.675 345.793 492.648 344.766 491.381 344.766C490.113 344.766 489.086 345.793 489.086 347.06C489.086 348.327 490.113 349.355 491.381 349.355Z" fill="currentColor"/>
            <path d="M484.71 368.671C485.997 368.671 487.04 367.628 487.04 366.34C487.04 365.053 485.997 364.01 484.71 364.01C483.422 364.01 482.379 365.053 482.379 366.34C482.379 367.628 483.422 368.671 484.71 368.671Z" fill="currentColor"/>
            <path d="M476.233 387.166C477.485 387.166 478.5 386.151 478.5 384.899C478.5 383.646 477.485 382.631 476.233 382.631C474.98 382.631 473.965 383.646 473.965 384.899C473.965 386.151 474.98 387.166 476.233 387.166Z" fill="currentColor"/>
            <path d="M466.033 404.862C467.3 404.862 468.327 403.834 468.327 402.567C468.327 401.3 467.3 400.272 466.033 400.272C464.766 400.272 463.738 401.3 463.738 402.567C463.738 403.834 464.766 404.862 466.033 404.862Z" fill="currentColor"/>
            <path d="M454.198 421.517C455.485 421.517 456.529 420.473 456.529 419.186C456.529 417.899 455.485 416.855 454.198 416.855C452.911 416.855 451.867 417.899 451.867 419.186C451.867 420.473 452.911 421.517 454.198 421.517Z" fill="currentColor"/>
            <path d="M440.838 436.899C442.105 436.899 443.132 435.871 443.132 434.604C443.132 433.337 442.105 432.31 440.838 432.31C439.57 432.31 438.543 433.337 438.543 434.604C438.543 435.871 439.57 436.899 440.838 436.899Z" fill="currentColor"/>
            <path d="M426.073 451.014C427.36 451.014 428.404 449.97 428.404 448.683C428.404 447.396 427.36 446.353 426.073 446.353C424.786 446.353 423.742 447.396 423.742 448.683C423.742 449.97 424.786 451.014 426.073 451.014Z" fill="currentColor"/>
            <path d="M410.037 463.589C411.304 463.589 412.331 462.562 412.331 461.295C412.331 460.027 411.304 459 410.037 459C408.77 459 407.742 460.027 407.742 461.295C407.742 462.562 408.77 463.589 410.037 463.589Z" fill="currentColor"/>
            <path d="M392.873 474.619C394.14 474.619 395.167 473.592 395.167 472.325C395.167 471.058 394.14 470.03 392.873 470.03C391.605 470.03 390.578 471.058 390.578 472.325C390.578 473.592 391.605 474.619 392.873 474.619Z" fill="currentColor"/>
            <path d="M374.737 484.004C376.024 484.004 377.068 482.961 377.068 481.673C377.068 480.386 376.024 479.343 374.737 479.343C373.45 479.343 372.406 480.386 372.406 481.673C372.406 482.961 373.45 484.004 374.737 484.004Z" fill="currentColor"/>
            <path d="M355.799 491.524C357.051 491.524 358.067 490.508 358.067 489.256C358.067 488.004 357.051 486.988 355.799 486.988C354.546 486.988 353.531 488.004 353.531 489.256C353.531 490.508 354.546 491.524 355.799 491.524Z" fill="currentColor"/>
            <path d="M336.225 497.272C337.477 497.272 338.492 496.256 338.492 495.004C338.492 493.752 337.477 492.736 336.225 492.736C334.972 492.736 333.957 493.752 333.957 495.004C333.957 496.256 334.972 497.272 336.225 497.272Z" fill="currentColor"/>
            <path d="M316.19 501.133C317.442 501.133 318.457 500.118 318.457 498.865C318.457 497.613 317.442 496.598 316.19 496.598C314.937 496.598 313.922 497.613 313.922 498.865C313.922 500.118 314.937 501.133 316.19 501.133Z" fill="currentColor"/>
            <path d="M295.881 503.099C297.148 503.099 298.175 502.072 298.175 500.804C298.175 499.537 297.148 498.51 295.881 498.51C294.613 498.51 293.586 499.537 293.586 500.804C293.586 502.072 294.613 503.099 295.881 503.099Z" fill="currentColor"/>
            <path d="M275.478 503.099C276.745 503.099 277.773 502.072 277.773 500.804C277.773 499.537 276.745 498.51 275.478 498.51C274.211 498.51 273.184 499.537 273.184 500.804C273.184 502.072 274.211 503.099 275.478 503.099Z" fill="currentColor"/>
            <path d="M255.17 501.133C256.422 501.133 257.438 500.118 257.438 498.865C257.438 497.613 256.422 496.598 255.17 496.598C253.918 496.598 252.902 497.613 252.902 498.865C252.902 500.118 253.918 501.133 255.17 501.133Z" fill="currentColor"/>
            <path d="M235.134 497.298C236.402 497.298 237.429 496.271 237.429 495.004C237.429 493.736 236.402 492.709 235.134 492.709C233.867 492.709 232.84 493.736 232.84 495.004C232.84 496.271 233.867 497.298 235.134 497.298Z" fill="currentColor"/>
            <path d="M215.561 491.524C216.813 491.524 217.828 490.508 217.828 489.256C217.828 488.004 216.813 486.988 215.561 486.988C214.308 486.988 213.293 488.004 213.293 489.256C213.293 490.508 214.308 491.524 215.561 491.524Z" fill="currentColor"/>
            <path d="M196.619 483.942C197.872 483.942 198.887 482.926 198.887 481.674C198.887 480.421 197.872 479.406 196.619 479.406C195.367 479.406 194.352 480.421 194.352 481.674C194.352 482.926 195.367 483.942 196.619 483.942Z" fill="currentColor"/>
            <path d="M178.486 474.619C179.753 474.619 180.781 473.592 180.781 472.325C180.781 471.058 179.753 470.03 178.486 470.03C177.219 470.03 176.191 471.058 176.191 472.325C176.191 473.592 177.219 474.619 178.486 474.619Z" fill="currentColor"/>
            <path d="M161.322 463.589C162.589 463.589 163.617 462.562 163.617 461.295C163.617 460.027 162.589 459 161.322 459C160.055 459 159.027 460.027 159.027 461.295C159.027 462.562 160.055 463.589 161.322 463.589Z" fill="currentColor"/>
            <path d="M145.287 450.951C146.54 450.951 147.555 449.936 147.555 448.684C147.555 447.431 146.54 446.416 145.287 446.416C144.035 446.416 143.02 447.431 143.02 448.684C143.02 449.936 144.035 450.951 145.287 450.951Z" fill="currentColor"/>
            <path d="M130.521 436.899C131.788 436.899 132.816 435.871 132.816 434.604C132.816 433.337 131.788 432.31 130.521 432.31C129.254 432.31 128.227 433.337 128.227 434.604C128.227 435.871 129.254 436.899 130.521 436.899Z" fill="currentColor"/>
            <path d="M117.159 421.517C118.446 421.517 119.489 420.473 119.489 419.186C119.489 417.899 118.446 416.855 117.159 416.855C115.872 416.855 114.828 417.899 114.828 419.186C114.828 420.473 115.872 421.517 117.159 421.517Z" fill="currentColor"/>
            <path d="M105.327 404.898C106.614 404.898 107.657 403.854 107.657 402.567C107.657 401.28 106.614 400.236 105.327 400.236C104.04 400.236 102.996 401.28 102.996 402.567C102.996 403.854 104.04 404.898 105.327 404.898Z" fill="currentColor"/>
            <path d="M95.1271 387.166C96.3795 387.166 97.3947 386.151 97.3947 384.899C97.3947 383.646 96.3795 382.631 95.1271 382.631C93.8747 382.631 92.8594 383.646 92.8594 384.899C92.8594 386.151 93.8747 387.166 95.1271 387.166Z" fill="currentColor"/>
            <path d="M86.6501 368.635C87.9173 368.635 88.9447 367.608 88.9447 366.34C88.9447 365.073 87.9173 364.046 86.6501 364.046C85.3828 364.046 84.3555 365.073 84.3555 366.34C84.3555 367.608 85.3828 368.635 86.6501 368.635Z" fill="currentColor"/>
            <path d="M79.9786 349.328C81.231 349.328 82.2463 348.313 82.2463 347.061C82.2463 345.808 81.231 344.793 79.9786 344.793C78.7262 344.793 77.7109 345.808 77.7109 347.061C77.7109 348.313 78.7262 349.328 79.9786 349.328Z" fill="currentColor"/>
            <path d="M75.1657 329.529C76.433 329.529 77.4603 328.501 77.4603 327.234C77.4603 325.967 76.433 324.939 75.1657 324.939C73.8984 324.939 72.8711 325.967 72.8711 327.234C72.8711 328.501 73.8984 329.529 75.1657 329.529Z" fill="currentColor"/>
            <path d="M72.2634 309.334C73.5306 309.334 74.558 308.307 74.558 307.04C74.558 305.772 73.5306 304.745 72.2634 304.745C70.9961 304.745 69.9688 305.772 69.9688 307.04C69.9688 308.307 70.9961 309.334 72.2634 309.334Z" fill="currentColor"/>
            <path d="M519.554 289.235C520.976 289.235 522.128 288.082 522.128 286.661C522.128 285.239 520.976 284.087 519.554 284.087C518.133 284.087 516.98 285.239 516.98 286.661C516.98 288.082 518.133 289.235 519.554 289.235Z" fill="currentColor"/>
            <path d="M518.664 309.618C520.085 309.618 521.238 308.466 521.238 307.045C521.238 305.623 520.085 304.471 518.664 304.471C517.242 304.471 516.09 305.623 516.09 307.045C516.09 308.466 517.242 309.618 518.664 309.618Z" fill="currentColor"/>
            <path d="M516.002 329.81C517.403 329.81 518.539 328.674 518.539 327.273C518.539 325.872 517.403 324.736 516.002 324.736C514.601 324.736 513.465 325.872 513.465 327.273C513.465 328.674 514.601 329.81 516.002 329.81Z" fill="currentColor"/>
            <path d="M511.588 349.729C512.989 349.729 514.124 348.593 514.124 347.192C514.124 345.791 512.989 344.655 511.588 344.655C510.187 344.655 509.051 345.791 509.051 347.192C509.051 348.593 510.187 349.729 511.588 349.729Z" fill="currentColor"/>
            <path d="M505.453 369.225C506.874 369.225 508.027 368.072 508.027 366.651C508.027 365.229 506.874 364.077 505.453 364.077C504.031 364.077 502.879 365.229 502.879 366.651C502.879 368.072 504.031 369.225 505.453 369.225Z" fill="currentColor"/>
            <path d="M497.642 388.038C499.043 388.038 500.179 386.902 500.179 385.501C500.179 384.1 499.043 382.964 497.642 382.964C496.241 382.964 495.105 384.1 495.105 385.501C495.105 386.902 496.241 388.038 497.642 388.038Z" fill="currentColor"/>
            <path d="M488.22 406.135C489.621 406.135 490.757 404.999 490.757 403.598C490.757 402.197 489.621 401.062 488.22 401.062C486.819 401.062 485.684 402.197 485.684 403.598C485.684 404.999 486.819 406.135 488.22 406.135Z" fill="currentColor"/>
            <path d="M477.26 423.317C478.646 423.317 479.77 422.193 479.77 420.807C479.77 419.421 478.646 418.297 477.26 418.297C475.874 418.297 474.75 419.421 474.75 420.807C474.75 422.193 475.874 423.317 477.26 423.317Z" fill="currentColor"/>
            <path d="M464.838 439.531C466.239 439.531 467.374 438.395 467.374 436.994C467.374 435.593 466.239 434.457 464.838 434.457C463.437 434.457 462.301 435.593 462.301 436.994C462.301 438.395 463.437 439.531 464.838 439.531Z" fill="currentColor"/>
            <path d="M451.056 454.573C452.457 454.573 453.593 453.437 453.593 452.036C453.593 450.635 452.457 449.499 451.056 449.499C449.655 449.499 448.52 450.635 448.52 452.036C448.52 453.437 449.655 454.573 451.056 454.573Z" fill="currentColor"/>
            <path d="M436.011 468.395C437.433 468.395 438.585 467.242 438.585 465.821C438.585 464.399 437.433 463.247 436.011 463.247C434.59 463.247 433.438 464.399 433.438 465.821C433.438 467.242 434.59 468.395 436.011 468.395Z" fill="currentColor"/>
            <path d="M419.826 480.751C421.213 480.751 422.336 479.628 422.336 478.241C422.336 476.855 421.213 475.731 419.826 475.731C418.44 475.731 417.316 476.855 417.316 478.241C417.316 479.628 418.44 480.751 419.826 480.751Z" fill="currentColor"/>
            <path d="M402.619 491.741C404.02 491.741 405.156 490.605 405.156 489.204C405.156 487.803 404.02 486.667 402.619 486.667C401.218 486.667 400.082 487.803 400.082 489.204C400.082 490.605 401.218 491.741 402.619 491.741Z" fill="currentColor"/>
            <path d="M384.521 501.162C385.922 501.162 387.058 500.026 387.058 498.625C387.058 497.224 385.922 496.088 384.521 496.088C383.12 496.088 381.984 497.224 381.984 498.625C381.984 500.026 383.12 501.162 384.521 501.162Z" fill="currentColor"/>
            <path d="M365.67 508.969C367.071 508.969 368.207 507.833 368.207 506.432C368.207 505.031 367.071 503.896 365.67 503.896C364.269 503.896 363.133 505.031 363.133 506.432C363.133 507.833 364.269 508.969 365.67 508.969Z" fill="currentColor"/>
            <path d="M346.213 515.105C347.614 515.105 348.749 513.969 348.749 512.568C348.749 511.167 347.614 510.031 346.213 510.031C344.812 510.031 343.676 511.167 343.676 512.568C343.676 513.969 344.812 515.105 346.213 515.105Z" fill="currentColor"/>
            <path d="M326.291 519.521C327.692 519.521 328.828 518.385 328.828 516.984C328.828 515.583 327.692 514.447 326.291 514.447C324.89 514.447 323.754 515.583 323.754 516.984C323.754 518.385 324.89 519.521 326.291 519.521Z" fill="currentColor"/>
            <path d="M306.064 522.183C307.465 522.183 308.601 521.047 308.601 519.646C308.601 518.245 307.465 517.109 306.064 517.109C304.663 517.109 303.527 518.245 303.527 519.646C303.527 521.047 304.663 522.183 306.064 522.183Z" fill="currentColor"/>
            <path d="M285.677 523.074C287.079 523.074 288.214 521.938 288.214 520.537C288.214 519.136 287.079 518 285.677 518C284.276 518 283.141 519.136 283.141 520.537C283.141 521.938 284.276 523.074 285.677 523.074Z" fill="currentColor"/>
            <path d="M265.295 522.183C266.696 522.183 267.832 521.047 267.832 519.646C267.832 518.245 266.696 517.109 265.295 517.109C263.894 517.109 262.758 518.245 262.758 519.646C262.758 521.047 263.894 522.183 265.295 522.183Z" fill="currentColor"/>
            <path d="M245.068 519.521C246.469 519.521 247.605 518.385 247.605 516.984C247.605 515.583 246.469 514.447 245.068 514.447C243.667 514.447 242.531 515.583 242.531 516.984C242.531 518.385 243.667 519.521 245.068 519.521Z" fill="currentColor"/>
            <path d="M225.146 515.105C226.547 515.105 227.683 513.969 227.683 512.568C227.683 511.167 226.547 510.031 225.146 510.031C223.745 510.031 222.609 511.167 222.609 512.568C222.609 513.969 223.745 515.105 225.146 515.105Z" fill="currentColor"/>
            <path d="M205.687 509.006C207.109 509.006 208.261 507.854 208.261 506.432C208.261 505.011 207.109 503.858 205.687 503.858C204.266 503.858 203.113 505.011 203.113 506.432C203.113 507.854 204.266 509.006 205.687 509.006Z" fill="currentColor"/>
            <path d="M186.838 501.162C188.239 501.162 189.374 500.026 189.374 498.625C189.374 497.224 188.239 496.088 186.838 496.088C185.437 496.088 184.301 497.224 184.301 498.625C184.301 500.026 185.437 501.162 186.838 501.162Z" fill="currentColor"/>
            <path d="M168.74 491.741C170.141 491.741 171.277 490.605 171.277 489.204C171.277 487.803 170.141 486.667 168.74 486.667C167.339 486.667 166.203 487.803 166.203 489.204C166.203 490.605 167.339 491.741 168.74 491.741Z" fill="currentColor"/>
            <path d="M151.533 480.751C152.92 480.751 154.043 479.628 154.043 478.241C154.043 476.855 152.92 475.731 151.533 475.731C150.147 475.731 149.023 476.855 149.023 478.241C149.023 479.628 150.147 480.751 151.533 480.751Z" fill="currentColor"/>
            <path d="M135.345 468.358C136.747 468.358 137.882 467.222 137.882 465.821C137.882 464.42 136.747 463.284 135.345 463.284C133.944 463.284 132.809 464.42 132.809 465.821C132.809 467.222 133.944 468.358 135.345 468.358Z" fill="currentColor"/>
            <path d="M120.302 454.573C121.704 454.573 122.839 453.437 122.839 452.036C122.839 450.635 121.704 449.499 120.302 449.499C118.901 449.499 117.766 450.635 117.766 452.036C117.766 453.437 118.901 454.573 120.302 454.573Z" fill="currentColor"/>
            <path d="M106.521 439.531C107.922 439.531 109.058 438.395 109.058 436.994C109.058 435.593 107.922 434.457 106.521 434.457C105.12 434.457 103.984 435.593 103.984 436.994C103.984 438.395 105.12 439.531 106.521 439.531Z" fill="currentColor"/>
            <path d="M94.0997 423.317C95.4859 423.317 96.6097 422.193 96.6097 420.807C96.6097 419.421 95.4859 418.297 94.0997 418.297C92.7135 418.297 91.5898 419.421 91.5898 420.807C91.5898 422.193 92.7135 423.317 94.0997 423.317Z" fill="currentColor"/>
            <path d="M83.1384 406.135C84.5395 406.135 85.6753 404.999 85.6753 403.598C85.6753 402.197 84.5395 401.062 83.1384 401.062C81.7374 401.062 80.6016 402.197 80.6016 403.598C80.6016 404.999 81.7374 406.135 83.1384 406.135Z" fill="currentColor"/>
            <path d="M73.7165 388.038C75.1176 388.038 76.2534 386.902 76.2534 385.501C76.2534 384.1 75.1176 382.964 73.7165 382.964C72.3154 382.964 71.1797 384.1 71.1797 385.501C71.1797 386.902 72.3154 388.038 73.7165 388.038Z" fill="currentColor"/>
            <path d="M65.9079 369.188C67.309 369.188 68.4448 368.052 68.4448 366.651C68.4448 365.25 67.309 364.114 65.9079 364.114C64.5069 364.114 63.3711 365.25 63.3711 366.651C63.3711 368.052 64.5069 369.188 65.9079 369.188Z" fill="currentColor"/>
            <path d="M59.7717 349.702C61.1578 349.702 62.2816 348.579 62.2816 347.193C62.2816 345.806 61.1578 344.683 59.7717 344.683C58.3855 344.683 57.2617 345.806 57.2617 347.193C57.2617 348.579 58.3855 349.702 59.7717 349.702Z" fill="currentColor"/>
            <path d="M55.3572 329.81C56.7582 329.81 57.894 328.674 57.894 327.273C57.894 325.872 56.7582 324.736 55.3572 324.736C53.9561 324.736 52.8203 325.872 52.8203 327.273C52.8203 328.674 53.9561 329.81 55.3572 329.81Z" fill="currentColor"/>
            <path d="M52.6935 309.555C54.0797 309.555 55.2035 308.431 55.2035 307.045C55.2035 305.659 54.0797 304.535 52.6935 304.535C51.3073 304.535 50.1836 305.659 50.1836 307.045C50.1836 308.431 51.3073 309.555 52.6935 309.555Z" fill="currentColor"/>
            <path d="M51.8024 289.198C53.2035 289.198 54.3393 288.062 54.3393 286.661C54.3393 285.26 53.2035 284.124 51.8024 284.124C50.4014 284.124 49.2656 285.26 49.2656 286.661C49.2656 288.062 50.4014 289.198 51.8024 289.198Z" fill="currentColor"/>
            <path d="M52.695 268.851C54.1165 268.851 55.2688 267.698 55.2688 266.277C55.2688 264.855 54.1165 263.703 52.695 263.703C51.2735 263.703 50.1211 264.855 50.1211 266.277C50.1211 267.698 51.2735 268.851 52.695 268.851Z" fill="currentColor"/>
            <path d="M55.3576 248.559C56.7438 248.559 57.8675 247.435 57.8675 246.049C57.8675 244.663 56.7438 243.539 55.3576 243.539C53.9714 243.539 52.8477 244.663 52.8477 246.049C52.8477 247.435 53.9714 248.559 55.3576 248.559Z" fill="currentColor"/>
            <path d="M59.7717 228.639C61.1578 228.639 62.2816 227.515 62.2816 226.129C62.2816 224.743 61.1578 223.619 59.7717 223.619C58.3855 223.619 57.2617 224.743 57.2617 226.129C57.2617 227.515 58.3855 228.639 59.7717 228.639Z" fill="currentColor"/>
            <path d="M65.9079 209.207C67.309 209.207 68.4448 208.072 68.4448 206.671C68.4448 205.27 67.309 204.134 65.9079 204.134C64.5069 204.134 63.3711 205.27 63.3711 206.671C63.3711 208.072 64.5069 209.207 65.9079 209.207Z" fill="currentColor"/>
            <path d="M73.7165 190.358C75.1176 190.358 76.2534 189.222 76.2534 187.821C76.2534 186.42 75.1176 185.284 73.7165 185.284C72.3154 185.284 71.1797 186.42 71.1797 187.821C71.1797 189.222 72.3154 190.358 73.7165 190.358Z" fill="currentColor"/>
            <path d="M83.1388 172.233C84.525 172.233 85.6488 171.109 85.6488 169.723C85.6488 168.337 84.525 167.213 83.1388 167.213C81.7526 167.213 80.6289 168.337 80.6289 169.723C80.6289 171.109 81.7526 172.233 83.1388 172.233Z" fill="currentColor"/>
            <path d="M94.1012 155.089C95.5227 155.089 96.675 153.937 96.675 152.515C96.675 151.094 95.5227 149.941 94.1012 149.941C92.6797 149.941 91.5273 151.094 91.5273 152.515C91.5273 153.937 92.6797 155.089 94.1012 155.089Z" fill="currentColor"/>
            <path d="M106.519 138.903C107.941 138.903 109.093 137.75 109.093 136.329C109.093 134.907 107.941 133.755 106.519 133.755C105.098 133.755 103.945 134.907 103.945 136.329C103.945 137.75 105.098 138.903 106.519 138.903Z" fill="currentColor"/>
            <path d="M120.303 123.795C121.689 123.795 122.813 122.672 122.813 121.285C122.813 119.899 121.689 118.775 120.303 118.775C118.917 118.775 117.793 119.899 117.793 121.285C117.793 122.672 118.917 123.795 120.303 123.795Z" fill="currentColor"/>
            <path d="M135.345 110.039C136.747 110.039 137.882 108.903 137.882 107.502C137.882 106.101 136.747 104.965 135.345 104.965C133.944 104.965 132.809 106.101 132.809 107.502C132.809 108.903 133.944 110.039 135.345 110.039Z" fill="currentColor"/>
            <path d="M151.533 97.6176C152.934 97.6176 154.07 96.4818 154.07 95.0808C154.07 93.6797 152.934 92.5439 151.533 92.5439C150.132 92.5439 148.996 93.6797 148.996 95.0808C148.996 96.4818 150.132 97.6176 151.533 97.6176Z" fill="currentColor"/>
            <path d="M168.74 86.6557C170.141 86.6557 171.277 85.5199 171.277 84.1189C171.277 82.7178 170.141 81.582 168.74 81.582C167.339 81.582 166.203 82.7178 166.203 84.1189C166.203 85.5199 167.339 86.6557 168.74 86.6557Z" fill="currentColor"/>
            <path d="M186.838 77.2338C188.239 77.2338 189.374 76.098 189.374 74.697C189.374 73.2959 188.239 72.1602 186.838 72.1602C185.437 72.1602 184.301 73.2959 184.301 74.697C184.301 76.098 185.437 77.2338 186.838 77.2338Z" fill="currentColor"/>
            <path d="M205.687 69.4632C207.109 69.4632 208.261 68.3108 208.261 66.8893C208.261 65.4678 207.109 64.3154 205.687 64.3154C204.266 64.3154 203.113 65.4678 203.113 66.8893C203.113 68.3108 204.266 69.4632 205.687 69.4632Z" fill="currentColor"/>
            <path d="M225.147 63.264C226.533 63.264 227.657 62.1403 227.657 60.7541C227.657 59.3679 226.533 58.2441 225.147 58.2441C223.76 58.2441 222.637 59.3679 222.637 60.7541C222.637 62.1403 223.76 63.264 225.147 63.264Z" fill="currentColor"/>
            <path d="M245.069 58.848C246.455 58.848 247.578 57.7243 247.578 56.3381C247.578 54.9519 246.455 53.8281 245.069 53.8281C243.682 53.8281 242.559 54.9519 242.559 56.3381C242.559 57.7243 243.682 58.848 245.069 58.848Z" fill="currentColor"/>
            <path d="M265.295 56.2114C266.696 56.2114 267.832 55.0756 267.832 53.6745C267.832 52.2735 266.696 51.1377 265.295 51.1377C263.894 51.1377 262.758 52.2735 262.758 53.6745C262.758 55.0756 263.894 56.2114 265.295 56.2114Z" fill="currentColor"/>
            <path d="M285.677 55.3217C287.079 55.3217 288.214 54.1859 288.214 52.7849C288.214 51.3838 287.079 50.248 285.677 50.248C284.276 50.248 283.141 51.3838 283.141 52.7849C283.141 54.1859 284.276 55.3217 285.677 55.3217Z" fill="currentColor"/>
            <path d="M306.064 56.2114C307.465 56.2114 308.601 55.0756 308.601 53.6745C308.601 52.2735 307.465 51.1377 306.064 51.1377C304.663 51.1377 303.527 52.2735 303.527 53.6745C303.527 55.0756 304.663 56.2114 306.064 56.2114Z" fill="currentColor"/>
            <path d="M326.291 58.8745C327.692 58.8745 328.828 57.7387 328.828 56.3376C328.828 54.9366 327.692 53.8008 326.291 53.8008C324.89 53.8008 323.754 54.9366 323.754 56.3376C323.754 57.7387 324.89 58.8745 326.291 58.8745Z" fill="currentColor"/>
            <path d="M346.213 63.264C347.599 63.264 348.723 62.1403 348.723 60.7541C348.723 59.3679 347.599 58.2441 346.213 58.2441C344.827 58.2441 343.703 59.3679 343.703 60.7541C343.703 62.1403 344.827 63.264 346.213 63.264Z" fill="currentColor"/>
            <path d="M365.67 69.4262C367.071 69.4262 368.207 68.2905 368.207 66.8894C368.207 65.4883 367.071 64.3525 365.67 64.3525C364.269 64.3525 363.133 65.4883 363.133 66.8894C363.133 68.2905 364.269 69.4262 365.67 69.4262Z" fill="currentColor"/>
            <path d="M384.521 77.2338C385.922 77.2338 387.058 76.098 387.058 74.697C387.058 73.2959 385.922 72.1602 384.521 72.1602C383.12 72.1602 381.984 73.2959 381.984 74.697C381.984 76.098 383.12 77.2338 384.521 77.2338Z" fill="currentColor"/>
            <path d="M402.619 86.6557C404.02 86.6557 405.156 85.5199 405.156 84.1189C405.156 82.7178 404.02 81.582 402.619 81.582C401.218 81.582 400.082 82.7178 400.082 84.1189C400.082 85.5199 401.218 86.6557 402.619 86.6557Z" fill="currentColor"/>
            <path d="M419.826 97.6176C421.227 97.6176 422.363 96.4818 422.363 95.0808C422.363 93.6797 421.227 92.5439 419.826 92.5439C418.425 92.5439 417.289 93.6797 417.289 95.0808C417.289 96.4818 418.425 97.6176 419.826 97.6176Z" fill="currentColor"/>
            <path d="M436.013 110.039C437.414 110.039 438.55 108.903 438.55 107.502C438.55 106.101 437.414 104.965 436.013 104.965C434.612 104.965 433.477 106.101 433.477 107.502C433.477 108.903 434.612 110.039 436.013 110.039Z" fill="currentColor"/>
            <path d="M451.056 123.823C452.457 123.823 453.593 122.687 453.593 121.286C453.593 119.885 452.457 118.749 451.056 118.749C449.655 118.749 448.52 119.885 448.52 121.286C448.52 122.687 449.655 123.823 451.056 123.823Z" fill="currentColor"/>
            <path d="M464.838 138.866C466.239 138.866 467.374 137.73 467.374 136.329C467.374 134.928 466.239 133.792 464.838 133.792C463.437 133.792 462.301 134.928 462.301 136.329C462.301 137.73 463.437 138.866 464.838 138.866Z" fill="currentColor"/>
            <path d="M477.26 155.025C478.646 155.025 479.77 153.901 479.77 152.515C479.77 151.129 478.646 150.005 477.26 150.005C475.874 150.005 474.75 151.129 474.75 152.515C474.75 153.901 475.874 155.025 477.26 155.025Z" fill="currentColor"/>
            <path d="M488.22 172.26C489.621 172.26 490.757 171.124 490.757 169.723C490.757 168.322 489.621 167.187 488.22 167.187C486.819 167.187 485.684 168.322 485.684 169.723C485.684 171.124 486.819 172.26 488.22 172.26Z" fill="currentColor"/>
            <path d="M497.642 190.358C499.043 190.358 500.179 189.222 500.179 187.821C500.179 186.42 499.043 185.284 497.642 185.284C496.241 185.284 495.105 186.42 495.105 187.821C495.105 189.222 496.241 190.358 497.642 190.358Z" fill="currentColor"/>
            <path d="M505.451 209.207C506.852 209.207 507.988 208.072 507.988 206.671C507.988 205.27 506.852 204.134 505.451 204.134C504.05 204.134 502.914 205.27 502.914 206.671C502.914 208.072 504.05 209.207 505.451 209.207Z" fill="currentColor"/>
            <path d="M511.588 228.639C512.974 228.639 514.098 227.515 514.098 226.129C514.098 224.743 512.974 223.619 511.588 223.619C510.202 223.619 509.078 224.743 509.078 226.129C509.078 227.515 510.202 228.639 511.588 228.639Z" fill="currentColor"/>
            <path d="M516.002 248.585C517.403 248.585 518.539 247.45 518.539 246.049C518.539 244.648 517.403 243.512 516.002 243.512C514.601 243.512 513.465 244.648 513.465 246.049C513.465 247.45 514.601 248.585 516.002 248.585Z" fill="currentColor"/>
            <path d="M518.666 268.814C520.067 268.814 521.203 267.678 521.203 266.277C521.203 264.876 520.067 263.74 518.666 263.74C517.265 263.74 516.129 264.876 516.129 266.277C516.129 267.678 517.265 268.814 518.666 268.814Z" fill="currentColor"/>
            <path d="M32.3143 289.44C33.8491 289.44 35.0933 288.196 35.0933 286.661C35.0933 285.126 33.8491 283.882 32.3143 283.882C30.7794 283.882 29.5352 285.126 29.5352 286.661C29.5352 288.196 30.7794 289.44 32.3143 289.44Z" fill="currentColor"/>
            <path d="M33.1345 269.052C34.6694 269.052 35.9136 267.808 35.9136 266.273C35.9136 264.738 34.6694 263.494 33.1345 263.494C31.5997 263.494 30.3555 264.738 30.3555 266.273C30.3555 267.808 31.5997 269.052 33.1345 269.052Z" fill="currentColor"/>
            <path d="M35.5944 248.835C37.1502 248.835 38.4114 247.574 38.4114 246.018C38.4114 244.462 37.1502 243.201 35.5944 243.201C34.0386 243.201 32.7773 244.462 32.7773 246.018C32.7773 247.574 34.0386 248.835 35.5944 248.835Z" fill="currentColor"/>
            <path d="M39.6775 228.805C41.2124 228.805 42.4566 227.561 42.4566 226.026C42.4566 224.491 41.2124 223.247 39.6775 223.247C38.1427 223.247 36.8984 224.491 36.8984 226.026C36.8984 227.561 38.1427 228.805 39.6775 228.805Z" fill="currentColor"/>
            <path d="M45.3522 209.245C46.908 209.245 48.1693 207.984 48.1693 206.428C48.1693 204.873 46.908 203.611 45.3522 203.611C43.7964 203.611 42.5352 204.873 42.5352 206.428C42.5352 207.984 43.7964 209.245 45.3522 209.245Z" fill="currentColor"/>
            <path d="M52.5866 190.167C54.1424 190.167 55.4036 188.906 55.4036 187.35C55.4036 185.794 54.1424 184.533 52.5866 184.533C51.0308 184.533 49.7695 185.794 49.7695 187.35C49.7695 188.906 51.0308 190.167 52.5866 190.167Z" fill="currentColor"/>
            <path d="M61.3338 171.695C62.8686 171.695 64.1129 170.451 64.1129 168.916C64.1129 167.381 62.8686 166.137 61.3338 166.137C59.7989 166.137 58.5547 167.381 58.5547 168.916C58.5547 170.451 59.7989 171.695 61.3338 171.695Z" fill="currentColor"/>
            <path d="M71.5369 154.025C73.0718 154.025 74.316 152.781 74.316 151.246C74.316 149.711 73.0718 148.467 71.5369 148.467C70.0021 148.467 68.7578 149.711 68.7578 151.246C68.7578 152.781 70.0021 154.025 71.5369 154.025Z" fill="currentColor"/>
            <path d="M83.1268 137.233C84.6616 137.233 85.9058 135.989 85.9058 134.454C85.9058 132.919 84.6616 131.675 83.1268 131.675C81.5919 131.675 80.3477 132.919 80.3477 134.454C80.3477 135.989 81.5919 137.233 83.1268 137.233Z" fill="currentColor"/>
            <path d="M96.033 121.427C97.5678 121.427 98.8121 120.183 98.8121 118.648C98.8121 117.113 97.5678 115.869 96.033 115.869C94.4981 115.869 93.2539 117.113 93.2539 118.648C93.2539 120.183 94.4981 121.427 96.033 121.427Z" fill="currentColor"/>
            <path d="M110.166 106.685C111.686 106.685 112.918 105.453 112.918 103.933C112.918 102.413 111.686 101.181 110.166 101.181C108.646 101.181 107.414 102.413 107.414 103.933C107.414 105.453 108.646 106.685 110.166 106.685Z" fill="currentColor"/>
            <path d="M125.439 93.1812C126.974 93.1812 128.218 91.937 128.218 90.4021C128.218 88.8673 126.974 87.623 125.439 87.623C123.904 87.623 122.66 88.8673 122.66 90.4021C122.66 91.937 123.904 93.1812 125.439 93.1812Z" fill="currentColor"/>
            <path d="M141.752 80.9244C143.287 80.9244 144.531 79.6802 144.531 78.1453C144.531 76.6105 143.287 75.3662 141.752 75.3662C140.217 75.3662 138.973 76.6105 138.973 78.1453C138.973 79.6802 140.217 80.9244 141.752 80.9244Z" fill="currentColor"/>
            <path d="M158.998 70.0191C160.533 70.0191 161.777 68.7749 161.777 67.24C161.777 65.7052 160.533 64.4609 158.998 64.4609C157.463 64.4609 156.219 65.7052 156.219 67.24C156.219 68.7749 157.463 70.0191 158.998 70.0191Z" fill="currentColor"/>
            <path d="M177.065 60.5102C178.585 60.5102 179.817 59.278 179.817 57.758C179.817 56.2381 178.585 55.0059 177.065 55.0059C175.545 55.0059 174.312 56.2381 174.312 57.758C174.312 59.278 175.545 60.5102 177.065 60.5102Z" fill="currentColor"/>
            <path d="M195.834 52.5396C197.369 52.5396 198.613 51.2954 198.613 49.7605C198.613 48.2257 197.369 46.9814 195.834 46.9814C194.299 46.9814 193.055 48.2257 193.055 49.7605C193.055 51.2954 194.299 52.5396 195.834 52.5396Z" fill="currentColor"/>
            <path d="M215.188 46.1156C216.744 46.1156 218.005 44.8543 218.005 43.2985C218.005 41.7427 216.744 40.4814 215.188 40.4814C213.632 40.4814 212.371 41.7427 212.371 43.2985C212.371 44.8543 213.632 46.1156 215.188 46.1156Z" fill="currentColor"/>
            <path d="M234.998 41.1684C236.518 41.1684 237.75 39.9362 237.75 38.4162C237.75 36.8963 236.518 35.6641 234.998 35.6641C233.478 35.6641 232.246 36.8963 232.246 38.4162C232.246 39.9362 233.478 41.1684 234.998 41.1684Z" fill="currentColor"/>
            <path d="M255.138 37.9224C256.673 37.9224 257.918 36.6782 257.918 35.1434C257.918 33.6085 256.673 32.3643 255.138 32.3643C253.604 32.3643 252.359 33.6085 252.359 35.1434C252.359 36.6782 253.604 37.9224 255.138 37.9224Z" fill="currentColor"/>
            <path d="M275.478 36.2799C277.013 36.2799 278.257 35.0356 278.257 33.5008C278.257 31.9659 277.013 30.7217 275.478 30.7217C273.943 30.7217 272.699 31.9659 272.699 33.5008C272.699 35.0356 273.943 36.2799 275.478 36.2799Z" fill="currentColor"/>
            <path d="M295.881 36.2534C297.401 36.2534 298.633 35.0212 298.633 33.5012C298.633 31.9812 297.401 30.749 295.881 30.749C294.361 30.749 293.129 31.9812 293.129 33.5012C293.129 35.0212 294.361 36.2534 295.881 36.2534Z" fill="currentColor"/>
            <path d="M316.22 37.9224C317.755 37.9224 319 36.6782 319 35.1434C319 33.6085 317.755 32.3643 316.22 32.3643C314.686 32.3643 313.441 33.6085 313.441 35.1434C313.441 36.6782 314.686 37.9224 316.22 37.9224Z" fill="currentColor"/>
            <path d="M336.361 41.1949C337.896 41.1949 339.14 39.9507 339.14 38.4158C339.14 36.881 337.896 35.6367 336.361 35.6367C334.826 35.6367 333.582 36.881 333.582 38.4158C333.582 39.9507 334.826 41.1949 336.361 41.1949Z" fill="currentColor"/>
            <path d="M356.17 46.0512C357.69 46.0512 358.922 44.819 358.922 43.2991C358.922 41.7791 357.69 40.5469 356.17 40.5469C354.65 40.5469 353.418 41.7791 353.418 43.2991C353.418 44.819 354.65 46.0512 356.17 46.0512Z" fill="currentColor"/>
            <path d="M375.524 52.5775C377.08 52.5775 378.341 51.3162 378.341 49.7604C378.341 48.2046 377.08 46.9434 375.524 46.9434C373.968 46.9434 372.707 48.2046 372.707 49.7604C372.707 51.3162 373.968 52.5775 375.524 52.5775Z" fill="currentColor"/>
            <path d="M394.295 60.5367C395.83 60.5367 397.074 59.2925 397.074 57.7576C397.074 56.2228 395.83 54.9785 394.295 54.9785C392.76 54.9785 391.516 56.2228 391.516 57.7576C391.516 59.2925 392.76 60.5367 394.295 60.5367Z" fill="currentColor"/>
            <path d="M412.364 70.057C413.92 70.057 415.181 68.7958 415.181 67.2399C415.181 65.6841 413.92 64.4229 412.364 64.4229C410.808 64.4229 409.547 65.6841 409.547 67.2399C409.547 68.7958 410.808 70.057 412.364 70.057Z" fill="currentColor"/>
            <path d="M429.607 80.9244C431.142 80.9244 432.386 79.6802 432.386 78.1453C432.386 76.6105 431.142 75.3662 429.607 75.3662C428.072 75.3662 426.828 76.6105 426.828 78.1453C426.828 79.6802 428.072 80.9244 429.607 80.9244Z" fill="currentColor"/>
            <path d="M445.92 93.1812C447.455 93.1812 448.699 91.937 448.699 90.4021C448.699 88.8673 447.455 87.623 445.92 87.623C444.385 87.623 443.141 88.8673 443.141 90.4021C443.141 91.937 444.385 93.1812 445.92 93.1812Z" fill="currentColor"/>
            <path d="M461.193 106.712C462.728 106.712 463.972 105.468 463.972 103.933C463.972 102.399 462.728 101.154 461.193 101.154C459.658 101.154 458.414 102.399 458.414 103.933C458.414 105.468 459.658 106.712 461.193 106.712Z" fill="currentColor"/>
            <path d="M475.326 121.427C476.861 121.427 478.105 120.183 478.105 118.648C478.105 117.113 476.861 115.869 475.326 115.869C473.791 115.869 472.547 117.113 472.547 118.648C472.547 120.183 473.791 121.427 475.326 121.427Z" fill="currentColor"/>
            <path d="M488.232 137.233C489.767 137.233 491.011 135.989 491.011 134.454C491.011 132.919 489.767 131.675 488.232 131.675C486.697 131.675 485.453 132.919 485.453 134.454C485.453 135.989 486.697 137.233 488.232 137.233Z" fill="currentColor"/>
            <path d="M499.822 154.025C501.357 154.025 502.601 152.781 502.601 151.246C502.601 149.711 501.357 148.467 499.822 148.467C498.287 148.467 497.043 149.711 497.043 151.246C497.043 152.781 498.287 154.025 499.822 154.025Z" fill="currentColor"/>
            <path d="M510.025 171.695C511.56 171.695 512.804 170.451 512.804 168.916C512.804 167.381 511.56 166.137 510.025 166.137C508.49 166.137 507.246 167.381 507.246 168.916C507.246 170.451 508.49 171.695 510.025 171.695Z" fill="currentColor"/>
            <path d="M518.771 190.129C520.306 190.129 521.55 188.885 521.55 187.35C521.55 185.816 520.306 184.571 518.771 184.571C517.236 184.571 515.992 185.816 515.992 187.35C515.992 188.885 517.236 190.129 518.771 190.129Z" fill="currentColor"/>
            <path d="M526.006 209.18C527.526 209.18 528.758 207.948 528.758 206.428C528.758 204.908 527.526 203.676 526.006 203.676C524.486 203.676 523.254 204.908 523.254 206.428C523.254 207.948 524.486 209.18 526.006 209.18Z" fill="currentColor"/>
            <path d="M531.681 228.805C533.216 228.805 534.461 227.561 534.461 226.026C534.461 224.491 533.216 223.247 531.681 223.247C530.147 223.247 528.902 224.491 528.902 226.026C528.902 227.561 530.147 228.805 531.681 228.805Z" fill="currentColor"/>
            <path d="M535.764 248.797C537.298 248.797 538.543 247.553 538.543 246.018C538.543 244.484 537.298 243.239 535.764 243.239C534.229 243.239 532.984 244.484 532.984 246.018C532.984 247.553 534.229 248.797 535.764 248.797Z" fill="currentColor"/>
            <path d="M538.224 269.052C539.759 269.052 541.004 267.808 541.004 266.273C541.004 264.738 539.759 263.494 538.224 263.494C536.69 263.494 535.445 264.738 535.445 266.273C535.445 267.808 536.69 269.052 538.224 269.052Z" fill="currentColor"/>
            <path d="M539.045 289.44C540.58 289.44 541.824 288.196 541.824 286.661C541.824 285.126 540.58 283.882 539.045 283.882C537.51 283.882 536.266 285.126 536.266 286.661C536.266 288.196 537.51 289.44 539.045 289.44Z" fill="currentColor"/>
            <path d="M538.223 309.892C539.794 309.892 541.067 308.619 541.067 307.048C541.067 305.477 539.794 304.204 538.223 304.204C536.652 304.204 535.379 305.477 535.379 307.048C535.379 308.619 536.652 309.892 538.223 309.892Z" fill="currentColor"/>
            <path d="M535.764 330.083C537.298 330.083 538.543 328.838 538.543 327.303C538.543 325.769 537.298 324.524 535.764 324.524C534.229 324.524 532.984 325.769 532.984 327.303C532.984 328.838 534.229 330.083 535.764 330.083Z" fill="currentColor"/>
            <path d="M531.681 350.074C533.216 350.074 534.461 348.83 534.461 347.295C534.461 345.76 533.216 344.516 531.681 344.516C530.147 344.516 528.902 345.76 528.902 347.295C528.902 348.83 530.147 350.074 531.681 350.074Z" fill="currentColor"/>
            <path d="M526.006 369.672C527.54 369.672 528.785 368.428 528.785 366.893C528.785 365.358 527.54 364.114 526.006 364.114C524.471 364.114 523.227 365.358 523.227 366.893C523.227 368.428 524.471 369.672 526.006 369.672Z" fill="currentColor"/>
            <path d="M518.771 388.751C520.306 388.751 521.55 387.506 521.55 385.972C521.55 384.437 520.306 383.192 518.771 383.192C517.236 383.192 515.992 384.437 515.992 385.972C515.992 387.506 517.236 388.751 518.771 388.751Z" fill="currentColor"/>
            <path d="M510.024 407.223C511.58 407.223 512.841 405.962 512.841 404.406C512.841 402.85 511.58 401.589 510.024 401.589C508.468 401.589 507.207 402.85 507.207 404.406C507.207 405.962 508.468 407.223 510.024 407.223Z" fill="currentColor"/>
            <path d="M499.822 424.855C501.357 424.855 502.601 423.611 502.601 422.076C502.601 420.541 501.357 419.297 499.822 419.297C498.287 419.297 497.043 420.541 497.043 422.076C497.043 423.611 498.287 424.855 499.822 424.855Z" fill="currentColor"/>
            <path d="M488.232 441.648C489.767 441.648 491.011 440.404 491.011 438.869C491.011 437.334 489.767 436.09 488.232 436.09C486.697 436.09 485.453 437.334 485.453 438.869C485.453 440.404 486.697 441.648 488.232 441.648Z" fill="currentColor"/>
            <path d="M475.326 457.453C476.861 457.453 478.105 456.208 478.105 454.674C478.105 453.139 476.861 451.895 475.326 451.895C473.791 451.895 472.547 453.139 472.547 454.674C472.547 456.208 473.791 457.453 475.326 457.453Z" fill="currentColor"/>
            <path d="M461.193 472.168C462.728 472.168 463.972 470.924 463.972 469.389C463.972 467.855 462.728 466.61 461.193 466.61C459.658 466.61 458.414 467.855 458.414 469.389C458.414 470.924 459.658 472.168 461.193 472.168Z" fill="currentColor"/>
            <path d="M445.92 485.698C447.455 485.698 448.699 484.454 448.699 482.919C448.699 481.384 447.455 480.14 445.92 480.14C444.385 480.14 443.141 481.384 443.141 482.919C443.141 484.454 444.385 485.698 445.92 485.698Z" fill="currentColor"/>
            <path d="M429.607 497.956C431.142 497.956 432.386 496.711 432.386 495.177C432.386 493.642 431.142 492.397 429.607 492.397C428.072 492.397 426.828 493.642 426.828 495.177C426.828 496.711 428.072 497.956 429.607 497.956Z" fill="currentColor"/>
            <path d="M412.361 508.861C413.896 508.861 415.14 507.617 415.14 506.082C415.14 504.547 413.896 503.303 412.361 503.303C410.826 503.303 409.582 504.547 409.582 506.082C409.582 507.617 410.826 508.861 412.361 508.861Z" fill="currentColor"/>
            <path d="M394.294 518.381C395.849 518.381 397.111 517.12 397.111 515.564C397.111 514.008 395.849 512.747 394.294 512.747C392.738 512.747 391.477 514.008 391.477 515.564C391.477 517.12 392.738 518.381 394.294 518.381Z" fill="currentColor"/>
            <path d="M375.525 526.341C377.06 526.341 378.304 525.097 378.304 523.562C378.304 522.027 377.06 520.783 375.525 520.783C373.99 520.783 372.746 522.027 372.746 523.562C372.746 525.097 373.99 526.341 375.525 526.341Z" fill="currentColor"/>
            <path d="M356.17 532.802C357.705 532.802 358.949 531.558 358.949 530.023C358.949 528.488 357.705 527.244 356.17 527.244C354.635 527.244 353.391 528.488 353.391 530.023C353.391 531.558 354.635 532.802 356.17 532.802Z" fill="currentColor"/>
            <path d="M336.36 537.724C337.916 537.724 339.177 536.463 339.177 534.907C339.177 533.351 337.916 532.09 336.36 532.09C334.804 532.09 333.543 533.351 333.543 534.907C333.543 536.463 334.804 537.724 336.36 537.724Z" fill="currentColor"/>
            <path d="M316.22 540.959C317.755 540.959 319 539.714 319 538.18C319 536.645 317.755 535.4 316.22 535.4C314.686 535.4 313.441 536.645 313.441 538.18C313.441 539.714 314.686 540.959 316.22 540.959Z" fill="currentColor"/>
            <path d="M295.881 542.6C297.416 542.6 298.66 541.356 298.66 539.821C298.66 538.286 297.416 537.042 295.881 537.042C294.346 537.042 293.102 538.286 293.102 539.821C293.102 541.356 294.346 542.6 295.881 542.6Z" fill="currentColor"/>
            <path d="M275.477 542.638C277.033 542.638 278.294 541.377 278.294 539.821C278.294 538.265 277.033 537.004 275.477 537.004C273.921 537.004 272.66 538.265 272.66 539.821C272.66 541.377 273.921 542.638 275.477 542.638Z" fill="currentColor"/>
            <path d="M255.138 540.959C256.673 540.959 257.918 539.714 257.918 538.18C257.918 536.645 256.673 535.4 255.138 535.4C253.604 535.4 252.359 536.645 252.359 538.18C252.359 539.714 253.604 540.959 255.138 540.959Z" fill="currentColor"/>
            <path d="M234.998 537.685C236.533 537.685 237.777 536.441 237.777 534.906C237.777 533.371 236.533 532.127 234.998 532.127C233.463 532.127 232.219 533.371 232.219 534.906C232.219 536.441 233.463 537.685 234.998 537.685Z" fill="currentColor"/>
            <path d="M215.188 532.84C216.744 532.84 218.005 531.579 218.005 530.023C218.005 528.467 216.744 527.206 215.188 527.206C213.632 527.206 212.371 528.467 212.371 530.023C212.371 531.579 213.632 532.84 215.188 532.84Z" fill="currentColor"/>
            <path d="M195.834 526.341C197.369 526.341 198.613 525.097 198.613 523.562C198.613 522.027 197.369 520.783 195.834 520.783C194.299 520.783 193.055 522.027 193.055 523.562C193.055 525.097 194.299 526.341 195.834 526.341Z" fill="currentColor"/>
            <path d="M177.063 518.381C178.619 518.381 179.88 517.12 179.88 515.564C179.88 514.008 178.619 512.747 177.063 512.747C175.507 512.747 174.246 514.008 174.246 515.564C174.246 517.12 175.507 518.381 177.063 518.381Z" fill="currentColor"/>
            <path d="M158.998 508.861C160.533 508.861 161.777 507.617 161.777 506.082C161.777 504.547 160.533 503.303 158.998 503.303C157.463 503.303 156.219 504.547 156.219 506.082C156.219 507.617 157.463 508.861 158.998 508.861Z" fill="currentColor"/>
            <path d="M141.752 497.956C143.287 497.956 144.531 496.711 144.531 495.177C144.531 493.642 143.287 492.397 141.752 492.397C140.217 492.397 138.973 493.642 138.973 495.177C138.973 496.711 140.217 497.956 141.752 497.956Z" fill="currentColor"/>
            <path d="M125.439 485.698C126.974 485.698 128.218 484.454 128.218 482.919C128.218 481.384 126.974 480.14 125.439 480.14C123.904 480.14 122.66 481.384 122.66 482.919C122.66 484.454 123.904 485.698 125.439 485.698Z" fill="currentColor"/>
            <path d="M110.166 472.168C111.701 472.168 112.945 470.924 112.945 469.389C112.945 467.855 111.701 466.61 110.166 466.61C108.631 466.61 107.387 467.855 107.387 469.389C107.387 470.924 108.631 472.168 110.166 472.168Z" fill="currentColor"/>
            <path d="M96.033 457.453C97.5678 457.453 98.8121 456.208 98.8121 454.674C98.8121 453.139 97.5678 451.895 96.033 451.895C94.4981 451.895 93.2539 453.139 93.2539 454.674C93.2539 456.208 94.4981 457.453 96.033 457.453Z" fill="currentColor"/>
            <path d="M83.1268 441.648C84.6616 441.648 85.9058 440.404 85.9058 438.869C85.9058 437.334 84.6616 436.09 83.1268 436.09C81.5919 436.09 80.3477 437.334 80.3477 438.869C80.3477 440.404 81.5919 441.648 83.1268 441.648Z" fill="currentColor"/>
            <path d="M71.5369 424.855C73.0718 424.855 74.316 423.611 74.316 422.076C74.316 420.541 73.0718 419.297 71.5369 419.297C70.0021 419.297 68.7578 420.541 68.7578 422.076C68.7578 423.611 70.0021 424.855 71.5369 424.855Z" fill="currentColor"/>
            <path d="M61.3342 407.158C62.8542 407.158 64.0864 405.926 64.0864 404.406C64.0864 402.886 62.8542 401.653 61.3342 401.653C59.8142 401.653 58.582 402.886 58.582 404.406C58.582 405.926 59.8142 407.158 61.3342 407.158Z" fill="currentColor"/>
            <path d="M52.5877 388.751C54.1225 388.751 55.3668 387.506 55.3668 385.972C55.3668 384.437 54.1225 383.192 52.5877 383.192C51.0528 383.192 49.8086 384.437 49.8086 385.972C49.8086 387.506 51.0528 388.751 52.5877 388.751Z" fill="currentColor"/>
            <path d="M45.3522 369.711C46.908 369.711 48.1693 368.45 48.1693 366.894C48.1693 365.338 46.908 364.077 45.3522 364.077C43.7964 364.077 42.5352 365.338 42.5352 366.894C42.5352 368.45 43.7964 369.711 45.3522 369.711Z" fill="currentColor"/>
            <path d="M39.6775 350.074C41.2124 350.074 42.4566 348.83 42.4566 347.295C42.4566 345.76 41.2124 344.516 39.6775 344.516C38.1427 344.516 36.8984 345.76 36.8984 347.295C36.8984 348.83 38.1427 350.074 39.6775 350.074Z" fill="currentColor"/>
            <path d="M35.5955 330.083C37.1303 330.083 38.3746 328.838 38.3746 327.303C38.3746 325.769 37.1303 324.524 35.5955 324.524C34.0606 324.524 32.8164 325.769 32.8164 327.303C32.8164 328.838 34.0606 330.083 35.5955 330.083Z" fill="currentColor"/>
            <path d="M33.1345 309.828C34.6694 309.828 35.9136 308.583 35.9136 307.049C35.9136 305.514 34.6694 304.27 33.1345 304.27C31.5997 304.27 30.3555 305.514 30.3555 307.049C30.3555 308.583 31.5997 309.828 33.1345 309.828Z" fill="currentColor"/>
            <path d="M558.533 289.682C560.202 289.682 561.554 288.33 561.554 286.661C561.554 284.992 560.202 283.64 558.533 283.64C556.864 283.64 555.512 284.992 555.512 286.661C555.512 288.33 556.864 289.682 558.533 289.682Z" fill="currentColor"/>
            <path d="M557.772 310.046C559.426 310.046 560.766 308.706 560.766 307.052C560.766 305.398 559.426 304.058 557.772 304.058C556.118 304.058 554.777 305.398 554.777 307.052C554.777 308.706 556.118 310.046 557.772 310.046Z" fill="currentColor"/>
            <path d="M555.486 330.349C557.155 330.349 558.507 328.997 558.507 327.328C558.507 325.659 557.155 324.307 555.486 324.307C553.818 324.307 552.465 325.659 552.465 327.328C552.465 328.997 553.818 330.349 555.486 330.349Z" fill="currentColor"/>
            <path d="M551.693 350.398C553.362 350.398 554.715 349.045 554.715 347.377C554.715 345.708 553.362 344.355 551.693 344.355C550.025 344.355 548.672 345.708 548.672 347.377C548.672 349.045 550.025 350.398 551.693 350.398Z" fill="currentColor"/>
            <path d="M546.412 370.108C548.081 370.108 549.433 368.755 549.433 367.087C549.433 365.418 548.081 364.065 546.412 364.065C544.743 364.065 543.391 365.418 543.391 367.087C543.391 368.755 544.743 370.108 546.412 370.108Z" fill="currentColor"/>
            <path d="M539.674 389.368C541.342 389.368 542.695 388.015 542.695 386.347C542.695 384.678 541.342 383.325 539.674 383.325C538.005 383.325 536.652 384.678 536.652 386.347C536.652 388.015 538.005 389.368 539.674 389.368Z" fill="currentColor"/>
            <path d="M531.514 408.043C533.168 408.043 534.508 406.702 534.508 405.048C534.508 403.394 533.168 402.054 531.514 402.054C529.86 402.054 528.52 403.394 528.52 405.048C528.52 406.702 529.86 408.043 531.514 408.043Z" fill="currentColor"/>
            <path d="M521.978 426.11C523.647 426.11 525 424.757 525 423.089C525 421.42 523.647 420.067 521.978 420.067C520.31 420.067 518.957 421.42 518.957 423.089C518.957 424.757 520.31 426.11 521.978 426.11Z" fill="currentColor"/>
            <path d="M511.123 443.387C512.792 443.387 514.144 442.035 514.144 440.366C514.144 438.697 512.792 437.345 511.123 437.345C509.454 437.345 508.102 438.697 508.102 440.366C508.102 442.035 509.454 443.387 511.123 443.387Z" fill="currentColor"/>
            <path d="M499.006 459.805C500.674 459.805 502.027 458.453 502.027 456.784C502.027 455.115 500.674 453.763 499.006 453.763C497.337 453.763 495.984 455.115 495.984 456.784C495.984 458.453 497.337 459.805 499.006 459.805Z" fill="currentColor"/>
            <path d="M485.697 475.271C487.366 475.271 488.718 473.918 488.718 472.25C488.718 470.581 487.366 469.229 485.697 469.229C484.028 469.229 482.676 470.581 482.676 472.25C482.676 473.918 484.028 475.271 485.697 475.271Z" fill="currentColor"/>
            <path d="M471.267 489.7C472.936 489.7 474.289 488.347 474.289 486.679C474.289 485.01 472.936 483.657 471.267 483.657C469.599 483.657 468.246 485.01 468.246 486.679C468.246 488.347 469.599 489.7 471.267 489.7Z" fill="currentColor"/>
            <path d="M455.803 503.009C457.471 503.009 458.824 501.657 458.824 499.988C458.824 498.319 457.471 496.967 455.803 496.967C454.134 496.967 452.781 498.319 452.781 499.988C452.781 501.657 454.134 503.009 455.803 503.009Z" fill="currentColor"/>
            <path d="M439.385 515.126C441.053 515.126 442.406 513.773 442.406 512.104C442.406 510.436 441.053 509.083 439.385 509.083C437.716 509.083 436.363 510.436 436.363 512.104C436.363 513.773 437.716 515.126 439.385 515.126Z" fill="currentColor"/>
            <path d="M422.107 525.982C423.776 525.982 425.129 524.629 425.129 522.961C425.129 521.292 423.776 519.939 422.107 519.939C420.439 519.939 419.086 521.292 419.086 522.961C419.086 524.629 420.439 525.982 422.107 525.982Z" fill="currentColor"/>
            <path d="M404.068 535.516C405.737 535.516 407.09 534.164 407.09 532.495C407.09 530.826 405.737 529.474 404.068 529.474C402.4 529.474 401.047 530.826 401.047 532.495C401.047 534.164 402.4 535.516 404.068 535.516Z" fill="currentColor"/>
            <path d="M385.365 543.676C387.034 543.676 388.386 542.323 388.386 540.654C388.386 538.986 387.034 537.633 385.365 537.633C383.696 537.633 382.344 538.986 382.344 540.654C382.344 542.323 383.696 543.676 385.365 543.676Z" fill="currentColor"/>
            <path d="M366.103 550.416C367.772 550.416 369.125 549.063 369.125 547.394C369.125 545.726 367.772 544.373 366.103 544.373C364.435 544.373 363.082 545.726 363.082 547.394C363.082 549.063 364.435 550.416 366.103 550.416Z" fill="currentColor"/>
            <path d="M346.396 555.697C348.065 555.697 349.418 554.344 349.418 552.676C349.418 551.007 348.065 549.654 346.396 549.654C344.728 549.654 343.375 551.007 343.375 552.676C343.375 554.344 344.728 555.697 346.396 555.697Z" fill="currentColor"/>
            <path d="M326.346 559.49C328.014 559.49 329.367 558.137 329.367 556.469C329.367 554.8 328.014 553.447 326.346 553.447C324.677 553.447 323.324 554.8 323.324 556.469C323.324 558.137 324.677 559.49 326.346 559.49Z" fill="currentColor"/>
            <path d="M306.068 561.774C307.737 561.774 309.09 560.421 309.09 558.753C309.09 557.084 307.737 555.731 306.068 555.731C304.4 555.731 303.047 557.084 303.047 558.753C303.047 560.421 304.4 561.774 306.068 561.774Z" fill="currentColor"/>
            <path d="M285.678 562.538C287.346 562.538 288.699 561.185 288.699 559.516C288.699 557.848 287.346 556.495 285.678 556.495C284.009 556.495 282.656 557.848 282.656 559.516C282.656 561.185 284.009 562.538 285.678 562.538Z" fill="currentColor"/>
            <path d="M265.291 561.814C266.981 561.814 268.351 560.444 268.351 558.754C268.351 557.064 266.981 555.693 265.291 555.693C263.601 555.693 262.23 557.064 262.23 558.754C262.23 560.444 263.601 561.814 265.291 561.814Z" fill="currentColor"/>
            <path d="M245.014 559.49C246.682 559.49 248.035 558.137 248.035 556.469C248.035 554.8 246.682 553.447 245.014 553.447C243.345 553.447 241.992 554.8 241.992 556.469C241.992 558.137 243.345 559.49 245.014 559.49Z" fill="currentColor"/>
            <path d="M224.963 555.697C226.631 555.697 227.984 554.344 227.984 552.676C227.984 551.007 226.631 549.654 224.963 549.654C223.294 549.654 221.941 551.007 221.941 552.676C221.941 554.344 223.294 555.697 224.963 555.697Z" fill="currentColor"/>
            <path d="M205.252 550.388C206.906 550.388 208.247 549.048 208.247 547.394C208.247 545.74 206.906 544.399 205.252 544.399C203.598 544.399 202.258 545.74 202.258 547.394C202.258 549.048 203.598 550.388 205.252 550.388Z" fill="currentColor"/>
            <path d="M185.994 543.742C187.699 543.742 189.081 542.36 189.081 540.655C189.081 538.95 187.699 537.567 185.994 537.567C184.288 537.567 182.906 538.95 182.906 540.655C182.906 542.36 184.288 543.742 185.994 543.742Z" fill="currentColor"/>
            <path d="M167.291 535.516C168.96 535.516 170.312 534.164 170.312 532.495C170.312 530.826 168.96 529.474 167.291 529.474C165.622 529.474 164.27 530.826 164.27 532.495C164.27 534.164 165.622 535.516 167.291 535.516Z" fill="currentColor"/>
            <path d="M149.252 525.982C150.92 525.982 152.273 524.629 152.273 522.961C152.273 521.292 150.92 519.939 149.252 519.939C147.583 519.939 146.23 521.292 146.23 522.961C146.23 524.629 147.583 525.982 149.252 525.982Z" fill="currentColor"/>
            <path d="M131.974 515.126C133.643 515.126 134.996 513.773 134.996 512.104C134.996 510.436 133.643 509.083 131.974 509.083C130.306 509.083 128.953 510.436 128.953 512.104C128.953 513.773 130.306 515.126 131.974 515.126Z" fill="currentColor"/>
            <path d="M115.557 503.009C117.225 503.009 118.578 501.657 118.578 499.988C118.578 498.319 117.225 496.967 115.557 496.967C113.888 496.967 112.535 498.319 112.535 499.988C112.535 501.657 113.888 503.009 115.557 503.009Z" fill="currentColor"/>
            <path d="M100.092 489.7C101.76 489.7 103.113 488.347 103.113 486.679C103.113 485.01 101.76 483.657 100.092 483.657C98.423 483.657 97.0703 485.01 97.0703 486.679C97.0703 488.347 98.423 489.7 100.092 489.7Z" fill="currentColor"/>
            <path d="M85.6618 475.31C87.3519 475.31 88.722 473.94 88.722 472.25C88.722 470.56 87.3519 469.189 85.6618 469.189C83.9717 469.189 82.6016 470.56 82.6016 472.25C82.6016 473.94 83.9717 475.31 85.6618 475.31Z" fill="currentColor"/>
            <path d="M72.3534 459.805C74.022 459.805 75.3747 458.453 75.3747 456.784C75.3747 455.115 74.022 453.763 72.3534 453.763C70.6847 453.763 69.332 455.115 69.332 456.784C69.332 458.453 70.6847 459.805 72.3534 459.805Z" fill="currentColor"/>
            <path d="M60.2362 443.387C61.9048 443.387 63.2575 442.035 63.2575 440.366C63.2575 438.697 61.9048 437.345 60.2362 437.345C58.5675 437.345 57.2148 438.697 57.2148 440.366C57.2148 442.035 58.5675 443.387 60.2362 443.387Z" fill="currentColor"/>
            <path d="M49.3806 426.149C51.0707 426.149 52.4408 424.779 52.4408 423.089C52.4408 421.398 51.0707 420.028 49.3806 420.028C47.6904 420.028 46.3203 421.398 46.3203 423.089C46.3203 424.779 47.6904 426.149 49.3806 426.149Z" fill="currentColor"/>
            <path d="M39.8455 408.07C41.5142 408.07 42.8669 406.717 42.8669 405.049C42.8669 403.38 41.5142 402.027 39.8455 402.027C38.1769 402.027 36.8242 403.38 36.8242 405.049C36.8242 406.717 38.1769 408.07 39.8455 408.07Z" fill="currentColor"/>
            <path d="M31.6854 389.368C33.354 389.368 34.7067 388.015 34.7067 386.347C34.7067 384.678 33.354 383.325 31.6854 383.325C30.0168 383.325 28.6641 384.678 28.6641 386.347C28.6641 388.015 30.0168 389.368 31.6854 389.368Z" fill="currentColor"/>
            <path d="M24.947 370.147C26.6371 370.147 28.0072 368.777 28.0072 367.087C28.0072 365.397 26.6371 364.026 24.947 364.026C23.2568 364.026 21.8867 365.397 21.8867 367.087C21.8867 368.777 23.2568 370.147 24.947 370.147Z" fill="currentColor"/>
            <path d="M19.6659 350.398C21.3345 350.398 22.6872 349.045 22.6872 347.377C22.6872 345.708 21.3345 344.355 19.6659 344.355C17.9972 344.355 16.6445 345.708 16.6445 347.377C16.6445 349.045 17.9972 350.398 19.6659 350.398Z" fill="currentColor"/>
            <path d="M15.8728 330.388C17.5629 330.388 18.933 329.018 18.933 327.328C18.933 325.638 17.5629 324.268 15.8728 324.268C14.1826 324.268 12.8125 325.638 12.8125 327.328C12.8125 329.018 14.1826 330.388 15.8728 330.388Z" fill="currentColor"/>
            <path d="M13.5876 310.112C15.2777 310.112 16.6479 308.742 16.6479 307.051C16.6479 305.361 15.2777 303.991 13.5876 303.991C11.8975 303.991 10.5273 305.361 10.5273 307.051C10.5273 308.742 11.8975 310.112 13.5876 310.112Z" fill="currentColor"/>
            <path d="M12.8259 289.721C14.516 289.721 15.8861 288.351 15.8861 286.661C15.8861 284.971 14.516 283.601 12.8259 283.601C11.1357 283.601 9.76562 284.971 9.76562 286.661C9.76562 288.351 11.1357 289.721 12.8259 289.721Z" fill="currentColor"/>
            <path d="M13.5877 269.292C15.2564 269.292 16.6091 267.939 16.6091 266.27C16.6091 264.602 15.2564 263.249 13.5877 263.249C11.9191 263.249 10.5664 264.602 10.5664 266.27C10.5664 267.939 11.9191 269.292 13.5877 269.292Z" fill="currentColor"/>
            <path d="M15.8728 249.054C17.5629 249.054 18.933 247.684 18.933 245.994C18.933 244.304 17.5629 242.934 15.8728 242.934C14.1826 242.934 12.8125 244.304 12.8125 245.994C12.8125 247.684 14.1826 249.054 15.8728 249.054Z" fill="currentColor"/>
            <path d="M19.6659 228.966C21.3345 228.966 22.6872 227.614 22.6872 225.945C22.6872 224.277 21.3345 222.924 19.6659 222.924C17.9972 222.924 16.6445 224.277 16.6445 225.945C16.6445 227.614 17.9972 228.966 19.6659 228.966Z" fill="currentColor"/>
            <path d="M24.9471 209.257C26.6157 209.257 27.9684 207.904 27.9684 206.235C27.9684 204.567 26.6157 203.214 24.9471 203.214C23.2785 203.214 21.9258 204.567 21.9258 206.235C21.9258 207.904 23.2785 209.257 24.9471 209.257Z" fill="currentColor"/>
            <path d="M31.6853 190.036C33.3754 190.036 34.7455 188.665 34.7455 186.975C34.7455 185.285 33.3754 183.915 31.6853 183.915C29.9951 183.915 28.625 185.285 28.625 186.975C28.625 188.665 29.9951 190.036 31.6853 190.036Z" fill="currentColor"/>
            <path d="M39.8455 171.295C41.5142 171.295 42.8669 169.942 42.8669 168.273C42.8669 166.605 41.5142 165.252 39.8455 165.252C38.1769 165.252 36.8242 166.605 36.8242 168.273C36.8242 169.942 38.1769 171.295 39.8455 171.295Z" fill="currentColor"/>
            <path d="M49.3807 153.255C51.0494 153.255 52.4021 151.902 52.4021 150.233C52.4021 148.565 51.0494 147.212 49.3807 147.212C47.7121 147.212 46.3594 148.565 46.3594 150.233C46.3594 151.902 47.7121 153.255 49.3807 153.255Z" fill="currentColor"/>
            <path d="M60.2362 135.977C61.9048 135.977 63.2575 134.625 63.2575 132.956C63.2575 131.287 61.9048 129.935 60.2362 129.935C58.5675 129.935 57.2148 131.287 57.2148 132.956C57.2148 134.625 58.5675 135.977 60.2362 135.977Z" fill="currentColor"/>
            <path d="M72.3534 119.56C74.022 119.56 75.3747 118.208 75.3747 116.539C75.3747 114.87 74.022 113.518 72.3534 113.518C70.6847 113.518 69.332 114.87 69.332 116.539C69.332 118.208 70.6847 119.56 72.3534 119.56Z" fill="currentColor"/>
            <path d="M85.662 104.093C87.3306 104.093 88.6833 102.741 88.6833 101.072C88.6833 99.4035 87.3306 98.0508 85.662 98.0508C83.9933 98.0508 82.6406 99.4035 82.6406 101.072C82.6406 102.741 83.9933 104.093 85.662 104.093Z" fill="currentColor"/>
            <path d="M100.091 89.7045C101.782 89.7045 103.152 88.3344 103.152 86.6442C103.152 84.9541 101.782 83.584 100.091 83.584C98.4014 83.584 97.0312 84.9541 97.0312 86.6442C97.0312 88.3344 98.4014 89.7045 100.091 89.7045Z" fill="currentColor"/>
            <path d="M115.557 76.3552C117.225 76.3552 118.578 75.0025 118.578 73.3338C118.578 71.6652 117.225 70.3125 115.557 70.3125C113.888 70.3125 112.535 71.6652 112.535 73.3338C112.535 75.0025 113.888 76.3552 115.557 76.3552Z" fill="currentColor"/>
            <path d="M131.974 64.239C133.643 64.239 134.996 62.8862 134.996 61.2176C134.996 59.549 133.643 58.1963 131.974 58.1963C130.306 58.1963 128.953 59.549 128.953 61.2176C128.953 62.8862 130.306 64.239 131.974 64.239Z" fill="currentColor"/>
            <path d="M149.252 53.3825C150.92 53.3825 152.273 52.0298 152.273 50.3612C152.273 48.6926 150.92 47.3398 149.252 47.3398C147.583 47.3398 146.23 48.6926 146.23 50.3612C146.23 52.0298 147.583 53.3825 149.252 53.3825Z" fill="currentColor"/>
            <path d="M167.291 43.8218C168.945 43.8218 170.286 42.4812 170.286 40.8274C170.286 39.1736 168.945 37.833 167.291 37.833C165.638 37.833 164.297 39.1736 164.297 40.8274C164.297 42.4812 165.638 43.8218 167.291 43.8218Z" fill="currentColor"/>
            <path d="M185.994 35.6882C187.663 35.6882 189.015 34.3355 189.015 32.6669C189.015 30.9982 187.663 29.6455 185.994 29.6455C184.325 29.6455 182.973 30.9982 182.973 32.6669C182.973 34.3355 184.325 35.6882 185.994 35.6882Z" fill="currentColor"/>
            <path d="M205.252 28.9489C206.92 28.9489 208.273 27.5962 208.273 25.9276C208.273 24.2589 206.92 22.9062 205.252 22.9062C203.583 22.9062 202.23 24.2589 202.23 25.9276C202.23 27.5962 203.583 28.9489 205.252 28.9489Z" fill="currentColor"/>
            <path d="M224.963 23.6677C226.631 23.6677 227.984 22.315 227.984 20.6463C227.984 18.9777 226.631 17.625 224.963 17.625C223.294 17.625 221.941 18.9777 221.941 20.6463C221.941 22.315 223.294 23.6677 224.963 23.6677Z" fill="currentColor"/>
            <path d="M245.014 19.8472C246.668 19.8472 248.008 18.5066 248.008 16.8528C248.008 15.199 246.668 13.8584 245.014 13.8584C243.36 13.8584 242.02 15.199 242.02 16.8528C242.02 18.5066 243.36 19.8472 245.014 19.8472Z" fill="currentColor"/>
            <path d="M265.291 17.6293C266.981 17.6293 268.351 16.2592 268.351 14.569C268.351 12.8789 266.981 11.5088 265.291 11.5088C263.601 11.5088 262.23 12.8789 262.23 14.569C262.23 16.2592 263.601 17.6293 265.291 17.6293Z" fill="currentColor"/>
            <path d="M285.678 16.8269C287.346 16.8269 288.699 15.4741 288.699 13.8055C288.699 12.1369 287.346 10.7842 285.678 10.7842C284.009 10.7842 282.656 12.1369 282.656 13.8055C282.656 15.4741 284.009 16.8269 285.678 16.8269Z" fill="currentColor"/>
            <path d="M306.068 17.5895C307.737 17.5895 309.09 16.2368 309.09 14.5682C309.09 12.8996 307.737 11.5469 306.068 11.5469C304.4 11.5469 303.047 12.8996 303.047 14.5682C303.047 16.2368 304.4 17.5895 306.068 17.5895Z" fill="currentColor"/>
            <path d="M326.346 19.8472C328 19.8472 329.34 18.5066 329.34 16.8528C329.34 15.199 328 13.8584 326.346 13.8584C324.692 13.8584 323.352 15.199 323.352 16.8528C323.352 18.5066 324.692 19.8472 326.346 19.8472Z" fill="currentColor"/>
            <path d="M346.396 23.6677C348.065 23.6677 349.418 22.315 349.418 20.6463C349.418 18.9777 348.065 17.625 346.396 17.625C344.728 17.625 343.375 18.9777 343.375 20.6463C343.375 22.315 344.728 23.6677 346.396 23.6677Z" fill="currentColor"/>
            <path d="M366.103 28.9489C367.772 28.9489 369.125 27.5962 369.125 25.9276C369.125 24.2589 367.772 22.9062 366.103 22.9062C364.435 22.9062 363.082 24.2589 363.082 25.9276C363.082 27.5962 364.435 28.9489 366.103 28.9489Z" fill="currentColor"/>
            <path d="M385.365 35.6882C387.034 35.6882 388.386 34.3355 388.386 32.6669C388.386 30.9982 387.034 29.6455 385.365 29.6455C383.696 29.6455 382.344 30.9982 382.344 32.6669C382.344 34.3355 383.696 35.6882 385.365 35.6882Z" fill="currentColor"/>
            <path d="M404.068 43.8871C405.758 43.8871 407.128 42.517 407.128 40.8268C407.128 39.1367 405.758 37.7666 404.068 37.7666C402.378 37.7666 401.008 39.1367 401.008 40.8268C401.008 42.517 402.378 43.8871 404.068 43.8871Z" fill="currentColor"/>
            <path d="M422.108 53.3561C423.762 53.3561 425.102 52.0154 425.102 50.3616C425.102 48.7078 423.762 47.3672 422.108 47.3672C420.454 47.3672 419.113 48.7078 419.113 50.3616C419.113 52.0154 420.454 53.3561 422.108 53.3561Z" fill="currentColor"/>
            <path d="M439.385 64.239C441.053 64.239 442.406 62.8862 442.406 61.2176C442.406 59.549 441.053 58.1963 439.385 58.1963C437.716 58.1963 436.363 59.549 436.363 61.2176C436.363 62.8862 437.716 64.239 439.385 64.239Z" fill="currentColor"/>
            <path d="M455.803 76.3552C457.471 76.3552 458.824 75.0025 458.824 73.3338C458.824 71.6652 457.471 70.3125 455.803 70.3125C454.134 70.3125 452.781 71.6652 452.781 73.3338C452.781 75.0025 454.134 76.3552 455.803 76.3552Z" fill="currentColor"/>
            <path d="M471.267 89.6657C472.936 89.6657 474.289 88.313 474.289 86.6444C474.289 84.9758 472.936 83.623 471.267 83.623C469.599 83.623 468.246 84.9758 468.246 86.6444C468.246 88.313 469.599 89.6657 471.267 89.6657Z" fill="currentColor"/>
            <path d="M485.697 104.132C487.387 104.132 488.757 102.762 488.757 101.072C488.757 99.3818 487.387 98.0117 485.697 98.0117C484.007 98.0117 482.637 99.3818 482.637 101.072C482.637 102.762 484.007 104.132 485.697 104.132Z" fill="currentColor"/>
            <path d="M499.006 119.56C500.674 119.56 502.027 118.208 502.027 116.539C502.027 114.87 500.674 113.518 499.006 113.518C497.337 113.518 495.984 114.87 495.984 116.539C495.984 118.208 497.337 119.56 499.006 119.56Z" fill="currentColor"/>
            <path d="M511.123 135.977C512.792 135.977 514.144 134.625 514.144 132.956C514.144 131.287 512.792 129.935 511.123 129.935C509.454 129.935 508.102 131.287 508.102 132.956C508.102 134.625 509.454 135.977 511.123 135.977Z" fill="currentColor"/>
            <path d="M521.978 153.293C523.668 153.293 525.038 151.923 525.038 150.233C525.038 148.543 523.668 147.173 521.978 147.173C520.288 147.173 518.918 148.543 518.918 150.233C518.918 151.923 520.288 153.293 521.978 153.293Z" fill="currentColor"/>
            <path d="M531.514 171.268C533.168 171.268 534.508 169.928 534.508 168.274C534.508 166.62 533.168 165.279 531.514 165.279C529.86 165.279 528.52 166.62 528.52 168.274C528.52 169.928 529.86 171.268 531.514 171.268Z" fill="currentColor"/>
            <path d="M539.674 189.998C541.342 189.998 542.695 188.645 542.695 186.976C542.695 185.308 541.342 183.955 539.674 183.955C538.005 183.955 536.652 185.308 536.652 186.976C536.652 188.645 538.005 189.998 539.674 189.998Z" fill="currentColor"/>
            <path d="M546.412 209.257C548.081 209.257 549.433 207.904 549.433 206.235C549.433 204.567 548.081 203.214 546.412 203.214C544.743 203.214 543.391 204.567 543.391 206.235C543.391 207.904 544.743 209.257 546.412 209.257Z" fill="currentColor"/>
            <path d="M551.693 228.966C553.362 228.966 554.715 227.614 554.715 225.945C554.715 224.277 553.362 222.924 551.693 222.924C550.025 222.924 548.672 224.277 548.672 225.945C548.672 227.614 550.025 228.966 551.693 228.966Z" fill="currentColor"/>
            <path d="M555.487 248.989C557.14 248.989 558.481 247.648 558.481 245.994C558.481 244.341 557.14 243 555.487 243C553.833 243 552.492 244.341 552.492 245.994C552.492 247.648 553.833 248.989 555.487 248.989Z" fill="currentColor"/>
            <path d="M557.771 269.33C559.461 269.33 560.831 267.96 560.831 266.27C560.831 264.58 559.461 263.21 557.771 263.21C556.081 263.21 554.711 264.58 554.711 266.27C554.711 267.96 556.081 269.33 557.771 269.33Z" fill="currentColor"/>
            <path d="M-0.276336 229.196C1.55582 229.196 3.04108 227.711 3.04108 225.879C3.04108 224.047 1.55582 222.562 -0.276336 222.562C-2.10849 222.562 -3.59375 224.047 -3.59375 225.879C-3.59375 227.711 -2.10849 229.196 -0.276336 229.196Z" fill="currentColor"/>
            <path d="M4.66116 209.398C6.49332 209.398 7.97858 207.912 7.97858 206.08C7.97858 204.248 6.49332 202.763 4.66116 202.763C2.82901 202.763 1.34375 204.248 1.34375 206.08C1.34375 207.912 2.82901 209.398 4.66116 209.398Z" fill="currentColor"/>
            <path d="M10.9659 189.99C12.798 189.99 14.2833 188.505 14.2833 186.673C14.2833 184.841 12.798 183.355 10.9659 183.355C9.13369 183.355 7.64844 184.841 7.64844 186.673C7.64844 188.505 9.13369 189.99 10.9659 189.99Z" fill="currentColor"/>
            <path d="M18.6078 171.084C20.4472 171.084 21.9383 169.593 21.9383 167.753C21.9383 165.914 20.4472 164.423 18.6078 164.423C16.7684 164.423 15.2773 165.914 15.2773 167.753C15.2773 169.593 16.7684 171.084 18.6078 171.084Z" fill="currentColor"/>
            <path d="M27.5557 152.731C29.3879 152.731 30.8731 151.245 30.8731 149.413C30.8731 147.581 29.3879 146.096 27.5557 146.096C25.7236 146.096 24.2383 147.581 24.2383 149.413C24.2383 151.245 25.7236 152.731 27.5557 152.731Z" fill="currentColor"/>
            <path d="M37.7549 135.059C39.5871 135.059 41.0723 133.573 41.0723 131.741C41.0723 129.909 39.5871 128.424 37.7549 128.424C35.9227 128.424 34.4375 129.909 34.4375 131.741C34.4375 133.573 35.9227 135.059 37.7549 135.059Z" fill="currentColor"/>
            <path d="M49.169 118.143C51.0011 118.143 52.4864 116.657 52.4864 114.825C52.4864 112.993 51.0011 111.508 49.169 111.508C47.3368 111.508 45.8516 112.993 45.8516 114.825C45.8516 116.657 47.3368 118.143 49.169 118.143Z" fill="currentColor"/>
            <path d="M61.7315 102.063C63.5637 102.063 65.0489 100.577 65.0489 98.7452C65.0489 96.913 63.5637 95.4277 61.7315 95.4277C59.8993 95.4277 58.4141 96.913 58.4141 98.7452C58.4141 100.577 59.8993 102.063 61.7315 102.063Z" fill="currentColor"/>
            <path d="M75.3838 86.8985C77.216 86.8985 78.7012 85.4132 78.7012 83.5811C78.7012 81.7489 77.216 80.2637 75.3838 80.2637C73.5516 80.2637 72.0664 81.7489 72.0664 83.5811C72.0664 85.4132 73.5516 86.8985 75.3838 86.8985Z" fill="currentColor"/>
            <path d="M90.0635 72.7237C91.8956 72.7237 93.3809 71.2384 93.3809 69.4063C93.3809 67.5741 91.8956 66.0889 90.0635 66.0889C88.2313 66.0889 86.7461 67.5741 86.7461 69.4063C86.7461 71.2384 88.2313 72.7237 90.0635 72.7237Z" fill="currentColor"/>
            <path d="M105.692 59.6075C107.525 59.6075 109.01 58.1222 109.01 56.2901C109.01 54.4579 107.525 52.9727 105.692 52.9727C103.86 52.9727 102.375 54.4579 102.375 56.2901C102.375 58.1222 103.86 59.6075 105.692 59.6075Z" fill="currentColor"/>
            <path d="M122.2 47.6133C124.032 47.6133 125.518 46.1281 125.518 44.2959C125.518 42.4638 124.032 40.9785 122.2 40.9785C120.368 40.9785 118.883 42.4638 118.883 44.2959C118.883 46.1281 120.368 47.6133 122.2 47.6133Z" fill="currentColor"/>
            <path d="M139.505 36.7999C141.337 36.7999 142.822 35.3146 142.822 33.4825C142.822 31.6503 141.337 30.165 139.505 30.165C137.673 30.165 136.188 31.6503 136.188 33.4825C136.188 35.3146 137.673 36.7999 139.505 36.7999Z" fill="currentColor"/>
            <path d="M157.524 27.2208C159.357 27.2208 160.842 25.7355 160.842 23.9033C160.842 22.0712 159.357 20.5859 157.524 20.5859C155.692 20.5859 154.207 22.0712 154.207 23.9033C154.207 25.7355 155.692 27.2208 157.524 27.2208Z" fill="currentColor"/>
            <path d="M176.165 18.921C177.997 18.921 179.482 17.4357 179.482 15.6035C179.482 13.7714 177.997 12.2861 176.165 12.2861C174.333 12.2861 172.848 13.7714 172.848 15.6035C172.848 17.4357 174.333 18.921 176.165 18.921Z" fill="currentColor"/>
            <path d="M195.341 11.9415C197.173 11.9415 198.658 10.4562 198.658 8.62405C198.658 6.7919 197.173 5.30664 195.341 5.30664C193.509 5.30664 192.023 6.7919 192.023 8.62405C192.023 10.4562 193.509 11.9415 195.341 11.9415Z" fill="currentColor"/>
            <path d="M214.954 6.31745C216.786 6.31745 218.272 4.83219 218.272 3.00003C218.272 1.16787 216.786 -0.317383 214.954 -0.317383C213.122 -0.317383 211.637 1.16787 211.637 3.00003C211.637 4.83219 213.122 6.31745 214.954 6.31745Z" fill="currentColor"/>
            <path d="M234.915 2.07526C236.747 2.07526 238.232 0.590001 238.232 -1.24216C238.232 -3.07431 236.747 -4.55957 234.915 -4.55957C233.083 -4.55957 231.598 -3.07431 231.598 -1.24216C231.598 0.590001 233.083 2.07526 234.915 2.07526Z" fill="currentColor"/>
            <path d="M336.444 2.08771C338.283 2.08771 339.774 0.596596 339.774 -1.24277C339.774 -3.08214 338.283 -4.57324 336.444 -4.57324C334.604 -4.57324 333.113 -3.08214 333.113 -1.24277C333.113 0.596596 334.604 2.08771 336.444 2.08771Z" fill="currentColor"/>
            <path d="M356.403 6.31745C358.235 6.31745 359.721 4.83219 359.721 3.00003C359.721 1.16787 358.235 -0.317383 356.403 -0.317383C354.571 -0.317383 353.086 1.16787 353.086 3.00003C353.086 4.83219 354.571 6.31745 356.403 6.31745Z" fill="currentColor"/>
            <path d="M376.021 11.9415C377.853 11.9415 379.338 10.4562 379.338 8.62405C379.338 6.7919 377.853 5.30664 376.021 5.30664C374.188 5.30664 372.703 6.7919 372.703 8.62405C372.703 10.4562 374.188 11.9415 376.021 11.9415Z" fill="currentColor"/>
            <path d="M395.194 18.9334C397.033 18.9334 398.524 17.4423 398.524 15.6029C398.524 13.7636 397.033 12.2725 395.194 12.2725C393.354 12.2725 391.863 13.7636 391.863 15.6029C391.863 17.4423 393.354 18.9334 395.194 18.9334Z" fill="currentColor"/>
            <path d="M413.833 27.2208C415.665 27.2208 417.15 25.7355 417.15 23.9033C417.15 22.0712 415.665 20.5859 413.833 20.5859C412.001 20.5859 410.516 22.0712 410.516 23.9033C410.516 25.7355 412.001 27.2208 413.833 27.2208Z" fill="currentColor"/>
            <path d="M431.853 36.7999C433.685 36.7999 435.17 35.3146 435.17 33.4825C435.17 31.6503 433.685 30.165 431.853 30.165C430.02 30.165 428.535 31.6503 428.535 33.4825C428.535 35.3146 430.02 36.7999 431.853 36.7999Z" fill="currentColor"/>
            <path d="M449.155 47.6268C450.994 47.6268 452.485 46.1357 452.485 44.2963C452.485 42.4569 450.994 40.9658 449.155 40.9658C447.315 40.9658 445.824 42.4569 445.824 44.2963C445.824 46.1357 447.315 47.6268 449.155 47.6268Z" fill="currentColor"/>
            <path d="M465.665 59.6075C467.497 59.6075 468.982 58.1222 468.982 56.2901C468.982 54.4579 467.497 52.9727 465.665 52.9727C463.833 52.9727 462.348 54.4579 462.348 56.2901C462.348 58.1222 463.833 59.6075 465.665 59.6075Z" fill="currentColor"/>
            <path d="M481.298 72.7237C483.13 72.7237 484.615 71.2384 484.615 69.4063C484.615 67.5741 483.13 66.0889 481.298 66.0889C479.466 66.0889 477.98 67.5741 477.98 69.4063C477.98 71.2384 479.466 72.7237 481.298 72.7237Z" fill="currentColor"/>
            <path d="M495.974 86.8985C497.806 86.8985 499.291 85.4132 499.291 83.5811C499.291 81.7489 497.806 80.2637 495.974 80.2637C494.141 80.2637 492.656 81.7489 492.656 83.5811C492.656 85.4132 494.141 86.8985 495.974 86.8985Z" fill="currentColor"/>
            <path d="M509.63 102.063C511.462 102.063 512.947 100.577 512.947 98.7452C512.947 96.913 511.462 95.4277 509.63 95.4277C507.798 95.4277 506.312 96.913 506.312 98.7452C506.312 100.577 507.798 102.063 509.63 102.063Z" fill="currentColor"/>
            <path d="M522.19 118.156C524.029 118.156 525.52 116.665 525.52 114.826C525.52 112.986 524.029 111.495 522.19 111.495C520.35 111.495 518.859 112.986 518.859 114.826C518.859 116.665 520.35 118.156 522.19 118.156Z" fill="currentColor"/>
            <path d="M533.604 135.072C535.443 135.072 536.934 133.581 536.934 131.742C536.934 129.902 535.443 128.411 533.604 128.411C531.765 128.411 530.273 129.902 530.273 131.742C530.273 133.581 531.765 135.072 533.604 135.072Z" fill="currentColor"/>
            <path d="M543.803 152.744C545.642 152.744 547.134 151.253 547.134 149.413C547.134 147.574 545.642 146.083 543.803 146.083C541.964 146.083 540.473 147.574 540.473 149.413C540.473 151.253 541.964 152.744 543.803 152.744Z" fill="currentColor"/>
            <path d="M552.751 171.071C554.583 171.071 556.068 169.586 556.068 167.754C556.068 165.922 554.583 164.437 552.751 164.437C550.919 164.437 549.434 165.922 549.434 167.754C549.434 169.586 550.919 171.071 552.751 171.071Z" fill="currentColor"/>
            <path d="M560.396 189.99C562.228 189.99 563.713 188.505 563.713 186.673C563.713 184.841 562.228 183.355 560.396 183.355C558.563 183.355 557.078 184.841 557.078 186.673C557.078 188.505 558.563 189.99 560.396 189.99Z" fill="currentColor"/>
            <path d="M566.7 209.398C568.532 209.398 570.018 207.912 570.018 206.08C570.018 204.248 568.532 202.763 566.7 202.763C564.868 202.763 563.383 204.248 563.383 206.08C563.383 207.912 564.868 209.398 566.7 209.398Z" fill="currentColor"/>
            <path d="M571.638 229.196C573.47 229.196 574.955 227.711 574.955 225.879C574.955 224.047 573.47 222.562 571.638 222.562C569.806 222.562 568.32 224.047 568.32 225.879C568.32 227.711 569.806 229.196 571.638 229.196Z" fill="currentColor"/>
            <path d="M575.181 249.292C577.013 249.292 578.498 247.807 578.498 245.975C578.498 244.143 577.013 242.657 575.181 242.657C573.349 242.657 571.863 244.143 571.863 245.975C571.863 247.807 573.349 249.292 575.181 249.292Z" fill="currentColor"/>
            <path d="M575.181 330.665C577.013 330.665 578.498 329.18 578.498 327.348C578.498 325.516 577.013 324.03 575.181 324.03C573.349 324.03 571.863 325.516 571.863 327.348C571.863 329.18 573.349 330.665 575.181 330.665Z" fill="currentColor"/>
            <path d="M571.638 350.761C573.47 350.761 574.955 349.276 574.955 347.443C574.955 345.611 573.47 344.126 571.638 344.126C569.806 344.126 568.32 345.611 568.32 347.443C568.32 349.276 569.806 350.761 571.638 350.761Z" fill="currentColor"/>
            <path d="M566.7 370.56C568.532 370.56 570.018 369.074 570.018 367.242C570.018 365.41 568.532 363.925 566.7 363.925C564.868 363.925 563.383 365.41 563.383 367.242C563.383 369.074 564.868 370.56 566.7 370.56Z" fill="currentColor"/>
            <path d="M560.396 389.966C562.228 389.966 563.713 388.481 563.713 386.648C563.713 384.816 562.228 383.331 560.396 383.331C558.563 383.331 557.078 384.816 557.078 386.648C557.078 388.481 558.563 389.966 560.396 389.966Z" fill="currentColor"/>
            <path d="M552.751 408.886C554.583 408.886 556.068 407.401 556.068 405.568C556.068 403.736 554.583 402.251 552.751 402.251C550.919 402.251 549.434 403.736 549.434 405.568C549.434 407.401 550.919 408.886 552.751 408.886Z" fill="currentColor"/>
            <path d="M543.806 427.227C545.638 427.227 547.123 425.741 547.123 423.909C547.123 422.077 545.638 420.592 543.806 420.592C541.974 420.592 540.488 422.077 540.488 423.909C540.488 425.741 541.974 427.227 543.806 427.227Z" fill="currentColor"/>
            <path d="M533.603 444.897C535.435 444.897 536.92 443.412 536.92 441.58C536.92 439.748 535.435 438.263 533.603 438.263C531.77 438.263 530.285 439.748 530.285 441.58C530.285 443.412 531.77 444.897 533.603 444.897Z" fill="currentColor"/>
            <path d="M522.192 461.814C524.025 461.814 525.51 460.329 525.51 458.497C525.51 456.665 524.025 455.18 522.192 455.18C520.36 455.18 518.875 456.665 518.875 458.497C518.875 460.329 520.36 461.814 522.192 461.814Z" fill="currentColor"/>
            <path d="M509.627 477.907C511.467 477.907 512.958 476.416 512.958 474.577C512.958 472.737 511.467 471.246 509.627 471.246C507.788 471.246 506.297 472.737 506.297 474.577C506.297 476.416 507.788 477.907 509.627 477.907Z" fill="currentColor"/>
            <path d="M495.975 493.071C497.814 493.071 499.305 491.58 499.305 489.741C499.305 487.901 497.814 486.41 495.975 486.41C494.136 486.41 492.645 487.901 492.645 489.741C492.645 491.58 494.136 493.071 495.975 493.071Z" fill="currentColor"/>
            <path d="M481.298 507.233C483.13 507.233 484.615 505.748 484.615 503.916C484.615 502.084 483.13 500.599 481.298 500.599C479.466 500.599 477.98 502.084 477.98 503.916C477.98 505.748 479.466 507.233 481.298 507.233Z" fill="currentColor"/>
            <path d="M465.665 520.35C467.497 520.35 468.982 518.864 468.982 517.032C468.982 515.2 467.497 513.715 465.665 513.715C463.833 513.715 462.348 515.2 462.348 517.032C462.348 518.864 463.833 520.35 465.665 520.35Z" fill="currentColor"/>
            <path d="M449.157 532.344C450.989 532.344 452.475 530.859 452.475 529.026C452.475 527.194 450.989 525.709 449.157 525.709C447.325 525.709 445.84 527.194 445.84 529.026C445.84 530.859 447.325 532.344 449.157 532.344Z" fill="currentColor"/>
            <path d="M431.853 543.156C433.685 543.156 435.17 541.671 435.17 539.839C435.17 538.007 433.685 536.521 431.853 536.521C430.02 536.521 428.535 538.007 428.535 539.839C428.535 541.671 430.02 543.156 431.853 543.156Z" fill="currentColor"/>
            <path d="M413.833 552.736C415.665 552.736 417.15 551.251 417.15 549.419C417.15 547.587 415.665 546.102 413.833 546.102C412.001 546.102 410.516 547.587 410.516 549.419C410.516 551.251 412.001 552.736 413.833 552.736Z" fill="currentColor"/>
            <path d="M395.194 561.05C397.033 561.05 398.524 559.558 398.524 557.719C398.524 555.88 397.033 554.389 395.194 554.389C393.354 554.389 391.863 555.88 391.863 557.719C391.863 559.558 393.354 561.05 395.194 561.05Z" fill="currentColor"/>
            <path d="M376.021 568.015C377.853 568.015 379.338 566.529 379.338 564.697C379.338 562.865 377.853 561.38 376.021 561.38C374.188 561.38 372.703 562.865 372.703 564.697C372.703 566.529 374.188 568.015 376.021 568.015Z" fill="currentColor"/>
            <path d="M356.403 573.64C358.235 573.64 359.721 572.154 359.721 570.322C359.721 568.49 358.235 567.005 356.403 567.005C354.571 567.005 353.086 568.49 353.086 570.322C353.086 572.154 354.571 573.64 356.403 573.64Z" fill="currentColor"/>
            <path d="M336.446 577.882C338.278 577.882 339.764 576.397 339.764 574.564C339.764 572.732 338.278 571.247 336.446 571.247C334.614 571.247 333.129 572.732 333.129 574.564C333.129 576.397 334.614 577.882 336.446 577.882Z" fill="currentColor"/>
            <path d="M234.915 577.882C236.747 577.882 238.232 576.397 238.232 574.564C238.232 572.732 236.747 571.247 234.915 571.247C233.083 571.247 231.598 572.732 231.598 574.564C231.598 576.397 233.083 577.882 234.915 577.882Z" fill="currentColor"/>
            <path d="M214.954 573.64C216.786 573.64 218.272 572.154 218.272 570.322C218.272 568.49 216.786 567.005 214.954 567.005C213.122 567.005 211.637 568.49 211.637 570.322C211.637 572.154 213.122 573.64 214.954 573.64Z" fill="currentColor"/>
            <path d="M195.341 568.015C197.173 568.015 198.658 566.529 198.658 564.697C198.658 562.865 197.173 561.38 195.341 561.38C193.509 561.38 192.023 562.865 192.023 564.697C192.023 566.529 193.509 568.015 195.341 568.015Z" fill="currentColor"/>
            <path d="M176.166 561.05C178.006 561.05 179.497 559.558 179.497 557.719C179.497 555.88 178.006 554.389 176.166 554.389C174.327 554.389 172.836 555.88 172.836 557.719C172.836 559.558 174.327 561.05 176.166 561.05Z" fill="currentColor"/>
            <path d="M157.524 552.736C159.357 552.736 160.842 551.251 160.842 549.419C160.842 547.587 159.357 546.102 157.524 546.102C155.692 546.102 154.207 547.587 154.207 549.419C154.207 551.251 155.692 552.736 157.524 552.736Z" fill="currentColor"/>
            <path d="M139.505 543.156C141.337 543.156 142.822 541.671 142.822 539.839C142.822 538.007 141.337 536.521 139.505 536.521C137.673 536.521 136.188 538.007 136.188 539.839C136.188 541.671 137.673 543.156 139.505 543.156Z" fill="currentColor"/>
            <path d="M122.2 532.344C124.032 532.344 125.518 530.859 125.518 529.026C125.518 527.194 124.032 525.709 122.2 525.709C120.368 525.709 118.883 527.194 118.883 529.026C118.883 530.859 120.368 532.344 122.2 532.344Z" fill="currentColor"/>
            <path d="M105.692 520.35C107.525 520.35 109.01 518.864 109.01 517.032C109.01 515.2 107.525 513.715 105.692 513.715C103.86 513.715 102.375 515.2 102.375 517.032C102.375 518.864 103.86 520.35 105.692 520.35Z" fill="currentColor"/>
            <path d="M90.0635 507.233C91.8956 507.233 93.3809 505.748 93.3809 503.916C93.3809 502.084 91.8956 500.599 90.0635 500.599C88.2313 500.599 86.7461 502.084 86.7461 503.916C86.7461 505.748 88.2313 507.233 90.0635 507.233Z" fill="currentColor"/>
            <path d="M75.3838 493.059C77.216 493.059 78.7012 491.573 78.7012 489.741C78.7012 487.909 77.216 486.424 75.3838 486.424C73.5516 486.424 72.0664 487.909 72.0664 489.741C72.0664 491.573 73.5516 493.059 75.3838 493.059Z" fill="currentColor"/>
            <path d="M61.7315 477.894C63.5637 477.894 65.0489 476.408 65.0489 474.576C65.0489 472.744 63.5637 471.259 61.7315 471.259C59.8993 471.259 58.4141 472.744 58.4141 474.576C58.4141 476.408 59.8993 477.894 61.7315 477.894Z" fill="currentColor"/>
            <path d="M49.169 461.814C51.0011 461.814 52.4864 460.329 52.4864 458.497C52.4864 456.665 51.0011 455.18 49.169 455.18C47.3368 455.18 45.8516 456.665 45.8516 458.497C45.8516 460.329 47.3368 461.814 49.169 461.814Z" fill="currentColor"/>
            <path d="M37.7549 444.897C39.5871 444.897 41.0723 443.412 41.0723 441.58C41.0723 439.748 39.5871 438.263 37.7549 438.263C35.9227 438.263 34.4375 439.748 34.4375 441.58C34.4375 443.412 35.9227 444.897 37.7549 444.897Z" fill="currentColor"/>
            <path d="M27.5557 427.227C29.3879 427.227 30.8731 425.741 30.8731 423.909C30.8731 422.077 29.3879 420.592 27.5557 420.592C25.7236 420.592 24.2383 422.077 24.2383 423.909C24.2383 425.741 25.7236 427.227 27.5557 427.227Z" fill="currentColor"/>
            <path d="M18.6104 408.886C20.4425 408.886 21.9278 407.401 21.9278 405.568C21.9278 403.736 20.4425 402.251 18.6104 402.251C16.7782 402.251 15.293 403.736 15.293 405.568C15.293 407.401 16.7782 408.886 18.6104 408.886Z" fill="currentColor"/>
            <path d="M10.9659 389.966C12.798 389.966 14.2833 388.481 14.2833 386.648C14.2833 384.816 12.798 383.331 10.9659 383.331C9.13369 383.331 7.64844 384.816 7.64844 386.648C7.64844 388.481 9.13369 389.966 10.9659 389.966Z" fill="currentColor"/>
            <path d="M4.66116 370.56C6.49332 370.56 7.97858 369.074 7.97858 367.242C7.97858 365.41 6.49332 363.925 4.66116 363.925C2.82901 363.925 1.34375 365.41 1.34375 367.242C1.34375 369.074 2.82901 370.56 4.66116 370.56Z" fill="currentColor"/>
            <path d="M-0.276336 350.761C1.55582 350.761 3.04108 349.276 3.04108 347.443C3.04108 345.611 1.55582 344.126 -0.276336 344.126C-2.10849 344.126 -3.59375 345.611 -3.59375 347.443C-3.59375 349.276 -2.10849 350.761 -0.276336 350.761Z" fill="currentColor"/>
            <path d="M573.778 409.555C575.744 409.555 577.338 407.961 577.338 405.995C577.338 404.029 575.744 402.436 573.778 402.436C571.813 402.436 570.219 404.029 570.219 405.995C570.219 407.961 571.813 409.555 573.778 409.555Z" fill="currentColor"/>
            <path d="M565.357 428.142C567.322 428.142 568.916 426.548 568.916 424.582C568.916 422.616 567.322 421.022 565.357 421.022C563.391 421.022 561.797 422.616 561.797 424.582C561.797 426.548 563.391 428.142 565.357 428.142Z" fill="currentColor"/>
            <path d="M555.738 446.152C557.711 446.152 559.311 444.552 559.311 442.579C559.311 440.605 557.711 439.005 555.738 439.005C553.764 439.005 552.164 440.605 552.164 442.579C552.164 444.552 553.764 446.152 555.738 446.152Z" fill="currentColor"/>
            <path d="M544.96 463.48C546.934 463.48 548.534 461.88 548.534 459.907C548.534 457.933 546.934 456.333 544.96 456.333C542.987 456.333 541.387 457.933 541.387 459.907C541.387 461.88 542.987 463.48 544.96 463.48Z" fill="currentColor"/>
            <path d="M533.075 480.054C535.041 480.054 536.635 478.46 536.635 476.494C536.635 474.528 535.041 472.935 533.075 472.935C531.109 472.935 529.516 474.528 529.516 476.494C529.516 478.46 531.109 480.054 533.075 480.054Z" fill="currentColor"/>
            <path d="M520.13 495.827C522.096 495.827 523.69 494.234 523.69 492.268C523.69 490.302 522.096 488.708 520.13 488.708C518.164 488.708 516.57 490.302 516.57 492.268C516.57 494.234 518.164 495.827 520.13 495.827Z" fill="currentColor"/>
            <path d="M506.179 510.735C508.153 510.735 509.753 509.135 509.753 507.162C509.753 505.188 508.153 503.588 506.179 503.588C504.205 503.588 502.605 505.188 502.605 507.162C502.605 509.135 504.205 510.735 506.179 510.735Z" fill="currentColor"/>
            <path d="M491.286 524.67C493.252 524.67 494.846 523.076 494.846 521.11C494.846 519.144 493.252 517.551 491.286 517.551C489.32 517.551 487.727 519.144 487.727 521.11C487.727 523.076 489.32 524.67 491.286 524.67Z" fill="currentColor"/>
            <path d="M475.513 537.615C477.479 537.615 479.072 536.022 479.072 534.056C479.072 532.09 477.479 530.496 475.513 530.496C473.547 530.496 471.953 532.09 471.953 534.056C471.953 536.022 473.547 537.615 475.513 537.615Z" fill="currentColor"/>
            <path d="M458.927 549.502C460.893 549.502 462.486 547.908 462.486 545.942C462.486 543.977 460.893 542.383 458.927 542.383C456.961 542.383 455.367 543.977 455.367 545.942C455.367 547.908 456.961 549.502 458.927 549.502Z" fill="currentColor"/>
            <path d="M441.595 560.277C443.561 560.277 445.155 558.684 445.155 556.718C445.155 554.752 443.561 553.158 441.595 553.158C439.629 553.158 438.035 554.752 438.035 556.718C438.035 558.684 439.629 560.277 441.595 560.277Z" fill="currentColor"/>
            <path d="M423.599 569.897C425.565 569.897 427.158 568.303 427.158 566.337C427.158 564.371 425.565 562.777 423.599 562.777C421.633 562.777 420.039 564.371 420.039 566.337C420.039 568.303 421.633 569.897 423.599 569.897Z" fill="currentColor"/>
            <path d="M405.013 578.319C406.979 578.319 408.572 576.725 408.572 574.759C408.572 572.793 406.979 571.199 405.013 571.199C403.047 571.199 401.453 572.793 401.453 574.759C401.453 576.725 403.047 578.319 405.013 578.319Z" fill="currentColor"/>
            <path d="M166.345 578.319C168.311 578.319 169.904 576.725 169.904 574.759C169.904 572.793 168.311 571.199 166.345 571.199C164.379 571.199 162.785 572.793 162.785 574.759C162.785 576.725 164.379 578.319 166.345 578.319Z" fill="currentColor"/>
            <path d="M147.759 569.897C149.725 569.897 151.319 568.303 151.319 566.337C151.319 564.371 149.725 562.777 147.759 562.777C145.793 562.777 144.199 564.371 144.199 566.337C144.199 568.303 145.793 569.897 147.759 569.897Z" fill="currentColor"/>
            <path d="M129.761 560.292C131.735 560.292 133.335 558.692 133.335 556.718C133.335 554.744 131.735 553.145 129.761 553.145C127.787 553.145 126.188 554.744 126.188 556.718C126.188 558.692 127.787 560.292 129.761 560.292Z" fill="currentColor"/>
            <path d="M112.435 549.502C114.401 549.502 115.994 547.908 115.994 545.942C115.994 543.977 114.401 542.383 112.435 542.383C110.469 542.383 108.875 543.977 108.875 545.942C108.875 547.908 110.469 549.502 112.435 549.502Z" fill="currentColor"/>
            <path d="M95.8448 537.615C97.8107 537.615 99.4045 536.022 99.4045 534.056C99.4045 532.09 97.8107 530.496 95.8448 530.496C93.8789 530.496 92.2852 532.09 92.2852 534.056C92.2852 536.022 93.8789 537.615 95.8448 537.615Z" fill="currentColor"/>
            <path d="M80.0714 524.67C82.0373 524.67 83.631 523.076 83.631 521.11C83.631 519.144 82.0373 517.551 80.0714 517.551C78.1055 517.551 76.5117 519.144 76.5117 521.11C76.5117 523.076 78.1055 524.67 80.0714 524.67Z" fill="currentColor"/>
            <path d="M65.1807 510.721C67.1467 510.721 68.7404 509.127 68.7404 507.161C68.7404 505.195 67.1467 503.602 65.1807 503.602C63.2148 503.602 61.6211 505.195 61.6211 507.161C61.6211 509.127 63.2148 510.721 65.1807 510.721Z" fill="currentColor"/>
            <path d="M51.2316 495.827C53.1975 495.827 54.7912 494.234 54.7912 492.268C54.7912 490.302 53.1975 488.708 51.2316 488.708C49.2656 488.708 47.6719 490.302 47.6719 492.268C47.6719 494.234 49.2656 495.827 51.2316 495.827Z" fill="currentColor"/>
            <path d="M38.2862 480.054C40.2522 480.054 41.8459 478.46 41.8459 476.494C41.8459 474.528 40.2522 472.935 38.2862 472.935C36.3203 472.935 34.7266 474.528 34.7266 476.494C34.7266 478.46 36.3203 480.054 38.2862 480.054Z" fill="currentColor"/>
            <path d="M26.3995 463.467C28.3655 463.467 29.9592 461.873 29.9592 459.907C29.9592 457.941 28.3655 456.348 26.3995 456.348C24.4336 456.348 22.8398 457.941 22.8398 459.907C22.8398 461.873 24.4336 463.467 26.3995 463.467Z" fill="currentColor"/>
            <path d="M15.6222 446.138C17.5881 446.138 19.1818 444.544 19.1818 442.578C19.1818 440.612 17.5881 439.019 15.6222 439.019C13.6562 439.019 12.0625 440.612 12.0625 442.578C12.0625 444.544 13.6562 446.138 15.6222 446.138Z" fill="currentColor"/>
            <path d="M6.00498 428.142C7.97092 428.142 9.56464 426.548 9.56464 424.582C9.56464 422.616 7.97092 421.022 6.00498 421.022C4.03903 421.022 2.44531 422.616 2.44531 424.582C2.44531 426.548 4.03903 428.142 6.00498 428.142Z" fill="currentColor"/>
            <path d="M-2.4169 409.555C-0.450954 409.555 1.14276 407.961 1.14276 405.995C1.14276 404.029 -0.450954 402.436 -2.4169 402.436C-4.38284 402.436 -5.97656 404.029 -5.97656 405.995C-5.97656 407.961 -4.38284 409.555 -2.4169 409.555Z" fill="currentColor"/>
            <path d="M-2.41851 170.9C-0.444826 170.9 1.15517 169.3 1.15517 167.327C1.15517 165.353 -0.444826 163.753 -2.41851 163.753C-4.3922 163.753 -5.99219 165.353 -5.99219 167.327C-5.99219 169.3 -4.3922 170.9 -2.41851 170.9Z" fill="currentColor"/>
            <path d="M6.00498 152.3C7.97092 152.3 9.56464 150.706 9.56464 148.74C9.56464 146.774 7.97092 145.181 6.00498 145.181C4.03903 145.181 2.44531 146.774 2.44531 148.74C2.44531 150.706 4.03903 152.3 6.00498 152.3Z" fill="currentColor"/>
            <path d="M15.6222 134.303C17.5881 134.303 19.1818 132.709 19.1818 130.743C19.1818 128.777 17.5881 127.184 15.6222 127.184C13.6562 127.184 12.0625 128.777 12.0625 130.743C12.0625 132.709 13.6562 134.303 15.6222 134.303Z" fill="currentColor"/>
            <path d="M26.3995 116.975C28.3655 116.975 29.9592 115.381 29.9592 113.415C29.9592 111.449 28.3655 109.855 26.3995 109.855C24.4336 109.855 22.8398 111.449 22.8398 113.415C22.8398 115.381 24.4336 116.975 26.3995 116.975Z" fill="currentColor"/>
            <path d="M38.2862 100.388C40.2522 100.388 41.8459 98.7941 41.8459 96.8282C41.8459 94.8623 40.2522 93.2686 38.2862 93.2686C36.3203 93.2686 34.7266 94.8623 34.7266 96.8282C34.7266 98.7941 36.3203 100.388 38.2862 100.388Z" fill="currentColor"/>
            <path d="M51.2316 84.6135C53.1975 84.6135 54.7912 83.0198 54.7912 81.0538C54.7912 79.0879 53.1975 77.4941 51.2316 77.4941C49.2656 77.4941 47.6719 79.0879 47.6719 81.0538C47.6719 83.0198 49.2656 84.6135 51.2316 84.6135Z" fill="currentColor"/>
            <path d="M65.1807 69.7199C67.1467 69.7199 68.7404 68.1262 68.7404 66.1602C68.7404 64.1943 67.1467 62.6006 65.1807 62.6006C63.2148 62.6006 61.6211 64.1943 61.6211 66.1602C61.6211 68.1262 63.2148 69.7199 65.1807 69.7199Z" fill="currentColor"/>
            <path d="M80.0714 55.7707C82.0373 55.7707 83.631 54.177 83.631 52.211C83.631 50.2451 82.0373 48.6514 80.0714 48.6514C78.1055 48.6514 76.5117 50.2451 76.5117 52.211C76.5117 54.177 78.1055 55.7707 80.0714 55.7707Z" fill="currentColor"/>
            <path d="M95.8448 42.8254C97.8107 42.8254 99.4045 41.2317 99.4045 39.2657C99.4045 37.2998 97.8107 35.7061 95.8448 35.7061C93.8789 35.7061 92.2852 37.2998 92.2852 39.2657C92.2852 41.2317 93.8789 42.8254 95.8448 42.8254Z" fill="currentColor"/>
            <path d="M112.435 30.9396C114.401 30.9396 115.994 29.3459 115.994 27.38C115.994 25.414 114.401 23.8203 112.435 23.8203C110.469 23.8203 108.875 25.414 108.875 27.38C108.875 29.3459 110.469 30.9396 112.435 30.9396Z" fill="currentColor"/>
            <path d="M129.761 20.1776C131.735 20.1776 133.335 18.5776 133.335 16.604C133.335 14.6303 131.735 13.0303 129.761 13.0303C127.787 13.0303 126.188 14.6303 126.188 16.604C126.188 18.5776 127.787 20.1776 129.761 20.1776Z" fill="currentColor"/>
            <path d="M147.759 10.5451C149.725 10.5451 151.319 8.95139 151.319 6.98544C151.319 5.0195 149.725 3.42578 147.759 3.42578C145.793 3.42578 144.199 5.0195 144.199 6.98544C144.199 8.95139 145.793 10.5451 147.759 10.5451Z" fill="currentColor"/>
            <path d="M166.345 2.12323C168.311 2.12323 169.904 0.529515 169.904 -1.43643C169.904 -3.40238 168.311 -4.99609 166.345 -4.99609C164.379 -4.99609 162.785 -3.40238 162.785 -1.43643C162.785 0.529515 164.379 2.12323 166.345 2.12323Z" fill="currentColor"/>
            <path d="M405.013 2.12323C406.979 2.12323 408.572 0.529515 408.572 -1.43643C408.572 -3.40238 406.979 -4.99609 405.013 -4.99609C403.047 -4.99609 401.453 -3.40238 401.453 -1.43643C401.453 0.529515 403.047 2.12323 405.013 2.12323Z" fill="currentColor"/>
            <path d="M423.599 10.5451C425.565 10.5451 427.158 8.95139 427.158 6.98544C427.158 5.0195 425.565 3.42578 423.599 3.42578C421.633 3.42578 420.039 5.0195 420.039 6.98544C420.039 8.95139 421.633 10.5451 423.599 10.5451Z" fill="currentColor"/>
            <path d="M441.597 20.1776C443.571 20.1776 445.171 18.5776 445.171 16.604C445.171 14.6303 443.571 13.0303 441.597 13.0303C439.623 13.0303 438.023 14.6303 438.023 16.604C438.023 18.5776 439.623 20.1776 441.597 20.1776Z" fill="currentColor"/>
            <path d="M458.927 30.9396C460.893 30.9396 462.486 29.3459 462.486 27.38C462.486 25.414 460.893 23.8203 458.927 23.8203C456.961 23.8203 455.367 25.414 455.367 27.38C455.367 29.3459 456.961 30.9396 458.927 30.9396Z" fill="currentColor"/>
            <path d="M475.513 42.8254C477.479 42.8254 479.072 41.2317 479.072 39.2657C479.072 37.2998 477.479 35.7061 475.513 35.7061C473.547 35.7061 471.953 37.2998 471.953 39.2657C471.953 41.2317 473.547 42.8254 475.513 42.8254Z" fill="currentColor"/>
            <path d="M491.286 55.7707C493.252 55.7707 494.846 54.177 494.846 52.211C494.846 50.2451 493.252 48.6514 491.286 48.6514C489.32 48.6514 487.727 50.2451 487.727 52.211C487.727 54.177 489.32 55.7707 491.286 55.7707Z" fill="currentColor"/>
            <path d="M506.181 69.7199C508.147 69.7199 509.74 68.1262 509.74 66.1602C509.74 64.1943 508.147 62.6006 506.181 62.6006C504.215 62.6006 502.621 64.1943 502.621 66.1602C502.621 68.1262 504.215 69.7199 506.181 69.7199Z" fill="currentColor"/>
            <path d="M520.13 84.6135C522.096 84.6135 523.69 83.0198 523.69 81.0538C523.69 79.0879 522.096 77.4941 520.13 77.4941C518.164 77.4941 516.57 79.0879 516.57 81.0538C516.57 83.0198 518.164 84.6135 520.13 84.6135Z" fill="currentColor"/>
            <path d="M533.075 100.388C535.041 100.388 536.635 98.7941 536.635 96.8282C536.635 94.8623 535.041 93.2686 533.075 93.2686C531.109 93.2686 529.516 94.8623 529.516 96.8282C529.516 98.7941 531.109 100.388 533.075 100.388Z" fill="currentColor"/>
            <path d="M544.962 116.975C546.928 116.975 548.522 115.381 548.522 113.415C548.522 111.449 546.928 109.855 544.962 109.855C542.996 109.855 541.402 111.449 541.402 113.415C541.402 115.381 542.996 116.975 544.962 116.975Z" fill="currentColor"/>
            <path d="M555.735 134.303C557.701 134.303 559.295 132.709 559.295 130.743C559.295 128.777 557.701 127.184 555.735 127.184C553.769 127.184 552.176 128.777 552.176 130.743C552.176 132.709 553.769 134.303 555.735 134.303Z" fill="currentColor"/>
            <path d="M565.357 152.3C567.322 152.3 568.916 150.706 568.916 148.74C568.916 146.774 567.322 145.181 565.357 145.181C563.391 145.181 561.797 146.774 561.797 148.74C561.797 150.706 563.391 152.3 565.357 152.3Z" fill="currentColor"/>
            <path d="M573.777 170.9C575.751 170.9 577.35 169.3 577.35 167.327C577.35 165.353 575.751 163.753 573.777 163.753C571.803 163.753 570.203 165.353 570.203 167.327C570.203 169.3 571.803 170.9 573.777 170.9Z" fill="currentColor"/>
            <path d="M3.98158 116.043C6.08132 116.043 7.78349 114.341 7.78349 112.241C7.78349 110.142 6.08132 108.439 3.98158 108.439C1.88185 108.439 0.179688 110.142 0.179688 112.241C0.179688 114.341 1.88185 116.043 3.98158 116.043Z" fill="currentColor"/>
            <path d="M15.255 99.0325C17.3548 99.0325 19.0569 97.3303 19.0569 95.2306C19.0569 93.1309 17.3548 91.4287 15.255 91.4287C13.1553 91.4287 11.4531 93.1309 11.4531 95.2306C11.4531 97.3303 13.1553 99.0325 15.255 99.0325Z" fill="currentColor"/>
            <path d="M27.5519 82.7473C29.6517 82.7473 31.3538 81.0452 31.3538 78.9455C31.3538 76.8457 29.6517 75.1436 27.5519 75.1436C25.4522 75.1436 23.75 76.8457 23.75 78.9455C23.75 81.0452 25.4522 82.7473 27.5519 82.7473Z" fill="currentColor"/>
            <path d="M40.8292 67.2513C42.929 67.2513 44.6312 65.5491 44.6312 63.4494C44.6312 61.3497 42.929 59.6475 40.8292 59.6475C38.7295 59.6475 37.0273 61.3497 37.0273 63.4494C37.0273 65.5491 38.7295 67.2513 40.8292 67.2513Z" fill="currentColor"/>
            <path d="M55.0317 52.6162C57.1397 52.6162 58.8486 50.9073 58.8486 48.7993C58.8486 46.6913 57.1397 44.9824 55.0317 44.9824C52.9237 44.9824 51.2148 46.6913 51.2148 48.7993C51.2148 50.9073 52.9237 52.6162 55.0317 52.6162Z" fill="currentColor"/>
            <path d="M70.1144 38.8538C72.2142 38.8538 73.9163 37.1517 73.9163 35.0519C73.9163 32.9522 72.2142 31.25 70.1144 31.25C68.0147 31.25 66.3125 32.9522 66.3125 35.0519C66.3125 37.1517 68.0147 38.8538 70.1144 38.8538Z" fill="currentColor"/>
            <path d="M86.0128 26.0609C88.1126 26.0609 89.8148 24.3587 89.8148 22.259C89.8148 20.1592 88.1126 18.457 86.0128 18.457C83.9131 18.457 82.2109 20.1592 82.2109 22.259C82.2109 24.3587 83.9131 26.0609 86.0128 26.0609Z" fill="currentColor"/>
            <path d="M102.669 14.2708C104.769 14.2708 106.471 12.5686 106.471 10.4689C106.471 8.36915 104.769 6.66699 102.669 6.66699C100.569 6.66699 98.8672 8.36915 98.8672 10.4689C98.8672 12.5686 100.569 14.2708 102.669 14.2708Z" fill="currentColor"/>
            <path d="M120.017 3.52765C122.116 3.52765 123.819 1.82547 123.819 -0.27426C123.819 -2.37399 122.116 -4.07617 120.017 -4.07617C117.917 -4.07617 116.215 -2.37399 116.215 -0.27426C116.215 1.82547 117.917 3.52765 120.017 3.52765Z" fill="currentColor"/>
            <path d="M451.341 3.52765C453.441 3.52765 455.143 1.82547 455.143 -0.27426C455.143 -2.37399 453.441 -4.07617 451.341 -4.07617C449.241 -4.07617 447.539 -2.37399 447.539 -0.27426C447.539 1.82547 449.241 3.52765 451.341 3.52765Z" fill="currentColor"/>
            <path d="M468.693 14.2708C470.792 14.2708 472.494 12.5686 472.494 10.4689C472.494 8.36915 470.792 6.66699 468.693 6.66699C466.593 6.66699 464.891 8.36915 464.891 10.4689C464.891 12.5686 466.593 14.2708 468.693 14.2708Z" fill="currentColor"/>
            <path d="M485.349 26.0609C487.449 26.0609 489.151 24.3587 489.151 22.259C489.151 20.1592 487.449 18.457 485.349 18.457C483.249 18.457 481.547 20.1592 481.547 22.259C481.547 24.3587 483.249 26.0609 485.349 26.0609Z" fill="currentColor"/>
            <path d="M501.247 38.8538C503.347 38.8538 505.049 37.1517 505.049 35.0519C505.049 32.9522 503.347 31.25 501.247 31.25C499.147 31.25 497.445 32.9522 497.445 35.0519C497.445 37.1517 499.147 38.8538 501.247 38.8538Z" fill="currentColor"/>
            <path d="M516.325 52.6009C518.425 52.6009 520.127 50.8987 520.127 48.799C520.127 46.6992 518.425 44.9971 516.325 44.9971C514.226 44.9971 512.523 46.6992 512.523 48.799C512.523 50.8987 514.226 52.6009 516.325 52.6009Z" fill="currentColor"/>
            <path d="M530.532 67.2513C532.632 67.2513 534.334 65.5491 534.334 63.4494C534.334 61.3497 532.632 59.6475 530.532 59.6475C528.433 59.6475 526.73 61.3497 526.73 63.4494C526.73 65.5491 528.433 67.2513 530.532 67.2513Z" fill="currentColor"/>
            <path d="M543.81 82.7473C545.909 82.7473 547.612 81.0452 547.612 78.9455C547.612 76.8457 545.909 75.1436 543.81 75.1436C541.71 75.1436 540.008 76.8457 540.008 78.9455C540.008 81.0452 541.71 82.7473 543.81 82.7473Z" fill="currentColor"/>
            <path d="M556.107 99.0325C558.206 99.0325 559.908 97.3303 559.908 95.2306C559.908 93.1309 558.206 91.4287 556.107 91.4287C554.007 91.4287 552.305 93.1309 552.305 95.2306C552.305 97.3303 554.007 99.0325 556.107 99.0325Z" fill="currentColor"/>
            <path d="M567.376 116.043C569.476 116.043 571.178 114.341 571.178 112.241C571.178 110.142 569.476 108.439 567.376 108.439C565.276 108.439 563.574 110.142 563.574 112.241C563.574 114.341 565.276 116.043 567.376 116.043Z" fill="currentColor"/>
            <path d="M567.376 464.882C569.476 464.882 571.178 463.18 571.178 461.08C571.178 458.98 569.476 457.278 567.376 457.278C565.276 457.278 563.574 458.98 563.574 461.08C563.574 463.18 565.276 464.882 567.376 464.882Z" fill="currentColor"/>
            <path d="M556.106 481.908C558.214 481.908 559.923 480.199 559.923 478.091C559.923 475.983 558.214 474.274 556.106 474.274C553.998 474.274 552.289 475.983 552.289 478.091C552.289 480.199 553.998 481.908 556.106 481.908Z" fill="currentColor"/>
            <path d="M543.809 498.193C545.917 498.193 547.626 496.484 547.626 494.376C547.626 492.268 545.917 490.56 543.809 490.56C541.701 490.56 539.992 492.268 539.992 494.376C539.992 496.484 541.701 498.193 543.809 498.193Z" fill="currentColor"/>
            <path d="M530.532 513.675C532.632 513.675 534.334 511.973 534.334 509.873C534.334 507.773 532.632 506.071 530.532 506.071C528.433 506.071 526.73 507.773 526.73 509.873C526.73 511.973 528.433 513.675 530.532 513.675Z" fill="currentColor"/>
            <path d="M516.325 528.325C518.425 528.325 520.127 526.622 520.127 524.523C520.127 522.423 518.425 520.721 516.325 520.721C514.226 520.721 512.523 522.423 512.523 524.523C512.523 526.622 514.226 528.325 516.325 528.325Z" fill="currentColor"/>
            <path d="M501.247 542.073C503.347 542.073 505.049 540.37 505.049 538.271C505.049 536.171 503.347 534.469 501.247 534.469C499.147 534.469 497.445 536.171 497.445 538.271C497.445 540.37 499.147 542.073 501.247 542.073Z" fill="currentColor"/>
            <path d="M485.349 554.866C487.449 554.866 489.151 553.163 489.151 551.064C489.151 548.964 487.449 547.262 485.349 547.262C483.249 547.262 481.547 548.964 481.547 551.064C481.547 553.163 483.249 554.866 485.349 554.866Z" fill="currentColor"/>
            <path d="M468.693 566.656C470.792 566.656 472.494 564.953 472.494 562.854C472.494 560.754 470.792 559.052 468.693 559.052C466.593 559.052 464.891 560.754 464.891 562.854C464.891 564.953 466.593 566.656 468.693 566.656Z" fill="currentColor"/>
            <path d="M451.341 577.398C453.441 577.398 455.143 575.696 455.143 573.596C455.143 571.496 453.441 569.794 451.341 569.794C449.241 569.794 447.539 571.496 447.539 573.596C447.539 575.696 449.241 577.398 451.341 577.398Z" fill="currentColor"/>
            <path d="M120.017 577.398C122.116 577.398 123.819 575.696 123.819 573.596C123.819 571.496 122.116 569.794 120.017 569.794C117.917 569.794 116.215 571.496 116.215 573.596C116.215 575.696 117.917 577.398 120.017 577.398Z" fill="currentColor"/>
            <path d="M102.669 566.656C104.769 566.656 106.471 564.953 106.471 562.854C106.471 560.754 104.769 559.052 102.669 559.052C100.569 559.052 98.8672 560.754 98.8672 562.854C98.8672 564.953 100.569 566.656 102.669 566.656Z" fill="currentColor"/>
            <path d="M86.0128 554.866C88.1126 554.866 89.8148 553.163 89.8148 551.064C89.8148 548.964 88.1126 547.262 86.0128 547.262C83.9131 547.262 82.2109 548.964 82.2109 551.064C82.2109 553.163 83.9131 554.866 86.0128 554.866Z" fill="currentColor"/>
            <path d="M70.1144 542.073C72.2142 542.073 73.9163 540.37 73.9163 538.271C73.9163 536.171 72.2142 534.469 70.1144 534.469C68.0147 534.469 66.3125 536.171 66.3125 538.271C66.3125 540.37 68.0147 542.073 70.1144 542.073Z" fill="currentColor"/>
            <path d="M55.0324 528.325C57.1321 528.325 58.8343 526.622 58.8343 524.523C58.8343 522.423 57.1321 520.721 55.0324 520.721C52.9326 520.721 51.2305 522.423 51.2305 524.523C51.2305 526.622 52.9326 528.325 55.0324 528.325Z" fill="currentColor"/>
            <path d="M40.8292 513.675C42.929 513.675 44.6312 511.973 44.6312 509.873C44.6312 507.773 42.929 506.071 40.8292 506.071C38.7295 506.071 37.0273 507.773 37.0273 509.873C37.0273 511.973 38.7295 513.675 40.8292 513.675Z" fill="currentColor"/>
            <path d="M27.5513 498.193C29.6593 498.193 31.3681 496.484 31.3681 494.376C31.3681 492.268 29.6593 490.56 27.5513 490.56C25.4433 490.56 23.7344 492.268 23.7344 494.376C23.7344 496.484 25.4433 498.193 27.5513 498.193Z" fill="currentColor"/>
            <path d="M15.255 481.893C17.3548 481.893 19.0569 480.191 19.0569 478.091C19.0569 475.991 17.3548 474.289 15.255 474.289C13.1553 474.289 11.4531 475.991 11.4531 478.091C11.4531 480.191 13.1553 481.893 15.255 481.893Z" fill="currentColor"/>
            <path d="M3.98158 464.882C6.08132 464.882 7.78349 463.18 7.78349 461.08C7.78349 458.98 6.08132 457.278 3.98158 457.278C1.88185 457.278 0.179688 458.98 0.179688 461.08C0.179688 463.18 1.88185 464.882 3.98158 464.882Z" fill="currentColor"/>
            <path d="M567.075 500.224C569.323 500.224 571.146 498.401 571.146 496.153C571.146 493.905 569.323 492.082 567.075 492.082C564.827 492.082 563.004 493.905 563.004 496.153C563.004 498.401 564.827 500.224 567.075 500.224Z" fill="currentColor"/>
            <path d="M554.419 516.204C556.653 516.204 558.463 514.393 558.463 512.159C558.463 509.926 556.653 508.115 554.419 508.115C552.186 508.115 550.375 509.926 550.375 512.159C550.375 514.393 552.186 516.204 554.419 516.204Z" fill="currentColor"/>
            <path d="M540.853 531.448C543.086 531.448 544.897 529.637 544.897 527.404C544.897 525.17 543.086 523.359 540.853 523.359C538.619 523.359 536.809 525.17 536.809 527.404C536.809 529.637 538.619 531.448 540.853 531.448Z" fill="currentColor"/>
            <path d="M526.423 545.878C528.657 545.878 530.467 544.068 530.467 541.834C530.467 539.601 528.657 537.79 526.423 537.79C524.19 537.79 522.379 539.601 522.379 541.834C522.379 544.068 524.19 545.878 526.423 545.878Z" fill="currentColor"/>
            <path d="M511.177 559.444C513.41 559.444 515.221 557.633 515.221 555.4C515.221 553.166 513.41 551.355 511.177 551.355C508.943 551.355 507.133 553.166 507.133 555.4C507.133 557.633 508.943 559.444 511.177 559.444Z" fill="currentColor"/>
            <path d="M495.173 572.101C497.407 572.101 499.217 570.29 499.217 568.057C499.217 565.823 497.407 564.013 495.173 564.013C492.94 564.013 491.129 565.823 491.129 568.057C491.129 570.29 492.94 572.101 495.173 572.101Z" fill="currentColor"/>
            <path d="M76.1887 572.101C78.4222 572.101 80.2328 570.29 80.2328 568.057C80.2328 565.823 78.4222 564.013 76.1887 564.013C73.9552 564.013 72.1445 565.823 72.1445 568.057C72.1445 570.29 73.9552 572.101 76.1887 572.101Z" fill="currentColor"/>
            <path d="M60.1809 559.444C62.4144 559.444 64.225 557.633 64.225 555.4C64.225 553.166 62.4144 551.355 60.1809 551.355C57.9474 551.355 56.1367 553.166 56.1367 555.4C56.1367 557.633 57.9474 559.444 60.1809 559.444Z" fill="currentColor"/>
            <path d="M44.9348 545.878C47.1683 545.878 48.9789 544.068 48.9789 541.834C48.9789 539.601 47.1683 537.79 44.9348 537.79C42.7012 537.79 40.8906 539.601 40.8906 541.834C40.8906 544.068 42.7012 545.878 44.9348 545.878Z" fill="currentColor"/>
            <path d="M30.5051 531.448C32.7386 531.448 34.5492 529.637 34.5492 527.404C34.5492 525.17 32.7386 523.359 30.5051 523.359C28.2716 523.359 26.4609 525.17 26.4609 527.404C26.4609 529.637 28.2716 531.448 30.5051 531.448Z" fill="currentColor"/>
            <path d="M16.9387 516.204C19.1722 516.204 20.9828 514.393 20.9828 512.159C20.9828 509.926 19.1722 508.115 16.9387 508.115C14.7052 508.115 12.8945 509.926 12.8945 512.159C12.8945 514.393 14.7052 516.204 16.9387 516.204Z" fill="currentColor"/>
            <path d="M4.28241 500.24C6.53964 500.24 8.3695 498.41 8.3695 496.153C8.3695 493.895 6.53964 492.065 4.28241 492.065C2.02517 492.065 0.195312 493.895 0.195312 496.153C0.195312 498.41 2.02517 500.24 4.28241 500.24Z" fill="currentColor"/>
            <path d="M4.28243 81.2133C6.51595 81.2133 8.32657 79.4027 8.32657 77.1691C8.32657 74.9356 6.51595 73.125 4.28243 73.125C2.0489 73.125 0.238281 74.9356 0.238281 77.1691C0.238281 79.4027 2.0489 81.2133 4.28243 81.2133Z" fill="currentColor"/>
            <path d="M16.9387 65.2065C19.1722 65.2065 20.9828 63.3959 20.9828 61.1623C20.9828 58.9288 19.1722 57.1182 16.9387 57.1182C14.7052 57.1182 12.8945 58.9288 12.8945 61.1623C12.8945 63.3959 14.7052 65.2065 16.9387 65.2065Z" fill="currentColor"/>
            <path d="M30.5051 49.9623C32.7386 49.9623 34.5492 48.1517 34.5492 45.9182C34.5492 43.6846 32.7386 41.874 30.5051 41.874C28.2716 41.874 26.4609 43.6846 26.4609 45.9182C26.4609 48.1517 28.2716 49.9623 30.5051 49.9623Z" fill="currentColor"/>
            <path d="M44.9348 35.5326C47.1683 35.5326 48.9789 33.722 48.9789 31.4885C48.9789 29.255 47.1683 27.4443 44.9348 27.4443C42.7012 27.4443 40.8906 29.255 40.8906 31.4885C40.8906 33.722 42.7012 35.5326 44.9348 35.5326Z" fill="currentColor"/>
            <path d="M60.1809 21.9662C62.4144 21.9662 64.225 20.1556 64.225 17.9221C64.225 15.6886 62.4144 13.8779 60.1809 13.8779C57.9474 13.8779 56.1367 15.6886 56.1367 17.9221C56.1367 20.1556 57.9474 21.9662 60.1809 21.9662Z" fill="currentColor"/>
            <path d="M76.1887 9.30899C78.4222 9.30899 80.2328 7.49837 80.2328 5.26485C80.2328 3.03133 78.4222 1.2207 76.1887 1.2207C73.9552 1.2207 72.1445 3.03133 72.1445 5.26485C72.1445 7.49837 73.9552 9.30899 76.1887 9.30899Z" fill="currentColor"/>
            <path d="M495.173 9.30899C497.407 9.30899 499.217 7.49837 499.217 5.26485C499.217 3.03133 497.407 1.2207 495.173 1.2207C492.94 1.2207 491.129 3.03133 491.129 5.26485C491.129 7.49837 492.94 9.30899 495.173 9.30899Z" fill="currentColor"/>
            <path d="M511.177 21.9662C513.41 21.9662 515.221 20.1556 515.221 17.9221C515.221 15.6886 513.41 13.8779 511.177 13.8779C508.943 13.8779 507.133 15.6886 507.133 17.9221C507.133 20.1556 508.943 21.9662 511.177 21.9662Z" fill="currentColor"/>
            <path d="M526.423 35.5326C528.657 35.5326 530.467 33.722 530.467 31.4885C530.467 29.255 528.657 27.4443 526.423 27.4443C524.19 27.4443 522.379 29.255 522.379 31.4885C522.379 33.722 524.19 35.5326 526.423 35.5326Z" fill="currentColor"/>
            <path d="M540.853 49.9775C543.095 49.9775 544.913 48.1598 544.913 45.9175C544.913 43.6752 543.095 41.8574 540.853 41.8574C538.611 41.8574 536.793 43.6752 536.793 45.9175C536.793 48.1598 538.611 49.9775 540.853 49.9775Z" fill="currentColor"/>
            <path d="M554.419 65.2065C556.653 65.2065 558.463 63.3959 558.463 61.1623C558.463 58.9288 556.653 57.1182 554.419 57.1182C552.186 57.1182 550.375 58.9288 550.375 61.1623C550.375 63.3959 552.186 65.2065 554.419 65.2065Z" fill="currentColor"/>
            <path d="M567.075 81.2133C569.309 81.2133 571.12 79.4027 571.12 77.1691C571.12 74.9356 569.309 73.125 567.075 73.125C564.842 73.125 563.031 74.9356 563.031 77.1691C563.031 79.4027 564.842 81.2133 567.075 81.2133Z" fill="currentColor"/>
            <path d="M6.43092 47.7495C8.79823 47.7495 10.7173 45.8305 10.7173 43.4632C10.7173 41.0958 8.79823 39.1768 6.43092 39.1768C4.06361 39.1768 2.14453 41.0958 2.14453 43.4632C2.14453 45.8305 4.06361 47.7495 6.43092 47.7495Z" fill="currentColor"/>
            <path d="M20.2512 32.7359C22.6185 32.7359 24.5376 30.8168 24.5376 28.4495C24.5376 26.0822 22.6185 24.1631 20.2512 24.1631C17.8839 24.1631 15.9648 26.0822 15.9648 28.4495C15.9648 30.8168 17.8839 32.7359 20.2512 32.7359Z" fill="currentColor"/>
            <path d="M34.8802 18.5064C37.2475 18.5064 39.1666 16.5873 39.1666 14.22C39.1666 11.8527 37.2475 9.93359 34.8802 9.93359C32.5129 9.93359 30.5938 11.8527 30.5938 14.22C30.5938 16.5873 32.5129 18.5064 34.8802 18.5064Z" fill="currentColor"/>
            <path d="M50.2669 5.10404C52.6342 5.10404 54.5533 3.18495 54.5533 0.817643C54.5533 -1.54967 52.6342 -3.46875 50.2669 -3.46875C47.8996 -3.46875 45.9805 -1.54967 45.9805 0.817643C45.9805 3.18495 47.8996 5.10404 50.2669 5.10404Z" fill="currentColor"/>
            <path d="M521.091 5.10404C523.458 5.10404 525.377 3.18495 525.377 0.817643C525.377 -1.54967 523.458 -3.46875 521.091 -3.46875C518.724 -3.46875 516.805 -1.54967 516.805 0.817643C516.805 3.18495 518.724 5.10404 521.091 5.10404Z" fill="currentColor"/>
            <path d="M536.478 18.5064C538.845 18.5064 540.764 16.5873 540.764 14.22C540.764 11.8527 538.845 9.93359 536.478 9.93359C534.11 9.93359 532.191 11.8527 532.191 14.22C532.191 16.5873 534.11 18.5064 536.478 18.5064Z" fill="currentColor"/>
            <path d="M551.107 32.7359C553.474 32.7359 555.393 30.8168 555.393 28.4495C555.393 26.0822 553.474 24.1631 551.107 24.1631C548.739 24.1631 546.82 26.0822 546.82 28.4495C546.82 30.8168 548.739 32.7359 551.107 32.7359Z" fill="currentColor"/>
            <path d="M564.928 47.7667C567.305 47.7667 569.231 45.84 569.231 43.4634C569.231 41.0868 567.305 39.1602 564.928 39.1602C562.552 39.1602 560.625 41.0868 560.625 43.4634C560.625 45.84 562.552 47.7667 564.928 47.7667Z" fill="currentColor"/>
            <path d="M564.927 534.145C567.294 534.145 569.213 532.226 569.213 529.859C569.213 527.491 567.294 525.572 564.927 525.572C562.56 525.572 560.641 527.491 560.641 529.859C560.641 532.226 562.56 534.145 564.927 534.145Z" fill="currentColor"/>
            <path d="M551.107 549.159C553.474 549.159 555.393 547.24 555.393 544.872C555.393 542.505 553.474 540.586 551.107 540.586C548.739 540.586 546.82 542.505 546.82 544.872C546.82 547.24 548.739 549.159 551.107 549.159Z" fill="currentColor"/>
            <path d="M536.478 563.388C538.845 563.388 540.764 561.469 540.764 559.102C540.764 556.735 538.845 554.815 536.478 554.815C534.11 554.815 532.191 556.735 532.191 559.102C532.191 561.469 534.11 563.388 536.478 563.388Z" fill="currentColor"/>
            <path d="M521.091 576.791C523.458 576.791 525.377 574.871 525.377 572.504C525.377 570.137 523.458 568.218 521.091 568.218C518.724 568.218 516.805 570.137 516.805 572.504C516.805 574.871 518.724 576.791 521.091 576.791Z" fill="currentColor"/>
            <path d="M50.2669 576.791C52.6342 576.791 54.5533 574.871 54.5533 572.504C54.5533 570.137 52.6342 568.218 50.2669 568.218C47.8996 568.218 45.9805 570.137 45.9805 572.504C45.9805 574.871 47.8996 576.791 50.2669 576.791Z" fill="currentColor"/>
            <path d="M34.8814 563.405C37.258 563.405 39.1847 561.479 39.1847 559.102C39.1847 556.725 37.258 554.799 34.8814 554.799C32.5048 554.799 30.5781 556.725 30.5781 559.102C30.5781 561.479 32.5048 563.405 34.8814 563.405Z" fill="currentColor"/>
            <path d="M20.2512 549.159C22.6185 549.159 24.5376 547.24 24.5376 544.872C24.5376 542.505 22.6185 540.586 20.2512 540.586C17.8839 540.586 15.9648 542.505 15.9648 544.872C15.9648 547.24 17.8839 549.159 20.2512 549.159Z" fill="currentColor"/>
            <path d="M6.43092 534.145C8.79823 534.145 10.7173 532.226 10.7173 529.859C10.7173 527.491 8.79823 525.572 6.43092 525.572C4.06361 525.572 2.14453 527.491 2.14453 529.859C2.14453 532.226 4.06361 534.145 6.43092 534.145Z" fill="currentColor"/>
            <path d="M575.353 552.012C577.854 552.012 579.882 549.985 579.882 547.484C579.882 544.983 577.854 542.955 575.353 542.955C572.852 542.955 570.824 544.983 570.824 547.484C570.824 549.985 572.852 552.012 575.353 552.012Z" fill="currentColor"/>
            <path d="M561.306 566.842C563.822 566.842 565.861 564.802 565.861 562.286C565.861 559.77 563.822 557.73 561.306 557.73C558.79 557.73 556.75 559.77 556.75 562.286C556.75 564.802 558.79 566.842 561.306 566.842Z" fill="currentColor"/>
            <path d="M546.501 580.863C549.002 580.863 551.03 578.835 551.03 576.334C551.03 573.833 549.002 571.806 546.501 571.806C544 571.806 541.973 573.833 541.973 576.334C541.973 578.835 544 580.863 546.501 580.863Z" fill="currentColor"/>
            <path d="M24.8568 580.863C27.3579 580.863 29.3854 578.835 29.3854 576.334C29.3854 573.833 27.3579 571.806 24.8568 571.806C22.3557 571.806 20.3281 573.833 20.3281 576.334C20.3281 578.835 22.3557 580.863 24.8568 580.863Z" fill="currentColor"/>
            <path d="M10.0521 566.815C12.5532 566.815 14.5807 564.788 14.5807 562.286C14.5807 559.785 12.5532 557.758 10.0521 557.758C7.55098 557.758 5.52344 559.785 5.52344 562.286C5.52344 564.788 7.55098 566.815 10.0521 566.815Z" fill="currentColor"/>
            <path d="M-3.99481 552.012C-1.49371 552.012 0.53383 549.985 0.53383 547.484C0.53383 544.983 -1.49371 542.955 -3.99481 542.955C-6.49591 542.955 -8.52344 544.983 -8.52344 547.484C-8.52344 549.985 -6.49591 552.012 -3.99481 552.012Z" fill="currentColor"/>
            <path d="M-3.9926 30.3849C-1.48166 30.3849 0.553869 28.3494 0.553869 25.8385C0.553869 23.3275 -1.48166 21.292 -3.9926 21.292C-6.50355 21.292 -8.53906 23.3275 -8.53906 25.8385C-8.53906 28.3494 -6.50355 30.3849 -3.9926 30.3849Z" fill="currentColor"/>
            <path d="M10.0521 15.5641C12.5532 15.5641 14.5807 13.5366 14.5807 11.0355C14.5807 8.53438 12.5532 6.50684 10.0521 6.50684C7.55098 6.50684 5.52344 8.53438 5.52344 11.0355C5.52344 13.5366 7.55098 15.5641 10.0521 15.5641Z" fill="currentColor"/>
            <path d="M24.8568 1.51723C27.3579 1.51723 29.3854 -0.510315 29.3854 -3.01141C29.3854 -5.51251 27.3579 -7.54004 24.8568 -7.54004C22.3557 -7.54004 20.3281 -5.51251 20.3281 -3.01141C20.3281 -0.510315 22.3557 1.51723 24.8568 1.51723Z" fill="currentColor"/>
            <path d="M546.501 1.51723C549.002 1.51723 551.03 -0.510315 551.03 -3.01141C551.03 -5.51251 549.002 -7.54004 546.501 -7.54004C544 -7.54004 541.973 -5.51251 541.973 -3.01141C541.973 -0.510315 544 1.51723 546.501 1.51723Z" fill="currentColor"/>
            <path d="M561.306 15.5906C563.822 15.5906 565.861 13.551 565.861 11.0351C565.861 8.51909 563.822 6.47949 561.306 6.47949C558.79 6.47949 556.75 8.51909 556.75 11.0351C556.75 13.551 558.79 15.5906 561.306 15.5906Z" fill="currentColor"/>
            <path d="M575.353 30.3669C577.854 30.3669 579.882 28.3393 579.882 25.8382C579.882 23.3371 577.854 21.3096 575.353 21.3096C572.852 21.3096 570.824 23.3371 570.824 25.8382C570.824 28.3393 572.852 30.3669 575.353 30.3669Z" fill="currentColor"/>
        </svg>
    );
};

export default DotsPatternn;