// Core Factory exports
export {Factory} from './factory';
export {PostFactory} from './factories/post-factory';
export type {Post} from './factories/post-factory';
export {TagFactory} from './factories/tag-factory';
export type {Tag} from './factories/tag-factory';
export {MemberFactory} from './factories/member-factory';
export type {Member, Tier} from './factories/member-factory';
export {AutomatedEmailFactory} from './factories/automated-email-factory';
export type {AutomatedEmail} from './factories/automated-email-factory';
export {CommentFactory} from './factories/comment-factory';
export type {Comment} from './factories/comment-factory';
export * from './factories/user-factory';

// Persistence Adapters
export {KnexPersistenceAdapter} from './persistence/adapters/knex';
export {ApiPersistenceAdapter} from './persistence/adapters/api';
export type {HttpClient, HttpResponse} from './persistence/adapters/http-client';
export {GhostAdminApiAdapter} from './persistence/adapters/ghost-api';
export type {PersistenceAdapter} from './persistence/adapter';

// Utilities
export {generateId, generateUuid, generateSlug} from './utils';

// Factory Setup Helpers
export {createPostFactory} from './setup';
export {createTagFactory} from './setup';
export {createMemberFactory} from './setup';
export {createAutomatedEmailFactory} from './setup';
export {createCommentFactory} from './setup';
export {createFactories} from './setup';