import AppContext from '../../../../app-context';
import MemberAvatar from '../../../common/member-gravatar';
import {useContext} from 'react';
import {t} from '../../../../utils/i18n';

const UserHeader = () => {
    const {member, brandColor} = useContext(AppContext);
    const avatar = member.avatar_image;
    return (
        <header className='gh-portal-account-header'>
            <MemberAvatar gravatar={avatar} style={{userIcon: {color: brandColor, width: '56px', height: '56px', padding: '2px'}}} />
            <h2 className="gh-portal-main-title">{t('Your account')}</h2>
        </header>
    );
};

export default UserHeader;
