The widget provides an interface to an AI assistant that can process the content of its slotted element. It presents a
dropdown menu with various prompts (e.g., summarize, fix grammar) and displays the result in a card for review before
applying it back to the target widget.

## Examples

:::warning
None of the examples will work here in the docs as the AI agent cannot be accessed.
:::

### Single Target (Default)

By default, the widget processes the first element placed in its default slot.

```html:preview
<et2-ai>
<et2-textbox value="This is some text that needs to be more formal."></et2-textbox>
</et2-ai>
```

### Multiple Elements (Nested Target)

If you want to process multiple fields together, or if your target is inside a container like Et2Box, the widget will
attempt to extract values from the container using standard eTemplate2 methods.

```html:preview
<et2-ai>
    <et2-vbox>
        <et2-textbox label="Job" id="job_name" value="Do the thing with the thing"></et2-textbox>
        <et2-textarea label="Details" id="body" value="Don't forget the meeting tomorrow at 10 AM."></et2-textarea>
    </et2-box>
</et2-ai>
```

### Custom Prompts

You can provide your own set of prompts. Prompts can define a target (where the result goes) and a mode (replace,
append, or prepend).

```html:preview
<et2-ai id="custom-ai">
<et2-textarea id="my-target" value="Original content. "></et2-textarea>
</et2-ai>
<script>
    const aiWidget = document.getElementById('custom-ai');
    aiWidget.prompts = [
        {
            id: "aiassist.translate-de", 
            label: "Translate to German",
            action: { target: "#my-target", mode: "replace" }
        },
        {
            id: "custom.expand", 
            label: "Add more detail",
            action: { target: "#my-target", mode: "append" }
        }
    ];
</script>
```

:::tip
Prompt IDs must be matched to a predefined prompt on the server.
:::

### Using Events to Interfere

You can listen for the et2-ai-apply event to modify the result before it is written to the target, or call
preventDefault() to cancel the automatic application entirely.

```html:preview 
<et2-ai id="event-demo">
    <et2-textarea value="This text will be intercepted."></et2-textarea>
</et2-ai>

<script>
    const eventAi = document.getElementById('event-demo');
    eventAi.addEventListener('et2-ai-apply', (e) => {
        // e.detail.result contains the AI output
        // e.detail.target contains the element where it will be applied
        
        if (confirm("Do you want to add a signature to the result?")) {
            e.detail.result += "\n\nGenerated by AI Assistant";
        }
        
        // To stop the widget from automatically updating the target:
        // e.preventDefault();
    });
</script>
```
