import {css} from 'lit';
import SlSplitPanelStyles from "./EgwFrameworkSplitPanel.styles";

// noinspection CssUnresolvedCustomProperty
export default css`
    :host {
        display: block;
        width: 100vw;
        height: 100vh;
        position: relative;

        --icon-size: 32px;
        --tmp: hsl(from var(--template-custom-color) h max(calc(s * 0.3), 25) min(calc(l * 2), 80) / 1);
        --icon-background-color: var(--tmp, var(--sl-color-primary-400));
        --inactive-tab-opacity: 0.5;
        --header-icon-size: 1.5rem;
        --left-side-width: 200px;
        --tab-icon-spacing: 2px;
    }

    .egw_fw__layout-default {
        display: grid;

        width: 100%;
        height: 100%;
        grid-template-columns: [start banner-start header-start footer-start main-start] 1fr [main-end header-end banner-end end];
        grid-template-rows: [top banner] fit-content(2em) [header] fit-content(2em) [main-header] fit-content(2em) [main] 1fr [footer bottom] fit-content(2em);
    }

    .egw_fw__layout-default > * {
        position: relative;
        display: flex;
    }

    .egw_fw__layout-default .egw_fw__banner {
        grid-area: banner;
        grid-column-start: banner-start;
        grid-column-end: banner-end;
    }

    .egw_fw__layout-default .egw_fw__header {
        grid-area: header;
        align-items: center;
    }

    .egw_fw__layout-default .egw_fw__header > * {
        flex: 1 1 auto;
    }

    /* To use the sl-split-panel, we need it to have its own space & nest stuff inside */

    .egw_fw__layout-default .egw_fw__divider {
        max-width: 100vw;
        grid-column-start: start;
        grid-column-end: status-start;
        grid-row-start: main-header;
        grid-row-end: footer;
        display: flex;
        justify-content: stretch;
    }

    .egw_fw__layout-default sl-split-panel {
        width: 100%;
    }

    .egw_fw__layout-default sl-split-panel::part(divider) {
        color: var(--sl-color-primary-500);
    }

    .egw_fw__layout-default .egw_fw__sidemenu {
        overflow-x: hidden;
        overflow-y: auto;
    }

    .egw_fw__layout-default .egw_fw__status {
        overflow-x: hidden;
        overflow-y: auto;
    }

    .egw_fw__layout-default > .egw_fw__main {
        grid-area: main;
    }

    .egw_fw__layout-default .egw_fw__footer {
        grid-area: footer;
    }

    @media (min-width: 600px) {
        .egw_fw__main {
            overflow: hidden;
        }
    }
    @media (max-width: 800px) {
        :host(.egw_fw--left-side-collapsed) {
            --left-side-width: 0px;

            .egw_fw__header {
                display: none;
            }
        }
    }
    @media (max-width: 599px) {
        ::slotted([slot="logo"]) {
            display: none;
        }

        ::part(divider) {
            display: none;
        }
    }
    @media print {
        /* Hide the header */
        .egw_fw__header {
            display: none;
        }

        /* Hide status */
        .egw_fw__divider {
            sl-split-panel {
                grid-template-columns: auto 0px 0px !important;
            }
        }

        /* Show all content */
        :host {
            height: auto;
        }

        .egw_fw__main {
            overflow: auto;
        }

        ::slotted(egw-app[active]) {
            display: block;
            height: auto;
        }
    }

    /* Actual styles */

    .egw_fw__header sl-icon-button {
        color: inherit;
    }

    .egw_fw__header .egw_fw__logo_apps {
        container: logo / inline-size;
        flex: 1 1 var(--left-side-width);
        max-width: var(--left-side-width);
        display: flex;
        overflow: hidden;
        justify-content: space-between;
        align-items: center;
    }

    /* Hide logo when things get small (no CSS vars or calc() here) */
    @container logo (width < 150px) {
        slot {
            display: none;
        }
    }

    .egw_fw__header .egw_fw__app_list {
        flex: none;
        font-size: var(--sl-font-size-2x-large);

        sl-icon-button::part(base) {
            padding-left: 0
        }
    }

    .egw_fw__header .spacer {
        flex: 6 0 auto;
        min-width: 2rem;
    }

    .egw_fw__header .spacer_end {
        margin-left: -2rem;
    }

	.egw_fw__app_list {
		img {
			height: var(--icon-size);
			width: var(--icon-size);
		}

		&.egw_fw__app_list-style-icons {
			&::part(panel) {
				display: grid;
				grid-template-columns: repeat(5, 1fr);
				background-color: var(--sl-color-neutral-0);
				font-size: var(--icon-size);
				border-radius: var(--icon-size);
				position: relative;
				top: 0.8rem;
				padding: var(--sl-spacing-medium);
				gap: var(--sl-spacing-medium);
			}
            & > et2-image {
                cursor: pointer;
            }
		}

		&.egw_fw__app_list-style-text {
			&::part(panel) {
				display: block;
				border-radius: var(--sl-border-radius-large);
				padding: 0;
			}

			sl-menu {
				padding: var(--sl-spacing-medium);
				border-color: transparent;
				font-size: var(--sl-font-size-medium);
			}

			sl-menu-item::part(base) {
				align-items: center;
			}
		}
	}

    .egw_fw__open_applications {
        --track-width: 0px;
        max-width: calc(100vw - 13em);
    }

    .egw_fw__open_applications::part(tabs) {
        align-items: center;
    }

    .egw_fw__open_applications sl-tab {
        display: flex;
        width: auto;
        flex: 1 1 auto;
        position: relative;
        /* notification badges styling*/

        *[part="notification"] {
            position: absolute;
            bottom: 0px;
            left: -.5em;
            font-size: 1rem;

            &::part(base) {
                /* put specific sizing here*/
                padding: 0.15em 0.4em;
            }
        }
    }

    .egw_fw__open_applications sl-tab:last-of-type {
        flex: 0 0 auto;
    }

    /*make non active tabs a little transparent if we use our colorful icons*/
    /* unless you hover over one*/

    .egw_fw__open_applications sl-tab:not([active]).colorful *[part='tab-icon'] {
        opacity: var(--inactive-tab-opacity);

        &:hover {
            opacity: 1;
        }
    }

    .egw_fw__open_applications sl-tab::part(base) {
        padding: 0px;
        font-size: var(--tab-icon-size);
        align-items: center;
    }

    .egw_fw__open_applications sl-tab::part(close-button) {
        visibility: hidden;
        margin: 0;
        position: relative;
        bottom: 1.5em;
        right: .6em;
        color: var(--sl-color-neutral-900);
    }

    /*Icons for open applications that do not have kdots specific icon*/

    .egw_fw__open_applications et2-image:not([src*='/kdots-navbar.svg']), .egw_fw__app_list et2-image:not([src*='/kdots-navbar.svg']) {
        /* Always force icons to be the same size */
        height: var(--tab-icon-size, 32px);
        min-width: calc(var(--tab-icon-size, 32px));
        min-height: calc(var(--tab-icon-size, 32px));
        /* Prevent large icons from causing problems */
        max-width: var(--tab-icon-size, 32px);
        max-height: var(--tab-icon-size, 32px);

        /*align items centered on round app colored background*/
        padding: var(--tab-icon-spacing, 2px);
        background-color: var(--application-color, var(--default-color, var(--sl-color-neutral-600)));
        border-radius: var(--sl-border-radius-circle);
        text-align: center;
        line-height: 100%;
        align-content: end;


        *[part="image"] {
            position: relative;
            /*turn all app icons white*/
            filter: brightness(0) invert(1);
            width: 70%;
            height: auto;

            /*keep avatar images colored*/

            &[src*="avatar.php"] {
                filter: none;
                width: 100%;
                max-height: 100%;
                border-radius: var(--sl-border-radius-circle);
                vertical-align: bottom;
            }

            @supports (-moz-appearance:none) {
                bottom: 1.5px;
            }
        }
    }

    /***
	coloring of app icons with our monotone colors
	 */
    /*make non active crm view tabs a little transparent*/

    .egw_fw__open_applications sl-tab:not([active]) *[part='tab-icon'][src*='/avatar.php'] {
        opacity: var(--inactive-tab-opacity);
    }

    /* unless you hover over one*/

    .egw_fw__open_applications sl-tab:not([active]):hover *[part='tab-icon'][src*='/avatar.php'] {
        opacity: 1;
    }

    .egw_fw__open_applications et2-image:not([src*='/kdots-navbar.svg']) {
        background-color: var(--icon-background-color);

        &:hover {
            background-color: var(--application-color, var(--default-color, var(--sl-color-primary-700)));
        }
    }

    .egw_fw__open_applications sl-tab[active] *[part='tab-icon']:not([src*='/kdots-navbar.svg']) {
        background-color: var(--application-color, var(--default-color, var(--sl-color-primary-700)));
    }


    .egw_fw__open_applications et2-image[src*='/kdots-navbar.svg'] {
        color: var(--icon-background-color);
    }

    .egw_fw__app_list et2-image[src*='/kdots-navbar.svg'], .egw_fw__open_applications et2-image[src*='/kdots-navbar.svg']:hover {
        color: var(--application-color, var(--default-color, var(--sl-color-primary-700)));
    }

    .egw_fw__open_applications sl-tab[active] *[part='tab-icon'][src*='/kdots-navbar.svg'] {
        color: var(--application-color, var(--default-color, var(--sl-color-primary-700)));
    }

    /*Icons for applications that have a kdots specific icon*/

    .egw_fw__open_applications et2-image[src*='/kdots-navbar.svg'], .egw_fw__app_list et2-image[src*='/kdots-navbar.svg'] {
        /* Always force icons to be the same size */
        height: calc(
                calc(2 * var(--tab-icon-spacing, 2px) +
                var(--tab-icon-size, 32px)));
        min-width: calc(
                calc(2 * var(--tab-icon-spacing, 2px) +
                var(--tab-icon-size, 32px)));
        min-height: calc(
                calc(2 * var(--tab-icon-spacing, 2px) +
                var(--tab-icon-size, 32px)));
        /* Prevent large icons from causing problems */
        max-width: calc(
                calc(2 * var(--tab-icon-spacing, 2px) +
                var(--tab-icon-size, 32px)));
        max-height: calc(
                calc(2 * var(--tab-icon-spacing, 2px) +
                var(--tab-icon-size, 32px)));

        *[part="image"] {
            width: calc(
                    calc(2 * var(--tab-icon-spacing, 2px) +
                    var(--tab-icon-size, 32px)));
            height: auto;
        }
        
    }

    /* needs different alignment in app_list and open_apps*/

    .egw_fw__app_list et2-image[src*='/kdots-navbar.svg'] *[part="image"] {
        vertical-align: initial;
    }


    .egw_fw__open_applications sl-tab:hover::part(close-button) {
        visibility: visible;
    }

    ::slotted(egw-app:not([active]):not([slot])) {
        display: none;
    }

    /*
	This is the same as in EgwFrameworkApp.styles.ts
	*/
    ${SlSplitPanelStyles}

`