/**
 * EGroupware - Notifications Java Desktop App
 *
 * @license http://opensource.org/licenses/gpl-license.php GPL - GNU General Public License
 * @package notifications
 * @subpackage jdesk
 * @link http://www.egroupware.org
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 * @author Maik Hüttner <maik.huettner@hw-softwareentwicklung.de>
 */

/*
 * jegwConfigDialog.java
 *
 * Created on 19.05.2009, 14:23:15
 */

package egroupwaretray;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeSelectionModel;

/**
 * jegwConfigDialog
 * 
 * @author Stefan Werfling <stefan.werfling@hw-softwareentwicklung.de>
 */
public class jegwConfigDialog extends javax.swing.JDialog {

    private jegwconfig config = null;
    private Integer configindex = -1;

    /** Creates new form jegwConfigDialog */
    public jegwConfigDialog(java.awt.Frame parent, boolean modal, jegwconfig configmanager)
    {
        super(parent, modal);
        initComponents();

        this.config = configmanager;
        this.showConfig();
        this.jBcancel.setEnabled(false);
        this.jBedit.setEnabled(false);
    }

    private void showConfig()
    {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)((DefaultTreeModel) jTegwoverview.getModel()).getRoot();
        // Alle Nodes Löschen und Root Knoten wieder hinzufügen
        ((DefaultTreeModel)jTegwoverview.getModel()).setRoot(null);

        javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("eGroupwares");
        jTegwoverview.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));


        KeyArray aktivconf = this.config.getCXMLM().getActivConf();

        if(aktivconf == null)
        {
            return;
        }

        // Aktiver User anzeigen
        this.lhoststatus.setText(aktivconf.getString("host"));
        this.jLuserstatus.setText(aktivconf.getString("user"));

        this.jTegwoverview.setCellRenderer(new Renderer2());

        for( int g=0; g<this.config.getCXMLM().countConf(); g++ )
        {
            root = (DefaultMutableTreeNode)((DefaultTreeModel) jTegwoverview.getModel()).getRoot();
            KeyArray conf = this.config.getCXMLM().getConf(g);

            DefaultMutableTreeNode subnode = null;

            for( int i=0; i<root.getChildCount(); i++ )
            {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode) root.getChildAt(i);
                String nodename = (String) node.getUserObject();

                if( nodename.compareTo(conf.getString("host")) == 0 )
                {
                    subnode = node;
                }
            }

            if(subnode == null)
            {
                DefaultMutableTreeNode host = new DefaultMutableTreeNode(conf.getString("host"));
                ((DefaultTreeModel) jTegwoverview.getModel()).insertNodeInto(host, root, 0);
                subnode = host;
            }

            DefaultMutableTreeNode user = new DefaultMutableTreeNode(conf.getString("user"));
            ((DefaultTreeModel) jTegwoverview.getModel()).insertNodeInto(user, subnode, 0);
        }
    }

    public void infoDialog(String str, String title)
    {
        JOptionPane.showMessageDialog(EgroupwareTrayApp.getApplication().getMainFrame(),
                str, title, JOptionPane.INFORMATION_MESSAGE);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jDialog1 = new javax.swing.JDialog();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTegwoverview = new javax.swing.JTree();
        jPaccountsetting = new javax.swing.JPanel();
        jLhost = new javax.swing.JLabel();
        jTFhost = new javax.swing.JTextField();
        jLsamplehost = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLsamplepath = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jTFusername = new javax.swing.JTextField();
        jLsampleuser = new javax.swing.JLabel();
        jBsave = new javax.swing.JButton();
        jBcancel = new javax.swing.JButton();
        jBedit = new javax.swing.JButton();
        jTFegwurl = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        lhoststatus = new java.awt.Label();
        jLuserstatus = new javax.swing.JLabel();
        jBSelectActiv = new javax.swing.JButton();

        jDialog1.setName("jDialog1"); // NOI18N

        javax.swing.GroupLayout jDialog1Layout = new javax.swing.GroupLayout(jDialog1.getContentPane());
        jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );
        jDialog1Layout.setVerticalGroup(
            jDialog1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 300, Short.MAX_VALUE)
        );

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(egroupwaretray.EgroupwareTrayApp.class).getContext().getResourceMap(jegwConfigDialog.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N

        jScrollPane1.setName("jScrollPane1"); // NOI18N

        javax.swing.tree.DefaultMutableTreeNode treeNode1 = new javax.swing.tree.DefaultMutableTreeNode("eGroupwares");
        jTegwoverview.setModel(new javax.swing.tree.DefaultTreeModel(treeNode1));
        jTegwoverview.setDoubleBuffered(true);
        jTegwoverview.setName("jTegwoverview"); // NOI18N
        jTegwoverview.setShowsRootHandles(true);
        jTegwoverview.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jTegwoverviewMouseClicked(evt);
            }
        });
        jTegwoverview.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jTegwoverviewMouseDragged(evt);
            }
        });
        jScrollPane1.setViewportView(jTegwoverview);

        jPaccountsetting.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("jPaccountsetting.border.title"))); // NOI18N
        jPaccountsetting.setName("jPaccountsetting"); // NOI18N

        jLhost.setText(resourceMap.getString("jLhost.text")); // NOI18N
        jLhost.setName("jLhost"); // NOI18N

        jTFhost.setText(resourceMap.getString("jTFhost.text")); // NOI18N
        jTFhost.setName("jTFhost"); // NOI18N

        jLsamplehost.setText(resourceMap.getString("jLsamplehost.text")); // NOI18N
        jLsamplehost.setName("jLsamplehost"); // NOI18N

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jLsamplepath.setText(resourceMap.getString("jLsamplepath.text")); // NOI18N
        jLsamplepath.setName("jLsamplepath"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        jTFusername.setText(resourceMap.getString("jTFusername.text")); // NOI18N
        jTFusername.setName("jTFusername"); // NOI18N

        jLsampleuser.setText(resourceMap.getString("jLsampleuser.text")); // NOI18N
        jLsampleuser.setName("jLsampleuser"); // NOI18N

        jBsave.setText(resourceMap.getString("jBsave.text")); // NOI18N
        jBsave.setName("jBsave"); // NOI18N
        jBsave.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBsaveMouseClicked(evt);
            }
        });

        jBcancel.setText(resourceMap.getString("jBcancel.text")); // NOI18N
        jBcancel.setName("jBcancel"); // NOI18N
        jBcancel.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBcancelMouseClicked(evt);
            }
        });

        jBedit.setText(resourceMap.getString("jBedit.text")); // NOI18N
        jBedit.setName("jBedit"); // NOI18N
        jBedit.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBeditMouseClicked(evt);
            }
        });

        jTFegwurl.setText(resourceMap.getString("jTFegwurl.text")); // NOI18N
        jTFegwurl.setName("jTFegwurl"); // NOI18N

        javax.swing.GroupLayout jPaccountsettingLayout = new javax.swing.GroupLayout(jPaccountsetting);
        jPaccountsetting.setLayout(jPaccountsettingLayout);
        jPaccountsettingLayout.setHorizontalGroup(
            jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPaccountsettingLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jBsave, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(jPaccountsettingLayout.createSequentialGroup()
                        .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLhost, javax.swing.GroupLayout.DEFAULT_SIZE, 61, Short.MAX_VALUE)
                            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 61, Short.MAX_VALUE)
                            .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, 61, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jLsamplehost, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
                            .addComponent(jTFhost, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
                            .addComponent(jTFusername, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.LEADING, jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addGroup(jPaccountsettingLayout.createSequentialGroup()
                                    .addGap(26, 26, 26)
                                    .addComponent(jBedit, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                    .addComponent(jBcancel, javax.swing.GroupLayout.PREFERRED_SIZE, 97, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addComponent(jLsampleuser, javax.swing.GroupLayout.PREFERRED_SIZE, 228, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jLsamplepath, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, 238, Short.MAX_VALUE)
                            .addComponent(jTFegwurl, javax.swing.GroupLayout.PREFERRED_SIZE, 238, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        jPaccountsettingLayout.setVerticalGroup(
            jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPaccountsettingLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLhost)
                    .addComponent(jTFhost, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLsamplehost)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jTFegwurl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLsamplepath)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTFusername, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLsampleuser)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 118, Short.MAX_VALUE)
                .addGroup(jPaccountsettingLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jBsave)
                    .addComponent(jBedit)
                    .addComponent(jBcancel))
                .addContainerGap())
        );

        jLhost.getAccessibleContext().setAccessibleName(resourceMap.getString("jLhost.AccessibleContext.accessibleName")); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title"))); // NOI18N
        jPanel1.setName("jPanel1"); // NOI18N

        lhoststatus.setName("lhoststatus"); // NOI18N
        lhoststatus.setText(resourceMap.getString("lhoststatus.text")); // NOI18N

        jLuserstatus.setText(resourceMap.getString("jLuserstatus.text")); // NOI18N
        jLuserstatus.setName("jLuserstatus"); // NOI18N

        jBSelectActiv.setText(resourceMap.getString("jBSelectActiv.text")); // NOI18N
        jBSelectActiv.setName("jBSelectActiv"); // NOI18N
        jBSelectActiv.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jBSelectActivMouseClicked(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLuserstatus, javax.swing.GroupLayout.DEFAULT_SIZE, 305, Short.MAX_VALUE)
                            .addComponent(lhoststatus, javax.swing.GroupLayout.DEFAULT_SIZE, 305, Short.MAX_VALUE))
                        .addContainerGap())
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup()
                        .addComponent(jBSelectActiv)
                        .addGap(73, 73, 73))))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(lhoststatus, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLuserstatus)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jBSelectActiv)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 229, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPaccountsetting, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addGap(10, 10, 10))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jScrollPane1, javax.swing.GroupLayout.DEFAULT_SIZE, 455, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPaccountsetting, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        jPanel1.getAccessibleContext().setAccessibleName(resourceMap.getString("jPanel1.AccessibleContext.accessibleName")); // NOI18N

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jBsaveMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBsaveMouseClicked

        this.showConfig();

        if( this.configindex != -1 )
        {
            this.config.getCXMLM().deleteConf(this.configindex);
            this.configindex = -1;
        }

        KeyArray conf = new KeyArray(jegwxmlconfig.CONF_STRUCT);

        conf.add("host", this.jTFhost.getText());
        conf.add("user", this.jTFusername.getText());
        conf.add("egwurl", this.jTFegwurl.getText());
        conf.add("password", "");
        conf.add("logindomain", "");
        conf.add("subdir", "");

        this.config.getCXMLM().addConf(conf);

        try
        {
            this.config.saveConfig();
            this.showConfig();
            this.jBcancelMouseClicked(null);

            this.infoDialog("Ihre Einstellungen wurden erfolgreich gespeichert.", "Info");
        }
        catch (Exception ex)
        {
            Logger.getLogger(jegwConfigDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }//GEN-LAST:event_jBsaveMouseClicked

    private void jTegwoverviewMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTegwoverviewMouseClicked
        if (evt.getClickCount() == 2)
        {

            try
            {
                TreeSelectionModel model = jTegwoverview.getSelectionModel();
                String user = (String) model.getSelectionPath().getLastPathComponent().toString();
                String host = (String) model.getSelectionPath().getParentPath().getLastPathComponent().toString();

                for(int i=0; i<this.config.getCXMLM().countConf(); i++)
                {
                    KeyArray conf = this.config.getCXMLM().getConf(i);

                    if( (conf.getString("user").compareTo(user) == 0) &&
                            (conf.getString("host").compareTo(host) == 0) )
                    {
                        this.jBsave.setEnabled(false);
                        this.jTFusername.setText(user);
                        this.jTFusername.setEnabled(false);
                        this.jTFhost.setText(host);
                        this.jTFhost.setEnabled(false);
                        this.jTFegwurl.setText(conf.getString("egwurl"));
                        this.jTFegwurl.setEnabled(false);
                        this.configindex = i;
                        //this.jTegwoverview.disable();
                        this.jBedit.setEnabled(true);
                        this.jBcancel.setEnabled(true);
                        
                        return;
                    }
                }
            }
            catch(Exception e)
            {
                // Keine meldung
                Logger.getLogger(jegwConfigDialog.class.getName()).log(Level.SEVERE, null, e);
            }

        }
    }//GEN-LAST:event_jTegwoverviewMouseClicked

    private void jTegwoverviewMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jTegwoverviewMouseDragged
        // TODO add your handling code here:
    }//GEN-LAST:event_jTegwoverviewMouseDragged

    private void jBcancelMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBcancelMouseClicked
        // TODO add your handling code here:
        this.jTFhost.setText("");
        this.jTFusername.setText("");
        this.jTFegwurl.setText("");

        this.jTFusername.setEnabled(true);
        this.jTFhost.setEnabled(true);
        this.jTFegwurl.setEnabled(true);

        this.jBcancel.setEnabled(false);
        this.jBsave.setEnabled(true);
        this.jBedit.setEnabled(false);

        //this.jTegwoverview.enable();
        this.jTegwoverview.updateUI();
    }//GEN-LAST:event_jBcancelMouseClicked

    private void jBSelectActivMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBSelectActivMouseClicked
        // TODO add your handling code here:
        try
        {
            TreeSelectionModel model = jTegwoverview.getSelectionModel();
            String user = (String) model.getSelectionPath().getLastPathComponent().toString();
            String host = (String) model.getSelectionPath().getParentPath().getLastPathComponent().toString();

            for(int i=0; i<this.config.getCXMLM().countConf(); i++)
            {
                KeyArray conf = this.config.getCXMLM().getConf(i);

                if( (conf.getString("user").compareTo(user) == 0) &&
                        (conf.getString("host").compareTo(host) == 0) )
                {
                    this.config.getCXMLM().setActivConf(i);

                    try
                    {
                        this.config.saveConfig();
                    }
                    catch(Exception e)
                    {
                        JOptionPane.showMessageDialog(EgroupwareTrayApp.getApplication().getMainFrame(),
                            "Beim Speichern der Konfigurationsdatei trat ein Fehler auf!",
                            "Konfigurationsfehler", JOptionPane.ERROR_MESSAGE);
                    }

                    this.showConfig();
                    return;
                }
            }

            throw new Exception("Bitte wählen Sie einen Account aus!");
        }
        catch(Exception e)
        {
            JOptionPane.showMessageDialog(EgroupwareTrayApp.getApplication().getMainFrame(),
                            "Bitte wählen Sie einen Account aus!",
                            "Info", JOptionPane.INFORMATION_MESSAGE);
        }
}//GEN-LAST:event_jBSelectActivMouseClicked

    private void jBeditMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jBeditMouseClicked
        this.jTFusername.setEnabled(true);
        this.jTFhost.setEnabled(true);
        this.jTFegwurl.setEnabled(true);
        this.jBsave.setEnabled(true);
        this.jBedit.setEnabled(false);
    }//GEN-LAST:event_jBeditMouseClicked


    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                jegwConfigDialog dialog = new jegwConfigDialog(new javax.swing.JFrame(), true, null);
                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
                    @Override
                    public void windowClosing(java.awt.event.WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jBSelectActiv;
    private javax.swing.JButton jBcancel;
    private javax.swing.JButton jBedit;
    private javax.swing.JButton jBsave;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLhost;
    private javax.swing.JLabel jLsamplehost;
    private javax.swing.JLabel jLsamplepath;
    private javax.swing.JLabel jLsampleuser;
    private javax.swing.JLabel jLuserstatus;
    private javax.swing.JPanel jPaccountsetting;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextField jTFegwurl;
    private javax.swing.JTextField jTFhost;
    private javax.swing.JTextField jTFusername;
    private javax.swing.JTree jTegwoverview;
    private java.awt.Label lhoststatus;
    // End of variables declaration//GEN-END:variables

}

class Renderer2 extends DefaultTreeCellRenderer{
    @Override
	public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus){
	  super.getTreeCellRendererComponent( tree, value, selected, expanded, leaf, row, hasFocus );

      if(row == 0)
      {
          this.setIcon(new ImageIcon("img/fusion-icon2.png"));
      }
      else if(leaf)
      {
          this.setIcon(new ImageIcon("img/group.png"));
      }
      else
      {
          this.setIcon(new ImageIcon("img/favicon.png"));
      }

	  return this;
	}
  }