<?php

/**
 * @package     Joomla.Site
 * @subpackage  com_content
 *
 * @copyright   (C) 2006 Open Source Matters, Inc. <https://www.joomla.org>
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\Component\Content\Site\Helper\RouteHelper;

/** @var \Joomla\Component\Content\Site\View\Archive\HtmlView $this */
$params = $this->params;
?>
<div id="archive-items" class="com-content-archive__items">
    <?php foreach ($this->items as $i => $item) : ?>
        <?php $info = $item->params->get('info_block_position', 0); ?>
        <div class="row<?php echo $i % 2; ?>">
            <div class="page-header">
                <h2>
                    <?php if ($params->get('link_titles')) : ?>
                        <a href="<?php echo Route::_(RouteHelper::getArticleRoute($item->slug, $item->catid, $item->language)); ?>" >
                            <?php echo $this->escape($item->title); ?>
                        </a>
                    <?php else : ?>
                        <?php echo $this->escape($item->title); ?>
                    <?php endif; ?>
                </h2>

                <?php // Content is generated by content plugin event "onContentAfterTitle" ?>
                <?php echo $item->event->afterDisplayTitle; ?>

            </div>
        <?php $useDefList = ($params->get('show_modify_date') || $params->get('show_publish_date') || $params->get('show_create_date')
            || $params->get('show_hits') || $params->get('show_category') || $params->get('show_parent_category')); ?>
        <?php if ($useDefList && ($info == 0 || $info == 2)) : ?>
            <?php echo LayoutHelper::render('joomla.content.info_block', ['item' => $item, 'params' => $params, 'position' => 'above']); ?>
        <?php endif; ?>

        <?php // Content is generated by content plugin event "onContentBeforeDisplay" ?>
        <?php echo $item->event->beforeDisplayContent; ?>
        <?php if ($params->get('show_intro')) : ?>
            <div class="intro" > <?php echo HTMLHelper::_('string.truncateComplex', $item->introtext, $params->get('introtext_limit')); ?> </div>
        <?php endif; ?>

        <?php if ($useDefList && ($info == 1 || $info == 2)) : ?>
            <?php echo LayoutHelper::render('joomla.content.info_block', ['item' => $item, 'params' => $params, 'position' => 'below']); ?>
        <?php endif; ?>
        <?php // Content is generated by content plugin event "onContentAfterDisplay" ?>
        <?php echo $item->event->afterDisplayContent; ?>
        </div>
    <?php endforeach; ?>
</div>
<div class="com-content-archive__navigation w-100">
    <?php if ($this->params->def('show_pagination_results', 1)) : ?>
        <p class="com-content-archive__counter counter float-end pt-3 pe-2">
            <?php echo $this->pagination->getPagesCounter(); ?>
        </p>
    <?php endif; ?>
    <div class="com-content-archive__pagination">
        <?php echo $this->pagination->getPagesLinks(); ?>
    </div>
</div>
