jQuery.wikiword.downgradeMap = {
  // (af) - Afrikaans
  "á": "a",       "â": "a",       "é": "e",       "è": "e",       "ê": "e",       "ë": "e",       "î": "i",       "ï": "i",
  "ô": "o",       "ö": "o",       "û": "u",       

  // (ak) - Akan
  "ɛ": "e",       "ɔ": "o",       

  // (am) - Amharic
  "ሀ": "ha",      "ሁ": "hu",      "ሂ": "hi",      "ሃ": "haa",     "ሄ": "hee",     "ህ": "he",      "ሆ": "ho",      "ለ": "la",
  "ሉ": "lu",      "ሊ": "li",      "ላ": "laa",     "ሌ": "lee",     "ል": "le",      "ሎ": "lo",      "ሏ": "lwa",     "ሐ": "hha",
  "ሑ": "hhu",     "ሒ": "hhi",     "ሓ": "hhaa",    "ሔ": "hhee",    "ሕ": "hhe",     "ሖ": "hho",     "ሗ": "hhwa",    "መ": "ma",
  "ሙ": "mu",      "ሚ": "mi",      "ማ": "maa",     "ሜ": "mee",     "ም": "me",      "ሞ": "mo",      "ሟ": "mwa",     "ሠ": "sza",
  "ሡ": "szu",     "ሢ": "szi",     "ሣ": "szaa",    "ሤ": "szee",    "ሥ": "sze",     "ሦ": "szo",     "ሧ": "szwa",    "ረ": "ra",
  "ሩ": "ru",      "ሪ": "ri",      "ራ": "raa",     "ሬ": "ree",     "ር": "re",      "ሮ": "ro",      "ሯ": "rwa",     "ሰ": "sa",
  "ሱ": "su",      "ሲ": "si",      "ሳ": "saa",     "ሴ": "see",     "ስ": "se",      "ሶ": "so",      "ሷ": "swa",     "ሸ": "sha",
  "ሹ": "shu",     "ሺ": "shi",     "ሻ": "shaa",    "ሼ": "shee",    "ሽ": "she",     "ሾ": "sho",     "ሿ": "shwa",    "ቀ": "qa",
  "ቁ": "qu",      "ቂ": "qi",      "ቃ": "qaa",     "ቄ": "qee",     "ቅ": "qe",      "ቆ": "qo",      "ቈ": "qwa",     "ቊ": "qwi",
  "ቋ": "qwaa",    "ቌ": "qwee",    "ቍ": "qwe",     "በ": "ba",      "ቡ": "bu",      "ቢ": "bi",      "ባ": "baa",     "ቤ": "bee",
  "ብ": "be",      "ቦ": "bo",      "ቧ": "bwa",     "ቨ": "va",      "ቩ": "vu",      "ቪ": "vi",      "ቫ": "vaa",     "ቬ": "vee",
  "ቭ": "ve",      "ቮ": "vo",      "ቯ": "vwa",     "ተ": "ta",      "ቱ": "tu",      "ቲ": "ti",      "ታ": "taa",     "ቴ": "tee",
  "ት": "te",      "ቶ": "to",      "ቷ": "twa",     "ቸ": "ca",      "ቹ": "cu",      "ቺ": "ci",      "ቻ": "caa",     "ቼ": "cee",
  "ች": "ce",      "ቾ": "co",      "ቿ": "cwa",     "ኀ": "xa",      "ኁ": "xu",      "ኂ": "xi",      "ኃ": "xaa",     "ኄ": "xee",
  "ኅ": "xe",      "ኆ": "xo",      "ኈ": "xwa",     "ኊ": "xwi",     "ኋ": "xwaa",    "ኌ": "xwee",    "ኍ": "xwe",     "ነ": "na",
  "ኑ": "nu",      "ኒ": "ni",      "ና": "naa",     "ኔ": "nee",     "ን": "ne",      "ኖ": "no",      "ኗ": "nwa",     "ኘ": "nya",
  "ኙ": "nyu",     "ኚ": "nyi",     "ኛ": "nyaa",    "ኜ": "nyee",    "ኝ": "nye",     "ኞ": "nyo",     "ኟ": "nywa",    "አ": "'a",
  "ኡ": "'u",      "ኢ": "[?]",     "ኣ": "'aa",     "ኤ": "'ee",     "እ": "'e",      "ኦ": "'o",      "ኧ": "'wa",     "ከ": "ka",
  "ኩ": "ku",      "ኪ": "ki",      "ካ": "kaa",     "ኬ": "kee",     "ክ": "ke",      "ኮ": "ko",      "ኰ": "kwa",     "ኲ": "kwi",
  "ኳ": "kwaa",    "ኴ": "kwee",    "ኵ": "kwe",     "ኸ": "kxa",     "ኹ": "kxu",     "ኺ": "kxi",     "ኻ": "kxaa",    "ኼ": "kxee",
  "ኽ": "kxe",     "ኾ": "kxo",     "ወ": "wa",      "ዉ": "wu",      "ዊ": "wi",      "ዋ": "waa",     "ዌ": "wee",     "ው": "we",
  "ዎ": "wo",      "ዐ": "`a",      "ዑ": "`u",      "ዒ": "`i",      "ዓ": "`aa",     "ዔ": "`ee",     "ዕ": "`e",      "ዖ": "`o",
  "ዘ": "za",      "ዙ": "zu",      "ዚ": "zi",      "ዛ": "zaa",     "ዜ": "zee",     "ዝ": "ze",      "ዞ": "zo",      "ዟ": "zwa",
  "ዠ": "zha",     "ዡ": "zhu",     "ዢ": "zhi",     "ዣ": "zhaa",    "ዤ": "zhee",    "ዥ": "zhe",     "ዦ": "zho",     "ዧ": "zhwa",
  "የ": "ya",      "ዩ": "yu",      "ዪ": "yi",      "ያ": "yaa",     "ዬ": "yee",     "ይ": "ye",      "ዮ": "yo",      "ደ": "da",
  "ዱ": "du",      "ዲ": "di",      "ዳ": "daa",     "ዴ": "dee",     "ድ": "de",      "ዶ": "do",      "ዷ": "dwa",     "ጀ": "ja",
  "ጁ": "ju",      "ጂ": "ji",      "ጃ": "jaa",     "ጄ": "jee",     "ጅ": "je",      "ጆ": "jo",      "ጇ": "jwa",     "ገ": "ga",
  "ጉ": "gu",      "ጊ": "gi",      "ጋ": "gaa",     "ጌ": "gee",     "ግ": "ge",      "ጎ": "go",      "ጐ": "gwa",     "ጒ": "gwi",
  "ጓ": "gwaa",    "ጔ": "gwee",    "ጕ": "gwe",     "ጠ": "tha",     "ጡ": "thu",     "ጢ": "thi",     "ጣ": "thaa",    "ጤ": "thee",
  "ጥ": "the",     "ጦ": "tho",     "ጧ": "thwa",    "ጨ": "cha",     "ጩ": "chu",     "ጪ": "chi",     "ጫ": "chaa",    "ጬ": "chee",
  "ጭ": "che",     "ጮ": "cho",     "ጯ": "chwa",    "ጰ": "pha",     "ጱ": "phu",     "ጲ": "phi",     "ጳ": "phaa",    "ጴ": "phee",
  "ጵ": "phe",     "ጶ": "pho",     "ጷ": "phwa",    "ጸ": "tsa",     "ጹ": "tsu",     "ጺ": "tsi",     "ጻ": "tsaa",    "ጼ": "tsee",
  "ጽ": "tse",     "ጾ": "tso",     "ጿ": "tswa",    "ፀ": "tza",     "ፁ": "tzu",     "ፂ": "tzi",     "ፃ": "tzaa",    "ፄ": "tzee",
  "ፅ": "tze",     "ፆ": "tzo",     "ፈ": "fa",      "ፉ": "fu",      "ፊ": "fi",      "ፋ": "faa",     "ፌ": "fee",     "ፍ": "fe",
  "ፎ": "fo",      "ፏ": "fwa",     "ፐ": "pa",      "ፑ": "pu",      "ፒ": "pi",      "ፓ": "paa",     "ፔ": "pee",     "ፕ": "pe",
  "ፖ": "po",      "ፗ": "pwa",     

  // (ar) - Arabic
  "ء": "",  "أ": "'", "ؤ": "w'", "إ": "", "ئ": "y'", "ا": "",  "آ": "a", "ب": "b",
  "ة": "@", "ت": "t", "ث": "th", "ج": "j", "ح": "H", "خ": "kh",        "د": "d", "ذ": "dh",
  "ر": "r", "ز": "z", "س": "s", "ش": "sh", "ص": "S", "ض": "D", "ط": "T", "ظ": "Z",
  "ع": "`", "غ": "G", "ف": "f", "ق": "q", "ك": "k", "ل": "l", "م": "m", "ن": "n",
  "ه": "h", "و": "w", "ى": "~", "ي": "y", 

  // (as) - Assamese
  "অ": "a",       "আ": "aa",      "ই": "i",       "ঈ": "ii",      "উ": "u",       "ঊ": "uu",      "ঋ": "R",       "এ": "e",
  "ঐ": "ai",      "ও": "o",       "ঔ": "au",      "ং": "N",        "ঃ": "H",        "ক": "k",       "খ": "kh",      "গ": "g",
  "ঘ": "gh",      "ঙ": "ng",      "চ": "c",       "ছ": "ch",      "জ": "j",       "ঝ": "jh",      "ঞ": "ny",      "ট": "tt",
  "ঠ": "tth",     "ড": "dd",      "ড়": "rr",      "ঢ": "ddh",     "ঢ়": "rh",      "ণ": "nn",      "ত": "t",       "থ": "th",
  "দ": "d",       "ধ": "dh",      "ন": "n",       "প": "p",       "ফ": "ph",      "ব": "b",       "ভ": "bh",      "ম": "m",
  "য": "y",       "ৰ": "r'",      "ল": "l",       "ৱ": "r`",      "শ": "sh",      "ষ": "ss",      "স": "s",       "হ": "h",
  "া": "aa",       "ি": "i",        "ী": "ii",       "ে": "e",        "ৈ": "ai",       "ো": "o",        "ৌ": "au",       

  // (az) - Azerbaijani
  "ç": "c",       "ə": "@",       "ğ": "g",       "ı": "i",       "İ": "I",       "ö": "o",       "ş": "s",       "ü": "u",


  // (be) - Belarusian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "е": "e",       "ё": "io",      "ж": "zh",
  "з": "z",       "і": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",       "о": "o",
  "п": "p",       "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ў": "u",       "ф": "f",       "х": "kh",
  "ц": "ts",      "ч": "ch",      "ш": "sh",      "ы": "y",       "ь": "'",       "э": "e",       "ю": "iu",      "я": "ia",


  // (bg) - Bulgarian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "е": "e",       "ж": "zh",      "з": "z",
  "и": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",       "о": "o",       "п": "p",
  "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ф": "f",       "х": "kh",      "ц": "ts",      "ч": "ch",
  "ш": "sh",      "щ": "shch",    "ъ": "",        "ь": "'",       "ю": "iu",      "я": "ia",      

  // (bm) - Bambara
  "ɛ": "e",       "ɲ": "n",       "ŋ": "NG",      "ɔ": "o",       

  // (bn) - Bengali
  "৺": "",        "অ": "a",       "আ": "aa",      "ই": "i",       "ঈ": "ii",      "উ": "u",       "ঊ": "uu",      "ঋ": "R",
  "ৠ": "RR",      "ঌ": "RR",      "ৡ": "LL",      "এ": "e",       "ঐ": "ai",      "ও": "o",       "ঔ": "au",      "ং": "N",
  "ঃ": "H",        "ক": "k",       "খ": "kh",      "গ": "g",       "ঘ": "gh",      "ঙ": "ng",      "চ": "c",       "ছ": "ch",
  "জ": "j",       "ঝ": "jh",      "ঞ": "ny",      "ট": "tt",      "ঠ": "tth",     "ড": "dd",      "ঢ": "ddh",     "ণ": "nn",
  "ত": "t",       "ৎ": "[?]",     "থ": "th",      "দ": "d",       "ধ": "dh",      "ন": "n",       "প": "p",       "ফ": "ph",
  "ব": "b",       "ভ": "bh",      "ম": "m",       "য": "y",       "র": "r",       "ল": "l",       "শ": "sh",      "ষ": "ss",
  "স": "s",       "হ": "h",       "ঽ": "[?]",     "া": "aa",       "ি": "i",        "ী": "ii",       "ে": "e",        "ৈ": "ai",
  "ো": "o",        "ৌ": "au",       "ৗ": "+",        

  // (bo) - Tibetan
  "ཿ": "H",        "ཀ": "k",       "ཁ": "kh",      "ག": "g",       "ང": "ng",      "ཅ": "c",       "ཆ": "ch",      "ཇ": "j",
  "ཉ": "ny",      "ཊ": "tt",      "ཋ": "tth",     "ཌ": "dd",      "ཎ": "nn",      "ཏ": "t",       "ཐ": "th",      "ད": "d",
  "ན": "n",       "པ": "p",       "ཕ": "ph",      "བ": "b",       "མ": "m",       "ཙ": "ts",      "ཚ": "tsh",     "ཛ": "dz",
  "ཝ": "w",       "ཞ": "zh",      "ཟ": "z",       "འ": "'",       "ཡ": "y",       "ར": "r",       "ཪ": "r",       "ལ": "l",
  "ཤ": "sh",      "ཥ": "ssh",     "ས": "s",       "ཧ": "h",       "ཨ": "a",       

  // (br) - Breton
  "ê": "e",       "ñ": "n",       "ù": "u",       

  // (bs) - Bosnian
  "ć": "c",       "č": "c",       "đ": "d",       "š": "s",       "ž": "z",       

  // (ca) - Catalan
  "·": "*", "à": "a",       "ç": "c",       "é": "e",       "è": "e",       "í": "i",       "ï": "i",       "ó": "o",
  "ò": "o",       "ú": "u",       "ü": "u",       

  // (cs) - Czech
  "á": "a",       "č": "c",       "ď": "d",       "é": "e",       "ě": "e",       "í": "i",       "ň": "n",       "ó": "o",
  "ř": "r",       "š": "s",       "ť": "t",       "ú": "u",       "ů": "u",       "ý": "y",       "ž": "z",       

  // (cy) - Welsh
  "á": "a",       "à": "a",       "â": "a",       "ä": "a",       "é": "e",       "è": "e",       "ê": "e",       "ë": "e",
  "í": "i",       "ì": "i",       "î": "i",       "ï": "i",       "ó": "o",       "ò": "o",       "ô": "o",       "ö": "o",
  "ú": "u",       "ù": "u",       "û": "u",       "ü": "u",       "ẃ": "w",       "ẁ": "w",       "ŵ": "w",       "ẅ": "w",
  "ý": "y",       "ỳ": "y",       "ŷ": "y",       "ÿ": "y",       

  // (da) - Danish
  "æ": "ae",      "ø": "o",       "å": "a",       

  // (de) - German
  "ä": "a",       "ö": "o",       "ß": "ss",      "ü": "u",       

  // (dz) - Dzongkha
  "ཀ": "k",       "ཁ": "kh",      "ག": "g",       "ང": "ng",      "ཅ": "c",       "ཆ": "ch",      "ཇ": "j",       "ཉ": "ny",
  "ཏ": "t",       "ཐ": "th",      "ད": "d",       "ན": "n",       "པ": "p",       "ཕ": "ph",      "བ": "b",       "མ": "m",
  "ཙ": "ts",      "ཚ": "tsh",     "ཛ": "dz",      "ཝ": "w",       "ཞ": "zh",      "ཟ": "z",       "འ": "'",       "ཡ": "y",
  "ར": "r",       "ལ": "l",       "ཤ": "sh",      "ས": "s",       "ཧ": "h",       "ཨ": "a",       

  // (ee) - Ewe
  "á": "a",       "à": "a",       "ã": "a",       "ɖ": "d",       "é": "e",       "è": "e",       "ẽ": "e",       "ɛ": "e",
  "ƒ": "f",       "ɣ": "g",       "í": "i",       "ì": "i",       "ĩ": "i",       "ŋ": "NG",      "ó": "o",       "ò": "o",
  "õ": "o",       "ɔ": "o",       "ú": "u",       "ù": "u",       "ũ": "u",       "ʋ": "v",       

  // (el) - Modern Greek (1453-)
  "α": "a",       "ά": "a",       "β": "b",       "γ": "g",       "δ": "d",       "ε": "e",       "έ": "e",       "ζ": "z",
  "η": "e",       "ή": "e",       "θ": "th",      "ι": "i",       "ί": "i",       "ϊ": "i",       "ΐ": "I",       "κ": "k",
  "λ": "l",       "μ": "m",       "ν": "n",       "ξ": "x",       "ο": "o",       "ό": "o",       "π": "p",       "ρ": "r",
  "σ": "s",       "ς": "s",       "τ": "t",       "υ": "u",       "ύ": "u",       "ϋ": "u",       "ΰ": "u",       "φ": "ph",
  "χ": "kh",      "ψ": "ps",      "ω": "o",       "ώ": "o",       

  // (eo) - Esperanto
  "ĉ": "c",       "ĝ": "g",       "ĥ": "h",       "ĵ": "j",       "ŝ": "s",       "ŭ": "u",       

  // (es) - Spanish
  "á": "a",       "é": "e",       "í": "i",       "ñ": "n",       "ó": "o",       "ú": "u",       "ü": "u",       

  // (et) - Estonian
  "š": "s",       "ž": "z",       "õ": "o",       "ä": "a",       "ö": "o",       "ü": "u",       

  // (eu) - Basque
  "ç": "c",       "ñ": "n",       

  // (fa) - Persian
  "آ": "a", "ا": "",  "ء": "",  "أ": "'", "ؤ": "w'", "ئ": "y'", "ب": "b", "پ": "p",
  "ت": "t", "ث": "th", "ج": "j", "چ": "ch", "ح": "H", "خ": "kh", "د": "d", "ذ": "dh",
  "ر": "r", "ز": "z", "ژ": "j", "س": "s", "ش": "sh",  "ص": "S", "ض": "D", "ط": "T",
  "ظ": "Z", "ع": "`", "غ": "G", "ف": "f", "ق": "q", "ک": "kh",  "گ": "g", "ل": "l",
  "م": "m", "ن": "n", "و": "w", "ه": "h", "ة": "@", "ی": "y", 

  // (ff) - Fulah
  "ɓ": "b",       "ɗ": "d",       "ñ": "n",       "ŋ": "NG",      "ƴ": "y",       

  // (fi) - Finnish
  "š": "s",       "ž": "z",       "å": "a",       "ä": "a",       "ö": "o",       

  // (fo) - Faroese
  "á": "a",       "ð": "d",       "í": "i",       "ó": "o",       "ú": "u",       "ý": "y",       "æ": "ae",      "ø": "o",


  // (fr) - French
  "à": "a",       "â": "a",       "æ": "ae",      "ç": "c",       "é": "e",       "è": "e",       "ê": "e",       "ë": "e",
  "î": "i",       "ï": "i",       "ô": "o",       "œ": "oe",      "ù": "u",       "û": "u",       "ü": "u",       "ÿ": "y",


  // (fy) - Western Frisian
  "á": "a",       "ä": "a",       "é": "e",       "ë": "e",       "ì": "i",       "ï": "i",       "ò": "o",       "ö": "o",
  "ú": "u",       "ü": "u",       "ỳ": "y",       

  // (ga) - Irish
  "á": "a",       "é": "e",       "í": "i",       "ó": "o",       "ú": "u",       

  // (gd) - Scottish Gaelic
  "à": "a",       "è": "e",       "ì": "i",       "ò": "o",       "ù": "u",       

  // (gl) - Galician
  "á": "a",       "é": "e",       "í": "i",       "ñ": "n",       "ó": "o",       "ú": "u",       "ü": "u",       

  // (gu) - Gujarati
  "ૐ": "AUM",     "ઃ": "H",        "અ": "a",       "આ": "aa",      "ઇ": "i",       "ઈ": "ii",      "ઉ": "u",       "ઊ": "uu",
  "ઋ": "R",       "ૠ": "RR",      "ઍ": "eN",      "એ": "e",       "ઐ": "ai",      "ઑ": "oN",      "ઓ": "o",       "ઔ": "au",
  "ક": "k",       "ખ": "kh",      "ગ": "g",       "ઘ": "gh",      "ઙ": "ng",      "ચ": "c",       "છ": "ch",      "જ": "j",
  "ઝ": "jh",      "ઞ": "ny",      "ટ": "tt",      "ઠ": "tth",     "ડ": "dd",      "ઢ": "ddh",     "ણ": "nn",      "ત": "t",
  "થ": "th",      "દ": "d",       "ધ": "dh",      "ન": "n",       "પ": "p",       "ફ": "ph",      "બ": "b",       "ભ": "bh",
  "મ": "m",       "ય": "ya",      "ર": "r",       "લ": "l",       "વ": "v",       "શ": "sh",      "ષ": "ss",      "સ": "s",
  "હ": "h",       "ળ": "ll",      "ઽ": "'",       "ા": "aa",       "િ": "i",        "ી": "ii",       "ૉ": "oN",       "ો": "o",
  "ૌ": "au",       

  // (gv) - Manx
  "ç": "c",       

  // (ha) - Hausa
  "ɓ": "b",       "ɗ": "d",       "ƙ": "k",       "ʼ": "'",       

  // (he) - Hebrew
  "א": "",  "ב": "b", "ג": "g", "ד": "d", "ה": "h", "ו": "v", "ז": "z", "ח": "kh",
  "ט": "t", "י": "y", "כ": "k", "ך": "k", "ל": "l", "מ": "m", "ם": "m", "נ": "n",
  "ן": "n", "ס": "s", "ע": "`", "פ": "p", "ף": "p", "צ": "ts","ץ": "ts", "ק": "q",
  "ר": "r", "ש": "sh", "ת": "t", 

  // (hi) - Hindi
  "ॐ": "AUM",     "ः": "H",        "अ": "a",       "आ": "aa",      "इ": "i",       "ई": "ii",      "उ": "u",       "ऊ": "uu",
  "ऋ": "R",       "ऌ": "L",       "ऍ": "eN",      "ए": "e",       "ऐ": "ai",      "ऑ": "oN",      "ओ": "o",       "औ": "au",
  "क": "k",       "ख": "kh",      "ग": "g",       "घ": "gh",      "ङ": "ng",      "च": "c",       "छ": "ch",      "ज": "j",
  "झ": "jh",      "ञ": "ny",      "ट": "tt",      "ठ": "tth",     "ड": "dd",      "ढ": "ddh",     "ण": "nn",      "त": "t",
  "थ": "th",      "द": "d",       "ध": "dh",      "न": "n",       "प": "p",       "फ": "ph",      "ब": "b",       "भ": "bh",
  "म": "m",       "य": "y",       "र": "r",       "ल": "l",       "ळ": "l",       "व": "v",       "श": "sh",      "ष": "ss",
  "स": "s",       "ह": "h",       "ऽ": "'",       "ा": "aa",       "ि": "i",        "ी": "ii",       "ॉ": "oN",       "ो": "o",
  "ौ": "au",       

  // (hr) - Croatian
  "č": "c",       "ć": "c",       "đ": "d",       "š": "s",       "ž": "z",       

  // (hu) - Hungarian
  "á": "a",       "é": "e",       "í": "i",       "ó": "o",       "ö": "o",       "ő": "o",       "ú": "u",       "ü": "u",
  "ű": "u",       

  // (hy) - Armenian
  "ա": "a",       "բ": "b",       "գ": "g",       "դ": "d",       "ե": "e",       "զ": "z",       "է": "e",       "ը": "e",
  "թ": "t`",      "ժ": "zh",      "ի": "i",       "լ": "l",       "խ": "kh",      "ծ": "ts",      "կ": "k",       "հ": "h",
  "ձ": "dz",      "ղ": "gh",      "ճ": "ch",      "մ": "m",       "յ": "y",       "ն": "n",       "շ": "sh",      "ո": "o",
  "չ": "ch`",     "պ": "p",       "ջ": "j",       "ռ": "rh",      "ս": "s",       "վ": "v",       "տ": "t",       "ր": "r",
  "ց": "ts`",     "ւ": "w",       "փ": "p`",      "ք": "k`",      "և": "ew",      "օ": "o",       "ֆ": "f",       

  // (ig) - Igbo
  "ẹ": "e",       "ị": "i",       "ṅ": "n",       "ọ": "o",       "ụ": "u",       

  // (ii) - Sichuan Yi
  "ꀀ-ꒌ": "it-yyr",      

  // (is) - Icelandic
  "á": "a",       "ð": "d",       "é": "e",       "í": "i",       "ó": "o",       "ú": "u",       "ý": "y",       "þ": "th",
  "æ": "ae",      "ö": "o",       

  // (it) - Italian
  "à": "a",       "é": "e",       "è": "e",       "ì": "i",       "ó": "o",       "ò": "o",       "ù": "u",       

  // (ja) - Japanese
  "々": "\"",     "ゝ": "\"",     "ゞ": "\"",     "ー-ヾ": "-\"", "ぁ": "a",      "あ": "a",      "ァア": "aa",   "ぃ": "i",
  "い": "i",      "ィイ": "ii",   "ぅ": "u",      "う": "u",      "ゥウ": "uu",   "ヴ": "vu",     "ぇ": "e",      "え": "e",
  "ェエ": "ee",   "ぉ": "o",      "お": "o",      "ォオ": "oo",   "か": "ka",     "ヵ": "ka",     "カ": "ka",     "がガ": "gaga",
  "きキ": "kiki", "ぎギ": "gigi", "くク": "kuku", "ぐグ": "gugu", "け": "ke",     "ヶ": "ke",     "ケ": "ke",     "げゲ": "gege",
  "こコ": "koko", "ごゴ": "gogo", "さサ": "sasa", "ざザ": "zaza", "しシ": "sisi", "じジ": "zizi", "すス": "susu", "ずズ": "zuzu",
  "せセ": "sese", "ぜゼ": "zeze", "そソ": "soso", "ぞゾ": "zozo", "たタ": "tata", "だダ": "dada", "ちチ": "titi", "ぢヂ": "didi",
  "っ": "tu",     "つ": "tu",     "ッツ": "tutu", "づヅ": "dudu", "てテ": "tete", "でデ": "dede", "とト": "toto", "どド": "dodo",
  "なナ": "nana", "にニ": "nini", "ぬヌ": "nunu", "ねネ": "nene", "のノ": "nono", "はハ": "haha", "ばバ": "baba", "ぱパ": "papa",
  "ひヒ": "hihi", "びビ": "bibi", "ぴピ": "pipi", "ふフ": "huhu", "ぶブ": "bubu", "ぷプ": "pupu", "へヘ": "hehe", "べベ": "bebe",
  "ぺペ": "pepe", "ほホ": "hoho", "ぼボ": "bobo", "ぽポ": "popo", "まマ": "mama", "みミ": "mimi", "むム": "mumu", "めメ": "meme",
  "もモ": "momo", "ゃ": "ya",     "や": "ya",     "ャヤ": "yaya", "ゅ": "yu",     "ゆ": "yu",     "ュユ": "yuyu", "ょ": "yo",
  "よ": "yo",     "ョヨ": "yoyo", "らラ": "rara", "りリ": "riri", "るル": "ruru", "れレ": "rere", "ろロ": "roro", "ゎ": "wa",
  "わ": "wa",     "ヮワ": "wawa", "ゐヰ": "wiwi", "ゑヱ": "wewe", "をヲ": "wowo", "んン": "nn",   "一": "Yi ",    "丁": "Ding ",
  "七": "Qi ",    "万-下": "Mo -Xia ",    "不": "Bu ",    "与": "Yu ",    "丑": "Chou ",  "且": "Qie ",   "世": "Shi ",   "丘": "Qiu ",
  "丙": "Bing ",  "両": "Liang ", "並": "Bing ",  "中": "Zhong ", "丸": "Wan ",   "丹": "Dan ",   "主": "Zhu ",   "久": "Jiu ",
  "乏": "Fa ",    "乗": "Cheng ", "乙": "Yi ",    "九": "Jiu ",   "乱": "Luan ",  "乳": "Ru ",    "乾": "Gan ",   "亀": "Gui ",
  "了": "Liao ",  "予": "Yu ",    "争": "Zheng ", "事": "Shi ",   "二": "Er ",    "互": "Hu ",    "五": "Wu ",    "井": "Jing ",
  "亜": "Ya ",    "亡": "Wang ",  "交": "Jiao ",  "亥": "Hai ",   "亨": "Heng ",  "享-亭": "Xiang -Ting ",        "人": "Ren ",   "仁": "Ren ",
  "今": "Jin ",   "介": "Jie ",   "仏": "Fo ",    "仕": "Shi ",   "他": "Ta ",    "付": "Fu ",    "仙": "Xian ",  "代-以": "Dai -Yi ",
  "仮": "Jia ",   "仰": "Yang ",  "仲": "Zhong ", "件": "Jian ",  "任": "Ren ",   "企": "Qi ",    "伊": "Yi ",    "伏-休": "Fu -Xiu ",
  "会": "Hui ",   "伝": "Chuan ", "伯": "Bo ",    "伴": "Ban ",   "伸": "Shen ",  "伺": "Si ",    "似": "Si ",    "但": "Dan ",
  "位-佐": "Wei -Zuo ",   "体": "Ti ",    "何": "He ",    "余": "Yu ",    "作": "Zuo ",   "佳": "Jia ",   "併": "Bing ",  "使": "Shi ",
  "例": "Li ",    "侍": "Shi ",   "供": "Gong ",  "依": "Yi ",    "価": "Jia ",   "侮": "Wu ",    "侯": "Hou ",   "侵": "Qin ",
  "便": "Bian ",  "係": "Xi ",    "促": "Cu ",    "俊": "Jun ",   "俗": "Su ",    "保": "Bao ",   "信": "Xin ",   "修": "Xiu ",
  "俳": "Pai ",   "俵": "Biao ",  "俸": "Feng ",  "俺": "An ",    "倉": "Cang ",  "個": "Ge ",    "倍": "Bei ",   "倒": "Dao ",
  "候": "Hou ",   "借": "Jie ",   "倣": "Fang ",  "値": "Zhi ",   "倫": "Lun ",   "倹": "Jian ",  "偉": "Wei ",   "偏": "Pian ",
  "停": "Ting ",  "健": "Jian ",  "側-偶": "Ce -Ou ",     "偽": "Wei ",   "傍": "Bang ",  "傑": "Jie ",   "傘": "San ",   "備": "Bei ",
  "催": "Cui ",   "債": "Zhai ",  "傷": "Shang ", "傾": "Qing ",  "働": "Dong ",  "像": "Xiang ", "僕": "Pu ",    "僚": "Liao ",
  "僧": "Seng ",  "儀": "Yi ",    "億": "Yi ",    "儒": "Ru ",    "償": "Chang ", "優": "You ",   "元-兆": "Yuan -Zhao ", "先": "Xian ",
  "光": "Guang ", "克": "Ke ",    "免": "Mian ",  "兎": "Tu ",    "児": "Er ",    "党": "Dang ",  "入": "Ru ",    "全": "Quan ",
  "八-六": "Ba -Liu ",    "共": "Gong ",  "兵": "Bing ",  "具": "Ju ",    "典": "Dian ",  "兼": "Jian ",  "内": "Nei ",   "円": "Yuan ",
  "冊": "Ce ",    "再": "Zai ",   "冒": "Mou ",   "冗": "Rong ",  "写": "Xie ",   "冠": "Guan ",  "冬": "Dong ",  "冷": "Leng ",
  "准": "Zhun ",  "凍": "Dong ",  "凝": "Ning ",  "凡": "Fan ",   "処": "Chu ",   "凶": "Xiong ", "凸-出": "Tu -Chu ",    "刀": "Dao ",
  "刃": "Ren ",   "分-刈": "Fen -Yi ",    "刊": "Kan ",   "刑": "Xing ",  "列": "Lie ",   "初": "Chu ",   "判": "Pan ",   "別": "Bie ",
  "利": "Li ",    "到": "Dao ",   "制-券": "Zhi -Quan ",  "刺": "Ci ",    "刻": "Ke ",    "則": "Ze ",    "削": "Xue ",   "前": "Qian ",
  "剖": "Pou ",   "剛": "Gang ",  "剣": "Jian ",  "剤": "Ji ",    "副": "Fu ",    "剰": "Sheng ", "割": "Ge ",    "創": "Chuang ",
  "劇": "Ju ",    "力": "Li ",    "功": "Gong ",  "加": "Jia ",   "劣": "Lie ",   "助": "Zhu ",   "努": "Nu ",    "励": "Li ",
  "労": "Lao ",   "効": "Xiao ",  "劾": "He ",    "勅": "Chi ",   "勇": "Yong ",  "勉": "Mian ",  "動": "Dong ",  "勘": "Kan ",
  "務": "Wu ",    "勝": "Sheng ", "募": "Mu ",    "勢": "Shi ",   "勤": "Qin ",   "勧": "Quan ",  "勲": "Xun ",   "勺": "Shao ",
  "匁": "Mwun ",  "包": "Bao ",   "化": "Hua ",   "北": "Bei ",   "匠": "Jiang ", "匹-医": "Pi -Yi ",     "匿": "Ni ",    "十": "Shi ",
  "千": "Qian ",  "升": "Sheng ", "午": "Wu ",    "半": "Ban ",   "卑-協": "Bei -Xie ",   "南": "Nan ",   "単": "Dan ",   "博": "Bo ",
  "占": "Zhan ",  "卯-危": "Mao -Wei ",   "即-卵": "Ji -Luan ",   "卸": "Xie ",   "厄": "E ",     "厘": "Li ",    "厚": "Hou ",   "原": "Yuan ",
  "厳": "Yan ",   "去": "Qu ",    "参": "Can ",   "又": "You ",   "及-収": "Ji -Shou ",   "叔": "Shu ",   "取": "Qu ",    "受": "Shou ",
  "叙": "Xu ",    "口-句": "Kou -Ju ",    "叫": "Jiao ",  "召": "Zhao ",  "可": "Ke ",    "台": "Tai ",   "史": "Shi ",   "右": "You ",
  "号": "Hao ",   "司": "Si ",    "各": "Ge ",    "合": "He ",    "吉": "Ji ",    "同-向": "Tong -Xiang ",        "君": "Jun ",   "吟": "Yin ",
  "否": "Fou ",   "含": "Han ",   "吸": "Xi ",    "吹": "Chui ",  "呈-告": "Cheng -Gao ", "周": "Zhou ",  "味": "Wei ",   "呼": "Hu ",
  "命": "Ming ",  "和": "He ",    "咲": "Xiao ",  "哀": "Ai ",    "品": "Pin ",   "員": "Yuan ",  "哲": "Zhe ",   "唆": "Suo ",
  "唇": "Chun ",  "唐": "Tang ",  "唯": "Wei ",   "唱": "Chang ", "商": "Shang ", "問": "Wen ",   "啓": "Qi ",    "善": "Shan ",
  "喚": "Huan ",  "喜": "Xi ",    "喝": "He ",    "喪": "Sang ",  "喫": "Chi ",   "営": "Ying ",  "嗣": "Si ",    "嘆": "Tan ",
  "嘉": "Jia ",   "嘱": "Zhu ",   "器": "Qi ",    "噴": "Pen ",   "嚇": "Xia ",   "囚": "Qiu ",   "四": "Si ",    "回": "Hui ",
  "因": "Yin ",   "団": "Tuan ",  "困": "Kun ",   "囲": "Wei ",   "図": "Tu ",    "固": "Gu ",    "国": "Guo ",   "圏": "Quan ",
  "園": "Yuan ",  "土": "Tu ",    "圧": "Ya ",    "在": "Zai ",   "地": "Di ",    "坂": "Ban ",   "均": "Jun ",   "坊": "Fang ",
  "坑": "Keng ",  "坪": "Ping ",  "垂": "Chui ",  "型": "Xing ",  "垣": "Yuan ",  "埋": "Mai ",   "城": "Cheng ", "域": "Yu ",
  "執": "Zhi ",   "培": "Pei ",   "基": "Ji ",    "埼": "Qi ",    "堀": "Ku ",    "堂": "Tang ",  "堅": "Jian ",  "堕": "Duo ",
  "堤": "Di ",    "堪": "Kan ",   "報": "Bao ",   "場": "Chang ", "塀": "Pyeng ", "塁": "Toride ",        "塊": "Kuai ",  "塑": "Su ",
  "塔": "Ta ",    "塗": "Tu ",    "塚": "Zhong ", "塩": "Yan ",   "塾": "Shu ",   "境": "Jing ",  "墓": "Mu ",    "増": "Zeng ",
  "墜": "Zhui ",  "墨": "Mo ",    "墳": "Fen ",   "墾": "Ken ",   "壁": "Bi ",    "壇": "Tan ",   "壊": "Huai ",  "壌": "Rang ",
  "士": "Shi ",   "壬": "Ren ",   "壮": "Zhuang ",        "声-売": "Sheng -Mai ", "変": "Bian ",  "夏": "Xia ",   "夕": "Xi ",    "外": "Wai ",
  "多": "Duo ",   "夜": "Ye ",    "夢": "Meng ",  "大": "Da ",    "天-夫": "Tian -Fu ",   "央": "Yang ",  "失": "Shi ",   "奇-奉": "Qi -Feng ",
  "奏": "Zou ",   "契": "Qi ",    "奔": "Ben ",   "奥": "Ao ",    "奨": "Jiang ", "奪": "Duo ",   "奮": "Fen ",   "女": "Nu ",
  "奴": "Nu ",    "好": "Hao ",   "如-妄": "Ru -Wang ",   "妊": "Ren ",   "妙": "Miao ",  "妥": "Tuo ",   "妨": "Fang ",  "妹": "Mei ",
  "妻": "Qi ",    "姉": "Zi ",    "始": "Shi ",   "姓": "Xing ",  "委": "Wei ",   "姫": "Ji ",    "姻": "Yin ",   "姿": "Zi ",
  "威": "Wei ",   "娘": "Niang ", "娠": "Shen ",  "娯": "Yu ",    "婆": "Po ",    "婚": "Hun ",   "婦": "Fu ",    "婿": "Xu ",
  "媒": "Mei ",   "嫁": "Jia ",   "嫌": "Xian ",  "嫡": "Di ",    "嬢": "Niang ", "子": "Zi ",    "孔": "Kong ",  "字": "Zi ",
  "存": "Cun ",   "孝": "Xiao ",  "季": "Ji ",    "孤": "Gu ",    "学": "Xue ",   "孫": "Sun ",   "宅": "Zhai ",  "宇-安": "Yu -An ",
  "完": "Wan ",   "宗-定": "Zong -Ding ", "宜": "Yi ",    "宝": "Bao ",   "実": "Shi ",   "客-室": "Ke -Shi ",    "宮": "Gong ",  "宰": "Zai ",
  "害-家": "Hai -Jia ",   "容": "Rong ",  "宿": "Su ",    "寂": "Ji ",    "寄-密": "Ji -Mi ",     "富": "Fu ",    "寒": "Han ",   "寛": "Kuan ",
  "寝": "Qin ",   "察": "Cha ",   "寡": "Gua ",   "寧": "Zhu ",   "審": "Shen ",  "寮": "Liao ",  "寸": "Cun ",   "寺": "Si ",
  "対": "Dui ",   "寿": "Shou ",  "封": "Feng ",  "専": "Zhuan ", "射": "She ",   "将": "Jiang ", "尉-尋": "Wei -Xun ",   "導": "Dao ",
  "小": "Xiao ",  "少": "Shao ",  "尚": "Shang ", "就": "Jiu ",   "尺": "Chi ",   "尼-局": "Ni -Ju ",     "居": "Ju ",    "屈": "Qu ",
  "届": "Jie ",   "屋": "Wu ",    "展": "Zhan ",  "属": "Shu ",   "層": "Ceng ",  "履": "Lu ",    "屯": "Tun ",   "山": "Shan ",
  "岐": "Qi ",    "岡": "Gang ",  "岩": "Yan ",   "岬": "Jia ",   "岳": "Yue ",   "岸": "An ",    "峠": "Sang ",  "峡": "Xia ",
  "峰": "Feng ",  "島": "Dao ",   "崇": "Chong ", "崎": "Qi ",    "崩": "Beng ",  "川": "Chuan ", "州": "Zhou ",  "巡": "Xun ",
  "巣": "Chao ",  "工-巨": "Gong -Ju ",   "差": "Chai ",  "己": "Ji ",    "巳": "Si ",    "巻": "Juan ",  "市": "Shi ",   "布": "Bu ",
  "帆": "Fan ",   "希": "Xi ",    "帝": "Di ",    "帥": "Shuai ", "師": "Shi ",   "席": "Xi ",    "帯": "Dai ",   "帰": "Gui ",
  "帳": "Zhang ", "常": "Chang ", "帽": "Mao ",   "幅": "Fu ",    "幕": "Mu ",    "幣": "Bi ",    "干-年": "Gan -Nian ",  "幸": "Xing ",
  "幹": "Gan ",   "幻-幾": "Huan -Ji ",   "庁": "Ting ",  "広": "Guang ", "床": "Chuang ",        "序": "Xu ",    "底": "Di ",    "店": "Dian ",
  "庚": "Geng ",  "府": "Fu ",    "度": "Du ",    "座": "Zuo ",   "庫": "Ku ",    "庭": "Ting ",  "庶-庸": "Shu -Yong ",  "廃": "Fei ",
  "廉": "Lian ",  "廊": "Lang ",  "延": "Yan ",   "廷": "Ting ",  "建": "Jian ",  "弁": "Bian ",  "弊": "Bi ",    "式": "Shi ",
  "弐": "Er ",    "弓-引": "Gong -Yin ",  "弘": "Hong ",  "弟": "Di ",    "弦": "Xian ",  "弧": "Hu ",    "弱": "Ruo ",   "張": "Zhang ",
  "強": "Qiang ", "弾": "Dan ",   "当": "Dang ",  "形": "Xing ",  "彩": "Cai ",   "彫": "Diao ",  "彰": "Zhang ", "影": "Ying ",
  "役": "Yi ",    "彼": "Bi ",    "往": "Wang ",  "征": "Zheng ", "径": "Jing ",  "待": "Dai ",   "律": "Lu ",    "後": "Hou ",
  "徐": "Xu ",    "徒": "Tu ",    "従": "Cong ",  "得": "De ",    "御": "Yu ",    "復": "Fu ",    "循": "Xun ",   "微": "Wei ",
  "徳": "De ",    "徴": "Zheng ", "徹": "Che ",   "心": "Xin ",   "必": "Bi ",    "忌": "Ji ",    "忍": "Ren ",   "志-忙": "Zhi -Mang ",
  "応": "Ying ",  "忠": "Zhong ", "快": "Kuai ",  "念": "Nian ",  "怒": "Nu ",    "怖": "Bu ",    "思": "Si ",    "怠": "Dai ",
  "急": "Ji ",    "性": "Xing ",  "怪": "Guai ",  "恋": "Lian ",  "恐": "Kong ",  "恒": "Heng ",  "恥": "Chi ",   "恨": "Hen ",
  "恩": "En ",    "恭": "Gong ",  "息": "Xi ",    "恵": "Hui ",   "悔": "Hui ",   "悟": "Wu ",    "悠": "You ",   "患": "Huan ",
  "悦": "Yue ",   "悩": "Nao ",   "悪": "E ",     "悲": "Bei ",   "悼": "Dao ",   "情": "Qing ",  "惑": "Huo ",   "惜": "Xi ",
  "惨": "Can ",   "惰": "Duo ",   "想": "Xiang ", "愁": "Chou ",  "愉": "Yu ",    "意": "Yi ",    "愚": "Yu ",    "愛": "Ai ",
  "感": "Gan ",   "慈": "Ci ",    "態": "Tai ",   "慌": "Huang ", "慎": "Shen ",  "慕": "Mu ",    "慢": "Man ",   "慣": "Guan ",
  "慨": "Kai ",   "慮": "Lu ",    "慰": "Wei ",   "慶": "Qing ",  "憂": "You ",   "憎": "Zeng ",  "憤": "Fen ",   "憩": "Qi ",
  "憲": "Xian ",  "憶": "Yi ",    "憾": "Han ",   "懇": "Ken ",   "懐": "Huai ",  "懲": "Cheng ", "懸": "Xuan ",  "戊": "Wu ",
  "戌": "Xu ",    "成-戒": "Cheng -Jie ", "戦": "Zhan ",  "戯": "Xi ",    "戸": "Hu ",    "戻": "Li ",    "房": "Fang ",  "所": "Suo ",
  "扇": "Shan ",  "扉": "Fei ",   "手": "Shou ",  "才": "Cai ",   "打": "Da ",    "払": "Fu ",    "扱": "Xi ",    "扶": "Fu ",
  "批": "Pi ",    "承": "Cheng ", "技": "Ji ",    "抄": "Chao ",  "把": "Ba ",    "抑": "Yi ",    "投": "Tou ",   "抗": "Kang ",
  "折": "Zhe ",   "抜": "Ba ",    "択": "Ze ",    "披": "Pi ",    "抱": "Bao ",   "抵": "Di ",    "抹": "Mo ",    "押": "Ya ",
  "抽": "Chou ",  "担": "Dan ",   "拍": "Pai ",   "拐": "Guai ",  "拒": "Ju ",    "拓": "Tuo ",   "拘": "Ju ",    "拙": "Zhuo ",
  "招": "Zhao ",  "拝": "Bai ",   "拠": "Ju ",    "拡": "Kuo ",   "括": "Gua ",   "拷": "Kao ",   "拾": "Shi ",   "持": "Chi ",
  "指": "Zhi ",   "挑": "Tiao ",  "挙": "Ju ",    "挟": "Xie ",   "振": "Zhen ",  "挿": "Cha ",   "捕": "Bu ",    "捜": "Sou ",
  "捨": "She ",   "据": "Ju ",    "掃": "Sao ",   "授": "Shou ",  "掌": "Zhang ", "排": "Pai ",   "掘": "Jue ",   "掛": "Gua ",
  "採": "Cai ",   "探": "Tan ",   "接": "Jie ",   "控": "Kong ",  "推": "Tui ",   "措": "Cuo ",   "掲": "Jie ",   "描": "Miao ",
  "提": "Ti ",    "揚": "Yang ",  "換": "Huan ",  "握": "Wo ",    "揮": "Hui ",   "援": "Yuan ",  "揺": "Yao ",   "損": "Sun ",
  "搬": "Ban ",   "搭": "Da ",    "携": "Xi ",    "搾": "Zha ",   "摂": "She ",   "摘": "Zhai ",  "摩": "Mo ",    "撃": "Ji ",
  "撤": "Che ",   "撮": "Cuo ",   "撲": "Pu ",    "擁": "Yong ",  "操": "Cao ",   "擦": "Ca ",    "擬": "Ni ",    "支": "Zhi ",
  "改": "Gai ",   "攻": "Gong ",  "放": "Fang ",  "政": "Zheng ", "故": "Gu ",    "敏": "Min ",   "救": "Jiu ",   "敗": "Bai ",
  "教": "Jiao ",  "敢": "Gan ",   "散": "San ",   "敬": "Jing ",  "数": "Shu ",   "整": "Zheng ", "敵": "Di ",    "敷": "Fu ",
  "文": "Wen ",   "斉": "Qi ",    "斎": "Zhai ",  "斗": "Dou ",   "料": "Liao ",  "斜": "Xie ",   "斤": "Jin ",   "斥": "Chi ",
  "断": "Duan ",  "新": "Xin ",   "方": "Fang ",  "施": "Shi ",   "旅": "Lu ",    "旋": "Xuan ",  "族": "Zu ",    "旗": "Qi ",
  "既": "Ji ",    "日": "Ri ",    "旧-早": "Jiu -Zao ",   "旬": "Xun ",   "昆": "Kun ",   "昇": "Sheng ", "昌": "Chang ", "明": "Ming ",
  "易": "Yi ",    "昔": "Xi ",    "星": "Xing ",  "映": "Ying ",  "春": "Chun ",  "昨": "Zuo ",   "昭": "Zhao ",  "是": "Shi ",
  "昼": "Zhou ",  "時": "Shi ",   "晩": "Wan ",   "普": "Pu ",    "景": "Jing ",  "晴": "Qing ",  "晶": "Jing ",  "暁": "Xiao ",
  "暇": "Xia ",   "暑": "Shu ",   "暖": "Nuan ",  "暗": "An ",    "暦": "Li ",    "暫": "Zan ",   "暮": "Mu ",    "暴": "Bao ",
  "曇": "Tan ",   "曜": "Yao ",   "曲": "Qu ",    "更": "Geng ",  "書": "Shu ",   "曹": "Cao ",   "替": "Ti ",    "最": "Zui ",
  "月": "Yue ",   "有": "You ",   "服": "Fu ",    "朕": "Zhen ",  "朗": "Lang ",  "望": "Wang ",  "朝": "Zhao ",  "期": "Qi ",
  "木": "Mu ",    "未-札": "Wei -Zha ",   "朱": "Zhu ",   "朴": "Po ",    "机": "Ji ",    "朽": "Xiu ",   "杉": "Shan ",  "材": "Cai ",
  "村": "Cun ",   "束": "Shu ",   "条": "Tiao ",  "来": "Lai ",   "杯": "Bei ",   "東": "Dong ",  "松": "Song ",  "板": "Ban ",
  "析": "Xi ",    "林": "Lin ",   "枚": "Mei ",   "果": "Guo ",   "枝": "Zhi ",   "枠": "Waku ",  "枢": "Shu ",   "枯": "Ku ",
  "架": "Jia ",   "柄": "Bing ",  "某": "Mou ",   "染": "Ran ",   "柔": "Rou ",   "柱": "Zhu ",   "柳": "Liu ",   "査": "Cha ",
  "栄": "Rong ",  "栓": "Shuan ", "校": "Xiao ",  "株": "Zhu ",   "核": "He ",    "根": "Gen ",   "格": "Ge ",    "栽": "Zai ",
  "桃": "Tao ",   "案": "An ",    "桑": "Sang ",  "桜": "Ying ",  "桟": "Zhan ",  "梅": "Mei ",   "械": "Jie ",   "棄": "Qi ",
  "棋": "Qi ",    "棒": "Bang ",  "棚": "Peng ",  "棟": "Dong ",  "森": "Sen ",   "棺": "Guan ",  "植": "Zhi ",   "検": "Jian ",
  "業": "Ye ",    "極": "Ji ",    "楼": "Lou ",   "楽": "Le ",    "概": "Gai ",   "構": "Gou ",   "様": "Yang ",  "槽": "Cao ",
  "標": "Biao ",  "模": "Mo ",    "権": "Quan ",  "横": "Heng ",  "樹": "Shu ",   "橋": "Qiao ",  "機": "Ji ",    "欄": "Lan ",
  "欠": "Qian ",  "次": "Ci ",    "欧": "Ou ",    "欲": "Yu ",    "欺": "Qi ",    "款": "Kuan ",  "歌": "Ge ",    "歓": "Huan ",
  "止": "Zhi ",   "正": "Zheng ", "武": "Wu ",    "歩": "Bu ",    "歯": "Chi ",   "歳": "Sui ",   "歴": "Li ",    "死": "Si ",
  "殉-残": "Xun -Can ",   "殖": "Zhi ",   "殴": "Ou ",    "段": "Duan ",  "殺": "Sha ",   "殻": "Que ",   "殿": "Dian ",  "母": "Mu ",
  "毎": "Mei ",   "毒": "Du ",    "比": "Bi ",    "毛": "Mao ",   "氏": "Shi ",   "民": "Min ",   "気": "Qi ",    "水": "Shui ",
  "氷": "Bing ",  "永": "Yong ",  "汁": "Zhi ",   "求": "Qiu ",   "汎": "Fan ",   "汗": "Han ",   "汚": "Wu ",    "江": "Jiang ",
  "池": "Chi ",   "決": "Jue ",   "汽": "Qi ",    "沈": "Chen ",  "沖": "Chong ", "没": "Mei ",   "沢": "Ze ",    "河": "He ",
  "沸": "Fei ",   "油": "You ",   "治": "Zhi ",   "沼": "Zhao ",  "沿": "Yan ",   "況": "Kuang ", "泉": "Quan ",  "泊": "Bo ",
  "泌": "Mi ",    "法": "Fa ",    "泡-泣": "Pao -Qi ",    "泥": "Ni ",    "注": "Zhu ",   "泰": "Tai ",   "泳": "Yong ",  "洋": "Yang ",
  "洗": "Xi ",    "洞": "Dong ",  "津": "Jin ",   "洪": "Hong ",  "活": "Huo ",   "派": "Pai ",   "流": "Liu ",   "浄": "Jing ",
  "浅": "Qian ",  "浜": "Bang ",  "浦": "Pu ",    "浪": "Lang ",  "浮": "Fu ",    "浴": "Yu ",    "海": "Hai ",   "浸": "Jin ",
  "消": "Xiao ",  "涙": "Lei ",   "涯": "Ya ",    "液": "Ye ",    "涼": "Liang ", "淑": "Shu ",   "淡": "Dan ",   "深": "Shen ",
  "混": "Hun ",   "添": "Tian ",  "清": "Qing ",  "渇-渉": "Ke -She ",    "渋": "Shibui ",        "渓": "Tani ",  "減": "Jian ",  "渡": "Du ",
  "渦": "Wo ",    "温": "Wen ",   "測": "Ce ",    "港": "Gang ",  "湖": "Hu ",    "湯": "Tang ",  "湾-満": "Wan -Man ",   "源": "Yuan ",
  "準": "Zhun ",  "溝": "Gou ",   "溶": "Rong ",  "滅": "Mie ",   "滋": "Zi ",    "滑": "Hua ",   "滝": "Long ",  "滞": "Zhi ",
  "滴": "Di ",    "漁": "Yu ",    "漂": "Piao ",  "漆": "Qi ",    "漏": "Lou ",   "演": "Yan ",   "漠": "Mo ",    "漢": "Han ",
  "漫": "Man ",   "漬": "Zi ",    "漸": "Jian ",  "潔": "Jie ",   "潜": "Qian ",  "潟": "Xi ",    "潤": "Run ",   "潮": "Chao ",
  "澄": "Cheng ", "激": "Ji ",    "濁": "Zhuo ",  "濃": "Nong ",  "濫": "Lan ",   "濯": "Zhuo ",  "瀬": "Lai ",   "火": "Huo ",
  "灯": "Deng ",  "灰": "Hui ",   "災": "Zai ",   "炉": "Lu ",    "炊": "Chui ",  "炎": "Yan ",   "炭": "Tan ",   "点": "Dian ",
  "為": "Wei ",   "烈": "Lie ",   "無": "Wu ",    "焦": "Jiao ",  "然": "Ran ",   "焼": "Shao ",  "煙": "Yan ",   "照": "Zhao ",
  "煩": "Fan ",   "煮": "Zhu ",   "熟": "Shou ",  "熱": "Re ",    "燃": "Ran ",   "燥": "Zao ",   "爆": "Bao ",   "爵": "Jue ",
  "父": "Fu ",    "片": "Pian ",  "版": "Ban ",   "牙": "Ya ",    "牛": "Niu ",   "牧": "Mu ",    "物": "Wu ",    "牲": "Sheng ",
  "特": "Te ",    "犠": "Ikenie ",        "犬": "Quan ",  "犯": "Fan ",   "状": "Zhuang ",        "狂": "Kuang ", "狩": "Shou ",  "独": "Du ",
  "狭": "Xia ",   "猛": "Meng ",  "猟": "Kari ",  "猪": "Zhu ",   "猫": "Mao ",   "献": "Xian ",  "猶": "You ",   "猿": "Yuan ",
  "獄": "Yu ",    "獣": "Swu ",   "獲": "Huo ",   "玄": "Xuan ",  "率": "Lu ",    "玉": "Yu ",    "王": "Wang ",  "珍": "Zhen ",
  "珠": "Zhu ",   "班": "Ban ",   "現": "Xian ",  "球": "Qiu ",   "理": "Li ",    "琴": "Qin ",   "環": "Huan ",  "璽": "Xi ",
  "瓶": "Ping ",  "甘": "Gan ",   "甚": "Shen ",  "生": "Sheng ", "産": "Chan ",  "用": "Yong ",  "田-申": "Tian -Shen ", "男": "Nan ",
  "町": "Ting ",  "画": "Hua ",   "界": "Jie ",   "畑": "Tian ",  "畔": "Pan ",   "留": "Liu ",   "畜": "Chu ",   "畝": "Mu ",
  "略": "Lue ",   "番": "Fan ",   "異": "Yi ",    "畳": "Die ",   "疎": "Shu ",   "疑": "Yi ",    "疫": "Yi ",    "疲": "Pi ",
  "疾": "Ji ",    "病": "Bing ",  "症": "Zheng ", "痘": "Dou ",   "痛": "Tong ",  "痢": "Li ",    "痴": "Chi ",   "療": "Liao ",
  "癒": "Yu ",    "癖": "Pi ",    "癸": "Gui ",   "発": "Fa ",    "登": "Deng ",  "白": "Bai ",   "百": "Bai ",   "的": "De ",
  "皆": "Jie ",   "皇": "Huang ", "皮": "Pi ",    "皿": "Min ",   "盆": "Pen ",   "益": "Yi ",    "盗": "Dao ",   "盛": "Sheng ",
  "盟": "Meng ",  "監": "Jian ",  "盤": "Pan ",   "目": "Mu ",    "盲": "Mang ",  "直": "Zhi ",   "相": "Xiang ", "盾": "Dun ",
  "省": "Sheng ", "看": "Kan ",   "県": "Xian ",  "真": "Zhen ",  "眠": "Mian ",  "眺": "Tiao ",  "眼": "Yan ",   "着": "Zhao ",
  "睡": "Shui ",  "督": "Du ",    "瞬": "Shun ",  "矛": "Mao ",   "矢": "Shi ",   "知": "Zhi ",   "短": "Duan ",  "矯": "Jiao ",
  "石": "Shi ",   "砂": "Sha ",   "研": "Yan ",   "砕": "Sui ",   "砲": "Pao ",   "破": "Po ",    "硝": "Xiao ",  "硫": "Liu ",
  "硬": "Ying ",  "碁": "Qi ",    "碑": "Bei ",   "確": "Que ",   "磁": "Ci ",    "磨": "Mo ",    "礁": "Jiao ",  "礎": "Chu ",
  "示": "Shi ",   "礼": "Li ",    "社": "She ",   "祈": "Qi ",    "祉": "Zhi ",   "祖": "Zu ",    "祚": "Zuo ",   "祝": "Zhu ",
  "神": "Shen ",  "祥": "Xiang ", "票": "Piao ",  "祭": "Ji ",    "禁": "Jin ",   "禄": "Lu ",    "禅": "Shan ",  "禍-福": "Huo -Fu ",
  "秀": "Xiu ",   "私": "Si ",    "秋": "Qiu ",   "科": "Ke ",    "秒": "Miao ",  "秘": "Mi ",    "租": "Zu ",    "秩": "Zhi ",
  "称": "Cheng ", "移": "Yi ",    "程": "Cheng ", "税": "Shui ",  "稚": "Zhi ",   "種": "Zhong ", "稲": "Dao ",   "稼": "Jia ",
  "稿": "Gao ",   "穀": "Gu ",    "穂": "Sui ",   "積": "Ji ",    "穏": "Wen ",   "穫": "Huo ",   "穴": "Xue ",   "究": "Jiu ",
  "空": "Kong ",  "突": "Tu ",    "窃": "Qie ",   "窒": "Zhi ",   "窓": "Chuang ",        "窮": "Qiong ", "窯": "Yao ",   "立": "Li ",
  "竜": "Long ",  "章": "Zhang ", "童": "Tong ",  "端": "Duan ",  "競": "Jing ",  "竹": "Zhu ",   "笑": "Xiao ",  "笛": "Di ",
  "符": "Fu ",    "第": "Di ",    "筆": "Bi ",    "等": "Deng ",  "筋": "Jin ",   "筒": "Tong ",  "答": "Da ",    "策": "Ce ",
  "箇": "Ge ",    "算": "Suan ",  "管": "Guan ",  "箱": "Xiang ", "節": "Jie ",   "範": "Fan ",   "築": "Zhu ",   "篤": "Du ",
  "簡": "Jian ",  "簿": "Bo ",    "籍": "Ji ",    "米": "Mi ",    "粉": "Fen ",   "粋": "Cui ",   "粒": "Li ",    "粗": "Cu ",
  "粘": "Nian ",  "粛": "Su ",    "粧": "Zhuang ",        "精": "Jing ",  "糖": "Tang ",  "糧": "Liang ", "糸": "Mi ",    "系": "Xi ",
  "糾": "Jiu ",   "紀": "Ji ",    "約": "Yue ",   "紅": "Hong ",  "紋": "Wen ",   "納": "Na ",    "純": "Chun ",  "紙-紛": "Zhi -Fen ",
  "素-索": "Su -Suo ",    "紫": "Zi ",    "累": "Lei ",   "細": "Xi ",    "紳": "Shen ",  "紹": "Shao ",  "紺": "Gan ",   "終": "Zhong ",
  "組": "Zu ",    "経": "Jing ",  "結": "Jie ",   "絞": "Jiao ",  "絡": "Luo ",   "給": "Gei ",   "統": "Tong ",  "絵": "Hui ",
  "絶": "Jue ",   "絹": "Juan ",  "継": "Ji ",    "続": "Sok ",   "維": "Wei ",   "綱": "Gang ",  "網": "Wang ",  "綿": "Mian ",
  "緊": "Jin ",   "総": "Zong ",  "緑": "Lu ",    "緒": "Xu ",    "線": "Xian ",  "締": "Di ",    "編": "Bian ",  "緩": "Huan ",
  "緯": "Wei ",   "練": "Lian ",  "縁": "Yuan ",  "縄": "Nawa ",  "縛": "Fu ",    "縦": "Zong ",  "縫": "Feng ",  "縮": "Suo ",
  "績": "Ji ",    "繁": "Fan ",   "繊": "Sem ",   "織": "Zhi ",   "繕": "Shan ",  "繭": "Jian ",  "繰": "Zao ",   "缶": "Fou ",
  "罪": "Zui ",   "置": "Zhi ",   "罰": "Fa ",    "署": "Shu ",   "罷": "Ba ",    "羅": "Luo ",   "羊": "Yang ",  "美": "Mei ",
  "群": "Qun ",   "義": "Yi ",    "羽": "Yu ",    "翁": "Weng ",  "翌": "Yi ",    "習": "Xi ",    "翻": "Fan ",   "翼": "Yi ",
  "老": "Lao ",   "考": "Kao ",   "者": "Zhe ",   "耐": "Nai ",   "耕": "Geng ",  "耗": "Hao ",   "耳": "Er ",    "聖": "Sheng ",
  "聞": "Wen ",   "聴": "Ting ",  "職": "Zhi ",   "肉": "Rou ",   "肌": "Ji ",    "肖": "Xiao ",  "肝": "Gan ",   "肢": "Zhi ",
  "肥": "Fei ",   "肩": "Jian ",  "肪": "Fang ",  "肯": "Ken ",   "育": "Yu ",    "肺": "Fei ",   "胃": "Wei ",   "胆": "Dan ",
  "背": "Bei ",   "胎": "Tai ",   "胞": "Bao ",   "胴": "Dong ",  "胸": "Xiong ", "能": "Neng ",  "脂": "Zhi ",   "脅": "Xie ",
  "脈": "Mo ",    "脚": "Jiao ",  "脱": "Tuo ",   "脳": "Noy ",   "脹": "Zhang ", "腐": "Fu ",    "腕": "Wan ",   "腰": "Yao ",
  "腸": "Chang ", "腹": "Fu ",    "膚": "Fu ",    "膜": "Mo ",    "膨": "Peng ",  "臓": "Zang ",  "臣": "Chen ",  "臨": "Lin ",
  "自": "Zi ",    "臭": "Chou ",  "至": "Zhi ",   "致": "Zhi ",   "興": "Xing ",  "舌": "She ",   "舎": "Yadoru ",        "舗": "Pu ",
  "舞": "Wu ",    "舟": "Zhou ",  "航": "Hang ",  "般": "Ban ",   "舶": "Bo ",    "船": "Chuan ", "艇": "Ting ",  "艦": "Jian ",
  "良": "Liang ", "色": "Se ",    "芋": "Yu ",    "芝": "Zhi ",   "花": "Hua ",   "芳": "Fang ",  "芸": "Yun ",   "芽": "Ya ",
  "苗": "Miao ",  "若": "Ruo ",   "苦": "Ku ",    "英": "Ying ",  "茂": "Mao ",   "茎": "Jing ",  "茶": "Cha ",   "草": "Cao ",
  "荒": "Huang ", "荘": "Zhuang ",        "荷": "He ",    "菊": "Ju ",    "菌": "Jun ",   "菓": "Guo ",   "菜": "Cai ",   "華": "Hua ",
  "落": "Luo ",   "葉": "Xie ",   "著": "Zhu ",   "葬": "Zang ",  "蒸": "Zheng ", "蓄": "Xu ",    "蔵": "Zang ",  "薄": "Bo ",
  "薦": "Jian ",  "薪-薬": "Xin -Yao ",   "藤": "Teng ",  "藩": "Fan ",   "藻": "Zao ",   "虎": "Hu ",    "虐": "Nue ",   "虚": "Xu ",
  "虜": "Lu ",    "虞": "Yu ",    "虫": "Chong ", "蚊": "Wen ",   "蚕": "Tian ",  "蛇": "She ",   "蛍": "Ying ",  "蛮": "Man ",
  "融": "Rong ",  "血": "Xie ",   "衆": "Zhong ", "行": "Xing ",  "術": "Shu ",   "街": "Jie ",   "衛": "Wei ",   "衝": "Chong ",
  "衡": "Heng ",  "衣": "Yi ",    "表": "Biao ",  "衰": "Shuai ", "衷": "Zhong ", "袋": "Dai ",   "被": "Bei ",   "裁": "Cai ",
  "裂": "Lie ",   "装": "Zhuang ",        "裏": "Li ",    "裕": "Yu ",    "補": "Bu ",    "裸": "Luo ",   "製": "Zhi ",   "複": "Fu ",
  "褐": "He ",    "褒": "Bao ",   "襟": "Jin ",   "襲": "Xi ",    "西": "Xi ",    "要": "Yao ",   "覆": "Fu ",    "覇": "Ba ",
  "見": "Jian ",  "規": "Gui ",   "視": "Shi ",   "覚": "Jue ",   "覧": "Lan ",   "親": "Qin ",   "観": "Guan ",  "角": "Jiao ",
  "解": "Jie ",   "触": "Hong ",  "言": "Yan ",   "訂": "Ding ",  "計": "Ji ",    "討": "Tao ",   "訓": "Xun ",   "託": "Tuo ",
  "記": "Ji ",    "訟": "Song ",  "訪": "Fang ",  "設": "She ",   "許": "Xu ",    "訳": "Yi ",    "訴": "Su ",    "診": "Zhen ",
  "証": "Zheng ", "詐": "Zha ",   "詔": "Zhao ",  "評": "Ping ",  "詞": "Ci ",    "詠": "Yong ",  "試": "Shi ",   "詩": "Shi ",
  "詰-詳": "Jie -Xiang ", "誇": "Kua ",   "誉": "Yu ",    "誌": "Zhi ",   "認": "Ren ",   "誓": "Shi ",   "誕": "Dan ",   "誘": "You ",
  "語": "Yu ",    "誠": "Cheng ", "誤": "Wu ",    "説": "Shuo ",  "読": "Du ",    "誰": "Shui ",  "課": "Ke ",    "調": "Diao ",
  "談": "Tan ",   "請": "Qing ",  "論": "Lun ",   "諭": "Yu ",    "諮": "Zi ",    "諸": "Zhu ",   "諾": "Nuo ",   "謀": "Mou ",
  "謁": "Ye ",    "謄": "Teng ",  "謙": "Qian ",  "講": "Jiang ", "謝": "Xie ",   "謡": "Yao ",   "謹": "Jin ",   "識": "Shi ",
  "譜": "Pu ",    "警": "Jing ",  "議": "Yi ",    "譲": "Rang ",  "護": "Hu ",    "谷": "Gu ",    "豆": "Dou ",   "豊": "Li ",
  "豚": "Tun ",   "象": "Xiang ", "豪": "Hao ",   "貝": "Bei ",   "貞": "Zhen ",  "負-貢": "Fu -Gong ",   "貧-販": "Pin -Fan ",   "貫": "Guan ",
  "責": "Ze ",    "貯": "Zhu ",   "貴": "Gui ",   "買": "Mai ",   "貸": "Dai ",   "費": "Fei ",   "貿": "Mao ",   "賀": "He ",
  "賃": "Ren ",   "賄": "Hui ",   "資": "Zi ",    "賊": "Zei ",   "賓": "Bin ",   "賛": "Zan ",   "賜": "Si ",    "賞": "Shang ",
  "賠": "Pei ",   "賢": "Xian ",  "賦": "Fu ",    "質": "Zhi ",   "購": "Gou ",   "贈": "Zeng ",  "赤": "Chi ",   "赦": "She ",
  "走": "Zou ",   "赴": "Fu ",    "起": "Qi ",    "超": "Chao ",  "越": "Yue ",   "趣": "Qu ",    "足": "Zu ",    "距": "Ju ",
  "跡": "Ji ",    "路": "Lu ",    "跳": "Tiao ",  "践": "Jian ",  "踊": "Yong ",  "踏": "Ta ",    "躍": "Yue ",   "身": "Shen ",
  "車": "Che ",   "軌": "Gui ",   "軍": "Jun ",   "軒": "Xuan ",  "軟": "Ruan ",  "転": "Zhuan ", "軸": "Zhou ",  "軽": "Qing ",
  "較": "Jiao ",  "載": "Zai ",   "輝": "Hui ",   "輩": "Bei ",   "輪": "Lun ",   "輸": "Shu ",   "轄": "Xia ",   "辛": "Xin ",
  "辞": "Ci ",    "辰-農": "Chen -Nong ", "辺": "Bian ",  "込": "Ip ",    "迅": "Xun ",   "迎": "Ying ",  "近": "Jin ",   "返": "Fan ",
  "迫": "Po ",    "迭": "Die ",   "述": "Shu ",   "迷": "Mi ",    "追": "Zhui ",  "退": "Tui ",   "送": "Song ",  "逃": "Tao ",
  "逆": "Ni ",    "透": "Tou ",   "逐": "Zhu ",   "逓": "Di ",    "途": "Tu ",    "通": "Tong ",  "逝": "Shi ",   "速": "Su ",
  "造": "Zao ",   "連": "Lian ",  "逮": "Dai ",   "週": "Zhou ",  "進": "Jin ",   "逸": "Yi ",    "遂": "Sui ",   "遅": "Chi ",
  "遇": "Yu ",    "遊": "You ",   "運": "Yun ",   "遍": "Bian ",  "過": "Guo ",   "道-違": "Dao -Wei ",   "遠": "Yuan ",  "遣": "Qian ",
  "適": "Shi ",   "遭": "Zao ",   "遮": "Zhe ",   "遵": "Zun ",   "遷": "Qian ",  "選": "Xuan ",  "遺": "Yi ",    "避": "Bi ",
  "還": "Huan ",  "邦": "Bang ",  "邪": "Xie ",   "邸": "Di ",    "郊": "Jiao ",  "郎": "Lang ",  "郡": "Jun ",   "部": "Bu ",
  "郭": "Guo ",   "郵": "You ",   "郷": "Xiang ", "都": "Du ",    "酉": "You ",   "酌": "Zhuo ",  "配": "Pei ",   "酒": "Jiu ",
  "酔": "Zui ",   "酢": "Zuo ",   "酪": "Luo ",   "酬": "Chou ",  "酵": "Xiao ",  "酷": "Ku ",    "酸": "Suan ",  "醜": "Chou ",
  "醸": "Niang ", "釈": "Shi ",   "里-量": "Li -Liang ",  "金": "Jin ",   "針": "Zhen ",  "釣": "Diao ",  "鈍": "Dun ",   "鈴": "Ling ",
  "鉄": "Tie ",   "鉛": "Qian ",  "鉢": "Bo ",    "鉱": "Kuang ", "銀": "Yin ",   "銃": "Chong ", "銅": "Tong ",  "銑": "Xian ",
  "銘": "Ming ",  "銭": "Qian ",  "鋭": "Rui ",   "鋳": "Zhu ",   "鋼": "Gang ",  "錘": "Chui ",  "錠": "Ding ",  "錬": "Lian ",
  "錯": "Cuo ",   "録": "Lu ",    "鍛": "Duan ",  "鎖": "Suo ",   "鎮": "Zhen ",  "鏡": "Jing ",  "鐘": "Zhong ", "鑑": "Jian ",
  "長": "Chang ", "門": "Men ",   "閉": "Bi ",    "開": "Kai ",   "閏": "Run ",   "閑": "Xian ",  "間": "Jian ",  "関": "Guan ",
  "閣": "Ge ",    "閥": "Fa ",    "閲": "Yue ",   "闘": "Dou ",   "阪": "Ban ",   "防": "Fang ",  "阻": "Zu ",    "附": "Fu ",
  "降": "Jiang ", "限": "Xian ",  "陛": "Bi ",    "院-陥": "Yuan -Xian ", "陪": "Pei ",   "陰": "Yin ",   "陳": "Chen ",  "陵": "Ling ",
  "陶": "Tao ",   "陸": "Lu ",    "険": "Xian ",  "陽": "Yang ",  "隅": "Yu ",    "隆": "Long ",  "隊": "Dui ",   "階": "Jie ",
  "随": "Sui ",   "隔": "Ge ",    "際": "Ji ",    "障": "Zhang ", "隠": "Yin ",   "隣": "Lin ",   "隷": "Li ",    "隻": "Zhi ",
  "雄-雇": "Xiong -Gu ",  "雉": "Zhi ",   "雌": "Ci ",    "雑": "Za ",    "離": "Li ",    "難": "Nan ",   "雨": "Yu ",    "雪": "Xue ",
  "雰": "Fen ",   "雲": "Yun ",   "零": "Ling ",  "雷": "Lei ",   "電": "Dian ",  "需": "Xu ",    "震": "Zhen ",  "霊": "Ling ",
  "霜": "Shuang ",        "霧": "Wu ",    "露": "Lu ",    "青": "Qing ",  "静": "Jing ",  "非": "Fei ",   "面": "Mian ",  "革": "Ge ",
  "靴": "Xue ",   "韓": "Han ",   "音": "Yin ",   "韻": "Yun ",   "響": "Xiang ", "頂": "Ding ",  "頃": "Qing ",  "項": "Xiang ",
  "順": "Shun ",  "預-頒": "Yu -Ban ",    "領": "Ling ",  "頭": "Tou ",   "頻": "Pin ",   "頼": "Lai ",   "題": "Ti ",    "額": "E ",
  "顔": "Yan ",   "顕": "Xian ",  "願": "Yuan ",  "類": "Lei ",   "顧": "Gu ",    "風": "Feng ",  "飛": "Fei ",   "食": "Shi ",
  "飢": "Ji ",    "飯": "Fan ",   "飲": "Yin ",   "飼-飾": "Si -Shi ",    "養": "Yang ",  "餓": "E ",     "館": "Guan ",  "首": "Shou ",
  "香": "Xiang ", "馬": "Ma ",    "駄-駆": "Tuo -Qu ",    "駐": "Zhu ",   "騎": "Qi ",    "騒": "Sao ",   "験": "Yan ",   "騰": "Teng ",
  "驚": "Jing ",  "骨": "Gu ",    "髄": "Sui ",   "高": "Gao ",   "髪": "Fa ",    "鬼": "Gui ",   "魂": "Hun ",   "魅": "Mei ",
  "魔": "Mo ",    "魚": "Yu ",    "鮮": "Xian ",  "鯨": "Jing ",  "鳥": "Niao ",  "鳴": "Ming ",  "鶏": "Ji ",    "鹿": "Lu ",
  "麗": "Li ",    "麦": "Mai ",   "麻": "Ma ",    "黄": "Huang ", "黒": "Hei ",   "黙": "Mo ",    "鼓": "Gu ",    "鼠": "Shu ",
  "鼻": "Bi ",    "齢": "Ling ",  

  // (ka) - Georgian
  "ა": "a",       "ბ": "b",       "გ": "g",       "დ": "d",       "ე": "e",       "ვ": "v",       "ზ": "z",       "თ": "t`",
  "ი": "i",       "კ": "k",       "ლ": "l",       "მ": "m",       "ნ": "n",       "ო": "o",       "პ": "p",       "ჟ": "zh",
  "რ": "r",       "ს": "s",       "ტ": "t",       "უ": "u",       "ფ": "p`",      "ქ": "k`",      "ღ": "g'",      "ყ": "q",
  "შ": "sh",      "ჩ": "ch`",     "ც": "c`",      "ძ": "z'",      "წ": "c",       "ჭ": "ch",      "ხ": "x",       "ჯ": "j",
  "ჰ": "h",       

  // (ki) - Kikuyu
  "ĩ": "i",       "ũ": "u",       

  // (kk) - Kazakh
  "а": "a",       "ә": "@",       "б": "b",       "в": "v",       "г": "g",       "ғ": "g'",      "д": "d",       "е": "e",
  "ё": "io",      "ж": "zh",      "з": "z",       "и": "i",       "й": "i",       "к": "k",       "қ": "k'",      "л": "l",
  "м": "m",       "н": "n",       "ң": "n'",      "о": "o",       "ө": "o",       "п": "p",       "р": "r",       "с": "s",
  "т": "t",       "у": "u",       "ұ": "u'",      "ү": "u",       "ф": "f",       "х": "kh",      "һ": "h",       "ц": "ts",
  "ч": "ch",      "ш": "sh",      "щ": "shch",    "ъ": "",        "ы": "y",       "і": "i",       "ь": "'",       "э": "e",
  "ю": "iu",      "я": "ia",      

  // (kl) - Kalaallisut
  "á": "a",       "â": "a",       "ã": "a",       "é": "e",       "ê": "e",       "í": "i",       "î": "i",       "ĩ": "i",
  "ô": "o",       "ĸ": "k",       "ú": "u",       "û": "u",       "ũ": "u",       "æ": "ae",      "ø": "o",       "å": "a",


  // (km) - Central Khmer
  "ៈ": "a`",       "ក": "k",       "ខ": "kh",      "គ": "g",       "ឃ": "gh",      "ង": "ng",      "ច": "c",       "ឆ": "ch",
  "ជ": "j",       "ឈ": "jh",      "ញ": "ny",      "ដ": "t",       "ឋ": "tth",     "ឌ": "d",       "ឍ": "ddh",     "ណ": "nn",
  "ត": "t",       "ថ": "th",      "ទ": "d",       "ធ": "dh",      "ន": "n",       "ប": "p",       "ផ": "ph",      "ព": "b",
  "ភ": "bh",      "ម": "m",       "យ": "y",       "រ": "r",       "ឫ": "ry",      "ឬ": "ryy",     "ល": "l",       "ឭ": "ly",
  "ឮ": "lyy",     "វ": "v",       "ស": "s",       "ហ": "h",       "ឡ": "l",       "អ": "q",       "ឥ": "i",       "ឦ": "ii",
  "ឧ": "u",       "ឩ": "uu",      "ឪ": "uuv",     "ឯ": "e",       "ឰ": "ai",      "ឱ": "oo",      "ឲ": "oo",      "ឳ": "au",
  "ា": "aa",       "ើ": "oe",       "ឿ": "ya",       "ៀ": "ie",       "េ": "e",        "ែ": "ae",       "ៃ": "ai",       "ោ": "oo",
  "ៅ": "au",       "ះ": "H",        

  // (kn) - Kannada
  "೦": "0",       "೧": "1",       "೨": "2",       "೩": "3",       "೪": "4",       "೫": "5",       "೬": "6",       "೭": "7",
  "೮": "8",       "೯": "9",       "ಅ": "a",       "ಆ": "aa",      "ಇ": "i",       "ಈ": "ii",      "ಉ": "u",       "ಊ": "uu",
  "ಋ": "R",       "ೠ": "RR",      "ಌ": "L",       "ೡ": "LL",      "ಎ": "e",       "ಏ": "ee",      "ಐ": "ai",      "ಒ": "o",
  "ಓ": "oo",      "ಔ": "au",      "ಂ": "N",        "ಃ": "H",        "ಕ": "k",       "ಖ": "kh",      "ಗ": "g",       "ಘ": "gh",
  "ಙ": "ng",      "ಚ": "c",       "ಛ": "ch",      "ಜ": "j",       "ಝ": "jh",      "ಞ": "ny",      "ಟ": "tt",      "ಠ": "tth",
  "ಡ": "dd",      "ಢ": "ddh",     "ಣ": "nn",      "ತ": "t",       "ಥ": "th",      "ದ": "d",       "ಧ": "dh",      "ನ": "n",
  "ಪ": "p",       "ಫ": "ph",      "ಬ": "b",       "ಭ": "bh",      "ಮ": "m",       "ಯ": "y",       "ರ": "r",       "ಱ": "rr",
  "ಲ": "l",       "ವ": "v",       "ಶ": "sh",      "ಷ": "ss",      "ಸ": "s",       "ಹ": "h",       "ಳ": "ll",      "ಽ": "[?]",
  "ಾ": "aa",       "ೀ": "ii",       "ು": "u",        "ೂ": "uu",       "ೃ": "R",        "ೄ": "RR",       "ೇ": "ee",       "ೈ": "ai",
  "ೊ": "o",        "ೋ": "oo",       "ೕ": "+",        "ೖ": "+",        

  // (ko) - Korean
  "가-힣": "ga-hih",      

  // (ks) - Kashmiri
  "ء": "",  "آ": "a", "أ": "'", "ٲ": "'", "ؤ": "w'",        "ا": "",  "ٮ": "[?]",       "ب": "b",
  "پ": "p", "ت": "t", "ث": "th",        "ٹ": "tt",        "ج": "j", "چ": "ch",        "ح": "H", "خ": "kh",
  "د": "d", "ذ": "dh",        "ڈ": "dd",        "ر": "r", "ز": "z", "ڑ": "rr",        "ژ": "j", "س": "s",
  "ش": "sh",        "ص": "S", "ض": "D", "ط": "T", "ظ": "Z", "ع": "`", "غ": "G", "ف": "f",
  "ق": "q", "ک": "kh",        "گ": "g", "ل": "l", "م": "m", "ن": "n", "ں": "N", "ھ": "h",
  "ہ": "h", "و": "w", "ۄ": "W", "ی": "y", "ۍ": "Y", "ے": "y", 

  // (ky) - Kirghiz
  "а": "a",       "б": "b",       "г": "g",       "д": "d",       "е": "e",       "ё": "io",      "ж": "zh",      "з": "z",
  "и": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",       "ӊ": "[?]",     "о": "o",
  "ө": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ү": "u",       "х": "kh",
  "ч": "ch",      "ш": "sh",      "ъ": "",        "ы": "y",       "э": "e",       "ю": "iu",      "я": "ia",      

  // (lb) - Luxembourgish
  "ä": "a",       "é": "e",       "ë": "e",       

  // (lg) - Ganda
  "ŋ": "NG",      

  // (ln) - Lingala
  "á": "a",       "â": "a",       "ǎ": "a",       "é": "e",       "ê": "e",       "ě": "e",       "ɛ": "e",       "í": "i",
  "î": "i",       "ǐ": "i",       "ó": "o",       "ô": "o",       "ǒ": "o",       "ɔ": "o",       "ú": "u",       

  // (lo) - Lao
  "ໆ": "+",       "ກ": "k",       "ຂ": "kh",      "ຄ": "kh",      "ງ": "ng",      "ຈ": "ch",      "ສ": "s",       "ຊ": "s",
  "ຍ": "ny",      "ດ": "d",       "ຕ": "h",       "ຖ": "th",      "ທ": "th",      "ນ": "n",       "ບ": "b",       "ປ": "p",
  "ຜ": "ph",      "ຝ": "f",       "ພ": "ph",      "ຟ": "f",       "ມ": "m",       "ຢ": "y",       "ຣ": "r",       "ລ": "l",
  "ວ": "w",       "ຫ": "h",       "ໜ": "hn",      "ໝ": "hm",      "ອ": "`",       "ຮ": "",        "ຯ": "~",       "ະ": "a",
  "າ": "aa",      "ຳ": "am",      "ຽ": "ny",      "ເ": "e",       "ແ": "ei",      "ໂ": "o",       "ໃ": "ay",      "ໄ": "ai",


  // (lt) - Lithuanian
  "ą": "a",       "č": "c",       "ę": "e",       "ė": "e",       "į": "i",       "š": "s",       "ų": "u",       "ū": "u",
  "ž": "z",       

  // (lu) - Luba-Katanga
  "á": "a",       "à": "a",       "é": "e",       "è": "e",       "ɛ": "e",       "í": "i",       "ì": "i",       "ó": "o",
  "ò": "o",       "ɔ": "o",       "ú": "u",       "ù": "u",       

  // (lv) - Latvian
  "ā": "a",       "č": "c",       "ē": "e",       "ģ": "g",       "ī": "i",       "ķ": "k",       "ļ": "l",       "ņ": "n",
  "š": "s",       "ū": "u",       "ž": "z",       

  // (mg) - Malagasy
  "à": "a",       "â": "a",       "é": "e",       "è": "e",       "ê": "e",       "ë": "e",       "ì": "i",       "î": "i",
  "ï": "i",       "ñ": "n",       "ô": "o",       

  // (mk) - Macedonian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "ѓ": "gj",      "е": "e",       "ж": "zh",
  "з": "z",       "ѕ": "dz",      "и": "i",       "ј": "j",       "к": "k",       "л": "l",       "љ": "lj",      "м": "m",
  "н": "n",       "њ": "nj",      "о": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",       "ќ": "kj",
  "у": "u",       "ф": "f",       "х": "kh",      "ц": "ts",      "ч": "ch",      "џ": "dzh",     "ш": "sh",      

  // (ml) - Malayalam
  "ഃ": "H",        "അ": "a",       "ആ": "aa",      "ഇ": "i",       "ഈ": "ii",      "ഉ": "u",       "ഊ": "uu",      "ഋ": "R",
  "ൠ": "RR",      "ഌ": "L",       "ൡ": "LL",      "എ": "e",       "ഏ": "ee",      "ഐ": "ai",      "ഒ": "o",       "ഓ": "oo",
  "ഔ": "au",      "ക": "k",       "ൿ": "[?]",     "ഖ": "kh",      "ഗ": "g",       "ഘ": "gh",      "ങ": "ng",      "ച": "c",
  "ഛ": "ch",      "ജ": "j",       "ഝ": "jh",      "ഞ": "ny",      "ട": "tt",      "ഠ": "tth",     "ഡ": "dd",      "ഢ": "ddh",
  "ണ": "nn",      "ൺ": "[?]",     "ത": "t",       "ഥ": "th",      "ദ": "d",       "ധ": "dh",      "ന": "n",       "ൻ": "[?]",
  "പ": "p",       "ഫ": "ph",      "ബ": "b",       "ഭ": "bh",      "മ": "m",       "ം": "N",        "യ": "y",       "ര": "r",
  "ർ": "[?]",     "ല": "l",       "ൽ": "[?]",     "വ": "v",       "ശ": "sh",      "ഷ": "ss",      "സ": "s",       "ഹ": "h",
  "ള": "ll",      "ൾ": "[?]",     "ഴ": "lll",     "റ": "rr",      "ാ": "aa",       "ി": "i",        "ീ": "ii",       "െ": "e",
  "േ": "ee",       "ൈ": "ai",       "ൊ": "o",        "ോ": "oo",       "ൗ": "+",        "ൌ": "au",       

  // (mn) - Mongolian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "е": "e",       "ё": "io",      "ж": "zh",
  "з": "z",       "и": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",       "о": "o",
  "ө": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ү": "u",       "ф": "f",
  "х": "kh",      "ц": "ts",      "ч": "ch",      "ш": "sh",      "щ": "shch",    "ъ": "",        "ы": "y",       "ь": "'",
  "э": "e",       "ю": "iu",      "я": "ia",      

  // (mr) - Marathi
  "ॐ": "AUM",     "ः": "H",        "अ": "a",       "आ": "aa",      "इ": "i",       "ई": "ii",      "उ": "u",       "ऊ": "uu",
  "ऋ": "R",       "ऌ": "L",       "ऍ": "eN",      "ए": "e",       "ऐ": "ai",      "ऑ": "oN",      "ओ": "o",       "औ": "au",
  "क": "k",       "ख": "kh",      "ग": "g",       "घ": "gh",      "ङ": "ng",      "च": "c",       "छ": "ch",      "ज": "j",
  "झ": "jh",      "ञ": "ny",      "ट": "tt",      "ठ": "tth",     "ड": "dd",      "ढ": "ddh",     "ण": "nn",      "त": "t",
  "थ": "th",      "द": "d",       "ध": "dh",      "न": "n",       "प": "p",       "फ": "ph",      "ब": "b",       "भ": "bh",
  "म": "m",       "य": "y",       "र": "r",       "ल": "l",       "व": "v",       "श": "sh",      "ष": "ss",      "स": "s",
  "ह": "h",       "ळ": "l",       "ऽ": "'",       "ा": "aa",       "ि": "i",        "ी": "ii",       "ॉ": "oN",       "ो": "o",
  "ौ": "au",       

  // (mt) - Maltese
  "à": "a",       "ċ": "c",       "è": "e",       "ġ": "g",       "ħ": "h",       "ì": "i",       "ò": "o",       "ù": "u",
  "ż": "z",       

  // (my) - Burmese
  "က": "k",       "ခ": "kh",      "ဂ": "g",       "ဃ": "gh",      "င": "ng",      "စ": "c",       "ဆ": "ch",      "ဇ": "j",
  "ဈ": "jh",      "ဉ": "ny",      "ည": "nny",     "ဋ": "tt",      "ဌ": "tth",     "ဍ": "dd",      "ဎ": "ddh",     "ဏ": "nn",
  "တ": "tt",      "ထ": "th",      "ဒ": "d",       "ဓ": "dh",      "န": "n",       "ပ": "p",       "ဖ": "ph",      "ဗ": "b",
  "ဘ": "bh",      "မ": "m",       "ယ": "y",       "ရ": "r",       "လ": "l",       "ဝ": "w",       "သ": "s",       "ဟ": "h",
  "ဠ": "ll",      "အ": "a",       "ဣ": "i",       "ဤ": "ii",      "ဥ": "u",       "ဦ": "uu",      "ဧ": "e",       "ဩ": "o",
  "ဪ": "au",      "ာ": "aa",       "ါ": "[?]",      "ေ": "e",        "ဿ": "[?]",     "ျ": "[?]",      "ြ": "[?]",      "း": ":",


  // (nb) - Norwegian Bokmal
  "à": "a",       "é": "e",       "ó": "o",       "ò": "o",       "ô": "o",       "æ": "ae",      "ø": "o",       "å": "a",


  // (ne) - Nepali (macrolanguage)
  "ः": "H",        "ॐ": "AUM",     "अ": "a",       "आ": "aa",      "इ": "i",       "ई": "ii",      "उ": "u",       "ऊ": "uu",
  "ऋ": "R",       "ऌ": "L",       "ऍ": "eN",      "ए": "e",       "ऐ": "ai",      "ऑ": "oN",      "ओ": "o",       "औ": "au",
  "क": "k",       "ख": "kh",      "ग": "g",       "घ": "gh",      "ङ": "ng",      "च": "c",       "छ": "ch",      "ज": "j",
  "झ": "jh",      "ञ": "ny",      "ट": "tt",      "ठ": "tth",     "ड": "dd",      "ढ": "ddh",     "ण": "nn",      "त": "t",
  "थ": "th",      "द": "d",       "ध": "dh",      "न": "n",       "प": "p",       "फ": "ph",      "ब": "b",       "भ": "bh",
  "म": "m",       "य": "y",       "र": "r",       "ल": "l",       "ळ": "l",       "व": "v",       "श": "sh",      "ष": "ss",
  "स": "s",       "ह": "h",       "ऽ": "'",       "ा": "aa",       "ि": "i",        "ी": "ii",       "ॉ": "oN",       "ो": "o",
  "ौ": "au",       

  // (nl) - Dutch
  "á": "a",       "ä": "a",       "é": "e",       "ë": "e",       "í": "i",       "ï": "i",       "ó": "o",       "ö": "o",
  "ú": "u",       "ü": "u",       

  // (nn) - Norwegian Nynorsk
  "à": "a",       "é": "e",       "ó": "o",       "ò": "o",       "ô": "o",       "æ": "ae",      "ø": "o",       "å": "a",


  // (or) - Oriya (macrolanguage)
  "ଅ": "a",       "ଆ": "aa",      "ଇ": "i",       "ଈ": "ii",      "ଉ": "u",       "ଊ": "uu",      "ଋ": "R",       "ଏ": "e",
  "ଐ": "ai",      "ଓ": "o",       "ଔ": "au",      "ଂ": "N",        "ଃ": "H",        "କ": "k",       "ଖ": "kh",      "ଗ": "g",
  "ଘ": "gh",      "ଙ": "ng",      "ଚ": "c",       "ଛ": "ch",      "ଜ": "j",       "ଝ": "jh",      "ଞ": "ny",      "ଟ": "tt",
  "ଠ": "tth",     "ଡ": "dd",      "ଢ": "ddh",     "ଣ": "nn",      "ତ": "t",       "ଥ": "th",      "ଦ": "d",       "ଧ": "dh",
  "ନ": "n",       "ପ": "p",       "ଫ": "ph",      "ବ": "b",       "ଭ": "bh",      "ମ": "m",       "ଯ": "y",       "ୟ": "yy",
  "ର": "r",       "ଲ": "l",       "ଳ": "ll",      "ଵ": "",        "ୱ": "[?]",     "ଶ": "sh",      "ଷ": "ss",      "ସ": "s",
  "ହ": "h",       "ା": "aa",       "ୀ": "ii",       "େ": "e",        "ୈ": "ai",       "ୋ": "o",        "ୌ": "au",       

  // (os) - Ossetian
  "а": "a",       "ӕ": "ae",      "б": "b",       "в": "v",       "г": "g",       "д": "d",       "е": "e",       "ё": "io",
  "ж": "zh",      "з": "z",       "и": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",
  "о": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ф": "f",       "х": "kh",
  "ц": "ts",      "ч": "ch",      "ш": "sh",      "щ": "shch",    "ъ": "",        "ы": "y",       "ь": "'",       "э": "e",
  "ю": "iu",      "я": "ia",      

  // (pa) - Panjabi
  "੦": "0",       "੧": "1",       "੨": "2",       "੩": "3",       "੪": "4",       "੫": "5",       "੬": "6",       "੭": "7",
  "੮": "8",       "੯": "9",       "ੴ": "G.E.O.",  "ੳ": "",        "ਉ": "u",       "ਊ": "uu",      "ਓ": "oo",      "ਅ": "a",
  "ਆ": "aa",      "ਐ": "ai",      "ਔ": "au",      "ੲ": "",        "ਇ": "i",       "ਈ": "ii",      "ਏ": "ee",      "ਸ": "s",
  "ਹ": "h",       "ਕ": "k",       "ਖ": "kh",      "ਗ": "g",       "ਘ": "gh",      "ਙ": "ng",      "ਚ": "c",       "ਛ": "ch",
  "ਜ": "j",       "ਝ": "jh",      "ਞ": "ny",      "ਟ": "tt",      "ਠ": "tth",     "ਡ": "dd",      "ਢ": "ddh",     "ਣ": "nn",
  "ਤ": "t",       "ਥ": "th",      "ਦ": "d",       "ਧ": "dh",      "ਨ": "n",       "ਪ": "p",       "ਫ": "ph",      "ਬ": "b",
  "ਭ": "bb",      "ਮ": "m",       "ਯ": "y",       "ਰ": "r",       "ਲ": "l",       "ਵ": "v",       "ੜ": "rr",      "ਾ": "aa",
  "ਿ": "i",        "ੀ": "ii",       

  // (pl) - Polish
  "ą": "a",       "ć": "c",       "ę": "e",       "ł": "l",       "ń": "n",       "ó": "o",       "ś": "s",       "ź": "z",
  "ż": "z",       

  // (ps) - Pushto
  "آ": "a", "ا": "",  "أ": "'", "ء": "",  "ب": "b", "پ": "p", "ت": "t", "ټ": "t",
  "ث": "th",        "ج": "j", "ځ": "'h",        "چ": "ch",        "څ": "H", "ح": "H", "خ": "kh",        "د": "d",
  "ډ": "D", "ذ": "dh",        "ر": "r", "ړ": "R", "ز": "z", "ژ": "j", "ږ": "R", "س": "s",
  "ش": "sh",        "ښ": "S", "ص": "S", "ض": "D", "ط": "T", "ظ": "Z", "ع": "`", "غ": "G",
  "ف": "f", "ق": "q", "ک": "kh",        "ګ": "K", "ل": "l", "م": "m", "ن": "n", "ڼ": "N",
  "ه": "h", "ة": "@", "و": "w", "ؤ": "w'",        "ی": "y", "ي": "y", "ې": "",  "ۍ": "Y",
  "ئ": "y'",        

  // (pt) - Portuguese
  "á": "a",       "à": "a",       "â": "a",       "ã": "a",       "ç": "c",       "é": "e",       "ê": "e",       "í": "i",
  "ó": "o",       "ò": "o",       "ô": "o",       "õ": "o",       "ú": "u",       

  // (qu) - Quechua
  "ñ": "n",       

  // (rm) - Romansh
  "à": "a",       "é": "e",       "è": "e",       "ì": "i",       "ò": "o",       "ù": "u",       

  // (ro) - Romanian
  "ă": "a",       "â": "a",       "î": "i",       "ș": "s",       "ț": "t",       

  // (ru) - Russian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "е": "e",       "ё": "io",      "ж": "zh",
  "з": "z",       "и": "i",       "й": "i",       "к": "k",       "л": "l",       "м": "m",       "н": "n",       "о": "o",
  "п": "p",       "р": "r",       "с": "s",       "т": "t",       "у": "u",       "ф": "f",       "х": "kh",      "ц": "ts",
  "ч": "ch",      "ш": "sh",      "щ": "shch",    "ъ": "",        "ы": "y",       "ь": "'",       "э": "e",       "ю": "iu",
  "я": "ia",      

  // (se) - Northern Sami
  "á": "a",       "č": "c",       "đ": "d",       "ŋ": "NG",      "š": "s",       "ŧ": "t",       "ž": "z",       

  // (sg) - Sango
  "â": "a",       "ä": "a",       "ê": "e",       "ë": "e",       "î": "i",       "ï": "i",       "ô": "o",       "ö": "o",
  "ù": "u",       "û": "u",       "ü": "u",       

  // (si) - Sinhala
  "අ": "a",       "ආ": "aa",      "ඇ": "ae",      "ඈ": "aae",     "ඉ": "i",       "ඊ": "ii",      "උ": "u",       "ඌ": "uu",
  "ඍ": "R",       "එ": "e",       "ඒ": "ee",      "ඓ": "ai",      "ඔ": "o",       "ඕ": "oo",      "ඖ": "au",      "ං": "N",
  "ඃ": "H",        "ක": "k",       "ඛ": "kh",      "ග": "g",       "ඝ": "gh",      "ඞ": "ng",      "ඟ": "nng",     "ච": "c",
  "ඡ": "ch",      "ජ": "j",       "ඣ": "jh",      "ඥ": "jny",     "ඤ": "ny",      "ට": "tt",      "ඨ": "tth",     "ඩ": "dd",
  "ඪ": "ddh",     "ණ": "nn",      "ඬ": "nndd",    "ත": "t",       "ථ": "th",      "ද": "d",       "ධ": "dh",      "න": "n",
  "ඳ": "nd",      "ප": "p",       "ඵ": "ph",      "බ": "b",       "භ": "bh",      "ම": "m",       "ඹ": "mb",      "ය": "y",
  "ර": "r",       "ල": "l",       "ව": "v",       "ශ": "sh",      "ෂ": "ss",      "ස": "s",       "හ": "h",       "ළ": "ll",
  "ෆ": "f",       "ා": "aa",       "ැ": "ae",       "ෑ": "aae",      "ෘ": "R",        "ෲ": "RR",       "ෟ": "L",        "ෙ": "e",
  "ේ": "ee",       "ෛ": "ai",       "ො": "o",        "ෝ": "oo",       "ෞ": "au",       

  // (sk) - Slovak
  "á": "a",       "ä": "a",       "č": "c",       "ď": "d",       "é": "e",       "í": "i",       "ĺ": "l",       "ľ": "l",
  "ň": "n",       "ó": "o",       "ô": "o",       "ŕ": "r",       "š": "s",       "ť": "t",       "ú": "u",       "ý": "y",
  "ž": "z",       

  // (sl) - Slovenian
  "č": "c",       "š": "s",       "ž": "z",       

  // (sq) - Albanian
  "ç": "c",       "ë": "e",       

  // (sr) - Serbian
  "а": "a",       "б": "b",       "в": "v",       "г": "g",       "д": "d",       "ђ": "dj",      "е": "e",       "ж": "zh",
  "з": "z",       "и": "i",       "ј": "j",       "к": "k",       "л": "l",       "љ": "lj",      "м": "m",       "н": "n",
  "њ": "nj",      "о": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",       "ћ": "tsh",     "у": "u",
  "ф": "f",       "х": "kh",      "ц": "ts",      "ч": "ch",      "џ": "dzh",     "ш": "sh",      

  // (sv) - Swedish
  "à": "a",       "é": "e",       "å": "a",       "ä": "a",       "ö": "o",       

  // (ta) - Tamil
  "அ": "a",       "ஆ": "aa",      "இ": "i",       "ஈ": "ii",      "உ": "u",       "ஊ": "uu",      "எ": "e",       "ஏ": "ee",
  "ஐ": "ai",      "ஒ": "o",       "ஓ": "oo",      "ஔ": "au",      "ஃ": "H",       "க": "k",       "ங": "ng",      "ச": "c",
  "ஞ": "ny",      "ட": "tt",      "ண": "nn",      "த": "t",       "ந": "n",       "ப": "p",       "ம": "m",       "ய": "y",
  "ர": "r",       "ல": "l",       "வ": "v",       "ழ": "lll",     "ள": "ll",      "ற": "rr",      "ன": "nnn",     "ஜ": "j",
  "ஷ": "ss",      "ஸ": "s",       "ஹ": "h",       "ா": "aa",       "ி": "i",        "ு": "u",        "ூ": "uu",       "ெ": "e",
  "ே": "ee",       "ை": "ai",       "ொ": "o",        "ோ": "oo",       "ௌ": "au",       

  // (te) - Telugu
  "అ": "a",       "ఆ": "aa",      "ఇ": "i",       "ఈ": "ii",      "ఉ": "u",       "ఊ": "uu",      "ఋ": "R",       "ౠ": "RR",
  "ఌ": "L",       "ౡ": "LL",      "ఎ": "e",       "ఏ": "ee",      "ఐ": "ai",      "ఒ": "o",       "ఓ": "oo",      "ఔ": "au",
  "ఁ": "N",        "ం": "N",        "ః": "H",        "క": "k",       "ఖ": "kh",      "గ": "g",       "ఘ": "gh",      "ఙ": "ng",
  "చ": "c",       "ఛ": "ch",      "జ": "j",       "ఝ": "jh",      "ఞ": "ny",      "ట": "tt",      "ఠ": "tth",     "డ": "dd",
  "ఢ": "ddh",     "ణ": "nn",      "త": "t",       "థ": "th",      "ద": "d",       "ధ": "dh",      "న": "n",       "ప": "p",
  "ఫ": "ph",      "బ": "b",       "భ": "bh",      "మ": "m",       "య": "y",       "ర": "r",       "ఱ": "rr",      "ల": "l",
  "వ": "v",       "శ": "sh",      "ష": "ss",      "స": "s",       "హ": "h",       "ళ": "ll",      "ు": "u",        "ూ": "uu",
  "ృ": "R",        "ౄ": "RR",       

  // (th) - Thai
  "ๆ": "+",       "ก": "k",       "ข": "kh",      "ฃ": "kh",      "ค": "kh",      "ฅ": "kh",      "ฆ": "kh",      "ง": "ng",
  "จ": "cch",     "ฉ": "ch",      "ช": "ch",      "ซ": "ch",      "ฌ": "ch",      "ญ": "y",       "ฎ": "d",       "ฏ": "t",
  "ฐ": "th",      "ฑ": "th",      "ฒ": "th",      "ณ": "n",       "ด": "d",       "ต": "t",       "ถ": "th",      "ท": "th",
  "ธ": "th",      "น": "n",       "บ": "b",       "ป": "p",       "ผ": "ph",      "ฝ": "f",       "พ": "ph",      "ฟ": "f",
  "ภ": "ph",      "ม": "m",       "ย": "y",       "ร": "r",       "ฤ": "R",       "ล": "l",       "ฦ": "L",       "ว": "w",
  "ศ": "s",       "ษ": "s",       "ส": "s",       "ห": "h",       "ฬ": "l",       "อ": "`",       "ฮ": "h",       "ฯ": "~",
  "ะ": "a",       "า": "aa",      "ำ": "am",      "เ": "e",       "แ": "ae",      "โ": "o",       "ใ": "ai",      "ไ": "ai",
  "ๅ": "ao",      

  // (ti) - Tigrinya
  "ሀ-ሆ": "ha-ho", "ለ-ቆ": "la-qo", "ቈ": "qwa",     "ቊ-ቍ": "qwi-qwe",       "ቐ-ቖ": "qha-qho",       "ቘ": "qhwa",    "ቚ-ቝ": "qhwi-qhwe",     "በ-ኆ": "ba-xo",
  "ኈ": "xwa",     "ኊ-ኍ": "xwi-xwe",       "ነ-ኮ": "na-ko", "ኰ": "kwa",     "ኲ-ኵ": "kwi-kwe",       "ኸ-ኾ": "kxa-kxo",       "ዀ": "kxwa",    "ዂ-ዅ": "kxwi-kxwe",
  "ወ-ዎ": "wa-wo", "ዐ-ዖ": "`a-`o", "ዘ-ዮ": "za-yo", "ደ-ዷ": "da-dwa",        "ጀ-ጎ": "ja-go", "ጐ": "gwa",     "ጒ-ጕ": "gwi-gwe",       "ጠ-ፗ": "tha-pwa",


  // (to) - Tonga (Tonga Islands)
  "á": "a",       "ā": "a",       "é": "e",       "ē": "e",       "í": "i",       "ī": "i",       "ó": "o",       "ō": "o",
  "ú": "u",       "ū": "u",       "ʻ": "`",       

  // (tr) - Turkish
  "ç": "c",       "ğ": "g",       "ı": "i",       "İ": "I",       "ö": "o",       "ş": "s",       "ü": "u",       

  // (ug) - Uighur
  "ئ": "y'",        "ا": "",  "ە": "ae",        "ب": "b", "پ": "p", "ت": "t", "ج": "j", "چ": "ch",
  "خ": "kh",        "د": "d", "ر": "r", "ز": "z", "ژ": "j", "س": "s", "ش": "sh",        "غ": "G",
  "ف": "f", "ق": "q", "ك": "k", "گ": "g", "ڭ": "ng",        "ل": "l", "م": "m", "ن": "n",
  "ھ": "h", "و": "w", "ۇ": "u", "ۆ": "oe",        "ۈ": "yu",        "ۋ": "v", "ې": "",  "ى": "~",
  "ي": "y", 

  // (uk) - Ukrainian
  "ʼ": "'",       "а": "a",       "б": "b",       "в": "v",       "г": "g",       "ґ": "g'",      "д": "d",       "е": "e",
  "є": "ie",      "ж": "zh",      "з": "z",       "и": "i",       "і": "i",       "ї": "yi",      "й": "i",       "к": "k",
  "л": "l",       "м": "m",       "н": "n",       "о": "o",       "п": "p",       "р": "r",       "с": "s",       "т": "t",
  "у": "u",       "ф": "f",       "х": "kh",      "ц": "ts",      "ч": "ch",      "ш": "sh",      "щ": "shch",    "ь": "'",
  "ю": "iu",      "я": "ia",      

  // (ur) - Urdu
  "ا": "",  "أ": "'", "آ": "a", "ب": "b", "پ": "p", "ت": "t", "ٹ": "tt",        "ث": "th",
  "ج": "j", "چ": "ch",        "ح": "H", "خ": "kh",        "د": "d", "ڈ": "dd",        "ذ": "dh",        "ر": "r",
  "ڑ": "rr",        "ز": "z", "ژ": "j", "س": "s", "ش": "sh",        "ص": "S", "ض": "D", "ط": "T",
  "ظ": "Z", "ع": "`", "غ": "G", "ف": "f", "ق": "q", "ک": "kh",        "گ": "g", "ل": "l",
  "م": "m", "ن": "n", "ں": "N", "و": "w", "ؤ": "w'",        "ہ": "h", "ۂ": "H", "ھ": "h",
  "ء": "",  "ی": "y", "ئ": "y'",        "ے": "y", "ة": "@", "ه": "h", 

  // (vi) - Vietnamese
  "à": "a",       "ả": "a",       "ã": "a",       "á": "a",       "ạ": "a",       "ă": "a",       "ằ": "a",       "ẳ": "a",
  "ẵ": "a",       "ắ": "a",       "ặ": "a",       "â": "a",       "ầ": "a",       "ẩ": "a",       "ẫ": "a",       "ấ": "a",
  "ậ": "a",       "đ": "d",       "è": "e",       "ẻ": "e",       "ẽ": "e",       "é": "e",       "ẹ": "e",       "ê": "e",
  "ề": "e",       "ể": "e",       "ễ": "e",       "ế": "e",       "ệ": "e",       "ì": "i",       "ỉ": "i",       "ĩ": "i",
  "í": "i",       "ị": "i",       "ò": "o",       "ỏ": "o",       "õ": "o",       "ó": "o",       "ọ": "o",       "ô": "o",
  "ồ": "o",       "ổ": "o",       "ỗ": "o",       "ố": "o",       "ộ": "o",       "ơ": "o",       "ờ": "o",       "ở": "o",
  "ỡ": "o",       "ớ": "o",       "ợ": "o",       "ù": "u",       "ủ": "u",       "ũ": "u",       "ú": "u",       "ụ": "u",
  "ư": "u",       "ừ": "u",       "ử": "u",       "ữ": "u",       "ứ": "u",       "ự": "u",       "ỳ": "y",       "ỷ": "y",
  "ỹ": "y",       "ý": "y",       "ỵ": "y",       

  // (yi) - Yiddish
  "א": "",  "ב": "b", "ג": "g", "ד": "d", "ה": "h", "ו": "v", "ז": "z", "ח": "kh",
  "ט": "t", "י": "y", "כ": "k", "ך": "k", "ל": "l", "מ": "m", "ם": "m", "נ": "n",
  "ן": "n", "ס": "s", "ע": "`", "ף": "p", "צ": "ts",        "ץ": "ts",        "ק": "q", "ר": "r",
  "ש": "sh",        "ת": "t", 

  // (yo) - Yoruba
  "á": "a",       "à": "a",       "é": "e",       "è": "e",       "ẹ": "e",       "í": "i",       "ì": "i",       "ó": "o",
  "ò": "o",       "ọ": "o",       "ṣ": "s",       "ú": "u",       "ù": "u",       

  // (zh) - Chinese
  "一": "Yi ",    "丁": "Ding ",  "七": "Qi ",    "万-与": "Mo -Yu ",     "丑": "Chou ",  "专": "Zhuan ", "且": "Qie ",   "世": "Shi ",
  "丘-业": "Qiu -Ye ",    "东": "Dong ",  "丝": "Si ",    "丢": "Diu ",   "两": "Liang ", "严": "Yan ",   "丧": "Sang ",  "个": "Ge ",
  "中": "Zhong ", "丰": "Feng ",  "串": "Chuan ", "临": "Lin ",   "丸-主": "Wan -Zhu ",   "丽": "Li ",    "举": "Ju ",    "乃": "Nai ",
  "久": "Jiu ",   "么": "Yao ",   "义": "Yi ",    "之-乐": "Zhi -Le ",    "乔": "Qiao ",  "乖": "Guai ",  "乘": "Cheng ", "乙": "Yi ",
  "九": "Jiu ",   "也-乡": "Ye -Xiang ",  "书": "Shu ",   "买": "Mai ",   "乱": "Luan ",  "乾": "Gan ",   "了": "Liao ",  "予": "Yu ",
  "争": "Zheng ", "事": "Shi ",   "二": "Er ",    "于": "Yu ",    "亏": "Yu ",    "云": "Yun ",   "互": "Hu ",    "五": "Wu ",
  "井": "Jing ",  "亚": "Ya ",    "些": "Xie ",   "亡": "Wang ",  "交-亨": "Jiao -Heng ", "享": "Xiang ", "京": "Jing ",  "亮": "Liang ",
  "亲": "Qin ",   "人": "Ren ",   "亿-仁": "Yi -Ren ",    "仅": "Jin ",   "仇": "Chou ",  "今": "Jin ",   "介": "Jie ",   "仍": "Reng ",
  "从": "Cong ",  "仔": "Zi ",    "他": "Ta ",    "付": "Fu ",    "仙": "Xian ",  "代-以": "Dai -Yi ",    "仪": "Yi ",    "们": "Men ",
  "仰": "Yang ",  "仲": "Zhong ", "件": "Jian ",  "价": "Jie ",   "任": "Ren ",   "份": "Fen ",   "仿": "Fang ",  "企": "Qi ",
  "伊": "Yi ",    "伍": "Wu ",    "伏-休": "Fu -Xiu ",    "众-会": "Zhong -Hui ", "伟": "Wei ",   "传": "Chuan ", "伤": "Shang ", "伦": "Lun ",
  "伯": "Bo ",    "估": "Gu ",    "伴": "Ban ",   "伸": "Shen ",  "似": "Si ",    "伽": "Jia ",   "但": "Dan ",   "位-佑": "Wei -You ",
  "体": "Ti ",    "何": "He ",    "余": "Yu ",    "佛": "Fo ",    "作": "Zuo ",   "你": "Ni ",    "佤": "Wa ",    "佩": "Pei ",
  "佳": "Jia ",   "使": "Shi ",   "例": "Li ",    "供": "Gong ",  "依": "Yi ",    "侠": "Xia ",   "侦-侨": "Zhen -Qiao ", "侬": "Nong ",
  "侯": "Hou ",   "侵": "Qin ",   "便": "Bian ",  "促": "Cu ",    "俄": "E ",     "俊": "Jun ",   "俗": "Su ",    "保": "Bao ",
  "信": "Xin ",   "俩": "Lia ",   "修": "Xiu ",   "俱": "Ju ",    "俾": "Bi ",    "倍": "Bei ",   "倒": "Dao ",   "候": "Hou ",
  "倚": "Yi ",    "借": "Jie ",   "倦": "Juan ",  "值": "Zhi ",   "倾": "Qing ",  "假": "Jia ",   "偌": "Ruo ",   "偏": "Pian ",
  "做": "Zuo ",   "停": "Ting ",  "健": "Jian ",  "偶": "Ou ",    "偷": "Tou ",   "储": "Chu ",   "催": "Cui ",   "傲": "Ao ",
  "傻": "Sha ",   "像": "Xiang ", "僧": "Seng ",  "儒": "Ru ",    "儿": "Er ",    "允": "Yun ",   "元-兆": "Yuan -Zhao ", "先": "Xian ",
  "光": "Guang ", "克": "Ke ",    "免": "Mian ",  "兑": "Dui ",   "兔": "Tu ",    "党": "Dang ",  "入": "Ru ",    "全": "Quan ",
  "八-兮": "Ba -Xi ",     "兰": "Lan ",   "共": "Gong ",  "关-兹": "Guan -Zi ",   "养-兽": "Yang -Shou ", "内": "Nei ",   "冈": "Gang ",  "册": "Ce ",
  "再": "Zai ",   "冒": "Mou ",   "写": "Xie ",   "军": "Jun ",   "农": "Nong ",  "冠": "Guan ",  "冬": "Dong ",  "冰": "Bing ",
  "冲": "Chong ", "决": "Jue ",   "况": "Kuang ", "冷": "Leng ",  "准": "Zhun ",  "凌": "Ling ",  "减": "Jian ",  "凝": "Ning ",
  "几": "Ji ",    "凡": "Fan ",   "凤": "Feng ",  "凭": "Ping ",  "凯": "Kai ",   "凰": "Huang ", "出": "Chu ",   "击": "Ji ",
  "函": "Han ",   "刀": "Dao ",   "分": "Fen ",   "切": "Qie ",   "刊": "Kan ",   "刑": "Xing ",  "划": "Hua ",   "列-创": "Lie -Chuang ",
  "初": "Chu ",   "判": "Pan ",   "利": "Li ",    "别": "Bie ",   "到": "Dao ",   "制-券": "Zhi -Quan ",  "刺": "Ci ",    "刻": "Ke ",
  "剂": "Ji ",    "前": "Qian ",  "剑": "Jian ",  "剧": "Ju ",    "剩": "Sheng ", "剪": "Jian ",  "副": "Fu ",    "割": "Ge ",
  "力": "Li ",    "劝-务": "Quan -Wu ",   "劣": "Lie ",   "动-劫": "Dong -Jie ",  "励-劳": "Li -Lao ",    "势": "Shi ",   "勇": "Yong ",  "勉": "Mian ",
  "勋": "Xun ",   "勒": "Le ",    "勤": "Qin ",   "勾": "Gou ",   "勿": "Wu ",    "包": "Bao ",   "匆": "Cong ",  "匈": "Xiong ",
  "化": "Hua ",   "北": "Bei ",   "匙": "Chi ",   "匹-医": "Pi -Yi ",     "十": "Shi ",   "千": "Qian ",  "升": "Sheng ", "午": "Wu ",
  "半": "Ban ",   "华": "Hua ",   "协": "Xie ",   "卒": "Zu ",    "卓": "Zhuo ",  "单-南": "Dan -Nan ",   "博": "Bo ",    "占-卢": "Zhan -Lu ",
  "卫": "Wei ",   "卯-危": "Mao -Wei ",   "即": "Ji ",    "却": "Que ",   "卷": "Juan ",  "厂": "Han ",   "厄-历": "E -Li ",      "厉": "Li ",
  "压-厍": "Ya -She ",    "厚": "Hou ",   "原": "Yuan ",  "去": "Qu ",    "县": "Xian ",  "参": "Can ",   "又-反": "You -Fan ",   "发": "Fa ",
  "叔": "Shu ",   "取-叙": "Qu -Xu ",     "口-另": "Kou -Ling ",  "只-叭": "Zhi -Ba ",    "可": "Ke ",    "台": "Tai ",   "史": "Shi ",   "右": "You ",
  "叶-叹": "Xie -Tan ",   "吃": "Chi ",   "各": "Ge ",    "合-吊": "He -Diao ",   "同-后": "Tong -Hou ",  "吐": "Tu ",    "向": "Xiang ", "吓": "Xia ",
  "吗": "Ma ",    "君": "Jun ",   "吝": "Lin ",   "吟": "Yin ",   "否": "Fou ",   "吧": "Ba ",    "含": "Han ",   "听": "Ting ",
  "启": "Qi ",    "吵": "Chao ",  "吸": "Xi ",    "吹": "Chui ",  "吻": "Wen ",   "吾": "Wu ",    "呀": "Ya ",    "呆": "Ai ",
  "呈": "Cheng ", "告": "Gao ",   "呐": "Ne ",    "员": "Yuan ",  "呜": "Wu ",    "呢": "Ni ",    "呦": "You ",   "周": "Zhou ",
  "味": "Wei ",   "呵": "He ",    "呼": "Hu ",    "命": "Ming ",  "和": "He ",    "咖": "Ka ",    "咦-咨": "Yi -Zi ",     "咪": "Mi ",
  "咬": "Yao ",   "咯": "Ge ",    "咱": "Zan ",   "哀": "Ai ",    "品": "Pin ",   "哇-哉": "Wa -Zai ",    "响": "Xiang ", "哎": "Ai ",
  "哟": "Yo ",    "哥": "Ge ",    "哦": "E ",     "哩": "Li ",    "哪": "Na ",    "哭": "Ku ",    "哲": "Zhe ",   "唉": "Ai ",
  "唐": "Tang ",  "唤": "Huan ",  "唬": "Hu ",    "售": "Shou ",  "唯": "Wei ",   "唱": "Chang ", "唷": "Yo ",    "商": "Shang ",
  "啊": "A ",     "啡": "Pei ",   "啥": "Sha ",   "啦": "La ",    "啪": "Pa ",    "喀": "Ke ",    "喂": "Wei ",   "善": "Shan ",
  "喇": "La ",    "喊": "Han ",   "喏": "Re ",    "喔": "Wo ",    "喜": "Xi ",    "喝": "He ",    "喵": "Miao ",  "喷": "Pen ",
  "喻": "Yu ",    "嗒": "Ta ",    "嗨": "Hai ",   "嗯": "Ng ",    "嘉": "Jia ",   "嘛": "Ma ",    "嘴": "Zui ",   "嘻": "Xi ",
  "嘿": "Mo ",    "器": "Qi ",    "四": "Si ",    "回": "Hui ",   "因": "Yin ",   "团": "Tuan ",  "园": "Yuan ",  "困": "Kun ",
  "围": "Wei ",   "固": "Gu ",    "国": "Guo ",   "图": "Tu ",    "圆": "Yuan ",  "圈": "Quan ",  "土": "Tu ",    "圣": "Sheng ",
  "在": "Zai ",   "圭": "Gui ",   "地": "Di ",    "圳": "Zhen ",  "场": "Chang ", "圾": "Ji ",    "址": "Zhi ",   "均": "Jun ",
  "坎": "Kan ",   "坐": "Zuo ",   "坑": "Keng ",  "块": "Kuai ",  "坚-坜": "Jian -Li ",   "坡": "Po ",    "坤": "Kun ",   "坦": "Tan ",
  "坪": "Ping ",  "垂": "Chui ",  "垃": "La ",    "型": "Xing ",  "垒": "Lei ",   "埃": "Ai ",    "埋": "Mai ",   "城": "Cheng ",
  "埔": "Bu ",    "域": "Yu ",    "培": "Pei ",   "基": "Ji ",    "堂": "Tang ",  "堆": "Dui ",   "堕": "Duo ",   "堡": "Bao ",
  "堪": "Kan ",   "塑": "Su ",    "塔": "Ta ",    "塞": "Sai ",   "填": "Tian ",  "境": "Jing ",  "增": "Zeng ",  "墨": "Mo ",
  "壁": "Bi ",    "壤": "Rang ",  "士": "Shi ",   "壬": "Ren ",   "壮": "Zhuang ",        "声": "Sheng ", "处": "Chu ",   "备": "Bei ",
  "复": "Fu ",    "夏": "Xia ",   "夕": "Xi ",    "外": "Wai ",   "多": "Duo ",   "夜": "Ye ",    "够": "Gou ",   "夥": "Huo ",
  "大": "Da ",    "天-夫": "Tian -Fu ",   "央": "Yang ",  "失": "Shi ",   "头": "Tou ",   "夷-夺": "Yi -Duo ",    "奇-奉": "Qi -Feng ",   "奋": "Fen ",
  "奏": "Zou ",   "契": "Qi ",    "奔": "Ben ",   "奖": "Jiang ", "套": "Tao ",   "奥": "Ao ",    "女": "Nu ",    "奴": "Nu ",
  "奶": "Nai ",   "她": "Ta ",    "好": "Hao ",   "如": "Ru ",    "妇": "Fu ",    "妈": "Ma ",    "妖": "Yao ",   "妙": "Miao ",
  "妥": "Tuo ",   "妨": "Fang ",  "妮": "Ni ",    "妹": "Mei ",   "妻": "Qi ",    "姆": "Mu ",    "姊": "Zi ",    "始": "Shi ",
  "姐": "Jie ",   "姑": "Gu ",    "姓": "Xing ",  "委": "Wei ",   "姿": "Zi ",    "威": "Wei ",   "娃": "Wa ",    "娄": "Lou ",
  "娘": "Niang ", "娜": "Nuo ",   "娟": "Juan ",  "娱": "Yu ",    "婆": "Po ",    "婚": "Hun ",   "媒": "Mei ",   "嫁": "Jia ",
  "嫌": "Xian ",  "嫩": "Nen ",   "子": "Zi ",    "孔": "Kong ",  "孕": "Yun ",   "字-孙": "Zi -Sun ",    "孜": "Zi ",    "孝": "Xiao ",
  "孟": "Meng ",  "季": "Ji ",    "孤": "Gu ",    "学": "Xue ",   "孩": "Hai ",   "宁": "Zhu ",   "它": "Ta ",    "宇-安": "Yu -An ",
  "宋": "Song ",  "完": "Wan ",   "宏": "Hong ",  "宗-实": "Zong -Shi ",  "审-室": "Shen -Shi ",  "宪": "Xian ",  "害": "Hai ",   "宴": "Yan ",
  "家": "Jia ",   "容": "Rong ",  "宽-宿": "Kuan -Su ",   "寂": "Ji ",    "寄-寇": "Ji -Kou ",    "富": "Fu ",    "寒": "Han ",   "寝-察": "Qin -Cha ",
  "寡": "Gua ",   "寨": "Zhai ",  "寸": "Cun ",   "对": "Dui ",   "寻": "Xun ",   "导": "Dao ",   "寿": "Shou ",  "封": "Feng ",
  "射": "She ",   "将": "Jiang ", "尊": "Zun ",   "小": "Xiao ",  "少": "Shao ",  "尔": "Er ",    "尖": "Jian ",  "尘": "Chen ",
  "尚": "Shang ", "尝": "Chang ", "尤": "You ",   "就": "Jiu ",   "尺": "Chi ",   "尼-尾": "Ni -Wei ",    "局-层": "Ju -Ceng ",   "居": "Ju ",
  "屋": "Wu ",    "屏": "Ping ",  "展": "Zhan ",  "属": "Shu ",   "屠": "Tu ",    "山": "Shan ",  "岁": "Sui ",   "岂": "Qi ",
  "岗": "Gang ",  "岘": "Xian ",  "岚": "Lan ",   "岛": "Dao ",   "岳": "Yue ",   "岸": "An ",    "峡": "Xia ",   "峰": "Feng ",
  "崇": "Chong ", "崩": "Beng ",  "崴": "Wei ",   "川": "Chuan ", "州": "Zhou ",  "巡": "Xun ",   "工-巨": "Gong -Ju ",   "巫": "Wu ",
  "差": "Chai ",  "己-巴": "Ji -Ba ",     "巷": "Xiang ", "币-布": "Bi -Bu ",     "帅": "Shuai ", "师": "Shi ",   "希": "Xi ",    "帐": "Zhang ",
  "帕": "Pa ",    "帖": "Tie ",   "帝": "Di ",    "带": "Dai ",   "席": "Xi ",    "帮": "Bang ",  "常": "Chang ", "帽": "Mao ",
  "幅": "Fu ",    "幕": "Mu ",    "干-年": "Gan -Nian ",  "并": "Bing ",  "幸": "Xing ",  "幻-幽": "Huan -You ",  "广": "Yan ",   "庆": "Qing ",
  "床": "Chuang ",        "序": "Xu ",    "库-底": "Ku -Di ",     "店": "Dian ",  "庙": "Miao ",  "庚": "Geng ",  "府": "Fu ",    "庞": "Pang ",
  "废": "Fei ",   "度": "Du ",    "座": "Zuo ",   "庭": "Ting ",  "康": "Kang ",  "庸": "Yong ",  "廉": "Lian ",  "廖": "Liao ",
  "延": "Yan ",   "廷": "Ting ",  "建": "Jian ",  "开": "Kai ",   "异-弄": "Yi -Nong ",   "弊": "Bi ",    "式": "Shi ",   "引": "Yin ",
  "弗": "Fu ",    "弘": "Hong ",  "弟": "Di ",    "张": "Zhang ", "弥": "Mi ",    "弦": "Xian ",  "弯": "Wan ",   "弱": "Ruo ",
  "弹": "Dan ",   "强": "Qiang ", "归": "Gui ",   "当": "Dang ",  "录": "Lu ",    "彝": "Yi ",    "形": "Xing ",  "彩": "Cai ",
  "彬": "Bin ",   "彭": "Peng ",  "彰": "Zhang ", "影": "Ying ",  "彷": "Pang ",  "役": "Yi ",    "彻": "Che ",   "彼": "Bi ",
  "往": "Wang ",  "征": "Zheng ", "径": "Jing ",  "待": "Dai ",   "很": "Hen ",   "律": "Lu ",    "後": "Hou ",   "徐": "Xu ",
  "徒": "Tu ",    "得": "De ",    "循": "Xun ",   "微": "Wei ",   "徵": "Zheng ", "德": "De ",    "心": "Xin ",   "必": "Bi ",
  "忆": "Yi ",    "忌": "Ji ",    "忍": "Ren ",   "志-忙": "Zhi -Mang ",  "忠": "Zhong ", "忧": "You ",   "快": "Kuai ",  "念": "Nian ",
  "忽": "Hu ",    "怀": "Huai ",  "态": "Tai ",   "怎": "Zen ",   "怒": "Nu ",    "怕": "Pa ",    "怖": "Bu ",    "思": "Si ",
  "怡": "Yi ",    "急": "Ji ",    "性": "Xing ",  "怨": "Yuan ",  "怪": "Guai ",  "总": "Zong ",  "恋": "Lian ",  "恐": "Kong ",
  "恢": "Hui ",   "恨": "Hen ",   "恩": "En ",    "恭": "Gong ",  "息": "Xi ",    "恰": "Qia ",   "恶": "E ",     "恼": "Nao ",
  "悄": "Qiao ",  "悉": "Xi ",    "悔": "Hui ",   "悟": "Wu ",    "悠": "You ",   "患": "Huan ",  "您": "Nin ",   "悲": "Bei ",
  "情": "Qing ",  "惑": "Huo ",   "惜": "Xi ",    "惠": "Hui ",   "惧": "Ju ",    "惨": "Can ",   "惯": "Guan ",  "想": "Xiang ",
  "惹": "Re ",    "愁": "Chou ",  "愈": "Yu ",    "愉": "Yu ",    "意": "Yi ",    "愚": "Yu ",    "感": "Gan ",   "愧": "Kui ",
  "慈": "Ci ",    "慎": "Shen ",  "慕": "Mu ",    "慢": "Man ",   "慧": "Hui ",   "慰": "Wei ",   "憾": "Han ",   "懂": "Dong ",
  "懒": "Lan ",   "戈": "Ge ",    "戊": "Wu ",    "戌": "Xu ",    "戏-戒": "Xi -Jie ",    "或": "Huo ",   "战": "Zhan ",  "截": "Jie ",
  "戴": "Dai ",   "户": "Hu ",    "房-扁": "Fang -Bian ", "扇": "Shan ",  "手": "Shou ",  "才": "Cai ",   "扎": "Zha ",   "扑": "Bu ",
  "打": "Da ",    "托": "Tuo ",   "扣": "Kou ",   "执": "Zhi ",   "扩": "Kuo ",   "扫-扯": "Sao -Che ",   "批": "Pi ",    "找-技": "Zhao -Ji ",
  "抄": "Chao ",  "把": "Ba ",    "抑": "Yi ",    "抓": "Zhua ",  "投": "Tou ",   "抗": "Kang ",  "折": "Zhe ",   "抢": "Qiang ",
  "护": "Hu ",    "报": "Bao ",   "披": "Pi ",    "抬": "Tai ",   "抱": "Bao ",   "抵": "Di ",    "抹": "Mo ",    "抽": "Chou ",
  "担": "Dan ",   "拆": "Chai ",  "拉": "La ",    "拍": "Pai ",   "拒": "Ju ",    "拔": "Ba ",    "拖": "Tuo ",   "拘": "Ju ",
  "招": "Zhao ",  "拜": "Bai ",   "拟": "Ni ",    "拥": "Yong ",  "拦": "Lan ",   "拨": "Bo ",    "择": "Ze ",    "括": "Gua ",
  "拳": "Quan ",  "拷": "Kao ",   "拼": "Pin ",   "拾": "Shi ",   "拿": "Na ",    "持": "Chi ",   "指": "Zhi ",   "按": "An ",
  "挑": "Tiao ",  "挖": "Wa ",    "挝": "Zhua ",  "挡": "Dang ",  "挤": "Ji ",    "挥": "Hui ",   "挪": "Nuo ",   "振": "Zhen ",
  "挺": "Ting ",  "捉": "Zhuo ",  "捐": "Juan ",  "捕": "Bu ",    "损": "Sun ",   "捡": "Jian ",  "换": "Huan ",  "据": "Ju ",
  "捷": "Jie ",   "授": "Shou ",  "掉": "Diao ",  "掌": "Zhang ", "排": "Pai ",   "探": "Tan ",   "接": "Jie ",   "控-措": "Kong -Cuo ",
  "掸": "Dan ",   "描": "Miao ",  "提": "Ti ",    "插": "Cha ",   "握": "Wo ",    "援": "Yuan ",  "搜": "Sou ",   "搞": "Gao ",
  "搬": "Ban ",   "搭": "Da ",    "摄": "She ",   "摆": "Bai ",   "摊": "Tan ",   "摔": "Shuai ", "摘": "Zhai ",  "摩": "Mo ",
  "摸": "Mo ",    "撒": "Sa ",    "撞": "Zhuang ",        "播": "Bo ",    "操": "Cao ",   "擎": "Qing ",  "擦": "Ca ",    "支": "Zhi ",
  "收": "Shou ",  "改": "Gai ",   "攻": "Gong ",  "放": "Fang ",  "政": "Zheng ", "故": "Gu ",    "效": "Xiao ",  "敌": "Di ",
  "敏": "Min ",   "救": "Jiu ",   "教": "Jiao ",  "敝": "Bi ",    "敢": "Gan ",   "散": "San ",   "敦": "Dun ",   "敬": "Jing ",
  "数": "Shu ",   "敲": "Qiao ",  "整": "Zheng ", "文": "Wen ",   "斋": "Zhai ",  "斐": "Fei ",   "斗": "Dou ",   "料": "Liao ",
  "斜": "Xie ",   "斥": "Chi ",   "断": "Duan ",  "斯": "Si ",    "新": "Xin ",   "方": "Fang ",  "於": "Yu ",    "施": "Shi ",
  "旁": "Pang ",  "旅": "Lu ",    "旋": "Xuan ",  "族": "Zu ",    "旗": "Qi ",    "无": "Wu ",    "既": "Ji ",    "日-早": "Ri -Zao ",
  "旭": "Xu ",    "时": "Shi ",   "旺": "Wang ",  "昂": "Ang ",   "昆": "Kun ",   "昌": "Chang ", "明": "Ming ",  "昏": "Hun ",
  "易": "Yi ",    "星": "Xing ",  "映": "Ying ",  "春": "Chun ",  "昨": "Zuo ",   "昭": "Zhao ",  "是": "Shi ",   "显": "Xian ",
  "晃": "Huang ", "晋": "Jin ",   "晒": "Shai ",  "晓": "Xiao ",  "晚": "Wan ",   "晨": "Chen ",  "普": "Pu ",    "景": "Jing ",
  "晴": "Qing ",  "晶": "Jing ",  "智": "Zhi ",   "暂": "Zan ",   "暑": "Shu ",   "暖": "Nuan ",  "暗": "An ",    "暮": "Mu ",
  "暴": "Bao ",   "曰": "Yue ",   "曲": "Qu ",    "更": "Geng ",  "曹": "Cao ",   "曼": "Man ",   "曾-最": "Ceng -Zui ",  "月": "Yue ",
  "有": "You ",   "朋": "Peng ",  "服": "Fu ",    "朗": "Lang ",  "望": "Wang ",  "朝": "Zhao ",  "期": "Qi ",    "木": "Mu ",
  "未-札": "Wei -Zha ",   "术": "Zhu ",   "朱": "Zhu ",   "朵": "Duo ",   "机": "Ji ",    "杀": "Sha ",   "杂": "Za ",    "权": "Quan ",
  "杉": "Shan ",  "李": "Li ",    "材": "Cai ",   "村": "Cun ",   "杜": "Du ",    "束": "Shu ",   "条": "Tiao ",  "来": "Lai ",
  "杨": "Yang ",  "杯": "Bei ",   "杰": "Jie ",   "松": "Song ",  "板": "Ban ",   "极": "Ji ",    "构": "Gou ",   "析": "Xi ",
  "林": "Lin ",   "果": "Guo ",   "枝": "Zhi ",   "枢": "Shu ",   "枪": "Qiang ", "枫": "Feng ",  "架": "Jia ",   "柏": "Bo ",
  "某": "Mou ",   "染": "Ran ",   "柔": "Rou ",   "查": "Cha ",   "柬": "Jian ",  "柯": "Ke ",    "柳": "Liu ",   "柴": "Chai ",
  "标": "Biao ",  "栋": "Dong ",  "栏": "Lan ",   "树": "Shu ",   "校": "Xiao ",  "样-根": "Yang -Gen ",  "格": "Ge ",    "桃": "Tao ",
  "框": "Kuang ", "案": "An ",    "桌": "Zhuo ",  "桑": "Sang ",  "档": "Dang ",  "桥": "Qiao ",  "梁": "Liang ", "梅": "Mei ",
  "梦": "Meng ",  "梯": "Ti ",    "械": "Jie ",   "梵": "Fan ",   "检": "Jian ",  "棉": "Mian ",  "棋": "Qi ",    "棒": "Bang ",
  "棚": "Peng ",  "森": "Sen ",   "椅": "Yi ",    "植": "Zhi ",   "椰": "Ye ",    "楚": "Chu ",   "楼": "Lou ",   "概": "Gai ",
  "榜": "Bang ",  "模": "Mo ",    "樱": "Ying ",  "檀": "Tan ",   "欠-欣": "Qian -Xin ",  "欧": "Ou ",    "欲": "Yu ",    "欺": "Qi ",
  "款": "Kuan ",  "歉": "Qian ",  "歌": "Ge ",    "止-武": "Zhi -Wu ",    "歪": "Wai ",   "死": "Si ",    "殊": "Shu ",   "残": "Can ",
  "段": "Duan ",  "毅": "Yi ",    "母": "Mu ",    "每": "Mei ",   "毒": "Du ",    "比": "Bi ",    "毕": "Bi ",    "毛": "Mao ",
  "毫": "Hao ",   "氏": "Shi ",   "民": "Min ",   "气": "Qi ",    "氛": "Fen ",   "水": "Shui ",  "永": "Yong ",  "求": "Qiu ",
  "汇": "Hui ",   "汉": "Yi ",    "汗": "Han ",   "汝": "Ru ",    "江-污": "Jiang -Wu ",  "汤": "Tang ",  "汪": "Wang ",  "汶": "Wen ",
  "汽": "Qi ",    "沃": "Wo ",    "沈": "Chen ",  "沉": "Chen ",  "沙": "Sha ",   "沟": "Gou ",   "没": "Mei ",   "沧": "Cang ",
  "河": "He ",    "油": "You ",   "治": "Zhi ",   "沿": "Yan ",   "泉": "Quan ",  "泊": "Bo ",    "法": "Fa ",    "泛": "Fan ",
  "泡-泣": "Pao -Qi ",    "泥": "Ni ",    "注": "Zhu ",   "泰": "Tai ",   "泳": "Yong ",  "泽": "Ze ",    "洋": "Yang ",  "洗": "Xi ",
  "洛": "Luo ",   "洞": "Dong ",  "津": "Jin ",   "洪": "Hong ",  "洲": "Zhou ",  "活": "Huo ",   "洽": "Qia ",   "派": "Pai ",
  "流": "Liu ",   "浅": "Qian ",  "测": "Ce ",    "济": "Ji ",    "浏": "Liu ",   "浑": "Hun ",   "浓": "Nong ",  "浙": "Zhe ",
  "浦": "Pu ",    "浩": "Hao ",   "浪": "Lang ",  "浮": "Fu ",    "浴": "Yu ",    "海": "Hai ",   "涅": "Nie ",   "消": "Xiao ",
  "涉": "She ",   "涛": "Tao ",   "涨": "Zhang ", "涯": "Ya ",    "液": "Ye ",    "涵": "Han ",   "淋": "Lin ",   "淑": "Shu ",
  "淘": "Tao ",   "淡": "Dan ",   "深": "Shen ",  "混": "Hun ",   "添": "Tian ",  "清": "Qing ",  "渐": "Jian ",  "渡": "Du ",
  "渣": "Zha ",   "温": "Wen ",   "港": "Gang ",  "渴": "Ke ",    "游": "You ",   "湖": "Hu ",    "湾": "Wan ",   "源": "Yuan ",
  "溜": "Liu ",   "溪": "Xi ",    "滋": "Zi ",    "滑": "Hua ",   "满": "Man ",   "滥": "Lan ",   "滨": "Bin ",   "滴": "Di ",
  "漂": "Piao ",  "漏": "Lou ",   "演": "Yan ",   "漠": "Mo ",    "漫": "Man ",   "潘": "Pan ",   "潜": "Qian ",  "潮": "Chao ",
  "澎": "Peng ",  "澳": "Ao ",    "激": "Ji ",    "灌": "Guan ",  "火": "Huo ",   "灭": "Mie ",   "灯": "Deng ",  "灰": "Hui ",
  "灵": "Ling ",  "灿": "Can ",   "炉": "Lu ",    "炎": "Yan ",   "炮": "Pao ",   "炸": "Zha ",   "点": "Dian ",  "烂": "Lan ",
  "烈": "Lie ",   "烤": "Kao ",   "烦": "Fan ",   "烧": "Shao ",  "热": "Re ",    "焦": "Jiao ",  "然": "Ran ",   "煌": "Huang ",
  "煞": "Sha ",   "照": "Zhao ",  "煮": "Zhu ",   "熊": "Xiong ", "熟": "Shou ",  "燃": "Ran ",   "燕": "Yan ",   "爆": "Bao ",
  "爪": "Zhua ",  "爬": "Pa ",    "爱": "Ai ",    "爵-爸": "Jue -Ba ",    "爽": "Shuang ",        "片": "Pian ",  "版": "Ban ",   "牌": "Pai ",
  "牙": "Ya ",    "牛": "Niu ",   "牡": "Mu ",    "牢": "Lao ",   "牧": "Mu ",    "物": "Wu ",    "牲": "Sheng ", "牵": "Qian ",
  "特": "Te ",    "牺": "Xi ",    "犯": "Fan ",   "状": "Zhuang ",        "犹": "You ",   "狂": "Kuang ", "狐": "Hu ",    "狗": "Gou ",
  "狠": "Hen ",   "独": "Du ",    "狮": "Shi ",   "狱": "Yu ",    "狼": "Lang ",  "猛": "Meng ",  "猜": "Cai ",   "猪": "Zhu ",
  "献": "Xian ",  "猴": "Hou ",   "玄": "Xuan ",  "率": "Lu ",    "玉": "Yu ",    "王": "Wang ",  "玛": "Ma ",    "玩": "Wan ",
  "玫": "Mei ",   "环": "Huan ",  "现": "Xian ",  "玲": "Ling ",  "玻": "Bo ",    "珀": "Po ",    "珊": "Shan ",  "珍": "Zhen ",
  "珠": "Zhu ",   "班": "Ban ",   "球": "Qiu ",   "理": "Li ",    "琊": "Ye ",    "琪": "Qi ",    "琳": "Lin ",   "琴": "Qin ",
  "琼": "Qiong ", "瑙": "Nao ",   "瑜": "Yu ",    "瑞": "Rui ",   "瑟": "Se ",    "瑰": "Gui ",   "瑶": "Yao ",   "璃": "Li ",
  "瓜": "Gua ",   "瓦": "Wa ",    "瓶": "Ping ",  "甘": "Gan ",   "甚": "Shen ",  "甜": "Tian ",  "生": "Sheng ", "用": "Yong ",
  "田-申": "Tian -Shen ", "电": "Dian ",  "男": "Nan ",   "甸": "Dian ",  "画": "Hua ",   "畅": "Chang ", "界": "Jie ",   "留": "Liu ",
  "略": "Lue ",   "番": "Fan ",   "疆": "Jiang ", "疏": "Shu ",   "疑": "Yi ",    "疗": "Liao ",  "疯": "Feng ",  "疲": "Pi ",
  "疼": "Teng ",  "疾": "Ji ",    "病": "Bing ",  "痕": "Hen ",   "痛": "Tong ",  "痴": "Chi ",   "癸": "Gui ",   "登": "Deng ",
  "白": "Bai ",   "百": "Bai ",   "的": "De ",    "皆": "Jie ",   "皇": "Huang ", "皮": "Pi ",    "盈": "Ying ",  "益": "Yi ",
  "监": "Jian ",  "盒": "He ",    "盖": "Gai ",   "盘": "Pan ",   "盛": "Sheng ", "盟": "Meng ",  "目": "Mu ",    "直": "Zhi ",
  "相": "Xiang ", "盼": "Pan ",   "盾": "Dun ",   "省": "Sheng ", "眉": "Mei ",   "看": "Kan ",   "真": "Zhen ",  "眠": "Mian ",
  "眼": "Yan ",   "着": "Zhao ",  "睛": "Jing ",  "睡": "Shui ",  "督": "Du ",    "瞧": "Qiao ",  "矛": "Mao ",   "矣": "Yi ",
  "知": "Zhi ",   "短": "Duan ",  "石": "Shi ",   "矶": "Ji ",    "码": "Ma ",    "砂": "Sha ",   "砍": "Kan ",   "研": "Yan ",
  "破": "Po ",    "础": "Chu ",   "硕": "Shuo ",  "硬": "Ying ",  "确": "Que ",   "碍": "Ai ",    "碎": "Sui ",   "碗": "Wan ",
  "碟": "Die ",   "碧": "Bi ",    "碰": "Peng ",  "磁": "Ci ",    "磅": "Bang ",  "磨": "Mo ",    "示": "Shi ",   "礼": "Li ",
  "社": "She ",   "祖": "Zu ",    "祚": "Zuo ",   "祝": "Zhu ",   "神": "Shen ",  "祥": "Xiang ", "票": "Piao ",  "祯": "Zhen ",
  "祸": "Huo ",   "禁": "Jin ",   "禅": "Shan ",  "福": "Fu ",    "离": "Chi ",   "秀": "Xiu ",   "私": "Si ",    "秋": "Qiu ",
  "种": "Chong ", "科": "Ke ",    "秒": "Miao ",  "秘": "Mi ",    "租": "Zu ",    "秤": "Cheng ", "秦": "Qin ",   "秩": "Zhi ",
  "积": "Ji ",    "称": "Cheng ", "移": "Yi ",    "稀": "Xi ",    "程": "Cheng ", "稍": "Shao ",  "税": "Shui ",  "稣": "Su ",
  "稳": "Wen ",   "稿": "Gao ",   "穆": "Mu ",    "究": "Jiu ",   "穷": "Qiong ", "穹": "Qiong ", "空": "Kong ",  "穿": "Chuan ",
  "突": "Tu ",    "窗": "Chuang ",        "窝": "Wo ",    "立": "Li ",    "站": "Zhan ",  "竞-章": "Jing -Zhang ",        "童": "Tong ",  "端": "Duan ",
  "竹": "Zhu ",   "笑": "Xiao ",  "笔": "Bi ",    "笛": "Di ",    "符": "Fu ",    "笨": "Ben ",   "第": "Di ",    "等": "Deng ",
  "筋": "Jin ",   "筑": "Zhu ",   "答": "Da ",    "策": "Ce ",    "筹": "Chou ",  "签": "Qian ",  "简": "Jian ",  "算": "Suan ",
  "管": "Guan ",  "箭": "Jian ",  "箱": "Xiang ", "篇": "Pian ",  "篮": "Lan ",   "簿": "Bo ",    "籍": "Ji ",    "米": "Mi ",
  "类": "Lei ",   "粉": "Fen ",   "粒": "Li ",    "粗": "Cu ",    "粤": "Yue ",   "粹": "Cui ",   "精": "Jing ",  "糊": "Hu ",
  "糕": "Gao ",   "糖": "Tang ",  "糟": "Zao ",   "系": "Xi ",    "素": "Su ",    "索": "Suo ",   "紧": "Jin ",   "紫": "Zi ",
  "累": "Lei ",   "繁": "Fan ",   "红": "Hong ",  "约": "Yue ",   "级": "Ji ",    "纪": "Ji ",    "纯": "Chun ",  "纲": "Gang ",
  "纳": "Na ",    "纵": "Zong ",  "纷": "Fen ",   "纸": "Zhi ",   "纽": "Niu ",   "线": "Xian ",  "练": "Lian ",  "组": "Zu ",
  "细-终": "Xi -Zhong ",  "绍": "Shao ",  "经": "Jing ",  "结": "Jie ",   "绕": "Rao ",   "绘": "Hui ",   "给": "Gei ",   "络": "Luo ",
  "绝": "Jue ",   "统": "Tong ",  "继": "Ji ",    "绩": "Ji ",    "绪": "Xu ",    "续": "Xu ",    "维": "Wei ",   "绵": "Mian ",
  "综": "Zong ",  "绿": "Lu ",    "缅": "Mian ",  "缓": "Huan ",  "编": "Bian ",  "缘": "Yuan ",  "缠": "Chan ",  "缩": "Suo ",
  "缴": "Jiao ",  "缶": "Fou ",   "缸": "Gang ",  "缺": "Que ",   "罐": "Guan ",  "网": "Wang ",  "罕": "Han ",   "罗": "Luo ",
  "罚": "Fa ",    "罢": "Ba ",    "罪": "Zui ",   "置": "Zhi ",   "署": "Shu ",   "羊": "Yang ",  "美": "Mei ",   "羞": "Xiu ",
  "群": "Qun ",   "羯": "Jie ",   "羽": "Yu ",    "翁": "Weng ",  "翅": "Chi ",   "翔": "Xiang ", "翘": "Qiao ",  "翠": "Cui ",
  "翰": "Han ",   "翻": "Fan ",   "翼": "Yi ",    "耀": "Yao ",   "老": "Lao ",   "考": "Kao ",   "者": "Zhe ",   "而": "Er ",
  "耍": "Shua ",  "耐": "Nai ",   "耗": "Hao ",   "耳": "Er ",    "耶": "Ye ",    "聊": "Liao ",  "职": "Zhi ",   "联": "Lian ",
  "聘": "Pin ",   "聚": "Ju ",    "聪": "Cong ",  "肉": "Rou ",   "肖": "Xiao ",  "肚": "Du ",    "股": "Gu ",    "肤": "Fu ",
  "肥": "Fei ",   "肩": "Jian ",  "肯": "Ken ",   "育": "Yu ",    "胁": "Xie ",   "胆": "Dan ",   "背": "Bei ",   "胎": "Tai ",
  "胖": "Pang ",  "胜": "Sheng ", "胞": "Bao ",   "胡": "Hu ",    "胶": "Xiao ",  "胸": "Xiong ", "能": "Neng ",  "脆": "Cui ",
  "脑": "Nao ",   "脱": "Tuo ",   "脸": "Lian ",  "腊": "La ",    "腐": "Fu ",    "腓": "Fei ",   "腰": "Yao ",   "腹": "Fu ",
  "腾": "Teng ",  "腿": "Tui ",   "臂": "Bi ",    "臣": "Chen ",  "自": "Zi ",    "臭": "Chou ",  "至": "Zhi ",   "致": "Zhi ",
  "舌": "She ",   "舍": "She ",   "舒": "Shu ",   "舞": "Wu ",    "舟": "Zhou ",  "航": "Hang ",  "般": "Ban ",   "舰": "Jian ",
  "船": "Chuan ", "良": "Liang ", "色": "Se ",    "艺": "Yi ",    "艾": "Ai ",    "节": "Jie ",   "芒": "Mang ",  "芝": "Zhi ",
  "芦": "Lu ",    "芬": "Fen ",   "芭": "Ba ",    "花": "Hua ",   "芳": "Fang ",  "苍": "Cang ",  "苏": "Su ",    "苗": "Miao ",
  "若": "Ruo ",   "苦": "Ku ",    "英": "Ying ",  "茂": "Mao ",   "范": "Fan ",   "茨": "Ci ",    "茫": "Mang ",  "茶": "Cha ",
  "草": "Cao ",   "荐": "Jian ",  "荒": "Huang ", "荣": "Rong ",  "药": "Yao ",   "荷": "He ",    "莉": "Li ",    "莎": "Sha ",
  "莪": "E ",     "莫": "Mo ",    "莱": "Lai ",   "莲": "Lian ",  "获": "Huo ",   "菜": "Cai ",   "菩": "Pu ",    "菲": "Fei ",
  "萄": "Tao ",   "萍": "Ping ",  "萤": "Ying ",  "营": "Ying ",  "萧": "Xiao ",  "萨": "Sa ",    "落": "Luo ",   "著": "Zhu ",
  "葛": "Ge ",    "葡": "Pu ",    "蒂": "Di ",    "蒋": "Jiang ", "蒙": "Meng ",  "蓉": "Rong ",  "蓝": "Lan ",   "蓬": "Peng ",
  "蔑": "Mie ",   "蔡": "Cai ",   "薄": "Bo ",    "薪": "Xin ",   "藉": "Jie ",   "藏": "Cang ",  "藤": "Teng ",  "虎": "Hu ",
  "虑": "Lu ",    "虫": "Chong ", "虹": "Hong ",  "虽": "Sui ",   "虾": "Xia ",   "蚁": "Yi ",    "蛇": "She ",   "蛋": "Dan ",
  "蛙": "Wa ",    "蛮": "Man ",   "蜂": "Feng ",  "蜜": "Mi ",    "蝶": "Die ",   "融": "Rong ",  "蟹": "Xie ",   "蠢": "Chun ",
  "血": "Xie ",   "行": "Xing ",  "街": "Jie ",   "衡": "Heng ",  "衣": "Yi ",    "补": "Bu ",    "表": "Biao ",  "袋": "Dai ",
  "被": "Bei ",   "袭": "Xi ",    "裁": "Cai ",   "裂": "Lie ",   "装": "Zhuang ",        "裕": "Yu ",    "裤": "Ku ",    "西": "Xi ",
  "要": "Yao ",   "覆": "Fu ",    "见": "Jian ",  "观": "Guan ",  "规": "Gui ",   "视": "Shi ",   "览": "Lan ",   "觉": "Jue ",
  "角": "Jiao ",  "解": "Jie ",   "言": "Yan ",   "誉": "Yu ",    "誓": "Shi ",   "警": "Jing ",  "计": "Ji ",    "订": "Ding ",
  "认": "Ren ",   "讨": "Tao ",   "让": "Rang ",  "训-记": "Xun -Ji ",    "讲": "Jiang ", "讷": "Ne ",    "许": "Xu ",    "论": "Lun ",
  "设": "She ",   "访": "Fang ",  "证": "Zheng ", "评": "Ping ",  "识": "Shi ",   "诉": "Su ",    "词": "Ci ",    "译": "Yi ",
  "试": "Shi ",   "诗": "Shi ",   "诚": "Cheng ", "话": "Hua ",   "诞": "Dan ",   "询": "Xun ",   "该": "Gai ",   "详": "Xiang ",
  "语": "Yu ",    "误": "Wu ",    "说": "Shuo ",  "请": "Qing ",  "诸": "Zhu ",   "诺": "Nuo ",   "读": "Du ",    "课": "Ke ",
  "谁": "Shui ",  "调": "Diao ",  "谅": "Liang ", "谈": "Tan ",   "谊": "Yi ",    "谋": "Mou ",   "谓": "Wei ",   "谜": "Mi ",
  "谢": "Xie ",   "谨": "Jin ",   "谱": "Pu ",    "谷": "Gu ",    "豆": "Dou ",   "象": "Xiang ", "豪": "Hao ",   "貌": "Mao ",
  "贝-负": "Bei -Fu ",    "贡-败": "Gong -Bai ",  "货-贪": "Huo -Tan ",   "购": "Gou ",   "贯": "Guan ",  "贱": "Jian ",  "贴": "Tie ",   "贵": "Gui ",
  "贸-贺": "Mao -He ",    "贼": "Zei ",   "贾": "Jia ",   "资": "Zi ",    "赋": "Fu ",    "赌": "Du ",    "赏": "Shang ", "赐": "Si ",
  "赔": "Pei ",   "赖": "Lai ",   "赚": "Zhuan ", "赛": "Sai ",   "赞": "Zan ",   "赠": "Zeng ",  "赢": "Ying ",  "赤": "Chi ",
  "赫": "He ",    "走": "Zou ",   "赵": "Zhao ",  "起": "Qi ",    "趁": "Chen ",  "超": "Chao ",  "越": "Yue ",   "趋": "Qu ",
  "趣": "Qu ",    "足": "Zu ",    "跃": "Yue ",   "跌": "Die ",   "跑": "Pao ",   "距": "Ju ",    "跟": "Gen ",   "路": "Lu ",
  "跳": "Tiao ",  "踏": "Ta ",    "踢": "Ti ",    "踩": "Cai ",   "身": "Shen ",  "躲": "Duo ",   "车": "Che ",   "轨": "Gui ",
  "轩": "Xuan ",  "转": "Zhuan ", "轮-轰": "Lun -Hong ",  "轻": "Qing ",  "载": "Zai ",   "较": "Jiao ",  "辅": "Fu ",    "辆": "Liang ",
  "辈": "Bei ",   "辉": "Hui ",   "辑": "Ji ",    "输": "Shu ",   "辛": "Xin ",   "辞": "Ci ",    "辨": "Bian ",  "辩": "Bian ",
  "辰": "Chen ",  "辱": "Ru ",    "边": "Bian ",  "达": "Da ",    "迁": "Qian ",  "迅": "Xun ",   "过": "Guo ",   "迈": "Mai ",
  "迎": "Ying ",  "运": "Yun ",   "近": "Jin ",   "返": "Fan ",   "还": "Huan ",  "这": "Zhe ",   "进-迟": "Jin -Chi ",   "迦": "Jia ",
  "迪": "Di ",    "迫": "Po ",    "述": "Shu ",   "迷": "Mi ",    "追": "Zhui ",  "退-逃": "Tui -Tao ",   "逆": "Ni ",    "选": "Xuan ",
  "逊": "Xun ",   "透": "Tou ",   "逐": "Zhu ",   "递": "Di ",    "途": "Tu ",    "通": "Tong ",  "逛": "Guang ", "逝": "Shi ",
  "速": "Su ",    "造": "Zao ",   "逢": "Feng ",  "逸": "Yi ",    "逻": "Luo ",   "逼": "Bi ",    "遇": "Yu ",    "遍": "Bian ",
  "道": "Dao ",   "遗": "Yi ",    "遭": "Zao ",   "遮": "Zhe ",   "遵": "Zun ",   "避": "Bi ",    "邀": "Yao ",   "邓": "Deng ",
  "那": "Na ",    "邦": "Bang ",  "邪": "Xie ",   "邮": "You ",   "邱": "Qiu ",   "邻": "Lin ",   "郎": "Lang ",  "郑": "Zheng ",
  "部": "Bu ",    "郭": "Guo ",   "都": "Du ",    "鄂": "E ",     "酉": "You ",   "酋": "Qiu ",   "配": "Pei ",   "酒": "Jiu ",
  "酷": "Ku ",    "酸": "Suan ",  "醉": "Zui ",   "醒": "Xing ",  "采": "Cai ",   "释": "Shi ",   "里-量": "Li -Liang ",  "金": "Jin ",
  "针": "Zhen ",  "钓": "Diao ",  "钟": "Zhong ", "钢": "Gang ",  "钦": "Qin ",   "钱": "Qian ",  "钻": "Zuan ",  "铁": "Tie ",
  "铃": "Ling ",  "铜": "Tong ",  "铢": "Zhu ",   "铭": "Ming ",  "银": "Yin ",   "铺": "Pu ",    "链": "Lian ",  "销": "Xiao ",
  "锁": "Suo ",   "锅": "Guo ",   "锋": "Feng ",  "错": "Cuo ",   "锡": "Xi ",    "锦": "Jin ",   "键": "Jian ",  "锺": "Zhong ",
  "镇": "Zhen ",  "镜": "Jing ",  "镭": "Lei ",   "长": "Chang ", "门": "Men ",   "闪": "Shan ",  "闭": "Bi ",    "问": "Wen ",
  "闰": "Run ",   "闲": "Xian ",  "间": "Jian ",  "闷": "Men ",   "闹": "Nao ",   "闻": "Wen ",   "阁": "Ge ",    "阅": "Yue ",
  "阐": "Chan ",  "阔": "Kuo ",   "队": "Dui ",   "阮": "Ruan ",  "防-阶": "Fang -Jie ",  "阻": "Zu ",    "阿": "A ",     "陀": "Tuo ",
  "附-陆": "Fu -Lu ",     "陈": "Chen ",  "降": "Jiang ", "限": "Xian ",  "院": "Yuan ",  "除": "Chu ",   "险": "Xian ",  "陪": "Pei ",
  "陵-陷": "Ling -Xian ", "隆": "Long ",  "随": "Sui ",   "隐": "Yin ",   "隔": "Ge ",    "障": "Zhang ", "难": "Nan ",   "雄-集": "Xiong -Ji ",
  "雉": "Zhi ",   "雨": "Yu ",    "雪": "Xue ",   "雯": "Wen ",   "雳": "Li ",    "零": "Ling ",  "雷": "Lei ",   "雾": "Wu ",
  "需": "Xu ",    "震": "Zhen ",  "霍": "Huo ",   "霖": "Lin ",   "露": "Lu ",    "霸": "Ba ",    "霹": "Pi ",    "青": "Qing ",
  "靖": "Jing ",  "静": "Jing ",  "非": "Fei ",   "靠": "Kao ",   "面": "Mian ",  "革": "Ge ",    "靼": "Da ",    "鞋": "Xie ",
  "鞑": "Da ",    "韦": "Wei ",   "韩": "Han ",   "音": "Yin ",   "页": "Ye ",    "顶": "Ding ",  "项-须": "Xiang -Xu ",  "顽-顿": "Wan -Dun ",
  "预": "Yu ",    "领": "Ling ",  "颇": "Po ",    "频": "Pin ",   "颗": "Ke ",    "题": "Ti ",    "额": "E ",     "风": "Feng ",
  "飘": "Piao ",  "飙": "Biao ",  "飞": "Fei ",   "食": "Shi ",   "餐": "Can ",   "饭": "Fan ",   "饮": "Yin ",   "饰": "Shi ",
  "饱": "Bao ",   "饼": "Bing ",  "馆": "Guan ",  "首": "Shou ",  "香": "Xiang ", "馨": "Xin ",   "马": "Ma ",    "驱": "Qu ",
  "驶": "Shi ",   "驻": "Zhu ",   "驾": "Jia ",   "验": "Yan ",   "骑": "Qi ",    "骗": "Pian ",  "骚": "Sao ",   "骤": "Zou ",
  "骨": "Gu ",    "高": "Gao ",   "鬼": "Gui ",   "魂": "Hun ",   "魅": "Mei ",   "魔": "Mo ",    "鱼": "Yu ",    "鲁": "Lu ",
  "鲜": "Xian ",  "鸟": "Niao ",  "鸡": "Ji ",    "鸣": "Ming ",  "鸭": "Ya ",    "鸿": "Hong ",  "鹅": "E ",     "鹤": "He ",
  "鹰": "Ying ",  "鹿": "Lu ",    "麦": "Mai ",   "麻": "Ma ",    "黄": "Huang ", "黎": "Li ",    "黑": "Hei ",   "默": "Mo ",
  "鼓": "Gu ",    "鼠": "Shu ",   "鼻": "Bi ",    "齐": "Qi ",    "齿": "Chi ",   "龄": "Ling ",  "龙": "Long ",  "龟": "Gui ",

  // Symbols
  '©':'(c)',
  '®':'(r)'

  // soft hyphen
  "\xAD": ''
};
