# ---+ Extensions
# ---++ UpdatesPlugin
# This is the configuration used by the <b>UpdatesPlugin</b>.

# **BOOLEAN LABEL="Debug"**
# This flag enables the debug mode.
$Foswiki::cfg{Plugins}{UpdatesPlugin}{Debug} = 0;

# **URL LABEL="Report URL"**
# The source URL where to get the latest version of extensions. The URL must point to a page
# that generates a list in the same format as the list generated by
# http://foswiki.org/Extensions/UpdatesPluginReport
$Foswiki::cfg{Plugins}{UpdatesPlugin}{ReportUrl} = "https://foswiki.org/Extensions/UpdatesPluginReport";

# **NUMBER LABEL="Cache Timeout"**
# Number of seconds to cache the update report for extensions. Default is 24 hours.
$Foswiki::cfg{Plugins}{UpdatesPlugin}{CacheTimeout} = 86400;

# **STRING LABEL="Exclude Extensions"**
# A list of extensions that shall not be checked for updates on foswiki.org. This setting can be used
# to prevent plugins not hosted on foswiki.org from being reported to the outside world.
$Foswiki::cfg{Plugins}{UpdatesPlugin}{ExcludeExtensions} = '';

# **URLPATH LABEL="Configure URL" CHECK='emptyok'**
# The URL of the 'configure' program used to install extensions on your Foswiki. If not configured,
# it uses the default configure script URL.
$Foswiki::cfg{Plugins}{UpdatesPlugin}{ConfigureUrl} = '';

# **STRING LABEL="Message Variable"**
# Name of message variable to set. Sensible values are BROADCASTMESSAGE or FLASHOTE. 
# This variable will be set when notifying the user about updates.
$Foswiki::cfg{Plugins}{UpdatesPlugin}{MessageVariable} = 'BROADCASTMESSAGE';

1;
