# See bottom of file for license and copyright information

package Foswiki::Configure::Checkers::Email::SmimeKeyFile;

use strict;
use warnings;

use Foswiki::Configure::Checkers::Certificate::KeyChecker ();
our @ISA = ('Foswiki::Configure::Checkers::Certificate::KeyChecker');

sub check_current_value {
    my ( $this, $reporter ) = @_;

    return unless ( $Foswiki::cfg{Email}{EnableSMIME} );
    if ( $Foswiki::cfg{Email}{SmimeCertificateFile} ) {
        return $this->ERROR("Key file must be specified")
          unless ( $Foswiki::cfg{Email}{SmimeKeyFile} );
        return $this->SUPER::validateKeys( $this->{item}->{keys},
            '{Email}{SmimeKeyPassword}', $reporter );
    }

    # Certificate file not specified, but enable-smime is set.
    # So we should be using a self-signed certificate generated by Foswiki.

    my $file = '$Foswiki::cfg{DataDir}/SmimePrivateKey.pem';
    Foswiki::Configure::Load::expandValue($file);
    $Foswiki::cfg{Email}{SelfSigned} = $file;
    unless ( -r $file ) {
        return $reporter->ERROR(
            "Self-signed certificate's private key file $file is missing");
    }

    $Foswiki::cfg{Email}{SelfSigned} = $file;

    $this->SUPER::validateKeys( '{Email}{SelfSigned}',
        '{Email}{SmimeKeyPassword}', $reporter );
    delete $Foswiki::cfg{Email}{SelfSigned};
}

1;

__END__

Foswiki - The Free and Open Source Wiki, http://foswiki.org/

Copyright (C) 2008-2015 Foswiki Contributors. Foswiki Contributors
are listed in the AUTHORS file in the root of this distribution.
NOTE: Please extend that file, not this notice.

Additional copyrights apply to some or all of the code in this
file as follows:

Copyright (C) 2000-2006 TWiki Contributors. All Rights Reserved.
TWiki Contributors are listed in the AUTHORS file in the root
of this distribution. NOTE: Please extend that file, not this notice.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version. For
more details read LICENSE in the root of this distribution.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

As per the GPL, removal of this notice is prohibited.

