# See bottom of file for license and copyright information

package Foswiki::Configure::Checkers::Email::SmimeCertificateFile;

use strict;
use warnings;

use Foswiki::Configure::Checkers::Certificate ();
our @ISA = ('Foswiki::Configure::Checkers::Certificate');

sub check_current_value {
    my ( $this, $reporter ) = @_;

    return '' unless ( $Foswiki::cfg{Email}{EnableSMIME} );
    if ( $Foswiki::cfg{Email}{SmimeCertificateFile} ) {
        $this->checkUsage( $this->{item}->{keys}, 'email', $reporter );
    }

    # File not specified, but enable-smime is set.  So we should be using a
    # self-signed certificate generated by Foswiki.

    my $file = '$Foswiki::cfg{DataDir}/SmimeCertificate.pem';
    Foswiki::Configure::Load::expandValue($file);
    unless ( -r $file ) {
        return $reporter->ERROR(
            "Self-signed certificate file $file is missing");
    }

    $Foswiki::cfg{Email}{SelfSigned} = $file;

    my @subjects =
      $this->checkUsage( '{Email}{SelfSigned}', 'email', $reporter );
    delete $Foswiki::cfg{Email}{SelfSigned};

    return unless (@subjects);

    my $subjCN    = $Foswiki::cfg{WebMasterName}  || '';
    my $subjEmail = $Foswiki::cfg{WebMasterEmail} || '';

    return $reporter->ERROR(
"{WebMasterName} and/or {WebMasterEmail} are not set, so self-signed certificate can't be valid.  Please set these values."
    ) unless ( $subjCN && $subjEmail );

    foreach my $subj (@subjects) {
        if ( $subj eq $subjCN ) {
            $subjCN = '';
        }
        elsif ( $subj eq $subjEmail ) {
            $subjEmail = '';
        }
    }
    return $reporter->ERROR("Certificate subject does not include $subjCN")
      if ($subjCN);
    return $reporter->ERROR("Certificate subject does not include $subjEmail")
      if ($subjEmail);
}
1;

__END__

Foswiki - The Free and Open Source Wiki, http://foswiki.org/

Copyright (C) 2008-2015 Foswiki Contributors. Foswiki Contributors
are listed in the AUTHORS file in the root of this distribution.
NOTE: Please extend that file, not this notice.

Additional copyrights apply to some or all of the code in this
file as follows:

Copyright (C) 2000-2006 TWiki Contributors. All Rights Reserved.
TWiki Contributors are listed in the AUTHORS file in the root
of this distribution. NOTE: Please extend that file, not this notice.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version. For
more details read LICENSE in the root of this distribution.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

As per the GPL, removal of this notice is prohibited.
