<?php

return [
    'routes' => [
        'main' => [
            'mautic_core_ajax' => [
                'path'       => '/ajax',
                'controller' => 'Mautic\CoreBundle\Controller\AjaxController::delegateAjaxAction',
            ],
            'mautic_core_update' => [
                'path'       => '/update',
                'controller' => 'Mautic\CoreBundle\Controller\UpdateController::indexAction',
            ],
            'mautic_core_update_schema' => [
                'path'       => '/update/schema',
                'controller' => 'Mautic\CoreBundle\Controller\UpdateController::schemaAction',
            ],
            'mautic_core_form_action' => [
                'path'       => '/action/{objectAction}/{objectModel}/{objectId}',
                'controller' => 'Mautic\CoreBundle\Controller\FormController::executeAction',
                'defaults'   => [
                    'objectModel' => '',
                ],
            ],
            'mautic_core_file_action' => [
                'path'       => '/file/{objectAction}/{objectId}',
                'controller' => 'Mautic\CoreBundle\Controller\FileController::executeAction',
            ],
            'mautic_themes_index' => [
                'path'       => '/themes',
                'controller' => 'Mautic\CoreBundle\Controller\ThemeController::indexAction',
            ],
            'mautic_themes_action' => [
                'path'       => '/themes/{objectAction}/{objectId}',
                'controller' => 'Mautic\CoreBundle\Controller\ThemeController::executeAction',
            ],
            'mautic_core_keep_alive' => [
                'path'       => '/keep-alive',
                'controller' => 'Mautic\CoreBundle\Controller\KeepAliveController::keepAliveAction',
            ],
        ],
        'public' => [
            'mautic_js' => [
                'path'       => '/mtc.js',
                'controller' => 'Mautic\CoreBundle\Controller\JsController::indexAction',
            ],
            'mautic_base_index' => [
                'path'       => '/',
                'controller' => 'Mautic\CoreBundle\Controller\DefaultController::indexAction',
            ],
            'mautic_secure_root' => [
                'path'       => '/s',
                'controller' => 'Mautic\CoreBundle\Controller\DefaultController::redirectSecureRootAction',
            ],
            'mautic_secure_root_slash' => [
                'path'       => '/s/',
                'controller' => 'Mautic\CoreBundle\Controller\DefaultController::redirectSecureRootAction',
            ],
            'mautic_remove_trailing_slash' => [
                'path'         => '/{url}',
                'controller'   => 'Mautic\CoreBundle\Controller\CommonController::removeTrailingSlashAction',
                'method'       => 'GET',
                'requirements' => [
                    'url' => '.*/$',
                ],
            ],
        ],
        'api' => [
            'mautic_core_api_file_list' => [
                'path'       => '/files/{dir}',
                'controller' => 'Mautic\CoreBundle\Controller\Api\FileApiController::listAction',
            ],
            'mautic_core_api_file_create' => [
                'path'       => '/files/{dir}/new',
                'controller' => 'Mautic\CoreBundle\Controller\Api\FileApiController::createAction',
                'method'     => 'POST',
            ],
            'mautic_core_api_file_delete' => [
                'path'       => '/files/{dir}/{file}/delete',
                'controller' => 'Mautic\CoreBundle\Controller\Api\FileApiController::deleteAction',
                'method'     => 'DELETE',
            ],
            'mautic_core_api_theme_list' => [
                'path'       => '/themes',
                'controller' => 'Mautic\CoreBundle\Controller\Api\ThemeApiController::listAction',
            ],
            'mautic_core_api_theme_get' => [
                'path'       => '/themes/{theme}',
                'controller' => 'Mautic\CoreBundle\Controller\Api\ThemeApiController::getAction',
            ],
            'mautic_core_api_theme_create' => [
                'path'       => '/themes/new',
                'controller' => 'Mautic\CoreBundle\Controller\Api\ThemeApiController::newAction',
                'method'     => 'POST',
            ],
            'mautic_core_api_theme_delete' => [
                'path'       => '/themes/{theme}/delete',
                'controller' => 'Mautic\CoreBundle\Controller\Api\ThemeApiController::deleteAction',
                'method'     => 'DELETE',
            ],
            'mautic_core_api_stats' => [
                'path'       => '/stats/{table}',
                'controller' => 'Mautic\CoreBundle\Controller\Api\StatsApiController::listAction',
                'defaults'   => [
                    'table' => '',
                ],
            ],
        ],
    ],
    'menu' => [
        'main' => [
            'mautic.core.components' => [
                'id'        => 'mautic_components_root',
                'iconClass' => 'ri-archive-2-fill',
                'priority'  => 60,
            ],
            'mautic.core.channels' => [
                'id'        => 'mautic_channels_root',
                'iconClass' => 'ri-remote-control-fill',
                'priority'  => 40,
            ],
        ],
        'admin' => [
            'mautic.core.general' => [
                'id'        => 'mautic_general_root',
                'priority'  => 15,
            ],
            'mautic.theme.menu.index' => [
                'route'     => 'mautic_themes_index',
                'iconClass' => 'ri-pantone-line',
                'id'        => 'mautic_themes_index',
                'access'    => 'core:themes:view',
                'parent'    => 'mautic.core.general',
                'priority'  => 18,
            ],
            'mautic.core.integrations' => [
                'id'        => 'mautic_integrations_root',
                'priority'  => 15,
            ],
        ],
        'extra' => [
            'priority' => -1000,
            'items'    => [
                'name'     => 'extra',
                'children' => [],
            ],
        ],
        'profile' => [
            'priority' => -1000,
            'items'    => [
                'name'     => 'profile',
                'children' => [],
            ],
        ],
    ],
    'services' => [
        'main' => [
            'mautic.core.service.flashbag' => [
                'class'     => Mautic\CoreBundle\Service\FlashBag::class,
                'arguments' => [
                    'translator',
                    'request_stack',
                    'mautic.core.model.notification',
                ],
            ],
            'mautic.core.service.bulk_notification' => [
                'class'     => Mautic\CoreBundle\Service\BulkNotification::class,
                'arguments' => [
                    'mautic.core.model.notification',
                ],
            ],
            'mautic.core.service.local_file_adapter' => [
                'class'     => Mautic\CoreBundle\Service\LocalFileAdapterService::class,
                'arguments' => [
                    '%env(resolve:MAUTIC_EL_FINDER_PATH)%',
                ],
            ],
            'mautic.core.service.log_processor' => [
                'class'     => Mautic\CoreBundle\Monolog\LogProcessor::class,
                'tags'      => ['monolog.processor'],
            ],
        ],
        'events' => [
            'mautic.core.subscriber.router' => [
                'class'     => Mautic\CoreBundle\EventListener\RouterSubscriber::class,
                'arguments' => [
                    'router',
                    '%router.request_context.scheme%',
                    '%router.request_context.host%',
                    '%request_listener.https_port%',
                    '%request_listener.http_port%',
                    '%router.request_context.base_url%',
                ],
            ],
        ],
        'forms' => [
            'mautic.form.type.dynamic_content_filter_entry_filters' => [
                'class'     => Mautic\CoreBundle\Form\Type\DynamicContentFilterEntryFiltersType::class,
                'arguments' => [
                    'translator',
                    'mautic.lead.model.list',
                ],
                'methodCalls' => [
                    'setConnection' => [
                        'database_connection',
                    ],
                ],
            ],
        ],
        'helpers' => [
            'mautic.helper.app_version' => [
                'class' => Mautic\CoreBundle\Helper\AppVersion::class,
            ],
            'mautic.helper.twig.menu' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\MenuHelper::class,
                'arguments' => ['knp_menu.helper'],
                'alias'     => 'menu',
            ],
            'mautic.helper.twig.date' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\DateHelper::class,
                'arguments' => [
                    '%mautic.date_format_full%',
                    '%mautic.date_format_short%',
                    '%mautic.date_format_dateonly%',
                    '%mautic.date_format_timeonly%',
                    'translator',
                    'mautic.helper.core_parameters',
                ],
                'alias' => 'date',
            ],
            'mautic.helper.twig.gravatar' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\GravatarHelper::class,
                'arguments' => [
                    'mautic.helper.twig.default_avatar',
                    'mautic.helper.core_parameters',
                    'request_stack',
                ],
                'alias'     => 'gravatar',
            ],
            'mautic.helper.twig.analytics' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\AnalyticsHelper::class,
                'alias'     => 'analytics',
                'arguments' => [
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.helper.twig.config' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\ConfigHelper::class,
                'alias'     => 'config',
                'arguments' => [
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.helper.twig.mautibot' => [
                'class' => Mautic\CoreBundle\Twig\Helper\MautibotHelper::class,
                'alias' => 'mautibot',
            ],
            'mautic.helper.twig.button' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\ButtonHelper::class,
                'arguments' => [
                    'twig',
                    'translator',
                    'event_dispatcher',
                ],
                'alias' => 'buttons',
            ],
            'mautic.helper.twig.content' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\ContentHelper::class,
                'arguments' => [
                    'twig',
                    'event_dispatcher',
                ],
                'alias' => 'content',
            ],
            'mautic.helper.twig.formatter' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\FormatterHelper::class,
                'arguments' => [
                    'mautic.helper.twig.date',
                    'translator',
                ],
                'alias' => 'formatter',
            ],
            'mautic.helper.twig.version' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\VersionHelper::class,
                'arguments' => [
                    'mautic.helper.app_version',
                ],
                'alias' => 'version',
            ],
            'mautic.helper.twig.security' => [
                'class'     => Mautic\CoreBundle\Twig\Helper\SecurityHelper::class,
                'arguments' => [
                    'mautic.security',
                    'request_stack',
                    'event_dispatcher',
                    'security.csrf.token_manager',
                ],
                'alias' => 'security',
            ],
            'mautic.helper.paths' => [
                'class'     => Mautic\CoreBundle\Helper\PathsHelper::class,
                'arguments' => [
                    'mautic.helper.user',
                    'mautic.helper.core_parameters',
                    '%kernel.cache_dir%',
                    '%kernel.logs_dir%',
                    '%mautic.application_dir%',
                ],
            ],
            'mautic.helper.ip_lookup' => [
                'class'     => Mautic\CoreBundle\Helper\IpLookupHelper::class,
                'arguments' => [
                    'request_stack',
                    'doctrine.orm.entity_manager',
                    'mautic.helper.core_parameters',
                    'mautic.ip_lookup',
                ],
            ],
            'mautic.helper.user' => [
                'class'     => Mautic\CoreBundle\Helper\UserHelper::class,
                'arguments' => [
                    'security.token_storage',
                ],
            ],
            'mautic.helper.core_parameters' => [
                'class'     => Mautic\CoreBundle\Helper\CoreParametersHelper::class,
                'arguments' => [
                    'service_container',
                ],
                'serviceAlias' => 'mautic.config',
            ],
            'mautic.helper.bundle' => [
                'class'     => Mautic\CoreBundle\Helper\BundleHelper::class,
                'arguments' => [
                    '%mautic.bundles%',
                    '%mautic.plugin.bundles%',
                ],
            ],
            'mautic.helper.phone_number' => [
                'class' => Mautic\CoreBundle\Helper\PhoneNumberHelper::class,
            ],
            'mautic.helper.input_helper' => [
                'class' => Mautic\CoreBundle\Helper\InputHelper::class,
            ],
            'mautic.helper.file_uploader' => [
                'class'     => Mautic\CoreBundle\Helper\FileUploader::class,
                'arguments' => [
                    'mautic.helper.file_path_resolver',
                    'translator',
                ],
            ],
            'mautic.helper.file_path_resolver' => [
                'class'     => Mautic\CoreBundle\Helper\FilePathResolver::class,
                'arguments' => [
                    'symfony.filesystem',
                    'mautic.helper.input_helper',
                ],
            ],
            'mautic.helper.file_properties' => [
                'class' => Mautic\CoreBundle\Helper\FileProperties::class,
            ],
            'mautic.helper.trailing_slash' => [
                'class'     => Mautic\CoreBundle\Helper\TrailingSlashHelper::class,
                'arguments' => [
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.helper.token_builder' => [
                'class'     => Mautic\CoreBundle\Helper\BuilderTokenHelper::class,
                'arguments' => [
                    'mautic.security',
                    'mautic.model.factory',
                    'database_connection',
                    'mautic.helper.user',
                ],
            ],
            'mautic.helper.token_builder.factory' => [
                'class'     => Mautic\CoreBundle\Helper\BuilderTokenHelperFactory::class,
                'arguments' => [
                    'mautic.security',
                    'mautic.model.factory',
                    'database_connection',
                    'mautic.helper.user',
                ],
            ],
            'mautic.helper.maxmind_do_not_sell_download' => [
                'class'     => Mautic\CoreBundle\Helper\MaxMindDoNotSellDownloadHelper::class,
                'arguments' => [
                    '%mautic.ip_lookup_auth%',
                    'monolog.logger.mautic',
                    'mautic.native.connector',
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.helper.update_checks' => [
                'class' => Mautic\CoreBundle\Helper\PreUpdateCheckHelper::class,
            ],
        ],
        'menus' => [
            'mautic.menu.main' => [
                'alias' => 'main',
            ],
            'mautic.menu.admin' => [
                'alias'   => 'admin',
                'options' => [
                    'template' => '@MauticCore/Menu/admin.html.twig',
                ],
            ],
            'mautic.menu.extra' => [
                'alias'   => 'extra',
                'options' => [
                    'template' => '@MauticCore/Menu/extra.html.twig',
                ],
            ],
            'mautic.menu.profile' => [
                'alias'   => 'profile',
                'options' => [
                    'template' => '@MauticCore/Menu/profile_inline.html.twig',
                ],
            ],
        ],
        'other' => [
            'mautic.cache.warmer.middleware' => [
                'class'     => Mautic\CoreBundle\Cache\MiddlewareCacheWarmer::class,
                'tag'       => 'kernel.cache_warmer',
                'arguments' => [
                    '%kernel.environment%',
                ],
            ],
            /* @deprecated to be removed in Mautic 4. Use 'mautic.filesystem' instead. */
            'symfony.filesystem' => [
                'class' => Symfony\Component\Filesystem\Filesystem::class,
            ],
            'mautic.filesystem' => [
                'class' => Mautic\CoreBundle\Helper\Filesystem::class,
            ],
            'symfony.finder' => [
                'class' => Symfony\Component\Finder\Finder::class,
            ],
            // Error handler
            'mautic.core.errorhandler.subscriber' => [
                'class'     => Mautic\CoreBundle\EventListener\ErrorHandlingListener::class,
                'arguments' => [
                    'monolog.logger.mautic',
                    'monolog.logger',
                    "@=container.has('monolog.logger.chrome') ? container.get('monolog.logger.chrome') : null",
                ],
                'tag' => 'kernel.event_subscriber',
            ],

            // Configurator (used in installer and managing global config]
            'mautic.configurator' => [
                'class'     => Mautic\CoreBundle\Configurator\Configurator::class,
                'arguments' => [
                    'mautic.helper.paths',
                ],
            ],

            // System uses
            'mautic.di.env_processor.nullable' => [
                'class' => Mautic\CoreBundle\DependencyInjection\EnvProcessor\NullableProcessor::class,
                'tag'   => 'container.env_var_processor',
            ],
            'mautic.di.env_processor.int_nullable' => [
                'class' => Mautic\CoreBundle\DependencyInjection\EnvProcessor\IntNullableProcessor::class,
                'tag'   => 'container.env_var_processor',
            ],
            'mautic.di.env_processor.mauticconst' => [
                'class' => Mautic\CoreBundle\DependencyInjection\EnvProcessor\MauticConstProcessor::class,
                'tag'   => 'container.env_var_processor',
            ],
            'mautic.cipher.openssl' => [
                'class'     => Mautic\CoreBundle\Security\Cryptography\Cipher\Symmetric\OpenSSLCipher::class,
                'arguments' => ['%kernel.environment%'],
            ],
            'mautic.route_loader' => [
                'class'     => Mautic\CoreBundle\Loader\RouteLoader::class,
                'arguments' => [
                    'event_dispatcher',
                    'mautic.helper.core_parameters',
                ],
                'tag' => 'routing.loader',
            ],
            'mautic.security' => [
                'class'     => Mautic\CoreBundle\Security\Permissions\CorePermissions::class,
                'arguments' => [
                    'mautic.helper.user',
                    'translator',
                    'mautic.helper.core_parameters',
                    '%mautic.bundles%',
                    '%mautic.plugin.bundles%',
                ],
            ],
            'mautic.page.helper.factory' => [
                'class'     => Mautic\CoreBundle\Factory\PageHelperFactory::class,
                'arguments' => [
                    'request_stack',
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.translation.loader' => [
                'class'     => Mautic\CoreBundle\Loader\TranslationLoader::class,
                'arguments' => [
                    'mautic.helper.bundle',
                    'mautic.helper.paths',
                ],
                'tag'       => 'translation.loader',
                'alias'     => 'mautic',
            ],
            'mautic.tblprefix_subscriber' => [
                'class'     => Mautic\CoreBundle\EventListener\DoctrineEventsSubscriber::class,
                'tag'       => 'doctrine.event_subscriber',
                'arguments' => '%mautic.db_table_prefix%',
            ],
            'mautic.database.version.provider' => [
                'class'     => Mautic\CoreBundle\Doctrine\Provider\VersionProvider::class,
                'arguments' => ['database_connection', 'mautic.helper.core_parameters'],
            ],
            'mautic.generated.columns.provider' => [
                'class'     => Mautic\CoreBundle\Doctrine\Provider\GeneratedColumnsProvider::class,
                'arguments' => ['mautic.database.version.provider', 'event_dispatcher'],
            ],
            'mautic.generated.columns.doctrine.listener' => [
                'class'        => Mautic\CoreBundle\EventListener\DoctrineGeneratedColumnsListener::class,
                'tag'          => 'doctrine.event_listener',
                'tagArguments' => [
                    'event' => 'postGenerateSchema',
                    'lazy'  => true,
                ],
                'arguments' => [
                    'mautic.generated.columns.provider',
                    'monolog.logger.mautic',
                ],
            ],
            'mautic.exception.listener' => [
                'class'     => Mautic\CoreBundle\EventListener\ExceptionListener::class,
                'arguments' => [
                    'router',
                    'Mautic\CoreBundle\Controller\ExceptionController::showAction',
                    'monolog.logger.mautic',
                ],
                'tag'          => 'kernel.event_listener',
                'tagArguments' => [
                    'event'    => 'kernel.exception',
                    'method'   => 'onKernelException',
                    'priority' => 255,
                ],
            ],
            // Helpers
            'mautic.helper.cookie' => [
                'class'     => Mautic\CoreBundle\Helper\CookieHelper::class,
                'arguments' => [
                    '%mautic.cookie_path%',
                    '%mautic.cookie_domain%',
                    '%mautic.cookie_secure%',
                    '%mautic.cookie_httponly%',
                    'request_stack',
                ],
                'tag' => 'kernel.event_subscriber',
            ],
            'mautic.helper.cache_storage' => [
                'class'     => Mautic\CoreBundle\Helper\CacheStorageHelper::class,
                'arguments' => [
                    '"db"',
                    '%mautic.db_table_prefix%',
                    'doctrine.dbal.default_connection',
                    '%kernel.cache_dir%',
                ],
            ],
            'mautic.helper.update' => [
                'class'     => Mautic\CoreBundle\Helper\UpdateHelper::class,
                'arguments' => [
                    'mautic.helper.paths',
                    'monolog.logger.mautic',
                    'mautic.helper.core_parameters',
                    'mautic.http.client',
                    'mautic.helper.update.release_parser',
                    'mautic.helper.update_checks',
                ],
            ],
            'mautic.helper.update.release_parser' => [
                'class'     => Mautic\CoreBundle\Helper\Update\Github\ReleaseParser::class,
                'arguments' => [
                    'mautic.http.client',
                ],
            ],
            'mautic.helper.cache' => [
                'class'     => Mautic\CoreBundle\Helper\CacheHelper::class,
                'arguments' => [
                    '%kernel.cache_dir%',
                    'request_stack',
                    'mautic.helper.paths',
                    'kernel',
                ],
            ],
            'mautic.helper.theme' => [
                'class'     => Mautic\CoreBundle\Helper\ThemeHelper::class,
                'arguments' => [
                    'mautic.helper.paths',
                    'twig',
                    'translator',
                    'mautic.helper.core_parameters',
                    'mautic.filesystem',
                    'symfony.finder',
                    'mautic.integrations.helper.builder_integrations',
                ],
                'methodCalls' => [
                    'setDefaultTheme' => [
                        '%mautic.theme%',
                    ],
                ],
            ],
            'mautic.helper.encryption' => [
                'class'     => Mautic\CoreBundle\Helper\EncryptionHelper::class,
                'arguments' => [
                    'mautic.helper.core_parameters',
                    'mautic.cipher.openssl',
                ],
            ],
            'mautic.helper.url' => [
                'class'     => Mautic\CoreBundle\Helper\UrlHelper::class,
            ],
            'mautic.helper.export' => [
                'class'     => Mautic\CoreBundle\Helper\ExportHelper::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.core_parameters',
                    'mautic.helper.file_path_resolver',
                ],
            ],
            'mautic.helper.composer' => [
                'class'     => Mautic\CoreBundle\Helper\ComposerHelper::class,
                'arguments' => [
                    'kernel',
                    'monolog.logger.mautic',
                ],
            ],
            // Menu
            'mautic.helper.menu' => [
                'class'     => Mautic\CoreBundle\Menu\MenuHelper::class,
                'arguments' => [
                    'mautic.security',
                    'request_stack',
                    'mautic.helper.core_parameters',
                    'mautic.helper.integration',
                ],
            ],
            'mautic.helper.hash' => [
                'class' => Mautic\CoreBundle\Helper\HashHelper\HashHelper::class,
            ],
            'mautic.helper.random' => [
                'class' => Mautic\CoreBundle\Helper\RandomHelper\RandomHelper::class,
            ],
            'mautic.helper.command' => [
                'class'     => Mautic\CoreBundle\Helper\CommandHelper::class,
                'arguments' => 'kernel',
            ],
            'mautic.menu_renderer' => [
                'class'     => Mautic\CoreBundle\Menu\MenuRenderer::class,
                'arguments' => [
                    'knp_menu.matcher',
                    'twig',
                ],
                'tag'   => 'knp_menu.renderer',
                'alias' => 'mautic',
            ],
            'mautic.menu.builder' => [
                'class'     => Mautic\CoreBundle\Menu\MenuBuilder::class,
                'arguments' => [
                    'knp_menu.factory',
                    'knp_menu.matcher',
                    'event_dispatcher',
                    'mautic.helper.menu',
                ],
            ],
            // IP Lookup
            'mautic.ip_lookup.factory' => [
                'class'     => Mautic\CoreBundle\Factory\IpLookupFactory::class,
                'arguments' => [
                    '%mautic.ip_lookup_services%',
                    'monolog.logger.mautic',
                    'mautic.http.client',
                    '%kernel.cache_dir%',
                    'mautic.helper.core_parameters',
                ],
            ],
            'mautic.ip_lookup' => [
                'class'     => Mautic\CoreBundle\IpLookup\AbstractLookup::class, // bogus just to make cache compilation happy
                'factory'   => ['@mautic.ip_lookup.factory', 'getService'],
                'arguments' => [
                    '%mautic.ip_lookup_service%',
                    '%mautic.ip_lookup_auth%',
                    '%mautic.ip_lookup_config%',
                    'mautic.http.client',
                ],
            ],
            'mautic.native.connector' => [
                'class'     => Symfony\Contracts\HttpClient\HttpClientInterface::class,
                'factory'   => [Symfony\Component\HttpClient\HttpClient::class, 'create'],
            ],

            'twig.controller.exception.class' => Mautic\CoreBundle\Controller\ExceptionController::class,

            'mautic.doctrine.loader.mautic_fixtures_loader' => [
                'class'     => Mautic\CoreBundle\Doctrine\Loader\MauticFixturesLoader::class,
                'arguments' => [
                    'doctrine.fixtures.loader',
                ],
            ],
            // Schema
            'mautic.schema.helper.column' => [
                'class'     => Mautic\CoreBundle\Doctrine\Helper\ColumnSchemaHelper::class,
                'arguments' => [
                    'database_connection',
                    '%mautic.db_table_prefix%',
                ],
            ],
            'mautic.schema.helper.index' => [
                'class'     => Mautic\CoreBundle\Doctrine\Helper\IndexSchemaHelper::class,
                'arguments' => [
                    'database_connection',
                    '%mautic.db_table_prefix%',
                ],
            ],
            'mautic.schema.helper.table' => [
                'class'     => Mautic\CoreBundle\Doctrine\Helper\TableSchemaHelper::class,
                'arguments' => [
                    'database_connection',
                    '%mautic.db_table_prefix%',
                    'mautic.schema.helper.column',
                ],
            ],
            'mautic.form.list.validator.circular' => [
                'class'     => Mautic\CoreBundle\Form\Validator\Constraints\CircularDependencyValidator::class,
                'arguments' => [
                    'mautic.lead.model.list',
                    'request_stack',
                ],
                'tag' => 'validator.constraint_validator',
            ],
            'mautic.maxmind.doNotSellList' => [
                'class'     => Mautic\CoreBundle\IpLookup\DoNotSellList\MaxMindDoNotSellList::class,
                'arguments' => [
                    'mautic.helper.core_parameters',
                ],
            ],
            // Logger
            'mautic.monolog.handler' => [
                'class'     => Mautic\CoreBundle\Monolog\Handler\FileLogHandler::class,
                'arguments' => [
                    'mautic.helper.core_parameters',
                    'mautic.monolog.fulltrace.formatter',
                ],
            ],

            // Update steps
            'mautic.update.step_provider' => [
                'class' => Mautic\CoreBundle\Update\StepProvider::class,
            ],
            'mautic.update.step.delete_cache' => [
                'class'     => Mautic\CoreBundle\Update\Step\DeleteCacheStep::class,
                'arguments' => [
                    'mautic.helper.cache',
                    'translator',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.finalize' => [
                'class'     => Mautic\CoreBundle\Update\Step\FinalizeUpdateStep::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.paths',
                    'request_stack',
                    'mautic.helper.app_version',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.install_new_files' => [
                'class'     => Mautic\CoreBundle\Update\Step\InstallNewFilesStep::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.update',
                    'mautic.helper.paths',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.remove_deleted_files' => [
                'class'     => Mautic\CoreBundle\Update\Step\RemoveDeletedFilesStep::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.paths',
                    'monolog.logger.mautic',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.update_schema' => [
                'class'     => Mautic\CoreBundle\Update\Step\UpdateSchemaStep::class,
                'arguments' => [
                    'translator',
                    'service_container',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.update_translations' => [
                'class'     => Mautic\CoreBundle\Update\Step\UpdateTranslationsStep::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.language',
                    'monolog.logger.mautic',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.step.checks' => [
                'class'     => Mautic\CoreBundle\Update\Step\PreUpdateChecksStep::class,
                'arguments' => [
                    'translator',
                    'mautic.helper.update',
                ],
                'tag' => 'mautic.update_step',
            ],
            'mautic.update.checks.php' => [
                'class' => Mautic\CoreBundle\Helper\Update\PreUpdateChecks\CheckPhpVersion::class,
                'tag'   => 'mautic.update_check',
            ],
            'mautic.update.checks.database' => [
                'class'     => Mautic\CoreBundle\Helper\Update\PreUpdateChecks\CheckDatabaseDriverAndVersion::class,
                'arguments' => [
                    'doctrine.orm.default_entity_manager',
                ],
                'tag' => 'mautic.update_check',
            ],
        ],
        'validator' => [
            'mautic.core.validator.file_upload' => [
                'class'     => Mautic\CoreBundle\Validator\FileUploadValidator::class,
                'arguments' => [
                    'translator',
                ],
            ],
        ],
    ],

    'ip_lookup_services' => [
        'extreme-ip' => [
            'display_name' => 'Extreme-IP',
            'class'        => Mautic\CoreBundle\IpLookup\ExtremeIpLookup::class,
        ],
        'freegeoip' => [
            'display_name' => 'Ipstack.com',
            'class'        => Mautic\CoreBundle\IpLookup\IpstackLookup::class,
        ],
        'geobytes' => [
            'display_name' => 'Geobytes',
            'class'        => Mautic\CoreBundle\IpLookup\GeobytesLookup::class,
        ],
        'geoips' => [
            'display_name' => 'GeoIPs',
            'class'        => Mautic\CoreBundle\IpLookup\GeoipsLookup::class,
        ],
        'ipinfodb' => [
            'display_name' => 'IPInfoDB',
            'class'        => Mautic\CoreBundle\IpLookup\IpinfodbLookup::class,
        ],
        'maxmind_country' => [
            'display_name' => 'MaxMind - Country Geolocation',
            'class'        => Mautic\CoreBundle\IpLookup\MaxmindCountryLookup::class,
        ],
        'maxmind_omni' => [
            'display_name' => 'MaxMind - Insights (formerly Omni]',
            'class'        => Mautic\CoreBundle\IpLookup\MaxmindOmniLookup::class,
        ],
        'maxmind_precision' => [
            'display_name' => 'MaxMind - GeoIP2 Precision',
            'class'        => Mautic\CoreBundle\IpLookup\MaxmindPrecisionLookup::class,
        ],
        'maxmind_download' => [
            'display_name' => 'MaxMind - GeoLite2 City Download',
            'class'        => Mautic\CoreBundle\IpLookup\MaxmindDownloadLookup::class,
        ],
        'telize' => [
            'display_name' => 'Telize',
            'class'        => Mautic\CoreBundle\IpLookup\TelizeLookup::class,
        ],
        'ip2loctionlocal' => [
            'display_name' => 'IP2Location Local Bin File',
            'class'        => Mautic\CoreBundle\IpLookup\IP2LocationBinLookup::class,
        ],
        'ip2loctionapi' => [
            'display_name' => 'IP2Location Web Service',
            'class'        => Mautic\CoreBundle\IpLookup\IP2LocationAPILookup::class,
        ],
    ],

    'parameters' => [
        'site_url'                        => '',
        'webroot'                         => '',
        '404_page'                        => '',
        'cache_path'                      => '%kernel.project_dir%/var/cache',
        'log_path'                        => '%kernel.project_dir%/var/logs',
        'max_log_files'                   => 7,
        'log_file_name'                   => 'mautic_%kernel.environment%.php',
        'image_path'                      => 'media/images',
        'media_path'                      => 'media',
        'tmp_path'                        => '%kernel.project_dir%/var/tmp',
        'theme'                           => 'blank',
        'theme_import_allowed_extensions' => ['json', 'twig', 'css', 'js', 'htm', 'html', 'txt', 'jpg', 'jpeg', 'png', 'gif'],
        'brand_name'                      => 'Your Brand (configurable)',
        'primary_brand_color'             => '000000',
        'db_driver'                       => 'pdo_mysql',
        'db_host'                         => '127.0.0.1',
        'db_port'                         => 3306,
        'db_name'                         => '',
        'db_user'                         => '',
        'db_password'                     => '',
        'db_table_prefix'                 => '',
        'db_host_ro'                      => null,
        'locale'                          => 'en_US',
        'secret_key'                      => 'temp',
        'dev_hosts'                       => [],
        'trusted_hosts'                   => [],
        'trusted_proxies'                 => [],
        'rememberme_key'                  => '%mautic.secret_key%',
        'rememberme_lifetime'             => 31_536_000, // 365 days in seconds
        'rememberme_path'                 => '/',
        'rememberme_domain'               => '',
        'default_pagelimit'               => 30,
        'default_timezone'                => 'UTC',
        'date_format_full'                => 'F j, Y g:i a T',
        'date_format_short'               => 'D, M d',
        'date_format_dateonly'            => 'F j, Y',
        'date_format_timeonly'            => 'g:i a',
        'ip_lookup_service'               => 'maxmind_download',
        'ip_lookup_auth'                  => '',
        'ip_lookup_config'                => [],
        'ip_lookup_create_organization'   => false,
        'transifex_api_token'             => '',
        'update_stability'                => 'stable',
        'cookie_path'                     => '/',
        'cookie_domain'                   => '',
        'cookie_secure'                   => true,
        'cookie_httponly'                 => false,
        'do_not_track_ips'                => [],
        'do_not_track_bots'               => [
            'MSNBOT',
            'msnbot-media',
            'bingbot',
            'Googlebot',
            'Google Web Preview',
            'Mediapartners-Google',
            'Baiduspider',
            'Ezooms',
            'YahooSeeker',
            'Slurp',
            'AltaVista',
            'AVSearch',
            'Mercator',
            'Scooter',
            'InfoSeek',
            'Ultraseek',
            'Lycos',
            'Wget',
            'YandexBot',
            'Java/1.4.1_04',
            'SiteBot',
            'Exabot',
            'AhrefsBot',
            'MJ12bot',
            'NetSeer crawler',
            'TurnitinBot',
            'magpie-crawler',
            'Nutch Crawler',
            'CMS Crawler',
            'rogerbot',
            'Domnutch',
            'ssearch_bot',
            'XoviBot',
            'digincore',
            'fr-crawler',
            'SeznamBot',
            'Seznam screenshot-generator',
            'Facebot',
            'facebookexternalhit',
            'SimplePie',
            'Riddler',
            '007ac9 Crawler',
            '360Spider',
            'A6-Indexer',
            'ADmantX',
            'AHC',
            'AISearchBot',
            'APIs-Google',
            'Aboundex',
            'AddThis',
            'Adidxbot',
            'AdsBot-Google',
            'AdsTxtCrawler',
            'AdvBot',
            'Ahrefs',
            'AlphaBot',
            'Amazon CloudFront',
            'AndersPinkBot',
            'Apache-HttpClient',
            'Apercite',
            'AppEngine-Google',
            'Applebot',
            'ArchiveBot',
            'BDCbot',
            'BIGLOTRON',
            'BLEXBot',
            'BLP_bbot',
            'BTWebClient',
            'BUbiNG',
            'Baidu-YunGuanCe',
            'Barkrowler',
            'BehloolBot',
            'BingPreview',
            'BomboraBot',
            'Bot.AraTurka.com',
            'BoxcarBot',
            'BrandVerity',
            'Buck',
            'CC Metadata Scaper',
            'CCBot',
            'CapsuleChecker',
            'Cliqzbot',
            'CloudFlare-AlwaysOnline',
            'Companybook-Crawler',
            'ContextAd Bot',
            'CrunchBot',
            'CrystalSemanticsBot',
            'CyberPatrol',
            'DareBoost',
            'Datafeedwatch',
            'Daum',
            'DeuSu',
            'developers.google.com',
            'Diffbot',
            'Digg Deeper',
            'Digincore bot',
            'Discordbot',
            'Disqus',
            'DnyzBot',
            'Domain Re-Animator Bot',
            'DomainStatsBot',
            'DuckDuckBot',
            'DuckDuckGo-Favicons-Bot',
            'EZID',
            'Embedly',
            'EveryoneSocialBot',
            'ExtLinksBot',
            'FAST Enterprise Crawler',
            'FAST-WebCrawler',
            'Feedfetcher-Google',
            'Feedly',
            'Feedspotbot',
            'FemtosearchBot',
            'Fetch',
            'Fever',
            'Flamingo_SearchEngine',
            'FlipboardProxy',
            'Fyrebot',
            'GarlikCrawler',
            'Genieo',
            'Gigablast',
            'Gigabot',
            'GingerCrawler',
            'Gluten Free Crawler',
            'GnowitNewsbot',
            'Go-http-client',
            'Google-Adwords-Instant',
            'Gowikibot',
            'GrapeshotCrawler',
            'Grobbot',
            'HTTrack',
            'Hatena',
            'IAS crawler',
            'ICC-Crawler',
            'IndeedBot',
            'InterfaxScanBot',
            'IstellaBot',
            'James BOT',
            'Jamie\'s Spider',
            'Jetslide',
            'Jetty',
            'Jugendschutzprogramm-Crawler',
            'K7MLWCBot',
            'Kemvibot',
            'KosmioBot',
            'Landau-Media-Spider',
            'Laserlikebot',
            'Leikibot',
            'Linguee Bot',
            'LinkArchiver',
            'LinkedInBot',
            'LivelapBot',
            'Luminator-robots',
            'Mail.RU_Bot',
            'Mastodon',
            'MauiBot',
            'Mediatoolkitbot',
            'MegaIndex',
            'MeltwaterNews',
            'MetaJobBot',
            'MetaURI',
            'Miniflux',
            'MojeekBot',
            'Moreover',
            'MuckRack',
            'Multiviewbot',
            'NING',
            'NerdByNature.Bot',
            'NetcraftSurveyAgent',
            'Netvibes',
            'Nimbostratus-Bot',
            'Nuzzel',
            'Ocarinabot',
            'OpenHoseBot',
            'OrangeBot',
            'OutclicksBot',
            'PR-CY.RU',
            'PaperLiBot',
            'Pcore-HTTP',
            'PhantomJS',
            'PiplBot',
            'PocketParser',
            'Primalbot',
            'PrivacyAwareBot',
            'Pulsepoint',
            'Python-urllib',
            'Qwantify',
            'RankActiveLinkBot',
            'RetrevoPageAnalyzer',
            'SBL-BOT',
            'SEMrushBot',
            'SEOkicks',
            'SWIMGBot',
            'SafeDNSBot',
            'SafeSearch microdata crawler',
            'ScoutJet',
            'Scrapy',
            'Screaming Frog SEO Spider',
            'SemanticScholarBot',
            'SimpleCrawler',
            'Siteimprove.com',
            'SkypeUriPreview',
            'Slack-ImgProxy',
            'Slackbot',
            'Snacktory',
            'SocialRankIOBot',
            'Sogou',
            'Sonic',
            'StorygizeBot',
            'SurveyBot',
            'Sysomos',
            'TangibleeBot',
            'TelegramBot',
            'Teoma',
            'Thinklab',
            'TinEye',
            'ToutiaoSpider',
            'Traackr.com',
            'Trove',
            'TweetmemeBot',
            'Twitterbot',
            'Twurly',
            'Upflow',
            'UptimeRobot',
            'UsineNouvelleCrawler',
            'Veoozbot',
            'WeSEE:Search',
            'WhatsApp',
            'Xenu Link Sleuth',
            'Y!J',
            'YaK',
            'Yahoo Link Preview',
            'Yeti',
            'YisouSpider',
            'Zabbix',
            'ZoominfoBot',
            'ZumBot',
            'ZuperlistBot',
            '^LCC ',
            'acapbot',
            'acoonbot',
            'adbeat_bot',
            'adscanner',
            'aiHitBot',
            'antibot',
            'arabot',
            'archive.org_bot',
            'axios',
            'backlinkcrawler',
            'betaBot',
            'bibnum.bnf',
            'binlar',
            'bitlybot',
            'blekkobot',
            'blogmuraBot',
            'bnf.fr_bot',
            'bot-pge.chlooe.com',
            'botify',
            'brainobot',
            'buzzbot',
            'cXensebot',
            'careerbot',
            'centurybot9',
            'changedetection',
            'check_http',
            'citeseerxbot',
            'coccoc',
            'collection@infegy.com',
            'content crawler spider',
            'contxbot',
            'convera',
            'crawler4j',
            'curl',
            'datagnionbot',
            'dcrawl',
            'deadlinkchecker',
            'discobot',
            'domaincrawler',
            'dotbot',
            'drupact',
            'ec2linkfinder',
            'edisterbot',
            'electricmonk',
            'elisabot',
            'epicbot',
            'eright',
            'europarchive.org',
            'exabot',
            'ezooms',
            'filterdb.iss.net',
            'findlink',
            'findthatfile',
            'findxbot',
            'fluffy',
            'fuelbot',
            'g00g1e.net',
            'g2reader-bot',
            'gnam gnam spider',
            'google-xrawler',
            'grub.org',
            'gslfbot',
            'heritrix',
            'http_get',
            'httpunit',
            'ia_archiver',
            'ichiro',
            'imrbot',
            'integromedb',
            'intelium_bot',
            'ip-web-crawler.com',
            'ips-agent',
            'iskanie',
            'it2media-domain-crawler',
            'jyxobot',
            'lb-spider',
            'libwww',
            'linkapediabot',
            'linkdex',
            'lipperhey',
            'lssbot',
            'lssrocketcrawler',
            'ltx71',
            'mappydata',
            'memorybot',
            'mindUpBot',
            'mlbot',
            'moatbot',
            'msnbot',
            'msrbot',
            'nerdybot',
            'netEstate NE Crawler',
            'netresearchserver',
            'newsharecounts',
            'newspaper',
            'niki-bot',
            'nutch',
            'okhttp',
            'omgili',
            'openindexspider',
            'page2rss',
            'panscient',
            'phpcrawl',
            'pingdom',
            'pinterest',
            'postrank',
            'proximic',
            'psbot',
            'purebot',
            'python-requests',
            'redditbot',
            'scribdbot',
            'seekbot',
            'semanticbot',
            'sentry',
            'seoscanners',
            'seznambot',
            'sistrix crawler',
            'sitebot',
            'siteexplorer.info',
            'smtbot',
            'spbot',
            'speedy',
            'summify',
            'tagoobot',
            'toplistbot',
            'tracemyfile',
            'trendictionbot',
            'turnitinbot',
            'twengabot',
            'um-LN',
            'urlappendbot',
            'vebidoobot',
            'vkShare',
            'voilabot',
            'wbsearchbot',
            'web-archive-net.com.bot',
            'webcompanycrawler',
            'webmon',
            'wget',
            'wocbot',
            'woobot',
            'woriobot',
            'wotbox',
            'xovibot',
            'yacybot',
            'yandex.com',
            'yanga',
            'yoozBot',
            'zgrab',
        ],
        'do_not_track_internal_ips'           => [],
        'track_private_ip_ranges'             => false,
        'link_shortener_url'                  => null,
        'shortener_email_enable'              => false,
        'shortener_sms_enable'                => true,
        'cached_data_timeout'                 => 10,
        'batch_sleep_time'                    => 1,
        'batch_campaign_sleep_time'           => false,
        'transliterate_page_title'            => false,
        'cors_restrict_domains'               => true,
        'cors_valid_domains'                  => [],
        'headers_sts'                         => false,
        'headers_sts_expire_time'             => 60,
        'headers_sts_subdomains'              => false,
        'headers_sts_preload'                 => false,
        'max_entity_lock_time'                => 0,
        'default_daterange_filter'            => '-1 month',
        'debug'                               => false,
        'anonymize_ip_address_in_background'  => false,
        'rss_notification_url'                => '',
        'translations_list_url'               => 'https://language-packs.mautic.com/manifest.json',
        'translations_fetch_url'              => 'https://language-packs.mautic.com/',
        'stats_update_url'                    => 'https://updates.mautic.org/stats/send', // set to empty in config file to disable
        'install_source'                      => 'Mautic',
        'system_update_url'                   => 'https://api.github.com/repos/mautic/mautic/releases',
        'editor_fonts'                        => [
            [
                'name' => 'Arial',
                'font' => 'Arial, Helvetica Neue, Helvetica, sans-serif',
            ],
            [
                'name' => 'Bitter',
                'font' => 'Bitter, Georgia, Times, Times New Roman, serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Bitter',
            ],
            [
                'name' => 'Courier New',
                'font' => 'Courier New, Courier, Lucida Sans Typewriter, Lucida Typewriter, monospace',
            ],
            [
                'name' => 'Droid Serif',
                'font' => 'Droid Serif, Georgia, Times, Times New Roman, serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Droid+Serif',
            ],
            [
                'name' => 'Georgia',
                'font' => 'Georgia, Times, Times New Roman, serif',
            ],
            [
                'name' => 'Helvetica',
                'font' => 'Helvetica Neue, Helvetica, Arial, sans-serif',
            ],
            [
                'name' => 'Lato',
                'font' => 'Lato, Tahoma, Verdana, Segoe, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Lato',
            ],
            [
                'name' => 'Lucida Sans Unicode',
                'font' => 'Lucida Sans Unicode, Lucida Grande, Lucida Sans, Geneva, Verdana, sans-serif',
            ],
            [
                'name' => 'Montserrat',
                'font' => 'Montserrat, Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Montserrat',
            ],
            [
                'name' => 'Open Sans',
                'font' => 'Open Sans, Helvetica Neue, Helvetica, Arial, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Open+Sans',
            ],
            [
                'name' => 'Roboto',
                'font' => 'Roboto, Tahoma, Verdana, Segoe, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Roboto',
            ],
            [
                'name' => 'Source Sans Pro',
                'font' => 'Source Sans Pro, Tahoma, Verdana, Segoe, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Source+Sans+Pro',
            ],
            [
                'name' => 'Tahoma',
                'font' => 'Tahoma, Geneva, Segoe, sans-serif',
            ],
            [
                'name' => 'Times New Roman',
                'font' => 'TimesNewRoman, Times New Roman, Times, Beskerville, Georgia, serif',
            ],
            [
                'name' => 'Trebuchet MS',
                'font' => 'Trebuchet MS, Lucida Grande, Lucida Sans Unicode, Lucida Sans, Tahoma, sans-serif',
            ],
            [
                'name' => 'Ubuntu',
                'font' => 'Ubuntu, Tahoma, Verdana, Segoe, sans-serif',
                'url'  => 'https://fonts.googleapis.com/css?family=Ubuntu',
            ],
            [
                'name' => 'Verdana',
                'font' => 'Verdana, Geneva, sans-serif',
            ],
            [
                'name' => 'ヒラギノ角ゴ Pro W3',
                'font' => 'ヒラギノ角ゴ Pro W3, Hiragino Kaku Gothic Pro,Osaka, メイリオ, Meiryo, ＭＳ Ｐゴシック, MS PGothic, sans-serif',
            ],
            [
                'name' => 'メイリオ',
                'font' => 'メイリオ, Meiryo, ＭＳ Ｐゴシック, MS PGothic, ヒラギノ角ゴ Pro W3, Hiragino Kaku Gothic Pro,Osaka, sans-serif',
            ],
        ],
        'composer_updates'                                        => false,
        'redis_primary_only'                                      => false,
        Mautic\CoreBundle\Shortener\Shortener::SHORTENER_SERVICE  => null,
        'gdpr_user_purge_threshold'                               => 1095, // Minimum no. of days a user has to be inactive to get picked up by `mautic:maintenance:cleanup --gdpr`
    ],
];
