(function(window,document,undefined){if(!window){return}
var _MAP={8:'backspace',9:'tab',13:'enter',16:'shift',17:'ctrl',18:'alt',20:'capslock',27:'esc',32:'space',33:'pageup',34:'pagedown',35:'end',36:'home',37:'left',38:'up',39:'right',40:'down',45:'ins',46:'del',91:'meta',93:'meta',224:'meta'};var _KEYCODE_MAP={106:'*',107:'+',109:'-',110:'.',111:'/',186:';',187:'=',188:',',189:'-',190:'.',191:'/',192:'`',219:'[',220:'\\',221:']',222:'\''};var _SHIFT_MAP={'~':'`','!':'1','@':'2','#':'3','$':'4','%':'5','^':'6','&':'7','*':'8','(':'9',')':'0','_':'-','+':'=',':':';','\"':'\'','<':',','>':'.','?':'/','|':'\\'};var _SPECIAL_ALIASES={'option':'alt','command':'meta','return':'enter','escape':'esc','plus':'+','mod':/Mac|iPod|iPhone|iPad/.test(navigator.platform)?'meta':'ctrl'};var _REVERSE_MAP;for(var i=1;i<20;++i){_MAP[111+i]='f'+i}
for(i=0;i<=9;++i){_MAP[i+96]=i.toString()}
function _addEvent(object,type,callback){if(object.addEventListener){object.addEventListener(type,callback,!1);return}
object.attachEvent('on'+type,callback)}
function _characterFromEvent(e){if(e.type=='keypress'){var character=String.fromCharCode(e.which);if(!e.shiftKey){character=character.toLowerCase()}
return character}
if(_MAP[e.which]){return _MAP[e.which]}
if(_KEYCODE_MAP[e.which]){return _KEYCODE_MAP[e.which]}
return String.fromCharCode(e.which).toLowerCase()}
function _modifiersMatch(modifiers1,modifiers2){return modifiers1.sort().join(',')===modifiers2.sort().join(',')}
function _eventModifiers(e){var modifiers=[];if(e.shiftKey){modifiers.push('shift')}
if(e.altKey){modifiers.push('alt')}
if(e.ctrlKey){modifiers.push('ctrl')}
if(e.metaKey){modifiers.push('meta')}
return modifiers}
function _preventDefault(e){if(e.preventDefault){e.preventDefault();return}
e.returnValue=!1}
function _stopPropagation(e){if(e.stopPropagation){e.stopPropagation();return}
e.cancelBubble=!0}
function _isModifier(key){return key=='shift'||key=='ctrl'||key=='alt'||key=='meta'}
function _getReverseMap(){if(!_REVERSE_MAP){_REVERSE_MAP={};for(var key in _MAP){if(key>95&&key<112){continue}
if(_MAP.hasOwnProperty(key)){_REVERSE_MAP[_MAP[key]]=key}}}
return _REVERSE_MAP}
function _pickBestAction(key,modifiers,action){if(!action){action=_getReverseMap()[key]?'keydown':'keypress'}
if(action=='keypress'&&modifiers.length){action='keydown'}
return action}
function _keysFromString(combination){if(combination==='+'){return['+']}
combination=combination.replace(/\+{2}/g,'+plus');return combination.split('+')}
function _getKeyInfo(combination,action){var keys;var key;var i;var modifiers=[];keys=_keysFromString(combination);for(i=0;i<keys.length;++i){key=keys[i];if(_SPECIAL_ALIASES[key]){key=_SPECIAL_ALIASES[key]}
if(action&&action!='keypress'&&_SHIFT_MAP[key]){key=_SHIFT_MAP[key];modifiers.push('shift')}
if(_isModifier(key)){modifiers.push(key)}}
action=_pickBestAction(key,modifiers,action);return{key:key,modifiers:modifiers,action:action}}
function _belongsTo(element,ancestor){if(element===null||element===document){return!1}
if(element===ancestor){return!0}
return _belongsTo(element.parentNode,ancestor)}
function Mousetrap(targetElement){var self=this;targetElement=targetElement||document;if(!(self instanceof Mousetrap)){return new Mousetrap(targetElement)}
self.target=targetElement;self._callbacks={};self._directMap={};var _sequenceLevels={};var _resetTimer;var _ignoreNextKeyup=!1;var _ignoreNextKeypress=!1;var _nextExpectedAction=!1;function _resetSequences(doNotReset){doNotReset=doNotReset||{};var activeSequences=!1,key;for(key in _sequenceLevels){if(doNotReset[key]){activeSequences=!0;continue}
_sequenceLevels[key]=0}
if(!activeSequences){_nextExpectedAction=!1}}
function _getMatches(character,modifiers,e,sequenceName,combination,level){var i;var callback;var matches=[];var action=e.type;if(!self._callbacks[character]){return[]}
if(action=='keyup'&&_isModifier(character)){modifiers=[character]}
for(i=0;i<self._callbacks[character].length;++i){callback=self._callbacks[character][i];if(!sequenceName&&callback.seq&&_sequenceLevels[callback.seq]!=callback.level){continue}
if(action!=callback.action){continue}
if((action=='keypress'&&!e.metaKey&&!e.ctrlKey)||_modifiersMatch(modifiers,callback.modifiers)){var deleteCombo=!sequenceName&&callback.combo==combination;var deleteSequence=sequenceName&&callback.seq==sequenceName&&callback.level==level;if(deleteCombo||deleteSequence){self._callbacks[character].splice(i,1)}
matches.push(callback)}}
return matches}
function _fireCallback(callback,e,combo,sequence){if(self.stopCallback(e,e.target||e.srcElement,combo,sequence)){return}
if(callback(e,combo)===!1){_preventDefault(e);_stopPropagation(e)}}
self._handleKey=function(character,modifiers,e){var callbacks=_getMatches(character,modifiers,e);var i;var doNotReset={};var maxLevel=0;var processedSequenceCallback=!1;for(i=0;i<callbacks.length;++i){if(callbacks[i].seq){maxLevel=Math.max(maxLevel,callbacks[i].level)}}
for(i=0;i<callbacks.length;++i){if(callbacks[i].seq){if(callbacks[i].level!=maxLevel){continue}
processedSequenceCallback=!0;doNotReset[callbacks[i].seq]=1;_fireCallback(callbacks[i].callback,e,callbacks[i].combo,callbacks[i].seq);continue}
if(!processedSequenceCallback){_fireCallback(callbacks[i].callback,e,callbacks[i].combo)}}
var ignoreThisKeypress=e.type=='keypress'&&_ignoreNextKeypress;if(e.type==_nextExpectedAction&&!_isModifier(character)&&!ignoreThisKeypress){_resetSequences(doNotReset)}
_ignoreNextKeypress=processedSequenceCallback&&e.type=='keydown'};function _handleKeyEvent(e){if(typeof e.which!=='number'){e.which=e.keyCode}
var character=_characterFromEvent(e);if(!character){return}
if(e.type=='keyup'&&_ignoreNextKeyup===character){_ignoreNextKeyup=!1;return}
self.handleKey(character,_eventModifiers(e),e)}
function _resetSequenceTimer(){clearTimeout(_resetTimer);_resetTimer=setTimeout(_resetSequences,1000)}
function _bindSequence(combo,keys,callback,action){_sequenceLevels[combo]=0;function _increaseSequence(nextAction){return function(){_nextExpectedAction=nextAction;++_sequenceLevels[combo];_resetSequenceTimer()}}
function _callbackAndReset(e){_fireCallback(callback,e,combo);if(action!=='keyup'){_ignoreNextKeyup=_characterFromEvent(e)}
setTimeout(_resetSequences,10)}
for(var i=0;i<keys.length;++i){var isFinal=i+1===keys.length;var wrappedCallback=isFinal?_callbackAndReset:_increaseSequence(action||_getKeyInfo(keys[i+1]).action);_bindSingle(keys[i],wrappedCallback,action,combo,i)}}
function _bindSingle(combination,callback,action,sequenceName,level){self._directMap[combination+':'+action]=callback;combination=combination.replace(/\s+/g,' ');var sequence=combination.split(' ');var info;if(sequence.length>1){_bindSequence(combination,sequence,callback,action);return}
info=_getKeyInfo(combination,action);self._callbacks[info.key]=self._callbacks[info.key]||[];_getMatches(info.key,info.modifiers,{type:info.action},sequenceName,combination,level);self._callbacks[info.key][sequenceName?'unshift':'push']({callback:callback,modifiers:info.modifiers,action:info.action,seq:sequenceName,level:level,combo:combination})}
self._bindMultiple=function(combinations,callback,action){for(var i=0;i<combinations.length;++i){_bindSingle(combinations[i],callback,action)}};_addEvent(targetElement,'keypress',_handleKeyEvent);_addEvent(targetElement,'keydown',_handleKeyEvent);_addEvent(targetElement,'keyup',_handleKeyEvent)}
Mousetrap.prototype.bind=function(keys,callback,action){var self=this;keys=keys instanceof Array?keys:[keys];self._bindMultiple.call(self,keys,callback,action);return self};Mousetrap.prototype.unbind=function(keys,action){var self=this;return self.bind.call(self,keys,function(){},action)};Mousetrap.prototype.trigger=function(keys,action){var self=this;if(self._directMap[keys+':'+action]){self._directMap[keys+':'+action]({},keys)}
return self};Mousetrap.prototype.reset=function(){var self=this;self._callbacks={};self._directMap={};return self};Mousetrap.prototype.stopCallback=function(e,element){var self=this;if((' '+element.className+' ').indexOf(' mousetrap ')>-1){return!1}
if(_belongsTo(element,self.target)){return!1}
if('composedPath' in e&&typeof e.composedPath==='function'){var initialEventTarget=e.composedPath()[0];if(initialEventTarget!==e.target){element=initialEventTarget}}
return element.tagName=='INPUT'||element.tagName=='SELECT'||element.tagName=='TEXTAREA'||element.isContentEditable};Mousetrap.prototype.handleKey=function(){var self=this;return self._handleKey.apply(self,arguments)};Mousetrap.addKeycodes=function(object){for(var key in object){if(object.hasOwnProperty(key)){_MAP[key]=object[key]}}
_REVERSE_MAP=null};Mousetrap.init=function(){var documentMousetrap=Mousetrap(document);for(var method in documentMousetrap){if(method.charAt(0)!=='_'){Mousetrap[method]=(function(method){return function(){return documentMousetrap[method].apply(documentMousetrap,arguments)}}(method))}}};Mousetrap.init();window.Mousetrap=Mousetrap;if(typeof module!=='undefined'&&module.exports){module.exports=Mousetrap}
if(typeof define==='function'&&define.amd){define(function(){return Mousetrap})}})(typeof window!=='undefined'?window:null,typeof window!=='undefined'?document:null);/*!
 * jQuery JavaScript Library v3.7.1
 * https://jquery.com/
 *
 * Copyright OpenJS Foundation and other contributors
 * Released under the MIT license
 * https://jquery.org/license
 *
 * Date: 2023-08-28T13:37Z
 */
(function(global,factory){"use strict";if(typeof module==="object"&&typeof module.exports==="object"){module.exports=global.document?factory(global,!0):function(w){if(!w.document){throw new Error("jQuery requires a window with a document")}
return factory(w)}}else{factory(global)}})(typeof window!=="undefined"?window:this,function(window,noGlobal){"use strict";var arr=[];var getProto=Object.getPrototypeOf;var slice=arr.slice;var flat=arr.flat?function(array){return arr.flat.call(array)}:function(array){return arr.concat.apply([],array)};var push=arr.push;var indexOf=arr.indexOf;var class2type={};var toString=class2type.toString;var hasOwn=class2type.hasOwnProperty;var fnToString=hasOwn.toString;var ObjectFunctionString=fnToString.call(Object);var support={};var isFunction=function isFunction(obj){return typeof obj==="function"&&typeof obj.nodeType!=="number"&&typeof obj.item!=="function"};var isWindow=function isWindow(obj){return obj!=null&&obj===obj.window};var document=window.document;var preservedScriptAttributes={type:!0,src:!0,nonce:!0,noModule:!0};function DOMEval(code,node,doc){doc=doc||document;var i,val,script=doc.createElement("script");script.text=code;if(node){for(i in preservedScriptAttributes){val=node[i]||node.getAttribute&&node.getAttribute(i);if(val){script.setAttribute(i,val)}}}
doc.head.appendChild(script).parentNode.removeChild(script)}
function toType(obj){if(obj==null){return obj+""}
return typeof obj==="object"||typeof obj==="function"?class2type[toString.call(obj)]||"object":typeof obj}
var version="3.7.1",rhtmlSuffix=/HTML$/i,jQuery=function(selector,context){return new jQuery.fn.init(selector,context)};jQuery.fn=jQuery.prototype={jquery:version,constructor:jQuery,length:0,toArray:function(){return slice.call(this)},get:function(num){if(num==null){return slice.call(this)}
return num<0?this[num+this.length]:this[num]},pushStack:function(elems){var ret=jQuery.merge(this.constructor(),elems);ret.prevObject=this;return ret},each:function(callback){return jQuery.each(this,callback)},map:function(callback){return this.pushStack(jQuery.map(this,function(elem,i){return callback.call(elem,i,elem)}))},slice:function(){return this.pushStack(slice.apply(this,arguments))},first:function(){return this.eq(0)},last:function(){return this.eq(-1)},even:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return(i+1)%2}))},odd:function(){return this.pushStack(jQuery.grep(this,function(_elem,i){return i%2}))},eq:function(i){var len=this.length,j=+i+(i<0?len:0);return this.pushStack(j>=0&&j<len?[this[j]]:[])},end:function(){return this.prevObject||this.constructor()},push:push,sort:arr.sort,splice:arr.splice};jQuery.extend=jQuery.fn.extend=function(){var options,name,src,copy,copyIsArray,clone,target=arguments[0]||{},i=1,length=arguments.length,deep=!1;if(typeof target==="boolean"){deep=target;target=arguments[i]||{};i++}
if(typeof target!=="object"&&!isFunction(target)){target={}}
if(i===length){target=this;i--}
for(;i<length;i++){if((options=arguments[i])!=null){for(name in options){copy=options[name];if(name==="__proto__"||target===copy){continue}
if(deep&&copy&&(jQuery.isPlainObject(copy)||(copyIsArray=Array.isArray(copy)))){src=target[name];if(copyIsArray&&!Array.isArray(src)){clone=[]}else if(!copyIsArray&&!jQuery.isPlainObject(src)){clone={}}else{clone=src}
copyIsArray=!1;target[name]=jQuery.extend(deep,clone,copy)}else if(copy!==undefined){target[name]=copy}}}}
return target};jQuery.extend({expando:"jQuery"+(version+Math.random()).replace(/\D/g,""),isReady:!0,error:function(msg){throw new Error(msg)},noop:function(){},isPlainObject:function(obj){var proto,Ctor;if(!obj||toString.call(obj)!=="[object Object]"){return!1}
proto=getProto(obj);if(!proto){return!0}
Ctor=hasOwn.call(proto,"constructor")&&proto.constructor;return typeof Ctor==="function"&&fnToString.call(Ctor)===ObjectFunctionString},isEmptyObject:function(obj){var name;for(name in obj){return!1}
return!0},globalEval:function(code,options,doc){DOMEval(code,{nonce:options&&options.nonce},doc)},each:function(obj,callback){var length,i=0;if(isArrayLike(obj)){length=obj.length;for(;i<length;i++){if(callback.call(obj[i],i,obj[i])===!1){break}}}else{for(i in obj){if(callback.call(obj[i],i,obj[i])===!1){break}}}
return obj},text:function(elem){var node,ret="",i=0,nodeType=elem.nodeType;if(!nodeType){while((node=elem[i++])){ret+=jQuery.text(node)}}
if(nodeType===1||nodeType===11){return elem.textContent}
if(nodeType===9){return elem.documentElement.textContent}
if(nodeType===3||nodeType===4){return elem.nodeValue}
return ret},makeArray:function(arr,results){var ret=results||[];if(arr!=null){if(isArrayLike(Object(arr))){jQuery.merge(ret,typeof arr==="string"?[arr]:arr)}else{push.call(ret,arr)}}
return ret},inArray:function(elem,arr,i){return arr==null?-1:indexOf.call(arr,elem,i)},isXMLDoc:function(elem){var namespace=elem&&elem.namespaceURI,docElem=elem&&(elem.ownerDocument||elem).documentElement;return!rhtmlSuffix.test(namespace||docElem&&docElem.nodeName||"HTML")},merge:function(first,second){var len=+second.length,j=0,i=first.length;for(;j<len;j++){first[i++]=second[j]}
first.length=i;return first},grep:function(elems,callback,invert){var callbackInverse,matches=[],i=0,length=elems.length,callbackExpect=!invert;for(;i<length;i++){callbackInverse=!callback(elems[i],i);if(callbackInverse!==callbackExpect){matches.push(elems[i])}}
return matches},map:function(elems,callback,arg){var length,value,i=0,ret=[];if(isArrayLike(elems)){length=elems.length;for(;i<length;i++){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}else{for(i in elems){value=callback(elems[i],i,arg);if(value!=null){ret.push(value)}}}
return flat(ret)},guid:1,support:support});if(typeof Symbol==="function"){jQuery.fn[Symbol.iterator]=arr[Symbol.iterator]}
jQuery.each("Boolean Number String Function Array Date RegExp Object Error Symbol".split(" "),function(_i,name){class2type["[object "+name+"]"]=name.toLowerCase()});function isArrayLike(obj){var length=!!obj&&"length" in obj&&obj.length,type=toType(obj);if(isFunction(obj)||isWindow(obj)){return!1}
return type==="array"||length===0||typeof length==="number"&&length>0&&(length-1)in obj}
function nodeName(elem,name){return elem.nodeName&&elem.nodeName.toLowerCase()===name.toLowerCase()}
var pop=arr.pop;var sort=arr.sort;var splice=arr.splice;var whitespace="[\\x20\\t\\r\\n\\f]";var rtrimCSS=new RegExp("^"+whitespace+"+|((?:^|[^\\\\])(?:\\\\.)*)"+whitespace+"+$","g");jQuery.contains=function(a,b){var bup=b&&b.parentNode;return a===bup||!!(bup&&bup.nodeType===1&&(a.contains?a.contains(bup):a.compareDocumentPosition&&a.compareDocumentPosition(bup)&16))};var rcssescape=/([\0-\x1f\x7f]|^-?\d)|^-$|[^\x80-\uFFFF\w-]/g;function fcssescape(ch,asCodePoint){if(asCodePoint){if(ch==="\0"){return"\uFFFD"}
return ch.slice(0,-1)+"\\"+ch.charCodeAt(ch.length-1).toString(16)+" "}
return"\\"+ch}
jQuery.escapeSelector=function(sel){return(sel+"").replace(rcssescape,fcssescape)};var preferredDoc=document,pushNative=push;(function(){var i,Expr,outermostContext,sortInput,hasDuplicate,push=pushNative,document,documentElement,documentIsHTML,rbuggyQSA,matches,expando=jQuery.expando,dirruns=0,done=0,classCache=createCache(),tokenCache=createCache(),compilerCache=createCache(),nonnativeSelectorCache=createCache(),sortOrder=function(a,b){if(a===b){hasDuplicate=!0}
return 0},booleans="checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|"+"loop|multiple|open|readonly|required|scoped",identifier="(?:\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+",attributes="\\["+whitespace+"*("+identifier+")(?:"+whitespace+"*([*^$|!~]?=)"+whitespace+"*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|("+identifier+"))|)"+whitespace+"*\\]",pseudos=":("+identifier+")(?:\\(("+"('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|"+"((?:\\\\.|[^\\\\()[\\]]|"+attributes+")*)|"+".*"+")\\)|)",rwhitespace=new RegExp(whitespace+"+","g"),rcomma=new RegExp("^"+whitespace+"*,"+whitespace+"*"),rleadingCombinator=new RegExp("^"+whitespace+"*([>+~]|"+whitespace+")"+whitespace+"*"),rdescend=new RegExp(whitespace+"|>"),rpseudo=new RegExp(pseudos),ridentifier=new RegExp("^"+identifier+"$"),matchExpr={ID:new RegExp("^#("+identifier+")"),CLASS:new RegExp("^\\.("+identifier+")"),TAG:new RegExp("^("+identifier+"|[*])"),ATTR:new RegExp("^"+attributes),PSEUDO:new RegExp("^"+pseudos),CHILD:new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\("+whitespace+"*(even|odd|(([+-]|)(\\d*)n|)"+whitespace+"*(?:([+-]|)"+whitespace+"*(\\d+)|))"+whitespace+"*\\)|)","i"),bool:new RegExp("^(?:"+booleans+")$","i"),needsContext:new RegExp("^"+whitespace+"*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\("+whitespace+"*((?:-\\d)?\\d*)"+whitespace+"*\\)|)(?=[^-]|$)","i")},rinputs=/^(?:input|select|textarea|button)$/i,rheader=/^h\d$/i,rquickExpr=/^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/,rsibling=/[+~]/,runescape=new RegExp("\\\\[\\da-fA-F]{1,6}"+whitespace+"?|\\\\([^\\r\\n\\f])","g"),funescape=function(escape,nonHex){var high="0x"+escape.slice(1)-0x10000;if(nonHex){return nonHex}
return high<0?String.fromCharCode(high+0x10000):String.fromCharCode(high>>10|0xD800,high&0x3FF|0xDC00)},unloadHandler=function(){setDocument()},inDisabledFieldset=addCombinator(function(elem){return elem.disabled===!0&&nodeName(elem,"fieldset")},{dir:"parentNode",next:"legend"});function safeActiveElement(){try{return document.activeElement}catch(err){}}
try{push.apply((arr=slice.call(preferredDoc.childNodes)),preferredDoc.childNodes);arr[preferredDoc.childNodes.length].nodeType}catch(e){push={apply:function(target,els){pushNative.apply(target,slice.call(els))},call:function(target){pushNative.apply(target,slice.call(arguments,1))}}}
function find(selector,context,results,seed){var m,i,elem,nid,match,groups,newSelector,newContext=context&&context.ownerDocument,nodeType=context?context.nodeType:9;results=results||[];if(typeof selector!=="string"||!selector||nodeType!==1&&nodeType!==9&&nodeType!==11){return results}
if(!seed){setDocument(context);context=context||document;if(documentIsHTML){if(nodeType!==11&&(match=rquickExpr.exec(selector))){if((m=match[1])){if(nodeType===9){if((elem=context.getElementById(m))){if(elem.id===m){push.call(results,elem);return results}}else{return results}}else{if(newContext&&(elem=newContext.getElementById(m))&&find.contains(context,elem)&&elem.id===m){push.call(results,elem);return results}}}else if(match[2]){push.apply(results,context.getElementsByTagName(selector));return results}else if((m=match[3])&&context.getElementsByClassName){push.apply(results,context.getElementsByClassName(m));return results}}
if(!nonnativeSelectorCache[selector+" "]&&(!rbuggyQSA||!rbuggyQSA.test(selector))){newSelector=selector;newContext=context;if(nodeType===1&&(rdescend.test(selector)||rleadingCombinator.test(selector))){newContext=rsibling.test(selector)&&testContext(context.parentNode)||context;if(newContext!=context||!support.scope){if((nid=context.getAttribute("id"))){nid=jQuery.escapeSelector(nid)}else{context.setAttribute("id",(nid=expando))}}
groups=tokenize(selector);i=groups.length;while(i--){groups[i]=(nid?"#"+nid:":scope")+" "+toSelector(groups[i])}
newSelector=groups.join(",")}
try{push.apply(results,newContext.querySelectorAll(newSelector));return results}catch(qsaError){nonnativeSelectorCache(selector,!0)}finally{if(nid===expando){context.removeAttribute("id")}}}}}
return select(selector.replace(rtrimCSS,"$1"),context,results,seed)}
function createCache(){var keys=[];function cache(key,value){if(keys.push(key+" ")>Expr.cacheLength){delete cache[keys.shift()]}
return(cache[key+" "]=value)}
return cache}
function markFunction(fn){fn[expando]=!0;return fn}
function assert(fn){var el=document.createElement("fieldset");try{return!!fn(el)}catch(e){return!1}finally{if(el.parentNode){el.parentNode.removeChild(el)}
el=null}}
function createInputPseudo(type){return function(elem){return nodeName(elem,"input")&&elem.type===type}}
function createButtonPseudo(type){return function(elem){return(nodeName(elem,"input")||nodeName(elem,"button"))&&elem.type===type}}
function createDisabledPseudo(disabled){return function(elem){if("form" in elem){if(elem.parentNode&&elem.disabled===!1){if("label" in elem){if("label" in elem.parentNode){return elem.parentNode.disabled===disabled}else{return elem.disabled===disabled}}
return elem.isDisabled===disabled||elem.isDisabled!==!disabled&&inDisabledFieldset(elem)===disabled}
return elem.disabled===disabled}else if("label" in elem){return elem.disabled===disabled}
return!1}}
function createPositionalPseudo(fn){return markFunction(function(argument){argument=+argument;return markFunction(function(seed,matches){var j,matchIndexes=fn([],seed.length,argument),i=matchIndexes.length;while(i--){if(seed[(j=matchIndexes[i])]){seed[j]=!(matches[j]=seed[j])}}})})}
function testContext(context){return context&&typeof context.getElementsByTagName!=="undefined"&&context}
function setDocument(node){var subWindow,doc=node?node.ownerDocument||node:preferredDoc;if(doc==document||doc.nodeType!==9||!doc.documentElement){return document}
document=doc;documentElement=document.documentElement;documentIsHTML=!jQuery.isXMLDoc(document);matches=documentElement.matches||documentElement.webkitMatchesSelector||documentElement.msMatchesSelector;if(documentElement.msMatchesSelector&&preferredDoc!=document&&(subWindow=document.defaultView)&&subWindow.top!==subWindow){subWindow.addEventListener("unload",unloadHandler)}
support.getById=assert(function(el){documentElement.appendChild(el).id=jQuery.expando;return!document.getElementsByName||!document.getElementsByName(jQuery.expando).length});support.disconnectedMatch=assert(function(el){return matches.call(el,"*")});support.scope=assert(function(){return document.querySelectorAll(":scope")});support.cssHas=assert(function(){try{document.querySelector(":has(*,:jqfake)");return!1}catch(e){return!0}});if(support.getById){Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){return elem.getAttribute("id")===attrId}};Expr.find.ID=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var elem=context.getElementById(id);return elem?[elem]:[]}}}else{Expr.filter.ID=function(id){var attrId=id.replace(runescape,funescape);return function(elem){var node=typeof elem.getAttributeNode!=="undefined"&&elem.getAttributeNode("id");return node&&node.value===attrId}};Expr.find.ID=function(id,context){if(typeof context.getElementById!=="undefined"&&documentIsHTML){var node,i,elems,elem=context.getElementById(id);if(elem){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}
elems=context.getElementsByName(id);i=0;while((elem=elems[i++])){node=elem.getAttributeNode("id");if(node&&node.value===id){return[elem]}}}
return[]}}}
Expr.find.TAG=function(tag,context){if(typeof context.getElementsByTagName!=="undefined"){return context.getElementsByTagName(tag)}else{return context.querySelectorAll(tag)}};Expr.find.CLASS=function(className,context){if(typeof context.getElementsByClassName!=="undefined"&&documentIsHTML){return context.getElementsByClassName(className)}};rbuggyQSA=[];assert(function(el){var input;documentElement.appendChild(el).innerHTML="<a id='"+expando+"' href='' disabled='disabled'></a>"+"<select id='"+expando+"-\r\\' disabled='disabled'>"+"<option selected=''></option></select>";if(!el.querySelectorAll("[selected]").length){rbuggyQSA.push("\\["+whitespace+"*(?:value|"+booleans+")")}
if(!el.querySelectorAll("[id~="+expando+"-]").length){rbuggyQSA.push("~=")}
if(!el.querySelectorAll("a#"+expando+"+*").length){rbuggyQSA.push(".#.+[+~]")}
if(!el.querySelectorAll(":checked").length){rbuggyQSA.push(":checked")}
input=document.createElement("input");input.setAttribute("type","hidden");el.appendChild(input).setAttribute("name","D");documentElement.appendChild(el).disabled=!0;if(el.querySelectorAll(":disabled").length!==2){rbuggyQSA.push(":enabled",":disabled")}
input=document.createElement("input");input.setAttribute("name","");el.appendChild(input);if(!el.querySelectorAll("[name='']").length){rbuggyQSA.push("\\["+whitespace+"*name"+whitespace+"*="+whitespace+"*(?:''|\"\")")}});if(!support.cssHas){rbuggyQSA.push(":has")}
rbuggyQSA=rbuggyQSA.length&&new RegExp(rbuggyQSA.join("|"));sortOrder=function(a,b){if(a===b){hasDuplicate=!0;return 0}
var compare=!a.compareDocumentPosition-!b.compareDocumentPosition;if(compare){return compare}
compare=(a.ownerDocument||a)==(b.ownerDocument||b)?a.compareDocumentPosition(b):1;if(compare&1||(!support.sortDetached&&b.compareDocumentPosition(a)===compare)){if(a===document||a.ownerDocument==preferredDoc&&find.contains(preferredDoc,a)){return-1}
if(b===document||b.ownerDocument==preferredDoc&&find.contains(preferredDoc,b)){return 1}
return sortInput?(indexOf.call(sortInput,a)-indexOf.call(sortInput,b)):0}
return compare&4?-1:1};return document}
find.matches=function(expr,elements){return find(expr,null,null,elements)};find.matchesSelector=function(elem,expr){setDocument(elem);if(documentIsHTML&&!nonnativeSelectorCache[expr+" "]&&(!rbuggyQSA||!rbuggyQSA.test(expr))){try{var ret=matches.call(elem,expr);if(ret||support.disconnectedMatch||elem.document&&elem.document.nodeType!==11){return ret}}catch(e){nonnativeSelectorCache(expr,!0)}}
return find(expr,document,null,[elem]).length>0};find.contains=function(context,elem){if((context.ownerDocument||context)!=document){setDocument(context)}
return jQuery.contains(context,elem)};find.attr=function(elem,name){if((elem.ownerDocument||elem)!=document){setDocument(elem)}
var fn=Expr.attrHandle[name.toLowerCase()],val=fn&&hasOwn.call(Expr.attrHandle,name.toLowerCase())?fn(elem,name,!documentIsHTML):undefined;if(val!==undefined){return val}
return elem.getAttribute(name)};find.error=function(msg){throw new Error("Syntax error, unrecognized expression: "+msg)};jQuery.uniqueSort=function(results){var elem,duplicates=[],j=0,i=0;hasDuplicate=!support.sortStable;sortInput=!support.sortStable&&slice.call(results,0);sort.call(results,sortOrder);if(hasDuplicate){while((elem=results[i++])){if(elem===results[i]){j=duplicates.push(i)}}
while(j--){splice.call(results,duplicates[j],1)}}
sortInput=null;return results};jQuery.fn.uniqueSort=function(){return this.pushStack(jQuery.uniqueSort(slice.apply(this)))};Expr=jQuery.expr={cacheLength:50,createPseudo:markFunction,match:matchExpr,attrHandle:{},find:{},relative:{">":{dir:"parentNode",first:!0}," ":{dir:"parentNode"},"+":{dir:"previousSibling",first:!0},"~":{dir:"previousSibling"}},preFilter:{ATTR:function(match){match[1]=match[1].replace(runescape,funescape);match[3]=(match[3]||match[4]||match[5]||"").replace(runescape,funescape);if(match[2]==="~="){match[3]=" "+match[3]+" "}
return match.slice(0,4)},CHILD:function(match){match[1]=match[1].toLowerCase();if(match[1].slice(0,3)==="nth"){if(!match[3]){find.error(match[0])}
match[4]=+(match[4]?match[5]+(match[6]||1):2*(match[3]==="even"||match[3]==="odd"));match[5]=+((match[7]+match[8])||match[3]==="odd")}else if(match[3]){find.error(match[0])}
return match},PSEUDO:function(match){var excess,unquoted=!match[6]&&match[2];if(matchExpr.CHILD.test(match[0])){return null}
if(match[3]){match[2]=match[4]||match[5]||""}else if(unquoted&&rpseudo.test(unquoted)&&(excess=tokenize(unquoted,!0))&&(excess=unquoted.indexOf(")",unquoted.length-excess)-unquoted.length)){match[0]=match[0].slice(0,excess);match[2]=unquoted.slice(0,excess)}
return match.slice(0,3)}},filter:{TAG:function(nodeNameSelector){var expectedNodeName=nodeNameSelector.replace(runescape,funescape).toLowerCase();return nodeNameSelector==="*"?function(){return!0}:function(elem){return nodeName(elem,expectedNodeName)}},CLASS:function(className){var pattern=classCache[className+" "];return pattern||(pattern=new RegExp("(^|"+whitespace+")"+className+"("+whitespace+"|$)"))&&classCache(className,function(elem){return pattern.test(typeof elem.className==="string"&&elem.className||typeof elem.getAttribute!=="undefined"&&elem.getAttribute("class")||"")})},ATTR:function(name,operator,check){return function(elem){var result=find.attr(elem,name);if(result==null){return operator==="!="}
if(!operator){return!0}
result+="";if(operator==="="){return result===check}
if(operator==="!="){return result!==check}
if(operator==="^="){return check&&result.indexOf(check)===0}
if(operator==="*="){return check&&result.indexOf(check)>-1}
if(operator==="$="){return check&&result.slice(-check.length)===check}
if(operator==="~="){return(" "+result.replace(rwhitespace," ")+" ").indexOf(check)>-1}
if(operator==="|="){return result===check||result.slice(0,check.length+1)===check+"-"}
return!1}},CHILD:function(type,what,_argument,first,last){var simple=type.slice(0,3)!=="nth",forward=type.slice(-4)!=="last",ofType=what==="of-type";return first===1&&last===0?function(elem){return!!elem.parentNode}:function(elem,_context,xml){var cache,outerCache,node,nodeIndex,start,dir=simple!==forward?"nextSibling":"previousSibling",parent=elem.parentNode,name=ofType&&elem.nodeName.toLowerCase(),useCache=!xml&&!ofType,diff=!1;if(parent){if(simple){while(dir){node=elem;while((node=node[dir])){if(ofType?nodeName(node,name):node.nodeType===1){return!1}}
start=dir=type==="only"&&!start&&"nextSibling"}
return!0}
start=[forward?parent.firstChild:parent.lastChild];if(forward&&useCache){outerCache=parent[expando]||(parent[expando]={});cache=outerCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex&&cache[2];node=nodeIndex&&parent.childNodes[nodeIndex];while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if(node.nodeType===1&&++diff&&node===elem){outerCache[type]=[dirruns,nodeIndex,diff];break}}}else{if(useCache){outerCache=elem[expando]||(elem[expando]={});cache=outerCache[type]||[];nodeIndex=cache[0]===dirruns&&cache[1];diff=nodeIndex}
if(diff===!1){while((node=++nodeIndex&&node&&node[dir]||(diff=nodeIndex=0)||start.pop())){if((ofType?nodeName(node,name):node.nodeType===1)&&++diff){if(useCache){outerCache=node[expando]||(node[expando]={});outerCache[type]=[dirruns,diff]}
if(node===elem){break}}}}}
diff-=last;return diff===first||(diff%first===0&&diff/first>=0)}}},PSEUDO:function(pseudo,argument){var args,fn=Expr.pseudos[pseudo]||Expr.setFilters[pseudo.toLowerCase()]||find.error("unsupported pseudo: "+pseudo);if(fn[expando]){return fn(argument)}
if(fn.length>1){args=[pseudo,pseudo,"",argument];return Expr.setFilters.hasOwnProperty(pseudo.toLowerCase())?markFunction(function(seed,matches){var idx,matched=fn(seed,argument),i=matched.length;while(i--){idx=indexOf.call(seed,matched[i]);seed[idx]=!(matches[idx]=matched[i])}}):function(elem){return fn(elem,0,args)}}
return fn}},pseudos:{not:markFunction(function(selector){var input=[],results=[],matcher=compile(selector.replace(rtrimCSS,"$1"));return matcher[expando]?markFunction(function(seed,matches,_context,xml){var elem,unmatched=matcher(seed,null,xml,[]),i=seed.length;while(i--){if((elem=unmatched[i])){seed[i]=!(matches[i]=elem)}}}):function(elem,_context,xml){input[0]=elem;matcher(input,null,xml,results);input[0]=null;return!results.pop()}}),has:markFunction(function(selector){return function(elem){return find(selector,elem).length>0}}),contains:markFunction(function(text){text=text.replace(runescape,funescape);return function(elem){return(elem.textContent||jQuery.text(elem)).indexOf(text)>-1}}),lang:markFunction(function(lang){if(!ridentifier.test(lang||"")){find.error("unsupported lang: "+lang)}
lang=lang.replace(runescape,funescape).toLowerCase();return function(elem){var elemLang;do{if((elemLang=documentIsHTML?elem.lang:elem.getAttribute("xml:lang")||elem.getAttribute("lang"))){elemLang=elemLang.toLowerCase();return elemLang===lang||elemLang.indexOf(lang+"-")===0}}while((elem=elem.parentNode)&&elem.nodeType===1);return!1}}),target:function(elem){var hash=window.location&&window.location.hash;return hash&&hash.slice(1)===elem.id},root:function(elem){return elem===documentElement},focus:function(elem){return elem===safeActiveElement()&&document.hasFocus()&&!!(elem.type||elem.href||~elem.tabIndex)},enabled:createDisabledPseudo(!1),disabled:createDisabledPseudo(!0),checked:function(elem){return(nodeName(elem,"input")&&!!elem.checked)||(nodeName(elem,"option")&&!!elem.selected)},selected:function(elem){if(elem.parentNode){elem.parentNode.selectedIndex}
return elem.selected===!0},empty:function(elem){for(elem=elem.firstChild;elem;elem=elem.nextSibling){if(elem.nodeType<6){return!1}}
return!0},parent:function(elem){return!Expr.pseudos.empty(elem)},header:function(elem){return rheader.test(elem.nodeName)},input:function(elem){return rinputs.test(elem.nodeName)},button:function(elem){return nodeName(elem,"input")&&elem.type==="button"||nodeName(elem,"button")},text:function(elem){var attr;return nodeName(elem,"input")&&elem.type==="text"&&((attr=elem.getAttribute("type"))==null||attr.toLowerCase()==="text")},first:createPositionalPseudo(function(){return[0]}),last:createPositionalPseudo(function(_matchIndexes,length){return[length-1]}),eq:createPositionalPseudo(function(_matchIndexes,length,argument){return[argument<0?argument+length:argument]}),even:createPositionalPseudo(function(matchIndexes,length){var i=0;for(;i<length;i+=2){matchIndexes.push(i)}
return matchIndexes}),odd:createPositionalPseudo(function(matchIndexes,length){var i=1;for(;i<length;i+=2){matchIndexes.push(i)}
return matchIndexes}),lt:createPositionalPseudo(function(matchIndexes,length,argument){var i;if(argument<0){i=argument+length}else if(argument>length){i=length}else{i=argument}
for(;--i>=0;){matchIndexes.push(i)}
return matchIndexes}),gt:createPositionalPseudo(function(matchIndexes,length,argument){var i=argument<0?argument+length:argument;for(;++i<length;){matchIndexes.push(i)}
return matchIndexes})}};Expr.pseudos.nth=Expr.pseudos.eq;for(i in{radio:!0,checkbox:!0,file:!0,password:!0,image:!0}){Expr.pseudos[i]=createInputPseudo(i)}
for(i in{submit:!0,reset:!0}){Expr.pseudos[i]=createButtonPseudo(i)}
function setFilters(){}
setFilters.prototype=Expr.filters=Expr.pseudos;Expr.setFilters=new setFilters();function tokenize(selector,parseOnly){var matched,match,tokens,type,soFar,groups,preFilters,cached=tokenCache[selector+" "];if(cached){return parseOnly?0:cached.slice(0)}
soFar=selector;groups=[];preFilters=Expr.preFilter;while(soFar){if(!matched||(match=rcomma.exec(soFar))){if(match){soFar=soFar.slice(match[0].length)||soFar}
groups.push((tokens=[]))}
matched=!1;if((match=rleadingCombinator.exec(soFar))){matched=match.shift();tokens.push({value:matched,type:match[0].replace(rtrimCSS," ")});soFar=soFar.slice(matched.length)}
for(type in Expr.filter){if((match=matchExpr[type].exec(soFar))&&(!preFilters[type]||(match=preFilters[type](match)))){matched=match.shift();tokens.push({value:matched,type:type,matches:match});soFar=soFar.slice(matched.length)}}
if(!matched){break}}
if(parseOnly){return soFar.length}
return soFar?find.error(selector):tokenCache(selector,groups).slice(0)}
function toSelector(tokens){var i=0,len=tokens.length,selector="";for(;i<len;i++){selector+=tokens[i].value}
return selector}
function addCombinator(matcher,combinator,base){var dir=combinator.dir,skip=combinator.next,key=skip||dir,checkNonElements=base&&key==="parentNode",doneName=done++;return combinator.first?function(elem,context,xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){return matcher(elem,context,xml)}}
return!1}:function(elem,context,xml){var oldCache,outerCache,newCache=[dirruns,doneName];if(xml){while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){if(matcher(elem,context,xml)){return!0}}}}else{while((elem=elem[dir])){if(elem.nodeType===1||checkNonElements){outerCache=elem[expando]||(elem[expando]={});if(skip&&nodeName(elem,skip)){elem=elem[dir]||elem}else if((oldCache=outerCache[key])&&oldCache[0]===dirruns&&oldCache[1]===doneName){return(newCache[2]=oldCache[2])}else{outerCache[key]=newCache;if((newCache[2]=matcher(elem,context,xml))){return!0}}}}}
return!1}}
function elementMatcher(matchers){return matchers.length>1?function(elem,context,xml){var i=matchers.length;while(i--){if(!matchers[i](elem,context,xml)){return!1}}
return!0}:matchers[0]}
function multipleContexts(selector,contexts,results){var i=0,len=contexts.length;for(;i<len;i++){find(selector,contexts[i],results)}
return results}
function condense(unmatched,map,filter,context,xml){var elem,newUnmatched=[],i=0,len=unmatched.length,mapped=map!=null;for(;i<len;i++){if((elem=unmatched[i])){if(!filter||filter(elem,context,xml)){newUnmatched.push(elem);if(mapped){map.push(i)}}}}
return newUnmatched}
function setMatcher(preFilter,selector,matcher,postFilter,postFinder,postSelector){if(postFilter&&!postFilter[expando]){postFilter=setMatcher(postFilter)}
if(postFinder&&!postFinder[expando]){postFinder=setMatcher(postFinder,postSelector)}
return markFunction(function(seed,results,context,xml){var temp,i,elem,matcherOut,preMap=[],postMap=[],preexisting=results.length,elems=seed||multipleContexts(selector||"*",context.nodeType?[context]:context,[]),matcherIn=preFilter&&(seed||!selector)?condense(elems,preMap,preFilter,context,xml):elems;if(matcher){matcherOut=postFinder||(seed?preFilter:preexisting||postFilter)?[]:results;matcher(matcherIn,matcherOut,context,xml)}else{matcherOut=matcherIn}
if(postFilter){temp=condense(matcherOut,postMap);postFilter(temp,[],context,xml);i=temp.length;while(i--){if((elem=temp[i])){matcherOut[postMap[i]]=!(matcherIn[postMap[i]]=elem)}}}
if(seed){if(postFinder||preFilter){if(postFinder){temp=[];i=matcherOut.length;while(i--){if((elem=matcherOut[i])){temp.push((matcherIn[i]=elem))}}
postFinder(null,(matcherOut=[]),temp,xml)}
i=matcherOut.length;while(i--){if((elem=matcherOut[i])&&(temp=postFinder?indexOf.call(seed,elem):preMap[i])>-1){seed[temp]=!(results[temp]=elem)}}}}else{matcherOut=condense(matcherOut===results?matcherOut.splice(preexisting,matcherOut.length):matcherOut);if(postFinder){postFinder(null,results,matcherOut,xml)}else{push.apply(results,matcherOut)}}})}
function matcherFromTokens(tokens){var checkContext,matcher,j,len=tokens.length,leadingRelative=Expr.relative[tokens[0].type],implicitRelative=leadingRelative||Expr.relative[" "],i=leadingRelative?1:0,matchContext=addCombinator(function(elem){return elem===checkContext},implicitRelative,!0),matchAnyContext=addCombinator(function(elem){return indexOf.call(checkContext,elem)>-1},implicitRelative,!0),matchers=[function(elem,context,xml){var ret=(!leadingRelative&&(xml||context!=outermostContext))||((checkContext=context).nodeType?matchContext(elem,context,xml):matchAnyContext(elem,context,xml));checkContext=null;return ret}];for(;i<len;i++){if((matcher=Expr.relative[tokens[i].type])){matchers=[addCombinator(elementMatcher(matchers),matcher)]}else{matcher=Expr.filter[tokens[i].type].apply(null,tokens[i].matches);if(matcher[expando]){j=++i;for(;j<len;j++){if(Expr.relative[tokens[j].type]){break}}
return setMatcher(i>1&&elementMatcher(matchers),i>1&&toSelector(tokens.slice(0,i-1).concat({value:tokens[i-2].type===" "?"*":""})).replace(rtrimCSS,"$1"),matcher,i<j&&matcherFromTokens(tokens.slice(i,j)),j<len&&matcherFromTokens((tokens=tokens.slice(j))),j<len&&toSelector(tokens))}
matchers.push(matcher)}}
return elementMatcher(matchers)}
function matcherFromGroupMatchers(elementMatchers,setMatchers){var bySet=setMatchers.length>0,byElement=elementMatchers.length>0,superMatcher=function(seed,context,xml,results,outermost){var elem,j,matcher,matchedCount=0,i="0",unmatched=seed&&[],setMatched=[],contextBackup=outermostContext,elems=seed||byElement&&Expr.find.TAG("*",outermost),dirrunsUnique=(dirruns+=contextBackup==null?1:Math.random()||0.1),len=elems.length;if(outermost){outermostContext=context==document||context||outermost}
for(;i!==len&&(elem=elems[i])!=null;i++){if(byElement&&elem){j=0;if(!context&&elem.ownerDocument!=document){setDocument(elem);xml=!documentIsHTML}
while((matcher=elementMatchers[j++])){if(matcher(elem,context||document,xml)){push.call(results,elem);break}}
if(outermost){dirruns=dirrunsUnique}}
if(bySet){if((elem=!matcher&&elem)){matchedCount--}
if(seed){unmatched.push(elem)}}}
matchedCount+=i;if(bySet&&i!==matchedCount){j=0;while((matcher=setMatchers[j++])){matcher(unmatched,setMatched,context,xml)}
if(seed){if(matchedCount>0){while(i--){if(!(unmatched[i]||setMatched[i])){setMatched[i]=pop.call(results)}}}
setMatched=condense(setMatched)}
push.apply(results,setMatched);if(outermost&&!seed&&setMatched.length>0&&(matchedCount+setMatchers.length)>1){jQuery.uniqueSort(results)}}
if(outermost){dirruns=dirrunsUnique;outermostContext=contextBackup}
return unmatched};return bySet?markFunction(superMatcher):superMatcher}
function compile(selector,match){var i,setMatchers=[],elementMatchers=[],cached=compilerCache[selector+" "];if(!cached){if(!match){match=tokenize(selector)}
i=match.length;while(i--){cached=matcherFromTokens(match[i]);if(cached[expando]){setMatchers.push(cached)}else{elementMatchers.push(cached)}}
cached=compilerCache(selector,matcherFromGroupMatchers(elementMatchers,setMatchers));cached.selector=selector}
return cached}
function select(selector,context,results,seed){var i,tokens,token,type,find,compiled=typeof selector==="function"&&selector,match=!seed&&tokenize((selector=compiled.selector||selector));results=results||[];if(match.length===1){tokens=match[0]=match[0].slice(0);if(tokens.length>2&&(token=tokens[0]).type==="ID"&&context.nodeType===9&&documentIsHTML&&Expr.relative[tokens[1].type]){context=(Expr.find.ID(token.matches[0].replace(runescape,funescape),context)||[])[0];if(!context){return results}else if(compiled){context=context.parentNode}
selector=selector.slice(tokens.shift().value.length)}
i=matchExpr.needsContext.test(selector)?0:tokens.length;while(i--){token=tokens[i];if(Expr.relative[(type=token.type)]){break}
if((find=Expr.find[type])){if((seed=find(token.matches[0].replace(runescape,funescape),rsibling.test(tokens[0].type)&&testContext(context.parentNode)||context))){tokens.splice(i,1);selector=seed.length&&toSelector(tokens);if(!selector){push.apply(results,seed);return results}
break}}}}(compiled||compile(selector,match))(seed,context,!documentIsHTML,results,!context||rsibling.test(selector)&&testContext(context.parentNode)||context);return results}
support.sortStable=expando.split("").sort(sortOrder).join("")===expando;setDocument();support.sortDetached=assert(function(el){return el.compareDocumentPosition(document.createElement("fieldset"))&1});jQuery.find=find;jQuery.expr[":"]=jQuery.expr.pseudos;jQuery.unique=jQuery.uniqueSort;find.compile=compile;find.select=select;find.setDocument=setDocument;find.tokenize=tokenize;find.escape=jQuery.escapeSelector;find.getText=jQuery.text;find.isXML=jQuery.isXMLDoc;find.selectors=jQuery.expr;find.support=jQuery.support;find.uniqueSort=jQuery.uniqueSort})();var dir=function(elem,dir,until){var matched=[],truncate=until!==undefined;while((elem=elem[dir])&&elem.nodeType!==9){if(elem.nodeType===1){if(truncate&&jQuery(elem).is(until)){break}
matched.push(elem)}}
return matched};var siblings=function(n,elem){var matched=[];for(;n;n=n.nextSibling){if(n.nodeType===1&&n!==elem){matched.push(n)}}
return matched};var rneedsContext=jQuery.expr.match.needsContext;var rsingleTag=(/^<([a-z][^\/\0>:\x20\t\r\n\f]*)[\x20\t\r\n\f]*\/?>(?:<\/\1>|)$/i);function winnow(elements,qualifier,not){if(isFunction(qualifier)){return jQuery.grep(elements,function(elem,i){return!!qualifier.call(elem,i,elem)!==not})}
if(qualifier.nodeType){return jQuery.grep(elements,function(elem){return(elem===qualifier)!==not})}
if(typeof qualifier!=="string"){return jQuery.grep(elements,function(elem){return(indexOf.call(qualifier,elem)>-1)!==not})}
return jQuery.filter(qualifier,elements,not)}
jQuery.filter=function(expr,elems,not){var elem=elems[0];if(not){expr=":not("+expr+")"}
if(elems.length===1&&elem.nodeType===1){return jQuery.find.matchesSelector(elem,expr)?[elem]:[]}
return jQuery.find.matches(expr,jQuery.grep(elems,function(elem){return elem.nodeType===1}))};jQuery.fn.extend({find:function(selector){var i,ret,len=this.length,self=this;if(typeof selector!=="string"){return this.pushStack(jQuery(selector).filter(function(){for(i=0;i<len;i++){if(jQuery.contains(self[i],this)){return!0}}}))}
ret=this.pushStack([]);for(i=0;i<len;i++){jQuery.find(selector,self[i],ret)}
return len>1?jQuery.uniqueSort(ret):ret},filter:function(selector){return this.pushStack(winnow(this,selector||[],!1))},not:function(selector){return this.pushStack(winnow(this,selector||[],!0))},is:function(selector){return!!winnow(this,typeof selector==="string"&&rneedsContext.test(selector)?jQuery(selector):selector||[],!1).length}});var rootjQuery,rquickExpr=/^(?:\s*(<[\w\W]+>)[^>]*|#([\w-]+))$/,init=jQuery.fn.init=function(selector,context,root){var match,elem;if(!selector){return this}
root=root||rootjQuery;if(typeof selector==="string"){if(selector[0]==="<"&&selector[selector.length-1]===">"&&selector.length>=3){match=[null,selector,null]}else{match=rquickExpr.exec(selector)}
if(match&&(match[1]||!context)){if(match[1]){context=context instanceof jQuery?context[0]:context;jQuery.merge(this,jQuery.parseHTML(match[1],context&&context.nodeType?context.ownerDocument||context:document,!0));if(rsingleTag.test(match[1])&&jQuery.isPlainObject(context)){for(match in context){if(isFunction(this[match])){this[match](context[match])}else{this.attr(match,context[match])}}}
return this}else{elem=document.getElementById(match[2]);if(elem){this[0]=elem;this.length=1}
return this}}else if(!context||context.jquery){return(context||root).find(selector)}else{return this.constructor(context).find(selector)}}else if(selector.nodeType){this[0]=selector;this.length=1;return this}else if(isFunction(selector)){return root.ready!==undefined?root.ready(selector):selector(jQuery)}
return jQuery.makeArray(selector,this)};init.prototype=jQuery.fn;rootjQuery=jQuery(document);var rparentsprev=/^(?:parents|prev(?:Until|All))/,guaranteedUnique={children:!0,contents:!0,next:!0,prev:!0};jQuery.fn.extend({has:function(target){var targets=jQuery(target,this),l=targets.length;return this.filter(function(){var i=0;for(;i<l;i++){if(jQuery.contains(this,targets[i])){return!0}}})},closest:function(selectors,context){var cur,i=0,l=this.length,matched=[],targets=typeof selectors!=="string"&&jQuery(selectors);if(!rneedsContext.test(selectors)){for(;i<l;i++){for(cur=this[i];cur&&cur!==context;cur=cur.parentNode){if(cur.nodeType<11&&(targets?targets.index(cur)>-1:cur.nodeType===1&&jQuery.find.matchesSelector(cur,selectors))){matched.push(cur);break}}}}
return this.pushStack(matched.length>1?jQuery.uniqueSort(matched):matched)},index:function(elem){if(!elem){return(this[0]&&this[0].parentNode)?this.first().prevAll().length:-1}
if(typeof elem==="string"){return indexOf.call(jQuery(elem),this[0])}
return indexOf.call(this,elem.jquery?elem[0]:elem)},add:function(selector,context){return this.pushStack(jQuery.uniqueSort(jQuery.merge(this.get(),jQuery(selector,context))))},addBack:function(selector){return this.add(selector==null?this.prevObject:this.prevObject.filter(selector))}});function sibling(cur,dir){while((cur=cur[dir])&&cur.nodeType!==1){}
return cur}
jQuery.each({parent:function(elem){var parent=elem.parentNode;return parent&&parent.nodeType!==11?parent:null},parents:function(elem){return dir(elem,"parentNode")},parentsUntil:function(elem,_i,until){return dir(elem,"parentNode",until)},next:function(elem){return sibling(elem,"nextSibling")},prev:function(elem){return sibling(elem,"previousSibling")},nextAll:function(elem){return dir(elem,"nextSibling")},prevAll:function(elem){return dir(elem,"previousSibling")},nextUntil:function(elem,_i,until){return dir(elem,"nextSibling",until)},prevUntil:function(elem,_i,until){return dir(elem,"previousSibling",until)},siblings:function(elem){return siblings((elem.parentNode||{}).firstChild,elem)},children:function(elem){return siblings(elem.firstChild)},contents:function(elem){if(elem.contentDocument!=null&&getProto(elem.contentDocument)){return elem.contentDocument}
if(nodeName(elem,"template")){elem=elem.content||elem}
return jQuery.merge([],elem.childNodes)}},function(name,fn){jQuery.fn[name]=function(until,selector){var matched=jQuery.map(this,fn,until);if(name.slice(-5)!=="Until"){selector=until}
if(selector&&typeof selector==="string"){matched=jQuery.filter(selector,matched)}
if(this.length>1){if(!guaranteedUnique[name]){jQuery.uniqueSort(matched)}
if(rparentsprev.test(name)){matched.reverse()}}
return this.pushStack(matched)}});var rnothtmlwhite=(/[^\x20\t\r\n\f]+/g);function createOptions(options){var object={};jQuery.each(options.match(rnothtmlwhite)||[],function(_,flag){object[flag]=!0});return object}
jQuery.Callbacks=function(options){options=typeof options==="string"?createOptions(options):jQuery.extend({},options);var firing,memory,fired,locked,list=[],queue=[],firingIndex=-1,fire=function(){locked=locked||options.once;fired=firing=!0;for(;queue.length;firingIndex=-1){memory=queue.shift();while(++firingIndex<list.length){if(list[firingIndex].apply(memory[0],memory[1])===!1&&options.stopOnFalse){firingIndex=list.length;memory=!1}}}
if(!options.memory){memory=!1}
firing=!1;if(locked){if(memory){list=[]}else{list=""}}},self={add:function(){if(list){if(memory&&!firing){firingIndex=list.length-1;queue.push(memory)}(function add(args){jQuery.each(args,function(_,arg){if(isFunction(arg)){if(!options.unique||!self.has(arg)){list.push(arg)}}else if(arg&&arg.length&&toType(arg)!=="string"){add(arg)}})})(arguments);if(memory&&!firing){fire()}}
return this},remove:function(){jQuery.each(arguments,function(_,arg){var index;while((index=jQuery.inArray(arg,list,index))>-1){list.splice(index,1);if(index<=firingIndex){firingIndex--}}});return this},has:function(fn){return fn?jQuery.inArray(fn,list)>-1:list.length>0},empty:function(){if(list){list=[]}
return this},disable:function(){locked=queue=[];list=memory="";return this},disabled:function(){return!list},lock:function(){locked=queue=[];if(!memory&&!firing){list=memory=""}
return this},locked:function(){return!!locked},fireWith:function(context,args){if(!locked){args=args||[];args=[context,args.slice?args.slice():args];queue.push(args);if(!firing){fire()}}
return this},fire:function(){self.fireWith(this,arguments);return this},fired:function(){return!!fired}};return self};function Identity(v){return v}
function Thrower(ex){throw ex}
function adoptValue(value,resolve,reject,noValue){var method;try{if(value&&isFunction((method=value.promise))){method.call(value).done(resolve).fail(reject)}else if(value&&isFunction((method=value.then))){method.call(value,resolve,reject)}else{resolve.apply(undefined,[value].slice(noValue))}}catch(value){reject.apply(undefined,[value])}}
jQuery.extend({Deferred:function(func){var tuples=[["notify","progress",jQuery.Callbacks("memory"),jQuery.Callbacks("memory"),2],["resolve","done",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),0,"resolved"],["reject","fail",jQuery.Callbacks("once memory"),jQuery.Callbacks("once memory"),1,"rejected"]],state="pending",promise={state:function(){return state},always:function(){deferred.done(arguments).fail(arguments);return this},"catch":function(fn){return promise.then(null,fn)},pipe:function(){var fns=arguments;return jQuery.Deferred(function(newDefer){jQuery.each(tuples,function(_i,tuple){var fn=isFunction(fns[tuple[4]])&&fns[tuple[4]];deferred[tuple[1]](function(){var returned=fn&&fn.apply(this,arguments);if(returned&&isFunction(returned.promise)){returned.promise().progress(newDefer.notify).done(newDefer.resolve).fail(newDefer.reject)}else{newDefer[tuple[0]+"With"](this,fn?[returned]:arguments)}})});fns=null}).promise()},then:function(onFulfilled,onRejected,onProgress){var maxDepth=0;function resolve(depth,deferred,handler,special){return function(){var that=this,args=arguments,mightThrow=function(){var returned,then;if(depth<maxDepth){return}
returned=handler.apply(that,args);if(returned===deferred.promise()){throw new TypeError("Thenable self-resolution")}
then=returned&&(typeof returned==="object"||typeof returned==="function")&&returned.then;if(isFunction(then)){if(special){then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special))}else{maxDepth++;then.call(returned,resolve(maxDepth,deferred,Identity,special),resolve(maxDepth,deferred,Thrower,special),resolve(maxDepth,deferred,Identity,deferred.notifyWith))}}else{if(handler!==Identity){that=undefined;args=[returned]}(special||deferred.resolveWith)(that,args)}},process=special?mightThrow:function(){try{mightThrow()}catch(e){if(jQuery.Deferred.exceptionHook){jQuery.Deferred.exceptionHook(e,process.error)}
if(depth+1>=maxDepth){if(handler!==Thrower){that=undefined;args=[e]}
deferred.rejectWith(that,args)}}};if(depth){process()}else{if(jQuery.Deferred.getErrorHook){process.error=jQuery.Deferred.getErrorHook()}else if(jQuery.Deferred.getStackHook){process.error=jQuery.Deferred.getStackHook()}
window.setTimeout(process)}}}
return jQuery.Deferred(function(newDefer){tuples[0][3].add(resolve(0,newDefer,isFunction(onProgress)?onProgress:Identity,newDefer.notifyWith));tuples[1][3].add(resolve(0,newDefer,isFunction(onFulfilled)?onFulfilled:Identity));tuples[2][3].add(resolve(0,newDefer,isFunction(onRejected)?onRejected:Thrower))}).promise()},promise:function(obj){return obj!=null?jQuery.extend(obj,promise):promise}},deferred={};jQuery.each(tuples,function(i,tuple){var list=tuple[2],stateString=tuple[5];promise[tuple[1]]=list.add;if(stateString){list.add(function(){state=stateString},tuples[3-i][2].disable,tuples[3-i][3].disable,tuples[0][2].lock,tuples[0][3].lock)}
list.add(tuple[3].fire);deferred[tuple[0]]=function(){deferred[tuple[0]+"With"](this===deferred?undefined:this,arguments);return this};deferred[tuple[0]+"With"]=list.fireWith});promise.promise(deferred);if(func){func.call(deferred,deferred)}
return deferred},when:function(singleValue){var
remaining=arguments.length,i=remaining,resolveContexts=Array(i),resolveValues=slice.call(arguments),primary=jQuery.Deferred(),updateFunc=function(i){return function(value){resolveContexts[i]=this;resolveValues[i]=arguments.length>1?slice.call(arguments):value;if(!(--remaining)){primary.resolveWith(resolveContexts,resolveValues)}}};if(remaining<=1){adoptValue(singleValue,primary.done(updateFunc(i)).resolve,primary.reject,!remaining);if(primary.state()==="pending"||isFunction(resolveValues[i]&&resolveValues[i].then)){return primary.then()}}
while(i--){adoptValue(resolveValues[i],updateFunc(i),primary.reject)}
return primary.promise()}});var rerrorNames=/^(Eval|Internal|Range|Reference|Syntax|Type|URI)Error$/;jQuery.Deferred.exceptionHook=function(error,asyncError){if(window.console&&window.console.warn&&error&&rerrorNames.test(error.name)){window.console.warn("jQuery.Deferred exception: "+error.message,error.stack,asyncError)}};jQuery.readyException=function(error){window.setTimeout(function(){throw error})};var readyList=jQuery.Deferred();jQuery.fn.ready=function(fn){readyList.then(fn).catch(function(error){jQuery.readyException(error)});return this};jQuery.extend({isReady:!1,readyWait:1,ready:function(wait){if(wait===!0?--jQuery.readyWait:jQuery.isReady){return}
jQuery.isReady=!0;if(wait!==!0&&--jQuery.readyWait>0){return}
readyList.resolveWith(document,[jQuery])}});jQuery.ready.then=readyList.then;function completed(){document.removeEventListener("DOMContentLoaded",completed);window.removeEventListener("load",completed);jQuery.ready()}
if(document.readyState==="complete"||(document.readyState!=="loading"&&!document.documentElement.doScroll)){window.setTimeout(jQuery.ready)}else{document.addEventListener("DOMContentLoaded",completed);window.addEventListener("load",completed)}
var access=function(elems,fn,key,value,chainable,emptyGet,raw){var i=0,len=elems.length,bulk=key==null;if(toType(key)==="object"){chainable=!0;for(i in key){access(elems,fn,i,key[i],!0,emptyGet,raw)}}else if(value!==undefined){chainable=!0;if(!isFunction(value)){raw=!0}
if(bulk){if(raw){fn.call(elems,value);fn=null}else{bulk=fn;fn=function(elem,_key,value){return bulk.call(jQuery(elem),value)}}}
if(fn){for(;i<len;i++){fn(elems[i],key,raw?value:value.call(elems[i],i,fn(elems[i],key)))}}}
if(chainable){return elems}
if(bulk){return fn.call(elems)}
return len?fn(elems[0],key):emptyGet};var rmsPrefix=/^-ms-/,rdashAlpha=/-([a-z])/g;function fcamelCase(_all,letter){return letter.toUpperCase()}
function camelCase(string){return string.replace(rmsPrefix,"ms-").replace(rdashAlpha,fcamelCase)}
var acceptData=function(owner){return owner.nodeType===1||owner.nodeType===9||!(+owner.nodeType)};function Data(){this.expando=jQuery.expando+Data.uid++}
Data.uid=1;Data.prototype={cache:function(owner){var value=owner[this.expando];if(!value){value={};if(acceptData(owner)){if(owner.nodeType){owner[this.expando]=value}else{Object.defineProperty(owner,this.expando,{value:value,configurable:!0})}}}
return value},set:function(owner,data,value){var prop,cache=this.cache(owner);if(typeof data==="string"){cache[camelCase(data)]=value}else{for(prop in data){cache[camelCase(prop)]=data[prop]}}
return cache},get:function(owner,key){return key===undefined?this.cache(owner):owner[this.expando]&&owner[this.expando][camelCase(key)]},access:function(owner,key,value){if(key===undefined||((key&&typeof key==="string")&&value===undefined)){return this.get(owner,key)}
this.set(owner,key,value);return value!==undefined?value:key},remove:function(owner,key){var i,cache=owner[this.expando];if(cache===undefined){return}
if(key!==undefined){if(Array.isArray(key)){key=key.map(camelCase)}else{key=camelCase(key);key=key in cache?[key]:(key.match(rnothtmlwhite)||[])}
i=key.length;while(i--){delete cache[key[i]]}}
if(key===undefined||jQuery.isEmptyObject(cache)){if(owner.nodeType){owner[this.expando]=undefined}else{delete owner[this.expando]}}},hasData:function(owner){var cache=owner[this.expando];return cache!==undefined&&!jQuery.isEmptyObject(cache)}};var dataPriv=new Data();var dataUser=new Data();var rbrace=/^(?:\{[\w\W]*\}|\[[\w\W]*\])$/,rmultiDash=/[A-Z]/g;function getData(data){if(data==="true"){return!0}
if(data==="false"){return!1}
if(data==="null"){return null}
if(data===+data+""){return+data}
if(rbrace.test(data)){return JSON.parse(data)}
return data}
function dataAttr(elem,key,data){var name;if(data===undefined&&elem.nodeType===1){name="data-"+key.replace(rmultiDash,"-$&").toLowerCase();data=elem.getAttribute(name);if(typeof data==="string"){try{data=getData(data)}catch(e){}
dataUser.set(elem,key,data)}else{data=undefined}}
return data}
jQuery.extend({hasData:function(elem){return dataUser.hasData(elem)||dataPriv.hasData(elem)},data:function(elem,name,data){return dataUser.access(elem,name,data)},removeData:function(elem,name){dataUser.remove(elem,name)},_data:function(elem,name,data){return dataPriv.access(elem,name,data)},_removeData:function(elem,name){dataPriv.remove(elem,name)}});jQuery.fn.extend({data:function(key,value){var i,name,data,elem=this[0],attrs=elem&&elem.attributes;if(key===undefined){if(this.length){data=dataUser.get(elem);if(elem.nodeType===1&&!dataPriv.get(elem,"hasDataAttrs")){i=attrs.length;while(i--){if(attrs[i]){name=attrs[i].name;if(name.indexOf("data-")===0){name=camelCase(name.slice(5));dataAttr(elem,name,data[name])}}}
dataPriv.set(elem,"hasDataAttrs",!0)}}
return data}
if(typeof key==="object"){return this.each(function(){dataUser.set(this,key)})}
return access(this,function(value){var data;if(elem&&value===undefined){data=dataUser.get(elem,key);if(data!==undefined){return data}
data=dataAttr(elem,key);if(data!==undefined){return data}
return}
this.each(function(){dataUser.set(this,key,value)})},null,value,arguments.length>1,null,!0)},removeData:function(key){return this.each(function(){dataUser.remove(this,key)})}});jQuery.extend({queue:function(elem,type,data){var queue;if(elem){type=(type||"fx")+"queue";queue=dataPriv.get(elem,type);if(data){if(!queue||Array.isArray(data)){queue=dataPriv.access(elem,type,jQuery.makeArray(data))}else{queue.push(data)}}
return queue||[]}},dequeue:function(elem,type){type=type||"fx";var queue=jQuery.queue(elem,type),startLength=queue.length,fn=queue.shift(),hooks=jQuery._queueHooks(elem,type),next=function(){jQuery.dequeue(elem,type)};if(fn==="inprogress"){fn=queue.shift();startLength--}
if(fn){if(type==="fx"){queue.unshift("inprogress")}
delete hooks.stop;fn.call(elem,next,hooks)}
if(!startLength&&hooks){hooks.empty.fire()}},_queueHooks:function(elem,type){var key=type+"queueHooks";return dataPriv.get(elem,key)||dataPriv.access(elem,key,{empty:jQuery.Callbacks("once memory").add(function(){dataPriv.remove(elem,[type+"queue",key])})})}});jQuery.fn.extend({queue:function(type,data){var setter=2;if(typeof type!=="string"){data=type;type="fx";setter--}
if(arguments.length<setter){return jQuery.queue(this[0],type)}
return data===undefined?this:this.each(function(){var queue=jQuery.queue(this,type,data);jQuery._queueHooks(this,type);if(type==="fx"&&queue[0]!=="inprogress"){jQuery.dequeue(this,type)}})},dequeue:function(type){return this.each(function(){jQuery.dequeue(this,type)})},clearQueue:function(type){return this.queue(type||"fx",[])},promise:function(type,obj){var tmp,count=1,defer=jQuery.Deferred(),elements=this,i=this.length,resolve=function(){if(!(--count)){defer.resolveWith(elements,[elements])}};if(typeof type!=="string"){obj=type;type=undefined}
type=type||"fx";while(i--){tmp=dataPriv.get(elements[i],type+"queueHooks");if(tmp&&tmp.empty){count++;tmp.empty.add(resolve)}}
resolve();return defer.promise(obj)}});var pnum=(/[+-]?(?:\d*\.|)\d+(?:[eE][+-]?\d+|)/).source;var rcssNum=new RegExp("^(?:([+-])=|)("+pnum+")([a-z%]*)$","i");var cssExpand=["Top","Right","Bottom","Left"];var documentElement=document.documentElement;var isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)},composed={composed:!0};if(documentElement.getRootNode){isAttached=function(elem){return jQuery.contains(elem.ownerDocument,elem)||elem.getRootNode(composed)===elem.ownerDocument}}
var isHiddenWithinTree=function(elem,el){elem=el||elem;return elem.style.display==="none"||elem.style.display===""&&isAttached(elem)&&jQuery.css(elem,"display")==="none"};function adjustCSS(elem,prop,valueParts,tween){var adjusted,scale,maxIterations=20,currentValue=tween?function(){return tween.cur()}:function(){return jQuery.css(elem,prop,"")},initial=currentValue(),unit=valueParts&&valueParts[3]||(jQuery.cssNumber[prop]?"":"px"),initialInUnit=elem.nodeType&&(jQuery.cssNumber[prop]||unit!=="px"&&+initial)&&rcssNum.exec(jQuery.css(elem,prop));if(initialInUnit&&initialInUnit[3]!==unit){initial=initial/2;unit=unit||initialInUnit[3];initialInUnit=+initial||1;while(maxIterations--){jQuery.style(elem,prop,initialInUnit+unit);if((1-scale)*(1-(scale=currentValue()/initial||0.5))<=0){maxIterations=0}
initialInUnit=initialInUnit/scale}
initialInUnit=initialInUnit*2;jQuery.style(elem,prop,initialInUnit+unit);valueParts=valueParts||[]}
if(valueParts){initialInUnit=+initialInUnit||+initial||0;adjusted=valueParts[1]?initialInUnit+(valueParts[1]+1)*valueParts[2]:+valueParts[2];if(tween){tween.unit=unit;tween.start=initialInUnit;tween.end=adjusted}}
return adjusted}
var defaultDisplayMap={};function getDefaultDisplay(elem){var temp,doc=elem.ownerDocument,nodeName=elem.nodeName,display=defaultDisplayMap[nodeName];if(display){return display}
temp=doc.body.appendChild(doc.createElement(nodeName));display=jQuery.css(temp,"display");temp.parentNode.removeChild(temp);if(display==="none"){display="block"}
defaultDisplayMap[nodeName]=display;return display}
function showHide(elements,show){var display,elem,values=[],index=0,length=elements.length;for(;index<length;index++){elem=elements[index];if(!elem.style){continue}
display=elem.style.display;if(show){if(display==="none"){values[index]=dataPriv.get(elem,"display")||null;if(!values[index]){elem.style.display=""}}
if(elem.style.display===""&&isHiddenWithinTree(elem)){values[index]=getDefaultDisplay(elem)}}else{if(display!=="none"){values[index]="none";dataPriv.set(elem,"display",display)}}}
for(index=0;index<length;index++){if(values[index]!=null){elements[index].style.display=values[index]}}
return elements}
jQuery.fn.extend({show:function(){return showHide(this,!0)},hide:function(){return showHide(this)},toggle:function(state){if(typeof state==="boolean"){return state?this.show():this.hide()}
return this.each(function(){if(isHiddenWithinTree(this)){jQuery(this).show()}else{jQuery(this).hide()}})}});var rcheckableType=(/^(?:checkbox|radio)$/i);var rtagName=(/<([a-z][^\/\0>\x20\t\r\n\f]*)/i);var rscriptType=(/^$|^module$|\/(?:java|ecma)script/i);(function(){var fragment=document.createDocumentFragment(),div=fragment.appendChild(document.createElement("div")),input=document.createElement("input");input.setAttribute("type","radio");input.setAttribute("checked","checked");input.setAttribute("name","t");div.appendChild(input);support.checkClone=div.cloneNode(!0).cloneNode(!0).lastChild.checked;div.innerHTML="<textarea>x</textarea>";support.noCloneChecked=!!div.cloneNode(!0).lastChild.defaultValue;div.innerHTML="<option></option>";support.option=!!div.lastChild})();var wrapMap={thead:[1,"<table>","</table>"],col:[2,"<table><colgroup>","</colgroup></table>"],tr:[2,"<table><tbody>","</tbody></table>"],td:[3,"<table><tbody><tr>","</tr></tbody></table>"],_default:[0,"",""]};wrapMap.tbody=wrapMap.tfoot=wrapMap.colgroup=wrapMap.caption=wrapMap.thead;wrapMap.th=wrapMap.td;if(!support.option){wrapMap.optgroup=wrapMap.option=[1,"<select multiple='multiple'>","</select>"]}
function getAll(context,tag){var ret;if(typeof context.getElementsByTagName!=="undefined"){ret=context.getElementsByTagName(tag||"*")}else if(typeof context.querySelectorAll!=="undefined"){ret=context.querySelectorAll(tag||"*")}else{ret=[]}
if(tag===undefined||tag&&nodeName(context,tag)){return jQuery.merge([context],ret)}
return ret}
function setGlobalEval(elems,refElements){var i=0,l=elems.length;for(;i<l;i++){dataPriv.set(elems[i],"globalEval",!refElements||dataPriv.get(refElements[i],"globalEval"))}}
var rhtml=/<|&#?\w+;/;function buildFragment(elems,context,scripts,selection,ignored){var elem,tmp,tag,wrap,attached,j,fragment=context.createDocumentFragment(),nodes=[],i=0,l=elems.length;for(;i<l;i++){elem=elems[i];if(elem||elem===0){if(toType(elem)==="object"){jQuery.merge(nodes,elem.nodeType?[elem]:elem)}else if(!rhtml.test(elem)){nodes.push(context.createTextNode(elem))}else{tmp=tmp||fragment.appendChild(context.createElement("div"));tag=(rtagName.exec(elem)||["",""])[1].toLowerCase();wrap=wrapMap[tag]||wrapMap._default;tmp.innerHTML=wrap[1]+jQuery.htmlPrefilter(elem)+wrap[2];j=wrap[0];while(j--){tmp=tmp.lastChild}
jQuery.merge(nodes,tmp.childNodes);tmp=fragment.firstChild;tmp.textContent=""}}}
fragment.textContent="";i=0;while((elem=nodes[i++])){if(selection&&jQuery.inArray(elem,selection)>-1){if(ignored){ignored.push(elem)}
continue}
attached=isAttached(elem);tmp=getAll(fragment.appendChild(elem),"script");if(attached){setGlobalEval(tmp)}
if(scripts){j=0;while((elem=tmp[j++])){if(rscriptType.test(elem.type||"")){scripts.push(elem)}}}}
return fragment}
var rtypenamespace=/^([^.]*)(?:\.(.+)|)/;function returnTrue(){return!0}
function returnFalse(){return!1}
function on(elem,types,selector,data,fn,one){var origFn,type;if(typeof types==="object"){if(typeof selector!=="string"){data=data||selector;selector=undefined}
for(type in types){on(elem,type,selector,data,types[type],one)}
return elem}
if(data==null&&fn==null){fn=selector;data=selector=undefined}else if(fn==null){if(typeof selector==="string"){fn=data;data=undefined}else{fn=data;data=selector;selector=undefined}}
if(fn===!1){fn=returnFalse}else if(!fn){return elem}
if(one===1){origFn=fn;fn=function(event){jQuery().off(event);return origFn.apply(this,arguments)};fn.guid=origFn.guid||(origFn.guid=jQuery.guid++)}
return elem.each(function(){jQuery.event.add(this,types,fn,data,selector)})}
jQuery.event={global:{},add:function(elem,types,handler,data,selector){var handleObjIn,eventHandle,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.get(elem);if(!acceptData(elem)){return}
if(handler.handler){handleObjIn=handler;handler=handleObjIn.handler;selector=handleObjIn.selector}
if(selector){jQuery.find.matchesSelector(documentElement,selector)}
if(!handler.guid){handler.guid=jQuery.guid++}
if(!(events=elemData.events)){events=elemData.events=Object.create(null)}
if(!(eventHandle=elemData.handle)){eventHandle=elemData.handle=function(e){return typeof jQuery!=="undefined"&&jQuery.event.triggered!==e.type?jQuery.event.dispatch.apply(elem,arguments):undefined}}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){continue}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;special=jQuery.event.special[type]||{};handleObj=jQuery.extend({type:type,origType:origType,data:data,handler:handler,guid:handler.guid,selector:selector,needsContext:selector&&jQuery.expr.match.needsContext.test(selector),namespace:namespaces.join(".")},handleObjIn);if(!(handlers=events[type])){handlers=events[type]=[];handlers.delegateCount=0;if(!special.setup||special.setup.call(elem,data,namespaces,eventHandle)===!1){if(elem.addEventListener){elem.addEventListener(type,eventHandle)}}}
if(special.add){special.add.call(elem,handleObj);if(!handleObj.handler.guid){handleObj.handler.guid=handler.guid}}
if(selector){handlers.splice(handlers.delegateCount++,0,handleObj)}else{handlers.push(handleObj)}
jQuery.event.global[type]=!0}},remove:function(elem,types,handler,selector,mappedTypes){var j,origCount,tmp,events,t,handleObj,special,handlers,type,namespaces,origType,elemData=dataPriv.hasData(elem)&&dataPriv.get(elem);if(!elemData||!(events=elemData.events)){return}
types=(types||"").match(rnothtmlwhite)||[""];t=types.length;while(t--){tmp=rtypenamespace.exec(types[t])||[];type=origType=tmp[1];namespaces=(tmp[2]||"").split(".").sort();if(!type){for(type in events){jQuery.event.remove(elem,type+types[t],handler,selector,!0)}
continue}
special=jQuery.event.special[type]||{};type=(selector?special.delegateType:special.bindType)||type;handlers=events[type]||[];tmp=tmp[2]&&new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)");origCount=j=handlers.length;while(j--){handleObj=handlers[j];if((mappedTypes||origType===handleObj.origType)&&(!handler||handler.guid===handleObj.guid)&&(!tmp||tmp.test(handleObj.namespace))&&(!selector||selector===handleObj.selector||selector==="**"&&handleObj.selector)){handlers.splice(j,1);if(handleObj.selector){handlers.delegateCount--}
if(special.remove){special.remove.call(elem,handleObj)}}}
if(origCount&&!handlers.length){if(!special.teardown||special.teardown.call(elem,namespaces,elemData.handle)===!1){jQuery.removeEvent(elem,type,elemData.handle)}
delete events[type]}}
if(jQuery.isEmptyObject(events)){dataPriv.remove(elem,"handle events")}},dispatch:function(nativeEvent){var i,j,ret,matched,handleObj,handlerQueue,args=new Array(arguments.length),event=jQuery.event.fix(nativeEvent),handlers=(dataPriv.get(this,"events")||Object.create(null))[event.type]||[],special=jQuery.event.special[event.type]||{};args[0]=event;for(i=1;i<arguments.length;i++){args[i]=arguments[i]}
event.delegateTarget=this;if(special.preDispatch&&special.preDispatch.call(this,event)===!1){return}
handlerQueue=jQuery.event.handlers.call(this,event,handlers);i=0;while((matched=handlerQueue[i++])&&!event.isPropagationStopped()){event.currentTarget=matched.elem;j=0;while((handleObj=matched.handlers[j++])&&!event.isImmediatePropagationStopped()){if(!event.rnamespace||handleObj.namespace===!1||event.rnamespace.test(handleObj.namespace)){event.handleObj=handleObj;event.data=handleObj.data;ret=((jQuery.event.special[handleObj.origType]||{}).handle||handleObj.handler).apply(matched.elem,args);if(ret!==undefined){if((event.result=ret)===!1){event.preventDefault();event.stopPropagation()}}}}}
if(special.postDispatch){special.postDispatch.call(this,event)}
return event.result},handlers:function(event,handlers){var i,handleObj,sel,matchedHandlers,matchedSelectors,handlerQueue=[],delegateCount=handlers.delegateCount,cur=event.target;if(delegateCount&&cur.nodeType&&!(event.type==="click"&&event.button>=1)){for(;cur!==this;cur=cur.parentNode||this){if(cur.nodeType===1&&!(event.type==="click"&&cur.disabled===!0)){matchedHandlers=[];matchedSelectors={};for(i=0;i<delegateCount;i++){handleObj=handlers[i];sel=handleObj.selector+" ";if(matchedSelectors[sel]===undefined){matchedSelectors[sel]=handleObj.needsContext?jQuery(sel,this).index(cur)>-1:jQuery.find(sel,this,null,[cur]).length}
if(matchedSelectors[sel]){matchedHandlers.push(handleObj)}}
if(matchedHandlers.length){handlerQueue.push({elem:cur,handlers:matchedHandlers})}}}}
cur=this;if(delegateCount<handlers.length){handlerQueue.push({elem:cur,handlers:handlers.slice(delegateCount)})}
return handlerQueue},addProp:function(name,hook){Object.defineProperty(jQuery.Event.prototype,name,{enumerable:!0,configurable:!0,get:isFunction(hook)?function(){if(this.originalEvent){return hook(this.originalEvent)}}:function(){if(this.originalEvent){return this.originalEvent[name]}},set:function(value){Object.defineProperty(this,name,{enumerable:!0,configurable:!0,writable:!0,value:value})}})},fix:function(originalEvent){return originalEvent[jQuery.expando]?originalEvent:new jQuery.Event(originalEvent)},special:{load:{noBubble:!0},click:{setup:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click",!0)}
return!1},trigger:function(data){var el=this||data;if(rcheckableType.test(el.type)&&el.click&&nodeName(el,"input")){leverageNative(el,"click")}
return!0},_default:function(event){var target=event.target;return rcheckableType.test(target.type)&&target.click&&nodeName(target,"input")&&dataPriv.get(target,"click")||nodeName(target,"a")}},beforeunload:{postDispatch:function(event){if(event.result!==undefined&&event.originalEvent){event.originalEvent.returnValue=event.result}}}}};function leverageNative(el,type,isSetup){if(!isSetup){if(dataPriv.get(el,type)===undefined){jQuery.event.add(el,type,returnTrue)}
return}
dataPriv.set(el,type,!1);jQuery.event.add(el,type,{namespace:!1,handler:function(event){var result,saved=dataPriv.get(this,type);if((event.isTrigger&1)&&this[type]){if(!saved){saved=slice.call(arguments);dataPriv.set(this,type,saved);this[type]();result=dataPriv.get(this,type);dataPriv.set(this,type,!1);if(saved!==result){event.stopImmediatePropagation();event.preventDefault();return result}}else if((jQuery.event.special[type]||{}).delegateType){event.stopPropagation()}}else if(saved){dataPriv.set(this,type,jQuery.event.trigger(saved[0],saved.slice(1),this));event.stopPropagation();event.isImmediatePropagationStopped=returnTrue}}})}
jQuery.removeEvent=function(elem,type,handle){if(elem.removeEventListener){elem.removeEventListener(type,handle)}};jQuery.Event=function(src,props){if(!(this instanceof jQuery.Event)){return new jQuery.Event(src,props)}
if(src&&src.type){this.originalEvent=src;this.type=src.type;this.isDefaultPrevented=src.defaultPrevented||src.defaultPrevented===undefined&&src.returnValue===!1?returnTrue:returnFalse;this.target=(src.target&&src.target.nodeType===3)?src.target.parentNode:src.target;this.currentTarget=src.currentTarget;this.relatedTarget=src.relatedTarget}else{this.type=src}
if(props){jQuery.extend(this,props)}
this.timeStamp=src&&src.timeStamp||Date.now();this[jQuery.expando]=!0};jQuery.Event.prototype={constructor:jQuery.Event,isDefaultPrevented:returnFalse,isPropagationStopped:returnFalse,isImmediatePropagationStopped:returnFalse,isSimulated:!1,preventDefault:function(){var e=this.originalEvent;this.isDefaultPrevented=returnTrue;if(e&&!this.isSimulated){e.preventDefault()}},stopPropagation:function(){var e=this.originalEvent;this.isPropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopPropagation()}},stopImmediatePropagation:function(){var e=this.originalEvent;this.isImmediatePropagationStopped=returnTrue;if(e&&!this.isSimulated){e.stopImmediatePropagation()}
this.stopPropagation()}};jQuery.each({altKey:!0,bubbles:!0,cancelable:!0,changedTouches:!0,ctrlKey:!0,detail:!0,eventPhase:!0,metaKey:!0,pageX:!0,pageY:!0,shiftKey:!0,view:!0,"char":!0,code:!0,charCode:!0,key:!0,keyCode:!0,button:!0,buttons:!0,clientX:!0,clientY:!0,offsetX:!0,offsetY:!0,pointerId:!0,pointerType:!0,screenX:!0,screenY:!0,targetTouches:!0,toElement:!0,touches:!0,which:!0},jQuery.event.addProp);jQuery.each({focus:"focusin",blur:"focusout"},function(type,delegateType){function focusMappedHandler(nativeEvent){if(document.documentMode){var handle=dataPriv.get(this,"handle"),event=jQuery.event.fix(nativeEvent);event.type=nativeEvent.type==="focusin"?"focus":"blur";event.isSimulated=!0;handle(nativeEvent);if(event.target===event.currentTarget){handle(event)}}else{jQuery.event.simulate(delegateType,nativeEvent.target,jQuery.event.fix(nativeEvent))}}
jQuery.event.special[type]={setup:function(){var attaches;leverageNative(this,type,!0);if(document.documentMode){attaches=dataPriv.get(this,delegateType);if(!attaches){this.addEventListener(delegateType,focusMappedHandler)}
dataPriv.set(this,delegateType,(attaches||0)+1)}else{return!1}},trigger:function(){leverageNative(this,type);return!0},teardown:function(){var attaches;if(document.documentMode){attaches=dataPriv.get(this,delegateType)-1;if(!attaches){this.removeEventListener(delegateType,focusMappedHandler);dataPriv.remove(this,delegateType)}else{dataPriv.set(this,delegateType,attaches)}}else{return!1}},_default:function(event){return dataPriv.get(event.target,type)},delegateType:delegateType};jQuery.event.special[delegateType]={setup:function(){var doc=this.ownerDocument||this.document||this,dataHolder=document.documentMode?this:doc,attaches=dataPriv.get(dataHolder,delegateType);if(!attaches){if(document.documentMode){this.addEventListener(delegateType,focusMappedHandler)}else{doc.addEventListener(type,focusMappedHandler,!0)}}
dataPriv.set(dataHolder,delegateType,(attaches||0)+1)},teardown:function(){var doc=this.ownerDocument||this.document||this,dataHolder=document.documentMode?this:doc,attaches=dataPriv.get(dataHolder,delegateType)-1;if(!attaches){if(document.documentMode){this.removeEventListener(delegateType,focusMappedHandler)}else{doc.removeEventListener(type,focusMappedHandler,!0)}
dataPriv.remove(dataHolder,delegateType)}else{dataPriv.set(dataHolder,delegateType,attaches)}}}});jQuery.each({mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},function(orig,fix){jQuery.event.special[orig]={delegateType:fix,bindType:fix,handle:function(event){var ret,target=this,related=event.relatedTarget,handleObj=event.handleObj;if(!related||(related!==target&&!jQuery.contains(target,related))){event.type=handleObj.origType;ret=handleObj.handler.apply(this,arguments);event.type=fix}
return ret}}});jQuery.fn.extend({on:function(types,selector,data,fn){return on(this,types,selector,data,fn)},one:function(types,selector,data,fn){return on(this,types,selector,data,fn,1)},off:function(types,selector,fn){var handleObj,type;if(types&&types.preventDefault&&types.handleObj){handleObj=types.handleObj;jQuery(types.delegateTarget).off(handleObj.namespace?handleObj.origType+"."+handleObj.namespace:handleObj.origType,handleObj.selector,handleObj.handler);return this}
if(typeof types==="object"){for(type in types){this.off(type,selector,types[type])}
return this}
if(selector===!1||typeof selector==="function"){fn=selector;selector=undefined}
if(fn===!1){fn=returnFalse}
return this.each(function(){jQuery.event.remove(this,types,fn,selector)})}});var rnoInnerhtml=/<script|<style|<link/i,rchecked=/checked\s*(?:[^=]|=\s*.checked.)/i,rcleanScript=/^\s*<!\[CDATA\[|\]\]>\s*$/g;function manipulationTarget(elem,content){if(nodeName(elem,"table")&&nodeName(content.nodeType!==11?content:content.firstChild,"tr")){return jQuery(elem).children("tbody")[0]||elem}
return elem}
function disableScript(elem){elem.type=(elem.getAttribute("type")!==null)+"/"+elem.type;return elem}
function restoreScript(elem){if((elem.type||"").slice(0,5)==="true/"){elem.type=elem.type.slice(5)}else{elem.removeAttribute("type")}
return elem}
function cloneCopyEvent(src,dest){var i,l,type,pdataOld,udataOld,udataCur,events;if(dest.nodeType!==1){return}
if(dataPriv.hasData(src)){pdataOld=dataPriv.get(src);events=pdataOld.events;if(events){dataPriv.remove(dest,"handle events");for(type in events){for(i=0,l=events[type].length;i<l;i++){jQuery.event.add(dest,type,events[type][i])}}}}
if(dataUser.hasData(src)){udataOld=dataUser.access(src);udataCur=jQuery.extend({},udataOld);dataUser.set(dest,udataCur)}}
function fixInput(src,dest){var nodeName=dest.nodeName.toLowerCase();if(nodeName==="input"&&rcheckableType.test(src.type)){dest.checked=src.checked}else if(nodeName==="input"||nodeName==="textarea"){dest.defaultValue=src.defaultValue}}
function domManip(collection,args,callback,ignored){args=flat(args);var fragment,first,scripts,hasScripts,node,doc,i=0,l=collection.length,iNoClone=l-1,value=args[0],valueIsFunction=isFunction(value);if(valueIsFunction||(l>1&&typeof value==="string"&&!support.checkClone&&rchecked.test(value))){return collection.each(function(index){var self=collection.eq(index);if(valueIsFunction){args[0]=value.call(this,index,self.html())}
domManip(self,args,callback,ignored)})}
if(l){fragment=buildFragment(args,collection[0].ownerDocument,!1,collection,ignored);first=fragment.firstChild;if(fragment.childNodes.length===1){fragment=first}
if(first||ignored){scripts=jQuery.map(getAll(fragment,"script"),disableScript);hasScripts=scripts.length;for(;i<l;i++){node=fragment;if(i!==iNoClone){node=jQuery.clone(node,!0,!0);if(hasScripts){jQuery.merge(scripts,getAll(node,"script"))}}
callback.call(collection[i],node,i)}
if(hasScripts){doc=scripts[scripts.length-1].ownerDocument;jQuery.map(scripts,restoreScript);for(i=0;i<hasScripts;i++){node=scripts[i];if(rscriptType.test(node.type||"")&&!dataPriv.access(node,"globalEval")&&jQuery.contains(doc,node)){if(node.src&&(node.type||"").toLowerCase()!=="module"){if(jQuery._evalUrl&&!node.noModule){jQuery._evalUrl(node.src,{nonce:node.nonce||node.getAttribute("nonce")},doc)}}else{DOMEval(node.textContent.replace(rcleanScript,""),node,doc)}}}}}}
return collection}
function remove(elem,selector,keepData){var node,nodes=selector?jQuery.filter(selector,elem):elem,i=0;for(;(node=nodes[i])!=null;i++){if(!keepData&&node.nodeType===1){jQuery.cleanData(getAll(node))}
if(node.parentNode){if(keepData&&isAttached(node)){setGlobalEval(getAll(node,"script"))}
node.parentNode.removeChild(node)}}
return elem}
jQuery.extend({htmlPrefilter:function(html){return html},clone:function(elem,dataAndEvents,deepDataAndEvents){var i,l,srcElements,destElements,clone=elem.cloneNode(!0),inPage=isAttached(elem);if(!support.noCloneChecked&&(elem.nodeType===1||elem.nodeType===11)&&!jQuery.isXMLDoc(elem)){destElements=getAll(clone);srcElements=getAll(elem);for(i=0,l=srcElements.length;i<l;i++){fixInput(srcElements[i],destElements[i])}}
if(dataAndEvents){if(deepDataAndEvents){srcElements=srcElements||getAll(elem);destElements=destElements||getAll(clone);for(i=0,l=srcElements.length;i<l;i++){cloneCopyEvent(srcElements[i],destElements[i])}}else{cloneCopyEvent(elem,clone)}}
destElements=getAll(clone,"script");if(destElements.length>0){setGlobalEval(destElements,!inPage&&getAll(elem,"script"))}
return clone},cleanData:function(elems){var data,elem,type,special=jQuery.event.special,i=0;for(;(elem=elems[i])!==undefined;i++){if(acceptData(elem)){if((data=elem[dataPriv.expando])){if(data.events){for(type in data.events){if(special[type]){jQuery.event.remove(elem,type)}else{jQuery.removeEvent(elem,type,data.handle)}}}
elem[dataPriv.expando]=undefined}
if(elem[dataUser.expando]){elem[dataUser.expando]=undefined}}}}});jQuery.fn.extend({detach:function(selector){return remove(this,selector,!0)},remove:function(selector){return remove(this,selector)},text:function(value){return access(this,function(value){return value===undefined?jQuery.text(this):this.empty().each(function(){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){this.textContent=value}})},null,value,arguments.length)},append:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.appendChild(elem)}})},prepend:function(){return domManip(this,arguments,function(elem){if(this.nodeType===1||this.nodeType===11||this.nodeType===9){var target=manipulationTarget(this,elem);target.insertBefore(elem,target.firstChild)}})},before:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this)}})},after:function(){return domManip(this,arguments,function(elem){if(this.parentNode){this.parentNode.insertBefore(elem,this.nextSibling)}})},empty:function(){var elem,i=0;for(;(elem=this[i])!=null;i++){if(elem.nodeType===1){jQuery.cleanData(getAll(elem,!1));elem.textContent=""}}
return this},clone:function(dataAndEvents,deepDataAndEvents){dataAndEvents=dataAndEvents==null?!1:dataAndEvents;deepDataAndEvents=deepDataAndEvents==null?dataAndEvents:deepDataAndEvents;return this.map(function(){return jQuery.clone(this,dataAndEvents,deepDataAndEvents)})},html:function(value){return access(this,function(value){var elem=this[0]||{},i=0,l=this.length;if(value===undefined&&elem.nodeType===1){return elem.innerHTML}
if(typeof value==="string"&&!rnoInnerhtml.test(value)&&!wrapMap[(rtagName.exec(value)||["",""])[1].toLowerCase()]){value=jQuery.htmlPrefilter(value);try{for(;i<l;i++){elem=this[i]||{};if(elem.nodeType===1){jQuery.cleanData(getAll(elem,!1));elem.innerHTML=value}}
elem=0}catch(e){}}
if(elem){this.empty().append(value)}},null,value,arguments.length)},replaceWith:function(){var ignored=[];return domManip(this,arguments,function(elem){var parent=this.parentNode;if(jQuery.inArray(this,ignored)<0){jQuery.cleanData(getAll(this));if(parent){parent.replaceChild(elem,this)}}},ignored)}});jQuery.each({appendTo:"append",prependTo:"prepend",insertBefore:"before",insertAfter:"after",replaceAll:"replaceWith"},function(name,original){jQuery.fn[name]=function(selector){var elems,ret=[],insert=jQuery(selector),last=insert.length-1,i=0;for(;i<=last;i++){elems=i===last?this:this.clone(!0);jQuery(insert[i])[original](elems);push.apply(ret,elems.get())}
return this.pushStack(ret)}});var rnumnonpx=new RegExp("^("+pnum+")(?!px)[a-z%]+$","i");var rcustomProp=/^--/;var getStyles=function(elem){var view=elem.ownerDocument.defaultView;if(!view||!view.opener){view=window}
return view.getComputedStyle(elem)};var swap=function(elem,options,callback){var ret,name,old={};for(name in options){old[name]=elem.style[name];elem.style[name]=options[name]}
ret=callback.call(elem);for(name in options){elem.style[name]=old[name]}
return ret};var rboxStyle=new RegExp(cssExpand.join("|"),"i");(function(){function computeStyleTests(){if(!div){return}
container.style.cssText="position:absolute;left:-11111px;width:60px;"+"margin-top:1px;padding:0;border:0";div.style.cssText="position:relative;display:block;box-sizing:border-box;overflow:scroll;"+"margin:auto;border:1px;padding:1px;"+"width:60%;top:1%";documentElement.appendChild(container).appendChild(div);var divStyle=window.getComputedStyle(div);pixelPositionVal=divStyle.top!=="1%";reliableMarginLeftVal=roundPixelMeasures(divStyle.marginLeft)===12;div.style.right="60%";pixelBoxStylesVal=roundPixelMeasures(divStyle.right)===36;boxSizingReliableVal=roundPixelMeasures(divStyle.width)===36;div.style.position="absolute";scrollboxSizeVal=roundPixelMeasures(div.offsetWidth/3)===12;documentElement.removeChild(container);div=null}
function roundPixelMeasures(measure){return Math.round(parseFloat(measure))}
var pixelPositionVal,boxSizingReliableVal,scrollboxSizeVal,pixelBoxStylesVal,reliableTrDimensionsVal,reliableMarginLeftVal,container=document.createElement("div"),div=document.createElement("div");if(!div.style){return}
div.style.backgroundClip="content-box";div.cloneNode(!0).style.backgroundClip="";support.clearCloneStyle=div.style.backgroundClip==="content-box";jQuery.extend(support,{boxSizingReliable:function(){computeStyleTests();return boxSizingReliableVal},pixelBoxStyles:function(){computeStyleTests();return pixelBoxStylesVal},pixelPosition:function(){computeStyleTests();return pixelPositionVal},reliableMarginLeft:function(){computeStyleTests();return reliableMarginLeftVal},scrollboxSize:function(){computeStyleTests();return scrollboxSizeVal},reliableTrDimensions:function(){var table,tr,trChild,trStyle;if(reliableTrDimensionsVal==null){table=document.createElement("table");tr=document.createElement("tr");trChild=document.createElement("div");table.style.cssText="position:absolute;left:-11111px;border-collapse:separate";tr.style.cssText="box-sizing:content-box;border:1px solid";tr.style.height="1px";trChild.style.height="9px";trChild.style.display="block";documentElement.appendChild(table).appendChild(tr).appendChild(trChild);trStyle=window.getComputedStyle(tr);reliableTrDimensionsVal=(parseInt(trStyle.height,10)+parseInt(trStyle.borderTopWidth,10)+parseInt(trStyle.borderBottomWidth,10))===tr.offsetHeight;documentElement.removeChild(table)}
return reliableTrDimensionsVal}})})();function curCSS(elem,name,computed){var width,minWidth,maxWidth,ret,isCustomProp=rcustomProp.test(name),style=elem.style;computed=computed||getStyles(elem);if(computed){ret=computed.getPropertyValue(name)||computed[name];if(isCustomProp&&ret){ret=ret.replace(rtrimCSS,"$1")||undefined}
if(ret===""&&!isAttached(elem)){ret=jQuery.style(elem,name)}
if(!support.pixelBoxStyles()&&rnumnonpx.test(ret)&&rboxStyle.test(name)){width=style.width;minWidth=style.minWidth;maxWidth=style.maxWidth;style.minWidth=style.maxWidth=style.width=ret;ret=computed.width;style.width=width;style.minWidth=minWidth;style.maxWidth=maxWidth}}
return ret!==undefined?ret+"":ret}
function addGetHookIf(conditionFn,hookFn){return{get:function(){if(conditionFn()){delete this.get;return}
return(this.get=hookFn).apply(this,arguments)}}}
var cssPrefixes=["Webkit","Moz","ms"],emptyStyle=document.createElement("div").style,vendorProps={};function vendorPropName(name){var capName=name[0].toUpperCase()+name.slice(1),i=cssPrefixes.length;while(i--){name=cssPrefixes[i]+capName;if(name in emptyStyle){return name}}}
function finalPropName(name){var final=jQuery.cssProps[name]||vendorProps[name];if(final){return final}
if(name in emptyStyle){return name}
return vendorProps[name]=vendorPropName(name)||name}
var rdisplayswap=/^(none|table(?!-c[ea]).+)/,cssShow={position:"absolute",visibility:"hidden",display:"block"},cssNormalTransform={letterSpacing:"0",fontWeight:"400"};function setPositiveNumber(_elem,value,subtract){var matches=rcssNum.exec(value);return matches?Math.max(0,matches[2]-(subtract||0))+(matches[3]||"px"):value}
function boxModelAdjustment(elem,dimension,box,isBorderBox,styles,computedVal){var i=dimension==="width"?1:0,extra=0,delta=0,marginDelta=0;if(box===(isBorderBox?"border":"content")){return 0}
for(;i<4;i+=2){if(box==="margin"){marginDelta+=jQuery.css(elem,box+cssExpand[i],!0,styles)}
if(!isBorderBox){delta+=jQuery.css(elem,"padding"+cssExpand[i],!0,styles);if(box!=="padding"){delta+=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}else{extra+=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}}else{if(box==="content"){delta-=jQuery.css(elem,"padding"+cssExpand[i],!0,styles)}
if(box!=="margin"){delta-=jQuery.css(elem,"border"+cssExpand[i]+"Width",!0,styles)}}}
if(!isBorderBox&&computedVal>=0){delta+=Math.max(0,Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-computedVal-delta-extra-0.5))||0}
return delta+marginDelta}
function getWidthOrHeight(elem,dimension,extra){var styles=getStyles(elem),boxSizingNeeded=!support.boxSizingReliable()||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",!1,styles)==="border-box",valueIsBorderBox=isBorderBox,val=curCSS(elem,dimension,styles),offsetProp="offset"+dimension[0].toUpperCase()+dimension.slice(1);if(rnumnonpx.test(val)){if(!extra){return val}
val="auto"}
if((!support.boxSizingReliable()&&isBorderBox||!support.reliableTrDimensions()&&nodeName(elem,"tr")||val==="auto"||!parseFloat(val)&&jQuery.css(elem,"display",!1,styles)==="inline")&&elem.getClientRects().length){isBorderBox=jQuery.css(elem,"boxSizing",!1,styles)==="border-box";valueIsBorderBox=offsetProp in elem;if(valueIsBorderBox){val=elem[offsetProp]}}
val=parseFloat(val)||0;return(val+boxModelAdjustment(elem,dimension,extra||(isBorderBox?"border":"content"),valueIsBorderBox,styles,val))+"px"}
jQuery.extend({cssHooks:{opacity:{get:function(elem,computed){if(computed){var ret=curCSS(elem,"opacity");return ret===""?"1":ret}}}},cssNumber:{animationIterationCount:!0,aspectRatio:!0,borderImageSlice:!0,columnCount:!0,flexGrow:!0,flexShrink:!0,fontWeight:!0,gridArea:!0,gridColumn:!0,gridColumnEnd:!0,gridColumnStart:!0,gridRow:!0,gridRowEnd:!0,gridRowStart:!0,lineHeight:!0,opacity:!0,order:!0,orphans:!0,scale:!0,widows:!0,zIndex:!0,zoom:!0,fillOpacity:!0,floodOpacity:!0,stopOpacity:!0,strokeMiterlimit:!0,strokeOpacity:!0},cssProps:{},style:function(elem,name,value,extra){if(!elem||elem.nodeType===3||elem.nodeType===8||!elem.style){return}
var ret,type,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name),style=elem.style;if(!isCustomProp){name=finalPropName(origName)}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(value!==undefined){type=typeof value;if(type==="string"&&(ret=rcssNum.exec(value))&&ret[1]){value=adjustCSS(elem,name,ret);type="number"}
if(value==null||value!==value){return}
if(type==="number"&&!isCustomProp){value+=ret&&ret[3]||(jQuery.cssNumber[origName]?"":"px")}
if(!support.clearCloneStyle&&value===""&&name.indexOf("background")===0){style[name]="inherit"}
if(!hooks||!("set" in hooks)||(value=hooks.set(elem,value,extra))!==undefined){if(isCustomProp){style.setProperty(name,value)}else{style[name]=value}}}else{if(hooks&&"get" in hooks&&(ret=hooks.get(elem,!1,extra))!==undefined){return ret}
return style[name]}},css:function(elem,name,extra,styles){var val,num,hooks,origName=camelCase(name),isCustomProp=rcustomProp.test(name);if(!isCustomProp){name=finalPropName(origName)}
hooks=jQuery.cssHooks[name]||jQuery.cssHooks[origName];if(hooks&&"get" in hooks){val=hooks.get(elem,!0,extra)}
if(val===undefined){val=curCSS(elem,name,styles)}
if(val==="normal"&&name in cssNormalTransform){val=cssNormalTransform[name]}
if(extra===""||extra){num=parseFloat(val);return extra===!0||isFinite(num)?num||0:val}
return val}});jQuery.each(["height","width"],function(_i,dimension){jQuery.cssHooks[dimension]={get:function(elem,computed,extra){if(computed){return rdisplayswap.test(jQuery.css(elem,"display"))&&(!elem.getClientRects().length||!elem.getBoundingClientRect().width)?swap(elem,cssShow,function(){return getWidthOrHeight(elem,dimension,extra)}):getWidthOrHeight(elem,dimension,extra)}},set:function(elem,value,extra){var matches,styles=getStyles(elem),scrollboxSizeBuggy=!support.scrollboxSize()&&styles.position==="absolute",boxSizingNeeded=scrollboxSizeBuggy||extra,isBorderBox=boxSizingNeeded&&jQuery.css(elem,"boxSizing",!1,styles)==="border-box",subtract=extra?boxModelAdjustment(elem,dimension,extra,isBorderBox,styles):0;if(isBorderBox&&scrollboxSizeBuggy){subtract-=Math.ceil(elem["offset"+dimension[0].toUpperCase()+dimension.slice(1)]-parseFloat(styles[dimension])-boxModelAdjustment(elem,dimension,"border",!1,styles)-0.5)}
if(subtract&&(matches=rcssNum.exec(value))&&(matches[3]||"px")!=="px"){elem.style[dimension]=value;value=jQuery.css(elem,dimension)}
return setPositiveNumber(elem,value,subtract)}}});jQuery.cssHooks.marginLeft=addGetHookIf(support.reliableMarginLeft,function(elem,computed){if(computed){return(parseFloat(curCSS(elem,"marginLeft"))||elem.getBoundingClientRect().left-swap(elem,{marginLeft:0},function(){return elem.getBoundingClientRect().left}))+"px"}});jQuery.each({margin:"",padding:"",border:"Width"},function(prefix,suffix){jQuery.cssHooks[prefix+suffix]={expand:function(value){var i=0,expanded={},parts=typeof value==="string"?value.split(" "):[value];for(;i<4;i++){expanded[prefix+cssExpand[i]+suffix]=parts[i]||parts[i-2]||parts[0]}
return expanded}};if(prefix!=="margin"){jQuery.cssHooks[prefix+suffix].set=setPositiveNumber}});jQuery.fn.extend({css:function(name,value){return access(this,function(elem,name,value){var styles,len,map={},i=0;if(Array.isArray(name)){styles=getStyles(elem);len=name.length;for(;i<len;i++){map[name[i]]=jQuery.css(elem,name[i],!1,styles)}
return map}
return value!==undefined?jQuery.style(elem,name,value):jQuery.css(elem,name)},name,value,arguments.length>1)}});function Tween(elem,options,prop,end,easing){return new Tween.prototype.init(elem,options,prop,end,easing)}
jQuery.Tween=Tween;Tween.prototype={constructor:Tween,init:function(elem,options,prop,end,easing,unit){this.elem=elem;this.prop=prop;this.easing=easing||jQuery.easing._default;this.options=options;this.start=this.now=this.cur();this.end=end;this.unit=unit||(jQuery.cssNumber[prop]?"":"px")},cur:function(){var hooks=Tween.propHooks[this.prop];return hooks&&hooks.get?hooks.get(this):Tween.propHooks._default.get(this)},run:function(percent){var eased,hooks=Tween.propHooks[this.prop];if(this.options.duration){this.pos=eased=jQuery.easing[this.easing](percent,this.options.duration*percent,0,1,this.options.duration)}else{this.pos=eased=percent}
this.now=(this.end-this.start)*eased+this.start;if(this.options.step){this.options.step.call(this.elem,this.now,this)}
if(hooks&&hooks.set){hooks.set(this)}else{Tween.propHooks._default.set(this)}
return this}};Tween.prototype.init.prototype=Tween.prototype;Tween.propHooks={_default:{get:function(tween){var result;if(tween.elem.nodeType!==1||tween.elem[tween.prop]!=null&&tween.elem.style[tween.prop]==null){return tween.elem[tween.prop]}
result=jQuery.css(tween.elem,tween.prop,"");return!result||result==="auto"?0:result},set:function(tween){if(jQuery.fx.step[tween.prop]){jQuery.fx.step[tween.prop](tween)}else if(tween.elem.nodeType===1&&(jQuery.cssHooks[tween.prop]||tween.elem.style[finalPropName(tween.prop)]!=null)){jQuery.style(tween.elem,tween.prop,tween.now+tween.unit)}else{tween.elem[tween.prop]=tween.now}}}};Tween.propHooks.scrollTop=Tween.propHooks.scrollLeft={set:function(tween){if(tween.elem.nodeType&&tween.elem.parentNode){tween.elem[tween.prop]=tween.now}}};jQuery.easing={linear:function(p){return p},swing:function(p){return 0.5-Math.cos(p*Math.PI)/2},_default:"swing"};jQuery.fx=Tween.prototype.init;jQuery.fx.step={};var fxNow,inProgress,rfxtypes=/^(?:toggle|show|hide)$/,rrun=/queueHooks$/;function schedule(){if(inProgress){if(document.hidden===!1&&window.requestAnimationFrame){window.requestAnimationFrame(schedule)}else{window.setTimeout(schedule,jQuery.fx.interval)}
jQuery.fx.tick()}}
function createFxNow(){window.setTimeout(function(){fxNow=undefined});return(fxNow=Date.now())}
function genFx(type,includeWidth){var which,i=0,attrs={height:type};includeWidth=includeWidth?1:0;for(;i<4;i+=2-includeWidth){which=cssExpand[i];attrs["margin"+which]=attrs["padding"+which]=type}
if(includeWidth){attrs.opacity=attrs.width=type}
return attrs}
function createTween(value,prop,animation){var tween,collection=(Animation.tweeners[prop]||[]).concat(Animation.tweeners["*"]),index=0,length=collection.length;for(;index<length;index++){if((tween=collection[index].call(animation,prop,value))){return tween}}}
function defaultPrefilter(elem,props,opts){var prop,value,toggle,hooks,oldfire,propTween,restoreDisplay,display,isBox="width" in props||"height" in props,anim=this,orig={},style=elem.style,hidden=elem.nodeType&&isHiddenWithinTree(elem),dataShow=dataPriv.get(elem,"fxshow");if(!opts.queue){hooks=jQuery._queueHooks(elem,"fx");if(hooks.unqueued==null){hooks.unqueued=0;oldfire=hooks.empty.fire;hooks.empty.fire=function(){if(!hooks.unqueued){oldfire()}}}
hooks.unqueued++;anim.always(function(){anim.always(function(){hooks.unqueued--;if(!jQuery.queue(elem,"fx").length){hooks.empty.fire()}})})}
for(prop in props){value=props[prop];if(rfxtypes.test(value)){delete props[prop];toggle=toggle||value==="toggle";if(value===(hidden?"hide":"show")){if(value==="show"&&dataShow&&dataShow[prop]!==undefined){hidden=!0}else{continue}}
orig[prop]=dataShow&&dataShow[prop]||jQuery.style(elem,prop)}}
propTween=!jQuery.isEmptyObject(props);if(!propTween&&jQuery.isEmptyObject(orig)){return}
if(isBox&&elem.nodeType===1){opts.overflow=[style.overflow,style.overflowX,style.overflowY];restoreDisplay=dataShow&&dataShow.display;if(restoreDisplay==null){restoreDisplay=dataPriv.get(elem,"display")}
display=jQuery.css(elem,"display");if(display==="none"){if(restoreDisplay){display=restoreDisplay}else{showHide([elem],!0);restoreDisplay=elem.style.display||restoreDisplay;display=jQuery.css(elem,"display");showHide([elem])}}
if(display==="inline"||display==="inline-block"&&restoreDisplay!=null){if(jQuery.css(elem,"float")==="none"){if(!propTween){anim.done(function(){style.display=restoreDisplay});if(restoreDisplay==null){display=style.display;restoreDisplay=display==="none"?"":display}}
style.display="inline-block"}}}
if(opts.overflow){style.overflow="hidden";anim.always(function(){style.overflow=opts.overflow[0];style.overflowX=opts.overflow[1];style.overflowY=opts.overflow[2]})}
propTween=!1;for(prop in orig){if(!propTween){if(dataShow){if("hidden" in dataShow){hidden=dataShow.hidden}}else{dataShow=dataPriv.access(elem,"fxshow",{display:restoreDisplay})}
if(toggle){dataShow.hidden=!hidden}
if(hidden){showHide([elem],!0)}
anim.done(function(){if(!hidden){showHide([elem])}
dataPriv.remove(elem,"fxshow");for(prop in orig){jQuery.style(elem,prop,orig[prop])}})}
propTween=createTween(hidden?dataShow[prop]:0,prop,anim);if(!(prop in dataShow)){dataShow[prop]=propTween.start;if(hidden){propTween.end=propTween.start;propTween.start=0}}}}
function propFilter(props,specialEasing){var index,name,easing,value,hooks;for(index in props){name=camelCase(index);easing=specialEasing[name];value=props[index];if(Array.isArray(value)){easing=value[1];value=props[index]=value[0]}
if(index!==name){props[name]=value;delete props[index]}
hooks=jQuery.cssHooks[name];if(hooks&&"expand" in hooks){value=hooks.expand(value);delete props[name];for(index in value){if(!(index in props)){props[index]=value[index];specialEasing[index]=easing}}}else{specialEasing[name]=easing}}}
function Animation(elem,properties,options){var result,stopped,index=0,length=Animation.prefilters.length,deferred=jQuery.Deferred().always(function(){delete tick.elem}),tick=function(){if(stopped){return!1}
var currentTime=fxNow||createFxNow(),remaining=Math.max(0,animation.startTime+animation.duration-currentTime),temp=remaining/animation.duration||0,percent=1-temp,index=0,length=animation.tweens.length;for(;index<length;index++){animation.tweens[index].run(percent)}
deferred.notifyWith(elem,[animation,percent,remaining]);if(percent<1&&length){return remaining}
if(!length){deferred.notifyWith(elem,[animation,1,0])}
deferred.resolveWith(elem,[animation]);return!1},animation=deferred.promise({elem:elem,props:jQuery.extend({},properties),opts:jQuery.extend(!0,{specialEasing:{},easing:jQuery.easing._default},options),originalProperties:properties,originalOptions:options,startTime:fxNow||createFxNow(),duration:options.duration,tweens:[],createTween:function(prop,end){var tween=jQuery.Tween(elem,animation.opts,prop,end,animation.opts.specialEasing[prop]||animation.opts.easing);animation.tweens.push(tween);return tween},stop:function(gotoEnd){var index=0,length=gotoEnd?animation.tweens.length:0;if(stopped){return this}
stopped=!0;for(;index<length;index++){animation.tweens[index].run(1)}
if(gotoEnd){deferred.notifyWith(elem,[animation,1,0]);deferred.resolveWith(elem,[animation,gotoEnd])}else{deferred.rejectWith(elem,[animation,gotoEnd])}
return this}}),props=animation.props;propFilter(props,animation.opts.specialEasing);for(;index<length;index++){result=Animation.prefilters[index].call(animation,elem,props,animation.opts);if(result){if(isFunction(result.stop)){jQuery._queueHooks(animation.elem,animation.opts.queue).stop=result.stop.bind(result)}
return result}}
jQuery.map(props,createTween,animation);if(isFunction(animation.opts.start)){animation.opts.start.call(elem,animation)}
animation.progress(animation.opts.progress).done(animation.opts.done,animation.opts.complete).fail(animation.opts.fail).always(animation.opts.always);jQuery.fx.timer(jQuery.extend(tick,{elem:elem,anim:animation,queue:animation.opts.queue}));return animation}
jQuery.Animation=jQuery.extend(Animation,{tweeners:{"*":[function(prop,value){var tween=this.createTween(prop,value);adjustCSS(tween.elem,prop,rcssNum.exec(value),tween);return tween}]},tweener:function(props,callback){if(isFunction(props)){callback=props;props=["*"]}else{props=props.match(rnothtmlwhite)}
var prop,index=0,length=props.length;for(;index<length;index++){prop=props[index];Animation.tweeners[prop]=Animation.tweeners[prop]||[];Animation.tweeners[prop].unshift(callback)}},prefilters:[defaultPrefilter],prefilter:function(callback,prepend){if(prepend){Animation.prefilters.unshift(callback)}else{Animation.prefilters.push(callback)}}});jQuery.speed=function(speed,easing,fn){var opt=speed&&typeof speed==="object"?jQuery.extend({},speed):{complete:fn||!fn&&easing||isFunction(speed)&&speed,duration:speed,easing:fn&&easing||easing&&!isFunction(easing)&&easing};if(jQuery.fx.off){opt.duration=0}else{if(typeof opt.duration!=="number"){if(opt.duration in jQuery.fx.speeds){opt.duration=jQuery.fx.speeds[opt.duration]}else{opt.duration=jQuery.fx.speeds._default}}}
if(opt.queue==null||opt.queue===!0){opt.queue="fx"}
opt.old=opt.complete;opt.complete=function(){if(isFunction(opt.old)){opt.old.call(this)}
if(opt.queue){jQuery.dequeue(this,opt.queue)}};return opt};jQuery.fn.extend({fadeTo:function(speed,to,easing,callback){return this.filter(isHiddenWithinTree).css("opacity",0).show().end().animate({opacity:to},speed,easing,callback)},animate:function(prop,speed,easing,callback){var empty=jQuery.isEmptyObject(prop),optall=jQuery.speed(speed,easing,callback),doAnimation=function(){var anim=Animation(this,jQuery.extend({},prop),optall);if(empty||dataPriv.get(this,"finish")){anim.stop(!0)}};doAnimation.finish=doAnimation;return empty||optall.queue===!1?this.each(doAnimation):this.queue(optall.queue,doAnimation)},stop:function(type,clearQueue,gotoEnd){var stopQueue=function(hooks){var stop=hooks.stop;delete hooks.stop;stop(gotoEnd)};if(typeof type!=="string"){gotoEnd=clearQueue;clearQueue=type;type=undefined}
if(clearQueue){this.queue(type||"fx",[])}
return this.each(function(){var dequeue=!0,index=type!=null&&type+"queueHooks",timers=jQuery.timers,data=dataPriv.get(this);if(index){if(data[index]&&data[index].stop){stopQueue(data[index])}}else{for(index in data){if(data[index]&&data[index].stop&&rrun.test(index)){stopQueue(data[index])}}}
for(index=timers.length;index--;){if(timers[index].elem===this&&(type==null||timers[index].queue===type)){timers[index].anim.stop(gotoEnd);dequeue=!1;timers.splice(index,1)}}
if(dequeue||!gotoEnd){jQuery.dequeue(this,type)}})},finish:function(type){if(type!==!1){type=type||"fx"}
return this.each(function(){var index,data=dataPriv.get(this),queue=data[type+"queue"],hooks=data[type+"queueHooks"],timers=jQuery.timers,length=queue?queue.length:0;data.finish=!0;jQuery.queue(this,type,[]);if(hooks&&hooks.stop){hooks.stop.call(this,!0)}
for(index=timers.length;index--;){if(timers[index].elem===this&&timers[index].queue===type){timers[index].anim.stop(!0);timers.splice(index,1)}}
for(index=0;index<length;index++){if(queue[index]&&queue[index].finish){queue[index].finish.call(this)}}
delete data.finish})}});jQuery.each(["toggle","show","hide"],function(_i,name){var cssFn=jQuery.fn[name];jQuery.fn[name]=function(speed,easing,callback){return speed==null||typeof speed==="boolean"?cssFn.apply(this,arguments):this.animate(genFx(name,!0),speed,easing,callback)}});jQuery.each({slideDown:genFx("show"),slideUp:genFx("hide"),slideToggle:genFx("toggle"),fadeIn:{opacity:"show"},fadeOut:{opacity:"hide"},fadeToggle:{opacity:"toggle"}},function(name,props){jQuery.fn[name]=function(speed,easing,callback){return this.animate(props,speed,easing,callback)}});jQuery.timers=[];jQuery.fx.tick=function(){var timer,i=0,timers=jQuery.timers;fxNow=Date.now();for(;i<timers.length;i++){timer=timers[i];if(!timer()&&timers[i]===timer){timers.splice(i--,1)}}
if(!timers.length){jQuery.fx.stop()}
fxNow=undefined};jQuery.fx.timer=function(timer){jQuery.timers.push(timer);jQuery.fx.start()};jQuery.fx.interval=13;jQuery.fx.start=function(){if(inProgress){return}
inProgress=!0;schedule()};jQuery.fx.stop=function(){inProgress=null};jQuery.fx.speeds={slow:600,fast:200,_default:400};jQuery.fn.delay=function(time,type){time=jQuery.fx?jQuery.fx.speeds[time]||time:time;type=type||"fx";return this.queue(type,function(next,hooks){var timeout=window.setTimeout(next,time);hooks.stop=function(){window.clearTimeout(timeout)}})};(function(){var input=document.createElement("input"),select=document.createElement("select"),opt=select.appendChild(document.createElement("option"));input.type="checkbox";support.checkOn=input.value!=="";support.optSelected=opt.selected;input=document.createElement("input");input.value="t";input.type="radio";support.radioValue=input.value==="t"})();var boolHook,attrHandle=jQuery.expr.attrHandle;jQuery.fn.extend({attr:function(name,value){return access(this,jQuery.attr,name,value,arguments.length>1)},removeAttr:function(name){return this.each(function(){jQuery.removeAttr(this,name)})}});jQuery.extend({attr:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}
if(typeof elem.getAttribute==="undefined"){return jQuery.prop(elem,name,value)}
if(nType!==1||!jQuery.isXMLDoc(elem)){hooks=jQuery.attrHooks[name.toLowerCase()]||(jQuery.expr.match.bool.test(name)?boolHook:undefined)}
if(value!==undefined){if(value===null){jQuery.removeAttr(elem,name);return}
if(hooks&&"set" in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}
elem.setAttribute(name,value+"");return value}
if(hooks&&"get" in hooks&&(ret=hooks.get(elem,name))!==null){return ret}
ret=jQuery.find.attr(elem,name);return ret==null?undefined:ret},attrHooks:{type:{set:function(elem,value){if(!support.radioValue&&value==="radio"&&nodeName(elem,"input")){var val=elem.value;elem.setAttribute("type",value);if(val){elem.value=val}
return value}}}},removeAttr:function(elem,value){var name,i=0,attrNames=value&&value.match(rnothtmlwhite);if(attrNames&&elem.nodeType===1){while((name=attrNames[i++])){elem.removeAttribute(name)}}}});boolHook={set:function(elem,value,name){if(value===!1){jQuery.removeAttr(elem,name)}else{elem.setAttribute(name,name)}
return name}};jQuery.each(jQuery.expr.match.bool.source.match(/\w+/g),function(_i,name){var getter=attrHandle[name]||jQuery.find.attr;attrHandle[name]=function(elem,name,isXML){var ret,handle,lowercaseName=name.toLowerCase();if(!isXML){handle=attrHandle[lowercaseName];attrHandle[lowercaseName]=ret;ret=getter(elem,name,isXML)!=null?lowercaseName:null;attrHandle[lowercaseName]=handle}
return ret}});var rfocusable=/^(?:input|select|textarea|button)$/i,rclickable=/^(?:a|area)$/i;jQuery.fn.extend({prop:function(name,value){return access(this,jQuery.prop,name,value,arguments.length>1)},removeProp:function(name){return this.each(function(){delete this[jQuery.propFix[name]||name]})}});jQuery.extend({prop:function(elem,name,value){var ret,hooks,nType=elem.nodeType;if(nType===3||nType===8||nType===2){return}
if(nType!==1||!jQuery.isXMLDoc(elem)){name=jQuery.propFix[name]||name;hooks=jQuery.propHooks[name]}
if(value!==undefined){if(hooks&&"set" in hooks&&(ret=hooks.set(elem,value,name))!==undefined){return ret}
return(elem[name]=value)}
if(hooks&&"get" in hooks&&(ret=hooks.get(elem,name))!==null){return ret}
return elem[name]},propHooks:{tabIndex:{get:function(elem){var tabindex=jQuery.find.attr(elem,"tabindex");if(tabindex){return parseInt(tabindex,10)}
if(rfocusable.test(elem.nodeName)||rclickable.test(elem.nodeName)&&elem.href){return 0}
return-1}}},propFix:{"for":"htmlFor","class":"className"}});if(!support.optSelected){jQuery.propHooks.selected={get:function(elem){var parent=elem.parentNode;if(parent&&parent.parentNode){parent.parentNode.selectedIndex}
return null},set:function(elem){var parent=elem.parentNode;if(parent){parent.selectedIndex;if(parent.parentNode){parent.parentNode.selectedIndex}}}}}
jQuery.each(["tabIndex","readOnly","maxLength","cellSpacing","cellPadding","rowSpan","colSpan","useMap","frameBorder","contentEditable"],function(){jQuery.propFix[this.toLowerCase()]=this});function stripAndCollapse(value){var tokens=value.match(rnothtmlwhite)||[];return tokens.join(" ")}
function getClass(elem){return elem.getAttribute&&elem.getAttribute("class")||""}
function classesToArray(value){if(Array.isArray(value)){return value}
if(typeof value==="string"){return value.match(rnothtmlwhite)||[]}
return[]}
jQuery.fn.extend({addClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each(function(j){jQuery(this).addClass(value.call(this,j,getClass(this)))})}
classNames=classesToArray(value);if(classNames.length){return this.each(function(){curValue=getClass(this);cur=this.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];if(cur.indexOf(" "+className+" ")<0){cur+=className+" "}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}})}
return this},removeClass:function(value){var classNames,cur,curValue,className,i,finalValue;if(isFunction(value)){return this.each(function(j){jQuery(this).removeClass(value.call(this,j,getClass(this)))})}
if(!arguments.length){return this.attr("class","")}
classNames=classesToArray(value);if(classNames.length){return this.each(function(){curValue=getClass(this);cur=this.nodeType===1&&(" "+stripAndCollapse(curValue)+" ");if(cur){for(i=0;i<classNames.length;i++){className=classNames[i];while(cur.indexOf(" "+className+" ")>-1){cur=cur.replace(" "+className+" "," ")}}
finalValue=stripAndCollapse(cur);if(curValue!==finalValue){this.setAttribute("class",finalValue)}}})}
return this},toggleClass:function(value,stateVal){var classNames,className,i,self,type=typeof value,isValidValue=type==="string"||Array.isArray(value);if(isFunction(value)){return this.each(function(i){jQuery(this).toggleClass(value.call(this,i,getClass(this),stateVal),stateVal)})}
if(typeof stateVal==="boolean"&&isValidValue){return stateVal?this.addClass(value):this.removeClass(value)}
classNames=classesToArray(value);return this.each(function(){if(isValidValue){self=jQuery(this);for(i=0;i<classNames.length;i++){className=classNames[i];if(self.hasClass(className)){self.removeClass(className)}else{self.addClass(className)}}}else if(value===undefined||type==="boolean"){className=getClass(this);if(className){dataPriv.set(this,"__className__",className)}
if(this.setAttribute){this.setAttribute("class",className||value===!1?"":dataPriv.get(this,"__className__")||"")}}})},hasClass:function(selector){var className,elem,i=0;className=" "+selector+" ";while((elem=this[i++])){if(elem.nodeType===1&&(" "+stripAndCollapse(getClass(elem))+" ").indexOf(className)>-1){return!0}}
return!1}});var rreturn=/\r/g;jQuery.fn.extend({val:function(value){var hooks,ret,valueIsFunction,elem=this[0];if(!arguments.length){if(elem){hooks=jQuery.valHooks[elem.type]||jQuery.valHooks[elem.nodeName.toLowerCase()];if(hooks&&"get" in hooks&&(ret=hooks.get(elem,"value"))!==undefined){return ret}
ret=elem.value;if(typeof ret==="string"){return ret.replace(rreturn,"")}
return ret==null?"":ret}
return}
valueIsFunction=isFunction(value);return this.each(function(i){var val;if(this.nodeType!==1){return}
if(valueIsFunction){val=value.call(this,i,jQuery(this).val())}else{val=value}
if(val==null){val=""}else if(typeof val==="number"){val+=""}else if(Array.isArray(val)){val=jQuery.map(val,function(value){return value==null?"":value+""})}
hooks=jQuery.valHooks[this.type]||jQuery.valHooks[this.nodeName.toLowerCase()];if(!hooks||!("set" in hooks)||hooks.set(this,val,"value")===undefined){this.value=val}})}});jQuery.extend({valHooks:{option:{get:function(elem){var val=jQuery.find.attr(elem,"value");return val!=null?val:stripAndCollapse(jQuery.text(elem))}},select:{get:function(elem){var value,option,i,options=elem.options,index=elem.selectedIndex,one=elem.type==="select-one",values=one?null:[],max=one?index+1:options.length;if(index<0){i=max}else{i=one?index:0}
for(;i<max;i++){option=options[i];if((option.selected||i===index)&&!option.disabled&&(!option.parentNode.disabled||!nodeName(option.parentNode,"optgroup"))){value=jQuery(option).val();if(one){return value}
values.push(value)}}
return values},set:function(elem,value){var optionSet,option,options=elem.options,values=jQuery.makeArray(value),i=options.length;while(i--){option=options[i];if(option.selected=jQuery.inArray(jQuery.valHooks.option.get(option),values)>-1){optionSet=!0}}
if(!optionSet){elem.selectedIndex=-1}
return values}}}});jQuery.each(["radio","checkbox"],function(){jQuery.valHooks[this]={set:function(elem,value){if(Array.isArray(value)){return(elem.checked=jQuery.inArray(jQuery(elem).val(),value)>-1)}}};if(!support.checkOn){jQuery.valHooks[this].get=function(elem){return elem.getAttribute("value")===null?"on":elem.value}}});var location=window.location;var nonce={guid:Date.now()};var rquery=(/\?/);jQuery.parseXML=function(data){var xml,parserErrorElem;if(!data||typeof data!=="string"){return null}
try{xml=(new window.DOMParser()).parseFromString(data,"text/xml")}catch(e){}
parserErrorElem=xml&&xml.getElementsByTagName("parsererror")[0];if(!xml||parserErrorElem){jQuery.error("Invalid XML: "+(parserErrorElem?jQuery.map(parserErrorElem.childNodes,function(el){return el.textContent}).join("\n"):data))}
return xml};var rfocusMorph=/^(?:focusinfocus|focusoutblur)$/,stopPropagationCallback=function(e){e.stopPropagation()};jQuery.extend(jQuery.event,{trigger:function(event,data,elem,onlyHandlers){var i,cur,tmp,bubbleType,ontype,handle,special,lastElement,eventPath=[elem||document],type=hasOwn.call(event,"type")?event.type:event,namespaces=hasOwn.call(event,"namespace")?event.namespace.split("."):[];cur=lastElement=tmp=elem=elem||document;if(elem.nodeType===3||elem.nodeType===8){return}
if(rfocusMorph.test(type+jQuery.event.triggered)){return}
if(type.indexOf(".")>-1){namespaces=type.split(".");type=namespaces.shift();namespaces.sort()}
ontype=type.indexOf(":")<0&&"on"+type;event=event[jQuery.expando]?event:new jQuery.Event(type,typeof event==="object"&&event);event.isTrigger=onlyHandlers?2:3;event.namespace=namespaces.join(".");event.rnamespace=event.namespace?new RegExp("(^|\\.)"+namespaces.join("\\.(?:.*\\.|)")+"(\\.|$)"):null;event.result=undefined;if(!event.target){event.target=elem}
data=data==null?[event]:jQuery.makeArray(data,[event]);special=jQuery.event.special[type]||{};if(!onlyHandlers&&special.trigger&&special.trigger.apply(elem,data)===!1){return}
if(!onlyHandlers&&!special.noBubble&&!isWindow(elem)){bubbleType=special.delegateType||type;if(!rfocusMorph.test(bubbleType+type)){cur=cur.parentNode}
for(;cur;cur=cur.parentNode){eventPath.push(cur);tmp=cur}
if(tmp===(elem.ownerDocument||document)){eventPath.push(tmp.defaultView||tmp.parentWindow||window)}}
i=0;while((cur=eventPath[i++])&&!event.isPropagationStopped()){lastElement=cur;event.type=i>1?bubbleType:special.bindType||type;handle=(dataPriv.get(cur,"events")||Object.create(null))[event.type]&&dataPriv.get(cur,"handle");if(handle){handle.apply(cur,data)}
handle=ontype&&cur[ontype];if(handle&&handle.apply&&acceptData(cur)){event.result=handle.apply(cur,data);if(event.result===!1){event.preventDefault()}}}
event.type=type;if(!onlyHandlers&&!event.isDefaultPrevented()){if((!special._default||special._default.apply(eventPath.pop(),data)===!1)&&acceptData(elem)){if(ontype&&isFunction(elem[type])&&!isWindow(elem)){tmp=elem[ontype];if(tmp){elem[ontype]=null}
jQuery.event.triggered=type;if(event.isPropagationStopped()){lastElement.addEventListener(type,stopPropagationCallback)}
elem[type]();if(event.isPropagationStopped()){lastElement.removeEventListener(type,stopPropagationCallback)}
jQuery.event.triggered=undefined;if(tmp){elem[ontype]=tmp}}}}
return event.result},simulate:function(type,elem,event){var e=jQuery.extend(new jQuery.Event(),event,{type:type,isSimulated:!0});jQuery.event.trigger(e,null,elem)}});jQuery.fn.extend({trigger:function(type,data){return this.each(function(){jQuery.event.trigger(type,data,this)})},triggerHandler:function(type,data){var elem=this[0];if(elem){return jQuery.event.trigger(type,data,elem,!0)}}});var rbracket=/\[\]$/,rCRLF=/\r?\n/g,rsubmitterTypes=/^(?:submit|button|image|reset|file)$/i,rsubmittable=/^(?:input|select|textarea|keygen)/i;function buildParams(prefix,obj,traditional,add){var name;if(Array.isArray(obj)){jQuery.each(obj,function(i,v){if(traditional||rbracket.test(prefix)){add(prefix,v)}else{buildParams(prefix+"["+(typeof v==="object"&&v!=null?i:"")+"]",v,traditional,add)}})}else if(!traditional&&toType(obj)==="object"){for(name in obj){buildParams(prefix+"["+name+"]",obj[name],traditional,add)}}else{add(prefix,obj)}}
jQuery.param=function(a,traditional){var prefix,s=[],add=function(key,valueOrFunction){var value=isFunction(valueOrFunction)?valueOrFunction():valueOrFunction;s[s.length]=encodeURIComponent(key)+"="+encodeURIComponent(value==null?"":value)};if(a==null){return""}
if(Array.isArray(a)||(a.jquery&&!jQuery.isPlainObject(a))){jQuery.each(a,function(){add(this.name,this.value)})}else{for(prefix in a){buildParams(prefix,a[prefix],traditional,add)}}
return s.join("&")};jQuery.fn.extend({serialize:function(){return jQuery.param(this.serializeArray())},serializeArray:function(){return this.map(function(){var elements=jQuery.prop(this,"elements");return elements?jQuery.makeArray(elements):this}).filter(function(){var type=this.type;return this.name&&!jQuery(this).is(":disabled")&&rsubmittable.test(this.nodeName)&&!rsubmitterTypes.test(type)&&(this.checked||!rcheckableType.test(type))}).map(function(_i,elem){var val=jQuery(this).val();if(val==null){return null}
if(Array.isArray(val)){return jQuery.map(val,function(val){return{name:elem.name,value:val.replace(rCRLF,"\r\n")}})}
return{name:elem.name,value:val.replace(rCRLF,"\r\n")}}).get()}});var r20=/%20/g,rhash=/#.*$/,rantiCache=/([?&])_=[^&]*/,rheaders=/^(.*?):[ \t]*([^\r\n]*)$/mg,rlocalProtocol=/^(?:about|app|app-storage|.+-extension|file|res|widget):$/,rnoContent=/^(?:GET|HEAD)$/,rprotocol=/^\/\//,prefilters={},transports={},allTypes="*/".concat("*"),originAnchor=document.createElement("a");originAnchor.href=location.href;function addToPrefiltersOrTransports(structure){return function(dataTypeExpression,func){if(typeof dataTypeExpression!=="string"){func=dataTypeExpression;dataTypeExpression="*"}
var dataType,i=0,dataTypes=dataTypeExpression.toLowerCase().match(rnothtmlwhite)||[];if(isFunction(func)){while((dataType=dataTypes[i++])){if(dataType[0]==="+"){dataType=dataType.slice(1)||"*";(structure[dataType]=structure[dataType]||[]).unshift(func)}else{(structure[dataType]=structure[dataType]||[]).push(func)}}}}}
function inspectPrefiltersOrTransports(structure,options,originalOptions,jqXHR){var inspected={},seekingTransport=(structure===transports);function inspect(dataType){var selected;inspected[dataType]=!0;jQuery.each(structure[dataType]||[],function(_,prefilterOrFactory){var dataTypeOrTransport=prefilterOrFactory(options,originalOptions,jqXHR);if(typeof dataTypeOrTransport==="string"&&!seekingTransport&&!inspected[dataTypeOrTransport]){options.dataTypes.unshift(dataTypeOrTransport);inspect(dataTypeOrTransport);return!1}else if(seekingTransport){return!(selected=dataTypeOrTransport)}});return selected}
return inspect(options.dataTypes[0])||!inspected["*"]&&inspect("*")}
function ajaxExtend(target,src){var key,deep,flatOptions=jQuery.ajaxSettings.flatOptions||{};for(key in src){if(src[key]!==undefined){(flatOptions[key]?target:(deep||(deep={})))[key]=src[key]}}
if(deep){jQuery.extend(!0,target,deep)}
return target}
function ajaxHandleResponses(s,jqXHR,responses){var ct,type,finalDataType,firstDataType,contents=s.contents,dataTypes=s.dataTypes;while(dataTypes[0]==="*"){dataTypes.shift();if(ct===undefined){ct=s.mimeType||jqXHR.getResponseHeader("Content-Type")}}
if(ct){for(type in contents){if(contents[type]&&contents[type].test(ct)){dataTypes.unshift(type);break}}}
if(dataTypes[0]in responses){finalDataType=dataTypes[0]}else{for(type in responses){if(!dataTypes[0]||s.converters[type+" "+dataTypes[0]]){finalDataType=type;break}
if(!firstDataType){firstDataType=type}}
finalDataType=finalDataType||firstDataType}
if(finalDataType){if(finalDataType!==dataTypes[0]){dataTypes.unshift(finalDataType)}
return responses[finalDataType]}}
function ajaxConvert(s,response,jqXHR,isSuccess){var conv2,current,conv,tmp,prev,converters={},dataTypes=s.dataTypes.slice();if(dataTypes[1]){for(conv in s.converters){converters[conv.toLowerCase()]=s.converters[conv]}}
current=dataTypes.shift();while(current){if(s.responseFields[current]){jqXHR[s.responseFields[current]]=response}
if(!prev&&isSuccess&&s.dataFilter){response=s.dataFilter(response,s.dataType)}
prev=current;current=dataTypes.shift();if(current){if(current==="*"){current=prev}else if(prev!=="*"&&prev!==current){conv=converters[prev+" "+current]||converters["* "+current];if(!conv){for(conv2 in converters){tmp=conv2.split(" ");if(tmp[1]===current){conv=converters[prev+" "+tmp[0]]||converters["* "+tmp[0]];if(conv){if(conv===!0){conv=converters[conv2]}else if(converters[conv2]!==!0){current=tmp[0];dataTypes.unshift(tmp[1])}
break}}}}
if(conv!==!0){if(conv&&s.throws){response=conv(response)}else{try{response=conv(response)}catch(e){return{state:"parsererror",error:conv?e:"No conversion from "+prev+" to "+current}}}}}}}
return{state:"success",data:response}}
jQuery.extend({active:0,lastModified:{},etag:{},ajaxSettings:{url:location.href,type:"GET",isLocal:rlocalProtocol.test(location.protocol),global:!0,processData:!0,async:!0,contentType:"application/x-www-form-urlencoded; charset=UTF-8",accepts:{"*":allTypes,text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript"},contents:{xml:/\bxml\b/,html:/\bhtml/,json:/\bjson\b/},responseFields:{xml:"responseXML",text:"responseText",json:"responseJSON"},converters:{"* text":String,"text html":!0,"text json":JSON.parse,"text xml":jQuery.parseXML},flatOptions:{url:!0,context:!0}},ajaxSetup:function(target,settings){return settings?ajaxExtend(ajaxExtend(target,jQuery.ajaxSettings),settings):ajaxExtend(jQuery.ajaxSettings,target)},ajaxPrefilter:addToPrefiltersOrTransports(prefilters),ajaxTransport:addToPrefiltersOrTransports(transports),ajax:function(url,options){if(typeof url==="object"){options=url;url=undefined}
options=options||{};var transport,cacheURL,responseHeadersString,responseHeaders,timeoutTimer,urlAnchor,completed,fireGlobals,i,uncached,s=jQuery.ajaxSetup({},options),callbackContext=s.context||s,globalEventContext=s.context&&(callbackContext.nodeType||callbackContext.jquery)?jQuery(callbackContext):jQuery.event,deferred=jQuery.Deferred(),completeDeferred=jQuery.Callbacks("once memory"),statusCode=s.statusCode||{},requestHeaders={},requestHeadersNames={},strAbort="canceled",jqXHR={readyState:0,getResponseHeader:function(key){var match;if(completed){if(!responseHeaders){responseHeaders={};while((match=rheaders.exec(responseHeadersString))){responseHeaders[match[1].toLowerCase()+" "]=(responseHeaders[match[1].toLowerCase()+" "]||[]).concat(match[2])}}
match=responseHeaders[key.toLowerCase()+" "]}
return match==null?null:match.join(", ")},getAllResponseHeaders:function(){return completed?responseHeadersString:null},setRequestHeader:function(name,value){if(completed==null){name=requestHeadersNames[name.toLowerCase()]=requestHeadersNames[name.toLowerCase()]||name;requestHeaders[name]=value}
return this},overrideMimeType:function(type){if(completed==null){s.mimeType=type}
return this},statusCode:function(map){var code;if(map){if(completed){jqXHR.always(map[jqXHR.status])}else{for(code in map){statusCode[code]=[statusCode[code],map[code]]}}}
return this},abort:function(statusText){var finalText=statusText||strAbort;if(transport){transport.abort(finalText)}
done(0,finalText);return this}};deferred.promise(jqXHR);s.url=((url||s.url||location.href)+"").replace(rprotocol,location.protocol+"//");s.type=options.method||options.type||s.method||s.type;s.dataTypes=(s.dataType||"*").toLowerCase().match(rnothtmlwhite)||[""];if(s.crossDomain==null){urlAnchor=document.createElement("a");try{urlAnchor.href=s.url;urlAnchor.href=urlAnchor.href;s.crossDomain=originAnchor.protocol+"//"+originAnchor.host!==urlAnchor.protocol+"//"+urlAnchor.host}catch(e){s.crossDomain=!0}}
if(s.data&&s.processData&&typeof s.data!=="string"){s.data=jQuery.param(s.data,s.traditional)}
inspectPrefiltersOrTransports(prefilters,s,options,jqXHR);if(completed){return jqXHR}
fireGlobals=jQuery.event&&s.global;if(fireGlobals&&jQuery.active++===0){jQuery.event.trigger("ajaxStart")}
s.type=s.type.toUpperCase();s.hasContent=!rnoContent.test(s.type);cacheURL=s.url.replace(rhash,"");if(!s.hasContent){uncached=s.url.slice(cacheURL.length);if(s.data&&(s.processData||typeof s.data==="string")){cacheURL+=(rquery.test(cacheURL)?"&":"?")+s.data;delete s.data}
if(s.cache===!1){cacheURL=cacheURL.replace(rantiCache,"$1");uncached=(rquery.test(cacheURL)?"&":"?")+"_="+(nonce.guid++)+uncached}
s.url=cacheURL+uncached}else if(s.data&&s.processData&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0){s.data=s.data.replace(r20,"+")}
if(s.ifModified){if(jQuery.lastModified[cacheURL]){jqXHR.setRequestHeader("If-Modified-Since",jQuery.lastModified[cacheURL])}
if(jQuery.etag[cacheURL]){jqXHR.setRequestHeader("If-None-Match",jQuery.etag[cacheURL])}}
if(s.data&&s.hasContent&&s.contentType!==!1||options.contentType){jqXHR.setRequestHeader("Content-Type",s.contentType)}
jqXHR.setRequestHeader("Accept",s.dataTypes[0]&&s.accepts[s.dataTypes[0]]?s.accepts[s.dataTypes[0]]+(s.dataTypes[0]!=="*"?", "+allTypes+"; q=0.01":""):s.accepts["*"]);for(i in s.headers){jqXHR.setRequestHeader(i,s.headers[i])}
if(s.beforeSend&&(s.beforeSend.call(callbackContext,jqXHR,s)===!1||completed)){return jqXHR.abort()}
strAbort="abort";completeDeferred.add(s.complete);jqXHR.done(s.success);jqXHR.fail(s.error);transport=inspectPrefiltersOrTransports(transports,s,options,jqXHR);if(!transport){done(-1,"No Transport")}else{jqXHR.readyState=1;if(fireGlobals){globalEventContext.trigger("ajaxSend",[jqXHR,s])}
if(completed){return jqXHR}
if(s.async&&s.timeout>0){timeoutTimer=window.setTimeout(function(){jqXHR.abort("timeout")},s.timeout)}
try{completed=!1;transport.send(requestHeaders,done)}catch(e){if(completed){throw e}
done(-1,e)}}
function done(status,nativeStatusText,responses,headers){var isSuccess,success,error,response,modified,statusText=nativeStatusText;if(completed){return}
completed=!0;if(timeoutTimer){window.clearTimeout(timeoutTimer)}
transport=undefined;responseHeadersString=headers||"";jqXHR.readyState=status>0?4:0;isSuccess=status>=200&&status<300||status===304;if(responses){response=ajaxHandleResponses(s,jqXHR,responses)}
if(!isSuccess&&jQuery.inArray("script",s.dataTypes)>-1&&jQuery.inArray("json",s.dataTypes)<0){s.converters["text script"]=function(){}}
response=ajaxConvert(s,response,jqXHR,isSuccess);if(isSuccess){if(s.ifModified){modified=jqXHR.getResponseHeader("Last-Modified");if(modified){jQuery.lastModified[cacheURL]=modified}
modified=jqXHR.getResponseHeader("etag");if(modified){jQuery.etag[cacheURL]=modified}}
if(status===204||s.type==="HEAD"){statusText="nocontent"}else if(status===304){statusText="notmodified"}else{statusText=response.state;success=response.data;error=response.error;isSuccess=!error}}else{error=statusText;if(status||!statusText){statusText="error";if(status<0){status=0}}}
jqXHR.status=status;jqXHR.statusText=(nativeStatusText||statusText)+"";if(isSuccess){deferred.resolveWith(callbackContext,[success,statusText,jqXHR])}else{deferred.rejectWith(callbackContext,[jqXHR,statusText,error])}
jqXHR.statusCode(statusCode);statusCode=undefined;if(fireGlobals){globalEventContext.trigger(isSuccess?"ajaxSuccess":"ajaxError",[jqXHR,s,isSuccess?success:error])}
completeDeferred.fireWith(callbackContext,[jqXHR,statusText]);if(fireGlobals){globalEventContext.trigger("ajaxComplete",[jqXHR,s]);if(!(--jQuery.active)){jQuery.event.trigger("ajaxStop")}}}
return jqXHR},getJSON:function(url,data,callback){return jQuery.get(url,data,callback,"json")},getScript:function(url,callback){return jQuery.get(url,undefined,callback,"script")}});jQuery.each(["get","post"],function(_i,method){jQuery[method]=function(url,data,callback,type){if(isFunction(data)){type=type||callback;callback=data;data=undefined}
return jQuery.ajax(jQuery.extend({url:url,type:method,dataType:type,data:data,success:callback},jQuery.isPlainObject(url)&&url))}});jQuery.ajaxPrefilter(function(s){var i;for(i in s.headers){if(i.toLowerCase()==="content-type"){s.contentType=s.headers[i]||""}}});jQuery._evalUrl=function(url,options,doc){return jQuery.ajax({url:url,type:"GET",dataType:"script",cache:!0,async:!1,global:!1,converters:{"text script":function(){}},dataFilter:function(response){jQuery.globalEval(response,options,doc)}})};jQuery.fn.extend({wrapAll:function(html){var wrap;if(this[0]){if(isFunction(html)){html=html.call(this[0])}
wrap=jQuery(html,this[0].ownerDocument).eq(0).clone(!0);if(this[0].parentNode){wrap.insertBefore(this[0])}
wrap.map(function(){var elem=this;while(elem.firstElementChild){elem=elem.firstElementChild}
return elem}).append(this)}
return this},wrapInner:function(html){if(isFunction(html)){return this.each(function(i){jQuery(this).wrapInner(html.call(this,i))})}
return this.each(function(){var self=jQuery(this),contents=self.contents();if(contents.length){contents.wrapAll(html)}else{self.append(html)}})},wrap:function(html){var htmlIsFunction=isFunction(html);return this.each(function(i){jQuery(this).wrapAll(htmlIsFunction?html.call(this,i):html)})},unwrap:function(selector){this.parent(selector).not("body").each(function(){jQuery(this).replaceWith(this.childNodes)});return this}});jQuery.expr.pseudos.hidden=function(elem){return!jQuery.expr.pseudos.visible(elem)};jQuery.expr.pseudos.visible=function(elem){return!!(elem.offsetWidth||elem.offsetHeight||elem.getClientRects().length)};jQuery.ajaxSettings.xhr=function(){try{return new window.XMLHttpRequest()}catch(e){}};var xhrSuccessStatus={0:200,1223:204},xhrSupported=jQuery.ajaxSettings.xhr();support.cors=!!xhrSupported&&("withCredentials" in xhrSupported);support.ajax=xhrSupported=!!xhrSupported;jQuery.ajaxTransport(function(options){var callback,errorCallback;if(support.cors||xhrSupported&&!options.crossDomain){return{send:function(headers,complete){var i,xhr=options.xhr();xhr.open(options.type,options.url,options.async,options.username,options.password);if(options.xhrFields){for(i in options.xhrFields){xhr[i]=options.xhrFields[i]}}
if(options.mimeType&&xhr.overrideMimeType){xhr.overrideMimeType(options.mimeType)}
if(!options.crossDomain&&!headers["X-Requested-With"]){headers["X-Requested-With"]="XMLHttpRequest"}
for(i in headers){xhr.setRequestHeader(i,headers[i])}
callback=function(type){return function(){if(callback){callback=errorCallback=xhr.onload=xhr.onerror=xhr.onabort=xhr.ontimeout=xhr.onreadystatechange=null;if(type==="abort"){xhr.abort()}else if(type==="error"){if(typeof xhr.status!=="number"){complete(0,"error")}else{complete(xhr.status,xhr.statusText)}}else{complete(xhrSuccessStatus[xhr.status]||xhr.status,xhr.statusText,(xhr.responseType||"text")!=="text"||typeof xhr.responseText!=="string"?{binary:xhr.response}:{text:xhr.responseText},xhr.getAllResponseHeaders())}}}};xhr.onload=callback();errorCallback=xhr.onerror=xhr.ontimeout=callback("error");if(xhr.onabort!==undefined){xhr.onabort=errorCallback}else{xhr.onreadystatechange=function(){if(xhr.readyState===4){window.setTimeout(function(){if(callback){errorCallback()}})}}}
callback=callback("abort");try{xhr.send(options.hasContent&&options.data||null)}catch(e){if(callback){throw e}}},abort:function(){if(callback){callback()}}}}});jQuery.ajaxPrefilter(function(s){if(s.crossDomain){s.contents.script=!1}});jQuery.ajaxSetup({accepts:{script:"text/javascript, application/javascript, "+"application/ecmascript, application/x-ecmascript"},contents:{script:/\b(?:java|ecma)script\b/},converters:{"text script":function(text){jQuery.globalEval(text);return text}}});jQuery.ajaxPrefilter("script",function(s){if(s.cache===undefined){s.cache=!1}
if(s.crossDomain){s.type="GET"}});jQuery.ajaxTransport("script",function(s){if(s.crossDomain||s.scriptAttrs){var script,callback;return{send:function(_,complete){script=jQuery("<script>").attr(s.scriptAttrs||{}).prop({charset:s.scriptCharset,src:s.url}).on("load error",callback=function(evt){script.remove();callback=null;if(evt){complete(evt.type==="error"?404:200,evt.type)}});document.head.appendChild(script[0])},abort:function(){if(callback){callback()}}}}});var oldCallbacks=[],rjsonp=/(=)\?(?=&|$)|\?\?/;jQuery.ajaxSetup({jsonp:"callback",jsonpCallback:function(){var callback=oldCallbacks.pop()||(jQuery.expando+"_"+(nonce.guid++));this[callback]=!0;return callback}});jQuery.ajaxPrefilter("json jsonp",function(s,originalSettings,jqXHR){var callbackName,overwritten,responseContainer,jsonProp=s.jsonp!==!1&&(rjsonp.test(s.url)?"url":typeof s.data==="string"&&(s.contentType||"").indexOf("application/x-www-form-urlencoded")===0&&rjsonp.test(s.data)&&"data");if(jsonProp||s.dataTypes[0]==="jsonp"){callbackName=s.jsonpCallback=isFunction(s.jsonpCallback)?s.jsonpCallback():s.jsonpCallback;if(jsonProp){s[jsonProp]=s[jsonProp].replace(rjsonp,"$1"+callbackName)}else if(s.jsonp!==!1){s.url+=(rquery.test(s.url)?"&":"?")+s.jsonp+"="+callbackName}
s.converters["script json"]=function(){if(!responseContainer){jQuery.error(callbackName+" was not called")}
return responseContainer[0]};s.dataTypes[0]="json";overwritten=window[callbackName];window[callbackName]=function(){responseContainer=arguments};jqXHR.always(function(){if(overwritten===undefined){jQuery(window).removeProp(callbackName)}else{window[callbackName]=overwritten}
if(s[callbackName]){s.jsonpCallback=originalSettings.jsonpCallback;oldCallbacks.push(callbackName)}
if(responseContainer&&isFunction(overwritten)){overwritten(responseContainer[0])}
responseContainer=overwritten=undefined});return"script"}});support.createHTMLDocument=(function(){var body=document.implementation.createHTMLDocument("").body;body.innerHTML="<form></form><form></form>";return body.childNodes.length===2})();jQuery.parseHTML=function(data,context,keepScripts){if(typeof data!=="string"){return[]}
if(typeof context==="boolean"){keepScripts=context;context=!1}
var base,parsed,scripts;if(!context){if(support.createHTMLDocument){context=document.implementation.createHTMLDocument("");base=context.createElement("base");base.href=document.location.href;context.head.appendChild(base)}else{context=document}}
parsed=rsingleTag.exec(data);scripts=!keepScripts&&[];if(parsed){return[context.createElement(parsed[1])]}
parsed=buildFragment([data],context,scripts);if(scripts&&scripts.length){jQuery(scripts).remove()}
return jQuery.merge([],parsed.childNodes)};jQuery.fn.load=function(url,params,callback){var selector,type,response,self=this,off=url.indexOf(" ");if(off>-1){selector=stripAndCollapse(url.slice(off));url=url.slice(0,off)}
if(isFunction(params)){callback=params;params=undefined}else if(params&&typeof params==="object"){type="POST"}
if(self.length>0){jQuery.ajax({url:url,type:type||"GET",dataType:"html",data:params}).done(function(responseText){response=arguments;self.html(selector?jQuery("<div>").append(jQuery.parseHTML(responseText)).find(selector):responseText)}).always(callback&&function(jqXHR,status){self.each(function(){callback.apply(this,response||[jqXHR.responseText,status,jqXHR])})})}
return this};jQuery.expr.pseudos.animated=function(elem){return jQuery.grep(jQuery.timers,function(fn){return elem===fn.elem}).length};jQuery.offset={setOffset:function(elem,options,i){var curPosition,curLeft,curCSSTop,curTop,curOffset,curCSSLeft,calculatePosition,position=jQuery.css(elem,"position"),curElem=jQuery(elem),props={};if(position==="static"){elem.style.position="relative"}
curOffset=curElem.offset();curCSSTop=jQuery.css(elem,"top");curCSSLeft=jQuery.css(elem,"left");calculatePosition=(position==="absolute"||position==="fixed")&&(curCSSTop+curCSSLeft).indexOf("auto")>-1;if(calculatePosition){curPosition=curElem.position();curTop=curPosition.top;curLeft=curPosition.left}else{curTop=parseFloat(curCSSTop)||0;curLeft=parseFloat(curCSSLeft)||0}
if(isFunction(options)){options=options.call(elem,i,jQuery.extend({},curOffset))}
if(options.top!=null){props.top=(options.top-curOffset.top)+curTop}
if(options.left!=null){props.left=(options.left-curOffset.left)+curLeft}
if("using" in options){options.using.call(elem,props)}else{curElem.css(props)}}};jQuery.fn.extend({offset:function(options){if(arguments.length){return options===undefined?this:this.each(function(i){jQuery.offset.setOffset(this,options,i)})}
var rect,win,elem=this[0];if(!elem){return}
if(!elem.getClientRects().length){return{top:0,left:0}}
rect=elem.getBoundingClientRect();win=elem.ownerDocument.defaultView;return{top:rect.top+win.pageYOffset,left:rect.left+win.pageXOffset}},position:function(){if(!this[0]){return}
var offsetParent,offset,doc,elem=this[0],parentOffset={top:0,left:0};if(jQuery.css(elem,"position")==="fixed"){offset=elem.getBoundingClientRect()}else{offset=this.offset();doc=elem.ownerDocument;offsetParent=elem.offsetParent||doc.documentElement;while(offsetParent&&(offsetParent===doc.body||offsetParent===doc.documentElement)&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.parentNode}
if(offsetParent&&offsetParent!==elem&&offsetParent.nodeType===1){parentOffset=jQuery(offsetParent).offset();parentOffset.top+=jQuery.css(offsetParent,"borderTopWidth",!0);parentOffset.left+=jQuery.css(offsetParent,"borderLeftWidth",!0)}}
return{top:offset.top-parentOffset.top-jQuery.css(elem,"marginTop",!0),left:offset.left-parentOffset.left-jQuery.css(elem,"marginLeft",!0)}},offsetParent:function(){return this.map(function(){var offsetParent=this.offsetParent;while(offsetParent&&jQuery.css(offsetParent,"position")==="static"){offsetParent=offsetParent.offsetParent}
return offsetParent||documentElement})}});jQuery.each({scrollLeft:"pageXOffset",scrollTop:"pageYOffset"},function(method,prop){var top="pageYOffset"===prop;jQuery.fn[method]=function(val){return access(this,function(elem,method,val){var win;if(isWindow(elem)){win=elem}else if(elem.nodeType===9){win=elem.defaultView}
if(val===undefined){return win?win[prop]:elem[method]}
if(win){win.scrollTo(!top?val:win.pageXOffset,top?val:win.pageYOffset)}else{elem[method]=val}},method,val,arguments.length)}});jQuery.each(["top","left"],function(_i,prop){jQuery.cssHooks[prop]=addGetHookIf(support.pixelPosition,function(elem,computed){if(computed){computed=curCSS(elem,prop);return rnumnonpx.test(computed)?jQuery(elem).position()[prop]+"px":computed}})});jQuery.each({Height:"height",Width:"width"},function(name,type){jQuery.each({padding:"inner"+name,content:type,"":"outer"+name},function(defaultExtra,funcName){jQuery.fn[funcName]=function(margin,value){var chainable=arguments.length&&(defaultExtra||typeof margin!=="boolean"),extra=defaultExtra||(margin===!0||value===!0?"margin":"border");return access(this,function(elem,type,value){var doc;if(isWindow(elem)){return funcName.indexOf("outer")===0?elem["inner"+name]:elem.document.documentElement["client"+name]}
if(elem.nodeType===9){doc=elem.documentElement;return Math.max(elem.body["scroll"+name],doc["scroll"+name],elem.body["offset"+name],doc["offset"+name],doc["client"+name])}
return value===undefined?jQuery.css(elem,type,extra):jQuery.style(elem,type,value,extra)},type,chainable?margin:undefined,chainable)}})});jQuery.each(["ajaxStart","ajaxStop","ajaxComplete","ajaxError","ajaxSuccess","ajaxSend"],function(_i,type){jQuery.fn[type]=function(fn){return this.on(type,fn)}});jQuery.fn.extend({bind:function(types,data,fn){return this.on(types,null,data,fn)},unbind:function(types,fn){return this.off(types,null,fn)},delegate:function(selector,types,data,fn){return this.on(types,selector,data,fn)},undelegate:function(selector,types,fn){return arguments.length===1?this.off(selector,"**"):this.off(types,selector||"**",fn)},hover:function(fnOver,fnOut){return this.on("mouseenter",fnOver).on("mouseleave",fnOut||fnOver)}});jQuery.each(("blur focus focusin focusout resize scroll click dblclick "+"mousedown mouseup mousemove mouseover mouseout mouseenter mouseleave "+"change select submit keydown keypress keyup contextmenu").split(" "),function(_i,name){jQuery.fn[name]=function(data,fn){return arguments.length>0?this.on(name,null,data,fn):this.trigger(name)}});var rtrim=/^[\s\uFEFF\xA0]+|([^\s\uFEFF\xA0])[\s\uFEFF\xA0]+$/g;jQuery.proxy=function(fn,context){var tmp,args,proxy;if(typeof context==="string"){tmp=fn[context];context=fn;fn=tmp}
if(!isFunction(fn)){return undefined}
args=slice.call(arguments,2);proxy=function(){return fn.apply(context||this,args.concat(slice.call(arguments)))};proxy.guid=fn.guid=fn.guid||jQuery.guid++;return proxy};jQuery.holdReady=function(hold){if(hold){jQuery.readyWait++}else{jQuery.ready(!0)}};jQuery.isArray=Array.isArray;jQuery.parseJSON=JSON.parse;jQuery.nodeName=nodeName;jQuery.isFunction=isFunction;jQuery.isWindow=isWindow;jQuery.camelCase=camelCase;jQuery.type=toType;jQuery.now=Date.now;jQuery.isNumeric=function(obj){var type=jQuery.type(obj);return(type==="number"||type==="string")&&!isNaN(obj-parseFloat(obj))};jQuery.trim=function(text){return text==null?"":(text+"").replace(rtrim,"$1")};if(typeof define==="function"&&define.amd){define("jquery",[],function(){return jQuery})}
var _jQuery=window.jQuery,_$=window.$;jQuery.noConflict=function(deep){if(window.$===jQuery){window.$=_$}
if(deep&&window.jQuery===jQuery){window.jQuery=_jQuery}
return jQuery};if(typeof noGlobal==="undefined"){window.jQuery=window.$=jQuery}
return jQuery});/*!
 * JavaScript Cookie v2.2.1
 * https://github.com/js-cookie/js-cookie
 *
 * Copyright 2006, 2015 Klaus Hartl & Fagner Brack
 * Released under the MIT license
 */
;(function(factory){var registeredInModuleLoader;if(typeof define==='function'&&define.amd){define(factory);registeredInModuleLoader=!0}
if(typeof exports==='object'){module.exports=factory();registeredInModuleLoader=!0}
if(!registeredInModuleLoader){var OldCookies=window.Cookies;var api=window.Cookies=factory();api.noConflict=function(){window.Cookies=OldCookies;return api}}}(function(){function extend(){var i=0;var result={};for(;i<arguments.length;i++){var attributes=arguments[i];for(var key in attributes){result[key]=attributes[key]}}
return result}
function decode(s){return s.replace(/(%[0-9A-Z]{2})+/g,decodeURIComponent)}
function init(converter){function api(){}
function set(key,value,attributes){if(typeof document==='undefined'){return}
attributes=extend({path:'/'},api.defaults,attributes);if(typeof attributes.expires==='number'){attributes.expires=new Date(new Date()*1+attributes.expires*864e+5)}
attributes.expires=attributes.expires?attributes.expires.toUTCString():'';try{var result=JSON.stringify(value);if(/^[\{\[]/.test(result)){value=result}}catch(e){}
value=converter.write?converter.write(value,key):encodeURIComponent(String(value)).replace(/%(23|24|26|2B|3A|3C|3E|3D|2F|3F|40|5B|5D|5E|60|7B|7D|7C)/g,decodeURIComponent);key=encodeURIComponent(String(key)).replace(/%(23|24|26|2B|5E|60|7C)/g,decodeURIComponent).replace(/[\(\)]/g,escape);var stringifiedAttributes='';for(var attributeName in attributes){if(!attributes[attributeName]){continue}
stringifiedAttributes+='; '+attributeName;if(attributes[attributeName]===!0){continue}
stringifiedAttributes+='='+attributes[attributeName].split(';')[0]}
return(document.cookie=key+'='+value+stringifiedAttributes)}
function get(key,json){if(typeof document==='undefined'){return}
var jar={};var cookies=document.cookie?document.cookie.split('; '):[];var i=0;for(;i<cookies.length;i++){var parts=cookies[i].split('=');var cookie=parts.slice(1).join('=');if(!json&&cookie.charAt(0)==='"'){cookie=cookie.slice(1,-1)}
try{var name=decode(parts[0]);cookie=(converter.read||converter)(cookie,name)||decode(cookie);if(json){try{cookie=JSON.parse(cookie)}catch(e){}}
jar[name]=cookie;if(key===name){break}}catch(e){}}
return key?jar[key]:jar}
api.set=set;api.get=function(key){return get(key,!1)};api.getJSON=function(key){return get(key,!0)};api.remove=function(key,attributes){set(key,'',extend(attributes,{expires:-1}))};api.defaults={};api.withConverter=init;return api}
return init(function(){})}));/*!
 * Bootstrap v3.4.1 (https://getbootstrap.com/)
 * Copyright 2011-2019 Twitter, Inc.
 * Licensed under the MIT license
 */
if(typeof jQuery==='undefined'){throw new Error('Bootstrap\'s JavaScript requires jQuery')}+function($){'use strict';var version=$.fn.jquery.split(' ')[0].split('.')
if((version[0]<2&&version[1]<9)||(version[0]==1&&version[1]==9&&version[2]<1)||(version[0]>3)){throw new Error('Bootstrap\'s JavaScript requires jQuery version 1.9.1 or higher, but lower than version 4')}}(jQuery);+function($){'use strict';function transitionEnd(){var el=document.createElement('bootstrap')
var transEndEventNames={WebkitTransition:'webkitTransitionEnd',MozTransition:'transitionend',OTransition:'oTransitionEnd otransitionend',transition:'transitionend'}
for(var name in transEndEventNames){if(el.style[name]!==undefined){return{end:transEndEventNames[name]}}}
return!1}
$.fn.emulateTransitionEnd=function(duration){var called=!1
var $el=this
$(this).one('bsTransitionEnd',function(){called=!0})
var callback=function(){if(!called)$($el).trigger($.support.transition.end)}
setTimeout(callback,duration)
return this}
$(function(){$.support.transition=transitionEnd()
if(!$.support.transition)return
$.event.special.bsTransitionEnd={bindType:$.support.transition.end,delegateType:$.support.transition.end,handle:function(e){if($(e.target).is(this))return e.handleObj.handler.apply(this,arguments)}}})}(jQuery);+function($){'use strict';var dismiss='[data-dismiss="alert"]'
var Alert=function(el){$(el).on('click',dismiss,this.close)}
Alert.VERSION='3.4.1'
Alert.TRANSITION_DURATION=150
Alert.prototype.close=function(e){var $this=$(this)
var selector=$this.attr('data-target')
if(!selector){selector=$this.attr('href')
selector=selector&&selector.replace(/.*(?=#[^\s]*$)/,'')}
selector=selector==='#'?[]:selector
var $parent=$(document).find(selector)
if(e)e.preventDefault()
if(!$parent.length){$parent=$this.closest('.alert')}
$parent.trigger(e=$.Event('close.bs.alert'))
if(e.isDefaultPrevented())return
$parent.removeClass('in')
function removeElement(){$parent.detach().trigger('closed.bs.alert').remove()}
$.support.transition&&$parent.hasClass('fade')?$parent.one('bsTransitionEnd',removeElement).emulateTransitionEnd(Alert.TRANSITION_DURATION):removeElement()}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.alert')
if(!data)$this.data('bs.alert',(data=new Alert(this)))
if(typeof option=='string')data[option].call($this)})}
var old=$.fn.alert
$.fn.alert=Plugin
$.fn.alert.Constructor=Alert
$.fn.alert.noConflict=function(){$.fn.alert=old
return this}
$(document).on('click.bs.alert.data-api',dismiss,Alert.prototype.close)}(jQuery);+function($){'use strict';var Button=function(element,options){this.$element=$(element)
this.options=$.extend({},Button.DEFAULTS,options)
this.isLoading=!1}
Button.VERSION='3.4.1'
Button.DEFAULTS={loadingText:'loading...'}
Button.prototype.setState=function(state){var d='disabled'
var $el=this.$element
var val=$el.is('input')?'val':'html'
var data=$el.data()
state+='Text'
if(data.resetText==null)$el.data('resetText',$el[val]())
setTimeout($.proxy(function(){$el[val](data[state]==null?this.options[state]:data[state])
if(state=='loadingText'){this.isLoading=!0
$el.addClass(d).attr(d,d).prop(d,!0)}else if(this.isLoading){this.isLoading=!1
$el.removeClass(d).removeAttr(d).prop(d,!1)}},this),0)}
Button.prototype.toggle=function(){var changed=!0
var $parent=this.$element.closest('[data-toggle="buttons"]')
if($parent.length){var $input=this.$element.find('input')
if($input.prop('type')=='radio'){if($input.prop('checked'))changed=!1
$parent.find('.active').removeClass('active')
this.$element.addClass('active')}else if($input.prop('type')=='checkbox'){if(($input.prop('checked'))!==this.$element.hasClass('active'))changed=!1
this.$element.toggleClass('active')}
$input.prop('checked',this.$element.hasClass('active'))
if(changed)$input.trigger('change')}else{this.$element.attr('aria-pressed',!this.$element.hasClass('active'))
this.$element.toggleClass('active')}}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.button')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.button',(data=new Button(this,options)))
if(option=='toggle')data.toggle()
else if(option)data.setState(option)})}
var old=$.fn.button
$.fn.button=Plugin
$.fn.button.Constructor=Button
$.fn.button.noConflict=function(){$.fn.button=old
return this}
$(document).on('click.bs.button.data-api','[data-toggle^="button"]',function(e){var $btn=$(e.target).closest('.btn')
Plugin.call($btn,'toggle')
if(!($(e.target).is('input[type="radio"], input[type="checkbox"]'))){e.preventDefault()
if($btn.is('input,button'))$btn.trigger('focus')
else $btn.find('input:visible,button:visible').first().trigger('focus')}}).on('focus.bs.button.data-api blur.bs.button.data-api','[data-toggle^="button"]',function(e){$(e.target).closest('.btn').toggleClass('focus',/^focus(in)?$/.test(e.type))})}(jQuery);+function($){'use strict';var Carousel=function(element,options){this.$element=$(element)
this.$indicators=this.$element.find('.carousel-indicators')
this.options=options
this.paused=null
this.sliding=null
this.interval=null
this.$active=null
this.$items=null
this.options.keyboard&&this.$element.on('keydown.bs.carousel',$.proxy(this.keydown,this))
this.options.pause=='hover'&&!('ontouchstart' in document.documentElement)&&this.$element.on('mouseenter.bs.carousel',$.proxy(this.pause,this)).on('mouseleave.bs.carousel',$.proxy(this.cycle,this))}
Carousel.VERSION='3.4.1'
Carousel.TRANSITION_DURATION=600
Carousel.DEFAULTS={interval:5000,pause:'hover',wrap:!0,keyboard:!0}
Carousel.prototype.keydown=function(e){if(/input|textarea/i.test(e.target.tagName))return
switch(e.which){case 37:this.prev();break
case 39:this.next();break
default:return}
e.preventDefault()}
Carousel.prototype.cycle=function(e){e||(this.paused=!1)
this.interval&&clearInterval(this.interval)
this.options.interval&&!this.paused&&(this.interval=setInterval($.proxy(this.next,this),this.options.interval))
return this}
Carousel.prototype.getItemIndex=function(item){this.$items=item.parent().children('.item')
return this.$items.index(item||this.$active)}
Carousel.prototype.getItemForDirection=function(direction,active){var activeIndex=this.getItemIndex(active)
var willWrap=(direction=='prev'&&activeIndex===0)||(direction=='next'&&activeIndex==(this.$items.length-1))
if(willWrap&&!this.options.wrap)return active
var delta=direction=='prev'?-1:1
var itemIndex=(activeIndex+delta)%this.$items.length
return this.$items.eq(itemIndex)}
Carousel.prototype.to=function(pos){var that=this
var activeIndex=this.getItemIndex(this.$active=this.$element.find('.item.active'))
if(pos>(this.$items.length-1)||pos<0)return
if(this.sliding)return this.$element.one('slid.bs.carousel',function(){that.to(pos)})
if(activeIndex==pos)return this.pause().cycle()
return this.slide(pos>activeIndex?'next':'prev',this.$items.eq(pos))}
Carousel.prototype.pause=function(e){e||(this.paused=!0)
if(this.$element.find('.next, .prev').length&&$.support.transition){this.$element.trigger($.support.transition.end)
this.cycle(!0)}
this.interval=clearInterval(this.interval)
return this}
Carousel.prototype.next=function(){if(this.sliding)return
return this.slide('next')}
Carousel.prototype.prev=function(){if(this.sliding)return
return this.slide('prev')}
Carousel.prototype.slide=function(type,next){var $active=this.$element.find('.item.active')
var $next=next||this.getItemForDirection(type,$active)
var isCycling=this.interval
var direction=type=='next'?'left':'right'
var that=this
if($next.hasClass('active'))return(this.sliding=!1)
var relatedTarget=$next[0]
var slideEvent=$.Event('slide.bs.carousel',{relatedTarget:relatedTarget,direction:direction})
this.$element.trigger(slideEvent)
if(slideEvent.isDefaultPrevented())return
this.sliding=!0
isCycling&&this.pause()
if(this.$indicators.length){this.$indicators.find('.active').removeClass('active')
var $nextIndicator=$(this.$indicators.children()[this.getItemIndex($next)])
$nextIndicator&&$nextIndicator.addClass('active')}
var slidEvent=$.Event('slid.bs.carousel',{relatedTarget:relatedTarget,direction:direction})
if($.support.transition&&this.$element.hasClass('slide')){$next.addClass(type)
if(typeof $next==='object'&&$next.length){$next[0].offsetWidth}
$active.addClass(direction)
$next.addClass(direction)
$active.one('bsTransitionEnd',function(){$next.removeClass([type,direction].join(' ')).addClass('active')
$active.removeClass(['active',direction].join(' '))
that.sliding=!1
setTimeout(function(){that.$element.trigger(slidEvent)},0)}).emulateTransitionEnd(Carousel.TRANSITION_DURATION)}else{$active.removeClass('active')
$next.addClass('active')
this.sliding=!1
this.$element.trigger(slidEvent)}
isCycling&&this.cycle()
return this}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.carousel')
var options=$.extend({},Carousel.DEFAULTS,$this.data(),typeof option=='object'&&option)
var action=typeof option=='string'?option:options.slide
if(!data)$this.data('bs.carousel',(data=new Carousel(this,options)))
if(typeof option=='number')data.to(option)
else if(action)data[action]()
else if(options.interval)data.pause().cycle()})}
var old=$.fn.carousel
$.fn.carousel=Plugin
$.fn.carousel.Constructor=Carousel
$.fn.carousel.noConflict=function(){$.fn.carousel=old
return this}
var clickHandler=function(e){var $this=$(this)
var href=$this.attr('href')
if(href){href=href.replace(/.*(?=#[^\s]+$)/,'')}
var target=$this.attr('data-target')||href
var $target=$(document).find(target)
if(!$target.hasClass('carousel'))return
var options=$.extend({},$target.data(),$this.data())
var slideIndex=$this.attr('data-slide-to')
if(slideIndex)options.interval=!1
Plugin.call($target,options)
if(slideIndex){$target.data('bs.carousel').to(slideIndex)}
e.preventDefault()}
$(document).on('click.bs.carousel.data-api','[data-slide]',clickHandler).on('click.bs.carousel.data-api','[data-slide-to]',clickHandler)
$(window).on('load',function(){$('[data-ride="carousel"]').each(function(){var $carousel=$(this)
Plugin.call($carousel,$carousel.data())})})}(jQuery);+function($){'use strict';var Collapse=function(element,options){this.$element=$(element)
this.options=$.extend({},Collapse.DEFAULTS,options)
this.$trigger=$('[data-toggle="collapse"][href="#'+element.id+'"],'+'[data-toggle="collapse"][data-target="#'+element.id+'"]')
this.transitioning=null
if(this.options.parent){this.$parent=this.getParent()}else{this.addAriaAndCollapsedClass(this.$element,this.$trigger)}
if(this.options.toggle)this.toggle()}
Collapse.VERSION='3.4.1'
Collapse.TRANSITION_DURATION=350
Collapse.DEFAULTS={toggle:!0}
Collapse.prototype.dimension=function(){var hasWidth=this.$element.hasClass('width')
return hasWidth?'width':'height'}
Collapse.prototype.show=function(){if(this.transitioning||this.$element.hasClass('in'))return
var activesData
var actives=this.$parent&&this.$parent.children('.panel').children('.in, .collapsing')
if(actives&&actives.length){activesData=actives.data('bs.collapse')
if(activesData&&activesData.transitioning)return}
var startEvent=$.Event('show.bs.collapse')
this.$element.trigger(startEvent)
if(startEvent.isDefaultPrevented())return
if(actives&&actives.length){Plugin.call(actives,'hide')
activesData||actives.data('bs.collapse',null)}
var dimension=this.dimension()
this.$element.removeClass('collapse').addClass('collapsing')[dimension](0).attr('aria-expanded',!0)
this.$trigger.removeClass('collapsed').attr('aria-expanded',!0)
this.transitioning=1
var complete=function(){this.$element.removeClass('collapsing').addClass('collapse in')[dimension]('')
this.transitioning=0
this.$element.trigger('shown.bs.collapse')}
if(!$.support.transition)return complete.call(this)
var scrollSize=$.camelCase(['scroll',dimension].join('-'))
this.$element.one('bsTransitionEnd',$.proxy(complete,this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION)[dimension](this.$element[0][scrollSize])}
Collapse.prototype.hide=function(){if(this.transitioning||!this.$element.hasClass('in'))return
var startEvent=$.Event('hide.bs.collapse')
this.$element.trigger(startEvent)
if(startEvent.isDefaultPrevented())return
var dimension=this.dimension()
this.$element[dimension](this.$element[dimension]())[0].offsetHeight
this.$element.addClass('collapsing').removeClass('collapse in').attr('aria-expanded',!1)
this.$trigger.addClass('collapsed').attr('aria-expanded',!1)
this.transitioning=1
var complete=function(){this.transitioning=0
this.$element.removeClass('collapsing').addClass('collapse').trigger('hidden.bs.collapse')}
if(!$.support.transition)return complete.call(this)
this.$element[dimension](0).one('bsTransitionEnd',$.proxy(complete,this)).emulateTransitionEnd(Collapse.TRANSITION_DURATION)}
Collapse.prototype.toggle=function(){this[this.$element.hasClass('in')?'hide':'show']()}
Collapse.prototype.getParent=function(){return $(document).find(this.options.parent).find('[data-toggle="collapse"][data-parent="'+this.options.parent+'"]').each($.proxy(function(i,element){var $element=$(element)
this.addAriaAndCollapsedClass(getTargetFromTrigger($element),$element)},this)).end()}
Collapse.prototype.addAriaAndCollapsedClass=function($element,$trigger){var isOpen=$element.hasClass('in')
$element.attr('aria-expanded',isOpen)
$trigger.toggleClass('collapsed',!isOpen).attr('aria-expanded',isOpen)}
function getTargetFromTrigger($trigger){var href
var target=$trigger.attr('data-target')||(href=$trigger.attr('href'))&&href.replace(/.*(?=#[^\s]+$)/,'')
return $(document).find(target)}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.collapse')
var options=$.extend({},Collapse.DEFAULTS,$this.data(),typeof option=='object'&&option)
if(!data&&options.toggle&&/show|hide/.test(option))options.toggle=!1
if(!data)$this.data('bs.collapse',(data=new Collapse(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.collapse
$.fn.collapse=Plugin
$.fn.collapse.Constructor=Collapse
$.fn.collapse.noConflict=function(){$.fn.collapse=old
return this}
$(document).on('click.bs.collapse.data-api','[data-toggle="collapse"]',function(e){var $this=$(this)
if(!$this.attr('data-target'))e.preventDefault()
var $target=getTargetFromTrigger($this)
var data=$target.data('bs.collapse')
var option=data?'toggle':$this.data()
Plugin.call($target,option)})}(jQuery);+function($){'use strict';var backdrop='.dropdown-backdrop'
var toggle='[data-toggle="dropdown"]'
var Dropdown=function(element){$(element).on('click.bs.dropdown',this.toggle)}
Dropdown.VERSION='3.4.1'
function getParent($this){var selector=$this.attr('data-target')
if(!selector){selector=$this.attr('href')
selector=selector&&/#[A-Za-z]/.test(selector)&&selector.replace(/.*(?=#[^\s]*$)/,'')}
var $parent=selector!=='#'?$(document).find(selector):null
return $parent&&$parent.length?$parent:$this.parent()}
function clearMenus(e){if(e&&e.which===3)return
$(backdrop).remove()
$(toggle).each(function(){var $this=$(this)
var $parent=getParent($this)
var relatedTarget={relatedTarget:this}
if(!$parent.hasClass('open'))return
if(e&&e.type=='click'&&/input|textarea/i.test(e.target.tagName)&&$.contains($parent[0],e.target))return
$parent.trigger(e=$.Event('hide.bs.dropdown',relatedTarget))
if(e.isDefaultPrevented())return
$this.attr('aria-expanded','false')
$parent.removeClass('open').trigger($.Event('hidden.bs.dropdown',relatedTarget))})}
Dropdown.prototype.toggle=function(e){var $this=$(this)
if($this.is('.disabled, :disabled'))return
var $parent=getParent($this)
var isActive=$parent.hasClass('open')
clearMenus()
if(!isActive){if('ontouchstart' in document.documentElement&&!$parent.closest('.navbar-nav').length){$(document.createElement('div')).addClass('dropdown-backdrop').insertAfter($(this)).on('click',clearMenus)}
var relatedTarget={relatedTarget:this}
$parent.trigger(e=$.Event('show.bs.dropdown',relatedTarget))
if(e.isDefaultPrevented())return
$this.trigger('focus').attr('aria-expanded','true')
$parent.toggleClass('open').trigger($.Event('shown.bs.dropdown',relatedTarget))}
return!1}
Dropdown.prototype.keydown=function(e){if(!/(38|40|27|32)/.test(e.which)||/input|textarea/i.test(e.target.tagName))return
var $this=$(this)
e.preventDefault()
e.stopPropagation()
if($this.is('.disabled, :disabled'))return
var $parent=getParent($this)
var isActive=$parent.hasClass('open')
if(!isActive&&e.which!=27||isActive&&e.which==27){if(e.which==27)$parent.find(toggle).trigger('focus')
return $this.trigger('click')}
var desc=' li:not(.disabled):visible a'
var $items=$parent.find('.dropdown-menu'+desc)
if(!$items.length)return
var index=$items.index(e.target)
if(e.which==38&&index>0)index--
if(e.which==40&&index<$items.length-1)index++
if(!~index)index=0
$items.eq(index).trigger('focus')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.dropdown')
if(!data)$this.data('bs.dropdown',(data=new Dropdown(this)))
if(typeof option=='string')data[option].call($this)})}
var old=$.fn.dropdown
$.fn.dropdown=Plugin
$.fn.dropdown.Constructor=Dropdown
$.fn.dropdown.noConflict=function(){$.fn.dropdown=old
return this}
$(document).on('click.bs.dropdown.data-api',clearMenus).on('click.bs.dropdown.data-api','.dropdown form',function(e){e.stopPropagation()}).on('click.bs.dropdown.data-api',toggle,Dropdown.prototype.toggle).on('keydown.bs.dropdown.data-api',toggle,Dropdown.prototype.keydown).on('keydown.bs.dropdown.data-api','.dropdown-menu',Dropdown.prototype.keydown)}(jQuery);+function($){'use strict';var Modal=function(element,options){this.options=options
this.$body=$(document.body)
this.$element=$(element)
this.$dialog=this.$element.find('.modal-dialog')
this.$backdrop=null
this.isShown=null
this.originalBodyPad=null
this.scrollbarWidth=0
this.ignoreBackdropClick=!1
this.fixedContent='.navbar-fixed-top, .navbar-fixed-bottom'
if(this.options.remote){this.$element.find('.modal-content').load(this.options.remote,$.proxy(function(){this.$element.trigger('loaded.bs.modal')},this))}}
Modal.VERSION='3.4.1'
Modal.TRANSITION_DURATION=300
Modal.BACKDROP_TRANSITION_DURATION=150
Modal.DEFAULTS={backdrop:!0,keyboard:!0,show:!0}
Modal.prototype.toggle=function(_relatedTarget){return this.isShown?this.hide():this.show(_relatedTarget)}
Modal.prototype.show=function(_relatedTarget){var that=this
var e=$.Event('show.bs.modal',{relatedTarget:_relatedTarget})
this.$element.trigger(e)
if(this.isShown||e.isDefaultPrevented())return
this.isShown=!0
this.checkScrollbar()
this.setScrollbar()
this.$body.addClass('modal-open')
this.escape()
this.resize()
this.$element.on('click.dismiss.bs.modal','[data-dismiss="modal"]',$.proxy(this.hide,this))
this.$dialog.on('mousedown.dismiss.bs.modal',function(){that.$element.one('mouseup.dismiss.bs.modal',function(e){if($(e.target).is(that.$element))that.ignoreBackdropClick=!0})})
this.backdrop(function(){var transition=$.support.transition&&that.$element.hasClass('fade')
if(!that.$element.parent().length){that.$element.appendTo(that.$body)}
that.$element.show().scrollTop(0)
that.adjustDialog()
if(transition){that.$element[0].offsetWidth}
that.$element.addClass('in')
that.enforceFocus()
var e=$.Event('shown.bs.modal',{relatedTarget:_relatedTarget})
transition?that.$dialog.one('bsTransitionEnd',function(){that.$element.trigger('focus').trigger(e)}).emulateTransitionEnd(Modal.TRANSITION_DURATION):that.$element.trigger('focus').trigger(e)})}
Modal.prototype.hide=function(e){if(e)e.preventDefault()
e=$.Event('hide.bs.modal')
this.$element.trigger(e)
if(!this.isShown||e.isDefaultPrevented())return
this.isShown=!1
this.escape()
this.resize()
$(document).off('focusin.bs.modal')
this.$element.removeClass('in').off('click.dismiss.bs.modal').off('mouseup.dismiss.bs.modal')
this.$dialog.off('mousedown.dismiss.bs.modal')
$.support.transition&&this.$element.hasClass('fade')?this.$element.one('bsTransitionEnd',$.proxy(this.hideModal,this)).emulateTransitionEnd(Modal.TRANSITION_DURATION):this.hideModal()}
Modal.prototype.enforceFocus=function(){$(document).off('focusin.bs.modal').on('focusin.bs.modal',$.proxy(function(e){if(document!==e.target&&this.$element[0]!==e.target&&!this.$element.has(e.target).length){this.$element.trigger('focus')}},this))}
Modal.prototype.escape=function(){if(this.isShown&&this.options.keyboard){this.$element.on('keydown.dismiss.bs.modal',$.proxy(function(e){e.which==27&&this.hide()},this))}else if(!this.isShown){this.$element.off('keydown.dismiss.bs.modal')}}
Modal.prototype.resize=function(){if(this.isShown){$(window).on('resize.bs.modal',$.proxy(this.handleUpdate,this))}else{$(window).off('resize.bs.modal')}}
Modal.prototype.hideModal=function(){var that=this
this.$element.hide()
this.backdrop(function(){that.$body.removeClass('modal-open')
that.resetAdjustments()
that.resetScrollbar()
that.$element.trigger('hidden.bs.modal')})}
Modal.prototype.removeBackdrop=function(){this.$backdrop&&this.$backdrop.remove()
this.$backdrop=null}
Modal.prototype.backdrop=function(callback){var that=this
var animate=this.$element.hasClass('fade')?'fade':''
if(this.isShown&&this.options.backdrop){var doAnimate=$.support.transition&&animate
this.$backdrop=$(document.createElement('div')).addClass('modal-backdrop '+animate).appendTo(this.$body)
this.$element.on('click.dismiss.bs.modal',$.proxy(function(e){if(this.ignoreBackdropClick){this.ignoreBackdropClick=!1
return}
if(e.target!==e.currentTarget)return
this.options.backdrop=='static'?this.$element[0].focus():this.hide()},this))
if(doAnimate)this.$backdrop[0].offsetWidth
this.$backdrop.addClass('in')
if(!callback)return
doAnimate?this.$backdrop.one('bsTransitionEnd',callback).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION):callback()}else if(!this.isShown&&this.$backdrop){this.$backdrop.removeClass('in')
var callbackRemove=function(){that.removeBackdrop()
callback&&callback()}
$.support.transition&&this.$element.hasClass('fade')?this.$backdrop.one('bsTransitionEnd',callbackRemove).emulateTransitionEnd(Modal.BACKDROP_TRANSITION_DURATION):callbackRemove()}else if(callback){callback()}}
Modal.prototype.handleUpdate=function(){this.adjustDialog()}
Modal.prototype.adjustDialog=function(){var modalIsOverflowing=this.$element[0].scrollHeight>document.documentElement.clientHeight
this.$element.css({paddingLeft:!this.bodyIsOverflowing&&modalIsOverflowing?this.scrollbarWidth:'',paddingRight:this.bodyIsOverflowing&&!modalIsOverflowing?this.scrollbarWidth:''})}
Modal.prototype.resetAdjustments=function(){this.$element.css({paddingLeft:'',paddingRight:''})}
Modal.prototype.checkScrollbar=function(){var fullWindowWidth=window.innerWidth
if(!fullWindowWidth){var documentElementRect=document.documentElement.getBoundingClientRect()
fullWindowWidth=documentElementRect.right-Math.abs(documentElementRect.left)}
this.bodyIsOverflowing=document.body.clientWidth<fullWindowWidth
this.scrollbarWidth=this.measureScrollbar()}
Modal.prototype.setScrollbar=function(){var bodyPad=parseInt((this.$body.css('padding-right')||0),10)
this.originalBodyPad=document.body.style.paddingRight||''
var scrollbarWidth=this.scrollbarWidth
if(this.bodyIsOverflowing){this.$body.css('padding-right',bodyPad+scrollbarWidth)
$(this.fixedContent).each(function(index,element){var actualPadding=element.style.paddingRight
var calculatedPadding=$(element).css('padding-right')
$(element).data('padding-right',actualPadding).css('padding-right',parseFloat(calculatedPadding)+scrollbarWidth+'px')})}}
Modal.prototype.resetScrollbar=function(){this.$body.css('padding-right',this.originalBodyPad)
$(this.fixedContent).each(function(index,element){var padding=$(element).data('padding-right')
$(element).removeData('padding-right')
element.style.paddingRight=padding?padding:''})}
Modal.prototype.measureScrollbar=function(){var scrollDiv=document.createElement('div')
scrollDiv.className='modal-scrollbar-measure'
this.$body.append(scrollDiv)
var scrollbarWidth=scrollDiv.offsetWidth-scrollDiv.clientWidth
this.$body[0].removeChild(scrollDiv)
return scrollbarWidth}
function Plugin(option,_relatedTarget){return this.each(function(){var $this=$(this)
var data=$this.data('bs.modal')
var options=$.extend({},Modal.DEFAULTS,$this.data(),typeof option=='object'&&option)
if(!data)$this.data('bs.modal',(data=new Modal(this,options)))
if(typeof option=='string')data[option](_relatedTarget)
else if(options.show)data.show(_relatedTarget)})}
var old=$.fn.modal
$.fn.modal=Plugin
$.fn.modal.Constructor=Modal
$.fn.modal.noConflict=function(){$.fn.modal=old
return this}
$(document).on('click.bs.modal.data-api','[data-toggle="modal"]',function(e){var $this=$(this)
var href=$this.attr('href')
var target=$this.attr('data-target')||(href&&href.replace(/.*(?=#[^\s]+$)/,''))
var $target=$(document).find(target)
var option=$target.data('bs.modal')?'toggle':$.extend({remote:!/#/.test(href)&&href},$target.data(),$this.data())
if($this.is('a'))e.preventDefault()
$target.one('show.bs.modal',function(showEvent){if(showEvent.isDefaultPrevented())return
$target.one('hidden.bs.modal',function(){$this.is(':visible')&&$this.trigger('focus')})})
Plugin.call($target,option,this)})}(jQuery);+function($){'use strict';var DISALLOWED_ATTRIBUTES=['sanitize','whiteList','sanitizeFn']
var uriAttrs=['background','cite','href','itemtype','longdesc','poster','src','xlink:href']
var ARIA_ATTRIBUTE_PATTERN=/^aria-[\w-]*$/i
var DefaultWhitelist={'*':['class','dir','id','lang','role',ARIA_ATTRIBUTE_PATTERN],a:['target','href','title','rel'],area:[],b:[],br:[],col:[],code:[],div:[],em:[],hr:[],h1:[],h2:[],h3:[],h4:[],h5:[],h6:[],i:[],img:['src','alt','title','width','height'],li:[],ol:[],p:[],pre:[],s:[],small:[],span:[],sub:[],sup:[],strong:[],u:[],ul:[]}
var SAFE_URL_PATTERN=/^(?:(?:https?|mailto|ftp|tel|file):|[^&:/?#]*(?:[/?#]|$))/gi
var DATA_URL_PATTERN=/^data:(?:image\/(?:bmp|gif|jpeg|jpg|png|tiff|webp)|video\/(?:mpeg|mp4|ogg|webm)|audio\/(?:mp3|oga|ogg|opus));base64,[a-z0-9+/]+=*$/i
function allowedAttribute(attr,allowedAttributeList){var attrName=attr.nodeName.toLowerCase()
if($.inArray(attrName,allowedAttributeList)!==-1){if($.inArray(attrName,uriAttrs)!==-1){return Boolean(attr.nodeValue.match(SAFE_URL_PATTERN)||attr.nodeValue.match(DATA_URL_PATTERN))}
return!0}
var regExp=$(allowedAttributeList).filter(function(index,value){return value instanceof RegExp})
for(var i=0,l=regExp.length;i<l;i++){if(attrName.match(regExp[i])){return!0}}
return!1}
function sanitizeHtml(unsafeHtml,whiteList,sanitizeFn){if(unsafeHtml.length===0){return unsafeHtml}
if(sanitizeFn&&typeof sanitizeFn==='function'){return sanitizeFn(unsafeHtml)}
if(!document.implementation||!document.implementation.createHTMLDocument){return unsafeHtml}
var createdDocument=document.implementation.createHTMLDocument('sanitization')
createdDocument.body.innerHTML=unsafeHtml
var whitelistKeys=$.map(whiteList,function(el,i){return i})
var elements=$(createdDocument.body).find('*')
for(var i=0,len=elements.length;i<len;i++){var el=elements[i]
var elName=el.nodeName.toLowerCase()
if($.inArray(elName,whitelistKeys)===-1){el.parentNode.removeChild(el)
continue}
var attributeList=$.map(el.attributes,function(el){return el})
var whitelistedAttributes=[].concat(whiteList['*']||[],whiteList[elName]||[])
for(var j=0,len2=attributeList.length;j<len2;j++){if(!allowedAttribute(attributeList[j],whitelistedAttributes)){el.removeAttribute(attributeList[j].nodeName)}}}
return createdDocument.body.innerHTML}
var Tooltip=function(element,options){this.type=null
this.options=null
this.enabled=null
this.timeout=null
this.hoverState=null
this.$element=null
this.inState=null
this.init('tooltip',element,options)}
Tooltip.VERSION='3.4.1'
Tooltip.TRANSITION_DURATION=150
Tooltip.DEFAULTS={animation:!0,placement:'top',selector:!1,template:'<div class="tooltip" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div></div>',trigger:'hover focus',title:'',delay:0,html:!1,container:!1,viewport:{selector:'body',padding:0},sanitize:!0,sanitizeFn:null,whiteList:DefaultWhitelist}
Tooltip.prototype.init=function(type,element,options){this.enabled=!0
this.type=type
this.$element=$(element)
this.options=this.getOptions(options)
this.$viewport=this.options.viewport&&$(document).find($.isFunction(this.options.viewport)?this.options.viewport.call(this,this.$element):(this.options.viewport.selector||this.options.viewport))
this.inState={click:!1,hover:!1,focus:!1}
if(this.$element[0]instanceof document.constructor&&!this.options.selector){throw new Error('`selector` option must be specified when initializing '+this.type+' on the window.document object!')}
var triggers=this.options.trigger.split(' ')
for(var i=triggers.length;i--;){var trigger=triggers[i]
if(trigger=='click'){this.$element.on('click.'+this.type,this.options.selector,$.proxy(this.toggle,this))}else if(trigger!='manual'){var eventIn=trigger=='hover'?'mouseenter':'focusin'
var eventOut=trigger=='hover'?'mouseleave':'focusout'
this.$element.on(eventIn+'.'+this.type,this.options.selector,$.proxy(this.enter,this))
this.$element.on(eventOut+'.'+this.type,this.options.selector,$.proxy(this.leave,this))}}
this.options.selector?(this._options=$.extend({},this.options,{trigger:'manual',selector:''})):this.fixTitle()}
Tooltip.prototype.getDefaults=function(){return Tooltip.DEFAULTS}
Tooltip.prototype.getOptions=function(options){var dataAttributes=this.$element.data()
for(var dataAttr in dataAttributes){if(dataAttributes.hasOwnProperty(dataAttr)&&$.inArray(dataAttr,DISALLOWED_ATTRIBUTES)!==-1){delete dataAttributes[dataAttr]}}
options=$.extend({},this.getDefaults(),dataAttributes,options)
if(options.delay&&typeof options.delay=='number'){options.delay={show:options.delay,hide:options.delay}}
if(options.sanitize){options.template=sanitizeHtml(options.template,options.whiteList,options.sanitizeFn)}
return options}
Tooltip.prototype.getDelegateOptions=function(){var options={}
var defaults=this.getDefaults()
this._options&&$.each(this._options,function(key,value){if(defaults[key]!=value)options[key]=value})
return options}
Tooltip.prototype.enter=function(obj){var self=obj instanceof this.constructor?obj:$(obj.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(obj.currentTarget,this.getDelegateOptions())
$(obj.currentTarget).data('bs.'+this.type,self)}
if(obj instanceof $.Event){self.inState[obj.type=='focusin'?'focus':'hover']=!0}
if(self.tip().hasClass('in')||self.hoverState=='in'){self.hoverState='in'
return}
clearTimeout(self.timeout)
self.hoverState='in'
if(!self.options.delay||!self.options.delay.show)return self.show()
self.timeout=setTimeout(function(){if(self.hoverState=='in')self.show()},self.options.delay.show)}
Tooltip.prototype.isInStateTrue=function(){for(var key in this.inState){if(this.inState[key])return!0}
return!1}
Tooltip.prototype.leave=function(obj){var self=obj instanceof this.constructor?obj:$(obj.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(obj.currentTarget,this.getDelegateOptions())
$(obj.currentTarget).data('bs.'+this.type,self)}
if(obj instanceof $.Event){self.inState[obj.type=='focusout'?'focus':'hover']=!1}
if(self.isInStateTrue())return
clearTimeout(self.timeout)
self.hoverState='out'
if(!self.options.delay||!self.options.delay.hide)return self.hide()
self.timeout=setTimeout(function(){if(self.hoverState=='out')self.hide()},self.options.delay.hide)}
Tooltip.prototype.show=function(){var e=$.Event('show.bs.'+this.type)
if(this.hasContent()&&this.enabled){this.$element.trigger(e)
var inDom=$.contains(this.$element[0].ownerDocument.documentElement,this.$element[0])
if(e.isDefaultPrevented()||!inDom)return
var that=this
var $tip=this.tip()
var tipId=this.getUID(this.type)
this.setContent()
$tip.attr('id',tipId)
this.$element.attr('aria-describedby',tipId)
if(this.options.animation)$tip.addClass('fade')
var placement=typeof this.options.placement=='function'?this.options.placement.call(this,$tip[0],this.$element[0]):this.options.placement
var autoToken=/\s?auto?\s?/i
var autoPlace=autoToken.test(placement)
if(autoPlace)placement=placement.replace(autoToken,'')||'top'
$tip.detach().css({top:0,left:0,display:'block'}).addClass(placement).data('bs.'+this.type,this)
this.options.container?$tip.appendTo($(document).find(this.options.container)):$tip.insertAfter(this.$element)
this.$element.trigger('inserted.bs.'+this.type)
var pos=this.getPosition()
var actualWidth=$tip[0].offsetWidth
var actualHeight=$tip[0].offsetHeight
if(autoPlace){var orgPlacement=placement
var viewportDim=this.getPosition(this.$viewport)
placement=placement=='bottom'&&pos.bottom+actualHeight>viewportDim.bottom?'top':placement=='top'&&pos.top-actualHeight<viewportDim.top?'bottom':placement=='right'&&pos.right+actualWidth>viewportDim.width?'left':placement=='left'&&pos.left-actualWidth<viewportDim.left?'right':placement
$tip.removeClass(orgPlacement).addClass(placement)}
var calculatedOffset=this.getCalculatedOffset(placement,pos,actualWidth,actualHeight)
this.applyPlacement(calculatedOffset,placement)
var complete=function(){var prevHoverState=that.hoverState
that.$element.trigger('shown.bs.'+that.type)
that.hoverState=null
if(prevHoverState=='out')that.leave(that)}
$.support.transition&&this.$tip.hasClass('fade')?$tip.one('bsTransitionEnd',complete).emulateTransitionEnd(Tooltip.TRANSITION_DURATION):complete()}}
Tooltip.prototype.applyPlacement=function(offset,placement){var $tip=this.tip()
var width=$tip[0].offsetWidth
var height=$tip[0].offsetHeight
var marginTop=parseInt($tip.css('margin-top'),10)
var marginLeft=parseInt($tip.css('margin-left'),10)
if(isNaN(marginTop))marginTop=0
if(isNaN(marginLeft))marginLeft=0
offset.top+=marginTop
offset.left+=marginLeft
$.offset.setOffset($tip[0],$.extend({using:function(props){$tip.css({top:Math.round(props.top),left:Math.round(props.left)})}},offset),0)
$tip.addClass('in')
var actualWidth=$tip[0].offsetWidth
var actualHeight=$tip[0].offsetHeight
if(placement=='top'&&actualHeight!=height){offset.top=offset.top+height-actualHeight}
var delta=this.getViewportAdjustedDelta(placement,offset,actualWidth,actualHeight)
if(delta.left)offset.left+=delta.left
else offset.top+=delta.top
var isVertical=/top|bottom/.test(placement)
var arrowDelta=isVertical?delta.left*2-width+actualWidth:delta.top*2-height+actualHeight
var arrowOffsetPosition=isVertical?'offsetWidth':'offsetHeight'
$tip.offset(offset)
this.replaceArrow(arrowDelta,$tip[0][arrowOffsetPosition],isVertical)}
Tooltip.prototype.replaceArrow=function(delta,dimension,isVertical){this.arrow().css(isVertical?'left':'top',50*(1-delta/dimension)+'%').css(isVertical?'top':'left','')}
Tooltip.prototype.setContent=function(){var $tip=this.tip()
var title=this.getTitle()
if(this.options.html){if(this.options.sanitize){title=sanitizeHtml(title,this.options.whiteList,this.options.sanitizeFn)}
$tip.find('.tooltip-inner').html(title)}else{$tip.find('.tooltip-inner').text(title)}
$tip.removeClass('fade in top bottom left right')}
Tooltip.prototype.hide=function(callback){var that=this
var $tip=$(this.$tip)
var e=$.Event('hide.bs.'+this.type)
function complete(){if(that.hoverState!='in')$tip.detach()
if(that.$element){that.$element.removeAttr('aria-describedby').trigger('hidden.bs.'+that.type)}
callback&&callback()}
this.$element.trigger(e)
if(e.isDefaultPrevented())return
$tip.removeClass('in')
$.support.transition&&$tip.hasClass('fade')?$tip.one('bsTransitionEnd',complete).emulateTransitionEnd(Tooltip.TRANSITION_DURATION):complete()
this.hoverState=null
return this}
Tooltip.prototype.fixTitle=function(){var $e=this.$element
if($e.attr('title')||typeof $e.attr('data-original-title')!='string'){$e.attr('data-original-title',$e.attr('title')||'').attr('title','')}}
Tooltip.prototype.hasContent=function(){return this.getTitle()}
Tooltip.prototype.getPosition=function($element){$element=$element||this.$element
var el=$element[0]
var isBody=el.tagName=='BODY'
var elRect=el.getBoundingClientRect()
if(elRect.width==null){elRect=$.extend({},elRect,{width:elRect.right-elRect.left,height:elRect.bottom-elRect.top})}
var isSvg=window.SVGElement&&el instanceof window.SVGElement
var elOffset=isBody?{top:0,left:0}:(isSvg?null:$element.offset())
var scroll={scroll:isBody?document.documentElement.scrollTop||document.body.scrollTop:$element.scrollTop()}
var outerDims=isBody?{width:$(window).width(),height:$(window).height()}:null
return $.extend({},elRect,scroll,outerDims,elOffset)}
Tooltip.prototype.getCalculatedOffset=function(placement,pos,actualWidth,actualHeight){return placement=='bottom'?{top:pos.top+pos.height,left:pos.left+pos.width/2-actualWidth/2}:placement=='top'?{top:pos.top-actualHeight,left:pos.left+pos.width/2-actualWidth/2}:placement=='left'?{top:pos.top+pos.height/2-actualHeight/2,left:pos.left-actualWidth}:{top:pos.top+pos.height/2-actualHeight/2,left:pos.left+pos.width}}
Tooltip.prototype.getViewportAdjustedDelta=function(placement,pos,actualWidth,actualHeight){var delta={top:0,left:0}
if(!this.$viewport)return delta
var viewportPadding=this.options.viewport&&this.options.viewport.padding||0
var viewportDimensions=this.getPosition(this.$viewport)
if(/right|left/.test(placement)){var topEdgeOffset=pos.top-viewportPadding-viewportDimensions.scroll
var bottomEdgeOffset=pos.top+viewportPadding-viewportDimensions.scroll+actualHeight
if(topEdgeOffset<viewportDimensions.top){delta.top=viewportDimensions.top-topEdgeOffset}else if(bottomEdgeOffset>viewportDimensions.top+viewportDimensions.height){delta.top=viewportDimensions.top+viewportDimensions.height-bottomEdgeOffset}}else{var leftEdgeOffset=pos.left-viewportPadding
var rightEdgeOffset=pos.left+viewportPadding+actualWidth
if(leftEdgeOffset<viewportDimensions.left){delta.left=viewportDimensions.left-leftEdgeOffset}else if(rightEdgeOffset>viewportDimensions.right){delta.left=viewportDimensions.left+viewportDimensions.width-rightEdgeOffset}}
return delta}
Tooltip.prototype.getTitle=function(){var title
var $e=this.$element
var o=this.options
title=$e.attr('data-original-title')||(typeof o.title=='function'?o.title.call($e[0]):o.title)
return title}
Tooltip.prototype.getUID=function(prefix){do prefix+=~~(Math.random()*1000000)
while(document.getElementById(prefix))
return prefix}
Tooltip.prototype.tip=function(){if(!this.$tip){this.$tip=$(this.options.template)
if(this.$tip.length!=1){throw new Error(this.type+' `template` option must consist of exactly 1 top-level element!')}}
return this.$tip}
Tooltip.prototype.arrow=function(){return(this.$arrow=this.$arrow||this.tip().find('.tooltip-arrow'))}
Tooltip.prototype.enable=function(){this.enabled=!0}
Tooltip.prototype.disable=function(){this.enabled=!1}
Tooltip.prototype.toggleEnabled=function(){this.enabled=!this.enabled}
Tooltip.prototype.toggle=function(e){var self=this
if(e){self=$(e.currentTarget).data('bs.'+this.type)
if(!self){self=new this.constructor(e.currentTarget,this.getDelegateOptions())
$(e.currentTarget).data('bs.'+this.type,self)}}
if(e){self.inState.click=!self.inState.click
if(self.isInStateTrue())self.enter(self)
else self.leave(self)}else{self.tip().hasClass('in')?self.leave(self):self.enter(self)}}
Tooltip.prototype.destroy=function(){var that=this
clearTimeout(this.timeout)
this.hide(function(){that.$element.off('.'+that.type).removeData('bs.'+that.type)
if(that.$tip){that.$tip.detach()}
that.$tip=null
that.$arrow=null
that.$viewport=null
that.$element=null})}
Tooltip.prototype.sanitizeHtml=function(unsafeHtml){return sanitizeHtml(unsafeHtml,this.options.whiteList,this.options.sanitizeFn)}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.tooltip')
var options=typeof option=='object'&&option
if(!data&&/destroy|hide/.test(option))return
if(!data)$this.data('bs.tooltip',(data=new Tooltip(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.tooltip
$.fn.tooltip=Plugin
$.fn.tooltip.Constructor=Tooltip
$.fn.tooltip.noConflict=function(){$.fn.tooltip=old
return this}}(jQuery);+function($){'use strict';var Popover=function(element,options){this.init('popover',element,options)}
if(!$.fn.tooltip)throw new Error('Popover requires tooltip.js')
Popover.VERSION='3.4.1'
Popover.DEFAULTS=$.extend({},$.fn.tooltip.Constructor.DEFAULTS,{placement:'right',trigger:'click',content:'',template:'<div class="popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'})
Popover.prototype=$.extend({},$.fn.tooltip.Constructor.prototype)
Popover.prototype.constructor=Popover
Popover.prototype.getDefaults=function(){return Popover.DEFAULTS}
Popover.prototype.setContent=function(){var $tip=this.tip()
var title=this.getTitle()
var content=this.getContent()
if(this.options.html){var typeContent=typeof content
if(this.options.sanitize){title=this.sanitizeHtml(title)
if(typeContent==='string'){content=this.sanitizeHtml(content)}}
$tip.find('.popover-title').html(title)
$tip.find('.popover-content').children().detach().end()[typeContent==='string'?'html':'append'](content)}else{$tip.find('.popover-title').text(title)
$tip.find('.popover-content').children().detach().end().text(content)}
$tip.removeClass('fade top bottom left right in')
if(!$tip.find('.popover-title').html())$tip.find('.popover-title').hide()}
Popover.prototype.hasContent=function(){return this.getTitle()||this.getContent()}
Popover.prototype.getContent=function(){var $e=this.$element
var o=this.options
return $e.attr('data-content')||(typeof o.content=='function'?o.content.call($e[0]):o.content)}
Popover.prototype.arrow=function(){return(this.$arrow=this.$arrow||this.tip().find('.arrow'))}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.popover')
var options=typeof option=='object'&&option
if(!data&&/destroy|hide/.test(option))return
if(!data)$this.data('bs.popover',(data=new Popover(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.popover
$.fn.popover=Plugin
$.fn.popover.Constructor=Popover
$.fn.popover.noConflict=function(){$.fn.popover=old
return this}}(jQuery);+function($){'use strict';function ScrollSpy(element,options){this.$body=$(document.body)
this.$scrollElement=$(element).is(document.body)?$(window):$(element)
this.options=$.extend({},ScrollSpy.DEFAULTS,options)
this.selector=(this.options.target||'')+' .nav li > a'
this.offsets=[]
this.targets=[]
this.activeTarget=null
this.scrollHeight=0
this.$scrollElement.on('scroll.bs.scrollspy',$.proxy(this.process,this))
this.refresh()
this.process()}
ScrollSpy.VERSION='3.4.1'
ScrollSpy.DEFAULTS={offset:10}
ScrollSpy.prototype.getScrollHeight=function(){return this.$scrollElement[0].scrollHeight||Math.max(this.$body[0].scrollHeight,document.documentElement.scrollHeight)}
ScrollSpy.prototype.refresh=function(){var that=this
var offsetMethod='offset'
var offsetBase=0
this.offsets=[]
this.targets=[]
this.scrollHeight=this.getScrollHeight()
if(!$.isWindow(this.$scrollElement[0])){offsetMethod='position'
offsetBase=this.$scrollElement.scrollTop()}
this.$body.find(this.selector).map(function(){var $el=$(this)
var href=$el.data('target')||$el.attr('href')
var $href=/^#./.test(href)&&$(href)
return($href&&$href.length&&$href.is(':visible')&&[[$href[offsetMethod]().top+offsetBase,href]])||null}).sort(function(a,b){return a[0]-b[0]}).each(function(){that.offsets.push(this[0])
that.targets.push(this[1])})}
ScrollSpy.prototype.process=function(){var scrollTop=this.$scrollElement.scrollTop()+this.options.offset
var scrollHeight=this.getScrollHeight()
var maxScroll=this.options.offset+scrollHeight-this.$scrollElement.height()
var offsets=this.offsets
var targets=this.targets
var activeTarget=this.activeTarget
var i
if(this.scrollHeight!=scrollHeight){this.refresh()}
if(scrollTop>=maxScroll){return activeTarget!=(i=targets[targets.length-1])&&this.activate(i)}
if(activeTarget&&scrollTop<offsets[0]){this.activeTarget=null
return this.clear()}
for(i=offsets.length;i--;){activeTarget!=targets[i]&&scrollTop>=offsets[i]&&(offsets[i+1]===undefined||scrollTop<offsets[i+1])&&this.activate(targets[i])}}
ScrollSpy.prototype.activate=function(target){this.activeTarget=target
this.clear()
var selector=this.selector+'[data-target="'+target+'"],'+this.selector+'[href="'+target+'"]'
var active=$(selector).parents('li').addClass('active')
if(active.parent('.dropdown-menu').length){active=active.closest('li.dropdown').addClass('active')}
active.trigger('activate.bs.scrollspy')}
ScrollSpy.prototype.clear=function(){$(this.selector).parentsUntil(this.options.target,'.active').removeClass('active')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.scrollspy')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.scrollspy',(data=new ScrollSpy(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.scrollspy
$.fn.scrollspy=Plugin
$.fn.scrollspy.Constructor=ScrollSpy
$.fn.scrollspy.noConflict=function(){$.fn.scrollspy=old
return this}
$(window).on('load.bs.scrollspy.data-api',function(){$('[data-spy="scroll"]').each(function(){var $spy=$(this)
Plugin.call($spy,$spy.data())})})}(jQuery);+function($){'use strict';var Tab=function(element){this.element=$(element)}
Tab.VERSION='3.4.1'
Tab.TRANSITION_DURATION=150
Tab.prototype.show=function(){var $this=this.element
var $ul=$this.closest('ul:not(.dropdown-menu)')
var selector=$this.data('target')
if(!selector){selector=$this.attr('href')
selector=selector&&selector.replace(/.*(?=#[^\s]*$)/,'')}
if($this.parent('li').hasClass('active'))return
var $previous=$ul.find('.active:last a')
var hideEvent=$.Event('hide.bs.tab',{relatedTarget:$this[0]})
var showEvent=$.Event('show.bs.tab',{relatedTarget:$previous[0]})
$previous.trigger(hideEvent)
$this.trigger(showEvent)
if(showEvent.isDefaultPrevented()||hideEvent.isDefaultPrevented())return
var $target=$(document).find(selector)
this.activate($this.closest('li'),$ul)
this.activate($target,$target.parent(),function(){$previous.trigger({type:'hidden.bs.tab',relatedTarget:$this[0]})
$this.trigger({type:'shown.bs.tab',relatedTarget:$previous[0]})})}
Tab.prototype.activate=function(element,container,callback){var $active=container.find('> .active')
var transition=callback&&$.support.transition&&($active.length&&$active.hasClass('fade')||!!container.find('> .fade').length)
function next(){$active.removeClass('active').find('> .dropdown-menu > .active').removeClass('active').end().find('[data-toggle="tab"]').attr('aria-expanded',!1)
element.addClass('active').find('[data-toggle="tab"]').attr('aria-expanded',!0)
if(transition){element[0].offsetWidth
element.addClass('in')}else{element.removeClass('fade')}
if(element.parent('.dropdown-menu').length){element.closest('li.dropdown').addClass('active').end().find('[data-toggle="tab"]').attr('aria-expanded',!0)}
callback&&callback()}
$active.length&&transition?$active.one('bsTransitionEnd',next).emulateTransitionEnd(Tab.TRANSITION_DURATION):next()
$active.removeClass('in')}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.tab')
if(!data)$this.data('bs.tab',(data=new Tab(this)))
if(typeof option=='string')data[option]()})}
var old=$.fn.tab
$.fn.tab=Plugin
$.fn.tab.Constructor=Tab
$.fn.tab.noConflict=function(){$.fn.tab=old
return this}
var clickHandler=function(e){e.preventDefault()
Plugin.call($(this),'show')}
$(document).on('click.bs.tab.data-api','[data-toggle="tab"]',clickHandler).on('click.bs.tab.data-api','[data-toggle="pill"]',clickHandler)}(jQuery);+function($){'use strict';var Affix=function(element,options){this.options=$.extend({},Affix.DEFAULTS,options)
var target=this.options.target===Affix.DEFAULTS.target?$(this.options.target):$(document).find(this.options.target)
this.$target=target.on('scroll.bs.affix.data-api',$.proxy(this.checkPosition,this)).on('click.bs.affix.data-api',$.proxy(this.checkPositionWithEventLoop,this))
this.$element=$(element)
this.affixed=null
this.unpin=null
this.pinnedOffset=null
this.checkPosition()}
Affix.VERSION='3.4.1'
Affix.RESET='affix affix-top affix-bottom'
Affix.DEFAULTS={offset:0,target:window}
Affix.prototype.getState=function(scrollHeight,height,offsetTop,offsetBottom){var scrollTop=this.$target.scrollTop()
var position=this.$element.offset()
var targetHeight=this.$target.height()
if(offsetTop!=null&&this.affixed=='top')return scrollTop<offsetTop?'top':!1
if(this.affixed=='bottom'){if(offsetTop!=null)return(scrollTop+this.unpin<=position.top)?!1:'bottom'
return(scrollTop+targetHeight<=scrollHeight-offsetBottom)?!1:'bottom'}
var initializing=this.affixed==null
var colliderTop=initializing?scrollTop:position.top
var colliderHeight=initializing?targetHeight:height
if(offsetTop!=null&&scrollTop<=offsetTop)return'top'
if(offsetBottom!=null&&(colliderTop+colliderHeight>=scrollHeight-offsetBottom))return'bottom'
return!1}
Affix.prototype.getPinnedOffset=function(){if(this.pinnedOffset)return this.pinnedOffset
this.$element.removeClass(Affix.RESET).addClass('affix')
var scrollTop=this.$target.scrollTop()
var position=this.$element.offset()
return(this.pinnedOffset=position.top-scrollTop)}
Affix.prototype.checkPositionWithEventLoop=function(){setTimeout($.proxy(this.checkPosition,this),1)}
Affix.prototype.checkPosition=function(){if(!this.$element.is(':visible'))return
var height=this.$element.height()
var offset=this.options.offset
var offsetTop=offset.top
var offsetBottom=offset.bottom
var scrollHeight=Math.max($(document).height(),$(document.body).height())
if(typeof offset!='object')offsetBottom=offsetTop=offset
if(typeof offsetTop=='function')offsetTop=offset.top(this.$element)
if(typeof offsetBottom=='function')offsetBottom=offset.bottom(this.$element)
var affix=this.getState(scrollHeight,height,offsetTop,offsetBottom)
if(this.affixed!=affix){if(this.unpin!=null)this.$element.css('top','')
var affixType='affix'+(affix?'-'+affix:'')
var e=$.Event(affixType+'.bs.affix')
this.$element.trigger(e)
if(e.isDefaultPrevented())return
this.affixed=affix
this.unpin=affix=='bottom'?this.getPinnedOffset():null
this.$element.removeClass(Affix.RESET).addClass(affixType).trigger(affixType.replace('affix','affixed')+'.bs.affix')}
if(affix=='bottom'){this.$element.offset({top:scrollHeight-height-offsetBottom})}}
function Plugin(option){return this.each(function(){var $this=$(this)
var data=$this.data('bs.affix')
var options=typeof option=='object'&&option
if(!data)$this.data('bs.affix',(data=new Affix(this,options)))
if(typeof option=='string')data[option]()})}
var old=$.fn.affix
$.fn.affix=Plugin
$.fn.affix.Constructor=Affix
$.fn.affix.noConflict=function(){$.fn.affix=old
return this}
$(window).on('load',function(){$('[data-spy="affix"]').each(function(){var $spy=$(this)
var data=$spy.data()
data.offset=data.offset||{}
if(data.offsetBottom!=null)data.offset.bottom=data.offsetBottom
if(data.offsetTop!=null)data.offset.top=data.offsetTop
Plugin.call($spy,data)})})}(jQuery);/*!
 * jQuery Form Plugin
 * version: 4.3.0
 * Requires jQuery v1.7.2 or later
 * Project repository: https://github.com/jquery-form/form

 * Copyright 2017 Kevin Morris
 * Copyright 2006 M. Alsup

 * Dual licensed under the LGPL-2.1+ or MIT licenses
 * https://github.com/jquery-form/form#license

 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof module==='object'&&module.exports){module.exports=function(root,jQuery){if(typeof jQuery==='undefined'){if(typeof window!=='undefined'){jQuery=require('jquery')}else{jQuery=require('jquery')(root)}}
factory(jQuery);return jQuery}}else{factory(jQuery)}}(function($){'use strict';var rCRLF=/\r?\n/g;var feature={};feature.fileapi=$('<input type="file">').get(0).files!==undefined;feature.formdata=(typeof window.FormData!=='undefined');var hasProp=!!$.fn.prop;$.fn.attr2=function(){if(!hasProp){return this.attr.apply(this,arguments)}
var val=this.prop.apply(this,arguments);if((val&&val.jquery)||typeof val==='string'){return val}
return this.attr.apply(this,arguments)};$.fn.ajaxSubmit=function(options,data,dataType,onSuccess){if(!this.length){log('ajaxSubmit: skipping submit process - no element selected');return this}
var method,action,url,isMsie,iframeSrc,$form=this;if(typeof options==='function'){options={success:options}}else if(typeof options==='string'||(options===!1&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}else if(typeof options==='undefined'){options={}}
method=options.method||options.type||this.attr2('method');action=options.url||this.attr2('action');url=(typeof action==='string')?$.trim(action):'';url=url||window.location.href||'';if(url){url=(url.match(/^([^#]+)/)||[])[1]}
isMsie=/(MSIE|Trident)/.test(navigator.userAgent||'');iframeSrc=(isMsie&&/^https/i.test(window.location.href||''))?'javascript:false':'about:blank';options=$.extend(!0,{url:url,success:$.ajaxSettings.success,type:method||$.ajaxSettings.type,iframeSrc:iframeSrc},options);var veto={};this.trigger('form-pre-serialize',[this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-pre-serialize trigger');return this}
if(options.beforeSerialize&&options.beforeSerialize(this,options)===!1){log('ajaxSubmit: submit aborted via beforeSerialize callback');return this}
var traditional=options.traditional;if(typeof traditional==='undefined'){traditional=$.ajaxSettings.traditional}
var elements=[];var qx,a=this.formToArray(options.semantic,elements,options.filtering);if(options.data){var optionsData=$.isFunction(options.data)?options.data(a):options.data;options.extraData=optionsData;qx=$.param(optionsData,traditional)}
if(options.beforeSubmit&&options.beforeSubmit(a,this,options)===!1){log('ajaxSubmit: submit aborted via beforeSubmit callback');return this}
this.trigger('form-submit-validate',[a,this,options,veto]);if(veto.veto){log('ajaxSubmit: submit vetoed via form-submit-validate trigger');return this}
var q=$.param(a,traditional);if(qx){q=(q?(q+'&'+qx):qx)}
if(options.type.toUpperCase()==='GET'){options.url+=(options.url.indexOf('?')>=0?'&':'?')+q;options.data=null}else{options.data=q}
var callbacks=[];if(options.resetForm){callbacks.push(function(){$form.resetForm()})}
if(options.clearForm){callbacks.push(function(){$form.clearForm(options.includeHidden)})}
if(!options.dataType&&options.target){var oldSuccess=options.success||function(){};callbacks.push(function(data,textStatus,jqXHR){var successArguments=arguments,fn=options.replaceTarget?'replaceWith':'html';$(options.target)[fn](data).each(function(){oldSuccess.apply(this,successArguments)})})}else if(options.success){if($.isArray(options.success)){$.merge(callbacks,options.success)}else{callbacks.push(options.success)}}
options.success=function(data,status,xhr){var context=options.context||this;for(var i=0,max=callbacks.length;i<max;i++){callbacks[i].apply(context,[data,status,xhr||$form,$form])}};if(options.error){var oldError=options.error;options.error=function(xhr,status,error){var context=options.context||this;oldError.apply(context,[xhr,status,error,$form])}}
if(options.complete){var oldComplete=options.complete;options.complete=function(xhr,status){var context=options.context||this;oldComplete.apply(context,[xhr,status,$form])}}
var fileInputs=$('input[type=file]:enabled',this).filter(function(){return $(this).val()!==''});var hasFileInputs=fileInputs.length>0;var mp='multipart/form-data';var multipart=($form.attr('enctype')===mp||$form.attr('encoding')===mp);var fileAPI=feature.fileapi&&feature.formdata;log('fileAPI :'+fileAPI);var shouldUseFrame=(hasFileInputs||multipart)&&!fileAPI;var jqxhr;if(options.iframe!==!1&&(options.iframe||shouldUseFrame)){if(options.closeKeepAlive){$.get(options.closeKeepAlive,function(){jqxhr=fileUploadIframe(a)})}else{jqxhr=fileUploadIframe(a)}}else if((hasFileInputs||multipart)&&fileAPI){jqxhr=fileUploadXhr(a)}else{jqxhr=$.ajax(options)}
$form.removeData('jqxhr').data('jqxhr',jqxhr);for(var k=0;k<elements.length;k++){elements[k]=null}
this.trigger('form-submit-notify',[this,options]);return this;function deepSerialize(extraData){var serialized=$.param(extraData,options.traditional).split('&');var len=serialized.length;var result=[];var i,part;for(i=0;i<len;i++){serialized[i]=serialized[i].replace(/\+/g,' ');part=serialized[i].split('=');result.push([decodeURIComponent(part[0]),decodeURIComponent(part[1])])}
return result}
function fileUploadXhr(a){var formdata=new FormData();for(var i=0;i<a.length;i++){formdata.append(a[i].name,a[i].value)}
if(options.extraData){var serializedData=deepSerialize(options.extraData);for(i=0;i<serializedData.length;i++){if(serializedData[i]){formdata.append(serializedData[i][0],serializedData[i][1])}}}
options.data=null;var s=$.extend(!0,{},$.ajaxSettings,options,{contentType:!1,processData:!1,cache:!1,type:method||'POST'});if(options.uploadProgress){s.xhr=function(){var xhr=$.ajaxSettings.xhr();if(xhr.upload){xhr.upload.addEventListener('progress',function(event){var percent=0;var position=event.loaded||event.position;var total=event.total;if(event.lengthComputable){percent=Math.ceil(position/total*100)}
options.uploadProgress(event,position,total,percent)},!1)}
return xhr}}
s.data=null;var beforeSend=s.beforeSend;s.beforeSend=function(xhr,o){if(options.formData){o.data=options.formData}else{o.data=formdata}
if(beforeSend){beforeSend.call(this,xhr,o)}};return $.ajax(s)}
function fileUploadIframe(a){var form=$form[0],el,i,s,g,id,$io,io,xhr,sub,n,timedOut,timeoutHandle;var deferred=$.Deferred();deferred.abort=function(status){xhr.abort(status)};if(a){for(i=0;i<elements.length;i++){el=$(elements[i]);if(hasProp){el.prop('disabled',!1)}else{el.removeAttr('disabled')}}}
s=$.extend(!0,{},$.ajaxSettings,options);s.context=s.context||s;id='jqFormIO'+new Date().getTime();var ownerDocument=form.ownerDocument;var $body=$form.closest('body');if(s.iframeTarget){$io=$(s.iframeTarget,ownerDocument);n=$io.attr2('name');if(!n){$io.attr2('name',id)}else{id=n}}else{$io=$('<iframe name="'+id+'" src="'+s.iframeSrc+'" />',ownerDocument);$io.css({position:'absolute',top:'-1000px',left:'-1000px'})}
io=$io[0];xhr={aborted:0,responseText:null,responseXML:null,status:0,statusText:'n/a',getAllResponseHeaders:function(){},getResponseHeader:function(){},setRequestHeader:function(){},abort:function(status){var e=(status==='timeout'?'timeout':'aborted');log('aborting upload... '+e);this.aborted=1;try{if(io.contentWindow.document.execCommand){io.contentWindow.document.execCommand('Stop')}}catch(ignore){}
$io.attr('src',s.iframeSrc);xhr.error=e;if(s.error){s.error.call(s.context,xhr,e,status)}
if(g){$.event.trigger('ajaxError',[xhr,s,e])}
if(s.complete){s.complete.call(s.context,xhr,e)}}};g=s.global;if(g&&$.active++===0){$.event.trigger('ajaxStart')}
if(g){$.event.trigger('ajaxSend',[xhr,s])}
if(s.beforeSend&&s.beforeSend.call(s.context,xhr,s)===!1){if(s.global){$.active--}
deferred.reject();return deferred}
if(xhr.aborted){deferred.reject();return deferred}
sub=form.clk;if(sub){n=sub.name;if(n&&!sub.disabled){s.extraData=s.extraData||{};s.extraData[n]=sub.value;if(sub.type==='image'){s.extraData[n+'.x']=form.clk_x;s.extraData[n+'.y']=form.clk_y}}}
var CLIENT_TIMEOUT_ABORT=1;var SERVER_ABORT=2;function getDoc(frame){var doc=null;try{if(frame.contentWindow){doc=frame.contentWindow.document}}catch(err){log('cannot get iframe.contentWindow document: '+err)}
if(doc){return doc}
try{doc=frame.contentDocument?frame.contentDocument:frame.document}catch(err){log('cannot get iframe.contentDocument: '+err);doc=frame.document}
return doc}
var csrf_token=$('meta[name=csrf-token]').attr('content');var csrf_param=$('meta[name=csrf-param]').attr('content');if(csrf_param&&csrf_token){s.extraData=s.extraData||{};s.extraData[csrf_param]=csrf_token}
function doSubmit(){var t=$form.attr2('target'),a=$form.attr2('action'),mp='multipart/form-data',et=$form.attr('enctype')||$form.attr('encoding')||mp;form.setAttribute('target',id);if(!method||/post/i.test(method)){form.setAttribute('method','POST')}
if(a!==s.url){form.setAttribute('action',s.url)}
if(!s.skipEncodingOverride&&(!method||/post/i.test(method))){$form.attr({encoding:'multipart/form-data',enctype:'multipart/form-data'})}
if(s.timeout){timeoutHandle=setTimeout(function(){timedOut=!0;cb(CLIENT_TIMEOUT_ABORT)},s.timeout)}
function checkState(){try{var state=getDoc(io).readyState;log('state = '+state);if(state&&state.toLowerCase()==='uninitialized'){setTimeout(checkState,50)}}catch(e){log('Server abort: ',e,' (',e.name,')');cb(SERVER_ABORT);if(timeoutHandle){clearTimeout(timeoutHandle)}
timeoutHandle=undefined}}
var extraInputs=[];try{if(s.extraData){for(var n in s.extraData){if(s.extraData.hasOwnProperty(n)){if($.isPlainObject(s.extraData[n])&&s.extraData[n].hasOwnProperty('name')&&s.extraData[n].hasOwnProperty('value')){extraInputs.push($('<input type="hidden" name="'+s.extraData[n].name+'">',ownerDocument).val(s.extraData[n].value).appendTo(form)[0])}else{extraInputs.push($('<input type="hidden" name="'+n+'">',ownerDocument).val(s.extraData[n]).appendTo(form)[0])}}}}
if(!s.iframeTarget){$io.appendTo($body)}
if(io.attachEvent){io.attachEvent('onload',cb)}else{io.addEventListener('load',cb,!1)}
setTimeout(checkState,15);try{form.submit()}catch(err){var submitFn=document.createElement('form').submit;submitFn.apply(form)}}finally{form.setAttribute('action',a);form.setAttribute('enctype',et);if(t){form.setAttribute('target',t)}else{$form.removeAttr('target')}
$(extraInputs).remove()}}
if(s.forceSync){doSubmit()}else{setTimeout(doSubmit,10)}
var data,doc,domCheckCount=50,callbackProcessed;function cb(e){if(xhr.aborted||callbackProcessed){return}
doc=getDoc(io);if(!doc){log('cannot access response document');e=SERVER_ABORT}
if(e===CLIENT_TIMEOUT_ABORT&&xhr){xhr.abort('timeout');deferred.reject(xhr,'timeout');return}
if(e===SERVER_ABORT&&xhr){xhr.abort('server abort');deferred.reject(xhr,'error','server abort');return}
if(!doc||doc.location.href===s.iframeSrc){if(!timedOut){return}}
if(io.detachEvent){io.detachEvent('onload',cb)}else{io.removeEventListener('load',cb,!1)}
var status='success',errMsg;try{if(timedOut){throw 'timeout'}
var isXml=s.dataType==='xml'||doc.XMLDocument||$.isXMLDoc(doc);log('isXml='+isXml);if(!isXml&&window.opera&&(doc.body===null||!doc.body.innerHTML)){if(--domCheckCount){log('requeing onLoad callback, DOM not available');setTimeout(cb,250);return}}
var docRoot=doc.body?doc.body:doc.documentElement;xhr.responseText=docRoot?docRoot.innerHTML:null;xhr.responseXML=doc.XMLDocument?doc.XMLDocument:doc;if(isXml){s.dataType='xml'}
xhr.getResponseHeader=function(header){var headers={'content-type':s.dataType};return headers[header.toLowerCase()]};if(docRoot){xhr.status=Number(docRoot.getAttribute('status'))||xhr.status;xhr.statusText=docRoot.getAttribute('statusText')||xhr.statusText}
var dt=(s.dataType||'').toLowerCase();var scr=/(json|script|text)/.test(dt);if(scr||s.textarea){var ta=doc.getElementsByTagName('textarea')[0];if(ta){xhr.responseText=ta.value;xhr.status=Number(ta.getAttribute('status'))||xhr.status;xhr.statusText=ta.getAttribute('statusText')||xhr.statusText}else if(scr){var pre=doc.getElementsByTagName('pre')[0];var b=doc.getElementsByTagName('body')[0];if(pre){xhr.responseText=pre.textContent?pre.textContent:pre.innerText}else if(b){xhr.responseText=b.textContent?b.textContent:b.innerText}}}else if(dt==='xml'&&!xhr.responseXML&&xhr.responseText){xhr.responseXML=toXml(xhr.responseText)}
try{data=httpData(xhr,dt,s)}catch(err){status='parsererror';xhr.error=errMsg=(err||status)}}catch(err){log('error caught: ',err);status='error';xhr.error=errMsg=(err||status)}
if(xhr.aborted){log('upload aborted');status=null}
if(xhr.status){status=((xhr.status>=200&&xhr.status<300)||xhr.status===304)?'success':'error'}
if(status==='success'){if(s.success){s.success.call(s.context,data,'success',xhr)}
deferred.resolve(xhr.responseText,'success',xhr);if(g){$.event.trigger('ajaxSuccess',[xhr,s])}}else if(status){if(typeof errMsg==='undefined'){errMsg=xhr.statusText}
if(s.error){s.error.call(s.context,xhr,status,errMsg)}
deferred.reject(xhr,'error',errMsg);if(g){$.event.trigger('ajaxError',[xhr,s,errMsg])}}
if(g){$.event.trigger('ajaxComplete',[xhr,s])}
if(g&&!--$.active){$.event.trigger('ajaxStop')}
if(s.complete){s.complete.call(s.context,xhr,status)}
callbackProcessed=!0;if(s.timeout){clearTimeout(timeoutHandle)}
setTimeout(function(){if(!s.iframeTarget){$io.remove()}else{$io.attr('src',s.iframeSrc)}
xhr.responseXML=null},100)}
var toXml=$.parseXML||function(s,doc){if(window.ActiveXObject){doc=new ActiveXObject('Microsoft.XMLDOM');doc.async='false';doc.loadXML(s)}else{doc=(new DOMParser()).parseFromString(s,'text/xml')}
return(doc&&doc.documentElement&&doc.documentElement.nodeName!=='parsererror')?doc:null};var parseJSON=$.parseJSON||function(s){return window['eval']('('+s+')')};var httpData=function(xhr,type,s){var ct=xhr.getResponseHeader('content-type')||'',xml=((type==='xml'||!type)&&ct.indexOf('xml')>=0),data=xml?xhr.responseXML:xhr.responseText;if(xml&&data.documentElement.nodeName==='parsererror'){if($.error){$.error('parsererror')}}
if(s&&s.dataFilter){data=s.dataFilter(data,type)}
if(typeof data==='string'){if((type==='json'||!type)&&ct.indexOf('json')>=0){data=parseJSON(data)}else if((type==='script'||!type)&&ct.indexOf('javascript')>=0){$.globalEval(data)}}
return data};return deferred}};$.fn.ajaxForm=function(options,data,dataType,onSuccess){if(typeof options==='string'||(options===!1&&arguments.length>0)){options={'url':options,'data':data,'dataType':dataType};if(typeof onSuccess==='function'){options.success=onSuccess}}
options=options||{};options.delegation=options.delegation&&$.isFunction($.fn.on);if(!options.delegation&&this.length===0){var o={s:this.selector,c:this.context};if(!$.isReady&&o.s){log('DOM not ready, queuing ajaxForm');$(function(){$(o.s,o.c).ajaxForm(options)});return this}
log('terminating; zero elements found by selector'+($.isReady?'':' (DOM not ready)'));return this}
if(options.delegation){$(document).off('submit.form-plugin',this.selector,doAjaxSubmit).off('click.form-plugin',this.selector,captureSubmittingElement).on('submit.form-plugin',this.selector,options,doAjaxSubmit).on('click.form-plugin',this.selector,options,captureSubmittingElement);return this}
if(options.beforeFormUnbind){options.beforeFormUnbind(this,options)}
return this.ajaxFormUnbind().on('submit.form-plugin',options,doAjaxSubmit).on('click.form-plugin',options,captureSubmittingElement)};function doAjaxSubmit(e){var options=e.data;if(!e.isDefaultPrevented()){e.preventDefault();$(e.target).closest('form').ajaxSubmit(options)}}
function captureSubmittingElement(e){var target=e.target;var $el=$(target);if(!$el.is('[type=submit],[type=image]')){var t=$el.closest('[type=submit]');if(t.length===0){return}
target=t[0]}
var form=target.form;form.clk=target;if(target.type==='image'){if(typeof e.offsetX!=='undefined'){form.clk_x=e.offsetX;form.clk_y=e.offsetY}else if(typeof $.fn.offset==='function'){var offset=$el.offset();form.clk_x=e.pageX-offset.left;form.clk_y=e.pageY-offset.top}else{form.clk_x=e.pageX-target.offsetLeft;form.clk_y=e.pageY-target.offsetTop}}
setTimeout(function(){form.clk=form.clk_x=form.clk_y=null},100)}
$.fn.ajaxFormUnbind=function(){return this.off('submit.form-plugin click.form-plugin')};$.fn.formToArray=function(semantic,elements,filtering){var a=[];if(this.length===0){return a}
var form=this[0];var formId=this.attr('id');var els=(semantic||typeof form.elements==='undefined')?form.getElementsByTagName('*'):form.elements;var els2;if(els){els=$.makeArray(els)}
if(formId&&(semantic||/(Edge|Trident)\//.test(navigator.userAgent))){els2=$(':input[form="'+formId+'"]').get();if(els2.length){els=(els||[]).concat(els2)}}
if(!els||!els.length){return a}
if($.isFunction(filtering)){els=$.map(els,filtering)}
var i,j,n,v,el,max,jmax;for(i=0,max=els.length;i<max;i++){el=els[i];n=el.name;if(!n||el.disabled){continue}
if(semantic&&form.clk&&el.type==='image'){if(form.clk===el){a.push({name:n,value:$(el).val(),type:el.type});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}
continue}
v=$.fieldValue(el,!0);if(v&&v.constructor===Array){if(elements){elements.push(el)}
for(j=0,jmax=v.length;j<jmax;j++){a.push({name:n,value:v[j]})}}else if(feature.fileapi&&el.type==='file'){if(elements){elements.push(el)}
var files=el.files;if(files.length){for(j=0;j<files.length;j++){a.push({name:n,value:files[j],type:el.type})}}else{a.push({name:n,value:'',type:el.type})}}else if(v!==null&&typeof v!=='undefined'){if(elements){elements.push(el)}
a.push({name:n,value:v,type:el.type,required:el.required})}}
if(!semantic&&form.clk){var $input=$(form.clk),input=$input[0];n=input.name;if(n&&!input.disabled&&input.type==='image'){a.push({name:n,value:$input.val()});a.push({name:n+'.x',value:form.clk_x},{name:n+'.y',value:form.clk_y})}}
return a};$.fn.formSerialize=function(semantic){return $.param(this.formToArray(semantic))};$.fn.fieldSerialize=function(successful){var a=[];this.each(function(){var n=this.name;if(!n){return}
var v=$.fieldValue(this,successful);if(v&&v.constructor===Array){for(var i=0,max=v.length;i<max;i++){a.push({name:n,value:v[i]})}}else if(v!==null&&typeof v!=='undefined'){a.push({name:this.name,value:v})}});return $.param(a)};$.fn.fieldValue=function(successful){for(var val=[],i=0,max=this.length;i<max;i++){var el=this[i];var v=$.fieldValue(el,successful);if(v===null||typeof v==='undefined'||(v.constructor===Array&&!v.length)){continue}
if(v.constructor===Array){$.merge(val,v)}else{val.push(v)}}
return val};$.fieldValue=function(el,successful){var n=el.name,t=el.type,tag=el.tagName.toLowerCase();if(typeof successful==='undefined'){successful=!0}
if(successful&&(!n||el.disabled||t==='reset'||t==='button'||(t==='checkbox'||t==='radio')&&!el.checked||(t==='submit'||t==='image')&&el.form&&el.form.clk!==el||tag==='select'&&el.selectedIndex===-1)){return null}
if(tag==='select'){var index=el.selectedIndex;if(index<0){return null}
var a=[],ops=el.options;var one=(t==='select-one');var max=(one?index+1:ops.length);for(var i=(one?index:0);i<max;i++){var op=ops[i];if(op.selected&&!op.disabled){var v=op.value;if(!v){v=(op.attributes&&op.attributes.value&&!(op.attributes.value.specified))?op.text:op.value}
if(one){return v}
a.push(v)}}
return a}
return $(el).val().replace(rCRLF,'\r\n')};$.fn.clearForm=function(includeHidden){return this.each(function(){$('input,select,textarea',this).clearFields(includeHidden)})};$.fn.clearFields=$.fn.clearInputs=function(includeHidden){var re=/^(?:color|date|datetime|email|month|number|password|range|search|tel|text|time|url|week)$/i;return this.each(function(){var t=this.type,tag=this.tagName.toLowerCase();if(re.test(t)||tag==='textarea'){this.value=''}else if(t==='checkbox'||t==='radio'){this.checked=!1}else if(tag==='select'){this.selectedIndex=-1}else if(t==='file'){if(/MSIE/.test(navigator.userAgent)){$(this).replaceWith($(this).clone(!0))}else{$(this).val('')}}else if(includeHidden){if((includeHidden===!0&&/hidden/.test(t))||(typeof includeHidden==='string'&&$(this).is(includeHidden))){this.value=''}}})};$.fn.resetForm=function(){return this.each(function(){var el=$(this);var tag=this.tagName.toLowerCase();switch(tag){case 'input':this.checked=this.defaultChecked;case 'textarea':this.value=this.defaultValue;return!0;case 'option':case 'optgroup':var select=el.parents('select');if(select.length&&select[0].multiple){if(tag==='option'){this.selected=this.defaultSelected}else{el.find('option').resetForm()}}else{select.resetForm()}
return!0;case 'select':el.find('option').each(function(i){this.selected=this.defaultSelected;if(this.defaultSelected&&!el[0].multiple){el[0].selectedIndex=i;return!1}});return!0;case 'label':var forEl=$(el.attr('for'));var list=el.find('input,select,textarea');if(forEl[0]){list.unshift(forEl[0])}
list.resetForm();return!0;case 'form':if(typeof this.reset==='function'||(typeof this.reset==='object'&&!this.reset.nodeType)){this.reset()}
return!0;default:el.find('form,input,label,select,textarea').resetForm();return!0}})};$.fn.enable=function(b){if(typeof b==='undefined'){b=!0}
return this.each(function(){this.disabled=!b})};$.fn.selected=function(select){if(typeof select==='undefined'){select=!0}
return this.each(function(){var t=this.type;if(t==='checkbox'||t==='radio'){this.checked=select}else if(this.tagName.toLowerCase()==='option'){var $sel=$(this).parent('select');if(select&&$sel[0]&&$sel[0].type==='select-one'){$sel.find('option').selected(!1)}
this.selected=select}})};$.fn.ajaxSubmit.debug=!1;function log(){if(!$.fn.ajaxSubmit.debug){return}
var msg='[jquery.form] '+Array.prototype.join.call(arguments,'');if(window.console&&window.console.log){window.console.log(msg)}else if(window.opera&&window.opera.postError){window.opera.postError(msg)}}}));!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?module.exports=t():"function"==typeof define&&define.amd?define(t):e.moment=t()}(this,function(){"use strict";var H;function _(){return H.apply(null,arguments)}function y(e){return e instanceof Array||"[object Array]"===Object.prototype.toString.call(e)}function F(e){return null!=e&&"[object Object]"===Object.prototype.toString.call(e)}function c(e,t){return Object.prototype.hasOwnProperty.call(e,t)}function L(e){if(Object.getOwnPropertyNames)return 0===Object.getOwnPropertyNames(e).length;for(var t in e)if(c(e,t))return;return 1}function g(e){return void 0===e}function w(e){return"number"==typeof e||"[object Number]"===Object.prototype.toString.call(e)}function V(e){return e instanceof Date||"[object Date]"===Object.prototype.toString.call(e)}function G(e,t){for(var n=[],s=e.length,i=0;i<s;++i)n.push(t(e[i],i));return n}function E(e,t){for(var n in t)c(t,n)&&(e[n]=t[n]);return c(t,"toString")&&(e.toString=t.toString),c(t,"valueOf")&&(e.valueOf=t.valueOf),e}function l(e,t,n,s){return Wt(e,t,n,s,!0).utc()}function p(e){return null==e._pf&&(e._pf={empty:!1,unusedTokens:[],unusedInput:[],overflow:-2,charsLeftOver:0,nullInput:!1,invalidEra:null,invalidMonth:null,invalidFormat:!1,userInvalidated:!1,iso:!1,parsedDateParts:[],era:null,meridiem:null,rfc2822:!1,weekdayMismatch:!1}),e._pf}function A(e){var t,n,s=e._d&&!isNaN(e._d.getTime());return s&&(t=p(e),n=j.call(t.parsedDateParts,function(e){return null!=e}),s=t.overflow<0&&!t.empty&&!t.invalidEra&&!t.invalidMonth&&!t.invalidWeekday&&!t.weekdayMismatch&&!t.nullInput&&!t.invalidFormat&&!t.userInvalidated&&(!t.meridiem||t.meridiem&&n),e._strict)&&(s=s&&0===t.charsLeftOver&&0===t.unusedTokens.length&&void 0===t.bigHour),null!=Object.isFrozen&&Object.isFrozen(e)?s:(e._isValid=s,e._isValid)}function I(e){var t=l(NaN);return null!=e?E(p(t),e):p(t).userInvalidated=!0,t}var j=Array.prototype.some||function(e){for(var t=Object(this),n=t.length>>>0,s=0;s<n;s++)if(s in t&&e.call(this,t[s],s,t))return!0;return!1},Z=_.momentProperties=[],z=!1;function q(e,t){var n,s,i,r=Z.length;if(g(t._isAMomentObject)||(e._isAMomentObject=t._isAMomentObject),g(t._i)||(e._i=t._i),g(t._f)||(e._f=t._f),g(t._l)||(e._l=t._l),g(t._strict)||(e._strict=t._strict),g(t._tzm)||(e._tzm=t._tzm),g(t._isUTC)||(e._isUTC=t._isUTC),g(t._offset)||(e._offset=t._offset),g(t._pf)||(e._pf=p(t)),g(t._locale)||(e._locale=t._locale),0<r)for(n=0;n<r;n++)g(i=t[s=Z[n]])||(e[s]=i);return e}function $(e){q(this,e),this._d=new Date(null!=e._d?e._d.getTime():NaN),this.isValid()||(this._d=new Date(NaN)),!1===z&&(z=!0,_.updateOffset(this),z=!1)}function k(e){return e instanceof $||null!=e&&null!=e._isAMomentObject}function B(e){!1===_.suppressDeprecationWarnings&&"undefined"!=typeof console&&console.warn&&console.warn("Deprecation warning: "+e)}function e(r,a){var o=!0;return E(function(){if(null!=_.deprecationHandler&&_.deprecationHandler(null,r),o){for(var e,t,n=[],s=arguments.length,i=0;i<s;i++){if(e="","object"==typeof arguments[i]){for(t in e+="\n["+i+"] ",arguments[0])c(arguments[0],t)&&(e+=t+": "+arguments[0][t]+", ");e=e.slice(0,-2)}else e=arguments[i];n.push(e)}B(r+"\nArguments: "+Array.prototype.slice.call(n).join("")+"\n"+(new Error).stack),o=!1}return a.apply(this,arguments)},a)}var J={};function Q(e,t){null!=_.deprecationHandler&&_.deprecationHandler(e,t),J[e]||(B(t),J[e]=!0)}function a(e){return"undefined"!=typeof Function&&e instanceof Function||"[object Function]"===Object.prototype.toString.call(e)}function X(e,t){var n,s=E({},e);for(n in t)c(t,n)&&(F(e[n])&&F(t[n])?(s[n]={},E(s[n],e[n]),E(s[n],t[n])):null!=t[n]?s[n]=t[n]:delete s[n]);for(n in e)c(e,n)&&!c(t,n)&&F(e[n])&&(s[n]=E({},s[n]));return s}function K(e){null!=e&&this.set(e)}_.suppressDeprecationWarnings=!1,_.deprecationHandler=null;var ee=Object.keys||function(e){var t,n=[];for(t in e)c(e,t)&&n.push(t);return n};function r(e,t,n){var s=""+Math.abs(e);return(0<=e?n?"+":"":"-")+Math.pow(10,Math.max(0,t-s.length)).toString().substr(1)+s}var te=/(\[[^\[]*\])|(\\)?([Hh]mm(ss)?|Mo|MM?M?M?|Do|DDDo|DD?D?D?|ddd?d?|do?|w[o|w]?|W[o|W]?|Qo?|N{1,5}|YYYYYY|YYYYY|YYYY|YY|y{2,4}|yo?|gg(ggg?)?|GG(GGG?)?|e|E|a|A|hh?|HH?|kk?|mm?|ss?|S{1,9}|x|X|zz?|ZZ?|.)/g,ne=/(\[[^\[]*\])|(\\)?(LTS|LT|LL?L?L?|l{1,4})/g,se={},ie={};function s(e,t,n,s){var i="string"==typeof s?function(){return this[s]()}:s;e&&(ie[e]=i),t&&(ie[t[0]]=function(){return r(i.apply(this,arguments),t[1],t[2])}),n&&(ie[n]=function(){return this.localeData().ordinal(i.apply(this,arguments),e)})}function re(e,t){return e.isValid()?(t=ae(t,e.localeData()),se[t]=se[t]||function(s){for(var e,i=s.match(te),t=0,r=i.length;t<r;t++)ie[i[t]]?i[t]=ie[i[t]]:i[t]=(e=i[t]).match(/\[[\s\S]/)?e.replace(/^\[|\]$/g,""):e.replace(/\\/g,"");return function(e){for(var t="",n=0;n<r;n++)t+=a(i[n])?i[n].call(e,s):i[n];return t}}(t),se[t](e)):e.localeData().invalidDate()}function ae(e,t){var n=5;function s(e){return t.longDateFormat(e)||e}for(ne.lastIndex=0;0<=n&&ne.test(e);)e=e.replace(ne,s),ne.lastIndex=0,--n;return e}var oe={D:"date",dates:"date",date:"date",d:"day",days:"day",day:"day",e:"weekday",weekdays:"weekday",weekday:"weekday",E:"isoWeekday",isoweekdays:"isoWeekday",isoweekday:"isoWeekday",DDD:"dayOfYear",dayofyears:"dayOfYear",dayofyear:"dayOfYear",h:"hour",hours:"hour",hour:"hour",ms:"millisecond",milliseconds:"millisecond",millisecond:"millisecond",m:"minute",minutes:"minute",minute:"minute",M:"month",months:"month",month:"month",Q:"quarter",quarters:"quarter",quarter:"quarter",s:"second",seconds:"second",second:"second",gg:"weekYear",weekyears:"weekYear",weekyear:"weekYear",GG:"isoWeekYear",isoweekyears:"isoWeekYear",isoweekyear:"isoWeekYear",w:"week",weeks:"week",week:"week",W:"isoWeek",isoweeks:"isoWeek",isoweek:"isoWeek",y:"year",years:"year",year:"year"};function o(e){return"string"==typeof e?oe[e]||oe[e.toLowerCase()]:void 0}function ue(e){var t,n,s={};for(n in e)c(e,n)&&(t=o(n))&&(s[t]=e[n]);return s}var le={date:9,day:11,weekday:11,isoWeekday:11,dayOfYear:4,hour:13,millisecond:16,minute:14,month:8,quarter:7,second:15,weekYear:1,isoWeekYear:1,week:5,isoWeek:5,year:1};var de=/\d/,t=/\d\d/,he=/\d{3}/,ce=/\d{4}/,fe=/[+-]?\d{6}/,n=/\d\d?/,me=/\d\d\d\d?/,_e=/\d\d\d\d\d\d?/,ye=/\d{1,3}/,ge=/\d{1,4}/,we=/[+-]?\d{1,6}/,pe=/\d+/,ke=/[+-]?\d+/,Me=/Z|[+-]\d\d:?\d\d/gi,ve=/Z|[+-]\d\d(?::?\d\d)?/gi,i=/[0-9]{0,256}['a-z\u00A0-\u05FF\u0700-\uD7FF\uF900-\uFDCF\uFDF0-\uFF07\uFF10-\uFFEF]{1,256}|[\u0600-\u06FF\/]{1,256}(\s*?[\u0600-\u06FF]{1,256}){1,2}/i,u=/^[1-9]\d?/,d=/^([1-9]\d|\d)/;function h(e,n,s){Ye[e]=a(n)?n:function(e,t){return e&&s?s:n}}function De(e,t){return c(Ye,e)?Ye[e](t._strict,t._locale):new RegExp(f(e.replace("\\","").replace(/\\(\[)|\\(\])|\[([^\]\[]*)\]|\\(.)/g,function(e,t,n,s,i){return t||n||s||i})))}function f(e){return e.replace(/[-\/\\^$*+?.()|[\]{}]/g,"\\$&")}function m(e){return e<0?Math.ceil(e)||0:Math.floor(e)}function M(e){var e=+e,t=0;return t=0!=e&&isFinite(e)?m(e):t}var Ye={},Se={};function v(e,n){var t,s,i=n;for("string"==typeof e&&(e=[e]),w(n)&&(i=function(e,t){t[n]=M(e)}),s=e.length,t=0;t<s;t++)Se[e[t]]=i}function Oe(e,i){v(e,function(e,t,n,s){n._w=n._w||{},i(e,n._w,n,s)})}function be(e){return e%4==0&&e%100!=0||e%400==0}var D=0,Y=1,S=2,O=3,b=4,T=5,Te=6,xe=7,Ne=8;function We(e){return be(e)?366:365}s("Y",0,0,function(){var e=this.year();return e<=9999?r(e,4):"+"+e}),s(0,["YY",2],0,function(){return this.year()%100}),s(0,["YYYY",4],0,"year"),s(0,["YYYYY",5],0,"year"),s(0,["YYYYYY",6,!0],0,"year"),h("Y",ke),h("YY",n,t),h("YYYY",ge,ce),h("YYYYY",we,fe),h("YYYYYY",we,fe),v(["YYYYY","YYYYYY"],D),v("YYYY",function(e,t){t[D]=2===e.length?_.parseTwoDigitYear(e):M(e)}),v("YY",function(e,t){t[D]=_.parseTwoDigitYear(e)}),v("Y",function(e,t){t[D]=parseInt(e,10)}),_.parseTwoDigitYear=function(e){return M(e)+(68<M(e)?1900:2e3)};var x,Pe=Re("FullYear",!0);function Re(t,n){return function(e){return null!=e?(Ue(this,t,e),_.updateOffset(this,n),this):Ce(this,t)}}function Ce(e,t){if(!e.isValid())return NaN;var n=e._d,s=e._isUTC;switch(t){case"Milliseconds":return s?n.getUTCMilliseconds():n.getMilliseconds();case"Seconds":return s?n.getUTCSeconds():n.getSeconds();case"Minutes":return s?n.getUTCMinutes():n.getMinutes();case"Hours":return s?n.getUTCHours():n.getHours();case"Date":return s?n.getUTCDate():n.getDate();case"Day":return s?n.getUTCDay():n.getDay();case"Month":return s?n.getUTCMonth():n.getMonth();case"FullYear":return s?n.getUTCFullYear():n.getFullYear();default:return NaN}}function Ue(e,t,n){var s,i,r;if(e.isValid()&&!isNaN(n)){switch(s=e._d,i=e._isUTC,t){case"Milliseconds":return i?s.setUTCMilliseconds(n):s.setMilliseconds(n);case"Seconds":return i?s.setUTCSeconds(n):s.setSeconds(n);case"Minutes":return i?s.setUTCMinutes(n):s.setMinutes(n);case"Hours":return i?s.setUTCHours(n):s.setHours(n);case"Date":return i?s.setUTCDate(n):s.setDate(n);case"FullYear":break;default:return}t=n,r=e.month(),e=29!==(e=e.date())||1!==r||be(t)?e:28,i?s.setUTCFullYear(t,r,e):s.setFullYear(t,r,e)}}function He(e,t){var n;return isNaN(e)||isNaN(t)?NaN:(n=(t%(n=12)+n)%n,e+=(t-n)/12,1==n?be(e)?29:28:31-n%7%2)}x=Array.prototype.indexOf||function(e){for(var t=0;t<this.length;++t)if(this[t]===e)return t;return-1},s("M",["MM",2],"Mo",function(){return this.month()+1}),s("MMM",0,0,function(e){return this.localeData().monthsShort(this,e)}),s("MMMM",0,0,function(e){return this.localeData().months(this,e)}),h("M",n,u),h("MM",n,t),h("MMM",function(e,t){return t.monthsShortRegex(e)}),h("MMMM",function(e,t){return t.monthsRegex(e)}),v(["M","MM"],function(e,t){t[Y]=M(e)-1}),v(["MMM","MMMM"],function(e,t,n,s){s=n._locale.monthsParse(e,s,n._strict);null!=s?t[Y]=s:p(n).invalidMonth=e});var Fe="January_February_March_April_May_June_July_August_September_October_November_December".split("_"),Le="Jan_Feb_Mar_Apr_May_Jun_Jul_Aug_Sep_Oct_Nov_Dec".split("_"),Ve=/D[oD]?(\[[^\[\]]*\]|\s)+MMMM?/,Ge=i,Ee=i;function Ae(e,t){if(e.isValid()){if("string"==typeof t)if(/^\d+$/.test(t))t=M(t);else if(!w(t=e.localeData().monthsParse(t)))return;var n=(n=e.date())<29?n:Math.min(n,He(e.year(),t));e._isUTC?e._d.setUTCMonth(t,n):e._d.setMonth(t,n)}}function Ie(e){return null!=e?(Ae(this,e),_.updateOffset(this,!0),this):Ce(this,"Month")}function je(){function e(e,t){return t.length-e.length}for(var t,n,s=[],i=[],r=[],a=0;a<12;a++)n=l([2e3,a]),t=f(this.monthsShort(n,"")),n=f(this.months(n,"")),s.push(t),i.push(n),r.push(n),r.push(t);s.sort(e),i.sort(e),r.sort(e),this._monthsRegex=new RegExp("^("+r.join("|")+")","i"),this._monthsShortRegex=this._monthsRegex,this._monthsStrictRegex=new RegExp("^("+i.join("|")+")","i"),this._monthsShortStrictRegex=new RegExp("^("+s.join("|")+")","i")}function Ze(e,t,n,s,i,r,a){var o;return e<100&&0<=e?(o=new Date(e+400,t,n,s,i,r,a),isFinite(o.getFullYear())&&o.setFullYear(e)):o=new Date(e,t,n,s,i,r,a),o}function ze(e){var t;return e<100&&0<=e?((t=Array.prototype.slice.call(arguments))[0]=e+400,t=new Date(Date.UTC.apply(null,t)),isFinite(t.getUTCFullYear())&&t.setUTCFullYear(e)):t=new Date(Date.UTC.apply(null,arguments)),t}function qe(e,t,n){n=7+t-n;return n-(7+ze(e,0,n).getUTCDay()-t)%7-1}function $e(e,t,n,s,i){var r,t=1+7*(t-1)+(7+n-s)%7+qe(e,s,i),n=t<=0?We(r=e-1)+t:t>We(e)?(r=e+1,t-We(e)):(r=e,t);return{year:r,dayOfYear:n}}function Be(e,t,n){var s,i,r=qe(e.year(),t,n),r=Math.floor((e.dayOfYear()-r-1)/7)+1;return r<1?s=r+N(i=e.year()-1,t,n):r>N(e.year(),t,n)?(s=r-N(e.year(),t,n),i=e.year()+1):(i=e.year(),s=r),{week:s,year:i}}function N(e,t,n){var s=qe(e,t,n),t=qe(e+1,t,n);return(We(e)-s+t)/7}s("w",["ww",2],"wo","week"),s("W",["WW",2],"Wo","isoWeek"),h("w",n,u),h("ww",n,t),h("W",n,u),h("WW",n,t),Oe(["w","ww","W","WW"],function(e,t,n,s){t[s.substr(0,1)]=M(e)});function Je(e,t){return e.slice(t,7).concat(e.slice(0,t))}s("d",0,"do","day"),s("dd",0,0,function(e){return this.localeData().weekdaysMin(this,e)}),s("ddd",0,0,function(e){return this.localeData().weekdaysShort(this,e)}),s("dddd",0,0,function(e){return this.localeData().weekdays(this,e)}),s("e",0,0,"weekday"),s("E",0,0,"isoWeekday"),h("d",n),h("e",n),h("E",n),h("dd",function(e,t){return t.weekdaysMinRegex(e)}),h("ddd",function(e,t){return t.weekdaysShortRegex(e)}),h("dddd",function(e,t){return t.weekdaysRegex(e)}),Oe(["dd","ddd","dddd"],function(e,t,n,s){s=n._locale.weekdaysParse(e,s,n._strict);null!=s?t.d=s:p(n).invalidWeekday=e}),Oe(["d","e","E"],function(e,t,n,s){t[s]=M(e)});var Qe="Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"),Xe="Sun_Mon_Tue_Wed_Thu_Fri_Sat".split("_"),Ke="Su_Mo_Tu_We_Th_Fr_Sa".split("_"),et=i,tt=i,nt=i;function st(){function e(e,t){return t.length-e.length}for(var t,n,s,i=[],r=[],a=[],o=[],u=0;u<7;u++)s=l([2e3,1]).day(u),t=f(this.weekdaysMin(s,"")),n=f(this.weekdaysShort(s,"")),s=f(this.weekdays(s,"")),i.push(t),r.push(n),a.push(s),o.push(t),o.push(n),o.push(s);i.sort(e),r.sort(e),a.sort(e),o.sort(e),this._weekdaysRegex=new RegExp("^("+o.join("|")+")","i"),this._weekdaysShortRegex=this._weekdaysRegex,this._weekdaysMinRegex=this._weekdaysRegex,this._weekdaysStrictRegex=new RegExp("^("+a.join("|")+")","i"),this._weekdaysShortStrictRegex=new RegExp("^("+r.join("|")+")","i"),this._weekdaysMinStrictRegex=new RegExp("^("+i.join("|")+")","i")}function it(){return this.hours()%12||12}function rt(e,t){s(e,0,0,function(){return this.localeData().meridiem(this.hours(),this.minutes(),t)})}function at(e,t){return t._meridiemParse}s("H",["HH",2],0,"hour"),s("h",["hh",2],0,it),s("k",["kk",2],0,function(){return this.hours()||24}),s("hmm",0,0,function(){return""+it.apply(this)+r(this.minutes(),2)}),s("hmmss",0,0,function(){return""+it.apply(this)+r(this.minutes(),2)+r(this.seconds(),2)}),s("Hmm",0,0,function(){return""+this.hours()+r(this.minutes(),2)}),s("Hmmss",0,0,function(){return""+this.hours()+r(this.minutes(),2)+r(this.seconds(),2)}),rt("a",!0),rt("A",!1),h("a",at),h("A",at),h("H",n,d),h("h",n,u),h("k",n,u),h("HH",n,t),h("hh",n,t),h("kk",n,t),h("hmm",me),h("hmmss",_e),h("Hmm",me),h("Hmmss",_e),v(["H","HH"],O),v(["k","kk"],function(e,t,n){e=M(e);t[O]=24===e?0:e}),v(["a","A"],function(e,t,n){n._isPm=n._locale.isPM(e),n._meridiem=e}),v(["h","hh"],function(e,t,n){t[O]=M(e),p(n).bigHour=!0}),v("hmm",function(e,t,n){var s=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s)),p(n).bigHour=!0}),v("hmmss",function(e,t,n){var s=e.length-4,i=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s,2)),t[T]=M(e.substr(i)),p(n).bigHour=!0}),v("Hmm",function(e,t,n){var s=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s))}),v("Hmmss",function(e,t,n){var s=e.length-4,i=e.length-2;t[O]=M(e.substr(0,s)),t[b]=M(e.substr(s,2)),t[T]=M(e.substr(i))});i=Re("Hours",!0);var ot,ut={calendar:{sameDay:"[Today at] LT",nextDay:"[Tomorrow at] LT",nextWeek:"dddd [at] LT",lastDay:"[Yesterday at] LT",lastWeek:"[Last] dddd [at] LT",sameElse:"L"},longDateFormat:{LTS:"h:mm:ss A",LT:"h:mm A",L:"MM/DD/YYYY",LL:"MMMM D, YYYY",LLL:"MMMM D, YYYY h:mm A",LLLL:"dddd, MMMM D, YYYY h:mm A"},invalidDate:"Invalid date",ordinal:"%d",dayOfMonthOrdinalParse:/\d{1,2}/,relativeTime:{future:"in %s",past:"%s ago",s:"a few seconds",ss:"%d seconds",m:"a minute",mm:"%d minutes",h:"an hour",hh:"%d hours",d:"a day",dd:"%d days",w:"a week",ww:"%d weeks",M:"a month",MM:"%d months",y:"a year",yy:"%d years"},months:Fe,monthsShort:Le,week:{dow:0,doy:6},weekdays:Qe,weekdaysMin:Ke,weekdaysShort:Xe,meridiemParse:/[ap]\.?m?\.?/i},W={},lt={};function dt(e){return e&&e.toLowerCase().replace("_","-")}function ht(e){for(var t,n,s,i,r=0;r<e.length;){for(t=(i=dt(e[r]).split("-")).length,n=(n=dt(e[r+1]))?n.split("-"):null;0<t;){if(s=ct(i.slice(0,t).join("-")))return s;if(n&&n.length>=t&&function(e,t){for(var n=Math.min(e.length,t.length),s=0;s<n;s+=1)if(e[s]!==t[s])return s;return n}(i,n)>=t-1)break;t--}r++}return ot}function ct(t){var e,n;if(void 0===W[t]&&"undefined"!=typeof module&&module&&module.exports&&(n=t)&&n.match("^[^/\\\\]*$"))try{e=ot._abbr,require("./locale/"+t),ft(e)}catch(e){W[t]=null}return W[t]}function ft(e,t){return e&&((t=g(t)?P(e):mt(e,t))?ot=t:"undefined"!=typeof console&&console.warn&&console.warn("Locale "+e+" not found. Did you forget to load it?")),ot._abbr}function mt(e,t){if(null===t)return delete W[e],null;var n,s=ut;if(t.abbr=e,null!=W[e])Q("defineLocaleOverride","use moment.updateLocale(localeName, config) to change an existing locale. moment.defineLocale(localeName, config) should only be used for creating a new locale See http://momentjs.com/guides/#/warnings/define-locale/ for more info."),s=W[e]._config;else if(null!=t.parentLocale)if(null!=W[t.parentLocale])s=W[t.parentLocale]._config;else{if(null==(n=ct(t.parentLocale)))return lt[t.parentLocale]||(lt[t.parentLocale]=[]),lt[t.parentLocale].push({name:e,config:t}),null;s=n._config}return W[e]=new K(X(s,t)),lt[e]&&lt[e].forEach(function(e){mt(e.name,e.config)}),ft(e),W[e]}function P(e){var t;if(!(e=e&&e._locale&&e._locale._abbr?e._locale._abbr:e))return ot;if(!y(e)){if(t=ct(e))return t;e=[e]}return ht(e)}function _t(e){var t=e._a;return t&&-2===p(e).overflow&&(t=t[Y]<0||11<t[Y]?Y:t[S]<1||t[S]>He(t[D],t[Y])?S:t[O]<0||24<t[O]||24===t[O]&&(0!==t[b]||0!==t[T]||0!==t[Te])?O:t[b]<0||59<t[b]?b:t[T]<0||59<t[T]?T:t[Te]<0||999<t[Te]?Te:-1,p(e)._overflowDayOfYear&&(t<D||S<t)&&(t=S),p(e)._overflowWeeks&&-1===t&&(t=xe),p(e)._overflowWeekday&&-1===t&&(t=Ne),p(e).overflow=t),e}var yt=/^\s*((?:[+-]\d{6}|\d{4})-(?:\d\d-\d\d|W\d\d-\d|W\d\d|\d\d\d|\d\d))(?:(T| )(\d\d(?::\d\d(?::\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,gt=/^\s*((?:[+-]\d{6}|\d{4})(?:\d\d\d\d|W\d\d\d|W\d\d|\d\d\d|\d\d|))(?:(T| )(\d\d(?:\d\d(?:\d\d(?:[.,]\d+)?)?)?)([+-]\d\d(?::?\d\d)?|\s*Z)?)?$/,wt=/Z|[+-]\d\d(?::?\d\d)?/,pt=[["YYYYYY-MM-DD",/[+-]\d{6}-\d\d-\d\d/],["YYYY-MM-DD",/\d{4}-\d\d-\d\d/],["GGGG-[W]WW-E",/\d{4}-W\d\d-\d/],["GGGG-[W]WW",/\d{4}-W\d\d/,!1],["YYYY-DDD",/\d{4}-\d{3}/],["YYYY-MM",/\d{4}-\d\d/,!1],["YYYYYYMMDD",/[+-]\d{10}/],["YYYYMMDD",/\d{8}/],["GGGG[W]WWE",/\d{4}W\d{3}/],["GGGG[W]WW",/\d{4}W\d{2}/,!1],["YYYYDDD",/\d{7}/],["YYYYMM",/\d{6}/,!1],["YYYY",/\d{4}/,!1]],kt=[["HH:mm:ss.SSSS",/\d\d:\d\d:\d\d\.\d+/],["HH:mm:ss,SSSS",/\d\d:\d\d:\d\d,\d+/],["HH:mm:ss",/\d\d:\d\d:\d\d/],["HH:mm",/\d\d:\d\d/],["HHmmss.SSSS",/\d\d\d\d\d\d\.\d+/],["HHmmss,SSSS",/\d\d\d\d\d\d,\d+/],["HHmmss",/\d\d\d\d\d\d/],["HHmm",/\d\d\d\d/],["HH",/\d\d/]],Mt=/^\/?Date\((-?\d+)/i,vt=/^(?:(Mon|Tue|Wed|Thu|Fri|Sat|Sun),?\s)?(\d{1,2})\s(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\s(\d{2,4})\s(\d\d):(\d\d)(?::(\d\d))?\s(?:(UT|GMT|[ECMP][SD]T)|([Zz])|([+-]\d{4}))$/,Dt={UT:0,GMT:0,EDT:-240,EST:-300,CDT:-300,CST:-360,MDT:-360,MST:-420,PDT:-420,PST:-480};function Yt(e){var t,n,s,i,r,a,o=e._i,u=yt.exec(o)||gt.exec(o),o=pt.length,l=kt.length;if(u){for(p(e).iso=!0,t=0,n=o;t<n;t++)if(pt[t][1].exec(u[1])){i=pt[t][0],s=!1!==pt[t][2];break}if(null==i)e._isValid=!1;else{if(u[3]){for(t=0,n=l;t<n;t++)if(kt[t][1].exec(u[3])){r=(u[2]||" ")+kt[t][0];break}if(null==r)return void(e._isValid=!1)}if(s||null==r){if(u[4]){if(!wt.exec(u[4]))return void(e._isValid=!1);a="Z"}e._f=i+(r||"")+(a||""),xt(e)}else e._isValid=!1}}else e._isValid=!1}function St(e,t,n,s,i,r){e=[function(e){e=parseInt(e,10);{if(e<=49)return 2e3+e;if(e<=999)return 1900+e}return e}(e),Le.indexOf(t),parseInt(n,10),parseInt(s,10),parseInt(i,10)];return r&&e.push(parseInt(r,10)),e}function Ot(e){var t,n,s=vt.exec(e._i.replace(/\([^()]*\)|[\n\t]/g," ").replace(/(\s\s+)/g," ").replace(/^\s\s*/,"").replace(/\s\s*$/,""));s?(t=St(s[4],s[3],s[2],s[5],s[6],s[7]),function(e,t,n){if(!e||Xe.indexOf(e)===new Date(t[0],t[1],t[2]).getDay())return 1;p(n).weekdayMismatch=!0,n._isValid=!1}(s[1],t,e)&&(e._a=t,e._tzm=(t=s[8],n=s[9],s=s[10],t?Dt[t]:n?0:60*(((t=parseInt(s,10))-(n=t%100))/100)+n),e._d=ze.apply(null,e._a),e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),p(e).rfc2822=!0)):e._isValid=!1}function bt(e,t,n){return null!=e?e:null!=t?t:n}function Tt(e){var t,n,s,i,r,a,o,u,l,d,h,c=[];if(!e._d){for(s=e,i=new Date(_.now()),n=s._useUTC?[i.getUTCFullYear(),i.getUTCMonth(),i.getUTCDate()]:[i.getFullYear(),i.getMonth(),i.getDate()],e._w&&null==e._a[S]&&null==e._a[Y]&&(null!=(i=(s=e)._w).GG||null!=i.W||null!=i.E?(u=1,l=4,r=bt(i.GG,s._a[D],Be(R(),1,4).year),a=bt(i.W,1),((o=bt(i.E,1))<1||7<o)&&(d=!0)):(u=s._locale._week.dow,l=s._locale._week.doy,h=Be(R(),u,l),r=bt(i.gg,s._a[D],h.year),a=bt(i.w,h.week),null!=i.d?((o=i.d)<0||6<o)&&(d=!0):null!=i.e?(o=i.e+u,(i.e<0||6<i.e)&&(d=!0)):o=u),a<1||a>N(r,u,l)?p(s)._overflowWeeks=!0:null!=d?p(s)._overflowWeekday=!0:(h=$e(r,a,o,u,l),s._a[D]=h.year,s._dayOfYear=h.dayOfYear)),null!=e._dayOfYear&&(i=bt(e._a[D],n[D]),(e._dayOfYear>We(i)||0===e._dayOfYear)&&(p(e)._overflowDayOfYear=!0),d=ze(i,0,e._dayOfYear),e._a[Y]=d.getUTCMonth(),e._a[S]=d.getUTCDate()),t=0;t<3&&null==e._a[t];++t)e._a[t]=c[t]=n[t];for(;t<7;t++)e._a[t]=c[t]=null==e._a[t]?2===t?1:0:e._a[t];24===e._a[O]&&0===e._a[b]&&0===e._a[T]&&0===e._a[Te]&&(e._nextDay=!0,e._a[O]=0),e._d=(e._useUTC?ze:Ze).apply(null,c),r=e._useUTC?e._d.getUTCDay():e._d.getDay(),null!=e._tzm&&e._d.setUTCMinutes(e._d.getUTCMinutes()-e._tzm),e._nextDay&&(e._a[O]=24),e._w&&void 0!==e._w.d&&e._w.d!==r&&(p(e).weekdayMismatch=!0)}}function xt(e){if(e._f===_.ISO_8601)Yt(e);else if(e._f===_.RFC_2822)Ot(e);else{e._a=[],p(e).empty=!0;for(var t,n,s,i,r,a=""+e._i,o=a.length,u=0,l=ae(e._f,e._locale).match(te)||[],d=l.length,h=0;h<d;h++)n=l[h],(t=(a.match(De(n,e))||[])[0])&&(0<(s=a.substr(0,a.indexOf(t))).length&&p(e).unusedInput.push(s),a=a.slice(a.indexOf(t)+t.length),u+=t.length),ie[n]?(t?p(e).empty=!1:p(e).unusedTokens.push(n),s=n,r=e,null!=(i=t)&&c(Se,s)&&Se[s](i,r._a,r,s)):e._strict&&!t&&p(e).unusedTokens.push(n);p(e).charsLeftOver=o-u,0<a.length&&p(e).unusedInput.push(a),e._a[O]<=12&&!0===p(e).bigHour&&0<e._a[O]&&(p(e).bigHour=void 0),p(e).parsedDateParts=e._a.slice(0),p(e).meridiem=e._meridiem,e._a[O]=function(e,t,n){if(null==n)return t;return null!=e.meridiemHour?e.meridiemHour(t,n):null!=e.isPM?((e=e.isPM(n))&&t<12&&(t+=12),t=e||12!==t?t:0):t}(e._locale,e._a[O],e._meridiem),null!==(o=p(e).era)&&(e._a[D]=e._locale.erasConvertYear(o,e._a[D])),Tt(e),_t(e)}}function Nt(e){var t,n,s,i=e._i,r=e._f;if(e._locale=e._locale||P(e._l),null===i||void 0===r&&""===i)return I({nullInput:!0});if("string"==typeof i&&(e._i=i=e._locale.preparse(i)),k(i))return new $(_t(i));if(V(i))e._d=i;else if(y(r)){var a,o,u,l,d,h,c=e,f=!1,m=c._f.length;if(0===m)p(c).invalidFormat=!0,c._d=new Date(NaN);else{for(l=0;l<m;l++)d=0,h=!1,a=q({},c),null!=c._useUTC&&(a._useUTC=c._useUTC),a._f=c._f[l],xt(a),A(a)&&(h=!0),d=(d+=p(a).charsLeftOver)+10*p(a).unusedTokens.length,p(a).score=d,f?d<u&&(u=d,o=a):(null==u||d<u||h)&&(u=d,o=a,h)&&(f=!0);E(c,o||a)}}else if(r)xt(e);else if(g(r=(i=e)._i))i._d=new Date(_.now());else V(r)?i._d=new Date(r.valueOf()):"string"==typeof r?(n=i,null!==(t=Mt.exec(n._i))?n._d=new Date(+t[1]):(Yt(n),!1===n._isValid&&(delete n._isValid,Ot(n),!1===n._isValid)&&(delete n._isValid,n._strict?n._isValid=!1:_.createFromInputFallback(n)))):y(r)?(i._a=G(r.slice(0),function(e){return parseInt(e,10)}),Tt(i)):F(r)?(t=i)._d||(s=void 0===(n=ue(t._i)).day?n.date:n.day,t._a=G([n.year,n.month,s,n.hour,n.minute,n.second,n.millisecond],function(e){return e&&parseInt(e,10)}),Tt(t)):w(r)?i._d=new Date(r):_.createFromInputFallback(i);return A(e)||(e._d=null),e}function Wt(e,t,n,s,i){var r={};return!0!==t&&!1!==t||(s=t,t=void 0),!0!==n&&!1!==n||(s=n,n=void 0),(F(e)&&L(e)||y(e)&&0===e.length)&&(e=void 0),r._isAMomentObject=!0,r._useUTC=r._isUTC=i,r._l=n,r._i=e,r._f=t,r._strict=s,(i=new $(_t(Nt(i=r))))._nextDay&&(i.add(1,"d"),i._nextDay=void 0),i}function R(e,t,n,s){return Wt(e,t,n,s,!1)}_.createFromInputFallback=e("value provided is not in a recognized RFC2822 or ISO format. moment construction falls back to js Date(), which is not reliable across all browsers and versions. Non RFC2822/ISO date formats are discouraged. Please refer to http://momentjs.com/guides/#/warnings/js-date/ for more info.",function(e){e._d=new Date(e._i+(e._useUTC?" UTC":""))}),_.ISO_8601=function(){},_.RFC_2822=function(){};me=e("moment().min is deprecated, use moment.max instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=R.apply(null,arguments);return this.isValid()&&e.isValid()?e<this?this:e:I()}),_e=e("moment().max is deprecated, use moment.min instead. http://momentjs.com/guides/#/warnings/min-max/",function(){var e=R.apply(null,arguments);return this.isValid()&&e.isValid()?this<e?this:e:I()});function Pt(e,t){var n,s;if(!(t=1===t.length&&y(t[0])?t[0]:t).length)return R();for(n=t[0],s=1;s<t.length;++s)t[s].isValid()&&!t[s][e](n)||(n=t[s]);return n}var Rt=["year","quarter","month","week","day","hour","minute","second","millisecond"];function Ct(e){var e=ue(e),t=e.year||0,n=e.quarter||0,s=e.month||0,i=e.week||e.isoWeek||0,r=e.day||0,a=e.hour||0,o=e.minute||0,u=e.second||0,l=e.millisecond||0;this._isValid=function(e){var t,n,s=!1,i=Rt.length;for(t in e)if(c(e,t)&&(-1===x.call(Rt,t)||null!=e[t]&&isNaN(e[t])))return!1;for(n=0;n<i;++n)if(e[Rt[n]]){if(s)return!1;parseFloat(e[Rt[n]])!==M(e[Rt[n]])&&(s=!0)}return!0}(e),this._milliseconds=+l+1e3*u+6e4*o+1e3*a*60*60,this._days=+r+7*i,this._months=+s+3*n+12*t,this._data={},this._locale=P(),this._bubble()}function Ut(e){return e instanceof Ct}function Ht(e){return e<0?-1*Math.round(-1*e):Math.round(e)}function Ft(e,n){s(e,0,0,function(){var e=this.utcOffset(),t="+";return e<0&&(e=-e,t="-"),t+r(~~(e/60),2)+n+r(~~e%60,2)})}Ft("Z",":"),Ft("ZZ",""),h("Z",ve),h("ZZ",ve),v(["Z","ZZ"],function(e,t,n){n._useUTC=!0,n._tzm=Vt(ve,e)});var Lt=/([\+\-]|\d\d)/gi;function Vt(e,t){var t=(t||"").match(e);return null===t?null:0===(t=60*(e=((t[t.length-1]||[])+"").match(Lt)||["-",0,0])[1]+M(e[2]))?0:"+"===e[0]?t:-t}function Gt(e,t){var n;return t._isUTC?(t=t.clone(),n=(k(e)||V(e)?e:R(e)).valueOf()-t.valueOf(),t._d.setTime(t._d.valueOf()+n),_.updateOffset(t,!1),t):R(e).local()}function Et(e){return-Math.round(e._d.getTimezoneOffset())}function At(){return!!this.isValid()&&this._isUTC&&0===this._offset}_.updateOffset=function(){};var It=/^(-|\+)?(?:(\d*)[. ])?(\d+):(\d+)(?::(\d+)(\.\d*)?)?$/,jt=/^(-|\+)?P(?:([-+]?[0-9,.]*)Y)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)W)?(?:([-+]?[0-9,.]*)D)?(?:T(?:([-+]?[0-9,.]*)H)?(?:([-+]?[0-9,.]*)M)?(?:([-+]?[0-9,.]*)S)?)?$/;function C(e,t){var n,s=e;return Ut(e)?s={ms:e._milliseconds,d:e._days,M:e._months}:w(e)||!isNaN(+e)?(s={},t?s[t]=+e:s.milliseconds=+e):(t=It.exec(e))?(n="-"===t[1]?-1:1,s={y:0,d:M(t[S])*n,h:M(t[O])*n,m:M(t[b])*n,s:M(t[T])*n,ms:M(Ht(1e3*t[Te]))*n}):(t=jt.exec(e))?(n="-"===t[1]?-1:1,s={y:Zt(t[2],n),M:Zt(t[3],n),w:Zt(t[4],n),d:Zt(t[5],n),h:Zt(t[6],n),m:Zt(t[7],n),s:Zt(t[8],n)}):null==s?s={}:"object"==typeof s&&("from"in s||"to"in s)&&(t=function(e,t){var n;if(!e.isValid()||!t.isValid())return{milliseconds:0,months:0};t=Gt(t,e),e.isBefore(t)?n=zt(e,t):((n=zt(t,e)).milliseconds=-n.milliseconds,n.months=-n.months);return n}(R(s.from),R(s.to)),(s={}).ms=t.milliseconds,s.M=t.months),n=new Ct(s),Ut(e)&&c(e,"_locale")&&(n._locale=e._locale),Ut(e)&&c(e,"_isValid")&&(n._isValid=e._isValid),n}function Zt(e,t){e=e&&parseFloat(e.replace(",","."));return(isNaN(e)?0:e)*t}function zt(e,t){var n={};return n.months=t.month()-e.month()+12*(t.year()-e.year()),e.clone().add(n.months,"M").isAfter(t)&&--n.months,n.milliseconds=+t-+e.clone().add(n.months,"M"),n}function qt(s,i){return function(e,t){var n;return null===t||isNaN(+t)||(Q(i,"moment()."+i+"(period, number) is deprecated. Please use moment()."+i+"(number, period). See http://momentjs.com/guides/#/warnings/add-inverted-param/ for more info."),n=e,e=t,t=n),$t(this,C(e,t),s),this}}function $t(e,t,n,s){var i=t._milliseconds,r=Ht(t._days),t=Ht(t._months);e.isValid()&&(s=null==s||s,t&&Ae(e,Ce(e,"Month")+t*n),r&&Ue(e,"Date",Ce(e,"Date")+r*n),i&&e._d.setTime(e._d.valueOf()+i*n),s)&&_.updateOffset(e,r||t)}C.fn=Ct.prototype,C.invalid=function(){return C(NaN)};Fe=qt(1,"add"),Qe=qt(-1,"subtract");function Bt(e){return"string"==typeof e||e instanceof String}function Jt(e){return k(e)||V(e)||Bt(e)||w(e)||function(t){var e=y(t),n=!1;e&&(n=0===t.filter(function(e){return!w(e)&&Bt(t)}).length);return e&&n}(e)||function(e){var t,n,s=F(e)&&!L(e),i=!1,r=["years","year","y","months","month","M","days","day","d","dates","date","D","hours","hour","h","minutes","minute","m","seconds","second","s","milliseconds","millisecond","ms"],a=r.length;for(t=0;t<a;t+=1)n=r[t],i=i||c(e,n);return s&&i}(e)||null==e}function Qt(e,t){var n,s;return e.date()<t.date()?-Qt(t,e):-((n=12*(t.year()-e.year())+(t.month()-e.month()))+(t-(s=e.clone().add(n,"months"))<0?(t-s)/(s-e.clone().add(n-1,"months")):(t-s)/(e.clone().add(1+n,"months")-s)))||0}function Xt(e){return void 0===e?this._locale._abbr:(null!=(e=P(e))&&(this._locale=e),this)}_.defaultFormat="YYYY-MM-DDTHH:mm:ssZ",_.defaultFormatUtc="YYYY-MM-DDTHH:mm:ss[Z]";Ke=e("moment().lang() is deprecated. Instead, use moment().localeData() to get the language configuration. Use moment().locale() to change languages.",function(e){return void 0===e?this.localeData():this.locale(e)});function Kt(){return this._locale}var en=126227808e5;function tn(e,t){return(e%t+t)%t}function nn(e,t,n){return e<100&&0<=e?new Date(e+400,t,n)-en:new Date(e,t,n).valueOf()}function sn(e,t,n){return e<100&&0<=e?Date.UTC(e+400,t,n)-en:Date.UTC(e,t,n)}function rn(e,t){return t.erasAbbrRegex(e)}function an(){for(var e,t,n,s=[],i=[],r=[],a=[],o=this.eras(),u=0,l=o.length;u<l;++u)e=f(o[u].name),t=f(o[u].abbr),n=f(o[u].narrow),i.push(e),s.push(t),r.push(n),a.push(e),a.push(t),a.push(n);this._erasRegex=new RegExp("^("+a.join("|")+")","i"),this._erasNameRegex=new RegExp("^("+i.join("|")+")","i"),this._erasAbbrRegex=new RegExp("^("+s.join("|")+")","i"),this._erasNarrowRegex=new RegExp("^("+r.join("|")+")","i")}function on(e,t){s(0,[e,e.length],0,t)}function un(e,t,n,s,i){var r;return null==e?Be(this,s,i).year:(r=N(e,s,i),function(e,t,n,s,i){e=$e(e,t,n,s,i),t=ze(e.year,0,e.dayOfYear);return this.year(t.getUTCFullYear()),this.month(t.getUTCMonth()),this.date(t.getUTCDate()),this}.call(this,e,t=r<t?r:t,n,s,i))}s("N",0,0,"eraAbbr"),s("NN",0,0,"eraAbbr"),s("NNN",0,0,"eraAbbr"),s("NNNN",0,0,"eraName"),s("NNNNN",0,0,"eraNarrow"),s("y",["y",1],"yo","eraYear"),s("y",["yy",2],0,"eraYear"),s("y",["yyy",3],0,"eraYear"),s("y",["yyyy",4],0,"eraYear"),h("N",rn),h("NN",rn),h("NNN",rn),h("NNNN",function(e,t){return t.erasNameRegex(e)}),h("NNNNN",function(e,t){return t.erasNarrowRegex(e)}),v(["N","NN","NNN","NNNN","NNNNN"],function(e,t,n,s){s=n._locale.erasParse(e,s,n._strict);s?p(n).era=s:p(n).invalidEra=e}),h("y",pe),h("yy",pe),h("yyy",pe),h("yyyy",pe),h("yo",function(e,t){return t._eraYearOrdinalRegex||pe}),v(["y","yy","yyy","yyyy"],D),v(["yo"],function(e,t,n,s){var i;n._locale._eraYearOrdinalRegex&&(i=e.match(n._locale._eraYearOrdinalRegex)),n._locale.eraYearOrdinalParse?t[D]=n._locale.eraYearOrdinalParse(e,i):t[D]=parseInt(e,10)}),s(0,["gg",2],0,function(){return this.weekYear()%100}),s(0,["GG",2],0,function(){return this.isoWeekYear()%100}),on("gggg","weekYear"),on("ggggg","weekYear"),on("GGGG","isoWeekYear"),on("GGGGG","isoWeekYear"),h("G",ke),h("g",ke),h("GG",n,t),h("gg",n,t),h("GGGG",ge,ce),h("gggg",ge,ce),h("GGGGG",we,fe),h("ggggg",we,fe),Oe(["gggg","ggggg","GGGG","GGGGG"],function(e,t,n,s){t[s.substr(0,2)]=M(e)}),Oe(["gg","GG"],function(e,t,n,s){t[s]=_.parseTwoDigitYear(e)}),s("Q",0,"Qo","quarter"),h("Q",de),v("Q",function(e,t){t[Y]=3*(M(e)-1)}),s("D",["DD",2],"Do","date"),h("D",n,u),h("DD",n,t),h("Do",function(e,t){return e?t._dayOfMonthOrdinalParse||t._ordinalParse:t._dayOfMonthOrdinalParseLenient}),v(["D","DD"],S),v("Do",function(e,t){t[S]=M(e.match(n)[0])});ge=Re("Date",!0);s("DDD",["DDDD",3],"DDDo","dayOfYear"),h("DDD",ye),h("DDDD",he),v(["DDD","DDDD"],function(e,t,n){n._dayOfYear=M(e)}),s("m",["mm",2],0,"minute"),h("m",n,d),h("mm",n,t),v(["m","mm"],b);var ln,ce=Re("Minutes",!1),we=(s("s",["ss",2],0,"second"),h("s",n,d),h("ss",n,t),v(["s","ss"],T),Re("Seconds",!1));for(s("S",0,0,function(){return~~(this.millisecond()/100)}),s(0,["SS",2],0,function(){return~~(this.millisecond()/10)}),s(0,["SSS",3],0,"millisecond"),s(0,["SSSS",4],0,function(){return 10*this.millisecond()}),s(0,["SSSSS",5],0,function(){return 100*this.millisecond()}),s(0,["SSSSSS",6],0,function(){return 1e3*this.millisecond()}),s(0,["SSSSSSS",7],0,function(){return 1e4*this.millisecond()}),s(0,["SSSSSSSS",8],0,function(){return 1e5*this.millisecond()}),s(0,["SSSSSSSSS",9],0,function(){return 1e6*this.millisecond()}),h("S",ye,de),h("SS",ye,t),h("SSS",ye,he),ln="SSSS";ln.length<=9;ln+="S")h(ln,pe);function dn(e,t){t[Te]=M(1e3*("0."+e))}for(ln="S";ln.length<=9;ln+="S")v(ln,dn);fe=Re("Milliseconds",!1),s("z",0,0,"zoneAbbr"),s("zz",0,0,"zoneName");u=$.prototype;function hn(e){return e}u.add=Fe,u.calendar=function(e,t){1===arguments.length&&(arguments[0]?Jt(arguments[0])?(e=arguments[0],t=void 0):function(e){for(var t=F(e)&&!L(e),n=!1,s=["sameDay","nextDay","lastDay","nextWeek","lastWeek","sameElse"],i=0;i<s.length;i+=1)n=n||c(e,s[i]);return t&&n}(arguments[0])&&(t=arguments[0],e=void 0):t=e=void 0);var e=e||R(),n=Gt(e,this).startOf("day"),n=_.calendarFormat(this,n)||"sameElse",t=t&&(a(t[n])?t[n].call(this,e):t[n]);return this.format(t||this.localeData().calendar(n,this,R(e)))},u.clone=function(){return new $(this)},u.diff=function(e,t,n){var s,i,r;if(!this.isValid())return NaN;if(!(s=Gt(e,this)).isValid())return NaN;switch(i=6e4*(s.utcOffset()-this.utcOffset()),t=o(t)){case"year":r=Qt(this,s)/12;break;case"month":r=Qt(this,s);break;case"quarter":r=Qt(this,s)/3;break;case"second":r=(this-s)/1e3;break;case"minute":r=(this-s)/6e4;break;case"hour":r=(this-s)/36e5;break;case"day":r=(this-s-i)/864e5;break;case"week":r=(this-s-i)/6048e5;break;default:r=this-s}return n?r:m(r)},u.endOf=function(e){var t,n;if(void 0!==(e=o(e))&&"millisecond"!==e&&this.isValid()){switch(n=this._isUTC?sn:nn,e){case"year":t=n(this.year()+1,0,1)-1;break;case"quarter":t=n(this.year(),this.month()-this.month()%3+3,1)-1;break;case"month":t=n(this.year(),this.month()+1,1)-1;break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday()+7)-1;break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1)+7)-1;break;case"day":case"date":t=n(this.year(),this.month(),this.date()+1)-1;break;case"hour":t=this._d.valueOf(),t+=36e5-tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5)-1;break;case"minute":t=this._d.valueOf(),t+=6e4-tn(t,6e4)-1;break;case"second":t=this._d.valueOf(),t+=1e3-tn(t,1e3)-1;break}this._d.setTime(t),_.updateOffset(this,!0)}return this},u.format=function(e){return e=e||(this.isUtc()?_.defaultFormatUtc:_.defaultFormat),e=re(this,e),this.localeData().postformat(e)},u.from=function(e,t){return this.isValid()&&(k(e)&&e.isValid()||R(e).isValid())?C({to:this,from:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},u.fromNow=function(e){return this.from(R(),e)},u.to=function(e,t){return this.isValid()&&(k(e)&&e.isValid()||R(e).isValid())?C({from:this,to:e}).locale(this.locale()).humanize(!t):this.localeData().invalidDate()},u.toNow=function(e){return this.to(R(),e)},u.get=function(e){return a(this[e=o(e)])?this[e]():this},u.invalidAt=function(){return p(this).overflow},u.isAfter=function(e,t){return e=k(e)?e:R(e),!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()>e.valueOf():e.valueOf()<this.clone().startOf(t).valueOf())},u.isBefore=function(e,t){return e=k(e)?e:R(e),!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()<e.valueOf():this.clone().endOf(t).valueOf()<e.valueOf())},u.isBetween=function(e,t,n,s){return e=k(e)?e:R(e),t=k(t)?t:R(t),!!(this.isValid()&&e.isValid()&&t.isValid())&&("("===(s=s||"()")[0]?this.isAfter(e,n):!this.isBefore(e,n))&&(")"===s[1]?this.isBefore(t,n):!this.isAfter(t,n))},u.isSame=function(e,t){var e=k(e)?e:R(e);return!(!this.isValid()||!e.isValid())&&("millisecond"===(t=o(t)||"millisecond")?this.valueOf()===e.valueOf():(e=e.valueOf(),this.clone().startOf(t).valueOf()<=e&&e<=this.clone().endOf(t).valueOf()))},u.isSameOrAfter=function(e,t){return this.isSame(e,t)||this.isAfter(e,t)},u.isSameOrBefore=function(e,t){return this.isSame(e,t)||this.isBefore(e,t)},u.isValid=function(){return A(this)},u.lang=Ke,u.locale=Xt,u.localeData=Kt,u.max=_e,u.min=me,u.parsingFlags=function(){return E({},p(this))},u.set=function(e,t){if("object"==typeof e)for(var n=function(e){var t,n=[];for(t in e)c(e,t)&&n.push({unit:t,priority:le[t]});return n.sort(function(e,t){return e.priority-t.priority}),n}(e=ue(e)),s=n.length,i=0;i<s;i++)this[n[i].unit](e[n[i].unit]);else if(a(this[e=o(e)]))return this[e](t);return this},u.startOf=function(e){var t,n;if(void 0!==(e=o(e))&&"millisecond"!==e&&this.isValid()){switch(n=this._isUTC?sn:nn,e){case"year":t=n(this.year(),0,1);break;case"quarter":t=n(this.year(),this.month()-this.month()%3,1);break;case"month":t=n(this.year(),this.month(),1);break;case"week":t=n(this.year(),this.month(),this.date()-this.weekday());break;case"isoWeek":t=n(this.year(),this.month(),this.date()-(this.isoWeekday()-1));break;case"day":case"date":t=n(this.year(),this.month(),this.date());break;case"hour":t=this._d.valueOf(),t-=tn(t+(this._isUTC?0:6e4*this.utcOffset()),36e5);break;case"minute":t=this._d.valueOf(),t-=tn(t,6e4);break;case"second":t=this._d.valueOf(),t-=tn(t,1e3);break}this._d.setTime(t),_.updateOffset(this,!0)}return this},u.subtract=Qe,u.toArray=function(){var e=this;return[e.year(),e.month(),e.date(),e.hour(),e.minute(),e.second(),e.millisecond()]},u.toObject=function(){var e=this;return{years:e.year(),months:e.month(),date:e.date(),hours:e.hours(),minutes:e.minutes(),seconds:e.seconds(),milliseconds:e.milliseconds()}},u.toDate=function(){return new Date(this.valueOf())},u.toISOString=function(e){var t;return this.isValid()?(t=(e=!0!==e)?this.clone().utc():this).year()<0||9999<t.year()?re(t,e?"YYYYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYYYY-MM-DD[T]HH:mm:ss.SSSZ"):a(Date.prototype.toISOString)?e?this.toDate().toISOString():new Date(this.valueOf()+60*this.utcOffset()*1e3).toISOString().replace("Z",re(t,"Z")):re(t,e?"YYYY-MM-DD[T]HH:mm:ss.SSS[Z]":"YYYY-MM-DD[T]HH:mm:ss.SSSZ"):null},u.inspect=function(){var e,t,n;return this.isValid()?(t="moment",e="",this.isLocal()||(t=0===this.utcOffset()?"moment.utc":"moment.parseZone",e="Z"),t="["+t+'("]',n=0<=this.year()&&this.year()<=9999?"YYYY":"YYYYYY",this.format(t+n+"-MM-DD[T]HH:mm:ss.SSS"+(e+'[")]'))):"moment.invalid(/* "+this._i+" */)"},"undefined"!=typeof Symbol&&null!=Symbol.for&&(u[Symbol.for("nodejs.util.inspect.custom")]=function(){return"Moment<"+this.format()+">"}),u.toJSON=function(){return this.isValid()?this.toISOString():null},u.toString=function(){return this.clone().locale("en").format("ddd MMM DD YYYY HH:mm:ss [GMT]ZZ")},u.unix=function(){return Math.floor(this.valueOf()/1e3)},u.valueOf=function(){return this._d.valueOf()-6e4*(this._offset||0)},u.creationData=function(){return{input:this._i,format:this._f,locale:this._locale,isUTC:this._isUTC,strict:this._strict}},u.eraName=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].name;if(t[n].until<=e&&e<=t[n].since)return t[n].name}return""},u.eraNarrow=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].narrow;if(t[n].until<=e&&e<=t[n].since)return t[n].narrow}return""},u.eraAbbr=function(){for(var e,t=this.localeData().eras(),n=0,s=t.length;n<s;++n){if(e=this.clone().startOf("day").valueOf(),t[n].since<=e&&e<=t[n].until)return t[n].abbr;if(t[n].until<=e&&e<=t[n].since)return t[n].abbr}return""},u.eraYear=function(){for(var e,t,n=this.localeData().eras(),s=0,i=n.length;s<i;++s)if(e=n[s].since<=n[s].until?1:-1,t=this.clone().startOf("day").valueOf(),n[s].since<=t&&t<=n[s].until||n[s].until<=t&&t<=n[s].since)return(this.year()-_(n[s].since).year())*e+n[s].offset;return this.year()},u.year=Pe,u.isLeapYear=function(){return be(this.year())},u.weekYear=function(e){return un.call(this,e,this.week(),this.weekday()+this.localeData()._week.dow,this.localeData()._week.dow,this.localeData()._week.doy)},u.isoWeekYear=function(e){return un.call(this,e,this.isoWeek(),this.isoWeekday(),1,4)},u.quarter=u.quarters=function(e){return null==e?Math.ceil((this.month()+1)/3):this.month(3*(e-1)+this.month()%3)},u.month=Ie,u.daysInMonth=function(){return He(this.year(),this.month())},u.week=u.weeks=function(e){var t=this.localeData().week(this);return null==e?t:this.add(7*(e-t),"d")},u.isoWeek=u.isoWeeks=function(e){var t=Be(this,1,4).week;return null==e?t:this.add(7*(e-t),"d")},u.weeksInYear=function(){var e=this.localeData()._week;return N(this.year(),e.dow,e.doy)},u.weeksInWeekYear=function(){var e=this.localeData()._week;return N(this.weekYear(),e.dow,e.doy)},u.isoWeeksInYear=function(){return N(this.year(),1,4)},u.isoWeeksInISOWeekYear=function(){return N(this.isoWeekYear(),1,4)},u.date=ge,u.day=u.days=function(e){var t,n,s;return this.isValid()?(t=Ce(this,"Day"),null!=e?(n=e,s=this.localeData(),e="string"!=typeof n?n:isNaN(n)?"number"==typeof(n=s.weekdaysParse(n))?n:null:parseInt(n,10),this.add(e-t,"d")):t):null!=e?this:NaN},u.weekday=function(e){var t;return this.isValid()?(t=(this.day()+7-this.localeData()._week.dow)%7,null==e?t:this.add(e-t,"d")):null!=e?this:NaN},u.isoWeekday=function(e){var t,n;return this.isValid()?null!=e?(t=e,n=this.localeData(),n="string"==typeof t?n.weekdaysParse(t)%7||7:isNaN(t)?null:t,this.day(this.day()%7?n:n-7)):this.day()||7:null!=e?this:NaN},u.dayOfYear=function(e){var t=Math.round((this.clone().startOf("day")-this.clone().startOf("year"))/864e5)+1;return null==e?t:this.add(e-t,"d")},u.hour=u.hours=i,u.minute=u.minutes=ce,u.second=u.seconds=we,u.millisecond=u.milliseconds=fe,u.utcOffset=function(e,t,n){var s,i=this._offset||0;if(!this.isValid())return null!=e?this:NaN;if(null==e)return this._isUTC?i:Et(this);if("string"==typeof e){if(null===(e=Vt(ve,e)))return this}else Math.abs(e)<16&&!n&&(e*=60);return!this._isUTC&&t&&(s=Et(this)),this._offset=e,this._isUTC=!0,null!=s&&this.add(s,"m"),i!==e&&(!t||this._changeInProgress?$t(this,C(e-i,"m"),1,!1):this._changeInProgress||(this._changeInProgress=!0,_.updateOffset(this,!0),this._changeInProgress=null)),this},u.utc=function(e){return this.utcOffset(0,e)},u.local=function(e){return this._isUTC&&(this.utcOffset(0,e),this._isUTC=!1,e)&&this.subtract(Et(this),"m"),this},u.parseZone=function(){var e;return null!=this._tzm?this.utcOffset(this._tzm,!1,!0):"string"==typeof this._i&&(null!=(e=Vt(Me,this._i))?this.utcOffset(e):this.utcOffset(0,!0)),this},u.hasAlignedHourOffset=function(e){return!!this.isValid()&&(e=e?R(e).utcOffset():0,(this.utcOffset()-e)%60==0)},u.isDST=function(){return this.utcOffset()>this.clone().month(0).utcOffset()||this.utcOffset()>this.clone().month(5).utcOffset()},u.isLocal=function(){return!!this.isValid()&&!this._isUTC},u.isUtcOffset=function(){return!!this.isValid()&&this._isUTC},u.isUtc=At,u.isUTC=At,u.zoneAbbr=function(){return this._isUTC?"UTC":""},u.zoneName=function(){return this._isUTC?"Coordinated Universal Time":""},u.dates=e("dates accessor is deprecated. Use date instead.",ge),u.months=e("months accessor is deprecated. Use month instead",Ie),u.years=e("years accessor is deprecated. Use year instead",Pe),u.zone=e("moment().zone is deprecated, use moment().utcOffset instead. http://momentjs.com/guides/#/warnings/zone/",function(e,t){return null!=e?(this.utcOffset(e="string"!=typeof e?-e:e,t),this):-this.utcOffset()}),u.isDSTShifted=e("isDSTShifted is deprecated. See http://momentjs.com/guides/#/warnings/dst-shifted/ for more information",function(){var e,t;return g(this._isDSTShifted)&&(q(e={},this),(e=Nt(e))._a?(t=(e._isUTC?l:R)(e._a),this._isDSTShifted=this.isValid()&&0<function(e,t,n){for(var s=Math.min(e.length,t.length),i=Math.abs(e.length-t.length),r=0,a=0;a<s;a++)(n&&e[a]!==t[a]||!n&&M(e[a])!==M(t[a]))&&r++;return r+i}(e._a,t.toArray())):this._isDSTShifted=!1),this._isDSTShifted});d=K.prototype;function cn(e,t,n,s){var i=P(),s=l().set(s,t);return i[n](s,e)}function fn(e,t,n){if(w(e)&&(t=e,e=void 0),e=e||"",null!=t)return cn(e,t,n,"month");for(var s=[],i=0;i<12;i++)s[i]=cn(e,i,n,"month");return s}function mn(e,t,n,s){t=("boolean"==typeof e?w(t)&&(n=t,t=void 0):(t=e,e=!1,w(n=t)&&(n=t,t=void 0)),t||"");var i,r=P(),a=e?r._week.dow:0,o=[];if(null!=n)return cn(t,(n+a)%7,s,"day");for(i=0;i<7;i++)o[i]=cn(t,(i+a)%7,s,"day");return o}d.calendar=function(e,t,n){return a(e=this._calendar[e]||this._calendar.sameElse)?e.call(t,n):e},d.longDateFormat=function(e){var t=this._longDateFormat[e],n=this._longDateFormat[e.toUpperCase()];return t||!n?t:(this._longDateFormat[e]=n.match(te).map(function(e){return"MMMM"===e||"MM"===e||"DD"===e||"dddd"===e?e.slice(1):e}).join(""),this._longDateFormat[e])},d.invalidDate=function(){return this._invalidDate},d.ordinal=function(e){return this._ordinal.replace("%d",e)},d.preparse=hn,d.postformat=hn,d.relativeTime=function(e,t,n,s){var i=this._relativeTime[n];return a(i)?i(e,t,n,s):i.replace(/%d/i,e)},d.pastFuture=function(e,t){return a(e=this._relativeTime[0<e?"future":"past"])?e(t):e.replace(/%s/i,t)},d.set=function(e){var t,n;for(n in e)c(e,n)&&(a(t=e[n])?this[n]=t:this["_"+n]=t);this._config=e,this._dayOfMonthOrdinalParseLenient=new RegExp((this._dayOfMonthOrdinalParse.source||this._ordinalParse.source)+"|"+/\d{1,2}/.source)},d.eras=function(e,t){for(var n,s=this._eras||P("en")._eras,i=0,r=s.length;i<r;++i){switch(typeof s[i].since){case"string":n=_(s[i].since).startOf("day"),s[i].since=n.valueOf();break}switch(typeof s[i].until){case"undefined":s[i].until=1/0;break;case"string":n=_(s[i].until).startOf("day").valueOf(),s[i].until=n.valueOf();break}}return s},d.erasParse=function(e,t,n){var s,i,r,a,o,u=this.eras();for(e=e.toUpperCase(),s=0,i=u.length;s<i;++s)if(r=u[s].name.toUpperCase(),a=u[s].abbr.toUpperCase(),o=u[s].narrow.toUpperCase(),n)switch(t){case"N":case"NN":case"NNN":if(a===e)return u[s];break;case"NNNN":if(r===e)return u[s];break;case"NNNNN":if(o===e)return u[s];break}else if(0<=[r,a,o].indexOf(e))return u[s]},d.erasConvertYear=function(e,t){var n=e.since<=e.until?1:-1;return void 0===t?_(e.since).year():_(e.since).year()+(t-e.offset)*n},d.erasAbbrRegex=function(e){return c(this,"_erasAbbrRegex")||an.call(this),e?this._erasAbbrRegex:this._erasRegex},d.erasNameRegex=function(e){return c(this,"_erasNameRegex")||an.call(this),e?this._erasNameRegex:this._erasRegex},d.erasNarrowRegex=function(e){return c(this,"_erasNarrowRegex")||an.call(this),e?this._erasNarrowRegex:this._erasRegex},d.months=function(e,t){return e?(y(this._months)?this._months:this._months[(this._months.isFormat||Ve).test(t)?"format":"standalone"])[e.month()]:y(this._months)?this._months:this._months.standalone},d.monthsShort=function(e,t){return e?(y(this._monthsShort)?this._monthsShort:this._monthsShort[Ve.test(t)?"format":"standalone"])[e.month()]:y(this._monthsShort)?this._monthsShort:this._monthsShort.standalone},d.monthsParse=function(e,t,n){var s,i;if(this._monthsParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._monthsParse)for(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[],s=0;s<12;++s)r=l([2e3,s]),this._shortMonthsParse[s]=this.monthsShort(r,"").toLocaleLowerCase(),this._longMonthsParse[s]=this.months(r,"").toLocaleLowerCase();return n?"MMM"===t?-1!==(i=x.call(this._shortMonthsParse,e))?i:null:-1!==(i=x.call(this._longMonthsParse,e))?i:null:"MMM"===t?-1!==(i=x.call(this._shortMonthsParse,e))||-1!==(i=x.call(this._longMonthsParse,e))?i:null:-1!==(i=x.call(this._longMonthsParse,e))||-1!==(i=x.call(this._shortMonthsParse,e))?i:null}.call(this,e,t,n);for(this._monthsParse||(this._monthsParse=[],this._longMonthsParse=[],this._shortMonthsParse=[]),s=0;s<12;s++){if(i=l([2e3,s]),n&&!this._longMonthsParse[s]&&(this._longMonthsParse[s]=new RegExp("^"+this.months(i,"").replace(".","")+"$","i"),this._shortMonthsParse[s]=new RegExp("^"+this.monthsShort(i,"").replace(".","")+"$","i")),n||this._monthsParse[s]||(i="^"+this.months(i,"")+"|^"+this.monthsShort(i,""),this._monthsParse[s]=new RegExp(i.replace(".",""),"i")),n&&"MMMM"===t&&this._longMonthsParse[s].test(e))return s;if(n&&"MMM"===t&&this._shortMonthsParse[s].test(e))return s;if(!n&&this._monthsParse[s].test(e))return s}},d.monthsRegex=function(e){return this._monthsParseExact?(c(this,"_monthsRegex")||je.call(this),e?this._monthsStrictRegex:this._monthsRegex):(c(this,"_monthsRegex")||(this._monthsRegex=Ee),this._monthsStrictRegex&&e?this._monthsStrictRegex:this._monthsRegex)},d.monthsShortRegex=function(e){return this._monthsParseExact?(c(this,"_monthsRegex")||je.call(this),e?this._monthsShortStrictRegex:this._monthsShortRegex):(c(this,"_monthsShortRegex")||(this._monthsShortRegex=Ge),this._monthsShortStrictRegex&&e?this._monthsShortStrictRegex:this._monthsShortRegex)},d.week=function(e){return Be(e,this._week.dow,this._week.doy).week},d.firstDayOfYear=function(){return this._week.doy},d.firstDayOfWeek=function(){return this._week.dow},d.weekdays=function(e,t){return t=y(this._weekdays)?this._weekdays:this._weekdays[e&&!0!==e&&this._weekdays.isFormat.test(t)?"format":"standalone"],!0===e?Je(t,this._week.dow):e?t[e.day()]:t},d.weekdaysMin=function(e){return!0===e?Je(this._weekdaysMin,this._week.dow):e?this._weekdaysMin[e.day()]:this._weekdaysMin},d.weekdaysShort=function(e){return!0===e?Je(this._weekdaysShort,this._week.dow):e?this._weekdaysShort[e.day()]:this._weekdaysShort},d.weekdaysParse=function(e,t,n){var s,i;if(this._weekdaysParseExact)return function(e,t,n){var s,i,r,e=e.toLocaleLowerCase();if(!this._weekdaysParse)for(this._weekdaysParse=[],this._shortWeekdaysParse=[],this._minWeekdaysParse=[],s=0;s<7;++s)r=l([2e3,1]).day(s),this._minWeekdaysParse[s]=this.weekdaysMin(r,"").toLocaleLowerCase(),this._shortWeekdaysParse[s]=this.weekdaysShort(r,"").toLocaleLowerCase(),this._weekdaysParse[s]=this.weekdays(r,"").toLocaleLowerCase();return n?"dddd"===t?-1!==(i=x.call(this._weekdaysParse,e))?i:null:"ddd"===t?-1!==(i=x.call(this._shortWeekdaysParse,e))?i:null:-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:"dddd"===t?-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._shortWeekdaysParse,e))||-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:"ddd"===t?-1!==(i=x.call(this._shortWeekdaysParse,e))||-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._minWeekdaysParse,e))?i:null:-1!==(i=x.call(this._minWeekdaysParse,e))||-1!==(i=x.call(this._weekdaysParse,e))||-1!==(i=x.call(this._shortWeekdaysParse,e))?i:null}.call(this,e,t,n);for(this._weekdaysParse||(this._weekdaysParse=[],this._minWeekdaysParse=[],this._shortWeekdaysParse=[],this._fullWeekdaysParse=[]),s=0;s<7;s++){if(i=l([2e3,1]).day(s),n&&!this._fullWeekdaysParse[s]&&(this._fullWeekdaysParse[s]=new RegExp("^"+this.weekdays(i,"").replace(".","\\.?")+"$","i"),this._shortWeekdaysParse[s]=new RegExp("^"+this.weekdaysShort(i,"").replace(".","\\.?")+"$","i"),this._minWeekdaysParse[s]=new RegExp("^"+this.weekdaysMin(i,"").replace(".","\\.?")+"$","i")),this._weekdaysParse[s]||(i="^"+this.weekdays(i,"")+"|^"+this.weekdaysShort(i,"")+"|^"+this.weekdaysMin(i,""),this._weekdaysParse[s]=new RegExp(i.replace(".",""),"i")),n&&"dddd"===t&&this._fullWeekdaysParse[s].test(e))return s;if(n&&"ddd"===t&&this._shortWeekdaysParse[s].test(e))return s;if(n&&"dd"===t&&this._minWeekdaysParse[s].test(e))return s;if(!n&&this._weekdaysParse[s].test(e))return s}},d.weekdaysRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysStrictRegex:this._weekdaysRegex):(c(this,"_weekdaysRegex")||(this._weekdaysRegex=et),this._weekdaysStrictRegex&&e?this._weekdaysStrictRegex:this._weekdaysRegex)},d.weekdaysShortRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex):(c(this,"_weekdaysShortRegex")||(this._weekdaysShortRegex=tt),this._weekdaysShortStrictRegex&&e?this._weekdaysShortStrictRegex:this._weekdaysShortRegex)},d.weekdaysMinRegex=function(e){return this._weekdaysParseExact?(c(this,"_weekdaysRegex")||st.call(this),e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex):(c(this,"_weekdaysMinRegex")||(this._weekdaysMinRegex=nt),this._weekdaysMinStrictRegex&&e?this._weekdaysMinStrictRegex:this._weekdaysMinRegex)},d.isPM=function(e){return"p"===(e+"").toLowerCase().charAt(0)},d.meridiem=function(e,t,n){return 11<e?n?"pm":"PM":n?"am":"AM"},ft("en",{eras:[{since:"0001-01-01",until:1/0,offset:1,name:"Anno Domini",narrow:"AD",abbr:"AD"},{since:"0000-12-31",until:-1/0,offset:1,name:"Before Christ",narrow:"BC",abbr:"BC"}],dayOfMonthOrdinalParse:/\d{1,2}(th|st|nd|rd)/,ordinal:function(e){var t=e%10;return e+(1===M(e%100/10)?"th":1==t?"st":2==t?"nd":3==t?"rd":"th")}}),_.lang=e("moment.lang is deprecated. Use moment.locale instead.",ft),_.langData=e("moment.langData is deprecated. Use moment.localeData instead.",P);var _n=Math.abs;function yn(e,t,n,s){t=C(t,n);return e._milliseconds+=s*t._milliseconds,e._days+=s*t._days,e._months+=s*t._months,e._bubble()}function gn(e){return e<0?Math.floor(e):Math.ceil(e)}function wn(e){return 4800*e/146097}function pn(e){return 146097*e/4800}function kn(e){return function(){return this.as(e)}}de=kn("ms"),t=kn("s"),ye=kn("m"),he=kn("h"),Fe=kn("d"),_e=kn("w"),me=kn("M"),Qe=kn("Q"),i=kn("y"),ce=de;function Mn(e){return function(){return this.isValid()?this._data[e]:NaN}}var we=Mn("milliseconds"),fe=Mn("seconds"),ge=Mn("minutes"),Pe=Mn("hours"),d=Mn("days"),vn=Mn("months"),Dn=Mn("years");var Yn=Math.round,Sn={ss:44,s:45,m:45,h:22,d:26,w:null,M:11};function On(e,t,n,s){var i=C(e).abs(),r=Yn(i.as("s")),a=Yn(i.as("m")),o=Yn(i.as("h")),u=Yn(i.as("d")),l=Yn(i.as("M")),d=Yn(i.as("w")),i=Yn(i.as("y")),r=(r<=n.ss?["s",r]:r<n.s&&["ss",r])||(a<=1?["m"]:a<n.m&&["mm",a])||(o<=1?["h"]:o<n.h&&["hh",o])||(u<=1?["d"]:u<n.d&&["dd",u]);return(r=(r=null!=n.w?r||(d<=1?["w"]:d<n.w&&["ww",d]):r)||(l<=1?["M"]:l<n.M&&["MM",l])||(i<=1?["y"]:["yy",i]))[2]=t,r[3]=0<+e,r[4]=s,function(e,t,n,s,i){return i.relativeTime(t||1,!!n,e,s)}.apply(null,r)}var bn=Math.abs;function Tn(e){return(0<e)-(e<0)||+e}function xn(){var e,t,n,s,i,r,a,o,u,l,d;return this.isValid()?(e=bn(this._milliseconds)/1e3,t=bn(this._days),n=bn(this._months),(o=this.asSeconds())?(s=m(e/60),i=m(s/60),e%=60,s%=60,r=m(n/12),n%=12,a=e?e.toFixed(3).replace(/\.?0+$/,""):"",u=Tn(this._months)!==Tn(o)?"-":"",l=Tn(this._days)!==Tn(o)?"-":"",d=Tn(this._milliseconds)!==Tn(o)?"-":"",(o<0?"-":"")+"P"+(r?u+r+"Y":"")+(n?u+n+"M":"")+(t?l+t+"D":"")+(i||s||e?"T":"")+(i?d+i+"H":"")+(s?d+s+"M":"")+(e?d+a+"S":"")):"P0D"):this.localeData().invalidDate()}var U=Ct.prototype;return U.isValid=function(){return this._isValid},U.abs=function(){var e=this._data;return this._milliseconds=_n(this._milliseconds),this._days=_n(this._days),this._months=_n(this._months),e.milliseconds=_n(e.milliseconds),e.seconds=_n(e.seconds),e.minutes=_n(e.minutes),e.hours=_n(e.hours),e.months=_n(e.months),e.years=_n(e.years),this},U.add=function(e,t){return yn(this,e,t,1)},U.subtract=function(e,t){return yn(this,e,t,-1)},U.as=function(e){if(!this.isValid())return NaN;var t,n,s=this._milliseconds;if("month"===(e=o(e))||"quarter"===e||"year"===e)switch(t=this._days+s/864e5,n=this._months+wn(t),e){case"month":return n;case"quarter":return n/3;case"year":return n/12}else switch(t=this._days+Math.round(pn(this._months)),e){case"week":return t/7+s/6048e5;case"day":return t+s/864e5;case"hour":return 24*t+s/36e5;case"minute":return 1440*t+s/6e4;case"second":return 86400*t+s/1e3;case"millisecond":return Math.floor(864e5*t)+s;default:throw new Error("Unknown unit "+e)}},U.asMilliseconds=de,U.asSeconds=t,U.asMinutes=ye,U.asHours=he,U.asDays=Fe,U.asWeeks=_e,U.asMonths=me,U.asQuarters=Qe,U.asYears=i,U.valueOf=ce,U._bubble=function(){var e=this._milliseconds,t=this._days,n=this._months,s=this._data;return 0<=e&&0<=t&&0<=n||e<=0&&t<=0&&n<=0||(e+=864e5*gn(pn(n)+t),n=t=0),s.milliseconds=e%1e3,e=m(e/1e3),s.seconds=e%60,e=m(e/60),s.minutes=e%60,e=m(e/60),s.hours=e%24,t+=m(e/24),n+=e=m(wn(t)),t-=gn(pn(e)),e=m(n/12),n%=12,s.days=t,s.months=n,s.years=e,this},U.clone=function(){return C(this)},U.get=function(e){return e=o(e),this.isValid()?this[e+"s"]():NaN},U.milliseconds=we,U.seconds=fe,U.minutes=ge,U.hours=Pe,U.days=d,U.weeks=function(){return m(this.days()/7)},U.months=vn,U.years=Dn,U.humanize=function(e,t){var n,s;return this.isValid()?(n=!1,s=Sn,"object"==typeof e&&(t=e,e=!1),"boolean"==typeof e&&(n=e),"object"==typeof t&&(s=Object.assign({},Sn,t),null!=t.s)&&null==t.ss&&(s.ss=t.s-1),e=this.localeData(),t=On(this,!n,s,e),n&&(t=e.pastFuture(+this,t)),e.postformat(t)):this.localeData().invalidDate()},U.toISOString=xn,U.toString=xn,U.toJSON=xn,U.locale=Xt,U.localeData=Kt,U.toIsoString=e("toIsoString() is deprecated. Please use toISOString() instead (notice the capitals)",xn),U.lang=Ke,s("X",0,0,"unix"),s("x",0,0,"valueOf"),h("x",ke),h("X",/[+-]?\d+(\.\d{1,3})?/),v("X",function(e,t,n){n._d=new Date(1e3*parseFloat(e))}),v("x",function(e,t,n){n._d=new Date(M(e))}),_.version="2.30.1",H=R,_.fn=u,_.min=function(){return Pt("isBefore",[].slice.call(arguments,0))},_.max=function(){return Pt("isAfter",[].slice.call(arguments,0))},_.now=function(){return Date.now?Date.now():+new Date},_.utc=l,_.unix=function(e){return R(1e3*e)},_.months=function(e,t){return fn(e,t,"months")},_.isDate=V,_.locale=ft,_.invalid=I,_.duration=C,_.isMoment=k,_.weekdays=function(e,t,n){return mn(e,t,n,"weekdays")},_.parseZone=function(){return R.apply(null,arguments).parseZone()},_.localeData=P,_.isDuration=Ut,_.monthsShort=function(e,t){return fn(e,t,"monthsShort")},_.weekdaysMin=function(e,t,n){return mn(e,t,n,"weekdaysMin")},_.defineLocale=mt,_.updateLocale=function(e,t){var n,s;return null!=t?(s=ut,null!=W[e]&&null!=W[e].parentLocale?W[e].set(X(W[e]._config,t)):(t=X(s=null!=(n=ct(e))?n._config:s,t),null==n&&(t.abbr=e),(s=new K(t)).parentLocale=W[e],W[e]=s),ft(e)):null!=W[e]&&(null!=W[e].parentLocale?(W[e]=W[e].parentLocale,e===ft()&&ft(e)):null!=W[e]&&delete W[e]),W[e]},_.locales=function(){return ee(W)},_.weekdaysShort=function(e,t,n){return mn(e,t,n,"weekdaysShort")},_.normalizeUnits=o,_.relativeTimeRounding=function(e){return void 0===e?Yn:"function"==typeof e&&(Yn=e,!0)},_.relativeTimeThreshold=function(e,t){return void 0!==Sn[e]&&(void 0===t?Sn[e]:(Sn[e]=t,"s"===e&&(Sn.ss=t-1),!0))},_.calendarFormat=function(e,t){return(e=e.diff(t,"days",!0))<-6?"sameElse":e<-1?"lastWeek":e<0?"lastDay":e<1?"sameDay":e<2?"nextDay":e<7?"nextWeek":"sameElse"},_.prototype=u,_.HTML5_FMT={DATETIME_LOCAL:"YYYY-MM-DDTHH:mm",DATETIME_LOCAL_SECONDS:"YYYY-MM-DDTHH:mm:ss",DATETIME_LOCAL_MS:"YYYY-MM-DDTHH:mm:ss.SSS",DATE:"YYYY-MM-DD",TIME:"HH:mm",TIME_SECONDS:"HH:mm:ss",TIME_MS:"HH:mm:ss.SSS",WEEK:"GGGG-[W]WW",MONTH:"YYYY-MM"},_});(function(root,factory){if(typeof define==='function'&&define.amd){define(["jquery"],function($){return(root.returnExportsGlobal=factory($))})}else if(typeof exports==='object'){module.exports=factory(require("jquery"))}else{factory(jQuery)}}(this,function($){"use strict";var EditableCaret,InputCaret,Mirror,Utils,discoveryIframeOf,methods,oDocument,oFrame,oWindow,pluginName,setContextBy;pluginName='caret';EditableCaret=(function(){function EditableCaret($inputor){this.$inputor=$inputor;this.domInputor=this.$inputor[0]}
EditableCaret.prototype.setPos=function(pos){var fn,found,offset,sel;if(sel=oWindow.getSelection()){offset=0;found=!1;(fn=function(pos,parent){var node,range,_i,_len,_ref,_results;_ref=parent.childNodes;_results=[];for(_i=0,_len=_ref.length;_i<_len;_i++){node=_ref[_i];if(found){break}
if(node.nodeType===3){if(offset+node.length>=pos){found=!0;range=oDocument.createRange();range.setStart(node,pos-offset);sel.removeAllRanges();sel.addRange(range);break}else{_results.push(offset+=node.length)}}else{_results.push(fn(pos,node))}}
return _results})(pos,this.domInputor)}
return this.domInputor};EditableCaret.prototype.getIEPosition=function(){return this.getPosition()};EditableCaret.prototype.getPosition=function(){var inputor_offset,offset;offset=this.getOffset();inputor_offset=this.$inputor.offset();offset.left-=inputor_offset.left;offset.top-=inputor_offset.top;return offset};EditableCaret.prototype.getOldIEPos=function(){var preCaretTextRange,textRange;textRange=oDocument.selection.createRange();preCaretTextRange=oDocument.body.createTextRange();preCaretTextRange.moveToElementText(this.domInputor);preCaretTextRange.setEndPoint("EndToEnd",textRange);return preCaretTextRange.text.length};EditableCaret.prototype.getPos=function(){var clonedRange,pos,range;if(range=this.range()){clonedRange=range.cloneRange();clonedRange.selectNodeContents(this.domInputor);clonedRange.setEnd(range.endContainer,range.endOffset);pos=clonedRange.toString().length;clonedRange.detach();return pos}else if(oDocument.selection){return this.getOldIEPos()}};EditableCaret.prototype.getOldIEOffset=function(){var range,rect;range=oDocument.selection.createRange().duplicate();range.moveStart("character",-1);rect=range.getBoundingClientRect();return{height:rect.bottom-rect.top,left:rect.left,top:rect.top}};EditableCaret.prototype.getOffset=function(pos){var clonedRange,offset,range,rect,shadowCaret;if(oWindow.getSelection&&(range=this.range())){if(range.endOffset-1>0&&range.endContainer!==this.domInputor){clonedRange=range.cloneRange();clonedRange.setStart(range.endContainer,range.endOffset-1);clonedRange.setEnd(range.endContainer,range.endOffset);rect=clonedRange.getBoundingClientRect();offset={height:rect.height,left:rect.left+rect.width,top:rect.top};clonedRange.detach()}
if(!offset||(offset!=null?offset.height:void 0)===0){clonedRange=range.cloneRange();shadowCaret=$(oDocument.createTextNode("|"));clonedRange.insertNode(shadowCaret[0]);clonedRange.selectNode(shadowCaret[0]);rect=clonedRange.getBoundingClientRect();offset={height:rect.height,left:rect.left,top:rect.top};shadowCaret.remove();clonedRange.detach()}}else if(oDocument.selection){offset=this.getOldIEOffset()}
if(offset){offset.top+=$(oWindow).scrollTop();offset.left+=$(oWindow).scrollLeft()}
return offset};EditableCaret.prototype.range=function(){var sel;if(!oWindow.getSelection){return}
sel=oWindow.getSelection();if(sel.rangeCount>0){return sel.getRangeAt(0)}else{return null}};return EditableCaret})();InputCaret=(function(){function InputCaret($inputor){this.$inputor=$inputor;this.domInputor=this.$inputor[0]}
InputCaret.prototype.getIEPos=function(){var endRange,inputor,len,normalizedValue,pos,range,textInputRange;inputor=this.domInputor;range=oDocument.selection.createRange();pos=0;if(range&&range.parentElement()===inputor){normalizedValue=inputor.value.replace(/\r\n/g,"\n");len=normalizedValue.length;textInputRange=inputor.createTextRange();textInputRange.moveToBookmark(range.getBookmark());endRange=inputor.createTextRange();endRange.collapse(!1);if(textInputRange.compareEndPoints("StartToEnd",endRange)>-1){pos=len}else{pos=-textInputRange.moveStart("character",-len)}}
return pos};InputCaret.prototype.getPos=function(){if(oDocument.selection){return this.getIEPos()}else{return this.domInputor.selectionStart}};InputCaret.prototype.setPos=function(pos){var inputor,range;inputor=this.domInputor;if(oDocument.selection){range=inputor.createTextRange();range.move("character",pos);range.select()}else if(inputor.setSelectionRange){inputor.setSelectionRange(pos,pos)}
return inputor};InputCaret.prototype.getIEOffset=function(pos){var h,textRange,x,y;textRange=this.domInputor.createTextRange();pos||(pos=this.getPos());textRange.move('character',pos);x=textRange.boundingLeft;y=textRange.boundingTop;h=textRange.boundingHeight;return{left:x,top:y,height:h}};InputCaret.prototype.getOffset=function(pos){var $inputor,offset,position;$inputor=this.$inputor;if(oDocument.selection){offset=this.getIEOffset(pos);offset.top+=$(oWindow).scrollTop()+$inputor.scrollTop();offset.left+=$(oWindow).scrollLeft()+$inputor.scrollLeft();return offset}else{offset=$inputor.offset();position=this.getPosition(pos);return offset={left:offset.left+position.left-$inputor.scrollLeft(),top:offset.top+position.top-$inputor.scrollTop(),height:position.height}}};InputCaret.prototype.getPosition=function(pos){var $inputor,at_rect,end_range,format,html,mirror,start_range;$inputor=this.$inputor;format=function(value){value=value.replace(/<|>|`|"|&/g,'?').replace(/\r\n|\r|\n/g,"<br/>");if(/firefox/i.test(navigator.userAgent)){value=value.replace(/\s/g,'&nbsp;')}
return value};if(pos===void 0){pos=this.getPos()}
start_range=$inputor.val().slice(0,pos);end_range=$inputor.val().slice(pos);html="<span style='position: relative; display: inline;'>"+format(start_range)+"</span>";html+="<span id='caret' style='position: relative; display: inline;'>|</span>";html+="<span style='position: relative; display: inline;'>"+format(end_range)+"</span>";mirror=new Mirror($inputor);return at_rect=mirror.create(html).rect()};InputCaret.prototype.getIEPosition=function(pos){var h,inputorOffset,offset,x,y;offset=this.getIEOffset(pos);inputorOffset=this.$inputor.offset();x=offset.left-inputorOffset.left;y=offset.top-inputorOffset.top;h=offset.height;return{left:x,top:y,height:h}};return InputCaret})();Mirror=(function(){Mirror.prototype.css_attr=["borderBottomWidth","borderLeftWidth","borderRightWidth","borderTopStyle","borderRightStyle","borderBottomStyle","borderLeftStyle","borderTopWidth","boxSizing","fontFamily","fontSize","fontWeight","height","letterSpacing","lineHeight","marginBottom","marginLeft","marginRight","marginTop","outlineWidth","overflow","overflowX","overflowY","paddingBottom","paddingLeft","paddingRight","paddingTop","textAlign","textOverflow","textTransform","whiteSpace","wordBreak","wordWrap"];function Mirror($inputor){this.$inputor=$inputor}
Mirror.prototype.mirrorCss=function(){var css,_this=this;css={position:'absolute',left:-9999,top:0,zIndex:-20000};if(this.$inputor.prop('tagName')==='TEXTAREA'){this.css_attr.push('width')}
$.each(this.css_attr,function(i,p){return css[p]=_this.$inputor.css(p)});return css};Mirror.prototype.create=function(html){this.$mirror=$('<div></div>');this.$mirror.css(this.mirrorCss());this.$mirror.html(html);this.$inputor.after(this.$mirror);return this};Mirror.prototype.rect=function(){var $flag,pos,rect;$flag=this.$mirror.find("#caret");pos=$flag.position();rect={left:pos.left,top:pos.top,height:$flag.height()};this.$mirror.remove();return rect};return Mirror})();Utils={contentEditable:function($inputor){return!!($inputor[0].contentEditable&&$inputor[0].contentEditable==='true')}};methods={pos:function(pos){if(pos||pos===0){return this.setPos(pos)}else{return this.getPos()}},position:function(pos){if(oDocument.selection){return this.getIEPosition(pos)}else{return this.getPosition(pos)}},offset:function(pos){var offset;offset=this.getOffset(pos);return offset}};oDocument=null;oWindow=null;oFrame=null;setContextBy=function(settings){var iframe;if(iframe=settings!=null?settings.iframe:void 0){oFrame=iframe;oWindow=iframe.contentWindow;return oDocument=iframe.contentDocument||oWindow.document}else{oFrame=void 0;oWindow=window;return oDocument=document}};discoveryIframeOf=function($dom){var error;oDocument=$dom[0].ownerDocument;oWindow=oDocument.defaultView||oDocument.parentWindow;try{return oFrame=oWindow.frameElement}catch(_error){error=_error}};$.fn.caret=function(method,value,settings){var caret;if(methods[method]){if($.isPlainObject(value)){setContextBy(value);value=void 0}else{setContextBy(settings)}
caret=Utils.contentEditable(this)?new EditableCaret(this):new InputCaret(this);return methods[method].apply(caret,[value])}else{return $.error("Method "+method+" does not exist on jQuery.caret")}};$.fn.caret.EditableCaret=EditableCaret;$.fn.caret.InputCaret=InputCaret;$.fn.caret.Utils=Utils;$.fn.caret.apis=methods}));(function(global,factory){typeof exports==='object'&&typeof module!=='undefined'?module.exports=factory():typeof define==='function'&&define.amd?define(factory):(global=global||self,global.CodeMirror=factory())}(this,(function(){'use strict';var userAgent=navigator.userAgent;var platform=navigator.platform;var gecko=/gecko\/\d/i.test(userAgent);var ie_upto10=/MSIE \d/.test(userAgent);var ie_11up=/Trident\/(?:[7-9]|\d{2,})\..*rv:(\d+)/.exec(userAgent);var edge=/Edge\/(\d+)/.exec(userAgent);var ie=ie_upto10||ie_11up||edge;var ie_version=ie&&(ie_upto10?document.documentMode||6:+(edge||ie_11up)[1]);var webkit=!edge&&/WebKit\//.test(userAgent);var qtwebkit=webkit&&/Qt\/\d+\.\d+/.test(userAgent);var chrome=!edge&&/Chrome\/(\d+)/.exec(userAgent);var chrome_version=chrome&&+chrome[1];var presto=/Opera\//.test(userAgent);var safari=/Apple Computer/.test(navigator.vendor);var mac_geMountainLion=/Mac OS X 1\d\D([8-9]|\d\d)\D/.test(userAgent);var phantom=/PhantomJS/.test(userAgent);var ios=safari&&(/Mobile\/\w+/.test(userAgent)||navigator.maxTouchPoints>2);var android=/Android/.test(userAgent);var mobile=ios||android||/webOS|BlackBerry|Opera Mini|Opera Mobi|IEMobile/i.test(userAgent);var mac=ios||/Mac/.test(platform);var chromeOS=/\bCrOS\b/.test(userAgent);var windows=/win/i.test(platform);var presto_version=presto&&userAgent.match(/Version\/(\d*\.\d*)/);if(presto_version){presto_version=Number(presto_version[1])}
if(presto_version&&presto_version>=15){presto=!1;webkit=!0}
var flipCtrlCmd=mac&&(qtwebkit||presto&&(presto_version==null||presto_version<12.11));var captureRightClick=gecko||(ie&&ie_version>=9);function classTest(cls){return new RegExp("(^|\\s)"+cls+"(?:$|\\s)\\s*")}
var rmClass=function(node,cls){var current=node.className;var match=classTest(cls).exec(current);if(match){var after=current.slice(match.index+match[0].length);node.className=current.slice(0,match.index)+(after?match[1]+after:"")}};function removeChildren(e){for(var count=e.childNodes.length;count>0;--count){e.removeChild(e.firstChild)}
return e}
function removeChildrenAndAdd(parent,e){return removeChildren(parent).appendChild(e)}
function elt(tag,content,className,style){var e=document.createElement(tag);if(className){e.className=className}
if(style){e.style.cssText=style}
if(typeof content=="string"){e.appendChild(document.createTextNode(content))}else if(content){for(var i=0;i<content.length;++i){e.appendChild(content[i])}}
return e}
function eltP(tag,content,className,style){var e=elt(tag,content,className,style);e.setAttribute("role","presentation");return e}
var range;if(document.createRange){range=function(node,start,end,endNode){var r=document.createRange();r.setEnd(endNode||node,end);r.setStart(node,start);return r}}else{range=function(node,start,end){var r=document.body.createTextRange();try{r.moveToElementText(node.parentNode)}catch(e){return r}
r.collapse(!0);r.moveEnd("character",end);r.moveStart("character",start);return r}}
function contains(parent,child){if(child.nodeType==3){child=child.parentNode}
if(parent.contains){return parent.contains(child)}
do{if(child.nodeType==11){child=child.host}
if(child==parent){return!0}}while(child=child.parentNode)}
function activeElt(rootNode){var doc=rootNode.ownerDocument||rootNode;var activeElement;try{activeElement=rootNode.activeElement}catch(e){activeElement=doc.body||null}
while(activeElement&&activeElement.shadowRoot&&activeElement.shadowRoot.activeElement){activeElement=activeElement.shadowRoot.activeElement}
return activeElement}
function addClass(node,cls){var current=node.className;if(!classTest(cls).test(current)){node.className+=(current?" ":"")+cls}}
function joinClasses(a,b){var as=a.split(" ");for(var i=0;i<as.length;i++){if(as[i]&&!classTest(as[i]).test(b)){b+=" "+as[i]}}
return b}
var selectInput=function(node){node.select()};if(ios){selectInput=function(node){node.selectionStart=0;node.selectionEnd=node.value.length}}else if(ie){selectInput=function(node){try{node.select()}catch(_e){}}}
function doc(cm){return cm.display.wrapper.ownerDocument}
function root(cm){return rootNode(cm.display.wrapper)}
function rootNode(element){return element.getRootNode?element.getRootNode():element.ownerDocument}
function win(cm){return doc(cm).defaultView}
function bind(f){var args=Array.prototype.slice.call(arguments,1);return function(){return f.apply(null,args)}}
function copyObj(obj,target,overwrite){if(!target){target={}}
for(var prop in obj){if(obj.hasOwnProperty(prop)&&(overwrite!==!1||!target.hasOwnProperty(prop))){target[prop]=obj[prop]}}
return target}
function countColumn(string,end,tabSize,startIndex,startValue){if(end==null){end=string.search(/[^\s\u00a0]/);if(end==-1){end=string.length}}
for(var i=startIndex||0,n=startValue||0;;){var nextTab=string.indexOf("\t",i);if(nextTab<0||nextTab>=end){return n+(end-i)}
n+=nextTab-i;n+=tabSize-(n%tabSize);i=nextTab+1}}
var Delayed=function(){this.id=null;this.f=null;this.time=0;this.handler=bind(this.onTimeout,this)};Delayed.prototype.onTimeout=function(self){self.id=0;if(self.time<=+new Date){self.f()}else{setTimeout(self.handler,self.time- +new Date)}};Delayed.prototype.set=function(ms,f){this.f=f;var time=+new Date+ms;if(!this.id||time<this.time){clearTimeout(this.id);this.id=setTimeout(this.handler,ms);this.time=time}};function indexOf(array,elt){for(var i=0;i<array.length;++i){if(array[i]==elt){return i}}
return-1}
var scrollerGap=50;var Pass={toString:function(){return"CodeMirror.Pass"}};var sel_dontScroll={scroll:!1},sel_mouse={origin:"*mouse"},sel_move={origin:"+move"};function findColumn(string,goal,tabSize){for(var pos=0,col=0;;){var nextTab=string.indexOf("\t",pos);if(nextTab==-1){nextTab=string.length}
var skipped=nextTab-pos;if(nextTab==string.length||col+skipped>=goal){return pos+Math.min(skipped,goal-col)}
col+=nextTab-pos;col+=tabSize-(col%tabSize);pos=nextTab+1;if(col>=goal){return pos}}}
var spaceStrs=[""];function spaceStr(n){while(spaceStrs.length<=n){spaceStrs.push(lst(spaceStrs)+" ")}
return spaceStrs[n]}
function lst(arr){return arr[arr.length-1]}
function map(array,f){var out=[];for(var i=0;i<array.length;i++){out[i]=f(array[i],i)}
return out}
function insertSorted(array,value,score){var pos=0,priority=score(value);while(pos<array.length&&score(array[pos])<=priority){pos++}
array.splice(pos,0,value)}
function nothing(){}
function createObj(base,props){var inst;if(Object.create){inst=Object.create(base)}else{nothing.prototype=base;inst=new nothing()}
if(props){copyObj(props,inst)}
return inst}
var nonASCIISingleCaseWordChar=/[\u00df\u0587\u0590-\u05f4\u0600-\u06ff\u3040-\u309f\u30a0-\u30ff\u3400-\u4db5\u4e00-\u9fcc\uac00-\ud7af]/;function isWordCharBasic(ch){return/\w/.test(ch)||ch>"\x80"&&(ch.toUpperCase()!=ch.toLowerCase()||nonASCIISingleCaseWordChar.test(ch))}
function isWordChar(ch,helper){if(!helper){return isWordCharBasic(ch)}
if(helper.source.indexOf("\\w")>-1&&isWordCharBasic(ch)){return!0}
return helper.test(ch)}
function isEmpty(obj){for(var n in obj){if(obj.hasOwnProperty(n)&&obj[n]){return!1}}
return!0}
var extendingChars=/[\u0300-\u036f\u0483-\u0489\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u065e\u0670\u06d6-\u06dc\u06de-\u06e4\u06e7\u06e8\u06ea-\u06ed\u0711\u0730-\u074a\u07a6-\u07b0\u07eb-\u07f3\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0900-\u0902\u093c\u0941-\u0948\u094d\u0951-\u0955\u0962\u0963\u0981\u09bc\u09be\u09c1-\u09c4\u09cd\u09d7\u09e2\u09e3\u0a01\u0a02\u0a3c\u0a41\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a70\u0a71\u0a75\u0a81\u0a82\u0abc\u0ac1-\u0ac5\u0ac7\u0ac8\u0acd\u0ae2\u0ae3\u0b01\u0b3c\u0b3e\u0b3f\u0b41-\u0b44\u0b4d\u0b56\u0b57\u0b62\u0b63\u0b82\u0bbe\u0bc0\u0bcd\u0bd7\u0c3e-\u0c40\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0cbc\u0cbf\u0cc2\u0cc6\u0ccc\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0d3e\u0d41-\u0d44\u0d4d\u0d57\u0d62\u0d63\u0dca\u0dcf\u0dd2-\u0dd4\u0dd6\u0ddf\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0eb1\u0eb4-\u0eb9\u0ebb\u0ebc\u0ec8-\u0ecd\u0f18\u0f19\u0f35\u0f37\u0f39\u0f71-\u0f7e\u0f80-\u0f84\u0f86\u0f87\u0f90-\u0f97\u0f99-\u0fbc\u0fc6\u102d-\u1030\u1032-\u1037\u1039\u103a\u103d\u103e\u1058\u1059\u105e-\u1060\u1071-\u1074\u1082\u1085\u1086\u108d\u109d\u135f\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b7-\u17bd\u17c6\u17c9-\u17d3\u17dd\u180b-\u180d\u18a9\u1920-\u1922\u1927\u1928\u1932\u1939-\u193b\u1a17\u1a18\u1a56\u1a58-\u1a5e\u1a60\u1a62\u1a65-\u1a6c\u1a73-\u1a7c\u1a7f\u1b00-\u1b03\u1b34\u1b36-\u1b3a\u1b3c\u1b42\u1b6b-\u1b73\u1b80\u1b81\u1ba2-\u1ba5\u1ba8\u1ba9\u1c2c-\u1c33\u1c36\u1c37\u1cd0-\u1cd2\u1cd4-\u1ce0\u1ce2-\u1ce8\u1ced\u1dc0-\u1de6\u1dfd-\u1dff\u200c\u200d\u20d0-\u20f0\u2cef-\u2cf1\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua66f-\ua672\ua67c\ua67d\ua6f0\ua6f1\ua802\ua806\ua80b\ua825\ua826\ua8c4\ua8e0-\ua8f1\ua926-\ua92d\ua947-\ua951\ua980-\ua982\ua9b3\ua9b6-\ua9b9\ua9bc\uaa29-\uaa2e\uaa31\uaa32\uaa35\uaa36\uaa43\uaa4c\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uabe5\uabe8\uabed\udc00-\udfff\ufb1e\ufe00-\ufe0f\ufe20-\ufe26\uff9e\uff9f]/;function isExtendingChar(ch){return ch.charCodeAt(0)>=768&&extendingChars.test(ch)}
function skipExtendingChars(str,pos,dir){while((dir<0?pos>0:pos<str.length)&&isExtendingChar(str.charAt(pos))){pos+=dir}
return pos}
function findFirst(pred,from,to){var dir=from>to?-1:1;for(;;){if(from==to){return from}
var midF=(from+to)/2,mid=dir<0?Math.ceil(midF):Math.floor(midF);if(mid==from){return pred(mid)?from:to}
if(pred(mid)){to=mid}else{from=mid+dir}}}
function iterateBidiSections(order,from,to,f){if(!order){return f(from,to,"ltr",0)}
var found=!1;for(var i=0;i<order.length;++i){var part=order[i];if(part.from<to&&part.to>from||from==to&&part.to==from){f(Math.max(part.from,from),Math.min(part.to,to),part.level==1?"rtl":"ltr",i);found=!0}}
if(!found){f(from,to,"ltr")}}
var bidiOther=null;function getBidiPartAt(order,ch,sticky){var found;bidiOther=null;for(var i=0;i<order.length;++i){var cur=order[i];if(cur.from<ch&&cur.to>ch){return i}
if(cur.to==ch){if(cur.from!=cur.to&&sticky=="before"){found=i}else{bidiOther=i}}
if(cur.from==ch){if(cur.from!=cur.to&&sticky!="before"){found=i}else{bidiOther=i}}}
return found!=null?found:bidiOther}
var bidiOrdering=(function(){var lowTypes="bbbbbbbbbtstwsbbbbbbbbbbbbbbssstwNN%%%NNNNNN,N,N1111111111NNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNNNLLLLLLLLLLLLLLLLLLLLLLLLLLNNNNbbbbbbsbbbbbbbbbbbbbbbbbbbbbbbbbb,N%%%%NNNNLNNNNN%%11NLNNN1LNNNNNLLLLLLLLLLLLLLLLLLLLLLLNLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLLN";var arabicTypes="nnnnnnNNr%%r,rNNmmmmmmmmmmmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmmmmmmmmmmmmmmmnnnnnnnnnn%nnrrrmrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrrmmmmmmmnNmmmmmmrrmmNmmmmrr1111111111";function charType(code){if(code<=0xf7){return lowTypes.charAt(code)}else if(0x590<=code&&code<=0x5f4){return"R"}else if(0x600<=code&&code<=0x6f9){return arabicTypes.charAt(code-0x600)}else if(0x6ee<=code&&code<=0x8ac){return"r"}else if(0x2000<=code&&code<=0x200b){return"w"}else if(code==0x200c){return"b"}else{return"L"}}
var bidiRE=/[\u0590-\u05f4\u0600-\u06ff\u0700-\u08ac]/;var isNeutral=/[stwN]/,isStrong=/[LRr]/,countsAsLeft=/[Lb1n]/,countsAsNum=/[1n]/;function BidiSpan(level,from,to){this.level=level;this.from=from;this.to=to}
return function(str,direction){var outerType=direction=="ltr"?"L":"R";if(str.length==0||direction=="ltr"&&!bidiRE.test(str)){return!1}
var len=str.length,types=[];for(var i=0;i<len;++i){types.push(charType(str.charCodeAt(i)))}
for(var i$1=0,prev=outerType;i$1<len;++i$1){var type=types[i$1];if(type=="m"){types[i$1]=prev}else{prev=type}}
for(var i$2=0,cur=outerType;i$2<len;++i$2){var type$1=types[i$2];if(type$1=="1"&&cur=="r"){types[i$2]="n"}else if(isStrong.test(type$1)){cur=type$1;if(type$1=="r"){types[i$2]="R"}}}
for(var i$3=1,prev$1=types[0];i$3<len-1;++i$3){var type$2=types[i$3];if(type$2=="+"&&prev$1=="1"&&types[i$3+1]=="1"){types[i$3]="1"}else if(type$2==","&&prev$1==types[i$3+1]&&(prev$1=="1"||prev$1=="n")){types[i$3]=prev$1}
prev$1=type$2}
for(var i$4=0;i$4<len;++i$4){var type$3=types[i$4];if(type$3==","){types[i$4]="N"}else if(type$3=="%"){var end=(void 0);for(end=i$4+1;end<len&&types[end]=="%";++end){}
var replace=(i$4&&types[i$4-1]=="!")||(end<len&&types[end]=="1")?"1":"N";for(var j=i$4;j<end;++j){types[j]=replace}
i$4=end-1}}
for(var i$5=0,cur$1=outerType;i$5<len;++i$5){var type$4=types[i$5];if(cur$1=="L"&&type$4=="1"){types[i$5]="L"}else if(isStrong.test(type$4)){cur$1=type$4}}
for(var i$6=0;i$6<len;++i$6){if(isNeutral.test(types[i$6])){var end$1=(void 0);for(end$1=i$6+1;end$1<len&&isNeutral.test(types[end$1]);++end$1){}
var before=(i$6?types[i$6-1]:outerType)=="L";var after=(end$1<len?types[end$1]:outerType)=="L";var replace$1=before==after?(before?"L":"R"):outerType;for(var j$1=i$6;j$1<end$1;++j$1){types[j$1]=replace$1}
i$6=end$1-1}}
var order=[],m;for(var i$7=0;i$7<len;){if(countsAsLeft.test(types[i$7])){var start=i$7;for(++i$7;i$7<len&&countsAsLeft.test(types[i$7]);++i$7){}
order.push(new BidiSpan(0,start,i$7))}else{var pos=i$7,at=order.length,isRTL=direction=="rtl"?1:0;for(++i$7;i$7<len&&types[i$7]!="L";++i$7){}
for(var j$2=pos;j$2<i$7;){if(countsAsNum.test(types[j$2])){if(pos<j$2){order.splice(at,0,new BidiSpan(1,pos,j$2));at+=isRTL}
var nstart=j$2;for(++j$2;j$2<i$7&&countsAsNum.test(types[j$2]);++j$2){}
order.splice(at,0,new BidiSpan(2,nstart,j$2));at+=isRTL;pos=j$2}else{++j$2}}
if(pos<i$7){order.splice(at,0,new BidiSpan(1,pos,i$7))}}}
if(direction=="ltr"){if(order[0].level==1&&(m=str.match(/^\s+/))){order[0].from=m[0].length;order.unshift(new BidiSpan(0,0,m[0].length))}
if(lst(order).level==1&&(m=str.match(/\s+$/))){lst(order).to-=m[0].length;order.push(new BidiSpan(0,len-m[0].length,len))}}
return direction=="rtl"?order.reverse():order}})();function getOrder(line,direction){var order=line.order;if(order==null){order=line.order=bidiOrdering(line.text,direction)}
return order}
var noHandlers=[];var on=function(emitter,type,f){if(emitter.addEventListener){emitter.addEventListener(type,f,!1)}else if(emitter.attachEvent){emitter.attachEvent("on"+type,f)}else{var map=emitter._handlers||(emitter._handlers={});map[type]=(map[type]||noHandlers).concat(f)}};function getHandlers(emitter,type){return emitter._handlers&&emitter._handlers[type]||noHandlers}
function off(emitter,type,f){if(emitter.removeEventListener){emitter.removeEventListener(type,f,!1)}else if(emitter.detachEvent){emitter.detachEvent("on"+type,f)}else{var map=emitter._handlers,arr=map&&map[type];if(arr){var index=indexOf(arr,f);if(index>-1){map[type]=arr.slice(0,index).concat(arr.slice(index+1))}}}}
function signal(emitter,type){var handlers=getHandlers(emitter,type);if(!handlers.length){return}
var args=Array.prototype.slice.call(arguments,2);for(var i=0;i<handlers.length;++i){handlers[i].apply(null,args)}}
function signalDOMEvent(cm,e,override){if(typeof e=="string"){e={type:e,preventDefault:function(){this.defaultPrevented=!0}}}
signal(cm,override||e.type,cm,e);return e_defaultPrevented(e)||e.codemirrorIgnore}
function signalCursorActivity(cm){var arr=cm._handlers&&cm._handlers.cursorActivity;if(!arr){return}
var set=cm.curOp.cursorActivityHandlers||(cm.curOp.cursorActivityHandlers=[]);for(var i=0;i<arr.length;++i){if(indexOf(set,arr[i])==-1){set.push(arr[i])}}}
function hasHandler(emitter,type){return getHandlers(emitter,type).length>0}
function eventMixin(ctor){ctor.prototype.on=function(type,f){on(this,type,f)};ctor.prototype.off=function(type,f){off(this,type,f)}}
function e_preventDefault(e){if(e.preventDefault){e.preventDefault()}else{e.returnValue=!1}}
function e_stopPropagation(e){if(e.stopPropagation){e.stopPropagation()}else{e.cancelBubble=!0}}
function e_defaultPrevented(e){return e.defaultPrevented!=null?e.defaultPrevented:e.returnValue==!1}
function e_stop(e){e_preventDefault(e);e_stopPropagation(e)}
function e_target(e){return e.target||e.srcElement}
function e_button(e){var b=e.which;if(b==null){if(e.button&1){b=1}else if(e.button&2){b=3}else if(e.button&4){b=2}}
if(mac&&e.ctrlKey&&b==1){b=3}
return b}
var dragAndDrop=function(){if(ie&&ie_version<9){return!1}
var div=elt('div');return"draggable" in div||"dragDrop" in div}();var zwspSupported;function zeroWidthElement(measure){if(zwspSupported==null){var test=elt("span","\u200b");removeChildrenAndAdd(measure,elt("span",[test,document.createTextNode("x")]));if(measure.firstChild.offsetHeight!=0){zwspSupported=test.offsetWidth<=1&&test.offsetHeight>2&&!(ie&&ie_version<8)}}
var node=zwspSupported?elt("span","\u200b"):elt("span","\u00a0",null,"display: inline-block; width: 1px; margin-right: -1px");node.setAttribute("cm-text","");return node}
var badBidiRects;function hasBadBidiRects(measure){if(badBidiRects!=null){return badBidiRects}
var txt=removeChildrenAndAdd(measure,document.createTextNode("A\u062eA"));var r0=range(txt,0,1).getBoundingClientRect();var r1=range(txt,1,2).getBoundingClientRect();removeChildren(measure);if(!r0||r0.left==r0.right){return!1}
return badBidiRects=(r1.right-r0.right<3)}
var splitLinesAuto="\n\nb".split(/\n/).length!=3?function(string){var pos=0,result=[],l=string.length;while(pos<=l){var nl=string.indexOf("\n",pos);if(nl==-1){nl=string.length}
var line=string.slice(pos,string.charAt(nl-1)=="\r"?nl-1:nl);var rt=line.indexOf("\r");if(rt!=-1){result.push(line.slice(0,rt));pos+=rt+1}else{result.push(line);pos=nl+1}}
return result}:function(string){return string.split(/\r\n?|\n/)};var hasSelection=window.getSelection?function(te){try{return te.selectionStart!=te.selectionEnd}catch(e){return!1}}:function(te){var range;try{range=te.ownerDocument.selection.createRange()}catch(e){}
if(!range||range.parentElement()!=te){return!1}
return range.compareEndPoints("StartToEnd",range)!=0};var hasCopyEvent=(function(){var e=elt("div");if("oncopy" in e){return!0}
e.setAttribute("oncopy","return;");return typeof e.oncopy=="function"})();var badZoomedRects=null;function hasBadZoomedRects(measure){if(badZoomedRects!=null){return badZoomedRects}
var node=removeChildrenAndAdd(measure,elt("span","x"));var normal=node.getBoundingClientRect();var fromRange=range(node,0,1).getBoundingClientRect();return badZoomedRects=Math.abs(normal.left-fromRange.left)>1}
var modes={},mimeModes={};function defineMode(name,mode){if(arguments.length>2){mode.dependencies=Array.prototype.slice.call(arguments,2)}
modes[name]=mode}
function defineMIME(mime,spec){mimeModes[mime]=spec}
function resolveMode(spec){if(typeof spec=="string"&&mimeModes.hasOwnProperty(spec)){spec=mimeModes[spec]}else if(spec&&typeof spec.name=="string"&&mimeModes.hasOwnProperty(spec.name)){var found=mimeModes[spec.name];if(typeof found=="string"){found={name:found}}
spec=createObj(found,spec);spec.name=found.name}else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+xml$/.test(spec)){return resolveMode("application/xml")}else if(typeof spec=="string"&&/^[\w\-]+\/[\w\-]+\+json$/.test(spec)){return resolveMode("application/json")}
if(typeof spec=="string"){return{name:spec}}else{return spec||{name:"null"}}}
function getMode(options,spec){spec=resolveMode(spec);var mfactory=modes[spec.name];if(!mfactory){return getMode(options,"text/plain")}
var modeObj=mfactory(options,spec);if(modeExtensions.hasOwnProperty(spec.name)){var exts=modeExtensions[spec.name];for(var prop in exts){if(!exts.hasOwnProperty(prop)){continue}
if(modeObj.hasOwnProperty(prop)){modeObj["_"+prop]=modeObj[prop]}
modeObj[prop]=exts[prop]}}
modeObj.name=spec.name;if(spec.helperType){modeObj.helperType=spec.helperType}
if(spec.modeProps){for(var prop$1 in spec.modeProps){modeObj[prop$1]=spec.modeProps[prop$1]}}
return modeObj}
var modeExtensions={};function extendMode(mode,properties){var exts=modeExtensions.hasOwnProperty(mode)?modeExtensions[mode]:(modeExtensions[mode]={});copyObj(properties,exts)}
function copyState(mode,state){if(state===!0){return state}
if(mode.copyState){return mode.copyState(state)}
var nstate={};for(var n in state){var val=state[n];if(val instanceof Array){val=val.concat([])}
nstate[n]=val}
return nstate}
function innerMode(mode,state){var info;while(mode.innerMode){info=mode.innerMode(state);if(!info||info.mode==mode){break}
state=info.state;mode=info.mode}
return info||{mode:mode,state:state}}
function startState(mode,a1,a2){return mode.startState?mode.startState(a1,a2):!0}
var StringStream=function(string,tabSize,lineOracle){this.pos=this.start=0;this.string=string;this.tabSize=tabSize||8;this.lastColumnPos=this.lastColumnValue=0;this.lineStart=0;this.lineOracle=lineOracle};StringStream.prototype.eol=function(){return this.pos>=this.string.length};StringStream.prototype.sol=function(){return this.pos==this.lineStart};StringStream.prototype.peek=function(){return this.string.charAt(this.pos)||undefined};StringStream.prototype.next=function(){if(this.pos<this.string.length){return this.string.charAt(this.pos++)}};StringStream.prototype.eat=function(match){var ch=this.string.charAt(this.pos);var ok;if(typeof match=="string"){ok=ch==match}else{ok=ch&&(match.test?match.test(ch):match(ch))}
if(ok){++this.pos;return ch}};StringStream.prototype.eatWhile=function(match){var start=this.pos;while(this.eat(match)){}
return this.pos>start};StringStream.prototype.eatSpace=function(){var start=this.pos;while(/[\s\u00a0]/.test(this.string.charAt(this.pos))){++this.pos}
return this.pos>start};StringStream.prototype.skipToEnd=function(){this.pos=this.string.length};StringStream.prototype.skipTo=function(ch){var found=this.string.indexOf(ch,this.pos);if(found>-1){this.pos=found;return!0}};StringStream.prototype.backUp=function(n){this.pos-=n};StringStream.prototype.column=function(){if(this.lastColumnPos<this.start){this.lastColumnValue=countColumn(this.string,this.start,this.tabSize,this.lastColumnPos,this.lastColumnValue);this.lastColumnPos=this.start}
return this.lastColumnValue-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};StringStream.prototype.indentation=function(){return countColumn(this.string,null,this.tabSize)-(this.lineStart?countColumn(this.string,this.lineStart,this.tabSize):0)};StringStream.prototype.match=function(pattern,consume,caseInsensitive){if(typeof pattern=="string"){var cased=function(str){return caseInsensitive?str.toLowerCase():str};var substr=this.string.substr(this.pos,pattern.length);if(cased(substr)==cased(pattern)){if(consume!==!1){this.pos+=pattern.length}
return!0}}else{var match=this.string.slice(this.pos).match(pattern);if(match&&match.index>0){return null}
if(match&&consume!==!1){this.pos+=match[0].length}
return match}};StringStream.prototype.current=function(){return this.string.slice(this.start,this.pos)};StringStream.prototype.hideFirstChars=function(n,inner){this.lineStart+=n;try{return inner()}finally{this.lineStart-=n}};StringStream.prototype.lookAhead=function(n){var oracle=this.lineOracle;return oracle&&oracle.lookAhead(n)};StringStream.prototype.baseToken=function(){var oracle=this.lineOracle;return oracle&&oracle.baseToken(this.pos)};function getLine(doc,n){n-=doc.first;if(n<0||n>=doc.size){throw new Error("There is no line "+(n+doc.first)+" in the document.")}
var chunk=doc;while(!chunk.lines){for(var i=0;;++i){var child=chunk.children[i],sz=child.chunkSize();if(n<sz){chunk=child;break}
n-=sz}}
return chunk.lines[n]}
function getBetween(doc,start,end){var out=[],n=start.line;doc.iter(start.line,end.line+1,function(line){var text=line.text;if(n==end.line){text=text.slice(0,end.ch)}
if(n==start.line){text=text.slice(start.ch)}
out.push(text);++n});return out}
function getLines(doc,from,to){var out=[];doc.iter(from,to,function(line){out.push(line.text)});return out}
function updateLineHeight(line,height){var diff=height-line.height;if(diff){for(var n=line;n;n=n.parent){n.height+=diff}}}
function lineNo(line){if(line.parent==null){return null}
var cur=line.parent,no=indexOf(cur.lines,line);for(var chunk=cur.parent;chunk;cur=chunk,chunk=chunk.parent){for(var i=0;;++i){if(chunk.children[i]==cur){break}
no+=chunk.children[i].chunkSize()}}
return no+cur.first}
function lineAtHeight(chunk,h){var n=chunk.first;outer:do{for(var i$1=0;i$1<chunk.children.length;++i$1){var child=chunk.children[i$1],ch=child.height;if(h<ch){chunk=child;continue outer}
h-=ch;n+=child.chunkSize()}
return n}while(!chunk.lines)
var i=0;for(;i<chunk.lines.length;++i){var line=chunk.lines[i],lh=line.height;if(h<lh){break}
h-=lh}
return n+i}
function isLine(doc,l){return l>=doc.first&&l<doc.first+doc.size}
function lineNumberFor(options,i){return String(options.lineNumberFormatter(i+options.firstLineNumber))}
function Pos(line,ch,sticky){if(sticky===void 0)sticky=null;if(!(this instanceof Pos)){return new Pos(line,ch,sticky)}
this.line=line;this.ch=ch;this.sticky=sticky}
function cmp(a,b){return a.line-b.line||a.ch-b.ch}
function equalCursorPos(a,b){return a.sticky==b.sticky&&cmp(a,b)==0}
function copyPos(x){return Pos(x.line,x.ch)}
function maxPos(a,b){return cmp(a,b)<0?b:a}
function minPos(a,b){return cmp(a,b)<0?a:b}
function clipLine(doc,n){return Math.max(doc.first,Math.min(n,doc.first+doc.size-1))}
function clipPos(doc,pos){if(pos.line<doc.first){return Pos(doc.first,0)}
var last=doc.first+doc.size-1;if(pos.line>last){return Pos(last,getLine(doc,last).text.length)}
return clipToLen(pos,getLine(doc,pos.line).text.length)}
function clipToLen(pos,linelen){var ch=pos.ch;if(ch==null||ch>linelen){return Pos(pos.line,linelen)}else if(ch<0){return Pos(pos.line,0)}else{return pos}}
function clipPosArray(doc,array){var out=[];for(var i=0;i<array.length;i++){out[i]=clipPos(doc,array[i])}
return out}
var SavedContext=function(state,lookAhead){this.state=state;this.lookAhead=lookAhead};var Context=function(doc,state,line,lookAhead){this.state=state;this.doc=doc;this.line=line;this.maxLookAhead=lookAhead||0;this.baseTokens=null;this.baseTokenPos=1};Context.prototype.lookAhead=function(n){var line=this.doc.getLine(this.line+n);if(line!=null&&n>this.maxLookAhead){this.maxLookAhead=n}
return line};Context.prototype.baseToken=function(n){if(!this.baseTokens){return null}
while(this.baseTokens[this.baseTokenPos]<=n){this.baseTokenPos+=2}
var type=this.baseTokens[this.baseTokenPos+1];return{type:type&&type.replace(/( |^)overlay .*/,""),size:this.baseTokens[this.baseTokenPos]-n}};Context.prototype.nextLine=function(){this.line++;if(this.maxLookAhead>0){this.maxLookAhead--}};Context.fromSaved=function(doc,saved,line){if(saved instanceof SavedContext){return new Context(doc,copyState(doc.mode,saved.state),line,saved.lookAhead)}else{return new Context(doc,copyState(doc.mode,saved),line)}};Context.prototype.save=function(copy){var state=copy!==!1?copyState(this.doc.mode,this.state):this.state;return this.maxLookAhead>0?new SavedContext(state,this.maxLookAhead):state};function highlightLine(cm,line,context,forceToEnd){var st=[cm.state.modeGen],lineClasses={};runMode(cm,line.text,cm.doc.mode,context,function(end,style){return st.push(end,style)},lineClasses,forceToEnd);var state=context.state;var loop=function(o){context.baseTokens=st;var overlay=cm.state.overlays[o],i=1,at=0;context.state=!0;runMode(cm,line.text,overlay.mode,context,function(end,style){var start=i;while(at<end){var i_end=st[i];if(i_end>end){st.splice(i,1,end,st[i+1],i_end)}
i+=2;at=Math.min(end,i_end)}
if(!style){return}
if(overlay.opaque){st.splice(start,i-start,end,"overlay "+style);i=start+2}else{for(;start<i;start+=2){var cur=st[start+1];st[start+1]=(cur?cur+" ":"")+"overlay "+style}}},lineClasses);context.state=state;context.baseTokens=null;context.baseTokenPos=1};for(var o=0;o<cm.state.overlays.length;++o)loop(o);return{styles:st,classes:lineClasses.bgClass||lineClasses.textClass?lineClasses:null}}
function getLineStyles(cm,line,updateFrontier){if(!line.styles||line.styles[0]!=cm.state.modeGen){var context=getContextBefore(cm,lineNo(line));var resetState=line.text.length>cm.options.maxHighlightLength&&copyState(cm.doc.mode,context.state);var result=highlightLine(cm,line,context);if(resetState){context.state=resetState}
line.stateAfter=context.save(!resetState);line.styles=result.styles;if(result.classes){line.styleClasses=result.classes}else if(line.styleClasses){line.styleClasses=null}
if(updateFrontier===cm.doc.highlightFrontier){cm.doc.modeFrontier=Math.max(cm.doc.modeFrontier,++cm.doc.highlightFrontier)}}
return line.styles}
function getContextBefore(cm,n,precise){var doc=cm.doc,display=cm.display;if(!doc.mode.startState){return new Context(doc,!0,n)}
var start=findStartLine(cm,n,precise);var saved=start>doc.first&&getLine(doc,start-1).stateAfter;var context=saved?Context.fromSaved(doc,saved,start):new Context(doc,startState(doc.mode),start);doc.iter(start,n,function(line){processLine(cm,line.text,context);var pos=context.line;line.stateAfter=pos==n-1||pos%5==0||pos>=display.viewFrom&&pos<display.viewTo?context.save():null;context.nextLine()});if(precise){doc.modeFrontier=context.line}
return context}
function processLine(cm,text,context,startAt){var mode=cm.doc.mode;var stream=new StringStream(text,cm.options.tabSize,context);stream.start=stream.pos=startAt||0;if(text==""){callBlankLine(mode,context.state)}
while(!stream.eol()){readToken(mode,stream,context.state);stream.start=stream.pos}}
function callBlankLine(mode,state){if(mode.blankLine){return mode.blankLine(state)}
if(!mode.innerMode){return}
var inner=innerMode(mode,state);if(inner.mode.blankLine){return inner.mode.blankLine(inner.state)}}
function readToken(mode,stream,state,inner){for(var i=0;i<10;i++){if(inner){inner[0]=innerMode(mode,state).mode}
var style=mode.token(stream,state);if(stream.pos>stream.start){return style}}
throw new Error("Mode "+mode.name+" failed to advance stream.")}
var Token=function(stream,type,state){this.start=stream.start;this.end=stream.pos;this.string=stream.current();this.type=type||null;this.state=state};function takeToken(cm,pos,precise,asArray){var doc=cm.doc,mode=doc.mode,style;pos=clipPos(doc,pos);var line=getLine(doc,pos.line),context=getContextBefore(cm,pos.line,precise);var stream=new StringStream(line.text,cm.options.tabSize,context),tokens;if(asArray){tokens=[]}
while((asArray||stream.pos<pos.ch)&&!stream.eol()){stream.start=stream.pos;style=readToken(mode,stream,context.state);if(asArray){tokens.push(new Token(stream,style,copyState(doc.mode,context.state)))}}
return asArray?tokens:new Token(stream,style,context.state)}
function extractLineClasses(type,output){if(type){for(;;){var lineClass=type.match(/(?:^|\s+)line-(background-)?(\S+)/);if(!lineClass){break}
type=type.slice(0,lineClass.index)+type.slice(lineClass.index+lineClass[0].length);var prop=lineClass[1]?"bgClass":"textClass";if(output[prop]==null){output[prop]=lineClass[2]}else if(!(new RegExp("(?:^|\\s)"+lineClass[2]+"(?:$|\\s)")).test(output[prop])){output[prop]+=" "+lineClass[2]}}}
return type}
function runMode(cm,text,mode,context,f,lineClasses,forceToEnd){var flattenSpans=mode.flattenSpans;if(flattenSpans==null){flattenSpans=cm.options.flattenSpans}
var curStart=0,curStyle=null;var stream=new StringStream(text,cm.options.tabSize,context),style;var inner=cm.options.addModeClass&&[null];if(text==""){extractLineClasses(callBlankLine(mode,context.state),lineClasses)}
while(!stream.eol()){if(stream.pos>cm.options.maxHighlightLength){flattenSpans=!1;if(forceToEnd){processLine(cm,text,context,stream.pos)}
stream.pos=text.length;style=null}else{style=extractLineClasses(readToken(mode,stream,context.state,inner),lineClasses)}
if(inner){var mName=inner[0].name;if(mName){style="m-"+(style?mName+" "+style:mName)}}
if(!flattenSpans||curStyle!=style){while(curStart<stream.start){curStart=Math.min(stream.start,curStart+5000);f(curStart,curStyle)}
curStyle=style}
stream.start=stream.pos}
while(curStart<stream.pos){var pos=Math.min(stream.pos,curStart+5000);f(pos,curStyle);curStart=pos}}
function findStartLine(cm,n,precise){var minindent,minline,doc=cm.doc;var lim=precise?-1:n-(cm.doc.mode.innerMode?1000:100);for(var search=n;search>lim;--search){if(search<=doc.first){return doc.first}
var line=getLine(doc,search-1),after=line.stateAfter;if(after&&(!precise||search+(after instanceof SavedContext?after.lookAhead:0)<=doc.modeFrontier)){return search}
var indented=countColumn(line.text,null,cm.options.tabSize);if(minline==null||minindent>indented){minline=search-1;minindent=indented}}
return minline}
function retreatFrontier(doc,n){doc.modeFrontier=Math.min(doc.modeFrontier,n);if(doc.highlightFrontier<n-10){return}
var start=doc.first;for(var line=n-1;line>start;line--){var saved=getLine(doc,line).stateAfter;if(saved&&(!(saved instanceof SavedContext)||line+saved.lookAhead<n)){start=line+1;break}}
doc.highlightFrontier=Math.min(doc.highlightFrontier,start)}
var sawReadOnlySpans=!1,sawCollapsedSpans=!1;function seeReadOnlySpans(){sawReadOnlySpans=!0}
function seeCollapsedSpans(){sawCollapsedSpans=!0}
function MarkedSpan(marker,from,to){this.marker=marker;this.from=from;this.to=to}
function getMarkedSpanFor(spans,marker){if(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if(span.marker==marker){return span}}}}
function removeMarkedSpan(spans,span){var r;for(var i=0;i<spans.length;++i){if(spans[i]!=span){(r||(r=[])).push(spans[i])}}
return r}
function addMarkedSpan(line,span,op){var inThisOp=op&&window.WeakSet&&(op.markedSpans||(op.markedSpans=new WeakSet));if(inThisOp&&line.markedSpans&&inThisOp.has(line.markedSpans)){line.markedSpans.push(span)}else{line.markedSpans=line.markedSpans?line.markedSpans.concat([span]):[span];if(inThisOp){inThisOp.add(line.markedSpans)}}
span.marker.attachLine(line)}
function markedSpansBefore(old,startCh,isInsert){var nw;if(old){for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker;var startsBefore=span.from==null||(marker.inclusiveLeft?span.from<=startCh:span.from<startCh);if(startsBefore||span.from==startCh&&marker.type=="bookmark"&&(!isInsert||!span.marker.insertLeft)){var endsAfter=span.to==null||(marker.inclusiveRight?span.to>=startCh:span.to>startCh);(nw||(nw=[])).push(new MarkedSpan(marker,span.from,endsAfter?null:span.to))}}}
return nw}
function markedSpansAfter(old,endCh,isInsert){var nw;if(old){for(var i=0;i<old.length;++i){var span=old[i],marker=span.marker;var endsAfter=span.to==null||(marker.inclusiveRight?span.to>=endCh:span.to>endCh);if(endsAfter||span.from==endCh&&marker.type=="bookmark"&&(!isInsert||span.marker.insertLeft)){var startsBefore=span.from==null||(marker.inclusiveLeft?span.from<=endCh:span.from<endCh);(nw||(nw=[])).push(new MarkedSpan(marker,startsBefore?null:span.from-endCh,span.to==null?null:span.to-endCh))}}}
return nw}
function stretchSpansOverChange(doc,change){if(change.full){return null}
var oldFirst=isLine(doc,change.from.line)&&getLine(doc,change.from.line).markedSpans;var oldLast=isLine(doc,change.to.line)&&getLine(doc,change.to.line).markedSpans;if(!oldFirst&&!oldLast){return null}
var startCh=change.from.ch,endCh=change.to.ch,isInsert=cmp(change.from,change.to)==0;var first=markedSpansBefore(oldFirst,startCh,isInsert);var last=markedSpansAfter(oldLast,endCh,isInsert);var sameLine=change.text.length==1,offset=lst(change.text).length+(sameLine?startCh:0);if(first){for(var i=0;i<first.length;++i){var span=first[i];if(span.to==null){var found=getMarkedSpanFor(last,span.marker);if(!found){span.to=startCh}else if(sameLine){span.to=found.to==null?null:found.to+offset}}}}
if(last){for(var i$1=0;i$1<last.length;++i$1){var span$1=last[i$1];if(span$1.to!=null){span$1.to+=offset}
if(span$1.from==null){var found$1=getMarkedSpanFor(first,span$1.marker);if(!found$1){span$1.from=offset;if(sameLine){(first||(first=[])).push(span$1)}}}else{span$1.from+=offset;if(sameLine){(first||(first=[])).push(span$1)}}}}
if(first){first=clearEmptySpans(first)}
if(last&&last!=first){last=clearEmptySpans(last)}
var newMarkers=[first];if(!sameLine){var gap=change.text.length-2,gapMarkers;if(gap>0&&first){for(var i$2=0;i$2<first.length;++i$2){if(first[i$2].to==null){(gapMarkers||(gapMarkers=[])).push(new MarkedSpan(first[i$2].marker,null,null))}}}
for(var i$3=0;i$3<gap;++i$3){newMarkers.push(gapMarkers)}
newMarkers.push(last)}
return newMarkers}
function clearEmptySpans(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if(span.from!=null&&span.from==span.to&&span.marker.clearWhenEmpty!==!1){spans.splice(i--,1)}}
if(!spans.length){return null}
return spans}
function removeReadOnlyRanges(doc,from,to){var markers=null;doc.iter(from.line,to.line+1,function(line){if(line.markedSpans){for(var i=0;i<line.markedSpans.length;++i){var mark=line.markedSpans[i].marker;if(mark.readOnly&&(!markers||indexOf(markers,mark)==-1)){(markers||(markers=[])).push(mark)}}}});if(!markers){return null}
var parts=[{from:from,to:to}];for(var i=0;i<markers.length;++i){var mk=markers[i],m=mk.find(0);for(var j=0;j<parts.length;++j){var p=parts[j];if(cmp(p.to,m.from)<0||cmp(p.from,m.to)>0){continue}
var newParts=[j,1],dfrom=cmp(p.from,m.from),dto=cmp(p.to,m.to);if(dfrom<0||!mk.inclusiveLeft&&!dfrom){newParts.push({from:p.from,to:m.from})}
if(dto>0||!mk.inclusiveRight&&!dto){newParts.push({from:m.to,to:p.to})}
parts.splice.apply(parts,newParts);j+=newParts.length-3}}
return parts}
function detachMarkedSpans(line){var spans=line.markedSpans;if(!spans){return}
for(var i=0;i<spans.length;++i){spans[i].marker.detachLine(line)}
line.markedSpans=null}
function attachMarkedSpans(line,spans){if(!spans){return}
for(var i=0;i<spans.length;++i){spans[i].marker.attachLine(line)}
line.markedSpans=spans}
function extraLeft(marker){return marker.inclusiveLeft?-1:0}
function extraRight(marker){return marker.inclusiveRight?1:0}
function compareCollapsedMarkers(a,b){var lenDiff=a.lines.length-b.lines.length;if(lenDiff!=0){return lenDiff}
var aPos=a.find(),bPos=b.find();var fromCmp=cmp(aPos.from,bPos.from)||extraLeft(a)-extraLeft(b);if(fromCmp){return-fromCmp}
var toCmp=cmp(aPos.to,bPos.to)||extraRight(a)-extraRight(b);if(toCmp){return toCmp}
return b.id-a.id}
function collapsedSpanAtSide(line,start){var sps=sawCollapsedSpans&&line.markedSpans,found;if(sps){for(var sp=(void 0),i=0;i<sps.length;++i){sp=sps[i];if(sp.marker.collapsed&&(start?sp.from:sp.to)==null&&(!found||compareCollapsedMarkers(found,sp.marker)<0)){found=sp.marker}}}
return found}
function collapsedSpanAtStart(line){return collapsedSpanAtSide(line,!0)}
function collapsedSpanAtEnd(line){return collapsedSpanAtSide(line,!1)}
function collapsedSpanAround(line,ch){var sps=sawCollapsedSpans&&line.markedSpans,found;if(sps){for(var i=0;i<sps.length;++i){var sp=sps[i];if(sp.marker.collapsed&&(sp.from==null||sp.from<ch)&&(sp.to==null||sp.to>ch)&&(!found||compareCollapsedMarkers(found,sp.marker)<0)){found=sp.marker}}}
return found}
function conflictingCollapsedRange(doc,lineNo,from,to,marker){var line=getLine(doc,lineNo);var sps=sawCollapsedSpans&&line.markedSpans;if(sps){for(var i=0;i<sps.length;++i){var sp=sps[i];if(!sp.marker.collapsed){continue}
var found=sp.marker.find(0);var fromCmp=cmp(found.from,from)||extraLeft(sp.marker)-extraLeft(marker);var toCmp=cmp(found.to,to)||extraRight(sp.marker)-extraRight(marker);if(fromCmp>=0&&toCmp<=0||fromCmp<=0&&toCmp>=0){continue}
if(fromCmp<=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.to,from)>=0:cmp(found.to,from)>0)||fromCmp>=0&&(sp.marker.inclusiveRight&&marker.inclusiveLeft?cmp(found.from,to)<=0:cmp(found.from,to)<0)){return!0}}}}
function visualLine(line){var merged;while(merged=collapsedSpanAtStart(line)){line=merged.find(-1,!0).line}
return line}
function visualLineEnd(line){var merged;while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,!0).line}
return line}
function visualLineContinued(line){var merged,lines;while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,!0).line;(lines||(lines=[])).push(line)}
return lines}
function visualLineNo(doc,lineN){var line=getLine(doc,lineN),vis=visualLine(line);if(line==vis){return lineN}
return lineNo(vis)}
function visualLineEndNo(doc,lineN){if(lineN>doc.lastLine()){return lineN}
var line=getLine(doc,lineN),merged;if(!lineIsHidden(doc,line)){return lineN}
while(merged=collapsedSpanAtEnd(line)){line=merged.find(1,!0).line}
return lineNo(line)+1}
function lineIsHidden(doc,line){var sps=sawCollapsedSpans&&line.markedSpans;if(sps){for(var sp=(void 0),i=0;i<sps.length;++i){sp=sps[i];if(!sp.marker.collapsed){continue}
if(sp.from==null){return!0}
if(sp.marker.widgetNode){continue}
if(sp.from==0&&sp.marker.inclusiveLeft&&lineIsHiddenInner(doc,line,sp)){return!0}}}}
function lineIsHiddenInner(doc,line,span){if(span.to==null){var end=span.marker.find(1,!0);return lineIsHiddenInner(doc,end.line,getMarkedSpanFor(end.line.markedSpans,span.marker))}
if(span.marker.inclusiveRight&&span.to==line.text.length){return!0}
for(var sp=(void 0),i=0;i<line.markedSpans.length;++i){sp=line.markedSpans[i];if(sp.marker.collapsed&&!sp.marker.widgetNode&&sp.from==span.to&&(sp.to==null||sp.to!=span.from)&&(sp.marker.inclusiveLeft||span.marker.inclusiveRight)&&lineIsHiddenInner(doc,line,sp)){return!0}}}
function heightAtLine(lineObj){lineObj=visualLine(lineObj);var h=0,chunk=lineObj.parent;for(var i=0;i<chunk.lines.length;++i){var line=chunk.lines[i];if(line==lineObj){break}else{h+=line.height}}
for(var p=chunk.parent;p;chunk=p,p=chunk.parent){for(var i$1=0;i$1<p.children.length;++i$1){var cur=p.children[i$1];if(cur==chunk){break}else{h+=cur.height}}}
return h}
function lineLength(line){if(line.height==0){return 0}
var len=line.text.length,merged,cur=line;while(merged=collapsedSpanAtStart(cur)){var found=merged.find(0,!0);cur=found.from.line;len+=found.from.ch-found.to.ch}
cur=line;while(merged=collapsedSpanAtEnd(cur)){var found$1=merged.find(0,!0);len-=cur.text.length-found$1.from.ch;cur=found$1.to.line;len+=cur.text.length-found$1.to.ch}
return len}
function findMaxLine(cm){var d=cm.display,doc=cm.doc;d.maxLine=getLine(doc,doc.first);d.maxLineLength=lineLength(d.maxLine);d.maxLineChanged=!0;doc.iter(function(line){var len=lineLength(line);if(len>d.maxLineLength){d.maxLineLength=len;d.maxLine=line}})}
var Line=function(text,markedSpans,estimateHeight){this.text=text;attachMarkedSpans(this,markedSpans);this.height=estimateHeight?estimateHeight(this):1};Line.prototype.lineNo=function(){return lineNo(this)};eventMixin(Line);function updateLine(line,text,markedSpans,estimateHeight){line.text=text;if(line.stateAfter){line.stateAfter=null}
if(line.styles){line.styles=null}
if(line.order!=null){line.order=null}
detachMarkedSpans(line);attachMarkedSpans(line,markedSpans);var estHeight=estimateHeight?estimateHeight(line):1;if(estHeight!=line.height){updateLineHeight(line,estHeight)}}
function cleanUpLine(line){line.parent=null;detachMarkedSpans(line)}
var styleToClassCache={},styleToClassCacheWithMode={};function interpretTokenStyle(style,options){if(!style||/^\s*$/.test(style)){return null}
var cache=options.addModeClass?styleToClassCacheWithMode:styleToClassCache;return cache[style]||(cache[style]=style.replace(/\S+/g,"cm-$&"))}
function buildLineContent(cm,lineView){var content=eltP("span",null,null,webkit?"padding-right: .1px":null);var builder={pre:eltP("pre",[content],"CodeMirror-line"),content:content,col:0,pos:0,cm:cm,trailingSpace:!1,splitSpaces:cm.getOption("lineWrapping")};lineView.measure={};for(var i=0;i<=(lineView.rest?lineView.rest.length:0);i++){var line=i?lineView.rest[i-1]:lineView.line,order=(void 0);builder.pos=0;builder.addToken=buildToken;if(hasBadBidiRects(cm.display.measure)&&(order=getOrder(line,cm.doc.direction))){builder.addToken=buildTokenBadBidi(builder.addToken,order)}
builder.map=[];var allowFrontierUpdate=lineView!=cm.display.externalMeasured&&lineNo(line);insertLineContent(line,builder,getLineStyles(cm,line,allowFrontierUpdate));if(line.styleClasses){if(line.styleClasses.bgClass){builder.bgClass=joinClasses(line.styleClasses.bgClass,builder.bgClass||"")}
if(line.styleClasses.textClass){builder.textClass=joinClasses(line.styleClasses.textClass,builder.textClass||"")}}
if(builder.map.length==0){builder.map.push(0,0,builder.content.appendChild(zeroWidthElement(cm.display.measure)))}
if(i==0){lineView.measure.map=builder.map;lineView.measure.cache={}}else{(lineView.measure.maps||(lineView.measure.maps=[])).push(builder.map);(lineView.measure.caches||(lineView.measure.caches=[])).push({})}}
if(webkit){var last=builder.content.lastChild;if(/\bcm-tab\b/.test(last.className)||(last.querySelector&&last.querySelector(".cm-tab"))){builder.content.className="cm-tab-wrap-hack"}}
signal(cm,"renderLine",cm,lineView.line,builder.pre);if(builder.pre.className){builder.textClass=joinClasses(builder.pre.className,builder.textClass||"")}
return builder}
function defaultSpecialCharPlaceholder(ch){var token=elt("span","\u2022","cm-invalidchar");token.title="\\u"+ch.charCodeAt(0).toString(16);token.setAttribute("aria-label",token.title);return token}
function buildToken(builder,text,style,startStyle,endStyle,css,attributes){if(!text){return}
var displayText=builder.splitSpaces?splitSpaces(text,builder.trailingSpace):text;var special=builder.cm.state.specialChars,mustWrap=!1;var content;if(!special.test(text)){builder.col+=text.length;content=document.createTextNode(displayText);builder.map.push(builder.pos,builder.pos+text.length,content);if(ie&&ie_version<9){mustWrap=!0}
builder.pos+=text.length}else{content=document.createDocumentFragment();var pos=0;while(!0){special.lastIndex=pos;var m=special.exec(text);var skipped=m?m.index-pos:text.length-pos;if(skipped){var txt=document.createTextNode(displayText.slice(pos,pos+skipped));if(ie&&ie_version<9){content.appendChild(elt("span",[txt]))}else{content.appendChild(txt)}
builder.map.push(builder.pos,builder.pos+skipped,txt);builder.col+=skipped;builder.pos+=skipped}
if(!m){break}
pos+=skipped+1;var txt$1=(void 0);if(m[0]=="\t"){var tabSize=builder.cm.options.tabSize,tabWidth=tabSize-builder.col%tabSize;txt$1=content.appendChild(elt("span",spaceStr(tabWidth),"cm-tab"));txt$1.setAttribute("role","presentation");txt$1.setAttribute("cm-text","\t");builder.col+=tabWidth}else if(m[0]=="\r"||m[0]=="\n"){txt$1=content.appendChild(elt("span",m[0]=="\r"?"\u240d":"\u2424","cm-invalidchar"));txt$1.setAttribute("cm-text",m[0]);builder.col+=1}else{txt$1=builder.cm.options.specialCharPlaceholder(m[0]);txt$1.setAttribute("cm-text",m[0]);if(ie&&ie_version<9){content.appendChild(elt("span",[txt$1]))}else{content.appendChild(txt$1)}
builder.col+=1}
builder.map.push(builder.pos,builder.pos+1,txt$1);builder.pos++}}
builder.trailingSpace=displayText.charCodeAt(text.length-1)==32;if(style||startStyle||endStyle||mustWrap||css||attributes){var fullStyle=style||"";if(startStyle){fullStyle+=startStyle}
if(endStyle){fullStyle+=endStyle}
var token=elt("span",[content],fullStyle,css);if(attributes){for(var attr in attributes){if(attributes.hasOwnProperty(attr)&&attr!="style"&&attr!="class"){token.setAttribute(attr,attributes[attr])}}}
return builder.content.appendChild(token)}
builder.content.appendChild(content)}
function splitSpaces(text,trailingBefore){if(text.length>1&&!/  /.test(text)){return text}
var spaceBefore=trailingBefore,result="";for(var i=0;i<text.length;i++){var ch=text.charAt(i);if(ch==" "&&spaceBefore&&(i==text.length-1||text.charCodeAt(i+1)==32)){ch="\u00a0"}
result+=ch;spaceBefore=ch==" "}
return result}
function buildTokenBadBidi(inner,order){return function(builder,text,style,startStyle,endStyle,css,attributes){style=style?style+" cm-force-border":"cm-force-border";var start=builder.pos,end=start+text.length;for(;;){var part=(void 0);for(var i=0;i<order.length;i++){part=order[i];if(part.to>start&&part.from<=start){break}}
if(part.to>=end){return inner(builder,text,style,startStyle,endStyle,css,attributes)}
inner(builder,text.slice(0,part.to-start),style,startStyle,null,css,attributes);startStyle=null;text=text.slice(part.to-start);start=part.to}}}
function buildCollapsedSpan(builder,size,marker,ignoreWidget){var widget=!ignoreWidget&&marker.widgetNode;if(widget){builder.map.push(builder.pos,builder.pos+size,widget)}
if(!ignoreWidget&&builder.cm.display.input.needsContentAttribute){if(!widget){widget=builder.content.appendChild(document.createElement("span"))}
widget.setAttribute("cm-marker",marker.id)}
if(widget){builder.cm.display.input.setUneditable(widget);builder.content.appendChild(widget)}
builder.pos+=size;builder.trailingSpace=!1}
function insertLineContent(line,builder,styles){var spans=line.markedSpans,allText=line.text,at=0;if(!spans){for(var i$1=1;i$1<styles.length;i$1+=2){builder.addToken(builder,allText.slice(at,at=styles[i$1]),interpretTokenStyle(styles[i$1+1],builder.cm.options))}
return}
var len=allText.length,pos=0,i=1,text="",style,css;var nextChange=0,spanStyle,spanEndStyle,spanStartStyle,collapsed,attributes;for(;;){if(nextChange==pos){spanStyle=spanEndStyle=spanStartStyle=css="";attributes=null;collapsed=null;nextChange=Infinity;var foundBookmarks=[],endStyles=(void 0);for(var j=0;j<spans.length;++j){var sp=spans[j],m=sp.marker;if(m.type=="bookmark"&&sp.from==pos&&m.widgetNode){foundBookmarks.push(m)}else if(sp.from<=pos&&(sp.to==null||sp.to>pos||m.collapsed&&sp.to==pos&&sp.from==pos)){if(sp.to!=null&&sp.to!=pos&&nextChange>sp.to){nextChange=sp.to;spanEndStyle=""}
if(m.className){spanStyle+=" "+m.className}
if(m.css){css=(css?css+";":"")+m.css}
if(m.startStyle&&sp.from==pos){spanStartStyle+=" "+m.startStyle}
if(m.endStyle&&sp.to==nextChange){(endStyles||(endStyles=[])).push(m.endStyle,sp.to)}
if(m.title){(attributes||(attributes={})).title=m.title}
if(m.attributes){for(var attr in m.attributes){(attributes||(attributes={}))[attr]=m.attributes[attr]}}
if(m.collapsed&&(!collapsed||compareCollapsedMarkers(collapsed.marker,m)<0)){collapsed=sp}}else if(sp.from>pos&&nextChange>sp.from){nextChange=sp.from}}
if(endStyles){for(var j$1=0;j$1<endStyles.length;j$1+=2){if(endStyles[j$1+1]==nextChange){spanEndStyle+=" "+endStyles[j$1]}}}
if(!collapsed||collapsed.from==pos){for(var j$2=0;j$2<foundBookmarks.length;++j$2){buildCollapsedSpan(builder,0,foundBookmarks[j$2])}}
if(collapsed&&(collapsed.from||0)==pos){buildCollapsedSpan(builder,(collapsed.to==null?len+1:collapsed.to)-pos,collapsed.marker,collapsed.from==null);if(collapsed.to==null){return}
if(collapsed.to==pos){collapsed=!1}}}
if(pos>=len){break}
var upto=Math.min(len,nextChange);while(!0){if(text){var end=pos+text.length;if(!collapsed){var tokenText=end>upto?text.slice(0,upto-pos):text;builder.addToken(builder,tokenText,style?style+spanStyle:spanStyle,spanStartStyle,pos+tokenText.length==nextChange?spanEndStyle:"",css,attributes)}
if(end>=upto){text=text.slice(upto-pos);pos=upto;break}
pos=end;spanStartStyle=""}
text=allText.slice(at,at=styles[i++]);style=interpretTokenStyle(styles[i++],builder.cm.options)}}}
function LineView(doc,line,lineN){this.line=line;this.rest=visualLineContinued(line);this.size=this.rest?lineNo(lst(this.rest))-lineN+1:1;this.node=this.text=null;this.hidden=lineIsHidden(doc,line)}
function buildViewArray(cm,from,to){var array=[],nextPos;for(var pos=from;pos<to;pos=nextPos){var view=new LineView(cm.doc,getLine(cm.doc,pos),pos);nextPos=pos+view.size;array.push(view)}
return array}
var operationGroup=null;function pushOperation(op){if(operationGroup){operationGroup.ops.push(op)}else{op.ownsGroup=operationGroup={ops:[op],delayedCallbacks:[]}}}
function fireCallbacksForOps(group){var callbacks=group.delayedCallbacks,i=0;do{for(;i<callbacks.length;i++){callbacks[i].call(null)}
for(var j=0;j<group.ops.length;j++){var op=group.ops[j];if(op.cursorActivityHandlers){while(op.cursorActivityCalled<op.cursorActivityHandlers.length){op.cursorActivityHandlers[op.cursorActivityCalled++].call(null,op.cm)}}}}while(i<callbacks.length)}
function finishOperation(op,endCb){var group=op.ownsGroup;if(!group){return}
try{fireCallbacksForOps(group)}finally{operationGroup=null;endCb(group)}}
var orphanDelayedCallbacks=null;function signalLater(emitter,type){var arr=getHandlers(emitter,type);if(!arr.length){return}
var args=Array.prototype.slice.call(arguments,2),list;if(operationGroup){list=operationGroup.delayedCallbacks}else if(orphanDelayedCallbacks){list=orphanDelayedCallbacks}else{list=orphanDelayedCallbacks=[];setTimeout(fireOrphanDelayed,0)}
var loop=function(i){list.push(function(){return arr[i].apply(null,args)})};for(var i=0;i<arr.length;++i)
loop(i);}
function fireOrphanDelayed(){var delayed=orphanDelayedCallbacks;orphanDelayedCallbacks=null;for(var i=0;i<delayed.length;++i){delayed[i]()}}
function updateLineForChanges(cm,lineView,lineN,dims){for(var j=0;j<lineView.changes.length;j++){var type=lineView.changes[j];if(type=="text"){updateLineText(cm,lineView)}else if(type=="gutter"){updateLineGutter(cm,lineView,lineN,dims)}else if(type=="class"){updateLineClasses(cm,lineView)}else if(type=="widget"){updateLineWidgets(cm,lineView,dims)}}
lineView.changes=null}
function ensureLineWrapped(lineView){if(lineView.node==lineView.text){lineView.node=elt("div",null,null,"position: relative");if(lineView.text.parentNode){lineView.text.parentNode.replaceChild(lineView.node,lineView.text)}
lineView.node.appendChild(lineView.text);if(ie&&ie_version<8){lineView.node.style.zIndex=2}}
return lineView.node}
function updateLineBackground(cm,lineView){var cls=lineView.bgClass?lineView.bgClass+" "+(lineView.line.bgClass||""):lineView.line.bgClass;if(cls){cls+=" CodeMirror-linebackground"}
if(lineView.background){if(cls){lineView.background.className=cls}else{lineView.background.parentNode.removeChild(lineView.background);lineView.background=null}}else if(cls){var wrap=ensureLineWrapped(lineView);lineView.background=wrap.insertBefore(elt("div",null,cls),wrap.firstChild);cm.display.input.setUneditable(lineView.background)}}
function getLineContent(cm,lineView){var ext=cm.display.externalMeasured;if(ext&&ext.line==lineView.line){cm.display.externalMeasured=null;lineView.measure=ext.measure;return ext.built}
return buildLineContent(cm,lineView)}
function updateLineText(cm,lineView){var cls=lineView.text.className;var built=getLineContent(cm,lineView);if(lineView.text==lineView.node){lineView.node=built.pre}
lineView.text.parentNode.replaceChild(built.pre,lineView.text);lineView.text=built.pre;if(built.bgClass!=lineView.bgClass||built.textClass!=lineView.textClass){lineView.bgClass=built.bgClass;lineView.textClass=built.textClass;updateLineClasses(cm,lineView)}else if(cls){lineView.text.className=cls}}
function updateLineClasses(cm,lineView){updateLineBackground(cm,lineView);if(lineView.line.wrapClass){ensureLineWrapped(lineView).className=lineView.line.wrapClass}else if(lineView.node!=lineView.text){lineView.node.className=""}
var textClass=lineView.textClass?lineView.textClass+" "+(lineView.line.textClass||""):lineView.line.textClass;lineView.text.className=textClass||""}
function updateLineGutter(cm,lineView,lineN,dims){if(lineView.gutter){lineView.node.removeChild(lineView.gutter);lineView.gutter=null}
if(lineView.gutterBackground){lineView.node.removeChild(lineView.gutterBackground);lineView.gutterBackground=null}
if(lineView.line.gutterClass){var wrap=ensureLineWrapped(lineView);lineView.gutterBackground=elt("div",null,"CodeMirror-gutter-background "+lineView.line.gutterClass,("left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px; width: "+(dims.gutterTotalWidth)+"px"));cm.display.input.setUneditable(lineView.gutterBackground);wrap.insertBefore(lineView.gutterBackground,lineView.text)}
var markers=lineView.line.gutterMarkers;if(cm.options.lineNumbers||markers){var wrap$1=ensureLineWrapped(lineView);var gutterWrap=lineView.gutter=elt("div",null,"CodeMirror-gutter-wrapper",("left: "+(cm.options.fixedGutter?dims.fixedPos:-dims.gutterTotalWidth)+"px"));gutterWrap.setAttribute("aria-hidden","true");cm.display.input.setUneditable(gutterWrap);wrap$1.insertBefore(gutterWrap,lineView.text);if(lineView.line.gutterClass){gutterWrap.className+=" "+lineView.line.gutterClass}
if(cm.options.lineNumbers&&(!markers||!markers["CodeMirror-linenumbers"])){lineView.lineNumber=gutterWrap.appendChild(elt("div",lineNumberFor(cm.options,lineN),"CodeMirror-linenumber CodeMirror-gutter-elt",("left: "+(dims.gutterLeft["CodeMirror-linenumbers"])+"px; width: "+(cm.display.lineNumInnerWidth)+"px")))}
if(markers){for(var k=0;k<cm.display.gutterSpecs.length;++k){var id=cm.display.gutterSpecs[k].className,found=markers.hasOwnProperty(id)&&markers[id];if(found){gutterWrap.appendChild(elt("div",[found],"CodeMirror-gutter-elt",("left: "+(dims.gutterLeft[id])+"px; width: "+(dims.gutterWidth[id])+"px")))}}}}}
function updateLineWidgets(cm,lineView,dims){if(lineView.alignable){lineView.alignable=null}
var isWidget=classTest("CodeMirror-linewidget");for(var node=lineView.node.firstChild,next=(void 0);node;node=next){next=node.nextSibling;if(isWidget.test(node.className)){lineView.node.removeChild(node)}}
insertLineWidgets(cm,lineView,dims)}
function buildLineElement(cm,lineView,lineN,dims){var built=getLineContent(cm,lineView);lineView.text=lineView.node=built.pre;if(built.bgClass){lineView.bgClass=built.bgClass}
if(built.textClass){lineView.textClass=built.textClass}
updateLineClasses(cm,lineView);updateLineGutter(cm,lineView,lineN,dims);insertLineWidgets(cm,lineView,dims);return lineView.node}
function insertLineWidgets(cm,lineView,dims){insertLineWidgetsFor(cm,lineView.line,lineView,dims,!0);if(lineView.rest){for(var i=0;i<lineView.rest.length;i++){insertLineWidgetsFor(cm,lineView.rest[i],lineView,dims,!1)}}}
function insertLineWidgetsFor(cm,line,lineView,dims,allowAbove){if(!line.widgets){return}
var wrap=ensureLineWrapped(lineView);for(var i=0,ws=line.widgets;i<ws.length;++i){var widget=ws[i],node=elt("div",[widget.node],"CodeMirror-linewidget"+(widget.className?" "+widget.className:""));if(!widget.handleMouseEvents){node.setAttribute("cm-ignore-events","true")}
positionLineWidget(widget,node,lineView,dims);cm.display.input.setUneditable(node);if(allowAbove&&widget.above){wrap.insertBefore(node,lineView.gutter||lineView.text)}else{wrap.appendChild(node)}
signalLater(widget,"redraw")}}
function positionLineWidget(widget,node,lineView,dims){if(widget.noHScroll){(lineView.alignable||(lineView.alignable=[])).push(node);var width=dims.wrapperWidth;node.style.left=dims.fixedPos+"px";if(!widget.coverGutter){width-=dims.gutterTotalWidth;node.style.paddingLeft=dims.gutterTotalWidth+"px"}
node.style.width=width+"px"}
if(widget.coverGutter){node.style.zIndex=5;node.style.position="relative";if(!widget.noHScroll){node.style.marginLeft=-dims.gutterTotalWidth+"px"}}}
function widgetHeight(widget){if(widget.height!=null){return widget.height}
var cm=widget.doc.cm;if(!cm){return 0}
if(!contains(document.body,widget.node)){var parentStyle="position: relative;";if(widget.coverGutter){parentStyle+="margin-left: -"+cm.display.gutters.offsetWidth+"px;"}
if(widget.noHScroll){parentStyle+="width: "+cm.display.wrapper.clientWidth+"px;"}
removeChildrenAndAdd(cm.display.measure,elt("div",[widget.node],null,parentStyle))}
return widget.height=widget.node.parentNode.offsetHeight}
function eventInWidget(display,e){for(var n=e_target(e);n!=display.wrapper;n=n.parentNode){if(!n||(n.nodeType==1&&n.getAttribute("cm-ignore-events")=="true")||(n.parentNode==display.sizer&&n!=display.mover)){return!0}}}
function paddingTop(display){return display.lineSpace.offsetTop}
function paddingVert(display){return display.mover.offsetHeight-display.lineSpace.offsetHeight}
function paddingH(display){if(display.cachedPaddingH){return display.cachedPaddingH}
var e=removeChildrenAndAdd(display.measure,elt("pre","x","CodeMirror-line-like"));var style=window.getComputedStyle?window.getComputedStyle(e):e.currentStyle;var data={left:parseInt(style.paddingLeft),right:parseInt(style.paddingRight)};if(!isNaN(data.left)&&!isNaN(data.right)){display.cachedPaddingH=data}
return data}
function scrollGap(cm){return scrollerGap-cm.display.nativeBarWidth}
function displayWidth(cm){return cm.display.scroller.clientWidth-scrollGap(cm)-cm.display.barWidth}
function displayHeight(cm){return cm.display.scroller.clientHeight-scrollGap(cm)-cm.display.barHeight}
function ensureLineHeights(cm,lineView,rect){var wrapping=cm.options.lineWrapping;var curWidth=wrapping&&displayWidth(cm);if(!lineView.measure.heights||wrapping&&lineView.measure.width!=curWidth){var heights=lineView.measure.heights=[];if(wrapping){lineView.measure.width=curWidth;var rects=lineView.text.firstChild.getClientRects();for(var i=0;i<rects.length-1;i++){var cur=rects[i],next=rects[i+1];if(Math.abs(cur.bottom-next.bottom)>2){heights.push((cur.bottom+next.top)/2-rect.top)}}}
heights.push(rect.bottom-rect.top)}}
function mapFromLineView(lineView,line,lineN){if(lineView.line==line){return{map:lineView.measure.map,cache:lineView.measure.cache}}
if(lineView.rest){for(var i=0;i<lineView.rest.length;i++){if(lineView.rest[i]==line){return{map:lineView.measure.maps[i],cache:lineView.measure.caches[i]}}}
for(var i$1=0;i$1<lineView.rest.length;i$1++){if(lineNo(lineView.rest[i$1])>lineN){return{map:lineView.measure.maps[i$1],cache:lineView.measure.caches[i$1],before:!0}}}}}
function updateExternalMeasurement(cm,line){line=visualLine(line);var lineN=lineNo(line);var view=cm.display.externalMeasured=new LineView(cm.doc,line,lineN);view.lineN=lineN;var built=view.built=buildLineContent(cm,view);view.text=built.pre;removeChildrenAndAdd(cm.display.lineMeasure,built.pre);return view}
function measureChar(cm,line,ch,bias){return measureCharPrepared(cm,prepareMeasureForLine(cm,line),ch,bias)}
function findViewForLine(cm,lineN){if(lineN>=cm.display.viewFrom&&lineN<cm.display.viewTo){return cm.display.view[findViewIndex(cm,lineN)]}
var ext=cm.display.externalMeasured;if(ext&&lineN>=ext.lineN&&lineN<ext.lineN+ext.size){return ext}}
function prepareMeasureForLine(cm,line){var lineN=lineNo(line);var view=findViewForLine(cm,lineN);if(view&&!view.text){view=null}else if(view&&view.changes){updateLineForChanges(cm,view,lineN,getDimensions(cm));cm.curOp.forceUpdate=!0}
if(!view){view=updateExternalMeasurement(cm,line)}
var info=mapFromLineView(view,line,lineN);return{line:line,view:view,rect:null,map:info.map,cache:info.cache,before:info.before,hasHeights:!1}}
function measureCharPrepared(cm,prepared,ch,bias,varHeight){if(prepared.before){ch=-1}
var key=ch+(bias||""),found;if(prepared.cache.hasOwnProperty(key)){found=prepared.cache[key]}else{if(!prepared.rect){prepared.rect=prepared.view.text.getBoundingClientRect()}
if(!prepared.hasHeights){ensureLineHeights(cm,prepared.view,prepared.rect);prepared.hasHeights=!0}
found=measureCharInner(cm,prepared,ch,bias);if(!found.bogus){prepared.cache[key]=found}}
return{left:found.left,right:found.right,top:varHeight?found.rtop:found.top,bottom:varHeight?found.rbottom:found.bottom}}
var nullRect={left:0,right:0,top:0,bottom:0};function nodeAndOffsetInLineMap(map,ch,bias){var node,start,end,collapse,mStart,mEnd;for(var i=0;i<map.length;i+=3){mStart=map[i];mEnd=map[i+1];if(ch<mStart){start=0;end=1;collapse="left"}else if(ch<mEnd){start=ch-mStart;end=start+1}else if(i==map.length-3||ch==mEnd&&map[i+3]>ch){end=mEnd-mStart;start=end-1;if(ch>=mEnd){collapse="right"}}
if(start!=null){node=map[i+2];if(mStart==mEnd&&bias==(node.insertLeft?"left":"right")){collapse=bias}
if(bias=="left"&&start==0){while(i&&map[i-2]==map[i-3]&&map[i-1].insertLeft){node=map[(i-=3)+2];collapse="left"}}
if(bias=="right"&&start==mEnd-mStart){while(i<map.length-3&&map[i+3]==map[i+4]&&!map[i+5].insertLeft){node=map[(i+=3)+2];collapse="right"}}
break}}
return{node:node,start:start,end:end,collapse:collapse,coverStart:mStart,coverEnd:mEnd}}
function getUsefulRect(rects,bias){var rect=nullRect;if(bias=="left"){for(var i=0;i<rects.length;i++){if((rect=rects[i]).left!=rect.right){break}}}else{for(var i$1=rects.length-1;i$1>=0;i$1--){if((rect=rects[i$1]).left!=rect.right){break}}}
return rect}
function measureCharInner(cm,prepared,ch,bias){var place=nodeAndOffsetInLineMap(prepared.map,ch,bias);var node=place.node,start=place.start,end=place.end,collapse=place.collapse;var rect;if(node.nodeType==3){for(var i$1=0;i$1<4;i$1++){while(start&&isExtendingChar(prepared.line.text.charAt(place.coverStart+start))){--start}
while(place.coverStart+end<place.coverEnd&&isExtendingChar(prepared.line.text.charAt(place.coverStart+end))){++end}
if(ie&&ie_version<9&&start==0&&end==place.coverEnd-place.coverStart){rect=node.parentNode.getBoundingClientRect()}else{rect=getUsefulRect(range(node,start,end).getClientRects(),bias)}
if(rect.left||rect.right||start==0){break}
end=start;start=start-1;collapse="right"}
if(ie&&ie_version<11){rect=maybeUpdateRectForZooming(cm.display.measure,rect)}}else{if(start>0){collapse=bias="right"}
var rects;if(cm.options.lineWrapping&&(rects=node.getClientRects()).length>1){rect=rects[bias=="right"?rects.length-1:0]}else{rect=node.getBoundingClientRect()}}
if(ie&&ie_version<9&&!start&&(!rect||!rect.left&&!rect.right)){var rSpan=node.parentNode.getClientRects()[0];if(rSpan){rect={left:rSpan.left,right:rSpan.left+charWidth(cm.display),top:rSpan.top,bottom:rSpan.bottom}}else{rect=nullRect}}
var rtop=rect.top-prepared.rect.top,rbot=rect.bottom-prepared.rect.top;var mid=(rtop+rbot)/2;var heights=prepared.view.measure.heights;var i=0;for(;i<heights.length-1;i++){if(mid<heights[i]){break}}
var top=i?heights[i-1]:0,bot=heights[i];var result={left:(collapse=="right"?rect.right:rect.left)-prepared.rect.left,right:(collapse=="left"?rect.left:rect.right)-prepared.rect.left,top:top,bottom:bot};if(!rect.left&&!rect.right){result.bogus=!0}
if(!cm.options.singleCursorHeightPerLine){result.rtop=rtop;result.rbottom=rbot}
return result}
function maybeUpdateRectForZooming(measure,rect){if(!window.screen||screen.logicalXDPI==null||screen.logicalXDPI==screen.deviceXDPI||!hasBadZoomedRects(measure)){return rect}
var scaleX=screen.logicalXDPI/screen.deviceXDPI;var scaleY=screen.logicalYDPI/screen.deviceYDPI;return{left:rect.left*scaleX,right:rect.right*scaleX,top:rect.top*scaleY,bottom:rect.bottom*scaleY}}
function clearLineMeasurementCacheFor(lineView){if(lineView.measure){lineView.measure.cache={};lineView.measure.heights=null;if(lineView.rest){for(var i=0;i<lineView.rest.length;i++){lineView.measure.caches[i]={}}}}}
function clearLineMeasurementCache(cm){cm.display.externalMeasure=null;removeChildren(cm.display.lineMeasure);for(var i=0;i<cm.display.view.length;i++){clearLineMeasurementCacheFor(cm.display.view[i])}}
function clearCaches(cm){clearLineMeasurementCache(cm);cm.display.cachedCharWidth=cm.display.cachedTextHeight=cm.display.cachedPaddingH=null;if(!cm.options.lineWrapping){cm.display.maxLineChanged=!0}
cm.display.lineNumChars=null}
function pageScrollX(doc){if(chrome&&android){return-(doc.body.getBoundingClientRect().left-parseInt(getComputedStyle(doc.body).marginLeft))}
return doc.defaultView.pageXOffset||(doc.documentElement||doc.body).scrollLeft}
function pageScrollY(doc){if(chrome&&android){return-(doc.body.getBoundingClientRect().top-parseInt(getComputedStyle(doc.body).marginTop))}
return doc.defaultView.pageYOffset||(doc.documentElement||doc.body).scrollTop}
function widgetTopHeight(lineObj){var ref=visualLine(lineObj);var widgets=ref.widgets;var height=0;if(widgets){for(var i=0;i<widgets.length;++i){if(widgets[i].above){height+=widgetHeight(widgets[i])}}}
return height}
function intoCoordSystem(cm,lineObj,rect,context,includeWidgets){if(!includeWidgets){var height=widgetTopHeight(lineObj);rect.top+=height;rect.bottom+=height}
if(context=="line"){return rect}
if(!context){context="local"}
var yOff=heightAtLine(lineObj);if(context=="local"){yOff+=paddingTop(cm.display)}else{yOff-=cm.display.viewOffset}
if(context=="page"||context=="window"){var lOff=cm.display.lineSpace.getBoundingClientRect();yOff+=lOff.top+(context=="window"?0:pageScrollY(doc(cm)));var xOff=lOff.left+(context=="window"?0:pageScrollX(doc(cm)));rect.left+=xOff;rect.right+=xOff}
rect.top+=yOff;rect.bottom+=yOff;return rect}
function fromCoordSystem(cm,coords,context){if(context=="div"){return coords}
var left=coords.left,top=coords.top;if(context=="page"){left-=pageScrollX(doc(cm));top-=pageScrollY(doc(cm))}else if(context=="local"||!context){var localBox=cm.display.sizer.getBoundingClientRect();left+=localBox.left;top+=localBox.top}
var lineSpaceBox=cm.display.lineSpace.getBoundingClientRect();return{left:left-lineSpaceBox.left,top:top-lineSpaceBox.top}}
function charCoords(cm,pos,context,lineObj,bias){if(!lineObj){lineObj=getLine(cm.doc,pos.line)}
return intoCoordSystem(cm,lineObj,measureChar(cm,lineObj,pos.ch,bias),context)}
function cursorCoords(cm,pos,context,lineObj,preparedMeasure,varHeight){lineObj=lineObj||getLine(cm.doc,pos.line);if(!preparedMeasure){preparedMeasure=prepareMeasureForLine(cm,lineObj)}
function get(ch,right){var m=measureCharPrepared(cm,preparedMeasure,ch,right?"right":"left",varHeight);if(right){m.left=m.right}else{m.right=m.left}
return intoCoordSystem(cm,lineObj,m,context)}
var order=getOrder(lineObj,cm.doc.direction),ch=pos.ch,sticky=pos.sticky;if(ch>=lineObj.text.length){ch=lineObj.text.length;sticky="before"}else if(ch<=0){ch=0;sticky="after"}
if(!order){return get(sticky=="before"?ch-1:ch,sticky=="before")}
function getBidi(ch,partPos,invert){var part=order[partPos],right=part.level==1;return get(invert?ch-1:ch,right!=invert)}
var partPos=getBidiPartAt(order,ch,sticky);var other=bidiOther;var val=getBidi(ch,partPos,sticky=="before");if(other!=null){val.other=getBidi(ch,other,sticky!="before")}
return val}
function estimateCoords(cm,pos){var left=0;pos=clipPos(cm.doc,pos);if(!cm.options.lineWrapping){left=charWidth(cm.display)*pos.ch}
var lineObj=getLine(cm.doc,pos.line);var top=heightAtLine(lineObj)+paddingTop(cm.display);return{left:left,right:left,top:top,bottom:top+lineObj.height}}
function PosWithInfo(line,ch,sticky,outside,xRel){var pos=Pos(line,ch,sticky);pos.xRel=xRel;if(outside){pos.outside=outside}
return pos}
function coordsChar(cm,x,y){var doc=cm.doc;y+=cm.display.viewOffset;if(y<0){return PosWithInfo(doc.first,0,null,-1,-1)}
var lineN=lineAtHeight(doc,y),last=doc.first+doc.size-1;if(lineN>last){return PosWithInfo(doc.first+doc.size-1,getLine(doc,last).text.length,null,1,1)}
if(x<0){x=0}
var lineObj=getLine(doc,lineN);for(;;){var found=coordsCharInner(cm,lineObj,lineN,x,y);var collapsed=collapsedSpanAround(lineObj,found.ch+(found.xRel>0||found.outside>0?1:0));if(!collapsed){return found}
var rangeEnd=collapsed.find(1);if(rangeEnd.line==lineN){return rangeEnd}
lineObj=getLine(doc,lineN=rangeEnd.line)}}
function wrappedLineExtent(cm,lineObj,preparedMeasure,y){y-=widgetTopHeight(lineObj);var end=lineObj.text.length;var begin=findFirst(function(ch){return measureCharPrepared(cm,preparedMeasure,ch-1).bottom<=y},end,0);end=findFirst(function(ch){return measureCharPrepared(cm,preparedMeasure,ch).top>y},begin,end);return{begin:begin,end:end}}
function wrappedLineExtentChar(cm,lineObj,preparedMeasure,target){if(!preparedMeasure){preparedMeasure=prepareMeasureForLine(cm,lineObj)}
var targetTop=intoCoordSystem(cm,lineObj,measureCharPrepared(cm,preparedMeasure,target),"line").top;return wrappedLineExtent(cm,lineObj,preparedMeasure,targetTop)}
function boxIsAfter(box,x,y,left){return box.bottom<=y?!1:box.top>y?!0:(left?box.left:box.right)>x}
function coordsCharInner(cm,lineObj,lineNo,x,y){y-=heightAtLine(lineObj);var preparedMeasure=prepareMeasureForLine(cm,lineObj);var widgetHeight=widgetTopHeight(lineObj);var begin=0,end=lineObj.text.length,ltr=!0;var order=getOrder(lineObj,cm.doc.direction);if(order){var part=(cm.options.lineWrapping?coordsBidiPartWrapped:coordsBidiPart)(cm,lineObj,lineNo,preparedMeasure,order,x,y);ltr=part.level!=1;begin=ltr?part.from:part.to-1;end=ltr?part.to:part.from-1}
var chAround=null,boxAround=null;var ch=findFirst(function(ch){var box=measureCharPrepared(cm,preparedMeasure,ch);box.top+=widgetHeight;box.bottom+=widgetHeight;if(!boxIsAfter(box,x,y,!1)){return!1}
if(box.top<=y&&box.left<=x){chAround=ch;boxAround=box}
return!0},begin,end);var baseX,sticky,outside=!1;if(boxAround){var atLeft=x-boxAround.left<boxAround.right-x,atStart=atLeft==ltr;ch=chAround+(atStart?0:1);sticky=atStart?"after":"before";baseX=atLeft?boxAround.left:boxAround.right}else{if(!ltr&&(ch==end||ch==begin)){ch++}
sticky=ch==0?"after":ch==lineObj.text.length?"before":(measureCharPrepared(cm,preparedMeasure,ch-(ltr?1:0)).bottom+widgetHeight<=y)==ltr?"after":"before";var coords=cursorCoords(cm,Pos(lineNo,ch,sticky),"line",lineObj,preparedMeasure);baseX=coords.left;outside=y<coords.top?-1:y>=coords.bottom?1:0}
ch=skipExtendingChars(lineObj.text,ch,1);return PosWithInfo(lineNo,ch,sticky,outside,x-baseX)}
function coordsBidiPart(cm,lineObj,lineNo,preparedMeasure,order,x,y){var index=findFirst(function(i){var part=order[i],ltr=part.level!=1;return boxIsAfter(cursorCoords(cm,Pos(lineNo,ltr?part.to:part.from,ltr?"before":"after"),"line",lineObj,preparedMeasure),x,y,!0)},0,order.length-1);var part=order[index];if(index>0){var ltr=part.level!=1;var start=cursorCoords(cm,Pos(lineNo,ltr?part.from:part.to,ltr?"after":"before"),"line",lineObj,preparedMeasure);if(boxIsAfter(start,x,y,!0)&&start.top>y){part=order[index-1]}}
return part}
function coordsBidiPartWrapped(cm,lineObj,_lineNo,preparedMeasure,order,x,y){var ref=wrappedLineExtent(cm,lineObj,preparedMeasure,y);var begin=ref.begin;var end=ref.end;if(/\s/.test(lineObj.text.charAt(end-1))){end--}
var part=null,closestDist=null;for(var i=0;i<order.length;i++){var p=order[i];if(p.from>=end||p.to<=begin){continue}
var ltr=p.level!=1;var endX=measureCharPrepared(cm,preparedMeasure,ltr?Math.min(end,p.to)-1:Math.max(begin,p.from)).right;var dist=endX<x?x-endX+1e9:endX-x;if(!part||closestDist>dist){part=p;closestDist=dist}}
if(!part){part=order[order.length-1]}
if(part.from<begin){part={from:begin,to:part.to,level:part.level}}
if(part.to>end){part={from:part.from,to:end,level:part.level}}
return part}
var measureText;function textHeight(display){if(display.cachedTextHeight!=null){return display.cachedTextHeight}
if(measureText==null){measureText=elt("pre",null,"CodeMirror-line-like");for(var i=0;i<49;++i){measureText.appendChild(document.createTextNode("x"));measureText.appendChild(elt("br"))}
measureText.appendChild(document.createTextNode("x"))}
removeChildrenAndAdd(display.measure,measureText);var height=measureText.offsetHeight/50;if(height>3){display.cachedTextHeight=height}
removeChildren(display.measure);return height||1}
function charWidth(display){if(display.cachedCharWidth!=null){return display.cachedCharWidth}
var anchor=elt("span","xxxxxxxxxx");var pre=elt("pre",[anchor],"CodeMirror-line-like");removeChildrenAndAdd(display.measure,pre);var rect=anchor.getBoundingClientRect(),width=(rect.right-rect.left)/10;if(width>2){display.cachedCharWidth=width}
return width||10}
function getDimensions(cm){var d=cm.display,left={},width={};var gutterLeft=d.gutters.clientLeft;for(var n=d.gutters.firstChild,i=0;n;n=n.nextSibling,++i){var id=cm.display.gutterSpecs[i].className;left[id]=n.offsetLeft+n.clientLeft+gutterLeft;width[id]=n.clientWidth}
return{fixedPos:compensateForHScroll(d),gutterTotalWidth:d.gutters.offsetWidth,gutterLeft:left,gutterWidth:width,wrapperWidth:d.wrapper.clientWidth}}
function compensateForHScroll(display){return display.scroller.getBoundingClientRect().left-display.sizer.getBoundingClientRect().left}
function estimateHeight(cm){var th=textHeight(cm.display),wrapping=cm.options.lineWrapping;var perLine=wrapping&&Math.max(5,cm.display.scroller.clientWidth/charWidth(cm.display)-3);return function(line){if(lineIsHidden(cm.doc,line)){return 0}
var widgetsHeight=0;if(line.widgets){for(var i=0;i<line.widgets.length;i++){if(line.widgets[i].height){widgetsHeight+=line.widgets[i].height}}}
if(wrapping){return widgetsHeight+(Math.ceil(line.text.length/perLine)||1)*th}else{return widgetsHeight+th}}}
function estimateLineHeights(cm){var doc=cm.doc,est=estimateHeight(cm);doc.iter(function(line){var estHeight=est(line);if(estHeight!=line.height){updateLineHeight(line,estHeight)}})}
function posFromMouse(cm,e,liberal,forRect){var display=cm.display;if(!liberal&&e_target(e).getAttribute("cm-not-content")=="true"){return null}
var x,y,space=display.lineSpace.getBoundingClientRect();try{x=e.clientX-space.left;y=e.clientY-space.top}catch(e$1){return null}
var coords=coordsChar(cm,x,y),line;if(forRect&&coords.xRel>0&&(line=getLine(cm.doc,coords.line).text).length==coords.ch){var colDiff=countColumn(line,line.length,cm.options.tabSize)-line.length;coords=Pos(coords.line,Math.max(0,Math.round((x-paddingH(cm.display).left)/charWidth(cm.display))-colDiff))}
return coords}
function findViewIndex(cm,n){if(n>=cm.display.viewTo){return null}
n-=cm.display.viewFrom;if(n<0){return null}
var view=cm.display.view;for(var i=0;i<view.length;i++){n-=view[i].size;if(n<0){return i}}}
function regChange(cm,from,to,lendiff){if(from==null){from=cm.doc.first}
if(to==null){to=cm.doc.first+cm.doc.size}
if(!lendiff){lendiff=0}
var display=cm.display;if(lendiff&&to<display.viewTo&&(display.updateLineNumbers==null||display.updateLineNumbers>from)){display.updateLineNumbers=from}
cm.curOp.viewChanged=!0;if(from>=display.viewTo){if(sawCollapsedSpans&&visualLineNo(cm.doc,from)<display.viewTo){resetView(cm)}}else if(to<=display.viewFrom){if(sawCollapsedSpans&&visualLineEndNo(cm.doc,to+lendiff)>display.viewFrom){resetView(cm)}else{display.viewFrom+=lendiff;display.viewTo+=lendiff}}else if(from<=display.viewFrom&&to>=display.viewTo){resetView(cm)}else if(from<=display.viewFrom){var cut=viewCuttingPoint(cm,to,to+lendiff,1);if(cut){display.view=display.view.slice(cut.index);display.viewFrom=cut.lineN;display.viewTo+=lendiff}else{resetView(cm)}}else if(to>=display.viewTo){var cut$1=viewCuttingPoint(cm,from,from,-1);if(cut$1){display.view=display.view.slice(0,cut$1.index);display.viewTo=cut$1.lineN}else{resetView(cm)}}else{var cutTop=viewCuttingPoint(cm,from,from,-1);var cutBot=viewCuttingPoint(cm,to,to+lendiff,1);if(cutTop&&cutBot){display.view=display.view.slice(0,cutTop.index).concat(buildViewArray(cm,cutTop.lineN,cutBot.lineN)).concat(display.view.slice(cutBot.index));display.viewTo+=lendiff}else{resetView(cm)}}
var ext=display.externalMeasured;if(ext){if(to<ext.lineN){ext.lineN+=lendiff}else if(from<ext.lineN+ext.size){display.externalMeasured=null}}}
function regLineChange(cm,line,type){cm.curOp.viewChanged=!0;var display=cm.display,ext=cm.display.externalMeasured;if(ext&&line>=ext.lineN&&line<ext.lineN+ext.size){display.externalMeasured=null}
if(line<display.viewFrom||line>=display.viewTo){return}
var lineView=display.view[findViewIndex(cm,line)];if(lineView.node==null){return}
var arr=lineView.changes||(lineView.changes=[]);if(indexOf(arr,type)==-1){arr.push(type)}}
function resetView(cm){cm.display.viewFrom=cm.display.viewTo=cm.doc.first;cm.display.view=[];cm.display.viewOffset=0}
function viewCuttingPoint(cm,oldN,newN,dir){var index=findViewIndex(cm,oldN),diff,view=cm.display.view;if(!sawCollapsedSpans||newN==cm.doc.first+cm.doc.size){return{index:index,lineN:newN}}
var n=cm.display.viewFrom;for(var i=0;i<index;i++){n+=view[i].size}
if(n!=oldN){if(dir>0){if(index==view.length-1){return null}
diff=(n+view[index].size)-oldN;index++}else{diff=n-oldN}
oldN+=diff;newN+=diff}
while(visualLineNo(cm.doc,newN)!=newN){if(index==(dir<0?0:view.length-1)){return null}
newN+=dir*view[index-(dir<0?1:0)].size;index+=dir}
return{index:index,lineN:newN}}
function adjustView(cm,from,to){var display=cm.display,view=display.view;if(view.length==0||from>=display.viewTo||to<=display.viewFrom){display.view=buildViewArray(cm,from,to);display.viewFrom=from}else{if(display.viewFrom>from){display.view=buildViewArray(cm,from,display.viewFrom).concat(display.view)}else if(display.viewFrom<from){display.view=display.view.slice(findViewIndex(cm,from))}
display.viewFrom=from;if(display.viewTo<to){display.view=display.view.concat(buildViewArray(cm,display.viewTo,to))}else if(display.viewTo>to){display.view=display.view.slice(0,findViewIndex(cm,to))}}
display.viewTo=to}
function countDirtyView(cm){var view=cm.display.view,dirty=0;for(var i=0;i<view.length;i++){var lineView=view[i];if(!lineView.hidden&&(!lineView.node||lineView.changes)){++dirty}}
return dirty}
function updateSelection(cm){cm.display.input.showSelection(cm.display.input.prepareSelection())}
function prepareSelection(cm,primary){if(primary===void 0)primary=!0;var doc=cm.doc,result={};var curFragment=result.cursors=document.createDocumentFragment();var selFragment=result.selection=document.createDocumentFragment();var customCursor=cm.options.$customCursor;if(customCursor){primary=!0}
for(var i=0;i<doc.sel.ranges.length;i++){if(!primary&&i==doc.sel.primIndex){continue}
var range=doc.sel.ranges[i];if(range.from().line>=cm.display.viewTo||range.to().line<cm.display.viewFrom){continue}
var collapsed=range.empty();if(customCursor){var head=customCursor(cm,range);if(head){drawSelectionCursor(cm,head,curFragment)}}else if(collapsed||cm.options.showCursorWhenSelecting){drawSelectionCursor(cm,range.head,curFragment)}
if(!collapsed){drawSelectionRange(cm,range,selFragment)}}
return result}
function drawSelectionCursor(cm,head,output){var pos=cursorCoords(cm,head,"div",null,null,!cm.options.singleCursorHeightPerLine);var cursor=output.appendChild(elt("div","\u00a0","CodeMirror-cursor"));cursor.style.left=pos.left+"px";cursor.style.top=pos.top+"px";cursor.style.height=Math.max(0,pos.bottom-pos.top)*cm.options.cursorHeight+"px";if(/\bcm-fat-cursor\b/.test(cm.getWrapperElement().className)){var charPos=charCoords(cm,head,"div",null,null);var width=charPos.right-charPos.left;cursor.style.width=(width>0?width:cm.defaultCharWidth())+"px"}
if(pos.other){var otherCursor=output.appendChild(elt("div","\u00a0","CodeMirror-cursor CodeMirror-secondarycursor"));otherCursor.style.display="";otherCursor.style.left=pos.other.left+"px";otherCursor.style.top=pos.other.top+"px";otherCursor.style.height=(pos.other.bottom-pos.other.top)*.85+"px"}}
function cmpCoords(a,b){return a.top-b.top||a.left-b.left}
function drawSelectionRange(cm,range,output){var display=cm.display,doc=cm.doc;var fragment=document.createDocumentFragment();var padding=paddingH(cm.display),leftSide=padding.left;var rightSide=Math.max(display.sizerWidth,displayWidth(cm)-display.sizer.offsetLeft)-padding.right;var docLTR=doc.direction=="ltr";function add(left,top,width,bottom){if(top<0){top=0}
top=Math.round(top);bottom=Math.round(bottom);fragment.appendChild(elt("div",null,"CodeMirror-selected",("position: absolute; left: "+left+"px;\n                             top: "+top+"px; width: "+(width==null?rightSide-left:width)+"px;\n                             height: "+(bottom-top)+"px")))}
function drawForLine(line,fromArg,toArg){var lineObj=getLine(doc,line);var lineLen=lineObj.text.length;var start,end;function coords(ch,bias){return charCoords(cm,Pos(line,ch),"div",lineObj,bias)}
function wrapX(pos,dir,side){var extent=wrappedLineExtentChar(cm,lineObj,null,pos);var prop=(dir=="ltr")==(side=="after")?"left":"right";var ch=side=="after"?extent.begin:extent.end-(/\s/.test(lineObj.text.charAt(extent.end-1))?2:1);return coords(ch,prop)[prop]}
var order=getOrder(lineObj,doc.direction);iterateBidiSections(order,fromArg||0,toArg==null?lineLen:toArg,function(from,to,dir,i){var ltr=dir=="ltr";var fromPos=coords(from,ltr?"left":"right");var toPos=coords(to-1,ltr?"right":"left");var openStart=fromArg==null&&from==0,openEnd=toArg==null&&to==lineLen;var first=i==0,last=!order||i==order.length-1;if(toPos.top-fromPos.top<=3){var openLeft=(docLTR?openStart:openEnd)&&first;var openRight=(docLTR?openEnd:openStart)&&last;var left=openLeft?leftSide:(ltr?fromPos:toPos).left;var right=openRight?rightSide:(ltr?toPos:fromPos).right;add(left,fromPos.top,right-left,fromPos.bottom)}else{var topLeft,topRight,botLeft,botRight;if(ltr){topLeft=docLTR&&openStart&&first?leftSide:fromPos.left;topRight=docLTR?rightSide:wrapX(from,dir,"before");botLeft=docLTR?leftSide:wrapX(to,dir,"after");botRight=docLTR&&openEnd&&last?rightSide:toPos.right}else{topLeft=!docLTR?leftSide:wrapX(from,dir,"before");topRight=!docLTR&&openStart&&first?rightSide:fromPos.right;botLeft=!docLTR&&openEnd&&last?leftSide:toPos.left;botRight=!docLTR?rightSide:wrapX(to,dir,"after")}
add(topLeft,fromPos.top,topRight-topLeft,fromPos.bottom);if(fromPos.bottom<toPos.top){add(leftSide,fromPos.bottom,null,toPos.top)}
add(botLeft,toPos.top,botRight-botLeft,toPos.bottom)}
if(!start||cmpCoords(fromPos,start)<0){start=fromPos}
if(cmpCoords(toPos,start)<0){start=toPos}
if(!end||cmpCoords(fromPos,end)<0){end=fromPos}
if(cmpCoords(toPos,end)<0){end=toPos}});return{start:start,end:end}}
var sFrom=range.from(),sTo=range.to();if(sFrom.line==sTo.line){drawForLine(sFrom.line,sFrom.ch,sTo.ch)}else{var fromLine=getLine(doc,sFrom.line),toLine=getLine(doc,sTo.line);var singleVLine=visualLine(fromLine)==visualLine(toLine);var leftEnd=drawForLine(sFrom.line,sFrom.ch,singleVLine?fromLine.text.length+1:null).end;var rightStart=drawForLine(sTo.line,singleVLine?0:null,sTo.ch).start;if(singleVLine){if(leftEnd.top<rightStart.top-2){add(leftEnd.right,leftEnd.top,null,leftEnd.bottom);add(leftSide,rightStart.top,rightStart.left,rightStart.bottom)}else{add(leftEnd.right,leftEnd.top,rightStart.left-leftEnd.right,leftEnd.bottom)}}
if(leftEnd.bottom<rightStart.top){add(leftSide,leftEnd.bottom,null,rightStart.top)}}
output.appendChild(fragment)}
function restartBlink(cm){if(!cm.state.focused){return}
var display=cm.display;clearInterval(display.blinker);var on=!0;display.cursorDiv.style.visibility="";if(cm.options.cursorBlinkRate>0){display.blinker=setInterval(function(){if(!cm.hasFocus()){onBlur(cm)}
display.cursorDiv.style.visibility=(on=!on)?"":"hidden"},cm.options.cursorBlinkRate)}else if(cm.options.cursorBlinkRate<0){display.cursorDiv.style.visibility="hidden"}}
function ensureFocus(cm){if(!cm.hasFocus()){cm.display.input.focus();if(!cm.state.focused){onFocus(cm)}}}
function delayBlurEvent(cm){cm.state.delayingBlurEvent=!0;setTimeout(function(){if(cm.state.delayingBlurEvent){cm.state.delayingBlurEvent=!1;if(cm.state.focused){onBlur(cm)}}},100)}
function onFocus(cm,e){if(cm.state.delayingBlurEvent&&!cm.state.draggingText){cm.state.delayingBlurEvent=!1}
if(cm.options.readOnly=="nocursor"){return}
if(!cm.state.focused){signal(cm,"focus",cm,e);cm.state.focused=!0;addClass(cm.display.wrapper,"CodeMirror-focused");if(!cm.curOp&&cm.display.selForContextMenu!=cm.doc.sel){cm.display.input.reset();if(webkit){setTimeout(function(){return cm.display.input.reset(!0)},20)}}
cm.display.input.receivedFocus()}
restartBlink(cm)}
function onBlur(cm,e){if(cm.state.delayingBlurEvent){return}
if(cm.state.focused){signal(cm,"blur",cm,e);cm.state.focused=!1;rmClass(cm.display.wrapper,"CodeMirror-focused")}
clearInterval(cm.display.blinker);setTimeout(function(){if(!cm.state.focused){cm.display.shift=!1}},150)}
function updateHeightsInViewport(cm){var display=cm.display;var prevBottom=display.lineDiv.offsetTop;var viewTop=Math.max(0,display.scroller.getBoundingClientRect().top);var oldHeight=display.lineDiv.getBoundingClientRect().top;var mustScroll=0;for(var i=0;i<display.view.length;i++){var cur=display.view[i],wrapping=cm.options.lineWrapping;var height=(void 0),width=0;if(cur.hidden){continue}
oldHeight+=cur.line.height;if(ie&&ie_version<8){var bot=cur.node.offsetTop+cur.node.offsetHeight;height=bot-prevBottom;prevBottom=bot}else{var box=cur.node.getBoundingClientRect();height=box.bottom-box.top;if(!wrapping&&cur.text.firstChild){width=cur.text.firstChild.getBoundingClientRect().right-box.left-1}}
var diff=cur.line.height-height;if(diff>.005||diff<-.005){if(oldHeight<viewTop){mustScroll-=diff}
updateLineHeight(cur.line,height);updateWidgetHeight(cur.line);if(cur.rest){for(var j=0;j<cur.rest.length;j++){updateWidgetHeight(cur.rest[j])}}}
if(width>cm.display.sizerWidth){var chWidth=Math.ceil(width/charWidth(cm.display));if(chWidth>cm.display.maxLineLength){cm.display.maxLineLength=chWidth;cm.display.maxLine=cur.line;cm.display.maxLineChanged=!0}}}
if(Math.abs(mustScroll)>2){display.scroller.scrollTop+=mustScroll}}
function updateWidgetHeight(line){if(line.widgets){for(var i=0;i<line.widgets.length;++i){var w=line.widgets[i],parent=w.node.parentNode;if(parent){w.height=parent.offsetHeight}}}}
function visibleLines(display,doc,viewport){var top=viewport&&viewport.top!=null?Math.max(0,viewport.top):display.scroller.scrollTop;top=Math.floor(top-paddingTop(display));var bottom=viewport&&viewport.bottom!=null?viewport.bottom:top+display.wrapper.clientHeight;var from=lineAtHeight(doc,top),to=lineAtHeight(doc,bottom);if(viewport&&viewport.ensure){var ensureFrom=viewport.ensure.from.line,ensureTo=viewport.ensure.to.line;if(ensureFrom<from){from=ensureFrom;to=lineAtHeight(doc,heightAtLine(getLine(doc,ensureFrom))+display.wrapper.clientHeight)}else if(Math.min(ensureTo,doc.lastLine())>=to){from=lineAtHeight(doc,heightAtLine(getLine(doc,ensureTo))-display.wrapper.clientHeight);to=ensureTo}}
return{from:from,to:Math.max(to,from+1)}}
function maybeScrollWindow(cm,rect){if(signalDOMEvent(cm,"scrollCursorIntoView")){return}
var display=cm.display,box=display.sizer.getBoundingClientRect(),doScroll=null;var doc=display.wrapper.ownerDocument;if(rect.top+box.top<0){doScroll=!0}else if(rect.bottom+box.top>(doc.defaultView.innerHeight||doc.documentElement.clientHeight)){doScroll=!1}
if(doScroll!=null&&!phantom){var scrollNode=elt("div","\u200b",null,("position: absolute;\n                         top: "+(rect.top-display.viewOffset-paddingTop(cm.display))+"px;\n                         height: "+(rect.bottom-rect.top+scrollGap(cm)+display.barHeight)+"px;\n                         left: "+(rect.left)+"px; width: "+(Math.max(2,rect.right-rect.left))+"px;"));cm.display.lineSpace.appendChild(scrollNode);scrollNode.scrollIntoView(doScroll);cm.display.lineSpace.removeChild(scrollNode)}}
function scrollPosIntoView(cm,pos,end,margin){if(margin==null){margin=0}
var rect;if(!cm.options.lineWrapping&&pos==end){end=pos.sticky=="before"?Pos(pos.line,pos.ch+1,"before"):pos;pos=pos.ch?Pos(pos.line,pos.sticky=="before"?pos.ch-1:pos.ch,"after"):pos}
for(var limit=0;limit<5;limit++){var changed=!1;var coords=cursorCoords(cm,pos);var endCoords=!end||end==pos?coords:cursorCoords(cm,end);rect={left:Math.min(coords.left,endCoords.left),top:Math.min(coords.top,endCoords.top)-margin,right:Math.max(coords.left,endCoords.left),bottom:Math.max(coords.bottom,endCoords.bottom)+margin};var scrollPos=calculateScrollPos(cm,rect);var startTop=cm.doc.scrollTop,startLeft=cm.doc.scrollLeft;if(scrollPos.scrollTop!=null){updateScrollTop(cm,scrollPos.scrollTop);if(Math.abs(cm.doc.scrollTop-startTop)>1){changed=!0}}
if(scrollPos.scrollLeft!=null){setScrollLeft(cm,scrollPos.scrollLeft);if(Math.abs(cm.doc.scrollLeft-startLeft)>1){changed=!0}}
if(!changed){break}}
return rect}
function scrollIntoView(cm,rect){var scrollPos=calculateScrollPos(cm,rect);if(scrollPos.scrollTop!=null){updateScrollTop(cm,scrollPos.scrollTop)}
if(scrollPos.scrollLeft!=null){setScrollLeft(cm,scrollPos.scrollLeft)}}
function calculateScrollPos(cm,rect){var display=cm.display,snapMargin=textHeight(cm.display);if(rect.top<0){rect.top=0}
var screentop=cm.curOp&&cm.curOp.scrollTop!=null?cm.curOp.scrollTop:display.scroller.scrollTop;var screen=displayHeight(cm),result={};if(rect.bottom-rect.top>screen){rect.bottom=rect.top+screen}
var docBottom=cm.doc.height+paddingVert(display);var atTop=rect.top<snapMargin,atBottom=rect.bottom>docBottom-snapMargin;if(rect.top<screentop){result.scrollTop=atTop?0:rect.top}else if(rect.bottom>screentop+screen){var newTop=Math.min(rect.top,(atBottom?docBottom:rect.bottom)-screen);if(newTop!=screentop){result.scrollTop=newTop}}
var gutterSpace=cm.options.fixedGutter?0:display.gutters.offsetWidth;var screenleft=cm.curOp&&cm.curOp.scrollLeft!=null?cm.curOp.scrollLeft:display.scroller.scrollLeft-gutterSpace;var screenw=displayWidth(cm)-display.gutters.offsetWidth;var tooWide=rect.right-rect.left>screenw;if(tooWide){rect.right=rect.left+screenw}
if(rect.left<10){result.scrollLeft=0}else if(rect.left<screenleft){result.scrollLeft=Math.max(0,rect.left+gutterSpace-(tooWide?0:10))}else if(rect.right>screenw+screenleft-3){result.scrollLeft=rect.right+(tooWide?0:10)-screenw}
return result}
function addToScrollTop(cm,top){if(top==null){return}
resolveScrollToPos(cm);cm.curOp.scrollTop=(cm.curOp.scrollTop==null?cm.doc.scrollTop:cm.curOp.scrollTop)+top}
function ensureCursorVisible(cm){resolveScrollToPos(cm);var cur=cm.getCursor();cm.curOp.scrollToPos={from:cur,to:cur,margin:cm.options.cursorScrollMargin}}
function scrollToCoords(cm,x,y){if(x!=null||y!=null){resolveScrollToPos(cm)}
if(x!=null){cm.curOp.scrollLeft=x}
if(y!=null){cm.curOp.scrollTop=y}}
function scrollToRange(cm,range){resolveScrollToPos(cm);cm.curOp.scrollToPos=range}
function resolveScrollToPos(cm){var range=cm.curOp.scrollToPos;if(range){cm.curOp.scrollToPos=null;var from=estimateCoords(cm,range.from),to=estimateCoords(cm,range.to);scrollToCoordsRange(cm,from,to,range.margin)}}
function scrollToCoordsRange(cm,from,to,margin){var sPos=calculateScrollPos(cm,{left:Math.min(from.left,to.left),top:Math.min(from.top,to.top)-margin,right:Math.max(from.right,to.right),bottom:Math.max(from.bottom,to.bottom)+margin});scrollToCoords(cm,sPos.scrollLeft,sPos.scrollTop)}
function updateScrollTop(cm,val){if(Math.abs(cm.doc.scrollTop-val)<2){return}
if(!gecko){updateDisplaySimple(cm,{top:val})}
setScrollTop(cm,val,!0);if(gecko){updateDisplaySimple(cm)}
startWorker(cm,100)}
function setScrollTop(cm,val,forceScroll){val=Math.max(0,Math.min(cm.display.scroller.scrollHeight-cm.display.scroller.clientHeight,val));if(cm.display.scroller.scrollTop==val&&!forceScroll){return}
cm.doc.scrollTop=val;cm.display.scrollbars.setScrollTop(val);if(cm.display.scroller.scrollTop!=val){cm.display.scroller.scrollTop=val}}
function setScrollLeft(cm,val,isScroller,forceScroll){val=Math.max(0,Math.min(val,cm.display.scroller.scrollWidth-cm.display.scroller.clientWidth));if((isScroller?val==cm.doc.scrollLeft:Math.abs(cm.doc.scrollLeft-val)<2)&&!forceScroll){return}
cm.doc.scrollLeft=val;alignHorizontally(cm);if(cm.display.scroller.scrollLeft!=val){cm.display.scroller.scrollLeft=val}
cm.display.scrollbars.setScrollLeft(val)}
function measureForScrollbars(cm){var d=cm.display,gutterW=d.gutters.offsetWidth;var docH=Math.round(cm.doc.height+paddingVert(cm.display));return{clientHeight:d.scroller.clientHeight,viewHeight:d.wrapper.clientHeight,scrollWidth:d.scroller.scrollWidth,clientWidth:d.scroller.clientWidth,viewWidth:d.wrapper.clientWidth,barLeft:cm.options.fixedGutter?gutterW:0,docHeight:docH,scrollHeight:docH+scrollGap(cm)+d.barHeight,nativeBarWidth:d.nativeBarWidth,gutterWidth:gutterW}}
var NativeScrollbars=function(place,scroll,cm){this.cm=cm;var vert=this.vert=elt("div",[elt("div",null,null,"min-width: 1px")],"CodeMirror-vscrollbar");var horiz=this.horiz=elt("div",[elt("div",null,null,"height: 100%; min-height: 1px")],"CodeMirror-hscrollbar");vert.tabIndex=horiz.tabIndex=-1;place(vert);place(horiz);on(vert,"scroll",function(){if(vert.clientHeight){scroll(vert.scrollTop,"vertical")}});on(horiz,"scroll",function(){if(horiz.clientWidth){scroll(horiz.scrollLeft,"horizontal")}});this.checkedZeroWidth=!1;if(ie&&ie_version<8){this.horiz.style.minHeight=this.vert.style.minWidth="18px"}};NativeScrollbars.prototype.update=function(measure){var needsH=measure.scrollWidth>measure.clientWidth+1;var needsV=measure.scrollHeight>measure.clientHeight+1;var sWidth=measure.nativeBarWidth;if(needsV){this.vert.style.display="block";this.vert.style.bottom=needsH?sWidth+"px":"0";var totalHeight=measure.viewHeight-(needsH?sWidth:0);this.vert.firstChild.style.height=Math.max(0,measure.scrollHeight-measure.clientHeight+totalHeight)+"px"}else{this.vert.scrollTop=0;this.vert.style.display="";this.vert.firstChild.style.height="0"}
if(needsH){this.horiz.style.display="block";this.horiz.style.right=needsV?sWidth+"px":"0";this.horiz.style.left=measure.barLeft+"px";var totalWidth=measure.viewWidth-measure.barLeft-(needsV?sWidth:0);this.horiz.firstChild.style.width=Math.max(0,measure.scrollWidth-measure.clientWidth+totalWidth)+"px"}else{this.horiz.style.display="";this.horiz.firstChild.style.width="0"}
if(!this.checkedZeroWidth&&measure.clientHeight>0){if(sWidth==0){this.zeroWidthHack()}
this.checkedZeroWidth=!0}
return{right:needsV?sWidth:0,bottom:needsH?sWidth:0}};NativeScrollbars.prototype.setScrollLeft=function(pos){if(this.horiz.scrollLeft!=pos){this.horiz.scrollLeft=pos}
if(this.disableHoriz){this.enableZeroWidthBar(this.horiz,this.disableHoriz,"horiz")}};NativeScrollbars.prototype.setScrollTop=function(pos){if(this.vert.scrollTop!=pos){this.vert.scrollTop=pos}
if(this.disableVert){this.enableZeroWidthBar(this.vert,this.disableVert,"vert")}};NativeScrollbars.prototype.zeroWidthHack=function(){var w=mac&&!mac_geMountainLion?"12px":"18px";this.horiz.style.height=this.vert.style.width=w;this.horiz.style.visibility=this.vert.style.visibility="hidden";this.disableHoriz=new Delayed;this.disableVert=new Delayed};NativeScrollbars.prototype.enableZeroWidthBar=function(bar,delay,type){bar.style.visibility="";function maybeDisable(){var box=bar.getBoundingClientRect();var elt=type=="vert"?document.elementFromPoint(box.right-1,(box.top+box.bottom)/2):document.elementFromPoint((box.right+box.left)/2,box.bottom-1);if(elt!=bar){bar.style.visibility="hidden"}else{delay.set(1000,maybeDisable)}}
delay.set(1000,maybeDisable)};NativeScrollbars.prototype.clear=function(){var parent=this.horiz.parentNode;parent.removeChild(this.horiz);parent.removeChild(this.vert)};var NullScrollbars=function(){};NullScrollbars.prototype.update=function(){return{bottom:0,right:0}};NullScrollbars.prototype.setScrollLeft=function(){};NullScrollbars.prototype.setScrollTop=function(){};NullScrollbars.prototype.clear=function(){};function updateScrollbars(cm,measure){if(!measure){measure=measureForScrollbars(cm)}
var startWidth=cm.display.barWidth,startHeight=cm.display.barHeight;updateScrollbarsInner(cm,measure);for(var i=0;i<4&&startWidth!=cm.display.barWidth||startHeight!=cm.display.barHeight;i++){if(startWidth!=cm.display.barWidth&&cm.options.lineWrapping){updateHeightsInViewport(cm)}
updateScrollbarsInner(cm,measureForScrollbars(cm));startWidth=cm.display.barWidth;startHeight=cm.display.barHeight}}
function updateScrollbarsInner(cm,measure){var d=cm.display;var sizes=d.scrollbars.update(measure);d.sizer.style.paddingRight=(d.barWidth=sizes.right)+"px";d.sizer.style.paddingBottom=(d.barHeight=sizes.bottom)+"px";d.heightForcer.style.borderBottom=sizes.bottom+"px solid transparent";if(sizes.right&&sizes.bottom){d.scrollbarFiller.style.display="block";d.scrollbarFiller.style.height=sizes.bottom+"px";d.scrollbarFiller.style.width=sizes.right+"px"}else{d.scrollbarFiller.style.display=""}
if(sizes.bottom&&cm.options.coverGutterNextToScrollbar&&cm.options.fixedGutter){d.gutterFiller.style.display="block";d.gutterFiller.style.height=sizes.bottom+"px";d.gutterFiller.style.width=measure.gutterWidth+"px"}else{d.gutterFiller.style.display=""}}
var scrollbarModel={"native":NativeScrollbars,"null":NullScrollbars};function initScrollbars(cm){if(cm.display.scrollbars){cm.display.scrollbars.clear();if(cm.display.scrollbars.addClass){rmClass(cm.display.wrapper,cm.display.scrollbars.addClass)}}
cm.display.scrollbars=new scrollbarModel[cm.options.scrollbarStyle](function(node){cm.display.wrapper.insertBefore(node,cm.display.scrollbarFiller);on(node,"mousedown",function(){if(cm.state.focused){setTimeout(function(){return cm.display.input.focus()},0)}});node.setAttribute("cm-not-content","true")},function(pos,axis){if(axis=="horizontal"){setScrollLeft(cm,pos)}else{updateScrollTop(cm,pos)}},cm);if(cm.display.scrollbars.addClass){addClass(cm.display.wrapper,cm.display.scrollbars.addClass)}}
var nextOpId=0;function startOperation(cm){cm.curOp={cm:cm,viewChanged:!1,startHeight:cm.doc.height,forceUpdate:!1,updateInput:0,typing:!1,changeObjs:null,cursorActivityHandlers:null,cursorActivityCalled:0,selectionChanged:!1,updateMaxLine:!1,scrollLeft:null,scrollTop:null,scrollToPos:null,focus:!1,id:++nextOpId,markArrays:null};pushOperation(cm.curOp)}
function endOperation(cm){var op=cm.curOp;if(op){finishOperation(op,function(group){for(var i=0;i<group.ops.length;i++){group.ops[i].cm.curOp=null}
endOperations(group)})}}
function endOperations(group){var ops=group.ops;for(var i=0;i<ops.length;i++){endOperation_R1(ops[i])}
for(var i$1=0;i$1<ops.length;i$1++){endOperation_W1(ops[i$1])}
for(var i$2=0;i$2<ops.length;i$2++){endOperation_R2(ops[i$2])}
for(var i$3=0;i$3<ops.length;i$3++){endOperation_W2(ops[i$3])}
for(var i$4=0;i$4<ops.length;i$4++){endOperation_finish(ops[i$4])}}
function endOperation_R1(op){var cm=op.cm,display=cm.display;maybeClipScrollbars(cm);if(op.updateMaxLine){findMaxLine(cm)}
op.mustUpdate=op.viewChanged||op.forceUpdate||op.scrollTop!=null||op.scrollToPos&&(op.scrollToPos.from.line<display.viewFrom||op.scrollToPos.to.line>=display.viewTo)||display.maxLineChanged&&cm.options.lineWrapping;op.update=op.mustUpdate&&new DisplayUpdate(cm,op.mustUpdate&&{top:op.scrollTop,ensure:op.scrollToPos},op.forceUpdate)}
function endOperation_W1(op){op.updatedDisplay=op.mustUpdate&&updateDisplayIfNeeded(op.cm,op.update)}
function endOperation_R2(op){var cm=op.cm,display=cm.display;if(op.updatedDisplay){updateHeightsInViewport(cm)}
op.barMeasure=measureForScrollbars(cm);if(display.maxLineChanged&&!cm.options.lineWrapping){op.adjustWidthTo=measureChar(cm,display.maxLine,display.maxLine.text.length).left+3;cm.display.sizerWidth=op.adjustWidthTo;op.barMeasure.scrollWidth=Math.max(display.scroller.clientWidth,display.sizer.offsetLeft+op.adjustWidthTo+scrollGap(cm)+cm.display.barWidth);op.maxScrollLeft=Math.max(0,display.sizer.offsetLeft+op.adjustWidthTo-displayWidth(cm))}
if(op.updatedDisplay||op.selectionChanged){op.preparedSelection=display.input.prepareSelection()}}
function endOperation_W2(op){var cm=op.cm;if(op.adjustWidthTo!=null){cm.display.sizer.style.minWidth=op.adjustWidthTo+"px";if(op.maxScrollLeft<cm.doc.scrollLeft){setScrollLeft(cm,Math.min(cm.display.scroller.scrollLeft,op.maxScrollLeft),!0)}
cm.display.maxLineChanged=!1}
var takeFocus=op.focus&&op.focus==activeElt(root(cm));if(op.preparedSelection){cm.display.input.showSelection(op.preparedSelection,takeFocus)}
if(op.updatedDisplay||op.startHeight!=cm.doc.height){updateScrollbars(cm,op.barMeasure)}
if(op.updatedDisplay){setDocumentHeight(cm,op.barMeasure)}
if(op.selectionChanged){restartBlink(cm)}
if(cm.state.focused&&op.updateInput){cm.display.input.reset(op.typing)}
if(takeFocus){ensureFocus(op.cm)}}
function endOperation_finish(op){var cm=op.cm,display=cm.display,doc=cm.doc;if(op.updatedDisplay){postUpdateDisplay(cm,op.update)}
if(display.wheelStartX!=null&&(op.scrollTop!=null||op.scrollLeft!=null||op.scrollToPos)){display.wheelStartX=display.wheelStartY=null}
if(op.scrollTop!=null){setScrollTop(cm,op.scrollTop,op.forceScroll)}
if(op.scrollLeft!=null){setScrollLeft(cm,op.scrollLeft,!0,!0)}
if(op.scrollToPos){var rect=scrollPosIntoView(cm,clipPos(doc,op.scrollToPos.from),clipPos(doc,op.scrollToPos.to),op.scrollToPos.margin);maybeScrollWindow(cm,rect)}
var hidden=op.maybeHiddenMarkers,unhidden=op.maybeUnhiddenMarkers;if(hidden){for(var i=0;i<hidden.length;++i){if(!hidden[i].lines.length){signal(hidden[i],"hide")}}}
if(unhidden){for(var i$1=0;i$1<unhidden.length;++i$1){if(unhidden[i$1].lines.length){signal(unhidden[i$1],"unhide")}}}
if(display.wrapper.offsetHeight){doc.scrollTop=cm.display.scroller.scrollTop}
if(op.changeObjs){signal(cm,"changes",cm,op.changeObjs)}
if(op.update){op.update.finish()}}
function runInOp(cm,f){if(cm.curOp){return f()}
startOperation(cm);try{return f()}finally{endOperation(cm)}}
function operation(cm,f){return function(){if(cm.curOp){return f.apply(cm,arguments)}
startOperation(cm);try{return f.apply(cm,arguments)}finally{endOperation(cm)}}}
function methodOp(f){return function(){if(this.curOp){return f.apply(this,arguments)}
startOperation(this);try{return f.apply(this,arguments)}finally{endOperation(this)}}}
function docMethodOp(f){return function(){var cm=this.cm;if(!cm||cm.curOp){return f.apply(this,arguments)}
startOperation(cm);try{return f.apply(this,arguments)}finally{endOperation(cm)}}}
function startWorker(cm,time){if(cm.doc.highlightFrontier<cm.display.viewTo){cm.state.highlight.set(time,bind(highlightWorker,cm))}}
function highlightWorker(cm){var doc=cm.doc;if(doc.highlightFrontier>=cm.display.viewTo){return}
var end=+new Date+cm.options.workTime;var context=getContextBefore(cm,doc.highlightFrontier);var changedLines=[];doc.iter(context.line,Math.min(doc.first+doc.size,cm.display.viewTo+500),function(line){if(context.line>=cm.display.viewFrom){var oldStyles=line.styles;var resetState=line.text.length>cm.options.maxHighlightLength?copyState(doc.mode,context.state):null;var highlighted=highlightLine(cm,line,context,!0);if(resetState){context.state=resetState}
line.styles=highlighted.styles;var oldCls=line.styleClasses,newCls=highlighted.classes;if(newCls){line.styleClasses=newCls}else if(oldCls){line.styleClasses=null}
var ischange=!oldStyles||oldStyles.length!=line.styles.length||oldCls!=newCls&&(!oldCls||!newCls||oldCls.bgClass!=newCls.bgClass||oldCls.textClass!=newCls.textClass);for(var i=0;!ischange&&i<oldStyles.length;++i){ischange=oldStyles[i]!=line.styles[i]}
if(ischange){changedLines.push(context.line)}
line.stateAfter=context.save();context.nextLine()}else{if(line.text.length<=cm.options.maxHighlightLength){processLine(cm,line.text,context)}
line.stateAfter=context.line%5==0?context.save():null;context.nextLine()}
if(+new Date>end){startWorker(cm,cm.options.workDelay);return!0}});doc.highlightFrontier=context.line;doc.modeFrontier=Math.max(doc.modeFrontier,context.line);if(changedLines.length){runInOp(cm,function(){for(var i=0;i<changedLines.length;i++){regLineChange(cm,changedLines[i],"text")}})}}
var DisplayUpdate=function(cm,viewport,force){var display=cm.display;this.viewport=viewport;this.visible=visibleLines(display,cm.doc,viewport);this.editorIsHidden=!display.wrapper.offsetWidth;this.wrapperHeight=display.wrapper.clientHeight;this.wrapperWidth=display.wrapper.clientWidth;this.oldDisplayWidth=displayWidth(cm);this.force=force;this.dims=getDimensions(cm);this.events=[]};DisplayUpdate.prototype.signal=function(emitter,type){if(hasHandler(emitter,type)){this.events.push(arguments)}};DisplayUpdate.prototype.finish=function(){for(var i=0;i<this.events.length;i++){signal.apply(null,this.events[i])}};function maybeClipScrollbars(cm){var display=cm.display;if(!display.scrollbarsClipped&&display.scroller.offsetWidth){display.nativeBarWidth=display.scroller.offsetWidth-display.scroller.clientWidth;display.heightForcer.style.height=scrollGap(cm)+"px";display.sizer.style.marginBottom=-display.nativeBarWidth+"px";display.sizer.style.borderRightWidth=scrollGap(cm)+"px";display.scrollbarsClipped=!0}}
function selectionSnapshot(cm){if(cm.hasFocus()){return null}
var active=activeElt(root(cm));if(!active||!contains(cm.display.lineDiv,active)){return null}
var result={activeElt:active};if(window.getSelection){var sel=win(cm).getSelection();if(sel.anchorNode&&sel.extend&&contains(cm.display.lineDiv,sel.anchorNode)){result.anchorNode=sel.anchorNode;result.anchorOffset=sel.anchorOffset;result.focusNode=sel.focusNode;result.focusOffset=sel.focusOffset}}
return result}
function restoreSelection(snapshot){if(!snapshot||!snapshot.activeElt||snapshot.activeElt==activeElt(rootNode(snapshot.activeElt))){return}
snapshot.activeElt.focus();if(!/^(INPUT|TEXTAREA)$/.test(snapshot.activeElt.nodeName)&&snapshot.anchorNode&&contains(document.body,snapshot.anchorNode)&&contains(document.body,snapshot.focusNode)){var doc=snapshot.activeElt.ownerDocument;var sel=doc.defaultView.getSelection(),range=doc.createRange();range.setEnd(snapshot.anchorNode,snapshot.anchorOffset);range.collapse(!1);sel.removeAllRanges();sel.addRange(range);sel.extend(snapshot.focusNode,snapshot.focusOffset)}}
function updateDisplayIfNeeded(cm,update){var display=cm.display,doc=cm.doc;if(update.editorIsHidden){resetView(cm);return!1}
if(!update.force&&update.visible.from>=display.viewFrom&&update.visible.to<=display.viewTo&&(display.updateLineNumbers==null||display.updateLineNumbers>=display.viewTo)&&display.renderedView==display.view&&countDirtyView(cm)==0){return!1}
if(maybeUpdateLineNumberWidth(cm)){resetView(cm);update.dims=getDimensions(cm)}
var end=doc.first+doc.size;var from=Math.max(update.visible.from-cm.options.viewportMargin,doc.first);var to=Math.min(end,update.visible.to+cm.options.viewportMargin);if(display.viewFrom<from&&from-display.viewFrom<20){from=Math.max(doc.first,display.viewFrom)}
if(display.viewTo>to&&display.viewTo-to<20){to=Math.min(end,display.viewTo)}
if(sawCollapsedSpans){from=visualLineNo(cm.doc,from);to=visualLineEndNo(cm.doc,to)}
var different=from!=display.viewFrom||to!=display.viewTo||display.lastWrapHeight!=update.wrapperHeight||display.lastWrapWidth!=update.wrapperWidth;adjustView(cm,from,to);display.viewOffset=heightAtLine(getLine(cm.doc,display.viewFrom));cm.display.mover.style.top=display.viewOffset+"px";var toUpdate=countDirtyView(cm);if(!different&&toUpdate==0&&!update.force&&display.renderedView==display.view&&(display.updateLineNumbers==null||display.updateLineNumbers>=display.viewTo)){return!1}
var selSnapshot=selectionSnapshot(cm);if(toUpdate>4){display.lineDiv.style.display="none"}
patchDisplay(cm,display.updateLineNumbers,update.dims);if(toUpdate>4){display.lineDiv.style.display=""}
display.renderedView=display.view;restoreSelection(selSnapshot);removeChildren(display.cursorDiv);removeChildren(display.selectionDiv);display.gutters.style.height=display.sizer.style.minHeight=0;if(different){display.lastWrapHeight=update.wrapperHeight;display.lastWrapWidth=update.wrapperWidth;startWorker(cm,400)}
display.updateLineNumbers=null;return!0}
function postUpdateDisplay(cm,update){var viewport=update.viewport;for(var first=!0;;first=!1){if(!first||!cm.options.lineWrapping||update.oldDisplayWidth==displayWidth(cm)){if(viewport&&viewport.top!=null){viewport={top:Math.min(cm.doc.height+paddingVert(cm.display)-displayHeight(cm),viewport.top)}}
update.visible=visibleLines(cm.display,cm.doc,viewport);if(update.visible.from>=cm.display.viewFrom&&update.visible.to<=cm.display.viewTo){break}}else if(first){update.visible=visibleLines(cm.display,cm.doc,viewport)}
if(!updateDisplayIfNeeded(cm,update)){break}
updateHeightsInViewport(cm);var barMeasure=measureForScrollbars(cm);updateSelection(cm);updateScrollbars(cm,barMeasure);setDocumentHeight(cm,barMeasure);update.force=!1}
update.signal(cm,"update",cm);if(cm.display.viewFrom!=cm.display.reportedViewFrom||cm.display.viewTo!=cm.display.reportedViewTo){update.signal(cm,"viewportChange",cm,cm.display.viewFrom,cm.display.viewTo);cm.display.reportedViewFrom=cm.display.viewFrom;cm.display.reportedViewTo=cm.display.viewTo}}
function updateDisplaySimple(cm,viewport){var update=new DisplayUpdate(cm,viewport);if(updateDisplayIfNeeded(cm,update)){updateHeightsInViewport(cm);postUpdateDisplay(cm,update);var barMeasure=measureForScrollbars(cm);updateSelection(cm);updateScrollbars(cm,barMeasure);setDocumentHeight(cm,barMeasure);update.finish()}}
function patchDisplay(cm,updateNumbersFrom,dims){var display=cm.display,lineNumbers=cm.options.lineNumbers;var container=display.lineDiv,cur=container.firstChild;function rm(node){var next=node.nextSibling;if(webkit&&mac&&cm.display.currentWheelTarget==node){node.style.display="none"}else{node.parentNode.removeChild(node)}
return next}
var view=display.view,lineN=display.viewFrom;for(var i=0;i<view.length;i++){var lineView=view[i];if(lineView.hidden);else if(!lineView.node||lineView.node.parentNode!=container){var node=buildLineElement(cm,lineView,lineN,dims);container.insertBefore(node,cur)}else{while(cur!=lineView.node){cur=rm(cur)}
var updateNumber=lineNumbers&&updateNumbersFrom!=null&&updateNumbersFrom<=lineN&&lineView.lineNumber;if(lineView.changes){if(indexOf(lineView.changes,"gutter")>-1){updateNumber=!1}
updateLineForChanges(cm,lineView,lineN,dims)}
if(updateNumber){removeChildren(lineView.lineNumber);lineView.lineNumber.appendChild(document.createTextNode(lineNumberFor(cm.options,lineN)))}
cur=lineView.node.nextSibling}
lineN+=lineView.size}
while(cur){cur=rm(cur)}}
function updateGutterSpace(display){var width=display.gutters.offsetWidth;display.sizer.style.marginLeft=width+"px";signalLater(display,"gutterChanged",display)}
function setDocumentHeight(cm,measure){cm.display.sizer.style.minHeight=measure.docHeight+"px";cm.display.heightForcer.style.top=measure.docHeight+"px";cm.display.gutters.style.height=(measure.docHeight+cm.display.barHeight+scrollGap(cm))+"px"}
function alignHorizontally(cm){var display=cm.display,view=display.view;if(!display.alignWidgets&&(!display.gutters.firstChild||!cm.options.fixedGutter)){return}
var comp=compensateForHScroll(display)-display.scroller.scrollLeft+cm.doc.scrollLeft;var gutterW=display.gutters.offsetWidth,left=comp+"px";for(var i=0;i<view.length;i++){if(!view[i].hidden){if(cm.options.fixedGutter){if(view[i].gutter){view[i].gutter.style.left=left}
if(view[i].gutterBackground){view[i].gutterBackground.style.left=left}}
var align=view[i].alignable;if(align){for(var j=0;j<align.length;j++){align[j].style.left=left}}}}
if(cm.options.fixedGutter){display.gutters.style.left=(comp+gutterW)+"px"}}
function maybeUpdateLineNumberWidth(cm){if(!cm.options.lineNumbers){return!1}
var doc=cm.doc,last=lineNumberFor(cm.options,doc.first+doc.size-1),display=cm.display;if(last.length!=display.lineNumChars){var test=display.measure.appendChild(elt("div",[elt("div",last)],"CodeMirror-linenumber CodeMirror-gutter-elt"));var innerW=test.firstChild.offsetWidth,padding=test.offsetWidth-innerW;display.lineGutter.style.width="";display.lineNumInnerWidth=Math.max(innerW,display.lineGutter.offsetWidth-padding)+1;display.lineNumWidth=display.lineNumInnerWidth+padding;display.lineNumChars=display.lineNumInnerWidth?last.length:-1;display.lineGutter.style.width=display.lineNumWidth+"px";updateGutterSpace(cm.display);return!0}
return!1}
function getGutters(gutters,lineNumbers){var result=[],sawLineNumbers=!1;for(var i=0;i<gutters.length;i++){var name=gutters[i],style=null;if(typeof name!="string"){style=name.style;name=name.className}
if(name=="CodeMirror-linenumbers"){if(!lineNumbers){continue}else{sawLineNumbers=!0}}
result.push({className:name,style:style})}
if(lineNumbers&&!sawLineNumbers){result.push({className:"CodeMirror-linenumbers",style:null})}
return result}
function renderGutters(display){var gutters=display.gutters,specs=display.gutterSpecs;removeChildren(gutters);display.lineGutter=null;for(var i=0;i<specs.length;++i){var ref=specs[i];var className=ref.className;var style=ref.style;var gElt=gutters.appendChild(elt("div",null,"CodeMirror-gutter "+className));if(style){gElt.style.cssText=style}
if(className=="CodeMirror-linenumbers"){display.lineGutter=gElt;gElt.style.width=(display.lineNumWidth||1)+"px"}}
gutters.style.display=specs.length?"":"none";updateGutterSpace(display)}
function updateGutters(cm){renderGutters(cm.display);regChange(cm);alignHorizontally(cm)}
function Display(place,doc,input,options){var d=this;this.input=input;d.scrollbarFiller=elt("div",null,"CodeMirror-scrollbar-filler");d.scrollbarFiller.setAttribute("cm-not-content","true");d.gutterFiller=elt("div",null,"CodeMirror-gutter-filler");d.gutterFiller.setAttribute("cm-not-content","true");d.lineDiv=eltP("div",null,"CodeMirror-code");d.selectionDiv=elt("div",null,null,"position: relative; z-index: 1");d.cursorDiv=elt("div",null,"CodeMirror-cursors");d.measure=elt("div",null,"CodeMirror-measure");d.lineMeasure=elt("div",null,"CodeMirror-measure");d.lineSpace=eltP("div",[d.measure,d.lineMeasure,d.selectionDiv,d.cursorDiv,d.lineDiv],null,"position: relative; outline: none");var lines=eltP("div",[d.lineSpace],"CodeMirror-lines");d.mover=elt("div",[lines],null,"position: relative");d.sizer=elt("div",[d.mover],"CodeMirror-sizer");d.sizerWidth=null;d.heightForcer=elt("div",null,null,"position: absolute; height: "+scrollerGap+"px; width: 1px;");d.gutters=elt("div",null,"CodeMirror-gutters");d.lineGutter=null;d.scroller=elt("div",[d.sizer,d.heightForcer,d.gutters],"CodeMirror-scroll");d.scroller.setAttribute("tabIndex","-1");d.wrapper=elt("div",[d.scrollbarFiller,d.gutterFiller,d.scroller],"CodeMirror");if(chrome&&chrome_version>=105){d.wrapper.style.clipPath="inset(0px)"}
d.wrapper.setAttribute('translate','no');if(ie&&ie_version<8){d.gutters.style.zIndex=-1;d.scroller.style.paddingRight=0}
if(!webkit&&!(gecko&&mobile)){d.scroller.draggable=!0}
if(place){if(place.appendChild){place.appendChild(d.wrapper)}else{place(d.wrapper)}}
d.viewFrom=d.viewTo=doc.first;d.reportedViewFrom=d.reportedViewTo=doc.first;d.view=[];d.renderedView=null;d.externalMeasured=null;d.viewOffset=0;d.lastWrapHeight=d.lastWrapWidth=0;d.updateLineNumbers=null;d.nativeBarWidth=d.barHeight=d.barWidth=0;d.scrollbarsClipped=!1;d.lineNumWidth=d.lineNumInnerWidth=d.lineNumChars=null;d.alignWidgets=!1;d.cachedCharWidth=d.cachedTextHeight=d.cachedPaddingH=null;d.maxLine=null;d.maxLineLength=0;d.maxLineChanged=!1;d.wheelDX=d.wheelDY=d.wheelStartX=d.wheelStartY=null;d.shift=!1;d.selForContextMenu=null;d.activeTouch=null;d.gutterSpecs=getGutters(options.gutters,options.lineNumbers);renderGutters(d);input.init(d)}
var wheelSamples=0,wheelPixelsPerUnit=null;if(ie){wheelPixelsPerUnit=-.53}else if(gecko){wheelPixelsPerUnit=15}else if(chrome){wheelPixelsPerUnit=-.7}else if(safari){wheelPixelsPerUnit=-1/3}
function wheelEventDelta(e){var dx=e.wheelDeltaX,dy=e.wheelDeltaY;if(dx==null&&e.detail&&e.axis==e.HORIZONTAL_AXIS){dx=e.detail}
if(dy==null&&e.detail&&e.axis==e.VERTICAL_AXIS){dy=e.detail}else if(dy==null){dy=e.wheelDelta}
return{x:dx,y:dy}}
function wheelEventPixels(e){var delta=wheelEventDelta(e);delta.x*=wheelPixelsPerUnit;delta.y*=wheelPixelsPerUnit;return delta}
function onScrollWheel(cm,e){if(chrome&&chrome_version==102){if(cm.display.chromeScrollHack==null){cm.display.sizer.style.pointerEvents="none"}else{clearTimeout(cm.display.chromeScrollHack)}
cm.display.chromeScrollHack=setTimeout(function(){cm.display.chromeScrollHack=null;cm.display.sizer.style.pointerEvents=""},100)}
var delta=wheelEventDelta(e),dx=delta.x,dy=delta.y;var pixelsPerUnit=wheelPixelsPerUnit;if(e.deltaMode===0){dx=e.deltaX;dy=e.deltaY;pixelsPerUnit=1}
var display=cm.display,scroll=display.scroller;var canScrollX=scroll.scrollWidth>scroll.clientWidth;var canScrollY=scroll.scrollHeight>scroll.clientHeight;if(!(dx&&canScrollX||dy&&canScrollY)){return}
if(dy&&mac&&webkit){outer:for(var cur=e.target,view=display.view;cur!=scroll;cur=cur.parentNode){for(var i=0;i<view.length;i++){if(view[i].node==cur){cm.display.currentWheelTarget=cur;break outer}}}}
if(dx&&!gecko&&!presto&&pixelsPerUnit!=null){if(dy&&canScrollY){updateScrollTop(cm,Math.max(0,scroll.scrollTop+dy*pixelsPerUnit))}
setScrollLeft(cm,Math.max(0,scroll.scrollLeft+dx*pixelsPerUnit));if(!dy||(dy&&canScrollY)){e_preventDefault(e)}
display.wheelStartX=null;return}
if(dy&&pixelsPerUnit!=null){var pixels=dy*pixelsPerUnit;var top=cm.doc.scrollTop,bot=top+display.wrapper.clientHeight;if(pixels<0){top=Math.max(0,top+pixels-50)}else{bot=Math.min(cm.doc.height,bot+pixels+50)}
updateDisplaySimple(cm,{top:top,bottom:bot})}
if(wheelSamples<20&&e.deltaMode!==0){if(display.wheelStartX==null){display.wheelStartX=scroll.scrollLeft;display.wheelStartY=scroll.scrollTop;display.wheelDX=dx;display.wheelDY=dy;setTimeout(function(){if(display.wheelStartX==null){return}
var movedX=scroll.scrollLeft-display.wheelStartX;var movedY=scroll.scrollTop-display.wheelStartY;var sample=(movedY&&display.wheelDY&&movedY/display.wheelDY)||(movedX&&display.wheelDX&&movedX/display.wheelDX);display.wheelStartX=display.wheelStartY=null;if(!sample){return}
wheelPixelsPerUnit=(wheelPixelsPerUnit*wheelSamples+sample)/(wheelSamples+1);++wheelSamples},200)}else{display.wheelDX+=dx;display.wheelDY+=dy}}}
var Selection=function(ranges,primIndex){this.ranges=ranges;this.primIndex=primIndex};Selection.prototype.primary=function(){return this.ranges[this.primIndex]};Selection.prototype.equals=function(other){if(other==this){return!0}
if(other.primIndex!=this.primIndex||other.ranges.length!=this.ranges.length){return!1}
for(var i=0;i<this.ranges.length;i++){var here=this.ranges[i],there=other.ranges[i];if(!equalCursorPos(here.anchor,there.anchor)||!equalCursorPos(here.head,there.head)){return!1}}
return!0};Selection.prototype.deepCopy=function(){var out=[];for(var i=0;i<this.ranges.length;i++){out[i]=new Range(copyPos(this.ranges[i].anchor),copyPos(this.ranges[i].head))}
return new Selection(out,this.primIndex)};Selection.prototype.somethingSelected=function(){for(var i=0;i<this.ranges.length;i++){if(!this.ranges[i].empty()){return!0}}
return!1};Selection.prototype.contains=function(pos,end){if(!end){end=pos}
for(var i=0;i<this.ranges.length;i++){var range=this.ranges[i];if(cmp(end,range.from())>=0&&cmp(pos,range.to())<=0){return i}}
return-1};var Range=function(anchor,head){this.anchor=anchor;this.head=head};Range.prototype.from=function(){return minPos(this.anchor,this.head)};Range.prototype.to=function(){return maxPos(this.anchor,this.head)};Range.prototype.empty=function(){return this.head.line==this.anchor.line&&this.head.ch==this.anchor.ch};function normalizeSelection(cm,ranges,primIndex){var mayTouch=cm&&cm.options.selectionsMayTouch;var prim=ranges[primIndex];ranges.sort(function(a,b){return cmp(a.from(),b.from())});primIndex=indexOf(ranges,prim);for(var i=1;i<ranges.length;i++){var cur=ranges[i],prev=ranges[i-1];var diff=cmp(prev.to(),cur.from());if(mayTouch&&!cur.empty()?diff>0:diff>=0){var from=minPos(prev.from(),cur.from()),to=maxPos(prev.to(),cur.to());var inv=prev.empty()?cur.from()==cur.head:prev.from()==prev.head;if(i<=primIndex){--primIndex}
ranges.splice(--i,2,new Range(inv?to:from,inv?from:to))}}
return new Selection(ranges,primIndex)}
function simpleSelection(anchor,head){return new Selection([new Range(anchor,head||anchor)],0)}
function changeEnd(change){if(!change.text){return change.to}
return Pos(change.from.line+change.text.length-1,lst(change.text).length+(change.text.length==1?change.from.ch:0))}
function adjustForChange(pos,change){if(cmp(pos,change.from)<0){return pos}
if(cmp(pos,change.to)<=0){return changeEnd(change)}
var line=pos.line+change.text.length-(change.to.line-change.from.line)-1,ch=pos.ch;if(pos.line==change.to.line){ch+=changeEnd(change).ch-change.to.ch}
return Pos(line,ch)}
function computeSelAfterChange(doc,change){var out=[];for(var i=0;i<doc.sel.ranges.length;i++){var range=doc.sel.ranges[i];out.push(new Range(adjustForChange(range.anchor,change),adjustForChange(range.head,change)))}
return normalizeSelection(doc.cm,out,doc.sel.primIndex)}
function offsetPos(pos,old,nw){if(pos.line==old.line){return Pos(nw.line,pos.ch-old.ch+nw.ch)}else{return Pos(nw.line+(pos.line-old.line),pos.ch)}}
function computeReplacedSel(doc,changes,hint){var out=[];var oldPrev=Pos(doc.first,0),newPrev=oldPrev;for(var i=0;i<changes.length;i++){var change=changes[i];var from=offsetPos(change.from,oldPrev,newPrev);var to=offsetPos(changeEnd(change),oldPrev,newPrev);oldPrev=change.to;newPrev=to;if(hint=="around"){var range=doc.sel.ranges[i],inv=cmp(range.head,range.anchor)<0;out[i]=new Range(inv?to:from,inv?from:to)}else{out[i]=new Range(from,from)}}
return new Selection(out,doc.sel.primIndex)}
function loadMode(cm){cm.doc.mode=getMode(cm.options,cm.doc.modeOption);resetModeState(cm)}
function resetModeState(cm){cm.doc.iter(function(line){if(line.stateAfter){line.stateAfter=null}
if(line.styles){line.styles=null}});cm.doc.modeFrontier=cm.doc.highlightFrontier=cm.doc.first;startWorker(cm,100);cm.state.modeGen++;if(cm.curOp){regChange(cm)}}
function isWholeLineUpdate(doc,change){return change.from.ch==0&&change.to.ch==0&&lst(change.text)==""&&(!doc.cm||doc.cm.options.wholeLineUpdateBefore)}
function updateDoc(doc,change,markedSpans,estimateHeight){function spansFor(n){return markedSpans?markedSpans[n]:null}
function update(line,text,spans){updateLine(line,text,spans,estimateHeight);signalLater(line,"change",line,change)}
function linesFor(start,end){var result=[];for(var i=start;i<end;++i){result.push(new Line(text[i],spansFor(i),estimateHeight))}
return result}
var from=change.from,to=change.to,text=change.text;var firstLine=getLine(doc,from.line),lastLine=getLine(doc,to.line);var lastText=lst(text),lastSpans=spansFor(text.length-1),nlines=to.line-from.line;if(change.full){doc.insert(0,linesFor(0,text.length));doc.remove(text.length,doc.size-text.length)}else if(isWholeLineUpdate(doc,change)){var added=linesFor(0,text.length-1);update(lastLine,lastLine.text,lastSpans);if(nlines){doc.remove(from.line,nlines)}
if(added.length){doc.insert(from.line,added)}}else if(firstLine==lastLine){if(text.length==1){update(firstLine,firstLine.text.slice(0,from.ch)+lastText+firstLine.text.slice(to.ch),lastSpans)}else{var added$1=linesFor(1,text.length-1);added$1.push(new Line(lastText+firstLine.text.slice(to.ch),lastSpans,estimateHeight));update(firstLine,firstLine.text.slice(0,from.ch)+text[0],spansFor(0));doc.insert(from.line+1,added$1)}}else if(text.length==1){update(firstLine,firstLine.text.slice(0,from.ch)+text[0]+lastLine.text.slice(to.ch),spansFor(0));doc.remove(from.line+1,nlines)}else{update(firstLine,firstLine.text.slice(0,from.ch)+text[0],spansFor(0));update(lastLine,lastText+lastLine.text.slice(to.ch),lastSpans);var added$2=linesFor(1,text.length-1);if(nlines>1){doc.remove(from.line+1,nlines-1)}
doc.insert(from.line+1,added$2)}
signalLater(doc,"change",doc,change)}
function linkedDocs(doc,f,sharedHistOnly){function propagate(doc,skip,sharedHist){if(doc.linked){for(var i=0;i<doc.linked.length;++i){var rel=doc.linked[i];if(rel.doc==skip){continue}
var shared=sharedHist&&rel.sharedHist;if(sharedHistOnly&&!shared){continue}
f(rel.doc,shared);propagate(rel.doc,doc,shared)}}}
propagate(doc,null,!0)}
function attachDoc(cm,doc){if(doc.cm){throw new Error("This document is already in use.")}
cm.doc=doc;doc.cm=cm;estimateLineHeights(cm);loadMode(cm);setDirectionClass(cm);cm.options.direction=doc.direction;if(!cm.options.lineWrapping){findMaxLine(cm)}
cm.options.mode=doc.modeOption;regChange(cm)}
function setDirectionClass(cm){(cm.doc.direction=="rtl"?addClass:rmClass)(cm.display.lineDiv,"CodeMirror-rtl")}
function directionChanged(cm){runInOp(cm,function(){setDirectionClass(cm);regChange(cm)})}
function History(prev){this.done=[];this.undone=[];this.undoDepth=prev?prev.undoDepth:Infinity;this.lastModTime=this.lastSelTime=0;this.lastOp=this.lastSelOp=null;this.lastOrigin=this.lastSelOrigin=null;this.generation=this.maxGeneration=prev?prev.maxGeneration:1}
function historyChangeFromChange(doc,change){var histChange={from:copyPos(change.from),to:changeEnd(change),text:getBetween(doc,change.from,change.to)};attachLocalSpans(doc,histChange,change.from.line,change.to.line+1);linkedDocs(doc,function(doc){return attachLocalSpans(doc,histChange,change.from.line,change.to.line+1)},!0);return histChange}
function clearSelectionEvents(array){while(array.length){var last=lst(array);if(last.ranges){array.pop()}else{break}}}
function lastChangeEvent(hist,force){if(force){clearSelectionEvents(hist.done);return lst(hist.done)}else if(hist.done.length&&!lst(hist.done).ranges){return lst(hist.done)}else if(hist.done.length>1&&!hist.done[hist.done.length-2].ranges){hist.done.pop();return lst(hist.done)}}
function addChangeToHistory(doc,change,selAfter,opId){var hist=doc.history;hist.undone.length=0;var time=+new Date,cur;var last;if((hist.lastOp==opId||hist.lastOrigin==change.origin&&change.origin&&((change.origin.charAt(0)=="+"&&hist.lastModTime>time-(doc.cm?doc.cm.options.historyEventDelay:500))||change.origin.charAt(0)=="*"))&&(cur=lastChangeEvent(hist,hist.lastOp==opId))){last=lst(cur.changes);if(cmp(change.from,change.to)==0&&cmp(change.from,last.to)==0){last.to=changeEnd(change)}else{cur.changes.push(historyChangeFromChange(doc,change))}}else{var before=lst(hist.done);if(!before||!before.ranges){pushSelectionToHistory(doc.sel,hist.done)}
cur={changes:[historyChangeFromChange(doc,change)],generation:hist.generation};hist.done.push(cur);while(hist.done.length>hist.undoDepth){hist.done.shift();if(!hist.done[0].ranges){hist.done.shift()}}}
hist.done.push(selAfter);hist.generation=++hist.maxGeneration;hist.lastModTime=hist.lastSelTime=time;hist.lastOp=hist.lastSelOp=opId;hist.lastOrigin=hist.lastSelOrigin=change.origin;if(!last){signal(doc,"historyAdded")}}
function selectionEventCanBeMerged(doc,origin,prev,sel){var ch=origin.charAt(0);return ch=="*"||ch=="+"&&prev.ranges.length==sel.ranges.length&&prev.somethingSelected()==sel.somethingSelected()&&new Date-doc.history.lastSelTime<=(doc.cm?doc.cm.options.historyEventDelay:500)}
function addSelectionToHistory(doc,sel,opId,options){var hist=doc.history,origin=options&&options.origin;if(opId==hist.lastSelOp||(origin&&hist.lastSelOrigin==origin&&(hist.lastModTime==hist.lastSelTime&&hist.lastOrigin==origin||selectionEventCanBeMerged(doc,origin,lst(hist.done),sel)))){hist.done[hist.done.length-1]=sel}else{pushSelectionToHistory(sel,hist.done)}
hist.lastSelTime=+new Date;hist.lastSelOrigin=origin;hist.lastSelOp=opId;if(options&&options.clearRedo!==!1){clearSelectionEvents(hist.undone)}}
function pushSelectionToHistory(sel,dest){var top=lst(dest);if(!(top&&top.ranges&&top.equals(sel))){dest.push(sel)}}
function attachLocalSpans(doc,change,from,to){var existing=change["spans_"+doc.id],n=0;doc.iter(Math.max(doc.first,from),Math.min(doc.first+doc.size,to),function(line){if(line.markedSpans){(existing||(existing=change["spans_"+doc.id]={}))[n]=line.markedSpans}
++n})}
function removeClearedSpans(spans){if(!spans){return null}
var out;for(var i=0;i<spans.length;++i){if(spans[i].marker.explicitlyCleared){if(!out){out=spans.slice(0,i)}}else if(out){out.push(spans[i])}}
return!out?spans:out.length?out:null}
function getOldSpans(doc,change){var found=change["spans_"+doc.id];if(!found){return null}
var nw=[];for(var i=0;i<change.text.length;++i){nw.push(removeClearedSpans(found[i]))}
return nw}
function mergeOldSpans(doc,change){var old=getOldSpans(doc,change);var stretched=stretchSpansOverChange(doc,change);if(!old){return stretched}
if(!stretched){return old}
for(var i=0;i<old.length;++i){var oldCur=old[i],stretchCur=stretched[i];if(oldCur&&stretchCur){spans:for(var j=0;j<stretchCur.length;++j){var span=stretchCur[j];for(var k=0;k<oldCur.length;++k){if(oldCur[k].marker==span.marker){continue spans}}
oldCur.push(span)}}else if(stretchCur){old[i]=stretchCur}}
return old}
function copyHistoryArray(events,newGroup,instantiateSel){var copy=[];for(var i=0;i<events.length;++i){var event=events[i];if(event.ranges){copy.push(instantiateSel?Selection.prototype.deepCopy.call(event):event);continue}
var changes=event.changes,newChanges=[];copy.push({changes:newChanges});for(var j=0;j<changes.length;++j){var change=changes[j],m=(void 0);newChanges.push({from:change.from,to:change.to,text:change.text});if(newGroup){for(var prop in change){if(m=prop.match(/^spans_(\d+)$/)){if(indexOf(newGroup,Number(m[1]))>-1){lst(newChanges)[prop]=change[prop];delete change[prop]}}}}}}
return copy}
function extendRange(range,head,other,extend){if(extend){var anchor=range.anchor;if(other){var posBefore=cmp(head,anchor)<0;if(posBefore!=(cmp(other,anchor)<0)){anchor=head;head=other}else if(posBefore!=(cmp(head,other)<0)){head=other}}
return new Range(anchor,head)}else{return new Range(other||head,head)}}
function extendSelection(doc,head,other,options,extend){if(extend==null){extend=doc.cm&&(doc.cm.display.shift||doc.extend)}
setSelection(doc,new Selection([extendRange(doc.sel.primary(),head,other,extend)],0),options)}
function extendSelections(doc,heads,options){var out=[];var extend=doc.cm&&(doc.cm.display.shift||doc.extend);for(var i=0;i<doc.sel.ranges.length;i++){out[i]=extendRange(doc.sel.ranges[i],heads[i],null,extend)}
var newSel=normalizeSelection(doc.cm,out,doc.sel.primIndex);setSelection(doc,newSel,options)}
function replaceOneSelection(doc,i,range,options){var ranges=doc.sel.ranges.slice(0);ranges[i]=range;setSelection(doc,normalizeSelection(doc.cm,ranges,doc.sel.primIndex),options)}
function setSimpleSelection(doc,anchor,head,options){setSelection(doc,simpleSelection(anchor,head),options)}
function filterSelectionChange(doc,sel,options){var obj={ranges:sel.ranges,update:function(ranges){this.ranges=[];for(var i=0;i<ranges.length;i++){this.ranges[i]=new Range(clipPos(doc,ranges[i].anchor),clipPos(doc,ranges[i].head))}},origin:options&&options.origin};signal(doc,"beforeSelectionChange",doc,obj);if(doc.cm){signal(doc.cm,"beforeSelectionChange",doc.cm,obj)}
if(obj.ranges!=sel.ranges){return normalizeSelection(doc.cm,obj.ranges,obj.ranges.length-1)}else{return sel}}
function setSelectionReplaceHistory(doc,sel,options){var done=doc.history.done,last=lst(done);if(last&&last.ranges){done[done.length-1]=sel;setSelectionNoUndo(doc,sel,options)}else{setSelection(doc,sel,options)}}
function setSelection(doc,sel,options){setSelectionNoUndo(doc,sel,options);addSelectionToHistory(doc,doc.sel,doc.cm?doc.cm.curOp.id:NaN,options)}
function setSelectionNoUndo(doc,sel,options){if(hasHandler(doc,"beforeSelectionChange")||doc.cm&&hasHandler(doc.cm,"beforeSelectionChange")){sel=filterSelectionChange(doc,sel,options)}
var bias=options&&options.bias||(cmp(sel.primary().head,doc.sel.primary().head)<0?-1:1);setSelectionInner(doc,skipAtomicInSelection(doc,sel,bias,!0));if(!(options&&options.scroll===!1)&&doc.cm&&doc.cm.getOption("readOnly")!="nocursor"){ensureCursorVisible(doc.cm)}}
function setSelectionInner(doc,sel){if(sel.equals(doc.sel)){return}
doc.sel=sel;if(doc.cm){doc.cm.curOp.updateInput=1;doc.cm.curOp.selectionChanged=!0;signalCursorActivity(doc.cm)}
signalLater(doc,"cursorActivity",doc)}
function reCheckSelection(doc){setSelectionInner(doc,skipAtomicInSelection(doc,doc.sel,null,!1))}
function skipAtomicInSelection(doc,sel,bias,mayClear){var out;for(var i=0;i<sel.ranges.length;i++){var range=sel.ranges[i];var old=sel.ranges.length==doc.sel.ranges.length&&doc.sel.ranges[i];var newAnchor=skipAtomic(doc,range.anchor,old&&old.anchor,bias,mayClear);var newHead=range.head==range.anchor?newAnchor:skipAtomic(doc,range.head,old&&old.head,bias,mayClear);if(out||newAnchor!=range.anchor||newHead!=range.head){if(!out){out=sel.ranges.slice(0,i)}
out[i]=new Range(newAnchor,newHead)}}
return out?normalizeSelection(doc.cm,out,sel.primIndex):sel}
function skipAtomicInner(doc,pos,oldPos,dir,mayClear){var line=getLine(doc,pos.line);if(line.markedSpans){for(var i=0;i<line.markedSpans.length;++i){var sp=line.markedSpans[i],m=sp.marker;var preventCursorLeft=("selectLeft" in m)?!m.selectLeft:m.inclusiveLeft;var preventCursorRight=("selectRight" in m)?!m.selectRight:m.inclusiveRight;if((sp.from==null||(preventCursorLeft?sp.from<=pos.ch:sp.from<pos.ch))&&(sp.to==null||(preventCursorRight?sp.to>=pos.ch:sp.to>pos.ch))){if(mayClear){signal(m,"beforeCursorEnter");if(m.explicitlyCleared){if(!line.markedSpans){break}else{--i;continue}}}
if(!m.atomic){continue}
if(oldPos){var near=m.find(dir<0?1:-1),diff=(void 0);if(dir<0?preventCursorRight:preventCursorLeft){near=movePos(doc,near,-dir,near&&near.line==pos.line?line:null)}
if(near&&near.line==pos.line&&(diff=cmp(near,oldPos))&&(dir<0?diff<0:diff>0)){return skipAtomicInner(doc,near,pos,dir,mayClear)}}
var far=m.find(dir<0?-1:1);if(dir<0?preventCursorLeft:preventCursorRight){far=movePos(doc,far,dir,far.line==pos.line?line:null)}
return far?skipAtomicInner(doc,far,pos,dir,mayClear):null}}}
return pos}
function skipAtomic(doc,pos,oldPos,bias,mayClear){var dir=bias||1;var found=skipAtomicInner(doc,pos,oldPos,dir,mayClear)||(!mayClear&&skipAtomicInner(doc,pos,oldPos,dir,!0))||skipAtomicInner(doc,pos,oldPos,-dir,mayClear)||(!mayClear&&skipAtomicInner(doc,pos,oldPos,-dir,!0));if(!found){doc.cantEdit=!0;return Pos(doc.first,0)}
return found}
function movePos(doc,pos,dir,line){if(dir<0&&pos.ch==0){if(pos.line>doc.first){return clipPos(doc,Pos(pos.line-1))}else{return null}}else if(dir>0&&pos.ch==(line||getLine(doc,pos.line)).text.length){if(pos.line<doc.first+doc.size-1){return Pos(pos.line+1,0)}else{return null}}else{return new Pos(pos.line,pos.ch+dir)}}
function selectAll(cm){cm.setSelection(Pos(cm.firstLine(),0),Pos(cm.lastLine()),sel_dontScroll)}
function filterChange(doc,change,update){var obj={canceled:!1,from:change.from,to:change.to,text:change.text,origin:change.origin,cancel:function(){return obj.canceled=!0}};if(update){obj.update=function(from,to,text,origin){if(from){obj.from=clipPos(doc,from)}
if(to){obj.to=clipPos(doc,to)}
if(text){obj.text=text}
if(origin!==undefined){obj.origin=origin}}}
signal(doc,"beforeChange",doc,obj);if(doc.cm){signal(doc.cm,"beforeChange",doc.cm,obj)}
if(obj.canceled){if(doc.cm){doc.cm.curOp.updateInput=2}
return null}
return{from:obj.from,to:obj.to,text:obj.text,origin:obj.origin}}
function makeChange(doc,change,ignoreReadOnly){if(doc.cm){if(!doc.cm.curOp){return operation(doc.cm,makeChange)(doc,change,ignoreReadOnly)}
if(doc.cm.state.suppressEdits){return}}
if(hasHandler(doc,"beforeChange")||doc.cm&&hasHandler(doc.cm,"beforeChange")){change=filterChange(doc,change,!0);if(!change){return}}
var split=sawReadOnlySpans&&!ignoreReadOnly&&removeReadOnlyRanges(doc,change.from,change.to);if(split){for(var i=split.length-1;i>=0;--i){makeChangeInner(doc,{from:split[i].from,to:split[i].to,text:i?[""]:change.text,origin:change.origin})}}else{makeChangeInner(doc,change)}}
function makeChangeInner(doc,change){if(change.text.length==1&&change.text[0]==""&&cmp(change.from,change.to)==0){return}
var selAfter=computeSelAfterChange(doc,change);addChangeToHistory(doc,change,selAfter,doc.cm?doc.cm.curOp.id:NaN);makeChangeSingleDoc(doc,change,selAfter,stretchSpansOverChange(doc,change));var rebased=[];linkedDocs(doc,function(doc,sharedHist){if(!sharedHist&&indexOf(rebased,doc.history)==-1){rebaseHist(doc.history,change);rebased.push(doc.history)}
makeChangeSingleDoc(doc,change,null,stretchSpansOverChange(doc,change))})}
function makeChangeFromHistory(doc,type,allowSelectionOnly){var suppress=doc.cm&&doc.cm.state.suppressEdits;if(suppress&&!allowSelectionOnly){return}
var hist=doc.history,event,selAfter=doc.sel;var source=type=="undo"?hist.done:hist.undone,dest=type=="undo"?hist.undone:hist.done;var i=0;for(;i<source.length;i++){event=source[i];if(allowSelectionOnly?event.ranges&&!event.equals(doc.sel):!event.ranges){break}}
if(i==source.length){return}
hist.lastOrigin=hist.lastSelOrigin=null;for(;;){event=source.pop();if(event.ranges){pushSelectionToHistory(event,dest);if(allowSelectionOnly&&!event.equals(doc.sel)){setSelection(doc,event,{clearRedo:!1});return}
selAfter=event}else if(suppress){source.push(event);return}else{break}}
var antiChanges=[];pushSelectionToHistory(selAfter,dest);dest.push({changes:antiChanges,generation:hist.generation});hist.generation=event.generation||++hist.maxGeneration;var filter=hasHandler(doc,"beforeChange")||doc.cm&&hasHandler(doc.cm,"beforeChange");var loop=function(i){var change=event.changes[i];change.origin=type;if(filter&&!filterChange(doc,change,!1)){source.length=0;return{}}
antiChanges.push(historyChangeFromChange(doc,change));var after=i?computeSelAfterChange(doc,change):lst(source);makeChangeSingleDoc(doc,change,after,mergeOldSpans(doc,change));if(!i&&doc.cm){doc.cm.scrollIntoView({from:change.from,to:changeEnd(change)})}
var rebased=[];linkedDocs(doc,function(doc,sharedHist){if(!sharedHist&&indexOf(rebased,doc.history)==-1){rebaseHist(doc.history,change);rebased.push(doc.history)}
makeChangeSingleDoc(doc,change,null,mergeOldSpans(doc,change))})};for(var i$1=event.changes.length-1;i$1>=0;--i$1){var returned=loop(i$1);if(returned)return returned.v}}
function shiftDoc(doc,distance){if(distance==0){return}
doc.first+=distance;doc.sel=new Selection(map(doc.sel.ranges,function(range){return new Range(Pos(range.anchor.line+distance,range.anchor.ch),Pos(range.head.line+distance,range.head.ch))}),doc.sel.primIndex);if(doc.cm){regChange(doc.cm,doc.first,doc.first-distance,distance);for(var d=doc.cm.display,l=d.viewFrom;l<d.viewTo;l++){regLineChange(doc.cm,l,"gutter")}}}
function makeChangeSingleDoc(doc,change,selAfter,spans){if(doc.cm&&!doc.cm.curOp){return operation(doc.cm,makeChangeSingleDoc)(doc,change,selAfter,spans)}
if(change.to.line<doc.first){shiftDoc(doc,change.text.length-1-(change.to.line-change.from.line));return}
if(change.from.line>doc.lastLine()){return}
if(change.from.line<doc.first){var shift=change.text.length-1-(doc.first-change.from.line);shiftDoc(doc,shift);change={from:Pos(doc.first,0),to:Pos(change.to.line+shift,change.to.ch),text:[lst(change.text)],origin:change.origin}}
var last=doc.lastLine();if(change.to.line>last){change={from:change.from,to:Pos(last,getLine(doc,last).text.length),text:[change.text[0]],origin:change.origin}}
change.removed=getBetween(doc,change.from,change.to);if(!selAfter){selAfter=computeSelAfterChange(doc,change)}
if(doc.cm){makeChangeSingleDocInEditor(doc.cm,change,spans)}else{updateDoc(doc,change,spans)}
setSelectionNoUndo(doc,selAfter,sel_dontScroll);if(doc.cantEdit&&skipAtomic(doc,Pos(doc.firstLine(),0))){doc.cantEdit=!1}}
function makeChangeSingleDocInEditor(cm,change,spans){var doc=cm.doc,display=cm.display,from=change.from,to=change.to;var recomputeMaxLength=!1,checkWidthStart=from.line;if(!cm.options.lineWrapping){checkWidthStart=lineNo(visualLine(getLine(doc,from.line)));doc.iter(checkWidthStart,to.line+1,function(line){if(line==display.maxLine){recomputeMaxLength=!0;return!0}})}
if(doc.sel.contains(change.from,change.to)>-1){signalCursorActivity(cm)}
updateDoc(doc,change,spans,estimateHeight(cm));if(!cm.options.lineWrapping){doc.iter(checkWidthStart,from.line+change.text.length,function(line){var len=lineLength(line);if(len>display.maxLineLength){display.maxLine=line;display.maxLineLength=len;display.maxLineChanged=!0;recomputeMaxLength=!1}});if(recomputeMaxLength){cm.curOp.updateMaxLine=!0}}
retreatFrontier(doc,from.line);startWorker(cm,400);var lendiff=change.text.length-(to.line-from.line)-1;if(change.full){regChange(cm)}else if(from.line==to.line&&change.text.length==1&&!isWholeLineUpdate(cm.doc,change)){regLineChange(cm,from.line,"text")}else{regChange(cm,from.line,to.line+1,lendiff)}
var changesHandler=hasHandler(cm,"changes"),changeHandler=hasHandler(cm,"change");if(changeHandler||changesHandler){var obj={from:from,to:to,text:change.text,removed:change.removed,origin:change.origin};if(changeHandler){signalLater(cm,"change",cm,obj)}
if(changesHandler){(cm.curOp.changeObjs||(cm.curOp.changeObjs=[])).push(obj)}}
cm.display.selForContextMenu=null}
function replaceRange(doc,code,from,to,origin){var assign;if(!to){to=from}
if(cmp(to,from)<0){(assign=[to,from],from=assign[0],to=assign[1])}
if(typeof code=="string"){code=doc.splitLines(code)}
makeChange(doc,{from:from,to:to,text:code,origin:origin})}
function rebaseHistSelSingle(pos,from,to,diff){if(to<pos.line){pos.line+=diff}else if(from<pos.line){pos.line=from;pos.ch=0}}
function rebaseHistArray(array,from,to,diff){for(var i=0;i<array.length;++i){var sub=array[i],ok=!0;if(sub.ranges){if(!sub.copied){sub=array[i]=sub.deepCopy();sub.copied=!0}
for(var j=0;j<sub.ranges.length;j++){rebaseHistSelSingle(sub.ranges[j].anchor,from,to,diff);rebaseHistSelSingle(sub.ranges[j].head,from,to,diff)}
continue}
for(var j$1=0;j$1<sub.changes.length;++j$1){var cur=sub.changes[j$1];if(to<cur.from.line){cur.from=Pos(cur.from.line+diff,cur.from.ch);cur.to=Pos(cur.to.line+diff,cur.to.ch)}else if(from<=cur.to.line){ok=!1;break}}
if(!ok){array.splice(0,i+1);i=0}}}
function rebaseHist(hist,change){var from=change.from.line,to=change.to.line,diff=change.text.length-(to-from)-1;rebaseHistArray(hist.done,from,to,diff);rebaseHistArray(hist.undone,from,to,diff)}
function changeLine(doc,handle,changeType,op){var no=handle,line=handle;if(typeof handle=="number"){line=getLine(doc,clipLine(doc,handle))}else{no=lineNo(handle)}
if(no==null){return null}
if(op(line,no)&&doc.cm){regLineChange(doc.cm,no,changeType)}
return line}
function LeafChunk(lines){this.lines=lines;this.parent=null;var height=0;for(var i=0;i<lines.length;++i){lines[i].parent=this;height+=lines[i].height}
this.height=height}
LeafChunk.prototype={chunkSize:function(){return this.lines.length},removeInner:function(at,n){for(var i=at,e=at+n;i<e;++i){var line=this.lines[i];this.height-=line.height;cleanUpLine(line);signalLater(line,"delete")}
this.lines.splice(at,n)},collapse:function(lines){lines.push.apply(lines,this.lines)},insertInner:function(at,lines,height){this.height+=height;this.lines=this.lines.slice(0,at).concat(lines).concat(this.lines.slice(at));for(var i=0;i<lines.length;++i){lines[i].parent=this}},iterN:function(at,n,op){for(var e=at+n;at<e;++at){if(op(this.lines[at])){return!0}}}};function BranchChunk(children){this.children=children;var size=0,height=0;for(var i=0;i<children.length;++i){var ch=children[i];size+=ch.chunkSize();height+=ch.height;ch.parent=this}
this.size=size;this.height=height;this.parent=null}
BranchChunk.prototype={chunkSize:function(){return this.size},removeInner:function(at,n){this.size-=n;for(var i=0;i<this.children.length;++i){var child=this.children[i],sz=child.chunkSize();if(at<sz){var rm=Math.min(n,sz-at),oldHeight=child.height;child.removeInner(at,rm);this.height-=oldHeight-child.height;if(sz==rm){this.children.splice(i--,1);child.parent=null}
if((n-=rm)==0){break}
at=0}else{at-=sz}}
if(this.size-n<25&&(this.children.length>1||!(this.children[0]instanceof LeafChunk))){var lines=[];this.collapse(lines);this.children=[new LeafChunk(lines)];this.children[0].parent=this}},collapse:function(lines){for(var i=0;i<this.children.length;++i){this.children[i].collapse(lines)}},insertInner:function(at,lines,height){this.size+=lines.length;this.height+=height;for(var i=0;i<this.children.length;++i){var child=this.children[i],sz=child.chunkSize();if(at<=sz){child.insertInner(at,lines,height);if(child.lines&&child.lines.length>50){var remaining=child.lines.length%25+25;for(var pos=remaining;pos<child.lines.length;){var leaf=new LeafChunk(child.lines.slice(pos,pos+=25));child.height-=leaf.height;this.children.splice(++i,0,leaf);leaf.parent=this}
child.lines=child.lines.slice(0,remaining);this.maybeSpill()}
break}
at-=sz}},maybeSpill:function(){if(this.children.length<=10){return}
var me=this;do{var spilled=me.children.splice(me.children.length-5,5);var sibling=new BranchChunk(spilled);if(!me.parent){var copy=new BranchChunk(me.children);copy.parent=me;me.children=[copy,sibling];me=copy}else{me.size-=sibling.size;me.height-=sibling.height;var myIndex=indexOf(me.parent.children,me);me.parent.children.splice(myIndex+1,0,sibling)}
sibling.parent=me.parent}while(me.children.length>10)
me.parent.maybeSpill();},iterN:function(at,n,op){for(var i=0;i<this.children.length;++i){var child=this.children[i],sz=child.chunkSize();if(at<sz){var used=Math.min(n,sz-at);if(child.iterN(at,used,op)){return!0}
if((n-=used)==0){break}
at=0}else{at-=sz}}}};var LineWidget=function(doc,node,options){if(options){for(var opt in options){if(options.hasOwnProperty(opt)){this[opt]=options[opt]}}}
this.doc=doc;this.node=node};LineWidget.prototype.clear=function(){var cm=this.doc.cm,ws=this.line.widgets,line=this.line,no=lineNo(line);if(no==null||!ws){return}
for(var i=0;i<ws.length;++i){if(ws[i]==this){ws.splice(i--,1)}}
if(!ws.length){line.widgets=null}
var height=widgetHeight(this);updateLineHeight(line,Math.max(0,line.height-height));if(cm){runInOp(cm,function(){adjustScrollWhenAboveVisible(cm,line,-height);regLineChange(cm,no,"widget")});signalLater(cm,"lineWidgetCleared",cm,this,no)}};LineWidget.prototype.changed=function(){var this$1=this;var oldH=this.height,cm=this.doc.cm,line=this.line;this.height=null;var diff=widgetHeight(this)-oldH;if(!diff){return}
if(!lineIsHidden(this.doc,line)){updateLineHeight(line,line.height+diff)}
if(cm){runInOp(cm,function(){cm.curOp.forceUpdate=!0;adjustScrollWhenAboveVisible(cm,line,diff);signalLater(cm,"lineWidgetChanged",cm,this$1,lineNo(line))})}};eventMixin(LineWidget);function adjustScrollWhenAboveVisible(cm,line,diff){if(heightAtLine(line)<((cm.curOp&&cm.curOp.scrollTop)||cm.doc.scrollTop)){addToScrollTop(cm,diff)}}
function addLineWidget(doc,handle,node,options){var widget=new LineWidget(doc,node,options);var cm=doc.cm;if(cm&&widget.noHScroll){cm.display.alignWidgets=!0}
changeLine(doc,handle,"widget",function(line){var widgets=line.widgets||(line.widgets=[]);if(widget.insertAt==null){widgets.push(widget)}else{widgets.splice(Math.min(widgets.length,Math.max(0,widget.insertAt)),0,widget)}
widget.line=line;if(cm&&!lineIsHidden(doc,line)){var aboveVisible=heightAtLine(line)<doc.scrollTop;updateLineHeight(line,line.height+widgetHeight(widget));if(aboveVisible){addToScrollTop(cm,widget.height)}
cm.curOp.forceUpdate=!0}
return!0});if(cm){signalLater(cm,"lineWidgetAdded",cm,widget,typeof handle=="number"?handle:lineNo(handle))}
return widget}
var nextMarkerId=0;var TextMarker=function(doc,type){this.lines=[];this.type=type;this.doc=doc;this.id=++nextMarkerId};TextMarker.prototype.clear=function(){if(this.explicitlyCleared){return}
var cm=this.doc.cm,withOp=cm&&!cm.curOp;if(withOp){startOperation(cm)}
if(hasHandler(this,"clear")){var found=this.find();if(found){signalLater(this,"clear",found.from,found.to)}}
var min=null,max=null;for(var i=0;i<this.lines.length;++i){var line=this.lines[i];var span=getMarkedSpanFor(line.markedSpans,this);if(cm&&!this.collapsed){regLineChange(cm,lineNo(line),"text")}else if(cm){if(span.to!=null){max=lineNo(line)}
if(span.from!=null){min=lineNo(line)}}
line.markedSpans=removeMarkedSpan(line.markedSpans,span);if(span.from==null&&this.collapsed&&!lineIsHidden(this.doc,line)&&cm){updateLineHeight(line,textHeight(cm.display))}}
if(cm&&this.collapsed&&!cm.options.lineWrapping){for(var i$1=0;i$1<this.lines.length;++i$1){var visual=visualLine(this.lines[i$1]),len=lineLength(visual);if(len>cm.display.maxLineLength){cm.display.maxLine=visual;cm.display.maxLineLength=len;cm.display.maxLineChanged=!0}}}
if(min!=null&&cm&&this.collapsed){regChange(cm,min,max+1)}
this.lines.length=0;this.explicitlyCleared=!0;if(this.atomic&&this.doc.cantEdit){this.doc.cantEdit=!1;if(cm){reCheckSelection(cm.doc)}}
if(cm){signalLater(cm,"markerCleared",cm,this,min,max)}
if(withOp){endOperation(cm)}
if(this.parent){this.parent.clear()}};TextMarker.prototype.find=function(side,lineObj){if(side==null&&this.type=="bookmark"){side=1}
var from,to;for(var i=0;i<this.lines.length;++i){var line=this.lines[i];var span=getMarkedSpanFor(line.markedSpans,this);if(span.from!=null){from=Pos(lineObj?line:lineNo(line),span.from);if(side==-1){return from}}
if(span.to!=null){to=Pos(lineObj?line:lineNo(line),span.to);if(side==1){return to}}}
return from&&{from:from,to:to}};TextMarker.prototype.changed=function(){var this$1=this;var pos=this.find(-1,!0),widget=this,cm=this.doc.cm;if(!pos||!cm){return}
runInOp(cm,function(){var line=pos.line,lineN=lineNo(pos.line);var view=findViewForLine(cm,lineN);if(view){clearLineMeasurementCacheFor(view);cm.curOp.selectionChanged=cm.curOp.forceUpdate=!0}
cm.curOp.updateMaxLine=!0;if(!lineIsHidden(widget.doc,line)&&widget.height!=null){var oldHeight=widget.height;widget.height=null;var dHeight=widgetHeight(widget)-oldHeight;if(dHeight){updateLineHeight(line,line.height+dHeight)}}
signalLater(cm,"markerChanged",cm,this$1)})};TextMarker.prototype.attachLine=function(line){if(!this.lines.length&&this.doc.cm){var op=this.doc.cm.curOp;if(!op.maybeHiddenMarkers||indexOf(op.maybeHiddenMarkers,this)==-1){(op.maybeUnhiddenMarkers||(op.maybeUnhiddenMarkers=[])).push(this)}}
this.lines.push(line)};TextMarker.prototype.detachLine=function(line){this.lines.splice(indexOf(this.lines,line),1);if(!this.lines.length&&this.doc.cm){var op=this.doc.cm.curOp;(op.maybeHiddenMarkers||(op.maybeHiddenMarkers=[])).push(this)}};eventMixin(TextMarker);function markText(doc,from,to,options,type){if(options&&options.shared){return markTextShared(doc,from,to,options,type)}
if(doc.cm&&!doc.cm.curOp){return operation(doc.cm,markText)(doc,from,to,options,type)}
var marker=new TextMarker(doc,type),diff=cmp(from,to);if(options){copyObj(options,marker,!1)}
if(diff>0||diff==0&&marker.clearWhenEmpty!==!1){return marker}
if(marker.replacedWith){marker.collapsed=!0;marker.widgetNode=eltP("span",[marker.replacedWith],"CodeMirror-widget");if(!options.handleMouseEvents){marker.widgetNode.setAttribute("cm-ignore-events","true")}
if(options.insertLeft){marker.widgetNode.insertLeft=!0}}
if(marker.collapsed){if(conflictingCollapsedRange(doc,from.line,from,to,marker)||from.line!=to.line&&conflictingCollapsedRange(doc,to.line,from,to,marker)){throw new Error("Inserting collapsed marker partially overlapping an existing one")}
seeCollapsedSpans()}
if(marker.addToHistory){addChangeToHistory(doc,{from:from,to:to,origin:"markText"},doc.sel,NaN)}
var curLine=from.line,cm=doc.cm,updateMaxLine;doc.iter(curLine,to.line+1,function(line){if(cm&&marker.collapsed&&!cm.options.lineWrapping&&visualLine(line)==cm.display.maxLine){updateMaxLine=!0}
if(marker.collapsed&&curLine!=from.line){updateLineHeight(line,0)}
addMarkedSpan(line,new MarkedSpan(marker,curLine==from.line?from.ch:null,curLine==to.line?to.ch:null),doc.cm&&doc.cm.curOp);++curLine});if(marker.collapsed){doc.iter(from.line,to.line+1,function(line){if(lineIsHidden(doc,line)){updateLineHeight(line,0)}})}
if(marker.clearOnEnter){on(marker,"beforeCursorEnter",function(){return marker.clear()})}
if(marker.readOnly){seeReadOnlySpans();if(doc.history.done.length||doc.history.undone.length){doc.clearHistory()}}
if(marker.collapsed){marker.id=++nextMarkerId;marker.atomic=!0}
if(cm){if(updateMaxLine){cm.curOp.updateMaxLine=!0}
if(marker.collapsed){regChange(cm,from.line,to.line+1)}else if(marker.className||marker.startStyle||marker.endStyle||marker.css||marker.attributes||marker.title){for(var i=from.line;i<=to.line;i++){regLineChange(cm,i,"text")}}
if(marker.atomic){reCheckSelection(cm.doc)}
signalLater(cm,"markerAdded",cm,marker)}
return marker}
var SharedTextMarker=function(markers,primary){this.markers=markers;this.primary=primary;for(var i=0;i<markers.length;++i){markers[i].parent=this}};SharedTextMarker.prototype.clear=function(){if(this.explicitlyCleared){return}
this.explicitlyCleared=!0;for(var i=0;i<this.markers.length;++i){this.markers[i].clear()}
signalLater(this,"clear")};SharedTextMarker.prototype.find=function(side,lineObj){return this.primary.find(side,lineObj)};eventMixin(SharedTextMarker);function markTextShared(doc,from,to,options,type){options=copyObj(options);options.shared=!1;var markers=[markText(doc,from,to,options,type)],primary=markers[0];var widget=options.widgetNode;linkedDocs(doc,function(doc){if(widget){options.widgetNode=widget.cloneNode(!0)}
markers.push(markText(doc,clipPos(doc,from),clipPos(doc,to),options,type));for(var i=0;i<doc.linked.length;++i){if(doc.linked[i].isParent){return}}
primary=lst(markers)});return new SharedTextMarker(markers,primary)}
function findSharedMarkers(doc){return doc.findMarks(Pos(doc.first,0),doc.clipPos(Pos(doc.lastLine())),function(m){return m.parent})}
function copySharedMarkers(doc,markers){for(var i=0;i<markers.length;i++){var marker=markers[i],pos=marker.find();var mFrom=doc.clipPos(pos.from),mTo=doc.clipPos(pos.to);if(cmp(mFrom,mTo)){var subMark=markText(doc,mFrom,mTo,marker.primary,marker.primary.type);marker.markers.push(subMark);subMark.parent=marker}}}
function detachSharedMarkers(markers){var loop=function(i){var marker=markers[i],linked=[marker.primary.doc];linkedDocs(marker.primary.doc,function(d){return linked.push(d)});for(var j=0;j<marker.markers.length;j++){var subMarker=marker.markers[j];if(indexOf(linked,subMarker.doc)==-1){subMarker.parent=null;marker.markers.splice(j--,1)}}};for(var i=0;i<markers.length;i++)loop(i);}
var nextDocId=0;var Doc=function(text,mode,firstLine,lineSep,direction){if(!(this instanceof Doc)){return new Doc(text,mode,firstLine,lineSep,direction)}
if(firstLine==null){firstLine=0}
BranchChunk.call(this,[new LeafChunk([new Line("",null)])]);this.first=firstLine;this.scrollTop=this.scrollLeft=0;this.cantEdit=!1;this.cleanGeneration=1;this.modeFrontier=this.highlightFrontier=firstLine;var start=Pos(firstLine,0);this.sel=simpleSelection(start);this.history=new History(null);this.id=++nextDocId;this.modeOption=mode;this.lineSep=lineSep;this.direction=(direction=="rtl")?"rtl":"ltr";this.extend=!1;if(typeof text=="string"){text=this.splitLines(text)}
updateDoc(this,{from:start,to:start,text:text});setSelection(this,simpleSelection(start),sel_dontScroll)};Doc.prototype=createObj(BranchChunk.prototype,{constructor:Doc,iter:function(from,to,op){if(op){this.iterN(from-this.first,to-from,op)}else{this.iterN(this.first,this.first+this.size,from)}},insert:function(at,lines){var height=0;for(var i=0;i<lines.length;++i){height+=lines[i].height}
this.insertInner(at-this.first,lines,height)},remove:function(at,n){this.removeInner(at-this.first,n)},getValue:function(lineSep){var lines=getLines(this,this.first,this.first+this.size);if(lineSep===!1){return lines}
return lines.join(lineSep||this.lineSeparator())},setValue:docMethodOp(function(code){var top=Pos(this.first,0),last=this.first+this.size-1;makeChange(this,{from:top,to:Pos(last,getLine(this,last).text.length),text:this.splitLines(code),origin:"setValue",full:!0},!0);if(this.cm){scrollToCoords(this.cm,0,0)}
setSelection(this,simpleSelection(top),sel_dontScroll)}),replaceRange:function(code,from,to,origin){from=clipPos(this,from);to=to?clipPos(this,to):from;replaceRange(this,code,from,to,origin)},getRange:function(from,to,lineSep){var lines=getBetween(this,clipPos(this,from),clipPos(this,to));if(lineSep===!1){return lines}
if(lineSep===''){return lines.join('')}
return lines.join(lineSep||this.lineSeparator())},getLine:function(line){var l=this.getLineHandle(line);return l&&l.text},getLineHandle:function(line){if(isLine(this,line)){return getLine(this,line)}},getLineNumber:function(line){return lineNo(line)},getLineHandleVisualStart:function(line){if(typeof line=="number"){line=getLine(this,line)}
return visualLine(line)},lineCount:function(){return this.size},firstLine:function(){return this.first},lastLine:function(){return this.first+this.size-1},clipPos:function(pos){return clipPos(this,pos)},getCursor:function(start){var range=this.sel.primary(),pos;if(start==null||start=="head"){pos=range.head}else if(start=="anchor"){pos=range.anchor}else if(start=="end"||start=="to"||start===!1){pos=range.to()}else{pos=range.from()}
return pos},listSelections:function(){return this.sel.ranges},somethingSelected:function(){return this.sel.somethingSelected()},setCursor:docMethodOp(function(line,ch,options){setSimpleSelection(this,clipPos(this,typeof line=="number"?Pos(line,ch||0):line),null,options)}),setSelection:docMethodOp(function(anchor,head,options){setSimpleSelection(this,clipPos(this,anchor),clipPos(this,head||anchor),options)}),extendSelection:docMethodOp(function(head,other,options){extendSelection(this,clipPos(this,head),other&&clipPos(this,other),options)}),extendSelections:docMethodOp(function(heads,options){extendSelections(this,clipPosArray(this,heads),options)}),extendSelectionsBy:docMethodOp(function(f,options){var heads=map(this.sel.ranges,f);extendSelections(this,clipPosArray(this,heads),options)}),setSelections:docMethodOp(function(ranges,primary,options){if(!ranges.length){return}
var out=[];for(var i=0;i<ranges.length;i++){out[i]=new Range(clipPos(this,ranges[i].anchor),clipPos(this,ranges[i].head||ranges[i].anchor))}
if(primary==null){primary=Math.min(ranges.length-1,this.sel.primIndex)}
setSelection(this,normalizeSelection(this.cm,out,primary),options)}),addSelection:docMethodOp(function(anchor,head,options){var ranges=this.sel.ranges.slice(0);ranges.push(new Range(clipPos(this,anchor),clipPos(this,head||anchor)));setSelection(this,normalizeSelection(this.cm,ranges,ranges.length-1),options)}),getSelection:function(lineSep){var ranges=this.sel.ranges,lines;for(var i=0;i<ranges.length;i++){var sel=getBetween(this,ranges[i].from(),ranges[i].to());lines=lines?lines.concat(sel):sel}
if(lineSep===!1){return lines}else{return lines.join(lineSep||this.lineSeparator())}},getSelections:function(lineSep){var parts=[],ranges=this.sel.ranges;for(var i=0;i<ranges.length;i++){var sel=getBetween(this,ranges[i].from(),ranges[i].to());if(lineSep!==!1){sel=sel.join(lineSep||this.lineSeparator())}
parts[i]=sel}
return parts},replaceSelection:function(code,collapse,origin){var dup=[];for(var i=0;i<this.sel.ranges.length;i++){dup[i]=code}
this.replaceSelections(dup,collapse,origin||"+input")},replaceSelections:docMethodOp(function(code,collapse,origin){var changes=[],sel=this.sel;for(var i=0;i<sel.ranges.length;i++){var range=sel.ranges[i];changes[i]={from:range.from(),to:range.to(),text:this.splitLines(code[i]),origin:origin}}
var newSel=collapse&&collapse!="end"&&computeReplacedSel(this,changes,collapse);for(var i$1=changes.length-1;i$1>=0;i$1--){makeChange(this,changes[i$1])}
if(newSel){setSelectionReplaceHistory(this,newSel)}else if(this.cm){ensureCursorVisible(this.cm)}}),undo:docMethodOp(function(){makeChangeFromHistory(this,"undo")}),redo:docMethodOp(function(){makeChangeFromHistory(this,"redo")}),undoSelection:docMethodOp(function(){makeChangeFromHistory(this,"undo",!0)}),redoSelection:docMethodOp(function(){makeChangeFromHistory(this,"redo",!0)}),setExtending:function(val){this.extend=val},getExtending:function(){return this.extend},historySize:function(){var hist=this.history,done=0,undone=0;for(var i=0;i<hist.done.length;i++){if(!hist.done[i].ranges){++done}}
for(var i$1=0;i$1<hist.undone.length;i$1++){if(!hist.undone[i$1].ranges){++undone}}
return{undo:done,redo:undone}},clearHistory:function(){var this$1=this;this.history=new History(this.history);linkedDocs(this,function(doc){return doc.history=this$1.history},!0)},markClean:function(){this.cleanGeneration=this.changeGeneration(!0)},changeGeneration:function(forceSplit){if(forceSplit){this.history.lastOp=this.history.lastSelOp=this.history.lastOrigin=null}
return this.history.generation},isClean:function(gen){return this.history.generation==(gen||this.cleanGeneration)},getHistory:function(){return{done:copyHistoryArray(this.history.done),undone:copyHistoryArray(this.history.undone)}},setHistory:function(histData){var hist=this.history=new History(this.history);hist.done=copyHistoryArray(histData.done.slice(0),null,!0);hist.undone=copyHistoryArray(histData.undone.slice(0),null,!0)},setGutterMarker:docMethodOp(function(line,gutterID,value){return changeLine(this,line,"gutter",function(line){var markers=line.gutterMarkers||(line.gutterMarkers={});markers[gutterID]=value;if(!value&&isEmpty(markers)){line.gutterMarkers=null}
return!0})}),clearGutter:docMethodOp(function(gutterID){var this$1=this;this.iter(function(line){if(line.gutterMarkers&&line.gutterMarkers[gutterID]){changeLine(this$1,line,"gutter",function(){line.gutterMarkers[gutterID]=null;if(isEmpty(line.gutterMarkers)){line.gutterMarkers=null}
return!0})}})}),lineInfo:function(line){var n;if(typeof line=="number"){if(!isLine(this,line)){return null}
n=line;line=getLine(this,line);if(!line){return null}}else{n=lineNo(line);if(n==null){return null}}
return{line:n,handle:line,text:line.text,gutterMarkers:line.gutterMarkers,textClass:line.textClass,bgClass:line.bgClass,wrapClass:line.wrapClass,widgets:line.widgets}},addLineClass:docMethodOp(function(handle,where,cls){return changeLine(this,handle,where=="gutter"?"gutter":"class",function(line){var prop=where=="text"?"textClass":where=="background"?"bgClass":where=="gutter"?"gutterClass":"wrapClass";if(!line[prop]){line[prop]=cls}else if(classTest(cls).test(line[prop])){return!1}else{line[prop]+=" "+cls}
return!0})}),removeLineClass:docMethodOp(function(handle,where,cls){return changeLine(this,handle,where=="gutter"?"gutter":"class",function(line){var prop=where=="text"?"textClass":where=="background"?"bgClass":where=="gutter"?"gutterClass":"wrapClass";var cur=line[prop];if(!cur){return!1}else if(cls==null){line[prop]=null}else{var found=cur.match(classTest(cls));if(!found){return!1}
var end=found.index+found[0].length;line[prop]=cur.slice(0,found.index)+(!found.index||end==cur.length?"":" ")+cur.slice(end)||null}
return!0})}),addLineWidget:docMethodOp(function(handle,node,options){return addLineWidget(this,handle,node,options)}),removeLineWidget:function(widget){widget.clear()},markText:function(from,to,options){return markText(this,clipPos(this,from),clipPos(this,to),options,options&&options.type||"range")},setBookmark:function(pos,options){var realOpts={replacedWith:options&&(options.nodeType==null?options.widget:options),insertLeft:options&&options.insertLeft,clearWhenEmpty:!1,shared:options&&options.shared,handleMouseEvents:options&&options.handleMouseEvents};pos=clipPos(this,pos);return markText(this,pos,pos,realOpts,"bookmark")},findMarksAt:function(pos){pos=clipPos(this,pos);var markers=[],spans=getLine(this,pos.line).markedSpans;if(spans){for(var i=0;i<spans.length;++i){var span=spans[i];if((span.from==null||span.from<=pos.ch)&&(span.to==null||span.to>=pos.ch)){markers.push(span.marker.parent||span.marker)}}}
return markers},findMarks:function(from,to,filter){from=clipPos(this,from);to=clipPos(this,to);var found=[],lineNo=from.line;this.iter(from.line,to.line+1,function(line){var spans=line.markedSpans;if(spans){for(var i=0;i<spans.length;i++){var span=spans[i];if(!(span.to!=null&&lineNo==from.line&&from.ch>=span.to||span.from==null&&lineNo!=from.line||span.from!=null&&lineNo==to.line&&span.from>=to.ch)&&(!filter||filter(span.marker))){found.push(span.marker.parent||span.marker)}}}
++lineNo});return found},getAllMarks:function(){var markers=[];this.iter(function(line){var sps=line.markedSpans;if(sps){for(var i=0;i<sps.length;++i){if(sps[i].from!=null){markers.push(sps[i].marker)}}}});return markers},posFromIndex:function(off){var ch,lineNo=this.first,sepSize=this.lineSeparator().length;this.iter(function(line){var sz=line.text.length+sepSize;if(sz>off){ch=off;return!0}
off-=sz;++lineNo});return clipPos(this,Pos(lineNo,ch))},indexFromPos:function(coords){coords=clipPos(this,coords);var index=coords.ch;if(coords.line<this.first||coords.ch<0){return 0}
var sepSize=this.lineSeparator().length;this.iter(this.first,coords.line,function(line){index+=line.text.length+sepSize});return index},copy:function(copyHistory){var doc=new Doc(getLines(this,this.first,this.first+this.size),this.modeOption,this.first,this.lineSep,this.direction);doc.scrollTop=this.scrollTop;doc.scrollLeft=this.scrollLeft;doc.sel=this.sel;doc.extend=!1;if(copyHistory){doc.history.undoDepth=this.history.undoDepth;doc.setHistory(this.getHistory())}
return doc},linkedDoc:function(options){if(!options){options={}}
var from=this.first,to=this.first+this.size;if(options.from!=null&&options.from>from){from=options.from}
if(options.to!=null&&options.to<to){to=options.to}
var copy=new Doc(getLines(this,from,to),options.mode||this.modeOption,from,this.lineSep,this.direction);if(options.sharedHist){copy.history=this.history}(this.linked||(this.linked=[])).push({doc:copy,sharedHist:options.sharedHist});copy.linked=[{doc:this,isParent:!0,sharedHist:options.sharedHist}];copySharedMarkers(copy,findSharedMarkers(this));return copy},unlinkDoc:function(other){if(other instanceof CodeMirror){other=other.doc}
if(this.linked){for(var i=0;i<this.linked.length;++i){var link=this.linked[i];if(link.doc!=other){continue}
this.linked.splice(i,1);other.unlinkDoc(this);detachSharedMarkers(findSharedMarkers(this));break}}
if(other.history==this.history){var splitIds=[other.id];linkedDocs(other,function(doc){return splitIds.push(doc.id)},!0);other.history=new History(null);other.history.done=copyHistoryArray(this.history.done,splitIds);other.history.undone=copyHistoryArray(this.history.undone,splitIds)}},iterLinkedDocs:function(f){linkedDocs(this,f)},getMode:function(){return this.mode},getEditor:function(){return this.cm},splitLines:function(str){if(this.lineSep){return str.split(this.lineSep)}
return splitLinesAuto(str)},lineSeparator:function(){return this.lineSep||"\n"},setDirection:docMethodOp(function(dir){if(dir!="rtl"){dir="ltr"}
if(dir==this.direction){return}
this.direction=dir;this.iter(function(line){return line.order=null});if(this.cm){directionChanged(this.cm)}})});Doc.prototype.eachLine=Doc.prototype.iter;var lastDrop=0;function onDrop(e){var cm=this;clearDragCursor(cm);if(signalDOMEvent(cm,e)||eventInWidget(cm.display,e)){return}
e_preventDefault(e);if(ie){lastDrop=+new Date}
var pos=posFromMouse(cm,e,!0),files=e.dataTransfer.files;if(!pos||cm.isReadOnly()){return}
if(files&&files.length&&window.FileReader&&window.File){var n=files.length,text=Array(n),read=0;var markAsReadAndPasteIfAllFilesAreRead=function(){if(++read==n){operation(cm,function(){pos=clipPos(cm.doc,pos);var change={from:pos,to:pos,text:cm.doc.splitLines(text.filter(function(t){return t!=null}).join(cm.doc.lineSeparator())),origin:"paste"};makeChange(cm.doc,change);setSelectionReplaceHistory(cm.doc,simpleSelection(clipPos(cm.doc,pos),clipPos(cm.doc,changeEnd(change))))})()}};var readTextFromFile=function(file,i){if(cm.options.allowDropFileTypes&&indexOf(cm.options.allowDropFileTypes,file.type)==-1){markAsReadAndPasteIfAllFilesAreRead();return}
var reader=new FileReader;reader.onerror=function(){return markAsReadAndPasteIfAllFilesAreRead()};reader.onload=function(){var content=reader.result;if(/[\x00-\x08\x0e-\x1f]{2}/.test(content)){markAsReadAndPasteIfAllFilesAreRead();return}
text[i]=content;markAsReadAndPasteIfAllFilesAreRead()};reader.readAsText(file)};for(var i=0;i<files.length;i++){readTextFromFile(files[i],i)}}else{if(cm.state.draggingText&&cm.doc.sel.contains(pos)>-1){cm.state.draggingText(e);setTimeout(function(){return cm.display.input.focus()},20);return}
try{var text$1=e.dataTransfer.getData("Text");if(text$1){var selected;if(cm.state.draggingText&&!cm.state.draggingText.copy){selected=cm.listSelections()}
setSelectionNoUndo(cm.doc,simpleSelection(pos,pos));if(selected){for(var i$1=0;i$1<selected.length;++i$1){replaceRange(cm.doc,"",selected[i$1].anchor,selected[i$1].head,"drag")}}
cm.replaceSelection(text$1,"around","paste");cm.display.input.focus()}}catch(e$1){}}}
function onDragStart(cm,e){if(ie&&(!cm.state.draggingText||+new Date-lastDrop<100)){e_stop(e);return}
if(signalDOMEvent(cm,e)||eventInWidget(cm.display,e)){return}
e.dataTransfer.setData("Text",cm.getSelection());e.dataTransfer.effectAllowed="copyMove";if(e.dataTransfer.setDragImage&&!safari){var img=elt("img",null,null,"position: fixed; left: 0; top: 0;");img.src="data:image/gif;base64,R0lGODlhAQABAAAAACH5BAEKAAEALAAAAAABAAEAAAICTAEAOw==";if(presto){img.width=img.height=1;cm.display.wrapper.appendChild(img);img._top=img.offsetTop}
e.dataTransfer.setDragImage(img,0,0);if(presto){img.parentNode.removeChild(img)}}}
function onDragOver(cm,e){var pos=posFromMouse(cm,e);if(!pos){return}
var frag=document.createDocumentFragment();drawSelectionCursor(cm,pos,frag);if(!cm.display.dragCursor){cm.display.dragCursor=elt("div",null,"CodeMirror-cursors CodeMirror-dragcursors");cm.display.lineSpace.insertBefore(cm.display.dragCursor,cm.display.cursorDiv)}
removeChildrenAndAdd(cm.display.dragCursor,frag)}
function clearDragCursor(cm){if(cm.display.dragCursor){cm.display.lineSpace.removeChild(cm.display.dragCursor);cm.display.dragCursor=null}}
function forEachCodeMirror(f){if(!document.getElementsByClassName){return}
var byClass=document.getElementsByClassName("CodeMirror"),editors=[];for(var i=0;i<byClass.length;i++){var cm=byClass[i].CodeMirror;if(cm){editors.push(cm)}}
if(editors.length){editors[0].operation(function(){for(var i=0;i<editors.length;i++){f(editors[i])}})}}
var globalsRegistered=!1;function ensureGlobalHandlers(){if(globalsRegistered){return}
registerGlobalHandlers();globalsRegistered=!0}
function registerGlobalHandlers(){var resizeTimer;on(window,"resize",function(){if(resizeTimer==null){resizeTimer=setTimeout(function(){resizeTimer=null;forEachCodeMirror(onResize)},100)}});on(window,"blur",function(){return forEachCodeMirror(onBlur)})}
function onResize(cm){var d=cm.display;d.cachedCharWidth=d.cachedTextHeight=d.cachedPaddingH=null;d.scrollbarsClipped=!1;cm.setSize()}
var keyNames={3:"Pause",8:"Backspace",9:"Tab",13:"Enter",16:"Shift",17:"Ctrl",18:"Alt",19:"Pause",20:"CapsLock",27:"Esc",32:"Space",33:"PageUp",34:"PageDown",35:"End",36:"Home",37:"Left",38:"Up",39:"Right",40:"Down",44:"PrintScrn",45:"Insert",46:"Delete",59:";",61:"=",91:"Mod",92:"Mod",93:"Mod",106:"*",107:"=",109:"-",110:".",111:"/",145:"ScrollLock",173:"-",186:";",187:"=",188:",",189:"-",190:".",191:"/",192:"`",219:"[",220:"\\",221:"]",222:"'",224:"Mod",63232:"Up",63233:"Down",63234:"Left",63235:"Right",63272:"Delete",63273:"Home",63275:"End",63276:"PageUp",63277:"PageDown",63302:"Insert"};for(var i=0;i<10;i++){keyNames[i+48]=keyNames[i+96]=String(i)}
for(var i$1=65;i$1<=90;i$1++){keyNames[i$1]=String.fromCharCode(i$1)}
for(var i$2=1;i$2<=12;i$2++){keyNames[i$2+111]=keyNames[i$2+63235]="F"+i$2}
var keyMap={};keyMap.basic={"Left":"goCharLeft","Right":"goCharRight","Up":"goLineUp","Down":"goLineDown","End":"goLineEnd","Home":"goLineStartSmart","PageUp":"goPageUp","PageDown":"goPageDown","Delete":"delCharAfter","Backspace":"delCharBefore","Shift-Backspace":"delCharBefore","Tab":"defaultTab","Shift-Tab":"indentAuto","Enter":"newlineAndIndent","Insert":"toggleOverwrite","Esc":"singleSelection"};keyMap.pcDefault={"Ctrl-A":"selectAll","Ctrl-D":"deleteLine","Ctrl-Z":"undo","Shift-Ctrl-Z":"redo","Ctrl-Y":"redo","Ctrl-Home":"goDocStart","Ctrl-End":"goDocEnd","Ctrl-Up":"goLineUp","Ctrl-Down":"goLineDown","Ctrl-Left":"goGroupLeft","Ctrl-Right":"goGroupRight","Alt-Left":"goLineStart","Alt-Right":"goLineEnd","Ctrl-Backspace":"delGroupBefore","Ctrl-Delete":"delGroupAfter","Ctrl-S":"save","Ctrl-F":"find","Ctrl-G":"findNext","Shift-Ctrl-G":"findPrev","Shift-Ctrl-F":"replace","Shift-Ctrl-R":"replaceAll","Ctrl-[":"indentLess","Ctrl-]":"indentMore","Ctrl-U":"undoSelection","Shift-Ctrl-U":"redoSelection","Alt-U":"redoSelection","fallthrough":"basic"};keyMap.emacsy={"Ctrl-F":"goCharRight","Ctrl-B":"goCharLeft","Ctrl-P":"goLineUp","Ctrl-N":"goLineDown","Ctrl-A":"goLineStart","Ctrl-E":"goLineEnd","Ctrl-V":"goPageDown","Shift-Ctrl-V":"goPageUp","Ctrl-D":"delCharAfter","Ctrl-H":"delCharBefore","Alt-Backspace":"delWordBefore","Ctrl-K":"killLine","Ctrl-T":"transposeChars","Ctrl-O":"openLine"};keyMap.macDefault={"Cmd-A":"selectAll","Cmd-D":"deleteLine","Cmd-Z":"undo","Shift-Cmd-Z":"redo","Cmd-Y":"redo","Cmd-Home":"goDocStart","Cmd-Up":"goDocStart","Cmd-End":"goDocEnd","Cmd-Down":"goDocEnd","Alt-Left":"goGroupLeft","Alt-Right":"goGroupRight","Cmd-Left":"goLineLeft","Cmd-Right":"goLineRight","Alt-Backspace":"delGroupBefore","Ctrl-Alt-Backspace":"delGroupAfter","Alt-Delete":"delGroupAfter","Cmd-S":"save","Cmd-F":"find","Cmd-G":"findNext","Shift-Cmd-G":"findPrev","Cmd-Alt-F":"replace","Shift-Cmd-Alt-F":"replaceAll","Cmd-[":"indentLess","Cmd-]":"indentMore","Cmd-Backspace":"delWrappedLineLeft","Cmd-Delete":"delWrappedLineRight","Cmd-U":"undoSelection","Shift-Cmd-U":"redoSelection","Ctrl-Up":"goDocStart","Ctrl-Down":"goDocEnd","fallthrough":["basic","emacsy"]};keyMap["default"]=mac?keyMap.macDefault:keyMap.pcDefault;function normalizeKeyName(name){var parts=name.split(/-(?!$)/);name=parts[parts.length-1];var alt,ctrl,shift,cmd;for(var i=0;i<parts.length-1;i++){var mod=parts[i];if(/^(cmd|meta|m)$/i.test(mod)){cmd=!0}else if(/^a(lt)?$/i.test(mod)){alt=!0}else if(/^(c|ctrl|control)$/i.test(mod)){ctrl=!0}else if(/^s(hift)?$/i.test(mod)){shift=!0}else{throw new Error("Unrecognized modifier name: "+mod)}}
if(alt){name="Alt-"+name}
if(ctrl){name="Ctrl-"+name}
if(cmd){name="Cmd-"+name}
if(shift){name="Shift-"+name}
return name}
function normalizeKeyMap(keymap){var copy={};for(var keyname in keymap){if(keymap.hasOwnProperty(keyname)){var value=keymap[keyname];if(/^(name|fallthrough|(de|at)tach)$/.test(keyname)){continue}
if(value=="..."){delete keymap[keyname];continue}
var keys=map(keyname.split(" "),normalizeKeyName);for(var i=0;i<keys.length;i++){var val=(void 0),name=(void 0);if(i==keys.length-1){name=keys.join(" ");val=value}else{name=keys.slice(0,i+1).join(" ");val="..."}
var prev=copy[name];if(!prev){copy[name]=val}else if(prev!=val){throw new Error("Inconsistent bindings for "+name)}}
delete keymap[keyname]}}
for(var prop in copy){keymap[prop]=copy[prop]}
return keymap}
function lookupKey(key,map,handle,context){map=getKeyMap(map);var found=map.call?map.call(key,context):map[key];if(found===!1){return"nothing"}
if(found==="..."){return"multi"}
if(found!=null&&handle(found)){return"handled"}
if(map.fallthrough){if(Object.prototype.toString.call(map.fallthrough)!="[object Array]"){return lookupKey(key,map.fallthrough,handle,context)}
for(var i=0;i<map.fallthrough.length;i++){var result=lookupKey(key,map.fallthrough[i],handle,context);if(result){return result}}}}
function isModifierKey(value){var name=typeof value=="string"?value:keyNames[value.keyCode];return name=="Ctrl"||name=="Alt"||name=="Shift"||name=="Mod"}
function addModifierNames(name,event,noShift){var base=name;if(event.altKey&&base!="Alt"){name="Alt-"+name}
if((flipCtrlCmd?event.metaKey:event.ctrlKey)&&base!="Ctrl"){name="Ctrl-"+name}
if((flipCtrlCmd?event.ctrlKey:event.metaKey)&&base!="Mod"){name="Cmd-"+name}
if(!noShift&&event.shiftKey&&base!="Shift"){name="Shift-"+name}
return name}
function keyName(event,noShift){if(presto&&event.keyCode==34&&event["char"]){return!1}
var name=keyNames[event.keyCode];if(name==null||event.altGraphKey){return!1}
if(event.keyCode==3&&event.code){name=event.code}
return addModifierNames(name,event,noShift)}
function getKeyMap(val){return typeof val=="string"?keyMap[val]:val}
function deleteNearSelection(cm,compute){var ranges=cm.doc.sel.ranges,kill=[];for(var i=0;i<ranges.length;i++){var toKill=compute(ranges[i]);while(kill.length&&cmp(toKill.from,lst(kill).to)<=0){var replaced=kill.pop();if(cmp(replaced.from,toKill.from)<0){toKill.from=replaced.from;break}}
kill.push(toKill)}
runInOp(cm,function(){for(var i=kill.length-1;i>=0;i--){replaceRange(cm.doc,"",kill[i].from,kill[i].to,"+delete")}
ensureCursorVisible(cm)})}
function moveCharLogically(line,ch,dir){var target=skipExtendingChars(line.text,ch+dir,dir);return target<0||target>line.text.length?null:target}
function moveLogically(line,start,dir){var ch=moveCharLogically(line,start.ch,dir);return ch==null?null:new Pos(start.line,ch,dir<0?"after":"before")}
function endOfLine(visually,cm,lineObj,lineNo,dir){if(visually){if(cm.doc.direction=="rtl"){dir=-dir}
var order=getOrder(lineObj,cm.doc.direction);if(order){var part=dir<0?lst(order):order[0];var moveInStorageOrder=(dir<0)==(part.level==1);var sticky=moveInStorageOrder?"after":"before";var ch;if(part.level>0||cm.doc.direction=="rtl"){var prep=prepareMeasureForLine(cm,lineObj);ch=dir<0?lineObj.text.length-1:0;var targetTop=measureCharPrepared(cm,prep,ch).top;ch=findFirst(function(ch){return measureCharPrepared(cm,prep,ch).top==targetTop},(dir<0)==(part.level==1)?part.from:part.to-1,ch);if(sticky=="before"){ch=moveCharLogically(lineObj,ch,1)}}else{ch=dir<0?part.to:part.from}
return new Pos(lineNo,ch,sticky)}}
return new Pos(lineNo,dir<0?lineObj.text.length:0,dir<0?"before":"after")}
function moveVisually(cm,line,start,dir){var bidi=getOrder(line,cm.doc.direction);if(!bidi){return moveLogically(line,start,dir)}
if(start.ch>=line.text.length){start.ch=line.text.length;start.sticky="before"}else if(start.ch<=0){start.ch=0;start.sticky="after"}
var partPos=getBidiPartAt(bidi,start.ch,start.sticky),part=bidi[partPos];if(cm.doc.direction=="ltr"&&part.level%2==0&&(dir>0?part.to>start.ch:part.from<start.ch)){return moveLogically(line,start,dir)}
var mv=function(pos,dir){return moveCharLogically(line,pos instanceof Pos?pos.ch:pos,dir)};var prep;var getWrappedLineExtent=function(ch){if(!cm.options.lineWrapping){return{begin:0,end:line.text.length}}
prep=prep||prepareMeasureForLine(cm,line);return wrappedLineExtentChar(cm,line,prep,ch)};var wrappedLineExtent=getWrappedLineExtent(start.sticky=="before"?mv(start,-1):start.ch);if(cm.doc.direction=="rtl"||part.level==1){var moveInStorageOrder=(part.level==1)==(dir<0);var ch=mv(start,moveInStorageOrder?1:-1);if(ch!=null&&(!moveInStorageOrder?ch>=part.from&&ch>=wrappedLineExtent.begin:ch<=part.to&&ch<=wrappedLineExtent.end)){var sticky=moveInStorageOrder?"before":"after";return new Pos(start.line,ch,sticky)}}
var searchInVisualLine=function(partPos,dir,wrappedLineExtent){var getRes=function(ch,moveInStorageOrder){return moveInStorageOrder?new Pos(start.line,mv(ch,1),"before"):new Pos(start.line,ch,"after")};for(;partPos>=0&&partPos<bidi.length;partPos+=dir){var part=bidi[partPos];var moveInStorageOrder=(dir>0)==(part.level!=1);var ch=moveInStorageOrder?wrappedLineExtent.begin:mv(wrappedLineExtent.end,-1);if(part.from<=ch&&ch<part.to){return getRes(ch,moveInStorageOrder)}
ch=moveInStorageOrder?part.from:mv(part.to,-1);if(wrappedLineExtent.begin<=ch&&ch<wrappedLineExtent.end){return getRes(ch,moveInStorageOrder)}}};var res=searchInVisualLine(partPos+dir,dir,wrappedLineExtent);if(res){return res}
var nextCh=dir>0?wrappedLineExtent.end:mv(wrappedLineExtent.begin,-1);if(nextCh!=null&&!(dir>0&&nextCh==line.text.length)){res=searchInVisualLine(dir>0?0:bidi.length-1,dir,getWrappedLineExtent(nextCh));if(res){return res}}
return null}
var commands={selectAll:selectAll,singleSelection:function(cm){return cm.setSelection(cm.getCursor("anchor"),cm.getCursor("head"),sel_dontScroll)},killLine:function(cm){return deleteNearSelection(cm,function(range){if(range.empty()){var len=getLine(cm.doc,range.head.line).text.length;if(range.head.ch==len&&range.head.line<cm.lastLine()){return{from:range.head,to:Pos(range.head.line+1,0)}}else{return{from:range.head,to:Pos(range.head.line,len)}}}else{return{from:range.from(),to:range.to()}}})},deleteLine:function(cm){return deleteNearSelection(cm,function(range){return({from:Pos(range.from().line,0),to:clipPos(cm.doc,Pos(range.to().line+1,0))})})},delLineLeft:function(cm){return deleteNearSelection(cm,function(range){return({from:Pos(range.from().line,0),to:range.from()})})},delWrappedLineLeft:function(cm){return deleteNearSelection(cm,function(range){var top=cm.charCoords(range.head,"div").top+5;var leftPos=cm.coordsChar({left:0,top:top},"div");return{from:leftPos,to:range.from()}})},delWrappedLineRight:function(cm){return deleteNearSelection(cm,function(range){var top=cm.charCoords(range.head,"div").top+5;var rightPos=cm.coordsChar({left:cm.display.lineDiv.offsetWidth+100,top:top},"div");return{from:range.from(),to:rightPos}})},undo:function(cm){return cm.undo()},redo:function(cm){return cm.redo()},undoSelection:function(cm){return cm.undoSelection()},redoSelection:function(cm){return cm.redoSelection()},goDocStart:function(cm){return cm.extendSelection(Pos(cm.firstLine(),0))},goDocEnd:function(cm){return cm.extendSelection(Pos(cm.lastLine()))},goLineStart:function(cm){return cm.extendSelectionsBy(function(range){return lineStart(cm,range.head.line)},{origin:"+move",bias:1})},goLineStartSmart:function(cm){return cm.extendSelectionsBy(function(range){return lineStartSmart(cm,range.head)},{origin:"+move",bias:1})},goLineEnd:function(cm){return cm.extendSelectionsBy(function(range){return lineEnd(cm,range.head.line)},{origin:"+move",bias:-1})},goLineRight:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.cursorCoords(range.head,"div").top+5;return cm.coordsChar({left:cm.display.lineDiv.offsetWidth+100,top:top},"div")},sel_move)},goLineLeft:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.cursorCoords(range.head,"div").top+5;return cm.coordsChar({left:0,top:top},"div")},sel_move)},goLineLeftSmart:function(cm){return cm.extendSelectionsBy(function(range){var top=cm.cursorCoords(range.head,"div").top+5;var pos=cm.coordsChar({left:0,top:top},"div");if(pos.ch<cm.getLine(pos.line).search(/\S/)){return lineStartSmart(cm,range.head)}
return pos},sel_move)},goLineUp:function(cm){return cm.moveV(-1,"line")},goLineDown:function(cm){return cm.moveV(1,"line")},goPageUp:function(cm){return cm.moveV(-1,"page")},goPageDown:function(cm){return cm.moveV(1,"page")},goCharLeft:function(cm){return cm.moveH(-1,"char")},goCharRight:function(cm){return cm.moveH(1,"char")},goColumnLeft:function(cm){return cm.moveH(-1,"column")},goColumnRight:function(cm){return cm.moveH(1,"column")},goWordLeft:function(cm){return cm.moveH(-1,"word")},goGroupRight:function(cm){return cm.moveH(1,"group")},goGroupLeft:function(cm){return cm.moveH(-1,"group")},goWordRight:function(cm){return cm.moveH(1,"word")},delCharBefore:function(cm){return cm.deleteH(-1,"codepoint")},delCharAfter:function(cm){return cm.deleteH(1,"char")},delWordBefore:function(cm){return cm.deleteH(-1,"word")},delWordAfter:function(cm){return cm.deleteH(1,"word")},delGroupBefore:function(cm){return cm.deleteH(-1,"group")},delGroupAfter:function(cm){return cm.deleteH(1,"group")},indentAuto:function(cm){return cm.indentSelection("smart")},indentMore:function(cm){return cm.indentSelection("add")},indentLess:function(cm){return cm.indentSelection("subtract")},insertTab:function(cm){return cm.replaceSelection("\t")},insertSoftTab:function(cm){var spaces=[],ranges=cm.listSelections(),tabSize=cm.options.tabSize;for(var i=0;i<ranges.length;i++){var pos=ranges[i].from();var col=countColumn(cm.getLine(pos.line),pos.ch,tabSize);spaces.push(spaceStr(tabSize-col%tabSize))}
cm.replaceSelections(spaces)},defaultTab:function(cm){if(cm.somethingSelected()){cm.indentSelection("add")}else{cm.execCommand("insertTab")}},transposeChars:function(cm){return runInOp(cm,function(){var ranges=cm.listSelections(),newSel=[];for(var i=0;i<ranges.length;i++){if(!ranges[i].empty()){continue}
var cur=ranges[i].head,line=getLine(cm.doc,cur.line).text;if(line){if(cur.ch==line.length){cur=new Pos(cur.line,cur.ch-1)}
if(cur.ch>0){cur=new Pos(cur.line,cur.ch+1);cm.replaceRange(line.charAt(cur.ch-1)+line.charAt(cur.ch-2),Pos(cur.line,cur.ch-2),cur,"+transpose")}else if(cur.line>cm.doc.first){var prev=getLine(cm.doc,cur.line-1).text;if(prev){cur=new Pos(cur.line,1);cm.replaceRange(line.charAt(0)+cm.doc.lineSeparator()+prev.charAt(prev.length-1),Pos(cur.line-1,prev.length-1),cur,"+transpose")}}}
newSel.push(new Range(cur,cur))}
cm.setSelections(newSel)})},newlineAndIndent:function(cm){return runInOp(cm,function(){var sels=cm.listSelections();for(var i=sels.length-1;i>=0;i--){cm.replaceRange(cm.doc.lineSeparator(),sels[i].anchor,sels[i].head,"+input")}
sels=cm.listSelections();for(var i$1=0;i$1<sels.length;i$1++){cm.indentLine(sels[i$1].from().line,null,!0)}
ensureCursorVisible(cm)})},openLine:function(cm){return cm.replaceSelection("\n","start")},toggleOverwrite:function(cm){return cm.toggleOverwrite()}};function lineStart(cm,lineN){var line=getLine(cm.doc,lineN);var visual=visualLine(line);if(visual!=line){lineN=lineNo(visual)}
return endOfLine(!0,cm,visual,lineN,1)}
function lineEnd(cm,lineN){var line=getLine(cm.doc,lineN);var visual=visualLineEnd(line);if(visual!=line){lineN=lineNo(visual)}
return endOfLine(!0,cm,line,lineN,-1)}
function lineStartSmart(cm,pos){var start=lineStart(cm,pos.line);var line=getLine(cm.doc,start.line);var order=getOrder(line,cm.doc.direction);if(!order||order[0].level==0){var firstNonWS=Math.max(start.ch,line.text.search(/\S/));var inWS=pos.line==start.line&&pos.ch<=firstNonWS&&pos.ch;return Pos(start.line,inWS?0:firstNonWS,start.sticky)}
return start}
function doHandleBinding(cm,bound,dropShift){if(typeof bound=="string"){bound=commands[bound];if(!bound){return!1}}
cm.display.input.ensurePolled();var prevShift=cm.display.shift,done=!1;try{if(cm.isReadOnly()){cm.state.suppressEdits=!0}
if(dropShift){cm.display.shift=!1}
done=bound(cm)!=Pass}finally{cm.display.shift=prevShift;cm.state.suppressEdits=!1}
return done}
function lookupKeyForEditor(cm,name,handle){for(var i=0;i<cm.state.keyMaps.length;i++){var result=lookupKey(name,cm.state.keyMaps[i],handle,cm);if(result){return result}}
return(cm.options.extraKeys&&lookupKey(name,cm.options.extraKeys,handle,cm))||lookupKey(name,cm.options.keyMap,handle,cm)}
var stopSeq=new Delayed;function dispatchKey(cm,name,e,handle){var seq=cm.state.keySeq;if(seq){if(isModifierKey(name)){return"handled"}
if(/\'$/.test(name)){cm.state.keySeq=null}else{stopSeq.set(50,function(){if(cm.state.keySeq==seq){cm.state.keySeq=null;cm.display.input.reset()}})}
if(dispatchKeyInner(cm,seq+" "+name,e,handle)){return!0}}
return dispatchKeyInner(cm,name,e,handle)}
function dispatchKeyInner(cm,name,e,handle){var result=lookupKeyForEditor(cm,name,handle);if(result=="multi"){cm.state.keySeq=name}
if(result=="handled"){signalLater(cm,"keyHandled",cm,name,e)}
if(result=="handled"||result=="multi"){e_preventDefault(e);restartBlink(cm)}
return!!result}
function handleKeyBinding(cm,e){var name=keyName(e,!0);if(!name){return!1}
if(e.shiftKey&&!cm.state.keySeq){return dispatchKey(cm,"Shift-"+name,e,function(b){return doHandleBinding(cm,b,!0)})||dispatchKey(cm,name,e,function(b){if(typeof b=="string"?/^go[A-Z]/.test(b):b.motion){return doHandleBinding(cm,b)}})}else{return dispatchKey(cm,name,e,function(b){return doHandleBinding(cm,b)})}}
function handleCharBinding(cm,e,ch){return dispatchKey(cm,"'"+ch+"'",e,function(b){return doHandleBinding(cm,b,!0)})}
var lastStoppedKey=null;function onKeyDown(e){var cm=this;if(e.target&&e.target!=cm.display.input.getField()){return}
cm.curOp.focus=activeElt(root(cm));if(signalDOMEvent(cm,e)){return}
if(ie&&ie_version<11&&e.keyCode==27){e.returnValue=!1}
var code=e.keyCode;cm.display.shift=code==16||e.shiftKey;var handled=handleKeyBinding(cm,e);if(presto){lastStoppedKey=handled?code:null;if(!handled&&code==88&&!hasCopyEvent&&(mac?e.metaKey:e.ctrlKey)){cm.replaceSelection("",null,"cut")}}
if(gecko&&!mac&&!handled&&code==46&&e.shiftKey&&!e.ctrlKey&&document.execCommand){document.execCommand("cut")}
if(code==18&&!/\bCodeMirror-crosshair\b/.test(cm.display.lineDiv.className)){showCrossHair(cm)}}
function showCrossHair(cm){var lineDiv=cm.display.lineDiv;addClass(lineDiv,"CodeMirror-crosshair");function up(e){if(e.keyCode==18||!e.altKey){rmClass(lineDiv,"CodeMirror-crosshair");off(document,"keyup",up);off(document,"mouseover",up)}}
on(document,"keyup",up);on(document,"mouseover",up)}
function onKeyUp(e){if(e.keyCode==16){this.doc.sel.shift=!1}
signalDOMEvent(this,e)}
function onKeyPress(e){var cm=this;if(e.target&&e.target!=cm.display.input.getField()){return}
if(eventInWidget(cm.display,e)||signalDOMEvent(cm,e)||e.ctrlKey&&!e.altKey||mac&&e.metaKey){return}
var keyCode=e.keyCode,charCode=e.charCode;if(presto&&keyCode==lastStoppedKey){lastStoppedKey=null;e_preventDefault(e);return}
if((presto&&(!e.which||e.which<10))&&handleKeyBinding(cm,e)){return}
var ch=String.fromCharCode(charCode==null?keyCode:charCode);if(ch=="\x08"){return}
if(handleCharBinding(cm,e,ch)){return}
cm.display.input.onKeyPress(e)}
var DOUBLECLICK_DELAY=400;var PastClick=function(time,pos,button){this.time=time;this.pos=pos;this.button=button};PastClick.prototype.compare=function(time,pos,button){return this.time+DOUBLECLICK_DELAY>time&&cmp(pos,this.pos)==0&&button==this.button};var lastClick,lastDoubleClick;function clickRepeat(pos,button){var now=+new Date;if(lastDoubleClick&&lastDoubleClick.compare(now,pos,button)){lastClick=lastDoubleClick=null;return"triple"}else if(lastClick&&lastClick.compare(now,pos,button)){lastDoubleClick=new PastClick(now,pos,button);lastClick=null;return"double"}else{lastClick=new PastClick(now,pos,button);lastDoubleClick=null;return"single"}}
function onMouseDown(e){var cm=this,display=cm.display;if(signalDOMEvent(cm,e)||display.activeTouch&&display.input.supportsTouch()){return}
display.input.ensurePolled();display.shift=e.shiftKey;if(eventInWidget(display,e)){if(!webkit){display.scroller.draggable=!1;setTimeout(function(){return display.scroller.draggable=!0},100)}
return}
if(clickInGutter(cm,e)){return}
var pos=posFromMouse(cm,e),button=e_button(e),repeat=pos?clickRepeat(pos,button):"single";win(cm).focus();if(button==1&&cm.state.selectingText){cm.state.selectingText(e)}
if(pos&&handleMappedButton(cm,button,pos,repeat,e)){return}
if(button==1){if(pos){leftButtonDown(cm,pos,repeat,e)}else if(e_target(e)==display.scroller){e_preventDefault(e)}}else if(button==2){if(pos){extendSelection(cm.doc,pos)}
setTimeout(function(){return display.input.focus()},20)}else if(button==3){if(captureRightClick){cm.display.input.onContextMenu(e)}else{delayBlurEvent(cm)}}}
function handleMappedButton(cm,button,pos,repeat,event){var name="Click";if(repeat=="double"){name="Double"+name}else if(repeat=="triple"){name="Triple"+name}
name=(button==1?"Left":button==2?"Middle":"Right")+name;return dispatchKey(cm,addModifierNames(name,event),event,function(bound){if(typeof bound=="string"){bound=commands[bound]}
if(!bound){return!1}
var done=!1;try{if(cm.isReadOnly()){cm.state.suppressEdits=!0}
done=bound(cm,pos)!=Pass}finally{cm.state.suppressEdits=!1}
return done})}
function configureMouse(cm,repeat,event){var option=cm.getOption("configureMouse");var value=option?option(cm,repeat,event):{};if(value.unit==null){var rect=chromeOS?event.shiftKey&&event.metaKey:event.altKey;value.unit=rect?"rectangle":repeat=="single"?"char":repeat=="double"?"word":"line"}
if(value.extend==null||cm.doc.extend){value.extend=cm.doc.extend||event.shiftKey}
if(value.addNew==null){value.addNew=mac?event.metaKey:event.ctrlKey}
if(value.moveOnDrag==null){value.moveOnDrag=!(mac?event.altKey:event.ctrlKey)}
return value}
function leftButtonDown(cm,pos,repeat,event){if(ie){setTimeout(bind(ensureFocus,cm),0)}else{cm.curOp.focus=activeElt(root(cm))}
var behavior=configureMouse(cm,repeat,event);var sel=cm.doc.sel,contained;if(cm.options.dragDrop&&dragAndDrop&&!cm.isReadOnly()&&repeat=="single"&&(contained=sel.contains(pos))>-1&&(cmp((contained=sel.ranges[contained]).from(),pos)<0||pos.xRel>0)&&(cmp(contained.to(),pos)>0||pos.xRel<0)){leftButtonStartDrag(cm,event,pos,behavior)}else{leftButtonSelect(cm,event,pos,behavior)}}
function leftButtonStartDrag(cm,event,pos,behavior){var display=cm.display,moved=!1;var dragEnd=operation(cm,function(e){if(webkit){display.scroller.draggable=!1}
cm.state.draggingText=!1;if(cm.state.delayingBlurEvent){if(cm.hasFocus()){cm.state.delayingBlurEvent=!1}else{delayBlurEvent(cm)}}
off(display.wrapper.ownerDocument,"mouseup",dragEnd);off(display.wrapper.ownerDocument,"mousemove",mouseMove);off(display.scroller,"dragstart",dragStart);off(display.scroller,"drop",dragEnd);if(!moved){e_preventDefault(e);if(!behavior.addNew){extendSelection(cm.doc,pos,null,null,behavior.extend)}
if((webkit&&!safari)||ie&&ie_version==9){setTimeout(function(){display.wrapper.ownerDocument.body.focus({preventScroll:!0});display.input.focus()},20)}else{display.input.focus()}}});var mouseMove=function(e2){moved=moved||Math.abs(event.clientX-e2.clientX)+Math.abs(event.clientY-e2.clientY)>=10};var dragStart=function(){return moved=!0};if(webkit){display.scroller.draggable=!0}
cm.state.draggingText=dragEnd;dragEnd.copy=!behavior.moveOnDrag;on(display.wrapper.ownerDocument,"mouseup",dragEnd);on(display.wrapper.ownerDocument,"mousemove",mouseMove);on(display.scroller,"dragstart",dragStart);on(display.scroller,"drop",dragEnd);cm.state.delayingBlurEvent=!0;setTimeout(function(){return display.input.focus()},20);if(display.scroller.dragDrop){display.scroller.dragDrop()}}
function rangeForUnit(cm,pos,unit){if(unit=="char"){return new Range(pos,pos)}
if(unit=="word"){return cm.findWordAt(pos)}
if(unit=="line"){return new Range(Pos(pos.line,0),clipPos(cm.doc,Pos(pos.line+1,0)))}
var result=unit(cm,pos);return new Range(result.from,result.to)}
function leftButtonSelect(cm,event,start,behavior){if(ie){delayBlurEvent(cm)}
var display=cm.display,doc=cm.doc;e_preventDefault(event);var ourRange,ourIndex,startSel=doc.sel,ranges=startSel.ranges;if(behavior.addNew&&!behavior.extend){ourIndex=doc.sel.contains(start);if(ourIndex>-1){ourRange=ranges[ourIndex]}else{ourRange=new Range(start,start)}}else{ourRange=doc.sel.primary();ourIndex=doc.sel.primIndex}
if(behavior.unit=="rectangle"){if(!behavior.addNew){ourRange=new Range(start,start)}
start=posFromMouse(cm,event,!0,!0);ourIndex=-1}else{var range=rangeForUnit(cm,start,behavior.unit);if(behavior.extend){ourRange=extendRange(ourRange,range.anchor,range.head,behavior.extend)}else{ourRange=range}}
if(!behavior.addNew){ourIndex=0;setSelection(doc,new Selection([ourRange],0),sel_mouse);startSel=doc.sel}else if(ourIndex==-1){ourIndex=ranges.length;setSelection(doc,normalizeSelection(cm,ranges.concat([ourRange]),ourIndex),{scroll:!1,origin:"*mouse"})}else if(ranges.length>1&&ranges[ourIndex].empty()&&behavior.unit=="char"&&!behavior.extend){setSelection(doc,normalizeSelection(cm,ranges.slice(0,ourIndex).concat(ranges.slice(ourIndex+1)),0),{scroll:!1,origin:"*mouse"});startSel=doc.sel}else{replaceOneSelection(doc,ourIndex,ourRange,sel_mouse)}
var lastPos=start;function extendTo(pos){if(cmp(lastPos,pos)==0){return}
lastPos=pos;if(behavior.unit=="rectangle"){var ranges=[],tabSize=cm.options.tabSize;var startCol=countColumn(getLine(doc,start.line).text,start.ch,tabSize);var posCol=countColumn(getLine(doc,pos.line).text,pos.ch,tabSize);var left=Math.min(startCol,posCol),right=Math.max(startCol,posCol);for(var line=Math.min(start.line,pos.line),end=Math.min(cm.lastLine(),Math.max(start.line,pos.line));line<=end;line++){var text=getLine(doc,line).text,leftPos=findColumn(text,left,tabSize);if(left==right){ranges.push(new Range(Pos(line,leftPos),Pos(line,leftPos)))}else if(text.length>leftPos){ranges.push(new Range(Pos(line,leftPos),Pos(line,findColumn(text,right,tabSize))))}}
if(!ranges.length){ranges.push(new Range(start,start))}
setSelection(doc,normalizeSelection(cm,startSel.ranges.slice(0,ourIndex).concat(ranges),ourIndex),{origin:"*mouse",scroll:!1});cm.scrollIntoView(pos)}else{var oldRange=ourRange;var range=rangeForUnit(cm,pos,behavior.unit);var anchor=oldRange.anchor,head;if(cmp(range.anchor,anchor)>0){head=range.head;anchor=minPos(oldRange.from(),range.anchor)}else{head=range.anchor;anchor=maxPos(oldRange.to(),range.head)}
var ranges$1=startSel.ranges.slice(0);ranges$1[ourIndex]=bidiSimplify(cm,new Range(clipPos(doc,anchor),head));setSelection(doc,normalizeSelection(cm,ranges$1,ourIndex),sel_mouse)}}
var editorSize=display.wrapper.getBoundingClientRect();var counter=0;function extend(e){var curCount=++counter;var cur=posFromMouse(cm,e,!0,behavior.unit=="rectangle");if(!cur){return}
if(cmp(cur,lastPos)!=0){cm.curOp.focus=activeElt(root(cm));extendTo(cur);var visible=visibleLines(display,doc);if(cur.line>=visible.to||cur.line<visible.from){setTimeout(operation(cm,function(){if(counter==curCount){extend(e)}}),150)}}else{var outside=e.clientY<editorSize.top?-20:e.clientY>editorSize.bottom?20:0;if(outside){setTimeout(operation(cm,function(){if(counter!=curCount){return}
display.scroller.scrollTop+=outside;extend(e)}),50)}}}
function done(e){cm.state.selectingText=!1;counter=Infinity;if(e){e_preventDefault(e);display.input.focus()}
off(display.wrapper.ownerDocument,"mousemove",move);off(display.wrapper.ownerDocument,"mouseup",up);doc.history.lastSelOrigin=null}
var move=operation(cm,function(e){if(e.buttons===0||!e_button(e)){done(e)}else{extend(e)}});var up=operation(cm,done);cm.state.selectingText=up;on(display.wrapper.ownerDocument,"mousemove",move);on(display.wrapper.ownerDocument,"mouseup",up)}
function bidiSimplify(cm,range){var anchor=range.anchor;var head=range.head;var anchorLine=getLine(cm.doc,anchor.line);if(cmp(anchor,head)==0&&anchor.sticky==head.sticky){return range}
var order=getOrder(anchorLine);if(!order){return range}
var index=getBidiPartAt(order,anchor.ch,anchor.sticky),part=order[index];if(part.from!=anchor.ch&&part.to!=anchor.ch){return range}
var boundary=index+((part.from==anchor.ch)==(part.level!=1)?0:1);if(boundary==0||boundary==order.length){return range}
var leftSide;if(head.line!=anchor.line){leftSide=(head.line-anchor.line)*(cm.doc.direction=="ltr"?1:-1)>0}else{var headIndex=getBidiPartAt(order,head.ch,head.sticky);var dir=headIndex-index||(head.ch-anchor.ch)*(part.level==1?-1:1);if(headIndex==boundary-1||headIndex==boundary){leftSide=dir<0}else{leftSide=dir>0}}
var usePart=order[boundary+(leftSide?-1:0)];var from=leftSide==(usePart.level==1);var ch=from?usePart.from:usePart.to,sticky=from?"after":"before";return anchor.ch==ch&&anchor.sticky==sticky?range:new Range(new Pos(anchor.line,ch,sticky),head)}
function gutterEvent(cm,e,type,prevent){var mX,mY;if(e.touches){mX=e.touches[0].clientX;mY=e.touches[0].clientY}else{try{mX=e.clientX;mY=e.clientY}catch(e$1){return!1}}
if(mX>=Math.floor(cm.display.gutters.getBoundingClientRect().right)){return!1}
if(prevent){e_preventDefault(e)}
var display=cm.display;var lineBox=display.lineDiv.getBoundingClientRect();if(mY>lineBox.bottom||!hasHandler(cm,type)){return e_defaultPrevented(e)}
mY-=lineBox.top-display.viewOffset;for(var i=0;i<cm.display.gutterSpecs.length;++i){var g=display.gutters.childNodes[i];if(g&&g.getBoundingClientRect().right>=mX){var line=lineAtHeight(cm.doc,mY);var gutter=cm.display.gutterSpecs[i];signal(cm,type,cm,line,gutter.className,e);return e_defaultPrevented(e)}}}
function clickInGutter(cm,e){return gutterEvent(cm,e,"gutterClick",!0)}
function onContextMenu(cm,e){if(eventInWidget(cm.display,e)||contextMenuInGutter(cm,e)){return}
if(signalDOMEvent(cm,e,"contextmenu")){return}
if(!captureRightClick){cm.display.input.onContextMenu(e)}}
function contextMenuInGutter(cm,e){if(!hasHandler(cm,"gutterContextMenu")){return!1}
return gutterEvent(cm,e,"gutterContextMenu",!1)}
function themeChanged(cm){cm.display.wrapper.className=cm.display.wrapper.className.replace(/\s*cm-s-\S+/g,"")+cm.options.theme.replace(/(^|\s)\s*/g," cm-s-");clearCaches(cm)}
var Init={toString:function(){return"CodeMirror.Init"}};var defaults={};var optionHandlers={};function defineOptions(CodeMirror){var optionHandlers=CodeMirror.optionHandlers;function option(name,deflt,handle,notOnInit){CodeMirror.defaults[name]=deflt;if(handle){optionHandlers[name]=notOnInit?function(cm,val,old){if(old!=Init){handle(cm,val,old)}}:handle}}
CodeMirror.defineOption=option;CodeMirror.Init=Init;option("value","",function(cm,val){return cm.setValue(val)},!0);option("mode",null,function(cm,val){cm.doc.modeOption=val;loadMode(cm)},!0);option("indentUnit",2,loadMode,!0);option("indentWithTabs",!1);option("smartIndent",!0);option("tabSize",4,function(cm){resetModeState(cm);clearCaches(cm);regChange(cm)},!0);option("lineSeparator",null,function(cm,val){cm.doc.lineSep=val;if(!val){return}
var newBreaks=[],lineNo=cm.doc.first;cm.doc.iter(function(line){for(var pos=0;;){var found=line.text.indexOf(val,pos);if(found==-1){break}
pos=found+val.length;newBreaks.push(Pos(lineNo,found))}
lineNo++});for(var i=newBreaks.length-1;i>=0;i--){replaceRange(cm.doc,val,newBreaks[i],Pos(newBreaks[i].line,newBreaks[i].ch+val.length))}});option("specialChars",/[\u0000-\u001f\u007f-\u009f\u00ad\u061c\u200b\u200e\u200f\u2028\u2029\u202d\u202e\u2066\u2067\u2069\ufeff\ufff9-\ufffc]/g,function(cm,val,old){cm.state.specialChars=new RegExp(val.source+(val.test("\t")?"":"|\t"),"g");if(old!=Init){cm.refresh()}});option("specialCharPlaceholder",defaultSpecialCharPlaceholder,function(cm){return cm.refresh()},!0);option("electricChars",!0);option("inputStyle",mobile?"contenteditable":"textarea",function(){throw new Error("inputStyle can not (yet) be changed in a running editor")},!0);option("spellcheck",!1,function(cm,val){return cm.getInputField().spellcheck=val},!0);option("autocorrect",!1,function(cm,val){return cm.getInputField().autocorrect=val},!0);option("autocapitalize",!1,function(cm,val){return cm.getInputField().autocapitalize=val},!0);option("rtlMoveVisually",!windows);option("wholeLineUpdateBefore",!0);option("theme","default",function(cm){themeChanged(cm);updateGutters(cm)},!0);option("keyMap","default",function(cm,val,old){var next=getKeyMap(val);var prev=old!=Init&&getKeyMap(old);if(prev&&prev.detach){prev.detach(cm,next)}
if(next.attach){next.attach(cm,prev||null)}});option("extraKeys",null);option("configureMouse",null);option("lineWrapping",!1,wrappingChanged,!0);option("gutters",[],function(cm,val){cm.display.gutterSpecs=getGutters(val,cm.options.lineNumbers);updateGutters(cm)},!0);option("fixedGutter",!0,function(cm,val){cm.display.gutters.style.left=val?compensateForHScroll(cm.display)+"px":"0";cm.refresh()},!0);option("coverGutterNextToScrollbar",!1,function(cm){return updateScrollbars(cm)},!0);option("scrollbarStyle","native",function(cm){initScrollbars(cm);updateScrollbars(cm);cm.display.scrollbars.setScrollTop(cm.doc.scrollTop);cm.display.scrollbars.setScrollLeft(cm.doc.scrollLeft)},!0);option("lineNumbers",!1,function(cm,val){cm.display.gutterSpecs=getGutters(cm.options.gutters,val);updateGutters(cm)},!0);option("firstLineNumber",1,updateGutters,!0);option("lineNumberFormatter",function(integer){return integer},updateGutters,!0);option("showCursorWhenSelecting",!1,updateSelection,!0);option("resetSelectionOnContextMenu",!0);option("lineWiseCopyCut",!0);option("pasteLinesPerSelection",!0);option("selectionsMayTouch",!1);option("readOnly",!1,function(cm,val){if(val=="nocursor"){onBlur(cm);cm.display.input.blur()}
cm.display.input.readOnlyChanged(val)});option("screenReaderLabel",null,function(cm,val){val=(val==='')?null:val;cm.display.input.screenReaderLabelChanged(val)});option("disableInput",!1,function(cm,val){if(!val){cm.display.input.reset()}},!0);option("dragDrop",!0,dragDropChanged);option("allowDropFileTypes",null);option("cursorBlinkRate",530);option("cursorScrollMargin",0);option("cursorHeight",1,updateSelection,!0);option("singleCursorHeightPerLine",!0,updateSelection,!0);option("workTime",100);option("workDelay",100);option("flattenSpans",!0,resetModeState,!0);option("addModeClass",!1,resetModeState,!0);option("pollInterval",100);option("undoDepth",200,function(cm,val){return cm.doc.history.undoDepth=val});option("historyEventDelay",1250);option("viewportMargin",10,function(cm){return cm.refresh()},!0);option("maxHighlightLength",10000,resetModeState,!0);option("moveInputWithCursor",!0,function(cm,val){if(!val){cm.display.input.resetPosition()}});option("tabindex",null,function(cm,val){return cm.display.input.getField().tabIndex=val||""});option("autofocus",null);option("direction","ltr",function(cm,val){return cm.doc.setDirection(val)},!0);option("phrases",null)}
function dragDropChanged(cm,value,old){var wasOn=old&&old!=Init;if(!value!=!wasOn){var funcs=cm.display.dragFunctions;var toggle=value?on:off;toggle(cm.display.scroller,"dragstart",funcs.start);toggle(cm.display.scroller,"dragenter",funcs.enter);toggle(cm.display.scroller,"dragover",funcs.over);toggle(cm.display.scroller,"dragleave",funcs.leave);toggle(cm.display.scroller,"drop",funcs.drop)}}
function wrappingChanged(cm){if(cm.options.lineWrapping){addClass(cm.display.wrapper,"CodeMirror-wrap");cm.display.sizer.style.minWidth="";cm.display.sizerWidth=null}else{rmClass(cm.display.wrapper,"CodeMirror-wrap");findMaxLine(cm)}
estimateLineHeights(cm);regChange(cm);clearCaches(cm);setTimeout(function(){return updateScrollbars(cm)},100)}
function CodeMirror(place,options){var this$1=this;if(!(this instanceof CodeMirror)){return new CodeMirror(place,options)}
this.options=options=options?copyObj(options):{};copyObj(defaults,options,!1);var doc=options.value;if(typeof doc=="string"){doc=new Doc(doc,options.mode,null,options.lineSeparator,options.direction)}else if(options.mode){doc.modeOption=options.mode}
this.doc=doc;var input=new CodeMirror.inputStyles[options.inputStyle](this);var display=this.display=new Display(place,doc,input,options);display.wrapper.CodeMirror=this;themeChanged(this);if(options.lineWrapping){this.display.wrapper.className+=" CodeMirror-wrap"}
initScrollbars(this);this.state={keyMaps:[],overlays:[],modeGen:0,overwrite:!1,delayingBlurEvent:!1,focused:!1,suppressEdits:!1,pasteIncoming:-1,cutIncoming:-1,selectingText:!1,draggingText:!1,highlight:new Delayed(),keySeq:null,specialChars:null};if(options.autofocus&&!mobile){display.input.focus()}
if(ie&&ie_version<11){setTimeout(function(){return this$1.display.input.reset(!0)},20)}
registerEventHandlers(this);ensureGlobalHandlers();startOperation(this);this.curOp.forceUpdate=!0;attachDoc(this,doc);if((options.autofocus&&!mobile)||this.hasFocus()){setTimeout(function(){if(this$1.hasFocus()&&!this$1.state.focused){onFocus(this$1)}},20)}else{onBlur(this)}
for(var opt in optionHandlers){if(optionHandlers.hasOwnProperty(opt)){optionHandlers[opt](this,options[opt],Init)}}
maybeUpdateLineNumberWidth(this);if(options.finishInit){options.finishInit(this)}
for(var i=0;i<initHooks.length;++i){initHooks[i](this)}
endOperation(this);if(webkit&&options.lineWrapping&&getComputedStyle(display.lineDiv).textRendering=="optimizelegibility"){display.lineDiv.style.textRendering="auto"}}
CodeMirror.defaults=defaults;CodeMirror.optionHandlers=optionHandlers;function registerEventHandlers(cm){var d=cm.display;on(d.scroller,"mousedown",operation(cm,onMouseDown));if(ie&&ie_version<11){on(d.scroller,"dblclick",operation(cm,function(e){if(signalDOMEvent(cm,e)){return}
var pos=posFromMouse(cm,e);if(!pos||clickInGutter(cm,e)||eventInWidget(cm.display,e)){return}
e_preventDefault(e);var word=cm.findWordAt(pos);extendSelection(cm.doc,word.anchor,word.head)}))}else{on(d.scroller,"dblclick",function(e){return signalDOMEvent(cm,e)||e_preventDefault(e)})}
on(d.scroller,"contextmenu",function(e){return onContextMenu(cm,e)});on(d.input.getField(),"contextmenu",function(e){if(!d.scroller.contains(e.target)){onContextMenu(cm,e)}});var touchFinished,prevTouch={end:0};function finishTouch(){if(d.activeTouch){touchFinished=setTimeout(function(){return d.activeTouch=null},1000);prevTouch=d.activeTouch;prevTouch.end=+new Date}}
function isMouseLikeTouchEvent(e){if(e.touches.length!=1){return!1}
var touch=e.touches[0];return touch.radiusX<=1&&touch.radiusY<=1}
function farAway(touch,other){if(other.left==null){return!0}
var dx=other.left-touch.left,dy=other.top-touch.top;return dx*dx+dy*dy>20*20}
on(d.scroller,"touchstart",function(e){if(!signalDOMEvent(cm,e)&&!isMouseLikeTouchEvent(e)&&!clickInGutter(cm,e)){d.input.ensurePolled();clearTimeout(touchFinished);var now=+new Date;d.activeTouch={start:now,moved:!1,prev:now-prevTouch.end<=300?prevTouch:null};if(e.touches.length==1){d.activeTouch.left=e.touches[0].pageX;d.activeTouch.top=e.touches[0].pageY}}});on(d.scroller,"touchmove",function(){if(d.activeTouch){d.activeTouch.moved=!0}});on(d.scroller,"touchend",function(e){var touch=d.activeTouch;if(touch&&!eventInWidget(d,e)&&touch.left!=null&&!touch.moved&&new Date-touch.start<300){var pos=cm.coordsChar(d.activeTouch,"page"),range;if(!touch.prev||farAway(touch,touch.prev)){range=new Range(pos,pos)}else if(!touch.prev.prev||farAway(touch,touch.prev.prev)){range=cm.findWordAt(pos)}else{range=new Range(Pos(pos.line,0),clipPos(cm.doc,Pos(pos.line+1,0)))}
cm.setSelection(range.anchor,range.head);cm.focus();e_preventDefault(e)}
finishTouch()});on(d.scroller,"touchcancel",finishTouch);on(d.scroller,"scroll",function(){if(d.scroller.clientHeight){updateScrollTop(cm,d.scroller.scrollTop);setScrollLeft(cm,d.scroller.scrollLeft,!0);signal(cm,"scroll",cm)}});on(d.scroller,"mousewheel",function(e){return onScrollWheel(cm,e)});on(d.scroller,"DOMMouseScroll",function(e){return onScrollWheel(cm,e)});on(d.wrapper,"scroll",function(){return d.wrapper.scrollTop=d.wrapper.scrollLeft=0});d.dragFunctions={enter:function(e){if(!signalDOMEvent(cm,e)){e_stop(e)}},over:function(e){if(!signalDOMEvent(cm,e)){onDragOver(cm,e);e_stop(e)}},start:function(e){return onDragStart(cm,e)},drop:operation(cm,onDrop),leave:function(e){if(!signalDOMEvent(cm,e)){clearDragCursor(cm)}}};var inp=d.input.getField();on(inp,"keyup",function(e){return onKeyUp.call(cm,e)});on(inp,"keydown",operation(cm,onKeyDown));on(inp,"keypress",operation(cm,onKeyPress));on(inp,"focus",function(e){return onFocus(cm,e)});on(inp,"blur",function(e){return onBlur(cm,e)})}
var initHooks=[];CodeMirror.defineInitHook=function(f){return initHooks.push(f)};function indentLine(cm,n,how,aggressive){var doc=cm.doc,state;if(how==null){how="add"}
if(how=="smart"){if(!doc.mode.indent){how="prev"}else{state=getContextBefore(cm,n).state}}
var tabSize=cm.options.tabSize;var line=getLine(doc,n),curSpace=countColumn(line.text,null,tabSize);if(line.stateAfter){line.stateAfter=null}
var curSpaceString=line.text.match(/^\s*/)[0],indentation;if(!aggressive&&!/\S/.test(line.text)){indentation=0;how="not"}else if(how=="smart"){indentation=doc.mode.indent(state,line.text.slice(curSpaceString.length),line.text);if(indentation==Pass||indentation>150){if(!aggressive){return}
how="prev"}}
if(how=="prev"){if(n>doc.first){indentation=countColumn(getLine(doc,n-1).text,null,tabSize)}else{indentation=0}}else if(how=="add"){indentation=curSpace+cm.options.indentUnit}else if(how=="subtract"){indentation=curSpace-cm.options.indentUnit}else if(typeof how=="number"){indentation=curSpace+how}
indentation=Math.max(0,indentation);var indentString="",pos=0;if(cm.options.indentWithTabs){for(var i=Math.floor(indentation/tabSize);i;--i){pos+=tabSize;indentString+="\t"}}
if(pos<indentation){indentString+=spaceStr(indentation-pos)}
if(indentString!=curSpaceString){replaceRange(doc,indentString,Pos(n,0),Pos(n,curSpaceString.length),"+input");line.stateAfter=null;return!0}else{for(var i$1=0;i$1<doc.sel.ranges.length;i$1++){var range=doc.sel.ranges[i$1];if(range.head.line==n&&range.head.ch<curSpaceString.length){var pos$1=Pos(n,curSpaceString.length);replaceOneSelection(doc,i$1,new Range(pos$1,pos$1));break}}}}
var lastCopied=null;function setLastCopied(newLastCopied){lastCopied=newLastCopied}
function applyTextInput(cm,inserted,deleted,sel,origin){var doc=cm.doc;cm.display.shift=!1;if(!sel){sel=doc.sel}
var recent=+new Date-200;var paste=origin=="paste"||cm.state.pasteIncoming>recent;var textLines=splitLinesAuto(inserted),multiPaste=null;if(paste&&sel.ranges.length>1){if(lastCopied&&lastCopied.text.join("\n")==inserted){if(sel.ranges.length%lastCopied.text.length==0){multiPaste=[];for(var i=0;i<lastCopied.text.length;i++){multiPaste.push(doc.splitLines(lastCopied.text[i]))}}}else if(textLines.length==sel.ranges.length&&cm.options.pasteLinesPerSelection){multiPaste=map(textLines,function(l){return[l]})}}
var updateInput=cm.curOp.updateInput;for(var i$1=sel.ranges.length-1;i$1>=0;i$1--){var range=sel.ranges[i$1];var from=range.from(),to=range.to();if(range.empty()){if(deleted&&deleted>0){from=Pos(from.line,from.ch-deleted)}else if(cm.state.overwrite&&!paste){to=Pos(to.line,Math.min(getLine(doc,to.line).text.length,to.ch+lst(textLines).length))}else if(paste&&lastCopied&&lastCopied.lineWise&&lastCopied.text.join("\n")==textLines.join("\n")){from=to=Pos(from.line,0)}}
var changeEvent={from:from,to:to,text:multiPaste?multiPaste[i$1%multiPaste.length]:textLines,origin:origin||(paste?"paste":cm.state.cutIncoming>recent?"cut":"+input")};makeChange(cm.doc,changeEvent);signalLater(cm,"inputRead",cm,changeEvent)}
if(inserted&&!paste){triggerElectric(cm,inserted)}
ensureCursorVisible(cm);if(cm.curOp.updateInput<2){cm.curOp.updateInput=updateInput}
cm.curOp.typing=!0;cm.state.pasteIncoming=cm.state.cutIncoming=-1}
function handlePaste(e,cm){var pasted=e.clipboardData&&e.clipboardData.getData("Text");if(pasted){e.preventDefault();if(!cm.isReadOnly()&&!cm.options.disableInput&&cm.hasFocus()){runInOp(cm,function(){return applyTextInput(cm,pasted,0,null,"paste")})}
return!0}}
function triggerElectric(cm,inserted){if(!cm.options.electricChars||!cm.options.smartIndent){return}
var sel=cm.doc.sel;for(var i=sel.ranges.length-1;i>=0;i--){var range=sel.ranges[i];if(range.head.ch>100||(i&&sel.ranges[i-1].head.line==range.head.line)){continue}
var mode=cm.getModeAt(range.head);var indented=!1;if(mode.electricChars){for(var j=0;j<mode.electricChars.length;j++){if(inserted.indexOf(mode.electricChars.charAt(j))>-1){indented=indentLine(cm,range.head.line,"smart");break}}}else if(mode.electricInput){if(mode.electricInput.test(getLine(cm.doc,range.head.line).text.slice(0,range.head.ch))){indented=indentLine(cm,range.head.line,"smart")}}
if(indented){signalLater(cm,"electricInput",cm,range.head.line)}}}
function copyableRanges(cm){var text=[],ranges=[];for(var i=0;i<cm.doc.sel.ranges.length;i++){var line=cm.doc.sel.ranges[i].head.line;var lineRange={anchor:Pos(line,0),head:Pos(line+1,0)};ranges.push(lineRange);text.push(cm.getRange(lineRange.anchor,lineRange.head))}
return{text:text,ranges:ranges}}
function disableBrowserMagic(field,spellcheck,autocorrect,autocapitalize){field.setAttribute("autocorrect",autocorrect?"on":"off");field.setAttribute("autocapitalize",autocapitalize?"on":"off");field.setAttribute("spellcheck",!!spellcheck)}
function hiddenTextarea(){var te=elt("textarea",null,null,"position: absolute; bottom: -1em; padding: 0; width: 1px; height: 1em; min-height: 1em; outline: none");var div=elt("div",[te],null,"overflow: hidden; position: relative; width: 3px; height: 0px;");if(webkit){te.style.width="1000px"}else{te.setAttribute("wrap","off")}
if(ios){te.style.border="1px solid black"}
return div}
function addEditorMethods(CodeMirror){var optionHandlers=CodeMirror.optionHandlers;var helpers=CodeMirror.helpers={};CodeMirror.prototype={constructor:CodeMirror,focus:function(){win(this).focus();this.display.input.focus()},setOption:function(option,value){var options=this.options,old=options[option];if(options[option]==value&&option!="mode"){return}
options[option]=value;if(optionHandlers.hasOwnProperty(option)){operation(this,optionHandlers[option])(this,value,old)}
signal(this,"optionChange",this,option)},getOption:function(option){return this.options[option]},getDoc:function(){return this.doc},addKeyMap:function(map,bottom){this.state.keyMaps[bottom?"push":"unshift"](getKeyMap(map))},removeKeyMap:function(map){var maps=this.state.keyMaps;for(var i=0;i<maps.length;++i){if(maps[i]==map||maps[i].name==map){maps.splice(i,1);return!0}}},addOverlay:methodOp(function(spec,options){var mode=spec.token?spec:CodeMirror.getMode(this.options,spec);if(mode.startState){throw new Error("Overlays may not be stateful.")}
insertSorted(this.state.overlays,{mode:mode,modeSpec:spec,opaque:options&&options.opaque,priority:(options&&options.priority)||0},function(overlay){return overlay.priority});this.state.modeGen++;regChange(this)}),removeOverlay:methodOp(function(spec){var overlays=this.state.overlays;for(var i=0;i<overlays.length;++i){var cur=overlays[i].modeSpec;if(cur==spec||typeof spec=="string"&&cur.name==spec){overlays.splice(i,1);this.state.modeGen++;regChange(this);return}}}),indentLine:methodOp(function(n,dir,aggressive){if(typeof dir!="string"&&typeof dir!="number"){if(dir==null){dir=this.options.smartIndent?"smart":"prev"}else{dir=dir?"add":"subtract"}}
if(isLine(this.doc,n)){indentLine(this,n,dir,aggressive)}}),indentSelection:methodOp(function(how){var ranges=this.doc.sel.ranges,end=-1;for(var i=0;i<ranges.length;i++){var range=ranges[i];if(!range.empty()){var from=range.from(),to=range.to();var start=Math.max(end,from.line);end=Math.min(this.lastLine(),to.line-(to.ch?0:1))+1;for(var j=start;j<end;++j){indentLine(this,j,how)}
var newRanges=this.doc.sel.ranges;if(from.ch==0&&ranges.length==newRanges.length&&newRanges[i].from().ch>0){replaceOneSelection(this.doc,i,new Range(from,newRanges[i].to()),sel_dontScroll)}}else if(range.head.line>end){indentLine(this,range.head.line,how,!0);end=range.head.line;if(i==this.doc.sel.primIndex){ensureCursorVisible(this)}}}}),getTokenAt:function(pos,precise){return takeToken(this,pos,precise)},getLineTokens:function(line,precise){return takeToken(this,Pos(line),precise,!0)},getTokenTypeAt:function(pos){pos=clipPos(this.doc,pos);var styles=getLineStyles(this,getLine(this.doc,pos.line));var before=0,after=(styles.length-1)/2,ch=pos.ch;var type;if(ch==0){type=styles[2]}else{for(;;){var mid=(before+after)>>1;if((mid?styles[mid*2-1]:0)>=ch){after=mid}else if(styles[mid*2+1]<ch){before=mid+1}else{type=styles[mid*2+2];break}}}
var cut=type?type.indexOf("overlay "):-1;return cut<0?type:cut==0?null:type.slice(0,cut-1)},getModeAt:function(pos){var mode=this.doc.mode;if(!mode.innerMode){return mode}
return CodeMirror.innerMode(mode,this.getTokenAt(pos).state).mode},getHelper:function(pos,type){return this.getHelpers(pos,type)[0]},getHelpers:function(pos,type){var found=[];if(!helpers.hasOwnProperty(type)){return found}
var help=helpers[type],mode=this.getModeAt(pos);if(typeof mode[type]=="string"){if(help[mode[type]]){found.push(help[mode[type]])}}else if(mode[type]){for(var i=0;i<mode[type].length;i++){var val=help[mode[type][i]];if(val){found.push(val)}}}else if(mode.helperType&&help[mode.helperType]){found.push(help[mode.helperType])}else if(help[mode.name]){found.push(help[mode.name])}
for(var i$1=0;i$1<help._global.length;i$1++){var cur=help._global[i$1];if(cur.pred(mode,this)&&indexOf(found,cur.val)==-1){found.push(cur.val)}}
return found},getStateAfter:function(line,precise){var doc=this.doc;line=clipLine(doc,line==null?doc.first+doc.size-1:line);return getContextBefore(this,line+1,precise).state},cursorCoords:function(start,mode){var pos,range=this.doc.sel.primary();if(start==null){pos=range.head}else if(typeof start=="object"){pos=clipPos(this.doc,start)}else{pos=start?range.from():range.to()}
return cursorCoords(this,pos,mode||"page")},charCoords:function(pos,mode){return charCoords(this,clipPos(this.doc,pos),mode||"page")},coordsChar:function(coords,mode){coords=fromCoordSystem(this,coords,mode||"page");return coordsChar(this,coords.left,coords.top)},lineAtHeight:function(height,mode){height=fromCoordSystem(this,{top:height,left:0},mode||"page").top;return lineAtHeight(this.doc,height+this.display.viewOffset)},heightAtLine:function(line,mode,includeWidgets){var end=!1,lineObj;if(typeof line=="number"){var last=this.doc.first+this.doc.size-1;if(line<this.doc.first){line=this.doc.first}else if(line>last){line=last;end=!0}
lineObj=getLine(this.doc,line)}else{lineObj=line}
return intoCoordSystem(this,lineObj,{top:0,left:0},mode||"page",includeWidgets||end).top+(end?this.doc.height-heightAtLine(lineObj):0)},defaultTextHeight:function(){return textHeight(this.display)},defaultCharWidth:function(){return charWidth(this.display)},getViewport:function(){return{from:this.display.viewFrom,to:this.display.viewTo}},addWidget:function(pos,node,scroll,vert,horiz){var display=this.display;pos=cursorCoords(this,clipPos(this.doc,pos));var top=pos.bottom,left=pos.left;node.style.position="absolute";node.setAttribute("cm-ignore-events","true");this.display.input.setUneditable(node);display.sizer.appendChild(node);if(vert=="over"){top=pos.top}else if(vert=="above"||vert=="near"){var vspace=Math.max(display.wrapper.clientHeight,this.doc.height),hspace=Math.max(display.sizer.clientWidth,display.lineSpace.clientWidth);if((vert=='above'||pos.bottom+node.offsetHeight>vspace)&&pos.top>node.offsetHeight){top=pos.top-node.offsetHeight}else if(pos.bottom+node.offsetHeight<=vspace){top=pos.bottom}
if(left+node.offsetWidth>hspace){left=hspace-node.offsetWidth}}
node.style.top=top+"px";node.style.left=node.style.right="";if(horiz=="right"){left=display.sizer.clientWidth-node.offsetWidth;node.style.right="0px"}else{if(horiz=="left"){left=0}else if(horiz=="middle"){left=(display.sizer.clientWidth-node.offsetWidth)/2}
node.style.left=left+"px"}
if(scroll){scrollIntoView(this,{left:left,top:top,right:left+node.offsetWidth,bottom:top+node.offsetHeight})}},triggerOnKeyDown:methodOp(onKeyDown),triggerOnKeyPress:methodOp(onKeyPress),triggerOnKeyUp:onKeyUp,triggerOnMouseDown:methodOp(onMouseDown),execCommand:function(cmd){if(commands.hasOwnProperty(cmd)){return commands[cmd].call(null,this)}},triggerElectric:methodOp(function(text){triggerElectric(this,text)}),findPosH:function(from,amount,unit,visually){var dir=1;if(amount<0){dir=-1;amount=-amount}
var cur=clipPos(this.doc,from);for(var i=0;i<amount;++i){cur=findPosH(this.doc,cur,dir,unit,visually);if(cur.hitSide){break}}
return cur},moveH:methodOp(function(dir,unit){var this$1=this;this.extendSelectionsBy(function(range){if(this$1.display.shift||this$1.doc.extend||range.empty()){return findPosH(this$1.doc,range.head,dir,unit,this$1.options.rtlMoveVisually)}else{return dir<0?range.from():range.to()}},sel_move)}),deleteH:methodOp(function(dir,unit){var sel=this.doc.sel,doc=this.doc;if(sel.somethingSelected()){doc.replaceSelection("",null,"+delete")}else{deleteNearSelection(this,function(range){var other=findPosH(doc,range.head,dir,unit,!1);return dir<0?{from:other,to:range.head}:{from:range.head,to:other}})}}),findPosV:function(from,amount,unit,goalColumn){var dir=1,x=goalColumn;if(amount<0){dir=-1;amount=-amount}
var cur=clipPos(this.doc,from);for(var i=0;i<amount;++i){var coords=cursorCoords(this,cur,"div");if(x==null){x=coords.left}else{coords.left=x}
cur=findPosV(this,coords,dir,unit);if(cur.hitSide){break}}
return cur},moveV:methodOp(function(dir,unit){var this$1=this;var doc=this.doc,goals=[];var collapse=!this.display.shift&&!doc.extend&&doc.sel.somethingSelected();doc.extendSelectionsBy(function(range){if(collapse){return dir<0?range.from():range.to()}
var headPos=cursorCoords(this$1,range.head,"div");if(range.goalColumn!=null){headPos.left=range.goalColumn}
goals.push(headPos.left);var pos=findPosV(this$1,headPos,dir,unit);if(unit=="page"&&range==doc.sel.primary()){addToScrollTop(this$1,charCoords(this$1,pos,"div").top-headPos.top)}
return pos},sel_move);if(goals.length){for(var i=0;i<doc.sel.ranges.length;i++){doc.sel.ranges[i].goalColumn=goals[i]}}}),findWordAt:function(pos){var doc=this.doc,line=getLine(doc,pos.line).text;var start=pos.ch,end=pos.ch;if(line){var helper=this.getHelper(pos,"wordChars");if((pos.sticky=="before"||end==line.length)&&start){--start}else{++end}
var startChar=line.charAt(start);var check=isWordChar(startChar,helper)?function(ch){return isWordChar(ch,helper)}:/\s/.test(startChar)?function(ch){return/\s/.test(ch)}:function(ch){return(!/\s/.test(ch)&&!isWordChar(ch))};while(start>0&&check(line.charAt(start-1))){--start}
while(end<line.length&&check(line.charAt(end))){++end}}
return new Range(Pos(pos.line,start),Pos(pos.line,end))},toggleOverwrite:function(value){if(value!=null&&value==this.state.overwrite){return}
if(this.state.overwrite=!this.state.overwrite){addClass(this.display.cursorDiv,"CodeMirror-overwrite")}else{rmClass(this.display.cursorDiv,"CodeMirror-overwrite")}
signal(this,"overwriteToggle",this,this.state.overwrite)},hasFocus:function(){return this.display.input.getField()==activeElt(root(this))},isReadOnly:function(){return!!(this.options.readOnly||this.doc.cantEdit)},scrollTo:methodOp(function(x,y){scrollToCoords(this,x,y)}),getScrollInfo:function(){var scroller=this.display.scroller;return{left:scroller.scrollLeft,top:scroller.scrollTop,height:scroller.scrollHeight-scrollGap(this)-this.display.barHeight,width:scroller.scrollWidth-scrollGap(this)-this.display.barWidth,clientHeight:displayHeight(this),clientWidth:displayWidth(this)}},scrollIntoView:methodOp(function(range,margin){if(range==null){range={from:this.doc.sel.primary().head,to:null};if(margin==null){margin=this.options.cursorScrollMargin}}else if(typeof range=="number"){range={from:Pos(range,0),to:null}}else if(range.from==null){range={from:range,to:null}}
if(!range.to){range.to=range.from}
range.margin=margin||0;if(range.from.line!=null){scrollToRange(this,range)}else{scrollToCoordsRange(this,range.from,range.to,range.margin)}}),setSize:methodOp(function(width,height){var this$1=this;var interpret=function(val){return typeof val=="number"||/^\d+$/.test(String(val))?val+"px":val};if(width!=null){this.display.wrapper.style.width=interpret(width)}
if(height!=null){this.display.wrapper.style.height=interpret(height)}
if(this.options.lineWrapping){clearLineMeasurementCache(this)}
var lineNo=this.display.viewFrom;this.doc.iter(lineNo,this.display.viewTo,function(line){if(line.widgets){for(var i=0;i<line.widgets.length;i++){if(line.widgets[i].noHScroll){regLineChange(this$1,lineNo,"widget");break}}}
++lineNo});this.curOp.forceUpdate=!0;signal(this,"refresh",this)}),operation:function(f){return runInOp(this,f)},startOperation:function(){return startOperation(this)},endOperation:function(){return endOperation(this)},refresh:methodOp(function(){var oldHeight=this.display.cachedTextHeight;regChange(this);this.curOp.forceUpdate=!0;clearCaches(this);scrollToCoords(this,this.doc.scrollLeft,this.doc.scrollTop);updateGutterSpace(this.display);if(oldHeight==null||Math.abs(oldHeight-textHeight(this.display))>.5||this.options.lineWrapping){estimateLineHeights(this)}
signal(this,"refresh",this)}),swapDoc:methodOp(function(doc){var old=this.doc;old.cm=null;if(this.state.selectingText){this.state.selectingText()}
attachDoc(this,doc);clearCaches(this);this.display.input.reset();scrollToCoords(this,doc.scrollLeft,doc.scrollTop);this.curOp.forceScroll=!0;signalLater(this,"swapDoc",this,old);return old}),phrase:function(phraseText){var phrases=this.options.phrases;return phrases&&Object.prototype.hasOwnProperty.call(phrases,phraseText)?phrases[phraseText]:phraseText},getInputField:function(){return this.display.input.getField()},getWrapperElement:function(){return this.display.wrapper},getScrollerElement:function(){return this.display.scroller},getGutterElement:function(){return this.display.gutters}};eventMixin(CodeMirror);CodeMirror.registerHelper=function(type,name,value){if(!helpers.hasOwnProperty(type)){helpers[type]=CodeMirror[type]={_global:[]}}
helpers[type][name]=value};CodeMirror.registerGlobalHelper=function(type,name,predicate,value){CodeMirror.registerHelper(type,name,value);helpers[type]._global.push({pred:predicate,val:value})}}
function findPosH(doc,pos,dir,unit,visually){var oldPos=pos;var origDir=dir;var lineObj=getLine(doc,pos.line);var lineDir=visually&&doc.direction=="rtl"?-dir:dir;function findNextLine(){var l=pos.line+lineDir;if(l<doc.first||l>=doc.first+doc.size){return!1}
pos=new Pos(l,pos.ch,pos.sticky);return lineObj=getLine(doc,l)}
function moveOnce(boundToLine){var next;if(unit=="codepoint"){var ch=lineObj.text.charCodeAt(pos.ch+(dir>0?0:-1));if(isNaN(ch)){next=null}else{var astral=dir>0?ch>=0xD800&&ch<0xDC00:ch>=0xDC00&&ch<0xDFFF;next=new Pos(pos.line,Math.max(0,Math.min(lineObj.text.length,pos.ch+dir*(astral?2:1))),-dir)}}else if(visually){next=moveVisually(doc.cm,lineObj,pos,dir)}else{next=moveLogically(lineObj,pos,dir)}
if(next==null){if(!boundToLine&&findNextLine()){pos=endOfLine(visually,doc.cm,lineObj,pos.line,lineDir)}else{return!1}}else{pos=next}
return!0}
if(unit=="char"||unit=="codepoint"){moveOnce()}else if(unit=="column"){moveOnce(!0)}else if(unit=="word"||unit=="group"){var sawType=null,group=unit=="group";var helper=doc.cm&&doc.cm.getHelper(pos,"wordChars");for(var first=!0;;first=!1){if(dir<0&&!moveOnce(!first)){break}
var cur=lineObj.text.charAt(pos.ch)||"\n";var type=isWordChar(cur,helper)?"w":group&&cur=="\n"?"n":!group||/\s/.test(cur)?null:"p";if(group&&!first&&!type){type="s"}
if(sawType&&sawType!=type){if(dir<0){dir=1;moveOnce();pos.sticky="after"}
break}
if(type){sawType=type}
if(dir>0&&!moveOnce(!first)){break}}}
var result=skipAtomic(doc,pos,oldPos,origDir,!0);if(equalCursorPos(oldPos,result)){result.hitSide=!0}
return result}
function findPosV(cm,pos,dir,unit){var doc=cm.doc,x=pos.left,y;if(unit=="page"){var pageSize=Math.min(cm.display.wrapper.clientHeight,win(cm).innerHeight||doc(cm).documentElement.clientHeight);var moveAmount=Math.max(pageSize-.5*textHeight(cm.display),3);y=(dir>0?pos.bottom:pos.top)+dir*moveAmount}else if(unit=="line"){y=dir>0?pos.bottom+3:pos.top-3}
var target;for(;;){target=coordsChar(cm,x,y);if(!target.outside){break}
if(dir<0?y<=0:y>=doc.height){target.hitSide=!0;break}
y+=dir*5}
return target}
var ContentEditableInput=function(cm){this.cm=cm;this.lastAnchorNode=this.lastAnchorOffset=this.lastFocusNode=this.lastFocusOffset=null;this.polling=new Delayed();this.composing=null;this.gracePeriod=!1;this.readDOMTimeout=null};ContentEditableInput.prototype.init=function(display){var this$1=this;var input=this,cm=input.cm;var div=input.div=display.lineDiv;div.contentEditable=!0;disableBrowserMagic(div,cm.options.spellcheck,cm.options.autocorrect,cm.options.autocapitalize);function belongsToInput(e){for(var t=e.target;t;t=t.parentNode){if(t==div){return!0}
if(/\bCodeMirror-(?:line)?widget\b/.test(t.className)){break}}
return!1}
on(div,"paste",function(e){if(!belongsToInput(e)||signalDOMEvent(cm,e)||handlePaste(e,cm)){return}
if(ie_version<=11){setTimeout(operation(cm,function(){return this$1.updateFromDOM()}),20)}});on(div,"compositionstart",function(e){this$1.composing={data:e.data,done:!1}});on(div,"compositionupdate",function(e){if(!this$1.composing){this$1.composing={data:e.data,done:!1}}});on(div,"compositionend",function(e){if(this$1.composing){if(e.data!=this$1.composing.data){this$1.readFromDOMSoon()}
this$1.composing.done=!0}});on(div,"touchstart",function(){return input.forceCompositionEnd()});on(div,"input",function(){if(!this$1.composing){this$1.readFromDOMSoon()}});function onCopyCut(e){if(!belongsToInput(e)||signalDOMEvent(cm,e)){return}
if(cm.somethingSelected()){setLastCopied({lineWise:!1,text:cm.getSelections()});if(e.type=="cut"){cm.replaceSelection("",null,"cut")}}else if(!cm.options.lineWiseCopyCut){return}else{var ranges=copyableRanges(cm);setLastCopied({lineWise:!0,text:ranges.text});if(e.type=="cut"){cm.operation(function(){cm.setSelections(ranges.ranges,0,sel_dontScroll);cm.replaceSelection("",null,"cut")})}}
if(e.clipboardData){e.clipboardData.clearData();var content=lastCopied.text.join("\n");e.clipboardData.setData("Text",content);if(e.clipboardData.getData("Text")==content){e.preventDefault();return}}
var kludge=hiddenTextarea(),te=kludge.firstChild;disableBrowserMagic(te);cm.display.lineSpace.insertBefore(kludge,cm.display.lineSpace.firstChild);te.value=lastCopied.text.join("\n");var hadFocus=activeElt(rootNode(div));selectInput(te);setTimeout(function(){cm.display.lineSpace.removeChild(kludge);hadFocus.focus();if(hadFocus==div){input.showPrimarySelection()}},50)}
on(div,"copy",onCopyCut);on(div,"cut",onCopyCut)};ContentEditableInput.prototype.screenReaderLabelChanged=function(label){if(label){this.div.setAttribute('aria-label',label)}else{this.div.removeAttribute('aria-label')}};ContentEditableInput.prototype.prepareSelection=function(){var result=prepareSelection(this.cm,!1);result.focus=activeElt(rootNode(this.div))==this.div;return result};ContentEditableInput.prototype.showSelection=function(info,takeFocus){if(!info||!this.cm.display.view.length){return}
if(info.focus||takeFocus){this.showPrimarySelection()}
this.showMultipleSelections(info)};ContentEditableInput.prototype.getSelection=function(){return this.cm.display.wrapper.ownerDocument.getSelection()};ContentEditableInput.prototype.showPrimarySelection=function(){var sel=this.getSelection(),cm=this.cm,prim=cm.doc.sel.primary();var from=prim.from(),to=prim.to();if(cm.display.viewTo==cm.display.viewFrom||from.line>=cm.display.viewTo||to.line<cm.display.viewFrom){sel.removeAllRanges();return}
var curAnchor=domToPos(cm,sel.anchorNode,sel.anchorOffset);var curFocus=domToPos(cm,sel.focusNode,sel.focusOffset);if(curAnchor&&!curAnchor.bad&&curFocus&&!curFocus.bad&&cmp(minPos(curAnchor,curFocus),from)==0&&cmp(maxPos(curAnchor,curFocus),to)==0){return}
var view=cm.display.view;var start=(from.line>=cm.display.viewFrom&&posToDOM(cm,from))||{node:view[0].measure.map[2],offset:0};var end=to.line<cm.display.viewTo&&posToDOM(cm,to);if(!end){var measure=view[view.length-1].measure;var map=measure.maps?measure.maps[measure.maps.length-1]:measure.map;end={node:map[map.length-1],offset:map[map.length-2]-map[map.length-3]}}
if(!start||!end){sel.removeAllRanges();return}
var old=sel.rangeCount&&sel.getRangeAt(0),rng;try{rng=range(start.node,start.offset,end.offset,end.node)}catch(e){}
if(rng){if(!gecko&&cm.state.focused){sel.collapse(start.node,start.offset);if(!rng.collapsed){sel.removeAllRanges();sel.addRange(rng)}}else{sel.removeAllRanges();sel.addRange(rng)}
if(old&&sel.anchorNode==null){sel.addRange(old)}else if(gecko){this.startGracePeriod()}}
this.rememberSelection()};ContentEditableInput.prototype.startGracePeriod=function(){var this$1=this;clearTimeout(this.gracePeriod);this.gracePeriod=setTimeout(function(){this$1.gracePeriod=!1;if(this$1.selectionChanged()){this$1.cm.operation(function(){return this$1.cm.curOp.selectionChanged=!0})}},20)};ContentEditableInput.prototype.showMultipleSelections=function(info){removeChildrenAndAdd(this.cm.display.cursorDiv,info.cursors);removeChildrenAndAdd(this.cm.display.selectionDiv,info.selection)};ContentEditableInput.prototype.rememberSelection=function(){var sel=this.getSelection();this.lastAnchorNode=sel.anchorNode;this.lastAnchorOffset=sel.anchorOffset;this.lastFocusNode=sel.focusNode;this.lastFocusOffset=sel.focusOffset};ContentEditableInput.prototype.selectionInEditor=function(){var sel=this.getSelection();if(!sel.rangeCount){return!1}
var node=sel.getRangeAt(0).commonAncestorContainer;return contains(this.div,node)};ContentEditableInput.prototype.focus=function(){if(this.cm.options.readOnly!="nocursor"){if(!this.selectionInEditor()||activeElt(rootNode(this.div))!=this.div){this.showSelection(this.prepareSelection(),!0)}
this.div.focus()}};ContentEditableInput.prototype.blur=function(){this.div.blur()};ContentEditableInput.prototype.getField=function(){return this.div};ContentEditableInput.prototype.supportsTouch=function(){return!0};ContentEditableInput.prototype.receivedFocus=function(){var this$1=this;var input=this;if(this.selectionInEditor()){setTimeout(function(){return this$1.pollSelection()},20)}else{runInOp(this.cm,function(){return input.cm.curOp.selectionChanged=!0})}
function poll(){if(input.cm.state.focused){input.pollSelection();input.polling.set(input.cm.options.pollInterval,poll)}}
this.polling.set(this.cm.options.pollInterval,poll)};ContentEditableInput.prototype.selectionChanged=function(){var sel=this.getSelection();return sel.anchorNode!=this.lastAnchorNode||sel.anchorOffset!=this.lastAnchorOffset||sel.focusNode!=this.lastFocusNode||sel.focusOffset!=this.lastFocusOffset};ContentEditableInput.prototype.pollSelection=function(){if(this.readDOMTimeout!=null||this.gracePeriod||!this.selectionChanged()){return}
var sel=this.getSelection(),cm=this.cm;if(android&&chrome&&this.cm.display.gutterSpecs.length&&isInGutter(sel.anchorNode)){this.cm.triggerOnKeyDown({type:"keydown",keyCode:8,preventDefault:Math.abs});this.blur();this.focus();return}
if(this.composing){return}
this.rememberSelection();var anchor=domToPos(cm,sel.anchorNode,sel.anchorOffset);var head=domToPos(cm,sel.focusNode,sel.focusOffset);if(anchor&&head){runInOp(cm,function(){setSelection(cm.doc,simpleSelection(anchor,head),sel_dontScroll);if(anchor.bad||head.bad){cm.curOp.selectionChanged=!0}})}};ContentEditableInput.prototype.pollContent=function(){if(this.readDOMTimeout!=null){clearTimeout(this.readDOMTimeout);this.readDOMTimeout=null}
var cm=this.cm,display=cm.display,sel=cm.doc.sel.primary();var from=sel.from(),to=sel.to();if(from.ch==0&&from.line>cm.firstLine()){from=Pos(from.line-1,getLine(cm.doc,from.line-1).length)}
if(to.ch==getLine(cm.doc,to.line).text.length&&to.line<cm.lastLine()){to=Pos(to.line+1,0)}
if(from.line<display.viewFrom||to.line>display.viewTo-1){return!1}
var fromIndex,fromLine,fromNode;if(from.line==display.viewFrom||(fromIndex=findViewIndex(cm,from.line))==0){fromLine=lineNo(display.view[0].line);fromNode=display.view[0].node}else{fromLine=lineNo(display.view[fromIndex].line);fromNode=display.view[fromIndex-1].node.nextSibling}
var toIndex=findViewIndex(cm,to.line);var toLine,toNode;if(toIndex==display.view.length-1){toLine=display.viewTo-1;toNode=display.lineDiv.lastChild}else{toLine=lineNo(display.view[toIndex+1].line)-1;toNode=display.view[toIndex+1].node.previousSibling}
if(!fromNode){return!1}
var newText=cm.doc.splitLines(domTextBetween(cm,fromNode,toNode,fromLine,toLine));var oldText=getBetween(cm.doc,Pos(fromLine,0),Pos(toLine,getLine(cm.doc,toLine).text.length));while(newText.length>1&&oldText.length>1){if(lst(newText)==lst(oldText)){newText.pop();oldText.pop();toLine--}else if(newText[0]==oldText[0]){newText.shift();oldText.shift();fromLine++}else{break}}
var cutFront=0,cutEnd=0;var newTop=newText[0],oldTop=oldText[0],maxCutFront=Math.min(newTop.length,oldTop.length);while(cutFront<maxCutFront&&newTop.charCodeAt(cutFront)==oldTop.charCodeAt(cutFront)){++cutFront}
var newBot=lst(newText),oldBot=lst(oldText);var maxCutEnd=Math.min(newBot.length-(newText.length==1?cutFront:0),oldBot.length-(oldText.length==1?cutFront:0));while(cutEnd<maxCutEnd&&newBot.charCodeAt(newBot.length-cutEnd-1)==oldBot.charCodeAt(oldBot.length-cutEnd-1)){++cutEnd}
if(newText.length==1&&oldText.length==1&&fromLine==from.line){while(cutFront&&cutFront>from.ch&&newBot.charCodeAt(newBot.length-cutEnd-1)==oldBot.charCodeAt(oldBot.length-cutEnd-1)){cutFront--;cutEnd++}}
newText[newText.length-1]=newBot.slice(0,newBot.length-cutEnd).replace(/^\u200b+/,"");newText[0]=newText[0].slice(cutFront).replace(/\u200b+$/,"");var chFrom=Pos(fromLine,cutFront);var chTo=Pos(toLine,oldText.length?lst(oldText).length-cutEnd:0);if(newText.length>1||newText[0]||cmp(chFrom,chTo)){replaceRange(cm.doc,newText,chFrom,chTo,"+input");return!0}};ContentEditableInput.prototype.ensurePolled=function(){this.forceCompositionEnd()};ContentEditableInput.prototype.reset=function(){this.forceCompositionEnd()};ContentEditableInput.prototype.forceCompositionEnd=function(){if(!this.composing){return}
clearTimeout(this.readDOMTimeout);this.composing=null;this.updateFromDOM();this.div.blur();this.div.focus()};ContentEditableInput.prototype.readFromDOMSoon=function(){var this$1=this;if(this.readDOMTimeout!=null){return}
this.readDOMTimeout=setTimeout(function(){this$1.readDOMTimeout=null;if(this$1.composing){if(this$1.composing.done){this$1.composing=null}else{return}}
this$1.updateFromDOM()},80)};ContentEditableInput.prototype.updateFromDOM=function(){var this$1=this;if(this.cm.isReadOnly()||!this.pollContent()){runInOp(this.cm,function(){return regChange(this$1.cm)})}};ContentEditableInput.prototype.setUneditable=function(node){node.contentEditable="false"};ContentEditableInput.prototype.onKeyPress=function(e){if(e.charCode==0||this.composing){return}
e.preventDefault();if(!this.cm.isReadOnly()){operation(this.cm,applyTextInput)(this.cm,String.fromCharCode(e.charCode==null?e.keyCode:e.charCode),0)}};ContentEditableInput.prototype.readOnlyChanged=function(val){this.div.contentEditable=String(val!="nocursor")};ContentEditableInput.prototype.onContextMenu=function(){};ContentEditableInput.prototype.resetPosition=function(){};ContentEditableInput.prototype.needsContentAttribute=!0;function posToDOM(cm,pos){var view=findViewForLine(cm,pos.line);if(!view||view.hidden){return null}
var line=getLine(cm.doc,pos.line);var info=mapFromLineView(view,line,pos.line);var order=getOrder(line,cm.doc.direction),side="left";if(order){var partPos=getBidiPartAt(order,pos.ch);side=partPos%2?"right":"left"}
var result=nodeAndOffsetInLineMap(info.map,pos.ch,side);result.offset=result.collapse=="right"?result.end:result.start;return result}
function isInGutter(node){for(var scan=node;scan;scan=scan.parentNode){if(/CodeMirror-gutter-wrapper/.test(scan.className)){return!0}}
return!1}
function badPos(pos,bad){if(bad){pos.bad=!0}return pos}
function domTextBetween(cm,from,to,fromLine,toLine){var text="",closing=!1,lineSep=cm.doc.lineSeparator(),extraLinebreak=!1;function recognizeMarker(id){return function(marker){return marker.id==id}}
function close(){if(closing){text+=lineSep;if(extraLinebreak){text+=lineSep}
closing=extraLinebreak=!1}}
function addText(str){if(str){close();text+=str}}
function walk(node){if(node.nodeType==1){var cmText=node.getAttribute("cm-text");if(cmText){addText(cmText);return}
var markerID=node.getAttribute("cm-marker"),range;if(markerID){var found=cm.findMarks(Pos(fromLine,0),Pos(toLine+1,0),recognizeMarker(+markerID));if(found.length&&(range=found[0].find(0))){addText(getBetween(cm.doc,range.from,range.to).join(lineSep))}
return}
if(node.getAttribute("contenteditable")=="false"){return}
var isBlock=/^(pre|div|p|li|table|br)$/i.test(node.nodeName);if(!/^br$/i.test(node.nodeName)&&node.textContent.length==0){return}
if(isBlock){close()}
for(var i=0;i<node.childNodes.length;i++){walk(node.childNodes[i])}
if(/^(pre|p)$/i.test(node.nodeName)){extraLinebreak=!0}
if(isBlock){closing=!0}}else if(node.nodeType==3){addText(node.nodeValue.replace(/\u200b/g,"").replace(/\u00a0/g," "))}}
for(;;){walk(from);if(from==to){break}
from=from.nextSibling;extraLinebreak=!1}
return text}
function domToPos(cm,node,offset){var lineNode;if(node==cm.display.lineDiv){lineNode=cm.display.lineDiv.childNodes[offset];if(!lineNode){return badPos(cm.clipPos(Pos(cm.display.viewTo-1)),!0)}
node=null;offset=0}else{for(lineNode=node;;lineNode=lineNode.parentNode){if(!lineNode||lineNode==cm.display.lineDiv){return null}
if(lineNode.parentNode&&lineNode.parentNode==cm.display.lineDiv){break}}}
for(var i=0;i<cm.display.view.length;i++){var lineView=cm.display.view[i];if(lineView.node==lineNode){return locateNodeInLineView(lineView,node,offset)}}}
function locateNodeInLineView(lineView,node,offset){var wrapper=lineView.text.firstChild,bad=!1;if(!node||!contains(wrapper,node)){return badPos(Pos(lineNo(lineView.line),0),!0)}
if(node==wrapper){bad=!0;node=wrapper.childNodes[offset];offset=0;if(!node){var line=lineView.rest?lst(lineView.rest):lineView.line;return badPos(Pos(lineNo(line),line.text.length),bad)}}
var textNode=node.nodeType==3?node:null,topNode=node;if(!textNode&&node.childNodes.length==1&&node.firstChild.nodeType==3){textNode=node.firstChild;if(offset){offset=textNode.nodeValue.length}}
while(topNode.parentNode!=wrapper){topNode=topNode.parentNode}
var measure=lineView.measure,maps=measure.maps;function find(textNode,topNode,offset){for(var i=-1;i<(maps?maps.length:0);i++){var map=i<0?measure.map:maps[i];for(var j=0;j<map.length;j+=3){var curNode=map[j+2];if(curNode==textNode||curNode==topNode){var line=lineNo(i<0?lineView.line:lineView.rest[i]);var ch=map[j]+offset;if(offset<0||curNode!=textNode){ch=map[j+(offset?1:0)]}
return Pos(line,ch)}}}}
var found=find(textNode,topNode,offset);if(found){return badPos(found,bad)}
for(var after=topNode.nextSibling,dist=textNode?textNode.nodeValue.length-offset:0;after;after=after.nextSibling){found=find(after,after.firstChild,0);if(found){return badPos(Pos(found.line,found.ch-dist),bad)}else{dist+=after.textContent.length}}
for(var before=topNode.previousSibling,dist$1=offset;before;before=before.previousSibling){found=find(before,before.firstChild,-1);if(found){return badPos(Pos(found.line,found.ch+dist$1),bad)}else{dist$1+=before.textContent.length}}}
var TextareaInput=function(cm){this.cm=cm;this.prevInput="";this.pollingFast=!1;this.polling=new Delayed();this.hasSelection=!1;this.composing=null;this.resetting=!1};TextareaInput.prototype.init=function(display){var this$1=this;var input=this,cm=this.cm;this.createField(display);var te=this.textarea;display.wrapper.insertBefore(this.wrapper,display.wrapper.firstChild);if(ios){te.style.width="0px"}
on(te,"input",function(){if(ie&&ie_version>=9&&this$1.hasSelection){this$1.hasSelection=null}
input.poll()});on(te,"paste",function(e){if(signalDOMEvent(cm,e)||handlePaste(e,cm)){return}
cm.state.pasteIncoming=+new Date;input.fastPoll()});function prepareCopyCut(e){if(signalDOMEvent(cm,e)){return}
if(cm.somethingSelected()){setLastCopied({lineWise:!1,text:cm.getSelections()})}else if(!cm.options.lineWiseCopyCut){return}else{var ranges=copyableRanges(cm);setLastCopied({lineWise:!0,text:ranges.text});if(e.type=="cut"){cm.setSelections(ranges.ranges,null,sel_dontScroll)}else{input.prevInput="";te.value=ranges.text.join("\n");selectInput(te)}}
if(e.type=="cut"){cm.state.cutIncoming=+new Date}}
on(te,"cut",prepareCopyCut);on(te,"copy",prepareCopyCut);on(display.scroller,"paste",function(e){if(eventInWidget(display,e)||signalDOMEvent(cm,e)){return}
if(!te.dispatchEvent){cm.state.pasteIncoming=+new Date;input.focus();return}
var event=new Event("paste");event.clipboardData=e.clipboardData;te.dispatchEvent(event)});on(display.lineSpace,"selectstart",function(e){if(!eventInWidget(display,e)){e_preventDefault(e)}});on(te,"compositionstart",function(){var start=cm.getCursor("from");if(input.composing){input.composing.range.clear()}
input.composing={start:start,range:cm.markText(start,cm.getCursor("to"),{className:"CodeMirror-composing"})}});on(te,"compositionend",function(){if(input.composing){input.poll();input.composing.range.clear();input.composing=null}})};TextareaInput.prototype.createField=function(_display){this.wrapper=hiddenTextarea();this.textarea=this.wrapper.firstChild;var opts=this.cm.options;disableBrowserMagic(this.textarea,opts.spellcheck,opts.autocorrect,opts.autocapitalize)};TextareaInput.prototype.screenReaderLabelChanged=function(label){if(label){this.textarea.setAttribute('aria-label',label)}else{this.textarea.removeAttribute('aria-label')}};TextareaInput.prototype.prepareSelection=function(){var cm=this.cm,display=cm.display,doc=cm.doc;var result=prepareSelection(cm);if(cm.options.moveInputWithCursor){var headPos=cursorCoords(cm,doc.sel.primary().head,"div");var wrapOff=display.wrapper.getBoundingClientRect(),lineOff=display.lineDiv.getBoundingClientRect();result.teTop=Math.max(0,Math.min(display.wrapper.clientHeight-10,headPos.top+lineOff.top-wrapOff.top));result.teLeft=Math.max(0,Math.min(display.wrapper.clientWidth-10,headPos.left+lineOff.left-wrapOff.left))}
return result};TextareaInput.prototype.showSelection=function(drawn){var cm=this.cm,display=cm.display;removeChildrenAndAdd(display.cursorDiv,drawn.cursors);removeChildrenAndAdd(display.selectionDiv,drawn.selection);if(drawn.teTop!=null){this.wrapper.style.top=drawn.teTop+"px";this.wrapper.style.left=drawn.teLeft+"px"}};TextareaInput.prototype.reset=function(typing){if(this.contextMenuPending||this.composing&&typing){return}
var cm=this.cm;this.resetting=!0;if(cm.somethingSelected()){this.prevInput="";var content=cm.getSelection();this.textarea.value=content;if(cm.state.focused){selectInput(this.textarea)}
if(ie&&ie_version>=9){this.hasSelection=content}}else if(!typing){this.prevInput=this.textarea.value="";if(ie&&ie_version>=9){this.hasSelection=null}}
this.resetting=!1};TextareaInput.prototype.getField=function(){return this.textarea};TextareaInput.prototype.supportsTouch=function(){return!1};TextareaInput.prototype.focus=function(){if(this.cm.options.readOnly!="nocursor"&&(!mobile||activeElt(rootNode(this.textarea))!=this.textarea)){try{this.textarea.focus()}catch(e){}}};TextareaInput.prototype.blur=function(){this.textarea.blur()};TextareaInput.prototype.resetPosition=function(){this.wrapper.style.top=this.wrapper.style.left=0};TextareaInput.prototype.receivedFocus=function(){this.slowPoll()};TextareaInput.prototype.slowPoll=function(){var this$1=this;if(this.pollingFast){return}
this.polling.set(this.cm.options.pollInterval,function(){this$1.poll();if(this$1.cm.state.focused){this$1.slowPoll()}})};TextareaInput.prototype.fastPoll=function(){var missed=!1,input=this;input.pollingFast=!0;function p(){var changed=input.poll();if(!changed&&!missed){missed=!0;input.polling.set(60,p)}else{input.pollingFast=!1;input.slowPoll()}}
input.polling.set(20,p)};TextareaInput.prototype.poll=function(){var this$1=this;var cm=this.cm,input=this.textarea,prevInput=this.prevInput;if(this.contextMenuPending||this.resetting||!cm.state.focused||(hasSelection(input)&&!prevInput&&!this.composing)||cm.isReadOnly()||cm.options.disableInput||cm.state.keySeq){return!1}
var text=input.value;if(text==prevInput&&!cm.somethingSelected()){return!1}
if(ie&&ie_version>=9&&this.hasSelection===text||mac&&/[\uf700-\uf7ff]/.test(text)){cm.display.input.reset();return!1}
if(cm.doc.sel==cm.display.selForContextMenu){var first=text.charCodeAt(0);if(first==0x200b&&!prevInput){prevInput="\u200b"}
if(first==0x21da){this.reset();return this.cm.execCommand("undo")}}
var same=0,l=Math.min(prevInput.length,text.length);while(same<l&&prevInput.charCodeAt(same)==text.charCodeAt(same)){++same}
runInOp(cm,function(){applyTextInput(cm,text.slice(same),prevInput.length-same,null,this$1.composing?"*compose":null);if(text.length>1000||text.indexOf("\n")>-1){input.value=this$1.prevInput=""}else{this$1.prevInput=text}
if(this$1.composing){this$1.composing.range.clear();this$1.composing.range=cm.markText(this$1.composing.start,cm.getCursor("to"),{className:"CodeMirror-composing"})}});return!0};TextareaInput.prototype.ensurePolled=function(){if(this.pollingFast&&this.poll()){this.pollingFast=!1}};TextareaInput.prototype.onKeyPress=function(){if(ie&&ie_version>=9){this.hasSelection=null}
this.fastPoll()};TextareaInput.prototype.onContextMenu=function(e){var input=this,cm=input.cm,display=cm.display,te=input.textarea;if(input.contextMenuPending){input.contextMenuPending()}
var pos=posFromMouse(cm,e),scrollPos=display.scroller.scrollTop;if(!pos||presto){return}
var reset=cm.options.resetSelectionOnContextMenu;if(reset&&cm.doc.sel.contains(pos)==-1){operation(cm,setSelection)(cm.doc,simpleSelection(pos),sel_dontScroll)}
var oldCSS=te.style.cssText,oldWrapperCSS=input.wrapper.style.cssText;var wrapperBox=input.wrapper.offsetParent.getBoundingClientRect();input.wrapper.style.cssText="position: static";te.style.cssText="position: absolute; width: 30px; height: 30px;\n      top: "+(e.clientY-wrapperBox.top-5)+"px; left: "+(e.clientX-wrapperBox.left-5)+"px;\n      z-index: 1000; background: "+(ie?"rgba(255, 255, 255, .05)":"transparent")+";\n      outline: none; border-width: 0; outline: none; overflow: hidden; opacity: .05; filter: alpha(opacity=5);";var oldScrollY;if(webkit){oldScrollY=te.ownerDocument.defaultView.scrollY}
display.input.focus();if(webkit){te.ownerDocument.defaultView.scrollTo(null,oldScrollY)}
display.input.reset();if(!cm.somethingSelected()){te.value=input.prevInput=" "}
input.contextMenuPending=rehide;display.selForContextMenu=cm.doc.sel;clearTimeout(display.detectingSelectAll);function prepareSelectAllHack(){if(te.selectionStart!=null){var selected=cm.somethingSelected();var extval="\u200b"+(selected?te.value:"");te.value="\u21da";te.value=extval;input.prevInput=selected?"":"\u200b";te.selectionStart=1;te.selectionEnd=extval.length;display.selForContextMenu=cm.doc.sel}}
function rehide(){if(input.contextMenuPending!=rehide){return}
input.contextMenuPending=!1;input.wrapper.style.cssText=oldWrapperCSS;te.style.cssText=oldCSS;if(ie&&ie_version<9){display.scrollbars.setScrollTop(display.scroller.scrollTop=scrollPos)}
if(te.selectionStart!=null){if(!ie||(ie&&ie_version<9)){prepareSelectAllHack()}
var i=0,poll=function(){if(display.selForContextMenu==cm.doc.sel&&te.selectionStart==0&&te.selectionEnd>0&&input.prevInput=="\u200b"){operation(cm,selectAll)(cm)}else if(i++<10){display.detectingSelectAll=setTimeout(poll,500)}else{display.selForContextMenu=null;display.input.reset()}};display.detectingSelectAll=setTimeout(poll,200)}}
if(ie&&ie_version>=9){prepareSelectAllHack()}
if(captureRightClick){e_stop(e);var mouseup=function(){off(window,"mouseup",mouseup);setTimeout(rehide,20)};on(window,"mouseup",mouseup)}else{setTimeout(rehide,50)}};TextareaInput.prototype.readOnlyChanged=function(val){if(!val){this.reset()}
this.textarea.disabled=val=="nocursor";this.textarea.readOnly=!!val};TextareaInput.prototype.setUneditable=function(){};TextareaInput.prototype.needsContentAttribute=!1;function fromTextArea(textarea,options){options=options?copyObj(options):{};options.value=textarea.value;if(!options.tabindex&&textarea.tabIndex){options.tabindex=textarea.tabIndex}
if(!options.placeholder&&textarea.placeholder){options.placeholder=textarea.placeholder}
if(options.autofocus==null){var hasFocus=activeElt(rootNode(textarea));options.autofocus=hasFocus==textarea||textarea.getAttribute("autofocus")!=null&&hasFocus==document.body}
function save(){textarea.value=cm.getValue()}
var realSubmit;if(textarea.form){on(textarea.form,"submit",save);if(!options.leaveSubmitMethodAlone){var form=textarea.form;realSubmit=form.submit;try{var wrappedSubmit=form.submit=function(){save();form.submit=realSubmit;form.submit();form.submit=wrappedSubmit}}catch(e){}}}
options.finishInit=function(cm){cm.save=save;cm.getTextArea=function(){return textarea};cm.toTextArea=function(){cm.toTextArea=isNaN;save();textarea.parentNode.removeChild(cm.getWrapperElement());textarea.style.display="";if(textarea.form){off(textarea.form,"submit",save);if(!options.leaveSubmitMethodAlone&&typeof textarea.form.submit=="function"){textarea.form.submit=realSubmit}}}};textarea.style.display="none";var cm=CodeMirror(function(node){return textarea.parentNode.insertBefore(node,textarea.nextSibling)},options);return cm}
function addLegacyProps(CodeMirror){CodeMirror.off=off;CodeMirror.on=on;CodeMirror.wheelEventPixels=wheelEventPixels;CodeMirror.Doc=Doc;CodeMirror.splitLines=splitLinesAuto;CodeMirror.countColumn=countColumn;CodeMirror.findColumn=findColumn;CodeMirror.isWordChar=isWordCharBasic;CodeMirror.Pass=Pass;CodeMirror.signal=signal;CodeMirror.Line=Line;CodeMirror.changeEnd=changeEnd;CodeMirror.scrollbarModel=scrollbarModel;CodeMirror.Pos=Pos;CodeMirror.cmpPos=cmp;CodeMirror.modes=modes;CodeMirror.mimeModes=mimeModes;CodeMirror.resolveMode=resolveMode;CodeMirror.getMode=getMode;CodeMirror.modeExtensions=modeExtensions;CodeMirror.extendMode=extendMode;CodeMirror.copyState=copyState;CodeMirror.startState=startState;CodeMirror.innerMode=innerMode;CodeMirror.commands=commands;CodeMirror.keyMap=keyMap;CodeMirror.keyName=keyName;CodeMirror.isModifierKey=isModifierKey;CodeMirror.lookupKey=lookupKey;CodeMirror.normalizeKeyMap=normalizeKeyMap;CodeMirror.StringStream=StringStream;CodeMirror.SharedTextMarker=SharedTextMarker;CodeMirror.TextMarker=TextMarker;CodeMirror.LineWidget=LineWidget;CodeMirror.e_preventDefault=e_preventDefault;CodeMirror.e_stopPropagation=e_stopPropagation;CodeMirror.e_stop=e_stop;CodeMirror.addClass=addClass;CodeMirror.contains=contains;CodeMirror.rmClass=rmClass;CodeMirror.keyNames=keyNames}
defineOptions(CodeMirror);addEditorMethods(CodeMirror);var dontDelegate="iter insert remove copy getEditor constructor".split(" ");for(var prop in Doc.prototype){if(Doc.prototype.hasOwnProperty(prop)&&indexOf(dontDelegate,prop)<0){CodeMirror.prototype[prop]=(function(method){return function(){return method.apply(this.doc,arguments)}})(Doc.prototype[prop])}}
eventMixin(Doc);CodeMirror.inputStyles={"textarea":TextareaInput,"contenteditable":ContentEditableInput};CodeMirror.defineMode=function(name){if(!CodeMirror.defaults.mode&&name!="null"){CodeMirror.defaults.mode=name}
defineMode.apply(this,arguments)};CodeMirror.defineMIME=defineMIME;CodeMirror.defineMode("null",function(){return({token:function(stream){return stream.skipToEnd()}})});CodeMirror.defineMIME("text/plain","null");CodeMirror.defineExtension=function(name,func){CodeMirror.prototype[name]=func};CodeMirror.defineDocExtension=function(name,func){Doc.prototype[name]=func};CodeMirror.fromTextArea=fromTextArea;addLegacyProps(CodeMirror);CodeMirror.version="5.65.18";return CodeMirror})));(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var HINT_ELEMENT_CLASS="CodeMirror-hint";var ACTIVE_HINT_ELEMENT_CLASS="CodeMirror-hint-active";CodeMirror.showHint=function(cm,getHints,options){if(!getHints)return cm.showHint(options);if(options&&options.async)getHints.async=!0;var newOpts={hint:getHints};if(options)for(var prop in options)newOpts[prop]=options[prop];return cm.showHint(newOpts)};CodeMirror.defineExtension("showHint",function(options){options=parseOptions(this,this.getCursor("start"),options);var selections=this.listSelections()
if(selections.length>1)return;if(this.somethingSelected()){if(!options.hint.supportsSelection)return;for(var i=0;i<selections.length;i++)
if(selections[i].head.line!=selections[i].anchor.line)return}
if(this.state.completionActive)this.state.completionActive.close();var completion=this.state.completionActive=new Completion(this,options);if(!completion.options.hint)return;CodeMirror.signal(this,"startCompletion",this);completion.update(!0)});CodeMirror.defineExtension("closeHint",function(){if(this.state.completionActive)this.state.completionActive.close()})
function Completion(cm,options){this.cm=cm;this.options=options;this.widget=null;this.debounce=0;this.tick=0;this.startPos=this.cm.getCursor("start");this.startLen=this.cm.getLine(this.startPos.line).length-this.cm.getSelection().length;if(this.options.updateOnCursorActivity){var self=this;cm.on("cursorActivity",this.activityFunc=function(){self.cursorActivity()})}}
var requestAnimationFrame=window.requestAnimationFrame||function(fn){return setTimeout(fn,1000/60)};var cancelAnimationFrame=window.cancelAnimationFrame||clearTimeout;Completion.prototype={close:function(){if(!this.active())return;this.cm.state.completionActive=null;this.tick=null;if(this.options.updateOnCursorActivity){this.cm.off("cursorActivity",this.activityFunc)}
if(this.widget&&this.data)CodeMirror.signal(this.data,"close");if(this.widget)this.widget.close();CodeMirror.signal(this.cm,"endCompletion",this.cm)},active:function(){return this.cm.state.completionActive==this},pick:function(data,i){var completion=data.list[i],self=this;this.cm.operation(function(){if(completion.hint)
completion.hint(self.cm,data,completion);else self.cm.replaceRange(getText(completion),completion.from||data.from,completion.to||data.to,"complete");CodeMirror.signal(data,"pick",completion);self.cm.scrollIntoView()});if(this.options.closeOnPick){this.close()}},cursorActivity:function(){if(this.debounce){cancelAnimationFrame(this.debounce);this.debounce=0}
var identStart=this.startPos;if(this.data){identStart=this.data.from}
var pos=this.cm.getCursor(),line=this.cm.getLine(pos.line);if(pos.line!=this.startPos.line||line.length-pos.ch!=this.startLen-this.startPos.ch||pos.ch<identStart.ch||this.cm.somethingSelected()||(!pos.ch||this.options.closeCharacters.test(line.charAt(pos.ch-1)))){this.close()}else{var self=this;this.debounce=requestAnimationFrame(function(){self.update()});if(this.widget)this.widget.disable();}},update:function(first){if(this.tick==null)return
var self=this,myTick=++this.tick
fetchHints(this.options.hint,this.cm,this.options,function(data){if(self.tick==myTick)self.finishUpdate(data,first)})},finishUpdate:function(data,first){if(this.data)CodeMirror.signal(this.data,"update");var picked=(this.widget&&this.widget.picked)||(first&&this.options.completeSingle);if(this.widget)this.widget.close();this.data=data;if(data&&data.list.length){if(picked&&data.list.length==1){this.pick(data,0)}else{this.widget=new Widget(this,data);CodeMirror.signal(data,"shown")}}}};function parseOptions(cm,pos,options){var editor=cm.options.hintOptions;var out={};for(var prop in defaultOptions)out[prop]=defaultOptions[prop];if(editor)for(var prop in editor)
if(editor[prop]!==undefined)out[prop]=editor[prop];if(options)for(var prop in options)
if(options[prop]!==undefined)out[prop]=options[prop];if(out.hint.resolve)out.hint=out.hint.resolve(cm,pos)
return out}
function getText(completion){if(typeof completion=="string")return completion;else return completion.text}
function buildKeyMap(completion,handle){var baseMap={Up:function(){handle.moveFocus(-1)},Down:function(){handle.moveFocus(1)},PageUp:function(){handle.moveFocus(-handle.menuSize()+1,!0)},PageDown:function(){handle.moveFocus(handle.menuSize()-1,!0)},Home:function(){handle.setFocus(0)},End:function(){handle.setFocus(handle.length-1)},Enter:handle.pick,Tab:handle.pick,Esc:handle.close};var mac=/Mac/.test(navigator.platform);if(mac){baseMap["Ctrl-P"]=function(){handle.moveFocus(-1)};baseMap["Ctrl-N"]=function(){handle.moveFocus(1)}}
var custom=completion.options.customKeys;var ourMap=custom?{}:baseMap;function addBinding(key,val){var bound;if(typeof val!="string")
bound=function(cm){return val(cm,handle)};else if(baseMap.hasOwnProperty(val))
bound=baseMap[val];else bound=val;ourMap[key]=bound}
if(custom)
for(var key in custom)if(custom.hasOwnProperty(key))
addBinding(key,custom[key]);var extra=completion.options.extraKeys;if(extra)
for(var key in extra)if(extra.hasOwnProperty(key))
addBinding(key,extra[key]);return ourMap}
function getHintElement(hintsElement,el){while(el&&el!=hintsElement){if(el.nodeName.toUpperCase()==="LI"&&el.parentNode==hintsElement)return el;el=el.parentNode}}
function Widget(completion,data){this.id="cm-complete-"+Math.floor(Math.random(1e6))
this.completion=completion;this.data=data;this.picked=!1;var widget=this,cm=completion.cm;var ownerDocument=cm.getInputField().ownerDocument;var parentWindow=ownerDocument.defaultView||ownerDocument.parentWindow;var hints=this.hints=ownerDocument.createElement("ul");hints.setAttribute("role","listbox")
hints.setAttribute("aria-expanded","true")
hints.id=this.id
var theme=completion.cm.options.theme;hints.className="CodeMirror-hints "+theme;this.selectedHint=data.selectedHint||0;var completions=data.list;for(var i=0;i<completions.length;++i){var elt=hints.appendChild(ownerDocument.createElement("li")),cur=completions[i];var className=HINT_ELEMENT_CLASS+(i!=this.selectedHint?"":" "+ACTIVE_HINT_ELEMENT_CLASS);if(cur.className!=null)className=cur.className+" "+className;elt.className=className;if(i==this.selectedHint)elt.setAttribute("aria-selected","true")
elt.id=this.id+"-"+i
elt.setAttribute("role","option")
if(cur.render)cur.render(elt,data,cur);else elt.appendChild(ownerDocument.createTextNode(cur.displayText||getText(cur)));elt.hintId=i}
var container=completion.options.container||ownerDocument.body;var pos=cm.cursorCoords(completion.options.alignWithWord?data.from:null);var left=pos.left,top=pos.bottom,below=!0;var offsetLeft=0,offsetTop=0;if(container!==ownerDocument.body){var isContainerPositioned=['absolute','relative','fixed'].indexOf(parentWindow.getComputedStyle(container).position)!==-1;var offsetParent=isContainerPositioned?container:container.offsetParent;var offsetParentPosition=offsetParent.getBoundingClientRect();var bodyPosition=ownerDocument.body.getBoundingClientRect();offsetLeft=(offsetParentPosition.left-bodyPosition.left-offsetParent.scrollLeft);offsetTop=(offsetParentPosition.top-bodyPosition.top-offsetParent.scrollTop)}
hints.style.left=(left-offsetLeft)+"px";hints.style.top=(top-offsetTop)+"px";var winW=parentWindow.innerWidth||Math.max(ownerDocument.body.offsetWidth,ownerDocument.documentElement.offsetWidth);var winH=parentWindow.innerHeight||Math.max(ownerDocument.body.offsetHeight,ownerDocument.documentElement.offsetHeight);container.appendChild(hints);cm.getInputField().setAttribute("aria-autocomplete","list")
cm.getInputField().setAttribute("aria-owns",this.id)
cm.getInputField().setAttribute("aria-activedescendant",this.id+"-"+this.selectedHint)
var box=completion.options.moveOnOverlap?hints.getBoundingClientRect():new DOMRect();var scrolls=completion.options.paddingForScrollbar?hints.scrollHeight>hints.clientHeight+1:!1;var startScroll;setTimeout(function(){startScroll=cm.getScrollInfo()});var overlapY=box.bottom-winH;if(overlapY>0){var height=box.bottom-box.top,spaceAbove=box.top-(pos.bottom-pos.top)-2
if(winH-box.top<spaceAbove){if(height>spaceAbove)hints.style.height=(height=spaceAbove)+"px";hints.style.top=((top=pos.top-height)+offsetTop)+"px";below=!1}else{hints.style.height=(winH-box.top-2)+"px"}}
var overlapX=box.right-winW;if(scrolls)overlapX+=cm.display.nativeBarWidth;if(overlapX>0){if(box.right-box.left>winW){hints.style.width=(winW-5)+"px";overlapX-=(box.right-box.left)-winW}
hints.style.left=(left=Math.max(pos.left-overlapX-offsetLeft,0))+"px"}
if(scrolls)for(var node=hints.firstChild;node;node=node.nextSibling)
node.style.paddingRight=cm.display.nativeBarWidth+"px"
cm.addKeyMap(this.keyMap=buildKeyMap(completion,{moveFocus:function(n,avoidWrap){widget.changeActive(widget.selectedHint+n,avoidWrap)},setFocus:function(n){widget.changeActive(n)},menuSize:function(){return widget.screenAmount()},length:completions.length,close:function(){completion.close()},pick:function(){widget.pick()},data:data}));if(completion.options.closeOnUnfocus){var closingOnBlur;cm.on("blur",this.onBlur=function(){closingOnBlur=setTimeout(function(){completion.close()},100)});cm.on("focus",this.onFocus=function(){clearTimeout(closingOnBlur)})}
cm.on("scroll",this.onScroll=function(){var curScroll=cm.getScrollInfo(),editor=cm.getWrapperElement().getBoundingClientRect();if(!startScroll)startScroll=cm.getScrollInfo();var newTop=top+startScroll.top-curScroll.top;var point=newTop-(parentWindow.pageYOffset||(ownerDocument.documentElement||ownerDocument.body).scrollTop);if(!below)point+=hints.offsetHeight;if(point<=editor.top||point>=editor.bottom)return completion.close();hints.style.top=newTop+"px";hints.style.left=(left+startScroll.left-curScroll.left)+"px"});CodeMirror.on(hints,"dblclick",function(e){var t=getHintElement(hints,e.target||e.srcElement);if(t&&t.hintId!=null){widget.changeActive(t.hintId);widget.pick()}});CodeMirror.on(hints,"click",function(e){var t=getHintElement(hints,e.target||e.srcElement);if(t&&t.hintId!=null){widget.changeActive(t.hintId);if(completion.options.completeOnSingleClick)widget.pick();}});CodeMirror.on(hints,"mousedown",function(){setTimeout(function(){cm.focus()},20)});var selectedHintRange=this.getSelectedHintRange();if(selectedHintRange.from!==0||selectedHintRange.to!==0){this.scrollToActive()}
CodeMirror.signal(data,"select",completions[this.selectedHint],hints.childNodes[this.selectedHint]);return!0}
Widget.prototype={close:function(){if(this.completion.widget!=this)return;this.completion.widget=null;if(this.hints.parentNode)this.hints.parentNode.removeChild(this.hints);this.completion.cm.removeKeyMap(this.keyMap);var input=this.completion.cm.getInputField()
input.removeAttribute("aria-activedescendant")
input.removeAttribute("aria-owns")
var cm=this.completion.cm;if(this.completion.options.closeOnUnfocus){cm.off("blur",this.onBlur);cm.off("focus",this.onFocus)}
cm.off("scroll",this.onScroll)},disable:function(){this.completion.cm.removeKeyMap(this.keyMap);var widget=this;this.keyMap={Enter:function(){widget.picked=!0}};this.completion.cm.addKeyMap(this.keyMap)},pick:function(){this.completion.pick(this.data,this.selectedHint)},changeActive:function(i,avoidWrap){if(i>=this.data.list.length)
i=avoidWrap?this.data.list.length-1:0;else if(i<0)
i=avoidWrap?0:this.data.list.length-1;if(this.selectedHint==i)return;var node=this.hints.childNodes[this.selectedHint];if(node){node.className=node.className.replace(" "+ACTIVE_HINT_ELEMENT_CLASS,"");node.removeAttribute("aria-selected")}
node=this.hints.childNodes[this.selectedHint=i];node.className+=" "+ACTIVE_HINT_ELEMENT_CLASS;node.setAttribute("aria-selected","true")
this.completion.cm.getInputField().setAttribute("aria-activedescendant",node.id)
this.scrollToActive()
CodeMirror.signal(this.data,"select",this.data.list[this.selectedHint],node)},scrollToActive:function(){var selectedHintRange=this.getSelectedHintRange();var node1=this.hints.childNodes[selectedHintRange.from];var node2=this.hints.childNodes[selectedHintRange.to];var firstNode=this.hints.firstChild;if(node1.offsetTop<this.hints.scrollTop)
this.hints.scrollTop=node1.offsetTop-firstNode.offsetTop;else if(node2.offsetTop+node2.offsetHeight>this.hints.scrollTop+this.hints.clientHeight)
this.hints.scrollTop=node2.offsetTop+node2.offsetHeight-this.hints.clientHeight+firstNode.offsetTop},screenAmount:function(){return Math.floor(this.hints.clientHeight/this.hints.firstChild.offsetHeight)||1},getSelectedHintRange:function(){var margin=this.completion.options.scrollMargin||0;return{from:Math.max(0,this.selectedHint-margin),to:Math.min(this.data.list.length-1,this.selectedHint+margin),}}};function applicableHelpers(cm,helpers){if(!cm.somethingSelected())return helpers
var result=[]
for(var i=0;i<helpers.length;i++)
if(helpers[i].supportsSelection)result.push(helpers[i])
return result}
function fetchHints(hint,cm,options,callback){if(hint.async){hint(cm,callback,options)}else{var result=hint(cm,options)
if(result&&result.then)result.then(callback)
else callback(result)}}
function resolveAutoHints(cm,pos){var helpers=cm.getHelpers(pos,"hint"),words
if(helpers.length){var resolved=function(cm,callback,options){var app=applicableHelpers(cm,helpers);function run(i){if(i==app.length)return callback(null)
fetchHints(app[i],cm,options,function(result){if(result&&result.list.length>0)callback(result)
else run(i+1)})}
run(0)}
resolved.async=!0
resolved.supportsSelection=!0
return resolved}else if(words=cm.getHelper(cm.getCursor(),"hintWords")){return function(cm){return CodeMirror.hint.fromList(cm,{words:words})}}else if(CodeMirror.hint.anyword){return function(cm,options){return CodeMirror.hint.anyword(cm,options)}}else{return function(){}}}
CodeMirror.registerHelper("hint","auto",{resolve:resolveAutoHints});CodeMirror.registerHelper("hint","fromList",function(cm,options){var cur=cm.getCursor(),token=cm.getTokenAt(cur)
var term,from=CodeMirror.Pos(cur.line,token.start),to=cur
if(token.start<cur.ch&&/\w/.test(token.string.charAt(cur.ch-token.start-1))){term=token.string.substr(0,cur.ch-token.start)}else{term=""
from=cur}
var found=[];for(var i=0;i<options.words.length;i++){var word=options.words[i];if(word.slice(0,term.length)==term)
found.push(word);}
if(found.length)return{list:found,from:from,to:to}});CodeMirror.commands.autocomplete=CodeMirror.showHint;var defaultOptions={hint:CodeMirror.hint.auto,completeSingle:!0,alignWithWord:!0,closeCharacters:/[\s()\[\]{};:>,]/,closeOnPick:!0,closeOnUnfocus:!0,updateOnCursorActivity:!0,completeOnSingleClick:!0,container:null,customKeys:null,extraKeys:null,paddingForScrollbar:!0,moveOnOverlap:!0,};CodeMirror.defineOption("hintOptions",null)});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var htmlConfig={autoSelfClosers:{'area':!0,'base':!0,'br':!0,'col':!0,'command':!0,'embed':!0,'frame':!0,'hr':!0,'img':!0,'input':!0,'keygen':!0,'link':!0,'meta':!0,'param':!0,'source':!0,'track':!0,'wbr':!0,'menuitem':!0},implicitlyClosed:{'dd':!0,'li':!0,'optgroup':!0,'option':!0,'p':!0,'rp':!0,'rt':!0,'tbody':!0,'td':!0,'tfoot':!0,'th':!0,'tr':!0},contextGrabbers:{'dd':{'dd':!0,'dt':!0},'dt':{'dd':!0,'dt':!0},'li':{'li':!0},'option':{'option':!0,'optgroup':!0},'optgroup':{'optgroup':!0},'p':{'address':!0,'article':!0,'aside':!0,'blockquote':!0,'dir':!0,'div':!0,'dl':!0,'fieldset':!0,'footer':!0,'form':!0,'h1':!0,'h2':!0,'h3':!0,'h4':!0,'h5':!0,'h6':!0,'header':!0,'hgroup':!0,'hr':!0,'menu':!0,'nav':!0,'ol':!0,'p':!0,'pre':!0,'section':!0,'table':!0,'ul':!0},'rp':{'rp':!0,'rt':!0},'rt':{'rp':!0,'rt':!0},'tbody':{'tbody':!0,'tfoot':!0},'td':{'td':!0,'th':!0},'tfoot':{'tbody':!0},'th':{'td':!0,'th':!0},'thead':{'tbody':!0,'tfoot':!0},'tr':{'tr':!0}},doNotIndent:{"pre":!0},allowUnquoted:!0,allowMissing:!0,caseFold:!0}
var xmlConfig={autoSelfClosers:{},implicitlyClosed:{},contextGrabbers:{},doNotIndent:{},allowUnquoted:!1,allowMissing:!1,allowMissingTagName:!1,caseFold:!1}
CodeMirror.defineMode("xml",function(editorConf,config_){var indentUnit=editorConf.indentUnit
var config={}
var defaults=config_.htmlMode?htmlConfig:xmlConfig
for(var prop in defaults)config[prop]=defaults[prop]
for(var prop in config_)config[prop]=config_[prop]
var type,setStyle;function inText(stream,state){function chain(parser){state.tokenize=parser;return parser(stream,state)}
var ch=stream.next();if(ch=="<"){if(stream.eat("!")){if(stream.eat("[")){if(stream.match("CDATA["))return chain(inBlock("atom","]]>"));else return null}else if(stream.match("--")){return chain(inBlock("comment","-->"))}else if(stream.match("DOCTYPE",!0,!0)){stream.eatWhile(/[\w\._\-]/);return chain(doctype(1))}else{return null}}else if(stream.eat("?")){stream.eatWhile(/[\w\._\-]/);state.tokenize=inBlock("meta","?>");return"meta"}else{type=stream.eat("/")?"closeTag":"openTag";state.tokenize=inTag;return"tag bracket"}}else if(ch=="&"){var ok;if(stream.eat("#")){if(stream.eat("x")){ok=stream.eatWhile(/[a-fA-F\d]/)&&stream.eat(";")}else{ok=stream.eatWhile(/[\d]/)&&stream.eat(";")}}else{ok=stream.eatWhile(/[\w\.\-:]/)&&stream.eat(";")}
return ok?"atom":"error"}else{stream.eatWhile(/[^&<]/);return null}}
inText.isInText=!0;function inTag(stream,state){var ch=stream.next();if(ch==">"||(ch=="/"&&stream.eat(">"))){state.tokenize=inText;type=ch==">"?"endTag":"selfcloseTag";return"tag bracket"}else if(ch=="="){type="equals";return null}else if(ch=="<"){state.tokenize=inText;state.state=baseState;state.tagName=state.tagStart=null;var next=state.tokenize(stream,state);return next?next+" tag error":"tag error"}else if(/[\'\"]/.test(ch)){state.tokenize=inAttribute(ch);state.stringStartCol=stream.column();return state.tokenize(stream,state)}else{stream.match(/^[^\s\u00a0=<>\"\']*[^\s\u00a0=<>\"\'\/]/);return"word"}}
function inAttribute(quote){var closure=function(stream,state){while(!stream.eol()){if(stream.next()==quote){state.tokenize=inTag;break}}
return"string"};closure.isInAttribute=!0;return closure}
function inBlock(style,terminator){return function(stream,state){while(!stream.eol()){if(stream.match(terminator)){state.tokenize=inText;break}
stream.next()}
return style}}
function doctype(depth){return function(stream,state){var ch;while((ch=stream.next())!=null){if(ch=="<"){state.tokenize=doctype(depth+1);return state.tokenize(stream,state)}else if(ch==">"){if(depth==1){state.tokenize=inText;break}else{state.tokenize=doctype(depth-1);return state.tokenize(stream,state)}}}
return"meta"}}
function lower(tagName){return tagName&&tagName.toLowerCase()}
function Context(state,tagName,startOfLine){this.prev=state.context;this.tagName=tagName||"";this.indent=state.indented;this.startOfLine=startOfLine;if(config.doNotIndent.hasOwnProperty(tagName)||(state.context&&state.context.noIndent))
this.noIndent=!0}
function popContext(state){if(state.context)state.context=state.context.prev}
function maybePopContext(state,nextTagName){var parentTagName;while(!0){if(!state.context){return}
parentTagName=state.context.tagName;if(!config.contextGrabbers.hasOwnProperty(lower(parentTagName))||!config.contextGrabbers[lower(parentTagName)].hasOwnProperty(lower(nextTagName))){return}
popContext(state)}}
function baseState(type,stream,state){if(type=="openTag"){state.tagStart=stream.column();return tagNameState}else if(type=="closeTag"){return closeTagNameState}else{return baseState}}
function tagNameState(type,stream,state){if(type=="word"){state.tagName=stream.current();setStyle="tag";return attrState}else if(config.allowMissingTagName&&type=="endTag"){setStyle="tag bracket";return attrState(type,stream,state)}else{setStyle="error";return tagNameState}}
function closeTagNameState(type,stream,state){if(type=="word"){var tagName=stream.current();if(state.context&&state.context.tagName!=tagName&&config.implicitlyClosed.hasOwnProperty(lower(state.context.tagName)))
popContext(state);if((state.context&&state.context.tagName==tagName)||config.matchClosing===!1){setStyle="tag";return closeState}else{setStyle="tag error";return closeStateErr}}else if(config.allowMissingTagName&&type=="endTag"){setStyle="tag bracket";return closeState(type,stream,state)}else{setStyle="error";return closeStateErr}}
function closeState(type,_stream,state){if(type!="endTag"){setStyle="error";return closeState}
popContext(state);return baseState}
function closeStateErr(type,stream,state){setStyle="error";return closeState(type,stream,state)}
function attrState(type,_stream,state){if(type=="word"){setStyle="attribute";return attrEqState}else if(type=="endTag"||type=="selfcloseTag"){var tagName=state.tagName,tagStart=state.tagStart;state.tagName=state.tagStart=null;if(type=="selfcloseTag"||config.autoSelfClosers.hasOwnProperty(lower(tagName))){maybePopContext(state,tagName)}else{maybePopContext(state,tagName);state.context=new Context(state,tagName,tagStart==state.indented)}
return baseState}
setStyle="error";return attrState}
function attrEqState(type,stream,state){if(type=="equals")return attrValueState;if(!config.allowMissing)setStyle="error";return attrState(type,stream,state)}
function attrValueState(type,stream,state){if(type=="string")return attrContinuedState;if(type=="word"&&config.allowUnquoted){setStyle="string";return attrState}
setStyle="error";return attrState(type,stream,state)}
function attrContinuedState(type,stream,state){if(type=="string")return attrContinuedState;return attrState(type,stream,state)}
return{startState:function(baseIndent){var state={tokenize:inText,state:baseState,indented:baseIndent||0,tagName:null,tagStart:null,context:null}
if(baseIndent!=null)state.baseIndent=baseIndent
return state},token:function(stream,state){if(!state.tagName&&stream.sol())
state.indented=stream.indentation();if(stream.eatSpace())return null;type=null;var style=state.tokenize(stream,state);if((style||type)&&style!="comment"){setStyle=null;state.state=state.state(type||style,stream,state);if(setStyle)
style=setStyle=="error"?style+" error":setStyle}
return style},indent:function(state,textAfter,fullLine){var context=state.context;if(state.tokenize.isInAttribute){if(state.tagStart==state.indented)
return state.stringStartCol+1;else return state.indented+indentUnit}
if(context&&context.noIndent)return CodeMirror.Pass;if(state.tokenize!=inTag&&state.tokenize!=inText)
return fullLine?fullLine.match(/^(\s*)/)[0].length:0;if(state.tagName){if(config.multilineTagIndentPastTag!==!1)
return state.tagStart+state.tagName.length+2;else return state.tagStart+indentUnit*(config.multilineTagIndentFactor||1)}
if(config.alignCDATA&&/<!\[CDATA\[/.test(textAfter))return 0;var tagAfter=textAfter&&/^<(\/)?([\w_:\.-]*)/.exec(textAfter);if(tagAfter&&tagAfter[1]){while(context){if(context.tagName==tagAfter[2]){context=context.prev;break}else if(config.implicitlyClosed.hasOwnProperty(lower(context.tagName))){context=context.prev}else{break}}}else if(tagAfter){while(context){var grabbers=config.contextGrabbers[lower(context.tagName)];if(grabbers&&grabbers.hasOwnProperty(lower(tagAfter[2])))
context=context.prev;else break}}
while(context&&context.prev&&!context.startOfLine)
context=context.prev;if(context)return context.indent+indentUnit;else return state.baseIndent||0},electricInput:/<\/[\s\w:]+>$/,blockCommentStart:"<!--",blockCommentEnd:"-->",configuration:config.htmlMode?"html":"xml",helperType:config.htmlMode?"html":"xml",skipAttribute:function(state){if(state.state==attrValueState)
state.state=attrState},xmlCurrentTag:function(state){return state.tagName?{name:state.tagName,close:state.type=="closeTag"}:null},xmlCurrentContext:function(state){var context=[]
for(var cx=state.context;cx;cx=cx.prev)
context.push(cx.tagName)
return context.reverse()}}});CodeMirror.defineMIME("text/xml","xml");CodeMirror.defineMIME("application/xml","xml");if(!CodeMirror.mimeModes.hasOwnProperty("text/html"))
CodeMirror.defineMIME("text/html",{name:"xml",htmlMode:!0})});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("javascript",function(config,parserConfig){var indentUnit=config.indentUnit;var statementIndent=parserConfig.statementIndent;var jsonldMode=parserConfig.jsonld;var jsonMode=parserConfig.json||jsonldMode;var trackScope=parserConfig.trackScope!==!1
var isTS=parserConfig.typescript;var wordRE=parserConfig.wordCharacters||/[\w$\xa1-\uffff]/;var keywords=function(){function kw(type){return{type:type,style:"keyword"}}
var A=kw("keyword a"),B=kw("keyword b"),C=kw("keyword c"),D=kw("keyword d");var operator=kw("operator"),atom={type:"atom",style:"atom"};return{"if":kw("if"),"while":A,"with":A,"else":B,"do":B,"try":B,"finally":B,"return":D,"break":D,"continue":D,"new":kw("new"),"delete":C,"void":C,"throw":C,"debugger":kw("debugger"),"var":kw("var"),"const":kw("var"),"let":kw("var"),"function":kw("function"),"catch":kw("catch"),"for":kw("for"),"switch":kw("switch"),"case":kw("case"),"default":kw("default"),"in":operator,"typeof":operator,"instanceof":operator,"true":atom,"false":atom,"null":atom,"undefined":atom,"NaN":atom,"Infinity":atom,"this":kw("this"),"class":kw("class"),"super":kw("atom"),"yield":C,"export":kw("export"),"import":kw("import"),"extends":C,"await":C}}();var isOperatorChar=/[+\-*&%=<>!?|~^@]/;var isJsonldKeyword=/^@(context|id|value|language|type|container|list|set|reverse|index|base|vocab|graph)"/;function readRegexp(stream){var escaped=!1,next,inSet=!1;while((next=stream.next())!=null){if(!escaped){if(next=="/"&&!inSet)return;if(next=="[")inSet=!0;else if(inSet&&next=="]")inSet=!1}
escaped=!escaped&&next=="\\"}}
var type,content;function ret(tp,style,cont){type=tp;content=cont;return style}
function tokenBase(stream,state){var ch=stream.next();if(ch=='"'||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state)}else if(ch=="."&&stream.match(/^\d[\d_]*(?:[eE][+\-]?[\d_]+)?/)){return ret("number","number")}else if(ch=="."&&stream.match("..")){return ret("spread","meta")}else if(/[\[\]{}\(\),;\:\.]/.test(ch)){return ret(ch)}else if(ch=="="&&stream.eat(">")){return ret("=>","operator")}else if(ch=="0"&&stream.match(/^(?:x[\dA-Fa-f_]+|o[0-7_]+|b[01_]+)n?/)){return ret("number","number")}else if(/\d/.test(ch)){stream.match(/^[\d_]*(?:n|(?:\.[\d_]*)?(?:[eE][+\-]?[\d_]+)?)?/);return ret("number","number")}else if(ch=="/"){if(stream.eat("*")){state.tokenize=tokenComment;return tokenComment(stream,state)}else if(stream.eat("/")){stream.skipToEnd();return ret("comment","comment")}else if(expressionAllowed(stream,state,1)){readRegexp(stream);stream.match(/^\b(([gimyus])(?![gimyus]*\2))+\b/);return ret("regexp","string-2")}else{stream.eat("=");return ret("operator","operator",stream.current())}}else if(ch=="`"){state.tokenize=tokenQuasi;return tokenQuasi(stream,state)}else if(ch=="#"&&stream.peek()=="!"){stream.skipToEnd();return ret("meta","meta")}else if(ch=="#"&&stream.eatWhile(wordRE)){return ret("variable","property")}else if(ch=="<"&&stream.match("!--")||(ch=="-"&&stream.match("->")&&!/\S/.test(stream.string.slice(0,stream.start)))){stream.skipToEnd()
return ret("comment","comment")}else if(isOperatorChar.test(ch)){if(ch!=">"||!state.lexical||state.lexical.type!=">"){if(stream.eat("=")){if(ch=="!"||ch=="=")stream.eat("=")}else if(/[<>*+\-|&?]/.test(ch)){stream.eat(ch)
if(ch==">")stream.eat(ch)}}
if(ch=="?"&&stream.eat("."))return ret(".")
return ret("operator","operator",stream.current());}else if(wordRE.test(ch)){stream.eatWhile(wordRE);var word=stream.current()
if(state.lastType!="."){if(keywords.propertyIsEnumerable(word)){var kw=keywords[word]
return ret(kw.type,kw.style,word)}
if(word=="async"&&stream.match(/^(\s|\/\*([^*]|\*(?!\/))*?\*\/)*[\[\(\w]/,!1))
return ret("async","keyword",word)}
return ret("variable","variable",word)}}
function tokenString(quote){return function(stream,state){var escaped=!1,next;if(jsonldMode&&stream.peek()=="@"&&stream.match(isJsonldKeyword)){state.tokenize=tokenBase;return ret("jsonld-keyword","meta")}
while((next=stream.next())!=null){if(next==quote&&!escaped)break;escaped=!escaped&&next=="\\"}
if(!escaped)state.tokenize=tokenBase;return ret("string","string")}}
function tokenComment(stream,state){var maybeEnd=!1,ch;while(ch=stream.next()){if(ch=="/"&&maybeEnd){state.tokenize=tokenBase;break}
maybeEnd=(ch=="*")}
return ret("comment","comment")}
function tokenQuasi(stream,state){var escaped=!1,next;while((next=stream.next())!=null){if(!escaped&&(next=="`"||next=="$"&&stream.eat("{"))){state.tokenize=tokenBase;break}
escaped=!escaped&&next=="\\"}
return ret("quasi","string-2",stream.current())}
var brackets="([{}])";function findFatArrow(stream,state){if(state.fatArrowAt)state.fatArrowAt=null;var arrow=stream.string.indexOf("=>",stream.start);if(arrow<0)return;if(isTS){var m=/:\s*(?:\w+(?:<[^>]*>|\[\])?|\{[^}]*\})\s*$/.exec(stream.string.slice(stream.start,arrow))
if(m)arrow=m.index}
var depth=0,sawSomething=!1;for(var pos=arrow-1;pos>=0;--pos){var ch=stream.string.charAt(pos);var bracket=brackets.indexOf(ch);if(bracket>=0&&bracket<3){if(!depth){++pos;break}
if(--depth==0){if(ch=="(")sawSomething=!0;break}}else if(bracket>=3&&bracket<6){++depth}else if(wordRE.test(ch)){sawSomething=!0}else if(/["'\/`]/.test(ch)){for(;;--pos){if(pos==0)return
var next=stream.string.charAt(pos-1)
if(next==ch&&stream.string.charAt(pos-2)!="\\"){pos--;break}}}else if(sawSomething&&!depth){++pos;break}}
if(sawSomething&&!depth)state.fatArrowAt=pos}
var atomicTypes={"atom":!0,"number":!0,"variable":!0,"string":!0,"regexp":!0,"this":!0,"import":!0,"jsonld-keyword":!0};function JSLexical(indented,column,type,align,prev,info){this.indented=indented;this.column=column;this.type=type;this.prev=prev;this.info=info;if(align!=null)this.align=align}
function inScope(state,varname){if(!trackScope)return!1
for(var v=state.localVars;v;v=v.next)
if(v.name==varname)return!0;for(var cx=state.context;cx;cx=cx.prev){for(var v=cx.vars;v;v=v.next)
if(v.name==varname)return!0}}
function parseJS(state,style,type,content,stream){var cc=state.cc;cx.state=state;cx.stream=stream;cx.marked=null,cx.cc=cc;cx.style=style;if(!state.lexical.hasOwnProperty("align"))
state.lexical.align=!0;while(!0){var combinator=cc.length?cc.pop():jsonMode?expression:statement;if(combinator(type,content)){while(cc.length&&cc[cc.length-1].lex)
cc.pop()();if(cx.marked)return cx.marked;if(type=="variable"&&inScope(state,content))return"variable-2";return style}}}
var cx={state:null,column:null,marked:null,cc:null};function pass(){for(var i=arguments.length-1;i>=0;i--)cx.cc.push(arguments[i]);}
function cont(){pass.apply(null,arguments);return!0}
function inList(name,list){for(var v=list;v;v=v.next)if(v.name==name)return!0
return!1}
function register(varname){var state=cx.state;cx.marked="def";if(!trackScope)return
if(state.context){if(state.lexical.info=="var"&&state.context&&state.context.block){var newContext=registerVarScoped(varname,state.context)
if(newContext!=null){state.context=newContext
return}}else if(!inList(varname,state.localVars)){state.localVars=new Var(varname,state.localVars)
return}}
if(parserConfig.globalVars&&!inList(varname,state.globalVars))
state.globalVars=new Var(varname,state.globalVars)}
function registerVarScoped(varname,context){if(!context){return null}else if(context.block){var inner=registerVarScoped(varname,context.prev)
if(!inner)return null
if(inner==context.prev)return context
return new Context(inner,context.vars,!0)}else if(inList(varname,context.vars)){return context}else{return new Context(context.prev,new Var(varname,context.vars),!1)}}
function isModifier(name){return name=="public"||name=="private"||name=="protected"||name=="abstract"||name=="readonly"}
function Context(prev,vars,block){this.prev=prev;this.vars=vars;this.block=block}
function Var(name,next){this.name=name;this.next=next}
var defaultVars=new Var("this",new Var("arguments",null))
function pushcontext(){cx.state.context=new Context(cx.state.context,cx.state.localVars,!1)
cx.state.localVars=defaultVars}
function pushblockcontext(){cx.state.context=new Context(cx.state.context,cx.state.localVars,!0)
cx.state.localVars=null}
pushcontext.lex=pushblockcontext.lex=!0
function popcontext(){cx.state.localVars=cx.state.context.vars
cx.state.context=cx.state.context.prev}
popcontext.lex=!0
function pushlex(type,info){var result=function(){var state=cx.state,indent=state.indented;if(state.lexical.type=="stat")indent=state.lexical.indented;else for(var outer=state.lexical;outer&&outer.type==")"&&outer.align;outer=outer.prev)
indent=outer.indented;state.lexical=new JSLexical(indent,cx.stream.column(),type,null,state.lexical,info)};result.lex=!0;return result}
function poplex(){var state=cx.state;if(state.lexical.prev){if(state.lexical.type==")")
state.indented=state.lexical.indented;state.lexical=state.lexical.prev}}
poplex.lex=!0;function expect(wanted){function exp(type){if(type==wanted)return cont();else if(wanted==";"||type=="}"||type==")"||type=="]")return pass();else return cont(exp)};return exp}
function statement(type,value){if(type=="var")return cont(pushlex("vardef",value),vardef,expect(";"),poplex);if(type=="keyword a")return cont(pushlex("form"),parenExpr,statement,poplex);if(type=="keyword b")return cont(pushlex("form"),statement,poplex);if(type=="keyword d")return cx.stream.match(/^\s*$/,!1)?cont():cont(pushlex("stat"),maybeexpression,expect(";"),poplex);if(type=="debugger")return cont(expect(";"));if(type=="{")return cont(pushlex("}"),pushblockcontext,block,poplex,popcontext);if(type==";")return cont();if(type=="if"){if(cx.state.lexical.info=="else"&&cx.state.cc[cx.state.cc.length-1]==poplex)
cx.state.cc.pop()();return cont(pushlex("form"),parenExpr,statement,poplex,maybeelse)}
if(type=="function")return cont(functiondef);if(type=="for")return cont(pushlex("form"),pushblockcontext,forspec,statement,popcontext,poplex);if(type=="class"||(isTS&&value=="interface")){cx.marked="keyword"
return cont(pushlex("form",type=="class"?type:value),className,poplex)}
if(type=="variable"){if(isTS&&value=="declare"){cx.marked="keyword"
return cont(statement)}else if(isTS&&(value=="module"||value=="enum"||value=="type")&&cx.stream.match(/^\s*\w/,!1)){cx.marked="keyword"
if(value=="enum")return cont(enumdef);else if(value=="type")return cont(typename,expect("operator"),typeexpr,expect(";"));else return cont(pushlex("form"),pattern,expect("{"),pushlex("}"),block,poplex,poplex)}else if(isTS&&value=="namespace"){cx.marked="keyword"
return cont(pushlex("form"),expression,statement,poplex)}else if(isTS&&value=="abstract"){cx.marked="keyword"
return cont(statement)}else{return cont(pushlex("stat"),maybelabel)}}
if(type=="switch")return cont(pushlex("form"),parenExpr,expect("{"),pushlex("}","switch"),pushblockcontext,block,poplex,poplex,popcontext);if(type=="case")return cont(expression,expect(":"));if(type=="default")return cont(expect(":"));if(type=="catch")return cont(pushlex("form"),pushcontext,maybeCatchBinding,statement,poplex,popcontext);if(type=="export")return cont(pushlex("stat"),afterExport,poplex);if(type=="import")return cont(pushlex("stat"),afterImport,poplex);if(type=="async")return cont(statement)
if(value=="@")return cont(expression,statement)
return pass(pushlex("stat"),expression,expect(";"),poplex);}
function maybeCatchBinding(type){if(type=="(")return cont(funarg,expect(")"))}
function expression(type,value){return expressionInner(type,value,!1)}
function expressionNoComma(type,value){return expressionInner(type,value,!0)}
function parenExpr(type){if(type!="(")return pass()
return cont(pushlex(")"),maybeexpression,expect(")"),poplex)}
function expressionInner(type,value,noComma){if(cx.state.fatArrowAt==cx.stream.start){var body=noComma?arrowBodyNoComma:arrowBody;if(type=="(")return cont(pushcontext,pushlex(")"),commasep(funarg,")"),poplex,expect("=>"),body,popcontext);else if(type=="variable")return pass(pushcontext,pattern,expect("=>"),body,popcontext);}
var maybeop=noComma?maybeoperatorNoComma:maybeoperatorComma;if(atomicTypes.hasOwnProperty(type))return cont(maybeop);if(type=="function")return cont(functiondef,maybeop);if(type=="class"||(isTS&&value=="interface")){cx.marked="keyword";return cont(pushlex("form"),classExpression,poplex)}
if(type=="keyword c"||type=="async")return cont(noComma?expressionNoComma:expression);if(type=="(")return cont(pushlex(")"),maybeexpression,expect(")"),poplex,maybeop);if(type=="operator"||type=="spread")return cont(noComma?expressionNoComma:expression);if(type=="[")return cont(pushlex("]"),arrayLiteral,poplex,maybeop);if(type=="{")return contCommasep(objprop,"}",null,maybeop);if(type=="quasi")return pass(quasi,maybeop);if(type=="new")return cont(maybeTarget(noComma));return cont()}
function maybeexpression(type){if(type.match(/[;\}\)\],]/))return pass();return pass(expression)}
function maybeoperatorComma(type,value){if(type==",")return cont(maybeexpression);return maybeoperatorNoComma(type,value,!1)}
function maybeoperatorNoComma(type,value,noComma){var me=noComma==!1?maybeoperatorComma:maybeoperatorNoComma;var expr=noComma==!1?expression:expressionNoComma;if(type=="=>")return cont(pushcontext,noComma?arrowBodyNoComma:arrowBody,popcontext);if(type=="operator"){if(/\+\+|--/.test(value)||isTS&&value=="!")return cont(me);if(isTS&&value=="<"&&cx.stream.match(/^([^<>]|<[^<>]*>)*>\s*\(/,!1))
return cont(pushlex(">"),commasep(typeexpr,">"),poplex,me);if(value=="?")return cont(expression,expect(":"),expr);return cont(expr)}
if(type=="quasi"){return pass(quasi,me)}
if(type==";")return;if(type=="(")return contCommasep(expressionNoComma,")","call",me);if(type==".")return cont(property,me);if(type=="[")return cont(pushlex("]"),maybeexpression,expect("]"),poplex,me);if(isTS&&value=="as"){cx.marked="keyword";return cont(typeexpr,me)}
if(type=="regexp"){cx.state.lastType=cx.marked="operator"
cx.stream.backUp(cx.stream.pos-cx.stream.start-1)
return cont(expr)}}
function quasi(type,value){if(type!="quasi")return pass();if(value.slice(value.length-2)!="${")return cont(quasi);return cont(maybeexpression,continueQuasi)}
function continueQuasi(type){if(type=="}"){cx.marked="string-2";cx.state.tokenize=tokenQuasi;return cont(quasi)}}
function arrowBody(type){findFatArrow(cx.stream,cx.state);return pass(type=="{"?statement:expression)}
function arrowBodyNoComma(type){findFatArrow(cx.stream,cx.state);return pass(type=="{"?statement:expressionNoComma)}
function maybeTarget(noComma){return function(type){if(type==".")return cont(noComma?targetNoComma:target);else if(type=="variable"&&isTS)return cont(maybeTypeArgs,noComma?maybeoperatorNoComma:maybeoperatorComma)
else return pass(noComma?expressionNoComma:expression);}}
function target(_,value){if(value=="target"){cx.marked="keyword";return cont(maybeoperatorComma)}}
function targetNoComma(_,value){if(value=="target"){cx.marked="keyword";return cont(maybeoperatorNoComma)}}
function maybelabel(type){if(type==":")return cont(poplex,statement);return pass(maybeoperatorComma,expect(";"),poplex)}
function property(type){if(type=="variable"){cx.marked="property";return cont()}}
function objprop(type,value){if(type=="async"){cx.marked="property";return cont(objprop)}else if(type=="variable"||cx.style=="keyword"){cx.marked="property";if(value=="get"||value=="set")return cont(getterSetter);var m
if(isTS&&cx.state.fatArrowAt==cx.stream.start&&(m=cx.stream.match(/^\s*:\s*/,!1)))
cx.state.fatArrowAt=cx.stream.pos+m[0].length
return cont(afterprop);}else if(type=="number"||type=="string"){cx.marked=jsonldMode?"property":(cx.style+" property");return cont(afterprop)}else if(type=="jsonld-keyword"){return cont(afterprop)}else if(isTS&&isModifier(value)){cx.marked="keyword"
return cont(objprop)}else if(type=="["){return cont(expression,maybetype,expect("]"),afterprop)}else if(type=="spread"){return cont(expressionNoComma,afterprop)}else if(value=="*"){cx.marked="keyword";return cont(objprop)}else if(type==":"){return pass(afterprop)}}
function getterSetter(type){if(type!="variable")return pass(afterprop);cx.marked="property";return cont(functiondef)}
function afterprop(type){if(type==":")return cont(expressionNoComma);if(type=="(")return pass(functiondef);}
function commasep(what,end,sep){function proceed(type,value){if(sep?sep.indexOf(type)>-1:type==","){var lex=cx.state.lexical;if(lex.info=="call")lex.pos=(lex.pos||0)+1;return cont(function(type,value){if(type==end||value==end)return pass()
return pass(what)},proceed);}
if(type==end||value==end)return cont();if(sep&&sep.indexOf(";")>-1)return pass(what)
return cont(expect(end));}
return function(type,value){if(type==end||value==end)return cont();return pass(what,proceed)}}
function contCommasep(what,end,info){for(var i=3;i<arguments.length;i++)
cx.cc.push(arguments[i]);return cont(pushlex(end,info),commasep(what,end),poplex)}
function block(type){if(type=="}")return cont();return pass(statement,block)}
function maybetype(type,value){if(isTS){if(type==":")return cont(typeexpr);if(value=="?")return cont(maybetype);}}
function maybetypeOrIn(type,value){if(isTS&&(type==":"||value=="in"))return cont(typeexpr)}
function mayberettype(type){if(isTS&&type==":"){if(cx.stream.match(/^\s*\w+\s+is\b/,!1))return cont(expression,isKW,typeexpr)
else return cont(typeexpr)}}
function isKW(_,value){if(value=="is"){cx.marked="keyword"
return cont()}}
function typeexpr(type,value){if(value=="keyof"||value=="typeof"||value=="infer"||value=="readonly"){cx.marked="keyword"
return cont(value=="typeof"?expressionNoComma:typeexpr)}
if(type=="variable"||value=="void"){cx.marked="type"
return cont(afterType)}
if(value=="|"||value=="&")return cont(typeexpr)
if(type=="string"||type=="number"||type=="atom")return cont(afterType);if(type=="[")return cont(pushlex("]"),commasep(typeexpr,"]",","),poplex,afterType)
if(type=="{")return cont(pushlex("}"),typeprops,poplex,afterType)
if(type=="(")return cont(commasep(typearg,")"),maybeReturnType,afterType)
if(type=="<")return cont(commasep(typeexpr,">"),typeexpr)
if(type=="quasi"){return pass(quasiType,afterType)}}
function maybeReturnType(type){if(type=="=>")return cont(typeexpr)}
function typeprops(type){if(type.match(/[\}\)\]]/))return cont()
if(type==","||type==";")return cont(typeprops)
return pass(typeprop,typeprops)}
function typeprop(type,value){if(type=="variable"||cx.style=="keyword"){cx.marked="property"
return cont(typeprop)}else if(value=="?"||type=="number"||type=="string"){return cont(typeprop)}else if(type==":"){return cont(typeexpr)}else if(type=="["){return cont(expect("variable"),maybetypeOrIn,expect("]"),typeprop)}else if(type=="("){return pass(functiondecl,typeprop)}else if(!type.match(/[;\}\)\],]/)){return cont()}}
function quasiType(type,value){if(type!="quasi")return pass();if(value.slice(value.length-2)!="${")return cont(quasiType);return cont(typeexpr,continueQuasiType)}
function continueQuasiType(type){if(type=="}"){cx.marked="string-2";cx.state.tokenize=tokenQuasi;return cont(quasiType)}}
function typearg(type,value){if(type=="variable"&&cx.stream.match(/^\s*[?:]/,!1)||value=="?")return cont(typearg)
if(type==":")return cont(typeexpr)
if(type=="spread")return cont(typearg)
return pass(typeexpr)}
function afterType(type,value){if(value=="<")return cont(pushlex(">"),commasep(typeexpr,">"),poplex,afterType)
if(value=="|"||type=="."||value=="&")return cont(typeexpr)
if(type=="[")return cont(typeexpr,expect("]"),afterType)
if(value=="extends"||value=="implements"){cx.marked="keyword";return cont(typeexpr)}
if(value=="?")return cont(typeexpr,expect(":"),typeexpr)}
function maybeTypeArgs(_,value){if(value=="<")return cont(pushlex(">"),commasep(typeexpr,">"),poplex,afterType)}
function typeparam(){return pass(typeexpr,maybeTypeDefault)}
function maybeTypeDefault(_,value){if(value=="=")return cont(typeexpr)}
function vardef(_,value){if(value=="enum"){cx.marked="keyword";return cont(enumdef)}
return pass(pattern,maybetype,maybeAssign,vardefCont)}
function pattern(type,value){if(isTS&&isModifier(value)){cx.marked="keyword";return cont(pattern)}
if(type=="variable"){register(value);return cont()}
if(type=="spread")return cont(pattern);if(type=="[")return contCommasep(eltpattern,"]");if(type=="{")return contCommasep(proppattern,"}");}
function proppattern(type,value){if(type=="variable"&&!cx.stream.match(/^\s*:/,!1)){register(value);return cont(maybeAssign)}
if(type=="variable")cx.marked="property";if(type=="spread")return cont(pattern);if(type=="}")return pass();if(type=="[")return cont(expression,expect(']'),expect(':'),proppattern);return cont(expect(":"),pattern,maybeAssign)}
function eltpattern(){return pass(pattern,maybeAssign)}
function maybeAssign(_type,value){if(value=="=")return cont(expressionNoComma);}
function vardefCont(type){if(type==",")return cont(vardef);}
function maybeelse(type,value){if(type=="keyword b"&&value=="else")return cont(pushlex("form","else"),statement,poplex);}
function forspec(type,value){if(value=="await")return cont(forspec);if(type=="(")return cont(pushlex(")"),forspec1,poplex);}
function forspec1(type){if(type=="var")return cont(vardef,forspec2);if(type=="variable")return cont(forspec2);return pass(forspec2)}
function forspec2(type,value){if(type==")")return cont()
if(type==";")return cont(forspec2)
if(value=="in"||value=="of"){cx.marked="keyword";return cont(expression,forspec2)}
return pass(expression,forspec2)}
function functiondef(type,value){if(value=="*"){cx.marked="keyword";return cont(functiondef)}
if(type=="variable"){register(value);return cont(functiondef)}
if(type=="(")return cont(pushcontext,pushlex(")"),commasep(funarg,")"),poplex,mayberettype,statement,popcontext);if(isTS&&value=="<")return cont(pushlex(">"),commasep(typeparam,">"),poplex,functiondef)}
function functiondecl(type,value){if(value=="*"){cx.marked="keyword";return cont(functiondecl)}
if(type=="variable"){register(value);return cont(functiondecl)}
if(type=="(")return cont(pushcontext,pushlex(")"),commasep(funarg,")"),poplex,mayberettype,popcontext);if(isTS&&value=="<")return cont(pushlex(">"),commasep(typeparam,">"),poplex,functiondecl)}
function typename(type,value){if(type=="keyword"||type=="variable"){cx.marked="type"
return cont(typename)}else if(value=="<"){return cont(pushlex(">"),commasep(typeparam,">"),poplex)}}
function funarg(type,value){if(value=="@")cont(expression,funarg)
if(type=="spread")return cont(funarg);if(isTS&&isModifier(value)){cx.marked="keyword";return cont(funarg)}
if(isTS&&type=="this")return cont(maybetype,maybeAssign)
return pass(pattern,maybetype,maybeAssign);}
function classExpression(type,value){if(type=="variable")return className(type,value);return classNameAfter(type,value)}
function className(type,value){if(type=="variable"){register(value);return cont(classNameAfter)}}
function classNameAfter(type,value){if(value=="<")return cont(pushlex(">"),commasep(typeparam,">"),poplex,classNameAfter)
if(value=="extends"||value=="implements"||(isTS&&type==",")){if(value=="implements")cx.marked="keyword";return cont(isTS?typeexpr:expression,classNameAfter)}
if(type=="{")return cont(pushlex("}"),classBody,poplex);}
function classBody(type,value){if(type=="async"||(type=="variable"&&(value=="static"||value=="get"||value=="set"||(isTS&&isModifier(value)))&&cx.stream.match(/^\s+#?[\w$\xa1-\uffff]/,!1))){cx.marked="keyword";return cont(classBody)}
if(type=="variable"||cx.style=="keyword"){cx.marked="property";return cont(classfield,classBody)}
if(type=="number"||type=="string")return cont(classfield,classBody);if(type=="[")
return cont(expression,maybetype,expect("]"),classfield,classBody)
if(value=="*"){cx.marked="keyword";return cont(classBody)}
if(isTS&&type=="(")return pass(functiondecl,classBody)
if(type==";"||type==",")return cont(classBody);if(type=="}")return cont();if(value=="@")return cont(expression,classBody)}
function classfield(type,value){if(value=="!")return cont(classfield)
if(value=="?")return cont(classfield)
if(type==":")return cont(typeexpr,maybeAssign)
if(value=="=")return cont(expressionNoComma)
var context=cx.state.lexical.prev,isInterface=context&&context.info=="interface"
return pass(isInterface?functiondecl:functiondef)}
function afterExport(type,value){if(value=="*"){cx.marked="keyword";return cont(maybeFrom,expect(";"))}
if(value=="default"){cx.marked="keyword";return cont(expression,expect(";"))}
if(type=="{")return cont(commasep(exportField,"}"),maybeFrom,expect(";"));return pass(statement)}
function exportField(type,value){if(value=="as"){cx.marked="keyword";return cont(expect("variable"))}
if(type=="variable")return pass(expressionNoComma,exportField);}
function afterImport(type){if(type=="string")return cont();if(type=="(")return pass(expression);if(type==".")return pass(maybeoperatorComma);return pass(importSpec,maybeMoreImports,maybeFrom)}
function importSpec(type,value){if(type=="{")return contCommasep(importSpec,"}");if(type=="variable")register(value);if(value=="*")cx.marked="keyword";return cont(maybeAs)}
function maybeMoreImports(type){if(type==",")return cont(importSpec,maybeMoreImports)}
function maybeAs(_type,value){if(value=="as"){cx.marked="keyword";return cont(importSpec)}}
function maybeFrom(_type,value){if(value=="from"){cx.marked="keyword";return cont(expression)}}
function arrayLiteral(type){if(type=="]")return cont();return pass(commasep(expressionNoComma,"]"))}
function enumdef(){return pass(pushlex("form"),pattern,expect("{"),pushlex("}"),commasep(enummember,"}"),poplex,poplex)}
function enummember(){return pass(pattern,maybeAssign)}
function isContinuedStatement(state,textAfter){return state.lastType=="operator"||state.lastType==","||isOperatorChar.test(textAfter.charAt(0))||/[,.]/.test(textAfter.charAt(0))}
function expressionAllowed(stream,state,backUp){return state.tokenize==tokenBase&&/^(?:operator|sof|keyword [bcd]|case|new|export|default|spread|[\[{}\(,;:]|=>)$/.test(state.lastType)||(state.lastType=="quasi"&&/\{\s*$/.test(stream.string.slice(0,stream.pos-(backUp||0))))}
return{startState:function(basecolumn){var state={tokenize:tokenBase,lastType:"sof",cc:[],lexical:new JSLexical((basecolumn||0)-indentUnit,0,"block",!1),localVars:parserConfig.localVars,context:parserConfig.localVars&&new Context(null,null,!1),indented:basecolumn||0};if(parserConfig.globalVars&&typeof parserConfig.globalVars=="object")
state.globalVars=parserConfig.globalVars;return state},token:function(stream,state){if(stream.sol()){if(!state.lexical.hasOwnProperty("align"))
state.lexical.align=!1;state.indented=stream.indentation();findFatArrow(stream,state)}
if(state.tokenize!=tokenComment&&stream.eatSpace())return null;var style=state.tokenize(stream,state);if(type=="comment")return style;state.lastType=type=="operator"&&(content=="++"||content=="--")?"incdec":type;return parseJS(state,style,type,content,stream)},indent:function(state,textAfter){if(state.tokenize==tokenComment||state.tokenize==tokenQuasi)return CodeMirror.Pass;if(state.tokenize!=tokenBase)return 0;var firstChar=textAfter&&textAfter.charAt(0),lexical=state.lexical,top
if(!/^\s*else\b/.test(textAfter))for(var i=state.cc.length-1;i>=0;--i){var c=state.cc[i];if(c==poplex)lexical=lexical.prev;else if(c!=maybeelse&&c!=popcontext)break}
while((lexical.type=="stat"||lexical.type=="form")&&(firstChar=="}"||((top=state.cc[state.cc.length-1])&&(top==maybeoperatorComma||top==maybeoperatorNoComma)&&!/^[,\.=+\-*:?[\(]/.test(textAfter))))
lexical=lexical.prev;if(statementIndent&&lexical.type==")"&&lexical.prev.type=="stat")
lexical=lexical.prev;var type=lexical.type,closing=firstChar==type;if(type=="vardef")return lexical.indented+(state.lastType=="operator"||state.lastType==","?lexical.info.length+1:0);else if(type=="form"&&firstChar=="{")return lexical.indented;else if(type=="form")return lexical.indented+indentUnit;else if(type=="stat")
return lexical.indented+(isContinuedStatement(state,textAfter)?statementIndent||indentUnit:0);else if(lexical.info=="switch"&&!closing&&parserConfig.doubleIndentSwitch!=!1)
return lexical.indented+(/^(?:case|default)\b/.test(textAfter)?indentUnit:2*indentUnit);else if(lexical.align)return lexical.column+(closing?0:1);else return lexical.indented+(closing?0:indentUnit)},electricInput:/^\s*(?:case .*?:|default:|\{|\})$/,blockCommentStart:jsonMode?null:"/*",blockCommentEnd:jsonMode?null:"*/",blockCommentContinue:jsonMode?null:" * ",lineComment:jsonMode?null:"//",fold:"brace",closeBrackets:"()[]{}''\"\"``",helperType:jsonMode?"json":"javascript",jsonldMode:jsonldMode,jsonMode:jsonMode,expressionAllowed:expressionAllowed,skipExpression:function(state){parseJS(state,"atom","atom","true",new CodeMirror.StringStream("",2,null))}}});CodeMirror.registerHelper("wordChars","javascript",/[\w$]/);CodeMirror.defineMIME("text/javascript","javascript");CodeMirror.defineMIME("text/ecmascript","javascript");CodeMirror.defineMIME("application/javascript","javascript");CodeMirror.defineMIME("application/x-javascript","javascript");CodeMirror.defineMIME("application/ecmascript","javascript");CodeMirror.defineMIME("application/json",{name:"javascript",json:!0});CodeMirror.defineMIME("application/x-json",{name:"javascript",json:!0});CodeMirror.defineMIME("application/manifest+json",{name:"javascript",json:!0})
CodeMirror.defineMIME("application/ld+json",{name:"javascript",jsonld:!0});CodeMirror.defineMIME("text/typescript",{name:"javascript",typescript:!0});CodeMirror.defineMIME("application/typescript",{name:"javascript",typescript:!0})});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"),require("../xml/xml"),require("../javascript/javascript"),require("../css/css"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror","../xml/xml","../javascript/javascript","../css/css"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";var defaultTags={script:[["lang",/(javascript|babel)/i,"javascript"],["type",/^(?:text|application)\/(?:x-)?(?:java|ecma)script$|^module$|^$/i,"javascript"],["type",/./,"text/plain"],[null,null,"javascript"]],style:[["lang",/^css$/i,"css"],["type",/^(text\/)?(x-)?(stylesheet|css)$/i,"css"],["type",/./,"text/plain"],[null,null,"css"]]};function maybeBackup(stream,pat,style){var cur=stream.current(),close=cur.search(pat);if(close>-1){stream.backUp(cur.length-close)}else if(cur.match(/<\/?$/)){stream.backUp(cur.length);if(!stream.match(pat,!1))stream.match(cur);}
return style}
var attrRegexpCache={};function getAttrRegexp(attr){var regexp=attrRegexpCache[attr];if(regexp)return regexp;return attrRegexpCache[attr]=new RegExp("\\s+"+attr+"\\s*=\\s*('|\")?([^'\"]+)('|\")?\\s*")}
function getAttrValue(text,attr){var match=text.match(getAttrRegexp(attr))
return match?/^\s*(.*?)\s*$/.exec(match[2])[1]:""}
function getTagRegexp(tagName,anchored){return new RegExp((anchored?"^":"")+"<\/\\s*"+tagName+"\\s*>","i")}
function addTags(from,to){for(var tag in from){var dest=to[tag]||(to[tag]=[]);var source=from[tag];for(var i=source.length-1;i>=0;i--)
dest.unshift(source[i])}}
function findMatchingMode(tagInfo,tagText){for(var i=0;i<tagInfo.length;i++){var spec=tagInfo[i];if(!spec[0]||spec[1].test(getAttrValue(tagText,spec[0])))return spec[2]}}
CodeMirror.defineMode("htmlmixed",function(config,parserConfig){var htmlMode=CodeMirror.getMode(config,{name:"xml",htmlMode:!0,multilineTagIndentFactor:parserConfig.multilineTagIndentFactor,multilineTagIndentPastTag:parserConfig.multilineTagIndentPastTag,allowMissingTagName:parserConfig.allowMissingTagName,});var tags={};var configTags=parserConfig&&parserConfig.tags,configScript=parserConfig&&parserConfig.scriptTypes;addTags(defaultTags,tags);if(configTags)addTags(configTags,tags);if(configScript)for(var i=configScript.length-1;i>=0;i--)
tags.script.unshift(["type",configScript[i].matches,configScript[i].mode])
function html(stream,state){var style=htmlMode.token(stream,state.htmlState),tag=/\btag\b/.test(style),tagName
if(tag&&!/[<>\s\/]/.test(stream.current())&&(tagName=state.htmlState.tagName&&state.htmlState.tagName.toLowerCase())&&tags.hasOwnProperty(tagName)){state.inTag=tagName+" "}else if(state.inTag&&tag&&/>$/.test(stream.current())){var inTag=/^([\S]+) (.*)/.exec(state.inTag)
state.inTag=null
var modeSpec=stream.current()==">"&&findMatchingMode(tags[inTag[1]],inTag[2])
var mode=CodeMirror.getMode(config,modeSpec)
var endTagA=getTagRegexp(inTag[1],!0),endTag=getTagRegexp(inTag[1],!1);state.token=function(stream,state){if(stream.match(endTagA,!1)){state.token=html;state.localState=state.localMode=null;return null}
return maybeBackup(stream,endTag,state.localMode.token(stream,state.localState))};state.localMode=mode;state.localState=CodeMirror.startState(mode,htmlMode.indent(state.htmlState,"",""))}else if(state.inTag){state.inTag+=stream.current()
if(stream.eol())state.inTag+=" "}
return style};return{startState:function(){var state=CodeMirror.startState(htmlMode);return{token:html,inTag:null,localMode:null,localState:null,htmlState:state}},copyState:function(state){var local;if(state.localState){local=CodeMirror.copyState(state.localMode,state.localState)}
return{token:state.token,inTag:state.inTag,localMode:state.localMode,localState:local,htmlState:CodeMirror.copyState(htmlMode,state.htmlState)}},token:function(stream,state){return state.token(stream,state)},indent:function(state,textAfter,line){if(!state.localMode||/^\s*<\//.test(textAfter))
return htmlMode.indent(state.htmlState,textAfter,line);else if(state.localMode.indent)
return state.localMode.indent(state.localState,textAfter,line);else return CodeMirror.Pass},innerMode:function(state){return{state:state.localState||state.htmlState,mode:state.localMode||htmlMode}}}},"xml","javascript","css");CodeMirror.defineMIME("text/html","htmlmixed")});(function(mod){if(typeof exports=="object"&&typeof module=="object")
mod(require("../../lib/codemirror"));else if(typeof define=="function"&&define.amd)
define(["../../lib/codemirror"],mod);else mod(CodeMirror)})(function(CodeMirror){"use strict";CodeMirror.defineMode("css",function(config,parserConfig){var inline=parserConfig.inline
if(!parserConfig.propertyKeywords)parserConfig=CodeMirror.resolveMode("text/css");var indentUnit=config.indentUnit,tokenHooks=parserConfig.tokenHooks,documentTypes=parserConfig.documentTypes||{},mediaTypes=parserConfig.mediaTypes||{},mediaFeatures=parserConfig.mediaFeatures||{},mediaValueKeywords=parserConfig.mediaValueKeywords||{},propertyKeywords=parserConfig.propertyKeywords||{},nonStandardPropertyKeywords=parserConfig.nonStandardPropertyKeywords||{},fontProperties=parserConfig.fontProperties||{},counterDescriptors=parserConfig.counterDescriptors||{},colorKeywords=parserConfig.colorKeywords||{},valueKeywords=parserConfig.valueKeywords||{},allowNested=parserConfig.allowNested,lineComment=parserConfig.lineComment,supportsAtComponent=parserConfig.supportsAtComponent===!0,highlightNonStandardPropertyKeywords=config.highlightNonStandardPropertyKeywords!==!1;var type,override;function ret(style,tp){type=tp;return style}
function tokenBase(stream,state){var ch=stream.next();if(tokenHooks[ch]){var result=tokenHooks[ch](stream,state);if(result!==!1)return result}
if(ch=="@"){stream.eatWhile(/[\w\\\-]/);return ret("def",stream.current())}else if(ch=="="||(ch=="~"||ch=="|")&&stream.eat("=")){return ret(null,"compare")}else if(ch=="\""||ch=="'"){state.tokenize=tokenString(ch);return state.tokenize(stream,state)}else if(ch=="#"){stream.eatWhile(/[\w\\\-]/);return ret("atom","hash")}else if(ch=="!"){stream.match(/^\s*\w*/);return ret("keyword","important")}else if(/\d/.test(ch)||ch=="."&&stream.eat(/\d/)){stream.eatWhile(/[\w.%]/);return ret("number","unit")}else if(ch==="-"){if(/[\d.]/.test(stream.peek())){stream.eatWhile(/[\w.%]/);return ret("number","unit")}else if(stream.match(/^-[\w\\\-]*/)){stream.eatWhile(/[\w\\\-]/);if(stream.match(/^\s*:/,!1))
return ret("variable-2","variable-definition");return ret("variable-2","variable")}else if(stream.match(/^\w+-/)){return ret("meta","meta")}}else if(/[,+>*\/]/.test(ch)){return ret(null,"select-op")}else if(ch=="."&&stream.match(/^-?[_a-z][_a-z0-9-]*/i)){return ret("qualifier","qualifier")}else if(/[:;{}\[\]\(\)]/.test(ch)){return ret(null,ch)}else if(stream.match(/^[\w-.]+(?=\()/)){if(/^(url(-prefix)?|domain|regexp)$/i.test(stream.current())){state.tokenize=tokenParenthesized}
return ret("variable callee","variable")}else if(/[\w\\\-]/.test(ch)){stream.eatWhile(/[\w\\\-]/);return ret("property","word")}else{return ret(null,null)}}
function tokenString(quote){return function(stream,state){var escaped=!1,ch;while((ch=stream.next())!=null){if(ch==quote&&!escaped){if(quote==")")stream.backUp(1);break}
escaped=!escaped&&ch=="\\"}
if(ch==quote||!escaped&&quote!=")")state.tokenize=null;return ret("string","string")}}
function tokenParenthesized(stream,state){stream.next();if(!stream.match(/^\s*[\"\')]/,!1))
state.tokenize=tokenString(")");else state.tokenize=null;return ret(null,"(")}
function Context(type,indent,prev){this.type=type;this.indent=indent;this.prev=prev}
function pushContext(state,stream,type,indent){state.context=new Context(type,stream.indentation()+(indent===!1?0:indentUnit),state.context);return type}
function popContext(state){if(state.context.prev)
state.context=state.context.prev;return state.context.type}
function pass(type,stream,state){return states[state.context.type](type,stream,state)}
function popAndPass(type,stream,state,n){for(var i=n||1;i>0;i--)
state.context=state.context.prev;return pass(type,stream,state)}
function wordAsValue(stream){var word=stream.current().toLowerCase();if(valueKeywords.hasOwnProperty(word))
override="atom";else if(colorKeywords.hasOwnProperty(word))
override="keyword";else override="variable"}
var states={};states.top=function(type,stream,state){if(type=="{"){return pushContext(state,stream,"block")}else if(type=="}"&&state.context.prev){return popContext(state)}else if(supportsAtComponent&&/@component/i.test(type)){return pushContext(state,stream,"atComponentBlock")}else if(/^@(-moz-)?document$/i.test(type)){return pushContext(state,stream,"documentTypes")}else if(/^@(media|supports|(-moz-)?document|import)$/i.test(type)){return pushContext(state,stream,"atBlock")}else if(/^@(font-face|counter-style)/i.test(type)){state.stateArg=type;return"restricted_atBlock_before"}else if(/^@(-(moz|ms|o|webkit)-)?keyframes$/i.test(type)){return"keyframes"}else if(type&&type.charAt(0)=="@"){return pushContext(state,stream,"at")}else if(type=="hash"){override="builtin"}else if(type=="word"){override="tag"}else if(type=="variable-definition"){return"maybeprop"}else if(type=="interpolation"){return pushContext(state,stream,"interpolation")}else if(type==":"){return"pseudo"}else if(allowNested&&type=="("){return pushContext(state,stream,"parens")}
return state.context.type};states.block=function(type,stream,state){if(type=="word"){var word=stream.current().toLowerCase();if(propertyKeywords.hasOwnProperty(word)){override="property";return"maybeprop"}else if(nonStandardPropertyKeywords.hasOwnProperty(word)){override=highlightNonStandardPropertyKeywords?"string-2":"property";return"maybeprop"}else if(allowNested){override=stream.match(/^\s*:(?:\s|$)/,!1)?"property":"tag";return"block"}else{override+=" error";return"maybeprop"}}else if(type=="meta"){return"block"}else if(!allowNested&&(type=="hash"||type=="qualifier")){override="error";return"block"}else{return states.top(type,stream,state)}};states.maybeprop=function(type,stream,state){if(type==":")return pushContext(state,stream,"prop");return pass(type,stream,state)};states.prop=function(type,stream,state){if(type==";")return popContext(state);if(type=="{"&&allowNested)return pushContext(state,stream,"propBlock");if(type=="}"||type=="{")return popAndPass(type,stream,state);if(type=="(")return pushContext(state,stream,"parens");if(type=="hash"&&!/^#([0-9a-fA-F]{3,4}|[0-9a-fA-F]{6}|[0-9a-fA-F]{8})$/.test(stream.current())){override+=" error"}else if(type=="word"){wordAsValue(stream)}else if(type=="interpolation"){return pushContext(state,stream,"interpolation")}
return"prop"};states.propBlock=function(type,_stream,state){if(type=="}")return popContext(state);if(type=="word"){override="property";return"maybeprop"}
return state.context.type};states.parens=function(type,stream,state){if(type=="{"||type=="}")return popAndPass(type,stream,state);if(type==")")return popContext(state);if(type=="(")return pushContext(state,stream,"parens");if(type=="interpolation")return pushContext(state,stream,"interpolation");if(type=="word")wordAsValue(stream);return"parens"};states.pseudo=function(type,stream,state){if(type=="meta")return"pseudo";if(type=="word"){override="variable-3";return state.context.type}
return pass(type,stream,state)};states.documentTypes=function(type,stream,state){if(type=="word"&&documentTypes.hasOwnProperty(stream.current())){override="tag";return state.context.type}else{return states.atBlock(type,stream,state)}};states.atBlock=function(type,stream,state){if(type=="(")return pushContext(state,stream,"atBlock_parens");if(type=="}"||type==";")return popAndPass(type,stream,state);if(type=="{")return popContext(state)&&pushContext(state,stream,allowNested?"block":"top");if(type=="interpolation")return pushContext(state,stream,"interpolation");if(type=="word"){var word=stream.current().toLowerCase();if(word=="only"||word=="not"||word=="and"||word=="or")
override="keyword";else if(mediaTypes.hasOwnProperty(word))
override="attribute";else if(mediaFeatures.hasOwnProperty(word))
override="property";else if(mediaValueKeywords.hasOwnProperty(word))
override="keyword";else if(propertyKeywords.hasOwnProperty(word))
override="property";else if(nonStandardPropertyKeywords.hasOwnProperty(word))
override=highlightNonStandardPropertyKeywords?"string-2":"property";else if(valueKeywords.hasOwnProperty(word))
override="atom";else if(colorKeywords.hasOwnProperty(word))
override="keyword";else override="error"}
return state.context.type};states.atComponentBlock=function(type,stream,state){if(type=="}")
return popAndPass(type,stream,state);if(type=="{")
return popContext(state)&&pushContext(state,stream,allowNested?"block":"top",!1);if(type=="word")
override="error";return state.context.type};states.atBlock_parens=function(type,stream,state){if(type==")")return popContext(state);if(type=="{"||type=="}")return popAndPass(type,stream,state,2);return states.atBlock(type,stream,state)};states.restricted_atBlock_before=function(type,stream,state){if(type=="{")
return pushContext(state,stream,"restricted_atBlock");if(type=="word"&&state.stateArg=="@counter-style"){override="variable";return"restricted_atBlock_before"}
return pass(type,stream,state)};states.restricted_atBlock=function(type,stream,state){if(type=="}"){state.stateArg=null;return popContext(state)}
if(type=="word"){if((state.stateArg=="@font-face"&&!fontProperties.hasOwnProperty(stream.current().toLowerCase()))||(state.stateArg=="@counter-style"&&!counterDescriptors.hasOwnProperty(stream.current().toLowerCase())))
override="error";else override="property";return"maybeprop"}
return"restricted_atBlock"};states.keyframes=function(type,stream,state){if(type=="word"){override="variable";return"keyframes"}
if(type=="{")return pushContext(state,stream,"top");return pass(type,stream,state)};states.at=function(type,stream,state){if(type==";")return popContext(state);if(type=="{"||type=="}")return popAndPass(type,stream,state);if(type=="word")override="tag";else if(type=="hash")override="builtin";return"at"};states.interpolation=function(type,stream,state){if(type=="}")return popContext(state);if(type=="{"||type==";")return popAndPass(type,stream,state);if(type=="word")override="variable";else if(type!="variable"&&type!="("&&type!=")")override="error";return"interpolation"};return{startState:function(base){return{tokenize:null,state:inline?"block":"top",stateArg:null,context:new Context(inline?"block":"top",base||0,null)}},token:function(stream,state){if(!state.tokenize&&stream.eatSpace())return null;var style=(state.tokenize||tokenBase)(stream,state);if(style&&typeof style=="object"){type=style[1];style=style[0]}
override=style;if(type!="comment")
state.state=states[state.state](type,stream,state);return override},indent:function(state,textAfter){var cx=state.context,ch=textAfter&&textAfter.charAt(0);var indent=cx.indent;if(cx.type=="prop"&&(ch=="}"||ch==")"))cx=cx.prev;if(cx.prev){if(ch=="}"&&(cx.type=="block"||cx.type=="top"||cx.type=="interpolation"||cx.type=="restricted_atBlock")){cx=cx.prev;indent=cx.indent}else if(ch==")"&&(cx.type=="parens"||cx.type=="atBlock_parens")||ch=="{"&&(cx.type=="at"||cx.type=="atBlock")){indent=Math.max(0,cx.indent-indentUnit)}}
return indent},electricChars:"}",blockCommentStart:"/*",blockCommentEnd:"*/",blockCommentContinue:" * ",lineComment:lineComment,fold:"brace"}});function keySet(array){var keys={};for(var i=0;i<array.length;++i){keys[array[i].toLowerCase()]=!0}
return keys}
var documentTypes_=["domain","regexp","url","url-prefix"],documentTypes=keySet(documentTypes_);var mediaTypes_=["all","aural","braille","handheld","print","projection","screen","tty","tv","embossed"],mediaTypes=keySet(mediaTypes_);var mediaFeatures_=["width","min-width","max-width","height","min-height","max-height","device-width","min-device-width","max-device-width","device-height","min-device-height","max-device-height","aspect-ratio","min-aspect-ratio","max-aspect-ratio","device-aspect-ratio","min-device-aspect-ratio","max-device-aspect-ratio","color","min-color","max-color","color-index","min-color-index","max-color-index","monochrome","min-monochrome","max-monochrome","resolution","min-resolution","max-resolution","scan","grid","orientation","device-pixel-ratio","min-device-pixel-ratio","max-device-pixel-ratio","pointer","any-pointer","hover","any-hover","prefers-color-scheme","dynamic-range","video-dynamic-range"],mediaFeatures=keySet(mediaFeatures_);var mediaValueKeywords_=["landscape","portrait","none","coarse","fine","on-demand","hover","interlace","progressive","dark","light","standard","high"],mediaValueKeywords=keySet(mediaValueKeywords_);var propertyKeywords_=["align-content","align-items","align-self","alignment-adjust","alignment-baseline","all","anchor-point","animation","animation-delay","animation-direction","animation-duration","animation-fill-mode","animation-iteration-count","animation-name","animation-play-state","animation-timing-function","appearance","azimuth","backdrop-filter","backface-visibility","background","background-attachment","background-blend-mode","background-clip","background-color","background-image","background-origin","background-position","background-position-x","background-position-y","background-repeat","background-size","baseline-shift","binding","bleed","block-size","bookmark-label","bookmark-level","bookmark-state","bookmark-target","border","border-bottom","border-bottom-color","border-bottom-left-radius","border-bottom-right-radius","border-bottom-style","border-bottom-width","border-collapse","border-color","border-image","border-image-outset","border-image-repeat","border-image-slice","border-image-source","border-image-width","border-left","border-left-color","border-left-style","border-left-width","border-radius","border-right","border-right-color","border-right-style","border-right-width","border-spacing","border-style","border-top","border-top-color","border-top-left-radius","border-top-right-radius","border-top-style","border-top-width","border-width","bottom","box-decoration-break","box-shadow","box-sizing","break-after","break-before","break-inside","caption-side","caret-color","clear","clip","color","color-profile","column-count","column-fill","column-gap","column-rule","column-rule-color","column-rule-style","column-rule-width","column-span","column-width","columns","contain","content","counter-increment","counter-reset","crop","cue","cue-after","cue-before","cursor","direction","display","dominant-baseline","drop-initial-after-adjust","drop-initial-after-align","drop-initial-before-adjust","drop-initial-before-align","drop-initial-size","drop-initial-value","elevation","empty-cells","fit","fit-content","fit-position","flex","flex-basis","flex-direction","flex-flow","flex-grow","flex-shrink","flex-wrap","float","float-offset","flow-from","flow-into","font","font-family","font-feature-settings","font-kerning","font-language-override","font-optical-sizing","font-size","font-size-adjust","font-stretch","font-style","font-synthesis","font-variant","font-variant-alternates","font-variant-caps","font-variant-east-asian","font-variant-ligatures","font-variant-numeric","font-variant-position","font-variation-settings","font-weight","gap","grid","grid-area","grid-auto-columns","grid-auto-flow","grid-auto-rows","grid-column","grid-column-end","grid-column-gap","grid-column-start","grid-gap","grid-row","grid-row-end","grid-row-gap","grid-row-start","grid-template","grid-template-areas","grid-template-columns","grid-template-rows","hanging-punctuation","height","hyphens","icon","image-orientation","image-rendering","image-resolution","inline-box-align","inset","inset-block","inset-block-end","inset-block-start","inset-inline","inset-inline-end","inset-inline-start","isolation","justify-content","justify-items","justify-self","left","letter-spacing","line-break","line-height","line-height-step","line-stacking","line-stacking-ruby","line-stacking-shift","line-stacking-strategy","list-style","list-style-image","list-style-position","list-style-type","margin","margin-bottom","margin-left","margin-right","margin-top","marks","marquee-direction","marquee-loop","marquee-play-count","marquee-speed","marquee-style","mask-clip","mask-composite","mask-image","mask-mode","mask-origin","mask-position","mask-repeat","mask-size","mask-type","max-block-size","max-height","max-inline-size","max-width","min-block-size","min-height","min-inline-size","min-width","mix-blend-mode","move-to","nav-down","nav-index","nav-left","nav-right","nav-up","object-fit","object-position","offset","offset-anchor","offset-distance","offset-path","offset-position","offset-rotate","opacity","order","orphans","outline","outline-color","outline-offset","outline-style","outline-width","overflow","overflow-style","overflow-wrap","overflow-x","overflow-y","padding","padding-bottom","padding-left","padding-right","padding-top","page","page-break-after","page-break-before","page-break-inside","page-policy","pause","pause-after","pause-before","perspective","perspective-origin","pitch","pitch-range","place-content","place-items","place-self","play-during","position","presentation-level","punctuation-trim","quotes","region-break-after","region-break-before","region-break-inside","region-fragment","rendering-intent","resize","rest","rest-after","rest-before","richness","right","rotate","rotation","rotation-point","row-gap","ruby-align","ruby-overhang","ruby-position","ruby-span","scale","scroll-behavior","scroll-margin","scroll-margin-block","scroll-margin-block-end","scroll-margin-block-start","scroll-margin-bottom","scroll-margin-inline","scroll-margin-inline-end","scroll-margin-inline-start","scroll-margin-left","scroll-margin-right","scroll-margin-top","scroll-padding","scroll-padding-block","scroll-padding-block-end","scroll-padding-block-start","scroll-padding-bottom","scroll-padding-inline","scroll-padding-inline-end","scroll-padding-inline-start","scroll-padding-left","scroll-padding-right","scroll-padding-top","scroll-snap-align","scroll-snap-type","shape-image-threshold","shape-inside","shape-margin","shape-outside","size","speak","speak-as","speak-header","speak-numeral","speak-punctuation","speech-rate","stress","string-set","tab-size","table-layout","target","target-name","target-new","target-position","text-align","text-align-last","text-combine-upright","text-decoration","text-decoration-color","text-decoration-line","text-decoration-skip","text-decoration-skip-ink","text-decoration-style","text-emphasis","text-emphasis-color","text-emphasis-position","text-emphasis-style","text-height","text-indent","text-justify","text-orientation","text-outline","text-overflow","text-rendering","text-shadow","text-size-adjust","text-space-collapse","text-transform","text-underline-position","text-wrap","top","touch-action","transform","transform-origin","transform-style","transition","transition-delay","transition-duration","transition-property","transition-timing-function","translate","unicode-bidi","user-select","vertical-align","visibility","voice-balance","voice-duration","voice-family","voice-pitch","voice-range","voice-rate","voice-stress","voice-volume","volume","white-space","widows","width","will-change","word-break","word-spacing","word-wrap","writing-mode","z-index","clip-path","clip-rule","mask","enable-background","filter","flood-color","flood-opacity","lighting-color","stop-color","stop-opacity","pointer-events","color-interpolation","color-interpolation-filters","color-rendering","fill","fill-opacity","fill-rule","image-rendering","marker","marker-end","marker-mid","marker-start","paint-order","shape-rendering","stroke","stroke-dasharray","stroke-dashoffset","stroke-linecap","stroke-linejoin","stroke-miterlimit","stroke-opacity","stroke-width","text-rendering","baseline-shift","dominant-baseline","glyph-orientation-horizontal","glyph-orientation-vertical","text-anchor","writing-mode",],propertyKeywords=keySet(propertyKeywords_);var nonStandardPropertyKeywords_=["accent-color","aspect-ratio","border-block","border-block-color","border-block-end","border-block-end-color","border-block-end-style","border-block-end-width","border-block-start","border-block-start-color","border-block-start-style","border-block-start-width","border-block-style","border-block-width","border-inline","border-inline-color","border-inline-end","border-inline-end-color","border-inline-end-style","border-inline-end-width","border-inline-start","border-inline-start-color","border-inline-start-style","border-inline-start-width","border-inline-style","border-inline-width","content-visibility","margin-block","margin-block-end","margin-block-start","margin-inline","margin-inline-end","margin-inline-start","overflow-anchor","overscroll-behavior","padding-block","padding-block-end","padding-block-start","padding-inline","padding-inline-end","padding-inline-start","scroll-snap-stop","scrollbar-3d-light-color","scrollbar-arrow-color","scrollbar-base-color","scrollbar-dark-shadow-color","scrollbar-face-color","scrollbar-highlight-color","scrollbar-shadow-color","scrollbar-track-color","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","shape-inside","zoom"],nonStandardPropertyKeywords=keySet(nonStandardPropertyKeywords_);var fontProperties_=["font-display","font-family","src","unicode-range","font-variant","font-feature-settings","font-stretch","font-weight","font-style"],fontProperties=keySet(fontProperties_);var counterDescriptors_=["additive-symbols","fallback","negative","pad","prefix","range","speak-as","suffix","symbols","system"],counterDescriptors=keySet(counterDescriptors_);var colorKeywords_=["aliceblue","antiquewhite","aqua","aquamarine","azure","beige","bisque","black","blanchedalmond","blue","blueviolet","brown","burlywood","cadetblue","chartreuse","chocolate","coral","cornflowerblue","cornsilk","crimson","cyan","darkblue","darkcyan","darkgoldenrod","darkgray","darkgreen","darkgrey","darkkhaki","darkmagenta","darkolivegreen","darkorange","darkorchid","darkred","darksalmon","darkseagreen","darkslateblue","darkslategray","darkslategrey","darkturquoise","darkviolet","deeppink","deepskyblue","dimgray","dimgrey","dodgerblue","firebrick","floralwhite","forestgreen","fuchsia","gainsboro","ghostwhite","gold","goldenrod","gray","grey","green","greenyellow","honeydew","hotpink","indianred","indigo","ivory","khaki","lavender","lavenderblush","lawngreen","lemonchiffon","lightblue","lightcoral","lightcyan","lightgoldenrodyellow","lightgray","lightgreen","lightgrey","lightpink","lightsalmon","lightseagreen","lightskyblue","lightslategray","lightslategrey","lightsteelblue","lightyellow","lime","limegreen","linen","magenta","maroon","mediumaquamarine","mediumblue","mediumorchid","mediumpurple","mediumseagreen","mediumslateblue","mediumspringgreen","mediumturquoise","mediumvioletred","midnightblue","mintcream","mistyrose","moccasin","navajowhite","navy","oldlace","olive","olivedrab","orange","orangered","orchid","palegoldenrod","palegreen","paleturquoise","palevioletred","papayawhip","peachpuff","peru","pink","plum","powderblue","purple","rebeccapurple","red","rosybrown","royalblue","saddlebrown","salmon","sandybrown","seagreen","seashell","sienna","silver","skyblue","slateblue","slategray","slategrey","snow","springgreen","steelblue","tan","teal","thistle","tomato","turquoise","violet","wheat","white","whitesmoke","yellow","yellowgreen"],colorKeywords=keySet(colorKeywords_);var valueKeywords_=["above","absolute","activeborder","additive","activecaption","afar","after-white-space","ahead","alias","all","all-scroll","alphabetic","alternate","always","amharic","amharic-abegede","antialiased","appworkspace","arabic-indic","armenian","asterisks","attr","auto","auto-flow","avoid","avoid-column","avoid-page","avoid-region","axis-pan","background","backwards","baseline","below","bidi-override","binary","bengali","blink","block","block-axis","blur","bold","bolder","border","border-box","both","bottom","break","break-all","break-word","brightness","bullets","button","buttonface","buttonhighlight","buttonshadow","buttontext","calc","cambodian","capitalize","caps-lock-indicator","caption","captiontext","caret","cell","center","checkbox","circle","cjk-decimal","cjk-earthly-branch","cjk-heavenly-stem","cjk-ideographic","clear","clip","close-quote","col-resize","collapse","color","color-burn","color-dodge","column","column-reverse","compact","condensed","conic-gradient","contain","content","contents","content-box","context-menu","continuous","contrast","copy","counter","counters","cover","crop","cross","crosshair","cubic-bezier","currentcolor","cursive","cyclic","darken","dashed","decimal","decimal-leading-zero","default","default-button","dense","destination-atop","destination-in","destination-out","destination-over","devanagari","difference","disc","discard","disclosure-closed","disclosure-open","document","dot-dash","dot-dot-dash","dotted","double","down","drop-shadow","e-resize","ease","ease-in","ease-in-out","ease-out","element","ellipse","ellipsis","embed","end","ethiopic","ethiopic-abegede","ethiopic-abegede-am-et","ethiopic-abegede-gez","ethiopic-abegede-ti-er","ethiopic-abegede-ti-et","ethiopic-halehame-aa-er","ethiopic-halehame-aa-et","ethiopic-halehame-am-et","ethiopic-halehame-gez","ethiopic-halehame-om-et","ethiopic-halehame-sid-et","ethiopic-halehame-so-et","ethiopic-halehame-ti-er","ethiopic-halehame-ti-et","ethiopic-halehame-tig","ethiopic-numeric","ew-resize","exclusion","expanded","extends","extra-condensed","extra-expanded","fantasy","fast","fill","fill-box","fixed","flat","flex","flex-end","flex-start","footnotes","forwards","from","geometricPrecision","georgian","grayscale","graytext","grid","groove","gujarati","gurmukhi","hand","hangul","hangul-consonant","hard-light","hebrew","help","hidden","hide","higher","highlight","highlighttext","hiragana","hiragana-iroha","horizontal","hsl","hsla","hue","hue-rotate","icon","ignore","inactiveborder","inactivecaption","inactivecaptiontext","infinite","infobackground","infotext","inherit","initial","inline","inline-axis","inline-block","inline-flex","inline-grid","inline-table","inset","inside","intrinsic","invert","italic","japanese-formal","japanese-informal","justify","kannada","katakana","katakana-iroha","keep-all","khmer","korean-hangul-formal","korean-hanja-formal","korean-hanja-informal","landscape","lao","large","larger","left","level","lighter","lighten","line-through","linear","linear-gradient","lines","list-item","listbox","listitem","local","logical","loud","lower","lower-alpha","lower-armenian","lower-greek","lower-hexadecimal","lower-latin","lower-norwegian","lower-roman","lowercase","ltr","luminosity","malayalam","manipulation","match","matrix","matrix3d","media-play-button","media-slider","media-sliderthumb","media-volume-slider","media-volume-sliderthumb","medium","menu","menulist","menulist-button","menutext","message-box","middle","min-intrinsic","mix","mongolian","monospace","move","multiple","multiple_mask_images","multiply","myanmar","n-resize","narrower","ne-resize","nesw-resize","no-close-quote","no-drop","no-open-quote","no-repeat","none","normal","not-allowed","nowrap","ns-resize","numbers","numeric","nw-resize","nwse-resize","oblique","octal","opacity","open-quote","optimizeLegibility","optimizeSpeed","oriya","oromo","outset","outside","outside-shape","overlay","overline","padding","padding-box","painted","page","paused","persian","perspective","pinch-zoom","plus-darker","plus-lighter","pointer","polygon","portrait","pre","pre-line","pre-wrap","preserve-3d","progress","push-button","radial-gradient","radio","read-only","read-write","read-write-plaintext-only","rectangle","region","relative","repeat","repeating-linear-gradient","repeating-radial-gradient","repeating-conic-gradient","repeat-x","repeat-y","reset","reverse","rgb","rgba","ridge","right","rotate","rotate3d","rotateX","rotateY","rotateZ","round","row","row-resize","row-reverse","rtl","run-in","running","s-resize","sans-serif","saturate","saturation","scale","scale3d","scaleX","scaleY","scaleZ","screen","scroll","scrollbar","scroll-position","se-resize","searchfield","searchfield-cancel-button","searchfield-decoration","searchfield-results-button","searchfield-results-decoration","self-start","self-end","semi-condensed","semi-expanded","separate","sepia","serif","show","sidama","simp-chinese-formal","simp-chinese-informal","single","skew","skewX","skewY","skip-white-space","slide","slider-horizontal","slider-vertical","sliderthumb-horizontal","sliderthumb-vertical","slow","small","small-caps","small-caption","smaller","soft-light","solid","somali","source-atop","source-in","source-out","source-over","space","space-around","space-between","space-evenly","spell-out","square","square-button","start","static","status-bar","stretch","stroke","stroke-box","sub","subpixel-antialiased","svg_masks","super","sw-resize","symbolic","symbols","system-ui","table","table-caption","table-cell","table-column","table-column-group","table-footer-group","table-header-group","table-row","table-row-group","tamil","telugu","text","text-bottom","text-top","textarea","textfield","thai","thick","thin","threeddarkshadow","threedface","threedhighlight","threedlightshadow","threedshadow","tibetan","tigre","tigrinya-er","tigrinya-er-abegede","tigrinya-et","tigrinya-et-abegede","to","top","trad-chinese-formal","trad-chinese-informal","transform","translate","translate3d","translateX","translateY","translateZ","transparent","ultra-condensed","ultra-expanded","underline","unidirectional-pan","unset","up","upper-alpha","upper-armenian","upper-greek","upper-hexadecimal","upper-latin","upper-norwegian","upper-roman","uppercase","urdu","url","var","vertical","vertical-text","view-box","visible","visibleFill","visiblePainted","visibleStroke","visual","w-resize","wait","wave","wider","window","windowframe","windowtext","words","wrap","wrap-reverse","x-large","x-small","xor","xx-large","xx-small"],valueKeywords=keySet(valueKeywords_);var allWords=documentTypes_.concat(mediaTypes_).concat(mediaFeatures_).concat(mediaValueKeywords_).concat(propertyKeywords_).concat(nonStandardPropertyKeywords_).concat(colorKeywords_).concat(valueKeywords_);CodeMirror.registerHelper("hintWords","css",allWords);function tokenCComment(stream,state){var maybeEnd=!1,ch;while((ch=stream.next())!=null){if(maybeEnd&&ch=="/"){state.tokenize=null;break}
maybeEnd=(ch=="*")}
return["comment","comment"]}
CodeMirror.defineMIME("text/css",{documentTypes:documentTypes,mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,fontProperties:fontProperties,counterDescriptors:counterDescriptors,colorKeywords:colorKeywords,valueKeywords:valueKeywords,tokenHooks:{"/":function(stream,state){if(!stream.eat("*"))return!1;state.tokenize=tokenCComment;return tokenCComment(stream,state)}},name:"css"});CodeMirror.defineMIME("text/x-scss",{mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,colorKeywords:colorKeywords,valueKeywords:valueKeywords,fontProperties:fontProperties,allowNested:!0,lineComment:"//",tokenHooks:{"/":function(stream,state){if(stream.eat("/")){stream.skipToEnd();return["comment","comment"]}else if(stream.eat("*")){state.tokenize=tokenCComment;return tokenCComment(stream,state)}else{return["operator","operator"]}},":":function(stream){if(stream.match(/^\s*\{/,!1))
return[null,null]
return!1},"$":function(stream){stream.match(/^[\w-]+/);if(stream.match(/^\s*:/,!1))
return["variable-2","variable-definition"];return["variable-2","variable"]},"#":function(stream){if(!stream.eat("{"))return!1;return[null,"interpolation"]}},name:"css",helperType:"scss"});CodeMirror.defineMIME("text/x-less",{mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,mediaValueKeywords:mediaValueKeywords,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,colorKeywords:colorKeywords,valueKeywords:valueKeywords,fontProperties:fontProperties,allowNested:!0,lineComment:"//",tokenHooks:{"/":function(stream,state){if(stream.eat("/")){stream.skipToEnd();return["comment","comment"]}else if(stream.eat("*")){state.tokenize=tokenCComment;return tokenCComment(stream,state)}else{return["operator","operator"]}},"@":function(stream){if(stream.eat("{"))return[null,"interpolation"];if(stream.match(/^(charset|document|font-face|import|(-(moz|ms|o|webkit)-)?keyframes|media|namespace|page|supports)\b/i,!1))return!1;stream.eatWhile(/[\w\\\-]/);if(stream.match(/^\s*:/,!1))
return["variable-2","variable-definition"];return["variable-2","variable"]},"&":function(){return["atom","atom"]}},name:"css",helperType:"less"});CodeMirror.defineMIME("text/x-gss",{documentTypes:documentTypes,mediaTypes:mediaTypes,mediaFeatures:mediaFeatures,propertyKeywords:propertyKeywords,nonStandardPropertyKeywords:nonStandardPropertyKeywords,fontProperties:fontProperties,counterDescriptors:counterDescriptors,colorKeywords:colorKeywords,valueKeywords:valueKeywords,supportsAtComponent:!0,tokenHooks:{"/":function(stream,state){if(!stream.eat("*"))return!1;state.tokenize=tokenCComment;return tokenCComment(stream,state)}},name:"css",helperType:"gss"})});/*!
 * jQuery Cookie Plugin v1.4.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */
(function(factory){if(typeof define==='function'&&define.amd){define(['jquery'],factory)}else if(typeof exports==='object'){factory(require('jquery'))}else{factory(jQuery)}}(function($){var pluses=/\+/g;function encode(s){return config.raw?s:encodeURIComponent(s)}
function decode(s){return config.raw?s:decodeURIComponent(s)}
function stringifyCookieValue(value){return encode(config.json?JSON.stringify(value):String(value))}
function parseCookieValue(s){if(s.indexOf('"')===0){s=s.slice(1,-1).replace(/\\"/g,'"').replace(/\\\\/g,'\\')}
try{s=decodeURIComponent(s.replace(pluses,' '));return config.json?JSON.parse(s):s}catch(e){}}
function read(s,converter){var value=config.raw?s:parseCookieValue(s);return $.isFunction(converter)?converter(value):value}
var config=$.cookie=function(key,value,options){if(value!==undefined&&!$.isFunction(value)){options=$.extend({},config.defaults,options);if(typeof options.expires==='number'){var days=options.expires,t=options.expires=new Date();t.setTime(+t+days*864e+5)}
return(document.cookie=[encode(key),'=',stringifyCookieValue(value),options.expires?'; expires='+options.expires.toUTCString():'',options.path?'; path='+options.path:'',options.domain?'; domain='+options.domain:'',options.secure?'; secure':''].join(''))}
var result=key?undefined:{};var cookies=document.cookie?document.cookie.split('; '):[];for(var i=0,l=cookies.length;i<l;i++){var parts=cookies[i].split('=');var name=decode(parts.shift());var cookie=parts.join('=');if(key&&key===name){result=read(cookie,value);break}
if(!key&&(cookie=read(cookie))!==undefined){result[name]=cookie}}
return result};config.defaults={};$.removeCookie=function(key,options){if($.cookie(key)===undefined){return!1}
$.cookie(key,'',$.extend({},options,{expires:-1}));return!$.cookie(key)}}));(function(){var root=this;if(typeof Math.sgn=="undefined"){Math.sgn=function(x){return x==0?0:x>0?1:-1}}
var Vectors={subtract:function(v1,v2){return{x:v1.x-v2.x,y:v1.y-v2.y}},dotProduct:function(v1,v2){return(v1.x*v2.x)+(v1.y*v2.y)},square:function(v){return Math.sqrt((v.x*v.x)+(v.y*v.y))},scale:function(v,s){return{x:v.x*s,y:v.y*s}}},maxRecursion=64,flatnessTolerance=Math.pow(2.0,-maxRecursion-1);var _distanceFromCurve=function(point,curve){var candidates=[],w=_convertToBezier(point,curve),degree=curve.length-1,higherDegree=(2*degree)-1,numSolutions=_findRoots(w,higherDegree,candidates,0),v=Vectors.subtract(point,curve[0]),dist=Vectors.square(v),t=0.0;for(var i=0;i<numSolutions;i++){v=Vectors.subtract(point,_bezier(curve,degree,candidates[i],null,null));var newDist=Vectors.square(v);if(newDist<dist){dist=newDist;t=candidates[i]}}
v=Vectors.subtract(point,curve[degree]);newDist=Vectors.square(v);if(newDist<dist){dist=newDist;t=1.0}
return{location:t,distance:dist}};var _nearestPointOnCurve=function(point,curve){var td=_distanceFromCurve(point,curve);return{point:_bezier(curve,curve.length-1,td.location,null,null),location:td.location}};var _convertToBezier=function(point,curve){var degree=curve.length-1,higherDegree=(2*degree)-1,c=[],d=[],cdTable=[],w=[],z=[[1.0,0.6,0.3,0.1],[0.4,0.6,0.6,0.4],[0.1,0.3,0.6,1.0]];for(var i=0;i<=degree;i++)c[i]=Vectors.subtract(curve[i],point);for(var i=0;i<=degree-1;i++){d[i]=Vectors.subtract(curve[i+1],curve[i]);d[i]=Vectors.scale(d[i],3.0)}
for(var row=0;row<=degree-1;row++){for(var column=0;column<=degree;column++){if(!cdTable[row])cdTable[row]=[];cdTable[row][column]=Vectors.dotProduct(d[row],c[column])}}
for(i=0;i<=higherDegree;i++){if(!w[i])w[i]=[];w[i].y=0.0;w[i].x=parseFloat(i)/higherDegree}
var n=degree,m=degree-1;for(var k=0;k<=n+m;k++){var lb=Math.max(0,k-m),ub=Math.min(k,n);for(i=lb;i<=ub;i++){var j=k-i;w[i+j].y+=cdTable[j][i]*z[j][i]}}
return w};var _findRoots=function(w,degree,t,depth){var left=[],right=[],left_count,right_count,left_t=[],right_t=[];switch(_getCrossingCount(w,degree)){case 0:{return 0}
case 1:{if(depth>=maxRecursion){t[0]=(w[0].x+w[degree].x)/2.0;return 1}
if(_isFlatEnough(w,degree)){t[0]=_computeXIntercept(w,degree);return 1}
break}}
_bezier(w,degree,0.5,left,right);left_count=_findRoots(left,degree,left_t,depth+1);right_count=_findRoots(right,degree,right_t,depth+1);for(var i=0;i<left_count;i++)t[i]=left_t[i];for(var i=0;i<right_count;i++)t[i+left_count]=right_t[i];return(left_count+right_count)};var _getCrossingCount=function(curve,degree){var n_crossings=0,sign,old_sign;sign=old_sign=Math.sgn(curve[0].y);for(var i=1;i<=degree;i++){sign=Math.sgn(curve[i].y);if(sign!=old_sign)n_crossings++;old_sign=sign}
return n_crossings};var _isFlatEnough=function(curve,degree){var error,intercept_1,intercept_2,left_intercept,right_intercept,a,b,c,det,dInv,a1,b1,c1,a2,b2,c2;a=curve[0].y-curve[degree].y;b=curve[degree].x-curve[0].x;c=curve[0].x*curve[degree].y-curve[degree].x*curve[0].y;var max_distance_above,max_distance_below;max_distance_above=max_distance_below=0.0;for(var i=1;i<degree;i++){var value=a*curve[i].x+b*curve[i].y+c;if(value>max_distance_above)
max_distance_above=value;else if(value<max_distance_below)
max_distance_below=value}
a1=0.0;b1=1.0;c1=0.0;a2=a;b2=b;c2=c-max_distance_above;det=a1*b2-a2*b1;dInv=1.0/det;intercept_1=(b1*c2-b2*c1)*dInv;a2=a;b2=b;c2=c-max_distance_below;det=a1*b2-a2*b1;dInv=1.0/det;intercept_2=(b1*c2-b2*c1)*dInv;left_intercept=Math.min(intercept_1,intercept_2);right_intercept=Math.max(intercept_1,intercept_2);error=right_intercept-left_intercept;return(error<flatnessTolerance)?1:0};var _computeXIntercept=function(curve,degree){var XLK=1.0,YLK=0.0,XNM=curve[degree].x-curve[0].x,YNM=curve[degree].y-curve[0].y,XMK=curve[0].x-0.0,YMK=curve[0].y-0.0,det=XNM*YLK-YNM*XLK,detInv=1.0/det,S=(XNM*YMK-YNM*XMK)*detInv;return 0.0+XLK*S};var _bezier=function(curve,degree,t,left,right){var temp=[[]];for(var j=0;j<=degree;j++)temp[0][j]=curve[j];for(var i=1;i<=degree;i++){for(var j=0;j<=degree-i;j++){if(!temp[i])temp[i]=[];if(!temp[i][j])temp[i][j]={};temp[i][j].x=(1.0-t)*temp[i-1][j].x+t*temp[i-1][j+1].x;temp[i][j].y=(1.0-t)*temp[i-1][j].y+t*temp[i-1][j+1].y}}
if(left!=null)
for(j=0;j<=degree;j++)left[j]=temp[j][0];if(right!=null)
for(j=0;j<=degree;j++)right[j]=temp[degree-j][j];return(temp[degree][0])};var _curveFunctionCache={};var _getCurveFunctions=function(order){var fns=_curveFunctionCache[order];if(!fns){fns=[];var f_term=function(){return function(t){return Math.pow(t,order)}},l_term=function(){return function(t){return Math.pow((1-t),order)}},c_term=function(c){return function(t){return c}},t_term=function(){return function(t){return t}},one_minus_t_term=function(){return function(t){return 1-t}},_termFunc=function(terms){return function(t){var p=1;for(var i=0;i<terms.length;i++)p=p*terms[i](t);return p}};fns.push(new f_term());for(var i=1;i<order;i++){var terms=[new c_term(order)];for(var j=0;j<(order-i);j++)terms.push(new t_term());for(var j=0;j<i;j++)terms.push(new one_minus_t_term());fns.push(new _termFunc(terms))}
fns.push(new l_term());_curveFunctionCache[order]=fns}
return fns};var _pointOnPath=function(curve,location){var cc=_getCurveFunctions(curve.length-1),_x=0,_y=0;for(var i=0;i<curve.length;i++){_x=_x+(curve[i].x*cc[i](location));_y=_y+(curve[i].y*cc[i](location))}
return{x:_x,y:_y}};var _dist=function(p1,p2){return Math.sqrt(Math.pow(p1.x-p2.x,2)+Math.pow(p1.y-p2.y,2))};var _isPoint=function(curve){return curve[0].x===curve[1].x&&curve[0].y===curve[1].y};var _pointAlongPath=function(curve,location,distance){if(_isPoint(curve)){return{point:curve[0],location:location}}
var prev=_pointOnPath(curve,location),tally=0,curLoc=location,direction=distance>0?1:-1,cur=null;while(tally<Math.abs(distance)){curLoc+=(0.005*direction);cur=_pointOnPath(curve,curLoc);tally+=_dist(cur,prev);prev=cur}
return{point:cur,location:curLoc}};var _length=function(curve){var d=new Date().getTime();if(_isPoint(curve))return 0;var prev=_pointOnPath(curve,0),tally=0,curLoc=0,direction=1,cur=null;while(curLoc<1){curLoc+=(0.005*direction);cur=_pointOnPath(curve,curLoc);tally+=_dist(cur,prev);prev=cur}
console.log("length",new Date().getTime()-d);return tally};var _pointAlongPathFrom=function(curve,location,distance){return _pointAlongPath(curve,location,distance).point};var _locationAlongPathFrom=function(curve,location,distance){return _pointAlongPath(curve,location,distance).location};var _gradientAtPoint=function(curve,location){var p1=_pointOnPath(curve,location),p2=_pointOnPath(curve.slice(0,curve.length-1),location),dy=p2.y-p1.y,dx=p2.x-p1.x;return dy===0?Infinity:Math.atan(dy/dx)};var _gradientAtPointAlongPathFrom=function(curve,location,distance){var p=_pointAlongPath(curve,location,distance);if(p.location>1)p.location=1;if(p.location<0)p.location=0;return _gradientAtPoint(curve,p.location)};var _perpendicularToPathAt=function(curve,location,length,distance){distance=distance==null?0:distance;var p=_pointAlongPath(curve,location,distance),m=_gradientAtPoint(curve,p.location),_theta2=Math.atan(-1/m),y=length/2*Math.sin(_theta2),x=length/2*Math.cos(_theta2);return[{x:p.point.x+x,y:p.point.y+y},{x:p.point.x-x,y:p.point.y-y}]};var _lineIntersection=function(x1,y1,x2,y2,curve){var a=y2-y1,b=x1-x2,c=(x1*(y1-y2))+(y1*(x2-x1)),coeffs=_computeCoefficients(curve),p=[(a*coeffs[0][0])+(b*coeffs[1][0]),(a*coeffs[0][1])+(b*coeffs[1][1]),(a*coeffs[0][2])+(b*coeffs[1][2]),(a*coeffs[0][3])+(b*coeffs[1][3])+c],r=_cubicRoots.apply(null,p),intersections=[];if(r!=null){for(var i=0;i<3;i++){var t=r[i],t2=Math.pow(t,2),t3=Math.pow(t,3),x=[(coeffs[0][0]*t3)+(coeffs[0][1]*t2)+(coeffs[0][2]*t)+coeffs[0][3],(coeffs[1][0]*t3)+(coeffs[1][1]*t2)+(coeffs[1][2]*t)+coeffs[1][3]];var s;if((x2-x1)!==0){s=(x[0]-x1)/(x2-x1)}else{s=(x[1]-y1)/(y2-y1)}
if(t>=0&&t<=1.0&&s>=0&&s<=1.0){intersections.push(x)}}}
return intersections};var _boxIntersection=function(x,y,w,h,curve){var i=[];i.push.apply(i,_lineIntersection(x,y,x+w,y,curve));i.push.apply(i,_lineIntersection(x+w,y,x+w,y+h,curve));i.push.apply(i,_lineIntersection(x+w,y+h,x,y+h,curve));i.push.apply(i,_lineIntersection(x,y+h,x,y,curve));return i};var _boundingBoxIntersection=function(boundingBox,curve){var i=[];i.push.apply(i,_lineIntersection(boundingBox.x,boundingBox.y,boundingBox.x+boundingBox.w,boundingBox.y,curve));i.push.apply(i,_lineIntersection(boundingBox.x+boundingBox.w,boundingBox.y,boundingBox.x+boundingBox.w,boundingBox.y+boundingBox.h,curve));i.push.apply(i,_lineIntersection(boundingBox.x+boundingBox.w,boundingBox.y+boundingBox.h,boundingBox.x,boundingBox.y+boundingBox.h,curve));i.push.apply(i,_lineIntersection(boundingBox.x,boundingBox.y+boundingBox.h,boundingBox.x,boundingBox.y,curve));return i};function _computeCoefficientsForAxis(curve,axis){return[-(curve[0][axis])+(3*curve[1][axis])+(-3*curve[2][axis])+curve[3][axis],(3*(curve[0][axis]))-(6*(curve[1][axis]))+(3*(curve[2][axis])),-3*curve[0][axis]+3*curve[1][axis],curve[0][axis]]}
function _computeCoefficients(curve){return[_computeCoefficientsForAxis(curve,"x"),_computeCoefficientsForAxis(curve,"y")]}
function sgn(x){return x<0?-1:x>0?1:0}
function _cubicRoots(a,b,c,d){var A=b/a,B=c/a,C=d/a,Q=(3*B-Math.pow(A,2))/9,R=(9*A*B-27*C-2*Math.pow(A,3))/54,D=Math.pow(Q,3)+Math.pow(R,2),S,T,t=[];if(D>=0){S=sgn(R+Math.sqrt(D))*Math.pow(Math.abs(R+Math.sqrt(D)),(1/3));T=sgn(R-Math.sqrt(D))*Math.pow(Math.abs(R-Math.sqrt(D)),(1/3));t[0]=-A/3+(S+T);t[1]=-A/3-(S+T)/2;t[2]=-A/3-(S+T)/2;if(Math.abs(Math.sqrt(3)*(S-T)/2)!==0){t[1]=-1;t[2]=-1}}else{var th=Math.acos(R/Math.sqrt(-Math.pow(Q,3)));t[0]=2*Math.sqrt(-Q)*Math.cos(th/3)-A/3;t[1]=2*Math.sqrt(-Q)*Math.cos((th+2*Math.PI)/3)-A/3;t[2]=2*Math.sqrt(-Q)*Math.cos((th+4*Math.PI)/3)-A/3}
for(var i=0;i<3;i++){if(t[i]<0||t[i]>1.0){t[i]=-1}}
return t}
var jsBezier=this.jsBezier={distanceFromCurve:_distanceFromCurve,gradientAtPoint:_gradientAtPoint,gradientAtPointAlongCurveFrom:_gradientAtPointAlongPathFrom,nearestPointOnCurve:_nearestPointOnCurve,pointOnCurve:_pointOnPath,pointAlongCurveFrom:_pointAlongPathFrom,perpendicularToCurveAt:_perpendicularToPathAt,locationAlongCurveFrom:_locationAlongPathFrom,getLength:_length,lineIntersection:_lineIntersection,boxIntersection:_boxIntersection,boundingBoxIntersection:_boundingBoxIntersection,version:"0.9.0"};if(typeof exports!=="undefined"){exports.jsBezier=jsBezier}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;var Biltong=root.Biltong={version:"0.4.0"};if(typeof exports!=="undefined"){exports.Biltong=Biltong}
var _isa=function(a){return Object.prototype.toString.call(a)==="[object Array]"},_pointHelper=function(p1,p2,fn){p1=_isa(p1)?p1:[p1.x,p1.y];p2=_isa(p2)?p2:[p2.x,p2.y];return fn(p1,p2)},_gradient=Biltong.gradient=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){if(_p2[0]==_p1[0])
return _p2[1]>_p1[1]?Infinity:-Infinity;else if(_p2[1]==_p1[1])
return _p2[0]>_p1[0]?0:-0;else return(_p2[1]-_p1[1])/(_p2[0]-_p1[0])})},_normal=Biltong.normal=function(p1,p2){return-1/_gradient(p1,p2)},_lineLength=Biltong.lineLength=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){return Math.sqrt(Math.pow(_p2[1]-_p1[1],2)+Math.pow(_p2[0]-_p1[0],2))})},_quadrant=Biltong.quadrant=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){if(_p2[0]>_p1[0]){return(_p2[1]>_p1[1])?2:1}else if(_p2[0]==_p1[0]){return _p2[1]>_p1[1]?2:1}else{return(_p2[1]>_p1[1])?3:4}})},_theta=Biltong.theta=function(p1,p2){return _pointHelper(p1,p2,function(_p1,_p2){var m=_gradient(_p1,_p2),t=Math.atan(m),s=_quadrant(_p1,_p2);if((s==4||s==3))t+=Math.PI;if(t<0)t+=(2*Math.PI);return t})},_intersects=Biltong.intersects=function(r1,r2){var x1=r1.x,x2=r1.x+r1.w,y1=r1.y,y2=r1.y+r1.h,a1=r2.x,a2=r2.x+r2.w,b1=r2.y,b2=r2.y+r2.h;return((x1<=a1&&a1<=x2)&&(y1<=b1&&b1<=y2))||((x1<=a2&&a2<=x2)&&(y1<=b1&&b1<=y2))||((x1<=a1&&a1<=x2)&&(y1<=b2&&b2<=y2))||((x1<=a2&&a1<=x2)&&(y1<=b2&&b2<=y2))||((a1<=x1&&x1<=a2)&&(b1<=y1&&y1<=b2))||((a1<=x2&&x2<=a2)&&(b1<=y1&&y1<=b2))||((a1<=x1&&x1<=a2)&&(b1<=y2&&y2<=b2))||((a1<=x2&&x1<=a2)&&(b1<=y2&&y2<=b2))},_encloses=Biltong.encloses=function(r1,r2,allowSharedEdges){var x1=r1.x,x2=r1.x+r1.w,y1=r1.y,y2=r1.y+r1.h,a1=r2.x,a2=r2.x+r2.w,b1=r2.y,b2=r2.y+r2.h,c=function(v1,v2,v3,v4){return allowSharedEdges?v1<=v2&&v3>=v4:v1<v2&&v3>v4};return c(x1,a1,x2,a2)&&c(y1,b1,y2,b2)},_segmentMultipliers=[null,[1,-1],[1,1],[-1,1],[-1,-1]],_inverseSegmentMultipliers=[null,[-1,-1],[-1,1],[1,1],[1,-1]],_pointOnLine=Biltong.pointOnLine=function(fromPoint,toPoint,distance){var m=_gradient(fromPoint,toPoint),s=_quadrant(fromPoint,toPoint),segmentMultiplier=distance>0?_segmentMultipliers[s]:_inverseSegmentMultipliers[s],theta=Math.atan(m),y=Math.abs(distance*Math.sin(theta))*segmentMultiplier[1],x=Math.abs(distance*Math.cos(theta))*segmentMultiplier[0];return{x:fromPoint.x+x,y:fromPoint.y+y}},_perpendicularLineTo=Biltong.perpendicularLineTo=function(fromPoint,toPoint,length){var m=_gradient(fromPoint,toPoint),theta2=Math.atan(-1/m),y=length/2*Math.sin(theta2),x=length/2*Math.cos(theta2);return[{x:toPoint.x+x,y:toPoint.y+y},{x:toPoint.x-x,y:toPoint.y-y}]}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";function _touch(view,target,pageX,pageY,screenX,screenY,clientX,clientY){return new Touch({target:target,identifier:_uuid(),pageX:pageX,pageY:pageY,screenX:screenX,screenY:screenY,clientX:clientX||screenX,clientY:clientY||screenY})}
function _touchList(){var list=[];Array.prototype.push.apply(list,arguments);list.item=function(index){return this[index]};return list}
function _touchAndList(view,target,pageX,pageY,screenX,screenY,clientX,clientY){return _touchList(_touch.apply(null,arguments))}
var root=this,matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el){return!0}}
return!1},_gel=function(el){return(typeof el=="string"||el.constructor===String)?document.getElementById(el):el},_t=function(e){return e.srcElement||e.target},_pi=function(e,target,obj,doCompute){if(!doCompute)return{path:[target],end:1};else if(typeof e.path!=="undefined"&&e.path.indexOf){return{path:e.path,end:e.path.indexOf(obj)}}else{var out={path:[],end:-1},_one=function(el){out.path.push(el);if(el===obj){out.end=out.path.length-1}else if(el.parentNode!=null){_one(el.parentNode)}};_one(target);return out}},_d=function(l,fn){for(var i=0,j=l.length;i<j;i++){if(l[i]==fn)break}
if(i<l.length)l.splice(i,1);},guid=1,_store=function(obj,event,fn){var g=guid++;obj.__ta=obj.__ta||{};obj.__ta[event]=obj.__ta[event]||{};obj.__ta[event][g]=fn;fn.__tauid=g;return g},_unstore=function(obj,event,fn){obj.__ta&&obj.__ta[event]&&delete obj.__ta[event][fn.__tauid];if(fn.__taExtra){for(var i=0;i<fn.__taExtra.length;i++){_unbind(obj,fn.__taExtra[i][0],fn.__taExtra[i][1])}
fn.__taExtra.length=0}
fn.__taUnstore&&fn.__taUnstore()},_curryChildFilter=function(children,obj,fn,evt){if(children==null)return fn;else{var c=children.split(","),_fn=function(e){_fn.__tauid=fn.__tauid;var t=_t(e),target=t;var pathInfo=_pi(e,t,obj,children!=null)
if(pathInfo.end!=-1){for(var p=0;p<pathInfo.end;p++){target=pathInfo.path[p];for(var i=0;i<c.length;i++){if(matchesSelector(target,c[i],obj)){fn.apply(target,arguments)}}}}};registerExtraFunction(fn,evt,_fn);return _fn}},registerExtraFunction=function(fn,evt,newFn){fn.__taExtra=fn.__taExtra||[];fn.__taExtra.push([evt,newFn])},DefaultHandler=function(obj,evt,fn,children){if(isTouchDevice&&touchMap[evt]){var tfn=_curryChildFilter(children,obj,fn,touchMap[evt]);_bind(obj,touchMap[evt],tfn,fn)}
if(evt==="focus"&&obj.getAttribute("tabindex")==null){obj.setAttribute("tabindex","1")}
_bind(obj,evt,_curryChildFilter(children,obj,fn,evt),fn)},SmartClickHandler=function(obj,evt,fn,children){if(obj.__taSmartClicks==null){var down=function(e){obj.__tad=_pageLocation(e)},up=function(e){obj.__tau=_pageLocation(e)},click=function(e){if(obj.__tad&&obj.__tau&&obj.__tad[0]===obj.__tau[0]&&obj.__tad[1]===obj.__tau[1]){for(var i=0;i<obj.__taSmartClicks.length;i++)
obj.__taSmartClicks[i].apply(_t(e),[e]);}};DefaultHandler(obj,"mousedown",down,children);DefaultHandler(obj,"mouseup",up,children);DefaultHandler(obj,"click",click,children);obj.__taSmartClicks=[]}
obj.__taSmartClicks.push(fn);fn.__taUnstore=function(){_d(obj.__taSmartClicks,fn)}},_tapProfiles={"tap":{touches:1,taps:1},"dbltap":{touches:1,taps:2},"contextmenu":{touches:2,taps:1}},TapHandler=function(clickThreshold,dblClickThreshold){return function(obj,evt,fn,children){if(evt=="contextmenu"&&isMouseDevice)
DefaultHandler(obj,evt,fn,children);else{if(obj.__taTapHandler==null){var tt=obj.__taTapHandler={tap:[],dbltap:[],contextmenu:[],down:!1,taps:0,downSelectors:[]};var down=function(e){var target=_t(e),pathInfo=_pi(e,target,obj,children!=null),finished=!1;for(var p=0;p<pathInfo.end;p++){if(finished)return;target=pathInfo.path[p];for(var i=0;i<tt.downSelectors.length;i++){if(tt.downSelectors[i]==null||matchesSelector(target,tt.downSelectors[i],obj)){tt.down=!0;setTimeout(clearSingle,clickThreshold);setTimeout(clearDouble,dblClickThreshold);finished=!0;break}}}},up=function(e){if(tt.down){var target=_t(e),currentTarget,pathInfo;tt.taps++;var tc=_touchCount(e);for(var eventId in _tapProfiles){if(_tapProfiles.hasOwnProperty(eventId)){var p=_tapProfiles[eventId];if(p.touches===tc&&(p.taps===1||p.taps===tt.taps)){for(var i=0;i<tt[eventId].length;i++){pathInfo=_pi(e,target,obj,tt[eventId][i][1]!=null);for(var pLoop=0;pLoop<pathInfo.end;pLoop++){currentTarget=pathInfo.path[pLoop];if(tt[eventId][i][1]==null||matchesSelector(currentTarget,tt[eventId][i][1],obj)){tt[eventId][i][0].apply(currentTarget,[e]);break}}}}}}}},clearSingle=function(){tt.down=!1},clearDouble=function(){tt.taps=0};DefaultHandler(obj,"mousedown",down);DefaultHandler(obj,"mouseup",up)}
obj.__taTapHandler.downSelectors.push(children);obj.__taTapHandler[evt].push([fn,children]);fn.__taUnstore=function(){_d(obj.__taTapHandler[evt],fn)}}}},meeHelper=function(type,evt,obj,target){for(var i in obj.__tamee[type]){if(obj.__tamee[type].hasOwnProperty(i)){obj.__tamee[type][i].apply(target,[evt])}}},MouseEnterExitHandler=function(){var activeElements=[];return function(obj,evt,fn,children){if(!obj.__tamee){obj.__tamee={over:!1,mouseenter:[],mouseexit:[]};var over=function(e){var t=_t(e);if((children==null&&(t==obj&&!obj.__tamee.over))||(matchesSelector(t,children,obj)&&(t.__tamee==null||!t.__tamee.over))){meeHelper("mouseenter",e,obj,t);t.__tamee=t.__tamee||{};t.__tamee.over=!0;activeElements.push(t)}},out=function(e){var t=_t(e);for(var i=0;i<activeElements.length;i++){if(t==activeElements[i]&&!matchesSelector((e.relatedTarget||e.toElement),"*",t)){t.__tamee.over=!1;activeElements.splice(i,1);meeHelper("mouseexit",e,obj,t)}}};_bind(obj,"mouseover",_curryChildFilter(children,obj,over,"mouseover"),over);_bind(obj,"mouseout",_curryChildFilter(children,obj,out,"mouseout"),out)}
fn.__taUnstore=function(){delete obj.__tamee[evt][fn.__tauid]};_store(obj,evt,fn);obj.__tamee[evt][fn.__tauid]=fn}},isTouchDevice="ontouchstart" in document.documentElement||navigator.maxTouchPoints,isMouseDevice="onmousedown" in document.documentElement,touchMap={"mousedown":"touchstart","mouseup":"touchend","mousemove":"touchmove"},touchstart="touchstart",touchend="touchend",touchmove="touchmove",iev=(function(){var rv=-1;if(navigator.appName=='Microsoft Internet Explorer'){var ua=navigator.userAgent,re=new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");if(re.exec(ua)!=null)
rv=parseFloat(RegExp.$1);}
return rv})(),isIELT9=iev>-1&&iev<9,_genLoc=function(e,prefix){if(e==null)return[0,0];var ts=_touches(e),t=_getTouch(ts,0);return[t[prefix+"X"],t[prefix+"Y"]]},_pageLocation=function(e){if(e==null)return[0,0];if(isIELT9){return[e.clientX+document.documentElement.scrollLeft,e.clientY+document.documentElement.scrollTop]}else{return _genLoc(e,"page")}},_screenLocation=function(e){return _genLoc(e,"screen")},_clientLocation=function(e){return _genLoc(e,"client")},_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]},_touchCount=function(e){return _touches(e).length},_bind=function(obj,type,fn,originalFn){_store(obj,type,fn);originalFn.__tauid=fn.__tauid;if(obj.addEventListener)
obj.addEventListener(type,fn,!1);else if(obj.attachEvent){var key=type+fn.__tauid;obj["e"+key]=fn;obj[key]=function(){obj["e"+key]&&obj["e"+key](window.event)};obj.attachEvent("on"+type,obj[key])}},_unbind=function(obj,type,fn){if(fn==null)return;_each(obj,function(){var _el=_gel(this);_unstore(_el,type,fn);if(fn.__tauid!=null){if(_el.removeEventListener){_el.removeEventListener(type,fn,!1);if(isTouchDevice&&touchMap[type])_el.removeEventListener(touchMap[type],fn,!1);}else if(this.detachEvent){var key=type+fn.__tauid;_el[key]&&_el.detachEvent("on"+type,_el[key]);_el[key]=null;_el["e"+key]=null}}
if(fn.__taTouchProxy){_unbind(obj,fn.__taTouchProxy[1],fn.__taTouchProxy[0])}})},_each=function(obj,fn){if(obj==null)return;obj=(typeof Window!=="undefined"&&(typeof obj.top!=="unknown"&&obj==obj.top))?[obj]:(typeof obj!=="string")&&(obj.tagName==null&&obj.length!=null)?obj:typeof obj==="string"?document.querySelectorAll(obj):[obj];for(var i=0;i<obj.length;i++)
fn.apply(obj[i]);},_uuid=function(){return('xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=Math.random()*16|0,v=c=='x'?r:(r&0x3|0x8);return v.toString(16)}))};root.Mottle=function(params){params=params||{};var clickThreshold=params.clickThreshold||250,dblClickThreshold=params.dblClickThreshold||450,mouseEnterExitHandler=new MouseEnterExitHandler(),tapHandler=new TapHandler(clickThreshold,dblClickThreshold),_smartClicks=params.smartClicks,_doBind=function(obj,evt,fn,children){if(fn==null)return;_each(obj,function(){var _el=_gel(this);if(_smartClicks&&evt==="click")
SmartClickHandler(_el,evt,fn,children);else if(evt==="tap"||evt==="dbltap"||evt==="contextmenu"){tapHandler(_el,evt,fn,children)}else if(evt==="mouseenter"||evt=="mouseexit")
mouseEnterExitHandler(_el,evt,fn,children);else DefaultHandler(_el,evt,fn,children)})};this.remove=function(el){_each(el,function(){var _el=_gel(this);if(_el.__ta){for(var evt in _el.__ta){if(_el.__ta.hasOwnProperty(evt)){for(var h in _el.__ta[evt]){if(_el.__ta[evt].hasOwnProperty(h))
_unbind(_el,evt,_el.__ta[evt][h]);}}}}
_el.parentNode&&_el.parentNode.removeChild(_el)});return this};this.on=function(el,event,children,fn){var _el=arguments[0],_c=arguments.length==4?arguments[2]:null,_e=arguments[1],_f=arguments[arguments.length-1];_doBind(_el,_e,_f,_c);return this};this.off=function(el,event,fn){_unbind(el,event,fn);return this};this.trigger=function(el,event,originalEvent,payload){var originalIsMouse=isMouseDevice&&(typeof MouseEvent==="undefined"||originalEvent==null||originalEvent.constructor===MouseEvent);var eventToBind=(isTouchDevice&&!isMouseDevice&&touchMap[event])?touchMap[event]:event,bindingAMouseEvent=!(isTouchDevice&&!isMouseDevice&&touchMap[event]);var pl=_pageLocation(originalEvent),sl=_screenLocation(originalEvent),cl=_clientLocation(originalEvent);_each(el,function(){var _el=_gel(this),evt;originalEvent=originalEvent||{screenX:sl[0],screenY:sl[1],clientX:cl[0],clientY:cl[1]};var _decorate=function(_evt){if(payload)_evt.payload=payload};var eventGenerators={"TouchEvent":function(evt){var touchList=_touchAndList(window,_el,0,pl[0],pl[1],sl[0],sl[1],cl[0],cl[1]),init=evt.initTouchEvent||evt.initEvent;init(eventToBind,!0,!0,window,null,sl[0],sl[1],cl[0],cl[1],!1,!1,!1,!1,touchList,touchList,touchList,1,0)},"MouseEvents":function(evt){evt.initMouseEvent(eventToBind,!0,!0,window,0,sl[0],sl[1],cl[0],cl[1],!1,!1,!1,!1,1,_el)}};if(document.createEvent){var ite=!bindingAMouseEvent&&!originalIsMouse&&(isTouchDevice&&touchMap[event]),evtName=ite?"TouchEvent":"MouseEvents";evt=document.createEvent(evtName);eventGenerators[evtName](evt);_decorate(evt);_el.dispatchEvent(evt)}else if(document.createEventObject){evt=document.createEventObject();evt.eventType=evt.eventName=eventToBind;evt.screenX=sl[0];evt.screenY=sl[1];evt.clientX=cl[0];evt.clientY=cl[1];_decorate(evt);_el.fireEvent('on'+eventToBind,evt)}});return this}};root.Mottle.consume=function(e,doNotPreventDefault){if(e.stopPropagation)
e.stopPropagation();else e.returnValue=!1;if(!doNotPreventDefault&&e.preventDefault)
e.preventDefault();};root.Mottle.pageLocation=_pageLocation;root.Mottle.setForceTouchEvents=function(value){isTouchDevice=value};root.Mottle.setForceMouseEvents=function(value){isMouseDevice=value};root.Mottle.version="0.8.0";if(typeof exports!=="undefined"){exports.Mottle=root.Mottle}}).call(typeof window==="undefined"?this:window);(function(){"use strict";var root=this;var _suggest=function(list,item,head){if(list.indexOf(item)===-1){head?list.unshift(item):list.push(item);return!0}
return!1};var _vanquish=function(list,item){var idx=list.indexOf(item);if(idx!==-1)list.splice(idx,1);};var _difference=function(l1,l2){var d=[];for(var i=0;i<l1.length;i++){if(l2.indexOf(l1[i])===-1)
d.push(l1[i]);}
return d};var _isString=function(f){return f==null?!1:(typeof f==="string"||f.constructor===String)};var getOffsetRect=function(elem){var box=elem.getBoundingClientRect(),body=document.body,docElem=document.documentElement,scrollTop=window.pageYOffset||docElem.scrollTop||body.scrollTop,scrollLeft=window.pageXOffset||docElem.scrollLeft||body.scrollLeft,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,top=box.top+scrollTop-clientTop,left=box.left+scrollLeft-clientLeft;return{top:Math.round(top),left:Math.round(left)}};var matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el)
return!0}
return!1};var findDelegateElement=function(parentElement,childElement,selector){if(matchesSelector(childElement,selector,parentElement)){return childElement}else{var currentParent=childElement.parentNode;while(currentParent!=null&&currentParent!==parentElement){if(matchesSelector(currentParent,selector,parentElement)){return currentParent}else{currentParent=currentParent.parentNode}}}};var findMatchingSelector=function(availableSelectors,parentElement,childElement){var el=null;var draggableId=parentElement.getAttribute("katavorio-draggable"),prefix=draggableId!=null?"[katavorio-draggable='"+draggableId+"'] ":"";for(var i=0;i<availableSelectors.length;i++){el=findDelegateElement(parentElement,childElement,prefix+availableSelectors[i].selector);if(el!=null){if(availableSelectors[i].filter){var matches=matchesSelector(childElement,availableSelectors[i].filter,el),exclude=availableSelectors[i].filterExclude===!0;if((exclude&&!matches)||matches){return null}}
return[availableSelectors[i],el]}}
return null};var iev=(function(){var rv=-1;if(navigator.appName==='Microsoft Internet Explorer'){var ua=navigator.userAgent,re=new RegExp("MSIE ([0-9]{1,}[\.0-9]{0,})");if(re.exec(ua)!=null)
rv=parseFloat(RegExp.$1);}
return rv})(),DEFAULT_GRID_X=10,DEFAULT_GRID_Y=10,isIELT9=iev>-1&&iev<9,isIE9=iev===9,_pl=function(e){if(isIELT9){return[e.clientX+document.documentElement.scrollLeft,e.clientY+document.documentElement.scrollTop]}else{var ts=_touches(e),t=_getTouch(ts,0);return isIE9?[t.pageX||t.clientX,t.pageY||t.clientY]:[t.pageX,t.pageY]}},_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]},_classes={delegatedDraggable:"katavorio-delegated-draggable",draggable:"katavorio-draggable",droppable:"katavorio-droppable",drag:"katavorio-drag",selected:"katavorio-drag-selected",active:"katavorio-drag-active",hover:"katavorio-drag-hover",noSelect:"katavorio-drag-no-select",ghostProxy:"katavorio-ghost-proxy",clonedDrag:"katavorio-clone-drag"},_defaultScope="katavorio-drag-scope",_events=["stop","start","drag","drop","over","out","beforeStart"],_devNull=function(){},_true=function(){return!0},_foreach=function(l,fn,from){for(var i=0;i<l.length;i++){if(l[i]!=from)
fn(l[i]);}},_setDroppablesActive=function(dd,val,andHover,drag){_foreach(dd,function(e){e.setActive(val);if(val)e.updatePosition();if(andHover)e.setHover(drag,val);})},_each=function(obj,fn){if(obj==null)return;obj=!_isString(obj)&&(obj.tagName==null&&obj.length!=null)?obj:[obj];for(var i=0;i<obj.length;i++)
fn.apply(obj[i],[obj[i]]);},_consume=function(e){if(e.stopPropagation){e.stopPropagation();e.preventDefault()}else{e.returnValue=!1}},_defaultInputFilterSelector="input,textarea,select,button,option",_inputFilter=function(e,el,_katavorio){var t=e.srcElement||e.target;return!matchesSelector(t,_katavorio.getInputFilterSelector(),el)};var Super=function(el,params,css,scope){this.params=params||{};this.el=el;this.params.addClass(this.el,this._class);this.uuid=_uuid();var enabled=!0;this.setEnabled=function(e){enabled=e};this.isEnabled=function(){return enabled};this.toggleEnabled=function(){enabled=!enabled};this.setScope=function(scopes){this.scopes=scopes?scopes.split(/\s+/):[scope]};this.addScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){m[s]=!0});this.scopes=[];for(var i in m)this.scopes.push(i);};this.removeScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){delete m[s]});this.scopes=[];for(var i in m)this.scopes.push(i);};this.toggleScope=function(scopes){var m={};_each(this.scopes,function(s){m[s]=!0});_each(scopes?scopes.split(/\s+/):[],function(s){if(m[s])delete m[s];else m[s]=!0});this.scopes=[];for(var i in m)this.scopes.push(i);};this.setScope(params.scope);this.k=params.katavorio;return params.katavorio};var TRUE=function(){return!0};var FALSE=function(){return!1};var Drag=function(el,params,css,scope){this._class=css.draggable;var k=Super.apply(this,arguments);this.rightButtonCanDrag=this.params.rightButtonCanDrag;var downAt=[0,0],posAtDown=null,pagePosAtDown=null,pageDelta=[0,0],moving=!1,initialScroll=[0,0],consumeStartEvent=this.params.consumeStartEvent!==!1,dragEl=this.el,clone=this.params.clone,scroll=this.params.scroll,_multipleDrop=params.multipleDrop!==!1,isConstrained=!1,useGhostProxy,ghostProxy,elementToDrag=null,availableSelectors=[],activeSelectorParams=null,ghostProxyParent=params.ghostProxyParent,currentParentPosition,ghostParentPosition,ghostDx,ghostDy;if(params.ghostProxy===!0){useGhostProxy=TRUE}else{if(params.ghostProxy&&typeof params.ghostProxy==="function"){useGhostProxy=params.ghostProxy}else{useGhostProxy=function(container,dragEl){if(activeSelectorParams&&activeSelectorParams.useGhostProxy){return activeSelectorParams.useGhostProxy(container,dragEl)}else{return!1}}}}
if(params.makeGhostProxy){ghostProxy=params.makeGhostProxy}else{ghostProxy=function(el){if(activeSelectorParams&&activeSelectorParams.makeGhostProxy){return activeSelectorParams.makeGhostProxy(el)}else{return el.cloneNode(!0)}}}
if(params.selector){var draggableId=el.getAttribute("katavorio-draggable");if(draggableId==null){draggableId=""+new Date().getTime();el.setAttribute("katavorio-draggable",draggableId)}
availableSelectors.push(params)}
var snapThreshold=params.snapThreshold,_snap=function(pos,gridX,gridY,thresholdX,thresholdY){var _dx=Math.floor(pos[0]/gridX),_dxl=gridX*_dx,_dxt=_dxl+gridX,_x=Math.abs(pos[0]-_dxl)<=thresholdX?_dxl:Math.abs(_dxt-pos[0])<=thresholdX?_dxt:pos[0];var _dy=Math.floor(pos[1]/gridY),_dyl=gridY*_dy,_dyt=_dyl+gridY,_y=Math.abs(pos[1]-_dyl)<=thresholdY?_dyl:Math.abs(_dyt-pos[1])<=thresholdY?_dyt:pos[1];return[_x,_y]};this.posses=[];this.posseRoles={};this.toGrid=function(pos){if(this.params.grid==null){return pos}else{var tx=this.params.grid?this.params.grid[0]/2:snapThreshold?snapThreshold:DEFAULT_GRID_X/2,ty=this.params.grid?this.params.grid[1]/2:snapThreshold?snapThreshold:DEFAULT_GRID_Y/2;return _snap(pos,this.params.grid[0],this.params.grid[1],tx,ty)}};this.snap=function(x,y){if(dragEl==null)return;x=x||(this.params.grid?this.params.grid[0]:DEFAULT_GRID_X);y=y||(this.params.grid?this.params.grid[1]:DEFAULT_GRID_Y);var p=this.params.getPosition(dragEl),tx=this.params.grid?this.params.grid[0]/2:snapThreshold,ty=this.params.grid?this.params.grid[1]/2:snapThreshold,snapped=_snap(p,x,y,tx,ty);this.params.setPosition(dragEl,snapped);return snapped};this.setUseGhostProxy=function(val){useGhostProxy=val?TRUE:FALSE};var constrain;var negativeFilter=function(pos){return(params.allowNegative===!1)?[Math.max(0,pos[0]),Math.max(0,pos[1])]:pos};var _setConstrain=function(value){constrain=typeof value==="function"?value:value?function(pos,dragEl,_constrainRect,_size){return negativeFilter([Math.max(0,Math.min(_constrainRect.w-_size[0],pos[0])),Math.max(0,Math.min(_constrainRect.h-_size[1],pos[1]))])}.bind(this):function(pos){return negativeFilter(pos)}}.bind(this);_setConstrain(typeof this.params.constrain==="function"?this.params.constrain:(this.params.constrain||this.params.containment));this.setConstrain=function(value){_setConstrain(value)};var _doConstrain=function(pos,dragEl,_constrainRect,_size){if(activeSelectorParams!=null&&activeSelectorParams.constrain&&typeof activeSelectorParams.constrain==="function"){return activeSelectorParams.constrain(pos,dragEl,_constrainRect,_size)}else{return constrain(pos,dragEl,_constrainRect,_size)}};var revertFunction;this.setRevert=function(fn){revertFunction=fn};if(this.params.revert){revertFunction=this.params.revert}
var _assignId=function(obj){if(typeof obj==="function"){obj._katavorioId=_uuid();return obj._katavorioId}else{return obj}},_filters={},_testFilter=function(e){for(var key in _filters){var f=_filters[key];var rv=f[0](e);if(f[1])rv=!rv;if(!rv)return!1}
return!0},_setFilter=this.setFilter=function(f,_exclude){if(f){var key=_assignId(f);_filters[key]=[function(e){var t=e.srcElement||e.target,m;if(_isString(f)){m=matchesSelector(t,f,el)}else if(typeof f==="function"){m=f(e,el)}
return m},_exclude!==!1]}},_addFilter=this.addFilter=_setFilter,_removeFilter=this.removeFilter=function(f){var key=typeof f==="function"?f._katavorioId:f;delete _filters[key]};this.clearAllFilters=function(){_filters={}};this.canDrag=this.params.canDrag||_true;var constrainRect,matchingDroppables=[],intersectingDroppables=[];this.addSelector=function(params){if(params.selector){availableSelectors.push(params)}};this.downListener=function(e){if(e.defaultPrevented){return}
var isNotRightClick=this.rightButtonCanDrag||(e.which!==3&&e.button!==2);if(isNotRightClick&&this.isEnabled()&&this.canDrag()){var _f=_testFilter(e)&&_inputFilter(e,this.el,this.k);if(_f){activeSelectorParams=null;elementToDrag=null;if(availableSelectors.length>0){var match=findMatchingSelector(availableSelectors,this.el,e.target||e.srcElement);if(match!=null){activeSelectorParams=match[0];elementToDrag=match[1]}
if(elementToDrag==null){return}}else{elementToDrag=this.el}
if(clone){dragEl=elementToDrag.cloneNode(!0);this.params.addClass(dragEl,_classes.clonedDrag);dragEl.setAttribute("id",null);dragEl.style.position="absolute";if(this.params.parent!=null){var p=this.params.getPosition(this.el);dragEl.style.left=p[0]+"px";dragEl.style.top=p[1]+"px";this.params.parent.appendChild(dragEl)}else{var b=getOffsetRect(elementToDrag);dragEl.style.left=b.left+"px";dragEl.style.top=b.top+"px";document.body.appendChild(dragEl)}}else{dragEl=elementToDrag}
consumeStartEvent&&_consume(e);downAt=_pl(e);if(dragEl&&dragEl.parentNode){initialScroll=[dragEl.parentNode.scrollLeft,dragEl.parentNode.scrollTop]}
this.params.bind(document,"mousemove",this.moveListener);this.params.bind(document,"mouseup",this.upListener);k.markSelection(this);k.markPosses(this);this.params.addClass(document.body,css.noSelect);_dispatch("beforeStart",{el:this.el,pos:posAtDown,e:e,drag:this})}else if(this.params.consumeFilteredEvents){_consume(e)}}}.bind(this);this.moveListener=function(e){if(downAt){if(!moving){var _continue=_dispatch("start",{el:this.el,pos:posAtDown,e:e,drag:this});if(_continue!==!1){if(!downAt){return}
this.mark(!0);moving=!0}else{this.abort()}}
if(downAt){intersectingDroppables.length=0;var pos=_pl(e),dx=pos[0]-downAt[0],dy=pos[1]-downAt[1],z=this.params.ignoreZoom?1:k.getZoom();if(dragEl&&dragEl.parentNode){dx+=dragEl.parentNode.scrollLeft-initialScroll[0];dy+=dragEl.parentNode.scrollTop-initialScroll[1]}
dx/=z;dy/=z;this.moveBy(dx,dy,e);k.updateSelection(dx,dy,this);k.updatePosses(dx,dy,this)}}}.bind(this);this.upListener=function(e){if(downAt){downAt=null;this.params.unbind(document,"mousemove",this.moveListener);this.params.unbind(document,"mouseup",this.upListener);this.params.removeClass(document.body,css.noSelect);this.unmark(e);k.unmarkSelection(this,e);k.unmarkPosses(this,e);this.stop(e);k.notifyPosseDragStop(this,e);moving=!1;intersectingDroppables.length=0;if(clone){dragEl&&dragEl.parentNode&&dragEl.parentNode.removeChild(dragEl);dragEl=null}else{if(revertFunction&&revertFunction(dragEl,this.params.getPosition(dragEl))===!0){this.params.setPosition(dragEl,posAtDown);_dispatch("revert",dragEl)}}}}.bind(this);this.getFilters=function(){return _filters};this.abort=function(){if(downAt!=null){this.upListener()}};this.getDragElement=function(retrieveOriginalElement){return retrieveOriginalElement?elementToDrag||this.el:dragEl||this.el};var listeners={"start":[],"drag":[],"stop":[],"over":[],"out":[],"beforeStart":[],"revert":[]};if(params.events.start)listeners.start.push(params.events.start);if(params.events.beforeStart)listeners.beforeStart.push(params.events.beforeStart);if(params.events.stop)listeners.stop.push(params.events.stop);if(params.events.drag)listeners.drag.push(params.events.drag);if(params.events.revert)listeners.revert.push(params.events.revert);this.on=function(evt,fn){if(listeners[evt])listeners[evt].push(fn);};this.off=function(evt,fn){if(listeners[evt]){var l=[];for(var i=0;i<listeners[evt].length;i++){if(listeners[evt][i]!==fn)l.push(listeners[evt][i]);}
listeners[evt]=l}};var _dispatch=function(evt,value){var result=null;if(activeSelectorParams&&activeSelectorParams[evt]){result=activeSelectorParams[evt](value)}else if(listeners[evt]){for(var i=0;i<listeners[evt].length;i++){try{var v=listeners[evt][i](value);if(v!=null){result=v}}catch(e){}}}
return result};this.notifyStart=function(e){_dispatch("start",{el:this.el,pos:this.params.getPosition(dragEl),e:e,drag:this})};this.stop=function(e,force){if(force||moving){var positions=[],sel=k.getSelection(),dPos=this.params.getPosition(dragEl);if(sel.length>0){for(var i=0;i<sel.length;i++){var p=this.params.getPosition(sel[i].el);positions.push([sel[i].el,{left:p[0],top:p[1]},sel[i]])}}else{positions.push([dragEl,{left:dPos[0],top:dPos[1]},this])}
_dispatch("stop",{el:dragEl,pos:ghostProxyOffsets||dPos,finalPos:dPos,e:e,drag:this,selection:positions})}};this.mark=function(andNotify){posAtDown=this.params.getPosition(dragEl);pagePosAtDown=this.params.getPosition(dragEl,!0);pageDelta=[pagePosAtDown[0]-posAtDown[0],pagePosAtDown[1]-posAtDown[1]];this.size=this.params.getSize(dragEl);matchingDroppables=k.getMatchingDroppables(this);_setDroppablesActive(matchingDroppables,!0,!1,this);this.params.addClass(dragEl,this.params.dragClass||css.drag);var cs;if(this.params.getConstrainingRectangle){cs=this.params.getConstrainingRectangle(dragEl)}else{cs=this.params.getSize(dragEl.parentNode)}
constrainRect={w:cs[0],h:cs[1]};ghostDx=0;ghostDy=0;if(andNotify){k.notifySelectionDragStart(this)}};var ghostProxyOffsets;this.unmark=function(e,doNotCheckDroppables){_setDroppablesActive(matchingDroppables,!1,!0,this);if(isConstrained&&useGhostProxy(elementToDrag,dragEl)){ghostProxyOffsets=[dragEl.offsetLeft-ghostDx,dragEl.offsetTop-ghostDy];dragEl.parentNode.removeChild(dragEl);dragEl=elementToDrag}else{ghostProxyOffsets=null}
this.params.removeClass(dragEl,this.params.dragClass||css.drag);matchingDroppables.length=0;isConstrained=!1;if(!doNotCheckDroppables){if(intersectingDroppables.length>0&&ghostProxyOffsets){params.setPosition(elementToDrag,ghostProxyOffsets)}
intersectingDroppables.sort(_rankSort);for(var i=0;i<intersectingDroppables.length;i++){var retVal=intersectingDroppables[i].drop(this,e);if(retVal===!0)break}}};this.moveBy=function(dx,dy,e){intersectingDroppables.length=0;var desiredLoc=this.toGrid([posAtDown[0]+dx,posAtDown[1]+dy]),cPos=_doConstrain(desiredLoc,dragEl,constrainRect,this.size);if(useGhostProxy(this.el,dragEl)){if(desiredLoc[0]!==cPos[0]||desiredLoc[1]!==cPos[1]){if(!isConstrained){var gp=ghostProxy(elementToDrag);params.addClass(gp,_classes.ghostProxy);if(ghostProxyParent){ghostProxyParent.appendChild(gp);currentParentPosition=params.getPosition(elementToDrag.parentNode,!0);ghostParentPosition=params.getPosition(params.ghostProxyParent,!0);ghostDx=currentParentPosition[0]-ghostParentPosition[0];ghostDy=currentParentPosition[1]-ghostParentPosition[1]}else{elementToDrag.parentNode.appendChild(gp)}
dragEl=gp;isConstrained=!0}
cPos=desiredLoc}else{if(isConstrained){dragEl.parentNode.removeChild(dragEl);dragEl=elementToDrag;isConstrained=!1;currentParentPosition=null;ghostParentPosition=null;ghostDx=0;ghostDy=0}}}
var rect={x:cPos[0],y:cPos[1],w:this.size[0],h:this.size[1]},pageRect={x:rect.x+pageDelta[0],y:rect.y+pageDelta[1],w:rect.w,h:rect.h},focusDropElement=null;this.params.setPosition(dragEl,[cPos[0]+ghostDx,cPos[1]+ghostDy]);for(var i=0;i<matchingDroppables.length;i++){var r2={x:matchingDroppables[i].pagePosition[0],y:matchingDroppables[i].pagePosition[1],w:matchingDroppables[i].size[0],h:matchingDroppables[i].size[1]};if(this.params.intersects(pageRect,r2)&&(_multipleDrop||focusDropElement==null||focusDropElement===matchingDroppables[i].el)&&matchingDroppables[i].canDrop(this)){if(!focusDropElement)focusDropElement=matchingDroppables[i].el;intersectingDroppables.push(matchingDroppables[i]);matchingDroppables[i].setHover(this,!0,e)}else if(matchingDroppables[i].isHover()){matchingDroppables[i].setHover(this,!1,e)}}
_dispatch("drag",{el:this.el,pos:cPos,e:e,drag:this})};this.destroy=function(){this.params.unbind(this.el,"mousedown",this.downListener);this.params.unbind(document,"mousemove",this.moveListener);this.params.unbind(document,"mouseup",this.upListener);this.downListener=null;this.upListener=null;this.moveListener=null};this.params.bind(this.el,"mousedown",this.downListener);if(this.params.handle)
_setFilter(this.params.handle,!1);else _setFilter(this.params.filter,this.params.filterExclude)};var Drop=function(el,params,css,scope){this._class=css.droppable;this.params=params||{};this.rank=params.rank||0;this._activeClass=this.params.activeClass||css.active;this._hoverClass=this.params.hoverClass||css.hover;Super.apply(this,arguments);var hover=!1;this.allowLoopback=this.params.allowLoopback!==!1;this.setActive=function(val){this.params[val?"addClass":"removeClass"](this.el,this._activeClass)};this.updatePosition=function(){this.position=this.params.getPosition(this.el);this.pagePosition=this.params.getPosition(this.el,!0);this.size=this.params.getSize(this.el)};this.canDrop=this.params.canDrop||function(drag){return!0};this.isHover=function(){return hover};this.setHover=function(drag,val,e){if(val||this.el._katavorioDragHover==null||this.el._katavorioDragHover===drag.el._katavorio){this.params[val?"addClass":"removeClass"](this.el,this._hoverClass);this.el._katavorioDragHover=val?drag.el._katavorio:null;if(hover!==val){this.params.events[val?"over":"out"]({el:this.el,e:e,drag:drag,drop:this})}
hover=val}};this.drop=function(drag,event){return this.params.events.drop({drag:drag,e:event,drop:this})};this.destroy=function(){this._class=null;this._activeClass=null;this._hoverClass=null;hover=null}};var _uuid=function(){return('xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g,function(c){var r=Math.random()*16|0,v=c==='x'?r:(r&0x3|0x8);return v.toString(16)}))};var _rankSort=function(a,b){return a.rank<b.rank?1:a.rank>b.rank?-1:0};var _gel=function(el){if(el==null)return null;el=(typeof el==="string"||el.constructor===String)?document.getElementById(el):el;if(el==null)return null;el._katavorio=el._katavorio||_uuid();return el};root.Katavorio=function(katavorioParams){var _selection=[],_selectionMap={};this._dragsByScope={};this._dropsByScope={};var _zoom=1,_reg=function(obj,map){_each(obj,function(_obj){for(var i=0;i<_obj.scopes.length;i++){map[_obj.scopes[i]]=map[_obj.scopes[i]]||[];map[_obj.scopes[i]].push(_obj)}})},_unreg=function(obj,map){var c=0;_each(obj,function(_obj){for(var i=0;i<_obj.scopes.length;i++){if(map[_obj.scopes[i]]){var idx=katavorioParams.indexOf(map[_obj.scopes[i]],_obj);if(idx!==-1){map[_obj.scopes[i]].splice(idx,1);c++}}}});return c>0},_getMatchingDroppables=this.getMatchingDroppables=function(drag){var dd=[],_m={};for(var i=0;i<drag.scopes.length;i++){var _dd=this._dropsByScope[drag.scopes[i]];if(_dd){for(var j=0;j<_dd.length;j++){if(_dd[j].canDrop(drag)&&!_m[_dd[j].uuid]&&(_dd[j].allowLoopback||_dd[j].el!==drag.el)){_m[_dd[j].uuid]=!0;dd.push(_dd[j])}}}}
dd.sort(_rankSort);return dd},_prepareParams=function(p){p=p||{};var _p={events:{}},i;for(i in katavorioParams)_p[i]=katavorioParams[i];for(i in p)_p[i]=p[i];for(i=0;i<_events.length;i++){_p.events[_events[i]]=p[_events[i]]||_devNull}
_p.katavorio=this;return _p}.bind(this),_mistletoe=function(existingDrag,params){for(var i=0;i<_events.length;i++){if(params[_events[i]]){existingDrag.on(_events[i],params[_events[i]])}}}.bind(this),_css={},overrideCss=katavorioParams.css||{},_scope=katavorioParams.scope||_defaultScope;for(var i in _classes)_css[i]=_classes[i];for(var i in overrideCss)_css[i]=overrideCss[i];var inputFilterSelector=katavorioParams.inputFilterSelector||_defaultInputFilterSelector;this.getInputFilterSelector=function(){return inputFilterSelector};this.setInputFilterSelector=function(selector){inputFilterSelector=selector;return this};this.draggable=function(el,params){var o=[];_each(el,function(_el){_el=_gel(_el);if(_el!=null){if(_el._katavorioDrag==null){var p=_prepareParams(params);_el._katavorioDrag=new Drag(_el,p,_css,_scope);_reg(_el._katavorioDrag,this._dragsByScope);o.push(_el._katavorioDrag);katavorioParams.addClass(_el,p.selector?_css.delegatedDraggable:_css.draggable)}else{_mistletoe(_el._katavorioDrag,params)}}}.bind(this));return o};this.droppable=function(el,params){var o=[];_each(el,function(_el){_el=_gel(_el);if(_el!=null){var drop=new Drop(_el,_prepareParams(params),_css,_scope);_el._katavorioDrop=_el._katavorioDrop||[];_el._katavorioDrop.push(drop);_reg(drop,this._dropsByScope);o.push(drop);katavorioParams.addClass(_el,_css.droppable)}}.bind(this));return o};this.select=function(el){_each(el,function(){var _el=_gel(this);if(_el&&_el._katavorioDrag){if(!_selectionMap[_el._katavorio]){_selection.push(_el._katavorioDrag);_selectionMap[_el._katavorio]=[_el,_selection.length-1];katavorioParams.addClass(_el,_css.selected)}}});return this};this.deselect=function(el){_each(el,function(){var _el=_gel(this);if(_el&&_el._katavorio){var e=_selectionMap[_el._katavorio];if(e){var _s=[];for(var i=0;i<_selection.length;i++)
if(_selection[i].el!==_el)_s.push(_selection[i]);_selection=_s;delete _selectionMap[_el._katavorio];katavorioParams.removeClass(_el,_css.selected)}}});return this};this.deselectAll=function(){for(var i in _selectionMap){var d=_selectionMap[i];katavorioParams.removeClass(d[0],_css.selected)}
_selection.length=0;_selectionMap={}};this.markSelection=function(drag){_foreach(_selection,function(e){e.mark()},drag)};this.markPosses=function(drag){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(d){d.mark()},drag)}})}};this.unmarkSelection=function(drag,event){_foreach(_selection,function(e){e.unmark(event)},drag)};this.unmarkPosses=function(drag,event){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(d){d.unmark(event,!0)},drag)}})}};this.getSelection=function(){return _selection.slice(0)};this.updateSelection=function(dx,dy,drag){_foreach(_selection,function(e){e.moveBy(dx,dy)},drag)};var _posseAction=function(fn,drag){if(drag.posses){_each(drag.posses,function(p){if(drag.posseRoles[p]&&_posses[p]){_foreach(_posses[p].members,function(e){fn(e)},drag)}})}};this.updatePosses=function(dx,dy,drag){_posseAction(function(e){e.moveBy(dx,dy)},drag)};this.notifyPosseDragStop=function(drag,evt){_posseAction(function(e){e.stop(evt,!0)},drag)};this.notifySelectionDragStop=function(drag,evt){_foreach(_selection,function(e){e.stop(evt,!0)},drag)};this.notifySelectionDragStart=function(drag,evt){_foreach(_selection,function(e){e.notifyStart(evt)},drag)};this.setZoom=function(z){_zoom=z};this.getZoom=function(){return _zoom};var _scopeManip=function(kObj,scopes,map,fn){_each(kObj,function(_kObj){_unreg(_kObj,map);_kObj[fn](scopes);_reg(_kObj,map)})};_each(["set","add","remove","toggle"],function(v){this[v+"Scope"]=function(el,scopes){_scopeManip(el._katavorioDrag,scopes,this._dragsByScope,v+"Scope");_scopeManip(el._katavorioDrop,scopes,this._dropsByScope,v+"Scope")}.bind(this);this[v+"DragScope"]=function(el,scopes){_scopeManip(el.constructor===Drag?el:el._katavorioDrag,scopes,this._dragsByScope,v+"Scope")}.bind(this);this[v+"DropScope"]=function(el,scopes){_scopeManip(el.constructor===Drop?el:el._katavorioDrop,scopes,this._dropsByScope,v+"Scope")}.bind(this)}.bind(this));this.snapToGrid=function(x,y){for(var s in this._dragsByScope){_foreach(this._dragsByScope[s],function(d){d.snap(x,y)})}};this.getDragsForScope=function(s){return this._dragsByScope[s]};this.getDropsForScope=function(s){return this._dropsByScope[s]};var _destroy=function(el,type,map){el=_gel(el);if(el[type]){var selIdx=_selection.indexOf(el[type]);if(selIdx>=0){_selection.splice(selIdx,1)}
if(_unreg(el[type],map)){_each(el[type],function(kObj){kObj.destroy()})}
delete el[type]}};var _removeListener=function(el,type,evt,fn){el=_gel(el);if(el[type]){el[type].off(evt,fn)}};this.elementRemoved=function(el){if(el._katavorioDrag){this.destroyDraggable(el)}
if(el._katavorioDrop){this.destroyDroppable(el)}};this.destroyDraggable=function(el,evt,fn){if(arguments.length===1){_destroy(el,"_katavorioDrag",this._dragsByScope)}else{_removeListener(el,"_katavorioDrag",evt,fn)}};this.destroyDroppable=function(el,evt,fn){if(arguments.length===1){_destroy(el,"_katavorioDrop",this._dropsByScope)}else{_removeListener(el,"_katavorioDrop",evt,fn)}};this.reset=function(){this._dragsByScope={};this._dropsByScope={};_selection=[];_selectionMap={};_posses={}};var _posses={};var _processOneSpec=function(el,_spec,dontAddExisting){var posseId=_isString(_spec)?_spec:_spec.id;var active=_isString(_spec)?!0:_spec.active!==!1;var posse=_posses[posseId]||(function(){var g={name:posseId,members:[]};_posses[posseId]=g;return g})();_each(el,function(_el){if(_el._katavorioDrag){if(dontAddExisting&&_el._katavorioDrag.posseRoles[posse.name]!=null)return;_suggest(posse.members,_el._katavorioDrag);_suggest(_el._katavorioDrag.posses,posse.name);_el._katavorioDrag.posseRoles[posse.name]=active}});return posse};this.addToPosse=function(el,spec){var posses=[];for(var i=1;i<arguments.length;i++){posses.push(_processOneSpec(el,arguments[i]))}
return posses.length===1?posses[0]:posses};this.setPosse=function(el,spec){var posses=[];for(var i=1;i<arguments.length;i++){posses.push(_processOneSpec(el,arguments[i],!0).name)}
_each(el,function(_el){if(_el._katavorioDrag){var diff=_difference(_el._katavorioDrag.posses,posses);var p=[];Array.prototype.push.apply(p,_el._katavorioDrag.posses);for(var i=0;i<diff.length;i++){this.removeFromPosse(_el,diff[i])}}}.bind(this));return posses.length===1?posses[0]:posses};this.removeFromPosse=function(el,posseId){if(arguments.length<2)throw new TypeError("No posse id provided for remove operation");for(var i=1;i<arguments.length;i++){posseId=arguments[i];_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){var d=_el._katavorioDrag;_each(posseId,function(p){_vanquish(_posses[p].members,d);_vanquish(d.posses,p);delete d.posseRoles[p]})}})}};this.removeFromAllPosses=function(el){_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){var d=_el._katavorioDrag;_each(d.posses,function(p){_vanquish(_posses[p].members,d)});d.posses.length=0;d.posseRoles={}}})};this.setPosseState=function(el,posseId,state){var posse=_posses[posseId];if(posse){_each(el,function(_el){if(_el._katavorioDrag&&_el._katavorioDrag.posses){_el._katavorioDrag.posseRoles[posse.name]=state}})}}};root.Katavorio.version="1.0.0";if(typeof exports!=="undefined"){exports.Katavorio=root.Katavorio}}).call(typeof window!=='undefined'?window:this);(function(){var root=this;root.jsPlumbUtil=root.jsPlumbUtil||{};var jsPlumbUtil=root.jsPlumbUtil;if(typeof exports!=='undefined'){exports.jsPlumbUtil=jsPlumbUtil}
function isArray(a){return Object.prototype.toString.call(a)==="[object Array]"}
jsPlumbUtil.isArray=isArray;function isNumber(n){return Object.prototype.toString.call(n)==="[object Number]"}
jsPlumbUtil.isNumber=isNumber;function isString(s){return typeof s==="string"}
jsPlumbUtil.isString=isString;function isBoolean(s){return typeof s==="boolean"}
jsPlumbUtil.isBoolean=isBoolean;function isNull(s){return s==null}
jsPlumbUtil.isNull=isNull;function isObject(o){return o==null?!1:Object.prototype.toString.call(o)==="[object Object]"}
jsPlumbUtil.isObject=isObject;function isDate(o){return Object.prototype.toString.call(o)==="[object Date]"}
jsPlumbUtil.isDate=isDate;function isFunction(o){return Object.prototype.toString.call(o)==="[object Function]"}
jsPlumbUtil.isFunction=isFunction;function isNamedFunction(o){return isFunction(o)&&o.name!=null&&o.name.length>0}
jsPlumbUtil.isNamedFunction=isNamedFunction;function isEmpty(o){for(var i in o){if(o.hasOwnProperty(i)){return!1}}
return!0}
jsPlumbUtil.isEmpty=isEmpty;function clone(a){if(isString(a)){return""+a}else if(isBoolean(a)){return!!a}else if(isDate(a)){return new Date(a.getTime())}else if(isFunction(a)){return a}else if(isArray(a)){var b=[];for(var i=0;i<a.length;i++){b.push(clone(a[i]))}
return b}else if(isObject(a)){var c={};for(var j in a){c[j]=clone(a[j])}
return c}else{return a}}
jsPlumbUtil.clone=clone;function merge(a,b,collations,overwrites){var cMap={},ar,i,oMap={};collations=collations||[];overwrites=overwrites||[];for(i=0;i<collations.length;i++){cMap[collations[i]]=!0}
for(i=0;i<overwrites.length;i++){oMap[overwrites[i]]=!0}
var c=clone(a);for(i in b){if(c[i]==null||oMap[i]){c[i]=b[i]}else if(isString(b[i])||isBoolean(b[i])){if(!cMap[i]){c[i]=b[i]}else{ar=[];ar.push.apply(ar,isArray(c[i])?c[i]:[c[i]]);ar.push.apply(ar,isBoolean(b[i])?b[i]:[b[i]]);c[i]=ar}}else{if(isArray(b[i])){ar=[];if(isArray(c[i])){ar.push.apply(ar,c[i])}
ar.push.apply(ar,b[i]);c[i]=ar}else if(isObject(b[i])){if(!isObject(c[i])){c[i]={}}
for(var j in b[i]){c[i][j]=b[i][j]}}}}
return c}
jsPlumbUtil.merge=merge;function replace(inObj,path,value){if(inObj==null){return}
var q=inObj,t=q;path.replace(/([^\.])+/g,function(term,lc,pos,str){var array=term.match(/([^\[0-9]+){1}(\[)([0-9+])/),last=pos+term.length>=str.length,_getArray=function(){return t[array[1]]||(function(){t[array[1]]=[];return t[array[1]]})()};if(last){if(array){_getArray()[array[3]]=value}else{t[term]=value}}else{if(array){var a_1=_getArray();t=a_1[array[3]]||(function(){a_1[array[3]]={};return a_1[array[3]]})()}else{t=t[term]||(function(){t[term]={};return t[term]})()}}
return""});return inObj}
jsPlumbUtil.replace=replace;function functionChain(successValue,failValue,fns){for(var i=0;i<fns.length;i++){var o=fns[i][0][fns[i][1]].apply(fns[i][0],fns[i][2]);if(o===failValue){return o}}
return successValue}
jsPlumbUtil.functionChain=functionChain;function populate(model,values,functionPrefix,doNotExpandFunctions){var getValue=function(fromString){var matches=fromString.match(/(\${.*?})/g);if(matches!=null){for(var i=0;i<matches.length;i++){var val=values[matches[i].substring(2,matches[i].length-1)]||"";if(val!=null){fromString=fromString.replace(matches[i],val)}}}
return fromString};var _one=function(d){if(d!=null){if(isString(d)){return getValue(d)}else if(isFunction(d)&&!doNotExpandFunctions&&(functionPrefix==null||(d.name||"").indexOf(functionPrefix)===0)){return d(values)}else if(isArray(d)){var r=[];for(var i=0;i<d.length;i++){r.push(_one(d[i]))}
return r}else if(isObject(d)){var s={};for(var j in d){s[j]=_one(d[j])}
return s}else{return d}}};return _one(model)}
jsPlumbUtil.populate=populate;function findWithFunction(a,f){if(a){for(var i=0;i<a.length;i++){if(f(a[i])){return i}}}
return-1}
jsPlumbUtil.findWithFunction=findWithFunction;function removeWithFunction(a,f){var idx=findWithFunction(a,f);if(idx>-1){a.splice(idx,1)}
return idx!==-1}
jsPlumbUtil.removeWithFunction=removeWithFunction;function remove(l,v){var idx=l.indexOf(v);if(idx>-1){l.splice(idx,1)}
return idx!==-1}
jsPlumbUtil.remove=remove;function addWithFunction(list,item,hashFunction){if(findWithFunction(list,hashFunction)===-1){list.push(item)}}
jsPlumbUtil.addWithFunction=addWithFunction;function addToList(map,key,value,insertAtStart){var l=map[key];if(l==null){l=[];map[key]=l}
l[insertAtStart?"unshift":"push"](value);return l}
jsPlumbUtil.addToList=addToList;function suggest(list,item,insertAtHead){if(list.indexOf(item)===-1){if(insertAtHead){list.unshift(item)}else{list.push(item)}
return!0}
return!1}
jsPlumbUtil.suggest=suggest;function extend(child,parent,_protoFn){var i;parent=isArray(parent)?parent:[parent];var _copyProtoChain=function(focus){var proto=focus.__proto__;while(proto!=null){if(proto.prototype!=null){for(var j in proto.prototype){if(proto.prototype.hasOwnProperty(j)&&!child.prototype.hasOwnProperty(j)){child.prototype[j]=proto.prototype[j]}}
proto=proto.prototype.__proto__}else{proto=null}}};for(i=0;i<parent.length;i++){for(var j in parent[i].prototype){if(parent[i].prototype.hasOwnProperty(j)&&!child.prototype.hasOwnProperty(j)){child.prototype[j]=parent[i].prototype[j]}}
_copyProtoChain(parent[i])}
var _makeFn=function(name,protoFn){return function(){for(i=0;i<parent.length;i++){if(parent[i].prototype[name]){parent[i].prototype[name].apply(this,arguments)}}
return protoFn.apply(this,arguments)}};var _oneSet=function(fns){for(var k in fns){child.prototype[k]=_makeFn(k,fns[k])}};if(arguments.length>2){for(i=2;i<arguments.length;i++){_oneSet(arguments[i])}}
return child}
jsPlumbUtil.extend=extend;var lut=[];for(var i=0;i<256;i++){lut[i]=(i<16?'0':'')+(i).toString(16)}
function uuid(){var d0=Math.random()*0xffffffff|0;var d1=Math.random()*0xffffffff|0;var d2=Math.random()*0xffffffff|0;var d3=Math.random()*0xffffffff|0;return lut[d0&0xff]+lut[d0>>8&0xff]+lut[d0>>16&0xff]+lut[d0>>24&0xff]+'-'+lut[d1&0xff]+lut[d1>>8&0xff]+'-'+lut[d1>>16&0x0f|0x40]+lut[d1>>24&0xff]+'-'+lut[d2&0x3f|0x80]+lut[d2>>8&0xff]+'-'+lut[d2>>16&0xff]+lut[d2>>24&0xff]+lut[d3&0xff]+lut[d3>>8&0xff]+lut[d3>>16&0xff]+lut[d3>>24&0xff]}
jsPlumbUtil.uuid=uuid;function fastTrim(s){if(s==null){return null}
var str=s.replace(/^\s\s*/,''),ws=/\s/,i=str.length;while(ws.test(str.charAt(--i))){}
return str.slice(0,i+1)}
jsPlumbUtil.fastTrim=fastTrim;function each(obj,fn){obj=obj.length==null||typeof obj==="string"?[obj]:obj;for(var i=0;i<obj.length;i++){fn(obj[i])}}
jsPlumbUtil.each=each;function map(obj,fn){var o=[];for(var i=0;i<obj.length;i++){o.push(fn(obj[i]))}
return o}
jsPlumbUtil.map=map;function mergeWithParents(type,map,parentAttribute){parentAttribute=parentAttribute||"parent";var _def=function(id){return id?map[id]:null};var _parent=function(def){return def?_def(def[parentAttribute]):null};var _one=function(parent,def){if(parent==null){return def}else{var overrides=["anchor","anchors","cssClass","connector","paintStyle","hoverPaintStyle","endpoint","endpoints"];if(def.mergeStrategy==="override"){Array.prototype.push.apply(overrides,["events","overlays"])}
var d_1=merge(parent,def,[],overrides);return _one(_parent(parent),d_1)}};var _getDef=function(t){if(t==null){return{}}
if(typeof t==="string"){return _def(t)}else if(t.length){var done=!1,i=0,_dd=void 0;while(!done&&i<t.length){_dd=_getDef(t[i]);if(_dd){done=!0}else{i++}}
return _dd}};var d=_getDef(type);if(d){return _one(_parent(d),d)}else{return{}}}
jsPlumbUtil.mergeWithParents=mergeWithParents;jsPlumbUtil.logEnabled=!0;function log(){var args=[];for(var _i=0;_i<arguments.length;_i++){args[_i]=arguments[_i]}
if(jsPlumbUtil.logEnabled&&typeof console!=="undefined"){try{var msg=arguments[arguments.length-1];console.log(msg)}catch(e){}}}
jsPlumbUtil.log=log;function wrap(wrappedFunction,newFunction,returnOnThisValue){return function(){var r=null;try{if(newFunction!=null){r=newFunction.apply(this,arguments)}}catch(e){log("jsPlumb function failed : "+e)}
if((wrappedFunction!=null)&&(returnOnThisValue==null||(r!==returnOnThisValue))){try{r=wrappedFunction.apply(this,arguments)}catch(e){log("wrapped function failed : "+e)}}
return r}}
jsPlumbUtil.wrap=wrap;var EventGenerator=(function(){function EventGenerator(){var _this=this;this._listeners={};this.eventsSuspended=!1;this.tick=!1;this.eventsToDieOn={"ready":!0};this.queue=[];this.bind=function(event,listener,insertAtStart){var _one=function(evt){addToList(_this._listeners,evt,listener,insertAtStart);listener.__jsPlumb=listener.__jsPlumb||{};listener.__jsPlumb[uuid()]=evt};if(typeof event==="string"){_one(event)}else if(event.length!=null){for(var i=0;i<event.length;i++){_one(event[i])}}
return _this};this.fire=function(event,value,originalEvent){if(!this.tick){this.tick=!0;if(!this.eventsSuspended&&this._listeners[event]){var l=this._listeners[event].length,i=0,_gone=!1,ret=null;if(!this.shouldFireEvent||this.shouldFireEvent(event,value,originalEvent)){while(!_gone&&i<l&&ret!==!1){if(this.eventsToDieOn[event]){this._listeners[event][i].apply(this,[value,originalEvent])}else{try{ret=this._listeners[event][i].apply(this,[value,originalEvent])}catch(e){log("jsPlumb: fire failed for event "+event+" : "+e)}}
i++;if(this._listeners==null||this._listeners[event]==null){_gone=!0}}}}
this.tick=!1;this._drain()}else{this.queue.unshift(arguments)}
return this};this._drain=function(){var n=_this.queue.pop();if(n){_this.fire.apply(_this,n)}};this.unbind=function(eventOrListener,listener){if(arguments.length===0){this._listeners={}}else if(arguments.length===1){if(typeof eventOrListener==="string"){delete this._listeners[eventOrListener]}else if(eventOrListener.__jsPlumb){var evt=void 0;for(var i in eventOrListener.__jsPlumb){evt=eventOrListener.__jsPlumb[i];remove(this._listeners[evt]||[],eventOrListener)}}}else if(arguments.length===2){remove(this._listeners[eventOrListener]||[],listener)}
return this};this.getListener=function(forEvent){return _this._listeners[forEvent]};this.setSuspendEvents=function(val){_this.eventsSuspended=val};this.isSuspendEvents=function(){return _this.eventsSuspended};this.silently=function(fn){_this.setSuspendEvents(!0);try{fn()}catch(e){log("Cannot execute silent function "+e)}
_this.setSuspendEvents(!1)};this.cleanupListeners=function(){for(var i in _this._listeners){_this._listeners[i]=null}}}
return EventGenerator}());jsPlumbUtil.EventGenerator=EventGenerator;function rotatePoint(point,center,rotation){var radial=[point[0]-center[0],point[1]-center[1]],cr=Math.cos(rotation/360*Math.PI*2),sr=Math.sin(rotation/360*Math.PI*2);return[(radial[0]*cr)-(radial[1]*sr)+center[0],(radial[1]*cr)+(radial[0]*sr)+center[1],cr,sr]}
jsPlumbUtil.rotatePoint=rotatePoint;function rotateAnchorOrientation(orientation,rotation){var r=rotatePoint(orientation,[0,0],rotation);return[Math.round(r[0]),Math.round(r[1])]}
jsPlumbUtil.rotateAnchorOrientation=rotateAnchorOrientation}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;root.jsPlumbUtil.matchesSelector=function(el,selector,ctx){ctx=ctx||el.parentNode;var possibles=ctx.querySelectorAll(selector);for(var i=0;i<possibles.length;i++){if(possibles[i]===el){return!0}}
return!1};root.jsPlumbUtil.consume=function(e,doNotPreventDefault){if(e.stopPropagation){e.stopPropagation()}else{e.returnValue=!1}
if(!doNotPreventDefault&&e.preventDefault){e.preventDefault()}};root.jsPlumbUtil.sizeElement=function(el,x,y,w,h){if(el){el.style.height=h+"px";el.height=h;el.style.width=w+"px";el.width=w;el.style.left=x+"px";el.style.top=y+"px"}}}).call(typeof window!=='undefined'?window:this);(function(){var DEFAULT_OPTIONS={deriveAnchor:function(edge,index,ep,conn){return{top:["TopRight","TopLeft"],bottom:["BottomRight","BottomLeft"]}[edge][index]}};var root=this;var ListManager=function(jsPlumbInstance,params){this.count=0;this.instance=jsPlumbInstance;this.lists={};this.options=params||{};this.instance.addList=function(el,options){return this.listManager.addList(el,options)};this.instance.removeList=function(el){this.listManager.removeList(el)};this.instance.bind("manageElement",function(p){var scrollableLists=this.instance.getSelector(p.el,"[jtk-scrollable-list]");for(var i=0;i<scrollableLists.length;i++){this.addList(scrollableLists[i])}}.bind(this));this.instance.bind("unmanageElement",function(p){this.removeList(p.el)});this.instance.bind("connection",function(c,evt){if(evt==null){this._maybeUpdateParentList(c.source);this._maybeUpdateParentList(c.target)}}.bind(this))};root.jsPlumbListManager=ListManager;ListManager.prototype={addList:function(el,options){var dp=this.instance.extend({},DEFAULT_OPTIONS);this.instance.extend(dp,this.options);options=this.instance.extend(dp,options||{});var id=[this.instance.getInstanceIndex(),this.count++].join("_");this.lists[id]=new List(this.instance,el,options,id)},removeList:function(el){var list=this.lists[el._jsPlumbList];if(list){list.destroy();delete this.lists[el._jsPlumbList]}},_maybeUpdateParentList:function(el){var parent=el.parentNode,container=this.instance.getContainer();while(parent!=null&&parent!==container){if(parent._jsPlumbList!=null&&this.lists[parent._jsPlumbList]!=null){parent._jsPlumbScrollHandler();return}
parent=parent.parentNode}}};var List=function(instance,el,options,id){el._jsPlumbList=id;function deriveAnchor(edge,index,ep,conn){return options.anchor?options.anchor:options.deriveAnchor(edge,index,ep,conn)}
function deriveEndpoint(edge,index,ep,conn){return options.deriveEndpoint?options.deriveEndpoint(edge,index,ep,conn):options.endpoint?options.endpoint:ep.type}
function _maybeUpdateDraggable(el){var parent=el.parentNode,container=instance.getContainer();while(parent!=null&&parent!==container){if(instance.hasClass(parent,"jtk-managed")){instance.recalculateOffsets(parent);return}
parent=parent.parentNode}}
var scrollHandler=function(e){var children=instance.getSelector(el,".jtk-managed");var elId=instance.getId(el);for(var i=0;i<children.length;i++){if(children[i].offsetTop<el.scrollTop){if(!children[i]._jsPlumbProxies){children[i]._jsPlumbProxies=children[i]._jsPlumbProxies||[];instance.select({source:children[i]}).each(function(c){instance.proxyConnection(c,0,el,elId,function(){return deriveEndpoint("top",0,c.endpoints[0],c)},function(){return deriveAnchor("top",0,c.endpoints[0],c)});children[i]._jsPlumbProxies.push([c,0])});instance.select({target:children[i]}).each(function(c){instance.proxyConnection(c,1,el,elId,function(){return deriveEndpoint("top",1,c.endpoints[1],c)},function(){return deriveAnchor("top",1,c.endpoints[1],c)});children[i]._jsPlumbProxies.push([c,1])})}}else if(children[i].offsetTop+children[i].offsetHeight>el.scrollTop+el.offsetHeight){if(!children[i]._jsPlumbProxies){children[i]._jsPlumbProxies=children[i]._jsPlumbProxies||[];instance.select({source:children[i]}).each(function(c){instance.proxyConnection(c,0,el,elId,function(){return deriveEndpoint("bottom",0,c.endpoints[0],c)},function(){return deriveAnchor("bottom",0,c.endpoints[0],c)});children[i]._jsPlumbProxies.push([c,0])});instance.select({target:children[i]}).each(function(c){instance.proxyConnection(c,1,el,elId,function(){return deriveEndpoint("bottom",1,c.endpoints[1],c)},function(){return deriveAnchor("bottom",1,c.endpoints[1],c)});children[i]._jsPlumbProxies.push([c,1])})}}else if(children[i]._jsPlumbProxies){for(var j=0;j<children[i]._jsPlumbProxies.length;j++){instance.unproxyConnection(children[i]._jsPlumbProxies[j][0],children[i]._jsPlumbProxies[j][1],elId)}
delete children[i]._jsPlumbProxies}
instance.revalidate(children[i])}
_maybeUpdateDraggable(el)};instance.setAttribute(el,"jtk-scrollable-list","true");el._jsPlumbScrollHandler=scrollHandler;instance.on(el,"scroll",scrollHandler);scrollHandler();this.destroy=function(){instance.off(el,"scroll",scrollHandler);delete el._jsPlumbScrollHandler;var children=instance.getSelector(el,".jtk-managed");var elId=instance.getId(el);for(var i=0;i<children.length;i++){if(children[i]._jsPlumbProxies){for(var j=0;j<children[i]._jsPlumbProxies.length;j++){instance.unproxyConnection(children[i]._jsPlumbProxies[j][0],children[i]._jsPlumbProxies[j][1],elId)}
delete children[i]._jsPlumbProxies}}}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this;var _ju=root.jsPlumbUtil,_updateHoverStyle=function(component){if(component._jsPlumb.paintStyle&&component._jsPlumb.hoverPaintStyle){var mergedHoverStyle={};jsPlumb.extend(mergedHoverStyle,component._jsPlumb.paintStyle);jsPlumb.extend(mergedHoverStyle,component._jsPlumb.hoverPaintStyle);delete component._jsPlumb.hoverPaintStyle;if(mergedHoverStyle.gradient&&component._jsPlumb.paintStyle.fill){delete mergedHoverStyle.gradient}
component._jsPlumb.hoverPaintStyle=mergedHoverStyle}},events=["tap","dbltap","click","dblclick","mouseover","mouseout","mousemove","mousedown","mouseup","contextmenu"],eventFilters={"mouseout":"mouseleave","mouseexit":"mouseleave"},_updateAttachedElements=function(component,state,timestamp,sourceElement){var affectedElements=component.getAttachedElements();if(affectedElements){for(var i=0,j=affectedElements.length;i<j;i++){if(!sourceElement||sourceElement!==affectedElements[i]){affectedElements[i].setHover(state,!0,timestamp)}}}},_splitType=function(t){return t==null?null:t.split(" ")},_mapType=function(map,obj,typeId){for(var i in obj){map[i]=typeId}},_each=function(fn,obj){obj=_ju.isArray(obj)||(obj.length!=null&&!_ju.isString(obj))?obj:[obj];for(var i=0;i<obj.length;i++){try{fn.apply(obj[i],[obj[i]])}catch(e){_ju.log(".each iteration failed : "+e)}}},_applyTypes=function(component,params,doNotRepaint){if(component.getDefaultType){var td=component.getTypeDescriptor(),map={};var defType=component.getDefaultType();var o=_ju.merge({},defType);_mapType(map,defType,"__default");for(var i=0,j=component._jsPlumb.types.length;i<j;i++){var tid=component._jsPlumb.types[i];if(tid!=="__default"){var _t=component._jsPlumb.instance.getType(tid,td);if(_t!=null){var overrides=["anchor","anchors","connector","paintStyle","hoverPaintStyle","endpoint","endpoints","connectorOverlays","connectorStyle","connectorHoverStyle","endpointStyle","endpointHoverStyle"];var collations=[];if(_t.mergeStrategy==="override"){Array.prototype.push.apply(overrides,["events","overlays","cssClass"])}else{collations.push("cssClass")}
o=_ju.merge(o,_t,collations,overrides);_mapType(map,_t,tid)}}}
if(params){o=_ju.populate(o,params,"_")}
component.applyType(o,doNotRepaint,map);if(!doNotRepaint){component.repaint()}}},jsPlumbUIComponent=root.jsPlumbUIComponent=function(params){_ju.EventGenerator.apply(this,arguments);var self=this,a=arguments,idPrefix=self.idPrefix,id=idPrefix+(new Date()).getTime();this._jsPlumb={instance:params._jsPlumb,parameters:params.parameters||{},paintStyle:null,hoverPaintStyle:null,paintStyleInUse:null,hover:!1,beforeDetach:params.beforeDetach,beforeDrop:params.beforeDrop,overlayPlacements:[],hoverClass:params.hoverClass||params._jsPlumb.Defaults.HoverClass,types:[],typeCache:{}};this.cacheTypeItem=function(key,item,typeId){this._jsPlumb.typeCache[typeId]=this._jsPlumb.typeCache[typeId]||{};this._jsPlumb.typeCache[typeId][key]=item};this.getCachedTypeItem=function(key,typeId){return this._jsPlumb.typeCache[typeId]?this._jsPlumb.typeCache[typeId][key]:null};this.getId=function(){return id};var o=params.overlays||[],oo={};if(this.defaultOverlayKeys){for(var i=0;i<this.defaultOverlayKeys.length;i++){Array.prototype.push.apply(o,this._jsPlumb.instance.Defaults[this.defaultOverlayKeys[i]]||[])}
for(i=0;i<o.length;i++){var fo=jsPlumb.convertToFullOverlaySpec(o[i]);oo[fo[1].id]=fo}}
var _defaultType={overlays:oo,parameters:params.parameters||{},scope:params.scope||this._jsPlumb.instance.getDefaultScope()};this.getDefaultType=function(){return _defaultType};this.appendToDefaultType=function(obj){for(var i in obj){_defaultType[i]=obj[i]}};if(params.events){for(var evtName in params.events){self.bind(evtName,params.events[evtName])}}
this.clone=function(){var o=Object.create(this.constructor.prototype);this.constructor.apply(o,a);return o}.bind(this);this.isDetachAllowed=function(connection){var r=!0;if(this._jsPlumb.beforeDetach){try{r=this._jsPlumb.beforeDetach(connection)}catch(e){_ju.log("jsPlumb: beforeDetach callback failed",e)}}
return r};this.isDropAllowed=function(sourceId,targetId,scope,connection,dropEndpoint,source,target){var r=this._jsPlumb.instance.checkCondition("beforeDrop",{sourceId:sourceId,targetId:targetId,scope:scope,connection:connection,dropEndpoint:dropEndpoint,source:source,target:target});if(this._jsPlumb.beforeDrop){try{r=this._jsPlumb.beforeDrop({sourceId:sourceId,targetId:targetId,scope:scope,connection:connection,dropEndpoint:dropEndpoint,source:source,target:target})}catch(e){_ju.log("jsPlumb: beforeDrop callback failed",e)}}
return r};var domListeners=[];this.setListenerComponent=function(c){for(var i=0;i<domListeners.length;i++){domListeners[i][3]=c}}};var _removeTypeCssHelper=function(component,typeIndex){var typeId=component._jsPlumb.types[typeIndex],type=component._jsPlumb.instance.getType(typeId,component.getTypeDescriptor());if(type!=null&&type.cssClass&&component.canvas){component._jsPlumb.instance.removeClass(component.canvas,type.cssClass)}};_ju.extend(root.jsPlumbUIComponent,_ju.EventGenerator,{getParameter:function(name){return this._jsPlumb.parameters[name]},setParameter:function(name,value){this._jsPlumb.parameters[name]=value},getParameters:function(){return this._jsPlumb.parameters},setParameters:function(p){this._jsPlumb.parameters=p},getClass:function(){return jsPlumb.getClass(this.canvas)},hasClass:function(clazz){return jsPlumb.hasClass(this.canvas,clazz)},addClass:function(clazz){jsPlumb.addClass(this.canvas,clazz)},removeClass:function(clazz){jsPlumb.removeClass(this.canvas,clazz)},updateClasses:function(classesToAdd,classesToRemove){jsPlumb.updateClasses(this.canvas,classesToAdd,classesToRemove)},setType:function(typeId,params,doNotRepaint){this.clearTypes();this._jsPlumb.types=_splitType(typeId)||[];_applyTypes(this,params,doNotRepaint)},getType:function(){return this._jsPlumb.types},reapplyTypes:function(params,doNotRepaint){_applyTypes(this,params,doNotRepaint)},hasType:function(typeId){return this._jsPlumb.types.indexOf(typeId)!==-1},addType:function(typeId,params,doNotRepaint){var t=_splitType(typeId),_cont=!1;if(t!=null){for(var i=0,j=t.length;i<j;i++){if(!this.hasType(t[i])){this._jsPlumb.types.push(t[i]);_cont=!0}}
if(_cont){_applyTypes(this,params,doNotRepaint)}}},removeType:function(typeId,params,doNotRepaint){var t=_splitType(typeId),_cont=!1,_one=function(tt){var idx=this._jsPlumb.types.indexOf(tt);if(idx!==-1){_removeTypeCssHelper(this,idx);this._jsPlumb.types.splice(idx,1);return!0}
return!1}.bind(this);if(t!=null){for(var i=0,j=t.length;i<j;i++){_cont=_one(t[i])||_cont}
if(_cont){_applyTypes(this,params,doNotRepaint)}}},clearTypes:function(params,doNotRepaint){var i=this._jsPlumb.types.length;for(var j=0;j<i;j++){_removeTypeCssHelper(this,0);this._jsPlumb.types.splice(0,1)}
_applyTypes(this,params,doNotRepaint)},toggleType:function(typeId,params,doNotRepaint){var t=_splitType(typeId);if(t!=null){for(var i=0,j=t.length;i<j;i++){var idx=this._jsPlumb.types.indexOf(t[i]);if(idx!==-1){_removeTypeCssHelper(this,idx);this._jsPlumb.types.splice(idx,1)}else{this._jsPlumb.types.push(t[i])}}
_applyTypes(this,params,doNotRepaint)}},applyType:function(t,doNotRepaint){this.setPaintStyle(t.paintStyle,doNotRepaint);this.setHoverPaintStyle(t.hoverPaintStyle,doNotRepaint);if(t.parameters){for(var i in t.parameters){this.setParameter(i,t.parameters[i])}}
this._jsPlumb.paintStyleInUse=this.getPaintStyle()},setPaintStyle:function(style,doNotRepaint){this._jsPlumb.paintStyle=style;this._jsPlumb.paintStyleInUse=this._jsPlumb.paintStyle;_updateHoverStyle(this);if(!doNotRepaint){this.repaint()}},getPaintStyle:function(){return this._jsPlumb.paintStyle},setHoverPaintStyle:function(style,doNotRepaint){this._jsPlumb.hoverPaintStyle=style;_updateHoverStyle(this);if(!doNotRepaint){this.repaint()}},getHoverPaintStyle:function(){return this._jsPlumb.hoverPaintStyle},destroy:function(force){if(force||this.typeId==null){this.cleanupListeners();this.clone=null;this._jsPlumb=null}},isHover:function(){return this._jsPlumb.hover},setHover:function(hover,ignoreAttachedElements,timestamp){if(this._jsPlumb&&!this._jsPlumb.instance.currentlyDragging&&!this._jsPlumb.instance.isHoverSuspended()){this._jsPlumb.hover=hover;var method=hover?"addClass":"removeClass";if(this.canvas!=null){if(this._jsPlumb.instance.hoverClass!=null){this._jsPlumb.instance[method](this.canvas,this._jsPlumb.instance.hoverClass)}
if(this._jsPlumb.hoverClass!=null){this._jsPlumb.instance[method](this.canvas,this._jsPlumb.hoverClass)}}
if(this._jsPlumb.hoverPaintStyle!=null){this._jsPlumb.paintStyleInUse=hover?this._jsPlumb.hoverPaintStyle:this._jsPlumb.paintStyle;if(!this._jsPlumb.instance.isSuspendDrawing()){timestamp=timestamp||jsPlumbUtil.uuid();this.repaint({timestamp:timestamp,recalc:!1})}}
if(this.getAttachedElements&&!ignoreAttachedElements){_updateAttachedElements(this,hover,jsPlumbUtil.uuid(),this)}}}});var _jsPlumbInstanceIndex=0,getInstanceIndex=function(){var i=_jsPlumbInstanceIndex+1;_jsPlumbInstanceIndex++;return i};var jsPlumbInstance=root.jsPlumbInstance=function(_defaults){this.version="2.15.6";this.Defaults={Anchor:"Bottom",Anchors:[null,null],ConnectionsDetachable:!0,ConnectionOverlays:[],Connector:"Bezier",Container:null,DoNotThrowErrors:!1,DragOptions:{},DropOptions:{},Endpoint:"Dot",EndpointOverlays:[],Endpoints:[null,null],EndpointStyle:{fill:"#456"},EndpointStyles:[null,null],EndpointHoverStyle:null,EndpointHoverStyles:[null,null],HoverPaintStyle:null,LabelStyle:{color:"black"},ListStyle:{},LogEnabled:!1,Overlays:[],MaxConnections:1,PaintStyle:{"stroke-width":4,stroke:"#456"},ReattachConnections:!1,RenderMode:"svg",Scope:"jsPlumb_DefaultScope"};if(_defaults){jsPlumb.extend(this.Defaults,_defaults)}
this.logEnabled=this.Defaults.LogEnabled;this._connectionTypes={};this._endpointTypes={};_ju.EventGenerator.apply(this);var _currentInstance=this,_instanceIndex=getInstanceIndex(),_bb=_currentInstance.bind,_initialDefaults={},_zoom=1,_info=function(el){if(el==null){return null}else if(el.nodeType===3||el.nodeType===8){return{el:el,text:!0}}else{var _el=_currentInstance.getElement(el);return{el:_el,id:(_ju.isString(el)&&_el==null)?el:_getId(_el)}}};this.getInstanceIndex=function(){return _instanceIndex};this.setZoom=function(z,repaintEverything){_zoom=z;_currentInstance.fire("zoom",_zoom);if(repaintEverything){_currentInstance.repaintEverything()}
return!0};this.getZoom=function(){return _zoom};for(var i in this.Defaults){_initialDefaults[i]=this.Defaults[i]}
var _container,_containerDelegations=[];this.unbindContainer=function(){if(_container!=null&&_containerDelegations.length>0){for(var i=0;i<_containerDelegations.length;i++){_currentInstance.off(_container,_containerDelegations[i][0],_containerDelegations[i][1])}}};this.setContainer=function(c){this.unbindContainer();c=this.getElement(c);this.select().each(function(conn){conn.moveParent(c)});this.selectEndpoints().each(function(ep){ep.moveParent(c)});var previousContainer=_container;_container=c;_containerDelegations.length=0;var eventAliases={"endpointclick":"endpointClick","endpointdblclick":"endpointDblClick"};var _oneDelegateHandler=function(id,e,componentType){var t=e.srcElement||e.target,jp=(t&&t.parentNode?t.parentNode._jsPlumb:null)||(t?t._jsPlumb:null)||(t&&t.parentNode&&t.parentNode.parentNode?t.parentNode.parentNode._jsPlumb:null);if(jp){jp.fire(id,jp,e);var alias=componentType?eventAliases[componentType+id]||id:id;_currentInstance.fire(alias,jp.component||jp,e)}};var _addOneDelegate=function(eventId,selector,fn){_containerDelegations.push([eventId,fn]);_currentInstance.on(_container,eventId,selector,fn)};var _oneDelegate=function(id){_addOneDelegate(id,".jtk-connector",function(e){_oneDelegateHandler(id,e)});_addOneDelegate(id,".jtk-endpoint",function(e){_oneDelegateHandler(id,e,"endpoint")});_addOneDelegate(id,".jtk-overlay",function(e){_oneDelegateHandler(id,e)})};for(var i=0;i<events.length;i++){_oneDelegate(events[i])}
for(var elId in managedElements){var el=managedElements[elId].el;if(el.parentNode===previousContainer){previousContainer.removeChild(el);_container.appendChild(el)}}};this.getContainer=function(){return _container};this.bind=function(event,fn){if("ready"===event&&initialized){fn()}else{_bb.apply(_currentInstance,[event,fn])}};_currentInstance.importDefaults=function(d){for(var i in d){_currentInstance.Defaults[i]=d[i]}
if(d.Container){_currentInstance.setContainer(d.Container)}
return _currentInstance};_currentInstance.restoreDefaults=function(){_currentInstance.Defaults=jsPlumb.extend({},_initialDefaults);return _currentInstance};var log=null,initialized=!1,connections=[],endpointsByElement={},endpointsByUUID={},managedElements={},offsets={},offsetTimestamps={},draggableStates={},connectionBeingDragged=!1,sizes=[],_suspendDrawing=!1,_suspendedAt=null,DEFAULT_SCOPE=this.Defaults.Scope,_curIdStamp=1,_idstamp=function(){return""+_curIdStamp++},_appendElement=function(el,parent){if(_container){_container.appendChild(el)}else if(!parent){this.appendToRoot(el)}else{this.getElement(parent).appendChild(el)}}.bind(this),_draw=function(element,ui,timestamp,clearEdits){var drawResult={c:[],e:[]};if(!_suspendDrawing){element=_currentInstance.getElement(element);if(element!=null){var id=_getId(element),repaintEls=element.querySelectorAll(".jtk-managed");if(timestamp==null){timestamp=jsPlumbUtil.uuid()}
var o=_updateOffset({elId:id,offset:ui,recalc:!1,timestamp:timestamp});for(var i=0;i<repaintEls.length;i++){_updateOffset({elId:repaintEls[i].getAttribute("id"),recalc:!0,timestamp:timestamp})}
var d2=_currentInstance.router.redraw(id,ui,timestamp,null,clearEdits);Array.prototype.push.apply(drawResult.c,d2.c);Array.prototype.push.apply(drawResult.e,d2.e);if(repaintEls){for(var j=0;j<repaintEls.length;j++){d2=_currentInstance.router.redraw(repaintEls[j].getAttribute("id"),null,timestamp,null,clearEdits,!0);Array.prototype.push.apply(drawResult.c,d2.c);Array.prototype.push.apply(drawResult.e,d2.e)}}}}
return drawResult},_getEndpoint=function(uuid){return endpointsByUUID[uuid]},_scopeMatch=function(e1,e2){var s1=e1.scope.split(/\s/),s2=e2.scope.split(/\s/);for(var i=0;i<s1.length;i++){for(var j=0;j<s2.length;j++){if(s2[j]===s1[i]){return!0}}}
return!1},_mergeOverrides=function(def,values){var m=jsPlumb.extend({},def);for(var i in values){if(values[i]){m[i]=values[i]}}
return m},_prepareConnectionParams=function(params,referenceParams){var _p=jsPlumb.extend({},params);if(referenceParams){jsPlumb.extend(_p,referenceParams)}
if(_p.source){if(_p.source.endpoint){_p.sourceEndpoint=_p.source}else{_p.source=_currentInstance.getElement(_p.source)}}
if(_p.target){if(_p.target.endpoint){_p.targetEndpoint=_p.target}else{_p.target=_currentInstance.getElement(_p.target)}}
if(params.uuids){_p.sourceEndpoint=_getEndpoint(params.uuids[0]);_p.targetEndpoint=_getEndpoint(params.uuids[1])}
if(_p.sourceEndpoint&&_p.sourceEndpoint.isFull()){_ju.log(_currentInstance,"could not add connection; source endpoint is full");return}
if(_p.targetEndpoint&&_p.targetEndpoint.isFull()){_ju.log(_currentInstance,"could not add connection; target endpoint is full");return}
if(!_p.type&&_p.sourceEndpoint){_p.type=_p.sourceEndpoint.connectionType}
if(_p.sourceEndpoint&&_p.sourceEndpoint.connectorOverlays){_p.overlays=_p.overlays||[];for(var i=0,j=_p.sourceEndpoint.connectorOverlays.length;i<j;i++){_p.overlays.push(_p.sourceEndpoint.connectorOverlays[i])}}
if(_p.sourceEndpoint&&_p.sourceEndpoint.scope){_p.scope=_p.sourceEndpoint.scope}
if(!_p["pointer-events"]&&_p.sourceEndpoint&&_p.sourceEndpoint.connectorPointerEvents){_p["pointer-events"]=_p.sourceEndpoint.connectorPointerEvents}
var _addEndpoint=function(el,def,idx){var params=_mergeOverrides(def,{anchor:_p.anchors?_p.anchors[idx]:_p.anchor,endpoint:_p.endpoints?_p.endpoints[idx]:_p.endpoint,paintStyle:_p.endpointStyles?_p.endpointStyles[idx]:_p.endpointStyle,hoverPaintStyle:_p.endpointHoverStyles?_p.endpointHoverStyles[idx]:_p.endpointHoverStyle});return _currentInstance.addEndpoint(el,params)};var _oneElementDef=function(type,idx,defs,matchType){if(_p[type]&&!_p[type].endpoint&&!_p[type+"Endpoint"]&&!_p.newConnection){var tid=_getId(_p[type]),tep=defs[tid];tep=tep?tep[matchType]:null;if(tep){if(!tep.enabled){return!1}
var epDef=jsPlumb.extend({},tep.def);delete epDef.label;var newEndpoint=tep.endpoint!=null&&tep.endpoint._jsPlumb?tep.endpoint:_addEndpoint(_p[type],epDef,idx);if(newEndpoint.isFull()){return!1}
_p[type+"Endpoint"]=newEndpoint;if(!_p.scope&&epDef.scope){_p.scope=epDef.scope}
if(tep.uniqueEndpoint){if(!tep.endpoint){tep.endpoint=newEndpoint;newEndpoint.setDeleteOnEmpty(!1)}else{newEndpoint.finalEndpoint=tep.endpoint}}else{newEndpoint.setDeleteOnEmpty(!0)}
if(idx===0&&tep.def.connectorOverlays){_p.overlays=_p.overlays||[];Array.prototype.push.apply(_p.overlays,tep.def.connectorOverlays)}}}};if(_oneElementDef("source",0,this.sourceEndpointDefinitions,_p.type||"default")===!1){return}
if(_oneElementDef("target",1,this.targetEndpointDefinitions,_p.type||"default")===!1){return}
if(_p.sourceEndpoint&&_p.targetEndpoint){if(!_scopeMatch(_p.sourceEndpoint,_p.targetEndpoint)){_p=null}}
return _p}.bind(_currentInstance),_newConnection=function(params){var connectionFunc=_currentInstance.Defaults.ConnectionType||_currentInstance.getDefaultConnectionType();params._jsPlumb=_currentInstance;params.newConnection=_newConnection;params.newEndpoint=_newEndpoint;params.endpointsByUUID=endpointsByUUID;params.endpointsByElement=endpointsByElement;params.finaliseConnection=_finaliseConnection;params.id="con_"+_idstamp();var con=new connectionFunc(params);if(con.isDetachable()){con.endpoints[0].initDraggable("_jsPlumbSource");con.endpoints[1].initDraggable("_jsPlumbTarget")}
return con},_finaliseConnection=_currentInstance.finaliseConnection=function(jpc,params,originalEvent,doInformAnchorManager){params=params||{};if(!jpc.suspendedEndpoint){connections.push(jpc)}
jpc.pending=null;jpc.endpoints[0].isTemporarySource=!1;if(doInformAnchorManager!==!1){_currentInstance.router.newConnection(jpc)}
_draw(jpc.source);if(!params.doNotFireConnectionEvent&&params.fireEvent!==!1){var eventArgs={connection:jpc,source:jpc.source,target:jpc.target,sourceId:jpc.sourceId,targetId:jpc.targetId,sourceEndpoint:jpc.endpoints[0],targetEndpoint:jpc.endpoints[1]};_currentInstance.fire("connection",eventArgs,originalEvent)}},_newEndpoint=function(params,id){var endpointFunc=_currentInstance.Defaults.EndpointType||jsPlumb.Endpoint;var _p=jsPlumb.extend({},params);_p._jsPlumb=_currentInstance;_p.newConnection=_newConnection;_p.newEndpoint=_newEndpoint;_p.endpointsByUUID=endpointsByUUID;_p.endpointsByElement=endpointsByElement;_p.fireDetachEvent=fireDetachEvent;_p.elementId=id||_getId(_p.source);var ep=new endpointFunc(_p);ep.id="ep_"+_idstamp();_manage(_p.elementId,_p.source);if(!jsPlumb.headless){_currentInstance.getDragManager().endpointAdded(_p.source,id)}
return ep},_operation=function(elId,func,endpointFunc){var endpoints=endpointsByElement[elId];if(endpoints&&endpoints.length){for(var i=0,ii=endpoints.length;i<ii;i++){for(var j=0,jj=endpoints[i].connections.length;j<jj;j++){var retVal=func(endpoints[i].connections[j]);if(retVal){return}}
if(endpointFunc){endpointFunc(endpoints[i])}}}},_setDraggable=function(element,draggable){return jsPlumb.each(element,function(el){if(_currentInstance.isDragSupported(el)){draggableStates[_currentInstance.getAttribute(el,"id")]=draggable;_currentInstance.setElementDraggable(el,draggable)}})},_setVisible=function(el,state,alsoChangeEndpoints){state=state==="block";var endpointFunc=null;if(alsoChangeEndpoints){endpointFunc=function(ep){ep.setVisible(state,!0,!0)}}
var info=_info(el);_operation(info.id,function(jpc){if(state&&alsoChangeEndpoints){var oidx=jpc.sourceId===info.id?1:0;if(jpc.endpoints[oidx].isVisible()){jpc.setVisible(!0)}}else{jpc.setVisible(state)}},endpointFunc)},_toggleVisible=function(elId,changeEndpoints){var endpointFunc=null;if(changeEndpoints){endpointFunc=function(ep){var state=ep.isVisible();ep.setVisible(!state)}}
_operation(elId,function(jpc){var state=jpc.isVisible();jpc.setVisible(!state)},endpointFunc)},_getCachedData=function(elId){var o=offsets[elId];if(!o){return _updateOffset({elId:elId})}else{return{o:o,s:sizes[elId]}}},_getId=function(element,uuid,doNotCreateIfNotFound){if(_ju.isString(element)){return element}
if(element==null){return null}
var id=_currentInstance.getAttribute(element,"id");if(!id||id==="undefined"){if(arguments.length===2&&arguments[1]!==undefined){id=uuid}else if(arguments.length===1||(arguments.length===3&&!arguments[2])){id="jsPlumb_"+_instanceIndex+"_"+_idstamp()}
if(!doNotCreateIfNotFound){_currentInstance.setAttribute(element,"id",id)}}
return id};this.setConnectionBeingDragged=function(v){connectionBeingDragged=v};this.isConnectionBeingDragged=function(){return connectionBeingDragged};this.getManagedElements=function(){return managedElements};this.connectorClass="jtk-connector";this.connectorOutlineClass="jtk-connector-outline";this.connectedClass="jtk-connected";this.hoverClass="jtk-hover";this.endpointClass="jtk-endpoint";this.endpointConnectedClass="jtk-endpoint-connected";this.endpointFullClass="jtk-endpoint-full";this.endpointDropAllowedClass="jtk-endpoint-drop-allowed";this.endpointDropForbiddenClass="jtk-endpoint-drop-forbidden";this.overlayClass="jtk-overlay";this.draggingClass="jtk-dragging";this.elementDraggingClass="jtk-element-dragging";this.sourceElementDraggingClass="jtk-source-element-dragging";this.targetElementDraggingClass="jtk-target-element-dragging";this.endpointAnchorClassPrefix="jtk-endpoint-anchor";this.hoverSourceClass="jtk-source-hover";this.hoverTargetClass="jtk-target-hover";this.dragSelectClass="jtk-drag-select";this.Anchors={};this.Connectors={"svg":{}};this.Endpoints={"svg":{}};this.Overlays={"svg":{}};this.ConnectorRenderers={};this.SVG="svg";this.addEndpoint=function(el,params,referenceParams){referenceParams=referenceParams||{};var p=jsPlumb.extend({},referenceParams);jsPlumb.extend(p,params);p.endpoint=p.endpoint||_currentInstance.Defaults.Endpoint;p.paintStyle=p.paintStyle||_currentInstance.Defaults.EndpointStyle;var results=[],inputs=(_ju.isArray(el)||(el.length!=null&&!_ju.isString(el)))?el:[el];for(var i=0,j=inputs.length;i<j;i++){p.source=_currentInstance.getElement(inputs[i]);_ensureContainer(p.source);var id=_getId(p.source),e=_newEndpoint(p,id);var myOffset=_manage(id,p.source,null,!_suspendDrawing).info.o;_ju.addToList(endpointsByElement,id,e);if(!_suspendDrawing){e.paint({anchorLoc:e.anchor.compute({xy:[myOffset.left,myOffset.top],wh:sizes[id],element:e,timestamp:_suspendedAt,rotation:this.getRotation(id)}),timestamp:_suspendedAt})}
results.push(e)}
return results.length===1?results[0]:results};this.addEndpoints=function(el,endpoints,referenceParams){var results=[];for(var i=0,j=endpoints.length;i<j;i++){var e=_currentInstance.addEndpoint(el,endpoints[i],referenceParams);if(_ju.isArray(e)){Array.prototype.push.apply(results,e)}else{results.push(e)}}
return results};this.animate=function(el,properties,options){if(!this.animationSupported){return!1}
options=options||{};var del=_currentInstance.getElement(el),id=_getId(del),stepFunction=jsPlumb.animEvents.step,completeFunction=jsPlumb.animEvents.complete;options[stepFunction]=_ju.wrap(options[stepFunction],function(){_currentInstance.revalidate(id)});options[completeFunction]=_ju.wrap(options[completeFunction],function(){_currentInstance.revalidate(id)});_currentInstance.doAnimate(del,properties,options)};this.checkCondition=function(conditionName,args){var l=_currentInstance.getListener(conditionName),r=!0;if(l&&l.length>0){var values=Array.prototype.slice.call(arguments,1);try{for(var i=0,j=l.length;i<j;i++){r=r&&l[i].apply(l[i],values)}}catch(e){_ju.log(_currentInstance,"cannot check condition ["+conditionName+"]"+e)}}
return r};this.connect=function(params,referenceParams){var _p=_prepareConnectionParams(params,referenceParams),jpc;if(_p){if(_p.source==null&&_p.sourceEndpoint==null){_ju.log("Cannot establish connection - source does not exist");return}
if(_p.target==null&&_p.targetEndpoint==null){_ju.log("Cannot establish connection - target does not exist");return}
_ensureContainer(_p.source);jpc=_newConnection(_p);_finaliseConnection(jpc,_p)}
return jpc};var stTypes=[{el:"source",elId:"sourceId",epDefs:"sourceEndpointDefinitions"},{el:"target",elId:"targetId",epDefs:"targetEndpointDefinitions"}];var _set=function(c,el,idx,doNotRepaint){var ep,_st=stTypes[idx],cId=c[_st.elId],cEl=c[_st.el],sid,sep,oldEndpoint=c.endpoints[idx];var evtParams={index:idx,originalSourceId:idx===0?cId:c.sourceId,newSourceId:c.sourceId,originalTargetId:idx===1?cId:c.targetId,newTargetId:c.targetId,connection:c};if(el.constructor===jsPlumb.Endpoint){ep=el;ep.addConnection(c);el=ep.element}else{sid=_getId(el);sep=this[_st.epDefs][sid];if(sid===c[_st.elId]){ep=null}else if(sep){for(var t in sep){if(!sep[t].enabled){return}
ep=sep[t].endpoint!=null&&sep[t].endpoint._jsPlumb?sep[t].endpoint:this.addEndpoint(el,sep[t].def);if(sep[t].uniqueEndpoint){sep[t].endpoint=ep}
ep.addConnection(c)}}else{ep=c.makeEndpoint(idx===0,el,sid)}}
if(ep!=null){oldEndpoint.detachFromConnection(c);c.endpoints[idx]=ep;c[_st.el]=ep.element;c[_st.elId]=ep.elementId;evtParams[idx===0?"newSourceId":"newTargetId"]=ep.elementId;fireMoveEvent(evtParams);if(!doNotRepaint){c.repaint()}}
evtParams.element=el;return evtParams}.bind(this);this.setSource=function(connection,el,doNotRepaint){var p=_set(connection,el,0,doNotRepaint);this.router.sourceOrTargetChanged(p.originalSourceId,p.newSourceId,connection,p.el,0)};this.setTarget=function(connection,el,doNotRepaint){var p=_set(connection,el,1,doNotRepaint);this.router.sourceOrTargetChanged(p.originalTargetId,p.newTargetId,connection,p.el,1)};this.deleteEndpoint=function(object,dontUpdateHover,deleteAttachedObjects){var endpoint=(typeof object==="string")?endpointsByUUID[object]:object;if(endpoint){_currentInstance.deleteObject({endpoint:endpoint,dontUpdateHover:dontUpdateHover,deleteAttachedObjects:deleteAttachedObjects})}
return _currentInstance};this.deleteEveryEndpoint=function(){var _is=_currentInstance.setSuspendDrawing(!0);for(var id in endpointsByElement){var endpoints=endpointsByElement[id];if(endpoints&&endpoints.length){for(var i=0,j=endpoints.length;i<j;i++){_currentInstance.deleteEndpoint(endpoints[i],!0)}}}
endpointsByElement={};managedElements={};endpointsByUUID={};offsets={};offsetTimestamps={};_currentInstance.router.reset();var dm=_currentInstance.getDragManager();if(dm){dm.reset()}
if(!_is){_currentInstance.setSuspendDrawing(!1)}
return _currentInstance};var fireDetachEvent=function(jpc,doFireEvent,originalEvent){var connType=_currentInstance.Defaults.ConnectionType||_currentInstance.getDefaultConnectionType(),argIsConnection=jpc.constructor===connType,params=argIsConnection?{connection:jpc,source:jpc.source,target:jpc.target,sourceId:jpc.sourceId,targetId:jpc.targetId,sourceEndpoint:jpc.endpoints[0],targetEndpoint:jpc.endpoints[1]}:jpc;if(doFireEvent){_currentInstance.fire("connectionDetached",params,originalEvent)}
_currentInstance.fire("internal.connectionDetached",params,originalEvent);_currentInstance.router.connectionDetached(params)};var fireMoveEvent=_currentInstance.fireMoveEvent=function(params,evt){_currentInstance.fire("connectionMoved",params,evt)};this.unregisterEndpoint=function(endpoint){if(endpoint._jsPlumb.uuid){endpointsByUUID[endpoint._jsPlumb.uuid]=null}
_currentInstance.router.deleteEndpoint(endpoint);for(var e in endpointsByElement){var endpoints=endpointsByElement[e];if(endpoints){var newEndpoints=[];for(var i=0,j=endpoints.length;i<j;i++){if(endpoints[i]!==endpoint){newEndpoints.push(endpoints[i])}}
endpointsByElement[e]=newEndpoints}
if(endpointsByElement[e].length<1){delete endpointsByElement[e]}}};var IS_DETACH_ALLOWED="isDetachAllowed";var BEFORE_DETACH="beforeDetach";var CHECK_CONDITION="checkCondition";this.deleteConnection=function(connection,params){if(connection!=null){params=params||{};if(params.force||_ju.functionChain(!0,!1,[[connection.endpoints[0],IS_DETACH_ALLOWED,[connection]],[connection.endpoints[1],IS_DETACH_ALLOWED,[connection]],[connection,IS_DETACH_ALLOWED,[connection]],[_currentInstance,CHECK_CONDITION,[BEFORE_DETACH,connection]]])){connection.setHover(!1);fireDetachEvent(connection,!connection.pending&&params.fireEvent!==!1,params.originalEvent);connection.endpoints[0].detachFromConnection(connection);connection.endpoints[1].detachFromConnection(connection);_ju.removeWithFunction(connections,function(_c){return connection.id===_c.id});connection.cleanup();connection.destroy();return!0}}
return!1};this.deleteEveryConnection=function(params){params=params||{};var count=connections.length,deletedCount=0;_currentInstance.batch(function(){for(var i=0;i<count;i++){deletedCount+=_currentInstance.deleteConnection(connections[0],params)?1:0}});return deletedCount};this.deleteConnectionsForElement=function(el,params){params=params||{};el=_currentInstance.getElement(el);var id=_getId(el),endpoints=endpointsByElement[id];if(endpoints&&endpoints.length){for(var i=0,j=endpoints.length;i<j;i++){endpoints[i].deleteEveryConnection(params)}}
return _currentInstance};this.deleteObject=function(params){var result={endpoints:{},connections:{},endpointCount:0,connectionCount:0},deleteAttachedObjects=params.deleteAttachedObjects!==!1;var unravelConnection=function(connection){if(connection!=null&&result.connections[connection.id]==null){if(!params.dontUpdateHover&&connection._jsPlumb!=null){connection.setHover(!1)}
result.connections[connection.id]=connection;result.connectionCount++}};var unravelEndpoint=function(endpoint){if(endpoint!=null&&result.endpoints[endpoint.id]==null){if(!params.dontUpdateHover&&endpoint._jsPlumb!=null){endpoint.setHover(!1)}
result.endpoints[endpoint.id]=endpoint;result.endpointCount++;if(deleteAttachedObjects){for(var i=0;i<endpoint.connections.length;i++){var c=endpoint.connections[i];unravelConnection(c)}}}};if(params.connection){unravelConnection(params.connection)}else{unravelEndpoint(params.endpoint)}
for(var i in result.connections){var c=result.connections[i];if(c._jsPlumb){_ju.removeWithFunction(connections,function(_c){return c.id===_c.id});fireDetachEvent(c,params.fireEvent===!1?!1:!c.pending,params.originalEvent);var doNotCleanup=params.deleteAttachedObjects==null?null:!params.deleteAttachedObjects;c.endpoints[0].detachFromConnection(c,null,doNotCleanup);c.endpoints[1].detachFromConnection(c,null,doNotCleanup);c.cleanup(!0);c.destroy(!0)}}
for(var j in result.endpoints){var e=result.endpoints[j];if(e._jsPlumb){_currentInstance.unregisterEndpoint(e);e.cleanup(!0);e.destroy(!0)}}
return result};var _setOperation=function(list,func,args,selector){for(var i=0,j=list.length;i<j;i++){list[i][func].apply(list[i],args)}
return selector(list)},_getOperation=function(list,func,args){var out=[];for(var i=0,j=list.length;i<j;i++){out.push([list[i][func].apply(list[i],args),list[i]])}
return out},setter=function(list,func,selector){return function(){return _setOperation(list,func,arguments,selector)}},getter=function(list,func){return function(){return _getOperation(list,func,arguments)}},prepareList=function(input,doNotGetIds){var r=[];if(input){if(typeof input==='string'){if(input==="*"){return input}
r.push(input)}else{if(doNotGetIds){r=input}else{if(input.length){for(var i=0,j=input.length;i<j;i++){r.push(_info(input[i]).id)}}else{r.push(_info(input).id)}}}}
return r},filterList=function(list,value,missingIsFalse){if(list==="*"){return!0}
return list.length>0?list.indexOf(value)!==-1:!missingIsFalse};this.getConnections=function(options,flat){if(!options){options={}}else if(options.constructor===String){options={"scope":options}}
var scope=options.scope||_currentInstance.getDefaultScope(),scopes=prepareList(scope,!0),sources=prepareList(options.source),targets=prepareList(options.target),results=(!flat&&scopes.length>1)?{}:[],_addOne=function(scope,obj){if(!flat&&scopes.length>1){var ss=results[scope];if(ss==null){ss=results[scope]=[]}
ss.push(obj)}else{results.push(obj)}};for(var j=0,jj=connections.length;j<jj;j++){var c=connections[j],sourceId=c.proxies&&c.proxies[0]?c.proxies[0].originalEp.elementId:c.sourceId,targetId=c.proxies&&c.proxies[1]?c.proxies[1].originalEp.elementId:c.targetId;if(filterList(scopes,c.scope)&&filterList(sources,sourceId)&&filterList(targets,targetId)){_addOne(c.scope,c)}}
return results};var _curryEach=function(list,executor){return function(f){for(var i=0,ii=list.length;i<ii;i++){f(list[i])}
return executor(list)}},_curryGet=function(list){return function(idx){return list[idx]}};var _makeCommonSelectHandler=function(list,executor){var out={length:list.length,each:_curryEach(list,executor),get:_curryGet(list)},setters=["setHover","removeAllOverlays","setLabel","addClass","addOverlay","removeOverlay","removeOverlays","showOverlay","hideOverlay","showOverlays","hideOverlays","setPaintStyle","setHoverPaintStyle","setSuspendEvents","setParameter","setParameters","setVisible","repaint","addType","toggleType","removeType","removeClass","setType","bind","unbind"],getters=["getLabel","getOverlay","isHover","getParameter","getParameters","getPaintStyle","getHoverPaintStyle","isVisible","hasType","getType","isSuspendEvents"],i,ii;for(i=0,ii=setters.length;i<ii;i++){out[setters[i]]=setter(list,setters[i],executor)}
for(i=0,ii=getters.length;i<ii;i++){out[getters[i]]=getter(list,getters[i])}
return out};var _makeConnectionSelectHandler=function(list){var common=_makeCommonSelectHandler(list,_makeConnectionSelectHandler);return jsPlumb.extend(common,{setDetachable:setter(list,"setDetachable",_makeConnectionSelectHandler),setReattach:setter(list,"setReattach",_makeConnectionSelectHandler),setConnector:setter(list,"setConnector",_makeConnectionSelectHandler),delete:function(){for(var i=0,ii=list.length;i<ii;i++){_currentInstance.deleteConnection(list[i])}},isDetachable:getter(list,"isDetachable"),isReattach:getter(list,"isReattach")})};var _makeEndpointSelectHandler=function(list){var common=_makeCommonSelectHandler(list,_makeEndpointSelectHandler);return jsPlumb.extend(common,{setEnabled:setter(list,"setEnabled",_makeEndpointSelectHandler),setAnchor:setter(list,"setAnchor",_makeEndpointSelectHandler),isEnabled:getter(list,"isEnabled"),deleteEveryConnection:function(){for(var i=0,ii=list.length;i<ii;i++){list[i].deleteEveryConnection()}},"delete":function(){for(var i=0,ii=list.length;i<ii;i++){_currentInstance.deleteEndpoint(list[i])}}})};this.select=function(params){params=params||{};params.scope=params.scope||"*";return _makeConnectionSelectHandler(params.connections||_currentInstance.getConnections(params,!0))};this.selectEndpoints=function(params){params=params||{};params.scope=params.scope||"*";var noElementFilters=!params.element&&!params.source&&!params.target,elements=noElementFilters?"*":prepareList(params.element),sources=noElementFilters?"*":prepareList(params.source),targets=noElementFilters?"*":prepareList(params.target),scopes=prepareList(params.scope,!0);var ep=[];for(var el in endpointsByElement){var either=filterList(elements,el,!0),source=filterList(sources,el,!0),sourceMatchExact=sources!=="*",target=filterList(targets,el,!0),targetMatchExact=targets!=="*";if(either||source||target){inner:for(var i=0,ii=endpointsByElement[el].length;i<ii;i++){var _ep=endpointsByElement[el][i];if(filterList(scopes,_ep.scope,!0)){var noMatchSource=(sourceMatchExact&&sources.length>0&&!_ep.isSource),noMatchTarget=(targetMatchExact&&targets.length>0&&!_ep.isTarget);if(noMatchSource||noMatchTarget){continue inner}
ep.push(_ep)}}}}
return _makeEndpointSelectHandler(ep)};this.getAllConnections=function(){return connections};this.getDefaultScope=function(){return DEFAULT_SCOPE};this.getEndpoint=_getEndpoint;this.getEndpoints=function(el){return endpointsByElement[_info(el).id]||[]};this.getDefaultEndpointType=function(){return jsPlumb.Endpoint};this.getDefaultConnectionType=function(){return jsPlumb.Connection};this.getId=_getId;this.draw=_draw;this.info=_info;this.appendElement=_appendElement;var _hoverSuspended=!1;this.isHoverSuspended=function(){return _hoverSuspended};this.setHoverSuspended=function(s){_hoverSuspended=s};this.hide=function(el,changeEndpoints){_setVisible(el,"none",changeEndpoints);return _currentInstance};this.idstamp=_idstamp;var _ensureContainer=function(candidate){if(!_container&&candidate){var can=_currentInstance.getElement(candidate);if(can.offsetParent){_currentInstance.setContainer(can.offsetParent)}}};var _getContainerFromDefaults=function(){if(_currentInstance.Defaults.Container){_currentInstance.setContainer(_currentInstance.Defaults.Container)}};var _manage=_currentInstance.manage=function(id,element,_transient,_recalc){if(!managedElements[id]){managedElements[id]={el:element,endpoints:[],connections:[],rotation:0};managedElements[id].info=_updateOffset({elId:id,timestamp:_suspendedAt});_currentInstance.addClass(element,"jtk-managed");if(!_transient){_currentInstance.fire("manageElement",{id:id,info:managedElements[id].info,el:element})}}else{if(_recalc){managedElements[id].info=_updateOffset({elId:id,timestamp:_suspendedAt,recalc:!0})}}
return managedElements[id]};this.unmanage=function(id){if(managedElements[id]){var el=managedElements[id].el;_currentInstance.removeClass(el,"jtk-managed");delete managedElements[id];_currentInstance.fire("unmanageElement",{id:id,el:el})}};this.rotate=function(elId,amountInDegrees,doNotRedraw){if(managedElements[elId]){managedElements[elId].rotation=amountInDegrees;managedElements[elId].el.style.transform="rotate("+amountInDegrees+"deg)";managedElements[elId].el.style.transformOrigin="center center";if(doNotRedraw!==!0){return this.revalidate(elId)}}
return{c:[],e:[]}};this.getRotation=function(elementId){return managedElements[elementId]?managedElements[elementId].rotation||0:0};var _updateOffset=function(params){var timestamp=params.timestamp,recalc=params.recalc,offset=params.offset,elId=params.elId,s;if(_suspendDrawing&&!timestamp){timestamp=_suspendedAt}
if(!recalc){if(timestamp&&timestamp===offsetTimestamps[elId]){return{o:params.offset||offsets[elId],s:sizes[elId]}}}
if(recalc||(!offset&&offsets[elId]==null)){s=managedElements[elId]?managedElements[elId].el:null;if(s!=null){sizes[elId]=_currentInstance.getSize(s);offsets[elId]=_currentInstance.getOffset(s);offsetTimestamps[elId]=timestamp}}else{offsets[elId]=offset||offsets[elId];if(sizes[elId]==null){s=managedElements[elId].el;if(s!=null){sizes[elId]=_currentInstance.getSize(s)}}
offsetTimestamps[elId]=timestamp}
if(offsets[elId]&&!offsets[elId].right){offsets[elId].right=offsets[elId].left+sizes[elId][0];offsets[elId].bottom=offsets[elId].top+sizes[elId][1];offsets[elId].width=sizes[elId][0];offsets[elId].height=sizes[elId][1];offsets[elId].centerx=offsets[elId].left+(offsets[elId].width/2);offsets[elId].centery=offsets[elId].top+(offsets[elId].height/2)}
return{o:offsets[elId],s:sizes[elId]}};this.updateOffset=_updateOffset;this.init=function(){if(!initialized){_getContainerFromDefaults();_currentInstance.router=new root.jsPlumb.DefaultRouter(_currentInstance);_currentInstance.anchorManager=_currentInstance.router.anchorManager;initialized=!0;_currentInstance.fire("ready",_currentInstance)}}.bind(this);this.log=log;this.jsPlumbUIComponent=jsPlumbUIComponent;this.makeAnchor=function(){var pp,_a=function(t,p){if(root.jsPlumb.Anchors[t]){return new root.jsPlumb.Anchors[t](p)}
if(!_currentInstance.Defaults.DoNotThrowErrors){throw{msg:"jsPlumb: unknown anchor type '"+t+"'"}}};if(arguments.length===0){return null}
var specimen=arguments[0],elementId=arguments[1],jsPlumbInstance=arguments[2],newAnchor=null;if(specimen.compute&&specimen.getOrientation){return specimen}else if(typeof specimen==="string"){newAnchor=_a(arguments[0],{elementId:elementId,jsPlumbInstance:_currentInstance})}else if(_ju.isArray(specimen)){if(_ju.isArray(specimen[0])||_ju.isString(specimen[0])){if(specimen.length===2&&_ju.isObject(specimen[1])){if(_ju.isString(specimen[0])){pp=root.jsPlumb.extend({elementId:elementId,jsPlumbInstance:_currentInstance},specimen[1]);newAnchor=_a(specimen[0],pp)}else{pp=root.jsPlumb.extend({elementId:elementId,jsPlumbInstance:_currentInstance,anchors:specimen[0]},specimen[1]);newAnchor=new root.jsPlumb.DynamicAnchor(pp)}}else{newAnchor=new jsPlumb.DynamicAnchor({anchors:specimen,selector:null,elementId:elementId,jsPlumbInstance:_currentInstance})}}else{var anchorParams={x:specimen[0],y:specimen[1],orientation:(specimen.length>=4)?[specimen[2],specimen[3]]:[0,0],offsets:(specimen.length>=6)?[specimen[4],specimen[5]]:[0,0],elementId:elementId,jsPlumbInstance:_currentInstance,cssClass:specimen.length===7?specimen[6]:null};newAnchor=new root.jsPlumb.Anchor(anchorParams);newAnchor.clone=function(){return new root.jsPlumb.Anchor(anchorParams)}}}
if(!newAnchor.id){newAnchor.id="anchor_"+_idstamp()}
return newAnchor};this.makeAnchors=function(types,elementId,jsPlumbInstance){var r=[];for(var i=0,ii=types.length;i<ii;i++){if(typeof types[i]==="string"){r.push(root.jsPlumb.Anchors[types[i]]({elementId:elementId,jsPlumbInstance:jsPlumbInstance}))}else if(_ju.isArray(types[i])){r.push(_currentInstance.makeAnchor(types[i],elementId,jsPlumbInstance))}}
return r};this.makeDynamicAnchor=function(anchors,anchorSelector){return new root.jsPlumb.DynamicAnchor({anchors:anchors,selector:anchorSelector,elementId:null,jsPlumbInstance:_currentInstance})};this.targetEndpointDefinitions={};this.sourceEndpointDefinitions={};var selectorFilter=function(evt,_el,selector,_instance,negate){var t=evt.target||evt.srcElement,ok=!1,sel=_instance.getSelector(_el,selector);for(var j=0;j<sel.length;j++){if(sel[j]===t){ok=!0;break}}
return negate?!ok:ok};var _makeElementDropHandler=function(elInfo,p,dropOptions,isSource,isTarget){var proxyComponent=new jsPlumbUIComponent(p);var _drop=p._jsPlumb.EndpointDropHandler({jsPlumb:_currentInstance,enabled:function(){return elInfo.def.enabled},isFull:function(){var targetCount=_currentInstance.select({target:elInfo.id}).length;return elInfo.def.maxConnections>0&&targetCount>=elInfo.def.maxConnections},element:elInfo.el,elementId:elInfo.id,isSource:isSource,isTarget:isTarget,addClass:function(clazz){_currentInstance.addClass(elInfo.el,clazz)},removeClass:function(clazz){_currentInstance.removeClass(elInfo.el,clazz)},onDrop:function(jpc){var source=jpc.endpoints[0];source.anchor.locked=!1},isDropAllowed:function(){return proxyComponent.isDropAllowed.apply(proxyComponent,arguments)},isRedrop:function(jpc){return(jpc.suspendedElement!=null&&jpc.suspendedEndpoint!=null&&jpc.suspendedEndpoint.element===elInfo.el)},getEndpoint:function(jpc){var newEndpoint=elInfo.def.endpoint;if(newEndpoint==null||newEndpoint._jsPlumb==null){var eps=_currentInstance.deriveEndpointAndAnchorSpec(jpc.getType().join(" "),!0);var pp=eps.endpoints?root.jsPlumb.extend(p,{endpoint:elInfo.def.def.endpoint||eps.endpoints[1]}):p;if(eps.anchors){pp=root.jsPlumb.extend(pp,{anchor:elInfo.def.def.anchor||eps.anchors[1]})}
newEndpoint=_currentInstance.addEndpoint(elInfo.el,pp);newEndpoint._mtNew=!0}
if(p.uniqueEndpoint){elInfo.def.endpoint=newEndpoint}
newEndpoint.setDeleteOnEmpty(!0);if(jpc.isDetachable()){newEndpoint.initDraggable()}
if(newEndpoint.anchor.positionFinder!=null){var dropPosition=_currentInstance.getUIPosition(arguments,_currentInstance.getZoom()),elPosition=_currentInstance.getOffset(elInfo.el),elSize=_currentInstance.getSize(elInfo.el),ap=dropPosition==null?[0,0]:newEndpoint.anchor.positionFinder(dropPosition,elPosition,elSize,newEndpoint.anchor.constructorParams);newEndpoint.anchor.x=ap[0];newEndpoint.anchor.y=ap[1]}
return newEndpoint},maybeCleanup:function(ep){if(ep._mtNew&&ep.connections.length===0){_currentInstance.deleteObject({endpoint:ep})}else{delete ep._mtNew}}});var dropEvent=root.jsPlumb.dragEvents.drop;dropOptions.scope=dropOptions.scope||(p.scope||_currentInstance.Defaults.Scope);dropOptions[dropEvent]=_ju.wrap(dropOptions[dropEvent],_drop,!0);dropOptions.rank=p.rank||0;if(isTarget){dropOptions[root.jsPlumb.dragEvents.over]=function(){return!0}}
if(p.allowLoopback===!1){dropOptions.canDrop=function(_drag){var de=_drag.getDragElement()._jsPlumbRelatedElement;return de!==elInfo.el}}
_currentInstance.initDroppable(elInfo.el,dropOptions,"internal");return _drop};this.makeTarget=function(el,params,referenceParams){var p=root.jsPlumb.extend({_jsPlumb:this},referenceParams);root.jsPlumb.extend(p,params);var maxConnections=p.maxConnections||-1,_doOne=function(el){var elInfo=_info(el),elid=elInfo.id,dropOptions=root.jsPlumb.extend({},p.dropOptions||{}),type=p.connectionType||"default";this.targetEndpointDefinitions[elid]=this.targetEndpointDefinitions[elid]||{};_ensureContainer(elid);if(elInfo.el._isJsPlumbGroup&&dropOptions.rank==null){dropOptions.rank=-1}
var _def={def:root.jsPlumb.extend({},p),uniqueEndpoint:p.uniqueEndpoint,maxConnections:maxConnections,enabled:!0};if(p.createEndpoint){_def.uniqueEndpoint=!0;_def.endpoint=_currentInstance.addEndpoint(el,_def.def);_def.endpoint.setDeleteOnEmpty(!1)}
elInfo.def=_def;this.targetEndpointDefinitions[elid][type]=_def;_makeElementDropHandler(elInfo,p,dropOptions,p.isSource===!0,!0);elInfo.el._katavorioDrop[elInfo.el._katavorioDrop.length-1].targetDef=_def}.bind(this);var inputs=el.length&&el.constructor!==String?el:[el];for(var i=0,ii=inputs.length;i<ii;i++){_doOne(inputs[i])}
return this};this.unmakeTarget=function(el,doNotClearArrays){var info=_info(el);_currentInstance.destroyDroppable(info.el,"internal");if(!doNotClearArrays){delete this.targetEndpointDefinitions[info.id]}
return this};this.makeSource=function(el,params,referenceParams){var p=root.jsPlumb.extend({_jsPlumb:this},referenceParams);root.jsPlumb.extend(p,params);var type=p.connectionType||"default";var aae=_currentInstance.deriveEndpointAndAnchorSpec(type);p.endpoint=p.endpoint||aae.endpoints[0];p.anchor=p.anchor||aae.anchors[0];var maxConnections=p.maxConnections||-1,onMaxConnections=p.onMaxConnections,_doOne=function(elInfo){var elid=elInfo.id,_del=this.getElement(elInfo.el);this.sourceEndpointDefinitions[elid]=this.sourceEndpointDefinitions[elid]||{};_ensureContainer(elid);var _def={def:root.jsPlumb.extend({},p),uniqueEndpoint:p.uniqueEndpoint,maxConnections:maxConnections,enabled:!0};if(p.createEndpoint){_def.uniqueEndpoint=!0;_def.endpoint=_currentInstance.addEndpoint(el,_def.def);_def.endpoint.setDeleteOnEmpty(!1)}
this.sourceEndpointDefinitions[elid][type]=_def;elInfo.def=_def;var stopEvent=root.jsPlumb.dragEvents.stop,dragEvent=root.jsPlumb.dragEvents.drag,dragOptions=root.jsPlumb.extend({},p.dragOptions||{}),existingDrag=dragOptions.drag,existingStop=dragOptions.stop,ep=null,endpointAddedButNoDragYet=!1;dragOptions.scope=dragOptions.scope||p.scope;dragOptions[dragEvent]=_ju.wrap(dragOptions[dragEvent],function(){if(existingDrag){existingDrag.apply(this,arguments)}
endpointAddedButNoDragYet=!1});dragOptions[stopEvent]=_ju.wrap(dragOptions[stopEvent],function(){if(existingStop){existingStop.apply(this,arguments)}
this.currentlyDragging=!1;if(ep._jsPlumb!=null){var anchorDef=p.anchor||this.Defaults.Anchor,oldAnchor=ep.anchor,oldConnection=ep.connections[0];var newAnchor=this.makeAnchor(anchorDef,elid,this),_el=ep.element;if(newAnchor.positionFinder!=null){var elPosition=_currentInstance.getOffset(_el),elSize=this.getSize(_el),dropPosition={left:elPosition.left+(oldAnchor.x*elSize[0]),top:elPosition.top+(oldAnchor.y*elSize[1])},ap=newAnchor.positionFinder(dropPosition,elPosition,elSize,newAnchor.constructorParams);newAnchor.x=ap[0];newAnchor.y=ap[1]}
ep.setAnchor(newAnchor,!0);ep.repaint();this.repaint(ep.elementId);if(oldConnection!=null){this.repaint(oldConnection.targetId)}}}.bind(this));var mouseDownListener=function(e){if(e.which===3||e.button===2){return}
elid=this.getId(this.getElement(elInfo.el));var def=this.sourceEndpointDefinitions[elid][type];if(!def.enabled){return}
if(p.filter){var r=_ju.isString(p.filter)?selectorFilter(e,elInfo.el,p.filter,this,p.filterExclude):p.filter(e,elInfo.el);if(r===!1){return}}
var sourceCount=this.select({source:elid}).length;if(def.maxConnections>=0&&(sourceCount>=def.maxConnections)){if(onMaxConnections){onMaxConnections({element:elInfo.el,maxConnections:maxConnections},e)}
return!1}
var elxy=root.jsPlumb.getPositionOnElement(e,_del,_zoom);var tempEndpointParams={};root.jsPlumb.extend(tempEndpointParams,def.def);tempEndpointParams.isTemporarySource=!0;tempEndpointParams.anchor=[elxy[0],elxy[1],0,0];tempEndpointParams.dragOptions=dragOptions;if(def.def.scope){tempEndpointParams.scope=def.def.scope}
ep=this.addEndpoint(elid,tempEndpointParams);endpointAddedButNoDragYet=!0;ep.setDeleteOnEmpty(!0);if(def.uniqueEndpoint){if(!def.endpoint){def.endpoint=ep;ep.setDeleteOnEmpty(!1)}else{ep.finalEndpoint=def.endpoint}}
var _delTempEndpoint=function(){_currentInstance.off(ep.canvas,"mouseup",_delTempEndpoint);_currentInstance.off(elInfo.el,"mouseup",_delTempEndpoint);if(endpointAddedButNoDragYet){endpointAddedButNoDragYet=!1;_currentInstance.deleteEndpoint(ep)}};_currentInstance.on(ep.canvas,"mouseup",_delTempEndpoint);_currentInstance.on(elInfo.el,"mouseup",_delTempEndpoint);var payload={};if(def.def.extract){for(var att in def.def.extract){var v=(e.srcElement||e.target).getAttribute(att);if(v){payload[def.def.extract[att]]=v}}}
_currentInstance.trigger(ep.canvas,"mousedown",e,payload);_ju.consume(e)}.bind(this);this.on(elInfo.el,"mousedown",mouseDownListener);_def.trigger=mouseDownListener;if(p.filter&&(_ju.isString(p.filter)||_ju.isFunction(p.filter))){_currentInstance.setDragFilter(elInfo.el,p.filter)}
var dropOptions=root.jsPlumb.extend({},p.dropOptions||{});_makeElementDropHandler(elInfo,p,dropOptions,!0,p.isTarget===!0)}.bind(this);var inputs=el.length&&el.constructor!==String?el:[el];for(var i=0,ii=inputs.length;i<ii;i++){_doOne(_info(inputs[i]))}
return this};this.unmakeSource=function(el,connectionType,doNotClearArrays){var info=_info(el);_currentInstance.destroyDroppable(info.el,"internal");var eldefs=this.sourceEndpointDefinitions[info.id];if(eldefs){for(var def in eldefs){if(connectionType==null||connectionType===def){var mouseDownListener=eldefs[def].trigger;if(mouseDownListener){_currentInstance.off(info.el,"mousedown",mouseDownListener)}
if(!doNotClearArrays){delete this.sourceEndpointDefinitions[info.id][def]}}}}
return this};this.unmakeEverySource=function(){for(var i in this.sourceEndpointDefinitions){_currentInstance.unmakeSource(i,null,!0)}
this.sourceEndpointDefinitions={};return this};var _getScope=function(el,types,connectionType){types=_ju.isArray(types)?types:[types];var id=_getId(el);connectionType=connectionType||"default";for(var i=0;i<types.length;i++){var eldefs=this[types[i]][id];if(eldefs&&eldefs[connectionType]){return eldefs[connectionType].def.scope||this.Defaults.Scope}}}.bind(this);var _setScope=function(el,scope,types,connectionType){types=_ju.isArray(types)?types:[types];var id=_getId(el);connectionType=connectionType||"default";for(var i=0;i<types.length;i++){var eldefs=this[types[i]][id];if(eldefs&&eldefs[connectionType]){eldefs[connectionType].def.scope=scope}}}.bind(this);this.getScope=function(el,scope){return _getScope(el,["sourceEndpointDefinitions","targetEndpointDefinitions"])};this.getSourceScope=function(el){return _getScope(el,"sourceEndpointDefinitions")};this.getTargetScope=function(el){return _getScope(el,"targetEndpointDefinitions")};this.setScope=function(el,scope,connectionType){this.setSourceScope(el,scope,connectionType);this.setTargetScope(el,scope,connectionType)};this.setSourceScope=function(el,scope,connectionType){_setScope(el,scope,"sourceEndpointDefinitions",connectionType);this.setDragScope(el,scope)};this.setTargetScope=function(el,scope,connectionType){_setScope(el,scope,"targetEndpointDefinitions",connectionType);this.setDropScope(el,scope)};this.unmakeEveryTarget=function(){for(var i in this.targetEndpointDefinitions){_currentInstance.unmakeTarget(i,!0)}
this.targetEndpointDefinitions={};return this};var _setEnabled=function(type,el,state,toggle,connectionType){var a=type==="source"?this.sourceEndpointDefinitions:this.targetEndpointDefinitions,originalState,info,newState;connectionType=connectionType||"default";if(el.length&&!_ju.isString(el)){originalState=[];for(var i=0,ii=el.length;i<ii;i++){info=_info(el[i]);if(a[info.id]&&a[info.id][connectionType]){originalState[i]=a[info.id][connectionType].enabled;newState=toggle?!originalState[i]:state;a[info.id][connectionType].enabled=newState;_currentInstance[newState?"removeClass":"addClass"](info.el,"jtk-"+type+"-disabled")}}}else{info=_info(el);var id=info.id;if(a[id]&&a[id][connectionType]){originalState=a[id][connectionType].enabled;newState=toggle?!originalState:state;a[id][connectionType].enabled=newState;_currentInstance[newState?"removeClass":"addClass"](info.el,"jtk-"+type+"-disabled")}}
return originalState}.bind(this);var _first=function(el,fn){if(el!=null){if(_ju.isString(el)||!el.length){return fn.apply(this,[el])}else if(el.length){return fn.apply(this,[el[0]])}}}.bind(this);this.toggleSourceEnabled=function(el,connectionType){_setEnabled("source",el,null,!0,connectionType);return this.isSourceEnabled(el,connectionType)};this.setSourceEnabled=function(el,state,connectionType){return _setEnabled("source",el,state,null,connectionType)};this.isSource=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var eldefs=this.sourceEndpointDefinitions[_info(_el).id];return eldefs!=null&&eldefs[connectionType]!=null}.bind(this))};this.isSourceEnabled=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var sep=this.sourceEndpointDefinitions[_info(_el).id];return sep&&sep[connectionType]&&sep[connectionType].enabled===!0}.bind(this))};this.toggleTargetEnabled=function(el,connectionType){_setEnabled("target",el,null,!0,connectionType);return this.isTargetEnabled(el,connectionType)};this.isTarget=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var eldefs=this.targetEndpointDefinitions[_info(_el).id];return eldefs!=null&&eldefs[connectionType]!=null}.bind(this))};this.isTargetEnabled=function(el,connectionType){connectionType=connectionType||"default";return _first(el,function(_el){var tep=this.targetEndpointDefinitions[_info(_el).id];return tep&&tep[connectionType]&&tep[connectionType].enabled===!0}.bind(this))};this.setTargetEnabled=function(el,state,connectionType){return _setEnabled("target",el,state,null,connectionType)};this.ready=function(fn){_currentInstance.bind("ready",fn)};var _elEach=function(el,fn){if(typeof el==='object'&&el.length){for(var i=0,ii=el.length;i<ii;i++){fn(el[i])}}else{fn(el)}
return _currentInstance};this.repaint=function(el,ui,timestamp){return _elEach(el,function(_el){_draw(_el,ui,timestamp)})};this.revalidate=function(el,timestamp,isIdAlready){var elId=isIdAlready?el:_currentInstance.getId(el);_currentInstance.updateOffset({elId:elId,recalc:!0,timestamp:timestamp});var dm=_currentInstance.getDragManager();if(dm){dm.updateOffsets(elId)}
return _draw(el,null,timestamp)};this.repaintEverything=function(){var timestamp=jsPlumbUtil.uuid(),elId;for(elId in endpointsByElement){_currentInstance.updateOffset({elId:elId,recalc:!0,timestamp:timestamp})}
for(elId in endpointsByElement){_draw(elId,null,timestamp)}
return this};this.removeAllEndpoints=function(el,recurse,affectedElements){affectedElements=affectedElements||[];var _one=function(_el){var info=_info(_el),ebe=endpointsByElement[info.id],i,ii;if(ebe){affectedElements.push(info);for(i=0,ii=ebe.length;i<ii;i++){_currentInstance.deleteEndpoint(ebe[i],!1)}}
delete endpointsByElement[info.id];if(recurse){if(info.el&&info.el.nodeType!==3&&info.el.nodeType!==8){for(i=0,ii=info.el.childNodes.length;i<ii;i++){_one(info.el.childNodes[i])}}}};_one(el);return this};var _doRemove=function(info,affectedElements){_currentInstance.removeAllEndpoints(info.id,!0,affectedElements);var dm=_currentInstance.getDragManager();var _one=function(_info){if(dm){dm.elementRemoved(_info.id)}
_currentInstance.router.elementRemoved(_info.id);if(_currentInstance.isSource(_info.el)){_currentInstance.unmakeSource(_info.el)}
if(_currentInstance.isTarget(_info.el)){_currentInstance.unmakeTarget(_info.el)}
_currentInstance.destroyDraggable(_info.el);_currentInstance.destroyDroppable(_info.el);delete _currentInstance.floatingConnections[_info.id];delete managedElements[_info.id];delete offsets[_info.id];if(_info.el){_currentInstance.removeElement(_info.el);_info.el._jsPlumb=null}};for(var ae=1;ae<affectedElements.length;ae++){_one(affectedElements[ae])}
_one(info)};this.remove=function(el,doNotRepaint){var info=_info(el),affectedElements=[];if(info.text&&info.el.parentNode){info.el.parentNode.removeChild(info.el)}else if(info.id){_currentInstance.batch(function(){_doRemove(info,affectedElements)},doNotRepaint===!0)}
return _currentInstance};this.empty=function(el,doNotRepaint){var affectedElements=[];var _one=function(el,dontRemoveFocus){var info=_info(el);if(info.text){info.el.parentNode.removeChild(info.el)}else if(info.el){while(info.el.childNodes.length>0){_one(info.el.childNodes[0])}
if(!dontRemoveFocus){_doRemove(info,affectedElements)}}};_currentInstance.batch(function(){_one(el,!0)},doNotRepaint===!1);return _currentInstance};this.reset=function(doNotUnbindInstanceEventListeners){_currentInstance.silently(function(){_hoverSuspended=!1;_currentInstance.removeAllGroups();_currentInstance.removeGroupManager();_currentInstance.deleteEveryEndpoint();if(!doNotUnbindInstanceEventListeners){_currentInstance.unbind()}
this.targetEndpointDefinitions={};this.sourceEndpointDefinitions={};connections.length=0;if(this.doReset){this.doReset()}}.bind(this))};this.destroy=function(){this.reset();_container=null;_containerDelegations=null};var _clearObject=function(obj){if(obj.canvas&&obj.canvas.parentNode){obj.canvas.parentNode.removeChild(obj.canvas)}
obj.cleanup();obj.destroy()};this.clear=function(){_currentInstance.select().each(_clearObject);_currentInstance.selectEndpoints().each(_clearObject);endpointsByElement={};endpointsByUUID={}};this.setDefaultScope=function(scope){DEFAULT_SCOPE=scope;return _currentInstance};this.deriveEndpointAndAnchorSpec=function(type,dontPrependDefault){var bits=((dontPrependDefault?"":"default ")+type).split(/[\s]/),eps=null,ep=null,a=null,as=null;for(var i=0;i<bits.length;i++){var _t=_currentInstance.getType(bits[i],"connection");if(_t){if(_t.endpoints){eps=_t.endpoints}
if(_t.endpoint){ep=_t.endpoint}
if(_t.anchors){as=_t.anchors}
if(_t.anchor){a=_t.anchor}}}
return{endpoints:eps?eps:[ep,ep],anchors:as?as:[a,a]}};this.setId=function(el,newId,doNotSetAttribute){var id;if(_ju.isString(el)){id=el}else{el=this.getElement(el);id=this.getId(el)}
var sConns=this.getConnections({source:id,scope:'*'},!0),tConns=this.getConnections({target:id,scope:'*'},!0);newId=""+newId;if(!doNotSetAttribute){el=this.getElement(id);this.setAttribute(el,"id",newId)}else{el=this.getElement(newId)}
endpointsByElement[newId]=endpointsByElement[id]||[];for(var i=0,ii=endpointsByElement[newId].length;i<ii;i++){endpointsByElement[newId][i].setElementId(newId);endpointsByElement[newId][i].setReferenceElement(el)}
delete endpointsByElement[id];this.sourceEndpointDefinitions[newId]=this.sourceEndpointDefinitions[id];delete this.sourceEndpointDefinitions[id];this.targetEndpointDefinitions[newId]=this.targetEndpointDefinitions[id];delete this.targetEndpointDefinitions[id];this.router.changeId(id,newId);var dm=this.getDragManager();if(dm){dm.changeId(id,newId)}
managedElements[newId]=managedElements[id];delete managedElements[id];var _conns=function(list,epIdx,type){for(var i=0,ii=list.length;i<ii;i++){list[i].endpoints[epIdx].setElementId(newId);list[i].endpoints[epIdx].setReferenceElement(el);list[i][type+"Id"]=newId;list[i][type]=el}};_conns(sConns,0,"source");_conns(tConns,1,"target");this.repaint(newId)};this.setDebugLog=function(debugLog){log=debugLog};this.setSuspendDrawing=function(val,repaintAfterwards){var curVal=_suspendDrawing;_suspendDrawing=val;if(val){_suspendedAt=new Date().getTime()}else{_suspendedAt=null}
if(repaintAfterwards){this.repaintEverything()}
return curVal};this.isSuspendDrawing=function(){return _suspendDrawing};this.getSuspendedAt=function(){return _suspendedAt};this.batch=function(fn,doNotRepaintAfterwards){var _wasSuspended=this.isSuspendDrawing();if(!_wasSuspended){this.setSuspendDrawing(!0)}
try{fn()}catch(e){_ju.log("Function run while suspended failed",e)}
if(!_wasSuspended){this.setSuspendDrawing(!1,!doNotRepaintAfterwards)}};this.doWhileSuspended=this.batch;this.getCachedData=_getCachedData;this.show=function(el,changeEndpoints){_setVisible(el,"block",changeEndpoints);return _currentInstance};this.toggleVisible=_toggleVisible;this.addListener=this.bind;var floatingConnections=[];this.registerFloatingConnection=function(info,conn,ep){floatingConnections[info.id]=conn;_ju.addToList(endpointsByElement,info.id,ep)};this.getFloatingConnectionFor=function(id){return floatingConnections[id]};this.listManager=new root.jsPlumbListManager(this,this.Defaults.ListStyle)};_ju.extend(root.jsPlumbInstance,_ju.EventGenerator,{setAttribute:function(el,a,v){this.setAttribute(el,a,v)},getAttribute:function(el,a){return this.getAttribute(root.jsPlumb.getElement(el),a)},convertToFullOverlaySpec:function(spec){if(_ju.isString(spec)){spec=[spec,{}]}
spec[1].id=spec[1].id||_ju.uuid();return spec},registerConnectionType:function(id,type){this._connectionTypes[id]=root.jsPlumb.extend({},type);if(type.overlays){var to={};for(var i=0;i<type.overlays.length;i++){var fo=this.convertToFullOverlaySpec(type.overlays[i]);to[fo[1].id]=fo}
this._connectionTypes[id].overlays=to}},registerConnectionTypes:function(types){for(var i in types){this.registerConnectionType(i,types[i])}},registerEndpointType:function(id,type){this._endpointTypes[id]=root.jsPlumb.extend({},type);if(type.overlays){var to={};for(var i=0;i<type.overlays.length;i++){var fo=this.convertToFullOverlaySpec(type.overlays[i]);to[fo[1].id]=fo}
this._endpointTypes[id].overlays=to}},registerEndpointTypes:function(types){for(var i in types){this.registerEndpointType(i,types[i])}},getType:function(id,typeDescriptor){return typeDescriptor==="connection"?this._connectionTypes[id]:this._endpointTypes[id]},setIdChanged:function(oldId,newId){this.setId(oldId,newId,!0)},setParent:function(el,newParent){var _dom=this.getElement(el),_id=this.getId(_dom),_pdom=this.getElement(newParent),_pid=this.getId(_pdom),dm=this.getDragManager();_dom.parentNode.removeChild(_dom);_pdom.appendChild(_dom);if(dm){dm.setParent(_dom,_id,_pdom,_pid)}},extend:function(o1,o2,names){var i;if(names){for(i=0;i<names.length;i++){o1[names[i]]=o2[names[i]]}}else{for(i in o2){o1[i]=o2[i]}}
return o1},floatingConnections:{},getFloatingAnchorIndex:function(jpc){return jpc.endpoints[0].isFloating()?0:jpc.endpoints[1].isFloating()?1:-1},proxyConnection:function(connection,index,proxyEl,proxyElId,endpointGenerator,anchorGenerator){var proxyEp,originalElementId=connection.endpoints[index].elementId,originalEndpoint=connection.endpoints[index];connection.proxies=connection.proxies||[];if(connection.proxies[index]){proxyEp=connection.proxies[index].ep}else{proxyEp=this.addEndpoint(proxyEl,{endpoint:endpointGenerator(connection,index),anchor:anchorGenerator(connection,index),parameters:{isProxyEndpoint:!0}})}
proxyEp.setDeleteOnEmpty(!0);connection.proxies[index]={ep:proxyEp,originalEp:originalEndpoint};if(index===0){this.router.sourceOrTargetChanged(originalElementId,proxyElId,connection,proxyEl,0)}else{this.router.sourceOrTargetChanged(originalElementId,proxyElId,connection,proxyEl,1)}
originalEndpoint.detachFromConnection(connection,null,!0);proxyEp.connections=[connection];connection.endpoints[index]=proxyEp;originalEndpoint.setVisible(!1);connection.setVisible(!0);this.revalidate(proxyEl)},unproxyConnection:function(connection,index,proxyElId){if(connection._jsPlumb==null||connection.proxies==null||connection.proxies[index]==null){return}
var originalElement=connection.proxies[index].originalEp.element,originalElementId=connection.proxies[index].originalEp.elementId;connection.endpoints[index]=connection.proxies[index].originalEp;if(index===0){this.router.sourceOrTargetChanged(proxyElId,originalElementId,connection,originalElement,0)}else{this.router.sourceOrTargetChanged(proxyElId,originalElementId,connection,originalElement,1)}
connection.proxies[index].ep.detachFromConnection(connection,null);connection.proxies[index].originalEp.addConnection(connection);if(connection.isVisible()){connection.proxies[index].originalEp.setVisible(!0)}
delete connection.proxies[index]}});var jsPlumb=new jsPlumbInstance();root.jsPlumb=jsPlumb;jsPlumb.getInstance=function(_defaults,overrideFns){var j=new jsPlumbInstance(_defaults);if(overrideFns){for(var ovf in overrideFns){j[ovf]=overrideFns[ovf]}}
j.init();return j};jsPlumb.each=function(spec,fn){if(spec==null){return}
if(typeof spec==="string"){fn(jsPlumb.getElement(spec))}else if(spec.length!=null){for(var i=0;i<spec.length;i++){fn(jsPlumb.getElement(spec[i]))}}else{fn(spec)}};if(typeof exports!=='undefined'){exports.jsPlumb=jsPlumb}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _internalLabelOverlayId="__label",_makeLabelOverlay=function(component,params){var _params={cssClass:params.cssClass,labelStyle:component.labelStyle,id:_internalLabelOverlayId,component:component,_jsPlumb:component._jsPlumb.instance},mergedParams=_jp.extend(_params,params);return new _jp.Overlays[component._jsPlumb.instance.getRenderMode()].Label(mergedParams)},_processOverlay=function(component,o){var _newOverlay=null;if(_ju.isArray(o)){var type=o[0],p=_jp.extend({component:component,_jsPlumb:component._jsPlumb.instance},o[1]);if(o.length===3){_jp.extend(p,o[2])}
_newOverlay=new _jp.Overlays[component._jsPlumb.instance.getRenderMode()][type](p)}else if(o.constructor===String){_newOverlay=new _jp.Overlays[component._jsPlumb.instance.getRenderMode()][o]({component:component,_jsPlumb:component._jsPlumb.instance})}else{_newOverlay=o}
_newOverlay.id=_newOverlay.id||_ju.uuid();component.cacheTypeItem("overlay",_newOverlay,_newOverlay.id);component._jsPlumb.overlays[_newOverlay.id]=_newOverlay;return _newOverlay};_jp.OverlayCapableJsPlumbUIComponent=function(params){root.jsPlumbUIComponent.apply(this,arguments);this._jsPlumb.overlays={};this._jsPlumb.overlayPositions={};if(params.label){this.getDefaultType().overlays[_internalLabelOverlayId]=["Label",{label:params.label,location:params.labelLocation||this.defaultLabelLocation||0.5,labelStyle:params.labelStyle||this._jsPlumb.instance.Defaults.LabelStyle,id:_internalLabelOverlayId}]}
this.setListenerComponent=function(c){if(this._jsPlumb){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].setListenerComponent(c)}}}};_jp.OverlayCapableJsPlumbUIComponent.applyType=function(component,t){if(t.overlays){var keep={},i;for(i in t.overlays){var existing=component._jsPlumb.overlays[t.overlays[i][1].id];if(existing){existing.updateFrom(t.overlays[i][1]);keep[t.overlays[i][1].id]=!0;existing.reattach(component._jsPlumb.instance,component)}else{var c=component.getCachedTypeItem("overlay",t.overlays[i][1].id);if(c!=null){c.reattach(component._jsPlumb.instance,component);c.setVisible(!0);c.updateFrom(t.overlays[i][1]);component._jsPlumb.overlays[c.id]=c}else{c=component.addOverlay(t.overlays[i],!0)}
keep[c.id]=!0}}
for(i in component._jsPlumb.overlays){if(keep[component._jsPlumb.overlays[i].id]==null){component.removeOverlay(component._jsPlumb.overlays[i].id,!0)}}}};_ju.extend(_jp.OverlayCapableJsPlumbUIComponent,root.jsPlumbUIComponent,{setHover:function(hover,ignoreAttachedElements){if(this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i][hover?"addClass":"removeClass"](this._jsPlumb.instance.hoverClass)}}},addOverlay:function(overlay,doNotRepaint){var o=_processOverlay(this,overlay);if(this.getData&&o.type==="Label"&&_ju.isArray(overlay)){var d=this.getData(),p=overlay[1];if(d){var locationAttribute=p.labelLocationAttribute||"labelLocation";var loc=d?d[locationAttribute]:null;if(loc){o.loc=loc}}}
if(!doNotRepaint){this.repaint()}
return o},getOverlay:function(id){return this._jsPlumb.overlays[id]},getOverlays:function(){return this._jsPlumb.overlays},hideOverlay:function(id){var o=this.getOverlay(id);if(o){o.hide()}},hideOverlays:function(){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].hide()}},showOverlay:function(id){var o=this.getOverlay(id);if(o){o.show()}},showOverlays:function(){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].show()}},removeAllOverlays:function(doNotRepaint){for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays[i].cleanup){this._jsPlumb.overlays[i].cleanup()}}
this._jsPlumb.overlays={};this._jsPlumb.overlayPositions=null;this._jsPlumb.overlayPlacements={};if(!doNotRepaint){this.repaint()}},removeOverlay:function(overlayId,dontCleanup){var o=this._jsPlumb.overlays[overlayId];if(o){o.setVisible(!1);if(!dontCleanup&&o.cleanup){o.cleanup()}
delete this._jsPlumb.overlays[overlayId];if(this._jsPlumb.overlayPositions){delete this._jsPlumb.overlayPositions[overlayId]}
if(this._jsPlumb.overlayPlacements){delete this._jsPlumb.overlayPlacements[overlayId]}}},removeOverlays:function(){for(var i=0,j=arguments.length;i<j;i++){this.removeOverlay(arguments[i])}},moveParent:function(newParent){if(this.bgCanvas){this.bgCanvas.parentNode.removeChild(this.bgCanvas);newParent.appendChild(this.bgCanvas)}
if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas);newParent.appendChild(this.canvas);for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays[i].isAppendedAtTopLevel){var el=this._jsPlumb.overlays[i].getElement();el.parentNode.removeChild(el);newParent.appendChild(el)}}}},getLabel:function(){var lo=this.getOverlay(_internalLabelOverlayId);return lo!=null?lo.getLabel():null},getLabelOverlay:function(){return this.getOverlay(_internalLabelOverlayId)},setLabel:function(l){var lo=this.getOverlay(_internalLabelOverlayId);if(!lo){var params=l.constructor===String||l.constructor===Function?{label:l}:l;lo=_makeLabelOverlay(this,params);this._jsPlumb.overlays[_internalLabelOverlayId]=lo}else{if(l.constructor===String||l.constructor===Function){lo.setLabel(l)}else{if(l.label){lo.setLabel(l.label)}
if(l.location){lo.setLocation(l.location)}}}
if(!this._jsPlumb.instance.isSuspendDrawing()){this.repaint()}},cleanup:function(force){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i].cleanup(force);this._jsPlumb.overlays[i].destroy(force)}
if(force){this._jsPlumb.overlays={};this._jsPlumb.overlayPositions=null}},setVisible:function(v){this[v?"showOverlays":"hideOverlays"]()},setAbsoluteOverlayPosition:function(overlay,xy){this._jsPlumb.overlayPositions[overlay.id]=xy},getAbsoluteOverlayPosition:function(overlay){return this._jsPlumb.overlayPositions?this._jsPlumb.overlayPositions[overlay.id]:null},_clazzManip:function(action,clazz,dontUpdateOverlays){if(!dontUpdateOverlays){for(var i in this._jsPlumb.overlays){this._jsPlumb.overlays[i][action+"Class"](clazz)}}},addClass:function(clazz,dontUpdateOverlays){this._clazzManip("add",clazz,dontUpdateOverlays)},removeClass:function(clazz,dontUpdateOverlays){this._clazzManip("remove",clazz,dontUpdateOverlays)}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _makeConnectionDragHandler=function(endpoint,placeholder,_jsPlumb){var stopped=!1;return{drag:function(){if(stopped){stopped=!1;return!0}
if(placeholder.element){var _ui=_jsPlumb.getUIPosition(arguments,_jsPlumb.getZoom());if(_ui!=null){_jsPlumb.setPosition(placeholder.element,_ui)}
_jsPlumb.repaint(placeholder.element,_ui);endpoint.paint({anchorPoint:endpoint.anchor.getCurrentLocation({element:endpoint})})}},stopDrag:function(){stopped=!0}}};var _makeDraggablePlaceholder=function(placeholder,_jsPlumb,ipco,ips){var n=_jsPlumb.createElement("div",{position:"absolute"});_jsPlumb.appendElement(n);var id=_jsPlumb.getId(n);_jsPlumb.setPosition(n,ipco);n.style.width=ips[0]+"px";n.style.height=ips[1]+"px";_jsPlumb.manage(id,n,!0);placeholder.id=id;placeholder.element=n};var _makeFloatingEndpoint=function(paintStyle,referenceAnchor,endpoint,referenceCanvas,sourceElement,_jsPlumb,_newEndpoint,scope){var floatingAnchor=new _jp.FloatingAnchor({reference:referenceAnchor,referenceCanvas:referenceCanvas,jsPlumbInstance:_jsPlumb});return _newEndpoint({paintStyle:paintStyle,endpoint:endpoint,anchor:floatingAnchor,source:sourceElement,scope:scope})};var typeParameters=["connectorStyle","connectorHoverStyle","connectorOverlays","connector","connectionType","connectorClass","connectorHoverClass"];var findConnectionToUseForDynamicAnchor=function(ep,elementWithPrecedence){var idx=0;if(elementWithPrecedence!=null){for(var i=0;i<ep.connections.length;i++){if(ep.connections[i].sourceId===elementWithPrecedence||ep.connections[i].targetId===elementWithPrecedence){idx=i;break}}}
return ep.connections[idx]};_jp.Endpoint=function(params){var _jsPlumb=params._jsPlumb,_newConnection=params.newConnection,_newEndpoint=params.newEndpoint;this.idPrefix="_jsplumb_e_";this.defaultLabelLocation=[0.5,0.5];this.defaultOverlayKeys=["Overlays","EndpointOverlays"];_jp.OverlayCapableJsPlumbUIComponent.apply(this,arguments);this.appendToDefaultType({connectionType:params.connectionType,maxConnections:params.maxConnections==null?this._jsPlumb.instance.Defaults.MaxConnections:params.maxConnections,paintStyle:params.endpointStyle||params.paintStyle||params.style||this._jsPlumb.instance.Defaults.EndpointStyle||_jp.Defaults.EndpointStyle,hoverPaintStyle:params.endpointHoverStyle||params.hoverPaintStyle||this._jsPlumb.instance.Defaults.EndpointHoverStyle||_jp.Defaults.EndpointHoverStyle,connectorStyle:params.connectorStyle,connectorHoverStyle:params.connectorHoverStyle,connectorClass:params.connectorClass,connectorHoverClass:params.connectorHoverClass,connectorOverlays:params.connectorOverlays,connector:params.connector,connectorTooltip:params.connectorTooltip});this._jsPlumb.enabled=!(params.enabled===!1);this._jsPlumb.visible=!0;this.element=_jp.getElement(params.source);this._jsPlumb.uuid=params.uuid;this._jsPlumb.floatingEndpoint=null;var inPlaceCopy=null;if(this._jsPlumb.uuid){params.endpointsByUUID[this._jsPlumb.uuid]=this}
this.elementId=params.elementId;this.dragProxy=params.dragProxy;this._jsPlumb.connectionCost=params.connectionCost;this._jsPlumb.connectionsDirected=params.connectionsDirected;this._jsPlumb.currentAnchorClass="";this._jsPlumb.events={};var deleteOnEmpty=params.deleteOnEmpty===!0;this.setDeleteOnEmpty=function(d){deleteOnEmpty=d};var _updateAnchorClass=function(){var oldAnchorClass=_jsPlumb.endpointAnchorClassPrefix+"-"+this._jsPlumb.currentAnchorClass;this._jsPlumb.currentAnchorClass=this.anchor.getCssClass();var anchorClass=_jsPlumb.endpointAnchorClassPrefix+(this._jsPlumb.currentAnchorClass?"-"+this._jsPlumb.currentAnchorClass:"");this.removeClass(oldAnchorClass);this.addClass(anchorClass);_jp.updateClasses(this.element,anchorClass,oldAnchorClass)}.bind(this);this.prepareAnchor=function(anchorParams){var a=this._jsPlumb.instance.makeAnchor(anchorParams,this.elementId,_jsPlumb);a.bind("anchorChanged",function(currentAnchor){this.fire("anchorChanged",{endpoint:this,anchor:currentAnchor});_updateAnchorClass()}.bind(this));return a};this.setPreparedAnchor=function(anchor,doNotRepaint){this._jsPlumb.instance.continuousAnchorFactory.clear(this.elementId);this.anchor=anchor;_updateAnchorClass();if(!doNotRepaint){this._jsPlumb.instance.repaint(this.elementId)}
return this};this.setAnchor=function(anchorParams,doNotRepaint){var a=this.prepareAnchor(anchorParams);this.setPreparedAnchor(a,doNotRepaint);return this};var internalHover=function(state){if(this.connections.length>0){for(var i=0;i<this.connections.length;i++){this.connections[i].setHover(state,!1)}}else{this.setHover(state)}}.bind(this);this.bind("mouseover",function(){internalHover(!0)});this.bind("mouseout",function(){internalHover(!1)});if(!params._transient){this._jsPlumb.instance.router.addEndpoint(this,this.elementId)}
this.prepareEndpoint=function(ep,typeId){var _e=function(t,p){var rm=_jsPlumb.getRenderMode();if(_jp.Endpoints[rm][t]){return new _jp.Endpoints[rm][t](p)}
if(!_jsPlumb.Defaults.DoNotThrowErrors){throw{msg:"jsPlumb: unknown endpoint type '"+t+"'"}}};var endpointArgs={_jsPlumb:this._jsPlumb.instance,cssClass:params.cssClass,container:params.container,tooltip:params.tooltip,connectorTooltip:params.connectorTooltip,endpoint:this};var endpoint;if(_ju.isString(ep)){endpoint=_e(ep,endpointArgs)}else if(_ju.isArray(ep)){endpointArgs=_ju.merge(ep[1],endpointArgs);endpoint=_e(ep[0],endpointArgs)}else{endpoint=ep.clone()}
endpoint.clone=function(){if(_ju.isString(ep)){return _e(ep,endpointArgs)}else if(_ju.isArray(ep)){endpointArgs=_ju.merge(ep[1],endpointArgs);return _e(ep[0],endpointArgs)}}.bind(this);endpoint.typeId=typeId;return endpoint};this.setEndpoint=function(ep,doNotRepaint){var _ep=this.prepareEndpoint(ep);this.setPreparedEndpoint(_ep,!0)};this.setPreparedEndpoint=function(ep,doNotRepaint){if(this.endpoint!=null){this.endpoint.cleanup();this.endpoint.destroy()}
this.endpoint=ep;this.type=this.endpoint.type;this.canvas=this.endpoint.canvas};_jp.extend(this,params,typeParameters);this.isSource=params.isSource||!1;this.isTemporarySource=params.isTemporarySource||!1;this.isTarget=params.isTarget||!1;this.connections=params.connections||[];this.connectorPointerEvents=params["connector-pointer-events"];this.scope=params.scope||_jsPlumb.getDefaultScope();this.timestamp=null;this.reattachConnections=params.reattach||_jsPlumb.Defaults.ReattachConnections;this.connectionsDetachable=_jsPlumb.Defaults.ConnectionsDetachable;if(params.connectionsDetachable===!1||params.detachable===!1){this.connectionsDetachable=!1}
this.dragAllowedWhenFull=params.dragAllowedWhenFull!==!1;if(params.onMaxConnections){this.bind("maxConnections",params.onMaxConnections)}
this.addConnection=function(connection){this.connections.push(connection);this[(this.connections.length>0?"add":"remove")+"Class"](_jsPlumb.endpointConnectedClass);this[(this.isFull()?"add":"remove")+"Class"](_jsPlumb.endpointFullClass)};this.detachFromConnection=function(connection,idx,doNotCleanup){idx=idx==null?this.connections.indexOf(connection):idx;if(idx>=0){this.connections.splice(idx,1);this[(this.connections.length>0?"add":"remove")+"Class"](_jsPlumb.endpointConnectedClass);this[(this.isFull()?"add":"remove")+"Class"](_jsPlumb.endpointFullClass)}
if(!doNotCleanup&&deleteOnEmpty&&this.connections.length===0){_jsPlumb.deleteObject({endpoint:this,fireEvent:!1,deleteAttachedObjects:doNotCleanup!==!0})}};this.deleteEveryConnection=function(params){var c=this.connections.length;for(var i=0;i<c;i++){_jsPlumb.deleteConnection(this.connections[0],params)}};this.detachFrom=function(targetEndpoint,fireEvent,originalEvent){var c=[];for(var i=0;i<this.connections.length;i++){if(this.connections[i].endpoints[1]===targetEndpoint||this.connections[i].endpoints[0]===targetEndpoint){c.push(this.connections[i])}}
for(var j=0,count=c.length;j<count;j++){_jsPlumb.deleteConnection(c[0])}
return this};this.getElement=function(){return this.element};this.setElement=function(el){var parentId=this._jsPlumb.instance.getId(el),curId=this.elementId;_ju.removeWithFunction(params.endpointsByElement[this.elementId],function(e){return e.id===this.id}.bind(this));this.element=_jp.getElement(el);this.elementId=_jsPlumb.getId(this.element);_jsPlumb.router.rehomeEndpoint(this,curId,this.element);_jsPlumb.dragManager.endpointAdded(this.element);_ju.addToList(params.endpointsByElement,parentId,this);return this};this.makeInPlaceCopy=function(){var loc=this.anchor.getCurrentLocation({element:this}),o=this.anchor.getOrientation(this),acc=this.anchor.getCssClass(),inPlaceAnchor={bind:function(){},compute:function(){return[loc[0],loc[1]]},getCurrentLocation:function(){return[loc[0],loc[1]]},getOrientation:function(){return o},getCssClass:function(){return acc}};return _newEndpoint({dropOptions:params.dropOptions,anchor:inPlaceAnchor,source:this.element,paintStyle:this.getPaintStyle(),endpoint:params.hideOnDrag?"Blank":this.endpoint,_transient:!0,scope:this.scope,reference:this})};this.connectorSelector=function(){return this.connections[0]};this.setStyle=this.setPaintStyle;this.paint=function(params){params=params||{};var timestamp=params.timestamp,recalc=!(params.recalc===!1);if(!timestamp||this.timestamp!==timestamp){var info=_jsPlumb.updateOffset({elId:this.elementId,timestamp:timestamp});var xy=params.offset?params.offset.o:info.o;if(xy!=null){var ap=params.anchorPoint,connectorPaintStyle=params.connectorPaintStyle;if(ap==null){var wh=params.dimensions||info.s,anchorParams={xy:[xy.left,xy.top],wh:wh,element:this,timestamp:timestamp};if(recalc&&this.anchor.isDynamic&&this.connections.length>0){var c=findConnectionToUseForDynamicAnchor(this,params.elementWithPrecedence),oIdx=c.endpoints[0]===this?1:0,oId=oIdx===0?c.sourceId:c.targetId,oInfo=_jsPlumb.getCachedData(oId),oOffset=oInfo.o,oWH=oInfo.s;anchorParams.index=oIdx===0?1:0;anchorParams.connection=c;anchorParams.txy=[oOffset.left,oOffset.top];anchorParams.twh=oWH;anchorParams.tElement=c.endpoints[oIdx];anchorParams.tRotation=_jsPlumb.getRotation(oId)}else if(this.connections.length>0){anchorParams.connection=this.connections[0]}
anchorParams.rotation=_jsPlumb.getRotation(this.elementId);ap=this.anchor.compute(anchorParams)}
this.endpoint.compute(ap,this.anchor.getOrientation(this),this._jsPlumb.paintStyleInUse,connectorPaintStyle||this.paintStyleInUse);this.endpoint.paint(this._jsPlumb.paintStyleInUse,this.anchor);this.timestamp=timestamp;for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(i)){var o=this._jsPlumb.overlays[i];if(o.isVisible()){this._jsPlumb.overlayPlacements[i]=o.draw(this.endpoint,this._jsPlumb.paintStyleInUse);o.paint(this._jsPlumb.overlayPlacements[i])}}}}}};this.getTypeDescriptor=function(){return"endpoint"};this.isVisible=function(){return this._jsPlumb.visible};this.repaint=this.paint;var draggingInitialised=!1;this.initDraggable=function(){if(!draggingInitialised&&_jp.isDragSupported(this.element)){var placeholderInfo={id:null,element:null},jpc=null,existingJpc=!1,existingJpcParams=null,_dragHandler=_makeConnectionDragHandler(this,placeholderInfo,_jsPlumb),dragOptions=params.dragOptions||{},defaultOpts={},startEvent=_jp.dragEvents.start,stopEvent=_jp.dragEvents.stop,dragEvent=_jp.dragEvents.drag,beforeStartEvent=_jp.dragEvents.beforeStart,payload;var beforeStart=function(beforeStartParams){payload=beforeStartParams.e.payload||{}};var start=function(startParams){jpc=this.connectorSelector();var _continue=!0;if(!this.isEnabled()){_continue=!1}
if(jpc==null&&!this.isSource&&!this.isTemporarySource){_continue=!1}
if(this.isSource&&this.isFull()&&!(jpc!=null&&this.dragAllowedWhenFull)){_continue=!1}
if(jpc!=null&&!jpc.isDetachable(this)){if(this.isFull()){_continue=!1}else{jpc=null}}
var beforeDrag=_jsPlumb.checkCondition(jpc==null?"beforeDrag":"beforeStartDetach",{endpoint:this,source:this.element,sourceId:this.elementId,connection:jpc});if(beforeDrag===!1){_continue=!1}else if(typeof beforeDrag==="object"){_jp.extend(beforeDrag,payload||{})}else{beforeDrag=payload||{}}
if(_continue===!1){if(_jsPlumb.stopDrag){_jsPlumb.stopDrag(this.canvas)}
_dragHandler.stopDrag();return!1}
for(var i=0;i<this.connections.length;i++){this.connections[i].setHover(!1)}
this.addClass("endpointDrag");_jsPlumb.setConnectionBeingDragged(!0);if(jpc&&!this.isFull()&&this.isSource){jpc=null}
_jsPlumb.updateOffset({elId:this.elementId});var ipco=this._jsPlumb.instance.getOffset(this.canvas),canvasElement=this.canvas,ips=this._jsPlumb.instance.getSize(this.canvas);_makeDraggablePlaceholder(placeholderInfo,_jsPlumb,ipco,ips);_jsPlumb.setAttributes(this.canvas,{"dragId":placeholderInfo.id,"elId":this.elementId});var endpointToFloat=this.dragProxy||this.endpoint;if(this.dragProxy==null&&this.connectionType!=null){var aae=this._jsPlumb.instance.deriveEndpointAndAnchorSpec(this.connectionType);if(aae.endpoints[1]){endpointToFloat=aae.endpoints[1]}}
var centerAnchor=this._jsPlumb.instance.makeAnchor("Center");centerAnchor.isFloating=!0;this._jsPlumb.floatingEndpoint=_makeFloatingEndpoint(this.getPaintStyle(),centerAnchor,endpointToFloat,this.canvas,placeholderInfo.element,_jsPlumb,_newEndpoint,this.scope);var _savedAnchor=this._jsPlumb.floatingEndpoint.anchor;if(jpc==null){this.setHover(!1,!1);jpc=_newConnection({sourceEndpoint:this,targetEndpoint:this._jsPlumb.floatingEndpoint,source:this.element,target:placeholderInfo.element,anchors:[this.anchor,this._jsPlumb.floatingEndpoint.anchor],paintStyle:params.connectorStyle,hoverPaintStyle:params.connectorHoverStyle,connector:params.connector,overlays:params.connectorOverlays,type:this.connectionType,cssClass:this.connectorClass,hoverClass:this.connectorHoverClass,scope:params.scope,data:beforeDrag});jpc.pending=!0;jpc.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.anchor=_savedAnchor;_jsPlumb.fire("connectionDrag",jpc);_jsPlumb.router.newConnection(jpc)}else{existingJpc=!0;jpc.setHover(!1);var anchorIdx=jpc.endpoints[0].id===this.id?0:1;this.detachFromConnection(jpc,null,!0);var dragScope=_jsPlumb.getDragScope(canvasElement);_jsPlumb.setAttribute(this.canvas,"originalScope",dragScope);_jsPlumb.fire("connectionDrag",jpc);if(anchorIdx===0){existingJpcParams=[jpc.source,jpc.sourceId,canvasElement,dragScope];_jsPlumb.router.sourceOrTargetChanged(jpc.endpoints[anchorIdx].elementId,placeholderInfo.id,jpc,placeholderInfo.element,0)}else{existingJpcParams=[jpc.target,jpc.targetId,canvasElement,dragScope];_jsPlumb.router.sourceOrTargetChanged(jpc.endpoints[anchorIdx].elementId,placeholderInfo.id,jpc,placeholderInfo.element,1)}
jpc.suspendedEndpoint=jpc.endpoints[anchorIdx];jpc.suspendedElement=jpc.endpoints[anchorIdx].getElement();jpc.suspendedElementId=jpc.endpoints[anchorIdx].elementId;jpc.suspendedElementType=anchorIdx===0?"source":"target";jpc.suspendedEndpoint.setHover(!1);this._jsPlumb.floatingEndpoint.referenceEndpoint=jpc.suspendedEndpoint;jpc.endpoints[anchorIdx]=this._jsPlumb.floatingEndpoint;jpc.addClass(_jsPlumb.draggingClass);this._jsPlumb.floatingEndpoint.addClass(_jsPlumb.draggingClass)}
_jsPlumb.registerFloatingConnection(placeholderInfo,jpc,this._jsPlumb.floatingEndpoint);_jsPlumb.currentlyDragging=!0}.bind(this);var stop=function(){_jsPlumb.setConnectionBeingDragged(!1);if(jpc&&jpc.endpoints!=null){var originalEvent=_jsPlumb.getDropEvent(arguments);var idx=_jsPlumb.getFloatingAnchorIndex(jpc);jpc.endpoints[idx===0?1:0].anchor.locked=!1;jpc.removeClass(_jsPlumb.draggingClass);if(this._jsPlumb&&(jpc.deleteConnectionNow||jpc.endpoints[idx]===this._jsPlumb.floatingEndpoint)){if(existingJpc&&jpc.suspendedEndpoint){if(idx===0){jpc.floatingElement=jpc.source;jpc.floatingId=jpc.sourceId;jpc.floatingEndpoint=jpc.endpoints[0];jpc.floatingIndex=0;jpc.source=existingJpcParams[0];jpc.sourceId=existingJpcParams[1]}else{jpc.floatingElement=jpc.target;jpc.floatingId=jpc.targetId;jpc.floatingEndpoint=jpc.endpoints[1];jpc.floatingIndex=1;jpc.target=existingJpcParams[0];jpc.targetId=existingJpcParams[1]}
var fe=this._jsPlumb.floatingEndpoint;_jsPlumb.setDragScope(existingJpcParams[2],existingJpcParams[3]);jpc.endpoints[idx]=jpc.suspendedEndpoint;if(jpc.isReattach()||jpc._forceReattach||jpc._forceDetach||!_jsPlumb.deleteConnection(jpc,{originalEvent:originalEvent})){jpc.setHover(!1);jpc._forceDetach=null;jpc._forceReattach=null;this._jsPlumb.floatingEndpoint.detachFromConnection(jpc);jpc.suspendedEndpoint.addConnection(jpc);if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,idx)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,idx)}
_jsPlumb.repaint(existingJpcParams[1])}else{_jsPlumb.deleteObject({endpoint:fe})}}}
if(this.deleteAfterDragStop){_jsPlumb.deleteObject({endpoint:this})}else{if(this._jsPlumb){this.paint({recalc:!1})}}
_jsPlumb.fire("connectionDragStop",jpc,originalEvent);if(jpc.pending){_jsPlumb.fire("connectionAborted",jpc,originalEvent)}
_jsPlumb.currentlyDragging=!1;jpc.suspendedElement=null;jpc.suspendedEndpoint=null;jpc=null}
if(placeholderInfo&&placeholderInfo.element){_jsPlumb.remove(placeholderInfo.element,!1,!1)}
if(inPlaceCopy){_jsPlumb.deleteObject({endpoint:inPlaceCopy})}
if(this._jsPlumb){this.canvas.style.visibility="visible";this.anchor.locked=!1;this._jsPlumb.floatingEndpoint=null}}.bind(this);dragOptions=_jp.extend(defaultOpts,dragOptions);dragOptions.scope=this.scope||dragOptions.scope;dragOptions[beforeStartEvent]=_ju.wrap(dragOptions[beforeStartEvent],beforeStart,!1);dragOptions[startEvent]=_ju.wrap(dragOptions[startEvent],start,!1);dragOptions[dragEvent]=_ju.wrap(dragOptions[dragEvent],_dragHandler.drag);dragOptions[stopEvent]=_ju.wrap(dragOptions[stopEvent],stop);dragOptions.multipleDrop=!1;dragOptions.canDrag=function(){return this.isSource||this.isTemporarySource||(this.connections.length>0&&this.connectionsDetachable!==!1)}.bind(this);_jsPlumb.initDraggable(this.canvas,dragOptions,"internal");this.canvas._jsPlumbRelatedElement=this.element;draggingInitialised=!0}};var ep=params.endpoint||this._jsPlumb.instance.Defaults.Endpoint||_jp.Defaults.Endpoint;this.setEndpoint(ep,!0);var anchorParamsToUse=params.anchor?params.anchor:params.anchors?params.anchors:(_jsPlumb.Defaults.Anchor||"Top");this.setAnchor(anchorParamsToUse,!0);var type=["default",(params.type||"")].join(" ");this.addType(type,params.data,!0);this.canvas=this.endpoint.canvas;this.canvas._jsPlumb=this;this.initDraggable();var _initDropTarget=function(canvas,isTransient,endpoint,referenceEndpoint){if(_jp.isDropSupported(this.element)){var dropOptions=params.dropOptions||_jsPlumb.Defaults.DropOptions||_jp.Defaults.DropOptions;dropOptions=_jp.extend({},dropOptions);dropOptions.scope=dropOptions.scope||this.scope;var dropEvent=_jp.dragEvents.drop,overEvent=_jp.dragEvents.over,outEvent=_jp.dragEvents.out,_ep=this,drop=_jsPlumb.EndpointDropHandler({getEndpoint:function(){return _ep},jsPlumb:_jsPlumb,enabled:function(){return endpoint!=null?endpoint.isEnabled():!0},isFull:function(){return endpoint.isFull()},element:this.element,elementId:this.elementId,isSource:this.isSource,isTarget:this.isTarget,addClass:function(clazz){_ep.addClass(clazz)},removeClass:function(clazz){_ep.removeClass(clazz)},isDropAllowed:function(){return _ep.isDropAllowed.apply(_ep,arguments)},reference:referenceEndpoint,isRedrop:function(jpc,dhParams){return jpc.suspendedEndpoint&&dhParams.reference&&(jpc.suspendedEndpoint.id===dhParams.reference.id)}});dropOptions[dropEvent]=_ju.wrap(dropOptions[dropEvent],drop,!0);dropOptions[overEvent]=_ju.wrap(dropOptions[overEvent],function(){var draggable=_jp.getDragObject(arguments),id=_jsPlumb.getAttribute(_jp.getElement(draggable),"dragId"),_jpc=_jsPlumb.getFloatingConnectionFor(id);if(_jpc!=null){var idx=_jsPlumb.getFloatingAnchorIndex(_jpc);var _cont=(this.isTarget&&idx!==0)||(_jpc.suspendedEndpoint&&this.referenceEndpoint&&this.referenceEndpoint.id===_jpc.suspendedEndpoint.id);if(_cont){var bb=_jsPlumb.checkCondition("checkDropAllowed",{sourceEndpoint:_jpc.endpoints[idx],targetEndpoint:this,connection:_jpc});this[(bb?"add":"remove")+"Class"](_jsPlumb.endpointDropAllowedClass);this[(bb?"remove":"add")+"Class"](_jsPlumb.endpointDropForbiddenClass);_jpc.endpoints[idx].anchor.over(this.anchor,this)}}}.bind(this));dropOptions[outEvent]=_ju.wrap(dropOptions[outEvent],function(){var draggable=_jp.getDragObject(arguments),id=draggable==null?null:_jsPlumb.getAttribute(_jp.getElement(draggable),"dragId"),_jpc=id?_jsPlumb.getFloatingConnectionFor(id):null;if(_jpc!=null){var idx=_jsPlumb.getFloatingAnchorIndex(_jpc);var _cont=(this.isTarget&&idx!==0)||(_jpc.suspendedEndpoint&&this.referenceEndpoint&&this.referenceEndpoint.id===_jpc.suspendedEndpoint.id);if(_cont){this.removeClass(_jsPlumb.endpointDropAllowedClass);this.removeClass(_jsPlumb.endpointDropForbiddenClass);_jpc.endpoints[idx].anchor.out()}}}.bind(this));_jsPlumb.initDroppable(canvas,dropOptions,"internal",isTransient)}}.bind(this);if(!this.anchor.isFloating){_initDropTarget(this.canvas,!(params._transient||this.anchor.isFloating),this,params.reference)}
return this};_ju.extend(_jp.Endpoint,_jp.OverlayCapableJsPlumbUIComponent,{setVisible:function(v,doNotChangeConnections,doNotNotifyOtherEndpoint){this._jsPlumb.visible=v;if(this.canvas){this.canvas.style.display=v?"block":"none"}
this[v?"showOverlays":"hideOverlays"]();if(!doNotChangeConnections){for(var i=0;i<this.connections.length;i++){this.connections[i].setVisible(v);if(!doNotNotifyOtherEndpoint){var oIdx=this===this.connections[i].endpoints[0]?1:0;if(this.connections[i].endpoints[oIdx].connections.length===1){this.connections[i].endpoints[oIdx].setVisible(v,!0,!0)}}}}},getAttachedElements:function(){return this.connections},applyType:function(t,doNotRepaint){this.setPaintStyle(t.endpointStyle||t.paintStyle,doNotRepaint);this.setHoverPaintStyle(t.endpointHoverStyle||t.hoverPaintStyle,doNotRepaint);if(t.maxConnections!=null){this._jsPlumb.maxConnections=t.maxConnections}
if(t.scope){this.scope=t.scope}
_jp.extend(this,t,typeParameters);if(t.cssClass!=null&&this.canvas){this._jsPlumb.instance.addClass(this.canvas,t.cssClass)}
_jp.OverlayCapableJsPlumbUIComponent.applyType(this,t)},isEnabled:function(){return this._jsPlumb.enabled},setEnabled:function(e){this._jsPlumb.enabled=e},cleanup:function(){var anchorClass=this._jsPlumb.instance.endpointAnchorClassPrefix+(this._jsPlumb.currentAnchorClass?"-"+this._jsPlumb.currentAnchorClass:"");_jp.removeClass(this.element,anchorClass);this.anchor=null;this.endpoint.cleanup(!0);this.endpoint.destroy();this.endpoint=null;this._jsPlumb.instance.destroyDraggable(this.canvas,"internal");this._jsPlumb.instance.destroyDroppable(this.canvas,"internal")},setHover:function(h){if(this.endpoint&&this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){this.endpoint.setHover(h)}},isFull:function(){return this._jsPlumb.maxConnections===0?!0:!(this.isFloating()||this._jsPlumb.maxConnections<0||this.connections.length<this._jsPlumb.maxConnections)},isFloating:function(){return this.anchor!=null&&this.anchor.isFloating},isConnectedTo:function(endpoint){var found=!1;if(endpoint){for(var i=0;i<this.connections.length;i++){if(this.connections[i].endpoints[1]===endpoint||this.connections[i].endpoints[0]===endpoint){found=!0;break}}}
return found},getConnectionCost:function(){return this._jsPlumb.connectionCost},setConnectionCost:function(c){this._jsPlumb.connectionCost=c},areConnectionsDirected:function(){return this._jsPlumb.connectionsDirected},setConnectionsDirected:function(b){this._jsPlumb.connectionsDirected=b},setElementId:function(_elId){this.elementId=_elId;this.anchor.elementId=_elId},setReferenceElement:function(_el){this.element=_jp.getElement(_el)},setDragAllowedWhenFull:function(allowed){this.dragAllowedWhenFull=allowed},equals:function(endpoint){return this.anchor.equals(endpoint.anchor)},getUuid:function(){return this._jsPlumb.uuid},computeAnchor:function(params){return this.anchor.compute(params)}});root.jsPlumbInstance.prototype.EndpointDropHandler=function(dhParams){return function(e){var _jsPlumb=dhParams.jsPlumb;dhParams.removeClass(_jsPlumb.endpointDropAllowedClass);dhParams.removeClass(_jsPlumb.endpointDropForbiddenClass);var originalEvent=_jsPlumb.getDropEvent(arguments),draggable=_jsPlumb.getDragObject(arguments),id=_jsPlumb.getAttribute(draggable,"dragId"),elId=_jsPlumb.getAttribute(draggable,"elId"),scope=_jsPlumb.getAttribute(draggable,"originalScope"),jpc=_jsPlumb.getFloatingConnectionFor(id);if(jpc==null){return}
var existingConnection=jpc.suspendedEndpoint!=null;if(existingConnection&&jpc.suspendedEndpoint._jsPlumb==null){return}
var _ep=dhParams.getEndpoint(jpc);if(_ep==null){return}
if(dhParams.isRedrop(jpc,dhParams)){jpc._forceReattach=!0;jpc.setHover(!1);if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
return}
var idx=_jsPlumb.getFloatingAnchorIndex(jpc);if((idx===0&&!dhParams.isSource)||(idx===1&&!dhParams.isTarget)){if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
return}
if(dhParams.onDrop){dhParams.onDrop(jpc)}
if(scope){_jsPlumb.setDragScope(draggable,scope)}
var isFull=dhParams.isFull(e);if(isFull){_ep.fire("maxConnections",{endpoint:this,connection:jpc,maxConnections:_ep._jsPlumb.maxConnections},originalEvent)}
if(!isFull&&dhParams.enabled()){var _doContinue=!0;if(idx===0){jpc.floatingElement=jpc.source;jpc.floatingId=jpc.sourceId;jpc.floatingEndpoint=jpc.endpoints[0];jpc.floatingIndex=0;jpc.source=dhParams.element;jpc.sourceId=_jsPlumb.getId(dhParams.element)}else{jpc.floatingElement=jpc.target;jpc.floatingId=jpc.targetId;jpc.floatingEndpoint=jpc.endpoints[1];jpc.floatingIndex=1;jpc.target=dhParams.element;jpc.targetId=_jsPlumb.getId(dhParams.element)}
if(existingConnection&&jpc.suspendedEndpoint.id!==_ep.id){if(!jpc.isDetachAllowed(jpc)||!jpc.endpoints[idx].isDetachAllowed(jpc)||!jpc.suspendedEndpoint.isDetachAllowed(jpc)||!_jsPlumb.checkCondition("beforeDetach",jpc)){_doContinue=!1}}
var continueFunction=function(optionalData){jpc.endpoints[idx].detachFromConnection(jpc);if(jpc.suspendedEndpoint){jpc.suspendedEndpoint.detachFromConnection(jpc)}
jpc.endpoints[idx]=_ep;_ep.addConnection(jpc);var params=_ep.getParameters();for(var aParam in params){jpc.setParameter(aParam,params[aParam])}
if(!existingConnection){if(params.draggable){_jsPlumb.initDraggable(this.element,dhParams.dragOptions,"internal",_jsPlumb)}}else{var suspendedElementId=jpc.suspendedEndpoint.elementId;_jsPlumb.fireMoveEvent({index:idx,originalSourceId:idx===0?suspendedElementId:jpc.sourceId,newSourceId:idx===0?_ep.elementId:jpc.sourceId,originalTargetId:idx===1?suspendedElementId:jpc.targetId,newTargetId:idx===1?_ep.elementId:jpc.targetId,originalSourceEndpoint:idx===0?jpc.suspendedEndpoint:jpc.endpoints[0],newSourceEndpoint:idx===0?_ep:jpc.endpoints[0],originalTargetEndpoint:idx===1?jpc.suspendedEndpoint:jpc.endpoints[1],newTargetEndpoint:idx===1?_ep:jpc.endpoints[1],connection:jpc},originalEvent)}
if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,1)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,0)}
if(jpc.endpoints[0].finalEndpoint){var _toDelete=jpc.endpoints[0];_toDelete.detachFromConnection(jpc);jpc.endpoints[0]=jpc.endpoints[0].finalEndpoint;jpc.endpoints[0].addConnection(jpc)}
if(_ju.isObject(optionalData)){jpc.mergeData(optionalData)}
_jsPlumb.finaliseConnection(jpc,null,originalEvent,!1);jpc.setHover(!1);_jsPlumb.revalidate(jpc.endpoints[0].element)}.bind(this);var dontContinueFunction=function(){if(jpc.suspendedEndpoint){jpc.endpoints[idx]=jpc.suspendedEndpoint;jpc.setHover(!1);jpc._forceDetach=!0;if(idx===0){jpc.source=jpc.suspendedEndpoint.element;jpc.sourceId=jpc.suspendedEndpoint.elementId}else{jpc.target=jpc.suspendedEndpoint.element;jpc.targetId=jpc.suspendedEndpoint.elementId}
jpc.suspendedEndpoint.addConnection(jpc);if(idx===1){_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.targetId,jpc,jpc.target,1)}else{_jsPlumb.router.sourceOrTargetChanged(jpc.floatingId,jpc.sourceId,jpc,jpc.source,0)}
_jsPlumb.repaint(jpc.sourceId);jpc._forceDetach=!1}};_doContinue=_doContinue&&dhParams.isDropAllowed(jpc.sourceId,jpc.targetId,jpc.scope,jpc,_ep);if(_doContinue){continueFunction(_doContinue);return!0}else{dontContinueFunction()}}
if(dhParams.maybeCleanup){dhParams.maybeCleanup(_ep)}
_jsPlumb.currentlyDragging=!1}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var makeConnector=function(_jsPlumb,renderMode,connectorName,connectorArgs,forComponent){_jp.Connectors[renderMode]=_jp.Connectors[renderMode]||{};if(_jp.Connectors[renderMode][connectorName]==null){if(_jp.Connectors[connectorName]==null){if(!_jsPlumb.Defaults.DoNotThrowErrors){throw new TypeError("jsPlumb: unknown connector type '"+connectorName+"'")}else{return null}}
_jp.Connectors[renderMode][connectorName]=function(){_jp.Connectors[connectorName].apply(this,arguments);_jp.ConnectorRenderers[renderMode].apply(this,arguments)};_ju.extend(_jp.Connectors[renderMode][connectorName],[_jp.Connectors[connectorName],_jp.ConnectorRenderers[renderMode]])}
return new _jp.Connectors[renderMode][connectorName](connectorArgs,forComponent)},_makeAnchor=function(anchorParams,elementId,_jsPlumb){return(anchorParams)?_jsPlumb.makeAnchor(anchorParams,elementId,_jsPlumb):null},_updateConnectedClass=function(conn,element,_jsPlumb,remove){if(element!=null){element._jsPlumbConnections=element._jsPlumbConnections||{};if(remove){delete element._jsPlumbConnections[conn.id]}else{element._jsPlumbConnections[conn.id]=!0}
if(_ju.isEmpty(element._jsPlumbConnections)){_jsPlumb.removeClass(element,_jsPlumb.connectedClass)}else{_jsPlumb.addClass(element,_jsPlumb.connectedClass)}}};_jp.Connection=function(params){var _newEndpoint=params.newEndpoint;this.id=params.id;this.connector=null;this.idPrefix="_jsplumb_c_";this.defaultLabelLocation=0.5;this.defaultOverlayKeys=["Overlays","ConnectionOverlays"];this.previousConnection=params.previousConnection;this.source=_jp.getElement(params.source);this.target=_jp.getElement(params.target);_jp.OverlayCapableJsPlumbUIComponent.apply(this,arguments);if(params.sourceEndpoint){this.source=params.sourceEndpoint.getElement();this.sourceId=params.sourceEndpoint.elementId}else{this.sourceId=this._jsPlumb.instance.getId(this.source)}
if(params.targetEndpoint){this.target=params.targetEndpoint.getElement();this.targetId=params.targetEndpoint.elementId}else{this.targetId=this._jsPlumb.instance.getId(this.target)}
this.scope=params.scope;this.endpoints=[];this.endpointStyles=[];var _jsPlumb=this._jsPlumb.instance;_jsPlumb.manage(this.sourceId,this.source);_jsPlumb.manage(this.targetId,this.target);this._jsPlumb.visible=!0;this._jsPlumb.params={cssClass:params.cssClass,container:params.container,"pointer-events":params["pointer-events"],editorParams:params.editorParams,overlays:params.overlays};this._jsPlumb.lastPaintedAt=null;this.bind("mouseover",function(){this.setHover(!0)}.bind(this));this.bind("mouseout",function(){this.setHover(!1)}.bind(this));this.makeEndpoint=function(isSource,el,elId,ep,definition){elId=elId||this._jsPlumb.instance.getId(el);return this.prepareEndpoint(_jsPlumb,_newEndpoint,this,ep,isSource?0:1,params,el,elId,definition)};if(params.type){params.endpoints=params.endpoints||this._jsPlumb.instance.deriveEndpointAndAnchorSpec(params.type).endpoints}
var eS=this.makeEndpoint(!0,this.source,this.sourceId,params.sourceEndpoint),eT=this.makeEndpoint(!1,this.target,this.targetId,params.targetEndpoint);if(eS){_ju.addToList(params.endpointsByElement,this.sourceId,eS)}
if(eT){_ju.addToList(params.endpointsByElement,this.targetId,eT)}
if(!this.scope){this.scope=this.endpoints[0].scope}
if(params.deleteEndpointsOnEmpty!=null){this.endpoints[0].setDeleteOnEmpty(params.deleteEndpointsOnEmpty);this.endpoints[1].setDeleteOnEmpty(params.deleteEndpointsOnEmpty)}
var _detachable=_jsPlumb.Defaults.ConnectionsDetachable;if(params.detachable===!1){_detachable=!1}
if(this.endpoints[0].connectionsDetachable===!1){_detachable=!1}
if(this.endpoints[1].connectionsDetachable===!1){_detachable=!1}
var _reattach=params.reattach||this.endpoints[0].reattachConnections||this.endpoints[1].reattachConnections||_jsPlumb.Defaults.ReattachConnections;this.appendToDefaultType({detachable:_detachable,reattach:_reattach,paintStyle:this.endpoints[0].connectorStyle||this.endpoints[1].connectorStyle||params.paintStyle||_jsPlumb.Defaults.PaintStyle||_jp.Defaults.PaintStyle,hoverPaintStyle:this.endpoints[0].connectorHoverStyle||this.endpoints[1].connectorHoverStyle||params.hoverPaintStyle||_jsPlumb.Defaults.HoverPaintStyle||_jp.Defaults.HoverPaintStyle});var _suspendedAt=_jsPlumb.getSuspendedAt();if(!_jsPlumb.isSuspendDrawing()){var myInfo=_jsPlumb.getCachedData(this.sourceId),myOffset=myInfo.o,myWH=myInfo.s,otherInfo=_jsPlumb.getCachedData(this.targetId),otherOffset=otherInfo.o,otherWH=otherInfo.s,initialTimestamp=_suspendedAt||jsPlumbUtil.uuid(),anchorLoc=this.endpoints[0].anchor.compute({xy:[myOffset.left,myOffset.top],wh:myWH,element:this.endpoints[0],elementId:this.endpoints[0].elementId,txy:[otherOffset.left,otherOffset.top],twh:otherWH,tElement:this.endpoints[1],timestamp:initialTimestamp,rotation:_jsPlumb.getRotation(this.endpoints[0].elementId)});this.endpoints[0].paint({anchorLoc:anchorLoc,timestamp:initialTimestamp});anchorLoc=this.endpoints[1].anchor.compute({xy:[otherOffset.left,otherOffset.top],wh:otherWH,element:this.endpoints[1],elementId:this.endpoints[1].elementId,txy:[myOffset.left,myOffset.top],twh:myWH,tElement:this.endpoints[0],timestamp:initialTimestamp,rotation:_jsPlumb.getRotation(this.endpoints[1].elementId)});this.endpoints[1].paint({anchorLoc:anchorLoc,timestamp:initialTimestamp})}
this.getTypeDescriptor=function(){return"connection"};this.getAttachedElements=function(){return this.endpoints};this.isDetachable=function(ep){return this._jsPlumb.detachable===!1?!1:ep!=null?ep.connectionsDetachable===!0:this._jsPlumb.detachable===!0};this.setDetachable=function(detachable){this._jsPlumb.detachable=detachable===!0};this.isReattach=function(){return this._jsPlumb.reattach===!0||this.endpoints[0].reattachConnections===!0||this.endpoints[1].reattachConnections===!0};this.setReattach=function(reattach){this._jsPlumb.reattach=reattach===!0};this._jsPlumb.cost=params.cost||this.endpoints[0].getConnectionCost();this._jsPlumb.directed=params.directed;if(params.directed==null){this._jsPlumb.directed=this.endpoints[0].areConnectionsDirected()}
var _p=_jp.extend({},this.endpoints[1].getParameters());_jp.extend(_p,this.endpoints[0].getParameters());_jp.extend(_p,this.getParameters());this.setParameters(_p);this.setConnector(this.endpoints[0].connector||this.endpoints[1].connector||params.connector||_jsPlumb.Defaults.Connector||_jp.Defaults.Connector,!0);var data=params.data==null||!_ju.isObject(params.data)?{}:params.data;this.getData=function(){return data};this.setData=function(d){data=d||{}};this.mergeData=function(d){data=_jp.extend(data,d)};var _types=["default",this.endpoints[0].connectionType,this.endpoints[1].connectionType,params.type].join(" ");if(/[^\s]/.test(_types)){this.addType(_types,params.data,!0)}
this.updateConnectedClass()};_ju.extend(_jp.Connection,_jp.OverlayCapableJsPlumbUIComponent,{applyType:function(t,doNotRepaint,typeMap){var _connector=null;if(t.connector!=null){_connector=this.getCachedTypeItem("connector",typeMap.connector);if(_connector==null){_connector=this.prepareConnector(t.connector,typeMap.connector);this.cacheTypeItem("connector",_connector,typeMap.connector)}
this.setPreparedConnector(_connector)}
if(t.detachable!=null){this.setDetachable(t.detachable)}
if(t.reattach!=null){this.setReattach(t.reattach)}
if(t.scope){this.scope=t.scope}
if(t.cssClass!=null&&this.canvas){this._jsPlumb.instance.addClass(this.canvas,t.cssClass)}
var _anchors=null;if(t.anchor){_anchors=this.getCachedTypeItem("anchors",typeMap.anchor);if(_anchors==null){_anchors=[this._jsPlumb.instance.makeAnchor(t.anchor),this._jsPlumb.instance.makeAnchor(t.anchor)];this.cacheTypeItem("anchors",_anchors,typeMap.anchor)}}else if(t.anchors){_anchors=this.getCachedTypeItem("anchors",typeMap.anchors);if(_anchors==null){_anchors=[this._jsPlumb.instance.makeAnchor(t.anchors[0]),this._jsPlumb.instance.makeAnchor(t.anchors[1])];this.cacheTypeItem("anchors",_anchors,typeMap.anchors)}}
if(_anchors!=null){this.endpoints[0].anchor=_anchors[0];this.endpoints[1].anchor=_anchors[1];if(this.endpoints[1].anchor.isDynamic){this._jsPlumb.instance.repaint(this.endpoints[1].elementId)}}
_jp.OverlayCapableJsPlumbUIComponent.applyType(this,t)},addClass:function(c,informEndpoints){if(informEndpoints){this.endpoints[0].addClass(c);this.endpoints[1].addClass(c);if(this.suspendedEndpoint){this.suspendedEndpoint.addClass(c)}}
if(this.connector){this.connector.addClass(c)}},removeClass:function(c,informEndpoints){if(informEndpoints){this.endpoints[0].removeClass(c);this.endpoints[1].removeClass(c);if(this.suspendedEndpoint){this.suspendedEndpoint.removeClass(c)}}
if(this.connector){this.connector.removeClass(c)}},isVisible:function(){return this._jsPlumb.visible},setVisible:function(v){this._jsPlumb.visible=v;if(this.connector){this.connector.setVisible(v)}
this.repaint()},cleanup:function(){this.updateConnectedClass(!0);this.endpoints=null;this.source=null;this.target=null;if(this.connector!=null){this.connector.cleanup(!0);this.connector.destroy(!0)}
this.connector=null},updateConnectedClass:function(remove){if(this._jsPlumb){_updateConnectedClass(this,this.source,this._jsPlumb.instance,remove);_updateConnectedClass(this,this.target,this._jsPlumb.instance,remove)}},setHover:function(state){if(this.connector&&this._jsPlumb&&!this._jsPlumb.instance.isConnectionBeingDragged()){this.connector.setHover(state);root.jsPlumb[state?"addClass":"removeClass"](this.source,this._jsPlumb.instance.hoverSourceClass);root.jsPlumb[state?"addClass":"removeClass"](this.target,this._jsPlumb.instance.hoverTargetClass)}},getUuids:function(){return[this.endpoints[0].getUuid(),this.endpoints[1].getUuid()]},getCost:function(){return this._jsPlumb?this._jsPlumb.cost:-Infinity},setCost:function(c){this._jsPlumb.cost=c},isDirected:function(){return this._jsPlumb.directed},getConnector:function(){return this.connector},prepareConnector:function(connectorSpec,typeId){var connectorArgs={_jsPlumb:this._jsPlumb.instance,cssClass:this._jsPlumb.params.cssClass,container:this._jsPlumb.params.container,"pointer-events":this._jsPlumb.params["pointer-events"]},renderMode=this._jsPlumb.instance.getRenderMode(),connector;if(_ju.isString(connectorSpec)){connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec,connectorArgs,this)}else if(_ju.isArray(connectorSpec)){if(connectorSpec.length===1){connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec[0],connectorArgs,this)}else{connector=makeConnector(this._jsPlumb.instance,renderMode,connectorSpec[0],_ju.merge(connectorSpec[1],connectorArgs),this)}}
if(typeId!=null){connector.typeId=typeId}
return connector},setPreparedConnector:function(connector,doNotRepaint,doNotChangeListenerComponent,typeId){if(this.connector!==connector){var previous,previousClasses="";if(this.connector!=null){previous=this.connector;previousClasses=previous.getClass();this.connector.cleanup();this.connector.destroy()}
this.connector=connector;if(typeId){this.cacheTypeItem("connector",connector,typeId)}
this.canvas=this.connector.canvas;this.bgCanvas=this.connector.bgCanvas;this.connector.reattach(this._jsPlumb.instance);this.addClass(previousClasses);if(this.canvas){this.canvas._jsPlumb=this}
if(this.bgCanvas){this.bgCanvas._jsPlumb=this}
if(previous!=null){var o=this.getOverlays();for(var i=0;i<o.length;i++){if(o[i].transfer){o[i].transfer(this.connector)}}}
if(!doNotChangeListenerComponent){this.setListenerComponent(this.connector)}
if(!doNotRepaint){this.repaint()}}},setConnector:function(connectorSpec,doNotRepaint,doNotChangeListenerComponent,typeId){var connector=this.prepareConnector(connectorSpec,typeId);this.setPreparedConnector(connector,doNotRepaint,doNotChangeListenerComponent,typeId)},paint:function(params){if(!this._jsPlumb.instance.isSuspendDrawing()&&this._jsPlumb.visible){params=params||{};var timestamp=params.timestamp,swap=!1,tId=swap?this.sourceId:this.targetId,sId=swap?this.targetId:this.sourceId,tIdx=swap?0:1,sIdx=swap?1:0;if(timestamp==null||timestamp!==this._jsPlumb.lastPaintedAt){var sourceInfo=this._jsPlumb.instance.updateOffset({elId:sId}).o,targetInfo=this._jsPlumb.instance.updateOffset({elId:tId}).o,sE=this.endpoints[sIdx],tE=this.endpoints[tIdx];var sAnchorP=sE.anchor.getCurrentLocation({xy:[sourceInfo.left,sourceInfo.top],wh:[sourceInfo.width,sourceInfo.height],element:sE,timestamp:timestamp,rotation:this._jsPlumb.instance.getRotation(this.sourceId)}),tAnchorP=tE.anchor.getCurrentLocation({xy:[targetInfo.left,targetInfo.top],wh:[targetInfo.width,targetInfo.height],element:tE,timestamp:timestamp,rotation:this._jsPlumb.instance.getRotation(this.targetId)});this.connector.resetBounds();this.connector.compute({sourcePos:sAnchorP,targetPos:tAnchorP,sourceOrientation:sE.anchor.getOrientation(sE),targetOrientation:tE.anchor.getOrientation(tE),sourceEndpoint:this.endpoints[sIdx],targetEndpoint:this.endpoints[tIdx],"stroke-width":this._jsPlumb.paintStyleInUse.strokeWidth,sourceInfo:sourceInfo,targetInfo:targetInfo});var overlayExtents={minX:Infinity,minY:Infinity,maxX:-Infinity,maxY:-Infinity};for(var i in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(i)){var o=this._jsPlumb.overlays[i];if(o.isVisible()){this._jsPlumb.overlayPlacements[i]=o.draw(this.connector,this._jsPlumb.paintStyleInUse,this.getAbsoluteOverlayPosition(o));overlayExtents.minX=Math.min(overlayExtents.minX,this._jsPlumb.overlayPlacements[i].minX);overlayExtents.maxX=Math.max(overlayExtents.maxX,this._jsPlumb.overlayPlacements[i].maxX);overlayExtents.minY=Math.min(overlayExtents.minY,this._jsPlumb.overlayPlacements[i].minY);overlayExtents.maxY=Math.max(overlayExtents.maxY,this._jsPlumb.overlayPlacements[i].maxY)}}}
var lineWidth=parseFloat(this._jsPlumb.paintStyleInUse.strokeWidth||1)/2,outlineWidth=parseFloat(this._jsPlumb.paintStyleInUse.strokeWidth||0),extents={xmin:Math.min(this.connector.bounds.minX-(lineWidth+outlineWidth),overlayExtents.minX),ymin:Math.min(this.connector.bounds.minY-(lineWidth+outlineWidth),overlayExtents.minY),xmax:Math.max(this.connector.bounds.maxX+(lineWidth+outlineWidth),overlayExtents.maxX),ymax:Math.max(this.connector.bounds.maxY+(lineWidth+outlineWidth),overlayExtents.maxY)};this.connector.paintExtents=extents;this.connector.paint(this._jsPlumb.paintStyleInUse,null,extents);for(var j in this._jsPlumb.overlays){if(this._jsPlumb.overlays.hasOwnProperty(j)){var p=this._jsPlumb.overlays[j];if(p.isVisible()){p.paint(this._jsPlumb.overlayPlacements[j],extents)}}}}
this._jsPlumb.lastPaintedAt=timestamp}},repaint:function(params){var p=jsPlumb.extend(params||{},{});p.elId=this.sourceId;this.paint(p)},prepareEndpoint:function(_jsPlumb,_newEndpoint,conn,existing,index,params,element,elementId,definition){var e;if(existing){conn.endpoints[index]=existing;existing.addConnection(conn)}else{if(!params.endpoints){params.endpoints=[null,null]}
var ep=definition||params.endpoints[index]||params.endpoint||_jsPlumb.Defaults.Endpoints[index]||_jp.Defaults.Endpoints[index]||_jsPlumb.Defaults.Endpoint||_jp.Defaults.Endpoint;if(!params.endpointStyles){params.endpointStyles=[null,null]}
if(!params.endpointHoverStyles){params.endpointHoverStyles=[null,null]}
var es=params.endpointStyles[index]||params.endpointStyle||_jsPlumb.Defaults.EndpointStyles[index]||_jp.Defaults.EndpointStyles[index]||_jsPlumb.Defaults.EndpointStyle||_jp.Defaults.EndpointStyle;if(es.fill==null&&params.paintStyle!=null){es.fill=params.paintStyle.stroke}
if(es.outlineStroke==null&&params.paintStyle!=null){es.outlineStroke=params.paintStyle.outlineStroke}
if(es.outlineWidth==null&&params.paintStyle!=null){es.outlineWidth=params.paintStyle.outlineWidth}
var ehs=params.endpointHoverStyles[index]||params.endpointHoverStyle||_jsPlumb.Defaults.EndpointHoverStyles[index]||_jp.Defaults.EndpointHoverStyles[index]||_jsPlumb.Defaults.EndpointHoverStyle||_jp.Defaults.EndpointHoverStyle;if(params.hoverPaintStyle!=null){if(ehs==null){ehs={}}
if(ehs.fill==null){ehs.fill=params.hoverPaintStyle.stroke}}
var a=params.anchors?params.anchors[index]:params.anchor?params.anchor:_makeAnchor(_jsPlumb.Defaults.Anchors[index],elementId,_jsPlumb)||_makeAnchor(_jp.Defaults.Anchors[index],elementId,_jsPlumb)||_makeAnchor(_jsPlumb.Defaults.Anchor,elementId,_jsPlumb)||_makeAnchor(_jp.Defaults.Anchor,elementId,_jsPlumb),u=params.uuids?params.uuids[index]:null;e=_newEndpoint({paintStyle:es,hoverPaintStyle:ehs,endpoint:ep,connections:[conn],uuid:u,anchor:a,source:element,scope:params.scope,reattach:params.reattach||_jsPlumb.Defaults.ReattachConnections,detachable:params.detachable||_jsPlumb.Defaults.ConnectionsDetachable});if(existing==null){e.setDeleteOnEmpty(!0)}
conn.endpoints[index]=e;if(params.drawEndpoints===!1){e.setVisible(!1,!0,!0)}}
return e},replaceEndpoint:function(idx,endpointDef){var current=this.endpoints[idx],elId=current.elementId,ebe=this._jsPlumb.instance.getEndpoints(elId),_idx=ebe.indexOf(current),_new=this.makeEndpoint(idx===0,current.element,elId,null,endpointDef);this.endpoints[idx]=_new;ebe.splice(_idx,1,_new);this._jsPlumb.instance.deleteObject({endpoint:current,deleteAttachedObjects:!1});this._jsPlumb.instance.fire("endpointReplaced",{previous:current,current:_new});this._jsPlumb.instance.router.sourceOrTargetChanged(this.endpoints[1].elementId,this.endpoints[1].elementId,this,this.endpoints[1].element,1)}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jp=root.jsPlumb;_jp.AnchorManager=function(params){var _amEndpoints={},continuousAnchorLocations={},continuousAnchorOrientations={},connectionsByElementId={},self=this,anchorLists={},jsPlumbInstance=params.jsPlumbInstance,floatingConnections={},placeAnchorsOnLine=function(desc,elementDimensions,elementPosition,connections,horizontal,otherMultiplier,reverse,rotation){var a=[],step=elementDimensions[horizontal?0:1]/(connections.length+1);for(var i=0;i<connections.length;i++){var val=(i+1)*step,other=otherMultiplier*elementDimensions[horizontal?1:0];if(reverse){val=elementDimensions[horizontal?0:1]-val}
var dx=(horizontal?val:other),x=elementPosition.left+dx,xp=dx/elementDimensions[0],dy=(horizontal?other:val),y=elementPosition.top+dy,yp=dy/elementDimensions[1];if(rotation!==0){var rotated=jsPlumbUtil.rotatePoint([x,y],[elementPosition.centerx,elementPosition.centery],rotation);x=rotated[0];y=rotated[1]}
a.push([x,y,xp,yp,connections[i][1],connections[i][2]])}
return a},rightAndBottomSort=function(a,b){return b[0][0]-a[0][0]},leftAndTopSort=function(a,b){var p1=a[0][0]<0?-Math.PI-a[0][0]:Math.PI-a[0][0],p2=b[0][0]<0?-Math.PI-b[0][0]:Math.PI-b[0][0];return p1-p2},edgeSortFunctions={"top":leftAndTopSort,"right":rightAndBottomSort,"bottom":rightAndBottomSort,"left":leftAndTopSort},_sortHelper=function(_array,_fn){return _array.sort(_fn)},placeAnchors=function(elementId,_anchorLists){var cd=jsPlumbInstance.getCachedData(elementId),sS=cd.s,sO=cd.o,placeSomeAnchors=function(desc,elementDimensions,elementPosition,unsortedConnections,isHorizontal,otherMultiplier,orientation){if(unsortedConnections.length>0){var sc=_sortHelper(unsortedConnections,edgeSortFunctions[desc]),reverse=desc==="right"||desc==="top",rotation=jsPlumbInstance.getRotation(elementId),anchors=placeAnchorsOnLine(desc,elementDimensions,elementPosition,sc,isHorizontal,otherMultiplier,reverse,rotation);var _setAnchorLocation=function(endpoint,anchorPos){continuousAnchorLocations[endpoint.id]=[anchorPos[0],anchorPos[1],anchorPos[2],anchorPos[3]];continuousAnchorOrientations[endpoint.id]=orientation};for(var i=0;i<anchors.length;i++){var c=anchors[i][4],weAreSource=c.endpoints[0].elementId===elementId,weAreTarget=c.endpoints[1].elementId===elementId;if(weAreSource){_setAnchorLocation(c.endpoints[0],anchors[i])}
if(weAreTarget){_setAnchorLocation(c.endpoints[1],anchors[i])}}}};placeSomeAnchors("bottom",sS,sO,_anchorLists.bottom,!0,1,[0,1]);placeSomeAnchors("top",sS,sO,_anchorLists.top,!0,0,[0,-1]);placeSomeAnchors("left",sS,sO,_anchorLists.left,!1,0,[-1,0]);placeSomeAnchors("right",sS,sO,_anchorLists.right,!1,1,[1,0])};this.reset=function(){_amEndpoints={};connectionsByElementId={};anchorLists={}};this.addFloatingConnection=function(key,conn){floatingConnections[key]=conn};this.newConnection=function(conn){var sourceId=conn.sourceId,targetId=conn.targetId,ep=conn.endpoints,doRegisterTarget=!0,registerConnection=function(otherIndex,otherEndpoint,otherAnchor,elId,c){if((sourceId===targetId)&&otherAnchor.isContinuous){conn._jsPlumb.instance.removeElement(ep[1].canvas);doRegisterTarget=!1}
_ju.addToList(connectionsByElementId,elId,[c,otherEndpoint,otherAnchor.constructor===_jp.DynamicAnchor])};registerConnection(0,ep[0],ep[0].anchor,targetId,conn);if(doRegisterTarget){registerConnection(1,ep[1],ep[1].anchor,sourceId,conn)}};var removeEndpointFromAnchorLists=function(endpoint){(function(list,eId){if(list){var f=function(e){return e[4]===eId};_ju.removeWithFunction(list.top,f);_ju.removeWithFunction(list.left,f);_ju.removeWithFunction(list.bottom,f);_ju.removeWithFunction(list.right,f)}})(anchorLists[endpoint.elementId],endpoint.id)};this.connectionDetached=function(connInfo,doNotRedraw){var connection=connInfo.connection||connInfo,sourceId=connInfo.sourceId,targetId=connInfo.targetId,ep=connection.endpoints,removeConnection=function(otherIndex,otherEndpoint,otherAnchor,elId,c){_ju.removeWithFunction(connectionsByElementId[elId],function(_c){return _c[0].id===c.id})};removeConnection(1,ep[1],ep[1].anchor,sourceId,connection);removeConnection(0,ep[0],ep[0].anchor,targetId,connection);if(connection.floatingId){removeConnection(connection.floatingIndex,connection.floatingEndpoint,connection.floatingEndpoint.anchor,connection.floatingId,connection);removeEndpointFromAnchorLists(connection.floatingEndpoint)}
removeEndpointFromAnchorLists(connection.endpoints[0]);removeEndpointFromAnchorLists(connection.endpoints[1]);if(!doNotRedraw){self.redraw(connection.sourceId);if(connection.targetId!==connection.sourceId){self.redraw(connection.targetId)}}};this.addEndpoint=function(endpoint,elementId){_ju.addToList(_amEndpoints,elementId,endpoint)};this.changeId=function(oldId,newId){connectionsByElementId[newId]=connectionsByElementId[oldId];_amEndpoints[newId]=_amEndpoints[oldId];delete connectionsByElementId[oldId];delete _amEndpoints[oldId]};this.getConnectionsFor=function(elementId){return connectionsByElementId[elementId]||[]};this.getEndpointsFor=function(elementId){return _amEndpoints[elementId]||[]};this.deleteEndpoint=function(endpoint){_ju.removeWithFunction(_amEndpoints[endpoint.elementId],function(e){return e.id===endpoint.id});removeEndpointFromAnchorLists(endpoint)};this.elementRemoved=function(elementId){delete floatingConnections[elementId];delete _amEndpoints[elementId];_amEndpoints[elementId]=[]};var _updateAnchorList=function(lists,theta,order,conn,aBoolean,otherElId,idx,reverse,edgeId,elId,connsToPaint,endpointsToPaint){var exactIdx=-1,firstMatchingElIdx=-1,endpoint=conn.endpoints[idx],endpointId=endpoint.id,oIdx=[1,0][idx],values=[[theta,order],conn,aBoolean,otherElId,endpointId],listToAddTo=lists[edgeId],listToRemoveFrom=endpoint._continuousAnchorEdge?lists[endpoint._continuousAnchorEdge]:null,i,candidate;if(listToRemoveFrom){var rIdx=_ju.findWithFunction(listToRemoveFrom,function(e){return e[4]===endpointId});if(rIdx!==-1){listToRemoveFrom.splice(rIdx,1);for(i=0;i<listToRemoveFrom.length;i++){candidate=listToRemoveFrom[i][1];_ju.addWithFunction(connsToPaint,candidate,function(c){return c.id===candidate.id});_ju.addWithFunction(endpointsToPaint,listToRemoveFrom[i][1].endpoints[idx],function(e){return e.id===candidate.endpoints[idx].id});_ju.addWithFunction(endpointsToPaint,listToRemoveFrom[i][1].endpoints[oIdx],function(e){return e.id===candidate.endpoints[oIdx].id})}}}
for(i=0;i<listToAddTo.length;i++){candidate=listToAddTo[i][1];if(params.idx===1&&listToAddTo[i][3]===otherElId&&firstMatchingElIdx===-1){firstMatchingElIdx=i}
_ju.addWithFunction(connsToPaint,candidate,function(c){return c.id===candidate.id});_ju.addWithFunction(endpointsToPaint,listToAddTo[i][1].endpoints[idx],function(e){return e.id===candidate.endpoints[idx].id});_ju.addWithFunction(endpointsToPaint,listToAddTo[i][1].endpoints[oIdx],function(e){return e.id===candidate.endpoints[oIdx].id})}
if(exactIdx!==-1){listToAddTo[exactIdx]=values}else{var insertIdx=reverse?firstMatchingElIdx!==-1?firstMatchingElIdx:0:listToAddTo.length;listToAddTo.splice(insertIdx,0,values)}
endpoint._continuousAnchorEdge=edgeId};this.sourceOrTargetChanged=function(originalId,newId,connection,newElement,anchorIndex){if(anchorIndex===0){if(originalId!==newId){connection.sourceId=newId;connection.source=newElement;_ju.removeWithFunction(connectionsByElementId[originalId],function(info){return info[0].id===connection.id});var tIdx=_ju.findWithFunction(connectionsByElementId[connection.targetId],function(i){return i[0].id===connection.id});if(tIdx>-1){connectionsByElementId[connection.targetId][tIdx][0]=connection;connectionsByElementId[connection.targetId][tIdx][1]=connection.endpoints[0];connectionsByElementId[connection.targetId][tIdx][2]=connection.endpoints[0].anchor.constructor===_jp.DynamicAnchor}
_ju.addToList(connectionsByElementId,newId,[connection,connection.endpoints[1],connection.endpoints[1].anchor.constructor===_jp.DynamicAnchor]);if(connection.endpoints[1].anchor.isContinuous){if(connection.source===connection.target){connection._jsPlumb.instance.removeElement(connection.endpoints[1].canvas)}else{if(connection.endpoints[1].canvas.parentNode==null){connection._jsPlumb.instance.appendElement(connection.endpoints[1].canvas)}}}
connection.updateConnectedClass()}}else if(anchorIndex===1){var sourceElId=connection.endpoints[0].elementId;connection.target=newElement;connection.targetId=newId;var sIndex=_ju.findWithFunction(connectionsByElementId[sourceElId],function(i){return i[0].id===connection.id}),tIndex=_ju.findWithFunction(connectionsByElementId[originalId],function(i){return i[0].id===connection.id});if(sIndex!==-1){connectionsByElementId[sourceElId][sIndex][0]=connection;connectionsByElementId[sourceElId][sIndex][1]=connection.endpoints[1];connectionsByElementId[sourceElId][sIndex][2]=connection.endpoints[1].anchor.constructor===_jp.DynamicAnchor}
if(tIndex>-1){connectionsByElementId[originalId].splice(tIndex,1);_ju.addToList(connectionsByElementId,newId,[connection,connection.endpoints[0],connection.endpoints[0].anchor.constructor===_jp.DynamicAnchor])}
connection.updateConnectedClass()}};this.rehomeEndpoint=function(ep,currentId,element){var eps=_amEndpoints[currentId]||[],elementId=jsPlumbInstance.getId(element);if(elementId!==currentId){var idx=eps.indexOf(ep);if(idx>-1){var _ep=eps.splice(idx,1)[0];self.add(_ep,elementId)}}
for(var i=0;i<ep.connections.length;i++){if(ep.connections[i].sourceId===currentId){self.sourceOrTargetChanged(currentId,ep.elementId,ep.connections[i],ep.element,0)}else if(ep.connections[i].targetId===currentId){self.sourceOrTargetChanged(currentId,ep.elementId,ep.connections[i],ep.element,1)}}};this.redraw=function(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint){var connectionsToPaint=[],endpointsToPaint=[],anchorsToUpdate=[];if(!jsPlumbInstance.isSuspendDrawing()){var ep=_amEndpoints[elementId]||[],endpointConnections=connectionsByElementId[elementId]||[];timestamp=timestamp||jsPlumbUtil.uuid();offsetToUI=offsetToUI||{left:0,top:0};if(ui){ui={left:ui.left+offsetToUI.left,top:ui.top+offsetToUI.top}}
var myOffset=jsPlumbInstance.updateOffset({elId:elementId,offset:ui,recalc:!1,timestamp:timestamp}),orientationCache={};for(var i=0;i<endpointConnections.length;i++){var conn=endpointConnections[i][0],sourceId=conn.sourceId,targetId=conn.targetId,sourceContinuous=conn.endpoints[0].anchor.isContinuous,targetContinuous=conn.endpoints[1].anchor.isContinuous;if(sourceContinuous||targetContinuous){var oKey=sourceId+"_"+targetId,o=orientationCache[oKey],oIdx=conn.sourceId===elementId?1:0,targetRotation=jsPlumbInstance.getRotation(targetId),sourceRotation=jsPlumbInstance.getRotation(sourceId);if(sourceContinuous&&!anchorLists[sourceId]){anchorLists[sourceId]={top:[],right:[],bottom:[],left:[]}}
if(targetContinuous&&!anchorLists[targetId]){anchorLists[targetId]={top:[],right:[],bottom:[],left:[]}}
if(elementId!==targetId){jsPlumbInstance.updateOffset({elId:targetId,timestamp:timestamp})}
if(elementId!==sourceId){jsPlumbInstance.updateOffset({elId:sourceId,timestamp:timestamp})}
var td=jsPlumbInstance.getCachedData(targetId),sd=jsPlumbInstance.getCachedData(sourceId);if(targetId===sourceId&&(sourceContinuous||targetContinuous)){_updateAnchorList(anchorLists[sourceId],-Math.PI/2,0,conn,!1,targetId,0,!1,"top",sourceId,connectionsToPaint,endpointsToPaint);_updateAnchorList(anchorLists[targetId],-Math.PI/2,0,conn,!1,sourceId,1,!1,"top",targetId,connectionsToPaint,endpointsToPaint)}else{if(!o){o=this.calculateOrientation(sourceId,targetId,sd.o,td.o,conn.endpoints[0].anchor,conn.endpoints[1].anchor,conn,sourceRotation,targetRotation);orientationCache[oKey]=o}
if(sourceContinuous){_updateAnchorList(anchorLists[sourceId],o.theta,0,conn,!1,targetId,0,!1,o.a[0],sourceId,connectionsToPaint,endpointsToPaint)}
if(targetContinuous){_updateAnchorList(anchorLists[targetId],o.theta2,-1,conn,!0,sourceId,1,!0,o.a[1],targetId,connectionsToPaint,endpointsToPaint)}}
if(sourceContinuous){_ju.addWithFunction(anchorsToUpdate,sourceId,function(a){return a===sourceId})}
if(targetContinuous){_ju.addWithFunction(anchorsToUpdate,targetId,function(a){return a===targetId})}
_ju.addWithFunction(connectionsToPaint,conn,function(c){return c.id===conn.id});if((sourceContinuous&&oIdx===0)||(targetContinuous&&oIdx===1)){_ju.addWithFunction(endpointsToPaint,conn.endpoints[oIdx],function(e){return e.id===conn.endpoints[oIdx].id})}}}
for(i=0;i<ep.length;i++){if(ep[i].connections.length===0&&ep[i].anchor.isContinuous){if(!anchorLists[elementId]){anchorLists[elementId]={top:[],right:[],bottom:[],left:[]}}
_updateAnchorList(anchorLists[elementId],-Math.PI/2,0,{endpoints:[ep[i],ep[i]],paint:function(){}},!1,elementId,0,!1,ep[i].anchor.getDefaultFace(),elementId,connectionsToPaint,endpointsToPaint);_ju.addWithFunction(anchorsToUpdate,elementId,function(a){return a===elementId})}}
for(i=0;i<anchorsToUpdate.length;i++){placeAnchors(anchorsToUpdate[i],anchorLists[anchorsToUpdate[i]])}
for(i=0;i<ep.length;i++){ep[i].paint({timestamp:timestamp,offset:myOffset,dimensions:myOffset.s,recalc:doNotRecalcEndpoint!==!0})}
for(i=0;i<endpointsToPaint.length;i++){var cd=jsPlumbInstance.getCachedData(endpointsToPaint[i].elementId);endpointsToPaint[i].paint({timestamp:null,offset:cd,dimensions:cd.s})}
for(i=0;i<endpointConnections.length;i++){var otherEndpoint=endpointConnections[i][1];if(otherEndpoint.anchor.constructor===_jp.DynamicAnchor){otherEndpoint.paint({elementWithPrecedence:elementId,timestamp:timestamp});_ju.addWithFunction(connectionsToPaint,endpointConnections[i][0],function(c){return c.id===endpointConnections[i][0].id});for(var k=0;k<otherEndpoint.connections.length;k++){if(otherEndpoint.connections[k]!==endpointConnections[i][0]){_ju.addWithFunction(connectionsToPaint,otherEndpoint.connections[k],function(c){return c.id===otherEndpoint.connections[k].id})}}}else{_ju.addWithFunction(connectionsToPaint,endpointConnections[i][0],function(c){return c.id===endpointConnections[i][0].id})}}
var fc=floatingConnections[elementId];if(fc){fc.paint({timestamp:timestamp,recalc:!1,elId:elementId})}
for(i=0;i<connectionsToPaint.length;i++){connectionsToPaint[i].paint({elId:elementId,timestamp:null,recalc:!1,clearEdits:clearEdits})}}
return{c:connectionsToPaint,e:endpointsToPaint}};var ContinuousAnchor=function(anchorParams){_ju.EventGenerator.apply(this);this.type="Continuous";this.isDynamic=!0;this.isContinuous=!0;var faces=anchorParams.faces||["top","right","bottom","left"],clockwise=!(anchorParams.clockwise===!1),availableFaces={},opposites={"top":"bottom","right":"left","left":"right","bottom":"top"},clockwiseOptions={"top":"right","right":"bottom","left":"top","bottom":"left"},antiClockwiseOptions={"top":"left","right":"top","left":"bottom","bottom":"right"},secondBest=clockwise?clockwiseOptions:antiClockwiseOptions,lastChoice=clockwise?antiClockwiseOptions:clockwiseOptions,cssClass=anchorParams.cssClass||"",_currentFace=null,_lockedFace=null,X_AXIS_FACES=["left","right"],Y_AXIS_FACES=["top","bottom"],_lockedAxis=null;for(var i=0;i<faces.length;i++){availableFaces[faces[i]]=!0}
this.getDefaultFace=function(){return faces.length===0?"top":faces[0]};this.isRelocatable=function(){return!0};this.isSnapOnRelocate=function(){return!0};this.verifyEdge=function(edge){if(availableFaces[edge]){return edge}else if(availableFaces[opposites[edge]]){return opposites[edge]}else if(availableFaces[secondBest[edge]]){return secondBest[edge]}else if(availableFaces[lastChoice[edge]]){return lastChoice[edge]}
return edge};this.isEdgeSupported=function(edge){return _lockedAxis==null?(_lockedFace==null?availableFaces[edge]===!0:_lockedFace===edge):_lockedAxis.indexOf(edge)!==-1};this.setCurrentFace=function(face,overrideLock){_currentFace=face;if(overrideLock&&_lockedFace!=null){_lockedFace=_currentFace}};this.getCurrentFace=function(){return _currentFace};this.getSupportedFaces=function(){var af=[];for(var k in availableFaces){if(availableFaces[k]){af.push(k)}}
return af};this.lock=function(){_lockedFace=_currentFace};this.unlock=function(){_lockedFace=null};this.isLocked=function(){return _lockedFace!=null};this.lockCurrentAxis=function(){if(_currentFace!=null){_lockedAxis=(_currentFace==="left"||_currentFace==="right")?X_AXIS_FACES:Y_AXIS_FACES}};this.unlockCurrentAxis=function(){_lockedAxis=null};this.compute=function(params){return continuousAnchorLocations[params.element.id]||[0,0]};this.getCurrentLocation=function(params){return continuousAnchorLocations[params.element.id]||[0,0]};this.getOrientation=function(endpoint){return continuousAnchorOrientations[endpoint.id]||[0,0]};this.getCssClass=function(){return cssClass}};jsPlumbInstance.continuousAnchorFactory={get:function(params){return new ContinuousAnchor(params)},clear:function(elementId){delete continuousAnchorLocations[elementId]}}};_jp.AnchorManager.prototype.calculateOrientation=function(sourceId,targetId,sd,td,sourceAnchor,targetAnchor,connection,sourceRotation,targetRotation){var Orientation={HORIZONTAL:"horizontal",VERTICAL:"vertical",DIAGONAL:"diagonal",IDENTITY:"identity"},axes=["left","top","right","bottom"];if(sourceId===targetId){return{orientation:Orientation.IDENTITY,a:["top","top"]}}
var theta=Math.atan2((td.centery-sd.centery),(td.centerx-sd.centerx)),theta2=Math.atan2((sd.centery-td.centery),(sd.centerx-td.centerx));var candidates=[],midpoints={};(function(types,dim){for(var i=0;i<types.length;i++){midpoints[types[i]]={"left":[dim[i][0].left,dim[i][0].centery],"right":[dim[i][0].right,dim[i][0].centery],"top":[dim[i][0].centerx,dim[i][0].top],"bottom":[dim[i][0].centerx,dim[i][0].bottom]};if(dim[i][1]!==0){for(var axis in midpoints[types[i]]){midpoints[types[i]][axis]=jsPlumbUtil.rotatePoint(midpoints[types[i]][axis],[dim[i][0].centerx,dim[i][0].centery],dim[i][1])}}}})(["source","target"],[[sd,sourceRotation],[td,targetRotation]]);for(var sf=0;sf<axes.length;sf++){for(var tf=0;tf<axes.length;tf++){candidates.push({source:axes[sf],target:axes[tf],dist:Biltong.lineLength(midpoints.source[axes[sf]],midpoints.target[axes[tf]])})}}
candidates.sort(function(a,b){return a.dist<b.dist?-1:a.dist>b.dist?1:0});var sourceEdge=candidates[0].source,targetEdge=candidates[0].target;for(var i=0;i<candidates.length;i++){if(sourceAnchor.isContinuous&&sourceAnchor.locked){sourceEdge=sourceAnchor.getCurrentFace()}else if(!sourceAnchor.isContinuous||sourceAnchor.isEdgeSupported(candidates[i].source)){sourceEdge=candidates[i].source}else{sourceEdge=null}
if(targetAnchor.isContinuous&&targetAnchor.locked){targetEdge=targetAnchor.getCurrentFace()}else if(!targetAnchor.isContinuous||targetAnchor.isEdgeSupported(candidates[i].target)){targetEdge=candidates[i].target}else{targetEdge=null}
if(sourceEdge!=null&&targetEdge!=null){break}}
if(sourceAnchor.isContinuous){sourceAnchor.setCurrentFace(sourceEdge)}
if(targetAnchor.isContinuous){targetAnchor.setCurrentFace(targetEdge)}
return{a:[sourceEdge,targetEdge],theta:theta,theta2:theta2}};_jp.Anchor=function(params){this.x=params.x||0;this.y=params.y||0;this.elementId=params.elementId;this.cssClass=params.cssClass||"";this.orientation=params.orientation||[0,0];this.lastReturnValue=null;this.offsets=params.offsets||[0,0];this.timestamp=null;this._unrotatedOrientation=[this.orientation[0],this.orientation[1]];this.relocatable=params.relocatable!==!1;this.snapOnRelocate=params.snapOnRelocate!==!1;this.locked=!1;_ju.EventGenerator.apply(this);this.compute=function(params){var xy=params.xy,wh=params.wh,timestamp=params.timestamp;if(timestamp&&timestamp===this.timestamp){return this.lastReturnValue}
var candidate=[xy[0]+(this.x*wh[0])+this.offsets[0],xy[1]+(this.y*wh[1])+this.offsets[1],this.x,this.y];var rotation=params.rotation;if(rotation!=null&&rotation!==0){var c2=jsPlumbUtil.rotatePoint(candidate,[xy[0]+(wh[0]/2),xy[1]+(wh[1]/2)],rotation);this.orientation[0]=Math.round((this._unrotatedOrientation[0]*c2[2])-(this._unrotatedOrientation[1]*c2[3]));this.orientation[1]=Math.round((this._unrotatedOrientation[1]*c2[2])+(this._unrotatedOrientation[0]*c2[3]));this.lastReturnValue=[c2[0],c2[1],this.x,this.y]}else{this.orientation[0]=this._unrotatedOrientation[0];this.orientation[1]=this._unrotatedOrientation[1];this.lastReturnValue=candidate}
this.timestamp=timestamp;return this.lastReturnValue};this.getCurrentLocation=function(params){params=params||{};return(this.lastReturnValue==null||(params.timestamp!=null&&this.timestamp!==params.timestamp))?this.compute(params):this.lastReturnValue};this.setPosition=function(x,y,ox,oy,overrideLock){if(!this.locked||overrideLock){this.x=x;this.y=y;this.orientation=[ox,oy];this.lastReturnValue=null}}};_ju.extend(_jp.Anchor,_ju.EventGenerator,{equals:function(anchor){if(!anchor){return!1}
var ao=anchor.getOrientation(),o=this.getOrientation();return this.x===anchor.x&&this.y===anchor.y&&this.offsets[0]===anchor.offsets[0]&&this.offsets[1]===anchor.offsets[1]&&o[0]===ao[0]&&o[1]===ao[1]},getOrientation:function(){return this.orientation},getCssClass:function(){return this.cssClass}});_jp.FloatingAnchor=function(params){_jp.Anchor.apply(this,arguments);var ref=params.reference,refCanvas=params.referenceCanvas,size=_jp.getSize(refCanvas),xDir=0,yDir=0,orientation=null,_lastResult=null;this.orientation=null;this.x=0;this.y=0;this.isFloating=!0;this.compute=function(params){var xy=params.xy,result=[xy[0]+(size[0]/2),xy[1]+(size[1]/2)];_lastResult=result;return result};this.getOrientation=function(_endpoint){if(orientation){return orientation}else{var o=ref.getOrientation(_endpoint);return[Math.abs(o[0])*xDir*-1,Math.abs(o[1])*yDir*-1]}};this.over=function(anchor,endpoint){orientation=anchor.getOrientation(endpoint)};this.out=function(){orientation=null};this.getCurrentLocation=function(params){return _lastResult==null?this.compute(params):_lastResult}};_ju.extend(_jp.FloatingAnchor,_jp.Anchor);var _convertAnchor=function(anchor,jsPlumbInstance,elementId){return anchor.constructor===_jp.Anchor?anchor:jsPlumbInstance.makeAnchor(anchor,elementId,jsPlumbInstance)};_jp.DynamicAnchor=function(params){_jp.Anchor.apply(this,arguments);this.isDynamic=!0;this.anchors=[];this.elementId=params.elementId;this.jsPlumbInstance=params.jsPlumbInstance;for(var i=0;i<params.anchors.length;i++){this.anchors[i]=_convertAnchor(params.anchors[i],this.jsPlumbInstance,this.elementId)}
this.getAnchors=function(){return this.anchors};var _curAnchor=this.anchors.length>0?this.anchors[0]:null,_lastAnchor=_curAnchor,self=this,_distance=function(anchor,cx,cy,xy,wh,r,tr){var ax=xy[0]+(anchor.x*wh[0]),ay=xy[1]+(anchor.y*wh[1]),acx=xy[0]+(wh[0]/2),acy=xy[1]+(wh[1]/2);if(r!=null&&r!==0){var rotated=jsPlumbUtil.rotatePoint([ax,ay],[acx,acy],r);ax=rotated[0];ay=rotated[1]}
return(Math.sqrt(Math.pow(cx-ax,2)+Math.pow(cy-ay,2))+Math.sqrt(Math.pow(acx-ax,2)+Math.pow(acy-ay,2)))},_anchorSelector=params.selector||function(xy,wh,txy,twh,r,tr,anchors){var cx=txy[0]+(twh[0]/2),cy=txy[1]+(twh[1]/2);var minIdx=-1,minDist=Infinity;for(var i=0;i<anchors.length;i++){var d=_distance(anchors[i],cx,cy,xy,wh,r,tr);if(d<minDist){minIdx=i+0;minDist=d}}
return anchors[minIdx]};this.compute=function(params){var xy=params.xy,wh=params.wh,txy=params.txy,twh=params.twh,r=params.rotation,tr=params.tRotation;this.timestamp=params.timestamp;if(this.locked||txy==null||twh==null){this.lastReturnValue=_curAnchor.compute(params);return this.lastReturnValue}else{params.timestamp=null}
_curAnchor=_anchorSelector(xy,wh,txy,twh,r,tr,this.anchors);this.x=_curAnchor.x;this.y=_curAnchor.y;if(_curAnchor!==_lastAnchor){this.fire("anchorChanged",_curAnchor)}
_lastAnchor=_curAnchor;this.lastReturnValue=_curAnchor.compute(params);return this.lastReturnValue};this.getCurrentLocation=function(params){return _curAnchor!=null?_curAnchor.getCurrentLocation(params):null};this.getOrientation=function(_endpoint){return _curAnchor!=null?_curAnchor.getOrientation(_endpoint):[0,0]};this.over=function(anchor,endpoint){if(_curAnchor!=null){_curAnchor.over(anchor,endpoint)}};this.out=function(){if(_curAnchor!=null){_curAnchor.out()}};this.setAnchor=function(a){_curAnchor=a};this.getCssClass=function(){return(_curAnchor&&_curAnchor.getCssClass())||""};this.setAnchorCoordinates=function(coords){var idx=jsPlumbUtil.findWithFunction(this.anchors,function(a){return a.x===coords[0]&&a.y===coords[1]});if(idx!==-1){this.setAnchor(this.anchors[idx]);return!0}else{return!1}}};_ju.extend(_jp.DynamicAnchor,_jp.Anchor);var _curryAnchor=function(x,y,ox,oy,type,fnInit){_jp.Anchors[type]=function(params){var a=params.jsPlumbInstance.makeAnchor([x,y,ox,oy,0,0],params.elementId,params.jsPlumbInstance);a.type=type;if(fnInit){fnInit(a,params)}
return a}};_curryAnchor(0.5,0,0,-1,"TopCenter");_curryAnchor(0.5,1,0,1,"BottomCenter");_curryAnchor(0,0.5,-1,0,"LeftMiddle");_curryAnchor(1,0.5,1,0,"RightMiddle");_curryAnchor(0.5,0,0,-1,"Top");_curryAnchor(0.5,1,0,1,"Bottom");_curryAnchor(0,0.5,-1,0,"Left");_curryAnchor(1,0.5,1,0,"Right");_curryAnchor(0.5,0.5,0,0,"Center");_curryAnchor(1,0,0,-1,"TopRight");_curryAnchor(1,1,0,1,"BottomRight");_curryAnchor(0,0,0,-1,"TopLeft");_curryAnchor(0,1,0,1,"BottomLeft");_jp.Defaults.DynamicAnchors=function(params){return params.jsPlumbInstance.makeAnchors(["TopCenter","RightMiddle","BottomCenter","LeftMiddle"],params.elementId,params.jsPlumbInstance)};_jp.Anchors.AutoDefault=function(params){var a=params.jsPlumbInstance.makeDynamicAnchor(_jp.Defaults.DynamicAnchors(params));a.type="AutoDefault";return a};var _curryContinuousAnchor=function(type,faces){_jp.Anchors[type]=function(params){var a=params.jsPlumbInstance.makeAnchor(["Continuous",{faces:faces}],params.elementId,params.jsPlumbInstance);a.type=type;return a}};_jp.Anchors.Continuous=function(params){return params.jsPlumbInstance.continuousAnchorFactory.get(params)};_curryContinuousAnchor("ContinuousLeft",["left"]);_curryContinuousAnchor("ContinuousTop",["top"]);_curryContinuousAnchor("ContinuousBottom",["bottom"]);_curryContinuousAnchor("ContinuousRight",["right"]);_curryAnchor(0,0,0,0,"Assign",function(anchor,params){var pf=params.position||"Fixed";anchor.positionFinder=pf.constructor===String?params.jsPlumbInstance.AnchorPositionFinders[pf]:pf;anchor.constructorParams=params});root.jsPlumbInstance.prototype.AnchorPositionFinders={"Fixed":function(dp,ep,es){return[(dp.left-ep.left)/es[0],(dp.top-ep.top)/es[1]]},"Grid":function(dp,ep,es,params){var dx=dp.left-ep.left,dy=dp.top-ep.top,gx=es[0]/(params.grid[0]),gy=es[1]/(params.grid[1]),mx=Math.floor(dx/gx),my=Math.floor(dy/gy);return[((mx*gx)+(gx/2))/es[0],((my*gy)+(gy/2))/es[1]]}};_jp.Anchors.Perimeter=function(params){params=params||{};var anchorCount=params.anchorCount||60,shape=params.shape;if(!shape){throw new Error("no shape supplied to Perimeter Anchor type")}
var _circle=function(){var r=0.5,step=Math.PI*2/anchorCount,current=0,a=[];for(var i=0;i<anchorCount;i++){var x=r+(r*Math.sin(current)),y=r+(r*Math.cos(current));a.push([x,y,0,0]);current+=step}
return a},_path=function(segments){var anchorsPerFace=anchorCount/segments.length,a=[],_computeFace=function(x1,y1,x2,y2,fractionalLength,ox,oy){anchorsPerFace=anchorCount*fractionalLength;var dx=(x2-x1)/anchorsPerFace,dy=(y2-y1)/anchorsPerFace;for(var i=0;i<anchorsPerFace;i++){a.push([x1+(dx*i),y1+(dy*i),ox==null?0:ox,oy==null?0:oy])}};for(var i=0;i<segments.length;i++){_computeFace.apply(null,segments[i])}
return a},_shape=function(faces){var s=[];for(var i=0;i<faces.length;i++){s.push([faces[i][0],faces[i][1],faces[i][2],faces[i][3],1/faces.length,faces[i][4],faces[i][5]])}
return _path(s)},_rectangle=function(){return _shape([[0,0,1,0,0,-1],[1,0,1,1,1,0],[1,1,0,1,0,1],[0,1,0,0,-1,0]])};var _shapes={"Circle":_circle,"Ellipse":_circle,"Diamond":function(){return _shape([[0.5,0,1,0.5],[1,0.5,0.5,1],[0.5,1,0,0.5],[0,0.5,0.5,0]])},"Rectangle":_rectangle,"Square":_rectangle,"Triangle":function(){return _shape([[0.5,0,1,1],[1,1,0,1],[0,1,0.5,0]])},"Path":function(params){var points=params.points,p=[],tl=0;for(var i=0;i<points.length-1;i++){var l=Math.sqrt(Math.pow(points[i][2]-points[i][0])+Math.pow(points[i][3]-points[i][1]));tl+=l;p.push([points[i][0],points[i][1],points[i+1][0],points[i+1][1],l])}
for(var j=0;j<p.length;j++){p[j][4]=p[j][4]/tl}
return _path(p)}},_rotate=function(points,amountInDegrees){var o=[],theta=amountInDegrees/180*Math.PI;for(var i=0;i<points.length;i++){var _x=points[i][0]-0.5,_y=points[i][1]-0.5;o.push([0.5+((_x*Math.cos(theta))-(_y*Math.sin(theta))),0.5+((_x*Math.sin(theta))+(_y*Math.cos(theta))),points[i][2],points[i][3]])}
return o};if(!_shapes[shape]){throw new Error("Shape ["+shape+"] is unknown by Perimeter Anchor type")}
var da=_shapes[shape](params);if(params.rotation){da=_rotate(da,params.rotation)}
var a=params.jsPlumbInstance.makeDynamicAnchor(da);a.type="Perimeter";return a}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jp=root.jsPlumb;_jp.DefaultRouter=function(jsPlumbInstance){this.jsPlumbInstance=jsPlumbInstance;this.anchorManager=new _jp.AnchorManager({jsPlumbInstance:jsPlumbInstance});this.sourceOrTargetChanged=function(originalId,newId,connection,newElement,anchorIndex){this.anchorManager.sourceOrTargetChanged(originalId,newId,connection,newElement,anchorIndex)};this.reset=function(){this.anchorManager.reset()};this.changeId=function(oldId,newId){this.anchorManager.changeId(oldId,newId)};this.elementRemoved=function(elementId){this.anchorManager.elementRemoved(elementId)};this.newConnection=function(conn){this.anchorManager.newConnection(conn)};this.connectionDetached=function(connInfo,doNotRedraw){this.anchorManager.connectionDetached(connInfo,doNotRedraw)};this.redraw=function(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint){return this.anchorManager.redraw(elementId,ui,timestamp,offsetToUI,clearEdits,doNotRecalcEndpoint)};this.deleteEndpoint=function(endpoint){this.anchorManager.deleteEndpoint(endpoint)};this.rehomeEndpoint=function(ep,currentId,element){this.anchorManager.rehomeEndpoint(ep,currentId,element)};this.addEndpoint=function(endpoint,elementId){this.anchorManager.addEndpoint(endpoint,elementId)}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil,_jg=root.Biltong;_jp.Segments={AbstractSegment:function(params){this.params=params;this.findClosestPointOnPath=function(x,y){return{d:Infinity,x:null,y:null,l:null}};this.getBounds=function(){return{minX:Math.min(params.x1,params.x2),minY:Math.min(params.y1,params.y2),maxX:Math.max(params.x1,params.x2),maxY:Math.max(params.y1,params.y2)}};this.lineIntersection=function(x1,y1,x2,y2){return[]};this.boxIntersection=function(x,y,w,h){var a=[];a.push.apply(a,this.lineIntersection(x,y,x+w,y));a.push.apply(a,this.lineIntersection(x+w,y,x+w,y+h));a.push.apply(a,this.lineIntersection(x+w,y+h,x,y+h));a.push.apply(a,this.lineIntersection(x,y+h,x,y));return a};this.boundingBoxIntersection=function(box){return this.boxIntersection(box.x,box.y,box.w,box.y)}},Straight:function(params){var _super=_jp.Segments.AbstractSegment.apply(this,arguments),length,m,m2,x1,x2,y1,y2,_recalc=function(){length=Math.sqrt(Math.pow(x2-x1,2)+Math.pow(y2-y1,2));m=_jg.gradient({x:x1,y:y1},{x:x2,y:y2});m2=-1/m};this.type="Straight";this.getLength=function(){return length};this.getGradient=function(){return m};this.getCoordinates=function(){return{x1:x1,y1:y1,x2:x2,y2:y2}};this.setCoordinates=function(coords){x1=coords.x1;y1=coords.y1;x2=coords.x2;y2=coords.y2;_recalc()};this.setCoordinates({x1:params.x1,y1:params.y1,x2:params.x2,y2:params.y2});this.getBounds=function(){return{minX:Math.min(x1,x2),minY:Math.min(y1,y2),maxX:Math.max(x1,x2),maxY:Math.max(y1,y2)}};this.pointOnPath=function(location,absolute){if(location===0&&!absolute){return{x:x1,y:y1}}else if(location===1&&!absolute){return{x:x2,y:y2}}else{var l=absolute?location>0?location:length+location:location*length;return _jg.pointOnLine({x:x1,y:y1},{x:x2,y:y2},l)}};this.gradientAtPoint=function(_){return m};this.pointAlongPathFrom=function(location,distance,absolute){var p=this.pointOnPath(location,absolute),farAwayPoint=distance<=0?{x:x1,y:y1}:{x:x2,y:y2};if(distance<=0&&Math.abs(distance)>1){distance*=-1}
return _jg.pointOnLine(p,farAwayPoint,distance)};var within=function(a,b,c){return c>=Math.min(a,b)&&c<=Math.max(a,b)};var closest=function(a,b,c){return Math.abs(c-a)<Math.abs(c-b)?a:b};this.findClosestPointOnPath=function(x,y){var out={d:Infinity,x:null,y:null,l:null,x1:x1,x2:x2,y1:y1,y2:y2};if(m===0){out.y=y1;out.x=within(x1,x2,x)?x:closest(x1,x2,x)}else if(m===Infinity||m===-Infinity){out.x=x1;out.y=within(y1,y2,y)?y:closest(y1,y2,y)}else{var b=y1-(m*x1),b2=y-(m2*x),_x1=(b2-b)/(m-m2),_y1=(m*_x1)+b;out.x=within(x1,x2,_x1)?_x1:closest(x1,x2,_x1);out.y=within(y1,y2,_y1)?_y1:closest(y1,y2,_y1)}
var fractionInSegment=_jg.lineLength([out.x,out.y],[x1,y1]);out.d=_jg.lineLength([x,y],[out.x,out.y]);out.l=fractionInSegment/length;return out};var _pointLiesBetween=function(q,p1,p2){return(p2>p1)?(p1<=q&&q<=p2):(p1>=q&&q>=p2)},_plb=_pointLiesBetween;this.lineIntersection=function(_x1,_y1,_x2,_y2){var m2=Math.abs(_jg.gradient({x:_x1,y:_y1},{x:_x2,y:_y2})),m1=Math.abs(m),b=m1===Infinity?x1:y1-(m1*x1),out=[],b2=m2===Infinity?_x1:_y1-(m2*_x1);if(m2!==m1){if(m2===Infinity&&m1===0){if(_plb(_x1,x1,x2)&&_plb(y1,_y1,_y2)){out=[_x1,y1]}}else if(m2===0&&m1===Infinity){if(_plb(_y1,y1,y2)&&_plb(x1,_x1,_x2)){out=[x1,_y1]}}else{var X,Y;if(m2===Infinity){X=_x1;if(_plb(X,x1,x2)){Y=(m1*_x1)+b;if(_plb(Y,_y1,_y2)){out=[X,Y]}}}else if(m2===0){Y=_y1;if(_plb(Y,y1,y2)){X=(_y1-b)/m1;if(_plb(X,_x1,_x2)){out=[X,Y]}}}else{X=(b2-b)/(m1-m2);Y=(m1*X)+b;if(_plb(X,x1,x2)&&_plb(Y,y1,y2)){out=[X,Y]}}}}
return out};this.boxIntersection=function(x,y,w,h){var a=[];a.push.apply(a,this.lineIntersection(x,y,x+w,y));a.push.apply(a,this.lineIntersection(x+w,y,x+w,y+h));a.push.apply(a,this.lineIntersection(x+w,y+h,x,y+h));a.push.apply(a,this.lineIntersection(x,y+h,x,y));return a};this.boundingBoxIntersection=function(box){return this.boxIntersection(box.x,box.y,box.w,box.h)}},Arc:function(params){var _super=_jp.Segments.AbstractSegment.apply(this,arguments),_calcAngle=function(_x,_y){return _jg.theta([params.cx,params.cy],[_x,_y])},_calcAngleForLocation=function(segment,location){if(segment.anticlockwise){var sa=segment.startAngle<segment.endAngle?segment.startAngle+TWO_PI:segment.startAngle,s=Math.abs(sa-segment.endAngle);return sa-(s*location)}else{var ea=segment.endAngle<segment.startAngle?segment.endAngle+TWO_PI:segment.endAngle,ss=Math.abs(ea-segment.startAngle);return segment.startAngle+(ss*location)}},TWO_PI=2*Math.PI;this.radius=params.r;this.anticlockwise=params.ac;this.type="Arc";if(params.startAngle&&params.endAngle){this.startAngle=params.startAngle;this.endAngle=params.endAngle;this.x1=params.cx+(this.radius*Math.cos(params.startAngle));this.y1=params.cy+(this.radius*Math.sin(params.startAngle));this.x2=params.cx+(this.radius*Math.cos(params.endAngle));this.y2=params.cy+(this.radius*Math.sin(params.endAngle))}else{this.startAngle=_calcAngle(params.x1,params.y1);this.endAngle=_calcAngle(params.x2,params.y2);this.x1=params.x1;this.y1=params.y1;this.x2=params.x2;this.y2=params.y2}
if(this.endAngle<0){this.endAngle+=TWO_PI}
if(this.startAngle<0){this.startAngle+=TWO_PI}
var ea=this.endAngle<this.startAngle?this.endAngle+TWO_PI:this.endAngle;this.sweep=Math.abs(ea-this.startAngle);if(this.anticlockwise){this.sweep=TWO_PI-this.sweep}
var circumference=2*Math.PI*this.radius,frac=this.sweep/TWO_PI,length=circumference*frac;this.getLength=function(){return length};this.getBounds=function(){return{minX:params.cx-params.r,maxX:params.cx+params.r,minY:params.cy-params.r,maxY:params.cy+params.r}};var VERY_SMALL_VALUE=0.0000000001,gentleRound=function(n){var f=Math.floor(n),r=Math.ceil(n);if(n-f<VERY_SMALL_VALUE){return f}else if(r-n<VERY_SMALL_VALUE){return r}
return n};this.pointOnPath=function(location,absolute){if(location===0){return{x:this.x1,y:this.y1,theta:this.startAngle}}else if(location===1){return{x:this.x2,y:this.y2,theta:this.endAngle}}
if(absolute){location=location/length}
var angle=_calcAngleForLocation(this,location),_x=params.cx+(params.r*Math.cos(angle)),_y=params.cy+(params.r*Math.sin(angle));return{x:gentleRound(_x),y:gentleRound(_y),theta:angle}};this.gradientAtPoint=function(location,absolute){var p=this.pointOnPath(location,absolute);var m=_jg.normal([params.cx,params.cy],[p.x,p.y]);if(!this.anticlockwise&&(m===Infinity||m===-Infinity)){m*=-1}
return m};this.pointAlongPathFrom=function(location,distance,absolute){var p=this.pointOnPath(location,absolute),arcSpan=distance/circumference*2*Math.PI,dir=this.anticlockwise?-1:1,startAngle=p.theta+(dir*arcSpan),startX=params.cx+(this.radius*Math.cos(startAngle)),startY=params.cy+(this.radius*Math.sin(startAngle));return{x:startX,y:startY}}},Bezier:function(params){this.curve=[{x:params.x1,y:params.y1},{x:params.cp1x,y:params.cp1y},{x:params.cp2x,y:params.cp2y},{x:params.x2,y:params.y2}];var _isPoint=function(c){return c[0].x===c[1].x&&c[0].y===c[1].y};var _dist=function(p1,p2){return Math.sqrt(Math.pow(p1.x-p2.x,2)+Math.pow(p1.y-p2.y,2))};var _compute=function(loc){var EMPTY_POINT={x:0,y:0};if(loc===0){return this.curve[0]}
var degree=this.curve.length-1;if(loc===1){return this.curve[degree]}
var o=this.curve;var s=1-loc;if(degree===0){return this.curve[0]}
if(degree===1){return{x:s*o[0].x+loc*o[1].x,y:s*o[0].y+loc*o[1].y}}
if(degree<4){var l=s*s,h=loc*loc,u=0,m,g,f;if(degree===2){o=[o[0],o[1],o[2],EMPTY_POINT];m=l;g=2*(s*loc);f=h}else if(degree===3){m=l*s;g=3*(l*loc);f=3*(s*h);u=loc*h}
return{x:m*o[0].x+g*o[1].x+f*o[2].x+u*o[3].x,y:m*o[0].y+g*o[1].y+f*o[2].y+u*o[3].y}}else{return EMPTY_POINT}}.bind(this);var _getLUT=function(steps){var out=[];steps--;for(var n=0;n<=steps;n++){out.push(_compute(n/steps))}
return out};var _computeLength=function(){if(_isPoint(this.curve)){this.length=0}
var steps=16;var lut=_getLUT(steps);this.length=0;for(var i=0;i<steps-1;i++){var a=lut[i],b=lut[i+1];this.length+=_dist(a,b)}}.bind(this);var _super=_jp.Segments.AbstractSegment.apply(this,arguments);this.bounds={minX:Math.min(params.x1,params.x2,params.cp1x,params.cp2x),minY:Math.min(params.y1,params.y2,params.cp1y,params.cp2y),maxX:Math.max(params.x1,params.x2,params.cp1x,params.cp2x),maxY:Math.max(params.y1,params.y2,params.cp1y,params.cp2y)};this.type="Bezier";_computeLength();var _translateLocation=function(_curve,location,absolute){if(absolute){location=root.jsBezier.locationAlongCurveFrom(_curve,location>0?0:1,location)}
return location};this.pointOnPath=function(location,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.pointOnCurve(this.curve,location)};this.gradientAtPoint=function(location,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.gradientAtPoint(this.curve,location)};this.pointAlongPathFrom=function(location,distance,absolute){location=_translateLocation(this.curve,location,absolute);return root.jsBezier.pointAlongCurveFrom(this.curve,location,distance)};this.getLength=function(){return this.length};this.getBounds=function(){return this.bounds};this.findClosestPointOnPath=function(x,y){var p=root.jsBezier.nearestPointOnCurve({x:x,y:y},this.curve);return{d:Math.sqrt(Math.pow(p.point.x-x,2)+Math.pow(p.point.y-y,2)),x:p.point.x,y:p.point.y,l:1-p.location,s:this}};this.lineIntersection=function(x1,y1,x2,y2){return root.jsBezier.lineIntersection(x1,y1,x2,y2,this.curve)}}};_jp.SegmentRenderer={getPath:function(segment,isFirstSegment){return({"Straight":function(isFirstSegment){var d=segment.getCoordinates();return(isFirstSegment?"M "+d.x1+" "+d.y1+" ":"")+"L "+d.x2+" "+d.y2},"Bezier":function(isFirstSegment){var d=segment.params;return(isFirstSegment?"M "+d.x2+" "+d.y2+" ":"")+"C "+d.cp2x+" "+d.cp2y+" "+d.cp1x+" "+d.cp1y+" "+d.x1+" "+d.y1},"Arc":function(isFirstSegment){var d=segment.params,laf=segment.sweep>Math.PI?1:0,sf=segment.anticlockwise?0:1;return(isFirstSegment?"M"+segment.x1+" "+segment.y1+" ":"")+"A "+segment.radius+" "+d.r+" 0 "+laf+","+sf+" "+segment.x2+" "+segment.y2}})[segment.type](isFirstSegment)}};var AbstractComponent=function(){this.resetBounds=function(){this.bounds={minX:Infinity,minY:Infinity,maxX:-Infinity,maxY:-Infinity}};this.resetBounds()};_jp.Connectors.AbstractConnector=function(params){AbstractComponent.apply(this,arguments);var segments=[],totalLength=0,segmentProportions=[],segmentProportionalLengths=[],stub=params.stub||0,sourceStub=_ju.isArray(stub)?stub[0]:stub,targetStub=_ju.isArray(stub)?stub[1]:stub,gap=params.gap||0,sourceGap=_ju.isArray(gap)?gap[0]:gap,targetGap=_ju.isArray(gap)?gap[1]:gap,userProvidedSegments=null,paintInfo=null;this.getPathData=function(){var p="";for(var i=0;i<segments.length;i++){p+=_jp.SegmentRenderer.getPath(segments[i],i===0);p+=" "}
return p};this.findSegmentForPoint=function(x,y){var out={d:Infinity,s:null,x:null,y:null,l:null};for(var i=0;i<segments.length;i++){var _s=segments[i].findClosestPointOnPath(x,y);if(_s.d<out.d){out.d=_s.d;out.l=_s.l;out.x=_s.x;out.y=_s.y;out.s=segments[i];out.x1=_s.x1;out.x2=_s.x2;out.y1=_s.y1;out.y2=_s.y2;out.index=i;out.connectorLocation=segmentProportions[i][0]+(_s.l*(segmentProportions[i][1]-segmentProportions[i][0]))}}
return out};this.lineIntersection=function(x1,y1,x2,y2){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].lineIntersection(x1,y1,x2,y2))}
return out};this.boxIntersection=function(x,y,w,h){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].boxIntersection(x,y,w,h))}
return out};this.boundingBoxIntersection=function(box){var out=[];for(var i=0;i<segments.length;i++){out.push.apply(out,segments[i].boundingBoxIntersection(box))}
return out};var _updateSegmentProportions=function(){var curLoc=0;for(var i=0;i<segments.length;i++){var sl=segments[i].getLength();segmentProportionalLengths[i]=sl/totalLength;segmentProportions[i]=[curLoc,(curLoc+=(sl/totalLength))]}},_findSegmentForLocation=function(location,absolute){var idx,i,inSegmentProportion;if(absolute){location=location>0?location/totalLength:(totalLength+location)/totalLength}
if(location===1){idx=segments.length-1;inSegmentProportion=1}else if(location===0){inSegmentProportion=0;idx=0}else{if(location>=0.5){idx=0;inSegmentProportion=0;for(i=segmentProportions.length-1;i>-1;i--){if(segmentProportions[i][1]>=location&&segmentProportions[i][0]<=location){idx=i;inSegmentProportion=(location-segmentProportions[i][0])/segmentProportionalLengths[i];break}}}else{idx=segmentProportions.length-1;inSegmentProportion=1;for(i=0;i<segmentProportions.length;i++){if(segmentProportions[i][1]>=location){idx=i;inSegmentProportion=(location-segmentProportions[i][0])/segmentProportionalLengths[i];break}}}}
return{segment:segments[idx],proportion:inSegmentProportion,index:idx}},_addSegment=function(conn,type,params){if(params.x1===params.x2&&params.y1===params.y2){return}
var s=new _jp.Segments[type](params);segments.push(s);totalLength+=s.getLength();conn.updateBounds(s)},_clearSegments=function(){totalLength=segments.length=segmentProportions.length=segmentProportionalLengths.length=0};this.setSegments=function(_segs){userProvidedSegments=[];totalLength=0;for(var i=0;i<_segs.length;i++){userProvidedSegments.push(_segs[i]);totalLength+=_segs[i].getLength()}};this.getLength=function(){return totalLength};var _prepareCompute=function(params){this.strokeWidth=params.strokeWidth;var segment=_jg.quadrant(params.sourcePos,params.targetPos),swapX=params.targetPos[0]<params.sourcePos[0],swapY=params.targetPos[1]<params.sourcePos[1],lw=params.strokeWidth||1,so=params.sourceEndpoint.anchor.getOrientation(params.sourceEndpoint),to=params.targetEndpoint.anchor.getOrientation(params.targetEndpoint),x=swapX?params.targetPos[0]:params.sourcePos[0],y=swapY?params.targetPos[1]:params.sourcePos[1],w=Math.abs(params.targetPos[0]-params.sourcePos[0]),h=Math.abs(params.targetPos[1]-params.sourcePos[1]);if(so[0]===0&&so[1]===0||to[0]===0&&to[1]===0){var index=w>h?0:1,oIndex=[1,0][index];so=[];to=[];so[index]=params.sourcePos[index]>params.targetPos[index]?-1:1;to[index]=params.sourcePos[index]>params.targetPos[index]?1:-1;so[oIndex]=0;to[oIndex]=0}
var sx=swapX?w+(sourceGap*so[0]):sourceGap*so[0],sy=swapY?h+(sourceGap*so[1]):sourceGap*so[1],tx=swapX?targetGap*to[0]:w+(targetGap*to[0]),ty=swapY?targetGap*to[1]:h+(targetGap*to[1]),oProduct=((so[0]*to[0])+(so[1]*to[1]));var result={sx:sx,sy:sy,tx:tx,ty:ty,lw:lw,xSpan:Math.abs(tx-sx),ySpan:Math.abs(ty-sy),mx:(sx+tx)/2,my:(sy+ty)/2,so:so,to:to,x:x,y:y,w:w,h:h,segment:segment,startStubX:sx+(so[0]*sourceStub),startStubY:sy+(so[1]*sourceStub),endStubX:tx+(to[0]*targetStub),endStubY:ty+(to[1]*targetStub),isXGreaterThanStubTimes2:Math.abs(sx-tx)>(sourceStub+targetStub),isYGreaterThanStubTimes2:Math.abs(sy-ty)>(sourceStub+targetStub),opposite:oProduct===-1,perpendicular:oProduct===0,orthogonal:oProduct===1,sourceAxis:so[0]===0?"y":"x",points:[x,y,w,h,sx,sy,tx,ty],stubs:[sourceStub,targetStub]};result.anchorOrientation=result.opposite?"opposite":result.orthogonal?"orthogonal":"perpendicular";return result};this.getSegments=function(){return segments};this.updateBounds=function(segment){var segBounds=segment.getBounds();this.bounds.minX=Math.min(this.bounds.minX,segBounds.minX);this.bounds.maxX=Math.max(this.bounds.maxX,segBounds.maxX);this.bounds.minY=Math.min(this.bounds.minY,segBounds.minY);this.bounds.maxY=Math.max(this.bounds.maxY,segBounds.maxY)};var dumpSegmentsToConsole=function(){console.log("SEGMENTS:");for(var i=0;i<segments.length;i++){console.log(segments[i].type,segments[i].getLength(),segmentProportions[i])}};this.pointOnPath=function(location,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.pointOnPath(seg.proportion,!1)||[0,0]};this.gradientAtPoint=function(location,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.gradientAtPoint(seg.proportion,!1)||0};this.pointAlongPathFrom=function(location,distance,absolute){var seg=_findSegmentForLocation(location,absolute);return seg.segment&&seg.segment.pointAlongPathFrom(seg.proportion,distance,!1)||[0,0]};this.compute=function(params){paintInfo=_prepareCompute.call(this,params);_clearSegments();this._compute(paintInfo,params);this.x=paintInfo.points[0];this.y=paintInfo.points[1];this.w=paintInfo.points[2];this.h=paintInfo.points[3];this.segment=paintInfo.segment;_updateSegmentProportions()};return{addSegment:_addSegment,prepareCompute:_prepareCompute,sourceStub:sourceStub,targetStub:targetStub,maxStub:Math.max(sourceStub,targetStub),sourceGap:sourceGap,targetGap:targetGap,maxGap:Math.max(sourceGap,targetGap)}};_ju.extend(_jp.Connectors.AbstractConnector,AbstractComponent);_jp.Endpoints.AbstractEndpoint=function(params){AbstractComponent.apply(this,arguments);var compute=this.compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var out=this._compute.apply(this,arguments);this.x=out[0];this.y=out[1];this.w=out[2];this.h=out[3];this.bounds.minX=this.x;this.bounds.minY=this.y;this.bounds.maxX=this.x+this.w;this.bounds.maxY=this.y+this.h;return out};return{compute:compute,cssClass:params.cssClass}};_ju.extend(_jp.Endpoints.AbstractEndpoint,AbstractComponent);_jp.Endpoints.Dot=function(params){this.type="Dot";var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);params=params||{};this.radius=params.radius||10;this.defaultOffset=0.5*this.radius;this.defaultInnerRadius=this.radius/3;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){this.radius=endpointStyle.radius||this.radius;var x=anchorPoint[0]-this.radius,y=anchorPoint[1]-this.radius,w=this.radius*2,h=this.radius*2;if(endpointStyle.stroke){var lw=endpointStyle.strokeWidth||1;x-=lw;y-=lw;w+=(lw*2);h+=(lw*2)}
return[x,y,w,h,this.radius]}};_ju.extend(_jp.Endpoints.Dot,_jp.Endpoints.AbstractEndpoint);_jp.Endpoints.Rectangle=function(params){this.type="Rectangle";var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);params=params||{};this.width=params.width||20;this.height=params.height||20;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var width=endpointStyle.width||this.width,height=endpointStyle.height||this.height,x=anchorPoint[0]-(width/2),y=anchorPoint[1]-(height/2);return[x,y,width,height]}};_ju.extend(_jp.Endpoints.Rectangle,_jp.Endpoints.AbstractEndpoint);var DOMElementEndpoint=function(params){_jp.jsPlumbUIComponent.apply(this,arguments);this._jsPlumb.displayElements=[]};_ju.extend(DOMElementEndpoint,_jp.jsPlumbUIComponent,{getDisplayElements:function(){return this._jsPlumb.displayElements},appendDisplayElement:function(el){this._jsPlumb.displayElements.push(el)}});_jp.Endpoints.Image=function(params){this.type="Image";DOMElementEndpoint.apply(this,arguments);_jp.Endpoints.AbstractEndpoint.apply(this,arguments);var _onload=params.onload,src=params.src||params.url,clazz=params.cssClass?" "+params.cssClass:"";this._jsPlumb.img=new Image();this._jsPlumb.ready=!1;this._jsPlumb.initialized=!1;this._jsPlumb.deleted=!1;this._jsPlumb.widthToUse=params.width;this._jsPlumb.heightToUse=params.height;this._jsPlumb.endpoint=params.endpoint;this._jsPlumb.img.onload=function(){if(this._jsPlumb!=null){this._jsPlumb.ready=!0;this._jsPlumb.widthToUse=this._jsPlumb.widthToUse||this._jsPlumb.img.width;this._jsPlumb.heightToUse=this._jsPlumb.heightToUse||this._jsPlumb.img.height;if(_onload){_onload(this)}}}.bind(this);this._jsPlumb.endpoint.setImage=function(_img,onload){var s=_img.constructor===String?_img:_img.src;_onload=onload;this._jsPlumb.img.src=s;if(this.canvas!=null){this.canvas.setAttribute("src",this._jsPlumb.img.src)}}.bind(this);this._jsPlumb.endpoint.setImage(src,_onload);this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){this.anchorPoint=anchorPoint;if(this._jsPlumb.ready){return[anchorPoint[0]-this._jsPlumb.widthToUse/2,anchorPoint[1]-this._jsPlumb.heightToUse/2,this._jsPlumb.widthToUse,this._jsPlumb.heightToUse]}else{return[0,0,0,0]}};this.canvas=_jp.createElement("img",{position:"absolute",margin:0,padding:0,outline:0},this._jsPlumb.instance.endpointClass+clazz);if(this._jsPlumb.widthToUse){this.canvas.setAttribute("width",this._jsPlumb.widthToUse)}
if(this._jsPlumb.heightToUse){this.canvas.setAttribute("height",this._jsPlumb.heightToUse)}
this._jsPlumb.instance.appendElement(this.canvas);this.actuallyPaint=function(d,style,anchor){if(!this._jsPlumb.deleted){if(!this._jsPlumb.initialized){this.canvas.setAttribute("src",this._jsPlumb.img.src);this.appendDisplayElement(this.canvas);this._jsPlumb.initialized=!0}
var x=this.anchorPoint[0]-(this._jsPlumb.widthToUse/2),y=this.anchorPoint[1]-(this._jsPlumb.heightToUse/2);_ju.sizeElement(this.canvas,x,y,this._jsPlumb.widthToUse,this._jsPlumb.heightToUse)}};this.paint=function(style,anchor){if(this._jsPlumb!=null){if(this._jsPlumb.ready){this.actuallyPaint(style,anchor)}else{root.setTimeout(function(){this.paint(style,anchor)}.bind(this),200)}}}};_ju.extend(_jp.Endpoints.Image,[DOMElementEndpoint,_jp.Endpoints.AbstractEndpoint],{cleanup:function(force){if(force){this._jsPlumb.deleted=!0;if(this.canvas){this.canvas.parentNode.removeChild(this.canvas)}
this.canvas=null}}});_jp.Endpoints.Blank=function(params){var _super=_jp.Endpoints.AbstractEndpoint.apply(this,arguments);this.type="Blank";DOMElementEndpoint.apply(this,arguments);this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){return[anchorPoint[0],anchorPoint[1],10,0]};var clazz=params.cssClass?" "+params.cssClass:"";this.canvas=_jp.createElement("div",{display:"block",width:"1px",height:"1px",background:"transparent",position:"absolute"},this._jsPlumb.instance.endpointClass+clazz);this._jsPlumb.instance.appendElement(this.canvas);this.paint=function(style,anchor){_ju.sizeElement(this.canvas,this.x,this.y,this.w,this.h)}};_ju.extend(_jp.Endpoints.Blank,[_jp.Endpoints.AbstractEndpoint,DOMElementEndpoint],{cleanup:function(){if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}}});_jp.Endpoints.Triangle=function(params){this.type="Triangle";_jp.Endpoints.AbstractEndpoint.apply(this,arguments);var self=this;params=params||{};params.width=params.width||55;params.height=params.height||55;this.width=params.width;this.height=params.height;this._compute=function(anchorPoint,orientation,endpointStyle,connectorPaintStyle){var width=endpointStyle.width||self.width,height=endpointStyle.height||self.height,x=anchorPoint[0]-(width/2),y=anchorPoint[1]-(height/2);return[x,y,width,height]}};var AbstractOverlay=_jp.Overlays.AbstractOverlay=function(params){this.visible=!0;this.isAppendedAtTopLevel=!0;this.component=params.component;this.loc=params.location==null?0.5:params.location;this.endpointLoc=params.endpointLocation==null?[0.5,0.5]:params.endpointLocation;this.visible=params.visible!==!1};AbstractOverlay.prototype={cleanup:function(force){if(force){this.component=null;this.canvas=null;this.endpointLoc=null}},reattach:function(instance,component){},setVisible:function(val){this.visible=val;this.component.repaint()},isVisible:function(){return this.visible},hide:function(){this.setVisible(!1)},show:function(){this.setVisible(!0)},incrementLocation:function(amount){this.loc+=amount;this.component.repaint()},setLocation:function(l){this.loc=l;this.component.repaint()},getLocation:function(){return this.loc},updateFrom:function(){}};_jp.Overlays.Arrow=function(params){this.type="Arrow";AbstractOverlay.apply(this,arguments);this.isAppendedAtTopLevel=!1;params=params||{};var self=this;this.length=params.length||20;this.width=params.width||20;this.id=params.id;this.direction=(params.direction||1)<0?-1:1;var paintStyle=params.paintStyle||{"stroke-width":1},foldback=params.foldback||0.623;this.computeMaxSize=function(){return self.width*1.5};this.elementCreated=function(p,component){this.path=p;if(params.events){for(var i in params.events){_jp.on(p,i,params.events[i])}}};this.draw=function(component,currentConnectionPaintStyle){var hxy,mid,txy,tail,cxy;if(component.pointAlongPathFrom){if(_ju.isString(this.loc)||this.loc>1||this.loc<0){var l=parseInt(this.loc,10),fromLoc=this.loc<0?1:0;hxy=component.pointAlongPathFrom(fromLoc,l,!1);mid=component.pointAlongPathFrom(fromLoc,l-(this.direction*this.length/2),!1);txy=_jg.pointOnLine(hxy,mid,this.length)}else if(this.loc===1){hxy=component.pointOnPath(this.loc);mid=component.pointAlongPathFrom(this.loc,-(this.length));txy=_jg.pointOnLine(hxy,mid,this.length);if(this.direction===-1){var _=txy;txy=hxy;hxy=_}}else if(this.loc===0){txy=component.pointOnPath(this.loc);mid=component.pointAlongPathFrom(this.loc,this.length);hxy=_jg.pointOnLine(txy,mid,this.length);if(this.direction===-1){var __=txy;txy=hxy;hxy=__}}else{hxy=component.pointAlongPathFrom(this.loc,this.direction*this.length/2);mid=component.pointOnPath(this.loc);txy=_jg.pointOnLine(hxy,mid,this.length)}
tail=_jg.perpendicularLineTo(hxy,txy,this.width);cxy=_jg.pointOnLine(hxy,txy,foldback*this.length);var d={hxy:hxy,tail:tail,cxy:cxy},stroke=paintStyle.stroke||currentConnectionPaintStyle.stroke,fill=paintStyle.fill||currentConnectionPaintStyle.stroke,lineWidth=paintStyle.strokeWidth||currentConnectionPaintStyle.strokeWidth;return{component:component,d:d,"stroke-width":lineWidth,stroke:stroke,fill:fill,minX:Math.min(hxy.x,tail[0].x,tail[1].x),maxX:Math.max(hxy.x,tail[0].x,tail[1].x),minY:Math.min(hxy.y,tail[0].y,tail[1].y),maxY:Math.max(hxy.y,tail[0].y,tail[1].y)}}else{return{component:component,minX:0,maxX:0,minY:0,maxY:0}}}};_ju.extend(_jp.Overlays.Arrow,AbstractOverlay,{updateFrom:function(d){this.length=d.length||this.length;this.width=d.width||this.width;this.direction=d.direction!=null?d.direction:this.direction;this.foldback=d.foldback||this.foldback},cleanup:function(){if(this.path&&this.path.parentNode){this.path.parentNode.removeChild(this.path)}}});_jp.Overlays.PlainArrow=function(params){params=params||{};var p=_jp.extend(params,{foldback:1});_jp.Overlays.Arrow.call(this,p);this.type="PlainArrow"};_ju.extend(_jp.Overlays.PlainArrow,_jp.Overlays.Arrow);_jp.Overlays.Diamond=function(params){params=params||{};var l=params.length||40,p=_jp.extend(params,{length:l/2,foldback:2});_jp.Overlays.Arrow.call(this,p);this.type="Diamond"};_ju.extend(_jp.Overlays.Diamond,_jp.Overlays.Arrow);var _getDimensions=function(component,forceRefresh){if(component._jsPlumb.cachedDimensions==null||forceRefresh){component._jsPlumb.cachedDimensions=component.getDimensions()}
return component._jsPlumb.cachedDimensions};var AbstractDOMOverlay=function(params){_jp.jsPlumbUIComponent.apply(this,arguments);AbstractOverlay.apply(this,arguments);var _f=this.fire;this.fire=function(){_f.apply(this,arguments);if(this.component){this.component.fire.apply(this.component,arguments)}};this.detached=!1;this.id=params.id;this._jsPlumb.div=null;this._jsPlumb.initialised=!1;this._jsPlumb.component=params.component;this._jsPlumb.cachedDimensions=null;this._jsPlumb.create=params.create;this._jsPlumb.initiallyInvisible=params.visible===!1;this.getElement=function(){if(this._jsPlumb.div==null){var div=this._jsPlumb.div=_jp.getElement(this._jsPlumb.create(this._jsPlumb.component));div.style.position="absolute";jsPlumb.addClass(div,this._jsPlumb.instance.overlayClass+" "+(this.cssClass?this.cssClass:params.cssClass?params.cssClass:""));this._jsPlumb.instance.appendElement(div);this._jsPlumb.instance.getId(div);this.canvas=div;var ts="translate(-50%, -50%)";div.style.webkitTransform=ts;div.style.mozTransform=ts;div.style.msTransform=ts;div.style.oTransform=ts;div.style.transform=ts;div._jsPlumb=this;if(params.visible===!1){div.style.display="none"}}
return this._jsPlumb.div};this.draw=function(component,currentConnectionPaintStyle,absolutePosition){var td=_getDimensions(this);if(td!=null&&td.length===2){var cxy={x:0,y:0};if(absolutePosition){cxy={x:absolutePosition[0],y:absolutePosition[1]}}else if(component.pointOnPath){var loc=this.loc,absolute=!1;if(_ju.isString(this.loc)||this.loc<0||this.loc>1){loc=parseInt(this.loc,10);absolute=!0}
cxy=component.pointOnPath(loc,absolute)}else{var locToUse=this.loc.constructor===Array?this.loc:this.endpointLoc;cxy={x:locToUse[0]*component.w,y:locToUse[1]*component.h}}
var minx=cxy.x-(td[0]/2),miny=cxy.y-(td[1]/2);return{component:component,d:{minx:minx,miny:miny,td:td,cxy:cxy},minX:minx,maxX:minx+td[0],minY:miny,maxY:miny+td[1]}}else{return{minX:0,maxX:0,minY:0,maxY:0}}}};_ju.extend(AbstractDOMOverlay,[_jp.jsPlumbUIComponent,AbstractOverlay],{getDimensions:function(){return[1,1]},setVisible:function(state){if(this._jsPlumb.div){this._jsPlumb.div.style.display=state?"block":"none";if(state&&this._jsPlumb.initiallyInvisible){_getDimensions(this,!0);this.component.repaint();this._jsPlumb.initiallyInvisible=!1}}},clearCachedDimensions:function(){this._jsPlumb.cachedDimensions=null},cleanup:function(force){if(force){if(this._jsPlumb.div!=null){this._jsPlumb.div._jsPlumb=null;this._jsPlumb.instance.removeElement(this._jsPlumb.div)}}else{if(this._jsPlumb&&this._jsPlumb.div&&this._jsPlumb.div.parentNode){this._jsPlumb.div.parentNode.removeChild(this._jsPlumb.div)}
this.detached=!0}},reattach:function(instance,component){if(this._jsPlumb.div!=null){instance.getContainer().appendChild(this._jsPlumb.div)}
this.detached=!1},computeMaxSize:function(){var td=_getDimensions(this);return Math.max(td[0],td[1])},paint:function(p,containerExtents){if(!this._jsPlumb.initialised){this.getElement();p.component.appendDisplayElement(this._jsPlumb.div);this._jsPlumb.initialised=!0;if(this.detached){this._jsPlumb.div.parentNode.removeChild(this._jsPlumb.div)}}
this._jsPlumb.div.style.left=(p.component.x+p.d.minx)+"px";this._jsPlumb.div.style.top=(p.component.y+p.d.miny)+"px"}});_jp.Overlays.Custom=function(params){this.type="Custom";AbstractDOMOverlay.apply(this,arguments)};_ju.extend(_jp.Overlays.Custom,AbstractDOMOverlay);_jp.Overlays.GuideLines=function(){var self=this;self.length=50;self.strokeWidth=5;this.type="GuideLines";AbstractOverlay.apply(this,arguments);_jp.jsPlumbUIComponent.apply(this,arguments);this.draw=function(connector,currentConnectionPaintStyle){var head=connector.pointAlongPathFrom(self.loc,self.length/2),mid=connector.pointOnPath(self.loc),tail=_jg.pointOnLine(head,mid,self.length),tailLine=_jg.perpendicularLineTo(head,tail,40),headLine=_jg.perpendicularLineTo(tail,head,20);return{connector:connector,head:head,tail:tail,headLine:headLine,tailLine:tailLine,minX:Math.min(head.x,tail.x,headLine[0].x,headLine[1].x),minY:Math.min(head.y,tail.y,headLine[0].y,headLine[1].y),maxX:Math.max(head.x,tail.x,headLine[0].x,headLine[1].x),maxY:Math.max(head.y,tail.y,headLine[0].y,headLine[1].y)}}};_jp.Overlays.Label=function(params){this.labelStyle=params.labelStyle;var labelWidth=null,labelHeight=null,labelText=null,labelPadding=null;this.cssClass=this.labelStyle!=null?this.labelStyle.cssClass:null;var p=_jp.extend({create:function(){return _jp.createElement("div")}},params);_jp.Overlays.Custom.call(this,p);this.type="Label";this.label=params.label||"";this.labelText=null;if(this.labelStyle){var el=this.getElement();this.labelStyle.font=this.labelStyle.font||"12px sans-serif";el.style.font=this.labelStyle.font;el.style.color=this.labelStyle.color||"black";if(this.labelStyle.fill){el.style.background=this.labelStyle.fill}
if(this.labelStyle.borderWidth>0){var dStyle=this.labelStyle.borderStyle?this.labelStyle.borderStyle:"black";el.style.border=this.labelStyle.borderWidth+"px solid "+dStyle}
if(this.labelStyle.padding){el.style.padding=this.labelStyle.padding}}};_ju.extend(_jp.Overlays.Label,_jp.Overlays.Custom,{cleanup:function(force){if(force){this.div=null;this.label=null;this.labelText=null;this.cssClass=null;this.labelStyle=null}},getLabel:function(){return this.label},setLabel:function(l){this.label=l;this.labelText=null;this.clearCachedDimensions();this.update();this.component.repaint()},getDimensions:function(){this.update();return AbstractDOMOverlay.prototype.getDimensions.apply(this,arguments)},update:function(){if(typeof this.label==="function"){var lt=this.label(this);this.getElement().innerHTML=lt.replace(/\r\n/g,"<br/>")}else{if(this.labelText==null){this.labelText=this.label;this.getElement().innerHTML=this.labelText.replace(/\r\n/g,"<br/>")}}},updateFrom:function(d){if(d.label!=null){this.setLabel(d.label)}}})}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_ju=root.jsPlumbUtil,_jpi=root.jsPlumbInstance;var GROUP_COLLAPSED_CLASS="jtk-group-collapsed";var GROUP_EXPANDED_CLASS="jtk-group-expanded";var GROUP_CONTAINER_SELECTOR="[jtk-group-content]";var ELEMENT_DRAGGABLE_EVENT="elementDraggable";var STOP="stop";var REVERT="revert";var GROUP_MANAGER="_groupManager";var GROUP="_jsPlumbGroup";var GROUP_DRAG_SCOPE="_jsPlumbGroupDrag";var EVT_CHILD_ADDED="group:addMember";var EVT_CHILD_REMOVED="group:removeMember";var EVT_GROUP_ADDED="group:add";var EVT_GROUP_REMOVED="group:remove";var EVT_EXPAND="group:expand";var EVT_COLLAPSE="group:collapse";var EVT_GROUP_DRAG_STOP="groupDragStop";var EVT_CONNECTION_MOVED="connectionMoved";var EVT_INTERNAL_CONNECTION_DETACHED="internal.connectionDetached";var CMD_REMOVE_ALL="removeAll";var CMD_ORPHAN_ALL="orphanAll";var CMD_SHOW="show";var CMD_HIDE="hide";var GroupManager=function(_jsPlumb){var _managedGroups={},_connectionSourceMap={},_connectionTargetMap={},self=this;function isDescendant(el,parentEl){var c=_jsPlumb.getContainer();var abort=!1,g=null,child=null;while(!abort){if(el==null||el===c){return!1}else{if(el===parentEl){return!0}else{el=el.parentNode}}}}
_jsPlumb.bind("connection",function(p){var sourceGroup=_jsPlumb.getGroupFor(p.source);var targetGroup=_jsPlumb.getGroupFor(p.target);if(sourceGroup!=null&&targetGroup!=null&&sourceGroup===targetGroup){_connectionSourceMap[p.connection.id]=sourceGroup;_connectionTargetMap[p.connection.id]=sourceGroup}else{if(sourceGroup!=null){_ju.suggest(sourceGroup.connections.source,p.connection);_connectionSourceMap[p.connection.id]=sourceGroup}
if(targetGroup!=null){_ju.suggest(targetGroup.connections.target,p.connection);_connectionTargetMap[p.connection.id]=targetGroup}}});function _cleanupDetachedConnection(conn){delete conn.proxies;var group=_connectionSourceMap[conn.id],f;if(group!=null){f=function(c){return c.id===conn.id};_ju.removeWithFunction(group.connections.source,f);_ju.removeWithFunction(group.connections.target,f);delete _connectionSourceMap[conn.id]}
group=_connectionTargetMap[conn.id];if(group!=null){f=function(c){return c.id===conn.id};_ju.removeWithFunction(group.connections.source,f);_ju.removeWithFunction(group.connections.target,f);delete _connectionTargetMap[conn.id]}}
_jsPlumb.bind(EVT_INTERNAL_CONNECTION_DETACHED,function(p){_cleanupDetachedConnection(p.connection)});_jsPlumb.bind(EVT_CONNECTION_MOVED,function(p){var connMap=p.index===0?_connectionSourceMap:_connectionTargetMap;var group=connMap[p.connection.id];if(group){var list=group.connections[p.index===0?"source":"target"];var idx=list.indexOf(p.connection);if(idx!==-1){list.splice(idx,1)}}});this.addGroup=function(group){_jsPlumb.addClass(group.getEl(),GROUP_EXPANDED_CLASS);_managedGroups[group.id]=group;group.manager=this;_updateConnectionsForGroup(group);_jsPlumb.fire(EVT_GROUP_ADDED,{group:group})};this.addToGroup=function(group,el,doNotFireEvent){group=this.getGroup(group);if(group){var groupEl=group.getEl();if(el._isJsPlumbGroup){return}
var currentGroup=el._jsPlumbGroup;if(currentGroup!==group){_jsPlumb.removeFromDragSelection(el);var elpos=_jsPlumb.getOffset(el,!0);var cpos=group.collapsed?_jsPlumb.getOffset(groupEl,!0):_jsPlumb.getOffset(group.getDragArea(),!0);if(currentGroup!=null){currentGroup.remove(el,!1,doNotFireEvent,!1,group);self.updateConnectionsForGroup(currentGroup)}
group.add(el,doNotFireEvent);var handleDroppedConnections=function(list,index){var oidx=index===0?1:0;list.each(function(c){c.setVisible(!1);if(c.endpoints[oidx].element._jsPlumbGroup===group){c.endpoints[oidx].setVisible(!1);_expandConnection(c,oidx,group)}else{c.endpoints[index].setVisible(!1);_collapseConnection(c,index,group)}})};if(group.collapsed){handleDroppedConnections(_jsPlumb.select({source:el}),0);handleDroppedConnections(_jsPlumb.select({target:el}),1)}
var elId=_jsPlumb.getId(el);_jsPlumb.dragManager.setParent(el,elId,groupEl,_jsPlumb.getId(groupEl),elpos);var newPosition={left:elpos.left-cpos.left,top:elpos.top-cpos.top};_jsPlumb.setPosition(el,newPosition);_jsPlumb.dragManager.revalidateParent(el,elId,elpos);self.updateConnectionsForGroup(group);_jsPlumb.revalidate(elId);if(!doNotFireEvent){var p={group:group,el:el,pos:newPosition};if(currentGroup){p.sourceGroup=currentGroup}
_jsPlumb.fire(EVT_CHILD_ADDED,p)}}}};this.removeFromGroup=function(group,el,doNotFireEvent){group=this.getGroup(group);if(group){if(group.collapsed){var _expandSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];if(c.proxies){for(var j=0;j<c.proxies.length;j++){if(c.proxies[j]!=null){var proxiedElement=c.proxies[j].originalEp.element;if(proxiedElement===el||isDescendant(proxiedElement,el)){_expandConnection(c,index,group)}}}}}};_expandSet(group.connections.source.slice(),0);_expandSet(group.connections.target.slice(),1)}
group.remove(el,null,doNotFireEvent)}};this.getGroup=function(groupId){var group=groupId;if(_ju.isString(groupId)){group=_managedGroups[groupId];if(group==null){throw new TypeError("No such group ["+groupId+"]")}}
return group};this.getGroups=function(){var o=[];for(var g in _managedGroups){o.push(_managedGroups[g])}
return o};this.removeGroup=function(group,deleteMembers,manipulateDOM,doNotFireEvent){group=this.getGroup(group);this.expandGroup(group,!0);var newPositions=group[deleteMembers?CMD_REMOVE_ALL:CMD_ORPHAN_ALL](manipulateDOM,doNotFireEvent);_jsPlumb.remove(group.getEl());delete _managedGroups[group.id];delete _jsPlumb._groups[group.id];_jsPlumb.fire(EVT_GROUP_REMOVED,{group:group});return newPositions};this.removeAllGroups=function(deleteMembers,manipulateDOM,doNotFireEvent){for(var g in _managedGroups){this.removeGroup(_managedGroups[g],deleteMembers,manipulateDOM,doNotFireEvent)}};function _setVisible(group,state){var m=group.getEl().querySelectorAll(".jtk-managed");for(var i=0;i<m.length;i++){_jsPlumb[state?CMD_SHOW:CMD_HIDE](m[i],!0)}}
var _collapseConnection=function(c,index,group){var otherEl=c.endpoints[index===0?1:0].element;if(otherEl[GROUP]&&(!otherEl[GROUP].shouldProxy()&&otherEl[GROUP].collapsed)){return}
var groupEl=group.getEl(),groupElId=_jsPlumb.getId(groupEl);_jsPlumb.proxyConnection(c,index,groupEl,groupElId,function(c,index){return group.getEndpoint(c,index)},function(c,index){return group.getAnchor(c,index)})};this.collapseGroup=function(group){group=this.getGroup(group);if(group==null||group.collapsed){return}
var groupEl=group.getEl();_setVisible(group,!1);if(group.shouldProxy()){var _collapseSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];_collapseConnection(c,index,group)}};_collapseSet(group.connections.source,0);_collapseSet(group.connections.target,1)}
group.collapsed=!0;_jsPlumb.removeClass(groupEl,GROUP_EXPANDED_CLASS);_jsPlumb.addClass(groupEl,GROUP_COLLAPSED_CLASS);_jsPlumb.revalidate(groupEl);_jsPlumb.fire(EVT_COLLAPSE,{group:group})};var _expandConnection=function(c,index,group){_jsPlumb.unproxyConnection(c,index,_jsPlumb.getId(group.getEl()))};this.expandGroup=function(group,doNotFireEvent){group=this.getGroup(group);if(group==null||!group.collapsed){return}
var groupEl=group.getEl();_setVisible(group,!0);if(group.shouldProxy()){var _expandSet=function(conns,index){for(var i=0;i<conns.length;i++){var c=conns[i];_expandConnection(c,index,group)}};_expandSet(group.connections.source,0);_expandSet(group.connections.target,1)}
group.collapsed=!1;_jsPlumb.addClass(groupEl,GROUP_EXPANDED_CLASS);_jsPlumb.removeClass(groupEl,GROUP_COLLAPSED_CLASS);_jsPlumb.revalidate(groupEl);this.repaintGroup(group);if(!doNotFireEvent){_jsPlumb.fire(EVT_EXPAND,{group:group})}};this.repaintGroup=function(group){group=this.getGroup(group);var m=group.getMembers();for(var i=0;i<m.length;i++){_jsPlumb.revalidate(m[i])}};function _updateConnectionsForGroup(group){var members=group.getMembers().slice();var childMembers=[];for(var i=0;i<members.length;i++){Array.prototype.push.apply(childMembers,members[i].querySelectorAll(".jtk-managed"))}
Array.prototype.push.apply(members,childMembers);var c1=_jsPlumb.getConnections({source:members,scope:"*"},!0);var c2=_jsPlumb.getConnections({target:members,scope:"*"},!0);var processed={};group.connections.source.length=0;group.connections.target.length=0;var oneSet=function(c){for(var i=0;i<c.length;i++){if(processed[c[i].id]){continue}
processed[c[i].id]=!0;var gs=_jsPlumb.getGroupFor(c[i].source),gt=_jsPlumb.getGroupFor(c[i].target);if(gs===group){if(gt!==group){group.connections.source.push(c[i])}
_connectionSourceMap[c[i].id]=group}else if(gt===group){group.connections.target.push(c[i]);_connectionTargetMap[c[i].id]=group}}};oneSet(c1);oneSet(c2)}
this.updateConnectionsForGroup=_updateConnectionsForGroup;this.refreshAllGroups=function(){for(var g in _managedGroups){_updateConnectionsForGroup(_managedGroups[g]);_jsPlumb.dragManager.updateOffsets(_jsPlumb.getId(_managedGroups[g].getEl()))}}};var Group=function(_jsPlumb,params){var self=this;var el=params.el;this.getEl=function(){return el};this.id=params.id||_ju.uuid();el._isJsPlumbGroup=!0;var getDragArea=this.getDragArea=function(){var da=_jsPlumb.getSelector(el,GROUP_CONTAINER_SELECTOR);return da&&da.length>0?da[0]:el};var ghost=params.ghost===!0;var constrain=ghost||(params.constrain===!0);var revert=params.revert!==!1;var orphan=params.orphan===!0;var prune=params.prune===!0;var dropOverride=params.dropOverride===!0;var proxied=params.proxied!==!1;var elements=[];this.connections={source:[],target:[],internal:[]};this.getAnchor=function(conn,endpointIndex){return params.anchor||"Continuous"};this.getEndpoint=function(conn,endpointIndex){return params.endpoint||["Dot",{radius:10}]};this.collapsed=!1;if(params.draggable!==!1){var opts={drag:function(){for(var i=0;i<elements.length;i++){_jsPlumb.draw(elements[i])}},stop:function(params){_jsPlumb.fire(EVT_GROUP_DRAG_STOP,jsPlumb.extend(params,{group:self}))},scope:GROUP_DRAG_SCOPE};if(params.dragOptions){root.jsPlumb.extend(opts,params.dragOptions)}
_jsPlumb.draggable(params.el,opts)}
if(params.droppable!==!1){_jsPlumb.droppable(params.el,{drop:function(p){var el=p.drag.el;if(el._isJsPlumbGroup){return}
var currentGroup=el._jsPlumbGroup;if(currentGroup!==self){if(currentGroup!=null){if(currentGroup.overrideDrop(el,self)){return}}
_jsPlumb.getGroupManager().addToGroup(self,el,!1)}}})}
var _each=function(_el,fn){var els=_el.nodeType==null?_el:[_el];for(var i=0;i<els.length;i++){fn(els[i])}};this.overrideDrop=function(_el,targetGroup){return dropOverride&&(revert||prune||orphan)};this.add=function(_el,doNotFireEvent){var dragArea=getDragArea();_each(_el,function(__el){if(__el._jsPlumbGroup!=null){if(__el._jsPlumbGroup===self){return}else{__el._jsPlumbGroup.remove(__el,!0,doNotFireEvent,!1)}}
__el._jsPlumbGroup=self;elements.push(__el);if(_jsPlumb.isAlreadyDraggable(__el)){_bindDragHandlers(__el)}
if(__el.parentNode!==dragArea){dragArea.appendChild(__el)}});_jsPlumb.getGroupManager().updateConnectionsForGroup(self)};this.remove=function(el,manipulateDOM,doNotFireEvent,doNotUpdateConnections,targetGroup){_each(el,function(__el){if(__el._jsPlumbGroup===self){delete __el._jsPlumbGroup;_ju.removeWithFunction(elements,function(e){return e===__el});if(manipulateDOM){try{self.getDragArea().removeChild(__el)}catch(e){jsPlumbUtil.log("Could not remove element from Group "+e)}}
_unbindDragHandlers(__el);if(!doNotFireEvent){var p={group:self,el:__el};if(targetGroup){p.targetGroup=targetGroup}
_jsPlumb.fire(EVT_CHILD_REMOVED,p)}}});if(!doNotUpdateConnections){_jsPlumb.getGroupManager().updateConnectionsForGroup(self)}};this.removeAll=function(manipulateDOM,doNotFireEvent){for(var i=0,l=elements.length;i<l;i++){var el=elements[0];self.remove(el,manipulateDOM,doNotFireEvent,!0);_jsPlumb.remove(el,!0)}
elements.length=0;_jsPlumb.getGroupManager().updateConnectionsForGroup(self)};this.orphanAll=function(){var orphanedPositions={};for(var i=0;i<elements.length;i++){var newPosition=_orphan(elements[i]);orphanedPositions[newPosition[0]]=newPosition[1]}
elements.length=0;return orphanedPositions};this.getMembers=function(){return elements};el[GROUP]=this;_jsPlumb.bind(ELEMENT_DRAGGABLE_EVENT,function(dragParams){if(dragParams.el._jsPlumbGroup===this){_bindDragHandlers(dragParams.el)}}.bind(this));function _findParent(_el){return _el.offsetParent}
function _isInsideParent(_el,pos){var p=_findParent(_el),s=_jsPlumb.getSize(p),ss=_jsPlumb.getSize(_el),leftEdge=pos[0],rightEdge=leftEdge+ss[0],topEdge=pos[1],bottomEdge=topEdge+ss[1];return rightEdge>0&&leftEdge<s[0]&&bottomEdge>0&&topEdge<s[1]}
function _orphan(_el){var id=_jsPlumb.getId(_el);var pos=_jsPlumb.getOffset(_el);_el.parentNode.removeChild(_el);_jsPlumb.getContainer().appendChild(_el);_jsPlumb.setPosition(_el,pos);_unbindDragHandlers(_el);_jsPlumb.dragManager.clearParent(_el,id);return[id,pos]}
function _pruneOrOrphan(p){var out=[];function _one(el,left,top){var orphanedPosition=null;if(!_isInsideParent(el,[left,top])){var group=el._jsPlumbGroup;if(prune){_jsPlumb.remove(el)}else{orphanedPosition=_orphan(el)}
group.remove(el)}
return orphanedPosition}
for(var i=0;i<p.selection.length;i++){out.push(_one(p.selection[i][0],p.selection[i][1].left,p.selection[i][1].top))}
return out.length===1?out[0]:out}
function _revalidate(_el){var id=_jsPlumb.getId(_el);_jsPlumb.revalidate(_el);_jsPlumb.dragManager.revalidateParent(_el,id)}
function _unbindDragHandlers(_el){if(!_el._katavorioDrag){return}
if(prune||orphan){_el._katavorioDrag.off(STOP,_pruneOrOrphan)}
if(!prune&&!orphan&&revert){_el._katavorioDrag.off(REVERT,_revalidate);_el._katavorioDrag.setRevert(null)}}
function _bindDragHandlers(_el){if(!_el._katavorioDrag){return}
if(prune||orphan){_el._katavorioDrag.on(STOP,_pruneOrOrphan)}
if(constrain){_el._katavorioDrag.setConstrain(!0)}
if(ghost){_el._katavorioDrag.setUseGhostProxy(!0)}
if(!prune&&!orphan&&revert){_el._katavorioDrag.on(REVERT,_revalidate);_el._katavorioDrag.setRevert(function(__el,pos){return!_isInsideParent(__el,pos)})}}
this.shouldProxy=function(){return proxied};_jsPlumb.getGroupManager().addGroup(this)};_jpi.prototype.addGroup=function(params){var j=this;j._groups=j._groups||{};if(j._groups[params.id]!=null){throw new TypeError("cannot create Group ["+params.id+"]; a Group with that ID exists")}
if(params.el[GROUP]!=null){throw new TypeError("cannot create Group ["+params.id+"]; the given element is already a Group")}
var group=new Group(j,params);j._groups[group.id]=group;if(params.collapsed){this.collapseGroup(group)}
return group};_jpi.prototype.addToGroup=function(group,el,doNotFireEvent){var _one=function(_el){var id=this.getId(_el);this.manage(id,_el);this.getGroupManager().addToGroup(group,_el,doNotFireEvent)}.bind(this);if(Array.isArray(el)){for(var i=0;i<el.length;i++){_one(el[i])}}else{_one(el)}};_jpi.prototype.removeFromGroup=function(group,el,doNotFireEvent){this.getGroupManager().removeFromGroup(group,el,doNotFireEvent);this.getContainer().appendChild(el)};_jpi.prototype.removeGroup=function(group,deleteMembers,manipulateDOM,doNotFireEvent){return this.getGroupManager().removeGroup(group,deleteMembers,manipulateDOM,doNotFireEvent)};_jpi.prototype.removeAllGroups=function(deleteMembers,manipulateDOM,doNotFireEvent){this.getGroupManager().removeAllGroups(deleteMembers,manipulateDOM,doNotFireEvent)};_jpi.prototype.getGroup=function(groupId){return this.getGroupManager().getGroup(groupId)};_jpi.prototype.getGroups=function(){return this.getGroupManager().getGroups()};_jpi.prototype.expandGroup=function(group){this.getGroupManager().expandGroup(group)};_jpi.prototype.collapseGroup=function(groupId){this.getGroupManager().collapseGroup(groupId)};_jpi.prototype.repaintGroup=function(group){this.getGroupManager().repaintGroup(group)};_jpi.prototype.toggleGroup=function(group){group=this.getGroupManager().getGroup(group);if(group!=null){this.getGroupManager()[group.collapsed?"expandGroup":"collapseGroup"](group)}};_jpi.prototype.getGroupManager=function(){var mgr=this[GROUP_MANAGER];if(mgr==null){mgr=this[GROUP_MANAGER]=new GroupManager(this)}
return mgr};_jpi.prototype.removeGroupManager=function(){delete this[GROUP_MANAGER]};_jpi.prototype.getGroupFor=function(el){el=this.getElement(el);if(el){var c=this.getContainer();var abort=!1,g=null,child=null;while(!abort){if(el==null||el===c){abort=!0}else{if(el[GROUP]){g=el[GROUP];child=el;abort=!0}else{el=el.parentNode}}}
return g}}}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var STRAIGHT="Straight";var ARC="Arc";var Flowchart=function(params){this.type="Flowchart";params=params||{};params.stub=params.stub==null?30:params.stub;var segments,_super=_jp.Connectors.AbstractConnector.apply(this,arguments),midpoint=params.midpoint==null||isNaN(params.midpoint)?0.5:params.midpoint,alwaysRespectStubs=params.alwaysRespectStubs===!0,lastx=null,lasty=null,lastOrientation,cornerRadius=params.cornerRadius!=null?params.cornerRadius:0,loopbackRadius=params.loopbackRadius||25,isLoopbackCurrently=!1,sgn=function(n){return n<0?-1:n===0?0:1},segmentDirections=function(segment){return[sgn(segment[2]-segment[0]),sgn(segment[3]-segment[1])]},addSegment=function(segments,x,y,paintInfo){if(lastx===x&&lasty===y){return}
var lx=lastx==null?paintInfo.sx:lastx,ly=lasty==null?paintInfo.sy:lasty,o=lx===x?"v":"h";lastx=x;lasty=y;segments.push([lx,ly,x,y,o])},segLength=function(s){return Math.sqrt(Math.pow(s[0]-s[2],2)+Math.pow(s[1]-s[3],2))},_cloneArray=function(a){var _a=[];_a.push.apply(_a,a);return _a},writeSegments=function(conn,segments,paintInfo){var current=null,next,currentDirection,nextDirection;for(var i=0;i<segments.length-1;i++){current=current||_cloneArray(segments[i]);next=_cloneArray(segments[i+1]);currentDirection=segmentDirections(current);nextDirection=segmentDirections(next);if(cornerRadius>0&&current[4]!==next[4]){var minSegLength=Math.min(segLength(current),segLength(next));var radiusToUse=Math.min(cornerRadius,minSegLength/2);current[2]-=currentDirection[0]*radiusToUse;current[3]-=currentDirection[1]*radiusToUse;next[0]+=nextDirection[0]*radiusToUse;next[1]+=nextDirection[1]*radiusToUse;var ac=(currentDirection[1]===nextDirection[0]&&nextDirection[0]===1)||((currentDirection[1]===nextDirection[0]&&nextDirection[0]===0)&&currentDirection[0]!==nextDirection[1])||(currentDirection[1]===nextDirection[0]&&nextDirection[0]===-1),sgny=next[1]>current[3]?1:-1,sgnx=next[0]>current[2]?1:-1,sgnEqual=sgny===sgnx,cx=(sgnEqual&&ac||(!sgnEqual&&!ac))?next[0]:current[2],cy=(sgnEqual&&ac||(!sgnEqual&&!ac))?current[3]:next[1];_super.addSegment(conn,STRAIGHT,{x1:current[0],y1:current[1],x2:current[2],y2:current[3]});_super.addSegment(conn,ARC,{r:radiusToUse,x1:current[2],y1:current[3],x2:next[0],y2:next[1],cx:cx,cy:cy,ac:ac})}else{var dx=(current[2]===current[0])?0:(current[2]>current[0])?(paintInfo.lw/2):-(paintInfo.lw/2),dy=(current[3]===current[1])?0:(current[3]>current[1])?(paintInfo.lw/2):-(paintInfo.lw/2);_super.addSegment(conn,STRAIGHT,{x1:current[0]-dx,y1:current[1]-dy,x2:current[2]+dx,y2:current[3]+dy})}
current=next}
if(next!=null){_super.addSegment(conn,STRAIGHT,{x1:next[0],y1:next[1],x2:next[2],y2:next[3]})}};this.midpoint=midpoint;this._compute=function(paintInfo,params){segments=[];lastx=null;lasty=null;lastOrientation=null;var commonStubCalculator=function(){return[paintInfo.startStubX,paintInfo.startStubY,paintInfo.endStubX,paintInfo.endStubY]},stubCalculators={perpendicular:commonStubCalculator,orthogonal:commonStubCalculator,opposite:function(axis){var pi=paintInfo,idx=axis==="x"?0:1,areInProximity={"x":function(){return((pi.so[idx]===1&&(((pi.startStubX>pi.endStubX)&&(pi.tx>pi.startStubX))||((pi.sx>pi.endStubX)&&(pi.tx>pi.sx)))))||((pi.so[idx]===-1&&(((pi.startStubX<pi.endStubX)&&(pi.tx<pi.startStubX))||((pi.sx<pi.endStubX)&&(pi.tx<pi.sx)))))},"y":function(){return((pi.so[idx]===1&&(((pi.startStubY>pi.endStubY)&&(pi.ty>pi.startStubY))||((pi.sy>pi.endStubY)&&(pi.ty>pi.sy)))))||((pi.so[idx]===-1&&(((pi.startStubY<pi.endStubY)&&(pi.ty<pi.startStubY))||((pi.sy<pi.endStubY)&&(pi.ty<pi.sy)))))}};if(!alwaysRespectStubs&&areInProximity[axis]()){return{"x":[(paintInfo.sx+paintInfo.tx)/2,paintInfo.startStubY,(paintInfo.sx+paintInfo.tx)/2,paintInfo.endStubY],"y":[paintInfo.startStubX,(paintInfo.sy+paintInfo.ty)/2,paintInfo.endStubX,(paintInfo.sy+paintInfo.ty)/2]}[axis]}else{return[paintInfo.startStubX,paintInfo.startStubY,paintInfo.endStubX,paintInfo.endStubY]}}};var stubs=stubCalculators[paintInfo.anchorOrientation](paintInfo.sourceAxis),idx=paintInfo.sourceAxis==="x"?0:1,oidx=paintInfo.sourceAxis==="x"?1:0,ss=stubs[idx],oss=stubs[oidx],es=stubs[idx+2],oes=stubs[oidx+2];addSegment(segments,stubs[0],stubs[1],paintInfo);var midx=paintInfo.startStubX+((paintInfo.endStubX-paintInfo.startStubX)*midpoint),midy=paintInfo.startStubY+((paintInfo.endStubY-paintInfo.startStubY)*midpoint);var orientations={x:[0,1],y:[1,0]},lineCalculators={perpendicular:function(axis){var pi=paintInfo,sis={x:[[[1,2,3,4],null,[2,1,4,3]],null,[[4,3,2,1],null,[3,4,1,2]]],y:[[[3,2,1,4],null,[2,3,4,1]],null,[[4,1,2,3],null,[1,4,3,2]]]},stubs={x:[[pi.startStubX,pi.endStubX],null,[pi.endStubX,pi.startStubX]],y:[[pi.startStubY,pi.endStubY],null,[pi.endStubY,pi.startStubY]]},midLines={x:[[midx,pi.startStubY],[midx,pi.endStubY]],y:[[pi.startStubX,midy],[pi.endStubX,midy]]},linesToEnd={x:[[pi.endStubX,pi.startStubY]],y:[[pi.startStubX,pi.endStubY]]},startToEnd={x:[[pi.startStubX,pi.endStubY],[pi.endStubX,pi.endStubY]],y:[[pi.endStubX,pi.startStubY],[pi.endStubX,pi.endStubY]]},startToMidToEnd={x:[[pi.startStubX,midy],[pi.endStubX,midy],[pi.endStubX,pi.endStubY]],y:[[midx,pi.startStubY],[midx,pi.endStubY],[pi.endStubX,pi.endStubY]]},otherStubs={x:[pi.startStubY,pi.endStubY],y:[pi.startStubX,pi.endStubX]},soIdx=orientations[axis][0],toIdx=orientations[axis][1],_so=pi.so[soIdx]+1,_to=pi.to[toIdx]+1,otherFlipped=(pi.to[toIdx]===-1&&(otherStubs[axis][1]<otherStubs[axis][0]))||(pi.to[toIdx]===1&&(otherStubs[axis][1]>otherStubs[axis][0])),stub1=stubs[axis][_so][0],stub2=stubs[axis][_so][1],segmentIndexes=sis[axis][_so][_to];if(pi.segment===segmentIndexes[3]||(pi.segment===segmentIndexes[2]&&otherFlipped)){return midLines[axis]}else if(pi.segment===segmentIndexes[2]&&stub2<stub1){return linesToEnd[axis]}else if((pi.segment===segmentIndexes[2]&&stub2>=stub1)||(pi.segment===segmentIndexes[1]&&!otherFlipped)){return startToMidToEnd[axis]}else if(pi.segment===segmentIndexes[0]||(pi.segment===segmentIndexes[1]&&otherFlipped)){return startToEnd[axis]}},orthogonal:function(axis,startStub,otherStartStub,endStub,otherEndStub){var pi=paintInfo,extent={"x":pi.so[0]===-1?Math.min(startStub,endStub):Math.max(startStub,endStub),"y":pi.so[1]===-1?Math.min(startStub,endStub):Math.max(startStub,endStub)}[axis];return{"x":[[extent,otherStartStub],[extent,otherEndStub],[endStub,otherEndStub]],"y":[[otherStartStub,extent],[otherEndStub,extent],[otherEndStub,endStub]]}[axis]},opposite:function(axis,ss,oss,es){var pi=paintInfo,otherAxis={"x":"y","y":"x"}[axis],dim={"x":"height","y":"width"}[axis],comparator=pi["is"+axis.toUpperCase()+"GreaterThanStubTimes2"];if(params.sourceEndpoint.elementId===params.targetEndpoint.elementId){var _val=oss+((1-params.sourceEndpoint.anchor[otherAxis])*params.sourceInfo[dim])+_super.maxStub;return{"x":[[ss,_val],[es,_val]],"y":[[_val,ss],[_val,es]]}[axis]}else if(!comparator||(pi.so[idx]===1&&ss>es)||(pi.so[idx]===-1&&ss<es)){return{"x":[[ss,midy],[es,midy]],"y":[[midx,ss],[midx,es]]}[axis]}else if((pi.so[idx]===1&&ss<es)||(pi.so[idx]===-1&&ss>es)){return{"x":[[midx,pi.sy],[midx,pi.ty]],"y":[[pi.sx,midy],[pi.tx,midy]]}[axis]}}};var p=lineCalculators[paintInfo.anchorOrientation](paintInfo.sourceAxis,ss,oss,es,oes);if(p){for(var i=0;i<p.length;i++){addSegment(segments,p[i][0],p[i][1],paintInfo)}}
addSegment(segments,stubs[2],stubs[3],paintInfo);addSegment(segments,paintInfo.tx,paintInfo.ty,paintInfo);writeSegments(this,segments,paintInfo)}};_jp.Connectors.Flowchart=Flowchart;_ju.extend(_jp.Connectors.Flowchart,_jp.Connectors.AbstractConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;_jp.Connectors.AbstractBezierConnector=function(params){params=params||{};var showLoopback=params.showLoopback!==!1,curviness=params.curviness||10,margin=params.margin||5,proximityLimit=params.proximityLimit||80,clockwise=params.orientation&&params.orientation==="clockwise",loopbackRadius=params.loopbackRadius||25,isLoopbackCurrently=!1,_super;this._compute=function(paintInfo,p){var sp=p.sourcePos,tp=p.targetPos,_w=Math.abs(sp[0]-tp[0]),_h=Math.abs(sp[1]-tp[1]);if(!showLoopback||(p.sourceEndpoint.elementId!==p.targetEndpoint.elementId)){isLoopbackCurrently=!1;this._computeBezier(paintInfo,p,sp,tp,_w,_h)}else{isLoopbackCurrently=!0;var x1=p.sourcePos[0],y1=p.sourcePos[1]-margin,cx=x1,cy=y1-loopbackRadius,_x=cx-loopbackRadius,_y=cy-loopbackRadius;_w=2*loopbackRadius;_h=2*loopbackRadius;paintInfo.points[0]=_x;paintInfo.points[1]=_y;paintInfo.points[2]=_w;paintInfo.points[3]=_h;_super.addSegment(this,"Arc",{loopback:!0,x1:(x1-_x)+4,y1:y1-_y,startAngle:0,endAngle:2*Math.PI,r:loopbackRadius,ac:!clockwise,x2:(x1-_x)-4,y2:y1-_y,cx:cx-_x,cy:cy-_y})}};_super=_jp.Connectors.AbstractConnector.apply(this,arguments);return _super};_ju.extend(_jp.Connectors.AbstractBezierConnector,_jp.Connectors.AbstractConnector);var Bezier=function(params){params=params||{};this.type="Bezier";var _super=_jp.Connectors.AbstractBezierConnector.apply(this,arguments),majorAnchor=params.curviness||150,minorAnchor=10;this.getCurviness=function(){return majorAnchor};this._findControlPoint=function(point,sourceAnchorPosition,targetAnchorPosition,sourceEndpoint,targetEndpoint,soo,too){var perpendicular=soo[0]!==too[0]||soo[1]===too[1],p=[];if(!perpendicular){if(soo[0]===0){p.push(sourceAnchorPosition[0]<targetAnchorPosition[0]?point[0]+minorAnchor:point[0]-minorAnchor)}else{p.push(point[0]-(majorAnchor*soo[0]))}
if(soo[1]===0){p.push(sourceAnchorPosition[1]<targetAnchorPosition[1]?point[1]+minorAnchor:point[1]-minorAnchor)}else{p.push(point[1]+(majorAnchor*too[1]))}}else{if(too[0]===0){p.push(targetAnchorPosition[0]<sourceAnchorPosition[0]?point[0]+minorAnchor:point[0]-minorAnchor)}else{p.push(point[0]+(majorAnchor*too[0]))}
if(too[1]===0){p.push(targetAnchorPosition[1]<sourceAnchorPosition[1]?point[1]+minorAnchor:point[1]-minorAnchor)}else{p.push(point[1]+(majorAnchor*soo[1]))}}
return p};this._computeBezier=function(paintInfo,p,sp,tp,_w,_h){var _CP,_CP2,_sx=sp[0]<tp[0]?_w:0,_sy=sp[1]<tp[1]?_h:0,_tx=sp[0]<tp[0]?0:_w,_ty=sp[1]<tp[1]?0:_h;_CP=this._findControlPoint([_sx,_sy],sp,tp,p.sourceEndpoint,p.targetEndpoint,paintInfo.so,paintInfo.to);_CP2=this._findControlPoint([_tx,_ty],tp,sp,p.targetEndpoint,p.sourceEndpoint,paintInfo.to,paintInfo.so);_super.addSegment(this,"Bezier",{x1:_sx,y1:_sy,x2:_tx,y2:_ty,cp1x:_CP[0],cp1y:_CP[1],cp2x:_CP2[0],cp2y:_CP2[1]})}};_jp.Connectors.Bezier=Bezier;_ju.extend(Bezier,_jp.Connectors.AbstractBezierConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var _segment=function(x1,y1,x2,y2){if(x1<=x2&&y2<=y1){return 1}else if(x1<=x2&&y1<=y2){return 2}else if(x2<=x1&&y2>=y1){return 3}
return 4},_findControlPoint=function(midx,midy,segment,sourceEdge,targetEdge,dx,dy,distance,proximityLimit){if(distance<=proximityLimit){return[midx,midy]}
if(segment===1){if(sourceEdge[3]<=0&&targetEdge[3]>=1){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]>=1&&targetEdge[2]<=0){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+(-1*dx),midy+(-1*dy)]}}else if(segment===2){if(sourceEdge[3]>=1&&targetEdge[3]<=0){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]>=1&&targetEdge[2]<=0){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+dx,midy+(-1*dy)]}}else if(segment===3){if(sourceEdge[3]>=1&&targetEdge[3]<=0){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]<=0&&targetEdge[2]>=1){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+(-1*dx),midy+(-1*dy)]}}else if(segment===4){if(sourceEdge[3]<=0&&targetEdge[3]>=1){return[midx+(sourceEdge[2]<0.5?-1*dx:dx),midy]}else if(sourceEdge[2]<=0&&targetEdge[2]>=1){return[midx,midy+(sourceEdge[3]<0.5?-1*dy:dy)]}else{return[midx+dx,midy+(-1*dy)]}}};var StateMachine=function(params){params=params||{};this.type="StateMachine";var _super=_jp.Connectors.AbstractBezierConnector.apply(this,arguments),curviness=params.curviness||10,margin=params.margin||5,proximityLimit=params.proximityLimit||80,clockwise=params.orientation&&params.orientation==="clockwise",_controlPoint;this._computeBezier=function(paintInfo,params,sp,tp,w,h){var _sx=params.sourcePos[0]<params.targetPos[0]?0:w,_sy=params.sourcePos[1]<params.targetPos[1]?0:h,_tx=params.sourcePos[0]<params.targetPos[0]?w:0,_ty=params.sourcePos[1]<params.targetPos[1]?h:0;if(params.sourcePos[2]===0){_sx-=margin}
if(params.sourcePos[2]===1){_sx+=margin}
if(params.sourcePos[3]===0){_sy-=margin}
if(params.sourcePos[3]===1){_sy+=margin}
if(params.targetPos[2]===0){_tx-=margin}
if(params.targetPos[2]===1){_tx+=margin}
if(params.targetPos[3]===0){_ty-=margin}
if(params.targetPos[3]===1){_ty+=margin}
var _midx=(_sx+_tx)/2,_midy=(_sy+_ty)/2,segment=_segment(_sx,_sy,_tx,_ty),distance=Math.sqrt(Math.pow(_tx-_sx,2)+Math.pow(_ty-_sy,2)),cp1x,cp2x,cp1y,cp2y;_controlPoint=_findControlPoint(_midx,_midy,segment,params.sourcePos,params.targetPos,curviness,curviness,distance,proximityLimit);cp1x=_controlPoint[0];cp2x=_controlPoint[0];cp1y=_controlPoint[1];cp2y=_controlPoint[1];_super.addSegment(this,"Bezier",{x1:_tx,y1:_ty,x2:_sx,y2:_sy,cp1x:cp1x,cp1y:cp1y,cp2x:cp2x,cp2y:cp2y})}};_jp.Connectors.StateMachine=StateMachine;_ju.extend(StateMachine,_jp.Connectors.AbstractBezierConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var STRAIGHT="Straight";var Straight=function(params){this.type=STRAIGHT;var _super=_jp.Connectors.AbstractConnector.apply(this,arguments);this._compute=function(paintInfo,_){_super.addSegment(this,STRAIGHT,{x1:paintInfo.sx,y1:paintInfo.sy,x2:paintInfo.startStubX,y2:paintInfo.startStubY});_super.addSegment(this,STRAIGHT,{x1:paintInfo.startStubX,y1:paintInfo.startStubY,x2:paintInfo.endStubX,y2:paintInfo.endStubY});_super.addSegment(this,STRAIGHT,{x1:paintInfo.endStubX,y1:paintInfo.endStubY,x2:paintInfo.tx,y2:paintInfo.ty})}};_jp.Connectors.Straight=Straight;_ju.extend(Straight,_jp.Connectors.AbstractConnector)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil;var svgAttributeMap={"stroke-linejoin":"stroke-linejoin","stroke-dashoffset":"stroke-dashoffset","stroke-linecap":"stroke-linecap"},STROKE_DASHARRAY="stroke-dasharray",DASHSTYLE="dashstyle",LINEAR_GRADIENT="linearGradient",RADIAL_GRADIENT="radialGradient",DEFS="defs",FILL="fill",STOP="stop",STROKE="stroke",STROKE_WIDTH="stroke-width",STYLE="style",NONE="none",JSPLUMB_GRADIENT="jsplumb_gradient_",LINE_WIDTH="strokeWidth",ns={svg:"http://www.w3.org/2000/svg"},_attr=function(node,attributes){for(var i in attributes){node.setAttribute(i,""+attributes[i])}},_node=function(name,attributes){attributes=attributes||{};attributes.version="1.1";attributes.xmlns=ns.svg;return _jp.createElementNS(ns.svg,name,null,null,attributes)},_pos=function(d){return"position:absolute;left:"+d[0]+"px;top:"+d[1]+"px"},_clearGradient=function(parent){var els=parent.querySelectorAll(" defs,linearGradient,radialGradient");for(var i=0;i<els.length;i++){els[i].parentNode.removeChild(els[i])}},_updateGradient=function(parent,node,style,dimensions,uiComponent){var id=JSPLUMB_GRADIENT+uiComponent._jsPlumb.instance.idstamp();_clearGradient(parent);var g;if(!style.gradient.offset){g=_node(LINEAR_GRADIENT,{id:id,gradientUnits:"userSpaceOnUse"})}else{g=_node(RADIAL_GRADIENT,{id:id})}
var defs=_node(DEFS);parent.appendChild(defs);defs.appendChild(g);for(var i=0;i<style.gradient.stops.length;i++){var styleToUse=uiComponent.segment===1||uiComponent.segment===2?i:style.gradient.stops.length-1-i,stopColor=style.gradient.stops[styleToUse][1],s=_node(STOP,{"offset":Math.floor(style.gradient.stops[i][0]*100)+"%","stop-color":stopColor});g.appendChild(s)}
var applyGradientTo=style.stroke?STROKE:FILL;node.setAttribute(applyGradientTo,"url(#"+id+")")},_applyStyles=function(parent,node,style,dimensions,uiComponent){node.setAttribute(FILL,style.fill?style.fill:NONE);node.setAttribute(STROKE,style.stroke?style.stroke:NONE);if(style.gradient){_updateGradient(parent,node,style,dimensions,uiComponent)}else{_clearGradient(parent);node.setAttribute(STYLE,"")}
if(style.strokeWidth){node.setAttribute(STROKE_WIDTH,style.strokeWidth)}
if(style[DASHSTYLE]&&style[LINE_WIDTH]&&!style[STROKE_DASHARRAY]){var sep=style[DASHSTYLE].indexOf(",")===-1?" ":",",parts=style[DASHSTYLE].split(sep),styleToUse="";parts.forEach(function(p){styleToUse+=(Math.floor(p*style.strokeWidth)+sep)});node.setAttribute(STROKE_DASHARRAY,styleToUse)}else if(style[STROKE_DASHARRAY]){node.setAttribute(STROKE_DASHARRAY,style[STROKE_DASHARRAY])}
for(var i in svgAttributeMap){if(style[i]){node.setAttribute(svgAttributeMap[i],style[i])}}},_appendAtIndex=function(svg,path,idx){if(svg.childNodes.length>idx){svg.insertBefore(path,svg.childNodes[idx])}else{svg.appendChild(path)}};_ju.svg={node:_node,attr:_attr,pos:_pos};var SvgComponent=function(params){var pointerEventsSpec=params.pointerEventsSpec||"all",renderer={};_jp.jsPlumbUIComponent.apply(this,params.originalArgs);this.canvas=null;this.path=null;this.svg=null;this.bgCanvas=null;var clazz=params.cssClass+" "+(params.originalArgs[0].cssClass||""),svgParams={"style":"","width":0,"height":0,"pointer-events":pointerEventsSpec,"position":"absolute"};this.svg=_node("svg",svgParams);if(params.useDivWrapper){this.canvas=_jp.createElement("div",{position:"absolute"});_ju.sizeElement(this.canvas,0,0,1,1);this.canvas.className=clazz}else{_attr(this.svg,{"class":clazz});this.canvas=this.svg}
params._jsPlumb.appendElement(this.canvas,params.originalArgs[0].parent);if(params.useDivWrapper){this.canvas.appendChild(this.svg)}
var displayElements=[this.canvas];this.getDisplayElements=function(){return displayElements};this.appendDisplayElement=function(el){displayElements.push(el)};this.paint=function(style,anchor,extents){if(style!=null){var xy=[this.x,this.y],wh=[this.w,this.h],p;if(extents!=null){if(extents.xmin<0){xy[0]+=extents.xmin}
if(extents.ymin<0){xy[1]+=extents.ymin}
wh[0]=extents.xmax+((extents.xmin<0)?-extents.xmin:0);wh[1]=extents.ymax+((extents.ymin<0)?-extents.ymin:0)}
if(params.useDivWrapper){_ju.sizeElement(this.canvas,xy[0],xy[1],wh[0]>0?wh[0]:1,wh[1]>0?wh[1]:1);xy[0]=0;xy[1]=0;p=_pos([0,0])}else{p=_pos([xy[0],xy[1]])}
renderer.paint.apply(this,arguments);_attr(this.svg,{"style":p,"width":wh[0]||1,"height":wh[1]||1})}};return{renderer:renderer}};_ju.extend(SvgComponent,_jp.jsPlumbUIComponent,{cleanup:function(force){if(force||this.typeId==null){if(this.canvas){this.canvas._jsPlumb=null}
if(this.svg){this.svg._jsPlumb=null}
if(this.bgCanvas){this.bgCanvas._jsPlumb=null}
if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
this.svg=null;this.canvas=null;this.path=null;this.group=null;this._jsPlumb=null}else{if(this.canvas&&this.canvas.parentNode){this.canvas.parentNode.removeChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode){this.bgCanvas.parentNode.removeChild(this.bgCanvas)}}},reattach:function(instance){var c=instance.getContainer();if(this.canvas&&this.canvas.parentNode==null){c.appendChild(this.canvas)}
if(this.bgCanvas&&this.bgCanvas.parentNode==null){c.appendChild(this.bgCanvas)}},setVisible:function(v){if(this.canvas){this.canvas.style.display=v?"block":"none"}}});_jp.ConnectorRenderers.svg=function(params){var self=this,_super=SvgComponent.apply(this,[{cssClass:params._jsPlumb.connectorClass,originalArgs:arguments,pointerEventsSpec:"none",_jsPlumb:params._jsPlumb}]);_super.renderer.paint=function(style,anchor,extents){var segments=self.getSegments(),p="",offset=[0,0];if(extents.xmin<0){offset[0]=-extents.xmin}
if(extents.ymin<0){offset[1]=-extents.ymin}
if(segments.length>0){p=self.getPathData();var a={d:p,transform:"translate("+offset[0]+","+offset[1]+")","pointer-events":params["pointer-events"]||"visibleStroke"},outlineStyle=null,d=[self.x,self.y,self.w,self.h];if(style.outlineStroke){var outlineWidth=style.outlineWidth||1,outlineStrokeWidth=style.strokeWidth+(2*outlineWidth);outlineStyle=_jp.extend({},style);delete outlineStyle.gradient;outlineStyle.stroke=style.outlineStroke;outlineStyle.strokeWidth=outlineStrokeWidth;if(self.bgPath==null){self.bgPath=_node("path",a);_jp.addClass(self.bgPath,_jp.connectorOutlineClass);_appendAtIndex(self.svg,self.bgPath,0)}else{_attr(self.bgPath,a)}
_applyStyles(self.svg,self.bgPath,outlineStyle,d,self)}
if(self.path==null){self.path=_node("path",a);_appendAtIndex(self.svg,self.path,style.outlineStroke?1:0)}else{_attr(self.path,a)}
_applyStyles(self.svg,self.path,style,d,self)}}};_ju.extend(_jp.ConnectorRenderers.svg,SvgComponent);var SvgEndpoint=_jp.SvgEndpoint=function(params){var _super=SvgComponent.apply(this,[{cssClass:params._jsPlumb.endpointClass,originalArgs:arguments,pointerEventsSpec:"all",useDivWrapper:!0,_jsPlumb:params._jsPlumb}]);_super.renderer.paint=function(style){var s=_jp.extend({},style);if(s.outlineStroke){s.stroke=s.outlineStroke}
if(this.node==null){this.node=this.makeNode(s);this.svg.appendChild(this.node)}else if(this.updateNode!=null){this.updateNode(this.node)}
_applyStyles(this.svg,this.node,s,[this.x,this.y,this.w,this.h],this);_pos(this.node,[this.x,this.y])}.bind(this)};_ju.extend(SvgEndpoint,SvgComponent);_jp.Endpoints.svg.Dot=function(){_jp.Endpoints.Dot.apply(this,arguments);SvgEndpoint.apply(this,arguments);this.makeNode=function(style){return _node("circle",{"cx":this.w/2,"cy":this.h/2,"r":this.radius})};this.updateNode=function(node){_attr(node,{"cx":this.w/2,"cy":this.h/2,"r":this.radius})}};_ju.extend(_jp.Endpoints.svg.Dot,[_jp.Endpoints.Dot,SvgEndpoint]);_jp.Endpoints.svg.Rectangle=function(){_jp.Endpoints.Rectangle.apply(this,arguments);SvgEndpoint.apply(this,arguments);this.makeNode=function(style){return _node("rect",{"width":this.w,"height":this.h})};this.updateNode=function(node){_attr(node,{"width":this.w,"height":this.h})}};_ju.extend(_jp.Endpoints.svg.Rectangle,[_jp.Endpoints.Rectangle,SvgEndpoint]);_jp.Endpoints.svg.Image=_jp.Endpoints.Image;_jp.Endpoints.svg.Blank=_jp.Endpoints.Blank;_jp.Overlays.svg.Label=_jp.Overlays.Label;_jp.Overlays.svg.Custom=_jp.Overlays.Custom;var AbstractSvgArrowOverlay=function(superclass,originalArgs){superclass.apply(this,originalArgs);_jp.jsPlumbUIComponent.apply(this,originalArgs);this.isAppendedAtTopLevel=!1;var self=this;this.path=null;this.paint=function(params,containerExtents){if(params.component.svg&&containerExtents){if(this.path==null){this.path=_node("path",{"pointer-events":"all"});params.component.svg.appendChild(this.path);if(this.elementCreated){this.elementCreated(this.path,params.component)}
this.canvas=params.component.svg}
var clazz=originalArgs&&(originalArgs.length===1)?(originalArgs[0].cssClass||""):"",offset=[0,0];if(containerExtents.xmin<0){offset[0]=-containerExtents.xmin}
if(containerExtents.ymin<0){offset[1]=-containerExtents.ymin}
_attr(this.path,{"d":makePath(params.d),"class":clazz,stroke:params.stroke?params.stroke:null,fill:params.fill?params.fill:null,transform:"translate("+offset[0]+","+offset[1]+")"})}};var makePath=function(d){return(isNaN(d.cxy.x)||isNaN(d.cxy.y))?"":"M"+d.hxy.x+","+d.hxy.y+" L"+d.tail[0].x+","+d.tail[0].y+" L"+d.cxy.x+","+d.cxy.y+" L"+d.tail[1].x+","+d.tail[1].y+" L"+d.hxy.x+","+d.hxy.y};this.transfer=function(target){if(target.canvas&&this.path&&this.path.parentNode){this.path.parentNode.removeChild(this.path);target.canvas.appendChild(this.path)}}};var svgProtoFunctions={cleanup:function(force){if(this.path!=null){if(force){this._jsPlumb.instance.removeElement(this.path)}else{if(this.path.parentNode){this.path.parentNode.removeChild(this.path)}}}},reattach:function(instance,component){if(this.path&&component.canvas){component.canvas.appendChild(this.path)}},setVisible:function(v){if(this.path!=null){(this.path.style.display=(v?"block":"none"))}}};_ju.extend(AbstractSvgArrowOverlay,[_jp.jsPlumbUIComponent,_jp.Overlays.AbstractOverlay]);_jp.Overlays.svg.Arrow=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.Arrow,arguments])};_ju.extend(_jp.Overlays.svg.Arrow,[_jp.Overlays.Arrow,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.PlainArrow=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.PlainArrow,arguments])};_ju.extend(_jp.Overlays.svg.PlainArrow,[_jp.Overlays.PlainArrow,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.Diamond=function(){AbstractSvgArrowOverlay.apply(this,[_jp.Overlays.Diamond,arguments])};_ju.extend(_jp.Overlays.svg.Diamond,[_jp.Overlays.Diamond,AbstractSvgArrowOverlay],svgProtoFunctions);_jp.Overlays.svg.GuideLines=function(){var path=null,self=this,p1_1,p1_2;_jp.Overlays.GuideLines.apply(this,arguments);this.paint=function(params,containerExtents){if(path==null){path=_node("path");params.connector.svg.appendChild(path);self.attachListeners(path,params.connector);self.attachListeners(path,self);p1_1=_node("path");params.connector.svg.appendChild(p1_1);self.attachListeners(p1_1,params.connector);self.attachListeners(p1_1,self);p1_2=_node("path");params.connector.svg.appendChild(p1_2);self.attachListeners(p1_2,params.connector);self.attachListeners(p1_2,self)}
var offset=[0,0];if(containerExtents.xmin<0){offset[0]=-containerExtents.xmin}
if(containerExtents.ymin<0){offset[1]=-containerExtents.ymin}
_attr(path,{"d":makePath(params.head,params.tail),stroke:"red",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"});_attr(p1_1,{"d":makePath(params.tailLine[0],params.tailLine[1]),stroke:"blue",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"});_attr(p1_2,{"d":makePath(params.headLine[0],params.headLine[1]),stroke:"green",fill:null,transform:"translate("+offset[0]+","+offset[1]+")"})};var makePath=function(d1,d2){return"M "+d1.x+","+d1.y+" L"+d2.x+","+d2.y}};_ju.extend(_jp.Overlays.svg.GuideLines,_jp.Overlays.GuideLines)}).call(typeof window!=='undefined'?window:this);(function(){"use strict";var root=this,_jp=root.jsPlumb,_ju=root.jsPlumbUtil,_jk=root.Katavorio,_jg=root.Biltong;var _getEventManager=function(instance){var e=instance._mottle;if(!e){e=instance._mottle=new root.Mottle()}
return e};var _getDragManager=function(instance,category){category=category||"main";var key="_katavorio_"+category;var k=instance[key],e=instance.getEventManager();if(!k){k=new _jk({bind:e.on,unbind:e.off,getSize:_jp.getSize,getConstrainingRectangle:function(el){return[el.parentNode.scrollWidth,el.parentNode.scrollHeight]},getPosition:function(el,relativeToRoot){var o=instance.getOffset(el,relativeToRoot,el._katavorioDrag?el.offsetParent:null);return[o.left,o.top]},setPosition:function(el,xy){el.style.left=xy[0]+"px";el.style.top=xy[1]+"px"},addClass:_jp.addClass,removeClass:_jp.removeClass,intersects:_jg.intersects,indexOf:function(l,i){return l.indexOf(i)},scope:instance.getDefaultScope(),css:{noSelect:instance.dragSelectClass,droppable:"jtk-droppable",draggable:"jtk-draggable",drag:"jtk-drag",selected:"jtk-drag-selected",active:"jtk-drag-active",hover:"jtk-drag-hover",ghostProxy:"jtk-ghost-proxy"}});k.setZoom(instance.getZoom());instance[key]=k;instance.bind("zoom",k.setZoom)}
return k};var _dragStart=function(params){var options=params.el._jsPlumbDragOptions;var cont=!0;if(options.canDrag){cont=options.canDrag()}
if(cont){this.setHoverSuspended(!0);this.select({source:params.el}).addClass(this.elementDraggingClass+" "+this.sourceElementDraggingClass,!0);this.select({target:params.el}).addClass(this.elementDraggingClass+" "+this.targetElementDraggingClass,!0);this.setConnectionBeingDragged(!0)}
return cont};var _dragMove=function(params){var ui=this.getUIPosition(arguments,this.getZoom());if(ui!=null){var o=params.el._jsPlumbDragOptions;this.draw(params.el,ui,null,!0);if(o._dragging){this.addClass(params.el,"jtk-dragged")}
o._dragging=!0}};var _dragStop=function(params){var elements=params.selection,uip;var _one=function(_e){var drawResult;if(_e[1]!=null){uip=this.getUIPosition([{el:_e[2].el,pos:[_e[1].left,_e[1].top]}]);drawResult=this.draw(_e[2].el,uip)}
if(_e[0]._jsPlumbDragOptions!=null){delete _e[0]._jsPlumbDragOptions._dragging}
this.removeClass(_e[0],"jtk-dragged");this.select({source:_e[2].el}).removeClass(this.elementDraggingClass+" "+this.sourceElementDraggingClass,!0);this.select({target:_e[2].el}).removeClass(this.elementDraggingClass+" "+this.targetElementDraggingClass,!0);params.e._drawResult=params.e._drawResult||{c:[],e:[],a:[]};Array.prototype.push.apply(params.e._drawResult.c,drawResult.c);Array.prototype.push.apply(params.e._drawResult.e,drawResult.e);Array.prototype.push.apply(params.e._drawResult.a,drawResult.a);this.getDragManager().dragEnded(_e[2].el)}.bind(this);for(var i=0;i<elements.length;i++){_one(elements[i])}
this.setHoverSuspended(!1);this.setConnectionBeingDragged(!1)};var _animProps=function(o,p){var _one=function(pName){if(p[pName]!=null){if(_ju.isString(p[pName])){var m=p[pName].match(/-=/)?-1:1,v=p[pName].substring(2);return o[pName]+(m*v)}else{return p[pName]}}else{return o[pName]}};return[_one("left"),_one("top")]};var _genLoc=function(prefix,e){if(e==null){return[0,0]}
var ts=_touches(e),t=_getTouch(ts,0);return[t[prefix+"X"],t[prefix+"Y"]]},_pageLocation=_genLoc.bind(this,"page"),_screenLocation=_genLoc.bind(this,"screen"),_clientLocation=_genLoc.bind(this,"client"),_getTouch=function(touches,idx){return touches.item?touches.item(idx):touches[idx]},_touches=function(e){return e.touches&&e.touches.length>0?e.touches:e.changedTouches&&e.changedTouches.length>0?e.changedTouches:e.targetTouches&&e.targetTouches.length>0?e.targetTouches:[e]};var DragManager=function(_currentInstance){var _draggables={},_dlist=[],_delements={},_elementsWithEndpoints={},_draggablesForElements={};this.register=function(el){var id=_currentInstance.getId(el),parentOffset;if(!_draggables[id]){_draggables[id]=el;_dlist.push(el);_delements[id]={}}
var _oneLevel=function(p){if(p){for(var i=0;i<p.childNodes.length;i++){if(p.childNodes[i].nodeType!==3&&p.childNodes[i].nodeType!==8){var cEl=jsPlumb.getElement(p.childNodes[i]),cid=_currentInstance.getId(p.childNodes[i],null,!0);if(cid&&_elementsWithEndpoints[cid]&&_elementsWithEndpoints[cid]>0){if(!parentOffset){parentOffset=_currentInstance.getOffset(el)}
var cOff=_currentInstance.getOffset(cEl);_delements[id][cid]={id:cid,offset:{left:cOff.left-parentOffset.left,top:cOff.top-parentOffset.top}};_draggablesForElements[cid]=id}
_oneLevel(p.childNodes[i])}}}};_oneLevel(el)};this.updateOffsets=function(elId,childOffsetOverrides){if(elId!=null){childOffsetOverrides=childOffsetOverrides||{};var domEl=jsPlumb.getElement(elId),id=_currentInstance.getId(domEl),children=_delements[id],parentOffset;if(children){for(var i in children){if(children.hasOwnProperty(i)){var cel=jsPlumb.getElement(i),cOff=childOffsetOverrides[i]||_currentInstance.getOffset(cel);if(cel.offsetParent==null&&_delements[id][i]!=null){continue}
if(!parentOffset){parentOffset=_currentInstance.getOffset(domEl)}
_delements[id][i]={id:i,offset:{left:cOff.left-parentOffset.left,top:cOff.top-parentOffset.top}};_draggablesForElements[i]=id}}}}};this.endpointAdded=function(el,id){id=id||_currentInstance.getId(el);var b=document.body,p=el.parentNode;_elementsWithEndpoints[id]=_elementsWithEndpoints[id]?_elementsWithEndpoints[id]+1:1;while(p!=null&&p!==b){var pid=_currentInstance.getId(p,null,!0);if(pid&&_draggables[pid]){var pLoc=_currentInstance.getOffset(p);if(_delements[pid][id]==null){var cLoc=_currentInstance.getOffset(el);_delements[pid][id]={id:id,offset:{left:cLoc.left-pLoc.left,top:cLoc.top-pLoc.top}};_draggablesForElements[id]=pid}
break}
p=p.parentNode}};this.endpointDeleted=function(endpoint){if(_elementsWithEndpoints[endpoint.elementId]){_elementsWithEndpoints[endpoint.elementId]--;if(_elementsWithEndpoints[endpoint.elementId]<=0){for(var i in _delements){if(_delements.hasOwnProperty(i)&&_delements[i]){delete _delements[i][endpoint.elementId];delete _draggablesForElements[endpoint.elementId]}}}}};this.changeId=function(oldId,newId){_delements[newId]=_delements[oldId];_delements[oldId]={};_draggablesForElements[newId]=_draggablesForElements[oldId];_draggablesForElements[oldId]=null};this.getElementsForDraggable=function(id){return _delements[id]};this.elementRemoved=function(elementId){var elId=_draggablesForElements[elementId];if(elId){_delements[elId]&&delete _delements[elId][elementId];delete _draggablesForElements[elementId]}};this.reset=function(){_draggables={};_dlist=[];_delements={};_elementsWithEndpoints={}};this.dragEnded=function(el){if(el.offsetParent!=null){var id=_currentInstance.getId(el),ancestor=_draggablesForElements[id];if(ancestor){this.updateOffsets(ancestor)}}};this.setParent=function(el,elId,p,pId,currentChildLocation){var current=_draggablesForElements[elId];if(!_delements[pId]){_delements[pId]={}}
var pLoc=_currentInstance.getOffset(p),cLoc=currentChildLocation||_currentInstance.getOffset(el);if(current&&_delements[current]){delete _delements[current][elId]}
_delements[pId][elId]={id:elId,offset:{left:cLoc.left-pLoc.left,top:cLoc.top-pLoc.top}};_draggablesForElements[elId]=pId};this.clearParent=function(el,elId){var current=_draggablesForElements[elId];if(current){delete _delements[current][elId];delete _draggablesForElements[elId]}};this.revalidateParent=function(el,elId,childOffset){var current=_draggablesForElements[elId];if(current){var co={};co[elId]=childOffset;this.updateOffsets(current,co);_currentInstance.revalidate(current)}};this.getDragAncestor=function(el){var de=jsPlumb.getElement(el),id=_currentInstance.getId(de),aid=_draggablesForElements[id];if(aid){return jsPlumb.getElement(aid)}else{return null}}};var _setClassName=function(el,cn,classList){cn=_ju.fastTrim(cn);if(typeof el.className.baseVal!=="undefined"){el.className.baseVal=cn}else{el.className=cn}
try{var cl=el.classList;if(cl!=null){while(cl.length>0){cl.remove(cl.item(0))}
for(var i=0;i<classList.length;i++){if(classList[i]){cl.add(classList[i])}}}}catch(e){_ju.log("JSPLUMB: cannot set class list",e)}},_getClassName=function(el){return(typeof el.className.baseVal==="undefined")?el.className:el.className.baseVal},_classManip=function(el,classesToAdd,classesToRemove){classesToAdd=classesToAdd==null?[]:_ju.isArray(classesToAdd)?classesToAdd:classesToAdd.split(/\s+/);classesToRemove=classesToRemove==null?[]:_ju.isArray(classesToRemove)?classesToRemove:classesToRemove.split(/\s+/);var className=_getClassName(el),curClasses=className.split(/\s+/);var _oneSet=function(add,classes){for(var i=0;i<classes.length;i++){if(add){if(curClasses.indexOf(classes[i])===-1){curClasses.push(classes[i])}}else{var idx=curClasses.indexOf(classes[i]);if(idx!==-1){curClasses.splice(idx,1)}}}};_oneSet(!0,classesToAdd);_oneSet(!1,classesToRemove);_setClassName(el,curClasses.join(" "),curClasses)};root.jsPlumb.extend(root.jsPlumbInstance.prototype,{headless:!1,pageLocation:_pageLocation,screenLocation:_screenLocation,clientLocation:_clientLocation,getDragManager:function(){if(this.dragManager==null){this.dragManager=new DragManager(this)}
return this.dragManager},recalculateOffsets:function(elId){this.getDragManager().updateOffsets(elId)},createElement:function(tag,style,clazz,atts){return this.createElementNS(null,tag,style,clazz,atts)},createElementNS:function(ns,tag,style,clazz,atts){var e=ns==null?document.createElement(tag):document.createElementNS(ns,tag);var i;style=style||{};for(i in style){e.style[i]=style[i]}
if(clazz){e.className=clazz}
atts=atts||{};for(i in atts){e.setAttribute(i,""+atts[i])}
return e},getAttribute:function(el,attName){return el.getAttribute!=null?el.getAttribute(attName):null},setAttribute:function(el,a,v){if(el.setAttribute!=null){el.setAttribute(a,v)}},setAttributes:function(el,atts){for(var i in atts){if(atts.hasOwnProperty(i)){el.setAttribute(i,atts[i])}}},appendToRoot:function(node){document.body.appendChild(node)},getRenderModes:function(){return["svg"]},getClass:_getClassName,addClass:function(el,clazz){jsPlumb.each(el,function(e){_classManip(e,clazz)})},hasClass:function(el,clazz){el=jsPlumb.getElement(el);if(el.classList){return el.classList.contains(clazz)}else{return _getClassName(el).indexOf(clazz)!==-1}},removeClass:function(el,clazz){jsPlumb.each(el,function(e){_classManip(e,null,clazz)})},toggleClass:function(el,clazz){if(jsPlumb.hasClass(el,clazz)){jsPlumb.removeClass(el,clazz)}else{jsPlumb.addClass(el,clazz)}},updateClasses:function(el,toAdd,toRemove){jsPlumb.each(el,function(e){_classManip(e,toAdd,toRemove)})},setClass:function(el,clazz){if(clazz!=null){jsPlumb.each(el,function(e){_setClassName(e,clazz,clazz.split(/\s+/))})}},setPosition:function(el,p){el.style.left=p.left+"px";el.style.top=p.top+"px"},getPosition:function(el){var _one=function(prop){var v=el.style[prop];return v?v.substring(0,v.length-2):0};return{left:_one("left"),top:_one("top")}},getStyle:function(el,prop){if(typeof window.getComputedStyle!=='undefined'){return getComputedStyle(el,null).getPropertyValue(prop)}else{return el.currentStyle[prop]}},getSelector:function(ctx,spec){var sel=null;if(arguments.length===1){sel=ctx.nodeType!=null?ctx:document.querySelectorAll(ctx)}else{sel=ctx.querySelectorAll(spec)}
return sel},getOffset:function(el,relativeToRoot,container){el=jsPlumb.getElement(el);container=container||this.getContainer();var out={left:el.offsetLeft,top:el.offsetTop},op=(relativeToRoot||(container!=null&&(el!==container&&el.offsetParent!==container)))?el.offsetParent:null,_maybeAdjustScroll=function(offsetParent){if(offsetParent!=null&&offsetParent!==document.body&&(offsetParent.scrollTop>0||offsetParent.scrollLeft>0)){out.left-=offsetParent.scrollLeft;out.top-=offsetParent.scrollTop}}.bind(this);while(op!=null){out.left+=op.offsetLeft;out.top+=op.offsetTop;_maybeAdjustScroll(op);op=relativeToRoot?op.offsetParent:op.offsetParent===container?null:op.offsetParent}
if(container!=null&&!relativeToRoot&&(container.scrollTop>0||container.scrollLeft>0)){var pp=el.offsetParent!=null?this.getStyle(el.offsetParent,"position"):"static",p=this.getStyle(el,"position");if(p!=="absolute"&&p!=="fixed"&&pp!=="absolute"&&pp!=="fixed"){out.left-=container.scrollLeft;out.top-=container.scrollTop}}
return out},getPositionOnElement:function(evt,el,zoom){var box=typeof el.getBoundingClientRect!=="undefined"?el.getBoundingClientRect():{left:0,top:0,width:0,height:0},body=document.body,docElem=document.documentElement,scrollTop=window.pageYOffset||docElem.scrollTop||body.scrollTop,scrollLeft=window.pageXOffset||docElem.scrollLeft||body.scrollLeft,clientTop=docElem.clientTop||body.clientTop||0,clientLeft=docElem.clientLeft||body.clientLeft||0,pst=0,psl=0,top=box.top+scrollTop-clientTop+(pst*zoom),left=box.left+scrollLeft-clientLeft+(psl*zoom),cl=jsPlumb.pageLocation(evt),w=box.width||(el.offsetWidth*zoom),h=box.height||(el.offsetHeight*zoom),x=(cl[0]-left)/w,y=(cl[1]-top)/h;return[x,y]},getAbsolutePosition:function(el){var _one=function(s){var ss=el.style[s];if(ss){return parseFloat(ss.substring(0,ss.length-2))}};return[_one("left"),_one("top")]},setAbsolutePosition:function(el,xy,animateFrom,animateOptions){if(animateFrom){this.animate(el,{left:"+="+(xy[0]-animateFrom[0]),top:"+="+(xy[1]-animateFrom[1])},animateOptions)}else{el.style.left=xy[0]+"px";el.style.top=xy[1]+"px"}},getSize:function(el){return[el.offsetWidth,el.offsetHeight]},getWidth:function(el){return el.offsetWidth},getHeight:function(el){return el.offsetHeight},getRenderMode:function(){return"svg"},draggable:function(el,options){var info;el=_ju.isArray(el)||(el.length!=null&&!_ju.isString(el))?el:[el];Array.prototype.slice.call(el).forEach(function(_el){info=this.info(_el);if(info.el){this._initDraggableIfNecessary(info.el,!0,options,info.id,!0)}}.bind(this));return this},snapToGrid:function(el,x,y){var out=[];var _oneEl=function(_el){var info=this.info(_el);if(info.el!=null&&info.el._katavorioDrag){var snapped=info.el._katavorioDrag.snap(x,y);this.revalidate(info.el);out.push([info.el,snapped])}}.bind(this);if(arguments.length===1||arguments.length===3){_oneEl(el,x,y)}else{var _me=this.getManagedElements();for(var mel in _me){_oneEl(mel,arguments[0],arguments[1])}}
return out},initDraggable:function(el,options,category){_getDragManager(this,category).draggable(el,options);el._jsPlumbDragOptions=options},destroyDraggable:function(el,category){_getDragManager(this,category).destroyDraggable(el);el._jsPlumbDragOptions=null;el._jsPlumbRelatedElement=null},unbindDraggable:function(el,evt,fn,category){_getDragManager(this,category).destroyDraggable(el,evt,fn)},setDraggable:function(element,draggable){return jsPlumb.each(element,function(el){if(this.isDragSupported(el)){this._draggableStates[this.getAttribute(el,"id")]=draggable;this.setElementDraggable(el,draggable)}}.bind(this))},_draggableStates:{},toggleDraggable:function(el){var state;jsPlumb.each(el,function(el){var elId=this.getAttribute(el,"id");state=this._draggableStates[elId]==null?!1:this._draggableStates[elId];state=!state;this._draggableStates[elId]=state;this.setDraggable(el,state);return state}.bind(this));return state},_initDraggableIfNecessary:function(element,isDraggable,dragOptions,id,fireEvent){if(!jsPlumb.headless){var _draggable=isDraggable==null?!1:isDraggable;if(_draggable){if(jsPlumb.isDragSupported(element,this)){var options=dragOptions||this.Defaults.DragOptions;options=jsPlumb.extend({},options);if(!jsPlumb.isAlreadyDraggable(element,this)){var dragEvent=jsPlumb.dragEvents.drag,stopEvent=jsPlumb.dragEvents.stop,startEvent=jsPlumb.dragEvents.start;this.manage(id,element);options[startEvent]=_ju.wrap(options[startEvent],_dragStart.bind(this));options[dragEvent]=_ju.wrap(options[dragEvent],_dragMove.bind(this));options[stopEvent]=_ju.wrap(options[stopEvent],_dragStop.bind(this));var elId=this.getId(element);this._draggableStates[elId]=!0;var draggable=this._draggableStates[elId];options.disabled=draggable==null?!1:!draggable;this.initDraggable(element,options);this.getDragManager().register(element);if(fireEvent){this.fire("elementDraggable",{el:element,options:options})}}else{if(dragOptions.force){this.initDraggable(element,options)}}}}}},animationSupported:!0,getElement:function(el){if(el==null){return null}
el=typeof el==="string"?el:(el.tagName==null&&el.length!=null&&el.enctype==null)?el[0]:el;return typeof el==="string"?document.getElementById(el):el},removeElement:function(element){_getDragManager(this).elementRemoved(element);this.getEventManager().remove(element)},doAnimate:function(el,properties,options){options=options||{};var o=this.getOffset(el),ap=_animProps(o,properties),ldist=ap[0]-o.left,tdist=ap[1]-o.top,d=options.duration||250,step=15,steps=d/step,linc=(step/d)*ldist,tinc=(step/d)*tdist,idx=0,_int=setInterval(function(){_jp.setPosition(el,{left:o.left+(linc*(idx+1)),top:o.top+(tinc*(idx+1))});if(options.step!=null){options.step(idx,Math.ceil(steps))}
idx++;if(idx>=steps){window.clearInterval(_int);if(options.complete!=null){options.complete()}}},step)},destroyDroppable:function(el,category){_getDragManager(this,category).destroyDroppable(el)},unbindDroppable:function(el,evt,fn,category){_getDragManager(this,category).destroyDroppable(el,evt,fn)},droppable:function(el,options){el=_ju.isArray(el)||(el.length!=null&&!_ju.isString(el))?el:[el];var info;options=options||{};options.allowLoopback=!1;Array.prototype.slice.call(el).forEach(function(_el){info=this.info(_el);if(info.el){this.initDroppable(info.el,options)}}.bind(this));return this},initDroppable:function(el,options,category){_getDragManager(this,category).droppable(el,options)},isAlreadyDraggable:function(el){return el._katavorioDrag!=null},isDragSupported:function(el,options){return!0},isDropSupported:function(el,options){return!0},isElementDraggable:function(el){el=_jp.getElement(el);return el._katavorioDrag&&el._katavorioDrag.isEnabled()},getDragObject:function(eventArgs){return eventArgs[0].drag.getDragElement()},getDragScope:function(el){return el._katavorioDrag&&el._katavorioDrag.scopes.join(" ")||""},getDropEvent:function(args){return args[0].e},getUIPosition:function(eventArgs,zoom){var el=eventArgs[0].el;if(el.offsetParent==null){return null}
var finalPos=eventArgs[0].finalPos||eventArgs[0].pos;var p={left:finalPos[0],top:finalPos[1]};if(el._katavorioDrag&&el.offsetParent!==this.getContainer()){var oc=this.getOffset(el.offsetParent);p.left+=oc.left;p.top+=oc.top}
return p},setDragFilter:function(el,filter,_exclude){if(el._katavorioDrag){el._katavorioDrag.setFilter(filter,_exclude)}},setElementDraggable:function(el,draggable){el=_jp.getElement(el);if(el._katavorioDrag){el._katavorioDrag.setEnabled(draggable)}},setDragScope:function(el,scope){if(el._katavorioDrag){el._katavorioDrag.k.setDragScope(el,scope)}},setDropScope:function(el,scope){if(el._katavorioDrop&&el._katavorioDrop.length>0){el._katavorioDrop[0].k.setDropScope(el,scope)}},addToPosse:function(el,spec){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.addToPosse.apply(dm,_el)})},setPosse:function(el,spec){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.setPosse.apply(dm,_el)})},removeFromPosse:function(el,posseId){var specs=Array.prototype.slice.call(arguments,1);var dm=_getDragManager(this);_jp.each(el,function(_el){_el=[_jp.getElement(_el)];_el.push.apply(_el,specs);dm.removeFromPosse.apply(dm,_el)})},removeFromAllPosses:function(el){var dm=_getDragManager(this);_jp.each(el,function(_el){dm.removeFromAllPosses(_jp.getElement(_el))})},setPosseState:function(el,posseId,state){var dm=_getDragManager(this);_jp.each(el,function(_el){dm.setPosseState(_jp.getElement(_el),posseId,state)})},dragEvents:{'start':'start','stop':'stop','drag':'drag','step':'step','over':'over','out':'out','drop':'drop','complete':'complete','beforeStart':'beforeStart'},animEvents:{'step':"step",'complete':'complete'},stopDrag:function(el){if(el._katavorioDrag){el._katavorioDrag.abort()}},addToDragSelection:function(spec){var el=this.getElement(spec);if(el!=null&&(el._isJsPlumbGroup||el._jsPlumbGroup==null)){_getDragManager(this).select(spec)}},removeFromDragSelection:function(spec){_getDragManager(this).deselect(spec)},getDragSelection:function(){return _getDragManager(this).getSelection()},clearDragSelection:function(){_getDragManager(this).deselectAll()},trigger:function(el,event,originalEvent,payload){this.getEventManager().trigger(el,event,originalEvent,payload)},doReset:function(){for(var key in this){if(key.indexOf("_katavorio_")===0){this[key].reset()}}},getEventManager:function(){return _getEventManager(this)},on:function(el,event,callback){this.getEventManager().on.apply(this,arguments);return this},off:function(el,event,callback){this.getEventManager().off.apply(this,arguments);return this}});var ready=function(f){var _do=function(){if(/complete|loaded|interactive/.test(document.readyState)&&typeof(document.body)!=="undefined"&&document.body!=null){f()}else{setTimeout(_do,9)}};_do()};ready(_jp.init)}).call(typeof window!=='undefined'?window:this);/*!
 * typeahead.js 0.11.1
 * https://github.com/twitter/typeahead.js
 * Copyright 2013-2015 Twitter, Inc. and other contributors; Licensed MIT
 */
(function(root,factory){if(typeof define==="function"&&define.amd){define("bloodhound",["jquery"],function(a0){return root.Bloodhound=factory(a0)})}else if(typeof exports==="object"){module.exports=factory(require("jquery"))}else{root.Bloodhound=factory(jQuery)}})(this,function($){var _=function(){"use strict";return{isMsie:function(){return/(msie|trident)/i.test(navigator.userAgent)?navigator.userAgent.match(/(msie |rv:)(\d+(.\d+)?)/i)[2]:!1},isBlankString:function(str){return!str||/^\s*$/.test(str)},escapeRegExChars:function(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(obj){return typeof obj==="string"},isNumber:function(obj){return typeof obj==="number"},isArray:$.isArray,isFunction:$.isFunction,isObject:$.isPlainObject,isUndefined:function(obj){return typeof obj==="undefined"},isElement:function(obj){return!!(obj&&obj.nodeType===1)},isJQuery:function(obj){return obj instanceof $},toStr:function toStr(s){return _.isUndefined(s)||s===null?"":s+""},bind:$.proxy,each:function(collection,cb){$.each(collection,reverseArgs);function reverseArgs(index,value){return cb(value,index)}},map:$.map,filter:$.grep,every:function(obj,test){var result=!0;if(!obj){return result}
$.each(obj,function(key,val){if(!(result=test.call(null,val,key,obj))){return!1}});return!!result},some:function(obj,test){var result=!1;if(!obj){return result}
$.each(obj,function(key,val){if(result=test.call(null,val,key,obj)){return!1}});return!!result},mixin:$.extend,identity:function(x){return x},clone:function(obj){return $.extend(!0,{},obj)},getIdGenerator:function(){var counter=0;return function(){return counter++}},templatify:function templatify(obj){return $.isFunction(obj)?obj:template;function template(){return String(obj)}},defer:function(fn){setTimeout(fn,0)},debounce:function(func,wait,immediate){var timeout,result;return function(){var context=this,args=arguments,later,callNow;later=function(){timeout=null;if(!immediate){result=func.apply(context,args)}};callNow=immediate&&!timeout;clearTimeout(timeout);timeout=setTimeout(later,wait);if(callNow){result=func.apply(context,args)}
return result}},throttle:function(func,wait){var context,args,timeout,result,previous,later;previous=0;later=function(){previous=new Date();timeout=null;result=func.apply(context,args)};return function(){var now=new Date(),remaining=wait-(now-previous);context=this;args=arguments;if(remaining<=0){clearTimeout(timeout);timeout=null;previous=now;result=func.apply(context,args)}else if(!timeout){timeout=setTimeout(later,remaining)}
return result}},stringify:function(val){return _.isString(val)?val:JSON.stringify(val)},noop:function(){}}}();var VERSION="0.11.1";var tokenizers=function(){"use strict";return{nonword:nonword,whitespace:whitespace,obj:{nonword:getObjTokenizer(nonword),whitespace:getObjTokenizer(whitespace)}};function whitespace(str){str=_.toStr(str);return str?str.split(/\s+/):[]}
function nonword(str){str=_.toStr(str);return str?str.split(/\W+/):[]}
function getObjTokenizer(tokenizer){return function setKey(keys){keys=_.isArray(keys)?keys:[].slice.call(arguments,0);return function tokenize(o){var tokens=[];_.each(keys,function(k){tokens=tokens.concat(tokenizer(_.toStr(o[k])))});return tokens}}}}();var LruCache=function(){"use strict";function LruCache(maxSize){this.maxSize=_.isNumber(maxSize)?maxSize:100;this.reset();if(this.maxSize<=0){this.set=this.get=$.noop}}
_.mixin(LruCache.prototype,{set:function set(key,val){var tailItem=this.list.tail,node;if(this.size>=this.maxSize){this.list.remove(tailItem);delete this.hash[tailItem.key];this.size--}
if(node=this.hash[key]){node.val=val;this.list.moveToFront(node)}else{node=new Node(key,val);this.list.add(node);this.hash[key]=node;this.size++}},get:function get(key){var node=this.hash[key];if(node){this.list.moveToFront(node);return node.val}},reset:function reset(){this.size=0;this.hash={};this.list=new List()}});function List(){this.head=this.tail=null}
_.mixin(List.prototype,{add:function add(node){if(this.head){node.next=this.head;this.head.prev=node}
this.head=node;this.tail=this.tail||node},remove:function remove(node){node.prev?node.prev.next=node.next:this.head=node.next;node.next?node.next.prev=node.prev:this.tail=node.prev},moveToFront:function(node){this.remove(node);this.add(node)}});function Node(key,val){this.key=key;this.val=val;this.prev=this.next=null}
return LruCache}();var PersistentStorage=function(){"use strict";var LOCAL_STORAGE;try{LOCAL_STORAGE=window.localStorage;LOCAL_STORAGE.setItem("~~~","!");LOCAL_STORAGE.removeItem("~~~")}catch(err){LOCAL_STORAGE=null}
function PersistentStorage(namespace,override){this.prefix=["__",namespace,"__"].join("");this.ttlKey="__ttl__";this.keyMatcher=new RegExp("^"+_.escapeRegExChars(this.prefix));this.ls=override||LOCAL_STORAGE;!this.ls&&this._noop()}
_.mixin(PersistentStorage.prototype,{_prefix:function(key){return this.prefix+key},_ttlKey:function(key){return this._prefix(key)+this.ttlKey},_noop:function(){this.get=this.set=this.remove=this.clear=this.isExpired=_.noop},_safeSet:function(key,val){try{this.ls.setItem(key,val)}catch(err){if(err.name==="QuotaExceededError"){this.clear();this._noop()}}},get:function(key){if(this.isExpired(key)){this.remove(key)}
return decode(this.ls.getItem(this._prefix(key)))},set:function(key,val,ttl){if(_.isNumber(ttl)){this._safeSet(this._ttlKey(key),encode(now()+ttl))}else{this.ls.removeItem(this._ttlKey(key))}
return this._safeSet(this._prefix(key),encode(val))},remove:function(key){this.ls.removeItem(this._ttlKey(key));this.ls.removeItem(this._prefix(key));return this},clear:function(){var i,keys=gatherMatchingKeys(this.keyMatcher);for(i=keys.length;i--;){this.remove(keys[i])}
return this},isExpired:function(key){var ttl=decode(this.ls.getItem(this._ttlKey(key)));return _.isNumber(ttl)&&now()>ttl?!0:!1}});return PersistentStorage;function now(){return new Date().getTime()}
function encode(val){return JSON.stringify(_.isUndefined(val)?null:val)}
function decode(val){return $.parseJSON(val)}
function gatherMatchingKeys(keyMatcher){var i,key,keys=[],len=LOCAL_STORAGE.length;for(i=0;i<len;i++){if((key=LOCAL_STORAGE.key(i)).match(keyMatcher)){keys.push(key.replace(keyMatcher,""))}}
return keys}}();var Transport=function(){"use strict";var pendingRequestsCount=0,pendingRequests={},maxPendingRequests=6,sharedCache=new LruCache(10);function Transport(o){o=o||{};this.cancelled=!1;this.lastReq=null;this._send=o.transport;this._get=o.limiter?o.limiter(this._get):this._get;this._cache=o.cache===!1?new LruCache(0):sharedCache}
Transport.setMaxPendingRequests=function setMaxPendingRequests(num){maxPendingRequests=num};Transport.resetCache=function resetCache(){sharedCache.reset()};_.mixin(Transport.prototype,{_fingerprint:function fingerprint(o){o=o||{};return o.url+o.type+$.param(o.data||{})},_get:function(o,cb){var that=this,fingerprint,jqXhr;fingerprint=this._fingerprint(o);if(this.cancelled||fingerprint!==this.lastReq){return}
if(jqXhr=pendingRequests[fingerprint]){jqXhr.done(done).fail(fail)}else if(pendingRequestsCount<maxPendingRequests){pendingRequestsCount++;pendingRequests[fingerprint]=this._send(o).done(done).fail(fail).always(always)}else{this.onDeckRequestArgs=[].slice.call(arguments,0)}
function done(resp){cb(null,resp);that._cache.set(fingerprint,resp)}
function fail(){cb(!0)}
function always(){pendingRequestsCount--;delete pendingRequests[fingerprint];if(that.onDeckRequestArgs){that._get.apply(that,that.onDeckRequestArgs);that.onDeckRequestArgs=null}}},get:function(o,cb){var resp,fingerprint;cb=cb||$.noop;o=_.isString(o)?{url:o}:o||{};fingerprint=this._fingerprint(o);this.cancelled=!1;this.lastReq=fingerprint;if(resp=this._cache.get(fingerprint)){cb(null,resp)}else{this._get(o,cb)}},cancel:function(){this.cancelled=!0}});return Transport}();var SearchIndex=window.SearchIndex=function(){"use strict";var CHILDREN="c",IDS="i";function SearchIndex(o){o=o||{};if(!o.datumTokenizer||!o.queryTokenizer){$.error("datumTokenizer and queryTokenizer are both required")}
this.identify=o.identify||_.stringify;this.datumTokenizer=o.datumTokenizer;this.queryTokenizer=o.queryTokenizer;this.reset()}
_.mixin(SearchIndex.prototype,{bootstrap:function bootstrap(o){this.datums=o.datums;this.trie=o.trie},add:function(data){var that=this;data=_.isArray(data)?data:[data];_.each(data,function(datum){var id,tokens;that.datums[id=that.identify(datum)]=datum;tokens=normalizeTokens(that.datumTokenizer(datum));_.each(tokens,function(token){var node,chars,ch;node=that.trie;chars=token.split("");while(ch=chars.shift()){node=node[CHILDREN][ch]||(node[CHILDREN][ch]=newNode());node[IDS].push(id)}})})},get:function get(ids){var that=this;return _.map(ids,function(id){return that.datums[id]})},search:function search(query){var that=this,tokens,matches;tokens=normalizeTokens(this.queryTokenizer(query));_.each(tokens,function(token){var node,chars,ch,ids;if(matches&&matches.length===0){return!1}
node=that.trie;chars=token.split("");while(node&&(ch=chars.shift())){node=node[CHILDREN][ch]}
if(node&&chars.length===0){ids=node[IDS].slice(0);matches=matches?getIntersection(matches,ids):ids}else{matches=[];return!1}});return matches?_.map(unique(matches),function(id){return that.datums[id]}):[]},all:function all(){var values=[];for(var key in this.datums){values.push(this.datums[key])}
return values},reset:function reset(){this.datums={};this.trie=newNode()},serialize:function serialize(){return{datums:this.datums,trie:this.trie}}});return SearchIndex;function normalizeTokens(tokens){tokens=_.filter(tokens,function(token){return!!token});tokens=_.map(tokens,function(token){return token.toLowerCase()});return tokens}
function newNode(){var node={};node[IDS]=[];node[CHILDREN]={};return node}
function unique(array){var seen={},uniques=[];for(var i=0,len=array.length;i<len;i++){if(!seen[array[i]]){seen[array[i]]=!0;uniques.push(array[i])}}
return uniques}
function getIntersection(arrayA,arrayB){var ai=0,bi=0,intersection=[];arrayA=arrayA.sort();arrayB=arrayB.sort();var lenArrayA=arrayA.length,lenArrayB=arrayB.length;while(ai<lenArrayA&&bi<lenArrayB){if(arrayA[ai]<arrayB[bi]){ai++}else if(arrayA[ai]>arrayB[bi]){bi++}else{intersection.push(arrayA[ai]);ai++;bi++}}
return intersection}}();var Prefetch=function(){"use strict";var keys;keys={data:"data",protocol:"protocol",thumbprint:"thumbprint"};function Prefetch(o){this.url=o.url;this.ttl=o.ttl;this.cache=o.cache;this.prepare=o.prepare;this.transform=o.transform;this.transport=o.transport;this.thumbprint=o.thumbprint;this.storage=new PersistentStorage(o.cacheKey)}
_.mixin(Prefetch.prototype,{_settings:function settings(){return{url:this.url,type:"GET",dataType:"json"}},store:function store(data){if(!this.cache){return}
this.storage.set(keys.data,data,this.ttl);this.storage.set(keys.protocol,location.protocol,this.ttl);this.storage.set(keys.thumbprint,this.thumbprint,this.ttl)},fromCache:function fromCache(){var stored={},isExpired;if(!this.cache){return null}
stored.data=this.storage.get(keys.data);stored.protocol=this.storage.get(keys.protocol);stored.thumbprint=this.storage.get(keys.thumbprint);isExpired=stored.thumbprint!==this.thumbprint||stored.protocol!==location.protocol;return stored.data&&!isExpired?stored.data:null},fromNetwork:function(cb){var that=this,settings;if(!cb){return}
settings=this.prepare(this._settings());this.transport(settings).fail(onError).done(onResponse);function onError(){cb(!0)}
function onResponse(resp){cb(null,that.transform(resp))}},clear:function clear(){this.storage.clear();return this}});return Prefetch}();var Remote=function(){"use strict";function Remote(o){this.url=o.url;this.prepare=o.prepare;this.transform=o.transform;this.transport=new Transport({cache:o.cache,limiter:o.limiter,transport:o.transport})}
_.mixin(Remote.prototype,{_settings:function settings(){return{url:this.url,type:"GET",dataType:"json"}},get:function get(query,cb){var that=this,settings;if(!cb){return}
query=query||"";settings=this.prepare(query,this._settings());return this.transport.get(settings,onResponse);function onResponse(err,resp){err?cb([]):cb(that.transform(resp))}},cancelLastRequest:function cancelLastRequest(){this.transport.cancel()}});return Remote}();var oParser=function(){"use strict";return function parse(o){var defaults,sorter;defaults={initialize:!0,identify:_.stringify,datumTokenizer:null,queryTokenizer:null,sufficient:5,sorter:null,local:[],prefetch:null,remote:null};o=_.mixin(defaults,o||{});!o.datumTokenizer&&$.error("datumTokenizer is required");!o.queryTokenizer&&$.error("queryTokenizer is required");sorter=o.sorter;o.sorter=sorter?function(x){return x.sort(sorter)}:_.identity;o.local=_.isFunction(o.local)?o.local():o.local;o.prefetch=parsePrefetch(o.prefetch);o.remote=parseRemote(o.remote);return o};function parsePrefetch(o){var defaults;if(!o){return null}
defaults={url:null,ttl:24*60*60*1e3,cache:!0,cacheKey:null,thumbprint:"",prepare:_.identity,transform:_.identity,transport:null};o=_.isString(o)?{url:o}:o;o=_.mixin(defaults,o);!o.url&&$.error("prefetch requires url to be set");o.transform=o.filter||o.transform;o.cacheKey=o.cacheKey||o.url;o.thumbprint=VERSION+o.thumbprint;o.transport=o.transport?callbackToDeferred(o.transport):$.ajax;return o}
function parseRemote(o){var defaults;if(!o){return}
defaults={url:null,cache:!0,prepare:null,replace:null,wildcard:null,limiter:null,rateLimitBy:"debounce",rateLimitWait:300,transform:_.identity,transport:null};o=_.isString(o)?{url:o}:o;o=_.mixin(defaults,o);!o.url&&$.error("remote requires url to be set");o.transform=o.filter||o.transform;o.prepare=toRemotePrepare(o);o.limiter=toLimiter(o);o.transport=o.transport?callbackToDeferred(o.transport):$.ajax;delete o.replace;delete o.wildcard;delete o.rateLimitBy;delete o.rateLimitWait;return o}
function toRemotePrepare(o){var prepare,replace,wildcard;prepare=o.prepare;replace=o.replace;wildcard=o.wildcard;if(prepare){return prepare}
if(replace){prepare=prepareByReplace}else if(o.wildcard){prepare=prepareByWildcard}else{prepare=idenityPrepare}
return prepare;function prepareByReplace(query,settings){settings.url=replace(settings.url,query);return settings}
function prepareByWildcard(query,settings){settings.url=settings.url.replace(wildcard,encodeURIComponent(query));return settings}
function idenityPrepare(query,settings){return settings}}
function toLimiter(o){var limiter,method,wait;limiter=o.limiter;method=o.rateLimitBy;wait=o.rateLimitWait;if(!limiter){limiter=/^throttle$/i.test(method)?throttle(wait):debounce(wait)}
return limiter;function debounce(wait){return function debounce(fn){return _.debounce(fn,wait)}}
function throttle(wait){return function throttle(fn){return _.throttle(fn,wait)}}}
function callbackToDeferred(fn){return function wrapper(o){var deferred=$.Deferred();fn(o,onSuccess,onError);return deferred;function onSuccess(resp){_.defer(function(){deferred.resolve(resp)})}
function onError(err){_.defer(function(){deferred.reject(err)})}}}}();var Bloodhound=function(){"use strict";var old;old=window&&window.Bloodhound;function Bloodhound(o){o=oParser(o);this.sorter=o.sorter;this.identify=o.identify;this.sufficient=o.sufficient;this.local=o.local;this.remote=o.remote?new Remote(o.remote):null;this.prefetch=o.prefetch?new Prefetch(o.prefetch):null;this.index=new SearchIndex({identify:this.identify,datumTokenizer:o.datumTokenizer,queryTokenizer:o.queryTokenizer});o.initialize!==!1&&this.initialize()}
Bloodhound.noConflict=function noConflict(){window&&(window.Bloodhound=old);return Bloodhound};Bloodhound.tokenizers=tokenizers;_.mixin(Bloodhound.prototype,{__ttAdapter:function ttAdapter(){var that=this;return this.remote?withAsync:withoutAsync;function withAsync(query,sync,async){return that.search(query,sync,async)}
function withoutAsync(query,sync){return that.search(query,sync)}},_loadPrefetch:function loadPrefetch(){var that=this,deferred,serialized;deferred=$.Deferred();if(!this.prefetch){deferred.resolve()}else if(serialized=this.prefetch.fromCache()){this.index.bootstrap(serialized);deferred.resolve()}else{this.prefetch.fromNetwork(done)}
return deferred.promise();function done(err,data){if(err){return deferred.reject()}
that.add(data);that.prefetch.store(that.index.serialize());deferred.resolve()}},_initialize:function initialize(){var that=this,deferred;this.clear();(this.initPromise=this._loadPrefetch()).done(addLocalToIndex);return this.initPromise;function addLocalToIndex(){that.add(that.local)}},initialize:function initialize(force){return!this.initPromise||force?this._initialize():this.initPromise},add:function add(data){this.index.add(data);return this},get:function get(ids){ids=_.isArray(ids)?ids:[].slice.call(arguments);return this.index.get(ids)},search:function search(query,sync,async){var that=this,local;local=this.sorter(this.index.search(query));sync(this.remote?local.slice():local);if(this.remote&&local.length<this.sufficient){this.remote.get(query,processRemote)}else if(this.remote){this.remote.cancelLastRequest()}
return this;function processRemote(remote){var nonDuplicates=[];_.each(remote,function(r){!_.some(local,function(l){return that.identify(r)===that.identify(l)})&&nonDuplicates.push(r)});async&&async(nonDuplicates)}},all:function all(){return this.index.all()},clear:function clear(){this.index.reset();return this},clearPrefetchCache:function clearPrefetchCache(){this.prefetch&&this.prefetch.clear();return this},clearRemoteCache:function clearRemoteCache(){Transport.resetCache();return this},ttAdapter:function ttAdapter(){return this.__ttAdapter()}});return Bloodhound}();return Bloodhound});(function(root,factory){if(typeof define==="function"&&define.amd){define("typeahead.js",["jquery"],function(a0){return factory(a0)})}else if(typeof exports==="object"){module.exports=factory(require("jquery"))}else{factory(jQuery)}})(this,function($){var _=function(){"use strict";return{isMsie:function(){return/(msie|trident)/i.test(navigator.userAgent)?navigator.userAgent.match(/(msie |rv:)(\d+(.\d+)?)/i)[2]:!1},isBlankString:function(str){return!str||/^\s*$/.test(str)},escapeRegExChars:function(str){return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g,"\\$&")},isString:function(obj){return typeof obj==="string"},isNumber:function(obj){return typeof obj==="number"},isArray:$.isArray,isFunction:$.isFunction,isObject:$.isPlainObject,isUndefined:function(obj){return typeof obj==="undefined"},isElement:function(obj){return!!(obj&&obj.nodeType===1)},isJQuery:function(obj){return obj instanceof $},toStr:function toStr(s){return _.isUndefined(s)||s===null?"":s+""},bind:$.proxy,each:function(collection,cb){$.each(collection,reverseArgs);function reverseArgs(index,value){return cb(value,index)}},map:$.map,filter:$.grep,every:function(obj,test){var result=!0;if(!obj){return result}
$.each(obj,function(key,val){if(!(result=test.call(null,val,key,obj))){return!1}});return!!result},some:function(obj,test){var result=!1;if(!obj){return result}
$.each(obj,function(key,val){if(result=test.call(null,val,key,obj)){return!1}});return!!result},mixin:$.extend,identity:function(x){return x},clone:function(obj){return $.extend(!0,{},obj)},getIdGenerator:function(){var counter=0;return function(){return counter++}},templatify:function templatify(obj){return $.isFunction(obj)?obj:template;function template(){return String(obj)}},defer:function(fn){setTimeout(fn,0)},debounce:function(func,wait,immediate){var timeout,result;return function(){var context=this,args=arguments,later,callNow;later=function(){timeout=null;if(!immediate){result=func.apply(context,args)}};callNow=immediate&&!timeout;clearTimeout(timeout);timeout=setTimeout(later,wait);if(callNow){result=func.apply(context,args)}
return result}},throttle:function(func,wait){var context,args,timeout,result,previous,later;previous=0;later=function(){previous=new Date();timeout=null;result=func.apply(context,args)};return function(){var now=new Date(),remaining=wait-(now-previous);context=this;args=arguments;if(remaining<=0){clearTimeout(timeout);timeout=null;previous=now;result=func.apply(context,args)}else if(!timeout){timeout=setTimeout(later,remaining)}
return result}},stringify:function(val){return _.isString(val)?val:JSON.stringify(val)},noop:function(){}}}();var WWW=function(){"use strict";var defaultClassNames={wrapper:"twitter-typeahead",input:"tt-input",hint:"tt-hint",menu:"tt-menu",dataset:"tt-dataset",suggestion:"tt-suggestion",selectable:"tt-selectable",empty:"tt-empty",open:"tt-open",cursor:"tt-cursor",highlight:"tt-highlight"};return build;function build(o){var www,classes;classes=_.mixin({},defaultClassNames,o);www={css:buildCss(),classes:classes,html:buildHtml(classes),selectors:buildSelectors(classes)};return{css:www.css,html:www.html,classes:www.classes,selectors:www.selectors,mixin:function(o){_.mixin(o,www)}}}
function buildHtml(c){return{wrapper:'<span class="'+c.wrapper+'"></span>',menu:'<div class="'+c.menu+'"></div>'}}
function buildSelectors(classes){var selectors={};_.each(classes,function(v,k){selectors[k]="."+v});return selectors}
function buildCss(){var css={wrapper:{position:"relative",display:"inline-block"},hint:{position:"absolute",top:"0",left:"0",borderColor:"transparent",boxShadow:"none",opacity:"1"},input:{position:"relative",verticalAlign:"top",backgroundColor:"transparent"},inputWithNoHint:{position:"relative",verticalAlign:"top"},menu:{position:"absolute",top:"100%",left:"0",zIndex:"100",display:"none"},ltr:{left:"0",right:"auto"},rtl:{left:"auto",right:" 0"}};if(_.isMsie()){_.mixin(css.input,{backgroundImage:"url(data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7)"})}
return css}}();var EventBus=function(){"use strict";var namespace,deprecationMap;namespace="typeahead:";deprecationMap={render:"rendered",cursorchange:"cursorchanged",select:"selected",autocomplete:"autocompleted"};function EventBus(o){if(!o||!o.el){$.error("EventBus initialized without el")}
this.$el=$(o.el)}
_.mixin(EventBus.prototype,{_trigger:function(type,args){var $e;$e=$.Event(namespace+type);(args=args||[]).unshift($e);this.$el.trigger.apply(this.$el,args);return $e},before:function(type){var args,$e;args=[].slice.call(arguments,1);$e=this._trigger("before"+type,args);return $e.isDefaultPrevented()},trigger:function(type){var deprecatedType;this._trigger(type,[].slice.call(arguments,1));if(deprecatedType=deprecationMap[type]){this._trigger(deprecatedType,[].slice.call(arguments,1))}}});return EventBus}();var EventEmitter=function(){"use strict";var splitter=/\s+/,nextTick=getNextTick();return{onSync:onSync,onAsync:onAsync,off:off,trigger:trigger};function on(method,types,cb,context){var type;if(!cb){return this}
types=types.split(splitter);cb=context?bindContext(cb,context):cb;this._callbacks=this._callbacks||{};while(type=types.shift()){this._callbacks[type]=this._callbacks[type]||{sync:[],async:[]};this._callbacks[type][method].push(cb)}
return this}
function onAsync(types,cb,context){return on.call(this,"async",types,cb,context)}
function onSync(types,cb,context){return on.call(this,"sync",types,cb,context)}
function off(types){var type;if(!this._callbacks){return this}
types=types.split(splitter);while(type=types.shift()){delete this._callbacks[type]}
return this}
function trigger(types){var type,callbacks,args,syncFlush,asyncFlush;if(!this._callbacks){return this}
types=types.split(splitter);args=[].slice.call(arguments,1);while((type=types.shift())&&(callbacks=this._callbacks[type])){syncFlush=getFlush(callbacks.sync,this,[type].concat(args));asyncFlush=getFlush(callbacks.async,this,[type].concat(args));syncFlush()&&nextTick(asyncFlush)}
return this}
function getFlush(callbacks,context,args){return flush;function flush(){var cancelled;for(var i=0,len=callbacks.length;!cancelled&&i<len;i+=1){cancelled=callbacks[i].apply(context,args)===!1}
return!cancelled}}
function getNextTick(){var nextTickFn;if(window.setImmediate){nextTickFn=function nextTickSetImmediate(fn){setImmediate(function(){fn()})}}else{nextTickFn=function nextTickSetTimeout(fn){setTimeout(function(){fn()},0)}}
return nextTickFn}
function bindContext(fn,context){return fn.bind?fn.bind(context):function(){fn.apply(context,[].slice.call(arguments,0))}}}();var highlight=function(doc){"use strict";var defaults={node:null,pattern:null,tagName:"strong",className:null,wordsOnly:!1,caseSensitive:!1};return function hightlight(o){var regex;o=_.mixin({},defaults,o);if(!o.node||!o.pattern){return}
o.pattern=_.isArray(o.pattern)?o.pattern:[o.pattern];regex=getRegex(o.pattern,o.caseSensitive,o.wordsOnly);traverse(o.node,hightlightTextNode);function hightlightTextNode(textNode){var match,patternNode,wrapperNode;if(match=regex.exec(textNode.data)){wrapperNode=doc.createElement(o.tagName);o.className&&(wrapperNode.className=o.className);patternNode=textNode.splitText(match.index);patternNode.splitText(match[0].length);wrapperNode.appendChild(patternNode.cloneNode(!0));textNode.parentNode.replaceChild(wrapperNode,patternNode)}
return!!match}
function traverse(el,hightlightTextNode){var childNode,TEXT_NODE_TYPE=3;for(var i=0;i<el.childNodes.length;i++){childNode=el.childNodes[i];if(childNode.nodeType===TEXT_NODE_TYPE){i+=hightlightTextNode(childNode)?1:0}else{traverse(childNode,hightlightTextNode)}}}};function getRegex(patterns,caseSensitive,wordsOnly){var escapedPatterns=[],regexStr;for(var i=0,len=patterns.length;i<len;i++){escapedPatterns.push(_.escapeRegExChars(patterns[i]))}
regexStr=wordsOnly?"\\b("+escapedPatterns.join("|")+")\\b":"("+escapedPatterns.join("|")+")";return caseSensitive?new RegExp(regexStr):new RegExp(regexStr,"i")}}(window.document);var Input=function(){"use strict";var specialKeyCodeMap;specialKeyCodeMap={9:"tab",27:"esc",37:"left",39:"right",13:"enter",38:"up",40:"down"};function Input(o,www){o=o||{};if(!o.input){$.error("input is missing")}
www.mixin(this);this.$hint=$(o.hint);this.$input=$(o.input);this.query=this.$input.val();this.queryWhenFocused=this.hasFocus()?this.query:null;this.$overflowHelper=buildOverflowHelper(this.$input);this._checkLanguageDirection();if(this.$hint.length===0){this.setHint=this.getHint=this.clearHint=this.clearHintIfInvalid=_.noop}}
Input.normalizeQuery=function(str){return _.toStr(str).replace(/^\s*/g,"").replace(/\s{2,}/g," ")};_.mixin(Input.prototype,EventEmitter,{_onBlur:function onBlur(){this.resetInputValue();this.trigger("blurred")},_onFocus:function onFocus(){this.queryWhenFocused=this.query;this.trigger("focused")},_onKeydown:function onKeydown($e){var keyName=specialKeyCodeMap[$e.which||$e.keyCode];this._managePreventDefault(keyName,$e);if(keyName&&this._shouldTrigger(keyName,$e)){this.trigger(keyName+"Keyed",$e)}},_onInput:function onInput(){this._setQuery(this.getInputValue());this.clearHintIfInvalid();this._checkLanguageDirection()},_managePreventDefault:function managePreventDefault(keyName,$e){var preventDefault;switch(keyName){case "up":case "down":preventDefault=!withModifier($e);break;default:preventDefault=!1}
preventDefault&&$e.preventDefault()},_shouldTrigger:function shouldTrigger(keyName,$e){var trigger;switch(keyName){case "tab":trigger=!withModifier($e);break;default:trigger=!0}
return trigger},_checkLanguageDirection:function checkLanguageDirection(){var dir=(this.$input.css("direction")||"ltr").toLowerCase();if(this.dir!==dir){this.dir=dir;this.$hint.attr("dir",dir);this.trigger("langDirChanged",dir)}},_setQuery:function setQuery(val,silent){var areEquivalent,hasDifferentWhitespace;areEquivalent=areQueriesEquivalent(val,this.query);hasDifferentWhitespace=areEquivalent?this.query.length!==val.length:!1;this.query=val;if(!silent&&!areEquivalent){this.trigger("queryChanged",this.query)}else if(!silent&&hasDifferentWhitespace){this.trigger("whitespaceChanged",this.query)}},bind:function(){var that=this,onBlur,onFocus,onKeydown,onInput;onBlur=_.bind(this._onBlur,this);onFocus=_.bind(this._onFocus,this);onKeydown=_.bind(this._onKeydown,this);onInput=_.bind(this._onInput,this);this.$input.on("blur.tt",onBlur).on("focus.tt",onFocus).on("keydown.tt",onKeydown);if(!_.isMsie()||_.isMsie()>9){this.$input.on("input.tt",onInput)}else{this.$input.on("keydown.tt keypress.tt cut.tt paste.tt",function($e){if(specialKeyCodeMap[$e.which||$e.keyCode]){return}
_.defer(_.bind(that._onInput,that,$e))})}
return this},focus:function focus(){this.$input.focus()},blur:function blur(){this.$input.blur()},getLangDir:function getLangDir(){return this.dir},getQuery:function getQuery(){return this.query||""},setQuery:function setQuery(val,silent){this.setInputValue(val);this._setQuery(val,silent)},hasQueryChangedSinceLastFocus:function hasQueryChangedSinceLastFocus(){return this.query!==this.queryWhenFocused},getInputValue:function getInputValue(){return this.$input.val()},setInputValue:function setInputValue(value){this.$input.val(value);this.clearHintIfInvalid();this._checkLanguageDirection()},resetInputValue:function resetInputValue(){this.setInputValue(this.query)},getHint:function getHint(){return this.$hint.val()},setHint:function setHint(value){this.$hint.val(value)},clearHint:function clearHint(){this.setHint("")},clearHintIfInvalid:function clearHintIfInvalid(){var val,hint,valIsPrefixOfHint,isValid;val=this.getInputValue();hint=this.getHint();valIsPrefixOfHint=val!==hint&&hint.indexOf(val)===0;isValid=val!==""&&valIsPrefixOfHint&&!this.hasOverflow();!isValid&&this.clearHint()},hasFocus:function hasFocus(){return this.$input.is(":focus")},hasOverflow:function hasOverflow(){var constraint=this.$input.width()-2;this.$overflowHelper.text(this.getInputValue());return this.$overflowHelper.width()>=constraint},isCursorAtEnd:function(){var valueLength,selectionStart,range;valueLength=this.$input.val().length;selectionStart=this.$input[0].selectionStart;if(_.isNumber(selectionStart)){return selectionStart===valueLength}else if(document.selection){range=document.selection.createRange();range.moveStart("character",-valueLength);return valueLength===range.text.length}
return!0},destroy:function destroy(){this.$hint.off(".tt");this.$input.off(".tt");this.$overflowHelper.remove();this.$hint=this.$input=this.$overflowHelper=$("<div>")}});return Input;function buildOverflowHelper($input){return $('<pre aria-hidden="true"></pre>').css({position:"absolute",visibility:"hidden",whiteSpace:"pre",fontFamily:$input.css("font-family"),fontSize:$input.css("font-size"),fontStyle:$input.css("font-style"),fontVariant:$input.css("font-variant"),fontWeight:$input.css("font-weight"),wordSpacing:$input.css("word-spacing"),letterSpacing:$input.css("letter-spacing"),textIndent:$input.css("text-indent"),textRendering:$input.css("text-rendering"),textTransform:$input.css("text-transform")}).insertAfter($input)}
function areQueriesEquivalent(a,b){return Input.normalizeQuery(a)===Input.normalizeQuery(b)}
function withModifier($e){return $e.altKey||$e.ctrlKey||$e.metaKey||$e.shiftKey}}();var Dataset=function(){"use strict";var keys,nameGenerator;keys={val:"tt-selectable-display",obj:"tt-selectable-object"};nameGenerator=_.getIdGenerator();function Dataset(o,www){o=o||{};o.templates=o.templates||{};o.templates.notFound=o.templates.notFound||o.templates.empty;if(!o.source){$.error("missing source")}
if(!o.node){$.error("missing node")}
if(o.name&&!isValidName(o.name)){$.error("invalid dataset name: "+o.name)}
www.mixin(this);this.highlight=!!o.highlight;this.name=o.name||nameGenerator();this.limit=o.limit||5;this.displayFn=getDisplayFn(o.display||o.displayKey);this.templates=getTemplates(o.templates,this.displayFn);this.source=o.source.__ttAdapter?o.source.__ttAdapter():o.source;this.async=_.isUndefined(o.async)?this.source.length>2:!!o.async;this._resetLastSuggestion();this.$el=$(o.node).addClass(this.classes.dataset).addClass(this.classes.dataset+"-"+this.name)}
Dataset.extractData=function extractData(el){var $el=$(el);if($el.data(keys.obj)){return{val:$el.data(keys.val)||"",obj:$el.data(keys.obj)||null}}
return null};_.mixin(Dataset.prototype,EventEmitter,{_overwrite:function overwrite(query,suggestions){suggestions=suggestions||[];if(suggestions.length){this._renderSuggestions(query,suggestions)}else if(this.async&&this.templates.pending){this._renderPending(query)}else if(!this.async&&this.templates.notFound){this._renderNotFound(query)}else{this._empty()}
this.trigger("rendered",this.name,suggestions,!1)},_append:function append(query,suggestions){suggestions=suggestions||[];if(suggestions.length&&this.$lastSuggestion.length){this._appendSuggestions(query,suggestions)}else if(suggestions.length){this._renderSuggestions(query,suggestions)}else if(!this.$lastSuggestion.length&&this.templates.notFound){this._renderNotFound(query)}
this.trigger("rendered",this.name,suggestions,!0)},_renderSuggestions:function renderSuggestions(query,suggestions){var $fragment;$fragment=this._getSuggestionsFragment(query,suggestions);this.$lastSuggestion=$fragment.children().last();this.$el.html($fragment).prepend(this._getHeader(query,suggestions)).append(this._getFooter(query,suggestions))},_appendSuggestions:function appendSuggestions(query,suggestions){var $fragment,$lastSuggestion;$fragment=this._getSuggestionsFragment(query,suggestions);$lastSuggestion=$fragment.children().last();this.$lastSuggestion.after($fragment);this.$lastSuggestion=$lastSuggestion},_renderPending:function renderPending(query){var template=this.templates.pending;this._resetLastSuggestion();template&&this.$el.html(template({query:query,dataset:this.name}))},_renderNotFound:function renderNotFound(query){var template=this.templates.notFound;this._resetLastSuggestion();template&&this.$el.html(template({query:query,dataset:this.name}))},_empty:function empty(){this.$el.empty();this._resetLastSuggestion()},_getSuggestionsFragment:function getSuggestionsFragment(query,suggestions){var that=this,fragment;fragment=document.createDocumentFragment();_.each(suggestions,function getSuggestionNode(suggestion){var $el,context;context=that._injectQuery(query,suggestion);$el=$(that.templates.suggestion(context)).data(keys.obj,suggestion).data(keys.val,that.displayFn(suggestion)).addClass(that.classes.suggestion+" "+that.classes.selectable);fragment.appendChild($el[0])});this.highlight&&highlight({className:this.classes.highlight,node:fragment,pattern:query});return $(fragment)},_getFooter:function getFooter(query,suggestions){return this.templates.footer?this.templates.footer({query:query,suggestions:suggestions,dataset:this.name}):null},_getHeader:function getHeader(query,suggestions){return this.templates.header?this.templates.header({query:query,suggestions:suggestions,dataset:this.name}):null},_resetLastSuggestion:function resetLastSuggestion(){this.$lastSuggestion=$()},_injectQuery:function injectQuery(query,obj){return _.isObject(obj)?_.mixin({_query:query},obj):obj},update:function update(query){var that=this,canceled=!1,syncCalled=!1,rendered=0;this.cancel();this.cancel=function cancel(){canceled=!0;that.cancel=$.noop;that.async&&that.trigger("asyncCanceled",query)};this.source(query,sync,async);!syncCalled&&sync([]);function sync(suggestions){if(syncCalled){return}
syncCalled=!0;suggestions=(suggestions||[]).slice(0,that.limit);rendered=suggestions.length;that._overwrite(query,suggestions);if(rendered<that.limit&&that.async){that.trigger("asyncRequested",query)}}
function async(suggestions){suggestions=suggestions||[];if(!canceled&&rendered<that.limit){that.cancel=$.noop;rendered+=suggestions.length;that._append(query,suggestions.slice(0,that.limit-rendered));that.async&&that.trigger("asyncReceived",query)}}},cancel:$.noop,clear:function clear(){this._empty();this.cancel();this.trigger("cleared")},isEmpty:function isEmpty(){return this.$el.is(":empty")},destroy:function destroy(){this.$el=$("<div>")}});return Dataset;function getDisplayFn(display){display=display||_.stringify;return _.isFunction(display)?display:displayFn;function displayFn(obj){return obj[display]}}
function getTemplates(templates,displayFn){return{notFound:templates.notFound&&_.templatify(templates.notFound),pending:templates.pending&&_.templatify(templates.pending),header:templates.header&&_.templatify(templates.header),footer:templates.footer&&_.templatify(templates.footer),suggestion:templates.suggestion||suggestionTemplate};function suggestionTemplate(context){return $("<div>").text(displayFn(context))}}
function isValidName(str){return/^[_a-zA-Z0-9-]+$/.test(str)}}();var Menu=function(){"use strict";function Menu(o,www){var that=this;o=o||{};if(!o.node){$.error("node is required")}
www.mixin(this);this.$node=$(o.node);this.query=null;this.datasets=_.map(o.datasets,initializeDataset);function initializeDataset(oDataset){var node=that.$node.find(oDataset.node).first();oDataset.node=node.length?node:$("<div>").appendTo(that.$node);return new Dataset(oDataset,www)}}
_.mixin(Menu.prototype,EventEmitter,{_onSelectableClick:function onSelectableClick($e){this.trigger("selectableClicked",$($e.currentTarget))},_onRendered:function onRendered(type,dataset,suggestions,async){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetRendered",dataset,suggestions,async)},_onCleared:function onCleared(){this.$node.toggleClass(this.classes.empty,this._allDatasetsEmpty());this.trigger("datasetCleared")},_propagate:function propagate(){this.trigger.apply(this,arguments)},_allDatasetsEmpty:function allDatasetsEmpty(){return _.every(this.datasets,isDatasetEmpty);function isDatasetEmpty(dataset){return dataset.isEmpty()}},_getSelectables:function getSelectables(){return this.$node.find(this.selectors.selectable)},_removeCursor:function _removeCursor(){var $selectable=this.getActiveSelectable();$selectable&&$selectable.removeClass(this.classes.cursor)},_ensureVisible:function ensureVisible($el){var elTop,elBottom,nodeScrollTop,nodeHeight;elTop=$el.position().top;elBottom=elTop+$el.outerHeight(!0);nodeScrollTop=this.$node.scrollTop();nodeHeight=this.$node.height()+parseInt(this.$node.css("paddingTop"),10)+parseInt(this.$node.css("paddingBottom"),10);if(elTop<0){this.$node.scrollTop(nodeScrollTop+elTop)}else if(nodeHeight<elBottom){this.$node.scrollTop(nodeScrollTop+(elBottom-nodeHeight))}},bind:function(){var that=this,onSelectableClick;onSelectableClick=_.bind(this._onSelectableClick,this);this.$node.on("click.tt",this.selectors.selectable,onSelectableClick);_.each(this.datasets,function(dataset){dataset.onSync("asyncRequested",that._propagate,that).onSync("asyncCanceled",that._propagate,that).onSync("asyncReceived",that._propagate,that).onSync("rendered",that._onRendered,that).onSync("cleared",that._onCleared,that)});return this},isOpen:function isOpen(){return this.$node.hasClass(this.classes.open)},open:function open(){this.$node.addClass(this.classes.open)},close:function close(){this.$node.removeClass(this.classes.open);this._removeCursor()},setLanguageDirection:function setLanguageDirection(dir){this.$node.attr("dir",dir)},selectableRelativeToCursor:function selectableRelativeToCursor(delta){var $selectables,$oldCursor,oldIndex,newIndex;$oldCursor=this.getActiveSelectable();$selectables=this._getSelectables();oldIndex=$oldCursor?$selectables.index($oldCursor):-1;newIndex=oldIndex+delta;newIndex=(newIndex+1)%($selectables.length+1)-1;newIndex=newIndex<-1?$selectables.length-1:newIndex;return newIndex===-1?null:$selectables.eq(newIndex)},setCursor:function setCursor($selectable){this._removeCursor();if($selectable=$selectable&&$selectable.first()){$selectable.addClass(this.classes.cursor);this._ensureVisible($selectable)}},getSelectableData:function getSelectableData($el){return $el&&$el.length?Dataset.extractData($el):null},getActiveSelectable:function getActiveSelectable(){var $selectable=this._getSelectables().filter(this.selectors.cursor).first();return $selectable.length?$selectable:null},getTopSelectable:function getTopSelectable(){var $selectable=this._getSelectables().first();return $selectable.length?$selectable:null},update:function update(query){var isValidUpdate=query!==this.query;if(isValidUpdate){this.query=query;_.each(this.datasets,updateDataset)}
return isValidUpdate;function updateDataset(dataset){dataset.update(query)}},empty:function empty(){_.each(this.datasets,clearDataset);this.query=null;this.$node.addClass(this.classes.empty);function clearDataset(dataset){dataset.clear()}},destroy:function destroy(){this.$node.off(".tt");this.$node=$("<div>");_.each(this.datasets,destroyDataset);function destroyDataset(dataset){dataset.destroy()}}});return Menu}();var DefaultMenu=function(){"use strict";var s=Menu.prototype;function DefaultMenu(){Menu.apply(this,[].slice.call(arguments,0))}
_.mixin(DefaultMenu.prototype,Menu.prototype,{open:function open(){!this._allDatasetsEmpty()&&this._show();return s.open.apply(this,[].slice.call(arguments,0))},close:function close(){this._hide();return s.close.apply(this,[].slice.call(arguments,0))},_onRendered:function onRendered(){if(this._allDatasetsE